/**
 *
 *    Copyright (c) 2020 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// This file is generated by Simplicity Studio.  Please do not edit manually.
//
//

#pragma once

#include "debug-printing-test.h"

// Printing macros for cluster: Basic
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BASIC_CLUSTER)
#define emberAfBasicClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_BASIC_CLUSTER, __VA_ARGS__)
#define emberAfBasicClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_BASIC_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfBasicClusterPrintBuffer(buffer, len, withSpace)                                                                     \
    emberAfPrintBuffer(EMBER_AF_PRINT_BASIC_CLUSTER, (buffer), (len), (withSpace))
#define emberAfBasicClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_BASIC_CLUSTER, (buffer))
#else
#define emberAfBasicClusterPrint(...)
#define emberAfBasicClusterPrintln(...)

#define emberAfBasicClusterPrintBuffer(buffer, len, withSpace)
#define emberAfBasicClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BASIC_CLUSTER)

// Printing macros for cluster: Power Configuration
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_POWER_CONFIG_CLUSTER)
#define emberAfPowerConfigClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_POWER_CONFIG_CLUSTER, __VA_ARGS__)
#define emberAfPowerConfigClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_POWER_CONFIG_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfPowerConfigClusterPrintBuffer(buffer, len, withSpace)                                                               \
    emberAfPrintBuffer(EMBER_AF_PRINT_POWER_CONFIG_CLUSTER, (buffer), (len), (withSpace))
#define emberAfPowerConfigClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_POWER_CONFIG_CLUSTER, (buffer))
#else
#define emberAfPowerConfigClusterPrint(...)
#define emberAfPowerConfigClusterPrintln(...)

#define emberAfPowerConfigClusterPrintBuffer(buffer, len, withSpace)
#define emberAfPowerConfigClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_POWER_CONFIG_CLUSTER)

// Printing macros for cluster: Device Temperature Configuration
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DEVICE_TEMP_CLUSTER)
#define emberAfDeviceTempClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_DEVICE_TEMP_CLUSTER, __VA_ARGS__)
#define emberAfDeviceTempClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_DEVICE_TEMP_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfDeviceTempClusterPrintBuffer(buffer, len, withSpace)                                                                \
    emberAfPrintBuffer(EMBER_AF_PRINT_DEVICE_TEMP_CLUSTER, (buffer), (len), (withSpace))
#define emberAfDeviceTempClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_DEVICE_TEMP_CLUSTER, (buffer))
#else
#define emberAfDeviceTempClusterPrint(...)
#define emberAfDeviceTempClusterPrintln(...)

#define emberAfDeviceTempClusterPrintBuffer(buffer, len, withSpace)
#define emberAfDeviceTempClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DEVICE_TEMP_CLUSTER)

// Printing macros for cluster: Identify
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_IDENTIFY_CLUSTER)
#define emberAfIdentifyClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_IDENTIFY_CLUSTER, __VA_ARGS__)
#define emberAfIdentifyClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_IDENTIFY_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfIdentifyClusterPrintBuffer(buffer, len, withSpace)                                                                  \
    emberAfPrintBuffer(EMBER_AF_PRINT_IDENTIFY_CLUSTER, (buffer), (len), (withSpace))
#define emberAfIdentifyClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_IDENTIFY_CLUSTER, (buffer))
#else
#define emberAfIdentifyClusterPrint(...)
#define emberAfIdentifyClusterPrintln(...)

#define emberAfIdentifyClusterPrintBuffer(buffer, len, withSpace)
#define emberAfIdentifyClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_IDENTIFY_CLUSTER)

// Printing macros for cluster: Groups
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_GROUPS_CLUSTER)
#define emberAfGroupsClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_GROUPS_CLUSTER, __VA_ARGS__)
#define emberAfGroupsClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_GROUPS_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfGroupsClusterPrintBuffer(buffer, len, withSpace)                                                                    \
    emberAfPrintBuffer(EMBER_AF_PRINT_GROUPS_CLUSTER, (buffer), (len), (withSpace))
#define emberAfGroupsClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_GROUPS_CLUSTER, (buffer))
#else
#define emberAfGroupsClusterPrint(...)
#define emberAfGroupsClusterPrintln(...)

#define emberAfGroupsClusterPrintBuffer(buffer, len, withSpace)
#define emberAfGroupsClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_GROUPS_CLUSTER)

// Printing macros for cluster: Scenes
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SCENES_CLUSTER)
#define emberAfScenesClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_SCENES_CLUSTER, __VA_ARGS__)
#define emberAfScenesClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_SCENES_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfScenesClusterPrintBuffer(buffer, len, withSpace)                                                                    \
    emberAfPrintBuffer(EMBER_AF_PRINT_SCENES_CLUSTER, (buffer), (len), (withSpace))
#define emberAfScenesClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_SCENES_CLUSTER, (buffer))
#else
#define emberAfScenesClusterPrint(...)
#define emberAfScenesClusterPrintln(...)

#define emberAfScenesClusterPrintBuffer(buffer, len, withSpace)
#define emberAfScenesClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SCENES_CLUSTER)

// Printing macros for cluster: On/off
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ON_OFF_CLUSTER)
#define emberAfOnOffClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_ON_OFF_CLUSTER, __VA_ARGS__)
#define emberAfOnOffClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ON_OFF_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfOnOffClusterPrintBuffer(buffer, len, withSpace)                                                                     \
    emberAfPrintBuffer(EMBER_AF_PRINT_ON_OFF_CLUSTER, (buffer), (len), (withSpace))
#define emberAfOnOffClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_ON_OFF_CLUSTER, (buffer))
#else
#define emberAfOnOffClusterPrint(...)
#define emberAfOnOffClusterPrintln(...)

#define emberAfOnOffClusterPrintBuffer(buffer, len, withSpace)
#define emberAfOnOffClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ON_OFF_CLUSTER)

// Printing macros for cluster: On/off Switch Configuration
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ON_OFF_SWITCH_CONFIGURATION_CLUSTER)
#define emberAfOnOffSwitchConfigClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_ON_OFF_SWITCH_CONFIGURATION_CLUSTER, __VA_ARGS__)
#define emberAfOnOffSwitchConfigClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ON_OFF_SWITCH_CONFIGURATION_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfOnOffSwitchConfigClusterPrintBuffer(buffer, len, withSpace)                                                         \
    emberAfPrintBuffer(EMBER_AF_PRINT_ON_OFF_SWITCH_CONFIGURATION_CLUSTER, (buffer), (len), (withSpace))
#define emberAfOnOffSwitchConfigClusterPrintString(buffer)                                                                         \
    emberAfPrintString(EMBER_AF_PRINT_ON_OFF_SWITCH_CONFIGURATION_CLUSTER, (buffer))
#else
#define emberAfOnOffSwitchConfigClusterPrint(...)
#define emberAfOnOffSwitchConfigClusterPrintln(...)

#define emberAfOnOffSwitchConfigClusterPrintBuffer(buffer, len, withSpace)
#define emberAfOnOffSwitchConfigClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ON_OFF_SWITCH_CONFIGURATION_CLUSTER)

// Printing macros for cluster: Level Control
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_LEVEL_CONTROL_CLUSTER)
#define emberAfLevelControlClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_LEVEL_CONTROL_CLUSTER, __VA_ARGS__)
#define emberAfLevelControlClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_LEVEL_CONTROL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfLevelControlClusterPrintBuffer(buffer, len, withSpace)                                                              \
    emberAfPrintBuffer(EMBER_AF_PRINT_LEVEL_CONTROL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfLevelControlClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_LEVEL_CONTROL_CLUSTER, (buffer))
#else
#define emberAfLevelControlClusterPrint(...)
#define emberAfLevelControlClusterPrintln(...)

#define emberAfLevelControlClusterPrintBuffer(buffer, len, withSpace)
#define emberAfLevelControlClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_LEVEL_CONTROL_CLUSTER)

// Printing macros for cluster: Alarms
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ALARM_CLUSTER)
#define emberAfAlarmClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_ALARM_CLUSTER, __VA_ARGS__)
#define emberAfAlarmClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ALARM_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfAlarmClusterPrintBuffer(buffer, len, withSpace)                                                                     \
    emberAfPrintBuffer(EMBER_AF_PRINT_ALARM_CLUSTER, (buffer), (len), (withSpace))
#define emberAfAlarmClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_ALARM_CLUSTER, (buffer))
#else
#define emberAfAlarmClusterPrint(...)
#define emberAfAlarmClusterPrintln(...)

#define emberAfAlarmClusterPrintBuffer(buffer, len, withSpace)
#define emberAfAlarmClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ALARM_CLUSTER)

// Printing macros for cluster: Time
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TIME_CLUSTER)
#define emberAfTimeClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_TIME_CLUSTER, __VA_ARGS__)
#define emberAfTimeClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_TIME_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfTimeClusterPrintBuffer(buffer, len, withSpace)                                                                      \
    emberAfPrintBuffer(EMBER_AF_PRINT_TIME_CLUSTER, (buffer), (len), (withSpace))
#define emberAfTimeClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_TIME_CLUSTER, (buffer))
#else
#define emberAfTimeClusterPrint(...)
#define emberAfTimeClusterPrintln(...)

#define emberAfTimeClusterPrintBuffer(buffer, len, withSpace)
#define emberAfTimeClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TIME_CLUSTER)

// Printing macros for cluster: RSSI Location
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_RSSI_LOCATION_CLUSTER)
#define emberAfRssiLocationClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_RSSI_LOCATION_CLUSTER, __VA_ARGS__)
#define emberAfRssiLocationClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_RSSI_LOCATION_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfRssiLocationClusterPrintBuffer(buffer, len, withSpace)                                                              \
    emberAfPrintBuffer(EMBER_AF_PRINT_RSSI_LOCATION_CLUSTER, (buffer), (len), (withSpace))
#define emberAfRssiLocationClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_RSSI_LOCATION_CLUSTER, (buffer))
#else
#define emberAfRssiLocationClusterPrint(...)
#define emberAfRssiLocationClusterPrintln(...)

#define emberAfRssiLocationClusterPrintBuffer(buffer, len, withSpace)
#define emberAfRssiLocationClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_RSSI_LOCATION_CLUSTER)

// Printing macros for cluster: Binary Input (Basic)
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BINARY_INPUT_BASIC_CLUSTER)
#define emberAfBinaryInputBasicClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_BINARY_INPUT_BASIC_CLUSTER, __VA_ARGS__)
#define emberAfBinaryInputBasicClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_BINARY_INPUT_BASIC_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfBinaryInputBasicClusterPrintBuffer(buffer, len, withSpace)                                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_BINARY_INPUT_BASIC_CLUSTER, (buffer), (len), (withSpace))
#define emberAfBinaryInputBasicClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_BINARY_INPUT_BASIC_CLUSTER, (buffer))
#else
#define emberAfBinaryInputBasicClusterPrint(...)
#define emberAfBinaryInputBasicClusterPrintln(...)

#define emberAfBinaryInputBasicClusterPrintBuffer(buffer, len, withSpace)
#define emberAfBinaryInputBasicClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BINARY_INPUT_BASIC_CLUSTER)

// Printing macros for cluster: Commissioning
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_COMMISSIONING_CLUSTER)
#define emberAfCommissioningClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_COMMISSIONING_CLUSTER, __VA_ARGS__)
#define emberAfCommissioningClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_COMMISSIONING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfCommissioningClusterPrintBuffer(buffer, len, withSpace)                                                             \
    emberAfPrintBuffer(EMBER_AF_PRINT_COMMISSIONING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfCommissioningClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_COMMISSIONING_CLUSTER, (buffer))
#else
#define emberAfCommissioningClusterPrint(...)
#define emberAfCommissioningClusterPrintln(...)

#define emberAfCommissioningClusterPrintBuffer(buffer, len, withSpace)
#define emberAfCommissioningClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_COMMISSIONING_CLUSTER)

// Printing macros for cluster: Partition
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PARTITION_CLUSTER)
#define emberAfPartitionClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_PARTITION_CLUSTER, __VA_ARGS__)
#define emberAfPartitionClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_PARTITION_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfPartitionClusterPrintBuffer(buffer, len, withSpace)                                                                 \
    emberAfPrintBuffer(EMBER_AF_PRINT_PARTITION_CLUSTER, (buffer), (len), (withSpace))
#define emberAfPartitionClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_PARTITION_CLUSTER, (buffer))
#else
#define emberAfPartitionClusterPrint(...)
#define emberAfPartitionClusterPrintln(...)

#define emberAfPartitionClusterPrintBuffer(buffer, len, withSpace)
#define emberAfPartitionClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PARTITION_CLUSTER)

// Printing macros for cluster: Over the Air Bootloading
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_OTA_BOOTLOAD_CLUSTER)
#define emberAfOtaBootloadClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_OTA_BOOTLOAD_CLUSTER, __VA_ARGS__)
#define emberAfOtaBootloadClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_OTA_BOOTLOAD_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfOtaBootloadClusterPrintBuffer(buffer, len, withSpace)                                                               \
    emberAfPrintBuffer(EMBER_AF_PRINT_OTA_BOOTLOAD_CLUSTER, (buffer), (len), (withSpace))
#define emberAfOtaBootloadClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_OTA_BOOTLOAD_CLUSTER, (buffer))
#else
#define emberAfOtaBootloadClusterPrint(...)
#define emberAfOtaBootloadClusterPrintln(...)

#define emberAfOtaBootloadClusterPrintBuffer(buffer, len, withSpace)
#define emberAfOtaBootloadClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_OTA_BOOTLOAD_CLUSTER)

// Printing macros for cluster: Power Profile
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_POWER_PROFILE_CLUSTER)
#define emberAfPowerProfileClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_POWER_PROFILE_CLUSTER, __VA_ARGS__)
#define emberAfPowerProfileClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_POWER_PROFILE_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfPowerProfileClusterPrintBuffer(buffer, len, withSpace)                                                              \
    emberAfPrintBuffer(EMBER_AF_PRINT_POWER_PROFILE_CLUSTER, (buffer), (len), (withSpace))
#define emberAfPowerProfileClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_POWER_PROFILE_CLUSTER, (buffer))
#else
#define emberAfPowerProfileClusterPrint(...)
#define emberAfPowerProfileClusterPrintln(...)

#define emberAfPowerProfileClusterPrintBuffer(buffer, len, withSpace)
#define emberAfPowerProfileClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_POWER_PROFILE_CLUSTER)

// Printing macros for cluster: Appliance Control
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLIANCE_CONTROL_CLUSTER)
#define emberAfApplianceControlClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_APPLIANCE_CONTROL_CLUSTER, __VA_ARGS__)
#define emberAfApplianceControlClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_APPLIANCE_CONTROL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfApplianceControlClusterPrintBuffer(buffer, len, withSpace)                                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_APPLIANCE_CONTROL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfApplianceControlClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_APPLIANCE_CONTROL_CLUSTER, (buffer))
#else
#define emberAfApplianceControlClusterPrint(...)
#define emberAfApplianceControlClusterPrintln(...)

#define emberAfApplianceControlClusterPrintBuffer(buffer, len, withSpace)
#define emberAfApplianceControlClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLIANCE_CONTROL_CLUSTER)

// Printing macros for cluster: Poll Control
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_POLL_CONTROL_CLUSTER)
#define emberAfPollControlClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_POLL_CONTROL_CLUSTER, __VA_ARGS__)
#define emberAfPollControlClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_POLL_CONTROL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfPollControlClusterPrintBuffer(buffer, len, withSpace)                                                               \
    emberAfPrintBuffer(EMBER_AF_PRINT_POLL_CONTROL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfPollControlClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_POLL_CONTROL_CLUSTER, (buffer))
#else
#define emberAfPollControlClusterPrint(...)
#define emberAfPollControlClusterPrintln(...)

#define emberAfPollControlClusterPrintBuffer(buffer, len, withSpace)
#define emberAfPollControlClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_POLL_CONTROL_CLUSTER)

// Printing macros for cluster: Green Power
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_GREEN_POWER_CLUSTER)
#define emberAfGreenPowerClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_GREEN_POWER_CLUSTER, __VA_ARGS__)
#define emberAfGreenPowerClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_GREEN_POWER_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfGreenPowerClusterPrintBuffer(buffer, len, withSpace)                                                                \
    emberAfPrintBuffer(EMBER_AF_PRINT_GREEN_POWER_CLUSTER, (buffer), (len), (withSpace))
#define emberAfGreenPowerClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_GREEN_POWER_CLUSTER, (buffer))
#else
#define emberAfGreenPowerClusterPrint(...)
#define emberAfGreenPowerClusterPrintln(...)

#define emberAfGreenPowerClusterPrintBuffer(buffer, len, withSpace)
#define emberAfGreenPowerClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_GREEN_POWER_CLUSTER)

// Printing macros for cluster: Keep-Alive
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_KEEPALIVE_CLUSTER)
#define emberAfKeepaliveClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_KEEPALIVE_CLUSTER, __VA_ARGS__)
#define emberAfKeepaliveClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_KEEPALIVE_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfKeepaliveClusterPrintBuffer(buffer, len, withSpace)                                                                 \
    emberAfPrintBuffer(EMBER_AF_PRINT_KEEPALIVE_CLUSTER, (buffer), (len), (withSpace))
#define emberAfKeepaliveClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_KEEPALIVE_CLUSTER, (buffer))
#else
#define emberAfKeepaliveClusterPrint(...)
#define emberAfKeepaliveClusterPrintln(...)

#define emberAfKeepaliveClusterPrintBuffer(buffer, len, withSpace)
#define emberAfKeepaliveClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_KEEPALIVE_CLUSTER)

// Printing macros for cluster: Shade Configuration
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SHADE_CONFIG_CLUSTER)
#define emberAfShadeConfigClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_SHADE_CONFIG_CLUSTER, __VA_ARGS__)
#define emberAfShadeConfigClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_SHADE_CONFIG_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfShadeConfigClusterPrintBuffer(buffer, len, withSpace)                                                               \
    emberAfPrintBuffer(EMBER_AF_PRINT_SHADE_CONFIG_CLUSTER, (buffer), (len), (withSpace))
#define emberAfShadeConfigClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_SHADE_CONFIG_CLUSTER, (buffer))
#else
#define emberAfShadeConfigClusterPrint(...)
#define emberAfShadeConfigClusterPrintln(...)

#define emberAfShadeConfigClusterPrintBuffer(buffer, len, withSpace)
#define emberAfShadeConfigClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SHADE_CONFIG_CLUSTER)

// Printing macros for cluster: Door Lock
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DOOR_LOCK_CLUSTER)
#define emberAfDoorLockClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_DOOR_LOCK_CLUSTER, __VA_ARGS__)
#define emberAfDoorLockClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_DOOR_LOCK_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfDoorLockClusterPrintBuffer(buffer, len, withSpace)                                                                  \
    emberAfPrintBuffer(EMBER_AF_PRINT_DOOR_LOCK_CLUSTER, (buffer), (len), (withSpace))
#define emberAfDoorLockClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_DOOR_LOCK_CLUSTER, (buffer))
#else
#define emberAfDoorLockClusterPrint(...)
#define emberAfDoorLockClusterPrintln(...)

#define emberAfDoorLockClusterPrintBuffer(buffer, len, withSpace)
#define emberAfDoorLockClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DOOR_LOCK_CLUSTER)

// Printing macros for cluster: Window Covering
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_WINDOW_COVERING_CLUSTER)
#define emberAfWindowCoveringClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_WINDOW_COVERING_CLUSTER, __VA_ARGS__)
#define emberAfWindowCoveringClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_WINDOW_COVERING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfWindowCoveringClusterPrintBuffer(buffer, len, withSpace)                                                            \
    emberAfPrintBuffer(EMBER_AF_PRINT_WINDOW_COVERING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfWindowCoveringClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_WINDOW_COVERING_CLUSTER, (buffer))
#else
#define emberAfWindowCoveringClusterPrint(...)
#define emberAfWindowCoveringClusterPrintln(...)

#define emberAfWindowCoveringClusterPrintBuffer(buffer, len, withSpace)
#define emberAfWindowCoveringClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_WINDOW_COVERING_CLUSTER)

// Printing macros for cluster: Barrier Control
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BARRIER_CONTROL_CLUSTER)
#define emberAfBarrierControlClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_BARRIER_CONTROL_CLUSTER, __VA_ARGS__)
#define emberAfBarrierControlClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_BARRIER_CONTROL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfBarrierControlClusterPrintBuffer(buffer, len, withSpace)                                                            \
    emberAfPrintBuffer(EMBER_AF_PRINT_BARRIER_CONTROL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfBarrierControlClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_BARRIER_CONTROL_CLUSTER, (buffer))
#else
#define emberAfBarrierControlClusterPrint(...)
#define emberAfBarrierControlClusterPrintln(...)

#define emberAfBarrierControlClusterPrintBuffer(buffer, len, withSpace)
#define emberAfBarrierControlClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BARRIER_CONTROL_CLUSTER)

// Printing macros for cluster: Pump Configuration and Control
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PUMP_CONFIGURATION_AND_CONTROL_CLUSTER)
#define emberAfPumpConfigControlClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_PUMP_CONFIGURATION_AND_CONTROL_CLUSTER, __VA_ARGS__)
#define emberAfPumpConfigControlClusterPrintln(...)                                                                                \
    emberAfPrintln(EMBER_AF_PRINT_PUMP_CONFIGURATION_AND_CONTROL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfPumpConfigControlClusterPrintBuffer(buffer, len, withSpace)                                                         \
    emberAfPrintBuffer(EMBER_AF_PRINT_PUMP_CONFIGURATION_AND_CONTROL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfPumpConfigControlClusterPrintString(buffer)                                                                         \
    emberAfPrintString(EMBER_AF_PRINT_PUMP_CONFIGURATION_AND_CONTROL_CLUSTER, (buffer))
#else
#define emberAfPumpConfigControlClusterPrint(...)
#define emberAfPumpConfigControlClusterPrintln(...)

#define emberAfPumpConfigControlClusterPrintBuffer(buffer, len, withSpace)
#define emberAfPumpConfigControlClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PUMP_CONFIGURATION_AND_CONTROL_CLUSTER)

// Printing macros for cluster: Thermostat
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_THERMOSTAT_CLUSTER)
#define emberAfThermostatClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_THERMOSTAT_CLUSTER, __VA_ARGS__)
#define emberAfThermostatClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_THERMOSTAT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfThermostatClusterPrintBuffer(buffer, len, withSpace)                                                                \
    emberAfPrintBuffer(EMBER_AF_PRINT_THERMOSTAT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfThermostatClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_THERMOSTAT_CLUSTER, (buffer))
#else
#define emberAfThermostatClusterPrint(...)
#define emberAfThermostatClusterPrintln(...)

#define emberAfThermostatClusterPrintBuffer(buffer, len, withSpace)
#define emberAfThermostatClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_THERMOSTAT_CLUSTER)

// Printing macros for cluster: Fan Control
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_FAN_CONTROL_CLUSTER)
#define emberAfFanControlClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_FAN_CONTROL_CLUSTER, __VA_ARGS__)
#define emberAfFanControlClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_FAN_CONTROL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfFanControlClusterPrintBuffer(buffer, len, withSpace)                                                                \
    emberAfPrintBuffer(EMBER_AF_PRINT_FAN_CONTROL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfFanControlClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_FAN_CONTROL_CLUSTER, (buffer))
#else
#define emberAfFanControlClusterPrint(...)
#define emberAfFanControlClusterPrintln(...)

#define emberAfFanControlClusterPrintBuffer(buffer, len, withSpace)
#define emberAfFanControlClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_FAN_CONTROL_CLUSTER)

// Printing macros for cluster: Dehumidification Control
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DEHUMID_CONTROL_CLUSTER)
#define emberAfDehumidControlClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_DEHUMID_CONTROL_CLUSTER, __VA_ARGS__)
#define emberAfDehumidControlClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_DEHUMID_CONTROL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfDehumidControlClusterPrintBuffer(buffer, len, withSpace)                                                            \
    emberAfPrintBuffer(EMBER_AF_PRINT_DEHUMID_CONTROL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfDehumidControlClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_DEHUMID_CONTROL_CLUSTER, (buffer))
#else
#define emberAfDehumidControlClusterPrint(...)
#define emberAfDehumidControlClusterPrintln(...)

#define emberAfDehumidControlClusterPrintBuffer(buffer, len, withSpace)
#define emberAfDehumidControlClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DEHUMID_CONTROL_CLUSTER)

// Printing macros for cluster: Thermostat User Interface Configuration
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_THERMOSTAT_USER_INTERFACE_CONFIGURATION_CLUSTER)
#define emberAfThermostatUiConfigClusterPrint(...)                                                                                 \
    emberAfPrint(EMBER_AF_PRINT_THERMOSTAT_USER_INTERFACE_CONFIGURATION_CLUSTER, __VA_ARGS__)
#define emberAfThermostatUiConfigClusterPrintln(...)                                                                               \
    emberAfPrintln(EMBER_AF_PRINT_THERMOSTAT_USER_INTERFACE_CONFIGURATION_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfThermostatUiConfigClusterPrintBuffer(buffer, len, withSpace)                                                        \
    emberAfPrintBuffer(EMBER_AF_PRINT_THERMOSTAT_USER_INTERFACE_CONFIGURATION_CLUSTER, (buffer), (len), (withSpace))
#define emberAfThermostatUiConfigClusterPrintString(buffer)                                                                        \
    emberAfPrintString(EMBER_AF_PRINT_THERMOSTAT_USER_INTERFACE_CONFIGURATION_CLUSTER, (buffer))
#else
#define emberAfThermostatUiConfigClusterPrint(...)
#define emberAfThermostatUiConfigClusterPrintln(...)

#define emberAfThermostatUiConfigClusterPrintBuffer(buffer, len, withSpace)
#define emberAfThermostatUiConfigClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_THERMOSTAT_USER_INTERFACE_CONFIGURATION_CLUSTER)

// Printing macros for cluster: Color Control
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_COLOR_CONTROL_CLUSTER)
#define emberAfColorControlClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_COLOR_CONTROL_CLUSTER, __VA_ARGS__)
#define emberAfColorControlClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_COLOR_CONTROL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfColorControlClusterPrintBuffer(buffer, len, withSpace)                                                              \
    emberAfPrintBuffer(EMBER_AF_PRINT_COLOR_CONTROL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfColorControlClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_COLOR_CONTROL_CLUSTER, (buffer))
#else
#define emberAfColorControlClusterPrint(...)
#define emberAfColorControlClusterPrintln(...)

#define emberAfColorControlClusterPrintBuffer(buffer, len, withSpace)
#define emberAfColorControlClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_COLOR_CONTROL_CLUSTER)

// Printing macros for cluster: Ballast Configuration
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BALLAST_CONFIGURATION_CLUSTER)
#define emberAfBallastConfigurationClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_BALLAST_CONFIGURATION_CLUSTER, __VA_ARGS__)
#define emberAfBallastConfigurationClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_BALLAST_CONFIGURATION_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfBallastConfigurationClusterPrintBuffer(buffer, len, withSpace)                                                      \
    emberAfPrintBuffer(EMBER_AF_PRINT_BALLAST_CONFIGURATION_CLUSTER, (buffer), (len), (withSpace))
#define emberAfBallastConfigurationClusterPrintString(buffer)                                                                      \
    emberAfPrintString(EMBER_AF_PRINT_BALLAST_CONFIGURATION_CLUSTER, (buffer))
#else
#define emberAfBallastConfigurationClusterPrint(...)
#define emberAfBallastConfigurationClusterPrintln(...)

#define emberAfBallastConfigurationClusterPrintBuffer(buffer, len, withSpace)
#define emberAfBallastConfigurationClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BALLAST_CONFIGURATION_CLUSTER)

// Printing macros for cluster: Illuminance Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ILLUM_MEASUREMENT_CLUSTER)
#define emberAfIllumMeasurementClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_ILLUM_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfIllumMeasurementClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ILLUM_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfIllumMeasurementClusterPrintBuffer(buffer, len, withSpace)                                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_ILLUM_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfIllumMeasurementClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_ILLUM_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfIllumMeasurementClusterPrint(...)
#define emberAfIllumMeasurementClusterPrintln(...)

#define emberAfIllumMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfIllumMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ILLUM_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Illuminance Level Sensing
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ILLUM_LEVEL_SENSING_CLUSTER)
#define emberAfIllumLevelSensingClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_ILLUM_LEVEL_SENSING_CLUSTER, __VA_ARGS__)
#define emberAfIllumLevelSensingClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ILLUM_LEVEL_SENSING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfIllumLevelSensingClusterPrintBuffer(buffer, len, withSpace)                                                         \
    emberAfPrintBuffer(EMBER_AF_PRINT_ILLUM_LEVEL_SENSING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfIllumLevelSensingClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_ILLUM_LEVEL_SENSING_CLUSTER, (buffer))
#else
#define emberAfIllumLevelSensingClusterPrint(...)
#define emberAfIllumLevelSensingClusterPrintln(...)

#define emberAfIllumLevelSensingClusterPrintBuffer(buffer, len, withSpace)
#define emberAfIllumLevelSensingClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ILLUM_LEVEL_SENSING_CLUSTER)

// Printing macros for cluster: Temperature Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TEMPERATURE_MEASUREMENT_CLUSTER)
#define emberAfTempMeasurementClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_TEMPERATURE_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfTempMeasurementClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_TEMPERATURE_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfTempMeasurementClusterPrintBuffer(buffer, len, withSpace)                                                           \
    emberAfPrintBuffer(EMBER_AF_PRINT_TEMPERATURE_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfTempMeasurementClusterPrintString(buffer)                                                                           \
    emberAfPrintString(EMBER_AF_PRINT_TEMPERATURE_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfTempMeasurementClusterPrint(...)
#define emberAfTempMeasurementClusterPrintln(...)

#define emberAfTempMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfTempMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TEMPERATURE_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Pressure Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PRESSURE_MEASUREMENT_CLUSTER)
#define emberAfPressureMeasurementClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_PRESSURE_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfPressureMeasurementClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_PRESSURE_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfPressureMeasurementClusterPrintBuffer(buffer, len, withSpace)                                                       \
    emberAfPrintBuffer(EMBER_AF_PRINT_PRESSURE_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfPressureMeasurementClusterPrintString(buffer)                                                                       \
    emberAfPrintString(EMBER_AF_PRINT_PRESSURE_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfPressureMeasurementClusterPrint(...)
#define emberAfPressureMeasurementClusterPrintln(...)

#define emberAfPressureMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfPressureMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PRESSURE_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Flow Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_FLOW_MEASUREMENT_CLUSTER)
#define emberAfFlowMeasurementClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_FLOW_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfFlowMeasurementClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_FLOW_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfFlowMeasurementClusterPrintBuffer(buffer, len, withSpace)                                                           \
    emberAfPrintBuffer(EMBER_AF_PRINT_FLOW_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfFlowMeasurementClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_FLOW_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfFlowMeasurementClusterPrint(...)
#define emberAfFlowMeasurementClusterPrintln(...)

#define emberAfFlowMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfFlowMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_FLOW_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Relative Humidity Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER)
#define emberAfRelativeHumidityMeasurementClusterPrint(...)                                                                        \
    emberAfPrint(EMBER_AF_PRINT_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfRelativeHumidityMeasurementClusterPrintln(...)                                                                      \
    emberAfPrintln(EMBER_AF_PRINT_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfRelativeHumidityMeasurementClusterPrintBuffer(buffer, len, withSpace)                                               \
    emberAfPrintBuffer(EMBER_AF_PRINT_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfRelativeHumidityMeasurementClusterPrintString(buffer)                                                               \
    emberAfPrintString(EMBER_AF_PRINT_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfRelativeHumidityMeasurementClusterPrint(...)
#define emberAfRelativeHumidityMeasurementClusterPrintln(...)

#define emberAfRelativeHumidityMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfRelativeHumidityMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Occupancy Sensing
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_OCCUPANCY_SENSING_CLUSTER)
#define emberAfOccupancySensingClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_OCCUPANCY_SENSING_CLUSTER, __VA_ARGS__)
#define emberAfOccupancySensingClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_OCCUPANCY_SENSING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfOccupancySensingClusterPrintBuffer(buffer, len, withSpace)                                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_OCCUPANCY_SENSING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfOccupancySensingClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_OCCUPANCY_SENSING_CLUSTER, (buffer))
#else
#define emberAfOccupancySensingClusterPrint(...)
#define emberAfOccupancySensingClusterPrintln(...)

#define emberAfOccupancySensingClusterPrintBuffer(buffer, len, withSpace)
#define emberAfOccupancySensingClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_OCCUPANCY_SENSING_CLUSTER)

// Printing macros for cluster: Carbon Monoxide Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CARBON_MONOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfCarbonMonoxideConcentrationMeasurementClusterPrint(...)                                                             \
    emberAfPrint(EMBER_AF_PRINT_CARBON_MONOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfCarbonMonoxideConcentrationMeasurementClusterPrintln(...)                                                           \
    emberAfPrintln(EMBER_AF_PRINT_CARBON_MONOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfCarbonMonoxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                    \
    emberAfPrintBuffer(EMBER_AF_PRINT_CARBON_MONOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfCarbonMonoxideConcentrationMeasurementClusterPrintString(buffer)                                                    \
    emberAfPrintString(EMBER_AF_PRINT_CARBON_MONOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfCarbonMonoxideConcentrationMeasurementClusterPrint(...)
#define emberAfCarbonMonoxideConcentrationMeasurementClusterPrintln(...)

#define emberAfCarbonMonoxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfCarbonMonoxideConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CARBON_MONOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Carbon Dioxide Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CARBON_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfCarbonDioxideConcentrationMeasurementClusterPrint(...)                                                              \
    emberAfPrint(EMBER_AF_PRINT_CARBON_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfCarbonDioxideConcentrationMeasurementClusterPrintln(...)                                                            \
    emberAfPrintln(EMBER_AF_PRINT_CARBON_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfCarbonDioxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                     \
    emberAfPrintBuffer(EMBER_AF_PRINT_CARBON_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfCarbonDioxideConcentrationMeasurementClusterPrintString(buffer)                                                     \
    emberAfPrintString(EMBER_AF_PRINT_CARBON_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfCarbonDioxideConcentrationMeasurementClusterPrint(...)
#define emberAfCarbonDioxideConcentrationMeasurementClusterPrintln(...)

#define emberAfCarbonDioxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfCarbonDioxideConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CARBON_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Ethylene Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ETHYLENE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfEthyleneConcentrationMeasurementClusterPrint(...)                                                                   \
    emberAfPrint(EMBER_AF_PRINT_ETHYLENE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfEthyleneConcentrationMeasurementClusterPrintln(...)                                                                 \
    emberAfPrintln(EMBER_AF_PRINT_ETHYLENE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfEthyleneConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_ETHYLENE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfEthyleneConcentrationMeasurementClusterPrintString(buffer)                                                          \
    emberAfPrintString(EMBER_AF_PRINT_ETHYLENE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfEthyleneConcentrationMeasurementClusterPrint(...)
#define emberAfEthyleneConcentrationMeasurementClusterPrintln(...)

#define emberAfEthyleneConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfEthyleneConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ETHYLENE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Ethylene Oxide Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ETHYLENE_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfEthyleneOxideConcentrationMeasurementClusterPrint(...)                                                              \
    emberAfPrint(EMBER_AF_PRINT_ETHYLENE_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfEthyleneOxideConcentrationMeasurementClusterPrintln(...)                                                            \
    emberAfPrintln(EMBER_AF_PRINT_ETHYLENE_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfEthyleneOxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                     \
    emberAfPrintBuffer(EMBER_AF_PRINT_ETHYLENE_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfEthyleneOxideConcentrationMeasurementClusterPrintString(buffer)                                                     \
    emberAfPrintString(EMBER_AF_PRINT_ETHYLENE_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfEthyleneOxideConcentrationMeasurementClusterPrint(...)
#define emberAfEthyleneOxideConcentrationMeasurementClusterPrintln(...)

#define emberAfEthyleneOxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfEthyleneOxideConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ETHYLENE_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Hydrogen Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_HYDROGEN_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfHydrogenConcentrationMeasurementClusterPrint(...)                                                                   \
    emberAfPrint(EMBER_AF_PRINT_HYDROGEN_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfHydrogenConcentrationMeasurementClusterPrintln(...)                                                                 \
    emberAfPrintln(EMBER_AF_PRINT_HYDROGEN_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfHydrogenConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_HYDROGEN_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfHydrogenConcentrationMeasurementClusterPrintString(buffer)                                                          \
    emberAfPrintString(EMBER_AF_PRINT_HYDROGEN_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfHydrogenConcentrationMeasurementClusterPrint(...)
#define emberAfHydrogenConcentrationMeasurementClusterPrintln(...)

#define emberAfHydrogenConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfHydrogenConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_HYDROGEN_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Hydrogen Sulphide Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_HYDROGEN_SULPHIDE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfHydrogenSulphideConcentrationMeasurementClusterPrint(...)                                                           \
    emberAfPrint(EMBER_AF_PRINT_HYDROGEN_SULPHIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfHydrogenSulphideConcentrationMeasurementClusterPrintln(...)                                                         \
    emberAfPrintln(EMBER_AF_PRINT_HYDROGEN_SULPHIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfHydrogenSulphideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                  \
    emberAfPrintBuffer(EMBER_AF_PRINT_HYDROGEN_SULPHIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfHydrogenSulphideConcentrationMeasurementClusterPrintString(buffer)                                                  \
    emberAfPrintString(EMBER_AF_PRINT_HYDROGEN_SULPHIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfHydrogenSulphideConcentrationMeasurementClusterPrint(...)
#define emberAfHydrogenSulphideConcentrationMeasurementClusterPrintln(...)

#define emberAfHydrogenSulphideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfHydrogenSulphideConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_HYDROGEN_SULPHIDE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Nitric Oxide Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_NITRIC_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfNitricOxideConcentrationMeasurementClusterPrint(...)                                                                \
    emberAfPrint(EMBER_AF_PRINT_NITRIC_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfNitricOxideConcentrationMeasurementClusterPrintln(...)                                                              \
    emberAfPrintln(EMBER_AF_PRINT_NITRIC_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfNitricOxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                       \
    emberAfPrintBuffer(EMBER_AF_PRINT_NITRIC_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfNitricOxideConcentrationMeasurementClusterPrintString(buffer)                                                       \
    emberAfPrintString(EMBER_AF_PRINT_NITRIC_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfNitricOxideConcentrationMeasurementClusterPrint(...)
#define emberAfNitricOxideConcentrationMeasurementClusterPrintln(...)

#define emberAfNitricOxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfNitricOxideConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_NITRIC_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Nitrogen Dioxide Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_NITROGEN_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfNitrogenDioxideConcentrationMeasurementClusterPrint(...)                                                            \
    emberAfPrint(EMBER_AF_PRINT_NITROGEN_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfNitrogenDioxideConcentrationMeasurementClusterPrintln(...)                                                          \
    emberAfPrintln(EMBER_AF_PRINT_NITROGEN_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfNitrogenDioxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                   \
    emberAfPrintBuffer(EMBER_AF_PRINT_NITROGEN_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfNitrogenDioxideConcentrationMeasurementClusterPrintString(buffer)                                                   \
    emberAfPrintString(EMBER_AF_PRINT_NITROGEN_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfNitrogenDioxideConcentrationMeasurementClusterPrint(...)
#define emberAfNitrogenDioxideConcentrationMeasurementClusterPrintln(...)

#define emberAfNitrogenDioxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfNitrogenDioxideConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_NITROGEN_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Oxygen Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfOxygenConcentrationMeasurementClusterPrint(...)                                                                     \
    emberAfPrint(EMBER_AF_PRINT_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfOxygenConcentrationMeasurementClusterPrintln(...)                                                                   \
    emberAfPrintln(EMBER_AF_PRINT_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfOxygenConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                            \
    emberAfPrintBuffer(EMBER_AF_PRINT_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfOxygenConcentrationMeasurementClusterPrintString(buffer)                                                            \
    emberAfPrintString(EMBER_AF_PRINT_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfOxygenConcentrationMeasurementClusterPrint(...)
#define emberAfOxygenConcentrationMeasurementClusterPrintln(...)

#define emberAfOxygenConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfOxygenConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Ozone Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_OZONE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfOzoneConcentrationMeasurementClusterPrint(...)                                                                      \
    emberAfPrint(EMBER_AF_PRINT_OZONE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfOzoneConcentrationMeasurementClusterPrintln(...)                                                                    \
    emberAfPrintln(EMBER_AF_PRINT_OZONE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfOzoneConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                             \
    emberAfPrintBuffer(EMBER_AF_PRINT_OZONE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfOzoneConcentrationMeasurementClusterPrintString(buffer)                                                             \
    emberAfPrintString(EMBER_AF_PRINT_OZONE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfOzoneConcentrationMeasurementClusterPrint(...)
#define emberAfOzoneConcentrationMeasurementClusterPrintln(...)

#define emberAfOzoneConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfOzoneConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_OZONE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Sulfur Dioxide Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SULFUR_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfSulfurDioxideConcentrationMeasurementClusterPrint(...)                                                              \
    emberAfPrint(EMBER_AF_PRINT_SULFUR_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfSulfurDioxideConcentrationMeasurementClusterPrintln(...)                                                            \
    emberAfPrintln(EMBER_AF_PRINT_SULFUR_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfSulfurDioxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                     \
    emberAfPrintBuffer(EMBER_AF_PRINT_SULFUR_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfSulfurDioxideConcentrationMeasurementClusterPrintString(buffer)                                                     \
    emberAfPrintString(EMBER_AF_PRINT_SULFUR_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfSulfurDioxideConcentrationMeasurementClusterPrint(...)
#define emberAfSulfurDioxideConcentrationMeasurementClusterPrintln(...)

#define emberAfSulfurDioxideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfSulfurDioxideConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SULFUR_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Dissolved Oxygen Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DISSOLVED_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfDissolvedOxygenConcentrationMeasurementClusterPrint(...)                                                            \
    emberAfPrint(EMBER_AF_PRINT_DISSOLVED_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfDissolvedOxygenConcentrationMeasurementClusterPrintln(...)                                                          \
    emberAfPrintln(EMBER_AF_PRINT_DISSOLVED_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfDissolvedOxygenConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                   \
    emberAfPrintBuffer(EMBER_AF_PRINT_DISSOLVED_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfDissolvedOxygenConcentrationMeasurementClusterPrintString(buffer)                                                   \
    emberAfPrintString(EMBER_AF_PRINT_DISSOLVED_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfDissolvedOxygenConcentrationMeasurementClusterPrint(...)
#define emberAfDissolvedOxygenConcentrationMeasurementClusterPrintln(...)

#define emberAfDissolvedOxygenConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfDissolvedOxygenConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DISSOLVED_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Bromate Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BROMATE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfBromateConcentrationMeasurementClusterPrint(...)                                                                    \
    emberAfPrint(EMBER_AF_PRINT_BROMATE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfBromateConcentrationMeasurementClusterPrintln(...)                                                                  \
    emberAfPrintln(EMBER_AF_PRINT_BROMATE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfBromateConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                           \
    emberAfPrintBuffer(EMBER_AF_PRINT_BROMATE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfBromateConcentrationMeasurementClusterPrintString(buffer)                                                           \
    emberAfPrintString(EMBER_AF_PRINT_BROMATE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfBromateConcentrationMeasurementClusterPrint(...)
#define emberAfBromateConcentrationMeasurementClusterPrintln(...)

#define emberAfBromateConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfBromateConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BROMATE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Chloramines Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CHLORAMINES_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfChloraminesConcentrationMeasurementClusterPrint(...)                                                                \
    emberAfPrint(EMBER_AF_PRINT_CHLORAMINES_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfChloraminesConcentrationMeasurementClusterPrintln(...)                                                              \
    emberAfPrintln(EMBER_AF_PRINT_CHLORAMINES_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfChloraminesConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                       \
    emberAfPrintBuffer(EMBER_AF_PRINT_CHLORAMINES_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfChloraminesConcentrationMeasurementClusterPrintString(buffer)                                                       \
    emberAfPrintString(EMBER_AF_PRINT_CHLORAMINES_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfChloraminesConcentrationMeasurementClusterPrint(...)
#define emberAfChloraminesConcentrationMeasurementClusterPrintln(...)

#define emberAfChloraminesConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfChloraminesConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CHLORAMINES_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Chlorine Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CHLORINE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfChlorineConcentrationMeasurementClusterPrint(...)                                                                   \
    emberAfPrint(EMBER_AF_PRINT_CHLORINE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfChlorineConcentrationMeasurementClusterPrintln(...)                                                                 \
    emberAfPrintln(EMBER_AF_PRINT_CHLORINE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfChlorineConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_CHLORINE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfChlorineConcentrationMeasurementClusterPrintString(buffer)                                                          \
    emberAfPrintString(EMBER_AF_PRINT_CHLORINE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfChlorineConcentrationMeasurementClusterPrint(...)
#define emberAfChlorineConcentrationMeasurementClusterPrintln(...)

#define emberAfChlorineConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfChlorineConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CHLORINE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Fecal coliform and E. Coli Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_FECAL_COLIFORM_AND_E_COLI_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfFecalColiformAndEColiConcentrationMeasurementClusterPrint(...)                                                      \
    emberAfPrint(EMBER_AF_PRINT_FECAL_COLIFORM_AND_E_COLI_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfFecalColiformAndEColiConcentrationMeasurementClusterPrintln(...)                                                    \
    emberAfPrintln(EMBER_AF_PRINT_FECAL_COLIFORM_AND_E_COLI_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfFecalColiformAndEColiConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                             \
    emberAfPrintBuffer(EMBER_AF_PRINT_FECAL_COLIFORM_AND_E_COLI_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfFecalColiformAndEColiConcentrationMeasurementClusterPrintString(buffer)                                             \
    emberAfPrintString(EMBER_AF_PRINT_FECAL_COLIFORM_AND_E_COLI_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfFecalColiformAndEColiConcentrationMeasurementClusterPrint(...)
#define emberAfFecalColiformAndEColiConcentrationMeasurementClusterPrintln(...)

#define emberAfFecalColiformAndEColiConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfFecalColiformAndEColiConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_FECAL_COLIFORM_AND_E_COLI_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Fluoride Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_FLUORIDE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfFluorideConcentrationMeasurementClusterPrint(...)                                                                   \
    emberAfPrint(EMBER_AF_PRINT_FLUORIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfFluorideConcentrationMeasurementClusterPrintln(...)                                                                 \
    emberAfPrintln(EMBER_AF_PRINT_FLUORIDE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfFluorideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_FLUORIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfFluorideConcentrationMeasurementClusterPrintString(buffer)                                                          \
    emberAfPrintString(EMBER_AF_PRINT_FLUORIDE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfFluorideConcentrationMeasurementClusterPrint(...)
#define emberAfFluorideConcentrationMeasurementClusterPrintln(...)

#define emberAfFluorideConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfFluorideConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_FLUORIDE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Haloacetic Acids Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_HALOACETIC_ACIDS_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfHaloaceticAcidsConcentrationMeasurementClusterPrint(...)                                                            \
    emberAfPrint(EMBER_AF_PRINT_HALOACETIC_ACIDS_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfHaloaceticAcidsConcentrationMeasurementClusterPrintln(...)                                                          \
    emberAfPrintln(EMBER_AF_PRINT_HALOACETIC_ACIDS_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfHaloaceticAcidsConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                   \
    emberAfPrintBuffer(EMBER_AF_PRINT_HALOACETIC_ACIDS_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfHaloaceticAcidsConcentrationMeasurementClusterPrintString(buffer)                                                   \
    emberAfPrintString(EMBER_AF_PRINT_HALOACETIC_ACIDS_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfHaloaceticAcidsConcentrationMeasurementClusterPrint(...)
#define emberAfHaloaceticAcidsConcentrationMeasurementClusterPrintln(...)

#define emberAfHaloaceticAcidsConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfHaloaceticAcidsConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_HALOACETIC_ACIDS_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Total Trihalomethanes Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TOTAL_TRIHALOMETHANES_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfTotalTrihalomethanesConcentrationMeasurementClusterPrint(...)                                                       \
    emberAfPrint(EMBER_AF_PRINT_TOTAL_TRIHALOMETHANES_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfTotalTrihalomethanesConcentrationMeasurementClusterPrintln(...)                                                     \
    emberAfPrintln(EMBER_AF_PRINT_TOTAL_TRIHALOMETHANES_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfTotalTrihalomethanesConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                              \
    emberAfPrintBuffer(EMBER_AF_PRINT_TOTAL_TRIHALOMETHANES_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfTotalTrihalomethanesConcentrationMeasurementClusterPrintString(buffer)                                              \
    emberAfPrintString(EMBER_AF_PRINT_TOTAL_TRIHALOMETHANES_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfTotalTrihalomethanesConcentrationMeasurementClusterPrint(...)
#define emberAfTotalTrihalomethanesConcentrationMeasurementClusterPrintln(...)

#define emberAfTotalTrihalomethanesConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfTotalTrihalomethanesConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TOTAL_TRIHALOMETHANES_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Total Coliform Bacteria Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TOTAL_COLIFORM_BACTERIA_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfTotalColiformBacteriaConcentrationMeasurementClusterPrint(...)                                                      \
    emberAfPrint(EMBER_AF_PRINT_TOTAL_COLIFORM_BACTERIA_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfTotalColiformBacteriaConcentrationMeasurementClusterPrintln(...)                                                    \
    emberAfPrintln(EMBER_AF_PRINT_TOTAL_COLIFORM_BACTERIA_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfTotalColiformBacteriaConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                             \
    emberAfPrintBuffer(EMBER_AF_PRINT_TOTAL_COLIFORM_BACTERIA_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfTotalColiformBacteriaConcentrationMeasurementClusterPrintString(buffer)                                             \
    emberAfPrintString(EMBER_AF_PRINT_TOTAL_COLIFORM_BACTERIA_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfTotalColiformBacteriaConcentrationMeasurementClusterPrint(...)
#define emberAfTotalColiformBacteriaConcentrationMeasurementClusterPrintln(...)

#define emberAfTotalColiformBacteriaConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfTotalColiformBacteriaConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TOTAL_COLIFORM_BACTERIA_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Turbidity Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TURBIDITY_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfTurbidityConcentrationMeasurementClusterPrint(...)                                                                  \
    emberAfPrint(EMBER_AF_PRINT_TURBIDITY_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfTurbidityConcentrationMeasurementClusterPrintln(...)                                                                \
    emberAfPrintln(EMBER_AF_PRINT_TURBIDITY_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfTurbidityConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                         \
    emberAfPrintBuffer(EMBER_AF_PRINT_TURBIDITY_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfTurbidityConcentrationMeasurementClusterPrintString(buffer)                                                         \
    emberAfPrintString(EMBER_AF_PRINT_TURBIDITY_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfTurbidityConcentrationMeasurementClusterPrint(...)
#define emberAfTurbidityConcentrationMeasurementClusterPrintln(...)

#define emberAfTurbidityConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfTurbidityConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TURBIDITY_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Copper Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_COPPER_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfCopperConcentrationMeasurementClusterPrint(...)                                                                     \
    emberAfPrint(EMBER_AF_PRINT_COPPER_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfCopperConcentrationMeasurementClusterPrintln(...)                                                                   \
    emberAfPrintln(EMBER_AF_PRINT_COPPER_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfCopperConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                            \
    emberAfPrintBuffer(EMBER_AF_PRINT_COPPER_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfCopperConcentrationMeasurementClusterPrintString(buffer)                                                            \
    emberAfPrintString(EMBER_AF_PRINT_COPPER_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfCopperConcentrationMeasurementClusterPrint(...)
#define emberAfCopperConcentrationMeasurementClusterPrintln(...)

#define emberAfCopperConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfCopperConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_COPPER_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Lead Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_LEAD_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfLeadConcentrationMeasurementClusterPrint(...)                                                                       \
    emberAfPrint(EMBER_AF_PRINT_LEAD_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfLeadConcentrationMeasurementClusterPrintln(...)                                                                     \
    emberAfPrintln(EMBER_AF_PRINT_LEAD_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfLeadConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                              \
    emberAfPrintBuffer(EMBER_AF_PRINT_LEAD_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfLeadConcentrationMeasurementClusterPrintString(buffer)                                                              \
    emberAfPrintString(EMBER_AF_PRINT_LEAD_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfLeadConcentrationMeasurementClusterPrint(...)
#define emberAfLeadConcentrationMeasurementClusterPrintln(...)

#define emberAfLeadConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfLeadConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_LEAD_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Manganese Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_MANGANESE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfManganeseConcentrationMeasurementClusterPrint(...)                                                                  \
    emberAfPrint(EMBER_AF_PRINT_MANGANESE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfManganeseConcentrationMeasurementClusterPrintln(...)                                                                \
    emberAfPrintln(EMBER_AF_PRINT_MANGANESE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfManganeseConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                         \
    emberAfPrintBuffer(EMBER_AF_PRINT_MANGANESE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfManganeseConcentrationMeasurementClusterPrintString(buffer)                                                         \
    emberAfPrintString(EMBER_AF_PRINT_MANGANESE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfManganeseConcentrationMeasurementClusterPrint(...)
#define emberAfManganeseConcentrationMeasurementClusterPrintln(...)

#define emberAfManganeseConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfManganeseConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_MANGANESE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Sulfate Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SULFATE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfSulfateConcentrationMeasurementClusterPrint(...)                                                                    \
    emberAfPrint(EMBER_AF_PRINT_SULFATE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfSulfateConcentrationMeasurementClusterPrintln(...)                                                                  \
    emberAfPrintln(EMBER_AF_PRINT_SULFATE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfSulfateConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                           \
    emberAfPrintBuffer(EMBER_AF_PRINT_SULFATE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfSulfateConcentrationMeasurementClusterPrintString(buffer)                                                           \
    emberAfPrintString(EMBER_AF_PRINT_SULFATE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfSulfateConcentrationMeasurementClusterPrint(...)
#define emberAfSulfateConcentrationMeasurementClusterPrintln(...)

#define emberAfSulfateConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfSulfateConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SULFATE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Bromodichloromethane Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BROMODICHLOROMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfBromodichloromethaneConcentrationMeasurementClusterPrint(...)                                                       \
    emberAfPrint(EMBER_AF_PRINT_BROMODICHLOROMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfBromodichloromethaneConcentrationMeasurementClusterPrintln(...)                                                     \
    emberAfPrintln(EMBER_AF_PRINT_BROMODICHLOROMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfBromodichloromethaneConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                              \
    emberAfPrintBuffer(EMBER_AF_PRINT_BROMODICHLOROMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfBromodichloromethaneConcentrationMeasurementClusterPrintString(buffer)                                              \
    emberAfPrintString(EMBER_AF_PRINT_BROMODICHLOROMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfBromodichloromethaneConcentrationMeasurementClusterPrint(...)
#define emberAfBromodichloromethaneConcentrationMeasurementClusterPrintln(...)

#define emberAfBromodichloromethaneConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfBromodichloromethaneConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BROMODICHLOROMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Bromoform Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BROMOFORM_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfBromoformConcentrationMeasurementClusterPrint(...)                                                                  \
    emberAfPrint(EMBER_AF_PRINT_BROMOFORM_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfBromoformConcentrationMeasurementClusterPrintln(...)                                                                \
    emberAfPrintln(EMBER_AF_PRINT_BROMOFORM_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfBromoformConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                         \
    emberAfPrintBuffer(EMBER_AF_PRINT_BROMOFORM_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfBromoformConcentrationMeasurementClusterPrintString(buffer)                                                         \
    emberAfPrintString(EMBER_AF_PRINT_BROMOFORM_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfBromoformConcentrationMeasurementClusterPrint(...)
#define emberAfBromoformConcentrationMeasurementClusterPrintln(...)

#define emberAfBromoformConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfBromoformConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BROMOFORM_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Chlorodibromomethane Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CHLORODIBROMOMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfChlorodibromomethaneConcentrationMeasurementClusterPrint(...)                                                       \
    emberAfPrint(EMBER_AF_PRINT_CHLORODIBROMOMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfChlorodibromomethaneConcentrationMeasurementClusterPrintln(...)                                                     \
    emberAfPrintln(EMBER_AF_PRINT_CHLORODIBROMOMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfChlorodibromomethaneConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                              \
    emberAfPrintBuffer(EMBER_AF_PRINT_CHLORODIBROMOMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfChlorodibromomethaneConcentrationMeasurementClusterPrintString(buffer)                                              \
    emberAfPrintString(EMBER_AF_PRINT_CHLORODIBROMOMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfChlorodibromomethaneConcentrationMeasurementClusterPrint(...)
#define emberAfChlorodibromomethaneConcentrationMeasurementClusterPrintln(...)

#define emberAfChlorodibromomethaneConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfChlorodibromomethaneConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CHLORODIBROMOMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Chloroform Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CHLOROFORM_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfChloroformConcentrationMeasurementClusterPrint(...)                                                                 \
    emberAfPrint(EMBER_AF_PRINT_CHLOROFORM_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfChloroformConcentrationMeasurementClusterPrintln(...)                                                               \
    emberAfPrintln(EMBER_AF_PRINT_CHLOROFORM_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfChloroformConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                        \
    emberAfPrintBuffer(EMBER_AF_PRINT_CHLOROFORM_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfChloroformConcentrationMeasurementClusterPrintString(buffer)                                                        \
    emberAfPrintString(EMBER_AF_PRINT_CHLOROFORM_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfChloroformConcentrationMeasurementClusterPrint(...)
#define emberAfChloroformConcentrationMeasurementClusterPrintln(...)

#define emberAfChloroformConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfChloroformConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CHLOROFORM_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Sodium Concentration Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SODIUM_CONCENTRATION_MEASUREMENT_CLUSTER)
#define emberAfSodiumConcentrationMeasurementClusterPrint(...)                                                                     \
    emberAfPrint(EMBER_AF_PRINT_SODIUM_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfSodiumConcentrationMeasurementClusterPrintln(...)                                                                   \
    emberAfPrintln(EMBER_AF_PRINT_SODIUM_CONCENTRATION_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfSodiumConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)                                            \
    emberAfPrintBuffer(EMBER_AF_PRINT_SODIUM_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfSodiumConcentrationMeasurementClusterPrintString(buffer)                                                            \
    emberAfPrintString(EMBER_AF_PRINT_SODIUM_CONCENTRATION_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfSodiumConcentrationMeasurementClusterPrint(...)
#define emberAfSodiumConcentrationMeasurementClusterPrintln(...)

#define emberAfSodiumConcentrationMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfSodiumConcentrationMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SODIUM_CONCENTRATION_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Generic Tunnel
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_GENERIC_TUNNEL_CLUSTER)
#define emberAfGenericTunnelClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_GENERIC_TUNNEL_CLUSTER, __VA_ARGS__)
#define emberAfGenericTunnelClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_GENERIC_TUNNEL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfGenericTunnelClusterPrintBuffer(buffer, len, withSpace)                                                             \
    emberAfPrintBuffer(EMBER_AF_PRINT_GENERIC_TUNNEL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfGenericTunnelClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_GENERIC_TUNNEL_CLUSTER, (buffer))
#else
#define emberAfGenericTunnelClusterPrint(...)
#define emberAfGenericTunnelClusterPrintln(...)

#define emberAfGenericTunnelClusterPrintBuffer(buffer, len, withSpace)
#define emberAfGenericTunnelClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_GENERIC_TUNNEL_CLUSTER)

// Printing macros for cluster: BACnet Protocol Tunnel
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BACNET_PROTOCOL_TUNNEL_CLUSTER)
#define emberAfBacnetProtocolTunnelClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_BACNET_PROTOCOL_TUNNEL_CLUSTER, __VA_ARGS__)
#define emberAfBacnetProtocolTunnelClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_BACNET_PROTOCOL_TUNNEL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfBacnetProtocolTunnelClusterPrintBuffer(buffer, len, withSpace)                                                      \
    emberAfPrintBuffer(EMBER_AF_PRINT_BACNET_PROTOCOL_TUNNEL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfBacnetProtocolTunnelClusterPrintString(buffer)                                                                      \
    emberAfPrintString(EMBER_AF_PRINT_BACNET_PROTOCOL_TUNNEL_CLUSTER, (buffer))
#else
#define emberAfBacnetProtocolTunnelClusterPrint(...)
#define emberAfBacnetProtocolTunnelClusterPrintln(...)

#define emberAfBacnetProtocolTunnelClusterPrintBuffer(buffer, len, withSpace)
#define emberAfBacnetProtocolTunnelClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BACNET_PROTOCOL_TUNNEL_CLUSTER)

// Printing macros for cluster: 11073 Protocol Tunnel
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_11073_PROTOCOL_TUNNEL_CLUSTER)
#define emberAf11073ProtocolTunnelClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_11073_PROTOCOL_TUNNEL_CLUSTER, __VA_ARGS__)
#define emberAf11073ProtocolTunnelClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_11073_PROTOCOL_TUNNEL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAf11073ProtocolTunnelClusterPrintBuffer(buffer, len, withSpace)                                                       \
    emberAfPrintBuffer(EMBER_AF_PRINT_11073_PROTOCOL_TUNNEL_CLUSTER, (buffer), (len), (withSpace))
#define emberAf11073ProtocolTunnelClusterPrintString(buffer)                                                                       \
    emberAfPrintString(EMBER_AF_PRINT_11073_PROTOCOL_TUNNEL_CLUSTER, (buffer))
#else
#define emberAf11073ProtocolTunnelClusterPrint(...)
#define emberAf11073ProtocolTunnelClusterPrintln(...)

#define emberAf11073ProtocolTunnelClusterPrintBuffer(buffer, len, withSpace)
#define emberAf11073ProtocolTunnelClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_11073_PROTOCOL_TUNNEL_CLUSTER)

// Printing macros for cluster: ISO 7816 Protocol Tunnel
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ISO7816_PROTOCOL_TUNNEL_CLUSTER)
#define emberAfIso7816ProtocolTunnelClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_ISO7816_PROTOCOL_TUNNEL_CLUSTER, __VA_ARGS__)
#define emberAfIso7816ProtocolTunnelClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ISO7816_PROTOCOL_TUNNEL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfIso7816ProtocolTunnelClusterPrintBuffer(buffer, len, withSpace)                                                     \
    emberAfPrintBuffer(EMBER_AF_PRINT_ISO7816_PROTOCOL_TUNNEL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfIso7816ProtocolTunnelClusterPrintString(buffer)                                                                     \
    emberAfPrintString(EMBER_AF_PRINT_ISO7816_PROTOCOL_TUNNEL_CLUSTER, (buffer))
#else
#define emberAfIso7816ProtocolTunnelClusterPrint(...)
#define emberAfIso7816ProtocolTunnelClusterPrintln(...)

#define emberAfIso7816ProtocolTunnelClusterPrintBuffer(buffer, len, withSpace)
#define emberAfIso7816ProtocolTunnelClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ISO7816_PROTOCOL_TUNNEL_CLUSTER)

// Printing macros for cluster: Price
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PRICE_CLUSTER)
#define emberAfPriceClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_PRICE_CLUSTER, __VA_ARGS__)
#define emberAfPriceClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_PRICE_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfPriceClusterPrintBuffer(buffer, len, withSpace)                                                                     \
    emberAfPrintBuffer(EMBER_AF_PRINT_PRICE_CLUSTER, (buffer), (len), (withSpace))
#define emberAfPriceClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_PRICE_CLUSTER, (buffer))
#else
#define emberAfPriceClusterPrint(...)
#define emberAfPriceClusterPrintln(...)

#define emberAfPriceClusterPrintBuffer(buffer, len, withSpace)
#define emberAfPriceClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PRICE_CLUSTER)

// Printing macros for cluster: Demand Response and Load Control
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DEMAND_RESPONSE_LOAD_CONTROL_CLUSTER)
#define emberAfDemandResponseLoadControlClusterPrint(...)                                                                          \
    emberAfPrint(EMBER_AF_PRINT_DEMAND_RESPONSE_LOAD_CONTROL_CLUSTER, __VA_ARGS__)
#define emberAfDemandResponseLoadControlClusterPrintln(...)                                                                        \
    emberAfPrintln(EMBER_AF_PRINT_DEMAND_RESPONSE_LOAD_CONTROL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfDemandResponseLoadControlClusterPrintBuffer(buffer, len, withSpace)                                                 \
    emberAfPrintBuffer(EMBER_AF_PRINT_DEMAND_RESPONSE_LOAD_CONTROL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfDemandResponseLoadControlClusterPrintString(buffer)                                                                 \
    emberAfPrintString(EMBER_AF_PRINT_DEMAND_RESPONSE_LOAD_CONTROL_CLUSTER, (buffer))
#else
#define emberAfDemandResponseLoadControlClusterPrint(...)
#define emberAfDemandResponseLoadControlClusterPrintln(...)

#define emberAfDemandResponseLoadControlClusterPrintBuffer(buffer, len, withSpace)
#define emberAfDemandResponseLoadControlClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DEMAND_RESPONSE_LOAD_CONTROL_CLUSTER)

// Printing macros for cluster: Simple Metering
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SIMPLE_METERING_CLUSTER)
#define emberAfSimpleMeteringClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_SIMPLE_METERING_CLUSTER, __VA_ARGS__)
#define emberAfSimpleMeteringClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_SIMPLE_METERING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfSimpleMeteringClusterPrintBuffer(buffer, len, withSpace)                                                            \
    emberAfPrintBuffer(EMBER_AF_PRINT_SIMPLE_METERING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfSimpleMeteringClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_SIMPLE_METERING_CLUSTER, (buffer))
#else
#define emberAfSimpleMeteringClusterPrint(...)
#define emberAfSimpleMeteringClusterPrintln(...)

#define emberAfSimpleMeteringClusterPrintBuffer(buffer, len, withSpace)
#define emberAfSimpleMeteringClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SIMPLE_METERING_CLUSTER)

// Printing macros for cluster: Messaging
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_MESSAGING_CLUSTER)
#define emberAfMessagingClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_MESSAGING_CLUSTER, __VA_ARGS__)
#define emberAfMessagingClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_MESSAGING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfMessagingClusterPrintBuffer(buffer, len, withSpace)                                                                 \
    emberAfPrintBuffer(EMBER_AF_PRINT_MESSAGING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfMessagingClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_MESSAGING_CLUSTER, (buffer))
#else
#define emberAfMessagingClusterPrint(...)
#define emberAfMessagingClusterPrintln(...)

#define emberAfMessagingClusterPrintBuffer(buffer, len, withSpace)
#define emberAfMessagingClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_MESSAGING_CLUSTER)

// Printing macros for cluster: Tunneling
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TUNNELING_CLUSTER)
#define emberAfTunnelingClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_TUNNELING_CLUSTER, __VA_ARGS__)
#define emberAfTunnelingClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_TUNNELING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfTunnelingClusterPrintBuffer(buffer, len, withSpace)                                                                 \
    emberAfPrintBuffer(EMBER_AF_PRINT_TUNNELING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfTunnelingClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_TUNNELING_CLUSTER, (buffer))
#else
#define emberAfTunnelingClusterPrint(...)
#define emberAfTunnelingClusterPrintln(...)

#define emberAfTunnelingClusterPrintBuffer(buffer, len, withSpace)
#define emberAfTunnelingClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TUNNELING_CLUSTER)

// Printing macros for cluster: Prepayment
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PREPAYMENT_CLUSTER)
#define emberAfPrepaymentClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_PREPAYMENT_CLUSTER, __VA_ARGS__)
#define emberAfPrepaymentClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_PREPAYMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfPrepaymentClusterPrintBuffer(buffer, len, withSpace)                                                                \
    emberAfPrintBuffer(EMBER_AF_PRINT_PREPAYMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfPrepaymentClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_PREPAYMENT_CLUSTER, (buffer))
#else
#define emberAfPrepaymentClusterPrint(...)
#define emberAfPrepaymentClusterPrintln(...)

#define emberAfPrepaymentClusterPrintBuffer(buffer, len, withSpace)
#define emberAfPrepaymentClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PREPAYMENT_CLUSTER)

// Printing macros for cluster: Energy Management
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ENERGY_MANAGEMENT_CLUSTER)
#define emberAfEnergyManagementClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_ENERGY_MANAGEMENT_CLUSTER, __VA_ARGS__)
#define emberAfEnergyManagementClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ENERGY_MANAGEMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfEnergyManagementClusterPrintBuffer(buffer, len, withSpace)                                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_ENERGY_MANAGEMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfEnergyManagementClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_ENERGY_MANAGEMENT_CLUSTER, (buffer))
#else
#define emberAfEnergyManagementClusterPrint(...)
#define emberAfEnergyManagementClusterPrintln(...)

#define emberAfEnergyManagementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfEnergyManagementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ENERGY_MANAGEMENT_CLUSTER)

// Printing macros for cluster: Calendar
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CALENDAR_CLUSTER)
#define emberAfCalendarClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_CALENDAR_CLUSTER, __VA_ARGS__)
#define emberAfCalendarClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_CALENDAR_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfCalendarClusterPrintBuffer(buffer, len, withSpace)                                                                  \
    emberAfPrintBuffer(EMBER_AF_PRINT_CALENDAR_CLUSTER, (buffer), (len), (withSpace))
#define emberAfCalendarClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_CALENDAR_CLUSTER, (buffer))
#else
#define emberAfCalendarClusterPrint(...)
#define emberAfCalendarClusterPrintln(...)

#define emberAfCalendarClusterPrintBuffer(buffer, len, withSpace)
#define emberAfCalendarClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CALENDAR_CLUSTER)

// Printing macros for cluster: Device Management
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DEVICE_MANAGEMENT_CLUSTER)
#define emberAfDeviceManagementClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_DEVICE_MANAGEMENT_CLUSTER, __VA_ARGS__)
#define emberAfDeviceManagementClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_DEVICE_MANAGEMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfDeviceManagementClusterPrintBuffer(buffer, len, withSpace)                                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_DEVICE_MANAGEMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfDeviceManagementClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_DEVICE_MANAGEMENT_CLUSTER, (buffer))
#else
#define emberAfDeviceManagementClusterPrint(...)
#define emberAfDeviceManagementClusterPrintln(...)

#define emberAfDeviceManagementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfDeviceManagementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DEVICE_MANAGEMENT_CLUSTER)

// Printing macros for cluster: Events
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_EVENTS_CLUSTER)
#define emberAfEventsClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_EVENTS_CLUSTER, __VA_ARGS__)
#define emberAfEventsClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_EVENTS_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfEventsClusterPrintBuffer(buffer, len, withSpace)                                                                    \
    emberAfPrintBuffer(EMBER_AF_PRINT_EVENTS_CLUSTER, (buffer), (len), (withSpace))
#define emberAfEventsClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_EVENTS_CLUSTER, (buffer))
#else
#define emberAfEventsClusterPrint(...)
#define emberAfEventsClusterPrintln(...)

#define emberAfEventsClusterPrintBuffer(buffer, len, withSpace)
#define emberAfEventsClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_EVENTS_CLUSTER)

// Printing macros for cluster: MDU Pairing
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_MDU_PAIRING_CLUSTER)
#define emberAfMduPairingClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_MDU_PAIRING_CLUSTER, __VA_ARGS__)
#define emberAfMduPairingClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_MDU_PAIRING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfMduPairingClusterPrintBuffer(buffer, len, withSpace)                                                                \
    emberAfPrintBuffer(EMBER_AF_PRINT_MDU_PAIRING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfMduPairingClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_MDU_PAIRING_CLUSTER, (buffer))
#else
#define emberAfMduPairingClusterPrint(...)
#define emberAfMduPairingClusterPrintln(...)

#define emberAfMduPairingClusterPrintBuffer(buffer, len, withSpace)
#define emberAfMduPairingClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_MDU_PAIRING_CLUSTER)

// Printing macros for cluster: Sub-GHz
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SUB_GHZ_CLUSTER)
#define emberAfSubGhzClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_SUB_GHZ_CLUSTER, __VA_ARGS__)
#define emberAfSubGhzClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_SUB_GHZ_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfSubGhzClusterPrintBuffer(buffer, len, withSpace)                                                                    \
    emberAfPrintBuffer(EMBER_AF_PRINT_SUB_GHZ_CLUSTER, (buffer), (len), (withSpace))
#define emberAfSubGhzClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_SUB_GHZ_CLUSTER, (buffer))
#else
#define emberAfSubGhzClusterPrint(...)
#define emberAfSubGhzClusterPrintln(...)

#define emberAfSubGhzClusterPrintBuffer(buffer, len, withSpace)
#define emberAfSubGhzClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SUB_GHZ_CLUSTER)

// Printing macros for cluster: Key Establishment
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_KEY_ESTABLISHMENT_CLUSTER)
#define emberAfKeyEstablishmentClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_KEY_ESTABLISHMENT_CLUSTER, __VA_ARGS__)
#define emberAfKeyEstablishmentClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_KEY_ESTABLISHMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfKeyEstablishmentClusterPrintBuffer(buffer, len, withSpace)                                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_KEY_ESTABLISHMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfKeyEstablishmentClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_KEY_ESTABLISHMENT_CLUSTER, (buffer))
#else
#define emberAfKeyEstablishmentClusterPrint(...)
#define emberAfKeyEstablishmentClusterPrintln(...)

#define emberAfKeyEstablishmentClusterPrintBuffer(buffer, len, withSpace)
#define emberAfKeyEstablishmentClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_KEY_ESTABLISHMENT_CLUSTER)

// Printing macros for cluster: Information
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_INFORMATION_CLUSTER)
#define emberAfInformationClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_INFORMATION_CLUSTER, __VA_ARGS__)
#define emberAfInformationClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_INFORMATION_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfInformationClusterPrintBuffer(buffer, len, withSpace)                                                               \
    emberAfPrintBuffer(EMBER_AF_PRINT_INFORMATION_CLUSTER, (buffer), (len), (withSpace))
#define emberAfInformationClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_INFORMATION_CLUSTER, (buffer))
#else
#define emberAfInformationClusterPrint(...)
#define emberAfInformationClusterPrintln(...)

#define emberAfInformationClusterPrintBuffer(buffer, len, withSpace)
#define emberAfInformationClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_INFORMATION_CLUSTER)

// Printing macros for cluster: Data Sharing
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DATA_SHARING_CLUSTER)
#define emberAfDataSharingClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_DATA_SHARING_CLUSTER, __VA_ARGS__)
#define emberAfDataSharingClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_DATA_SHARING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfDataSharingClusterPrintBuffer(buffer, len, withSpace)                                                               \
    emberAfPrintBuffer(EMBER_AF_PRINT_DATA_SHARING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfDataSharingClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_DATA_SHARING_CLUSTER, (buffer))
#else
#define emberAfDataSharingClusterPrint(...)
#define emberAfDataSharingClusterPrintln(...)

#define emberAfDataSharingClusterPrintBuffer(buffer, len, withSpace)
#define emberAfDataSharingClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DATA_SHARING_CLUSTER)

// Printing macros for cluster: Gaming
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_GAMING_CLUSTER)
#define emberAfGamingClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_GAMING_CLUSTER, __VA_ARGS__)
#define emberAfGamingClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_GAMING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfGamingClusterPrintBuffer(buffer, len, withSpace)                                                                    \
    emberAfPrintBuffer(EMBER_AF_PRINT_GAMING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfGamingClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_GAMING_CLUSTER, (buffer))
#else
#define emberAfGamingClusterPrint(...)
#define emberAfGamingClusterPrintln(...)

#define emberAfGamingClusterPrintBuffer(buffer, len, withSpace)
#define emberAfGamingClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_GAMING_CLUSTER)

// Printing macros for cluster: Data Rate Control
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DATA_RATE_CONTROL_CLUSTER)
#define emberAfDataRateControlClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_DATA_RATE_CONTROL_CLUSTER, __VA_ARGS__)
#define emberAfDataRateControlClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_DATA_RATE_CONTROL_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfDataRateControlClusterPrintBuffer(buffer, len, withSpace)                                                           \
    emberAfPrintBuffer(EMBER_AF_PRINT_DATA_RATE_CONTROL_CLUSTER, (buffer), (len), (withSpace))
#define emberAfDataRateControlClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_DATA_RATE_CONTROL_CLUSTER, (buffer))
#else
#define emberAfDataRateControlClusterPrint(...)
#define emberAfDataRateControlClusterPrintln(...)

#define emberAfDataRateControlClusterPrintBuffer(buffer, len, withSpace)
#define emberAfDataRateControlClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DATA_RATE_CONTROL_CLUSTER)

// Printing macros for cluster: Voice over ZigBee
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_VOICE_OVER_ZIGBEE_CLUSTER)
#define emberAfVoiceOverZigbeeClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_VOICE_OVER_ZIGBEE_CLUSTER, __VA_ARGS__)
#define emberAfVoiceOverZigbeeClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_VOICE_OVER_ZIGBEE_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfVoiceOverZigbeeClusterPrintBuffer(buffer, len, withSpace)                                                           \
    emberAfPrintBuffer(EMBER_AF_PRINT_VOICE_OVER_ZIGBEE_CLUSTER, (buffer), (len), (withSpace))
#define emberAfVoiceOverZigbeeClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_VOICE_OVER_ZIGBEE_CLUSTER, (buffer))
#else
#define emberAfVoiceOverZigbeeClusterPrint(...)
#define emberAfVoiceOverZigbeeClusterPrintln(...)

#define emberAfVoiceOverZigbeeClusterPrintBuffer(buffer, len, withSpace)
#define emberAfVoiceOverZigbeeClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_VOICE_OVER_ZIGBEE_CLUSTER)

// Printing macros for cluster: Chatting
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CHATTING_CLUSTER)
#define emberAfChattingClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_CHATTING_CLUSTER, __VA_ARGS__)
#define emberAfChattingClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_CHATTING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfChattingClusterPrintBuffer(buffer, len, withSpace)                                                                  \
    emberAfPrintBuffer(EMBER_AF_PRINT_CHATTING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfChattingClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_CHATTING_CLUSTER, (buffer))
#else
#define emberAfChattingClusterPrint(...)
#define emberAfChattingClusterPrintln(...)

#define emberAfChattingClusterPrintBuffer(buffer, len, withSpace)
#define emberAfChattingClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CHATTING_CLUSTER)

// Printing macros for cluster: Payment
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PAYMENT_CLUSTER)
#define emberAfPaymentClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_PAYMENT_CLUSTER, __VA_ARGS__)
#define emberAfPaymentClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_PAYMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfPaymentClusterPrintBuffer(buffer, len, withSpace)                                                                   \
    emberAfPrintBuffer(EMBER_AF_PRINT_PAYMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfPaymentClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_PAYMENT_CLUSTER, (buffer))
#else
#define emberAfPaymentClusterPrint(...)
#define emberAfPaymentClusterPrintln(...)

#define emberAfPaymentClusterPrintBuffer(buffer, len, withSpace)
#define emberAfPaymentClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_PAYMENT_CLUSTER)

// Printing macros for cluster: Billing
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BILLING_CLUSTER)
#define emberAfBillingClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_BILLING_CLUSTER, __VA_ARGS__)
#define emberAfBillingClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_BILLING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfBillingClusterPrintBuffer(buffer, len, withSpace)                                                                   \
    emberAfPrintBuffer(EMBER_AF_PRINT_BILLING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfBillingClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_BILLING_CLUSTER, (buffer))
#else
#define emberAfBillingClusterPrint(...)
#define emberAfBillingClusterPrintln(...)

#define emberAfBillingClusterPrintBuffer(buffer, len, withSpace)
#define emberAfBillingClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_BILLING_CLUSTER)

// Printing macros for cluster: Appliance Identification
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLIANCE_IDENTIFICATION_CLUSTER)
#define emberAfApplianceIdentificationClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_APPLIANCE_IDENTIFICATION_CLUSTER, __VA_ARGS__)
#define emberAfApplianceIdentificationClusterPrintln(...)                                                                          \
    emberAfPrintln(EMBER_AF_PRINT_APPLIANCE_IDENTIFICATION_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfApplianceIdentificationClusterPrintBuffer(buffer, len, withSpace)                                                   \
    emberAfPrintBuffer(EMBER_AF_PRINT_APPLIANCE_IDENTIFICATION_CLUSTER, (buffer), (len), (withSpace))
#define emberAfApplianceIdentificationClusterPrintString(buffer)                                                                   \
    emberAfPrintString(EMBER_AF_PRINT_APPLIANCE_IDENTIFICATION_CLUSTER, (buffer))
#else
#define emberAfApplianceIdentificationClusterPrint(...)
#define emberAfApplianceIdentificationClusterPrintln(...)

#define emberAfApplianceIdentificationClusterPrintBuffer(buffer, len, withSpace)
#define emberAfApplianceIdentificationClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLIANCE_IDENTIFICATION_CLUSTER)

// Printing macros for cluster: Meter Identification
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_METER_IDENTIFICATION_CLUSTER)
#define emberAfMeterIdentificationClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_METER_IDENTIFICATION_CLUSTER, __VA_ARGS__)
#define emberAfMeterIdentificationClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_METER_IDENTIFICATION_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfMeterIdentificationClusterPrintBuffer(buffer, len, withSpace)                                                       \
    emberAfPrintBuffer(EMBER_AF_PRINT_METER_IDENTIFICATION_CLUSTER, (buffer), (len), (withSpace))
#define emberAfMeterIdentificationClusterPrintString(buffer)                                                                       \
    emberAfPrintString(EMBER_AF_PRINT_METER_IDENTIFICATION_CLUSTER, (buffer))
#else
#define emberAfMeterIdentificationClusterPrint(...)
#define emberAfMeterIdentificationClusterPrintln(...)

#define emberAfMeterIdentificationClusterPrintBuffer(buffer, len, withSpace)
#define emberAfMeterIdentificationClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_METER_IDENTIFICATION_CLUSTER)

// Printing macros for cluster: Appliance Events and Alert
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLIANCE_EVENTS_AND_ALERT_CLUSTER)
#define emberAfApplianceEventsAndAlertClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_APPLIANCE_EVENTS_AND_ALERT_CLUSTER, __VA_ARGS__)
#define emberAfApplianceEventsAndAlertClusterPrintln(...)                                                                          \
    emberAfPrintln(EMBER_AF_PRINT_APPLIANCE_EVENTS_AND_ALERT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfApplianceEventsAndAlertClusterPrintBuffer(buffer, len, withSpace)                                                   \
    emberAfPrintBuffer(EMBER_AF_PRINT_APPLIANCE_EVENTS_AND_ALERT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfApplianceEventsAndAlertClusterPrintString(buffer)                                                                   \
    emberAfPrintString(EMBER_AF_PRINT_APPLIANCE_EVENTS_AND_ALERT_CLUSTER, (buffer))
#else
#define emberAfApplianceEventsAndAlertClusterPrint(...)
#define emberAfApplianceEventsAndAlertClusterPrintln(...)

#define emberAfApplianceEventsAndAlertClusterPrintBuffer(buffer, len, withSpace)
#define emberAfApplianceEventsAndAlertClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLIANCE_EVENTS_AND_ALERT_CLUSTER)

// Printing macros for cluster: Appliance Statistics
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLIANCE_STATISTICS_CLUSTER)
#define emberAfApplianceStatisticsClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_APPLIANCE_STATISTICS_CLUSTER, __VA_ARGS__)
#define emberAfApplianceStatisticsClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_APPLIANCE_STATISTICS_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfApplianceStatisticsClusterPrintBuffer(buffer, len, withSpace)                                                       \
    emberAfPrintBuffer(EMBER_AF_PRINT_APPLIANCE_STATISTICS_CLUSTER, (buffer), (len), (withSpace))
#define emberAfApplianceStatisticsClusterPrintString(buffer)                                                                       \
    emberAfPrintString(EMBER_AF_PRINT_APPLIANCE_STATISTICS_CLUSTER, (buffer))
#else
#define emberAfApplianceStatisticsClusterPrint(...)
#define emberAfApplianceStatisticsClusterPrintln(...)

#define emberAfApplianceStatisticsClusterPrintBuffer(buffer, len, withSpace)
#define emberAfApplianceStatisticsClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLIANCE_STATISTICS_CLUSTER)

// Printing macros for cluster: Electrical Measurement
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ELECTRICAL_MEASUREMENT_CLUSTER)
#define emberAfElectricalMeasurementClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_ELECTRICAL_MEASUREMENT_CLUSTER, __VA_ARGS__)
#define emberAfElectricalMeasurementClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ELECTRICAL_MEASUREMENT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfElectricalMeasurementClusterPrintBuffer(buffer, len, withSpace)                                                     \
    emberAfPrintBuffer(EMBER_AF_PRINT_ELECTRICAL_MEASUREMENT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfElectricalMeasurementClusterPrintString(buffer)                                                                     \
    emberAfPrintString(EMBER_AF_PRINT_ELECTRICAL_MEASUREMENT_CLUSTER, (buffer))
#else
#define emberAfElectricalMeasurementClusterPrint(...)
#define emberAfElectricalMeasurementClusterPrintln(...)

#define emberAfElectricalMeasurementClusterPrintBuffer(buffer, len, withSpace)
#define emberAfElectricalMeasurementClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ELECTRICAL_MEASUREMENT_CLUSTER)

// Printing macros for cluster: Diagnostics
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DIAGNOSTICS_CLUSTER)
#define emberAfDiagnosticsClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_DIAGNOSTICS_CLUSTER, __VA_ARGS__)
#define emberAfDiagnosticsClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_DIAGNOSTICS_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfDiagnosticsClusterPrintBuffer(buffer, len, withSpace)                                                               \
    emberAfPrintBuffer(EMBER_AF_PRINT_DIAGNOSTICS_CLUSTER, (buffer), (len), (withSpace))
#define emberAfDiagnosticsClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_DIAGNOSTICS_CLUSTER, (buffer))
#else
#define emberAfDiagnosticsClusterPrint(...)
#define emberAfDiagnosticsClusterPrintln(...)

#define emberAfDiagnosticsClusterPrintBuffer(buffer, len, withSpace)
#define emberAfDiagnosticsClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DIAGNOSTICS_CLUSTER)

// Printing macros for cluster: Application Basic
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLICATION_BASIC_CLUSTER)
#define emberAfApplicationBasicClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_APPLICATION_BASIC_CLUSTER, __VA_ARGS__)
#define emberAfApplicationBasicClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_APPLICATION_BASIC_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfApplicationBasicClusterPrintBuffer(buffer, len, withSpace)                                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_APPLICATION_BASIC_CLUSTER, (buffer), (len), (withSpace))
#define emberAfApplicationBasicClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_APPLICATION_BASIC_CLUSTER, (buffer))
#else
#define emberAfApplicationBasicClusterPrint(...)
#define emberAfApplicationBasicClusterPrintln(...)

#define emberAfApplicationBasicClusterPrintBuffer(buffer, len, withSpace)
#define emberAfApplicationBasicClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLICATION_BASIC_CLUSTER)

// Printing macros for cluster: ZLL Commissioning
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ZLL_COMMISSIONING_CLUSTER)
#define emberAfZllCommissioningClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_ZLL_COMMISSIONING_CLUSTER, __VA_ARGS__)
#define emberAfZllCommissioningClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ZLL_COMMISSIONING_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfZllCommissioningClusterPrintBuffer(buffer, len, withSpace)                                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_ZLL_COMMISSIONING_CLUSTER, (buffer), (len), (withSpace))
#define emberAfZllCommissioningClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_ZLL_COMMISSIONING_CLUSTER, (buffer))
#else
#define emberAfZllCommissioningClusterPrint(...)
#define emberAfZllCommissioningClusterPrintln(...)

#define emberAfZllCommissioningClusterPrintBuffer(buffer, len, withSpace)
#define emberAfZllCommissioningClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ZLL_COMMISSIONING_CLUSTER)

// Printing macros for cluster: Sample Mfg Specific Cluster
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER)
#define emberAfSampleMfgSpecificClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER, __VA_ARGS__)
#define emberAfSampleMfgSpecificClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfSampleMfgSpecificClusterPrintBuffer(buffer, len, withSpace)                                                         \
    emberAfPrintBuffer(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER, (buffer), (len), (withSpace))
#define emberAfSampleMfgSpecificClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER, (buffer))
#else
#define emberAfSampleMfgSpecificClusterPrint(...)
#define emberAfSampleMfgSpecificClusterPrintln(...)

#define emberAfSampleMfgSpecificClusterPrintBuffer(buffer, len, withSpace)
#define emberAfSampleMfgSpecificClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER)

// Printing macros for cluster: Sample Mfg Specific Cluster 2
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER_2)
#define emberAfSampleMfgSpecificCluster2Print(...) emberAfPrint(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER_2, __VA_ARGS__)
#define emberAfSampleMfgSpecificCluster2Println(...) emberAfPrintln(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER_2, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfSampleMfgSpecificCluster2PrintBuffer(buffer, len, withSpace)                                                        \
    emberAfPrintBuffer(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER_2, (buffer), (len), (withSpace))
#define emberAfSampleMfgSpecificCluster2PrintString(buffer)                                                                        \
    emberAfPrintString(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER_2, (buffer))
#else
#define emberAfSampleMfgSpecificCluster2Print(...)
#define emberAfSampleMfgSpecificCluster2Println(...)

#define emberAfSampleMfgSpecificCluster2PrintBuffer(buffer, len, withSpace)
#define emberAfSampleMfgSpecificCluster2PrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SAMPLE_MFG_SPECIFIC_CLUSTER_2)

// Printing macros for cluster: Configuration Cluster
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_OTA_CONFIGURATION_CLUSTER)
#define emberAfOtaConfigurationClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_OTA_CONFIGURATION_CLUSTER, __VA_ARGS__)
#define emberAfOtaConfigurationClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_OTA_CONFIGURATION_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfOtaConfigurationClusterPrintBuffer(buffer, len, withSpace)                                                          \
    emberAfPrintBuffer(EMBER_AF_PRINT_OTA_CONFIGURATION_CLUSTER, (buffer), (len), (withSpace))
#define emberAfOtaConfigurationClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_OTA_CONFIGURATION_CLUSTER, (buffer))
#else
#define emberAfOtaConfigurationClusterPrint(...)
#define emberAfOtaConfigurationClusterPrintln(...)

#define emberAfOtaConfigurationClusterPrintBuffer(buffer, len, withSpace)
#define emberAfOtaConfigurationClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_OTA_CONFIGURATION_CLUSTER)

// Printing macros for cluster: MFGLIB Cluster
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_MFGLIB_CLUSTER)
#define emberAfMfglibClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_MFGLIB_CLUSTER, __VA_ARGS__)
#define emberAfMfglibClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_MFGLIB_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfMfglibClusterPrintBuffer(buffer, len, withSpace)                                                                    \
    emberAfPrintBuffer(EMBER_AF_PRINT_MFGLIB_CLUSTER, (buffer), (len), (withSpace))
#define emberAfMfglibClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_MFGLIB_CLUSTER, (buffer))
#else
#define emberAfMfglibClusterPrint(...)
#define emberAfMfglibClusterPrintln(...)

#define emberAfMfglibClusterPrintBuffer(buffer, len, withSpace)
#define emberAfMfglibClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_MFGLIB_CLUSTER)

// Printing macros for cluster: SL Works With All Hubs
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SL_WWAH_CLUSTER)
#define emberAfSlWwahClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_SL_WWAH_CLUSTER, __VA_ARGS__)
#define emberAfSlWwahClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_SL_WWAH_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfSlWwahClusterPrintBuffer(buffer, len, withSpace)                                                                    \
    emberAfPrintBuffer(EMBER_AF_PRINT_SL_WWAH_CLUSTER, (buffer), (len), (withSpace))
#define emberAfSlWwahClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_SL_WWAH_CLUSTER, (buffer))
#else
#define emberAfSlWwahClusterPrint(...)
#define emberAfSlWwahClusterPrintln(...)

#define emberAfSlWwahClusterPrintBuffer(buffer, len, withSpace)
#define emberAfSlWwahClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_SL_WWAH_CLUSTER)

// Printing macros for Core
// Prints messages for global flow of the receive/send
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CORE)
#define emberAfCorePrint(...) emberAfPrint(EMBER_AF_PRINT_CORE, __VA_ARGS__)
#define emberAfCorePrintln(...) emberAfPrintln(EMBER_AF_PRINT_CORE, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.
#define emberAfCoreFlush()
#define emberAfCorePrintBuffer(buffer, len, withSpace) emberAfPrintBuffer(EMBER_AF_PRINT_CORE, (buffer), (len), (withSpace))
#define emberAfCorePrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_CORE, (buffer))
#else
#define emberAfCorePrint(...)
#define emberAfCorePrintln(...)
#define emberAfCoreFlush()
#define emberAfCorePrintBuffer(buffer, len, withSpace)
#define emberAfCorePrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CORE)

// Printing macros for Debug
// Prints messages for random debugging
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DEBUG)
#define emberAfDebugPrint(...) emberAfPrint(EMBER_AF_PRINT_DEBUG, __VA_ARGS__)
#define emberAfDebugPrintln(...) emberAfPrintln(EMBER_AF_PRINT_DEBUG, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.
#define emberAfDebugFlush()
#define emberAfDebugPrintBuffer(buffer, len, withSpace) emberAfPrintBuffer(EMBER_AF_PRINT_DEBUG, (buffer), (len), (withSpace))
#define emberAfDebugPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_DEBUG, (buffer))
#else
#define emberAfDebugPrint(...)
#define emberAfDebugPrintln(...)
#define emberAfDebugFlush()
#define emberAfDebugPrintBuffer(buffer, len, withSpace)
#define emberAfDebugPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_DEBUG)

// Printing macros for Application
// Prints messages for application part
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APP)
#define emberAfAppPrint(...) emberAfPrint(EMBER_AF_PRINT_APP, __VA_ARGS__)
#define emberAfAppPrintln(...) emberAfPrintln(EMBER_AF_PRINT_APP, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.
#define emberAfAppFlush()
#define emberAfAppPrintBuffer(buffer, len, withSpace) emberAfPrintBuffer(EMBER_AF_PRINT_APP, (buffer), (len), (withSpace))
#define emberAfAppPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_APP, (buffer))
#else
#define emberAfAppPrint(...)
#define emberAfAppPrintln(...)
#define emberAfAppFlush()
#define emberAfAppPrintBuffer(buffer, len, withSpace)
#define emberAfAppPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APP)

// Printing macros for Attributes
// Prints messages related to attributes
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ATTRIBUTES)
#define emberAfAttributesPrint(...) emberAfPrint(EMBER_AF_PRINT_ATTRIBUTES, __VA_ARGS__)
#define emberAfAttributesPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ATTRIBUTES, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.
#define emberAfAttributesFlush()
#define emberAfAttributesPrintBuffer(buffer, len, withSpace)                                                                       \
    emberAfPrintBuffer(EMBER_AF_PRINT_ATTRIBUTES, (buffer), (len), (withSpace))
#define emberAfAttributesPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_ATTRIBUTES, (buffer))
#else
#define emberAfAttributesPrint(...)
#define emberAfAttributesPrintln(...)
#define emberAfAttributesFlush()
#define emberAfAttributesPrintBuffer(buffer, len, withSpace)
#define emberAfAttributesPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ATTRIBUTES)

// Printing macros for Registration
// Prints messages related to registration
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_REGISTRATION)
#define emberAfRegistrationPrint(...) emberAfPrint(EMBER_AF_PRINT_REGISTRATION, __VA_ARGS__)
#define emberAfRegistrationPrintln(...) emberAfPrintln(EMBER_AF_PRINT_REGISTRATION, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.
#define emberAfRegistrationFlush()
#define emberAfRegistrationPrintBuffer(buffer, len, withSpace)                                                                     \
    emberAfPrintBuffer(EMBER_AF_PRINT_REGISTRATION, (buffer), (len), (withSpace))
#define emberAfRegistrationPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_REGISTRATION, (buffer))
#else
#define emberAfRegistrationPrint(...)
#define emberAfRegistrationPrintln(...)
#define emberAfRegistrationFlush()
#define emberAfRegistrationPrintBuffer(buffer, len, withSpace)
#define emberAfRegistrationPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_REGISTRATION)

// Printing macros for ZDO (ZigBee Device Object)
// Prints messages related to ZDO functionality
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ZDO)
#define emberAfZdoPrint(...) emberAfPrint(EMBER_AF_PRINT_ZDO, __VA_ARGS__)
#define emberAfZdoPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ZDO, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.
#define emberAfZdoFlush()
#define emberAfZdoPrintBuffer(buffer, len, withSpace) emberAfPrintBuffer(EMBER_AF_PRINT_ZDO, (buffer), (len), (withSpace))
#define emberAfZdoPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_ZDO, (buffer))
#else
#define emberAfZdoPrint(...)
#define emberAfZdoPrintln(...)
#define emberAfZdoFlush()
#define emberAfZdoPrintBuffer(buffer, len, withSpace)
#define emberAfZdoPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ZDO)

// Printing macros for Custom messages (1)
// Messages that can be used by the end developer
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CUSTOM1)
#define emberAfCustom1Print(...) emberAfPrint(EMBER_AF_PRINT_CUSTOM1, __VA_ARGS__)
#define emberAfCustom1Println(...) emberAfPrintln(EMBER_AF_PRINT_CUSTOM1, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.
#define emberAfCustom1Flush()
#define emberAfCustom1PrintBuffer(buffer, len, withSpace) emberAfPrintBuffer(EMBER_AF_PRINT_CUSTOM1, (buffer), (len), (withSpace))
#define emberAfCustom1PrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_CUSTOM1, (buffer))
#else
#define emberAfCustom1Print(...)
#define emberAfCustom1Println(...)
#define emberAfCustom1Flush()
#define emberAfCustom1PrintBuffer(buffer, len, withSpace)
#define emberAfCustom1PrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CUSTOM1)

// Printing macros for Custom messages (2)
// Messages that can be used by the end developer
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CUSTOM2)
#define emberAfCustom2Print(...) emberAfPrint(EMBER_AF_PRINT_CUSTOM2, __VA_ARGS__)
#define emberAfCustom2Println(...) emberAfPrintln(EMBER_AF_PRINT_CUSTOM2, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.
#define emberAfCustom2Flush()
#define emberAfCustom2PrintBuffer(buffer, len, withSpace) emberAfPrintBuffer(EMBER_AF_PRINT_CUSTOM2, (buffer), (len), (withSpace))
#define emberAfCustom2PrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_CUSTOM2, (buffer))
#else
#define emberAfCustom2Print(...)
#define emberAfCustom2Println(...)
#define emberAfCustom2Flush()
#define emberAfCustom2PrintBuffer(buffer, len, withSpace)
#define emberAfCustom2PrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CUSTOM2)

// Printing macros for cluster: Account Login
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ACCOUNT_LOGIN_CLUSTER)
#define emberAfAccountLoginClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_ACCOUNT_LOGIN_CLUSTER, __VA_ARGS__)
#define emberAfAccountLoginClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_ACCOUNT_LOGIN_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfAccountLoginClusterPrintBuffer(buffer, len, withSpace)                                                              \
    emberAfPrintBuffer(EMBER_AF_PRINT_ACCOUNT_LOGIN_CLUSTER, (buffer), (len), (withSpace))
#define emberAfAccountLoginClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_ACCOUNT_LOGIN_CLUSTER, (buffer))
#else
#define emberAfAccountLoginClusterPrint(...)
#define emberAfAccountLoginClusterPrintln(...)

#define emberAfAccountLoginClusterPrintBuffer(buffer, len, withSpace)
#define emberAfAccountLoginClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_ACCOUNT_LOGIN_CLUSTER)

// Printing macros for cluster: Media Playback
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_MEDIA_PLAYBACK_CLUSTER)
#define emberAfMediaPlaybackClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_MEDIA_PLAYBACK_CLUSTER, __VA_ARGS__)
#define emberAfMediaPlaybackClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_MEDIA_PLAYBACK_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfMediaPlaybackClusterPrintBuffer(buffer, len, withSpace)                                                             \
    emberAfPrintBuffer(EMBER_AF_PRINT_MEDIA_PLAYBACK_CLUSTER, (buffer), (len), (withSpace))
#define emberAfMediaPlaybackClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_MEDIA_PLAYBACK_CLUSTER, (buffer))
#else
#define emberAfMediaPlaybackClusterPrint(...)
#define emberAfMediaPlaybackClusterPrintln(...)

#define emberAfMediaPlaybackClusterPrintBuffer(buffer, len, withSpace)
#define emberAfMediaPlaybackClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_MEDIA_PLAYBACK_CLUSTER)

// Printing macros for Custom messages (3)
// Messages that can be used by the end developer
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CUSTOM3)
#define emberAfCustom3Print(...) emberAfPrint(EMBER_AF_PRINT_CUSTOM3, __VA_ARGS__)
#define emberAfCustom3Println(...) emberAfPrintln(EMBER_AF_PRINT_CUSTOM3, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.
#define emberAfCustom3Flush()
#define emberAfCustom3PrintBuffer(buffer, len, withSpace) emberAfPrintBuffer(EMBER_AF_PRINT_CUSTOM3, (buffer), (len), (withSpace))
#define emberAfCustom3PrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_CUSTOM3, (buffer))
#else
#define emberAfCustom3Print(...)
#define emberAfCustom3Println(...)
#define emberAfCustom3Flush()
#define emberAfCustom3PrintBuffer(buffer, len, withSpace)
#define emberAfCustom3PrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CUSTOM3)

// Printing macros for cluster: Application Launcher
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLICATION_LAUNCHER_CLUSTER)
#define emberAfApplicationLauncherClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_APPLICATION_LAUNCHER_CLUSTER, __VA_ARGS__)
#define emberAfApplicationLauncherClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_APPLICATION_LAUNCHER_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfApplicationLauncherClusterPrintBuffer(buffer, len, withSpace)                                                       \
    emberAfPrintBuffer(EMBER_AF_PRINT_APPLICATION_LAUNCHER_CLUSTER, (buffer), (len), (withSpace))
#define emberAfApplicationLauncherClusterPrintString(buffer)                                                                       \
    emberAfPrintString(EMBER_AF_PRINT_APPLICATION_LAUNCHER_CLUSTER, (buffer))
#else
#define emberAfApplicationLauncherClusterPrint(...)
#define emberAfApplicationLauncherClusterPrintln(...)

#define emberAfApplicationLauncherClusterPrintBuffer(buffer, len, withSpace)
#define emberAfApplicationLauncherClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_APPLICATION_LAUNCHER_CLUSTER)

// Printing macros for cluster: Audio Output
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_AUDIO_OUTPUT_CLUSTER)
#define emberAfAudioOutputClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_AUDIO_OUTPUT_CLUSTER, __VA_ARGS__)
#define emberAfAudioOutputClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_AUDIO_OUTPUT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfAudioOutputClusterPrintBuffer(buffer, len, withSpace)                                                               \
    emberAfPrintBuffer(EMBER_AF_PRINT_AUDIO_OUTPUT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfAudioOutputClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_AUDIO_OUTPUT_CLUSTER, (buffer))
#else
#define emberAfAudioOutputClusterPrint(...)
#define emberAfAudioOutputClusterPrintln(...)

#define emberAfAudioOutputClusterPrintBuffer(buffer, len, withSpace)
#define emberAfAudioOutputClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_AUDIO_OUTPUT_CLUSTER)

// Printing macros for cluster: Keypad Input
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_KEYPAD_INPUT_CLUSTER)
#define emberAfKeypadInputClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_KEYPAD_INPUT_CLUSTER, __VA_ARGS__)
#define emberAfKeypadInputClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_KEYPAD_INPUT_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfKeypadInputClusterPrintBuffer(buffer, len, withSpace)                                                               \
    emberAfPrintBuffer(EMBER_AF_PRINT_KEYPAD_INPUT_CLUSTER, (buffer), (len), (withSpace))
#define emberAfKeypadInputClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_KEYPAD_INPUT_CLUSTER, (buffer))
#else
#define emberAfKeypadInputClusterPrint(...)
#define emberAfKeypadInputClusterPrintln(...)

#define emberAfKeypadInputClusterPrintBuffer(buffer, len, withSpace)
#define emberAfKeypadInputClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_KEYPAD_INPUT_CLUSTER)

// Printing macros for cluster: Content Launcher
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CONTENT_LAUNCHER_CLUSTER)
#define emberAfContentLauncherClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_CONTENT_LAUNCHER_CLUSTER, __VA_ARGS__)
#define emberAfContentLauncherClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_CONTENT_LAUNCHER_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfContentLauncherClusterPrintBuffer(buffer, len, withSpace)                                                           \
    emberAfPrintBuffer(EMBER_AF_PRINT_CONTENT_LAUNCHER_CLUSTER, (buffer), (len), (withSpace))
#define emberAfContentLauncherClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_CONTENT_LAUNCHER_CLUSTER, (buffer))
#else
#define emberAfContentLauncherClusterPrint(...)
#define emberAfContentLauncherClusterPrintln(...)

#define emberAfContentLauncherClusterPrintBuffer(buffer, len, withSpace)
#define emberAfContentLauncherClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_CONTENT_LAUNCHER_CLUSTER)

// Printing macros for cluster: Target Navigator
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TARGET_NAVIGATOR_CLUSTER)
#define emberAfTargetNavigatorClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_TARGET_NAVIGATOR_CLUSTER, __VA_ARGS__)
#define emberAfTargetNavigatorClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_TARGET_NAVIGATOR_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfTargetNavigatorClusterPrintBuffer(buffer, len, withSpace)                                                           \
    emberAfPrintBuffer(EMBER_AF_PRINT_TARGET_NAVIGATOR_CLUSTER, (buffer), (len), (withSpace))
#define emberAfTargetNavigatorClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_TARGET_NAVIGATOR_CLUSTER, (buffer))
#else
#define emberAfTargetNavigatorClusterPrint(...)
#define emberAfTargetNavigatorClusterPrintln(...)

#define emberAfTargetNavigatorClusterPrintBuffer(buffer, len, withSpace)
#define emberAfTargetNavigatorClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_TARGET_NAVIGATOR_CLUSTER)

// Printing macros for cluster: Wake on LAN
#if defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_WAKE_ON_LAN_CLUSTER)
#define emberAfWakeOnLanClusterPrint(...) emberAfPrint(EMBER_AF_PRINT_WAKE_ON_LAN_CLUSTER, __VA_ARGS__)
#define emberAfWakeOnLanClusterPrintln(...) emberAfPrintln(EMBER_AF_PRINT_WAKE_ON_LAN_CLUSTER, __VA_ARGS__)
// Blocking IO is enabled for all serial ports, therefore flush calls are unnecessary.

#define emberAfWakeOnLanClusterPrintBuffer(buffer, len, withSpace)                                                                 \
    emberAfPrintBuffer(EMBER_AF_PRINT_WAKE_ON_LAN_CLUSTER, (buffer), (len), (withSpace))
#define emberAfWakeOnLanClusterPrintString(buffer) emberAfPrintString(EMBER_AF_PRINT_WAKE_ON_LAN_CLUSTER, (buffer))
#else
#define emberAfWakeOnLanClusterPrint(...)
#define emberAfWakeOnLanClusterPrintln(...)

#define emberAfWakeOnLanClusterPrintBuffer(buffer, len, withSpace)
#define emberAfWakeOnLanClusterPrintString(buffer)
#endif // defined(EMBER_AF_PRINT_ENABLE) && defined(EMBER_AF_PRINT_WAKE_ON_LAN_CLUSTER)
