/*
 *
 *    Copyright (c) 2023 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */
package chip.devicecontroller;

import chip.clusterinfo.CommandParameterInfo;
import chip.clusterinfo.InteractionInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ClusterReadMapping {


    private static Map<String, InteractionInfo> readIdentifyInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readIdentifyIdentifyTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIdentifyIdentifyTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IdentifyCluster) cluster).readIdentifyTimeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIdentifyIdentifyTimeCommandParams
        );
        result.put("readIdentifyTimeAttribute", readIdentifyIdentifyTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIdentifyIdentifyTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIdentifyIdentifyTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IdentifyCluster) cluster).readIdentifyTypeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIdentifyIdentifyTypeCommandParams
        );
        result.put("readIdentifyTypeAttribute", readIdentifyIdentifyTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIdentifyGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIdentifyGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IdentifyCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.IdentifyCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIdentifyClusterGeneratedCommandListAttributeCallback(),
          readIdentifyGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readIdentifyGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIdentifyAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIdentifyAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IdentifyCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.IdentifyCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIdentifyClusterAcceptedCommandListAttributeCallback(),
          readIdentifyAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readIdentifyAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIdentifyEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIdentifyEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IdentifyCluster) cluster).readEventListAttribute(
              (ChipClusters.IdentifyCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIdentifyClusterEventListAttributeCallback(),
          readIdentifyEventListCommandParams
        );
        result.put("readEventListAttribute", readIdentifyEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIdentifyAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIdentifyAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IdentifyCluster) cluster).readAttributeListAttribute(
              (ChipClusters.IdentifyCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIdentifyClusterAttributeListAttributeCallback(),
          readIdentifyAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readIdentifyAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIdentifyFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIdentifyFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IdentifyCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readIdentifyFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readIdentifyFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIdentifyClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIdentifyClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IdentifyCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIdentifyClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readIdentifyClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readGroupsInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readGroupsNameSupportCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupsNameSupportAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupsCluster) cluster).readNameSupportAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readGroupsNameSupportCommandParams
        );
        result.put("readNameSupportAttribute", readGroupsNameSupportAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupsGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupsGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupsCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.GroupsCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGroupsClusterGeneratedCommandListAttributeCallback(),
          readGroupsGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readGroupsGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupsAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupsAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupsCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.GroupsCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGroupsClusterAcceptedCommandListAttributeCallback(),
          readGroupsAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readGroupsAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupsEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupsEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupsCluster) cluster).readEventListAttribute(
              (ChipClusters.GroupsCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGroupsClusterEventListAttributeCallback(),
          readGroupsEventListCommandParams
        );
        result.put("readEventListAttribute", readGroupsEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupsAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupsAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupsCluster) cluster).readAttributeListAttribute(
              (ChipClusters.GroupsCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGroupsClusterAttributeListAttributeCallback(),
          readGroupsAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readGroupsAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupsFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupsFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupsCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readGroupsFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readGroupsFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupsClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupsClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupsCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readGroupsClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readGroupsClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readScenesInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readScenesSceneCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesSceneCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readSceneCountAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readScenesSceneCountCommandParams
        );
        result.put("readSceneCountAttribute", readScenesSceneCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesCurrentSceneCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesCurrentSceneAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readCurrentSceneAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readScenesCurrentSceneCommandParams
        );
        result.put("readCurrentSceneAttribute", readScenesCurrentSceneAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesCurrentGroupCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesCurrentGroupAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readCurrentGroupAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readScenesCurrentGroupCommandParams
        );
        result.put("readCurrentGroupAttribute", readScenesCurrentGroupAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesSceneValidCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesSceneValidAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readSceneValidAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readScenesSceneValidCommandParams
        );
        result.put("readSceneValidAttribute", readScenesSceneValidAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesNameSupportCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesNameSupportAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readNameSupportAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readScenesNameSupportCommandParams
        );
        result.put("readNameSupportAttribute", readScenesNameSupportAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesLastConfiguredByCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesLastConfiguredByAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readLastConfiguredByAttribute(
              (ChipClusters.ScenesCluster.LastConfiguredByAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedScenesClusterLastConfiguredByAttributeCallback(),
          readScenesLastConfiguredByCommandParams
        );
        result.put("readLastConfiguredByAttribute", readScenesLastConfiguredByAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesSceneTableSizeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesSceneTableSizeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readSceneTableSizeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readScenesSceneTableSizeCommandParams
        );
        result.put("readSceneTableSizeAttribute", readScenesSceneTableSizeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesRemainingCapacityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesRemainingCapacityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readRemainingCapacityAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readScenesRemainingCapacityCommandParams
        );
        result.put("readRemainingCapacityAttribute", readScenesRemainingCapacityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ScenesCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedScenesClusterGeneratedCommandListAttributeCallback(),
          readScenesGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readScenesGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ScenesCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedScenesClusterAcceptedCommandListAttributeCallback(),
          readScenesAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readScenesAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readEventListAttribute(
              (ChipClusters.ScenesCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedScenesClusterEventListAttributeCallback(),
          readScenesEventListCommandParams
        );
        result.put("readEventListAttribute", readScenesEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ScenesCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedScenesClusterAttributeListAttributeCallback(),
          readScenesAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readScenesAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readScenesFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readScenesFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readScenesClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readScenesClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ScenesCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readScenesClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readScenesClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readOnOffInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readOnOffOnOffCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffOnOffAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffCluster) cluster).readOnOffAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readOnOffOnOffCommandParams
        );
        result.put("readOnOffAttribute", readOnOffOnOffAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffGlobalSceneControlCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffGlobalSceneControlAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffCluster) cluster).readGlobalSceneControlAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readOnOffGlobalSceneControlCommandParams
        );
        result.put("readGlobalSceneControlAttribute", readOnOffGlobalSceneControlAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffOnTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffOnTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffCluster) cluster).readOnTimeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOnOffOnTimeCommandParams
        );
        result.put("readOnTimeAttribute", readOnOffOnTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffOffWaitTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffOffWaitTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffCluster) cluster).readOffWaitTimeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOnOffOffWaitTimeCommandParams
        );
        result.put("readOffWaitTimeAttribute", readOnOffOffWaitTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffStartUpOnOffCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffStartUpOnOffAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffCluster) cluster).readStartUpOnOffAttribute(
              (ChipClusters.OnOffCluster.StartUpOnOffAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOnOffClusterStartUpOnOffAttributeCallback(),
          readOnOffStartUpOnOffCommandParams
        );
        result.put("readStartUpOnOffAttribute", readOnOffStartUpOnOffAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.OnOffCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOnOffClusterGeneratedCommandListAttributeCallback(),
          readOnOffGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readOnOffGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.OnOffCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOnOffClusterAcceptedCommandListAttributeCallback(),
          readOnOffAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readOnOffAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffCluster) cluster).readEventListAttribute(
              (ChipClusters.OnOffCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOnOffClusterEventListAttributeCallback(),
          readOnOffEventListCommandParams
        );
        result.put("readEventListAttribute", readOnOffEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffCluster) cluster).readAttributeListAttribute(
              (ChipClusters.OnOffCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOnOffClusterAttributeListAttributeCallback(),
          readOnOffAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readOnOffAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOnOffFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readOnOffFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOnOffClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readOnOffClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readOnOffSwitchConfigurationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readOnOffSwitchConfigurationSwitchTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffSwitchConfigurationSwitchTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffSwitchConfigurationCluster) cluster).readSwitchTypeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOnOffSwitchConfigurationSwitchTypeCommandParams
        );
        result.put("readSwitchTypeAttribute", readOnOffSwitchConfigurationSwitchTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffSwitchConfigurationSwitchActionsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffSwitchConfigurationSwitchActionsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffSwitchConfigurationCluster) cluster).readSwitchActionsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOnOffSwitchConfigurationSwitchActionsCommandParams
        );
        result.put("readSwitchActionsAttribute", readOnOffSwitchConfigurationSwitchActionsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffSwitchConfigurationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffSwitchConfigurationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffSwitchConfigurationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.OnOffSwitchConfigurationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOnOffSwitchConfigurationClusterGeneratedCommandListAttributeCallback(),
          readOnOffSwitchConfigurationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readOnOffSwitchConfigurationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffSwitchConfigurationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffSwitchConfigurationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffSwitchConfigurationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.OnOffSwitchConfigurationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOnOffSwitchConfigurationClusterAcceptedCommandListAttributeCallback(),
          readOnOffSwitchConfigurationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readOnOffSwitchConfigurationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffSwitchConfigurationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffSwitchConfigurationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffSwitchConfigurationCluster) cluster).readEventListAttribute(
              (ChipClusters.OnOffSwitchConfigurationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOnOffSwitchConfigurationClusterEventListAttributeCallback(),
          readOnOffSwitchConfigurationEventListCommandParams
        );
        result.put("readEventListAttribute", readOnOffSwitchConfigurationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffSwitchConfigurationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffSwitchConfigurationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffSwitchConfigurationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.OnOffSwitchConfigurationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOnOffSwitchConfigurationClusterAttributeListAttributeCallback(),
          readOnOffSwitchConfigurationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readOnOffSwitchConfigurationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffSwitchConfigurationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffSwitchConfigurationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffSwitchConfigurationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOnOffSwitchConfigurationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readOnOffSwitchConfigurationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOnOffSwitchConfigurationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOnOffSwitchConfigurationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OnOffSwitchConfigurationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOnOffSwitchConfigurationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readOnOffSwitchConfigurationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readLevelControlInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readLevelControlCurrentLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlCurrentLevelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readCurrentLevelAttribute(
              (ChipClusters.LevelControlCluster.CurrentLevelAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLevelControlClusterCurrentLevelAttributeCallback(),
          readLevelControlCurrentLevelCommandParams
        );
        result.put("readCurrentLevelAttribute", readLevelControlCurrentLevelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlRemainingTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlRemainingTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readRemainingTimeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readLevelControlRemainingTimeCommandParams
        );
        result.put("readRemainingTimeAttribute", readLevelControlRemainingTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlMinLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlMinLevelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readMinLevelAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readLevelControlMinLevelCommandParams
        );
        result.put("readMinLevelAttribute", readLevelControlMinLevelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlMaxLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlMaxLevelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readMaxLevelAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readLevelControlMaxLevelCommandParams
        );
        result.put("readMaxLevelAttribute", readLevelControlMaxLevelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlCurrentFrequencyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlCurrentFrequencyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readCurrentFrequencyAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readLevelControlCurrentFrequencyCommandParams
        );
        result.put("readCurrentFrequencyAttribute", readLevelControlCurrentFrequencyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlMinFrequencyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlMinFrequencyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readMinFrequencyAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readLevelControlMinFrequencyCommandParams
        );
        result.put("readMinFrequencyAttribute", readLevelControlMinFrequencyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlMaxFrequencyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlMaxFrequencyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readMaxFrequencyAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readLevelControlMaxFrequencyCommandParams
        );
        result.put("readMaxFrequencyAttribute", readLevelControlMaxFrequencyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlOptionsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlOptionsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readOptionsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readLevelControlOptionsCommandParams
        );
        result.put("readOptionsAttribute", readLevelControlOptionsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlOnOffTransitionTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlOnOffTransitionTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readOnOffTransitionTimeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readLevelControlOnOffTransitionTimeCommandParams
        );
        result.put("readOnOffTransitionTimeAttribute", readLevelControlOnOffTransitionTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlOnLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlOnLevelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readOnLevelAttribute(
              (ChipClusters.LevelControlCluster.OnLevelAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLevelControlClusterOnLevelAttributeCallback(),
          readLevelControlOnLevelCommandParams
        );
        result.put("readOnLevelAttribute", readLevelControlOnLevelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlOnTransitionTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlOnTransitionTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readOnTransitionTimeAttribute(
              (ChipClusters.LevelControlCluster.OnTransitionTimeAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLevelControlClusterOnTransitionTimeAttributeCallback(),
          readLevelControlOnTransitionTimeCommandParams
        );
        result.put("readOnTransitionTimeAttribute", readLevelControlOnTransitionTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlOffTransitionTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlOffTransitionTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readOffTransitionTimeAttribute(
              (ChipClusters.LevelControlCluster.OffTransitionTimeAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLevelControlClusterOffTransitionTimeAttributeCallback(),
          readLevelControlOffTransitionTimeCommandParams
        );
        result.put("readOffTransitionTimeAttribute", readLevelControlOffTransitionTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlDefaultMoveRateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlDefaultMoveRateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readDefaultMoveRateAttribute(
              (ChipClusters.LevelControlCluster.DefaultMoveRateAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLevelControlClusterDefaultMoveRateAttributeCallback(),
          readLevelControlDefaultMoveRateCommandParams
        );
        result.put("readDefaultMoveRateAttribute", readLevelControlDefaultMoveRateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlStartUpCurrentLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlStartUpCurrentLevelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readStartUpCurrentLevelAttribute(
              (ChipClusters.LevelControlCluster.StartUpCurrentLevelAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLevelControlClusterStartUpCurrentLevelAttributeCallback(),
          readLevelControlStartUpCurrentLevelCommandParams
        );
        result.put("readStartUpCurrentLevelAttribute", readLevelControlStartUpCurrentLevelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.LevelControlCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLevelControlClusterGeneratedCommandListAttributeCallback(),
          readLevelControlGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readLevelControlGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.LevelControlCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLevelControlClusterAcceptedCommandListAttributeCallback(),
          readLevelControlAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readLevelControlAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readEventListAttribute(
              (ChipClusters.LevelControlCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLevelControlClusterEventListAttributeCallback(),
          readLevelControlEventListCommandParams
        );
        result.put("readEventListAttribute", readLevelControlEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readAttributeListAttribute(
              (ChipClusters.LevelControlCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLevelControlClusterAttributeListAttributeCallback(),
          readLevelControlAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readLevelControlAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readLevelControlFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readLevelControlFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLevelControlClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLevelControlClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LevelControlCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readLevelControlClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readLevelControlClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readBinaryInputBasicInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readBinaryInputBasicActiveTextCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicActiveTextAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readActiveTextAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBinaryInputBasicActiveTextCommandParams
        );
        result.put("readActiveTextAttribute", readBinaryInputBasicActiveTextAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicDescriptionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicDescriptionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readDescriptionAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBinaryInputBasicDescriptionCommandParams
        );
        result.put("readDescriptionAttribute", readBinaryInputBasicDescriptionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicInactiveTextCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicInactiveTextAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readInactiveTextAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBinaryInputBasicInactiveTextCommandParams
        );
        result.put("readInactiveTextAttribute", readBinaryInputBasicInactiveTextAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicOutOfServiceCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicOutOfServiceAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readOutOfServiceAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readBinaryInputBasicOutOfServiceCommandParams
        );
        result.put("readOutOfServiceAttribute", readBinaryInputBasicOutOfServiceAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicPolarityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicPolarityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readPolarityAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBinaryInputBasicPolarityCommandParams
        );
        result.put("readPolarityAttribute", readBinaryInputBasicPolarityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicPresentValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicPresentValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readPresentValueAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readBinaryInputBasicPresentValueCommandParams
        );
        result.put("readPresentValueAttribute", readBinaryInputBasicPresentValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicReliabilityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicReliabilityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readReliabilityAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBinaryInputBasicReliabilityCommandParams
        );
        result.put("readReliabilityAttribute", readBinaryInputBasicReliabilityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicStatusFlagsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicStatusFlagsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readStatusFlagsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBinaryInputBasicStatusFlagsCommandParams
        );
        result.put("readStatusFlagsAttribute", readBinaryInputBasicStatusFlagsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicApplicationTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicApplicationTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readApplicationTypeAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readBinaryInputBasicApplicationTypeCommandParams
        );
        result.put("readApplicationTypeAttribute", readBinaryInputBasicApplicationTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.BinaryInputBasicCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBinaryInputBasicClusterGeneratedCommandListAttributeCallback(),
          readBinaryInputBasicGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readBinaryInputBasicGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.BinaryInputBasicCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBinaryInputBasicClusterAcceptedCommandListAttributeCallback(),
          readBinaryInputBasicAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readBinaryInputBasicAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readEventListAttribute(
              (ChipClusters.BinaryInputBasicCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBinaryInputBasicClusterEventListAttributeCallback(),
          readBinaryInputBasicEventListCommandParams
        );
        result.put("readEventListAttribute", readBinaryInputBasicEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readAttributeListAttribute(
              (ChipClusters.BinaryInputBasicCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBinaryInputBasicClusterAttributeListAttributeCallback(),
          readBinaryInputBasicAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readBinaryInputBasicAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readBinaryInputBasicFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readBinaryInputBasicFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBinaryInputBasicClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBinaryInputBasicClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BinaryInputBasicCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBinaryInputBasicClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readBinaryInputBasicClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readPulseWidthModulationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readPulseWidthModulationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPulseWidthModulationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PulseWidthModulationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.PulseWidthModulationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPulseWidthModulationClusterGeneratedCommandListAttributeCallback(),
          readPulseWidthModulationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readPulseWidthModulationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPulseWidthModulationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPulseWidthModulationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PulseWidthModulationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.PulseWidthModulationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPulseWidthModulationClusterAcceptedCommandListAttributeCallback(),
          readPulseWidthModulationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readPulseWidthModulationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPulseWidthModulationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPulseWidthModulationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PulseWidthModulationCluster) cluster).readEventListAttribute(
              (ChipClusters.PulseWidthModulationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPulseWidthModulationClusterEventListAttributeCallback(),
          readPulseWidthModulationEventListCommandParams
        );
        result.put("readEventListAttribute", readPulseWidthModulationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPulseWidthModulationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPulseWidthModulationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PulseWidthModulationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.PulseWidthModulationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPulseWidthModulationClusterAttributeListAttributeCallback(),
          readPulseWidthModulationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readPulseWidthModulationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPulseWidthModulationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPulseWidthModulationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PulseWidthModulationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readPulseWidthModulationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readPulseWidthModulationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPulseWidthModulationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPulseWidthModulationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PulseWidthModulationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPulseWidthModulationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readPulseWidthModulationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readDescriptorInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readDescriptorDeviceTypeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDescriptorDeviceTypeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DescriptorCluster) cluster).readDeviceTypeListAttribute(
              (ChipClusters.DescriptorCluster.DeviceTypeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDescriptorClusterDeviceTypeListAttributeCallback(),
          readDescriptorDeviceTypeListCommandParams
        );
        result.put("readDeviceTypeListAttribute", readDescriptorDeviceTypeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDescriptorServerListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDescriptorServerListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DescriptorCluster) cluster).readServerListAttribute(
              (ChipClusters.DescriptorCluster.ServerListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDescriptorClusterServerListAttributeCallback(),
          readDescriptorServerListCommandParams
        );
        result.put("readServerListAttribute", readDescriptorServerListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDescriptorClientListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDescriptorClientListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DescriptorCluster) cluster).readClientListAttribute(
              (ChipClusters.DescriptorCluster.ClientListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDescriptorClusterClientListAttributeCallback(),
          readDescriptorClientListCommandParams
        );
        result.put("readClientListAttribute", readDescriptorClientListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDescriptorPartsListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDescriptorPartsListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DescriptorCluster) cluster).readPartsListAttribute(
              (ChipClusters.DescriptorCluster.PartsListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDescriptorClusterPartsListAttributeCallback(),
          readDescriptorPartsListCommandParams
        );
        result.put("readPartsListAttribute", readDescriptorPartsListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDescriptorGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDescriptorGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DescriptorCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.DescriptorCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDescriptorClusterGeneratedCommandListAttributeCallback(),
          readDescriptorGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readDescriptorGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDescriptorAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDescriptorAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DescriptorCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.DescriptorCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDescriptorClusterAcceptedCommandListAttributeCallback(),
          readDescriptorAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readDescriptorAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDescriptorEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDescriptorEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DescriptorCluster) cluster).readEventListAttribute(
              (ChipClusters.DescriptorCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDescriptorClusterEventListAttributeCallback(),
          readDescriptorEventListCommandParams
        );
        result.put("readEventListAttribute", readDescriptorEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDescriptorAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDescriptorAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DescriptorCluster) cluster).readAttributeListAttribute(
              (ChipClusters.DescriptorCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDescriptorClusterAttributeListAttributeCallback(),
          readDescriptorAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readDescriptorAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDescriptorFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDescriptorFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DescriptorCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readDescriptorFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readDescriptorFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDescriptorClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDescriptorClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DescriptorCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDescriptorClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readDescriptorClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readBindingInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readBindingBindingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBindingBindingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BindingCluster) cluster).readBindingAttribute(
              (ChipClusters.BindingCluster.BindingAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBindingClusterBindingAttributeCallback(),
          readBindingBindingCommandParams
        );
        result.put("readBindingAttribute", readBindingBindingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBindingGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBindingGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BindingCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.BindingCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBindingClusterGeneratedCommandListAttributeCallback(),
          readBindingGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readBindingGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBindingAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBindingAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BindingCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.BindingCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBindingClusterAcceptedCommandListAttributeCallback(),
          readBindingAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readBindingAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBindingEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBindingEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BindingCluster) cluster).readEventListAttribute(
              (ChipClusters.BindingCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBindingClusterEventListAttributeCallback(),
          readBindingEventListCommandParams
        );
        result.put("readEventListAttribute", readBindingEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBindingAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBindingAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BindingCluster) cluster).readAttributeListAttribute(
              (ChipClusters.BindingCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBindingClusterAttributeListAttributeCallback(),
          readBindingAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readBindingAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBindingFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBindingFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BindingCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readBindingFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readBindingFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBindingClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBindingClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BindingCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBindingClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readBindingClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readAccessControlInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readAccessControlAclCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAccessControlAclAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AccessControlCluster) cluster).readAclAttribute(
              (ChipClusters.AccessControlCluster.AclAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAccessControlClusterAclAttributeCallback(),
          readAccessControlAclCommandParams
        );
        result.put("readAclAttribute", readAccessControlAclAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAccessControlExtensionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAccessControlExtensionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AccessControlCluster) cluster).readExtensionAttribute(
              (ChipClusters.AccessControlCluster.ExtensionAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAccessControlClusterExtensionAttributeCallback(),
          readAccessControlExtensionCommandParams
        );
        result.put("readExtensionAttribute", readAccessControlExtensionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAccessControlSubjectsPerAccessControlEntryCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAccessControlSubjectsPerAccessControlEntryAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AccessControlCluster) cluster).readSubjectsPerAccessControlEntryAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readAccessControlSubjectsPerAccessControlEntryCommandParams
        );
        result.put("readSubjectsPerAccessControlEntryAttribute", readAccessControlSubjectsPerAccessControlEntryAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAccessControlTargetsPerAccessControlEntryCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAccessControlTargetsPerAccessControlEntryAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AccessControlCluster) cluster).readTargetsPerAccessControlEntryAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readAccessControlTargetsPerAccessControlEntryCommandParams
        );
        result.put("readTargetsPerAccessControlEntryAttribute", readAccessControlTargetsPerAccessControlEntryAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAccessControlAccessControlEntriesPerFabricCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAccessControlAccessControlEntriesPerFabricAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AccessControlCluster) cluster).readAccessControlEntriesPerFabricAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readAccessControlAccessControlEntriesPerFabricCommandParams
        );
        result.put("readAccessControlEntriesPerFabricAttribute", readAccessControlAccessControlEntriesPerFabricAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAccessControlGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAccessControlGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AccessControlCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.AccessControlCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAccessControlClusterGeneratedCommandListAttributeCallback(),
          readAccessControlGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readAccessControlGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAccessControlAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAccessControlAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AccessControlCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.AccessControlCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAccessControlClusterAcceptedCommandListAttributeCallback(),
          readAccessControlAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readAccessControlAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAccessControlEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAccessControlEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AccessControlCluster) cluster).readEventListAttribute(
              (ChipClusters.AccessControlCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAccessControlClusterEventListAttributeCallback(),
          readAccessControlEventListCommandParams
        );
        result.put("readEventListAttribute", readAccessControlEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAccessControlAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAccessControlAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AccessControlCluster) cluster).readAttributeListAttribute(
              (ChipClusters.AccessControlCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAccessControlClusterAttributeListAttributeCallback(),
          readAccessControlAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readAccessControlAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAccessControlFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAccessControlFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AccessControlCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readAccessControlFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readAccessControlFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAccessControlClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAccessControlClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AccessControlCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readAccessControlClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readAccessControlClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readActionsInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readActionsActionListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActionsActionListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActionsCluster) cluster).readActionListAttribute(
              (ChipClusters.ActionsCluster.ActionListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedActionsClusterActionListAttributeCallback(),
          readActionsActionListCommandParams
        );
        result.put("readActionListAttribute", readActionsActionListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActionsEndpointListsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActionsEndpointListsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActionsCluster) cluster).readEndpointListsAttribute(
              (ChipClusters.ActionsCluster.EndpointListsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedActionsClusterEndpointListsAttributeCallback(),
          readActionsEndpointListsCommandParams
        );
        result.put("readEndpointListsAttribute", readActionsEndpointListsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActionsSetupURLCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActionsSetupURLAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActionsCluster) cluster).readSetupURLAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readActionsSetupURLCommandParams
        );
        result.put("readSetupURLAttribute", readActionsSetupURLAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActionsGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActionsGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActionsCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ActionsCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedActionsClusterGeneratedCommandListAttributeCallback(),
          readActionsGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readActionsGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActionsAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActionsAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActionsCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ActionsCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedActionsClusterAcceptedCommandListAttributeCallback(),
          readActionsAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readActionsAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActionsEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActionsEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActionsCluster) cluster).readEventListAttribute(
              (ChipClusters.ActionsCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedActionsClusterEventListAttributeCallback(),
          readActionsEventListCommandParams
        );
        result.put("readEventListAttribute", readActionsEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActionsAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActionsAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActionsCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ActionsCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedActionsClusterAttributeListAttributeCallback(),
          readActionsAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readActionsAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActionsFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActionsFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActionsCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readActionsFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readActionsFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActionsClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActionsClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActionsCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readActionsClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readActionsClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readBasicInformationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readBasicInformationDataModelRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationDataModelRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readDataModelRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBasicInformationDataModelRevisionCommandParams
        );
        result.put("readDataModelRevisionAttribute", readBasicInformationDataModelRevisionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationVendorNameCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationVendorNameAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readVendorNameAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationVendorNameCommandParams
        );
        result.put("readVendorNameAttribute", readBasicInformationVendorNameAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationVendorIDCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationVendorIDAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readVendorIDAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBasicInformationVendorIDCommandParams
        );
        result.put("readVendorIDAttribute", readBasicInformationVendorIDAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationProductNameCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationProductNameAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readProductNameAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationProductNameCommandParams
        );
        result.put("readProductNameAttribute", readBasicInformationProductNameAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationProductIDCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationProductIDAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readProductIDAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBasicInformationProductIDCommandParams
        );
        result.put("readProductIDAttribute", readBasicInformationProductIDAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationNodeLabelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationNodeLabelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readNodeLabelAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationNodeLabelCommandParams
        );
        result.put("readNodeLabelAttribute", readBasicInformationNodeLabelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationLocationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationLocationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readLocationAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationLocationCommandParams
        );
        result.put("readLocationAttribute", readBasicInformationLocationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationHardwareVersionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationHardwareVersionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readHardwareVersionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBasicInformationHardwareVersionCommandParams
        );
        result.put("readHardwareVersionAttribute", readBasicInformationHardwareVersionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationHardwareVersionStringCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationHardwareVersionStringAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readHardwareVersionStringAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationHardwareVersionStringCommandParams
        );
        result.put("readHardwareVersionStringAttribute", readBasicInformationHardwareVersionStringAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationSoftwareVersionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationSoftwareVersionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readSoftwareVersionAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readBasicInformationSoftwareVersionCommandParams
        );
        result.put("readSoftwareVersionAttribute", readBasicInformationSoftwareVersionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationSoftwareVersionStringCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationSoftwareVersionStringAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readSoftwareVersionStringAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationSoftwareVersionStringCommandParams
        );
        result.put("readSoftwareVersionStringAttribute", readBasicInformationSoftwareVersionStringAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationManufacturingDateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationManufacturingDateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readManufacturingDateAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationManufacturingDateCommandParams
        );
        result.put("readManufacturingDateAttribute", readBasicInformationManufacturingDateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationPartNumberCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationPartNumberAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readPartNumberAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationPartNumberCommandParams
        );
        result.put("readPartNumberAttribute", readBasicInformationPartNumberAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationProductURLCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationProductURLAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readProductURLAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationProductURLCommandParams
        );
        result.put("readProductURLAttribute", readBasicInformationProductURLAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationProductLabelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationProductLabelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readProductLabelAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationProductLabelCommandParams
        );
        result.put("readProductLabelAttribute", readBasicInformationProductLabelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationSerialNumberCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationSerialNumberAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readSerialNumberAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationSerialNumberCommandParams
        );
        result.put("readSerialNumberAttribute", readBasicInformationSerialNumberAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationLocalConfigDisabledCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationLocalConfigDisabledAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readLocalConfigDisabledAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readBasicInformationLocalConfigDisabledCommandParams
        );
        result.put("readLocalConfigDisabledAttribute", readBasicInformationLocalConfigDisabledAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationReachableCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationReachableAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readReachableAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readBasicInformationReachableCommandParams
        );
        result.put("readReachableAttribute", readBasicInformationReachableAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationUniqueIDCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationUniqueIDAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readUniqueIDAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBasicInformationUniqueIDCommandParams
        );
        result.put("readUniqueIDAttribute", readBasicInformationUniqueIDAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.BasicInformationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBasicInformationClusterGeneratedCommandListAttributeCallback(),
          readBasicInformationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readBasicInformationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.BasicInformationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBasicInformationClusterAcceptedCommandListAttributeCallback(),
          readBasicInformationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readBasicInformationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readEventListAttribute(
              (ChipClusters.BasicInformationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBasicInformationClusterEventListAttributeCallback(),
          readBasicInformationEventListCommandParams
        );
        result.put("readEventListAttribute", readBasicInformationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.BasicInformationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBasicInformationClusterAttributeListAttributeCallback(),
          readBasicInformationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readBasicInformationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readBasicInformationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readBasicInformationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBasicInformationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBasicInformationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BasicInformationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBasicInformationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readBasicInformationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readOtaSoftwareUpdateProviderInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readOtaSoftwareUpdateProviderGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateProviderGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateProviderCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.OtaSoftwareUpdateProviderCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOtaSoftwareUpdateProviderClusterGeneratedCommandListAttributeCallback(),
          readOtaSoftwareUpdateProviderGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readOtaSoftwareUpdateProviderGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateProviderAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateProviderAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateProviderCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.OtaSoftwareUpdateProviderCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOtaSoftwareUpdateProviderClusterAcceptedCommandListAttributeCallback(),
          readOtaSoftwareUpdateProviderAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readOtaSoftwareUpdateProviderAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateProviderEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateProviderEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateProviderCluster) cluster).readEventListAttribute(
              (ChipClusters.OtaSoftwareUpdateProviderCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOtaSoftwareUpdateProviderClusterEventListAttributeCallback(),
          readOtaSoftwareUpdateProviderEventListCommandParams
        );
        result.put("readEventListAttribute", readOtaSoftwareUpdateProviderEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateProviderAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateProviderAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateProviderCluster) cluster).readAttributeListAttribute(
              (ChipClusters.OtaSoftwareUpdateProviderCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOtaSoftwareUpdateProviderClusterAttributeListAttributeCallback(),
          readOtaSoftwareUpdateProviderAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readOtaSoftwareUpdateProviderAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateProviderFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateProviderFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateProviderCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOtaSoftwareUpdateProviderFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readOtaSoftwareUpdateProviderFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateProviderClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateProviderClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateProviderCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOtaSoftwareUpdateProviderClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readOtaSoftwareUpdateProviderClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readOtaSoftwareUpdateRequestorInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readOtaSoftwareUpdateRequestorDefaultOTAProvidersCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateRequestorDefaultOTAProvidersAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateRequestorCluster) cluster).readDefaultOTAProvidersAttribute(
              (ChipClusters.OtaSoftwareUpdateRequestorCluster.DefaultOTAProvidersAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOtaSoftwareUpdateRequestorClusterDefaultOTAProvidersAttributeCallback(),
          readOtaSoftwareUpdateRequestorDefaultOTAProvidersCommandParams
        );
        result.put("readDefaultOTAProvidersAttribute", readOtaSoftwareUpdateRequestorDefaultOTAProvidersAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateRequestorUpdatePossibleCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateRequestorUpdatePossibleAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateRequestorCluster) cluster).readUpdatePossibleAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readOtaSoftwareUpdateRequestorUpdatePossibleCommandParams
        );
        result.put("readUpdatePossibleAttribute", readOtaSoftwareUpdateRequestorUpdatePossibleAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateRequestorUpdateStateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateRequestorUpdateStateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateRequestorCluster) cluster).readUpdateStateAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOtaSoftwareUpdateRequestorUpdateStateCommandParams
        );
        result.put("readUpdateStateAttribute", readOtaSoftwareUpdateRequestorUpdateStateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateRequestorUpdateStateProgressCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateRequestorUpdateStateProgressAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateRequestorCluster) cluster).readUpdateStateProgressAttribute(
              (ChipClusters.OtaSoftwareUpdateRequestorCluster.UpdateStateProgressAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOtaSoftwareUpdateRequestorClusterUpdateStateProgressAttributeCallback(),
          readOtaSoftwareUpdateRequestorUpdateStateProgressCommandParams
        );
        result.put("readUpdateStateProgressAttribute", readOtaSoftwareUpdateRequestorUpdateStateProgressAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateRequestorGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateRequestorGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateRequestorCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.OtaSoftwareUpdateRequestorCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOtaSoftwareUpdateRequestorClusterGeneratedCommandListAttributeCallback(),
          readOtaSoftwareUpdateRequestorGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readOtaSoftwareUpdateRequestorGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateRequestorAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateRequestorAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateRequestorCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.OtaSoftwareUpdateRequestorCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOtaSoftwareUpdateRequestorClusterAcceptedCommandListAttributeCallback(),
          readOtaSoftwareUpdateRequestorAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readOtaSoftwareUpdateRequestorAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateRequestorEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateRequestorEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateRequestorCluster) cluster).readEventListAttribute(
              (ChipClusters.OtaSoftwareUpdateRequestorCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOtaSoftwareUpdateRequestorClusterEventListAttributeCallback(),
          readOtaSoftwareUpdateRequestorEventListCommandParams
        );
        result.put("readEventListAttribute", readOtaSoftwareUpdateRequestorEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateRequestorAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateRequestorAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateRequestorCluster) cluster).readAttributeListAttribute(
              (ChipClusters.OtaSoftwareUpdateRequestorCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOtaSoftwareUpdateRequestorClusterAttributeListAttributeCallback(),
          readOtaSoftwareUpdateRequestorAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readOtaSoftwareUpdateRequestorAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateRequestorFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateRequestorFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateRequestorCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOtaSoftwareUpdateRequestorFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readOtaSoftwareUpdateRequestorFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOtaSoftwareUpdateRequestorClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOtaSoftwareUpdateRequestorClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OtaSoftwareUpdateRequestorCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOtaSoftwareUpdateRequestorClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readOtaSoftwareUpdateRequestorClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readLocalizationConfigurationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readLocalizationConfigurationActiveLocaleCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLocalizationConfigurationActiveLocaleAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LocalizationConfigurationCluster) cluster).readActiveLocaleAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readLocalizationConfigurationActiveLocaleCommandParams
        );
        result.put("readActiveLocaleAttribute", readLocalizationConfigurationActiveLocaleAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLocalizationConfigurationSupportedLocalesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLocalizationConfigurationSupportedLocalesAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LocalizationConfigurationCluster) cluster).readSupportedLocalesAttribute(
              (ChipClusters.LocalizationConfigurationCluster.SupportedLocalesAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLocalizationConfigurationClusterSupportedLocalesAttributeCallback(),
          readLocalizationConfigurationSupportedLocalesCommandParams
        );
        result.put("readSupportedLocalesAttribute", readLocalizationConfigurationSupportedLocalesAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLocalizationConfigurationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLocalizationConfigurationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LocalizationConfigurationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.LocalizationConfigurationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLocalizationConfigurationClusterGeneratedCommandListAttributeCallback(),
          readLocalizationConfigurationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readLocalizationConfigurationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLocalizationConfigurationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLocalizationConfigurationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LocalizationConfigurationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.LocalizationConfigurationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLocalizationConfigurationClusterAcceptedCommandListAttributeCallback(),
          readLocalizationConfigurationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readLocalizationConfigurationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLocalizationConfigurationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLocalizationConfigurationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LocalizationConfigurationCluster) cluster).readEventListAttribute(
              (ChipClusters.LocalizationConfigurationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLocalizationConfigurationClusterEventListAttributeCallback(),
          readLocalizationConfigurationEventListCommandParams
        );
        result.put("readEventListAttribute", readLocalizationConfigurationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLocalizationConfigurationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLocalizationConfigurationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LocalizationConfigurationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.LocalizationConfigurationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLocalizationConfigurationClusterAttributeListAttributeCallback(),
          readLocalizationConfigurationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readLocalizationConfigurationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLocalizationConfigurationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLocalizationConfigurationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LocalizationConfigurationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readLocalizationConfigurationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readLocalizationConfigurationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readLocalizationConfigurationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readLocalizationConfigurationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.LocalizationConfigurationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readLocalizationConfigurationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readLocalizationConfigurationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readTimeFormatLocalizationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readTimeFormatLocalizationHourFormatCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeFormatLocalizationHourFormatAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeFormatLocalizationCluster) cluster).readHourFormatAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTimeFormatLocalizationHourFormatCommandParams
        );
        result.put("readHourFormatAttribute", readTimeFormatLocalizationHourFormatAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeFormatLocalizationActiveCalendarTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeFormatLocalizationActiveCalendarTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeFormatLocalizationCluster) cluster).readActiveCalendarTypeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTimeFormatLocalizationActiveCalendarTypeCommandParams
        );
        result.put("readActiveCalendarTypeAttribute", readTimeFormatLocalizationActiveCalendarTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeFormatLocalizationSupportedCalendarTypesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeFormatLocalizationSupportedCalendarTypesAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeFormatLocalizationCluster) cluster).readSupportedCalendarTypesAttribute(
              (ChipClusters.TimeFormatLocalizationCluster.SupportedCalendarTypesAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeFormatLocalizationClusterSupportedCalendarTypesAttributeCallback(),
          readTimeFormatLocalizationSupportedCalendarTypesCommandParams
        );
        result.put("readSupportedCalendarTypesAttribute", readTimeFormatLocalizationSupportedCalendarTypesAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeFormatLocalizationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeFormatLocalizationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeFormatLocalizationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.TimeFormatLocalizationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeFormatLocalizationClusterGeneratedCommandListAttributeCallback(),
          readTimeFormatLocalizationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readTimeFormatLocalizationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeFormatLocalizationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeFormatLocalizationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeFormatLocalizationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.TimeFormatLocalizationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeFormatLocalizationClusterAcceptedCommandListAttributeCallback(),
          readTimeFormatLocalizationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readTimeFormatLocalizationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeFormatLocalizationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeFormatLocalizationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeFormatLocalizationCluster) cluster).readEventListAttribute(
              (ChipClusters.TimeFormatLocalizationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeFormatLocalizationClusterEventListAttributeCallback(),
          readTimeFormatLocalizationEventListCommandParams
        );
        result.put("readEventListAttribute", readTimeFormatLocalizationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeFormatLocalizationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeFormatLocalizationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeFormatLocalizationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.TimeFormatLocalizationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeFormatLocalizationClusterAttributeListAttributeCallback(),
          readTimeFormatLocalizationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readTimeFormatLocalizationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeFormatLocalizationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeFormatLocalizationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeFormatLocalizationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readTimeFormatLocalizationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readTimeFormatLocalizationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeFormatLocalizationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeFormatLocalizationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeFormatLocalizationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTimeFormatLocalizationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readTimeFormatLocalizationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readUnitLocalizationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readUnitLocalizationTemperatureUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUnitLocalizationTemperatureUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UnitLocalizationCluster) cluster).readTemperatureUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readUnitLocalizationTemperatureUnitCommandParams
        );
        result.put("readTemperatureUnitAttribute", readUnitLocalizationTemperatureUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUnitLocalizationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUnitLocalizationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UnitLocalizationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.UnitLocalizationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUnitLocalizationClusterGeneratedCommandListAttributeCallback(),
          readUnitLocalizationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readUnitLocalizationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUnitLocalizationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUnitLocalizationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UnitLocalizationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.UnitLocalizationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUnitLocalizationClusterAcceptedCommandListAttributeCallback(),
          readUnitLocalizationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readUnitLocalizationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUnitLocalizationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUnitLocalizationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UnitLocalizationCluster) cluster).readEventListAttribute(
              (ChipClusters.UnitLocalizationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUnitLocalizationClusterEventListAttributeCallback(),
          readUnitLocalizationEventListCommandParams
        );
        result.put("readEventListAttribute", readUnitLocalizationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUnitLocalizationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUnitLocalizationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UnitLocalizationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.UnitLocalizationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUnitLocalizationClusterAttributeListAttributeCallback(),
          readUnitLocalizationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readUnitLocalizationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUnitLocalizationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUnitLocalizationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UnitLocalizationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readUnitLocalizationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readUnitLocalizationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUnitLocalizationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUnitLocalizationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UnitLocalizationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readUnitLocalizationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readUnitLocalizationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readPowerSourceConfigurationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readPowerSourceConfigurationSourcesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceConfigurationSourcesAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceConfigurationCluster) cluster).readSourcesAttribute(
              (ChipClusters.PowerSourceConfigurationCluster.SourcesAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceConfigurationClusterSourcesAttributeCallback(),
          readPowerSourceConfigurationSourcesCommandParams
        );
        result.put("readSourcesAttribute", readPowerSourceConfigurationSourcesAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceConfigurationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceConfigurationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceConfigurationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.PowerSourceConfigurationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceConfigurationClusterGeneratedCommandListAttributeCallback(),
          readPowerSourceConfigurationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readPowerSourceConfigurationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceConfigurationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceConfigurationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceConfigurationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.PowerSourceConfigurationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceConfigurationClusterAcceptedCommandListAttributeCallback(),
          readPowerSourceConfigurationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readPowerSourceConfigurationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceConfigurationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceConfigurationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceConfigurationCluster) cluster).readEventListAttribute(
              (ChipClusters.PowerSourceConfigurationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceConfigurationClusterEventListAttributeCallback(),
          readPowerSourceConfigurationEventListCommandParams
        );
        result.put("readEventListAttribute", readPowerSourceConfigurationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceConfigurationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceConfigurationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceConfigurationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.PowerSourceConfigurationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceConfigurationClusterAttributeListAttributeCallback(),
          readPowerSourceConfigurationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readPowerSourceConfigurationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceConfigurationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceConfigurationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceConfigurationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readPowerSourceConfigurationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readPowerSourceConfigurationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceConfigurationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceConfigurationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceConfigurationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPowerSourceConfigurationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readPowerSourceConfigurationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readPowerSourceInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readPowerSourceStatusCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceStatusAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readStatusAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPowerSourceStatusCommandParams
        );
        result.put("readStatusAttribute", readPowerSourceStatusAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceOrderCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceOrderAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readOrderAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPowerSourceOrderCommandParams
        );
        result.put("readOrderAttribute", readPowerSourceOrderAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceDescriptionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceDescriptionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readDescriptionAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readPowerSourceDescriptionCommandParams
        );
        result.put("readDescriptionAttribute", readPowerSourceDescriptionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceWiredAssessedInputVoltageCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceWiredAssessedInputVoltageAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readWiredAssessedInputVoltageAttribute(
              (ChipClusters.PowerSourceCluster.WiredAssessedInputVoltageAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterWiredAssessedInputVoltageAttributeCallback(),
          readPowerSourceWiredAssessedInputVoltageCommandParams
        );
        result.put("readWiredAssessedInputVoltageAttribute", readPowerSourceWiredAssessedInputVoltageAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceWiredAssessedInputFrequencyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceWiredAssessedInputFrequencyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readWiredAssessedInputFrequencyAttribute(
              (ChipClusters.PowerSourceCluster.WiredAssessedInputFrequencyAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterWiredAssessedInputFrequencyAttributeCallback(),
          readPowerSourceWiredAssessedInputFrequencyCommandParams
        );
        result.put("readWiredAssessedInputFrequencyAttribute", readPowerSourceWiredAssessedInputFrequencyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceWiredCurrentTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceWiredCurrentTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readWiredCurrentTypeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPowerSourceWiredCurrentTypeCommandParams
        );
        result.put("readWiredCurrentTypeAttribute", readPowerSourceWiredCurrentTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceWiredAssessedCurrentCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceWiredAssessedCurrentAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readWiredAssessedCurrentAttribute(
              (ChipClusters.PowerSourceCluster.WiredAssessedCurrentAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterWiredAssessedCurrentAttributeCallback(),
          readPowerSourceWiredAssessedCurrentCommandParams
        );
        result.put("readWiredAssessedCurrentAttribute", readPowerSourceWiredAssessedCurrentAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceWiredNominalVoltageCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceWiredNominalVoltageAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readWiredNominalVoltageAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readPowerSourceWiredNominalVoltageCommandParams
        );
        result.put("readWiredNominalVoltageAttribute", readPowerSourceWiredNominalVoltageAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceWiredMaximumCurrentCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceWiredMaximumCurrentAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readWiredMaximumCurrentAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readPowerSourceWiredMaximumCurrentCommandParams
        );
        result.put("readWiredMaximumCurrentAttribute", readPowerSourceWiredMaximumCurrentAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceWiredPresentCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceWiredPresentAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readWiredPresentAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readPowerSourceWiredPresentCommandParams
        );
        result.put("readWiredPresentAttribute", readPowerSourceWiredPresentAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceActiveWiredFaultsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceActiveWiredFaultsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readActiveWiredFaultsAttribute(
              (ChipClusters.PowerSourceCluster.ActiveWiredFaultsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterActiveWiredFaultsAttributeCallback(),
          readPowerSourceActiveWiredFaultsCommandParams
        );
        result.put("readActiveWiredFaultsAttribute", readPowerSourceActiveWiredFaultsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatVoltageCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatVoltageAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatVoltageAttribute(
              (ChipClusters.PowerSourceCluster.BatVoltageAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterBatVoltageAttributeCallback(),
          readPowerSourceBatVoltageCommandParams
        );
        result.put("readBatVoltageAttribute", readPowerSourceBatVoltageAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatPercentRemainingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatPercentRemainingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatPercentRemainingAttribute(
              (ChipClusters.PowerSourceCluster.BatPercentRemainingAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterBatPercentRemainingAttributeCallback(),
          readPowerSourceBatPercentRemainingCommandParams
        );
        result.put("readBatPercentRemainingAttribute", readPowerSourceBatPercentRemainingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatTimeRemainingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatTimeRemainingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatTimeRemainingAttribute(
              (ChipClusters.PowerSourceCluster.BatTimeRemainingAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterBatTimeRemainingAttributeCallback(),
          readPowerSourceBatTimeRemainingCommandParams
        );
        result.put("readBatTimeRemainingAttribute", readPowerSourceBatTimeRemainingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatChargeLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatChargeLevelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatChargeLevelAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPowerSourceBatChargeLevelCommandParams
        );
        result.put("readBatChargeLevelAttribute", readPowerSourceBatChargeLevelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatReplacementNeededCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatReplacementNeededAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatReplacementNeededAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readPowerSourceBatReplacementNeededCommandParams
        );
        result.put("readBatReplacementNeededAttribute", readPowerSourceBatReplacementNeededAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatReplaceabilityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatReplaceabilityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatReplaceabilityAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPowerSourceBatReplaceabilityCommandParams
        );
        result.put("readBatReplaceabilityAttribute", readPowerSourceBatReplaceabilityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatPresentCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatPresentAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatPresentAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readPowerSourceBatPresentCommandParams
        );
        result.put("readBatPresentAttribute", readPowerSourceBatPresentAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceActiveBatFaultsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceActiveBatFaultsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readActiveBatFaultsAttribute(
              (ChipClusters.PowerSourceCluster.ActiveBatFaultsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterActiveBatFaultsAttributeCallback(),
          readPowerSourceActiveBatFaultsCommandParams
        );
        result.put("readActiveBatFaultsAttribute", readPowerSourceActiveBatFaultsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatReplacementDescriptionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatReplacementDescriptionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatReplacementDescriptionAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readPowerSourceBatReplacementDescriptionCommandParams
        );
        result.put("readBatReplacementDescriptionAttribute", readPowerSourceBatReplacementDescriptionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatCommonDesignationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatCommonDesignationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatCommonDesignationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPowerSourceBatCommonDesignationCommandParams
        );
        result.put("readBatCommonDesignationAttribute", readPowerSourceBatCommonDesignationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatANSIDesignationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatANSIDesignationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatANSIDesignationAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readPowerSourceBatANSIDesignationCommandParams
        );
        result.put("readBatANSIDesignationAttribute", readPowerSourceBatANSIDesignationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatIECDesignationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatIECDesignationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatIECDesignationAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readPowerSourceBatIECDesignationCommandParams
        );
        result.put("readBatIECDesignationAttribute", readPowerSourceBatIECDesignationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatApprovedChemistryCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatApprovedChemistryAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatApprovedChemistryAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPowerSourceBatApprovedChemistryCommandParams
        );
        result.put("readBatApprovedChemistryAttribute", readPowerSourceBatApprovedChemistryAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatCapacityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatCapacityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatCapacityAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readPowerSourceBatCapacityCommandParams
        );
        result.put("readBatCapacityAttribute", readPowerSourceBatCapacityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatQuantityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatQuantityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatQuantityAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPowerSourceBatQuantityCommandParams
        );
        result.put("readBatQuantityAttribute", readPowerSourceBatQuantityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatChargeStateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatChargeStateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatChargeStateAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPowerSourceBatChargeStateCommandParams
        );
        result.put("readBatChargeStateAttribute", readPowerSourceBatChargeStateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatTimeToFullChargeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatTimeToFullChargeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatTimeToFullChargeAttribute(
              (ChipClusters.PowerSourceCluster.BatTimeToFullChargeAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterBatTimeToFullChargeAttributeCallback(),
          readPowerSourceBatTimeToFullChargeCommandParams
        );
        result.put("readBatTimeToFullChargeAttribute", readPowerSourceBatTimeToFullChargeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatFunctionalWhileChargingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatFunctionalWhileChargingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatFunctionalWhileChargingAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readPowerSourceBatFunctionalWhileChargingCommandParams
        );
        result.put("readBatFunctionalWhileChargingAttribute", readPowerSourceBatFunctionalWhileChargingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceBatChargingCurrentCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceBatChargingCurrentAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readBatChargingCurrentAttribute(
              (ChipClusters.PowerSourceCluster.BatChargingCurrentAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterBatChargingCurrentAttributeCallback(),
          readPowerSourceBatChargingCurrentCommandParams
        );
        result.put("readBatChargingCurrentAttribute", readPowerSourceBatChargingCurrentAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceActiveBatChargeFaultsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceActiveBatChargeFaultsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readActiveBatChargeFaultsAttribute(
              (ChipClusters.PowerSourceCluster.ActiveBatChargeFaultsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterActiveBatChargeFaultsAttributeCallback(),
          readPowerSourceActiveBatChargeFaultsCommandParams
        );
        result.put("readActiveBatChargeFaultsAttribute", readPowerSourceActiveBatChargeFaultsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.PowerSourceCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterGeneratedCommandListAttributeCallback(),
          readPowerSourceGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readPowerSourceGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.PowerSourceCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterAcceptedCommandListAttributeCallback(),
          readPowerSourceAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readPowerSourceAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readEventListAttribute(
              (ChipClusters.PowerSourceCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterEventListAttributeCallback(),
          readPowerSourceEventListCommandParams
        );
        result.put("readEventListAttribute", readPowerSourceEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readAttributeListAttribute(
              (ChipClusters.PowerSourceCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPowerSourceClusterAttributeListAttributeCallback(),
          readPowerSourceAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readPowerSourceAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readPowerSourceFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readPowerSourceFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPowerSourceClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPowerSourceClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PowerSourceCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPowerSourceClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readPowerSourceClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readGeneralCommissioningInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readGeneralCommissioningBreadcrumbCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralCommissioningBreadcrumbAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralCommissioningCluster) cluster).readBreadcrumbAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readGeneralCommissioningBreadcrumbCommandParams
        );
        result.put("readBreadcrumbAttribute", readGeneralCommissioningBreadcrumbAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralCommissioningRegulatoryConfigCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralCommissioningRegulatoryConfigAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralCommissioningCluster) cluster).readRegulatoryConfigAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readGeneralCommissioningRegulatoryConfigCommandParams
        );
        result.put("readRegulatoryConfigAttribute", readGeneralCommissioningRegulatoryConfigAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralCommissioningLocationCapabilityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralCommissioningLocationCapabilityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralCommissioningCluster) cluster).readLocationCapabilityAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readGeneralCommissioningLocationCapabilityCommandParams
        );
        result.put("readLocationCapabilityAttribute", readGeneralCommissioningLocationCapabilityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralCommissioningSupportsConcurrentConnectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralCommissioningSupportsConcurrentConnectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralCommissioningCluster) cluster).readSupportsConcurrentConnectionAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readGeneralCommissioningSupportsConcurrentConnectionCommandParams
        );
        result.put("readSupportsConcurrentConnectionAttribute", readGeneralCommissioningSupportsConcurrentConnectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralCommissioningGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralCommissioningGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralCommissioningCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.GeneralCommissioningCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralCommissioningClusterGeneratedCommandListAttributeCallback(),
          readGeneralCommissioningGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readGeneralCommissioningGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralCommissioningAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralCommissioningAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralCommissioningCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.GeneralCommissioningCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralCommissioningClusterAcceptedCommandListAttributeCallback(),
          readGeneralCommissioningAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readGeneralCommissioningAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralCommissioningEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralCommissioningEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralCommissioningCluster) cluster).readEventListAttribute(
              (ChipClusters.GeneralCommissioningCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralCommissioningClusterEventListAttributeCallback(),
          readGeneralCommissioningEventListCommandParams
        );
        result.put("readEventListAttribute", readGeneralCommissioningEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralCommissioningAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralCommissioningAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralCommissioningCluster) cluster).readAttributeListAttribute(
              (ChipClusters.GeneralCommissioningCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralCommissioningClusterAttributeListAttributeCallback(),
          readGeneralCommissioningAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readGeneralCommissioningAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralCommissioningFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralCommissioningFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralCommissioningCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readGeneralCommissioningFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readGeneralCommissioningFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralCommissioningClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralCommissioningClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralCommissioningCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readGeneralCommissioningClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readGeneralCommissioningClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readNetworkCommissioningInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readNetworkCommissioningMaxNetworksCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningMaxNetworksAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readMaxNetworksAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNetworkCommissioningMaxNetworksCommandParams
        );
        result.put("readMaxNetworksAttribute", readNetworkCommissioningMaxNetworksAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningNetworksCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningNetworksAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readNetworksAttribute(
              (ChipClusters.NetworkCommissioningCluster.NetworksAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNetworkCommissioningClusterNetworksAttributeCallback(),
          readNetworkCommissioningNetworksCommandParams
        );
        result.put("readNetworksAttribute", readNetworkCommissioningNetworksAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningScanMaxTimeSecondsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningScanMaxTimeSecondsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readScanMaxTimeSecondsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNetworkCommissioningScanMaxTimeSecondsCommandParams
        );
        result.put("readScanMaxTimeSecondsAttribute", readNetworkCommissioningScanMaxTimeSecondsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningConnectMaxTimeSecondsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningConnectMaxTimeSecondsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readConnectMaxTimeSecondsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNetworkCommissioningConnectMaxTimeSecondsCommandParams
        );
        result.put("readConnectMaxTimeSecondsAttribute", readNetworkCommissioningConnectMaxTimeSecondsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningInterfaceEnabledCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningInterfaceEnabledAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readInterfaceEnabledAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readNetworkCommissioningInterfaceEnabledCommandParams
        );
        result.put("readInterfaceEnabledAttribute", readNetworkCommissioningInterfaceEnabledAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningLastNetworkingStatusCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningLastNetworkingStatusAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readLastNetworkingStatusAttribute(
              (ChipClusters.NetworkCommissioningCluster.LastNetworkingStatusAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNetworkCommissioningClusterLastNetworkingStatusAttributeCallback(),
          readNetworkCommissioningLastNetworkingStatusCommandParams
        );
        result.put("readLastNetworkingStatusAttribute", readNetworkCommissioningLastNetworkingStatusAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningLastNetworkIDCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningLastNetworkIDAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readLastNetworkIDAttribute(
              (ChipClusters.NetworkCommissioningCluster.LastNetworkIDAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNetworkCommissioningClusterLastNetworkIDAttributeCallback(),
          readNetworkCommissioningLastNetworkIDCommandParams
        );
        result.put("readLastNetworkIDAttribute", readNetworkCommissioningLastNetworkIDAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningLastConnectErrorValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningLastConnectErrorValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readLastConnectErrorValueAttribute(
              (ChipClusters.NetworkCommissioningCluster.LastConnectErrorValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNetworkCommissioningClusterLastConnectErrorValueAttributeCallback(),
          readNetworkCommissioningLastConnectErrorValueCommandParams
        );
        result.put("readLastConnectErrorValueAttribute", readNetworkCommissioningLastConnectErrorValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.NetworkCommissioningCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNetworkCommissioningClusterGeneratedCommandListAttributeCallback(),
          readNetworkCommissioningGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readNetworkCommissioningGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.NetworkCommissioningCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNetworkCommissioningClusterAcceptedCommandListAttributeCallback(),
          readNetworkCommissioningAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readNetworkCommissioningAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readEventListAttribute(
              (ChipClusters.NetworkCommissioningCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNetworkCommissioningClusterEventListAttributeCallback(),
          readNetworkCommissioningEventListCommandParams
        );
        result.put("readEventListAttribute", readNetworkCommissioningEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readAttributeListAttribute(
              (ChipClusters.NetworkCommissioningCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNetworkCommissioningClusterAttributeListAttributeCallback(),
          readNetworkCommissioningAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readNetworkCommissioningAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readNetworkCommissioningFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readNetworkCommissioningFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNetworkCommissioningClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNetworkCommissioningClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NetworkCommissioningCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNetworkCommissioningClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readNetworkCommissioningClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readDiagnosticLogsInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readDiagnosticLogsGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDiagnosticLogsGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DiagnosticLogsCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.DiagnosticLogsCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDiagnosticLogsClusterGeneratedCommandListAttributeCallback(),
          readDiagnosticLogsGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readDiagnosticLogsGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDiagnosticLogsAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDiagnosticLogsAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DiagnosticLogsCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.DiagnosticLogsCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDiagnosticLogsClusterAcceptedCommandListAttributeCallback(),
          readDiagnosticLogsAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readDiagnosticLogsAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDiagnosticLogsEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDiagnosticLogsEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DiagnosticLogsCluster) cluster).readEventListAttribute(
              (ChipClusters.DiagnosticLogsCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDiagnosticLogsClusterEventListAttributeCallback(),
          readDiagnosticLogsEventListCommandParams
        );
        result.put("readEventListAttribute", readDiagnosticLogsEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDiagnosticLogsAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDiagnosticLogsAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DiagnosticLogsCluster) cluster).readAttributeListAttribute(
              (ChipClusters.DiagnosticLogsCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDiagnosticLogsClusterAttributeListAttributeCallback(),
          readDiagnosticLogsAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readDiagnosticLogsAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDiagnosticLogsFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDiagnosticLogsFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DiagnosticLogsCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readDiagnosticLogsFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readDiagnosticLogsFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDiagnosticLogsClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDiagnosticLogsClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DiagnosticLogsCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDiagnosticLogsClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readDiagnosticLogsClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readGeneralDiagnosticsInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readGeneralDiagnosticsNetworkInterfacesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsNetworkInterfacesAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readNetworkInterfacesAttribute(
              (ChipClusters.GeneralDiagnosticsCluster.NetworkInterfacesAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralDiagnosticsClusterNetworkInterfacesAttributeCallback(),
          readGeneralDiagnosticsNetworkInterfacesCommandParams
        );
        result.put("readNetworkInterfacesAttribute", readGeneralDiagnosticsNetworkInterfacesAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsRebootCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsRebootCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readRebootCountAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readGeneralDiagnosticsRebootCountCommandParams
        );
        result.put("readRebootCountAttribute", readGeneralDiagnosticsRebootCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsUpTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsUpTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readUpTimeAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readGeneralDiagnosticsUpTimeCommandParams
        );
        result.put("readUpTimeAttribute", readGeneralDiagnosticsUpTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsTotalOperationalHoursCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsTotalOperationalHoursAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readTotalOperationalHoursAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readGeneralDiagnosticsTotalOperationalHoursCommandParams
        );
        result.put("readTotalOperationalHoursAttribute", readGeneralDiagnosticsTotalOperationalHoursAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsBootReasonCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsBootReasonAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readBootReasonAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readGeneralDiagnosticsBootReasonCommandParams
        );
        result.put("readBootReasonAttribute", readGeneralDiagnosticsBootReasonAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsActiveHardwareFaultsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsActiveHardwareFaultsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readActiveHardwareFaultsAttribute(
              (ChipClusters.GeneralDiagnosticsCluster.ActiveHardwareFaultsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralDiagnosticsClusterActiveHardwareFaultsAttributeCallback(),
          readGeneralDiagnosticsActiveHardwareFaultsCommandParams
        );
        result.put("readActiveHardwareFaultsAttribute", readGeneralDiagnosticsActiveHardwareFaultsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsActiveRadioFaultsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsActiveRadioFaultsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readActiveRadioFaultsAttribute(
              (ChipClusters.GeneralDiagnosticsCluster.ActiveRadioFaultsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralDiagnosticsClusterActiveRadioFaultsAttributeCallback(),
          readGeneralDiagnosticsActiveRadioFaultsCommandParams
        );
        result.put("readActiveRadioFaultsAttribute", readGeneralDiagnosticsActiveRadioFaultsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsActiveNetworkFaultsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsActiveNetworkFaultsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readActiveNetworkFaultsAttribute(
              (ChipClusters.GeneralDiagnosticsCluster.ActiveNetworkFaultsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralDiagnosticsClusterActiveNetworkFaultsAttributeCallback(),
          readGeneralDiagnosticsActiveNetworkFaultsCommandParams
        );
        result.put("readActiveNetworkFaultsAttribute", readGeneralDiagnosticsActiveNetworkFaultsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsTestEventTriggersEnabledCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsTestEventTriggersEnabledAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readTestEventTriggersEnabledAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readGeneralDiagnosticsTestEventTriggersEnabledCommandParams
        );
        result.put("readTestEventTriggersEnabledAttribute", readGeneralDiagnosticsTestEventTriggersEnabledAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.GeneralDiagnosticsCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralDiagnosticsClusterGeneratedCommandListAttributeCallback(),
          readGeneralDiagnosticsGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readGeneralDiagnosticsGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.GeneralDiagnosticsCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralDiagnosticsClusterAcceptedCommandListAttributeCallback(),
          readGeneralDiagnosticsAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readGeneralDiagnosticsAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readEventListAttribute(
              (ChipClusters.GeneralDiagnosticsCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralDiagnosticsClusterEventListAttributeCallback(),
          readGeneralDiagnosticsEventListCommandParams
        );
        result.put("readEventListAttribute", readGeneralDiagnosticsEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readAttributeListAttribute(
              (ChipClusters.GeneralDiagnosticsCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGeneralDiagnosticsClusterAttributeListAttributeCallback(),
          readGeneralDiagnosticsAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readGeneralDiagnosticsAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readGeneralDiagnosticsFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readGeneralDiagnosticsFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGeneralDiagnosticsClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGeneralDiagnosticsClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GeneralDiagnosticsCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readGeneralDiagnosticsClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readGeneralDiagnosticsClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readSoftwareDiagnosticsInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readSoftwareDiagnosticsThreadMetricsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSoftwareDiagnosticsThreadMetricsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SoftwareDiagnosticsCluster) cluster).readThreadMetricsAttribute(
              (ChipClusters.SoftwareDiagnosticsCluster.ThreadMetricsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSoftwareDiagnosticsClusterThreadMetricsAttributeCallback(),
          readSoftwareDiagnosticsThreadMetricsCommandParams
        );
        result.put("readThreadMetricsAttribute", readSoftwareDiagnosticsThreadMetricsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSoftwareDiagnosticsCurrentHeapFreeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSoftwareDiagnosticsCurrentHeapFreeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SoftwareDiagnosticsCluster) cluster).readCurrentHeapFreeAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readSoftwareDiagnosticsCurrentHeapFreeCommandParams
        );
        result.put("readCurrentHeapFreeAttribute", readSoftwareDiagnosticsCurrentHeapFreeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSoftwareDiagnosticsCurrentHeapUsedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSoftwareDiagnosticsCurrentHeapUsedAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SoftwareDiagnosticsCluster) cluster).readCurrentHeapUsedAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readSoftwareDiagnosticsCurrentHeapUsedCommandParams
        );
        result.put("readCurrentHeapUsedAttribute", readSoftwareDiagnosticsCurrentHeapUsedAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSoftwareDiagnosticsCurrentHeapHighWatermarkCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSoftwareDiagnosticsCurrentHeapHighWatermarkAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SoftwareDiagnosticsCluster) cluster).readCurrentHeapHighWatermarkAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readSoftwareDiagnosticsCurrentHeapHighWatermarkCommandParams
        );
        result.put("readCurrentHeapHighWatermarkAttribute", readSoftwareDiagnosticsCurrentHeapHighWatermarkAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSoftwareDiagnosticsGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSoftwareDiagnosticsGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SoftwareDiagnosticsCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.SoftwareDiagnosticsCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSoftwareDiagnosticsClusterGeneratedCommandListAttributeCallback(),
          readSoftwareDiagnosticsGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readSoftwareDiagnosticsGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSoftwareDiagnosticsAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSoftwareDiagnosticsAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SoftwareDiagnosticsCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.SoftwareDiagnosticsCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSoftwareDiagnosticsClusterAcceptedCommandListAttributeCallback(),
          readSoftwareDiagnosticsAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readSoftwareDiagnosticsAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSoftwareDiagnosticsEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSoftwareDiagnosticsEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SoftwareDiagnosticsCluster) cluster).readEventListAttribute(
              (ChipClusters.SoftwareDiagnosticsCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSoftwareDiagnosticsClusterEventListAttributeCallback(),
          readSoftwareDiagnosticsEventListCommandParams
        );
        result.put("readEventListAttribute", readSoftwareDiagnosticsEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSoftwareDiagnosticsAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSoftwareDiagnosticsAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SoftwareDiagnosticsCluster) cluster).readAttributeListAttribute(
              (ChipClusters.SoftwareDiagnosticsCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSoftwareDiagnosticsClusterAttributeListAttributeCallback(),
          readSoftwareDiagnosticsAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readSoftwareDiagnosticsAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSoftwareDiagnosticsFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSoftwareDiagnosticsFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SoftwareDiagnosticsCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readSoftwareDiagnosticsFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readSoftwareDiagnosticsFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSoftwareDiagnosticsClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSoftwareDiagnosticsClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SoftwareDiagnosticsCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSoftwareDiagnosticsClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readSoftwareDiagnosticsClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readThreadNetworkDiagnosticsInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsChannelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsChannelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readChannelAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.ChannelAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterChannelAttributeCallback(),
          readThreadNetworkDiagnosticsChannelCommandParams
        );
        result.put("readChannelAttribute", readThreadNetworkDiagnosticsChannelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRoutingRoleCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRoutingRoleAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRoutingRoleAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.RoutingRoleAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterRoutingRoleAttributeCallback(),
          readThreadNetworkDiagnosticsRoutingRoleCommandParams
        );
        result.put("readRoutingRoleAttribute", readThreadNetworkDiagnosticsRoutingRoleAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsNetworkNameCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsNetworkNameAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readNetworkNameAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.NetworkNameAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterNetworkNameAttributeCallback(),
          readThreadNetworkDiagnosticsNetworkNameCommandParams
        );
        result.put("readNetworkNameAttribute", readThreadNetworkDiagnosticsNetworkNameAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsPanIdCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsPanIdAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readPanIdAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.PanIdAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterPanIdAttributeCallback(),
          readThreadNetworkDiagnosticsPanIdCommandParams
        );
        result.put("readPanIdAttribute", readThreadNetworkDiagnosticsPanIdAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsExtendedPanIdCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsExtendedPanIdAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readExtendedPanIdAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.ExtendedPanIdAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterExtendedPanIdAttributeCallback(),
          readThreadNetworkDiagnosticsExtendedPanIdCommandParams
        );
        result.put("readExtendedPanIdAttribute", readThreadNetworkDiagnosticsExtendedPanIdAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsMeshLocalPrefixCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsMeshLocalPrefixAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readMeshLocalPrefixAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.MeshLocalPrefixAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterMeshLocalPrefixAttributeCallback(),
          readThreadNetworkDiagnosticsMeshLocalPrefixCommandParams
        );
        result.put("readMeshLocalPrefixAttribute", readThreadNetworkDiagnosticsMeshLocalPrefixAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsOverrunCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsOverrunCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readOverrunCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsOverrunCountCommandParams
        );
        result.put("readOverrunCountAttribute", readThreadNetworkDiagnosticsOverrunCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsNeighborTableCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsNeighborTableAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readNeighborTableAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.NeighborTableAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterNeighborTableAttributeCallback(),
          readThreadNetworkDiagnosticsNeighborTableCommandParams
        );
        result.put("readNeighborTableAttribute", readThreadNetworkDiagnosticsNeighborTableAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRouteTableCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRouteTableAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRouteTableAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.RouteTableAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterRouteTableAttributeCallback(),
          readThreadNetworkDiagnosticsRouteTableCommandParams
        );
        result.put("readRouteTableAttribute", readThreadNetworkDiagnosticsRouteTableAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsPartitionIdCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsPartitionIdAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readPartitionIdAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.PartitionIdAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterPartitionIdAttributeCallback(),
          readThreadNetworkDiagnosticsPartitionIdCommandParams
        );
        result.put("readPartitionIdAttribute", readThreadNetworkDiagnosticsPartitionIdAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsWeightingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsWeightingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readWeightingAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.WeightingAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterWeightingAttributeCallback(),
          readThreadNetworkDiagnosticsWeightingCommandParams
        );
        result.put("readWeightingAttribute", readThreadNetworkDiagnosticsWeightingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsDataVersionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsDataVersionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readDataVersionAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.DataVersionAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterDataVersionAttributeCallback(),
          readThreadNetworkDiagnosticsDataVersionCommandParams
        );
        result.put("readDataVersionAttribute", readThreadNetworkDiagnosticsDataVersionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsStableDataVersionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsStableDataVersionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readStableDataVersionAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.StableDataVersionAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterStableDataVersionAttributeCallback(),
          readThreadNetworkDiagnosticsStableDataVersionCommandParams
        );
        result.put("readStableDataVersionAttribute", readThreadNetworkDiagnosticsStableDataVersionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsLeaderRouterIdCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsLeaderRouterIdAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readLeaderRouterIdAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.LeaderRouterIdAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterLeaderRouterIdAttributeCallback(),
          readThreadNetworkDiagnosticsLeaderRouterIdCommandParams
        );
        result.put("readLeaderRouterIdAttribute", readThreadNetworkDiagnosticsLeaderRouterIdAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsDetachedRoleCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsDetachedRoleCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readDetachedRoleCountAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThreadNetworkDiagnosticsDetachedRoleCountCommandParams
        );
        result.put("readDetachedRoleCountAttribute", readThreadNetworkDiagnosticsDetachedRoleCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsChildRoleCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsChildRoleCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readChildRoleCountAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThreadNetworkDiagnosticsChildRoleCountCommandParams
        );
        result.put("readChildRoleCountAttribute", readThreadNetworkDiagnosticsChildRoleCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRouterRoleCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRouterRoleCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRouterRoleCountAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThreadNetworkDiagnosticsRouterRoleCountCommandParams
        );
        result.put("readRouterRoleCountAttribute", readThreadNetworkDiagnosticsRouterRoleCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsLeaderRoleCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsLeaderRoleCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readLeaderRoleCountAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThreadNetworkDiagnosticsLeaderRoleCountCommandParams
        );
        result.put("readLeaderRoleCountAttribute", readThreadNetworkDiagnosticsLeaderRoleCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsAttachAttemptCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsAttachAttemptCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readAttachAttemptCountAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThreadNetworkDiagnosticsAttachAttemptCountCommandParams
        );
        result.put("readAttachAttemptCountAttribute", readThreadNetworkDiagnosticsAttachAttemptCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsPartitionIdChangeCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsPartitionIdChangeCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readPartitionIdChangeCountAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThreadNetworkDiagnosticsPartitionIdChangeCountCommandParams
        );
        result.put("readPartitionIdChangeCountAttribute", readThreadNetworkDiagnosticsPartitionIdChangeCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsBetterPartitionAttachAttemptCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsBetterPartitionAttachAttemptCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readBetterPartitionAttachAttemptCountAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThreadNetworkDiagnosticsBetterPartitionAttachAttemptCountCommandParams
        );
        result.put("readBetterPartitionAttachAttemptCountAttribute", readThreadNetworkDiagnosticsBetterPartitionAttachAttemptCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsParentChangeCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsParentChangeCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readParentChangeCountAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThreadNetworkDiagnosticsParentChangeCountCommandParams
        );
        result.put("readParentChangeCountAttribute", readThreadNetworkDiagnosticsParentChangeCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxTotalCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxTotalCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxTotalCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxTotalCountCommandParams
        );
        result.put("readTxTotalCountAttribute", readThreadNetworkDiagnosticsTxTotalCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxUnicastCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxUnicastCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxUnicastCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxUnicastCountCommandParams
        );
        result.put("readTxUnicastCountAttribute", readThreadNetworkDiagnosticsTxUnicastCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxBroadcastCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxBroadcastCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxBroadcastCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxBroadcastCountCommandParams
        );
        result.put("readTxBroadcastCountAttribute", readThreadNetworkDiagnosticsTxBroadcastCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxAckRequestedCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxAckRequestedCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxAckRequestedCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxAckRequestedCountCommandParams
        );
        result.put("readTxAckRequestedCountAttribute", readThreadNetworkDiagnosticsTxAckRequestedCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxAckedCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxAckedCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxAckedCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxAckedCountCommandParams
        );
        result.put("readTxAckedCountAttribute", readThreadNetworkDiagnosticsTxAckedCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxNoAckRequestedCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxNoAckRequestedCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxNoAckRequestedCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxNoAckRequestedCountCommandParams
        );
        result.put("readTxNoAckRequestedCountAttribute", readThreadNetworkDiagnosticsTxNoAckRequestedCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxDataCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxDataCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxDataCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxDataCountCommandParams
        );
        result.put("readTxDataCountAttribute", readThreadNetworkDiagnosticsTxDataCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxDataPollCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxDataPollCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxDataPollCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxDataPollCountCommandParams
        );
        result.put("readTxDataPollCountAttribute", readThreadNetworkDiagnosticsTxDataPollCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxBeaconCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxBeaconCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxBeaconCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxBeaconCountCommandParams
        );
        result.put("readTxBeaconCountAttribute", readThreadNetworkDiagnosticsTxBeaconCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxBeaconRequestCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxBeaconRequestCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxBeaconRequestCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxBeaconRequestCountCommandParams
        );
        result.put("readTxBeaconRequestCountAttribute", readThreadNetworkDiagnosticsTxBeaconRequestCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxOtherCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxOtherCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxOtherCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxOtherCountCommandParams
        );
        result.put("readTxOtherCountAttribute", readThreadNetworkDiagnosticsTxOtherCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxRetryCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxRetryCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxRetryCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxRetryCountCommandParams
        );
        result.put("readTxRetryCountAttribute", readThreadNetworkDiagnosticsTxRetryCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxDirectMaxRetryExpiryCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxDirectMaxRetryExpiryCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxDirectMaxRetryExpiryCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxDirectMaxRetryExpiryCountCommandParams
        );
        result.put("readTxDirectMaxRetryExpiryCountAttribute", readThreadNetworkDiagnosticsTxDirectMaxRetryExpiryCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxIndirectMaxRetryExpiryCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxIndirectMaxRetryExpiryCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxIndirectMaxRetryExpiryCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxIndirectMaxRetryExpiryCountCommandParams
        );
        result.put("readTxIndirectMaxRetryExpiryCountAttribute", readThreadNetworkDiagnosticsTxIndirectMaxRetryExpiryCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxErrCcaCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxErrCcaCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxErrCcaCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxErrCcaCountCommandParams
        );
        result.put("readTxErrCcaCountAttribute", readThreadNetworkDiagnosticsTxErrCcaCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxErrAbortCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxErrAbortCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxErrAbortCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxErrAbortCountCommandParams
        );
        result.put("readTxErrAbortCountAttribute", readThreadNetworkDiagnosticsTxErrAbortCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsTxErrBusyChannelCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsTxErrBusyChannelCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readTxErrBusyChannelCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsTxErrBusyChannelCountCommandParams
        );
        result.put("readTxErrBusyChannelCountAttribute", readThreadNetworkDiagnosticsTxErrBusyChannelCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxTotalCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxTotalCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxTotalCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxTotalCountCommandParams
        );
        result.put("readRxTotalCountAttribute", readThreadNetworkDiagnosticsRxTotalCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxUnicastCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxUnicastCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxUnicastCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxUnicastCountCommandParams
        );
        result.put("readRxUnicastCountAttribute", readThreadNetworkDiagnosticsRxUnicastCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxBroadcastCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxBroadcastCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxBroadcastCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxBroadcastCountCommandParams
        );
        result.put("readRxBroadcastCountAttribute", readThreadNetworkDiagnosticsRxBroadcastCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxDataCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxDataCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxDataCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxDataCountCommandParams
        );
        result.put("readRxDataCountAttribute", readThreadNetworkDiagnosticsRxDataCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxDataPollCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxDataPollCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxDataPollCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxDataPollCountCommandParams
        );
        result.put("readRxDataPollCountAttribute", readThreadNetworkDiagnosticsRxDataPollCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxBeaconCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxBeaconCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxBeaconCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxBeaconCountCommandParams
        );
        result.put("readRxBeaconCountAttribute", readThreadNetworkDiagnosticsRxBeaconCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxBeaconRequestCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxBeaconRequestCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxBeaconRequestCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxBeaconRequestCountCommandParams
        );
        result.put("readRxBeaconRequestCountAttribute", readThreadNetworkDiagnosticsRxBeaconRequestCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxOtherCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxOtherCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxOtherCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxOtherCountCommandParams
        );
        result.put("readRxOtherCountAttribute", readThreadNetworkDiagnosticsRxOtherCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxAddressFilteredCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxAddressFilteredCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxAddressFilteredCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxAddressFilteredCountCommandParams
        );
        result.put("readRxAddressFilteredCountAttribute", readThreadNetworkDiagnosticsRxAddressFilteredCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxDestAddrFilteredCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxDestAddrFilteredCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxDestAddrFilteredCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxDestAddrFilteredCountCommandParams
        );
        result.put("readRxDestAddrFilteredCountAttribute", readThreadNetworkDiagnosticsRxDestAddrFilteredCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxDuplicatedCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxDuplicatedCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxDuplicatedCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxDuplicatedCountCommandParams
        );
        result.put("readRxDuplicatedCountAttribute", readThreadNetworkDiagnosticsRxDuplicatedCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxErrNoFrameCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxErrNoFrameCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxErrNoFrameCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxErrNoFrameCountCommandParams
        );
        result.put("readRxErrNoFrameCountAttribute", readThreadNetworkDiagnosticsRxErrNoFrameCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxErrUnknownNeighborCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxErrUnknownNeighborCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxErrUnknownNeighborCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxErrUnknownNeighborCountCommandParams
        );
        result.put("readRxErrUnknownNeighborCountAttribute", readThreadNetworkDiagnosticsRxErrUnknownNeighborCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxErrInvalidSrcAddrCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxErrInvalidSrcAddrCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxErrInvalidSrcAddrCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxErrInvalidSrcAddrCountCommandParams
        );
        result.put("readRxErrInvalidSrcAddrCountAttribute", readThreadNetworkDiagnosticsRxErrInvalidSrcAddrCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxErrSecCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxErrSecCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxErrSecCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxErrSecCountCommandParams
        );
        result.put("readRxErrSecCountAttribute", readThreadNetworkDiagnosticsRxErrSecCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxErrFcsCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxErrFcsCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxErrFcsCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxErrFcsCountCommandParams
        );
        result.put("readRxErrFcsCountAttribute", readThreadNetworkDiagnosticsRxErrFcsCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsRxErrOtherCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsRxErrOtherCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readRxErrOtherCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsRxErrOtherCountCommandParams
        );
        result.put("readRxErrOtherCountAttribute", readThreadNetworkDiagnosticsRxErrOtherCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsActiveTimestampCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsActiveTimestampAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readActiveTimestampAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.ActiveTimestampAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterActiveTimestampAttributeCallback(),
          readThreadNetworkDiagnosticsActiveTimestampCommandParams
        );
        result.put("readActiveTimestampAttribute", readThreadNetworkDiagnosticsActiveTimestampAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsPendingTimestampCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsPendingTimestampAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readPendingTimestampAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.PendingTimestampAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterPendingTimestampAttributeCallback(),
          readThreadNetworkDiagnosticsPendingTimestampCommandParams
        );
        result.put("readPendingTimestampAttribute", readThreadNetworkDiagnosticsPendingTimestampAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsDelayCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsDelayAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readDelayAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.DelayAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterDelayAttributeCallback(),
          readThreadNetworkDiagnosticsDelayCommandParams
        );
        result.put("readDelayAttribute", readThreadNetworkDiagnosticsDelayAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsChannelPage0MaskCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsChannelPage0MaskAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readChannelPage0MaskAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.ChannelPage0MaskAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterChannelPage0MaskAttributeCallback(),
          readThreadNetworkDiagnosticsChannelPage0MaskCommandParams
        );
        result.put("readChannelPage0MaskAttribute", readThreadNetworkDiagnosticsChannelPage0MaskAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsActiveNetworkFaultsListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsActiveNetworkFaultsListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readActiveNetworkFaultsListAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.ActiveNetworkFaultsListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterActiveNetworkFaultsListAttributeCallback(),
          readThreadNetworkDiagnosticsActiveNetworkFaultsListCommandParams
        );
        result.put("readActiveNetworkFaultsListAttribute", readThreadNetworkDiagnosticsActiveNetworkFaultsListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterGeneratedCommandListAttributeCallback(),
          readThreadNetworkDiagnosticsGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readThreadNetworkDiagnosticsGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterAcceptedCommandListAttributeCallback(),
          readThreadNetworkDiagnosticsAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readThreadNetworkDiagnosticsAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readEventListAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterEventListAttributeCallback(),
          readThreadNetworkDiagnosticsEventListCommandParams
        );
        result.put("readEventListAttribute", readThreadNetworkDiagnosticsEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ThreadNetworkDiagnosticsCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThreadNetworkDiagnosticsClusterAttributeListAttributeCallback(),
          readThreadNetworkDiagnosticsAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readThreadNetworkDiagnosticsAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThreadNetworkDiagnosticsFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readThreadNetworkDiagnosticsFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThreadNetworkDiagnosticsClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThreadNetworkDiagnosticsClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThreadNetworkDiagnosticsCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThreadNetworkDiagnosticsClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readThreadNetworkDiagnosticsClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readWiFiNetworkDiagnosticsInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsBssidCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsBssidAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readBssidAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.BssidAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterBssidAttributeCallback(),
          readWiFiNetworkDiagnosticsBssidCommandParams
        );
        result.put("readBssidAttribute", readWiFiNetworkDiagnosticsBssidAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsSecurityTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsSecurityTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readSecurityTypeAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.SecurityTypeAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterSecurityTypeAttributeCallback(),
          readWiFiNetworkDiagnosticsSecurityTypeCommandParams
        );
        result.put("readSecurityTypeAttribute", readWiFiNetworkDiagnosticsSecurityTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsWiFiVersionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsWiFiVersionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readWiFiVersionAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.WiFiVersionAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterWiFiVersionAttributeCallback(),
          readWiFiNetworkDiagnosticsWiFiVersionCommandParams
        );
        result.put("readWiFiVersionAttribute", readWiFiNetworkDiagnosticsWiFiVersionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsChannelNumberCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsChannelNumberAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readChannelNumberAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.ChannelNumberAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterChannelNumberAttributeCallback(),
          readWiFiNetworkDiagnosticsChannelNumberCommandParams
        );
        result.put("readChannelNumberAttribute", readWiFiNetworkDiagnosticsChannelNumberAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsRssiCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsRssiAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readRssiAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.RssiAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterRssiAttributeCallback(),
          readWiFiNetworkDiagnosticsRssiCommandParams
        );
        result.put("readRssiAttribute", readWiFiNetworkDiagnosticsRssiAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsBeaconLostCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsBeaconLostCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readBeaconLostCountAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.BeaconLostCountAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterBeaconLostCountAttributeCallback(),
          readWiFiNetworkDiagnosticsBeaconLostCountCommandParams
        );
        result.put("readBeaconLostCountAttribute", readWiFiNetworkDiagnosticsBeaconLostCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsBeaconRxCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsBeaconRxCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readBeaconRxCountAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.BeaconRxCountAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterBeaconRxCountAttributeCallback(),
          readWiFiNetworkDiagnosticsBeaconRxCountCommandParams
        );
        result.put("readBeaconRxCountAttribute", readWiFiNetworkDiagnosticsBeaconRxCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsPacketMulticastRxCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsPacketMulticastRxCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readPacketMulticastRxCountAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.PacketMulticastRxCountAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterPacketMulticastRxCountAttributeCallback(),
          readWiFiNetworkDiagnosticsPacketMulticastRxCountCommandParams
        );
        result.put("readPacketMulticastRxCountAttribute", readWiFiNetworkDiagnosticsPacketMulticastRxCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsPacketMulticastTxCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsPacketMulticastTxCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readPacketMulticastTxCountAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.PacketMulticastTxCountAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterPacketMulticastTxCountAttributeCallback(),
          readWiFiNetworkDiagnosticsPacketMulticastTxCountCommandParams
        );
        result.put("readPacketMulticastTxCountAttribute", readWiFiNetworkDiagnosticsPacketMulticastTxCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsPacketUnicastRxCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsPacketUnicastRxCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readPacketUnicastRxCountAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.PacketUnicastRxCountAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterPacketUnicastRxCountAttributeCallback(),
          readWiFiNetworkDiagnosticsPacketUnicastRxCountCommandParams
        );
        result.put("readPacketUnicastRxCountAttribute", readWiFiNetworkDiagnosticsPacketUnicastRxCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsPacketUnicastTxCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsPacketUnicastTxCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readPacketUnicastTxCountAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.PacketUnicastTxCountAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterPacketUnicastTxCountAttributeCallback(),
          readWiFiNetworkDiagnosticsPacketUnicastTxCountCommandParams
        );
        result.put("readPacketUnicastTxCountAttribute", readWiFiNetworkDiagnosticsPacketUnicastTxCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsCurrentMaxRateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsCurrentMaxRateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readCurrentMaxRateAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.CurrentMaxRateAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterCurrentMaxRateAttributeCallback(),
          readWiFiNetworkDiagnosticsCurrentMaxRateCommandParams
        );
        result.put("readCurrentMaxRateAttribute", readWiFiNetworkDiagnosticsCurrentMaxRateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsOverrunCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsOverrunCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readOverrunCountAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.OverrunCountAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterOverrunCountAttributeCallback(),
          readWiFiNetworkDiagnosticsOverrunCountCommandParams
        );
        result.put("readOverrunCountAttribute", readWiFiNetworkDiagnosticsOverrunCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterGeneratedCommandListAttributeCallback(),
          readWiFiNetworkDiagnosticsGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readWiFiNetworkDiagnosticsGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterAcceptedCommandListAttributeCallback(),
          readWiFiNetworkDiagnosticsAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readWiFiNetworkDiagnosticsAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readEventListAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterEventListAttributeCallback(),
          readWiFiNetworkDiagnosticsEventListCommandParams
        );
        result.put("readEventListAttribute", readWiFiNetworkDiagnosticsEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readAttributeListAttribute(
              (ChipClusters.WiFiNetworkDiagnosticsCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWiFiNetworkDiagnosticsClusterAttributeListAttributeCallback(),
          readWiFiNetworkDiagnosticsAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readWiFiNetworkDiagnosticsAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readWiFiNetworkDiagnosticsFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readWiFiNetworkDiagnosticsFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWiFiNetworkDiagnosticsClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWiFiNetworkDiagnosticsClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WiFiNetworkDiagnosticsCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWiFiNetworkDiagnosticsClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readWiFiNetworkDiagnosticsClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readEthernetNetworkDiagnosticsInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsPHYRateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsPHYRateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readPHYRateAttribute(
              (ChipClusters.EthernetNetworkDiagnosticsCluster.PHYRateAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthernetNetworkDiagnosticsClusterPHYRateAttributeCallback(),
          readEthernetNetworkDiagnosticsPHYRateCommandParams
        );
        result.put("readPHYRateAttribute", readEthernetNetworkDiagnosticsPHYRateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsFullDuplexCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsFullDuplexAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readFullDuplexAttribute(
              (ChipClusters.EthernetNetworkDiagnosticsCluster.FullDuplexAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthernetNetworkDiagnosticsClusterFullDuplexAttributeCallback(),
          readEthernetNetworkDiagnosticsFullDuplexCommandParams
        );
        result.put("readFullDuplexAttribute", readEthernetNetworkDiagnosticsFullDuplexAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsPacketRxCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsPacketRxCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readPacketRxCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthernetNetworkDiagnosticsPacketRxCountCommandParams
        );
        result.put("readPacketRxCountAttribute", readEthernetNetworkDiagnosticsPacketRxCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsPacketTxCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsPacketTxCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readPacketTxCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthernetNetworkDiagnosticsPacketTxCountCommandParams
        );
        result.put("readPacketTxCountAttribute", readEthernetNetworkDiagnosticsPacketTxCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsTxErrCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsTxErrCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readTxErrCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthernetNetworkDiagnosticsTxErrCountCommandParams
        );
        result.put("readTxErrCountAttribute", readEthernetNetworkDiagnosticsTxErrCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsCollisionCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsCollisionCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readCollisionCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthernetNetworkDiagnosticsCollisionCountCommandParams
        );
        result.put("readCollisionCountAttribute", readEthernetNetworkDiagnosticsCollisionCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsOverrunCountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsOverrunCountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readOverrunCountAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthernetNetworkDiagnosticsOverrunCountCommandParams
        );
        result.put("readOverrunCountAttribute", readEthernetNetworkDiagnosticsOverrunCountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsCarrierDetectCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsCarrierDetectAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readCarrierDetectAttribute(
              (ChipClusters.EthernetNetworkDiagnosticsCluster.CarrierDetectAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthernetNetworkDiagnosticsClusterCarrierDetectAttributeCallback(),
          readEthernetNetworkDiagnosticsCarrierDetectCommandParams
        );
        result.put("readCarrierDetectAttribute", readEthernetNetworkDiagnosticsCarrierDetectAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsTimeSinceResetCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsTimeSinceResetAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readTimeSinceResetAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthernetNetworkDiagnosticsTimeSinceResetCommandParams
        );
        result.put("readTimeSinceResetAttribute", readEthernetNetworkDiagnosticsTimeSinceResetAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.EthernetNetworkDiagnosticsCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthernetNetworkDiagnosticsClusterGeneratedCommandListAttributeCallback(),
          readEthernetNetworkDiagnosticsGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readEthernetNetworkDiagnosticsGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.EthernetNetworkDiagnosticsCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthernetNetworkDiagnosticsClusterAcceptedCommandListAttributeCallback(),
          readEthernetNetworkDiagnosticsAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readEthernetNetworkDiagnosticsAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readEventListAttribute(
              (ChipClusters.EthernetNetworkDiagnosticsCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthernetNetworkDiagnosticsClusterEventListAttributeCallback(),
          readEthernetNetworkDiagnosticsEventListCommandParams
        );
        result.put("readEventListAttribute", readEthernetNetworkDiagnosticsEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readAttributeListAttribute(
              (ChipClusters.EthernetNetworkDiagnosticsCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthernetNetworkDiagnosticsClusterAttributeListAttributeCallback(),
          readEthernetNetworkDiagnosticsAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readEthernetNetworkDiagnosticsAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthernetNetworkDiagnosticsFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readEthernetNetworkDiagnosticsFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthernetNetworkDiagnosticsClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthernetNetworkDiagnosticsClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthernetNetworkDiagnosticsCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readEthernetNetworkDiagnosticsClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readEthernetNetworkDiagnosticsClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readTimeSynchronizationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readTimeSynchronizationUTCTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationUTCTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readUTCTimeAttribute(
              (ChipClusters.TimeSynchronizationCluster.UTCTimeAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeSynchronizationClusterUTCTimeAttributeCallback(),
          readTimeSynchronizationUTCTimeCommandParams
        );
        result.put("readUTCTimeAttribute", readTimeSynchronizationUTCTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationGranularityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationGranularityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readGranularityAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTimeSynchronizationGranularityCommandParams
        );
        result.put("readGranularityAttribute", readTimeSynchronizationGranularityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationTimeSourceCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationTimeSourceAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readTimeSourceAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTimeSynchronizationTimeSourceCommandParams
        );
        result.put("readTimeSourceAttribute", readTimeSynchronizationTimeSourceAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationDefaultNTPCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationDefaultNTPAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readDefaultNTPAttribute(
              (ChipClusters.TimeSynchronizationCluster.DefaultNTPAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeSynchronizationClusterDefaultNTPAttributeCallback(),
          readTimeSynchronizationDefaultNTPCommandParams
        );
        result.put("readDefaultNTPAttribute", readTimeSynchronizationDefaultNTPAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationTimeZoneCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationTimeZoneAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readTimeZoneAttribute(
              (ChipClusters.TimeSynchronizationCluster.TimeZoneAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeSynchronizationClusterTimeZoneAttributeCallback(),
          readTimeSynchronizationTimeZoneCommandParams
        );
        result.put("readTimeZoneAttribute", readTimeSynchronizationTimeZoneAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationDSTOffsetCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationDSTOffsetAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readDSTOffsetAttribute(
              (ChipClusters.TimeSynchronizationCluster.DSTOffsetAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeSynchronizationClusterDSTOffsetAttributeCallback(),
          readTimeSynchronizationDSTOffsetCommandParams
        );
        result.put("readDSTOffsetAttribute", readTimeSynchronizationDSTOffsetAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationLocalTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationLocalTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readLocalTimeAttribute(
              (ChipClusters.TimeSynchronizationCluster.LocalTimeAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeSynchronizationClusterLocalTimeAttributeCallback(),
          readTimeSynchronizationLocalTimeCommandParams
        );
        result.put("readLocalTimeAttribute", readTimeSynchronizationLocalTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationTimeZoneDatabaseCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationTimeZoneDatabaseAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readTimeZoneDatabaseAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTimeSynchronizationTimeZoneDatabaseCommandParams
        );
        result.put("readTimeZoneDatabaseAttribute", readTimeSynchronizationTimeZoneDatabaseAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationNTPServerAvailableCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationNTPServerAvailableAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readNTPServerAvailableAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readTimeSynchronizationNTPServerAvailableCommandParams
        );
        result.put("readNTPServerAvailableAttribute", readTimeSynchronizationNTPServerAvailableAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationTimeZoneListMaxSizeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationTimeZoneListMaxSizeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readTimeZoneListMaxSizeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTimeSynchronizationTimeZoneListMaxSizeCommandParams
        );
        result.put("readTimeZoneListMaxSizeAttribute", readTimeSynchronizationTimeZoneListMaxSizeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationDSTOffsetListMaxSizeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationDSTOffsetListMaxSizeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readDSTOffsetListMaxSizeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTimeSynchronizationDSTOffsetListMaxSizeCommandParams
        );
        result.put("readDSTOffsetListMaxSizeAttribute", readTimeSynchronizationDSTOffsetListMaxSizeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationSupportsDNSResolveCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationSupportsDNSResolveAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readSupportsDNSResolveAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readTimeSynchronizationSupportsDNSResolveCommandParams
        );
        result.put("readSupportsDNSResolveAttribute", readTimeSynchronizationSupportsDNSResolveAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.TimeSynchronizationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeSynchronizationClusterGeneratedCommandListAttributeCallback(),
          readTimeSynchronizationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readTimeSynchronizationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.TimeSynchronizationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeSynchronizationClusterAcceptedCommandListAttributeCallback(),
          readTimeSynchronizationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readTimeSynchronizationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readEventListAttribute(
              (ChipClusters.TimeSynchronizationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeSynchronizationClusterEventListAttributeCallback(),
          readTimeSynchronizationEventListCommandParams
        );
        result.put("readEventListAttribute", readTimeSynchronizationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.TimeSynchronizationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTimeSynchronizationClusterAttributeListAttributeCallback(),
          readTimeSynchronizationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readTimeSynchronizationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readTimeSynchronizationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readTimeSynchronizationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTimeSynchronizationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTimeSynchronizationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TimeSynchronizationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTimeSynchronizationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readTimeSynchronizationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readBridgedDeviceBasicInformationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationVendorNameCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationVendorNameAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readVendorNameAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBridgedDeviceBasicInformationVendorNameCommandParams
        );
        result.put("readVendorNameAttribute", readBridgedDeviceBasicInformationVendorNameAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationVendorIDCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationVendorIDAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readVendorIDAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBridgedDeviceBasicInformationVendorIDCommandParams
        );
        result.put("readVendorIDAttribute", readBridgedDeviceBasicInformationVendorIDAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationProductNameCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationProductNameAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readProductNameAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBridgedDeviceBasicInformationProductNameCommandParams
        );
        result.put("readProductNameAttribute", readBridgedDeviceBasicInformationProductNameAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationNodeLabelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationNodeLabelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readNodeLabelAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBridgedDeviceBasicInformationNodeLabelCommandParams
        );
        result.put("readNodeLabelAttribute", readBridgedDeviceBasicInformationNodeLabelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationHardwareVersionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationHardwareVersionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readHardwareVersionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBridgedDeviceBasicInformationHardwareVersionCommandParams
        );
        result.put("readHardwareVersionAttribute", readBridgedDeviceBasicInformationHardwareVersionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationHardwareVersionStringCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationHardwareVersionStringAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readHardwareVersionStringAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBridgedDeviceBasicInformationHardwareVersionStringCommandParams
        );
        result.put("readHardwareVersionStringAttribute", readBridgedDeviceBasicInformationHardwareVersionStringAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationSoftwareVersionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationSoftwareVersionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readSoftwareVersionAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readBridgedDeviceBasicInformationSoftwareVersionCommandParams
        );
        result.put("readSoftwareVersionAttribute", readBridgedDeviceBasicInformationSoftwareVersionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationSoftwareVersionStringCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationSoftwareVersionStringAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readSoftwareVersionStringAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBridgedDeviceBasicInformationSoftwareVersionStringCommandParams
        );
        result.put("readSoftwareVersionStringAttribute", readBridgedDeviceBasicInformationSoftwareVersionStringAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationManufacturingDateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationManufacturingDateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readManufacturingDateAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBridgedDeviceBasicInformationManufacturingDateCommandParams
        );
        result.put("readManufacturingDateAttribute", readBridgedDeviceBasicInformationManufacturingDateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationPartNumberCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationPartNumberAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readPartNumberAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBridgedDeviceBasicInformationPartNumberCommandParams
        );
        result.put("readPartNumberAttribute", readBridgedDeviceBasicInformationPartNumberAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationProductURLCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationProductURLAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readProductURLAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBridgedDeviceBasicInformationProductURLCommandParams
        );
        result.put("readProductURLAttribute", readBridgedDeviceBasicInformationProductURLAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationProductLabelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationProductLabelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readProductLabelAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBridgedDeviceBasicInformationProductLabelCommandParams
        );
        result.put("readProductLabelAttribute", readBridgedDeviceBasicInformationProductLabelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationSerialNumberCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationSerialNumberAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readSerialNumberAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBridgedDeviceBasicInformationSerialNumberCommandParams
        );
        result.put("readSerialNumberAttribute", readBridgedDeviceBasicInformationSerialNumberAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationReachableCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationReachableAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readReachableAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readBridgedDeviceBasicInformationReachableCommandParams
        );
        result.put("readReachableAttribute", readBridgedDeviceBasicInformationReachableAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationUniqueIDCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationUniqueIDAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readUniqueIDAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBridgedDeviceBasicInformationUniqueIDCommandParams
        );
        result.put("readUniqueIDAttribute", readBridgedDeviceBasicInformationUniqueIDAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.BridgedDeviceBasicInformationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBridgedDeviceBasicInformationClusterGeneratedCommandListAttributeCallback(),
          readBridgedDeviceBasicInformationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readBridgedDeviceBasicInformationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.BridgedDeviceBasicInformationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBridgedDeviceBasicInformationClusterAcceptedCommandListAttributeCallback(),
          readBridgedDeviceBasicInformationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readBridgedDeviceBasicInformationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readEventListAttribute(
              (ChipClusters.BridgedDeviceBasicInformationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBridgedDeviceBasicInformationClusterEventListAttributeCallback(),
          readBridgedDeviceBasicInformationEventListCommandParams
        );
        result.put("readEventListAttribute", readBridgedDeviceBasicInformationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.BridgedDeviceBasicInformationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBridgedDeviceBasicInformationClusterAttributeListAttributeCallback(),
          readBridgedDeviceBasicInformationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readBridgedDeviceBasicInformationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readBridgedDeviceBasicInformationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readBridgedDeviceBasicInformationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBridgedDeviceBasicInformationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBridgedDeviceBasicInformationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BridgedDeviceBasicInformationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBridgedDeviceBasicInformationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readBridgedDeviceBasicInformationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readSwitchInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readSwitchNumberOfPositionsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSwitchNumberOfPositionsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SwitchCluster) cluster).readNumberOfPositionsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSwitchNumberOfPositionsCommandParams
        );
        result.put("readNumberOfPositionsAttribute", readSwitchNumberOfPositionsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSwitchCurrentPositionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSwitchCurrentPositionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SwitchCluster) cluster).readCurrentPositionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSwitchCurrentPositionCommandParams
        );
        result.put("readCurrentPositionAttribute", readSwitchCurrentPositionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSwitchMultiPressMaxCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSwitchMultiPressMaxAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SwitchCluster) cluster).readMultiPressMaxAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSwitchMultiPressMaxCommandParams
        );
        result.put("readMultiPressMaxAttribute", readSwitchMultiPressMaxAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSwitchGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSwitchGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SwitchCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.SwitchCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSwitchClusterGeneratedCommandListAttributeCallback(),
          readSwitchGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readSwitchGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSwitchAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSwitchAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SwitchCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.SwitchCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSwitchClusterAcceptedCommandListAttributeCallback(),
          readSwitchAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readSwitchAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSwitchEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSwitchEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SwitchCluster) cluster).readEventListAttribute(
              (ChipClusters.SwitchCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSwitchClusterEventListAttributeCallback(),
          readSwitchEventListCommandParams
        );
        result.put("readEventListAttribute", readSwitchEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSwitchAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSwitchAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SwitchCluster) cluster).readAttributeListAttribute(
              (ChipClusters.SwitchCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSwitchClusterAttributeListAttributeCallback(),
          readSwitchAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readSwitchAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSwitchFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSwitchFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SwitchCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readSwitchFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readSwitchFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSwitchClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSwitchClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SwitchCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSwitchClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readSwitchClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readAdministratorCommissioningInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readAdministratorCommissioningWindowStatusCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAdministratorCommissioningWindowStatusAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AdministratorCommissioningCluster) cluster).readWindowStatusAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readAdministratorCommissioningWindowStatusCommandParams
        );
        result.put("readWindowStatusAttribute", readAdministratorCommissioningWindowStatusAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAdministratorCommissioningAdminFabricIndexCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAdministratorCommissioningAdminFabricIndexAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AdministratorCommissioningCluster) cluster).readAdminFabricIndexAttribute(
              (ChipClusters.AdministratorCommissioningCluster.AdminFabricIndexAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAdministratorCommissioningClusterAdminFabricIndexAttributeCallback(),
          readAdministratorCommissioningAdminFabricIndexCommandParams
        );
        result.put("readAdminFabricIndexAttribute", readAdministratorCommissioningAdminFabricIndexAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAdministratorCommissioningAdminVendorIdCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAdministratorCommissioningAdminVendorIdAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AdministratorCommissioningCluster) cluster).readAdminVendorIdAttribute(
              (ChipClusters.AdministratorCommissioningCluster.AdminVendorIdAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAdministratorCommissioningClusterAdminVendorIdAttributeCallback(),
          readAdministratorCommissioningAdminVendorIdCommandParams
        );
        result.put("readAdminVendorIdAttribute", readAdministratorCommissioningAdminVendorIdAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAdministratorCommissioningGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAdministratorCommissioningGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AdministratorCommissioningCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.AdministratorCommissioningCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAdministratorCommissioningClusterGeneratedCommandListAttributeCallback(),
          readAdministratorCommissioningGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readAdministratorCommissioningGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAdministratorCommissioningAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAdministratorCommissioningAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AdministratorCommissioningCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.AdministratorCommissioningCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAdministratorCommissioningClusterAcceptedCommandListAttributeCallback(),
          readAdministratorCommissioningAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readAdministratorCommissioningAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAdministratorCommissioningEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAdministratorCommissioningEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AdministratorCommissioningCluster) cluster).readEventListAttribute(
              (ChipClusters.AdministratorCommissioningCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAdministratorCommissioningClusterEventListAttributeCallback(),
          readAdministratorCommissioningEventListCommandParams
        );
        result.put("readEventListAttribute", readAdministratorCommissioningEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAdministratorCommissioningAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAdministratorCommissioningAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AdministratorCommissioningCluster) cluster).readAttributeListAttribute(
              (ChipClusters.AdministratorCommissioningCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAdministratorCommissioningClusterAttributeListAttributeCallback(),
          readAdministratorCommissioningAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readAdministratorCommissioningAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAdministratorCommissioningFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAdministratorCommissioningFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AdministratorCommissioningCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readAdministratorCommissioningFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readAdministratorCommissioningFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAdministratorCommissioningClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAdministratorCommissioningClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AdministratorCommissioningCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readAdministratorCommissioningClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readAdministratorCommissioningClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readOperationalCredentialsInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readOperationalCredentialsNOCsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsNOCsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readNOCsAttribute(
              (ChipClusters.OperationalCredentialsCluster.NOCsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalCredentialsClusterNOCsAttributeCallback(),
          readOperationalCredentialsNOCsCommandParams
        );
        result.put("readNOCsAttribute", readOperationalCredentialsNOCsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalCredentialsFabricsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsFabricsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readFabricsAttribute(
              (ChipClusters.OperationalCredentialsCluster.FabricsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalCredentialsClusterFabricsAttributeCallback(),
          readOperationalCredentialsFabricsCommandParams
        );
        result.put("readFabricsAttribute", readOperationalCredentialsFabricsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalCredentialsSupportedFabricsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsSupportedFabricsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readSupportedFabricsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOperationalCredentialsSupportedFabricsCommandParams
        );
        result.put("readSupportedFabricsAttribute", readOperationalCredentialsSupportedFabricsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalCredentialsCommissionedFabricsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsCommissionedFabricsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readCommissionedFabricsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOperationalCredentialsCommissionedFabricsCommandParams
        );
        result.put("readCommissionedFabricsAttribute", readOperationalCredentialsCommissionedFabricsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalCredentialsTrustedRootCertificatesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsTrustedRootCertificatesAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readTrustedRootCertificatesAttribute(
              (ChipClusters.OperationalCredentialsCluster.TrustedRootCertificatesAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalCredentialsClusterTrustedRootCertificatesAttributeCallback(),
          readOperationalCredentialsTrustedRootCertificatesCommandParams
        );
        result.put("readTrustedRootCertificatesAttribute", readOperationalCredentialsTrustedRootCertificatesAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalCredentialsCurrentFabricIndexCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsCurrentFabricIndexAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readCurrentFabricIndexAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOperationalCredentialsCurrentFabricIndexCommandParams
        );
        result.put("readCurrentFabricIndexAttribute", readOperationalCredentialsCurrentFabricIndexAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalCredentialsGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.OperationalCredentialsCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalCredentialsClusterGeneratedCommandListAttributeCallback(),
          readOperationalCredentialsGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readOperationalCredentialsGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalCredentialsAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.OperationalCredentialsCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalCredentialsClusterAcceptedCommandListAttributeCallback(),
          readOperationalCredentialsAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readOperationalCredentialsAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalCredentialsEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readEventListAttribute(
              (ChipClusters.OperationalCredentialsCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalCredentialsClusterEventListAttributeCallback(),
          readOperationalCredentialsEventListCommandParams
        );
        result.put("readEventListAttribute", readOperationalCredentialsEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalCredentialsAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readAttributeListAttribute(
              (ChipClusters.OperationalCredentialsCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalCredentialsClusterAttributeListAttributeCallback(),
          readOperationalCredentialsAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readOperationalCredentialsAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalCredentialsFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOperationalCredentialsFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readOperationalCredentialsFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalCredentialsClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalCredentialsClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalCredentialsCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOperationalCredentialsClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readOperationalCredentialsClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readGroupKeyManagementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readGroupKeyManagementGroupKeyMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupKeyManagementGroupKeyMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupKeyManagementCluster) cluster).readGroupKeyMapAttribute(
              (ChipClusters.GroupKeyManagementCluster.GroupKeyMapAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGroupKeyManagementClusterGroupKeyMapAttributeCallback(),
          readGroupKeyManagementGroupKeyMapCommandParams
        );
        result.put("readGroupKeyMapAttribute", readGroupKeyManagementGroupKeyMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupKeyManagementGroupTableCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupKeyManagementGroupTableAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupKeyManagementCluster) cluster).readGroupTableAttribute(
              (ChipClusters.GroupKeyManagementCluster.GroupTableAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGroupKeyManagementClusterGroupTableAttributeCallback(),
          readGroupKeyManagementGroupTableCommandParams
        );
        result.put("readGroupTableAttribute", readGroupKeyManagementGroupTableAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupKeyManagementMaxGroupsPerFabricCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupKeyManagementMaxGroupsPerFabricAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupKeyManagementCluster) cluster).readMaxGroupsPerFabricAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readGroupKeyManagementMaxGroupsPerFabricCommandParams
        );
        result.put("readMaxGroupsPerFabricAttribute", readGroupKeyManagementMaxGroupsPerFabricAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupKeyManagementMaxGroupKeysPerFabricCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupKeyManagementMaxGroupKeysPerFabricAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupKeyManagementCluster) cluster).readMaxGroupKeysPerFabricAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readGroupKeyManagementMaxGroupKeysPerFabricCommandParams
        );
        result.put("readMaxGroupKeysPerFabricAttribute", readGroupKeyManagementMaxGroupKeysPerFabricAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupKeyManagementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupKeyManagementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupKeyManagementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.GroupKeyManagementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGroupKeyManagementClusterGeneratedCommandListAttributeCallback(),
          readGroupKeyManagementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readGroupKeyManagementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupKeyManagementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupKeyManagementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupKeyManagementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.GroupKeyManagementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGroupKeyManagementClusterAcceptedCommandListAttributeCallback(),
          readGroupKeyManagementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readGroupKeyManagementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupKeyManagementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupKeyManagementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupKeyManagementCluster) cluster).readEventListAttribute(
              (ChipClusters.GroupKeyManagementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGroupKeyManagementClusterEventListAttributeCallback(),
          readGroupKeyManagementEventListCommandParams
        );
        result.put("readEventListAttribute", readGroupKeyManagementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupKeyManagementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupKeyManagementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupKeyManagementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.GroupKeyManagementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedGroupKeyManagementClusterAttributeListAttributeCallback(),
          readGroupKeyManagementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readGroupKeyManagementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupKeyManagementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupKeyManagementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupKeyManagementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readGroupKeyManagementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readGroupKeyManagementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readGroupKeyManagementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readGroupKeyManagementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.GroupKeyManagementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readGroupKeyManagementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readGroupKeyManagementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readFixedLabelInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readFixedLabelLabelListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFixedLabelLabelListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FixedLabelCluster) cluster).readLabelListAttribute(
              (ChipClusters.FixedLabelCluster.LabelListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFixedLabelClusterLabelListAttributeCallback(),
          readFixedLabelLabelListCommandParams
        );
        result.put("readLabelListAttribute", readFixedLabelLabelListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFixedLabelGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFixedLabelGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FixedLabelCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.FixedLabelCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFixedLabelClusterGeneratedCommandListAttributeCallback(),
          readFixedLabelGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readFixedLabelGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFixedLabelAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFixedLabelAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FixedLabelCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.FixedLabelCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFixedLabelClusterAcceptedCommandListAttributeCallback(),
          readFixedLabelAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readFixedLabelAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFixedLabelEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFixedLabelEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FixedLabelCluster) cluster).readEventListAttribute(
              (ChipClusters.FixedLabelCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFixedLabelClusterEventListAttributeCallback(),
          readFixedLabelEventListCommandParams
        );
        result.put("readEventListAttribute", readFixedLabelEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFixedLabelAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFixedLabelAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FixedLabelCluster) cluster).readAttributeListAttribute(
              (ChipClusters.FixedLabelCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFixedLabelClusterAttributeListAttributeCallback(),
          readFixedLabelAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readFixedLabelAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFixedLabelFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFixedLabelFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FixedLabelCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readFixedLabelFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readFixedLabelFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFixedLabelClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFixedLabelClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FixedLabelCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFixedLabelClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readFixedLabelClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readUserLabelInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readUserLabelLabelListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUserLabelLabelListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UserLabelCluster) cluster).readLabelListAttribute(
              (ChipClusters.UserLabelCluster.LabelListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUserLabelClusterLabelListAttributeCallback(),
          readUserLabelLabelListCommandParams
        );
        result.put("readLabelListAttribute", readUserLabelLabelListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUserLabelGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUserLabelGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UserLabelCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.UserLabelCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUserLabelClusterGeneratedCommandListAttributeCallback(),
          readUserLabelGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readUserLabelGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUserLabelAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUserLabelAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UserLabelCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.UserLabelCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUserLabelClusterAcceptedCommandListAttributeCallback(),
          readUserLabelAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readUserLabelAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUserLabelEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUserLabelEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UserLabelCluster) cluster).readEventListAttribute(
              (ChipClusters.UserLabelCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUserLabelClusterEventListAttributeCallback(),
          readUserLabelEventListCommandParams
        );
        result.put("readEventListAttribute", readUserLabelEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUserLabelAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUserLabelAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UserLabelCluster) cluster).readAttributeListAttribute(
              (ChipClusters.UserLabelCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUserLabelClusterAttributeListAttributeCallback(),
          readUserLabelAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readUserLabelAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUserLabelFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUserLabelFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UserLabelCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readUserLabelFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readUserLabelFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUserLabelClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUserLabelClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UserLabelCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readUserLabelClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readUserLabelClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readProxyConfigurationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readProxyConfigurationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyConfigurationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyConfigurationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ProxyConfigurationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyConfigurationClusterGeneratedCommandListAttributeCallback(),
          readProxyConfigurationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readProxyConfigurationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyConfigurationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyConfigurationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyConfigurationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ProxyConfigurationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyConfigurationClusterAcceptedCommandListAttributeCallback(),
          readProxyConfigurationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readProxyConfigurationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyConfigurationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyConfigurationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyConfigurationCluster) cluster).readEventListAttribute(
              (ChipClusters.ProxyConfigurationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyConfigurationClusterEventListAttributeCallback(),
          readProxyConfigurationEventListCommandParams
        );
        result.put("readEventListAttribute", readProxyConfigurationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyConfigurationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyConfigurationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyConfigurationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ProxyConfigurationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyConfigurationClusterAttributeListAttributeCallback(),
          readProxyConfigurationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readProxyConfigurationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyConfigurationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyConfigurationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyConfigurationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readProxyConfigurationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readProxyConfigurationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyConfigurationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyConfigurationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyConfigurationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readProxyConfigurationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readProxyConfigurationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readProxyDiscoveryInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readProxyDiscoveryGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyDiscoveryGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyDiscoveryCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ProxyDiscoveryCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyDiscoveryClusterGeneratedCommandListAttributeCallback(),
          readProxyDiscoveryGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readProxyDiscoveryGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyDiscoveryAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyDiscoveryAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyDiscoveryCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ProxyDiscoveryCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyDiscoveryClusterAcceptedCommandListAttributeCallback(),
          readProxyDiscoveryAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readProxyDiscoveryAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyDiscoveryEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyDiscoveryEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyDiscoveryCluster) cluster).readEventListAttribute(
              (ChipClusters.ProxyDiscoveryCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyDiscoveryClusterEventListAttributeCallback(),
          readProxyDiscoveryEventListCommandParams
        );
        result.put("readEventListAttribute", readProxyDiscoveryEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyDiscoveryAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyDiscoveryAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyDiscoveryCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ProxyDiscoveryCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyDiscoveryClusterAttributeListAttributeCallback(),
          readProxyDiscoveryAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readProxyDiscoveryAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyDiscoveryFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyDiscoveryFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyDiscoveryCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readProxyDiscoveryFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readProxyDiscoveryFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyDiscoveryClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyDiscoveryClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyDiscoveryCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readProxyDiscoveryClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readProxyDiscoveryClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readProxyValidInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readProxyValidGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyValidGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyValidCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ProxyValidCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyValidClusterGeneratedCommandListAttributeCallback(),
          readProxyValidGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readProxyValidGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyValidAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyValidAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyValidCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ProxyValidCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyValidClusterAcceptedCommandListAttributeCallback(),
          readProxyValidAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readProxyValidAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyValidEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyValidEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyValidCluster) cluster).readEventListAttribute(
              (ChipClusters.ProxyValidCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyValidClusterEventListAttributeCallback(),
          readProxyValidEventListCommandParams
        );
        result.put("readEventListAttribute", readProxyValidEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyValidAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyValidAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyValidCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ProxyValidCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedProxyValidClusterAttributeListAttributeCallback(),
          readProxyValidAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readProxyValidAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyValidFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyValidFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyValidCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readProxyValidFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readProxyValidFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readProxyValidClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readProxyValidClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ProxyValidCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readProxyValidClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readProxyValidClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readBooleanStateInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readBooleanStateStateValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBooleanStateStateValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BooleanStateCluster) cluster).readStateValueAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readBooleanStateStateValueCommandParams
        );
        result.put("readStateValueAttribute", readBooleanStateStateValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBooleanStateGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBooleanStateGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BooleanStateCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.BooleanStateCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanStateClusterGeneratedCommandListAttributeCallback(),
          readBooleanStateGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readBooleanStateGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBooleanStateAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBooleanStateAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BooleanStateCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.BooleanStateCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanStateClusterAcceptedCommandListAttributeCallback(),
          readBooleanStateAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readBooleanStateAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBooleanStateEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBooleanStateEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BooleanStateCluster) cluster).readEventListAttribute(
              (ChipClusters.BooleanStateCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanStateClusterEventListAttributeCallback(),
          readBooleanStateEventListCommandParams
        );
        result.put("readEventListAttribute", readBooleanStateEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBooleanStateAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBooleanStateAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BooleanStateCluster) cluster).readAttributeListAttribute(
              (ChipClusters.BooleanStateCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanStateClusterAttributeListAttributeCallback(),
          readBooleanStateAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readBooleanStateAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBooleanStateFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBooleanStateFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BooleanStateCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readBooleanStateFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readBooleanStateFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBooleanStateClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBooleanStateClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BooleanStateCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBooleanStateClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readBooleanStateClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readIcdManagementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readIcdManagementIdleModeIntervalCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementIdleModeIntervalAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readIdleModeIntervalAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readIcdManagementIdleModeIntervalCommandParams
        );
        result.put("readIdleModeIntervalAttribute", readIcdManagementIdleModeIntervalAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIcdManagementActiveModeIntervalCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementActiveModeIntervalAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readActiveModeIntervalAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readIcdManagementActiveModeIntervalCommandParams
        );
        result.put("readActiveModeIntervalAttribute", readIcdManagementActiveModeIntervalAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIcdManagementActiveModeThresholdCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementActiveModeThresholdAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readActiveModeThresholdAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIcdManagementActiveModeThresholdCommandParams
        );
        result.put("readActiveModeThresholdAttribute", readIcdManagementActiveModeThresholdAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIcdManagementRegisteredClientsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementRegisteredClientsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readRegisteredClientsAttribute(
              (ChipClusters.IcdManagementCluster.RegisteredClientsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIcdManagementClusterRegisteredClientsAttributeCallback(),
          readIcdManagementRegisteredClientsCommandParams
        );
        result.put("readRegisteredClientsAttribute", readIcdManagementRegisteredClientsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIcdManagementICDCounterCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementICDCounterAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readICDCounterAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readIcdManagementICDCounterCommandParams
        );
        result.put("readICDCounterAttribute", readIcdManagementICDCounterAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIcdManagementClientsSupportedPerFabricCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementClientsSupportedPerFabricAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readClientsSupportedPerFabricAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIcdManagementClientsSupportedPerFabricCommandParams
        );
        result.put("readClientsSupportedPerFabricAttribute", readIcdManagementClientsSupportedPerFabricAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIcdManagementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.IcdManagementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIcdManagementClusterGeneratedCommandListAttributeCallback(),
          readIcdManagementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readIcdManagementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIcdManagementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.IcdManagementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIcdManagementClusterAcceptedCommandListAttributeCallback(),
          readIcdManagementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readIcdManagementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIcdManagementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readEventListAttribute(
              (ChipClusters.IcdManagementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIcdManagementClusterEventListAttributeCallback(),
          readIcdManagementEventListCommandParams
        );
        result.put("readEventListAttribute", readIcdManagementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIcdManagementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.IcdManagementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIcdManagementClusterAttributeListAttributeCallback(),
          readIcdManagementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readIcdManagementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIcdManagementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readIcdManagementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readIcdManagementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIcdManagementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIcdManagementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IcdManagementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIcdManagementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readIcdManagementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readModeSelectInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readModeSelectDescriptionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectDescriptionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readDescriptionAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readModeSelectDescriptionCommandParams
        );
        result.put("readDescriptionAttribute", readModeSelectDescriptionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readModeSelectStandardNamespaceCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectStandardNamespaceAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readStandardNamespaceAttribute(
              (ChipClusters.ModeSelectCluster.StandardNamespaceAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedModeSelectClusterStandardNamespaceAttributeCallback(),
          readModeSelectStandardNamespaceCommandParams
        );
        result.put("readStandardNamespaceAttribute", readModeSelectStandardNamespaceAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readModeSelectSupportedModesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectSupportedModesAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readSupportedModesAttribute(
              (ChipClusters.ModeSelectCluster.SupportedModesAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedModeSelectClusterSupportedModesAttributeCallback(),
          readModeSelectSupportedModesCommandParams
        );
        result.put("readSupportedModesAttribute", readModeSelectSupportedModesAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readModeSelectCurrentModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectCurrentModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readCurrentModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readModeSelectCurrentModeCommandParams
        );
        result.put("readCurrentModeAttribute", readModeSelectCurrentModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readModeSelectStartUpModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectStartUpModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readStartUpModeAttribute(
              (ChipClusters.ModeSelectCluster.StartUpModeAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedModeSelectClusterStartUpModeAttributeCallback(),
          readModeSelectStartUpModeCommandParams
        );
        result.put("readStartUpModeAttribute", readModeSelectStartUpModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readModeSelectOnModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectOnModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readOnModeAttribute(
              (ChipClusters.ModeSelectCluster.OnModeAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedModeSelectClusterOnModeAttributeCallback(),
          readModeSelectOnModeCommandParams
        );
        result.put("readOnModeAttribute", readModeSelectOnModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readModeSelectGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ModeSelectCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedModeSelectClusterGeneratedCommandListAttributeCallback(),
          readModeSelectGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readModeSelectGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readModeSelectAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ModeSelectCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedModeSelectClusterAcceptedCommandListAttributeCallback(),
          readModeSelectAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readModeSelectAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readModeSelectEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readEventListAttribute(
              (ChipClusters.ModeSelectCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedModeSelectClusterEventListAttributeCallback(),
          readModeSelectEventListCommandParams
        );
        result.put("readEventListAttribute", readModeSelectEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readModeSelectAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ModeSelectCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedModeSelectClusterAttributeListAttributeCallback(),
          readModeSelectAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readModeSelectAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readModeSelectFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readModeSelectFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readModeSelectFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readModeSelectClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readModeSelectClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ModeSelectCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readModeSelectClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readModeSelectClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readTemperatureControlInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readTemperatureControlTemperatureSetpointCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlTemperatureSetpointAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readTemperatureSetpointAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTemperatureControlTemperatureSetpointCommandParams
        );
        result.put("readTemperatureSetpointAttribute", readTemperatureControlTemperatureSetpointAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureControlMinTemperatureCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlMinTemperatureAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readMinTemperatureAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTemperatureControlMinTemperatureCommandParams
        );
        result.put("readMinTemperatureAttribute", readTemperatureControlMinTemperatureAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureControlMaxTemperatureCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlMaxTemperatureAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readMaxTemperatureAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTemperatureControlMaxTemperatureCommandParams
        );
        result.put("readMaxTemperatureAttribute", readTemperatureControlMaxTemperatureAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureControlStepCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlStepAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readStepAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTemperatureControlStepCommandParams
        );
        result.put("readStepAttribute", readTemperatureControlStepAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureControlCurrentTemperatureLevelIndexCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlCurrentTemperatureLevelIndexAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readCurrentTemperatureLevelIndexAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTemperatureControlCurrentTemperatureLevelIndexCommandParams
        );
        result.put("readCurrentTemperatureLevelIndexAttribute", readTemperatureControlCurrentTemperatureLevelIndexAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureControlSupportedTemperatureLevelsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlSupportedTemperatureLevelsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readSupportedTemperatureLevelsAttribute(
              (ChipClusters.TemperatureControlCluster.SupportedTemperatureLevelsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureControlClusterSupportedTemperatureLevelsAttributeCallback(),
          readTemperatureControlSupportedTemperatureLevelsCommandParams
        );
        result.put("readSupportedTemperatureLevelsAttribute", readTemperatureControlSupportedTemperatureLevelsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureControlGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.TemperatureControlCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureControlClusterGeneratedCommandListAttributeCallback(),
          readTemperatureControlGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readTemperatureControlGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureControlAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.TemperatureControlCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureControlClusterAcceptedCommandListAttributeCallback(),
          readTemperatureControlAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readTemperatureControlAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureControlEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readEventListAttribute(
              (ChipClusters.TemperatureControlCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureControlClusterEventListAttributeCallback(),
          readTemperatureControlEventListCommandParams
        );
        result.put("readEventListAttribute", readTemperatureControlEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureControlAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readAttributeListAttribute(
              (ChipClusters.TemperatureControlCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureControlClusterAttributeListAttributeCallback(),
          readTemperatureControlAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readTemperatureControlAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureControlFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readTemperatureControlFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readTemperatureControlFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureControlClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureControlClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureControlCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTemperatureControlClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readTemperatureControlClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readRefrigeratorAlarmInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readRefrigeratorAlarmMaskCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRefrigeratorAlarmMaskAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RefrigeratorAlarmCluster) cluster).readMaskAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readRefrigeratorAlarmMaskCommandParams
        );
        result.put("readMaskAttribute", readRefrigeratorAlarmMaskAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRefrigeratorAlarmLatchCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRefrigeratorAlarmLatchAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RefrigeratorAlarmCluster) cluster).readLatchAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readRefrigeratorAlarmLatchCommandParams
        );
        result.put("readLatchAttribute", readRefrigeratorAlarmLatchAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRefrigeratorAlarmStateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRefrigeratorAlarmStateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RefrigeratorAlarmCluster) cluster).readStateAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readRefrigeratorAlarmStateCommandParams
        );
        result.put("readStateAttribute", readRefrigeratorAlarmStateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRefrigeratorAlarmGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRefrigeratorAlarmGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RefrigeratorAlarmCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.RefrigeratorAlarmCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedRefrigeratorAlarmClusterGeneratedCommandListAttributeCallback(),
          readRefrigeratorAlarmGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readRefrigeratorAlarmGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRefrigeratorAlarmAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRefrigeratorAlarmAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RefrigeratorAlarmCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.RefrigeratorAlarmCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedRefrigeratorAlarmClusterAcceptedCommandListAttributeCallback(),
          readRefrigeratorAlarmAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readRefrigeratorAlarmAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRefrigeratorAlarmEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRefrigeratorAlarmEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RefrigeratorAlarmCluster) cluster).readEventListAttribute(
              (ChipClusters.RefrigeratorAlarmCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedRefrigeratorAlarmClusterEventListAttributeCallback(),
          readRefrigeratorAlarmEventListCommandParams
        );
        result.put("readEventListAttribute", readRefrigeratorAlarmEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRefrigeratorAlarmAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRefrigeratorAlarmAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RefrigeratorAlarmCluster) cluster).readAttributeListAttribute(
              (ChipClusters.RefrigeratorAlarmCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedRefrigeratorAlarmClusterAttributeListAttributeCallback(),
          readRefrigeratorAlarmAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readRefrigeratorAlarmAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRefrigeratorAlarmFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRefrigeratorAlarmFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RefrigeratorAlarmCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readRefrigeratorAlarmFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readRefrigeratorAlarmFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRefrigeratorAlarmClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRefrigeratorAlarmClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RefrigeratorAlarmCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readRefrigeratorAlarmClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readRefrigeratorAlarmClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readAirQualityInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readAirQualityAirQualityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAirQualityAirQualityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AirQualityCluster) cluster).readAirQualityAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readAirQualityAirQualityCommandParams
        );
        result.put("readAirQualityAttribute", readAirQualityAirQualityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAirQualityGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAirQualityGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AirQualityCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.AirQualityCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAirQualityClusterGeneratedCommandListAttributeCallback(),
          readAirQualityGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readAirQualityGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAirQualityAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAirQualityAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AirQualityCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.AirQualityCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAirQualityClusterAcceptedCommandListAttributeCallback(),
          readAirQualityAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readAirQualityAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAirQualityEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAirQualityEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AirQualityCluster) cluster).readEventListAttribute(
              (ChipClusters.AirQualityCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAirQualityClusterEventListAttributeCallback(),
          readAirQualityEventListCommandParams
        );
        result.put("readEventListAttribute", readAirQualityEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAirQualityAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAirQualityAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AirQualityCluster) cluster).readAttributeListAttribute(
              (ChipClusters.AirQualityCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedAirQualityClusterAttributeListAttributeCallback(),
          readAirQualityAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readAirQualityAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAirQualityFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAirQualityFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AirQualityCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readAirQualityFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readAirQualityFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readAirQualityClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readAirQualityClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.AirQualityCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readAirQualityClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readAirQualityClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readSmokeCoAlarmInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readSmokeCoAlarmExpressedStateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmExpressedStateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readExpressedStateAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSmokeCoAlarmExpressedStateCommandParams
        );
        result.put("readExpressedStateAttribute", readSmokeCoAlarmExpressedStateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmSmokeStateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmSmokeStateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readSmokeStateAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSmokeCoAlarmSmokeStateCommandParams
        );
        result.put("readSmokeStateAttribute", readSmokeCoAlarmSmokeStateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmCOStateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmCOStateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readCOStateAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSmokeCoAlarmCOStateCommandParams
        );
        result.put("readCOStateAttribute", readSmokeCoAlarmCOStateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmBatteryAlertCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmBatteryAlertAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readBatteryAlertAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSmokeCoAlarmBatteryAlertCommandParams
        );
        result.put("readBatteryAlertAttribute", readSmokeCoAlarmBatteryAlertAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmDeviceMutedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmDeviceMutedAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readDeviceMutedAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSmokeCoAlarmDeviceMutedCommandParams
        );
        result.put("readDeviceMutedAttribute", readSmokeCoAlarmDeviceMutedAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmTestInProgressCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmTestInProgressAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readTestInProgressAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readSmokeCoAlarmTestInProgressCommandParams
        );
        result.put("readTestInProgressAttribute", readSmokeCoAlarmTestInProgressAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmHardwareFaultAlertCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmHardwareFaultAlertAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readHardwareFaultAlertAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readSmokeCoAlarmHardwareFaultAlertCommandParams
        );
        result.put("readHardwareFaultAlertAttribute", readSmokeCoAlarmHardwareFaultAlertAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmEndOfServiceAlertCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmEndOfServiceAlertAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readEndOfServiceAlertAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSmokeCoAlarmEndOfServiceAlertCommandParams
        );
        result.put("readEndOfServiceAlertAttribute", readSmokeCoAlarmEndOfServiceAlertAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmInterconnectSmokeAlarmCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmInterconnectSmokeAlarmAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readInterconnectSmokeAlarmAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSmokeCoAlarmInterconnectSmokeAlarmCommandParams
        );
        result.put("readInterconnectSmokeAlarmAttribute", readSmokeCoAlarmInterconnectSmokeAlarmAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmInterconnectCOAlarmCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmInterconnectCOAlarmAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readInterconnectCOAlarmAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSmokeCoAlarmInterconnectCOAlarmCommandParams
        );
        result.put("readInterconnectCOAlarmAttribute", readSmokeCoAlarmInterconnectCOAlarmAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmContaminationStateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmContaminationStateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readContaminationStateAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSmokeCoAlarmContaminationStateCommandParams
        );
        result.put("readContaminationStateAttribute", readSmokeCoAlarmContaminationStateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmSensitivityLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmSensitivityLevelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readSensitivityLevelAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSmokeCoAlarmSensitivityLevelCommandParams
        );
        result.put("readSensitivityLevelAttribute", readSmokeCoAlarmSensitivityLevelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.SmokeCoAlarmCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSmokeCoAlarmClusterGeneratedCommandListAttributeCallback(),
          readSmokeCoAlarmGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readSmokeCoAlarmGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.SmokeCoAlarmCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSmokeCoAlarmClusterAcceptedCommandListAttributeCallback(),
          readSmokeCoAlarmAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readSmokeCoAlarmAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readEventListAttribute(
              (ChipClusters.SmokeCoAlarmCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSmokeCoAlarmClusterEventListAttributeCallback(),
          readSmokeCoAlarmEventListCommandParams
        );
        result.put("readEventListAttribute", readSmokeCoAlarmEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readAttributeListAttribute(
              (ChipClusters.SmokeCoAlarmCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSmokeCoAlarmClusterAttributeListAttributeCallback(),
          readSmokeCoAlarmAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readSmokeCoAlarmAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readSmokeCoAlarmFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readSmokeCoAlarmFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSmokeCoAlarmClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSmokeCoAlarmClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SmokeCoAlarmCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSmokeCoAlarmClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readSmokeCoAlarmClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readOperationalStateInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readOperationalStatePhaseListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalStatePhaseListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalStateCluster) cluster).readPhaseListAttribute(
              (ChipClusters.OperationalStateCluster.PhaseListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalStateClusterPhaseListAttributeCallback(),
          readOperationalStatePhaseListCommandParams
        );
        result.put("readPhaseListAttribute", readOperationalStatePhaseListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalStateCurrentPhaseCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalStateCurrentPhaseAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalStateCluster) cluster).readCurrentPhaseAttribute(
              (ChipClusters.OperationalStateCluster.CurrentPhaseAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalStateClusterCurrentPhaseAttributeCallback(),
          readOperationalStateCurrentPhaseCommandParams
        );
        result.put("readCurrentPhaseAttribute", readOperationalStateCurrentPhaseAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalStateCountdownTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalStateCountdownTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalStateCluster) cluster).readCountdownTimeAttribute(
              (ChipClusters.OperationalStateCluster.CountdownTimeAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalStateClusterCountdownTimeAttributeCallback(),
          readOperationalStateCountdownTimeCommandParams
        );
        result.put("readCountdownTimeAttribute", readOperationalStateCountdownTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalStateOperationalStateListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalStateOperationalStateListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalStateCluster) cluster).readOperationalStateListAttribute(
              (ChipClusters.OperationalStateCluster.OperationalStateListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalStateClusterOperationalStateListAttributeCallback(),
          readOperationalStateOperationalStateListCommandParams
        );
        result.put("readOperationalStateListAttribute", readOperationalStateOperationalStateListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalStateGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalStateGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalStateCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.OperationalStateCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalStateClusterGeneratedCommandListAttributeCallback(),
          readOperationalStateGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readOperationalStateGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalStateAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalStateAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalStateCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.OperationalStateCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalStateClusterAcceptedCommandListAttributeCallback(),
          readOperationalStateAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readOperationalStateAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalStateEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalStateEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalStateCluster) cluster).readEventListAttribute(
              (ChipClusters.OperationalStateCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalStateClusterEventListAttributeCallback(),
          readOperationalStateEventListCommandParams
        );
        result.put("readEventListAttribute", readOperationalStateEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalStateAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalStateAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalStateCluster) cluster).readAttributeListAttribute(
              (ChipClusters.OperationalStateCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOperationalStateClusterAttributeListAttributeCallback(),
          readOperationalStateAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readOperationalStateAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalStateFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalStateFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalStateCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOperationalStateFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readOperationalStateFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOperationalStateClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOperationalStateClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OperationalStateCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOperationalStateClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readOperationalStateClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readHepaFilterMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readHepaFilterMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHepaFilterMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HepaFilterMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHepaFilterMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readHepaFilterMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHepaFilterMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHepaFilterMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HepaFilterMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHepaFilterMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readHepaFilterMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHepaFilterMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHepaFilterMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HepaFilterMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHepaFilterMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readHepaFilterMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHepaFilterMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHepaFilterMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HepaFilterMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readHepaFilterMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readHepaFilterMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHepaFilterMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHepaFilterMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HepaFilterMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.HepaFilterMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHepaFilterMonitoringClusterGeneratedCommandListAttributeCallback(),
          readHepaFilterMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readHepaFilterMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHepaFilterMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHepaFilterMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HepaFilterMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.HepaFilterMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHepaFilterMonitoringClusterAcceptedCommandListAttributeCallback(),
          readHepaFilterMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readHepaFilterMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHepaFilterMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHepaFilterMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HepaFilterMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.HepaFilterMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHepaFilterMonitoringClusterEventListAttributeCallback(),
          readHepaFilterMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readHepaFilterMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHepaFilterMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHepaFilterMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HepaFilterMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.HepaFilterMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHepaFilterMonitoringClusterAttributeListAttributeCallback(),
          readHepaFilterMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readHepaFilterMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHepaFilterMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHepaFilterMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HepaFilterMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readHepaFilterMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readHepaFilterMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHepaFilterMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHepaFilterMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HepaFilterMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHepaFilterMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readHepaFilterMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readActivatedCarbonFilterMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readActivatedCarbonFilterMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActivatedCarbonFilterMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActivatedCarbonFilterMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readActivatedCarbonFilterMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readActivatedCarbonFilterMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActivatedCarbonFilterMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActivatedCarbonFilterMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActivatedCarbonFilterMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readActivatedCarbonFilterMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readActivatedCarbonFilterMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActivatedCarbonFilterMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActivatedCarbonFilterMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActivatedCarbonFilterMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readActivatedCarbonFilterMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readActivatedCarbonFilterMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActivatedCarbonFilterMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActivatedCarbonFilterMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActivatedCarbonFilterMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readActivatedCarbonFilterMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readActivatedCarbonFilterMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActivatedCarbonFilterMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActivatedCarbonFilterMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActivatedCarbonFilterMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ActivatedCarbonFilterMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedActivatedCarbonFilterMonitoringClusterGeneratedCommandListAttributeCallback(),
          readActivatedCarbonFilterMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readActivatedCarbonFilterMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActivatedCarbonFilterMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActivatedCarbonFilterMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActivatedCarbonFilterMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ActivatedCarbonFilterMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedActivatedCarbonFilterMonitoringClusterAcceptedCommandListAttributeCallback(),
          readActivatedCarbonFilterMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readActivatedCarbonFilterMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActivatedCarbonFilterMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActivatedCarbonFilterMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActivatedCarbonFilterMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.ActivatedCarbonFilterMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedActivatedCarbonFilterMonitoringClusterEventListAttributeCallback(),
          readActivatedCarbonFilterMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readActivatedCarbonFilterMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActivatedCarbonFilterMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActivatedCarbonFilterMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActivatedCarbonFilterMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ActivatedCarbonFilterMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedActivatedCarbonFilterMonitoringClusterAttributeListAttributeCallback(),
          readActivatedCarbonFilterMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readActivatedCarbonFilterMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActivatedCarbonFilterMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActivatedCarbonFilterMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActivatedCarbonFilterMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readActivatedCarbonFilterMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readActivatedCarbonFilterMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readActivatedCarbonFilterMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readActivatedCarbonFilterMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ActivatedCarbonFilterMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readActivatedCarbonFilterMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readActivatedCarbonFilterMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readCeramicFilterMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readCeramicFilterMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCeramicFilterMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CeramicFilterMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCeramicFilterMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readCeramicFilterMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCeramicFilterMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCeramicFilterMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CeramicFilterMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCeramicFilterMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readCeramicFilterMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCeramicFilterMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCeramicFilterMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CeramicFilterMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCeramicFilterMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readCeramicFilterMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCeramicFilterMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCeramicFilterMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CeramicFilterMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readCeramicFilterMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readCeramicFilterMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCeramicFilterMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCeramicFilterMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CeramicFilterMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.CeramicFilterMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCeramicFilterMonitoringClusterGeneratedCommandListAttributeCallback(),
          readCeramicFilterMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readCeramicFilterMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCeramicFilterMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCeramicFilterMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CeramicFilterMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.CeramicFilterMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCeramicFilterMonitoringClusterAcceptedCommandListAttributeCallback(),
          readCeramicFilterMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readCeramicFilterMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCeramicFilterMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCeramicFilterMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CeramicFilterMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.CeramicFilterMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCeramicFilterMonitoringClusterEventListAttributeCallback(),
          readCeramicFilterMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readCeramicFilterMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCeramicFilterMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCeramicFilterMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CeramicFilterMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.CeramicFilterMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCeramicFilterMonitoringClusterAttributeListAttributeCallback(),
          readCeramicFilterMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readCeramicFilterMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCeramicFilterMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCeramicFilterMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CeramicFilterMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readCeramicFilterMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readCeramicFilterMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCeramicFilterMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCeramicFilterMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CeramicFilterMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCeramicFilterMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readCeramicFilterMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readElectrostaticFilterMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readElectrostaticFilterMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readElectrostaticFilterMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ElectrostaticFilterMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readElectrostaticFilterMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readElectrostaticFilterMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readElectrostaticFilterMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readElectrostaticFilterMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ElectrostaticFilterMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readElectrostaticFilterMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readElectrostaticFilterMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readElectrostaticFilterMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readElectrostaticFilterMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ElectrostaticFilterMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readElectrostaticFilterMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readElectrostaticFilterMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readElectrostaticFilterMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readElectrostaticFilterMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ElectrostaticFilterMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readElectrostaticFilterMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readElectrostaticFilterMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readElectrostaticFilterMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readElectrostaticFilterMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ElectrostaticFilterMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ElectrostaticFilterMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedElectrostaticFilterMonitoringClusterGeneratedCommandListAttributeCallback(),
          readElectrostaticFilterMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readElectrostaticFilterMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readElectrostaticFilterMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readElectrostaticFilterMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ElectrostaticFilterMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ElectrostaticFilterMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedElectrostaticFilterMonitoringClusterAcceptedCommandListAttributeCallback(),
          readElectrostaticFilterMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readElectrostaticFilterMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readElectrostaticFilterMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readElectrostaticFilterMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ElectrostaticFilterMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.ElectrostaticFilterMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedElectrostaticFilterMonitoringClusterEventListAttributeCallback(),
          readElectrostaticFilterMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readElectrostaticFilterMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readElectrostaticFilterMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readElectrostaticFilterMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ElectrostaticFilterMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ElectrostaticFilterMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedElectrostaticFilterMonitoringClusterAttributeListAttributeCallback(),
          readElectrostaticFilterMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readElectrostaticFilterMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readElectrostaticFilterMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readElectrostaticFilterMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ElectrostaticFilterMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readElectrostaticFilterMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readElectrostaticFilterMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readElectrostaticFilterMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readElectrostaticFilterMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ElectrostaticFilterMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readElectrostaticFilterMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readElectrostaticFilterMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readUvFilterMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readUvFilterMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUvFilterMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UvFilterMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readUvFilterMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readUvFilterMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUvFilterMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUvFilterMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UvFilterMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readUvFilterMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readUvFilterMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUvFilterMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUvFilterMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UvFilterMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readUvFilterMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readUvFilterMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUvFilterMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUvFilterMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UvFilterMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readUvFilterMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readUvFilterMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUvFilterMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUvFilterMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UvFilterMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.UvFilterMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUvFilterMonitoringClusterGeneratedCommandListAttributeCallback(),
          readUvFilterMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readUvFilterMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUvFilterMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUvFilterMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UvFilterMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.UvFilterMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUvFilterMonitoringClusterAcceptedCommandListAttributeCallback(),
          readUvFilterMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readUvFilterMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUvFilterMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUvFilterMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UvFilterMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.UvFilterMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUvFilterMonitoringClusterEventListAttributeCallback(),
          readUvFilterMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readUvFilterMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUvFilterMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUvFilterMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UvFilterMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.UvFilterMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedUvFilterMonitoringClusterAttributeListAttributeCallback(),
          readUvFilterMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readUvFilterMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUvFilterMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUvFilterMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UvFilterMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readUvFilterMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readUvFilterMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readUvFilterMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readUvFilterMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.UvFilterMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readUvFilterMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readUvFilterMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readIonizingFilterMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readIonizingFilterMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIonizingFilterMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IonizingFilterMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIonizingFilterMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readIonizingFilterMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIonizingFilterMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIonizingFilterMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IonizingFilterMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIonizingFilterMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readIonizingFilterMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIonizingFilterMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIonizingFilterMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IonizingFilterMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIonizingFilterMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readIonizingFilterMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIonizingFilterMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIonizingFilterMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IonizingFilterMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readIonizingFilterMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readIonizingFilterMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIonizingFilterMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIonizingFilterMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IonizingFilterMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.IonizingFilterMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIonizingFilterMonitoringClusterGeneratedCommandListAttributeCallback(),
          readIonizingFilterMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readIonizingFilterMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIonizingFilterMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIonizingFilterMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IonizingFilterMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.IonizingFilterMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIonizingFilterMonitoringClusterAcceptedCommandListAttributeCallback(),
          readIonizingFilterMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readIonizingFilterMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIonizingFilterMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIonizingFilterMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IonizingFilterMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.IonizingFilterMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIonizingFilterMonitoringClusterEventListAttributeCallback(),
          readIonizingFilterMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readIonizingFilterMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIonizingFilterMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIonizingFilterMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IonizingFilterMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.IonizingFilterMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIonizingFilterMonitoringClusterAttributeListAttributeCallback(),
          readIonizingFilterMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readIonizingFilterMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIonizingFilterMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIonizingFilterMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IonizingFilterMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readIonizingFilterMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readIonizingFilterMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIonizingFilterMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIonizingFilterMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IonizingFilterMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIonizingFilterMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readIonizingFilterMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readZeoliteFilterMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readZeoliteFilterMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readZeoliteFilterMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ZeoliteFilterMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readZeoliteFilterMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readZeoliteFilterMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readZeoliteFilterMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readZeoliteFilterMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ZeoliteFilterMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readZeoliteFilterMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readZeoliteFilterMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readZeoliteFilterMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readZeoliteFilterMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ZeoliteFilterMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readZeoliteFilterMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readZeoliteFilterMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readZeoliteFilterMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readZeoliteFilterMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ZeoliteFilterMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readZeoliteFilterMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readZeoliteFilterMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readZeoliteFilterMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readZeoliteFilterMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ZeoliteFilterMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ZeoliteFilterMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedZeoliteFilterMonitoringClusterGeneratedCommandListAttributeCallback(),
          readZeoliteFilterMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readZeoliteFilterMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readZeoliteFilterMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readZeoliteFilterMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ZeoliteFilterMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ZeoliteFilterMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedZeoliteFilterMonitoringClusterAcceptedCommandListAttributeCallback(),
          readZeoliteFilterMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readZeoliteFilterMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readZeoliteFilterMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readZeoliteFilterMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ZeoliteFilterMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.ZeoliteFilterMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedZeoliteFilterMonitoringClusterEventListAttributeCallback(),
          readZeoliteFilterMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readZeoliteFilterMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readZeoliteFilterMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readZeoliteFilterMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ZeoliteFilterMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ZeoliteFilterMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedZeoliteFilterMonitoringClusterAttributeListAttributeCallback(),
          readZeoliteFilterMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readZeoliteFilterMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readZeoliteFilterMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readZeoliteFilterMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ZeoliteFilterMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readZeoliteFilterMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readZeoliteFilterMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readZeoliteFilterMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readZeoliteFilterMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ZeoliteFilterMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readZeoliteFilterMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readZeoliteFilterMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readOzoneFilterMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readOzoneFilterMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneFilterMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneFilterMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOzoneFilterMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readOzoneFilterMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneFilterMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneFilterMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneFilterMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOzoneFilterMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readOzoneFilterMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneFilterMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneFilterMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneFilterMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOzoneFilterMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readOzoneFilterMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneFilterMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneFilterMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneFilterMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readOzoneFilterMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readOzoneFilterMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneFilterMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneFilterMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneFilterMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.OzoneFilterMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneFilterMonitoringClusterGeneratedCommandListAttributeCallback(),
          readOzoneFilterMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readOzoneFilterMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneFilterMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneFilterMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneFilterMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.OzoneFilterMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneFilterMonitoringClusterAcceptedCommandListAttributeCallback(),
          readOzoneFilterMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readOzoneFilterMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneFilterMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneFilterMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneFilterMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.OzoneFilterMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneFilterMonitoringClusterEventListAttributeCallback(),
          readOzoneFilterMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readOzoneFilterMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneFilterMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneFilterMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneFilterMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.OzoneFilterMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneFilterMonitoringClusterAttributeListAttributeCallback(),
          readOzoneFilterMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readOzoneFilterMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneFilterMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneFilterMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneFilterMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOzoneFilterMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readOzoneFilterMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneFilterMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneFilterMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneFilterMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOzoneFilterMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readOzoneFilterMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readWaterTankMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readWaterTankMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWaterTankMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WaterTankMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWaterTankMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readWaterTankMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWaterTankMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWaterTankMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WaterTankMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWaterTankMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readWaterTankMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWaterTankMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWaterTankMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WaterTankMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWaterTankMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readWaterTankMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWaterTankMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWaterTankMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WaterTankMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readWaterTankMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readWaterTankMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWaterTankMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWaterTankMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WaterTankMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.WaterTankMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWaterTankMonitoringClusterGeneratedCommandListAttributeCallback(),
          readWaterTankMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readWaterTankMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWaterTankMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWaterTankMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WaterTankMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.WaterTankMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWaterTankMonitoringClusterAcceptedCommandListAttributeCallback(),
          readWaterTankMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readWaterTankMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWaterTankMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWaterTankMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WaterTankMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.WaterTankMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWaterTankMonitoringClusterEventListAttributeCallback(),
          readWaterTankMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readWaterTankMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWaterTankMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWaterTankMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WaterTankMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.WaterTankMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWaterTankMonitoringClusterAttributeListAttributeCallback(),
          readWaterTankMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readWaterTankMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWaterTankMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWaterTankMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WaterTankMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readWaterTankMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readWaterTankMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWaterTankMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWaterTankMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WaterTankMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWaterTankMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readWaterTankMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readFuelTankMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readFuelTankMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFuelTankMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FuelTankMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFuelTankMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readFuelTankMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFuelTankMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFuelTankMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FuelTankMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFuelTankMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readFuelTankMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFuelTankMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFuelTankMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FuelTankMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFuelTankMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readFuelTankMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFuelTankMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFuelTankMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FuelTankMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readFuelTankMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readFuelTankMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFuelTankMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFuelTankMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FuelTankMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.FuelTankMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFuelTankMonitoringClusterGeneratedCommandListAttributeCallback(),
          readFuelTankMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readFuelTankMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFuelTankMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFuelTankMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FuelTankMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.FuelTankMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFuelTankMonitoringClusterAcceptedCommandListAttributeCallback(),
          readFuelTankMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readFuelTankMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFuelTankMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFuelTankMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FuelTankMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.FuelTankMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFuelTankMonitoringClusterEventListAttributeCallback(),
          readFuelTankMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readFuelTankMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFuelTankMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFuelTankMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FuelTankMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.FuelTankMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFuelTankMonitoringClusterAttributeListAttributeCallback(),
          readFuelTankMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readFuelTankMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFuelTankMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFuelTankMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FuelTankMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readFuelTankMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readFuelTankMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFuelTankMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFuelTankMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FuelTankMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFuelTankMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readFuelTankMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readInkCartridgeMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readInkCartridgeMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readInkCartridgeMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.InkCartridgeMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readInkCartridgeMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readInkCartridgeMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readInkCartridgeMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readInkCartridgeMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.InkCartridgeMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readInkCartridgeMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readInkCartridgeMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readInkCartridgeMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readInkCartridgeMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.InkCartridgeMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readInkCartridgeMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readInkCartridgeMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readInkCartridgeMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readInkCartridgeMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.InkCartridgeMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readInkCartridgeMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readInkCartridgeMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readInkCartridgeMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readInkCartridgeMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.InkCartridgeMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.InkCartridgeMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedInkCartridgeMonitoringClusterGeneratedCommandListAttributeCallback(),
          readInkCartridgeMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readInkCartridgeMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readInkCartridgeMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readInkCartridgeMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.InkCartridgeMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.InkCartridgeMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedInkCartridgeMonitoringClusterAcceptedCommandListAttributeCallback(),
          readInkCartridgeMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readInkCartridgeMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readInkCartridgeMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readInkCartridgeMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.InkCartridgeMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.InkCartridgeMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedInkCartridgeMonitoringClusterEventListAttributeCallback(),
          readInkCartridgeMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readInkCartridgeMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readInkCartridgeMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readInkCartridgeMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.InkCartridgeMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.InkCartridgeMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedInkCartridgeMonitoringClusterAttributeListAttributeCallback(),
          readInkCartridgeMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readInkCartridgeMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readInkCartridgeMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readInkCartridgeMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.InkCartridgeMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readInkCartridgeMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readInkCartridgeMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readInkCartridgeMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readInkCartridgeMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.InkCartridgeMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readInkCartridgeMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readInkCartridgeMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readTonerCartridgeMonitoringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readTonerCartridgeMonitoringConditionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTonerCartridgeMonitoringConditionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TonerCartridgeMonitoringCluster) cluster).readConditionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTonerCartridgeMonitoringConditionCommandParams
        );
        result.put("readConditionAttribute", readTonerCartridgeMonitoringConditionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTonerCartridgeMonitoringDegradationDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTonerCartridgeMonitoringDegradationDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TonerCartridgeMonitoringCluster) cluster).readDegradationDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTonerCartridgeMonitoringDegradationDirectionCommandParams
        );
        result.put("readDegradationDirectionAttribute", readTonerCartridgeMonitoringDegradationDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTonerCartridgeMonitoringChangeIndicationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTonerCartridgeMonitoringChangeIndicationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TonerCartridgeMonitoringCluster) cluster).readChangeIndicationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTonerCartridgeMonitoringChangeIndicationCommandParams
        );
        result.put("readChangeIndicationAttribute", readTonerCartridgeMonitoringChangeIndicationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTonerCartridgeMonitoringInPlaceIndicatorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTonerCartridgeMonitoringInPlaceIndicatorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TonerCartridgeMonitoringCluster) cluster).readInPlaceIndicatorAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readTonerCartridgeMonitoringInPlaceIndicatorCommandParams
        );
        result.put("readInPlaceIndicatorAttribute", readTonerCartridgeMonitoringInPlaceIndicatorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTonerCartridgeMonitoringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTonerCartridgeMonitoringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TonerCartridgeMonitoringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.TonerCartridgeMonitoringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTonerCartridgeMonitoringClusterGeneratedCommandListAttributeCallback(),
          readTonerCartridgeMonitoringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readTonerCartridgeMonitoringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTonerCartridgeMonitoringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTonerCartridgeMonitoringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TonerCartridgeMonitoringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.TonerCartridgeMonitoringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTonerCartridgeMonitoringClusterAcceptedCommandListAttributeCallback(),
          readTonerCartridgeMonitoringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readTonerCartridgeMonitoringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTonerCartridgeMonitoringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTonerCartridgeMonitoringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TonerCartridgeMonitoringCluster) cluster).readEventListAttribute(
              (ChipClusters.TonerCartridgeMonitoringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTonerCartridgeMonitoringClusterEventListAttributeCallback(),
          readTonerCartridgeMonitoringEventListCommandParams
        );
        result.put("readEventListAttribute", readTonerCartridgeMonitoringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTonerCartridgeMonitoringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTonerCartridgeMonitoringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TonerCartridgeMonitoringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.TonerCartridgeMonitoringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTonerCartridgeMonitoringClusterAttributeListAttributeCallback(),
          readTonerCartridgeMonitoringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readTonerCartridgeMonitoringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTonerCartridgeMonitoringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTonerCartridgeMonitoringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TonerCartridgeMonitoringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readTonerCartridgeMonitoringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readTonerCartridgeMonitoringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTonerCartridgeMonitoringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTonerCartridgeMonitoringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TonerCartridgeMonitoringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTonerCartridgeMonitoringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readTonerCartridgeMonitoringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readDoorLockInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readDoorLockLockStateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockLockStateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readLockStateAttribute(
              (ChipClusters.DoorLockCluster.LockStateAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDoorLockClusterLockStateAttributeCallback(),
          readDoorLockLockStateCommandParams
        );
        result.put("readLockStateAttribute", readDoorLockLockStateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockLockTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockLockTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readLockTypeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockLockTypeCommandParams
        );
        result.put("readLockTypeAttribute", readDoorLockLockTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockActuatorEnabledCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockActuatorEnabledAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readActuatorEnabledAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readDoorLockActuatorEnabledCommandParams
        );
        result.put("readActuatorEnabledAttribute", readDoorLockActuatorEnabledAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockDoorStateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockDoorStateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readDoorStateAttribute(
              (ChipClusters.DoorLockCluster.DoorStateAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDoorLockClusterDoorStateAttributeCallback(),
          readDoorLockDoorStateCommandParams
        );
        result.put("readDoorStateAttribute", readDoorLockDoorStateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockDoorOpenEventsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockDoorOpenEventsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readDoorOpenEventsAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readDoorLockDoorOpenEventsCommandParams
        );
        result.put("readDoorOpenEventsAttribute", readDoorLockDoorOpenEventsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockDoorClosedEventsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockDoorClosedEventsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readDoorClosedEventsAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readDoorLockDoorClosedEventsCommandParams
        );
        result.put("readDoorClosedEventsAttribute", readDoorLockDoorClosedEventsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockOpenPeriodCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockOpenPeriodAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readOpenPeriodAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockOpenPeriodCommandParams
        );
        result.put("readOpenPeriodAttribute", readDoorLockOpenPeriodAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockNumberOfTotalUsersSupportedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockNumberOfTotalUsersSupportedAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readNumberOfTotalUsersSupportedAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockNumberOfTotalUsersSupportedCommandParams
        );
        result.put("readNumberOfTotalUsersSupportedAttribute", readDoorLockNumberOfTotalUsersSupportedAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockNumberOfPINUsersSupportedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockNumberOfPINUsersSupportedAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readNumberOfPINUsersSupportedAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockNumberOfPINUsersSupportedCommandParams
        );
        result.put("readNumberOfPINUsersSupportedAttribute", readDoorLockNumberOfPINUsersSupportedAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockNumberOfRFIDUsersSupportedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockNumberOfRFIDUsersSupportedAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readNumberOfRFIDUsersSupportedAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockNumberOfRFIDUsersSupportedCommandParams
        );
        result.put("readNumberOfRFIDUsersSupportedAttribute", readDoorLockNumberOfRFIDUsersSupportedAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockNumberOfWeekDaySchedulesSupportedPerUserCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockNumberOfWeekDaySchedulesSupportedPerUserAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readNumberOfWeekDaySchedulesSupportedPerUserAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockNumberOfWeekDaySchedulesSupportedPerUserCommandParams
        );
        result.put("readNumberOfWeekDaySchedulesSupportedPerUserAttribute", readDoorLockNumberOfWeekDaySchedulesSupportedPerUserAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockNumberOfYearDaySchedulesSupportedPerUserCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockNumberOfYearDaySchedulesSupportedPerUserAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readNumberOfYearDaySchedulesSupportedPerUserAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockNumberOfYearDaySchedulesSupportedPerUserCommandParams
        );
        result.put("readNumberOfYearDaySchedulesSupportedPerUserAttribute", readDoorLockNumberOfYearDaySchedulesSupportedPerUserAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockNumberOfHolidaySchedulesSupportedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockNumberOfHolidaySchedulesSupportedAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readNumberOfHolidaySchedulesSupportedAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockNumberOfHolidaySchedulesSupportedCommandParams
        );
        result.put("readNumberOfHolidaySchedulesSupportedAttribute", readDoorLockNumberOfHolidaySchedulesSupportedAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockMaxPINCodeLengthCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockMaxPINCodeLengthAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readMaxPINCodeLengthAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockMaxPINCodeLengthCommandParams
        );
        result.put("readMaxPINCodeLengthAttribute", readDoorLockMaxPINCodeLengthAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockMinPINCodeLengthCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockMinPINCodeLengthAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readMinPINCodeLengthAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockMinPINCodeLengthCommandParams
        );
        result.put("readMinPINCodeLengthAttribute", readDoorLockMinPINCodeLengthAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockMaxRFIDCodeLengthCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockMaxRFIDCodeLengthAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readMaxRFIDCodeLengthAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockMaxRFIDCodeLengthCommandParams
        );
        result.put("readMaxRFIDCodeLengthAttribute", readDoorLockMaxRFIDCodeLengthAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockMinRFIDCodeLengthCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockMinRFIDCodeLengthAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readMinRFIDCodeLengthAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockMinRFIDCodeLengthCommandParams
        );
        result.put("readMinRFIDCodeLengthAttribute", readDoorLockMinRFIDCodeLengthAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockCredentialRulesSupportCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockCredentialRulesSupportAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readCredentialRulesSupportAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockCredentialRulesSupportCommandParams
        );
        result.put("readCredentialRulesSupportAttribute", readDoorLockCredentialRulesSupportAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockNumberOfCredentialsSupportedPerUserCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockNumberOfCredentialsSupportedPerUserAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readNumberOfCredentialsSupportedPerUserAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockNumberOfCredentialsSupportedPerUserCommandParams
        );
        result.put("readNumberOfCredentialsSupportedPerUserAttribute", readDoorLockNumberOfCredentialsSupportedPerUserAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockLanguageCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockLanguageAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readLanguageAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readDoorLockLanguageCommandParams
        );
        result.put("readLanguageAttribute", readDoorLockLanguageAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockLEDSettingsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockLEDSettingsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readLEDSettingsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockLEDSettingsCommandParams
        );
        result.put("readLEDSettingsAttribute", readDoorLockLEDSettingsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockAutoRelockTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockAutoRelockTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readAutoRelockTimeAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readDoorLockAutoRelockTimeCommandParams
        );
        result.put("readAutoRelockTimeAttribute", readDoorLockAutoRelockTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockSoundVolumeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockSoundVolumeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readSoundVolumeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockSoundVolumeCommandParams
        );
        result.put("readSoundVolumeAttribute", readDoorLockSoundVolumeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockOperatingModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockOperatingModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readOperatingModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockOperatingModeCommandParams
        );
        result.put("readOperatingModeAttribute", readDoorLockOperatingModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockSupportedOperatingModesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockSupportedOperatingModesAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readSupportedOperatingModesAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockSupportedOperatingModesCommandParams
        );
        result.put("readSupportedOperatingModesAttribute", readDoorLockSupportedOperatingModesAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockDefaultConfigurationRegisterCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockDefaultConfigurationRegisterAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readDefaultConfigurationRegisterAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockDefaultConfigurationRegisterCommandParams
        );
        result.put("readDefaultConfigurationRegisterAttribute", readDoorLockDefaultConfigurationRegisterAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockEnableLocalProgrammingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockEnableLocalProgrammingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readEnableLocalProgrammingAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readDoorLockEnableLocalProgrammingCommandParams
        );
        result.put("readEnableLocalProgrammingAttribute", readDoorLockEnableLocalProgrammingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockEnableOneTouchLockingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockEnableOneTouchLockingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readEnableOneTouchLockingAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readDoorLockEnableOneTouchLockingCommandParams
        );
        result.put("readEnableOneTouchLockingAttribute", readDoorLockEnableOneTouchLockingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockEnableInsideStatusLEDCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockEnableInsideStatusLEDAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readEnableInsideStatusLEDAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readDoorLockEnableInsideStatusLEDCommandParams
        );
        result.put("readEnableInsideStatusLEDAttribute", readDoorLockEnableInsideStatusLEDAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockEnablePrivacyModeButtonCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockEnablePrivacyModeButtonAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readEnablePrivacyModeButtonAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readDoorLockEnablePrivacyModeButtonCommandParams
        );
        result.put("readEnablePrivacyModeButtonAttribute", readDoorLockEnablePrivacyModeButtonAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockLocalProgrammingFeaturesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockLocalProgrammingFeaturesAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readLocalProgrammingFeaturesAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockLocalProgrammingFeaturesCommandParams
        );
        result.put("readLocalProgrammingFeaturesAttribute", readDoorLockLocalProgrammingFeaturesAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockWrongCodeEntryLimitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockWrongCodeEntryLimitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readWrongCodeEntryLimitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockWrongCodeEntryLimitCommandParams
        );
        result.put("readWrongCodeEntryLimitAttribute", readDoorLockWrongCodeEntryLimitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockUserCodeTemporaryDisableTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockUserCodeTemporaryDisableTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readUserCodeTemporaryDisableTimeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockUserCodeTemporaryDisableTimeCommandParams
        );
        result.put("readUserCodeTemporaryDisableTimeAttribute", readDoorLockUserCodeTemporaryDisableTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockSendPINOverTheAirCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockSendPINOverTheAirAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readSendPINOverTheAirAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readDoorLockSendPINOverTheAirCommandParams
        );
        result.put("readSendPINOverTheAirAttribute", readDoorLockSendPINOverTheAirAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockRequirePINforRemoteOperationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockRequirePINforRemoteOperationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readRequirePINforRemoteOperationAttribute(
              (ChipClusters.BooleanAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBooleanAttributeCallback(),
          readDoorLockRequirePINforRemoteOperationCommandParams
        );
        result.put("readRequirePINforRemoteOperationAttribute", readDoorLockRequirePINforRemoteOperationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockExpiringUserTimeoutCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockExpiringUserTimeoutAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readExpiringUserTimeoutAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockExpiringUserTimeoutCommandParams
        );
        result.put("readExpiringUserTimeoutAttribute", readDoorLockExpiringUserTimeoutAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.DoorLockCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDoorLockClusterGeneratedCommandListAttributeCallback(),
          readDoorLockGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readDoorLockGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.DoorLockCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDoorLockClusterAcceptedCommandListAttributeCallback(),
          readDoorLockAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readDoorLockAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readEventListAttribute(
              (ChipClusters.DoorLockCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDoorLockClusterEventListAttributeCallback(),
          readDoorLockEventListCommandParams
        );
        result.put("readEventListAttribute", readDoorLockEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readAttributeListAttribute(
              (ChipClusters.DoorLockCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedDoorLockClusterAttributeListAttributeCallback(),
          readDoorLockAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readDoorLockAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readDoorLockFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readDoorLockFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readDoorLockClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readDoorLockClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.DoorLockCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readDoorLockClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readDoorLockClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readWindowCoveringInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readWindowCoveringTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readTypeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringTypeCommandParams
        );
        result.put("readTypeAttribute", readWindowCoveringTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringPhysicalClosedLimitLiftCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringPhysicalClosedLimitLiftAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readPhysicalClosedLimitLiftAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringPhysicalClosedLimitLiftCommandParams
        );
        result.put("readPhysicalClosedLimitLiftAttribute", readWindowCoveringPhysicalClosedLimitLiftAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringPhysicalClosedLimitTiltCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringPhysicalClosedLimitTiltAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readPhysicalClosedLimitTiltAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringPhysicalClosedLimitTiltCommandParams
        );
        result.put("readPhysicalClosedLimitTiltAttribute", readWindowCoveringPhysicalClosedLimitTiltAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringCurrentPositionLiftCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringCurrentPositionLiftAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readCurrentPositionLiftAttribute(
              (ChipClusters.WindowCoveringCluster.CurrentPositionLiftAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterCurrentPositionLiftAttributeCallback(),
          readWindowCoveringCurrentPositionLiftCommandParams
        );
        result.put("readCurrentPositionLiftAttribute", readWindowCoveringCurrentPositionLiftAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringCurrentPositionTiltCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringCurrentPositionTiltAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readCurrentPositionTiltAttribute(
              (ChipClusters.WindowCoveringCluster.CurrentPositionTiltAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterCurrentPositionTiltAttributeCallback(),
          readWindowCoveringCurrentPositionTiltCommandParams
        );
        result.put("readCurrentPositionTiltAttribute", readWindowCoveringCurrentPositionTiltAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringNumberOfActuationsLiftCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringNumberOfActuationsLiftAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readNumberOfActuationsLiftAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringNumberOfActuationsLiftCommandParams
        );
        result.put("readNumberOfActuationsLiftAttribute", readWindowCoveringNumberOfActuationsLiftAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringNumberOfActuationsTiltCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringNumberOfActuationsTiltAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readNumberOfActuationsTiltAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringNumberOfActuationsTiltCommandParams
        );
        result.put("readNumberOfActuationsTiltAttribute", readWindowCoveringNumberOfActuationsTiltAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringConfigStatusCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringConfigStatusAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readConfigStatusAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringConfigStatusCommandParams
        );
        result.put("readConfigStatusAttribute", readWindowCoveringConfigStatusAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringCurrentPositionLiftPercentageCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringCurrentPositionLiftPercentageAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readCurrentPositionLiftPercentageAttribute(
              (ChipClusters.WindowCoveringCluster.CurrentPositionLiftPercentageAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterCurrentPositionLiftPercentageAttributeCallback(),
          readWindowCoveringCurrentPositionLiftPercentageCommandParams
        );
        result.put("readCurrentPositionLiftPercentageAttribute", readWindowCoveringCurrentPositionLiftPercentageAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringCurrentPositionTiltPercentageCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringCurrentPositionTiltPercentageAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readCurrentPositionTiltPercentageAttribute(
              (ChipClusters.WindowCoveringCluster.CurrentPositionTiltPercentageAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterCurrentPositionTiltPercentageAttributeCallback(),
          readWindowCoveringCurrentPositionTiltPercentageCommandParams
        );
        result.put("readCurrentPositionTiltPercentageAttribute", readWindowCoveringCurrentPositionTiltPercentageAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringOperationalStatusCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringOperationalStatusAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readOperationalStatusAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringOperationalStatusCommandParams
        );
        result.put("readOperationalStatusAttribute", readWindowCoveringOperationalStatusAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringTargetPositionLiftPercent100thsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringTargetPositionLiftPercent100thsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readTargetPositionLiftPercent100thsAttribute(
              (ChipClusters.WindowCoveringCluster.TargetPositionLiftPercent100thsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterTargetPositionLiftPercent100thsAttributeCallback(),
          readWindowCoveringTargetPositionLiftPercent100thsCommandParams
        );
        result.put("readTargetPositionLiftPercent100thsAttribute", readWindowCoveringTargetPositionLiftPercent100thsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringTargetPositionTiltPercent100thsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringTargetPositionTiltPercent100thsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readTargetPositionTiltPercent100thsAttribute(
              (ChipClusters.WindowCoveringCluster.TargetPositionTiltPercent100thsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterTargetPositionTiltPercent100thsAttributeCallback(),
          readWindowCoveringTargetPositionTiltPercent100thsCommandParams
        );
        result.put("readTargetPositionTiltPercent100thsAttribute", readWindowCoveringTargetPositionTiltPercent100thsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringEndProductTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringEndProductTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readEndProductTypeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringEndProductTypeCommandParams
        );
        result.put("readEndProductTypeAttribute", readWindowCoveringEndProductTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringCurrentPositionLiftPercent100thsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringCurrentPositionLiftPercent100thsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readCurrentPositionLiftPercent100thsAttribute(
              (ChipClusters.WindowCoveringCluster.CurrentPositionLiftPercent100thsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterCurrentPositionLiftPercent100thsAttributeCallback(),
          readWindowCoveringCurrentPositionLiftPercent100thsCommandParams
        );
        result.put("readCurrentPositionLiftPercent100thsAttribute", readWindowCoveringCurrentPositionLiftPercent100thsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringCurrentPositionTiltPercent100thsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringCurrentPositionTiltPercent100thsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readCurrentPositionTiltPercent100thsAttribute(
              (ChipClusters.WindowCoveringCluster.CurrentPositionTiltPercent100thsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterCurrentPositionTiltPercent100thsAttributeCallback(),
          readWindowCoveringCurrentPositionTiltPercent100thsCommandParams
        );
        result.put("readCurrentPositionTiltPercent100thsAttribute", readWindowCoveringCurrentPositionTiltPercent100thsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringInstalledOpenLimitLiftCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringInstalledOpenLimitLiftAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readInstalledOpenLimitLiftAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringInstalledOpenLimitLiftCommandParams
        );
        result.put("readInstalledOpenLimitLiftAttribute", readWindowCoveringInstalledOpenLimitLiftAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringInstalledClosedLimitLiftCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringInstalledClosedLimitLiftAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readInstalledClosedLimitLiftAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringInstalledClosedLimitLiftCommandParams
        );
        result.put("readInstalledClosedLimitLiftAttribute", readWindowCoveringInstalledClosedLimitLiftAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringInstalledOpenLimitTiltCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringInstalledOpenLimitTiltAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readInstalledOpenLimitTiltAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringInstalledOpenLimitTiltCommandParams
        );
        result.put("readInstalledOpenLimitTiltAttribute", readWindowCoveringInstalledOpenLimitTiltAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringInstalledClosedLimitTiltCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringInstalledClosedLimitTiltAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readInstalledClosedLimitTiltAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringInstalledClosedLimitTiltCommandParams
        );
        result.put("readInstalledClosedLimitTiltAttribute", readWindowCoveringInstalledClosedLimitTiltAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringModeCommandParams
        );
        result.put("readModeAttribute", readWindowCoveringModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringSafetyStatusCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringSafetyStatusAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readSafetyStatusAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringSafetyStatusCommandParams
        );
        result.put("readSafetyStatusAttribute", readWindowCoveringSafetyStatusAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.WindowCoveringCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterGeneratedCommandListAttributeCallback(),
          readWindowCoveringGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readWindowCoveringGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.WindowCoveringCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterAcceptedCommandListAttributeCallback(),
          readWindowCoveringAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readWindowCoveringAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readEventListAttribute(
              (ChipClusters.WindowCoveringCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterEventListAttributeCallback(),
          readWindowCoveringEventListCommandParams
        );
        result.put("readEventListAttribute", readWindowCoveringEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readAttributeListAttribute(
              (ChipClusters.WindowCoveringCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedWindowCoveringClusterAttributeListAttributeCallback(),
          readWindowCoveringAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readWindowCoveringAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readWindowCoveringFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readWindowCoveringFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readWindowCoveringClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readWindowCoveringClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.WindowCoveringCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readWindowCoveringClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readWindowCoveringClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readBarrierControlInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readBarrierControlBarrierMovingStateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlBarrierMovingStateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readBarrierMovingStateAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBarrierControlBarrierMovingStateCommandParams
        );
        result.put("readBarrierMovingStateAttribute", readBarrierControlBarrierMovingStateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlBarrierSafetyStatusCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlBarrierSafetyStatusAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readBarrierSafetyStatusAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBarrierControlBarrierSafetyStatusCommandParams
        );
        result.put("readBarrierSafetyStatusAttribute", readBarrierControlBarrierSafetyStatusAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlBarrierCapabilitiesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlBarrierCapabilitiesAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readBarrierCapabilitiesAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBarrierControlBarrierCapabilitiesCommandParams
        );
        result.put("readBarrierCapabilitiesAttribute", readBarrierControlBarrierCapabilitiesAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlBarrierOpenEventsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlBarrierOpenEventsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readBarrierOpenEventsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBarrierControlBarrierOpenEventsCommandParams
        );
        result.put("readBarrierOpenEventsAttribute", readBarrierControlBarrierOpenEventsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlBarrierCloseEventsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlBarrierCloseEventsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readBarrierCloseEventsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBarrierControlBarrierCloseEventsCommandParams
        );
        result.put("readBarrierCloseEventsAttribute", readBarrierControlBarrierCloseEventsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlBarrierCommandOpenEventsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlBarrierCommandOpenEventsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readBarrierCommandOpenEventsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBarrierControlBarrierCommandOpenEventsCommandParams
        );
        result.put("readBarrierCommandOpenEventsAttribute", readBarrierControlBarrierCommandOpenEventsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlBarrierCommandCloseEventsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlBarrierCommandCloseEventsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readBarrierCommandCloseEventsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBarrierControlBarrierCommandCloseEventsCommandParams
        );
        result.put("readBarrierCommandCloseEventsAttribute", readBarrierControlBarrierCommandCloseEventsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlBarrierOpenPeriodCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlBarrierOpenPeriodAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readBarrierOpenPeriodAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBarrierControlBarrierOpenPeriodCommandParams
        );
        result.put("readBarrierOpenPeriodAttribute", readBarrierControlBarrierOpenPeriodAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlBarrierClosePeriodCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlBarrierClosePeriodAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readBarrierClosePeriodAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBarrierControlBarrierClosePeriodCommandParams
        );
        result.put("readBarrierClosePeriodAttribute", readBarrierControlBarrierClosePeriodAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlBarrierPositionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlBarrierPositionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readBarrierPositionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBarrierControlBarrierPositionCommandParams
        );
        result.put("readBarrierPositionAttribute", readBarrierControlBarrierPositionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.BarrierControlCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBarrierControlClusterGeneratedCommandListAttributeCallback(),
          readBarrierControlGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readBarrierControlGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.BarrierControlCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBarrierControlClusterAcceptedCommandListAttributeCallback(),
          readBarrierControlAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readBarrierControlAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readEventListAttribute(
              (ChipClusters.BarrierControlCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBarrierControlClusterEventListAttributeCallback(),
          readBarrierControlEventListCommandParams
        );
        result.put("readEventListAttribute", readBarrierControlEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readAttributeListAttribute(
              (ChipClusters.BarrierControlCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBarrierControlClusterAttributeListAttributeCallback(),
          readBarrierControlAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readBarrierControlAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readBarrierControlFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readBarrierControlFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBarrierControlClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBarrierControlClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BarrierControlCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBarrierControlClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readBarrierControlClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readPumpConfigurationAndControlInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readPumpConfigurationAndControlMaxPressureCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMaxPressureAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMaxPressureAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MaxPressureAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMaxPressureAttributeCallback(),
          readPumpConfigurationAndControlMaxPressureCommandParams
        );
        result.put("readMaxPressureAttribute", readPumpConfigurationAndControlMaxPressureAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMaxSpeedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMaxSpeedAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMaxSpeedAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MaxSpeedAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMaxSpeedAttributeCallback(),
          readPumpConfigurationAndControlMaxSpeedCommandParams
        );
        result.put("readMaxSpeedAttribute", readPumpConfigurationAndControlMaxSpeedAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMaxFlowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMaxFlowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMaxFlowAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MaxFlowAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMaxFlowAttributeCallback(),
          readPumpConfigurationAndControlMaxFlowCommandParams
        );
        result.put("readMaxFlowAttribute", readPumpConfigurationAndControlMaxFlowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMinConstPressureCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMinConstPressureAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMinConstPressureAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MinConstPressureAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMinConstPressureAttributeCallback(),
          readPumpConfigurationAndControlMinConstPressureCommandParams
        );
        result.put("readMinConstPressureAttribute", readPumpConfigurationAndControlMinConstPressureAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMaxConstPressureCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMaxConstPressureAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMaxConstPressureAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MaxConstPressureAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMaxConstPressureAttributeCallback(),
          readPumpConfigurationAndControlMaxConstPressureCommandParams
        );
        result.put("readMaxConstPressureAttribute", readPumpConfigurationAndControlMaxConstPressureAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMinCompPressureCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMinCompPressureAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMinCompPressureAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MinCompPressureAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMinCompPressureAttributeCallback(),
          readPumpConfigurationAndControlMinCompPressureCommandParams
        );
        result.put("readMinCompPressureAttribute", readPumpConfigurationAndControlMinCompPressureAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMaxCompPressureCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMaxCompPressureAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMaxCompPressureAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MaxCompPressureAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMaxCompPressureAttributeCallback(),
          readPumpConfigurationAndControlMaxCompPressureCommandParams
        );
        result.put("readMaxCompPressureAttribute", readPumpConfigurationAndControlMaxCompPressureAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMinConstSpeedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMinConstSpeedAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMinConstSpeedAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MinConstSpeedAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMinConstSpeedAttributeCallback(),
          readPumpConfigurationAndControlMinConstSpeedCommandParams
        );
        result.put("readMinConstSpeedAttribute", readPumpConfigurationAndControlMinConstSpeedAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMaxConstSpeedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMaxConstSpeedAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMaxConstSpeedAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MaxConstSpeedAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMaxConstSpeedAttributeCallback(),
          readPumpConfigurationAndControlMaxConstSpeedCommandParams
        );
        result.put("readMaxConstSpeedAttribute", readPumpConfigurationAndControlMaxConstSpeedAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMinConstFlowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMinConstFlowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMinConstFlowAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MinConstFlowAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMinConstFlowAttributeCallback(),
          readPumpConfigurationAndControlMinConstFlowCommandParams
        );
        result.put("readMinConstFlowAttribute", readPumpConfigurationAndControlMinConstFlowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMaxConstFlowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMaxConstFlowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMaxConstFlowAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MaxConstFlowAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMaxConstFlowAttributeCallback(),
          readPumpConfigurationAndControlMaxConstFlowCommandParams
        );
        result.put("readMaxConstFlowAttribute", readPumpConfigurationAndControlMaxConstFlowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMinConstTempCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMinConstTempAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMinConstTempAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MinConstTempAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMinConstTempAttributeCallback(),
          readPumpConfigurationAndControlMinConstTempCommandParams
        );
        result.put("readMinConstTempAttribute", readPumpConfigurationAndControlMinConstTempAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlMaxConstTempCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlMaxConstTempAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readMaxConstTempAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.MaxConstTempAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterMaxConstTempAttributeCallback(),
          readPumpConfigurationAndControlMaxConstTempCommandParams
        );
        result.put("readMaxConstTempAttribute", readPumpConfigurationAndControlMaxConstTempAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlPumpStatusCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlPumpStatusAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readPumpStatusAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPumpConfigurationAndControlPumpStatusCommandParams
        );
        result.put("readPumpStatusAttribute", readPumpConfigurationAndControlPumpStatusAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlEffectiveOperationModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlEffectiveOperationModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readEffectiveOperationModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPumpConfigurationAndControlEffectiveOperationModeCommandParams
        );
        result.put("readEffectiveOperationModeAttribute", readPumpConfigurationAndControlEffectiveOperationModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlEffectiveControlModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlEffectiveControlModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readEffectiveControlModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPumpConfigurationAndControlEffectiveControlModeCommandParams
        );
        result.put("readEffectiveControlModeAttribute", readPumpConfigurationAndControlEffectiveControlModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlCapacityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlCapacityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readCapacityAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.CapacityAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterCapacityAttributeCallback(),
          readPumpConfigurationAndControlCapacityCommandParams
        );
        result.put("readCapacityAttribute", readPumpConfigurationAndControlCapacityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlSpeedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlSpeedAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readSpeedAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.SpeedAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterSpeedAttributeCallback(),
          readPumpConfigurationAndControlSpeedCommandParams
        );
        result.put("readSpeedAttribute", readPumpConfigurationAndControlSpeedAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlLifetimeRunningHoursCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlLifetimeRunningHoursAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readLifetimeRunningHoursAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.LifetimeRunningHoursAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterLifetimeRunningHoursAttributeCallback(),
          readPumpConfigurationAndControlLifetimeRunningHoursCommandParams
        );
        result.put("readLifetimeRunningHoursAttribute", readPumpConfigurationAndControlLifetimeRunningHoursAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlPowerCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlPowerAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readPowerAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.PowerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterPowerAttributeCallback(),
          readPumpConfigurationAndControlPowerCommandParams
        );
        result.put("readPowerAttribute", readPumpConfigurationAndControlPowerAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlLifetimeEnergyConsumedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlLifetimeEnergyConsumedAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readLifetimeEnergyConsumedAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.LifetimeEnergyConsumedAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterLifetimeEnergyConsumedAttributeCallback(),
          readPumpConfigurationAndControlLifetimeEnergyConsumedCommandParams
        );
        result.put("readLifetimeEnergyConsumedAttribute", readPumpConfigurationAndControlLifetimeEnergyConsumedAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlOperationModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlOperationModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readOperationModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPumpConfigurationAndControlOperationModeCommandParams
        );
        result.put("readOperationModeAttribute", readPumpConfigurationAndControlOperationModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlControlModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlControlModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readControlModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPumpConfigurationAndControlControlModeCommandParams
        );
        result.put("readControlModeAttribute", readPumpConfigurationAndControlControlModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterGeneratedCommandListAttributeCallback(),
          readPumpConfigurationAndControlGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readPumpConfigurationAndControlGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterAcceptedCommandListAttributeCallback(),
          readPumpConfigurationAndControlAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readPumpConfigurationAndControlAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readEventListAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterEventListAttributeCallback(),
          readPumpConfigurationAndControlEventListCommandParams
        );
        result.put("readEventListAttribute", readPumpConfigurationAndControlEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readAttributeListAttribute(
              (ChipClusters.PumpConfigurationAndControlCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPumpConfigurationAndControlClusterAttributeListAttributeCallback(),
          readPumpConfigurationAndControlAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readPumpConfigurationAndControlAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readPumpConfigurationAndControlFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readPumpConfigurationAndControlFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPumpConfigurationAndControlClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPumpConfigurationAndControlClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PumpConfigurationAndControlCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPumpConfigurationAndControlClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readPumpConfigurationAndControlClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readThermostatInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readThermostatLocalTemperatureCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatLocalTemperatureAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readLocalTemperatureAttribute(
              (ChipClusters.ThermostatCluster.LocalTemperatureAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterLocalTemperatureAttributeCallback(),
          readThermostatLocalTemperatureCommandParams
        );
        result.put("readLocalTemperatureAttribute", readThermostatLocalTemperatureAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatOutdoorTemperatureCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatOutdoorTemperatureAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readOutdoorTemperatureAttribute(
              (ChipClusters.ThermostatCluster.OutdoorTemperatureAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterOutdoorTemperatureAttributeCallback(),
          readThermostatOutdoorTemperatureCommandParams
        );
        result.put("readOutdoorTemperatureAttribute", readThermostatOutdoorTemperatureAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatOccupancyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatOccupancyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readOccupancyAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatOccupancyCommandParams
        );
        result.put("readOccupancyAttribute", readThermostatOccupancyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatAbsMinHeatSetpointLimitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatAbsMinHeatSetpointLimitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readAbsMinHeatSetpointLimitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatAbsMinHeatSetpointLimitCommandParams
        );
        result.put("readAbsMinHeatSetpointLimitAttribute", readThermostatAbsMinHeatSetpointLimitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatAbsMaxHeatSetpointLimitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatAbsMaxHeatSetpointLimitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readAbsMaxHeatSetpointLimitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatAbsMaxHeatSetpointLimitCommandParams
        );
        result.put("readAbsMaxHeatSetpointLimitAttribute", readThermostatAbsMaxHeatSetpointLimitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatAbsMinCoolSetpointLimitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatAbsMinCoolSetpointLimitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readAbsMinCoolSetpointLimitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatAbsMinCoolSetpointLimitCommandParams
        );
        result.put("readAbsMinCoolSetpointLimitAttribute", readThermostatAbsMinCoolSetpointLimitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatAbsMaxCoolSetpointLimitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatAbsMaxCoolSetpointLimitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readAbsMaxCoolSetpointLimitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatAbsMaxCoolSetpointLimitCommandParams
        );
        result.put("readAbsMaxCoolSetpointLimitAttribute", readThermostatAbsMaxCoolSetpointLimitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatPICoolingDemandCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatPICoolingDemandAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readPICoolingDemandAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatPICoolingDemandCommandParams
        );
        result.put("readPICoolingDemandAttribute", readThermostatPICoolingDemandAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatPIHeatingDemandCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatPIHeatingDemandAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readPIHeatingDemandAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatPIHeatingDemandCommandParams
        );
        result.put("readPIHeatingDemandAttribute", readThermostatPIHeatingDemandAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatHVACSystemTypeConfigurationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatHVACSystemTypeConfigurationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readHVACSystemTypeConfigurationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatHVACSystemTypeConfigurationCommandParams
        );
        result.put("readHVACSystemTypeConfigurationAttribute", readThermostatHVACSystemTypeConfigurationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatLocalTemperatureCalibrationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatLocalTemperatureCalibrationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readLocalTemperatureCalibrationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatLocalTemperatureCalibrationCommandParams
        );
        result.put("readLocalTemperatureCalibrationAttribute", readThermostatLocalTemperatureCalibrationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatOccupiedCoolingSetpointCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatOccupiedCoolingSetpointAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readOccupiedCoolingSetpointAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatOccupiedCoolingSetpointCommandParams
        );
        result.put("readOccupiedCoolingSetpointAttribute", readThermostatOccupiedCoolingSetpointAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatOccupiedHeatingSetpointCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatOccupiedHeatingSetpointAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readOccupiedHeatingSetpointAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatOccupiedHeatingSetpointCommandParams
        );
        result.put("readOccupiedHeatingSetpointAttribute", readThermostatOccupiedHeatingSetpointAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUnoccupiedCoolingSetpointCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUnoccupiedCoolingSetpointAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readUnoccupiedCoolingSetpointAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatUnoccupiedCoolingSetpointCommandParams
        );
        result.put("readUnoccupiedCoolingSetpointAttribute", readThermostatUnoccupiedCoolingSetpointAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUnoccupiedHeatingSetpointCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUnoccupiedHeatingSetpointAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readUnoccupiedHeatingSetpointAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatUnoccupiedHeatingSetpointCommandParams
        );
        result.put("readUnoccupiedHeatingSetpointAttribute", readThermostatUnoccupiedHeatingSetpointAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatMinHeatSetpointLimitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatMinHeatSetpointLimitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readMinHeatSetpointLimitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatMinHeatSetpointLimitCommandParams
        );
        result.put("readMinHeatSetpointLimitAttribute", readThermostatMinHeatSetpointLimitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatMaxHeatSetpointLimitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatMaxHeatSetpointLimitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readMaxHeatSetpointLimitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatMaxHeatSetpointLimitCommandParams
        );
        result.put("readMaxHeatSetpointLimitAttribute", readThermostatMaxHeatSetpointLimitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatMinCoolSetpointLimitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatMinCoolSetpointLimitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readMinCoolSetpointLimitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatMinCoolSetpointLimitCommandParams
        );
        result.put("readMinCoolSetpointLimitAttribute", readThermostatMinCoolSetpointLimitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatMaxCoolSetpointLimitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatMaxCoolSetpointLimitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readMaxCoolSetpointLimitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatMaxCoolSetpointLimitCommandParams
        );
        result.put("readMaxCoolSetpointLimitAttribute", readThermostatMaxCoolSetpointLimitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatMinSetpointDeadBandCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatMinSetpointDeadBandAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readMinSetpointDeadBandAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatMinSetpointDeadBandCommandParams
        );
        result.put("readMinSetpointDeadBandAttribute", readThermostatMinSetpointDeadBandAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatRemoteSensingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatRemoteSensingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readRemoteSensingAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatRemoteSensingCommandParams
        );
        result.put("readRemoteSensingAttribute", readThermostatRemoteSensingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatControlSequenceOfOperationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatControlSequenceOfOperationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readControlSequenceOfOperationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatControlSequenceOfOperationCommandParams
        );
        result.put("readControlSequenceOfOperationAttribute", readThermostatControlSequenceOfOperationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatSystemModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatSystemModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readSystemModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatSystemModeCommandParams
        );
        result.put("readSystemModeAttribute", readThermostatSystemModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatThermostatRunningModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatThermostatRunningModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readThermostatRunningModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatThermostatRunningModeCommandParams
        );
        result.put("readThermostatRunningModeAttribute", readThermostatThermostatRunningModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatStartOfWeekCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatStartOfWeekAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readStartOfWeekAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatStartOfWeekCommandParams
        );
        result.put("readStartOfWeekAttribute", readThermostatStartOfWeekAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatNumberOfWeeklyTransitionsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatNumberOfWeeklyTransitionsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readNumberOfWeeklyTransitionsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatNumberOfWeeklyTransitionsCommandParams
        );
        result.put("readNumberOfWeeklyTransitionsAttribute", readThermostatNumberOfWeeklyTransitionsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatNumberOfDailyTransitionsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatNumberOfDailyTransitionsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readNumberOfDailyTransitionsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatNumberOfDailyTransitionsCommandParams
        );
        result.put("readNumberOfDailyTransitionsAttribute", readThermostatNumberOfDailyTransitionsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatTemperatureSetpointHoldCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatTemperatureSetpointHoldAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readTemperatureSetpointHoldAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatTemperatureSetpointHoldCommandParams
        );
        result.put("readTemperatureSetpointHoldAttribute", readThermostatTemperatureSetpointHoldAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatTemperatureSetpointHoldDurationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatTemperatureSetpointHoldDurationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readTemperatureSetpointHoldDurationAttribute(
              (ChipClusters.ThermostatCluster.TemperatureSetpointHoldDurationAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterTemperatureSetpointHoldDurationAttributeCallback(),
          readThermostatTemperatureSetpointHoldDurationCommandParams
        );
        result.put("readTemperatureSetpointHoldDurationAttribute", readThermostatTemperatureSetpointHoldDurationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatThermostatProgrammingOperationModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatThermostatProgrammingOperationModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readThermostatProgrammingOperationModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatThermostatProgrammingOperationModeCommandParams
        );
        result.put("readThermostatProgrammingOperationModeAttribute", readThermostatThermostatProgrammingOperationModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatThermostatRunningStateCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatThermostatRunningStateAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readThermostatRunningStateAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatThermostatRunningStateCommandParams
        );
        result.put("readThermostatRunningStateAttribute", readThermostatThermostatRunningStateAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatSetpointChangeSourceCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatSetpointChangeSourceAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readSetpointChangeSourceAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatSetpointChangeSourceCommandParams
        );
        result.put("readSetpointChangeSourceAttribute", readThermostatSetpointChangeSourceAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatSetpointChangeAmountCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatSetpointChangeAmountAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readSetpointChangeAmountAttribute(
              (ChipClusters.ThermostatCluster.SetpointChangeAmountAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterSetpointChangeAmountAttributeCallback(),
          readThermostatSetpointChangeAmountCommandParams
        );
        result.put("readSetpointChangeAmountAttribute", readThermostatSetpointChangeAmountAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatSetpointChangeSourceTimestampCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatSetpointChangeSourceTimestampAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readSetpointChangeSourceTimestampAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThermostatSetpointChangeSourceTimestampCommandParams
        );
        result.put("readSetpointChangeSourceTimestampAttribute", readThermostatSetpointChangeSourceTimestampAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatOccupiedSetbackCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatOccupiedSetbackAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readOccupiedSetbackAttribute(
              (ChipClusters.ThermostatCluster.OccupiedSetbackAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterOccupiedSetbackAttributeCallback(),
          readThermostatOccupiedSetbackCommandParams
        );
        result.put("readOccupiedSetbackAttribute", readThermostatOccupiedSetbackAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatOccupiedSetbackMinCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatOccupiedSetbackMinAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readOccupiedSetbackMinAttribute(
              (ChipClusters.ThermostatCluster.OccupiedSetbackMinAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterOccupiedSetbackMinAttributeCallback(),
          readThermostatOccupiedSetbackMinCommandParams
        );
        result.put("readOccupiedSetbackMinAttribute", readThermostatOccupiedSetbackMinAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatOccupiedSetbackMaxCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatOccupiedSetbackMaxAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readOccupiedSetbackMaxAttribute(
              (ChipClusters.ThermostatCluster.OccupiedSetbackMaxAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterOccupiedSetbackMaxAttributeCallback(),
          readThermostatOccupiedSetbackMaxCommandParams
        );
        result.put("readOccupiedSetbackMaxAttribute", readThermostatOccupiedSetbackMaxAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUnoccupiedSetbackCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUnoccupiedSetbackAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readUnoccupiedSetbackAttribute(
              (ChipClusters.ThermostatCluster.UnoccupiedSetbackAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterUnoccupiedSetbackAttributeCallback(),
          readThermostatUnoccupiedSetbackCommandParams
        );
        result.put("readUnoccupiedSetbackAttribute", readThermostatUnoccupiedSetbackAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUnoccupiedSetbackMinCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUnoccupiedSetbackMinAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readUnoccupiedSetbackMinAttribute(
              (ChipClusters.ThermostatCluster.UnoccupiedSetbackMinAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterUnoccupiedSetbackMinAttributeCallback(),
          readThermostatUnoccupiedSetbackMinCommandParams
        );
        result.put("readUnoccupiedSetbackMinAttribute", readThermostatUnoccupiedSetbackMinAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUnoccupiedSetbackMaxCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUnoccupiedSetbackMaxAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readUnoccupiedSetbackMaxAttribute(
              (ChipClusters.ThermostatCluster.UnoccupiedSetbackMaxAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterUnoccupiedSetbackMaxAttributeCallback(),
          readThermostatUnoccupiedSetbackMaxCommandParams
        );
        result.put("readUnoccupiedSetbackMaxAttribute", readThermostatUnoccupiedSetbackMaxAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatEmergencyHeatDeltaCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatEmergencyHeatDeltaAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readEmergencyHeatDeltaAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatEmergencyHeatDeltaCommandParams
        );
        result.put("readEmergencyHeatDeltaAttribute", readThermostatEmergencyHeatDeltaAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatACTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatACTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readACTypeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatACTypeCommandParams
        );
        result.put("readACTypeAttribute", readThermostatACTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatACCapacityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatACCapacityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readACCapacityAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatACCapacityCommandParams
        );
        result.put("readACCapacityAttribute", readThermostatACCapacityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatACRefrigerantTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatACRefrigerantTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readACRefrigerantTypeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatACRefrigerantTypeCommandParams
        );
        result.put("readACRefrigerantTypeAttribute", readThermostatACRefrigerantTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatACCompressorTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatACCompressorTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readACCompressorTypeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatACCompressorTypeCommandParams
        );
        result.put("readACCompressorTypeAttribute", readThermostatACCompressorTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatACErrorCodeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatACErrorCodeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readACErrorCodeAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThermostatACErrorCodeCommandParams
        );
        result.put("readACErrorCodeAttribute", readThermostatACErrorCodeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatACLouverPositionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatACLouverPositionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readACLouverPositionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatACLouverPositionCommandParams
        );
        result.put("readACLouverPositionAttribute", readThermostatACLouverPositionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatACCoilTemperatureCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatACCoilTemperatureAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readACCoilTemperatureAttribute(
              (ChipClusters.ThermostatCluster.ACCoilTemperatureAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterACCoilTemperatureAttributeCallback(),
          readThermostatACCoilTemperatureCommandParams
        );
        result.put("readACCoilTemperatureAttribute", readThermostatACCoilTemperatureAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatACCapacityformatCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatACCapacityformatAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readACCapacityformatAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatACCapacityformatCommandParams
        );
        result.put("readACCapacityformatAttribute", readThermostatACCapacityformatAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ThermostatCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterGeneratedCommandListAttributeCallback(),
          readThermostatGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readThermostatGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ThermostatCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterAcceptedCommandListAttributeCallback(),
          readThermostatAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readThermostatAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readEventListAttribute(
              (ChipClusters.ThermostatCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterEventListAttributeCallback(),
          readThermostatEventListCommandParams
        );
        result.put("readEventListAttribute", readThermostatEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ThermostatCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatClusterAttributeListAttributeCallback(),
          readThermostatAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readThermostatAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThermostatFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readThermostatFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readThermostatClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readFanControlInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readFanControlFanModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlFanModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readFanModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFanControlFanModeCommandParams
        );
        result.put("readFanModeAttribute", readFanControlFanModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlFanModeSequenceCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlFanModeSequenceAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readFanModeSequenceAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFanControlFanModeSequenceCommandParams
        );
        result.put("readFanModeSequenceAttribute", readFanControlFanModeSequenceAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlPercentSettingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlPercentSettingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readPercentSettingAttribute(
              (ChipClusters.FanControlCluster.PercentSettingAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFanControlClusterPercentSettingAttributeCallback(),
          readFanControlPercentSettingCommandParams
        );
        result.put("readPercentSettingAttribute", readFanControlPercentSettingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlPercentCurrentCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlPercentCurrentAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readPercentCurrentAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFanControlPercentCurrentCommandParams
        );
        result.put("readPercentCurrentAttribute", readFanControlPercentCurrentAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlSpeedMaxCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlSpeedMaxAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readSpeedMaxAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFanControlSpeedMaxCommandParams
        );
        result.put("readSpeedMaxAttribute", readFanControlSpeedMaxAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlSpeedSettingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlSpeedSettingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readSpeedSettingAttribute(
              (ChipClusters.FanControlCluster.SpeedSettingAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFanControlClusterSpeedSettingAttributeCallback(),
          readFanControlSpeedSettingCommandParams
        );
        result.put("readSpeedSettingAttribute", readFanControlSpeedSettingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlSpeedCurrentCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlSpeedCurrentAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readSpeedCurrentAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFanControlSpeedCurrentCommandParams
        );
        result.put("readSpeedCurrentAttribute", readFanControlSpeedCurrentAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlRockSupportCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlRockSupportAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readRockSupportAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFanControlRockSupportCommandParams
        );
        result.put("readRockSupportAttribute", readFanControlRockSupportAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlRockSettingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlRockSettingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readRockSettingAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFanControlRockSettingCommandParams
        );
        result.put("readRockSettingAttribute", readFanControlRockSettingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlWindSupportCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlWindSupportAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readWindSupportAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFanControlWindSupportCommandParams
        );
        result.put("readWindSupportAttribute", readFanControlWindSupportAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlWindSettingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlWindSettingAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readWindSettingAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFanControlWindSettingCommandParams
        );
        result.put("readWindSettingAttribute", readFanControlWindSettingAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlAirflowDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlAirflowDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readAirflowDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFanControlAirflowDirectionCommandParams
        );
        result.put("readAirflowDirectionAttribute", readFanControlAirflowDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.FanControlCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFanControlClusterGeneratedCommandListAttributeCallback(),
          readFanControlGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readFanControlGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.FanControlCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFanControlClusterAcceptedCommandListAttributeCallback(),
          readFanControlAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readFanControlAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readEventListAttribute(
              (ChipClusters.FanControlCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFanControlClusterEventListAttributeCallback(),
          readFanControlEventListCommandParams
        );
        result.put("readEventListAttribute", readFanControlEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readAttributeListAttribute(
              (ChipClusters.FanControlCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFanControlClusterAttributeListAttributeCallback(),
          readFanControlAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readFanControlAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readFanControlFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readFanControlFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFanControlClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFanControlClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FanControlCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFanControlClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readFanControlClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readThermostatUserInterfaceConfigurationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readThermostatUserInterfaceConfigurationTemperatureDisplayModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUserInterfaceConfigurationTemperatureDisplayModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatUserInterfaceConfigurationCluster) cluster).readTemperatureDisplayModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatUserInterfaceConfigurationTemperatureDisplayModeCommandParams
        );
        result.put("readTemperatureDisplayModeAttribute", readThermostatUserInterfaceConfigurationTemperatureDisplayModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUserInterfaceConfigurationKeypadLockoutCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUserInterfaceConfigurationKeypadLockoutAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatUserInterfaceConfigurationCluster) cluster).readKeypadLockoutAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatUserInterfaceConfigurationKeypadLockoutCommandParams
        );
        result.put("readKeypadLockoutAttribute", readThermostatUserInterfaceConfigurationKeypadLockoutAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUserInterfaceConfigurationScheduleProgrammingVisibilityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUserInterfaceConfigurationScheduleProgrammingVisibilityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatUserInterfaceConfigurationCluster) cluster).readScheduleProgrammingVisibilityAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatUserInterfaceConfigurationScheduleProgrammingVisibilityCommandParams
        );
        result.put("readScheduleProgrammingVisibilityAttribute", readThermostatUserInterfaceConfigurationScheduleProgrammingVisibilityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUserInterfaceConfigurationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUserInterfaceConfigurationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatUserInterfaceConfigurationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ThermostatUserInterfaceConfigurationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatUserInterfaceConfigurationClusterGeneratedCommandListAttributeCallback(),
          readThermostatUserInterfaceConfigurationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readThermostatUserInterfaceConfigurationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUserInterfaceConfigurationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUserInterfaceConfigurationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatUserInterfaceConfigurationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ThermostatUserInterfaceConfigurationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatUserInterfaceConfigurationClusterAcceptedCommandListAttributeCallback(),
          readThermostatUserInterfaceConfigurationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readThermostatUserInterfaceConfigurationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUserInterfaceConfigurationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUserInterfaceConfigurationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatUserInterfaceConfigurationCluster) cluster).readEventListAttribute(
              (ChipClusters.ThermostatUserInterfaceConfigurationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatUserInterfaceConfigurationClusterEventListAttributeCallback(),
          readThermostatUserInterfaceConfigurationEventListCommandParams
        );
        result.put("readEventListAttribute", readThermostatUserInterfaceConfigurationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUserInterfaceConfigurationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUserInterfaceConfigurationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatUserInterfaceConfigurationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ThermostatUserInterfaceConfigurationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedThermostatUserInterfaceConfigurationClusterAttributeListAttributeCallback(),
          readThermostatUserInterfaceConfigurationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readThermostatUserInterfaceConfigurationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUserInterfaceConfigurationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUserInterfaceConfigurationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatUserInterfaceConfigurationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readThermostatUserInterfaceConfigurationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readThermostatUserInterfaceConfigurationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readThermostatUserInterfaceConfigurationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readThermostatUserInterfaceConfigurationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ThermostatUserInterfaceConfigurationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readThermostatUserInterfaceConfigurationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readThermostatUserInterfaceConfigurationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readColorControlInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readColorControlCurrentHueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlCurrentHueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readCurrentHueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlCurrentHueCommandParams
        );
        result.put("readCurrentHueAttribute", readColorControlCurrentHueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlCurrentSaturationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlCurrentSaturationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readCurrentSaturationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlCurrentSaturationCommandParams
        );
        result.put("readCurrentSaturationAttribute", readColorControlCurrentSaturationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlRemainingTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlRemainingTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readRemainingTimeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlRemainingTimeCommandParams
        );
        result.put("readRemainingTimeAttribute", readColorControlRemainingTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlCurrentXCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlCurrentXAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readCurrentXAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlCurrentXCommandParams
        );
        result.put("readCurrentXAttribute", readColorControlCurrentXAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlCurrentYCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlCurrentYAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readCurrentYAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlCurrentYCommandParams
        );
        result.put("readCurrentYAttribute", readColorControlCurrentYAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlDriftCompensationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlDriftCompensationAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readDriftCompensationAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlDriftCompensationCommandParams
        );
        result.put("readDriftCompensationAttribute", readColorControlDriftCompensationAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlCompensationTextCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlCompensationTextAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readCompensationTextAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readColorControlCompensationTextCommandParams
        );
        result.put("readCompensationTextAttribute", readColorControlCompensationTextAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorTemperatureMiredsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorTemperatureMiredsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorTemperatureMiredsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorTemperatureMiredsCommandParams
        );
        result.put("readColorTemperatureMiredsAttribute", readColorControlColorTemperatureMiredsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorModeCommandParams
        );
        result.put("readColorModeAttribute", readColorControlColorModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlOptionsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlOptionsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readOptionsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlOptionsCommandParams
        );
        result.put("readOptionsAttribute", readColorControlOptionsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlNumberOfPrimariesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlNumberOfPrimariesAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readNumberOfPrimariesAttribute(
              (ChipClusters.ColorControlCluster.NumberOfPrimariesAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterNumberOfPrimariesAttributeCallback(),
          readColorControlNumberOfPrimariesCommandParams
        );
        result.put("readNumberOfPrimariesAttribute", readColorControlNumberOfPrimariesAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary1XCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary1XAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary1XAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary1XCommandParams
        );
        result.put("readPrimary1XAttribute", readColorControlPrimary1XAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary1YCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary1YAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary1YAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary1YCommandParams
        );
        result.put("readPrimary1YAttribute", readColorControlPrimary1YAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary1IntensityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary1IntensityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary1IntensityAttribute(
              (ChipClusters.ColorControlCluster.Primary1IntensityAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterPrimary1IntensityAttributeCallback(),
          readColorControlPrimary1IntensityCommandParams
        );
        result.put("readPrimary1IntensityAttribute", readColorControlPrimary1IntensityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary2XCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary2XAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary2XAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary2XCommandParams
        );
        result.put("readPrimary2XAttribute", readColorControlPrimary2XAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary2YCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary2YAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary2YAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary2YCommandParams
        );
        result.put("readPrimary2YAttribute", readColorControlPrimary2YAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary2IntensityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary2IntensityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary2IntensityAttribute(
              (ChipClusters.ColorControlCluster.Primary2IntensityAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterPrimary2IntensityAttributeCallback(),
          readColorControlPrimary2IntensityCommandParams
        );
        result.put("readPrimary2IntensityAttribute", readColorControlPrimary2IntensityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary3XCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary3XAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary3XAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary3XCommandParams
        );
        result.put("readPrimary3XAttribute", readColorControlPrimary3XAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary3YCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary3YAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary3YAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary3YCommandParams
        );
        result.put("readPrimary3YAttribute", readColorControlPrimary3YAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary3IntensityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary3IntensityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary3IntensityAttribute(
              (ChipClusters.ColorControlCluster.Primary3IntensityAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterPrimary3IntensityAttributeCallback(),
          readColorControlPrimary3IntensityCommandParams
        );
        result.put("readPrimary3IntensityAttribute", readColorControlPrimary3IntensityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary4XCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary4XAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary4XAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary4XCommandParams
        );
        result.put("readPrimary4XAttribute", readColorControlPrimary4XAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary4YCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary4YAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary4YAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary4YCommandParams
        );
        result.put("readPrimary4YAttribute", readColorControlPrimary4YAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary4IntensityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary4IntensityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary4IntensityAttribute(
              (ChipClusters.ColorControlCluster.Primary4IntensityAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterPrimary4IntensityAttributeCallback(),
          readColorControlPrimary4IntensityCommandParams
        );
        result.put("readPrimary4IntensityAttribute", readColorControlPrimary4IntensityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary5XCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary5XAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary5XAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary5XCommandParams
        );
        result.put("readPrimary5XAttribute", readColorControlPrimary5XAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary5YCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary5YAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary5YAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary5YCommandParams
        );
        result.put("readPrimary5YAttribute", readColorControlPrimary5YAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary5IntensityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary5IntensityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary5IntensityAttribute(
              (ChipClusters.ColorControlCluster.Primary5IntensityAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterPrimary5IntensityAttributeCallback(),
          readColorControlPrimary5IntensityCommandParams
        );
        result.put("readPrimary5IntensityAttribute", readColorControlPrimary5IntensityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary6XCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary6XAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary6XAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary6XCommandParams
        );
        result.put("readPrimary6XAttribute", readColorControlPrimary6XAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary6YCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary6YAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary6YAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlPrimary6YCommandParams
        );
        result.put("readPrimary6YAttribute", readColorControlPrimary6YAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlPrimary6IntensityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlPrimary6IntensityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readPrimary6IntensityAttribute(
              (ChipClusters.ColorControlCluster.Primary6IntensityAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterPrimary6IntensityAttributeCallback(),
          readColorControlPrimary6IntensityCommandParams
        );
        result.put("readPrimary6IntensityAttribute", readColorControlPrimary6IntensityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlWhitePointXCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlWhitePointXAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readWhitePointXAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlWhitePointXCommandParams
        );
        result.put("readWhitePointXAttribute", readColorControlWhitePointXAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlWhitePointYCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlWhitePointYAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readWhitePointYAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlWhitePointYCommandParams
        );
        result.put("readWhitePointYAttribute", readColorControlWhitePointYAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorPointRXCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorPointRXAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorPointRXAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorPointRXCommandParams
        );
        result.put("readColorPointRXAttribute", readColorControlColorPointRXAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorPointRYCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorPointRYAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorPointRYAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorPointRYCommandParams
        );
        result.put("readColorPointRYAttribute", readColorControlColorPointRYAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorPointRIntensityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorPointRIntensityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorPointRIntensityAttribute(
              (ChipClusters.ColorControlCluster.ColorPointRIntensityAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterColorPointRIntensityAttributeCallback(),
          readColorControlColorPointRIntensityCommandParams
        );
        result.put("readColorPointRIntensityAttribute", readColorControlColorPointRIntensityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorPointGXCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorPointGXAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorPointGXAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorPointGXCommandParams
        );
        result.put("readColorPointGXAttribute", readColorControlColorPointGXAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorPointGYCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorPointGYAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorPointGYAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorPointGYCommandParams
        );
        result.put("readColorPointGYAttribute", readColorControlColorPointGYAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorPointGIntensityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorPointGIntensityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorPointGIntensityAttribute(
              (ChipClusters.ColorControlCluster.ColorPointGIntensityAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterColorPointGIntensityAttributeCallback(),
          readColorControlColorPointGIntensityCommandParams
        );
        result.put("readColorPointGIntensityAttribute", readColorControlColorPointGIntensityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorPointBXCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorPointBXAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorPointBXAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorPointBXCommandParams
        );
        result.put("readColorPointBXAttribute", readColorControlColorPointBXAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorPointBYCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorPointBYAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorPointBYAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorPointBYCommandParams
        );
        result.put("readColorPointBYAttribute", readColorControlColorPointBYAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorPointBIntensityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorPointBIntensityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorPointBIntensityAttribute(
              (ChipClusters.ColorControlCluster.ColorPointBIntensityAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterColorPointBIntensityAttributeCallback(),
          readColorControlColorPointBIntensityCommandParams
        );
        result.put("readColorPointBIntensityAttribute", readColorControlColorPointBIntensityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlEnhancedCurrentHueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlEnhancedCurrentHueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readEnhancedCurrentHueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlEnhancedCurrentHueCommandParams
        );
        result.put("readEnhancedCurrentHueAttribute", readColorControlEnhancedCurrentHueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlEnhancedColorModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlEnhancedColorModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readEnhancedColorModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlEnhancedColorModeCommandParams
        );
        result.put("readEnhancedColorModeAttribute", readColorControlEnhancedColorModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorLoopActiveCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorLoopActiveAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorLoopActiveAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorLoopActiveCommandParams
        );
        result.put("readColorLoopActiveAttribute", readColorControlColorLoopActiveAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorLoopDirectionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorLoopDirectionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorLoopDirectionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorLoopDirectionCommandParams
        );
        result.put("readColorLoopDirectionAttribute", readColorControlColorLoopDirectionAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorLoopTimeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorLoopTimeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorLoopTimeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorLoopTimeCommandParams
        );
        result.put("readColorLoopTimeAttribute", readColorControlColorLoopTimeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorLoopStartEnhancedHueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorLoopStartEnhancedHueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorLoopStartEnhancedHueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorLoopStartEnhancedHueCommandParams
        );
        result.put("readColorLoopStartEnhancedHueAttribute", readColorControlColorLoopStartEnhancedHueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorLoopStoredEnhancedHueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorLoopStoredEnhancedHueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorLoopStoredEnhancedHueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorLoopStoredEnhancedHueCommandParams
        );
        result.put("readColorLoopStoredEnhancedHueAttribute", readColorControlColorLoopStoredEnhancedHueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorCapabilitiesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorCapabilitiesAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorCapabilitiesAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorCapabilitiesCommandParams
        );
        result.put("readColorCapabilitiesAttribute", readColorControlColorCapabilitiesAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorTempPhysicalMinMiredsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorTempPhysicalMinMiredsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorTempPhysicalMinMiredsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorTempPhysicalMinMiredsCommandParams
        );
        result.put("readColorTempPhysicalMinMiredsAttribute", readColorControlColorTempPhysicalMinMiredsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlColorTempPhysicalMaxMiredsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlColorTempPhysicalMaxMiredsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readColorTempPhysicalMaxMiredsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlColorTempPhysicalMaxMiredsCommandParams
        );
        result.put("readColorTempPhysicalMaxMiredsAttribute", readColorControlColorTempPhysicalMaxMiredsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlCoupleColorTempToLevelMinMiredsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlCoupleColorTempToLevelMinMiredsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readCoupleColorTempToLevelMinMiredsAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlCoupleColorTempToLevelMinMiredsCommandParams
        );
        result.put("readCoupleColorTempToLevelMinMiredsAttribute", readColorControlCoupleColorTempToLevelMinMiredsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlStartUpColorTemperatureMiredsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlStartUpColorTemperatureMiredsAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readStartUpColorTemperatureMiredsAttribute(
              (ChipClusters.ColorControlCluster.StartUpColorTemperatureMiredsAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterStartUpColorTemperatureMiredsAttributeCallback(),
          readColorControlStartUpColorTemperatureMiredsCommandParams
        );
        result.put("readStartUpColorTemperatureMiredsAttribute", readColorControlStartUpColorTemperatureMiredsAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.ColorControlCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterGeneratedCommandListAttributeCallback(),
          readColorControlGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readColorControlGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.ColorControlCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterAcceptedCommandListAttributeCallback(),
          readColorControlAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readColorControlAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readEventListAttribute(
              (ChipClusters.ColorControlCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterEventListAttributeCallback(),
          readColorControlEventListCommandParams
        );
        result.put("readEventListAttribute", readColorControlEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readAttributeListAttribute(
              (ChipClusters.ColorControlCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedColorControlClusterAttributeListAttributeCallback(),
          readColorControlAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readColorControlAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readColorControlFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readColorControlFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readColorControlClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readColorControlClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.ColorControlCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readColorControlClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readColorControlClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readBallastConfigurationInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readBallastConfigurationPhysicalMinLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationPhysicalMinLevelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readPhysicalMinLevelAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBallastConfigurationPhysicalMinLevelCommandParams
        );
        result.put("readPhysicalMinLevelAttribute", readBallastConfigurationPhysicalMinLevelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationPhysicalMaxLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationPhysicalMaxLevelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readPhysicalMaxLevelAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBallastConfigurationPhysicalMaxLevelCommandParams
        );
        result.put("readPhysicalMaxLevelAttribute", readBallastConfigurationPhysicalMaxLevelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationBallastStatusCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationBallastStatusAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readBallastStatusAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBallastConfigurationBallastStatusCommandParams
        );
        result.put("readBallastStatusAttribute", readBallastConfigurationBallastStatusAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationMinLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationMinLevelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readMinLevelAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBallastConfigurationMinLevelCommandParams
        );
        result.put("readMinLevelAttribute", readBallastConfigurationMinLevelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationMaxLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationMaxLevelAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readMaxLevelAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBallastConfigurationMaxLevelCommandParams
        );
        result.put("readMaxLevelAttribute", readBallastConfigurationMaxLevelAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationIntrinsicBallastFactorCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationIntrinsicBallastFactorAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readIntrinsicBallastFactorAttribute(
              (ChipClusters.BallastConfigurationCluster.IntrinsicBallastFactorAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBallastConfigurationClusterIntrinsicBallastFactorAttributeCallback(),
          readBallastConfigurationIntrinsicBallastFactorCommandParams
        );
        result.put("readIntrinsicBallastFactorAttribute", readBallastConfigurationIntrinsicBallastFactorAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationBallastFactorAdjustmentCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationBallastFactorAdjustmentAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readBallastFactorAdjustmentAttribute(
              (ChipClusters.BallastConfigurationCluster.BallastFactorAdjustmentAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBallastConfigurationClusterBallastFactorAdjustmentAttributeCallback(),
          readBallastConfigurationBallastFactorAdjustmentCommandParams
        );
        result.put("readBallastFactorAdjustmentAttribute", readBallastConfigurationBallastFactorAdjustmentAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationLampQuantityCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationLampQuantityAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readLampQuantityAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBallastConfigurationLampQuantityCommandParams
        );
        result.put("readLampQuantityAttribute", readBallastConfigurationLampQuantityAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationLampTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationLampTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readLampTypeAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBallastConfigurationLampTypeCommandParams
        );
        result.put("readLampTypeAttribute", readBallastConfigurationLampTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationLampManufacturerCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationLampManufacturerAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readLampManufacturerAttribute(
              (ChipClusters.CharStringAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCharStringAttributeCallback(),
          readBallastConfigurationLampManufacturerCommandParams
        );
        result.put("readLampManufacturerAttribute", readBallastConfigurationLampManufacturerAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationLampRatedHoursCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationLampRatedHoursAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readLampRatedHoursAttribute(
              (ChipClusters.BallastConfigurationCluster.LampRatedHoursAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBallastConfigurationClusterLampRatedHoursAttributeCallback(),
          readBallastConfigurationLampRatedHoursCommandParams
        );
        result.put("readLampRatedHoursAttribute", readBallastConfigurationLampRatedHoursAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationLampBurnHoursCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationLampBurnHoursAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readLampBurnHoursAttribute(
              (ChipClusters.BallastConfigurationCluster.LampBurnHoursAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBallastConfigurationClusterLampBurnHoursAttributeCallback(),
          readBallastConfigurationLampBurnHoursCommandParams
        );
        result.put("readLampBurnHoursAttribute", readBallastConfigurationLampBurnHoursAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationLampAlarmModeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationLampAlarmModeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readLampAlarmModeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBallastConfigurationLampAlarmModeCommandParams
        );
        result.put("readLampAlarmModeAttribute", readBallastConfigurationLampAlarmModeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationLampBurnHoursTripPointCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationLampBurnHoursTripPointAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readLampBurnHoursTripPointAttribute(
              (ChipClusters.BallastConfigurationCluster.LampBurnHoursTripPointAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBallastConfigurationClusterLampBurnHoursTripPointAttributeCallback(),
          readBallastConfigurationLampBurnHoursTripPointCommandParams
        );
        result.put("readLampBurnHoursTripPointAttribute", readBallastConfigurationLampBurnHoursTripPointAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.BallastConfigurationCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBallastConfigurationClusterGeneratedCommandListAttributeCallback(),
          readBallastConfigurationGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readBallastConfigurationGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.BallastConfigurationCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBallastConfigurationClusterAcceptedCommandListAttributeCallback(),
          readBallastConfigurationAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readBallastConfigurationAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readEventListAttribute(
              (ChipClusters.BallastConfigurationCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBallastConfigurationClusterEventListAttributeCallback(),
          readBallastConfigurationEventListCommandParams
        );
        result.put("readEventListAttribute", readBallastConfigurationEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readAttributeListAttribute(
              (ChipClusters.BallastConfigurationCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedBallastConfigurationClusterAttributeListAttributeCallback(),
          readBallastConfigurationAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readBallastConfigurationAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readBallastConfigurationFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readBallastConfigurationFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readBallastConfigurationClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readBallastConfigurationClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.BallastConfigurationCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readBallastConfigurationClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readBallastConfigurationClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readIlluminanceMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readIlluminanceMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIlluminanceMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IlluminanceMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.IlluminanceMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIlluminanceMeasurementClusterMeasuredValueAttributeCallback(),
          readIlluminanceMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readIlluminanceMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIlluminanceMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIlluminanceMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IlluminanceMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.IlluminanceMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIlluminanceMeasurementClusterMinMeasuredValueAttributeCallback(),
          readIlluminanceMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readIlluminanceMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIlluminanceMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIlluminanceMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IlluminanceMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.IlluminanceMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIlluminanceMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readIlluminanceMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readIlluminanceMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIlluminanceMeasurementToleranceCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIlluminanceMeasurementToleranceAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IlluminanceMeasurementCluster) cluster).readToleranceAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIlluminanceMeasurementToleranceCommandParams
        );
        result.put("readToleranceAttribute", readIlluminanceMeasurementToleranceAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIlluminanceMeasurementLightSensorTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIlluminanceMeasurementLightSensorTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IlluminanceMeasurementCluster) cluster).readLightSensorTypeAttribute(
              (ChipClusters.IlluminanceMeasurementCluster.LightSensorTypeAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIlluminanceMeasurementClusterLightSensorTypeAttributeCallback(),
          readIlluminanceMeasurementLightSensorTypeCommandParams
        );
        result.put("readLightSensorTypeAttribute", readIlluminanceMeasurementLightSensorTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIlluminanceMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIlluminanceMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IlluminanceMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.IlluminanceMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIlluminanceMeasurementClusterGeneratedCommandListAttributeCallback(),
          readIlluminanceMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readIlluminanceMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIlluminanceMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIlluminanceMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IlluminanceMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.IlluminanceMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIlluminanceMeasurementClusterAcceptedCommandListAttributeCallback(),
          readIlluminanceMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readIlluminanceMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIlluminanceMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIlluminanceMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IlluminanceMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.IlluminanceMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIlluminanceMeasurementClusterEventListAttributeCallback(),
          readIlluminanceMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readIlluminanceMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIlluminanceMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIlluminanceMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IlluminanceMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.IlluminanceMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIlluminanceMeasurementClusterAttributeListAttributeCallback(),
          readIlluminanceMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readIlluminanceMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIlluminanceMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIlluminanceMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IlluminanceMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readIlluminanceMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readIlluminanceMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readIlluminanceMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readIlluminanceMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.IlluminanceMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readIlluminanceMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readIlluminanceMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readTemperatureMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readTemperatureMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.TemperatureMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureMeasurementClusterMeasuredValueAttributeCallback(),
          readTemperatureMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readTemperatureMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.TemperatureMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureMeasurementClusterMinMeasuredValueAttributeCallback(),
          readTemperatureMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readTemperatureMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.TemperatureMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readTemperatureMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readTemperatureMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureMeasurementToleranceCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureMeasurementToleranceAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureMeasurementCluster) cluster).readToleranceAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTemperatureMeasurementToleranceCommandParams
        );
        result.put("readToleranceAttribute", readTemperatureMeasurementToleranceAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.TemperatureMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureMeasurementClusterGeneratedCommandListAttributeCallback(),
          readTemperatureMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readTemperatureMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.TemperatureMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureMeasurementClusterAcceptedCommandListAttributeCallback(),
          readTemperatureMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readTemperatureMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.TemperatureMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureMeasurementClusterEventListAttributeCallback(),
          readTemperatureMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readTemperatureMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.TemperatureMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedTemperatureMeasurementClusterAttributeListAttributeCallback(),
          readTemperatureMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readTemperatureMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readTemperatureMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readTemperatureMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readTemperatureMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readTemperatureMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.TemperatureMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readTemperatureMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readTemperatureMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readPressureMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readPressureMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.PressureMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPressureMeasurementClusterMeasuredValueAttributeCallback(),
          readPressureMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readPressureMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.PressureMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPressureMeasurementClusterMinMeasuredValueAttributeCallback(),
          readPressureMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readPressureMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.PressureMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPressureMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readPressureMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readPressureMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementToleranceCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementToleranceAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readToleranceAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPressureMeasurementToleranceCommandParams
        );
        result.put("readToleranceAttribute", readPressureMeasurementToleranceAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementScaledValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementScaledValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readScaledValueAttribute(
              (ChipClusters.PressureMeasurementCluster.ScaledValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPressureMeasurementClusterScaledValueAttributeCallback(),
          readPressureMeasurementScaledValueCommandParams
        );
        result.put("readScaledValueAttribute", readPressureMeasurementScaledValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementMinScaledValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementMinScaledValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readMinScaledValueAttribute(
              (ChipClusters.PressureMeasurementCluster.MinScaledValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPressureMeasurementClusterMinScaledValueAttributeCallback(),
          readPressureMeasurementMinScaledValueCommandParams
        );
        result.put("readMinScaledValueAttribute", readPressureMeasurementMinScaledValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementMaxScaledValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementMaxScaledValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readMaxScaledValueAttribute(
              (ChipClusters.PressureMeasurementCluster.MaxScaledValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPressureMeasurementClusterMaxScaledValueAttributeCallback(),
          readPressureMeasurementMaxScaledValueCommandParams
        );
        result.put("readMaxScaledValueAttribute", readPressureMeasurementMaxScaledValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementScaledToleranceCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementScaledToleranceAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readScaledToleranceAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPressureMeasurementScaledToleranceCommandParams
        );
        result.put("readScaledToleranceAttribute", readPressureMeasurementScaledToleranceAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementScaleCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementScaleAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readScaleAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPressureMeasurementScaleCommandParams
        );
        result.put("readScaleAttribute", readPressureMeasurementScaleAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.PressureMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPressureMeasurementClusterGeneratedCommandListAttributeCallback(),
          readPressureMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readPressureMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.PressureMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPressureMeasurementClusterAcceptedCommandListAttributeCallback(),
          readPressureMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readPressureMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.PressureMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPressureMeasurementClusterEventListAttributeCallback(),
          readPressureMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readPressureMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.PressureMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedPressureMeasurementClusterAttributeListAttributeCallback(),
          readPressureMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readPressureMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readPressureMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readPressureMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readPressureMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readPressureMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.PressureMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readPressureMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readPressureMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readFlowMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readFlowMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFlowMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FlowMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.FlowMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFlowMeasurementClusterMeasuredValueAttributeCallback(),
          readFlowMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readFlowMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFlowMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFlowMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FlowMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.FlowMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFlowMeasurementClusterMinMeasuredValueAttributeCallback(),
          readFlowMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readFlowMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFlowMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFlowMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FlowMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.FlowMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFlowMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readFlowMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readFlowMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFlowMeasurementToleranceCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFlowMeasurementToleranceAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FlowMeasurementCluster) cluster).readToleranceAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFlowMeasurementToleranceCommandParams
        );
        result.put("readToleranceAttribute", readFlowMeasurementToleranceAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFlowMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFlowMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FlowMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.FlowMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFlowMeasurementClusterGeneratedCommandListAttributeCallback(),
          readFlowMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readFlowMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFlowMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFlowMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FlowMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.FlowMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFlowMeasurementClusterAcceptedCommandListAttributeCallback(),
          readFlowMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readFlowMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFlowMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFlowMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FlowMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.FlowMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFlowMeasurementClusterEventListAttributeCallback(),
          readFlowMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readFlowMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFlowMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFlowMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FlowMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.FlowMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFlowMeasurementClusterAttributeListAttributeCallback(),
          readFlowMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readFlowMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFlowMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFlowMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FlowMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readFlowMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readFlowMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readFlowMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readFlowMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.FlowMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readFlowMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readFlowMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readRelativeHumidityMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readRelativeHumidityMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRelativeHumidityMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RelativeHumidityMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.RelativeHumidityMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedRelativeHumidityMeasurementClusterMeasuredValueAttributeCallback(),
          readRelativeHumidityMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readRelativeHumidityMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRelativeHumidityMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRelativeHumidityMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RelativeHumidityMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.RelativeHumidityMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedRelativeHumidityMeasurementClusterMinMeasuredValueAttributeCallback(),
          readRelativeHumidityMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readRelativeHumidityMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRelativeHumidityMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRelativeHumidityMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RelativeHumidityMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.RelativeHumidityMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedRelativeHumidityMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readRelativeHumidityMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readRelativeHumidityMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRelativeHumidityMeasurementToleranceCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRelativeHumidityMeasurementToleranceAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RelativeHumidityMeasurementCluster) cluster).readToleranceAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readRelativeHumidityMeasurementToleranceCommandParams
        );
        result.put("readToleranceAttribute", readRelativeHumidityMeasurementToleranceAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRelativeHumidityMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRelativeHumidityMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RelativeHumidityMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.RelativeHumidityMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedRelativeHumidityMeasurementClusterGeneratedCommandListAttributeCallback(),
          readRelativeHumidityMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readRelativeHumidityMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRelativeHumidityMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRelativeHumidityMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RelativeHumidityMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.RelativeHumidityMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedRelativeHumidityMeasurementClusterAcceptedCommandListAttributeCallback(),
          readRelativeHumidityMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readRelativeHumidityMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRelativeHumidityMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRelativeHumidityMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RelativeHumidityMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.RelativeHumidityMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedRelativeHumidityMeasurementClusterEventListAttributeCallback(),
          readRelativeHumidityMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readRelativeHumidityMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRelativeHumidityMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRelativeHumidityMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RelativeHumidityMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.RelativeHumidityMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedRelativeHumidityMeasurementClusterAttributeListAttributeCallback(),
          readRelativeHumidityMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readRelativeHumidityMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRelativeHumidityMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRelativeHumidityMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RelativeHumidityMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readRelativeHumidityMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readRelativeHumidityMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readRelativeHumidityMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readRelativeHumidityMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.RelativeHumidityMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readRelativeHumidityMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readRelativeHumidityMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readOccupancySensingInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readOccupancySensingOccupancyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingOccupancyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readOccupancyAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingOccupancyCommandParams
        );
        result.put("readOccupancyAttribute", readOccupancySensingOccupancyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingOccupancySensorTypeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingOccupancySensorTypeAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readOccupancySensorTypeAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingOccupancySensorTypeCommandParams
        );
        result.put("readOccupancySensorTypeAttribute", readOccupancySensingOccupancySensorTypeAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingOccupancySensorTypeBitmapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingOccupancySensorTypeBitmapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readOccupancySensorTypeBitmapAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingOccupancySensorTypeBitmapCommandParams
        );
        result.put("readOccupancySensorTypeBitmapAttribute", readOccupancySensingOccupancySensorTypeBitmapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingPIROccupiedToUnoccupiedDelayCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingPIROccupiedToUnoccupiedDelayAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readPIROccupiedToUnoccupiedDelayAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingPIROccupiedToUnoccupiedDelayCommandParams
        );
        result.put("readPIROccupiedToUnoccupiedDelayAttribute", readOccupancySensingPIROccupiedToUnoccupiedDelayAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingPIRUnoccupiedToOccupiedDelayCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingPIRUnoccupiedToOccupiedDelayAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readPIRUnoccupiedToOccupiedDelayAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingPIRUnoccupiedToOccupiedDelayCommandParams
        );
        result.put("readPIRUnoccupiedToOccupiedDelayAttribute", readOccupancySensingPIRUnoccupiedToOccupiedDelayAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingPIRUnoccupiedToOccupiedThresholdCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingPIRUnoccupiedToOccupiedThresholdAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readPIRUnoccupiedToOccupiedThresholdAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingPIRUnoccupiedToOccupiedThresholdCommandParams
        );
        result.put("readPIRUnoccupiedToOccupiedThresholdAttribute", readOccupancySensingPIRUnoccupiedToOccupiedThresholdAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingUltrasonicOccupiedToUnoccupiedDelayCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingUltrasonicOccupiedToUnoccupiedDelayAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readUltrasonicOccupiedToUnoccupiedDelayAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingUltrasonicOccupiedToUnoccupiedDelayCommandParams
        );
        result.put("readUltrasonicOccupiedToUnoccupiedDelayAttribute", readOccupancySensingUltrasonicOccupiedToUnoccupiedDelayAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingUltrasonicUnoccupiedToOccupiedDelayCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingUltrasonicUnoccupiedToOccupiedDelayAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readUltrasonicUnoccupiedToOccupiedDelayAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingUltrasonicUnoccupiedToOccupiedDelayCommandParams
        );
        result.put("readUltrasonicUnoccupiedToOccupiedDelayAttribute", readOccupancySensingUltrasonicUnoccupiedToOccupiedDelayAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingUltrasonicUnoccupiedToOccupiedThresholdCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingUltrasonicUnoccupiedToOccupiedThresholdAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readUltrasonicUnoccupiedToOccupiedThresholdAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingUltrasonicUnoccupiedToOccupiedThresholdCommandParams
        );
        result.put("readUltrasonicUnoccupiedToOccupiedThresholdAttribute", readOccupancySensingUltrasonicUnoccupiedToOccupiedThresholdAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingPhysicalContactOccupiedToUnoccupiedDelayCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingPhysicalContactOccupiedToUnoccupiedDelayAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readPhysicalContactOccupiedToUnoccupiedDelayAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingPhysicalContactOccupiedToUnoccupiedDelayCommandParams
        );
        result.put("readPhysicalContactOccupiedToUnoccupiedDelayAttribute", readOccupancySensingPhysicalContactOccupiedToUnoccupiedDelayAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingPhysicalContactUnoccupiedToOccupiedDelayCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingPhysicalContactUnoccupiedToOccupiedDelayAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readPhysicalContactUnoccupiedToOccupiedDelayAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingPhysicalContactUnoccupiedToOccupiedDelayCommandParams
        );
        result.put("readPhysicalContactUnoccupiedToOccupiedDelayAttribute", readOccupancySensingPhysicalContactUnoccupiedToOccupiedDelayAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingPhysicalContactUnoccupiedToOccupiedThresholdCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingPhysicalContactUnoccupiedToOccupiedThresholdAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readPhysicalContactUnoccupiedToOccupiedThresholdAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingPhysicalContactUnoccupiedToOccupiedThresholdCommandParams
        );
        result.put("readPhysicalContactUnoccupiedToOccupiedThresholdAttribute", readOccupancySensingPhysicalContactUnoccupiedToOccupiedThresholdAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.OccupancySensingCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOccupancySensingClusterGeneratedCommandListAttributeCallback(),
          readOccupancySensingGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readOccupancySensingGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.OccupancySensingCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOccupancySensingClusterAcceptedCommandListAttributeCallback(),
          readOccupancySensingAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readOccupancySensingAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readEventListAttribute(
              (ChipClusters.OccupancySensingCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOccupancySensingClusterEventListAttributeCallback(),
          readOccupancySensingEventListCommandParams
        );
        result.put("readEventListAttribute", readOccupancySensingEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readAttributeListAttribute(
              (ChipClusters.OccupancySensingCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOccupancySensingClusterAttributeListAttributeCallback(),
          readOccupancySensingAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readOccupancySensingAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOccupancySensingFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readOccupancySensingFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOccupancySensingClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOccupancySensingClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OccupancySensingCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOccupancySensingClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readOccupancySensingClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readCarbonMonoxideConcentrationMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonMonoxideConcentrationMeasurementClusterMeasuredValueAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readCarbonMonoxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonMonoxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readCarbonMonoxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonMonoxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readCarbonMonoxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementPeakMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueAttribute(
              (ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonMonoxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementPeakMeasuredValueCommandParams
        );
        result.put("readPeakMeasuredValueAttribute", readCarbonMonoxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams
        );
        result.put("readPeakMeasuredValueWindowAttribute", readCarbonMonoxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementAverageMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueAttribute(
              (ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonMonoxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementAverageMeasuredValueCommandParams
        );
        result.put("readAverageMeasuredValueAttribute", readCarbonMonoxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams
        );
        result.put("readAverageMeasuredValueWindowAttribute", readCarbonMonoxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementUncertaintyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementUncertaintyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readUncertaintyAttribute(
              (ChipClusters.FloatAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFloatAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementUncertaintyCommandParams
        );
        result.put("readUncertaintyAttribute", readCarbonMonoxideConcentrationMeasurementUncertaintyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementMeasurementUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readMeasurementUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementMeasurementUnitCommandParams
        );
        result.put("readMeasurementUnitAttribute", readCarbonMonoxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementMeasurementMediumCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readMeasurementMediumAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementMeasurementMediumCommandParams
        );
        result.put("readMeasurementMediumAttribute", readCarbonMonoxideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementLevelValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementLevelValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readLevelValueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementLevelValueCommandParams
        );
        result.put("readLevelValueAttribute", readCarbonMonoxideConcentrationMeasurementLevelValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonMonoxideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readCarbonMonoxideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonMonoxideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readCarbonMonoxideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonMonoxideConcentrationMeasurementClusterEventListAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readCarbonMonoxideConcentrationMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonMonoxideConcentrationMeasurementClusterAttributeListAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readCarbonMonoxideConcentrationMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readCarbonMonoxideConcentrationMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonMonoxideConcentrationMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonMonoxideConcentrationMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonMonoxideConcentrationMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCarbonMonoxideConcentrationMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readCarbonMonoxideConcentrationMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readCarbonDioxideConcentrationMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.CarbonDioxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonDioxideConcentrationMeasurementClusterMeasuredValueAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readCarbonDioxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.CarbonDioxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonDioxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readCarbonDioxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.CarbonDioxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonDioxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readCarbonDioxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementPeakMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueAttribute(
              (ChipClusters.CarbonDioxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonDioxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementPeakMeasuredValueCommandParams
        );
        result.put("readPeakMeasuredValueAttribute", readCarbonDioxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams
        );
        result.put("readPeakMeasuredValueWindowAttribute", readCarbonDioxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementAverageMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueAttribute(
              (ChipClusters.CarbonDioxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonDioxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementAverageMeasuredValueCommandParams
        );
        result.put("readAverageMeasuredValueAttribute", readCarbonDioxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams
        );
        result.put("readAverageMeasuredValueWindowAttribute", readCarbonDioxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementUncertaintyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementUncertaintyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readUncertaintyAttribute(
              (ChipClusters.FloatAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFloatAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementUncertaintyCommandParams
        );
        result.put("readUncertaintyAttribute", readCarbonDioxideConcentrationMeasurementUncertaintyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementMeasurementUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readMeasurementUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementMeasurementUnitCommandParams
        );
        result.put("readMeasurementUnitAttribute", readCarbonDioxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementMeasurementMediumCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readMeasurementMediumAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementMeasurementMediumCommandParams
        );
        result.put("readMeasurementMediumAttribute", readCarbonDioxideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementLevelValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementLevelValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readLevelValueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementLevelValueCommandParams
        );
        result.put("readLevelValueAttribute", readCarbonDioxideConcentrationMeasurementLevelValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.CarbonDioxideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonDioxideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readCarbonDioxideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.CarbonDioxideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonDioxideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readCarbonDioxideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.CarbonDioxideConcentrationMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonDioxideConcentrationMeasurementClusterEventListAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readCarbonDioxideConcentrationMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.CarbonDioxideConcentrationMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedCarbonDioxideConcentrationMeasurementClusterAttributeListAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readCarbonDioxideConcentrationMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readCarbonDioxideConcentrationMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readCarbonDioxideConcentrationMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readCarbonDioxideConcentrationMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.CarbonDioxideConcentrationMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readCarbonDioxideConcentrationMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readCarbonDioxideConcentrationMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readEthyleneConcentrationMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.EthyleneConcentrationMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneConcentrationMeasurementClusterMeasuredValueAttributeCallback(),
          readEthyleneConcentrationMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readEthyleneConcentrationMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.EthyleneConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneConcentrationMeasurementClusterMinMeasuredValueAttributeCallback(),
          readEthyleneConcentrationMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readEthyleneConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.EthyleneConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readEthyleneConcentrationMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readEthyleneConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementPeakMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readPeakMeasuredValueAttribute(
              (ChipClusters.EthyleneConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback(),
          readEthyleneConcentrationMeasurementPeakMeasuredValueCommandParams
        );
        result.put("readPeakMeasuredValueAttribute", readEthyleneConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementPeakMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readPeakMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthyleneConcentrationMeasurementPeakMeasuredValueWindowCommandParams
        );
        result.put("readPeakMeasuredValueWindowAttribute", readEthyleneConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementAverageMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readAverageMeasuredValueAttribute(
              (ChipClusters.EthyleneConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback(),
          readEthyleneConcentrationMeasurementAverageMeasuredValueCommandParams
        );
        result.put("readAverageMeasuredValueAttribute", readEthyleneConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementAverageMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readAverageMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthyleneConcentrationMeasurementAverageMeasuredValueWindowCommandParams
        );
        result.put("readAverageMeasuredValueWindowAttribute", readEthyleneConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementUncertaintyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementUncertaintyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readUncertaintyAttribute(
              (ChipClusters.FloatAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFloatAttributeCallback(),
          readEthyleneConcentrationMeasurementUncertaintyCommandParams
        );
        result.put("readUncertaintyAttribute", readEthyleneConcentrationMeasurementUncertaintyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementMeasurementUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementMeasurementUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readMeasurementUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readEthyleneConcentrationMeasurementMeasurementUnitCommandParams
        );
        result.put("readMeasurementUnitAttribute", readEthyleneConcentrationMeasurementMeasurementUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementMeasurementMediumCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementMeasurementMediumAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readMeasurementMediumAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readEthyleneConcentrationMeasurementMeasurementMediumCommandParams
        );
        result.put("readMeasurementMediumAttribute", readEthyleneConcentrationMeasurementMeasurementMediumAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementLevelValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementLevelValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readLevelValueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readEthyleneConcentrationMeasurementLevelValueCommandParams
        );
        result.put("readLevelValueAttribute", readEthyleneConcentrationMeasurementLevelValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.EthyleneConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneConcentrationMeasurementClusterGeneratedCommandListAttributeCallback(),
          readEthyleneConcentrationMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readEthyleneConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.EthyleneConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneConcentrationMeasurementClusterAcceptedCommandListAttributeCallback(),
          readEthyleneConcentrationMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readEthyleneConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.EthyleneConcentrationMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneConcentrationMeasurementClusterEventListAttributeCallback(),
          readEthyleneConcentrationMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readEthyleneConcentrationMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.EthyleneConcentrationMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneConcentrationMeasurementClusterAttributeListAttributeCallback(),
          readEthyleneConcentrationMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readEthyleneConcentrationMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthyleneConcentrationMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readEthyleneConcentrationMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneConcentrationMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneConcentrationMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneConcentrationMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readEthyleneConcentrationMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readEthyleneConcentrationMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readEthyleneOxideConcentrationMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.EthyleneOxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneOxideConcentrationMeasurementClusterMeasuredValueAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readEthyleneOxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.EthyleneOxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneOxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readEthyleneOxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.EthyleneOxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneOxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readEthyleneOxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementPeakMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueAttribute(
              (ChipClusters.EthyleneOxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneOxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementPeakMeasuredValueCommandParams
        );
        result.put("readPeakMeasuredValueAttribute", readEthyleneOxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams
        );
        result.put("readPeakMeasuredValueWindowAttribute", readEthyleneOxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementAverageMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueAttribute(
              (ChipClusters.EthyleneOxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneOxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementAverageMeasuredValueCommandParams
        );
        result.put("readAverageMeasuredValueAttribute", readEthyleneOxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams
        );
        result.put("readAverageMeasuredValueWindowAttribute", readEthyleneOxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementUncertaintyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementUncertaintyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readUncertaintyAttribute(
              (ChipClusters.FloatAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFloatAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementUncertaintyCommandParams
        );
        result.put("readUncertaintyAttribute", readEthyleneOxideConcentrationMeasurementUncertaintyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementMeasurementUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readMeasurementUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementMeasurementUnitCommandParams
        );
        result.put("readMeasurementUnitAttribute", readEthyleneOxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementMeasurementMediumCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readMeasurementMediumAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementMeasurementMediumCommandParams
        );
        result.put("readMeasurementMediumAttribute", readEthyleneOxideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementLevelValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementLevelValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readLevelValueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementLevelValueCommandParams
        );
        result.put("readLevelValueAttribute", readEthyleneOxideConcentrationMeasurementLevelValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.EthyleneOxideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneOxideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readEthyleneOxideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.EthyleneOxideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneOxideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readEthyleneOxideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.EthyleneOxideConcentrationMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneOxideConcentrationMeasurementClusterEventListAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readEthyleneOxideConcentrationMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.EthyleneOxideConcentrationMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedEthyleneOxideConcentrationMeasurementClusterAttributeListAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readEthyleneOxideConcentrationMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readEthyleneOxideConcentrationMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readEthyleneOxideConcentrationMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readEthyleneOxideConcentrationMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.EthyleneOxideConcentrationMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readEthyleneOxideConcentrationMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readEthyleneOxideConcentrationMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readHydrogenConcentrationMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.HydrogenConcentrationMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenConcentrationMeasurementClusterMeasuredValueAttributeCallback(),
          readHydrogenConcentrationMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readHydrogenConcentrationMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.HydrogenConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenConcentrationMeasurementClusterMinMeasuredValueAttributeCallback(),
          readHydrogenConcentrationMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readHydrogenConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.HydrogenConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readHydrogenConcentrationMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readHydrogenConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementPeakMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readPeakMeasuredValueAttribute(
              (ChipClusters.HydrogenConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback(),
          readHydrogenConcentrationMeasurementPeakMeasuredValueCommandParams
        );
        result.put("readPeakMeasuredValueAttribute", readHydrogenConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementPeakMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readPeakMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readHydrogenConcentrationMeasurementPeakMeasuredValueWindowCommandParams
        );
        result.put("readPeakMeasuredValueWindowAttribute", readHydrogenConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementAverageMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readAverageMeasuredValueAttribute(
              (ChipClusters.HydrogenConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback(),
          readHydrogenConcentrationMeasurementAverageMeasuredValueCommandParams
        );
        result.put("readAverageMeasuredValueAttribute", readHydrogenConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementAverageMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readAverageMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readHydrogenConcentrationMeasurementAverageMeasuredValueWindowCommandParams
        );
        result.put("readAverageMeasuredValueWindowAttribute", readHydrogenConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementUncertaintyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementUncertaintyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readUncertaintyAttribute(
              (ChipClusters.FloatAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFloatAttributeCallback(),
          readHydrogenConcentrationMeasurementUncertaintyCommandParams
        );
        result.put("readUncertaintyAttribute", readHydrogenConcentrationMeasurementUncertaintyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementMeasurementUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementMeasurementUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readMeasurementUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHydrogenConcentrationMeasurementMeasurementUnitCommandParams
        );
        result.put("readMeasurementUnitAttribute", readHydrogenConcentrationMeasurementMeasurementUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementMeasurementMediumCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementMeasurementMediumAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readMeasurementMediumAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHydrogenConcentrationMeasurementMeasurementMediumCommandParams
        );
        result.put("readMeasurementMediumAttribute", readHydrogenConcentrationMeasurementMeasurementMediumAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementLevelValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementLevelValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readLevelValueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHydrogenConcentrationMeasurementLevelValueCommandParams
        );
        result.put("readLevelValueAttribute", readHydrogenConcentrationMeasurementLevelValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.HydrogenConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenConcentrationMeasurementClusterGeneratedCommandListAttributeCallback(),
          readHydrogenConcentrationMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readHydrogenConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.HydrogenConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenConcentrationMeasurementClusterAcceptedCommandListAttributeCallback(),
          readHydrogenConcentrationMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readHydrogenConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.HydrogenConcentrationMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenConcentrationMeasurementClusterEventListAttributeCallback(),
          readHydrogenConcentrationMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readHydrogenConcentrationMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.HydrogenConcentrationMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenConcentrationMeasurementClusterAttributeListAttributeCallback(),
          readHydrogenConcentrationMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readHydrogenConcentrationMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readHydrogenConcentrationMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readHydrogenConcentrationMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenConcentrationMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenConcentrationMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenConcentrationMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHydrogenConcentrationMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readHydrogenConcentrationMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readHydrogenSulfideConcentrationMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenSulfideConcentrationMeasurementClusterMeasuredValueAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readHydrogenSulfideConcentrationMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenSulfideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readHydrogenSulfideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenSulfideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readHydrogenSulfideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementPeakMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueAttribute(
              (ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenSulfideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementPeakMeasuredValueCommandParams
        );
        result.put("readPeakMeasuredValueAttribute", readHydrogenSulfideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementPeakMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementPeakMeasuredValueWindowCommandParams
        );
        result.put("readPeakMeasuredValueWindowAttribute", readHydrogenSulfideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementAverageMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueAttribute(
              (ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenSulfideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementAverageMeasuredValueCommandParams
        );
        result.put("readAverageMeasuredValueAttribute", readHydrogenSulfideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementAverageMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementAverageMeasuredValueWindowCommandParams
        );
        result.put("readAverageMeasuredValueWindowAttribute", readHydrogenSulfideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementUncertaintyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementUncertaintyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readUncertaintyAttribute(
              (ChipClusters.FloatAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFloatAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementUncertaintyCommandParams
        );
        result.put("readUncertaintyAttribute", readHydrogenSulfideConcentrationMeasurementUncertaintyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementMeasurementUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readMeasurementUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementMeasurementUnitCommandParams
        );
        result.put("readMeasurementUnitAttribute", readHydrogenSulfideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementMeasurementMediumCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readMeasurementMediumAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementMeasurementMediumCommandParams
        );
        result.put("readMeasurementMediumAttribute", readHydrogenSulfideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementLevelValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementLevelValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readLevelValueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementLevelValueCommandParams
        );
        result.put("readLevelValueAttribute", readHydrogenSulfideConcentrationMeasurementLevelValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenSulfideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readHydrogenSulfideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenSulfideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readHydrogenSulfideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenSulfideConcentrationMeasurementClusterEventListAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readHydrogenSulfideConcentrationMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedHydrogenSulfideConcentrationMeasurementClusterAttributeListAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readHydrogenSulfideConcentrationMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readHydrogenSulfideConcentrationMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readHydrogenSulfideConcentrationMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readHydrogenSulfideConcentrationMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.HydrogenSulfideConcentrationMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readHydrogenSulfideConcentrationMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readHydrogenSulfideConcentrationMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readNitricOxideConcentrationMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.NitricOxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitricOxideConcentrationMeasurementClusterMeasuredValueAttributeCallback(),
          readNitricOxideConcentrationMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readNitricOxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.NitricOxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitricOxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback(),
          readNitricOxideConcentrationMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readNitricOxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.NitricOxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitricOxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readNitricOxideConcentrationMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readNitricOxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementPeakMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueAttribute(
              (ChipClusters.NitricOxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitricOxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback(),
          readNitricOxideConcentrationMeasurementPeakMeasuredValueCommandParams
        );
        result.put("readPeakMeasuredValueAttribute", readNitricOxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readNitricOxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams
        );
        result.put("readPeakMeasuredValueWindowAttribute", readNitricOxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementAverageMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueAttribute(
              (ChipClusters.NitricOxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitricOxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback(),
          readNitricOxideConcentrationMeasurementAverageMeasuredValueCommandParams
        );
        result.put("readAverageMeasuredValueAttribute", readNitricOxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readNitricOxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams
        );
        result.put("readAverageMeasuredValueWindowAttribute", readNitricOxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementUncertaintyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementUncertaintyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readUncertaintyAttribute(
              (ChipClusters.FloatAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFloatAttributeCallback(),
          readNitricOxideConcentrationMeasurementUncertaintyCommandParams
        );
        result.put("readUncertaintyAttribute", readNitricOxideConcentrationMeasurementUncertaintyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementMeasurementUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readMeasurementUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNitricOxideConcentrationMeasurementMeasurementUnitCommandParams
        );
        result.put("readMeasurementUnitAttribute", readNitricOxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementMeasurementMediumCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readMeasurementMediumAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNitricOxideConcentrationMeasurementMeasurementMediumCommandParams
        );
        result.put("readMeasurementMediumAttribute", readNitricOxideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementLevelValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementLevelValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readLevelValueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNitricOxideConcentrationMeasurementLevelValueCommandParams
        );
        result.put("readLevelValueAttribute", readNitricOxideConcentrationMeasurementLevelValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.NitricOxideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitricOxideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback(),
          readNitricOxideConcentrationMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readNitricOxideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.NitricOxideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitricOxideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback(),
          readNitricOxideConcentrationMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readNitricOxideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.NitricOxideConcentrationMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitricOxideConcentrationMeasurementClusterEventListAttributeCallback(),
          readNitricOxideConcentrationMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readNitricOxideConcentrationMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.NitricOxideConcentrationMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitricOxideConcentrationMeasurementClusterAttributeListAttributeCallback(),
          readNitricOxideConcentrationMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readNitricOxideConcentrationMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readNitricOxideConcentrationMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readNitricOxideConcentrationMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitricOxideConcentrationMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitricOxideConcentrationMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitricOxideConcentrationMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNitricOxideConcentrationMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readNitricOxideConcentrationMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readNitrogenDioxideConcentrationMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitrogenDioxideConcentrationMeasurementClusterMeasuredValueAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readNitrogenDioxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitrogenDioxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readNitrogenDioxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitrogenDioxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readNitrogenDioxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementPeakMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueAttribute(
              (ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitrogenDioxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementPeakMeasuredValueCommandParams
        );
        result.put("readPeakMeasuredValueAttribute", readNitrogenDioxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams
        );
        result.put("readPeakMeasuredValueWindowAttribute", readNitrogenDioxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementAverageMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueAttribute(
              (ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitrogenDioxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementAverageMeasuredValueCommandParams
        );
        result.put("readAverageMeasuredValueAttribute", readNitrogenDioxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams
        );
        result.put("readAverageMeasuredValueWindowAttribute", readNitrogenDioxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementUncertaintyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementUncertaintyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readUncertaintyAttribute(
              (ChipClusters.FloatAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFloatAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementUncertaintyCommandParams
        );
        result.put("readUncertaintyAttribute", readNitrogenDioxideConcentrationMeasurementUncertaintyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementMeasurementUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readMeasurementUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementMeasurementUnitCommandParams
        );
        result.put("readMeasurementUnitAttribute", readNitrogenDioxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementMeasurementMediumCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readMeasurementMediumAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementMeasurementMediumCommandParams
        );
        result.put("readMeasurementMediumAttribute", readNitrogenDioxideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementLevelValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementLevelValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readLevelValueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementLevelValueCommandParams
        );
        result.put("readLevelValueAttribute", readNitrogenDioxideConcentrationMeasurementLevelValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitrogenDioxideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readNitrogenDioxideConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitrogenDioxideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readNitrogenDioxideConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitrogenDioxideConcentrationMeasurementClusterEventListAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readNitrogenDioxideConcentrationMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedNitrogenDioxideConcentrationMeasurementClusterAttributeListAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readNitrogenDioxideConcentrationMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readNitrogenDioxideConcentrationMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readNitrogenDioxideConcentrationMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readNitrogenDioxideConcentrationMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.NitrogenDioxideConcentrationMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readNitrogenDioxideConcentrationMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readNitrogenDioxideConcentrationMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readOxygenConcentrationMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.OxygenConcentrationMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOxygenConcentrationMeasurementClusterMeasuredValueAttributeCallback(),
          readOxygenConcentrationMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readOxygenConcentrationMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.OxygenConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOxygenConcentrationMeasurementClusterMinMeasuredValueAttributeCallback(),
          readOxygenConcentrationMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readOxygenConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.OxygenConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOxygenConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readOxygenConcentrationMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readOxygenConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementPeakMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readPeakMeasuredValueAttribute(
              (ChipClusters.OxygenConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOxygenConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback(),
          readOxygenConcentrationMeasurementPeakMeasuredValueCommandParams
        );
        result.put("readPeakMeasuredValueAttribute", readOxygenConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementPeakMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readPeakMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOxygenConcentrationMeasurementPeakMeasuredValueWindowCommandParams
        );
        result.put("readPeakMeasuredValueWindowAttribute", readOxygenConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementAverageMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readAverageMeasuredValueAttribute(
              (ChipClusters.OxygenConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOxygenConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback(),
          readOxygenConcentrationMeasurementAverageMeasuredValueCommandParams
        );
        result.put("readAverageMeasuredValueAttribute", readOxygenConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementAverageMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readAverageMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOxygenConcentrationMeasurementAverageMeasuredValueWindowCommandParams
        );
        result.put("readAverageMeasuredValueWindowAttribute", readOxygenConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementUncertaintyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementUncertaintyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readUncertaintyAttribute(
              (ChipClusters.FloatAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFloatAttributeCallback(),
          readOxygenConcentrationMeasurementUncertaintyCommandParams
        );
        result.put("readUncertaintyAttribute", readOxygenConcentrationMeasurementUncertaintyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementMeasurementUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementMeasurementUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readMeasurementUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOxygenConcentrationMeasurementMeasurementUnitCommandParams
        );
        result.put("readMeasurementUnitAttribute", readOxygenConcentrationMeasurementMeasurementUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementMeasurementMediumCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementMeasurementMediumAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readMeasurementMediumAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOxygenConcentrationMeasurementMeasurementMediumCommandParams
        );
        result.put("readMeasurementMediumAttribute", readOxygenConcentrationMeasurementMeasurementMediumAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementLevelValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementLevelValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readLevelValueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOxygenConcentrationMeasurementLevelValueCommandParams
        );
        result.put("readLevelValueAttribute", readOxygenConcentrationMeasurementLevelValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.OxygenConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOxygenConcentrationMeasurementClusterGeneratedCommandListAttributeCallback(),
          readOxygenConcentrationMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readOxygenConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.OxygenConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOxygenConcentrationMeasurementClusterAcceptedCommandListAttributeCallback(),
          readOxygenConcentrationMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readOxygenConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.OxygenConcentrationMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOxygenConcentrationMeasurementClusterEventListAttributeCallback(),
          readOxygenConcentrationMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readOxygenConcentrationMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.OxygenConcentrationMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOxygenConcentrationMeasurementClusterAttributeListAttributeCallback(),
          readOxygenConcentrationMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readOxygenConcentrationMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOxygenConcentrationMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readOxygenConcentrationMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOxygenConcentrationMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOxygenConcentrationMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OxygenConcentrationMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOxygenConcentrationMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readOxygenConcentrationMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readOzoneConcentrationMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.OzoneConcentrationMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneConcentrationMeasurementClusterMeasuredValueAttributeCallback(),
          readOzoneConcentrationMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readOzoneConcentrationMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.OzoneConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneConcentrationMeasurementClusterMinMeasuredValueAttributeCallback(),
          readOzoneConcentrationMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readOzoneConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.OzoneConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readOzoneConcentrationMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readOzoneConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementPeakMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readPeakMeasuredValueAttribute(
              (ChipClusters.OzoneConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback(),
          readOzoneConcentrationMeasurementPeakMeasuredValueCommandParams
        );
        result.put("readPeakMeasuredValueAttribute", readOzoneConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementPeakMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readPeakMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOzoneConcentrationMeasurementPeakMeasuredValueWindowCommandParams
        );
        result.put("readPeakMeasuredValueWindowAttribute", readOzoneConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementAverageMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readAverageMeasuredValueAttribute(
              (ChipClusters.OzoneConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback(),
          readOzoneConcentrationMeasurementAverageMeasuredValueCommandParams
        );
        result.put("readAverageMeasuredValueAttribute", readOzoneConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementAverageMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readAverageMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOzoneConcentrationMeasurementAverageMeasuredValueWindowCommandParams
        );
        result.put("readAverageMeasuredValueWindowAttribute", readOzoneConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementUncertaintyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementUncertaintyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readUncertaintyAttribute(
              (ChipClusters.FloatAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFloatAttributeCallback(),
          readOzoneConcentrationMeasurementUncertaintyCommandParams
        );
        result.put("readUncertaintyAttribute", readOzoneConcentrationMeasurementUncertaintyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementMeasurementUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementMeasurementUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readMeasurementUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOzoneConcentrationMeasurementMeasurementUnitCommandParams
        );
        result.put("readMeasurementUnitAttribute", readOzoneConcentrationMeasurementMeasurementUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementMeasurementMediumCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementMeasurementMediumAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readMeasurementMediumAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOzoneConcentrationMeasurementMeasurementMediumCommandParams
        );
        result.put("readMeasurementMediumAttribute", readOzoneConcentrationMeasurementMeasurementMediumAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementLevelValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementLevelValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readLevelValueAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOzoneConcentrationMeasurementLevelValueCommandParams
        );
        result.put("readLevelValueAttribute", readOzoneConcentrationMeasurementLevelValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementGeneratedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readGeneratedCommandListAttribute(
              (ChipClusters.OzoneConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneConcentrationMeasurementClusterGeneratedCommandListAttributeCallback(),
          readOzoneConcentrationMeasurementGeneratedCommandListCommandParams
        );
        result.put("readGeneratedCommandListAttribute", readOzoneConcentrationMeasurementGeneratedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementAcceptedCommandListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readAcceptedCommandListAttribute(
              (ChipClusters.OzoneConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneConcentrationMeasurementClusterAcceptedCommandListAttributeCallback(),
          readOzoneConcentrationMeasurementAcceptedCommandListCommandParams
        );
        result.put("readAcceptedCommandListAttribute", readOzoneConcentrationMeasurementAcceptedCommandListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementEventListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementEventListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readEventListAttribute(
              (ChipClusters.OzoneConcentrationMeasurementCluster.EventListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneConcentrationMeasurementClusterEventListAttributeCallback(),
          readOzoneConcentrationMeasurementEventListCommandParams
        );
        result.put("readEventListAttribute", readOzoneConcentrationMeasurementEventListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementAttributeListCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementAttributeListAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readAttributeListAttribute(
              (ChipClusters.OzoneConcentrationMeasurementCluster.AttributeListAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedOzoneConcentrationMeasurementClusterAttributeListAttributeCallback(),
          readOzoneConcentrationMeasurementAttributeListCommandParams
        );
        result.put("readAttributeListAttribute", readOzoneConcentrationMeasurementAttributeListAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementFeatureMapCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementFeatureMapAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readFeatureMapAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readOzoneConcentrationMeasurementFeatureMapCommandParams
        );
        result.put("readFeatureMapAttribute", readOzoneConcentrationMeasurementFeatureMapAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readOzoneConcentrationMeasurementClusterRevisionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readOzoneConcentrationMeasurementClusterRevisionAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.OzoneConcentrationMeasurementCluster) cluster).readClusterRevisionAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readOzoneConcentrationMeasurementClusterRevisionCommandParams
        );
        result.put("readClusterRevisionAttribute", readOzoneConcentrationMeasurementClusterRevisionAttributeInteractionInfo);
     
       return result;
    }
    private static Map<String, InteractionInfo> readSulfurDioxideConcentrationMeasurementInteractionInfo() {
       Map<String, InteractionInfo> result = new LinkedHashMap<>();Map<String, CommandParameterInfo> readSulfurDioxideConcentrationMeasurementMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSulfurDioxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SulfurDioxideConcentrationMeasurementCluster) cluster).readMeasuredValueAttribute(
              (ChipClusters.SulfurDioxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSulfurDioxideConcentrationMeasurementClusterMeasuredValueAttributeCallback(),
          readSulfurDioxideConcentrationMeasurementMeasuredValueCommandParams
        );
        result.put("readMeasuredValueAttribute", readSulfurDioxideConcentrationMeasurementMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSulfurDioxideConcentrationMeasurementMinMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSulfurDioxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SulfurDioxideConcentrationMeasurementCluster) cluster).readMinMeasuredValueAttribute(
              (ChipClusters.SulfurDioxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSulfurDioxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback(),
          readSulfurDioxideConcentrationMeasurementMinMeasuredValueCommandParams
        );
        result.put("readMinMeasuredValueAttribute", readSulfurDioxideConcentrationMeasurementMinMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSulfurDioxideConcentrationMeasurementMaxMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSulfurDioxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SulfurDioxideConcentrationMeasurementCluster) cluster).readMaxMeasuredValueAttribute(
              (ChipClusters.SulfurDioxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSulfurDioxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback(),
          readSulfurDioxideConcentrationMeasurementMaxMeasuredValueCommandParams
        );
        result.put("readMaxMeasuredValueAttribute", readSulfurDioxideConcentrationMeasurementMaxMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSulfurDioxideConcentrationMeasurementPeakMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSulfurDioxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SulfurDioxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueAttribute(
              (ChipClusters.SulfurDioxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSulfurDioxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback(),
          readSulfurDioxideConcentrationMeasurementPeakMeasuredValueCommandParams
        );
        result.put("readPeakMeasuredValueAttribute", readSulfurDioxideConcentrationMeasurementPeakMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSulfurDioxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSulfurDioxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SulfurDioxideConcentrationMeasurementCluster) cluster).readPeakMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readSulfurDioxideConcentrationMeasurementPeakMeasuredValueWindowCommandParams
        );
        result.put("readPeakMeasuredValueWindowAttribute", readSulfurDioxideConcentrationMeasurementPeakMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSulfurDioxideConcentrationMeasurementAverageMeasuredValueCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSulfurDioxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SulfurDioxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueAttribute(
              (ChipClusters.SulfurDioxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedSulfurDioxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback(),
          readSulfurDioxideConcentrationMeasurementAverageMeasuredValueCommandParams
        );
        result.put("readAverageMeasuredValueAttribute", readSulfurDioxideConcentrationMeasurementAverageMeasuredValueAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSulfurDioxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSulfurDioxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SulfurDioxideConcentrationMeasurementCluster) cluster).readAverageMeasuredValueWindowAttribute(
              (ChipClusters.LongAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedLongAttributeCallback(),
          readSulfurDioxideConcentrationMeasurementAverageMeasuredValueWindowCommandParams
        );
        result.put("readAverageMeasuredValueWindowAttribute", readSulfurDioxideConcentrationMeasurementAverageMeasuredValueWindowAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSulfurDioxideConcentrationMeasurementUncertaintyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSulfurDioxideConcentrationMeasurementUncertaintyAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SulfurDioxideConcentrationMeasurementCluster) cluster).readUncertaintyAttribute(
              (ChipClusters.FloatAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedFloatAttributeCallback(),
          readSulfurDioxideConcentrationMeasurementUncertaintyCommandParams
        );
        result.put("readUncertaintyAttribute", readSulfurDioxideConcentrationMeasurementUncertaintyAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSulfurDioxideConcentrationMeasurementMeasurementUnitCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSulfurDioxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SulfurDioxideConcentrationMeasurementCluster) cluster).readMeasurementUnitAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
          readSulfurDioxideConcentrationMeasurementMeasurementUnitCommandParams
        );
        result.put("readMeasurementUnitAttribute", readSulfurDioxideConcentrationMeasurementMeasurementUnitAttributeInteractionInfo);
     Map<String, CommandParameterInfo> readSulfurDioxideConcentrationMeasurementMeasurementMediumCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
        InteractionInfo readSulfurDioxideConcentrationMeasurementMeasurementMediumAttributeInteractionInfo = new InteractionInfo(
          (cluster, callback, commandArguments) -> {
            ((ChipClusters.SulfurDioxideConcentrationMeasurementCluster) cluster).readMeasurementMediumAttribute(
              (ChipClusters.IntegerAttributeCallback) callback
            );
          },
          () -> new ClusterInfoMapping.DelegatedIntegerAttributeCallback(),
     