/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP
#include "CHIPInvokeCallbacks.h"
#include <jni/CHIPCallbackTypes.h>
#include <jni/CHIPReadCallbacks.h>

#include <app-common/zap-generated/cluster-objects.h>
#include <zap-generated/CHIPClientCallbacks.h>
#include <zap-generated/CHIPClusters.h>

#include <controller/java/AndroidCallbacks.h>
#include <controller/java/AndroidClusterExceptions.h>
#include <controller/java/CHIPDefaultCallbacks.h>
#include <jni.h>
#include <lib/support/CHIPListUtils.h>
#include <lib/support/CodeUtils.h>
#include <lib/support/JniReferences.h>
#include <lib/support/JniTypeWrappers.h>
#include <lib/support/Span.h>
#include <platform/PlatformManager.h>
#include <vector>

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wshorten-64-to-32"

#define JNI_METHOD(RETURN, CLASS_NAME, METHOD_NAME)                                                                                \
    extern "C" JNIEXPORT RETURN JNICALL Java_chip_devicecontroller_ChipClusters_00024##CLASS_NAME##_##METHOD_NAME

using namespace chip;
using namespace chip::Controller;

JNI_METHOD(void, IdentifyCluster, writeIdentifyTimeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Identify::Attributes::IdentifyTime::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    IdentifyCluster * cppCluster = reinterpret_cast<IdentifyCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OnOffCluster, writeOnTimeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OnOff::Attributes::OnTime::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err            = CHIP_NO_ERROR;
    OnOffCluster * cppCluster = reinterpret_cast<OnOffCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OnOffCluster, writeOffWaitTimeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OnOff::Attributes::OffWaitTime::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err            = CHIP_NO_ERROR;
    OnOffCluster * cppCluster = reinterpret_cast<OnOffCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OnOffCluster, writeStartUpOnOffAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OnOff::Attributes::StartUpOnOff::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err            = CHIP_NO_ERROR;
    OnOffCluster * cppCluster = reinterpret_cast<OnOffCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OnOffSwitchConfigurationCluster, writeSwitchActionsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OnOffSwitchConfiguration::Attributes::SwitchActions::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                               = CHIP_NO_ERROR;
    OnOffSwitchConfigurationCluster * cppCluster = reinterpret_cast<OnOffSwitchConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, LevelControlCluster, writeOptionsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::LevelControl::Attributes::Options::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue.SetRaw(static_cast<std::remove_reference_t<decltype(cppValue)>::IntegerType>(
        chip::JniReferences::GetInstance().IntegerToPrimitive(value)));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    LevelControlCluster * cppCluster = reinterpret_cast<LevelControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, LevelControlCluster, writeOnOffTransitionTimeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::LevelControl::Attributes::OnOffTransitionTime::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    LevelControlCluster * cppCluster = reinterpret_cast<LevelControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, LevelControlCluster, writeOnLevelAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::LevelControl::Attributes::OnLevel::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    LevelControlCluster * cppCluster = reinterpret_cast<LevelControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, LevelControlCluster, writeOnTransitionTimeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::LevelControl::Attributes::OnTransitionTime::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    LevelControlCluster * cppCluster = reinterpret_cast<LevelControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, LevelControlCluster, writeOffTransitionTimeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::LevelControl::Attributes::OffTransitionTime::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    LevelControlCluster * cppCluster = reinterpret_cast<LevelControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, LevelControlCluster, writeDefaultMoveRateAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::LevelControl::Attributes::DefaultMoveRate::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    LevelControlCluster * cppCluster = reinterpret_cast<LevelControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, LevelControlCluster, writeStartUpCurrentLevelAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::LevelControl::Attributes::StartUpCurrentLevel::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    LevelControlCluster * cppCluster = reinterpret_cast<LevelControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BinaryInputBasicCluster, writeActiveTextAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BinaryInputBasic::Attributes::ActiveText::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    BinaryInputBasicCluster * cppCluster = reinterpret_cast<BinaryInputBasicCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BinaryInputBasicCluster, writeDescriptionAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BinaryInputBasic::Attributes::Description::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    BinaryInputBasicCluster * cppCluster = reinterpret_cast<BinaryInputBasicCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BinaryInputBasicCluster, writeInactiveTextAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BinaryInputBasic::Attributes::InactiveText::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    BinaryInputBasicCluster * cppCluster = reinterpret_cast<BinaryInputBasicCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BinaryInputBasicCluster, writeOutOfServiceAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BinaryInputBasic::Attributes::OutOfService::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    BinaryInputBasicCluster * cppCluster = reinterpret_cast<BinaryInputBasicCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BinaryInputBasicCluster, writePresentValueAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BinaryInputBasic::Attributes::PresentValue::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    BinaryInputBasicCluster * cppCluster = reinterpret_cast<BinaryInputBasicCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BinaryInputBasicCluster, writeReliabilityAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BinaryInputBasic::Attributes::Reliability::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    BinaryInputBasicCluster * cppCluster = reinterpret_cast<BinaryInputBasicCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BindingCluster, writeBindingAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Binding::Attributes::Binding::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                jobject element_0_nodeItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "node", "Ljava/util/Optional;", element_0_nodeItem_1);
                if (element_0_nodeItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_nodeItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].node.Emplace();
                        definedValue_2        = static_cast<std::remove_reference_t<decltype(definedValue_2)>>(
                            chip::JniReferences::GetInstance().LongToPrimitive(optionalValue_2));
                    }
                }
                jobject element_0_groupItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "group", "Ljava/util/Optional;",
                                                                  element_0_groupItem_1);
                if (element_0_groupItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_groupItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].group.Emplace();
                        definedValue_2        = static_cast<std::remove_reference_t<decltype(definedValue_2)>>(
                            chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2));
                    }
                }
                jobject element_0_endpointItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "endpoint", "Ljava/util/Optional;",
                                                                  element_0_endpointItem_1);
                if (element_0_endpointItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_endpointItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].endpoint.Emplace();
                        definedValue_2        = static_cast<std::remove_reference_t<decltype(definedValue_2)>>(
                            chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2));
                    }
                }
                jobject element_0_clusterItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "cluster", "Ljava/util/Optional;",
                                                                  element_0_clusterItem_1);
                if (element_0_clusterItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_clusterItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].cluster.Emplace();
                        definedValue_2        = static_cast<std::remove_reference_t<decltype(definedValue_2)>>(
                            chip::JniReferences::GetInstance().LongToPrimitive(optionalValue_2));
                    }
                }
                jobject element_0_fabricIndexItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "fabricIndex", "Ljava/lang/Integer;",
                                                                  element_0_fabricIndexItem_1);
                listHolder_0->mList[i_0].fabricIndex =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricIndex)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_fabricIndexItem_1));
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err              = CHIP_NO_ERROR;
    BindingCluster * cppCluster = reinterpret_cast<BindingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, AccessControlCluster, writeAclAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::AccessControl::Attributes::Acl::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                jobject element_0_privilegeItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "privilege", "Ljava/lang/Integer;",
                                                                  element_0_privilegeItem_1);
                listHolder_0->mList[i_0].privilege =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].privilege)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_privilegeItem_1));
                jobject element_0_authModeItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "authMode", "Ljava/lang/Integer;",
                                                                  element_0_authModeItem_1);
                listHolder_0->mList[i_0].authMode =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].authMode)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_authModeItem_1));
                jobject element_0_subjectsItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "subjects", "Ljava/util/ArrayList;",
                                                                  element_0_subjectsItem_1);
                if (element_0_subjectsItem_1 == nullptr)
                {
                    listHolder_0->mList[i_0].subjects.SetNull();
                }
                else
                {
                    auto & nonNullValue_2 = listHolder_0->mList[i_0].subjects.SetNonNull();
                    {
                        using ListType_3       = std::remove_reference_t<decltype(nonNullValue_2)>;
                        using ListMemberType_3 = ListMemberTypeGetter<ListType_3>::Type;
                        jint element_0_subjectsItem_1Size;
                        chip::JniReferences::GetInstance().GetListSize(element_0_subjectsItem_1, element_0_subjectsItem_1Size);
                        if (element_0_subjectsItem_1Size != 0)
                        {
                            auto * listHolder_3 = new ListHolder<ListMemberType_3>(element_0_subjectsItem_1Size);
                            listFreer.add(listHolder_3);

                            for (jint i_3 = 0; i_3 < element_0_subjectsItem_1Size; ++i_3)
                            {
                                jobject element_3;
                                chip::JniReferences::GetInstance().GetListItem(element_0_subjectsItem_1, i_3, element_3);
                                listHolder_3->mList[i_3] = static_cast<std::remove_reference_t<decltype(listHolder_3->mList[i_3])>>(
                                    chip::JniReferences::GetInstance().LongToPrimitive(element_3));
                            }
                            nonNullValue_2 = ListType_3(listHolder_3->mList, element_0_subjectsItem_1Size);
                        }
                        else
                        {
                            nonNullValue_2 = ListType_3();
                        }
                    }
                }
                jobject element_0_targetsItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "targets", "Ljava/util/ArrayList;",
                                                                  element_0_targetsItem_1);
                if (element_0_targetsItem_1 == nullptr)
                {
                    listHolder_0->mList[i_0].targets.SetNull();
                }
                else
                {
                    auto & nonNullValue_2 = listHolder_0->mList[i_0].targets.SetNonNull();
                    {
                        using ListType_3       = std::remove_reference_t<decltype(nonNullValue_2)>;
                        using ListMemberType_3 = ListMemberTypeGetter<ListType_3>::Type;
                        jint element_0_targetsItem_1Size;
                        chip::JniReferences::GetInstance().GetListSize(element_0_targetsItem_1, element_0_targetsItem_1Size);
                        if (element_0_targetsItem_1Size != 0)
                        {
                            auto * listHolder_3 = new ListHolder<ListMemberType_3>(element_0_targetsItem_1Size);
                            listFreer.add(listHolder_3);

                            for (jint i_3 = 0; i_3 < element_0_targetsItem_1Size; ++i_3)
                            {
                                jobject element_3;
                                chip::JniReferences::GetInstance().GetListItem(element_0_targetsItem_1, i_3, element_3);
                                jobject element_3_clusterItem_4;
                                chip::JniReferences::GetInstance().GetObjectField(element_3, "cluster", "Ljava/lang/Long;",
                                                                                  element_3_clusterItem_4);
                                if (element_3_clusterItem_4 == nullptr)
                                {
                                    listHolder_3->mList[i_3].cluster.SetNull();
                                }
                                else
                                {
                                    auto & nonNullValue_5 = listHolder_3->mList[i_3].cluster.SetNonNull();
                                    nonNullValue_5        = static_cast<std::remove_reference_t<decltype(nonNullValue_5)>>(
                                        chip::JniReferences::GetInstance().LongToPrimitive(element_3_clusterItem_4));
                                }
                                jobject element_3_endpointItem_4;
                                chip::JniReferences::GetInstance().GetObjectField(element_3, "endpoint", "Ljava/lang/Integer;",
                                                                                  element_3_endpointItem_4);
                                if (element_3_endpointItem_4 == nullptr)
                                {
                                    listHolder_3->mList[i_3].endpoint.SetNull();
                                }
                                else
                                {
                                    auto & nonNullValue_5 = listHolder_3->mList[i_3].endpoint.SetNonNull();
                                    nonNullValue_5        = static_cast<std::remove_reference_t<decltype(nonNullValue_5)>>(
                                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_3_endpointItem_4));
                                }
                                jobject element_3_deviceTypeItem_4;
                                chip::JniReferences::GetInstance().GetObjectField(element_3, "deviceType", "Ljava/lang/Long;",
                                                                                  element_3_deviceTypeItem_4);
                                if (element_3_deviceTypeItem_4 == nullptr)
                                {
                                    listHolder_3->mList[i_3].deviceType.SetNull();
                                }
                                else
                                {
                                    auto & nonNullValue_5 = listHolder_3->mList[i_3].deviceType.SetNonNull();
                                    nonNullValue_5        = static_cast<std::remove_reference_t<decltype(nonNullValue_5)>>(
                                        chip::JniReferences::GetInstance().LongToPrimitive(element_3_deviceTypeItem_4));
                                }
                            }
                            nonNullValue_2 = ListType_3(listHolder_3->mList, element_0_targetsItem_1Size);
                        }
                        else
                        {
                            nonNullValue_2 = ListType_3();
                        }
                    }
                }
                jobject element_0_fabricIndexItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "fabricIndex", "Ljava/lang/Integer;",
                                                                  element_0_fabricIndexItem_1);
                listHolder_0->mList[i_0].fabricIndex =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricIndex)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_fabricIndexItem_1));
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                    = CHIP_NO_ERROR;
    AccessControlCluster * cppCluster = reinterpret_cast<AccessControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, AccessControlCluster, writeExtensionAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::AccessControl::Attributes::Extension::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                jobject element_0_dataItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "data", "[B", element_0_dataItem_1);
                cleanupByteArrays.push_back(
                    chip::Platform::MakeUnique<chip::JniByteArray>(env, static_cast<jbyteArray>(element_0_dataItem_1)));
                listHolder_0->mList[i_0].data = cleanupByteArrays.back()->byteSpan();
                jobject element_0_fabricIndexItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "fabricIndex", "Ljava/lang/Integer;",
                                                                  element_0_fabricIndexItem_1);
                listHolder_0->mList[i_0].fabricIndex =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricIndex)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_fabricIndexItem_1));
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                    = CHIP_NO_ERROR;
    AccessControlCluster * cppCluster = reinterpret_cast<AccessControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BasicInformationCluster, writeNodeLabelAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BasicInformation::Attributes::NodeLabel::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    BasicInformationCluster * cppCluster = reinterpret_cast<BasicInformationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BasicInformationCluster, writeLocationAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BasicInformation::Attributes::Location::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    BasicInformationCluster * cppCluster = reinterpret_cast<BasicInformationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BasicInformationCluster, writeLocalConfigDisabledAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BasicInformation::Attributes::LocalConfigDisabled::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    BasicInformationCluster * cppCluster = reinterpret_cast<BasicInformationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OtaSoftwareUpdateRequestorCluster, writeDefaultOTAProvidersAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OtaSoftwareUpdateRequestor::Attributes::DefaultOTAProviders::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                jobject element_0_providerNodeIDItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "providerNodeID", "Ljava/lang/Long;",
                                                                  element_0_providerNodeIDItem_1);
                listHolder_0->mList[i_0].providerNodeID =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].providerNodeID)>>(
                        chip::JniReferences::GetInstance().LongToPrimitive(element_0_providerNodeIDItem_1));
                jobject element_0_endpointItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "endpoint", "Ljava/lang/Integer;",
                                                                  element_0_endpointItem_1);
                listHolder_0->mList[i_0].endpoint =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].endpoint)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_endpointItem_1));
                jobject element_0_fabricIndexItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "fabricIndex", "Ljava/lang/Integer;",
                                                                  element_0_fabricIndexItem_1);
                listHolder_0->mList[i_0].fabricIndex =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricIndex)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_fabricIndexItem_1));
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                                 = CHIP_NO_ERROR;
    OtaSoftwareUpdateRequestorCluster * cppCluster = reinterpret_cast<OtaSoftwareUpdateRequestorCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, LocalizationConfigurationCluster, writeActiveLocaleAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::LocalizationConfiguration::Attributes::ActiveLocale::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                                = CHIP_NO_ERROR;
    LocalizationConfigurationCluster * cppCluster = reinterpret_cast<LocalizationConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, TimeFormatLocalizationCluster, writeHourFormatAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::TimeFormatLocalization::Attributes::HourFormat::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                             = CHIP_NO_ERROR;
    TimeFormatLocalizationCluster * cppCluster = reinterpret_cast<TimeFormatLocalizationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, TimeFormatLocalizationCluster, writeActiveCalendarTypeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::TimeFormatLocalization::Attributes::ActiveCalendarType::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                             = CHIP_NO_ERROR;
    TimeFormatLocalizationCluster * cppCluster = reinterpret_cast<TimeFormatLocalizationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitLocalizationCluster, writeTemperatureUnitAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitLocalization::Attributes::TemperatureUnit::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    UnitLocalizationCluster * cppCluster = reinterpret_cast<UnitLocalizationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, GeneralCommissioningCluster, writeBreadcrumbAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::GeneralCommissioning::Attributes::Breadcrumb::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    GeneralCommissioningCluster * cppCluster = reinterpret_cast<GeneralCommissioningCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, NetworkCommissioningCluster, writeInterfaceEnabledAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::NetworkCommissioning::Attributes::InterfaceEnabled::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    NetworkCommissioningCluster * cppCluster = reinterpret_cast<NetworkCommissioningCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BridgedDeviceBasicInformationCluster, writeNodeLabelAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BridgedDeviceBasicInformation::Attributes::NodeLabel::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                                    = CHIP_NO_ERROR;
    BridgedDeviceBasicInformationCluster * cppCluster = reinterpret_cast<BridgedDeviceBasicInformationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, GroupKeyManagementCluster, writeGroupKeyMapAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::GroupKeyManagement::Attributes::GroupKeyMap::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                jobject element_0_groupIdItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "groupId", "Ljava/lang/Integer;",
                                                                  element_0_groupIdItem_1);
                listHolder_0->mList[i_0].groupId = static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].groupId)>>(
                    chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_groupIdItem_1));
                jobject element_0_groupKeySetIDItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "groupKeySetID", "Ljava/lang/Integer;",
                                                                  element_0_groupKeySetIDItem_1);
                listHolder_0->mList[i_0].groupKeySetID =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].groupKeySetID)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_groupKeySetIDItem_1));
                jobject element_0_fabricIndexItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "fabricIndex", "Ljava/lang/Integer;",
                                                                  element_0_fabricIndexItem_1);
                listHolder_0->mList[i_0].fabricIndex =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricIndex)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_fabricIndexItem_1));
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                         = CHIP_NO_ERROR;
    GroupKeyManagementCluster * cppCluster = reinterpret_cast<GroupKeyManagementCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UserLabelCluster, writeLabelListAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UserLabel::Attributes::LabelList::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                jobject element_0_labelItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "label", "Ljava/lang/String;", element_0_labelItem_1);
                cleanupStrings.push_back(
                    chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(element_0_labelItem_1)));
                listHolder_0->mList[i_0].label = cleanupStrings.back()->charSpan();
                jobject element_0_valueItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "value", "Ljava/lang/String;", element_0_valueItem_1);
                cleanupStrings.push_back(
                    chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(element_0_valueItem_1)));
                listHolder_0->mList[i_0].value = cleanupStrings.back()->charSpan();
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                = CHIP_NO_ERROR;
    UserLabelCluster * cppCluster = reinterpret_cast<UserLabelCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ModeSelectCluster, writeStartUpModeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ModeSelect::Attributes::StartUpMode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ModeSelectCluster * cppCluster = reinterpret_cast<ModeSelectCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ModeSelectCluster, writeOnModeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ModeSelect::Attributes::OnMode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ModeSelectCluster * cppCluster = reinterpret_cast<ModeSelectCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, RefrigeratorAlarmCluster, writeMaskAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::RefrigeratorAlarm::Attributes::Mask::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue.SetRaw(static_cast<std::remove_reference_t<decltype(cppValue)>::IntegerType>(
        chip::JniReferences::GetInstance().LongToPrimitive(value)));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                        = CHIP_NO_ERROR;
    RefrigeratorAlarmCluster * cppCluster = reinterpret_cast<RefrigeratorAlarmCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, SmokeCoAlarmCluster, writeSensitivityLevelAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::SmokeCoAlarm::Attributes::SensitivityLevel::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    SmokeCoAlarmCluster * cppCluster = reinterpret_cast<SmokeCoAlarmCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeDoorOpenEventsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::DoorOpenEvents::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeDoorClosedEventsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::DoorClosedEvents::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeOpenPeriodAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::OpenPeriod::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeLanguageAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::Language::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeLEDSettingsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::LEDSettings::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeAutoRelockTimeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::AutoRelockTime::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeSoundVolumeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::SoundVolume::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeOperatingModeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::OperatingMode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeEnableLocalProgrammingAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::EnableLocalProgramming::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeEnableOneTouchLockingAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::EnableOneTouchLocking::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeEnableInsideStatusLEDAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::EnableInsideStatusLED::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeEnablePrivacyModeButtonAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::EnablePrivacyModeButton::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeLocalProgrammingFeaturesAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::LocalProgrammingFeatures::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue.SetRaw(static_cast<std::remove_reference_t<decltype(cppValue)>::IntegerType>(
        chip::JniReferences::GetInstance().IntegerToPrimitive(value)));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeWrongCodeEntryLimitAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::WrongCodeEntryLimit::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeUserCodeTemporaryDisableTimeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::UserCodeTemporaryDisableTime::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeSendPINOverTheAirAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::SendPINOverTheAir::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeRequirePINforRemoteOperationAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::RequirePINforRemoteOperation::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, DoorLockCluster, writeExpiringUserTimeoutAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::DoorLock::Attributes::ExpiringUserTimeout::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err               = CHIP_NO_ERROR;
    DoorLockCluster * cppCluster = reinterpret_cast<DoorLockCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, WindowCoveringCluster, writeModeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::WindowCovering::Attributes::Mode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue.SetRaw(static_cast<std::remove_reference_t<decltype(cppValue)>::IntegerType>(
        chip::JniReferences::GetInstance().IntegerToPrimitive(value)));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                     = CHIP_NO_ERROR;
    WindowCoveringCluster * cppCluster = reinterpret_cast<WindowCoveringCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BarrierControlCluster, writeBarrierOpenEventsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BarrierControl::Attributes::BarrierOpenEvents::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                     = CHIP_NO_ERROR;
    BarrierControlCluster * cppCluster = reinterpret_cast<BarrierControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BarrierControlCluster, writeBarrierCloseEventsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BarrierControl::Attributes::BarrierCloseEvents::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                     = CHIP_NO_ERROR;
    BarrierControlCluster * cppCluster = reinterpret_cast<BarrierControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BarrierControlCluster, writeBarrierCommandOpenEventsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BarrierControl::Attributes::BarrierCommandOpenEvents::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                     = CHIP_NO_ERROR;
    BarrierControlCluster * cppCluster = reinterpret_cast<BarrierControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BarrierControlCluster, writeBarrierCommandCloseEventsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BarrierControl::Attributes::BarrierCommandCloseEvents::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                     = CHIP_NO_ERROR;
    BarrierControlCluster * cppCluster = reinterpret_cast<BarrierControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BarrierControlCluster, writeBarrierOpenPeriodAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BarrierControl::Attributes::BarrierOpenPeriod::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                     = CHIP_NO_ERROR;
    BarrierControlCluster * cppCluster = reinterpret_cast<BarrierControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BarrierControlCluster, writeBarrierClosePeriodAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BarrierControl::Attributes::BarrierClosePeriod::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                     = CHIP_NO_ERROR;
    BarrierControlCluster * cppCluster = reinterpret_cast<BarrierControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, PumpConfigurationAndControlCluster, writeLifetimeRunningHoursAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::PumpConfigurationAndControl::Attributes::LifetimeRunningHours::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                                  = CHIP_NO_ERROR;
    PumpConfigurationAndControlCluster * cppCluster = reinterpret_cast<PumpConfigurationAndControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, PumpConfigurationAndControlCluster, writeLifetimeEnergyConsumedAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::PumpConfigurationAndControl::Attributes::LifetimeEnergyConsumed::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                                  = CHIP_NO_ERROR;
    PumpConfigurationAndControlCluster * cppCluster = reinterpret_cast<PumpConfigurationAndControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, PumpConfigurationAndControlCluster, writeOperationModeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::PumpConfigurationAndControl::Attributes::OperationMode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                                  = CHIP_NO_ERROR;
    PumpConfigurationAndControlCluster * cppCluster = reinterpret_cast<PumpConfigurationAndControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, PumpConfigurationAndControlCluster, writeControlModeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::PumpConfigurationAndControl::Attributes::ControlMode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                                  = CHIP_NO_ERROR;
    PumpConfigurationAndControlCluster * cppCluster = reinterpret_cast<PumpConfigurationAndControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeHVACSystemTypeConfigurationAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::HVACSystemTypeConfiguration::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeLocalTemperatureCalibrationAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::LocalTemperatureCalibration::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeOccupiedCoolingSetpointAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::OccupiedCoolingSetpoint::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeOccupiedHeatingSetpointAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::OccupiedHeatingSetpoint::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeUnoccupiedCoolingSetpointAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::UnoccupiedCoolingSetpoint::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeUnoccupiedHeatingSetpointAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::UnoccupiedHeatingSetpoint::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeMinHeatSetpointLimitAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::MinHeatSetpointLimit::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeMaxHeatSetpointLimitAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::MaxHeatSetpointLimit::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeMinCoolSetpointLimitAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::MinCoolSetpointLimit::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeMaxCoolSetpointLimitAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::MaxCoolSetpointLimit::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeMinSetpointDeadBandAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::MinSetpointDeadBand::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeRemoteSensingAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::RemoteSensing::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeControlSequenceOfOperationAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::ControlSequenceOfOperation::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeSystemModeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::SystemMode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeTemperatureSetpointHoldAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::TemperatureSetpointHold::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeTemperatureSetpointHoldDurationAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::TemperatureSetpointHoldDuration::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeThermostatProgrammingOperationModeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::ThermostatProgrammingOperationMode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeOccupiedSetbackAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::OccupiedSetback::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeUnoccupiedSetbackAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::UnoccupiedSetback::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeEmergencyHeatDeltaAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::EmergencyHeatDelta::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeACTypeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::ACType::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeACCapacityAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::ACCapacity::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeACRefrigerantTypeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::ACRefrigerantType::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeACCompressorTypeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::ACCompressorType::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeACErrorCodeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::ACErrorCode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeACLouverPositionAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::ACLouverPosition::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatCluster, writeACCapacityformatAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::Thermostat::Attributes::ACCapacityformat::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    ThermostatCluster * cppCluster = reinterpret_cast<ThermostatCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, FanControlCluster, writeFanModeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::FanControl::Attributes::FanMode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    FanControlCluster * cppCluster = reinterpret_cast<FanControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, FanControlCluster, writeFanModeSequenceAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::FanControl::Attributes::FanModeSequence::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    FanControlCluster * cppCluster = reinterpret_cast<FanControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, FanControlCluster, writePercentSettingAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::FanControl::Attributes::PercentSetting::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    FanControlCluster * cppCluster = reinterpret_cast<FanControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, FanControlCluster, writeSpeedSettingAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::FanControl::Attributes::SpeedSetting::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    FanControlCluster * cppCluster = reinterpret_cast<FanControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, FanControlCluster, writeRockSettingAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::FanControl::Attributes::RockSetting::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    FanControlCluster * cppCluster = reinterpret_cast<FanControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, FanControlCluster, writeWindSettingAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::FanControl::Attributes::WindSetting::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    FanControlCluster * cppCluster = reinterpret_cast<FanControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, FanControlCluster, writeAirflowDirectionAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::FanControl::Attributes::AirflowDirection::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                 = CHIP_NO_ERROR;
    FanControlCluster * cppCluster = reinterpret_cast<FanControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatUserInterfaceConfigurationCluster, writeTemperatureDisplayModeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ThermostatUserInterfaceConfiguration::Attributes::TemperatureDisplayMode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err = CHIP_NO_ERROR;
    ThermostatUserInterfaceConfigurationCluster * cppCluster =
        reinterpret_cast<ThermostatUserInterfaceConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatUserInterfaceConfigurationCluster, writeKeypadLockoutAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ThermostatUserInterfaceConfiguration::Attributes::KeypadLockout::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err = CHIP_NO_ERROR;
    ThermostatUserInterfaceConfigurationCluster * cppCluster =
        reinterpret_cast<ThermostatUserInterfaceConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ThermostatUserInterfaceConfigurationCluster, writeScheduleProgrammingVisibilityAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ThermostatUserInterfaceConfiguration::Attributes::ScheduleProgrammingVisibility::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err = CHIP_NO_ERROR;
    ThermostatUserInterfaceConfigurationCluster * cppCluster =
        reinterpret_cast<ThermostatUserInterfaceConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeOptionsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::Options::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeWhitePointXAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::WhitePointX::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeWhitePointYAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::WhitePointY::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeColorPointRXAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::ColorPointRX::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeColorPointRYAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::ColorPointRY::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeColorPointRIntensityAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::ColorPointRIntensity::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeColorPointGXAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::ColorPointGX::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeColorPointGYAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::ColorPointGY::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeColorPointGIntensityAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::ColorPointGIntensity::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeColorPointBXAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::ColorPointBX::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeColorPointBYAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::ColorPointBY::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeColorPointBIntensityAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::ColorPointBIntensity::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ColorControlCluster, writeStartUpColorTemperatureMiredsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ColorControl::Attributes::StartUpColorTemperatureMireds::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                   = CHIP_NO_ERROR;
    ColorControlCluster * cppCluster = reinterpret_cast<ColorControlCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BallastConfigurationCluster, writeMinLevelAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BallastConfiguration::Attributes::MinLevel::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    BallastConfigurationCluster * cppCluster = reinterpret_cast<BallastConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BallastConfigurationCluster, writeMaxLevelAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BallastConfiguration::Attributes::MaxLevel::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    BallastConfigurationCluster * cppCluster = reinterpret_cast<BallastConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BallastConfigurationCluster, writeIntrinsicBallastFactorAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BallastConfiguration::Attributes::IntrinsicBallastFactor::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    BallastConfigurationCluster * cppCluster = reinterpret_cast<BallastConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BallastConfigurationCluster, writeBallastFactorAdjustmentAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BallastConfiguration::Attributes::BallastFactorAdjustment::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    BallastConfigurationCluster * cppCluster = reinterpret_cast<BallastConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BallastConfigurationCluster, writeLampTypeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BallastConfiguration::Attributes::LampType::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    BallastConfigurationCluster * cppCluster = reinterpret_cast<BallastConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BallastConfigurationCluster, writeLampManufacturerAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BallastConfiguration::Attributes::LampManufacturer::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    BallastConfigurationCluster * cppCluster = reinterpret_cast<BallastConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BallastConfigurationCluster, writeLampRatedHoursAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BallastConfiguration::Attributes::LampRatedHours::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    BallastConfigurationCluster * cppCluster = reinterpret_cast<BallastConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BallastConfigurationCluster, writeLampBurnHoursAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BallastConfiguration::Attributes::LampBurnHours::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    BallastConfigurationCluster * cppCluster = reinterpret_cast<BallastConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BallastConfigurationCluster, writeLampAlarmModeAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BallastConfiguration::Attributes::LampAlarmMode::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    BallastConfigurationCluster * cppCluster = reinterpret_cast<BallastConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, BallastConfigurationCluster, writeLampBurnHoursTripPointAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::BallastConfiguration::Attributes::LampBurnHoursTripPoint::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                           = CHIP_NO_ERROR;
    BallastConfigurationCluster * cppCluster = reinterpret_cast<BallastConfigurationCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OccupancySensingCluster, writePIROccupiedToUnoccupiedDelayAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OccupancySensing::Attributes::PIROccupiedToUnoccupiedDelay::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    OccupancySensingCluster * cppCluster = reinterpret_cast<OccupancySensingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OccupancySensingCluster, writePIRUnoccupiedToOccupiedDelayAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OccupancySensing::Attributes::PIRUnoccupiedToOccupiedDelay::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    OccupancySensingCluster * cppCluster = reinterpret_cast<OccupancySensingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OccupancySensingCluster, writePIRUnoccupiedToOccupiedThresholdAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OccupancySensing::Attributes::PIRUnoccupiedToOccupiedThreshold::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    OccupancySensingCluster * cppCluster = reinterpret_cast<OccupancySensingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OccupancySensingCluster, writeUltrasonicOccupiedToUnoccupiedDelayAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OccupancySensing::Attributes::UltrasonicOccupiedToUnoccupiedDelay::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    OccupancySensingCluster * cppCluster = reinterpret_cast<OccupancySensingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OccupancySensingCluster, writeUltrasonicUnoccupiedToOccupiedDelayAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OccupancySensing::Attributes::UltrasonicUnoccupiedToOccupiedDelay::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    OccupancySensingCluster * cppCluster = reinterpret_cast<OccupancySensingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OccupancySensingCluster, writeUltrasonicUnoccupiedToOccupiedThresholdAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OccupancySensing::Attributes::UltrasonicUnoccupiedToOccupiedThreshold::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    OccupancySensingCluster * cppCluster = reinterpret_cast<OccupancySensingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OccupancySensingCluster, writePhysicalContactOccupiedToUnoccupiedDelayAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OccupancySensing::Attributes::PhysicalContactOccupiedToUnoccupiedDelay::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    OccupancySensingCluster * cppCluster = reinterpret_cast<OccupancySensingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OccupancySensingCluster, writePhysicalContactUnoccupiedToOccupiedDelayAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OccupancySensing::Attributes::PhysicalContactUnoccupiedToOccupiedDelay::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    OccupancySensingCluster * cppCluster = reinterpret_cast<OccupancySensingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, OccupancySensingCluster, writePhysicalContactUnoccupiedToOccupiedThresholdAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::OccupancySensing::Attributes::PhysicalContactUnoccupiedToOccupiedThreshold::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                       = CHIP_NO_ERROR;
    OccupancySensingCluster * cppCluster = reinterpret_cast<OccupancySensingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ContentLauncherCluster, writeSupportedStreamingProtocolsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ContentLauncher::Attributes::SupportedStreamingProtocols::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                      = CHIP_NO_ERROR;
    ContentLauncherCluster * cppCluster = reinterpret_cast<ContentLauncherCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ElectricalMeasurementCluster, writeAverageRmsVoltageMeasurementPeriodAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ElectricalMeasurement::Attributes::AverageRmsVoltageMeasurementPeriod::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                            = CHIP_NO_ERROR;
    ElectricalMeasurementCluster * cppCluster = reinterpret_cast<ElectricalMeasurementCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ElectricalMeasurementCluster, writeAverageRmsUnderVoltageCounterAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ElectricalMeasurement::Attributes::AverageRmsUnderVoltageCounter::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                            = CHIP_NO_ERROR;
    ElectricalMeasurementCluster * cppCluster = reinterpret_cast<ElectricalMeasurementCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ElectricalMeasurementCluster, writeRmsExtremeOverVoltagePeriodAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ElectricalMeasurement::Attributes::RmsExtremeOverVoltagePeriod::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                            = CHIP_NO_ERROR;
    ElectricalMeasurementCluster * cppCluster = reinterpret_cast<ElectricalMeasurementCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ElectricalMeasurementCluster, writeRmsExtremeUnderVoltagePeriodAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ElectricalMeasurement::Attributes::RmsExtremeUnderVoltagePeriod::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                            = CHIP_NO_ERROR;
    ElectricalMeasurementCluster * cppCluster = reinterpret_cast<ElectricalMeasurementCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ElectricalMeasurementCluster, writeRmsVoltageSagPeriodAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ElectricalMeasurement::Attributes::RmsVoltageSagPeriod::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                            = CHIP_NO_ERROR;
    ElectricalMeasurementCluster * cppCluster = reinterpret_cast<ElectricalMeasurementCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ElectricalMeasurementCluster, writeRmsVoltageSwellPeriodAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ElectricalMeasurement::Attributes::RmsVoltageSwellPeriod::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                            = CHIP_NO_ERROR;
    ElectricalMeasurementCluster * cppCluster = reinterpret_cast<ElectricalMeasurementCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ElectricalMeasurementCluster, writeOverloadAlarmsMaskAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ElectricalMeasurement::Attributes::OverloadAlarmsMask::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                            = CHIP_NO_ERROR;
    ElectricalMeasurementCluster * cppCluster = reinterpret_cast<ElectricalMeasurementCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, ElectricalMeasurementCluster, writeAcOverloadAlarmsMaskAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::ElectricalMeasurement::Attributes::AcOverloadAlarmsMask::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                            = CHIP_NO_ERROR;
    ElectricalMeasurementCluster * cppCluster = reinterpret_cast<ElectricalMeasurementCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeBooleanAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Boolean::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeBitmap8Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Bitmap8::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue.SetRaw(static_cast<std::remove_reference_t<decltype(cppValue)>::IntegerType>(
        chip::JniReferences::GetInstance().IntegerToPrimitive(value)));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeBitmap16Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Bitmap16::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue.SetRaw(static_cast<std::remove_reference_t<decltype(cppValue)>::IntegerType>(
        chip::JniReferences::GetInstance().IntegerToPrimitive(value)));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeBitmap32Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Bitmap32::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue.SetRaw(static_cast<std::remove_reference_t<decltype(cppValue)>::IntegerType>(
        chip::JniReferences::GetInstance().LongToPrimitive(value)));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeBitmap64Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Bitmap64::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue.SetRaw(static_cast<std::remove_reference_t<decltype(cppValue)>::IntegerType>(
        chip::JniReferences::GetInstance().LongToPrimitive(value)));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt8uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int8u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt16uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int16u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt24uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int24u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt32uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int32u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt40uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int40u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt48uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int48u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt56uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int56u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt64uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int64u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt8sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int8s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt16sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int16s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt24sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int24s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt32sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int32s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt40sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int40s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt48sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int48s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt56sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int56s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeInt64sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Int64s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeEnum8Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Enum8::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeEnum16Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Enum16::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeFloatSingleAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::FloatSingle::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().FloatToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeFloatDoubleAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::FloatDouble::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().DoubleToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeOctetStringAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jbyteArray value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::OctetString::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupByteArrays.push_back(chip::Platform::MakeUnique<chip::JniByteArray>(env, static_cast<jbyteArray>(value)));
    cppValue = cleanupByteArrays.back()->byteSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeListInt8uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::ListInt8u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                listHolder_0->mList[i_0] = static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0])>>(
                    chip::JniReferences::GetInstance().IntegerToPrimitive(element_0));
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeListOctetStringAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jbyteArray value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::ListOctetString::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                cleanupByteArrays.push_back(
                    chip::Platform::MakeUnique<chip::JniByteArray>(env, static_cast<jbyteArray>(element_0)));
                listHolder_0->mList[i_0] = cleanupByteArrays.back()->byteSpan();
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeListStructOctetStringAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::ListStructOctetString::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                jobject element_0_member1Item_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "member1", "Ljava/lang/Long;",
                                                                  element_0_member1Item_1);
                listHolder_0->mList[i_0].member1 = static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].member1)>>(
                    chip::JniReferences::GetInstance().LongToPrimitive(element_0_member1Item_1));
                jobject element_0_member2Item_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "member2", "[B", element_0_member2Item_1);
                cleanupByteArrays.push_back(
                    chip::Platform::MakeUnique<chip::JniByteArray>(env, static_cast<jbyteArray>(element_0_member2Item_1)));
                listHolder_0->mList[i_0].member2 = cleanupByteArrays.back()->byteSpan();
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeLongOctetStringAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jbyteArray value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::LongOctetString::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupByteArrays.push_back(chip::Platform::MakeUnique<chip::JniByteArray>(env, static_cast<jbyteArray>(value)));
    cppValue = cleanupByteArrays.back()->byteSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeCharStringAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::CharString::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeLongCharStringAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::LongCharString::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
    cppValue = cleanupStrings.back()->charSpan();

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeEpochUsAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::EpochUs::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeEpochSAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::EpochS::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue = static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().LongToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeVendorIdAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::VendorId::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeListNullablesAndOptionalsStructAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::ListNullablesAndOptionalsStruct::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                jobject element_0_nullableIntItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "nullableInt", "Ljava/lang/Integer;",
                                                                  element_0_nullableIntItem_1);
                if (element_0_nullableIntItem_1 == nullptr)
                {
                    listHolder_0->mList[i_0].nullableInt.SetNull();
                }
                else
                {
                    auto & nonNullValue_2 = listHolder_0->mList[i_0].nullableInt.SetNonNull();
                    nonNullValue_2        = static_cast<std::remove_reference_t<decltype(nonNullValue_2)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_nullableIntItem_1));
                }
                jobject element_0_optionalIntItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "optionalInt", "Ljava/util/Optional;",
                                                                  element_0_optionalIntItem_1);
                if (element_0_optionalIntItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_optionalIntItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].optionalInt.Emplace();
                        definedValue_2        = static_cast<std::remove_reference_t<decltype(definedValue_2)>>(
                            chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2));
                    }
                }
                jobject element_0_nullableOptionalIntItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "nullableOptionalInt", "Ljava/util/Optional;",
                                                                  element_0_nullableOptionalIntItem_1);
                if (element_0_nullableOptionalIntItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_nullableOptionalIntItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].nullableOptionalInt.Emplace();
                        if (optionalValue_2 == nullptr)
                        {
                            definedValue_2.SetNull();
                        }
                        else
                        {
                            auto & nonNullValue_3 = definedValue_2.SetNonNull();
                            nonNullValue_3        = static_cast<std::remove_reference_t<decltype(nonNullValue_3)>>(
                                chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2));
                        }
                    }
                }
                jobject element_0_nullableStringItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "nullableString", "Ljava/lang/String;",
                                                                  element_0_nullableStringItem_1);
                if (element_0_nullableStringItem_1 == nullptr)
                {
                    listHolder_0->mList[i_0].nullableString.SetNull();
                }
                else
                {
                    auto & nonNullValue_2 = listHolder_0->mList[i_0].nullableString.SetNonNull();
                    cleanupStrings.push_back(
                        chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(element_0_nullableStringItem_1)));
                    nonNullValue_2 = cleanupStrings.back()->charSpan();
                }
                jobject element_0_optionalStringItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "optionalString", "Ljava/util/Optional;",
                                                                  element_0_optionalStringItem_1);
                if (element_0_optionalStringItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_optionalStringItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].optionalString.Emplace();
                        cleanupStrings.push_back(
                            chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(optionalValue_2)));
                        definedValue_2 = cleanupStrings.back()->charSpan();
                    }
                }
                jobject element_0_nullableOptionalStringItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "nullableOptionalString", "Ljava/util/Optional;",
                                                                  element_0_nullableOptionalStringItem_1);
                if (element_0_nullableOptionalStringItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_nullableOptionalStringItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].nullableOptionalString.Emplace();
                        if (optionalValue_2 == nullptr)
                        {
                            definedValue_2.SetNull();
                        }
                        else
                        {
                            auto & nonNullValue_3 = definedValue_2.SetNonNull();
                            cleanupStrings.push_back(
                                chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(optionalValue_2)));
                            nonNullValue_3 = cleanupStrings.back()->charSpan();
                        }
                    }
                }
                jobject element_0_nullableStructItem_1;
                chip::JniReferences::GetInstance().GetObjectField(
                    element_0, "nullableStruct", "Lchip/devicecontroller/ChipStructs$UnitTestingClusterSimpleStruct;",
                    element_0_nullableStructItem_1);
                if (element_0_nullableStructItem_1 == nullptr)
                {
                    listHolder_0->mList[i_0].nullableStruct.SetNull();
                }
                else
                {
                    auto & nonNullValue_2 = listHolder_0->mList[i_0].nullableStruct.SetNonNull();
                    jobject element_0_nullableStructItem_1_aItem_3;
                    chip::JniReferences::GetInstance().GetObjectField(element_0_nullableStructItem_1, "a", "Ljava/lang/Integer;",
                                                                      element_0_nullableStructItem_1_aItem_3);
                    nonNullValue_2.a = static_cast<std::remove_reference_t<decltype(nonNullValue_2.a)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_nullableStructItem_1_aItem_3));
                    jobject element_0_nullableStructItem_1_bItem_3;
                    chip::JniReferences::GetInstance().GetObjectField(element_0_nullableStructItem_1, "b", "Ljava/lang/Boolean;",
                                                                      element_0_nullableStructItem_1_bItem_3);
                    nonNullValue_2.b = static_cast<std::remove_reference_t<decltype(nonNullValue_2.b)>>(
                        chip::JniReferences::GetInstance().BooleanToPrimitive(element_0_nullableStructItem_1_bItem_3));
                    jobject element_0_nullableStructItem_1_cItem_3;
                    chip::JniReferences::GetInstance().GetObjectField(element_0_nullableStructItem_1, "c", "Ljava/lang/Integer;",
                                                                      element_0_nullableStructItem_1_cItem_3);
                    nonNullValue_2.c = static_cast<std::remove_reference_t<decltype(nonNullValue_2.c)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_nullableStructItem_1_cItem_3));
                    jobject element_0_nullableStructItem_1_dItem_3;
                    chip::JniReferences::GetInstance().GetObjectField(element_0_nullableStructItem_1, "d", "[B",
                                                                      element_0_nullableStructItem_1_dItem_3);
                    cleanupByteArrays.push_back(chip::Platform::MakeUnique<chip::JniByteArray>(
                        env, static_cast<jbyteArray>(element_0_nullableStructItem_1_dItem_3)));
                    nonNullValue_2.d = cleanupByteArrays.back()->byteSpan();
                    jobject element_0_nullableStructItem_1_eItem_3;
                    chip::JniReferences::GetInstance().GetObjectField(element_0_nullableStructItem_1, "e", "Ljava/lang/String;",
                                                                      element_0_nullableStructItem_1_eItem_3);
                    cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(
                        env, static_cast<jstring>(element_0_nullableStructItem_1_eItem_3)));
                    nonNullValue_2.e = cleanupStrings.back()->charSpan();
                    jobject element_0_nullableStructItem_1_fItem_3;
                    chip::JniReferences::GetInstance().GetObjectField(element_0_nullableStructItem_1, "f", "Ljava/lang/Integer;",
                                                                      element_0_nullableStructItem_1_fItem_3);
                    nonNullValue_2.f.SetRaw(static_cast<std::remove_reference_t<decltype(nonNullValue_2.f)>::IntegerType>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_nullableStructItem_1_fItem_3)));
                    jobject element_0_nullableStructItem_1_gItem_3;
                    chip::JniReferences::GetInstance().GetObjectField(element_0_nullableStructItem_1, "g", "Ljava/lang/Float;",
                                                                      element_0_nullableStructItem_1_gItem_3);
                    nonNullValue_2.g = static_cast<std::remove_reference_t<decltype(nonNullValue_2.g)>>(
                        chip::JniReferences::GetInstance().FloatToPrimitive(element_0_nullableStructItem_1_gItem_3));
                    jobject element_0_nullableStructItem_1_hItem_3;
                    chip::JniReferences::GetInstance().GetObjectField(element_0_nullableStructItem_1, "h", "Ljava/lang/Double;",
                                                                      element_0_nullableStructItem_1_hItem_3);
                    nonNullValue_2.h = static_cast<std::remove_reference_t<decltype(nonNullValue_2.h)>>(
                        chip::JniReferences::GetInstance().DoubleToPrimitive(element_0_nullableStructItem_1_hItem_3));
                }
                jobject element_0_optionalStructItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "optionalStruct", "Ljava/util/Optional;",
                                                                  element_0_optionalStructItem_1);
                if (element_0_optionalStructItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_optionalStructItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].optionalStruct.Emplace();
                        jobject optionalValue_2_aItem_3;
                        chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "a", "Ljava/lang/Integer;",
                                                                          optionalValue_2_aItem_3);
                        definedValue_2.a = static_cast<std::remove_reference_t<decltype(definedValue_2.a)>>(
                            chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2_aItem_3));
                        jobject optionalValue_2_bItem_3;
                        chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "b", "Ljava/lang/Boolean;",
                                                                          optionalValue_2_bItem_3);
                        definedValue_2.b = static_cast<std::remove_reference_t<decltype(definedValue_2.b)>>(
                            chip::JniReferences::GetInstance().BooleanToPrimitive(optionalValue_2_bItem_3));
                        jobject optionalValue_2_cItem_3;
                        chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "c", "Ljava/lang/Integer;",
                                                                          optionalValue_2_cItem_3);
                        definedValue_2.c = static_cast<std::remove_reference_t<decltype(definedValue_2.c)>>(
                            chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2_cItem_3));
                        jobject optionalValue_2_dItem_3;
                        chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "d", "[B", optionalValue_2_dItem_3);
                        cleanupByteArrays.push_back(
                            chip::Platform::MakeUnique<chip::JniByteArray>(env, static_cast<jbyteArray>(optionalValue_2_dItem_3)));
                        definedValue_2.d = cleanupByteArrays.back()->byteSpan();
                        jobject optionalValue_2_eItem_3;
                        chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "e", "Ljava/lang/String;",
                                                                          optionalValue_2_eItem_3);
                        cleanupStrings.push_back(
                            chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(optionalValue_2_eItem_3)));
                        definedValue_2.e = cleanupStrings.back()->charSpan();
                        jobject optionalValue_2_fItem_3;
                        chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "f", "Ljava/lang/Integer;",
                                                                          optionalValue_2_fItem_3);
                        definedValue_2.f.SetRaw(static_cast<std::remove_reference_t<decltype(definedValue_2.f)>::IntegerType>(
                            chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2_fItem_3)));
                        jobject optionalValue_2_gItem_3;
                        chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "g", "Ljava/lang/Float;",
                                                                          optionalValue_2_gItem_3);
                        definedValue_2.g = static_cast<std::remove_reference_t<decltype(definedValue_2.g)>>(
                            chip::JniReferences::GetInstance().FloatToPrimitive(optionalValue_2_gItem_3));
                        jobject optionalValue_2_hItem_3;
                        chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "h", "Ljava/lang/Double;",
                                                                          optionalValue_2_hItem_3);
                        definedValue_2.h = static_cast<std::remove_reference_t<decltype(definedValue_2.h)>>(
                            chip::JniReferences::GetInstance().DoubleToPrimitive(optionalValue_2_hItem_3));
                    }
                }
                jobject element_0_nullableOptionalStructItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "nullableOptionalStruct", "Ljava/util/Optional;",
                                                                  element_0_nullableOptionalStructItem_1);
                if (element_0_nullableOptionalStructItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_nullableOptionalStructItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].nullableOptionalStruct.Emplace();
                        if (optionalValue_2 == nullptr)
                        {
                            definedValue_2.SetNull();
                        }
                        else
                        {
                            auto & nonNullValue_3 = definedValue_2.SetNonNull();
                            jobject optionalValue_2_aItem_4;
                            chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "a", "Ljava/lang/Integer;",
                                                                              optionalValue_2_aItem_4);
                            nonNullValue_3.a = static_cast<std::remove_reference_t<decltype(nonNullValue_3.a)>>(
                                chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2_aItem_4));
                            jobject optionalValue_2_bItem_4;
                            chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "b", "Ljava/lang/Boolean;",
                                                                              optionalValue_2_bItem_4);
                            nonNullValue_3.b = static_cast<std::remove_reference_t<decltype(nonNullValue_3.b)>>(
                                chip::JniReferences::GetInstance().BooleanToPrimitive(optionalValue_2_bItem_4));
                            jobject optionalValue_2_cItem_4;
                            chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "c", "Ljava/lang/Integer;",
                                                                              optionalValue_2_cItem_4);
                            nonNullValue_3.c = static_cast<std::remove_reference_t<decltype(nonNullValue_3.c)>>(
                                chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2_cItem_4));
                            jobject optionalValue_2_dItem_4;
                            chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "d", "[B", optionalValue_2_dItem_4);
                            cleanupByteArrays.push_back(chip::Platform::MakeUnique<chip::JniByteArray>(
                                env, static_cast<jbyteArray>(optionalValue_2_dItem_4)));
                            nonNullValue_3.d = cleanupByteArrays.back()->byteSpan();
                            jobject optionalValue_2_eItem_4;
                            chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "e", "Ljava/lang/String;",
                                                                              optionalValue_2_eItem_4);
                            cleanupStrings.push_back(
                                chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(optionalValue_2_eItem_4)));
                            nonNullValue_3.e = cleanupStrings.back()->charSpan();
                            jobject optionalValue_2_fItem_4;
                            chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "f", "Ljava/lang/Integer;",
                                                                              optionalValue_2_fItem_4);
                            nonNullValue_3.f.SetRaw(static_cast<std::remove_reference_t<decltype(nonNullValue_3.f)>::IntegerType>(
                                chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2_fItem_4)));
                            jobject optionalValue_2_gItem_4;
                            chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "g", "Ljava/lang/Float;",
                                                                              optionalValue_2_gItem_4);
                            nonNullValue_3.g = static_cast<std::remove_reference_t<decltype(nonNullValue_3.g)>>(
                                chip::JniReferences::GetInstance().FloatToPrimitive(optionalValue_2_gItem_4));
                            jobject optionalValue_2_hItem_4;
                            chip::JniReferences::GetInstance().GetObjectField(optionalValue_2, "h", "Ljava/lang/Double;",
                                                                              optionalValue_2_hItem_4);
                            nonNullValue_3.h = static_cast<std::remove_reference_t<decltype(nonNullValue_3.h)>>(
                                chip::JniReferences::GetInstance().DoubleToPrimitive(optionalValue_2_hItem_4));
                        }
                    }
                }
                jobject element_0_nullableListItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "nullableList", "Ljava/util/ArrayList;",
                                                                  element_0_nullableListItem_1);
                if (element_0_nullableListItem_1 == nullptr)
                {
                    listHolder_0->mList[i_0].nullableList.SetNull();
                }
                else
                {
                    auto & nonNullValue_2 = listHolder_0->mList[i_0].nullableList.SetNonNull();
                    {
                        using ListType_3       = std::remove_reference_t<decltype(nonNullValue_2)>;
                        using ListMemberType_3 = ListMemberTypeGetter<ListType_3>::Type;
                        jint element_0_nullableListItem_1Size;
                        chip::JniReferences::GetInstance().GetListSize(element_0_nullableListItem_1,
                                                                       element_0_nullableListItem_1Size);
                        if (element_0_nullableListItem_1Size != 0)
                        {
                            auto * listHolder_3 = new ListHolder<ListMemberType_3>(element_0_nullableListItem_1Size);
                            listFreer.add(listHolder_3);

                            for (jint i_3 = 0; i_3 < element_0_nullableListItem_1Size; ++i_3)
                            {
                                jobject element_3;
                                chip::JniReferences::GetInstance().GetListItem(element_0_nullableListItem_1, i_3, element_3);
                                listHolder_3->mList[i_3] = static_cast<std::remove_reference_t<decltype(listHolder_3->mList[i_3])>>(
                                    chip::JniReferences::GetInstance().IntegerToPrimitive(element_3));
                            }
                            nonNullValue_2 = ListType_3(listHolder_3->mList, element_0_nullableListItem_1Size);
                        }
                        else
                        {
                            nonNullValue_2 = ListType_3();
                        }
                    }
                }
                jobject element_0_optionalListItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "optionalList", "Ljava/util/Optional;",
                                                                  element_0_optionalListItem_1);
                if (element_0_optionalListItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_optionalListItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].optionalList.Emplace();
                        {
                            using ListType_3       = std::remove_reference_t<decltype(definedValue_2)>;
                            using ListMemberType_3 = ListMemberTypeGetter<ListType_3>::Type;
                            jint optionalValue_2Size;
                            chip::JniReferences::GetInstance().GetListSize(optionalValue_2, optionalValue_2Size);
                            if (optionalValue_2Size != 0)
                            {
                                auto * listHolder_3 = new ListHolder<ListMemberType_3>(optionalValue_2Size);
                                listFreer.add(listHolder_3);

                                for (jint i_3 = 0; i_3 < optionalValue_2Size; ++i_3)
                                {
                                    jobject element_3;
                                    chip::JniReferences::GetInstance().GetListItem(optionalValue_2, i_3, element_3);
                                    listHolder_3->mList[i_3] =
                                        static_cast<std::remove_reference_t<decltype(listHolder_3->mList[i_3])>>(
                                            chip::JniReferences::GetInstance().IntegerToPrimitive(element_3));
                                }
                                definedValue_2 = ListType_3(listHolder_3->mList, optionalValue_2Size);
                            }
                            else
                            {
                                definedValue_2 = ListType_3();
                            }
                        }
                    }
                }
                jobject element_0_nullableOptionalListItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "nullableOptionalList", "Ljava/util/Optional;",
                                                                  element_0_nullableOptionalListItem_1);
                if (element_0_nullableOptionalListItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_nullableOptionalListItem_1, optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].nullableOptionalList.Emplace();
                        if (optionalValue_2 == nullptr)
                        {
                            definedValue_2.SetNull();
                        }
                        else
                        {
                            auto & nonNullValue_3 = definedValue_2.SetNonNull();
                            {
                                using ListType_4       = std::remove_reference_t<decltype(nonNullValue_3)>;
                                using ListMemberType_4 = ListMemberTypeGetter<ListType_4>::Type;
                                jint optionalValue_2Size;
                                chip::JniReferences::GetInstance().GetListSize(optionalValue_2, optionalValue_2Size);
                                if (optionalValue_2Size != 0)
                                {
                                    auto * listHolder_4 = new ListHolder<ListMemberType_4>(optionalValue_2Size);
                                    listFreer.add(listHolder_4);

                                    for (jint i_4 = 0; i_4 < optionalValue_2Size; ++i_4)
                                    {
                                        jobject element_4;
                                        chip::JniReferences::GetInstance().GetListItem(optionalValue_2, i_4, element_4);
                                        listHolder_4->mList[i_4] =
                                            static_cast<std::remove_reference_t<decltype(listHolder_4->mList[i_4])>>(
                                                chip::JniReferences::GetInstance().IntegerToPrimitive(element_4));
                                    }
                                    nonNullValue_3 = ListType_4(listHolder_4->mList, optionalValue_2Size);
                                }
                                else
                                {
                                    nonNullValue_3 = ListType_4();
                                }
                            }
                        }
                    }
                }
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeEnumAttrAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::EnumAttr::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeRangeRestrictedInt8uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::RangeRestrictedInt8u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeRangeRestrictedInt8sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::RangeRestrictedInt8s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeRangeRestrictedInt16uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::RangeRestrictedInt16u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeRangeRestrictedInt16sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::RangeRestrictedInt16s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeListLongOctetStringAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jbyteArray value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::ListLongOctetString::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                cleanupByteArrays.push_back(
                    chip::Platform::MakeUnique<chip::JniByteArray>(env, static_cast<jbyteArray>(element_0)));
                listHolder_0->mList[i_0] = cleanupByteArrays.back()->byteSpan();
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeListFabricScopedAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::ListFabricScoped::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    {
        using ListType_0       = std::remove_reference_t<decltype(cppValue)>;
        using ListMemberType_0 = ListMemberTypeGetter<ListType_0>::Type;
        jint valueSize;
        chip::JniReferences::GetInstance().GetListSize(value, valueSize);
        if (valueSize != 0)
        {
            auto * listHolder_0 = new ListHolder<ListMemberType_0>(valueSize);
            listFreer.add(listHolder_0);

            for (jint i_0 = 0; i_0 < valueSize; ++i_0)
            {
                jobject element_0;
                chip::JniReferences::GetInstance().GetListItem(value, i_0, element_0);
                jobject element_0_fabricSensitiveInt8uItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "fabricSensitiveInt8u", "Ljava/lang/Integer;",
                                                                  element_0_fabricSensitiveInt8uItem_1);
                listHolder_0->mList[i_0].fabricSensitiveInt8u =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricSensitiveInt8u)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_fabricSensitiveInt8uItem_1));
                jobject element_0_optionalFabricSensitiveInt8uItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "optionalFabricSensitiveInt8u", "Ljava/util/Optional;",
                                                                  element_0_optionalFabricSensitiveInt8uItem_1);
                if (element_0_optionalFabricSensitiveInt8uItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_optionalFabricSensitiveInt8uItem_1,
                                                                        optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].optionalFabricSensitiveInt8u.Emplace();
                        definedValue_2        = static_cast<std::remove_reference_t<decltype(definedValue_2)>>(
                            chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2));
                    }
                }
                jobject element_0_nullableFabricSensitiveInt8uItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "nullableFabricSensitiveInt8u", "Ljava/lang/Integer;",
                                                                  element_0_nullableFabricSensitiveInt8uItem_1);
                if (element_0_nullableFabricSensitiveInt8uItem_1 == nullptr)
                {
                    listHolder_0->mList[i_0].nullableFabricSensitiveInt8u.SetNull();
                }
                else
                {
                    auto & nonNullValue_2 = listHolder_0->mList[i_0].nullableFabricSensitiveInt8u.SetNonNull();
                    nonNullValue_2        = static_cast<std::remove_reference_t<decltype(nonNullValue_2)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_nullableFabricSensitiveInt8uItem_1));
                }
                jobject element_0_nullableOptionalFabricSensitiveInt8uItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "nullableOptionalFabricSensitiveInt8u",
                                                                  "Ljava/util/Optional;",
                                                                  element_0_nullableOptionalFabricSensitiveInt8uItem_1);
                if (element_0_nullableOptionalFabricSensitiveInt8uItem_1 != nullptr)
                {
                    jobject optionalValue_2;
                    chip::JniReferences::GetInstance().GetOptionalValue(element_0_nullableOptionalFabricSensitiveInt8uItem_1,
                                                                        optionalValue_2);
                    if (optionalValue_2 != nullptr)
                    {
                        auto & definedValue_2 = listHolder_0->mList[i_0].nullableOptionalFabricSensitiveInt8u.Emplace();
                        if (optionalValue_2 == nullptr)
                        {
                            definedValue_2.SetNull();
                        }
                        else
                        {
                            auto & nonNullValue_3 = definedValue_2.SetNonNull();
                            nonNullValue_3        = static_cast<std::remove_reference_t<decltype(nonNullValue_3)>>(
                                chip::JniReferences::GetInstance().IntegerToPrimitive(optionalValue_2));
                        }
                    }
                }
                jobject element_0_fabricSensitiveCharStringItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "fabricSensitiveCharString", "Ljava/lang/String;",
                                                                  element_0_fabricSensitiveCharStringItem_1);
                cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(
                    env, static_cast<jstring>(element_0_fabricSensitiveCharStringItem_1)));
                listHolder_0->mList[i_0].fabricSensitiveCharString = cleanupStrings.back()->charSpan();
                jobject element_0_fabricSensitiveStructItem_1;
                chip::JniReferences::GetInstance().GetObjectField(
                    element_0, "fabricSensitiveStruct", "Lchip/devicecontroller/ChipStructs$UnitTestingClusterSimpleStruct;",
                    element_0_fabricSensitiveStructItem_1);
                jobject element_0_fabricSensitiveStructItem_1_aItem_2;
                chip::JniReferences::GetInstance().GetObjectField(element_0_fabricSensitiveStructItem_1, "a", "Ljava/lang/Integer;",
                                                                  element_0_fabricSensitiveStructItem_1_aItem_2);
                listHolder_0->mList[i_0].fabricSensitiveStruct.a =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricSensitiveStruct.a)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_fabricSensitiveStructItem_1_aItem_2));
                jobject element_0_fabricSensitiveStructItem_1_bItem_2;
                chip::JniReferences::GetInstance().GetObjectField(element_0_fabricSensitiveStructItem_1, "b", "Ljava/lang/Boolean;",
                                                                  element_0_fabricSensitiveStructItem_1_bItem_2);
                listHolder_0->mList[i_0].fabricSensitiveStruct.b =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricSensitiveStruct.b)>>(
                        chip::JniReferences::GetInstance().BooleanToPrimitive(element_0_fabricSensitiveStructItem_1_bItem_2));
                jobject element_0_fabricSensitiveStructItem_1_cItem_2;
                chip::JniReferences::GetInstance().GetObjectField(element_0_fabricSensitiveStructItem_1, "c", "Ljava/lang/Integer;",
                                                                  element_0_fabricSensitiveStructItem_1_cItem_2);
                listHolder_0->mList[i_0].fabricSensitiveStruct.c =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricSensitiveStruct.c)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_fabricSensitiveStructItem_1_cItem_2));
                jobject element_0_fabricSensitiveStructItem_1_dItem_2;
                chip::JniReferences::GetInstance().GetObjectField(element_0_fabricSensitiveStructItem_1, "d", "[B",
                                                                  element_0_fabricSensitiveStructItem_1_dItem_2);
                cleanupByteArrays.push_back(chip::Platform::MakeUnique<chip::JniByteArray>(
                    env, static_cast<jbyteArray>(element_0_fabricSensitiveStructItem_1_dItem_2)));
                listHolder_0->mList[i_0].fabricSensitiveStruct.d = cleanupByteArrays.back()->byteSpan();
                jobject element_0_fabricSensitiveStructItem_1_eItem_2;
                chip::JniReferences::GetInstance().GetObjectField(element_0_fabricSensitiveStructItem_1, "e", "Ljava/lang/String;",
                                                                  element_0_fabricSensitiveStructItem_1_eItem_2);
                cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(
                    env, static_cast<jstring>(element_0_fabricSensitiveStructItem_1_eItem_2)));
                listHolder_0->mList[i_0].fabricSensitiveStruct.e = cleanupStrings.back()->charSpan();
                jobject element_0_fabricSensitiveStructItem_1_fItem_2;
                chip::JniReferences::GetInstance().GetObjectField(element_0_fabricSensitiveStructItem_1, "f", "Ljava/lang/Integer;",
                                                                  element_0_fabricSensitiveStructItem_1_fItem_2);
                listHolder_0->mList[i_0].fabricSensitiveStruct.f.SetRaw(
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricSensitiveStruct.f)>::IntegerType>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_fabricSensitiveStructItem_1_fItem_2)));
                jobject element_0_fabricSensitiveStructItem_1_gItem_2;
                chip::JniReferences::GetInstance().GetObjectField(element_0_fabricSensitiveStructItem_1, "g", "Ljava/lang/Float;",
                                                                  element_0_fabricSensitiveStructItem_1_gItem_2);
                listHolder_0->mList[i_0].fabricSensitiveStruct.g =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricSensitiveStruct.g)>>(
                        chip::JniReferences::GetInstance().FloatToPrimitive(element_0_fabricSensitiveStructItem_1_gItem_2));
                jobject element_0_fabricSensitiveStructItem_1_hItem_2;
                chip::JniReferences::GetInstance().GetObjectField(element_0_fabricSensitiveStructItem_1, "h", "Ljava/lang/Double;",
                                                                  element_0_fabricSensitiveStructItem_1_hItem_2);
                listHolder_0->mList[i_0].fabricSensitiveStruct.h =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricSensitiveStruct.h)>>(
                        chip::JniReferences::GetInstance().DoubleToPrimitive(element_0_fabricSensitiveStructItem_1_hItem_2));
                jobject element_0_fabricSensitiveInt8uListItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "fabricSensitiveInt8uList", "Ljava/util/ArrayList;",
                                                                  element_0_fabricSensitiveInt8uListItem_1);
                {
                    using ListType_2       = std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricSensitiveInt8uList)>;
                    using ListMemberType_2 = ListMemberTypeGetter<ListType_2>::Type;
                    jint element_0_fabricSensitiveInt8uListItem_1Size;
                    chip::JniReferences::GetInstance().GetListSize(element_0_fabricSensitiveInt8uListItem_1,
                                                                   element_0_fabricSensitiveInt8uListItem_1Size);
                    if (element_0_fabricSensitiveInt8uListItem_1Size != 0)
                    {
                        auto * listHolder_2 = new ListHolder<ListMemberType_2>(element_0_fabricSensitiveInt8uListItem_1Size);
                        listFreer.add(listHolder_2);

                        for (jint i_2 = 0; i_2 < element_0_fabricSensitiveInt8uListItem_1Size; ++i_2)
                        {
                            jobject element_2;
                            chip::JniReferences::GetInstance().GetListItem(element_0_fabricSensitiveInt8uListItem_1, i_2,
                                                                           element_2);
                            listHolder_2->mList[i_2] = static_cast<std::remove_reference_t<decltype(listHolder_2->mList[i_2])>>(
                                chip::JniReferences::GetInstance().IntegerToPrimitive(element_2));
                        }
                        listHolder_0->mList[i_0].fabricSensitiveInt8uList =
                            ListType_2(listHolder_2->mList, element_0_fabricSensitiveInt8uListItem_1Size);
                    }
                    else
                    {
                        listHolder_0->mList[i_0].fabricSensitiveInt8uList = ListType_2();
                    }
                }
                jobject element_0_fabricIndexItem_1;
                chip::JniReferences::GetInstance().GetObjectField(element_0, "fabricIndex", "Ljava/lang/Integer;",
                                                                  element_0_fabricIndexItem_1);
                listHolder_0->mList[i_0].fabricIndex =
                    static_cast<std::remove_reference_t<decltype(listHolder_0->mList[i_0].fabricIndex)>>(
                        chip::JniReferences::GetInstance().IntegerToPrimitive(element_0_fabricIndexItem_1));
            }
            cppValue = ListType_0(listHolder_0->mList, valueSize);
        }
        else
        {
            cppValue = ListType_0();
        }
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeTimedWriteBooleanAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::TimedWriteBoolean::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                               chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeGeneralErrorBooleanAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::GeneralErrorBoolean::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeClusterErrorBooleanAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::ClusterErrorBoolean::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeUnsupportedAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::Unsupported::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().BooleanToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableBooleanAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableBoolean::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().BooleanToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableBitmap8Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableBitmap8::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0.SetRaw(static_cast<std::remove_reference_t<decltype(nonNullValue_0)>::IntegerType>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value)));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableBitmap16Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableBitmap16::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0.SetRaw(static_cast<std::remove_reference_t<decltype(nonNullValue_0)>::IntegerType>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value)));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableBitmap32Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableBitmap32::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0.SetRaw(static_cast<std::remove_reference_t<decltype(nonNullValue_0)>::IntegerType>(
            chip::JniReferences::GetInstance().LongToPrimitive(value)));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableBitmap64Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableBitmap64::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0.SetRaw(static_cast<std::remove_reference_t<decltype(nonNullValue_0)>::IntegerType>(
            chip::JniReferences::GetInstance().LongToPrimitive(value)));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt8uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt8u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt16uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt16u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt24uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt24u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt32uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt32u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt40uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt40u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt48uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt48u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt56uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt56u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt64uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt64u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt8sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt8s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt16sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt16s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt24sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt24s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt32sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt32s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt40sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt40s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt48sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt48s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt56sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt56s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableInt64sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableInt64s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().LongToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableEnum8Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableEnum8::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableEnum16Attribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableEnum16::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableFloatSingleAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableFloatSingle::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().FloatToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableFloatDoubleAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableFloatDouble::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().DoubleToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableOctetStringAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jbyteArray value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableOctetString::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        cleanupByteArrays.push_back(chip::Platform::MakeUnique<chip::JniByteArray>(env, static_cast<jbyteArray>(value)));
        nonNullValue_0 = cleanupByteArrays.back()->byteSpan();
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableCharStringAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jstring value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableCharString::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        cleanupStrings.push_back(chip::Platform::MakeUnique<chip::JniUtfString>(env, static_cast<jstring>(value)));
        nonNullValue_0 = cleanupStrings.back()->charSpan();
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableEnumAttrAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableEnumAttr::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableRangeRestrictedInt8uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableRangeRestrictedInt8u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableRangeRestrictedInt8sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableRangeRestrictedInt8s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableRangeRestrictedInt16uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableRangeRestrictedInt16u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeNullableRangeRestrictedInt16sAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::NullableRangeRestrictedInt16s::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    if (value == nullptr)
    {
        cppValue.SetNull();
    }
    else
    {
        auto & nonNullValue_0 = cppValue.SetNonNull();
        nonNullValue_0        = static_cast<std::remove_reference_t<decltype(nonNullValue_0)>>(
            chip::JniReferences::GetInstance().IntegerToPrimitive(value));
    }

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

JNI_METHOD(void, UnitTestingCluster, writeWriteOnlyInt8uAttribute)
(JNIEnv * env, jobject self, jlong clusterPtr, jobject callback, jobject value, jobject timedWriteTimeoutMs)
{
    chip::DeviceLayer::StackLock lock;
    ListFreer listFreer;
    using TypeInfo = chip::app::Clusters::UnitTesting::Attributes::WriteOnlyInt8u::TypeInfo;
    TypeInfo::Type cppValue;

    std::vector<Platform::UniquePtr<JniByteArray>> cleanupByteArrays;
    std::vector<Platform::UniquePtr<JniUtfString>> cleanupStrings;

    cppValue =
        static_cast<std::remove_reference_t<decltype(cppValue)>>(chip::JniReferences::GetInstance().IntegerToPrimitive(value));

    std::unique_ptr<CHIPDefaultSuccessCallback, void (*)(CHIPDefaultSuccessCallback *)> onSuccess(
        Platform::New<CHIPDefaultSuccessCallback>(callback), Platform::Delete<CHIPDefaultSuccessCallback>);
    VerifyOrReturn(onSuccess.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native success callback", CHIP_ERROR_NO_MEMORY));

    std::unique_ptr<CHIPDefaultFailureCallback, void (*)(CHIPDefaultFailureCallback *)> onFailure(
        Platform::New<CHIPDefaultFailureCallback>(callback), Platform::Delete<CHIPDefaultFailureCallback>);
    VerifyOrReturn(onFailure.get() != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Error creating native failure callback", CHIP_ERROR_NO_MEMORY));

    CHIP_ERROR err                  = CHIP_NO_ERROR;
    UnitTestingCluster * cppCluster = reinterpret_cast<UnitTestingCluster *>(clusterPtr);
    VerifyOrReturn(cppCluster != nullptr,
                   chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(
                       env, callback, "Could not get native cluster", CHIP_ERROR_INCORRECT_STATE));

    auto successFn = chip::Callback::Callback<CHIPDefaultWriteSuccessCallbackType>::FromCancelable(onSuccess->Cancel());
    auto failureFn = chip::Callback::Callback<CHIPDefaultFailureCallbackType>::FromCancelable(onFailure->Cancel());

    if (timedWriteTimeoutMs == nullptr)
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall);
    }
    else
    {
        err = cppCluster->WriteAttribute<TypeInfo>(cppValue, onSuccess->mContext, successFn->mCall, failureFn->mCall,
                                                   chip::JniReferences::GetInstance().IntegerToPrimitive(timedWriteTimeoutMs));
    }
    VerifyOrReturn(
        err == CHIP_NO_ERROR,
        chip::AndroidClusterExceptions::GetInstance().ReturnIllegalStateException(env, callback, "Error writing attribute", err));

    onSuccess.release();
    onFailure.release();
}

#pragma clang diagnostic pop
