/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP
#include <jni/CHIPCallbackTypes.h>

#include <app-common/zap-generated/cluster-objects.h>
#include <jni.h>
#include <zap-generated/CHIPClientCallbacks.h>

namespace chip {

class CHIPGroupsClusterAddGroupResponseCallback : public Callback::Callback<CHIPGroupsClusterAddGroupResponseCallbackType>
{
public:
    CHIPGroupsClusterAddGroupResponseCallback(jobject javaCallback);

    ~CHIPGroupsClusterAddGroupResponseCallback();

    static void CallbackFn(void * context, const chip::app::Clusters::Groups::Commands::AddGroupResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPGroupsClusterViewGroupResponseCallback : public Callback::Callback<CHIPGroupsClusterViewGroupResponseCallbackType>
{
public:
    CHIPGroupsClusterViewGroupResponseCallback(jobject javaCallback);

    ~CHIPGroupsClusterViewGroupResponseCallback();

    static void CallbackFn(void * context, const chip::app::Clusters::Groups::Commands::ViewGroupResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPGroupsClusterGetGroupMembershipResponseCallback
    : public Callback::Callback<CHIPGroupsClusterGetGroupMembershipResponseCallbackType>
{
public:
    CHIPGroupsClusterGetGroupMembershipResponseCallback(jobject javaCallback);

    ~CHIPGroupsClusterGetGroupMembershipResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::Groups::Commands::GetGroupMembershipResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPGroupsClusterRemoveGroupResponseCallback : public Callback::Callback<CHIPGroupsClusterRemoveGroupResponseCallbackType>
{
public:
    CHIPGroupsClusterRemoveGroupResponseCallback(jobject javaCallback);

    ~CHIPGroupsClusterRemoveGroupResponseCallback();

    static void CallbackFn(void * context, const chip::app::Clusters::Groups::Commands::RemoveGroupResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPScenesClusterAddSceneResponseCallback : public Callback::Callback<CHIPScenesClusterAddSceneResponseCallbackType>
{
public:
    CHIPScenesClusterAddSceneResponseCallback(jobject javaCallback);

    ~CHIPScenesClusterAddSceneResponseCallback();

    static void CallbackFn(void * context, const chip::app::Clusters::Scenes::Commands::AddSceneResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPScenesClusterViewSceneResponseCallback : public Callback::Callback<CHIPScenesClusterViewSceneResponseCallbackType>
{
public:
    CHIPScenesClusterViewSceneResponseCallback(jobject javaCallback);

    ~CHIPScenesClusterViewSceneResponseCallback();

    static void CallbackFn(void * context, const chip::app::Clusters::Scenes::Commands::ViewSceneResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPScenesClusterRemoveSceneResponseCallback : public Callback::Callback<CHIPScenesClusterRemoveSceneResponseCallbackType>
{
public:
    CHIPScenesClusterRemoveSceneResponseCallback(jobject javaCallback);

    ~CHIPScenesClusterRemoveSceneResponseCallback();

    static void CallbackFn(void * context, const chip::app::Clusters::Scenes::Commands::RemoveSceneResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPScenesClusterRemoveAllScenesResponseCallback
    : public Callback::Callback<CHIPScenesClusterRemoveAllScenesResponseCallbackType>
{
public:
    CHIPScenesClusterRemoveAllScenesResponseCallback(jobject javaCallback);

    ~CHIPScenesClusterRemoveAllScenesResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::Scenes::Commands::RemoveAllScenesResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPScenesClusterStoreSceneResponseCallback : public Callback::Callback<CHIPScenesClusterStoreSceneResponseCallbackType>
{
public:
    CHIPScenesClusterStoreSceneResponseCallback(jobject javaCallback);

    ~CHIPScenesClusterStoreSceneResponseCallback();

    static void CallbackFn(void * context, const chip::app::Clusters::Scenes::Commands::StoreSceneResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPScenesClusterGetSceneMembershipResponseCallback
    : public Callback::Callback<CHIPScenesClusterGetSceneMembershipResponseCallbackType>
{
public:
    CHIPScenesClusterGetSceneMembershipResponseCallback(jobject javaCallback);

    ~CHIPScenesClusterGetSceneMembershipResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::Scenes::Commands::GetSceneMembershipResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPScenesClusterEnhancedAddSceneResponseCallback
    : public Callback::Callback<CHIPScenesClusterEnhancedAddSceneResponseCallbackType>
{
public:
    CHIPScenesClusterEnhancedAddSceneResponseCallback(jobject javaCallback);

    ~CHIPScenesClusterEnhancedAddSceneResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::Scenes::Commands::EnhancedAddSceneResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPScenesClusterEnhancedViewSceneResponseCallback
    : public Callback::Callback<CHIPScenesClusterEnhancedViewSceneResponseCallbackType>
{
public:
    CHIPScenesClusterEnhancedViewSceneResponseCallback(jobject javaCallback);

    ~CHIPScenesClusterEnhancedViewSceneResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::Scenes::Commands::EnhancedViewSceneResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPScenesClusterCopySceneResponseCallback : public Callback::Callback<CHIPScenesClusterCopySceneResponseCallbackType>
{
public:
    CHIPScenesClusterCopySceneResponseCallback(jobject javaCallback);

    ~CHIPScenesClusterCopySceneResponseCallback();

    static void CallbackFn(void * context, const chip::app::Clusters::Scenes::Commands::CopySceneResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPOtaSoftwareUpdateProviderClusterQueryImageResponseCallback
    : public Callback::Callback<CHIPOtaSoftwareUpdateProviderClusterQueryImageResponseCallbackType>
{
public:
    CHIPOtaSoftwareUpdateProviderClusterQueryImageResponseCallback(jobject javaCallback);

    ~CHIPOtaSoftwareUpdateProviderClusterQueryImageResponseCallback();

    static void
    CallbackFn(void * context,
               const chip::app::Clusters::OtaSoftwareUpdateProvider::Commands::QueryImageResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPOtaSoftwareUpdateProviderClusterApplyUpdateResponseCallback
    : public Callback::Callback<CHIPOtaSoftwareUpdateProviderClusterApplyUpdateResponseCallbackType>
{
public:
    CHIPOtaSoftwareUpdateProviderClusterApplyUpdateResponseCallback(jobject javaCallback);

    ~CHIPOtaSoftwareUpdateProviderClusterApplyUpdateResponseCallback();

    static void
    CallbackFn(void * context,
               const chip::app::Clusters::OtaSoftwareUpdateProvider::Commands::ApplyUpdateResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPGeneralCommissioningClusterArmFailSafeResponseCallback
    : public Callback::Callback<CHIPGeneralCommissioningClusterArmFailSafeResponseCallbackType>
{
public:
    CHIPGeneralCommissioningClusterArmFailSafeResponseCallback(jobject javaCallback);

    ~CHIPGeneralCommissioningClusterArmFailSafeResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::GeneralCommissioning::Commands::ArmFailSafeResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPGeneralCommissioningClusterSetRegulatoryConfigResponseCallback
    : public Callback::Callback<CHIPGeneralCommissioningClusterSetRegulatoryConfigResponseCallbackType>
{
public:
    CHIPGeneralCommissioningClusterSetRegulatoryConfigResponseCallback(jobject javaCallback);

    ~CHIPGeneralCommissioningClusterSetRegulatoryConfigResponseCallback();

    static void
    CallbackFn(void * context,
               const chip::app::Clusters::GeneralCommissioning::Commands::SetRegulatoryConfigResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPGeneralCommissioningClusterCommissioningCompleteResponseCallback
    : public Callback::Callback<CHIPGeneralCommissioningClusterCommissioningCompleteResponseCallbackType>
{
public:
    CHIPGeneralCommissioningClusterCommissioningCompleteResponseCallback(jobject javaCallback);

    ~CHIPGeneralCommissioningClusterCommissioningCompleteResponseCallback();

    static void
    CallbackFn(void * context,
               const chip::app::Clusters::GeneralCommissioning::Commands::CommissioningCompleteResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPNetworkCommissioningClusterScanNetworksResponseCallback
    : public Callback::Callback<CHIPNetworkCommissioningClusterScanNetworksResponseCallbackType>
{
public:
    CHIPNetworkCommissioningClusterScanNetworksResponseCallback(jobject javaCallback);

    ~CHIPNetworkCommissioningClusterScanNetworksResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::NetworkCommissioning::Commands::ScanNetworksResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPNetworkCommissioningClusterNetworkConfigResponseCallback
    : public Callback::Callback<CHIPNetworkCommissioningClusterNetworkConfigResponseCallbackType>
{
public:
    CHIPNetworkCommissioningClusterNetworkConfigResponseCallback(jobject javaCallback);

    ~CHIPNetworkCommissioningClusterNetworkConfigResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPNetworkCommissioningClusterConnectNetworkResponseCallback
    : public Callback::Callback<CHIPNetworkCommissioningClusterConnectNetworkResponseCallbackType>
{
public:
    CHIPNetworkCommissioningClusterConnectNetworkResponseCallback(jobject javaCallback);

    ~CHIPNetworkCommissioningClusterConnectNetworkResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::NetworkCommissioning::Commands::ConnectNetworkResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPDiagnosticLogsClusterRetrieveLogsResponseCallback
    : public Callback::Callback<CHIPDiagnosticLogsClusterRetrieveLogsResponseCallbackType>
{
public:
    CHIPDiagnosticLogsClusterRetrieveLogsResponseCallback(jobject javaCallback);

    ~CHIPDiagnosticLogsClusterRetrieveLogsResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::DiagnosticLogs::Commands::RetrieveLogsResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPTimeSynchronizationClusterSetTimeZoneResponseCallback
    : public Callback::Callback<CHIPTimeSynchronizationClusterSetTimeZoneResponseCallbackType>
{
public:
    CHIPTimeSynchronizationClusterSetTimeZoneResponseCallback(jobject javaCallback);

    ~CHIPTimeSynchronizationClusterSetTimeZoneResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::TimeSynchronization::Commands::SetTimeZoneResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPOperationalCredentialsClusterAttestationResponseCallback
    : public Callback::Callback<CHIPOperationalCredentialsClusterAttestationResponseCallbackType>
{
public:
    CHIPOperationalCredentialsClusterAttestationResponseCallback(jobject javaCallback);

    ~CHIPOperationalCredentialsClusterAttestationResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::OperationalCredentials::Commands::AttestationResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPOperationalCredentialsClusterCertificateChainResponseCallback
    : public Callback::Callback<CHIPOperationalCredentialsClusterCertificateChainResponseCallbackType>
{
public:
    CHIPOperationalCredentialsClusterCertificateChainResponseCallback(jobject javaCallback);

    ~CHIPOperationalCredentialsClusterCertificateChainResponseCallback();

    static void
    CallbackFn(void * context,
               const chip::app::Clusters::OperationalCredentials::Commands::CertificateChainResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPOperationalCredentialsClusterCSRResponseCallback
    : public Callback::Callback<CHIPOperationalCredentialsClusterCSRResponseCallbackType>
{
public:
    CHIPOperationalCredentialsClusterCSRResponseCallback(jobject javaCallback);

    ~CHIPOperationalCredentialsClusterCSRResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::OperationalCredentials::Commands::CSRResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPOperationalCredentialsClusterNOCResponseCallback
    : public Callback::Callback<CHIPOperationalCredentialsClusterNOCResponseCallbackType>
{
public:
    CHIPOperationalCredentialsClusterNOCResponseCallback(jobject javaCallback);

    ~CHIPOperationalCredentialsClusterNOCResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::OperationalCredentials::Commands::NOCResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPGroupKeyManagementClusterKeySetReadResponseCallback
    : public Callback::Callback<CHIPGroupKeyManagementClusterKeySetReadResponseCallbackType>
{
public:
    CHIPGroupKeyManagementClusterKeySetReadResponseCallback(jobject javaCallback);

    ~CHIPGroupKeyManagementClusterKeySetReadResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::GroupKeyManagement::Commands::KeySetReadResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPGroupKeyManagementClusterKeySetReadAllIndicesResponseCallback
    : public Callback::Callback<CHIPGroupKeyManagementClusterKeySetReadAllIndicesResponseCallbackType>
{
public:
    CHIPGroupKeyManagementClusterKeySetReadAllIndicesResponseCallback(jobject javaCallback);

    ~CHIPGroupKeyManagementClusterKeySetReadAllIndicesResponseCallback();

    static void
    CallbackFn(void * context,
               const chip::app::Clusters::GroupKeyManagement::Commands::KeySetReadAllIndicesResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPIcdManagementClusterRegisterClientResponseCallback
    : public Callback::Callback<CHIPIcdManagementClusterRegisterClientResponseCallbackType>
{
public:
    CHIPIcdManagementClusterRegisterClientResponseCallback(jobject javaCallback);

    ~CHIPIcdManagementClusterRegisterClientResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::IcdManagement::Commands::RegisterClientResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPOperationalStateClusterOperationalCommandResponseCallback
    : public Callback::Callback<CHIPOperationalStateClusterOperationalCommandResponseCallbackType>
{
public:
    CHIPOperationalStateClusterOperationalCommandResponseCallback(jobject javaCallback);

    ~CHIPOperationalStateClusterOperationalCommandResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::OperationalState::Commands::OperationalCommandResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPDoorLockClusterGetWeekDayScheduleResponseCallback
    : public Callback::Callback<CHIPDoorLockClusterGetWeekDayScheduleResponseCallbackType>
{
public:
    CHIPDoorLockClusterGetWeekDayScheduleResponseCallback(jobject javaCallback);

    ~CHIPDoorLockClusterGetWeekDayScheduleResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::DoorLock::Commands::GetWeekDayScheduleResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPDoorLockClusterGetYearDayScheduleResponseCallback
    : public Callback::Callback<CHIPDoorLockClusterGetYearDayScheduleResponseCallbackType>
{
public:
    CHIPDoorLockClusterGetYearDayScheduleResponseCallback(jobject javaCallback);

    ~CHIPDoorLockClusterGetYearDayScheduleResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::DoorLock::Commands::GetYearDayScheduleResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPDoorLockClusterGetHolidayScheduleResponseCallback
    : public Callback::Callback<CHIPDoorLockClusterGetHolidayScheduleResponseCallbackType>
{
public:
    CHIPDoorLockClusterGetHolidayScheduleResponseCallback(jobject javaCallback);

    ~CHIPDoorLockClusterGetHolidayScheduleResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::DoorLock::Commands::GetHolidayScheduleResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPDoorLockClusterGetUserResponseCallback : public Callback::Callback<CHIPDoorLockClusterGetUserResponseCallbackType>
{
public:
    CHIPDoorLockClusterGetUserResponseCallback(jobject javaCallback);

    ~CHIPDoorLockClusterGetUserResponseCallback();

    static void CallbackFn(void * context, const chip::app::Clusters::DoorLock::Commands::GetUserResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPDoorLockClusterSetCredentialResponseCallback
    : public Callback::Callback<CHIPDoorLockClusterSetCredentialResponseCallbackType>
{
public:
    CHIPDoorLockClusterSetCredentialResponseCallback(jobject javaCallback);

    ~CHIPDoorLockClusterSetCredentialResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::DoorLock::Commands::SetCredentialResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPDoorLockClusterGetCredentialStatusResponseCallback
    : public Callback::Callback<CHIPDoorLockClusterGetCredentialStatusResponseCallbackType>
{
public:
    CHIPDoorLockClusterGetCredentialStatusResponseCallback(jobject javaCallback);

    ~CHIPDoorLockClusterGetCredentialStatusResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::DoorLock::Commands::GetCredentialStatusResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPThermostatClusterGetWeeklyScheduleResponseCallback
    : public Callback::Callback<CHIPThermostatClusterGetWeeklyScheduleResponseCallbackType>
{
public:
    CHIPThermostatClusterGetWeeklyScheduleResponseCallback(jobject javaCallback);

    ~CHIPThermostatClusterGetWeeklyScheduleResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::Thermostat::Commands::GetWeeklyScheduleResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPChannelClusterChangeChannelResponseCallback
    : public Callback::Callback<CHIPChannelClusterChangeChannelResponseCallbackType>
{
public:
    CHIPChannelClusterChangeChannelResponseCallback(jobject javaCallback);

    ~CHIPChannelClusterChangeChannelResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::Channel::Commands::ChangeChannelResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPTargetNavigatorClusterNavigateTargetResponseCallback
    : public Callback::Callback<CHIPTargetNavigatorClusterNavigateTargetResponseCallbackType>
{
public:
    CHIPTargetNavigatorClusterNavigateTargetResponseCallback(jobject javaCallback);

    ~CHIPTargetNavigatorClusterNavigateTargetResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::TargetNavigator::Commands::NavigateTargetResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPMediaPlaybackClusterPlaybackResponseCallback
    : public Callback::Callback<CHIPMediaPlaybackClusterPlaybackResponseCallbackType>
{
public:
    CHIPMediaPlaybackClusterPlaybackResponseCallback(jobject javaCallback);

    ~CHIPMediaPlaybackClusterPlaybackResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPKeypadInputClusterSendKeyResponseCallback : public Callback::Callback<CHIPKeypadInputClusterSendKeyResponseCallbackType>
{
public:
    CHIPKeypadInputClusterSendKeyResponseCallback(jobject javaCallback);

    ~CHIPKeypadInputClusterSendKeyResponseCallback();

    static void CallbackFn(void * context, const chip::app::Clusters::KeypadInput::Commands::SendKeyResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPContentLauncherClusterLauncherResponseCallback
    : public Callback::Callback<CHIPContentLauncherClusterLauncherResponseCallbackType>
{
public:
    CHIPContentLauncherClusterLauncherResponseCallback(jobject javaCallback);

    ~CHIPContentLauncherClusterLauncherResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::ContentLauncher::Commands::LauncherResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPApplicationLauncherClusterLauncherResponseCallback
    : public Callback::Callback<CHIPApplicationLauncherClusterLauncherResponseCallbackType>
{
public:
    CHIPApplicationLauncherClusterLauncherResponseCallback(jobject javaCallback);

    ~CHIPApplicationLauncherClusterLauncherResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::ApplicationLauncher::Commands::LauncherResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPAccountLoginClusterGetSetupPINResponseCallback
    : public Callback::Callback<CHIPAccountLoginClusterGetSetupPINResponseCallbackType>
{
public:
    CHIPAccountLoginClusterGetSetupPINResponseCallback(jobject javaCallback);

    ~CHIPAccountLoginClusterGetSetupPINResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::AccountLogin::Commands::GetSetupPINResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPElectricalMeasurementClusterGetProfileInfoResponseCommandCallback
    : public Callback::Callback<CHIPElectricalMeasurementClusterGetProfileInfoResponseCommandCallbackType>
{
public:
    CHIPElectricalMeasurementClusterGetProfileInfoResponseCommandCallback(jobject javaCallback);

    ~CHIPElectricalMeasurementClusterGetProfileInfoResponseCommandCallback();

    static void
    CallbackFn(void * context,
               const chip::app::Clusters::ElectricalMeasurement::Commands::GetProfileInfoResponseCommand::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPElectricalMeasurementClusterGetMeasurementProfileResponseCommandCallback
    : public Callback::Callback<CHIPElectricalMeasurementClusterGetMeasurementProfileResponseCommandCallbackType>
{
public:
    CHIPElectricalMeasurementClusterGetMeasurementProfileResponseCommandCallback(jobject javaCallback);

    ~CHIPElectricalMeasurementClusterGetMeasurementProfileResponseCommandCallback();

    static void CallbackFn(
        void * context,
        const chip::app::Clusters::ElectricalMeasurement::Commands::GetMeasurementProfileResponseCommand::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterTestSpecificResponseCallback
    : public Callback::Callback<CHIPUnitTestingClusterTestSpecificResponseCallbackType>
{
public:
    CHIPUnitTestingClusterTestSpecificResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterTestSpecificResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::UnitTesting::Commands::TestSpecificResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterTestAddArgumentsResponseCallback
    : public Callback::Callback<CHIPUnitTestingClusterTestAddArgumentsResponseCallbackType>
{
public:
    CHIPUnitTestingClusterTestAddArgumentsResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterTestAddArgumentsResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::UnitTesting::Commands::TestAddArgumentsResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterTestSimpleArgumentResponseCallback
    : public Callback::Callback<CHIPUnitTestingClusterTestSimpleArgumentResponseCallbackType>
{
public:
    CHIPUnitTestingClusterTestSimpleArgumentResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterTestSimpleArgumentResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::UnitTesting::Commands::TestSimpleArgumentResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterTestStructArrayArgumentResponseCallback
    : public Callback::Callback<CHIPUnitTestingClusterTestStructArrayArgumentResponseCallbackType>
{
public:
    CHIPUnitTestingClusterTestStructArrayArgumentResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterTestStructArrayArgumentResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::UnitTesting::Commands::TestStructArrayArgumentResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterTestListInt8UReverseResponseCallback
    : public Callback::Callback<CHIPUnitTestingClusterTestListInt8UReverseResponseCallbackType>
{
public:
    CHIPUnitTestingClusterTestListInt8UReverseResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterTestListInt8UReverseResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::UnitTesting::Commands::TestListInt8UReverseResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterTestEnumsResponseCallback
    : public Callback::Callback<CHIPUnitTestingClusterTestEnumsResponseCallbackType>
{
public:
    CHIPUnitTestingClusterTestEnumsResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterTestEnumsResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::UnitTesting::Commands::TestEnumsResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterTestNullableOptionalResponseCallback
    : public Callback::Callback<CHIPUnitTestingClusterTestNullableOptionalResponseCallbackType>
{
public:
    CHIPUnitTestingClusterTestNullableOptionalResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterTestNullableOptionalResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::UnitTesting::Commands::TestNullableOptionalResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterTestComplexNullableOptionalResponseCallback
    : public Callback::Callback<CHIPUnitTestingClusterTestComplexNullableOptionalResponseCallbackType>
{
public:
    CHIPUnitTestingClusterTestComplexNullableOptionalResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterTestComplexNullableOptionalResponseCallback();

    static void
    CallbackFn(void * context,
               const chip::app::Clusters::UnitTesting::Commands::TestComplexNullableOptionalResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterBooleanResponseCallback : public Callback::Callback<CHIPUnitTestingClusterBooleanResponseCallbackType>
{
public:
    CHIPUnitTestingClusterBooleanResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterBooleanResponseCallback();

    static void CallbackFn(void * context, const chip::app::Clusters::UnitTesting::Commands::BooleanResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterSimpleStructResponseCallback
    : public Callback::Callback<CHIPUnitTestingClusterSimpleStructResponseCallbackType>
{
public:
    CHIPUnitTestingClusterSimpleStructResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterSimpleStructResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::UnitTesting::Commands::SimpleStructResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterTestEmitTestEventResponseCallback
    : public Callback::Callback<CHIPUnitTestingClusterTestEmitTestEventResponseCallbackType>
{
public:
    CHIPUnitTestingClusterTestEmitTestEventResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterTestEmitTestEventResponseCallback();

    static void CallbackFn(void * context,
                           const chip::app::Clusters::UnitTesting::Commands::TestEmitTestEventResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

class CHIPUnitTestingClusterTestEmitTestFabricScopedEventResponseCallback
    : public Callback::Callback<CHIPUnitTestingClusterTestEmitTestFabricScopedEventResponseCallbackType>
{
public:
    CHIPUnitTestingClusterTestEmitTestFabricScopedEventResponseCallback(jobject javaCallback);

    ~CHIPUnitTestingClusterTestEmitTestFabricScopedEventResponseCallback();

    static void
    CallbackFn(void * context,
               const chip::app::Clusters::UnitTesting::Commands::TestEmitTestFabricScopedEventResponse::DecodableType & data);

private:
    jobject javaCallbackRef;
};

} // namespace chip
