/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP
package chip.devicecontroller;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ChipClusters {

  public interface DefaultClusterCallback {
    void onSuccess();
    void onError(Exception error);
  }

  public interface CharStringAttributeCallback {
    /** Indicates a successful read for a CHAR_STRING attribute. */
    void onSuccess(String value);
    void onError(Exception error);
    default void onSubscriptionEstablished(long subscriptionId) {}
  }

  public interface OctetStringAttributeCallback {
    /** Indicates a successful read for an OCTET_STRING attribute. */
    void onSuccess(byte[] value);
    void onError(Exception error);
    default void onSubscriptionEstablished(long subscriptionId) {}
  }

  public interface IntegerAttributeCallback {
    void onSuccess(int value);
    void onError(Exception error);
    default void onSubscriptionEstablished(long subscriptionId) {}
  }

  public interface LongAttributeCallback {
    void onSuccess(long value);
    void onError(Exception error);
    default void onSubscriptionEstablished(long subscriptionId) {}
  }

  public interface BooleanAttributeCallback {
    void onSuccess(boolean value);
    void onError(Exception error);
    default void onSubscriptionEstablished(long subscriptionId) {}
  }

  public interface FloatAttributeCallback {
    void onSuccess(float value);
    void onError(Exception error);
    default void onSubscriptionEstablished(long subscriptionId) {}
  }

  public interface DoubleAttributeCallback {
    void onSuccess(double value);
    void onError(Exception error);
    default void onSubscriptionEstablished(long subscriptionId) {}
  }

  public static abstract class BaseChipCluster {
    protected long chipClusterPtr;

    public BaseChipCluster(long devicePtr, int endpointId) {
      chipClusterPtr = initWithDevice(devicePtr, endpointId);
    }

    /**
     * Sets the timeout, in milliseconds, after which commands sent through this cluster will fail
     * with a timeout (regardless of whether or not a response has been received). If set to an
     * empty optional, the default timeout will be used.
     */
    public void setCommandTimeout(Optional<Long> timeoutMillis) {
      setCommandTimeout(chipClusterPtr, timeoutMillis);
    }

    private native void setCommandTimeout(long clusterPtr, Optional<Long> timeoutMillis);

    /** Returns the current timeout (in milliseconds) for commands sent through this cluster. */
    public Optional<Long> getCommandTimeout() {
      Optional<Long> timeout = getCommandTimeout(chipClusterPtr);
      return timeout == null ? Optional.empty() : timeout;
    }

    private native Optional<Long> getCommandTimeout(long clusterPtr);

    public abstract long initWithDevice(long devicePtr, int endpointId);

    public native void deleteCluster(long chipClusterPtr);
    
    @SuppressWarnings("deprecation")
    protected void finalize() throws Throwable {
      super.finalize();

      if (chipClusterPtr != 0) {
        deleteCluster(chipClusterPtr);
        chipClusterPtr = 0;
      }
    }
  }

  public static class IdentifyCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 3L;

    public IdentifyCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void identify(DefaultClusterCallback callback
      , Integer identifyTime) {
      identify(chipClusterPtr, callback, identifyTime, null);
    }

    public void identify(DefaultClusterCallback callback
      , Integer identifyTime
      , int timedInvokeTimeoutMs) {
      identify(chipClusterPtr, callback, identifyTime, timedInvokeTimeoutMs);
    }

    public void triggerEffect(DefaultClusterCallback callback
      , Integer effectIdentifier, Integer effectVariant) {
      triggerEffect(chipClusterPtr, callback, effectIdentifier, effectVariant, null);
    }

    public void triggerEffect(DefaultClusterCallback callback
      , Integer effectIdentifier, Integer effectVariant
      , int timedInvokeTimeoutMs) {
      triggerEffect(chipClusterPtr, callback, effectIdentifier, effectVariant, timedInvokeTimeoutMs);
    }
    private native void identify(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer identifyTime
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void triggerEffect(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer effectIdentifier, Integer effectVariant
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readIdentifyTimeAttribute(
      IntegerAttributeCallback callback
    ) {
      readIdentifyTimeAttribute(chipClusterPtr, callback);
    }
    public void writeIdentifyTimeAttribute(DefaultClusterCallback callback, Integer value) {
      writeIdentifyTimeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeIdentifyTimeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeIdentifyTimeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeIdentifyTimeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeIdentifyTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readIdentifyTypeAttribute(
      IntegerAttributeCallback callback
    ) {
      readIdentifyTypeAttribute(chipClusterPtr, callback);
    }
    public void subscribeIdentifyTypeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeIdentifyTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readIdentifyTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeIdentifyTimeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeIdentifyTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readIdentifyTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeIdentifyTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class GroupsCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 4L;

    public GroupsCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void addGroup(AddGroupResponseCallback callback
      , Integer groupID, String groupName) {
      addGroup(chipClusterPtr, callback, groupID, groupName, null);
    }

    public void addGroup(AddGroupResponseCallback callback
      , Integer groupID, String groupName
      , int timedInvokeTimeoutMs) {
      addGroup(chipClusterPtr, callback, groupID, groupName, timedInvokeTimeoutMs);
    }

    public void viewGroup(ViewGroupResponseCallback callback
      , Integer groupID) {
      viewGroup(chipClusterPtr, callback, groupID, null);
    }

    public void viewGroup(ViewGroupResponseCallback callback
      , Integer groupID
      , int timedInvokeTimeoutMs) {
      viewGroup(chipClusterPtr, callback, groupID, timedInvokeTimeoutMs);
    }

    public void getGroupMembership(GetGroupMembershipResponseCallback callback
      , ArrayList<Integer> groupList) {
      getGroupMembership(chipClusterPtr, callback, groupList, null);
    }

    public void getGroupMembership(GetGroupMembershipResponseCallback callback
      , ArrayList<Integer> groupList
      , int timedInvokeTimeoutMs) {
      getGroupMembership(chipClusterPtr, callback, groupList, timedInvokeTimeoutMs);
    }

    public void removeGroup(RemoveGroupResponseCallback callback
      , Integer groupID) {
      removeGroup(chipClusterPtr, callback, groupID, null);
    }

    public void removeGroup(RemoveGroupResponseCallback callback
      , Integer groupID
      , int timedInvokeTimeoutMs) {
      removeGroup(chipClusterPtr, callback, groupID, timedInvokeTimeoutMs);
    }

    public void removeAllGroups(DefaultClusterCallback callback
      ) {
      removeAllGroups(chipClusterPtr, callback, null);
    }

    public void removeAllGroups(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      removeAllGroups(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }

    public void addGroupIfIdentifying(DefaultClusterCallback callback
      , Integer groupID, String groupName) {
      addGroupIfIdentifying(chipClusterPtr, callback, groupID, groupName, null);
    }

    public void addGroupIfIdentifying(DefaultClusterCallback callback
      , Integer groupID, String groupName
      , int timedInvokeTimeoutMs) {
      addGroupIfIdentifying(chipClusterPtr, callback, groupID, groupName, timedInvokeTimeoutMs);
    }
    private native void addGroup(long chipClusterPtr, AddGroupResponseCallback Callback
      , Integer groupID, String groupName
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void viewGroup(long chipClusterPtr, ViewGroupResponseCallback Callback
      , Integer groupID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void getGroupMembership(long chipClusterPtr, GetGroupMembershipResponseCallback Callback
      , ArrayList<Integer> groupList
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void removeGroup(long chipClusterPtr, RemoveGroupResponseCallback Callback
      , Integer groupID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void removeAllGroups(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void addGroupIfIdentifying(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer groupID, String groupName
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface AddGroupResponseCallback {
      void onSuccess(Integer status, Integer groupID);
      
      void onError(Exception error);
    }

    public interface ViewGroupResponseCallback {
      void onSuccess(Integer status, Integer groupID, String groupName);
      
      void onError(Exception error);
    }

    public interface GetGroupMembershipResponseCallback {
      void onSuccess(@Nullable Integer capacity, ArrayList<Integer> groupList);
      
      void onError(Exception error);
    }

    public interface RemoveGroupResponseCallback {
      void onSuccess(Integer status, Integer groupID);
      
      void onError(Exception error);
    }


      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readNameSupportAttribute(
      IntegerAttributeCallback callback
    ) {
      readNameSupportAttribute(chipClusterPtr, callback);
    }
    public void subscribeNameSupportAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNameSupportAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readNameSupportAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNameSupportAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ScenesCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 5L;

    public ScenesCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void addScene(AddSceneResponseCallback callback
      , Integer groupID, Integer sceneID, Integer transitionTime, String sceneName, ArrayList<ChipStructs.ScenesClusterExtensionFieldSet> extensionFieldSets) {
      addScene(chipClusterPtr, callback, groupID, sceneID, transitionTime, sceneName, extensionFieldSets, null);
    }

    public void addScene(AddSceneResponseCallback callback
      , Integer groupID, Integer sceneID, Integer transitionTime, String sceneName, ArrayList<ChipStructs.ScenesClusterExtensionFieldSet> extensionFieldSets
      , int timedInvokeTimeoutMs) {
      addScene(chipClusterPtr, callback, groupID, sceneID, transitionTime, sceneName, extensionFieldSets, timedInvokeTimeoutMs);
    }

    public void viewScene(ViewSceneResponseCallback callback
      , Integer groupID, Integer sceneID) {
      viewScene(chipClusterPtr, callback, groupID, sceneID, null);
    }

    public void viewScene(ViewSceneResponseCallback callback
      , Integer groupID, Integer sceneID
      , int timedInvokeTimeoutMs) {
      viewScene(chipClusterPtr, callback, groupID, sceneID, timedInvokeTimeoutMs);
    }

    public void removeScene(RemoveSceneResponseCallback callback
      , Integer groupID, Integer sceneID) {
      removeScene(chipClusterPtr, callback, groupID, sceneID, null);
    }

    public void removeScene(RemoveSceneResponseCallback callback
      , Integer groupID, Integer sceneID
      , int timedInvokeTimeoutMs) {
      removeScene(chipClusterPtr, callback, groupID, sceneID, timedInvokeTimeoutMs);
    }

    public void removeAllScenes(RemoveAllScenesResponseCallback callback
      , Integer groupID) {
      removeAllScenes(chipClusterPtr, callback, groupID, null);
    }

    public void removeAllScenes(RemoveAllScenesResponseCallback callback
      , Integer groupID
      , int timedInvokeTimeoutMs) {
      removeAllScenes(chipClusterPtr, callback, groupID, timedInvokeTimeoutMs);
    }

    public void storeScene(StoreSceneResponseCallback callback
      , Integer groupID, Integer sceneID) {
      storeScene(chipClusterPtr, callback, groupID, sceneID, null);
    }

    public void storeScene(StoreSceneResponseCallback callback
      , Integer groupID, Integer sceneID
      , int timedInvokeTimeoutMs) {
      storeScene(chipClusterPtr, callback, groupID, sceneID, timedInvokeTimeoutMs);
    }

    public void recallScene(DefaultClusterCallback callback
      , Integer groupID, Integer sceneID, @Nullable Optional<Integer> transitionTime) {
      recallScene(chipClusterPtr, callback, groupID, sceneID, transitionTime, null);
    }

    public void recallScene(DefaultClusterCallback callback
      , Integer groupID, Integer sceneID, @Nullable Optional<Integer> transitionTime
      , int timedInvokeTimeoutMs) {
      recallScene(chipClusterPtr, callback, groupID, sceneID, transitionTime, timedInvokeTimeoutMs);
    }

    public void getSceneMembership(GetSceneMembershipResponseCallback callback
      , Integer groupID) {
      getSceneMembership(chipClusterPtr, callback, groupID, null);
    }

    public void getSceneMembership(GetSceneMembershipResponseCallback callback
      , Integer groupID
      , int timedInvokeTimeoutMs) {
      getSceneMembership(chipClusterPtr, callback, groupID, timedInvokeTimeoutMs);
    }
    private native void addScene(long chipClusterPtr, AddSceneResponseCallback Callback
      , Integer groupID, Integer sceneID, Integer transitionTime, String sceneName, ArrayList<ChipStructs.ScenesClusterExtensionFieldSet> extensionFieldSets
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void viewScene(long chipClusterPtr, ViewSceneResponseCallback Callback
      , Integer groupID, Integer sceneID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void removeScene(long chipClusterPtr, RemoveSceneResponseCallback Callback
      , Integer groupID, Integer sceneID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void removeAllScenes(long chipClusterPtr, RemoveAllScenesResponseCallback Callback
      , Integer groupID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void storeScene(long chipClusterPtr, StoreSceneResponseCallback Callback
      , Integer groupID, Integer sceneID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void recallScene(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer groupID, Integer sceneID, @Nullable Optional<Integer> transitionTime
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void getSceneMembership(long chipClusterPtr, GetSceneMembershipResponseCallback Callback
      , Integer groupID
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface AddSceneResponseCallback {
      void onSuccess(Integer status, Integer groupID, Integer sceneID);
      
      void onError(Exception error);
    }

    public interface ViewSceneResponseCallback {
      void onSuccess(Integer status, Integer groupID, Integer sceneID, Optional<Integer> transitionTime, Optional<String> sceneName, Optional<ArrayList<ChipStructs.ScenesClusterExtensionFieldSet>> extensionFieldSets);
      
      void onError(Exception error);
    }

    public interface RemoveSceneResponseCallback {
      void onSuccess(Integer status, Integer groupID, Integer sceneID);
      
      void onError(Exception error);
    }

    public interface RemoveAllScenesResponseCallback {
      void onSuccess(Integer status, Integer groupID);
      
      void onError(Exception error);
    }

    public interface StoreSceneResponseCallback {
      void onSuccess(Integer status, Integer groupID, Integer sceneID);
      
      void onError(Exception error);
    }

    public interface GetSceneMembershipResponseCallback {
      void onSuccess(Integer status, @Nullable Integer capacity, Integer groupID, Optional<ArrayList<Integer>> sceneList);
      
      void onError(Exception error);
    }


      public interface LastConfiguredByAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readSceneCountAttribute(
      IntegerAttributeCallback callback
    ) {
      readSceneCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeSceneCountAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSceneCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentSceneAttribute(
      IntegerAttributeCallback callback
    ) {
      readCurrentSceneAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentSceneAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentSceneAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentGroupAttribute(
      IntegerAttributeCallback callback
    ) {
      readCurrentGroupAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentGroupAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentGroupAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSceneValidAttribute(
      BooleanAttributeCallback callback
    ) {
      readSceneValidAttribute(chipClusterPtr, callback);
    }
    public void subscribeSceneValidAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSceneValidAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNameSupportAttribute(
      IntegerAttributeCallback callback
    ) {
      readNameSupportAttribute(chipClusterPtr, callback);
    }
    public void subscribeNameSupportAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNameSupportAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLastConfiguredByAttribute(
      LastConfiguredByAttributeCallback callback
    ) {
      readLastConfiguredByAttribute(chipClusterPtr, callback);
    }
    public void subscribeLastConfiguredByAttribute(
        LastConfiguredByAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLastConfiguredByAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSceneTableSizeAttribute(
      IntegerAttributeCallback callback
    ) {
      readSceneTableSizeAttribute(chipClusterPtr, callback);
    }
    public void subscribeSceneTableSizeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSceneTableSizeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRemainingCapacityAttribute(
      IntegerAttributeCallback callback
    ) {
      readRemainingCapacityAttribute(chipClusterPtr, callback);
    }
    public void subscribeRemainingCapacityAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRemainingCapacityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readSceneCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeSceneCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentSceneAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCurrentSceneAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentGroupAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCurrentGroupAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSceneValidAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeSceneValidAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNameSupportAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNameSupportAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLastConfiguredByAttribute(long chipClusterPtr,
        LastConfiguredByAttributeCallback callback
    );
    private native void subscribeLastConfiguredByAttribute(long chipClusterPtr,
        LastConfiguredByAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readSceneTableSizeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeSceneTableSizeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRemainingCapacityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeRemainingCapacityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class OnOffCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 6L;

    public OnOffCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void off(DefaultClusterCallback callback
      ) {
      off(chipClusterPtr, callback, null);
    }

    public void off(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      off(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }

    public void on(DefaultClusterCallback callback
      ) {
      on(chipClusterPtr, callback, null);
    }

    public void on(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      on(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }

    public void toggle(DefaultClusterCallback callback
      ) {
      toggle(chipClusterPtr, callback, null);
    }

    public void toggle(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      toggle(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }

    public void offWithEffect(DefaultClusterCallback callback
      , Integer effectIdentifier, Integer effectVariant) {
      offWithEffect(chipClusterPtr, callback, effectIdentifier, effectVariant, null);
    }

    public void offWithEffect(DefaultClusterCallback callback
      , Integer effectIdentifier, Integer effectVariant
      , int timedInvokeTimeoutMs) {
      offWithEffect(chipClusterPtr, callback, effectIdentifier, effectVariant, timedInvokeTimeoutMs);
    }

    public void onWithRecallGlobalScene(DefaultClusterCallback callback
      ) {
      onWithRecallGlobalScene(chipClusterPtr, callback, null);
    }

    public void onWithRecallGlobalScene(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      onWithRecallGlobalScene(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }

    public void onWithTimedOff(DefaultClusterCallback callback
      , Integer onOffControl, Integer onTime, Integer offWaitTime) {
      onWithTimedOff(chipClusterPtr, callback, onOffControl, onTime, offWaitTime, null);
    }

    public void onWithTimedOff(DefaultClusterCallback callback
      , Integer onOffControl, Integer onTime, Integer offWaitTime
      , int timedInvokeTimeoutMs) {
      onWithTimedOff(chipClusterPtr, callback, onOffControl, onTime, offWaitTime, timedInvokeTimeoutMs);
    }
    private native void off(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void on(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void toggle(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void offWithEffect(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer effectIdentifier, Integer effectVariant
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void onWithRecallGlobalScene(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void onWithTimedOff(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer onOffControl, Integer onTime, Integer offWaitTime
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface StartUpOnOffAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readOnOffAttribute(
      BooleanAttributeCallback callback
    ) {
      readOnOffAttribute(chipClusterPtr, callback);
    }
    public void subscribeOnOffAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOnOffAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGlobalSceneControlAttribute(
      BooleanAttributeCallback callback
    ) {
      readGlobalSceneControlAttribute(chipClusterPtr, callback);
    }
    public void subscribeGlobalSceneControlAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeGlobalSceneControlAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOnTimeAttribute(
      IntegerAttributeCallback callback
    ) {
      readOnTimeAttribute(chipClusterPtr, callback);
    }
    public void writeOnTimeAttribute(DefaultClusterCallback callback, Integer value) {
      writeOnTimeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOnTimeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOnTimeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOnTimeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOnTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOffWaitTimeAttribute(
      IntegerAttributeCallback callback
    ) {
      readOffWaitTimeAttribute(chipClusterPtr, callback);
    }
    public void writeOffWaitTimeAttribute(DefaultClusterCallback callback, Integer value) {
      writeOffWaitTimeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOffWaitTimeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOffWaitTimeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOffWaitTimeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOffWaitTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readStartUpOnOffAttribute(
      StartUpOnOffAttributeCallback callback
    ) {
      readStartUpOnOffAttribute(chipClusterPtr, callback);
    }
    public void writeStartUpOnOffAttribute(DefaultClusterCallback callback, Integer value) {
      writeStartUpOnOffAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeStartUpOnOffAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeStartUpOnOffAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeStartUpOnOffAttribute(
        StartUpOnOffAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeStartUpOnOffAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readOnOffAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeOnOffAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGlobalSceneControlAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeGlobalSceneControlAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOnTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeOnTimeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOnTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOffWaitTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeOffWaitTimeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOffWaitTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readStartUpOnOffAttribute(long chipClusterPtr,
        StartUpOnOffAttributeCallback callback
    );

    private native void writeStartUpOnOffAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeStartUpOnOffAttribute(long chipClusterPtr,
        StartUpOnOffAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class OnOffSwitchConfigurationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 7L;

    public OnOffSwitchConfigurationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readSwitchTypeAttribute(
      IntegerAttributeCallback callback
    ) {
      readSwitchTypeAttribute(chipClusterPtr, callback);
    }
    public void subscribeSwitchTypeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSwitchTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSwitchActionsAttribute(
      IntegerAttributeCallback callback
    ) {
      readSwitchActionsAttribute(chipClusterPtr, callback);
    }
    public void writeSwitchActionsAttribute(DefaultClusterCallback callback, Integer value) {
      writeSwitchActionsAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeSwitchActionsAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeSwitchActionsAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeSwitchActionsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSwitchActionsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readSwitchTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeSwitchTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSwitchActionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeSwitchActionsAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeSwitchActionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class LevelControlCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 8L;

    public LevelControlCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void moveToLevel(DefaultClusterCallback callback
      , Integer level, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      moveToLevel(chipClusterPtr, callback, level, transitionTime, optionsMask, optionsOverride, null);
    }

    public void moveToLevel(DefaultClusterCallback callback
      , Integer level, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveToLevel(chipClusterPtr, callback, level, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void move(DefaultClusterCallback callback
      , Integer moveMode, @Nullable Integer rate, Integer optionsMask, Integer optionsOverride) {
      move(chipClusterPtr, callback, moveMode, rate, optionsMask, optionsOverride, null);
    }

    public void move(DefaultClusterCallback callback
      , Integer moveMode, @Nullable Integer rate, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      move(chipClusterPtr, callback, moveMode, rate, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void step(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      step(chipClusterPtr, callback, stepMode, stepSize, transitionTime, optionsMask, optionsOverride, null);
    }

    public void step(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      step(chipClusterPtr, callback, stepMode, stepSize, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void stop(DefaultClusterCallback callback
      , Integer optionsMask, Integer optionsOverride) {
      stop(chipClusterPtr, callback, optionsMask, optionsOverride, null);
    }

    public void stop(DefaultClusterCallback callback
      , Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      stop(chipClusterPtr, callback, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void moveToLevelWithOnOff(DefaultClusterCallback callback
      , Integer level, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      moveToLevelWithOnOff(chipClusterPtr, callback, level, transitionTime, optionsMask, optionsOverride, null);
    }

    public void moveToLevelWithOnOff(DefaultClusterCallback callback
      , Integer level, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveToLevelWithOnOff(chipClusterPtr, callback, level, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void moveWithOnOff(DefaultClusterCallback callback
      , Integer moveMode, @Nullable Integer rate, Integer optionsMask, Integer optionsOverride) {
      moveWithOnOff(chipClusterPtr, callback, moveMode, rate, optionsMask, optionsOverride, null);
    }

    public void moveWithOnOff(DefaultClusterCallback callback
      , Integer moveMode, @Nullable Integer rate, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveWithOnOff(chipClusterPtr, callback, moveMode, rate, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void stepWithOnOff(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      stepWithOnOff(chipClusterPtr, callback, stepMode, stepSize, transitionTime, optionsMask, optionsOverride, null);
    }

    public void stepWithOnOff(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      stepWithOnOff(chipClusterPtr, callback, stepMode, stepSize, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void stopWithOnOff(DefaultClusterCallback callback
      , Integer optionsMask, Integer optionsOverride) {
      stopWithOnOff(chipClusterPtr, callback, optionsMask, optionsOverride, null);
    }

    public void stopWithOnOff(DefaultClusterCallback callback
      , Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      stopWithOnOff(chipClusterPtr, callback, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }
    private native void moveToLevel(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer level, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void move(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer moveMode, @Nullable Integer rate, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void step(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer stepMode, Integer stepSize, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void stop(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void moveToLevelWithOnOff(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer level, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void moveWithOnOff(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer moveMode, @Nullable Integer rate, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void stepWithOnOff(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer stepMode, Integer stepSize, @Nullable Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void stopWithOnOff(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface CurrentLevelAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface OnLevelAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface OnTransitionTimeAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface OffTransitionTimeAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface DefaultMoveRateAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface StartUpCurrentLevelAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readCurrentLevelAttribute(
      CurrentLevelAttributeCallback callback
    ) {
      readCurrentLevelAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentLevelAttribute(
        CurrentLevelAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCurrentLevelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRemainingTimeAttribute(
      IntegerAttributeCallback callback
    ) {
      readRemainingTimeAttribute(chipClusterPtr, callback);
    }
    public void subscribeRemainingTimeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRemainingTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinLevelAttribute(
      IntegerAttributeCallback callback
    ) {
      readMinLevelAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinLevelAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMinLevelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxLevelAttribute(
      IntegerAttributeCallback callback
    ) {
      readMaxLevelAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxLevelAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaxLevelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentFrequencyAttribute(
      IntegerAttributeCallback callback
    ) {
      readCurrentFrequencyAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentFrequencyAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentFrequencyAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinFrequencyAttribute(
      IntegerAttributeCallback callback
    ) {
      readMinFrequencyAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinFrequencyAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMinFrequencyAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxFrequencyAttribute(
      IntegerAttributeCallback callback
    ) {
      readMaxFrequencyAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxFrequencyAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaxFrequencyAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOptionsAttribute(
      IntegerAttributeCallback callback
    ) {
      readOptionsAttribute(chipClusterPtr, callback);
    }
    public void writeOptionsAttribute(DefaultClusterCallback callback, Integer value) {
      writeOptionsAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOptionsAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOptionsAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOptionsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOptionsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOnOffTransitionTimeAttribute(
      IntegerAttributeCallback callback
    ) {
      readOnOffTransitionTimeAttribute(chipClusterPtr, callback);
    }
    public void writeOnOffTransitionTimeAttribute(DefaultClusterCallback callback, Integer value) {
      writeOnOffTransitionTimeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOnOffTransitionTimeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOnOffTransitionTimeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOnOffTransitionTimeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOnOffTransitionTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOnLevelAttribute(
      OnLevelAttributeCallback callback
    ) {
      readOnLevelAttribute(chipClusterPtr, callback);
    }
    public void writeOnLevelAttribute(DefaultClusterCallback callback, Integer value) {
      writeOnLevelAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOnLevelAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOnLevelAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOnLevelAttribute(
        OnLevelAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeOnLevelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOnTransitionTimeAttribute(
      OnTransitionTimeAttributeCallback callback
    ) {
      readOnTransitionTimeAttribute(chipClusterPtr, callback);
    }
    public void writeOnTransitionTimeAttribute(DefaultClusterCallback callback, Integer value) {
      writeOnTransitionTimeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOnTransitionTimeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOnTransitionTimeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOnTransitionTimeAttribute(
        OnTransitionTimeAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeOnTransitionTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOffTransitionTimeAttribute(
      OffTransitionTimeAttributeCallback callback
    ) {
      readOffTransitionTimeAttribute(chipClusterPtr, callback);
    }
    public void writeOffTransitionTimeAttribute(DefaultClusterCallback callback, Integer value) {
      writeOffTransitionTimeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOffTransitionTimeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOffTransitionTimeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOffTransitionTimeAttribute(
        OffTransitionTimeAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeOffTransitionTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDefaultMoveRateAttribute(
      DefaultMoveRateAttributeCallback callback
    ) {
      readDefaultMoveRateAttribute(chipClusterPtr, callback);
    }
    public void writeDefaultMoveRateAttribute(DefaultClusterCallback callback, Integer value) {
      writeDefaultMoveRateAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeDefaultMoveRateAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeDefaultMoveRateAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeDefaultMoveRateAttribute(
        DefaultMoveRateAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeDefaultMoveRateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readStartUpCurrentLevelAttribute(
      StartUpCurrentLevelAttributeCallback callback
    ) {
      readStartUpCurrentLevelAttribute(chipClusterPtr, callback);
    }
    public void writeStartUpCurrentLevelAttribute(DefaultClusterCallback callback, Integer value) {
      writeStartUpCurrentLevelAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeStartUpCurrentLevelAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeStartUpCurrentLevelAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeStartUpCurrentLevelAttribute(
        StartUpCurrentLevelAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeStartUpCurrentLevelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readCurrentLevelAttribute(long chipClusterPtr,
        CurrentLevelAttributeCallback callback
    );
    private native void subscribeCurrentLevelAttribute(long chipClusterPtr,
        CurrentLevelAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readRemainingTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeRemainingTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMinLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMinLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMaxLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMaxLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentFrequencyAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCurrentFrequencyAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMinFrequencyAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMinFrequencyAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMaxFrequencyAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMaxFrequencyAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOptionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeOptionsAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOptionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOnOffTransitionTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeOnOffTransitionTimeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOnOffTransitionTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOnLevelAttribute(long chipClusterPtr,
        OnLevelAttributeCallback callback
    );

    private native void writeOnLevelAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOnLevelAttribute(long chipClusterPtr,
        OnLevelAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOnTransitionTimeAttribute(long chipClusterPtr,
        OnTransitionTimeAttributeCallback callback
    );

    private native void writeOnTransitionTimeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOnTransitionTimeAttribute(long chipClusterPtr,
        OnTransitionTimeAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOffTransitionTimeAttribute(long chipClusterPtr,
        OffTransitionTimeAttributeCallback callback
    );

    private native void writeOffTransitionTimeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOffTransitionTimeAttribute(long chipClusterPtr,
        OffTransitionTimeAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readDefaultMoveRateAttribute(long chipClusterPtr,
        DefaultMoveRateAttributeCallback callback
    );

    private native void writeDefaultMoveRateAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeDefaultMoveRateAttribute(long chipClusterPtr,
        DefaultMoveRateAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readStartUpCurrentLevelAttribute(long chipClusterPtr,
        StartUpCurrentLevelAttributeCallback callback
    );

    private native void writeStartUpCurrentLevelAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeStartUpCurrentLevelAttribute(long chipClusterPtr,
        StartUpCurrentLevelAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class BinaryInputBasicCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 15L;

    public BinaryInputBasicCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readActiveTextAttribute(
      CharStringAttributeCallback callback
    ) {
      readActiveTextAttribute(chipClusterPtr, callback);
    }
    public void writeActiveTextAttribute(DefaultClusterCallback callback, String value) {
      writeActiveTextAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeActiveTextAttribute(DefaultClusterCallback callback, String value, int timedWriteTimeoutMs) {
      writeActiveTextAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeActiveTextAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeActiveTextAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDescriptionAttribute(
      CharStringAttributeCallback callback
    ) {
      readDescriptionAttribute(chipClusterPtr, callback);
    }
    public void writeDescriptionAttribute(DefaultClusterCallback callback, String value) {
      writeDescriptionAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeDescriptionAttribute(DefaultClusterCallback callback, String value, int timedWriteTimeoutMs) {
      writeDescriptionAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeDescriptionAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDescriptionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInactiveTextAttribute(
      CharStringAttributeCallback callback
    ) {
      readInactiveTextAttribute(chipClusterPtr, callback);
    }
    public void writeInactiveTextAttribute(DefaultClusterCallback callback, String value) {
      writeInactiveTextAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeInactiveTextAttribute(DefaultClusterCallback callback, String value, int timedWriteTimeoutMs) {
      writeInactiveTextAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeInactiveTextAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInactiveTextAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOutOfServiceAttribute(
      BooleanAttributeCallback callback
    ) {
      readOutOfServiceAttribute(chipClusterPtr, callback);
    }
    public void writeOutOfServiceAttribute(DefaultClusterCallback callback, Boolean value) {
      writeOutOfServiceAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOutOfServiceAttribute(DefaultClusterCallback callback, Boolean value, int timedWriteTimeoutMs) {
      writeOutOfServiceAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOutOfServiceAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOutOfServiceAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPolarityAttribute(
      IntegerAttributeCallback callback
    ) {
      readPolarityAttribute(chipClusterPtr, callback);
    }
    public void subscribePolarityAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePolarityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPresentValueAttribute(
      BooleanAttributeCallback callback
    ) {
      readPresentValueAttribute(chipClusterPtr, callback);
    }
    public void writePresentValueAttribute(DefaultClusterCallback callback, Boolean value) {
      writePresentValueAttribute(chipClusterPtr, callback, value, null);
    }

    public void writePresentValueAttribute(DefaultClusterCallback callback, Boolean value, int timedWriteTimeoutMs) {
      writePresentValueAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribePresentValueAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePresentValueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readReliabilityAttribute(
      IntegerAttributeCallback callback
    ) {
      readReliabilityAttribute(chipClusterPtr, callback);
    }
    public void writeReliabilityAttribute(DefaultClusterCallback callback, Integer value) {
      writeReliabilityAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeReliabilityAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeReliabilityAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeReliabilityAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeReliabilityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readStatusFlagsAttribute(
      IntegerAttributeCallback callback
    ) {
      readStatusFlagsAttribute(chipClusterPtr, callback);
    }
    public void subscribeStatusFlagsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeStatusFlagsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readApplicationTypeAttribute(
      LongAttributeCallback callback
    ) {
      readApplicationTypeAttribute(chipClusterPtr, callback);
    }
    public void subscribeApplicationTypeAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeApplicationTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readActiveTextAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );

    private native void writeActiveTextAttribute(long chipClusterPtr, DefaultClusterCallback callback, String value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeActiveTextAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDescriptionAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );

    private native void writeDescriptionAttribute(long chipClusterPtr, DefaultClusterCallback callback, String value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeDescriptionAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInactiveTextAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );

    private native void writeInactiveTextAttribute(long chipClusterPtr, DefaultClusterCallback callback, String value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeInactiveTextAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOutOfServiceAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );

    private native void writeOutOfServiceAttribute(long chipClusterPtr, DefaultClusterCallback callback, Boolean value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOutOfServiceAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPolarityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePolarityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPresentValueAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );

    private native void writePresentValueAttribute(long chipClusterPtr, DefaultClusterCallback callback, Boolean value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribePresentValueAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readReliabilityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeReliabilityAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeReliabilityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readStatusFlagsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeStatusFlagsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readApplicationTypeAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeApplicationTypeAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class PulseWidthModulationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 28L;

    public PulseWidthModulationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class DescriptorCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 29L;

    public DescriptorCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface DeviceTypeListAttributeCallback {
        void onSuccess( List<ChipStructs.DescriptorClusterDeviceTypeStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ServerListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ClientListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface PartsListAttributeCallback {
        void onSuccess( List<Integer> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readDeviceTypeListAttribute(
      DeviceTypeListAttributeCallback callback
    ) {
      readDeviceTypeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeDeviceTypeListAttribute(
        DeviceTypeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeDeviceTypeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readServerListAttribute(
      ServerListAttributeCallback callback
    ) {
      readServerListAttribute(chipClusterPtr, callback);
    }
    public void subscribeServerListAttribute(
        ServerListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeServerListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClientListAttribute(
      ClientListAttributeCallback callback
    ) {
      readClientListAttribute(chipClusterPtr, callback);
    }
    public void subscribeClientListAttribute(
        ClientListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeClientListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPartsListAttribute(
      PartsListAttributeCallback callback
    ) {
      readPartsListAttribute(chipClusterPtr, callback);
    }
    public void subscribePartsListAttribute(
        PartsListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePartsListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readDeviceTypeListAttribute(long chipClusterPtr,
        DeviceTypeListAttributeCallback callback
    );
    private native void subscribeDeviceTypeListAttribute(long chipClusterPtr,
        DeviceTypeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readServerListAttribute(long chipClusterPtr,
        ServerListAttributeCallback callback
    );
    private native void subscribeServerListAttribute(long chipClusterPtr,
        ServerListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readClientListAttribute(long chipClusterPtr,
        ClientListAttributeCallback callback
    );
    private native void subscribeClientListAttribute(long chipClusterPtr,
        ClientListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPartsListAttribute(long chipClusterPtr,
        PartsListAttributeCallback callback
    );
    private native void subscribePartsListAttribute(long chipClusterPtr,
        PartsListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class BindingCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 30L;

    public BindingCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface BindingAttributeCallback {
        void onSuccess( List<ChipStructs.BindingClusterTargetStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readBindingAttribute(
      BindingAttributeCallback callback
    ) {
      readBindingAttribute(chipClusterPtr, callback);
    }
    public void writeBindingAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.BindingClusterTargetStruct> value) {
      writeBindingAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeBindingAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.BindingClusterTargetStruct> value, int timedWriteTimeoutMs) {
      writeBindingAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeBindingAttribute(
        BindingAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeBindingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readBindingAttribute(long chipClusterPtr,
        BindingAttributeCallback callback
    );

    private native void writeBindingAttribute(long chipClusterPtr, DefaultClusterCallback callback, ArrayList<ChipStructs.BindingClusterTargetStruct> value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeBindingAttribute(long chipClusterPtr,
        BindingAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class AccessControlCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 31L;

    public AccessControlCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface AclAttributeCallback {
        void onSuccess( List<ChipStructs.AccessControlClusterAccessControlEntryStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ExtensionAttributeCallback {
        void onSuccess( List<ChipStructs.AccessControlClusterAccessControlExtensionStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readAclAttribute(
      AclAttributeCallback callback
    ) {
      readAclAttribute(chipClusterPtr, callback);
    }
    public void writeAclAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.AccessControlClusterAccessControlEntryStruct> value) {
      writeAclAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeAclAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.AccessControlClusterAccessControlEntryStruct> value, int timedWriteTimeoutMs) {
      writeAclAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeAclAttribute(
        AclAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAclAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readExtensionAttribute(
      ExtensionAttributeCallback callback
    ) {
      readExtensionAttribute(chipClusterPtr, callback);
    }
    public void writeExtensionAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.AccessControlClusterAccessControlExtensionStruct> value) {
      writeExtensionAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeExtensionAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.AccessControlClusterAccessControlExtensionStruct> value, int timedWriteTimeoutMs) {
      writeExtensionAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeExtensionAttribute(
        ExtensionAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeExtensionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSubjectsPerAccessControlEntryAttribute(
      IntegerAttributeCallback callback
    ) {
      readSubjectsPerAccessControlEntryAttribute(chipClusterPtr, callback);
    }
    public void subscribeSubjectsPerAccessControlEntryAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSubjectsPerAccessControlEntryAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTargetsPerAccessControlEntryAttribute(
      IntegerAttributeCallback callback
    ) {
      readTargetsPerAccessControlEntryAttribute(chipClusterPtr, callback);
    }
    public void subscribeTargetsPerAccessControlEntryAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTargetsPerAccessControlEntryAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAccessControlEntriesPerFabricAttribute(
      IntegerAttributeCallback callback
    ) {
      readAccessControlEntriesPerFabricAttribute(chipClusterPtr, callback);
    }
    public void subscribeAccessControlEntriesPerFabricAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeAccessControlEntriesPerFabricAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readAclAttribute(long chipClusterPtr,
        AclAttributeCallback callback
    );

    private native void writeAclAttribute(long chipClusterPtr, DefaultClusterCallback callback, ArrayList<ChipStructs.AccessControlClusterAccessControlEntryStruct> value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeAclAttribute(long chipClusterPtr,
        AclAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readExtensionAttribute(long chipClusterPtr,
        ExtensionAttributeCallback callback
    );

    private native void writeExtensionAttribute(long chipClusterPtr, DefaultClusterCallback callback, ArrayList<ChipStructs.AccessControlClusterAccessControlExtensionStruct> value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeExtensionAttribute(long chipClusterPtr,
        ExtensionAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readSubjectsPerAccessControlEntryAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeSubjectsPerAccessControlEntryAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTargetsPerAccessControlEntryAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeTargetsPerAccessControlEntryAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readAccessControlEntriesPerFabricAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeAccessControlEntriesPerFabricAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ActionsCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 37L;

    public ActionsCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void instantAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID) {
      instantAction(chipClusterPtr, callback, actionID, invokeID, null);
    }

    public void instantAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID
      , int timedInvokeTimeoutMs) {
      instantAction(chipClusterPtr, callback, actionID, invokeID, timedInvokeTimeoutMs);
    }

    public void instantActionWithTransition(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID, Integer transitionTime) {
      instantActionWithTransition(chipClusterPtr, callback, actionID, invokeID, transitionTime, null);
    }

    public void instantActionWithTransition(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID, Integer transitionTime
      , int timedInvokeTimeoutMs) {
      instantActionWithTransition(chipClusterPtr, callback, actionID, invokeID, transitionTime, timedInvokeTimeoutMs);
    }

    public void startAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID) {
      startAction(chipClusterPtr, callback, actionID, invokeID, null);
    }

    public void startAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID
      , int timedInvokeTimeoutMs) {
      startAction(chipClusterPtr, callback, actionID, invokeID, timedInvokeTimeoutMs);
    }

    public void startActionWithDuration(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID, Long duration) {
      startActionWithDuration(chipClusterPtr, callback, actionID, invokeID, duration, null);
    }

    public void startActionWithDuration(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID, Long duration
      , int timedInvokeTimeoutMs) {
      startActionWithDuration(chipClusterPtr, callback, actionID, invokeID, duration, timedInvokeTimeoutMs);
    }

    public void stopAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID) {
      stopAction(chipClusterPtr, callback, actionID, invokeID, null);
    }

    public void stopAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID
      , int timedInvokeTimeoutMs) {
      stopAction(chipClusterPtr, callback, actionID, invokeID, timedInvokeTimeoutMs);
    }

    public void pauseAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID) {
      pauseAction(chipClusterPtr, callback, actionID, invokeID, null);
    }

    public void pauseAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID
      , int timedInvokeTimeoutMs) {
      pauseAction(chipClusterPtr, callback, actionID, invokeID, timedInvokeTimeoutMs);
    }

    public void pauseActionWithDuration(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID, Long duration) {
      pauseActionWithDuration(chipClusterPtr, callback, actionID, invokeID, duration, null);
    }

    public void pauseActionWithDuration(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID, Long duration
      , int timedInvokeTimeoutMs) {
      pauseActionWithDuration(chipClusterPtr, callback, actionID, invokeID, duration, timedInvokeTimeoutMs);
    }

    public void resumeAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID) {
      resumeAction(chipClusterPtr, callback, actionID, invokeID, null);
    }

    public void resumeAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID
      , int timedInvokeTimeoutMs) {
      resumeAction(chipClusterPtr, callback, actionID, invokeID, timedInvokeTimeoutMs);
    }

    public void enableAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID) {
      enableAction(chipClusterPtr, callback, actionID, invokeID, null);
    }

    public void enableAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID
      , int timedInvokeTimeoutMs) {
      enableAction(chipClusterPtr, callback, actionID, invokeID, timedInvokeTimeoutMs);
    }

    public void enableActionWithDuration(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID, Long duration) {
      enableActionWithDuration(chipClusterPtr, callback, actionID, invokeID, duration, null);
    }

    public void enableActionWithDuration(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID, Long duration
      , int timedInvokeTimeoutMs) {
      enableActionWithDuration(chipClusterPtr, callback, actionID, invokeID, duration, timedInvokeTimeoutMs);
    }

    public void disableAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID) {
      disableAction(chipClusterPtr, callback, actionID, invokeID, null);
    }

    public void disableAction(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID
      , int timedInvokeTimeoutMs) {
      disableAction(chipClusterPtr, callback, actionID, invokeID, timedInvokeTimeoutMs);
    }

    public void disableActionWithDuration(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID, Long duration) {
      disableActionWithDuration(chipClusterPtr, callback, actionID, invokeID, duration, null);
    }

    public void disableActionWithDuration(DefaultClusterCallback callback
      , Integer actionID, Optional<Long> invokeID, Long duration
      , int timedInvokeTimeoutMs) {
      disableActionWithDuration(chipClusterPtr, callback, actionID, invokeID, duration, timedInvokeTimeoutMs);
    }
    private native void instantAction(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void instantActionWithTransition(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID, Integer transitionTime
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void startAction(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void startActionWithDuration(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID, Long duration
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void stopAction(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void pauseAction(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void pauseActionWithDuration(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID, Long duration
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void resumeAction(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void enableAction(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void enableActionWithDuration(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID, Long duration
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void disableAction(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void disableActionWithDuration(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer actionID, Optional<Long> invokeID, Long duration
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface ActionListAttributeCallback {
        void onSuccess( List<ChipStructs.ActionsClusterActionStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EndpointListsAttributeCallback {
        void onSuccess( List<ChipStructs.ActionsClusterEndpointListStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readActionListAttribute(
      ActionListAttributeCallback callback
    ) {
      readActionListAttribute(chipClusterPtr, callback);
    }
    public void subscribeActionListAttribute(
        ActionListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeActionListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEndpointListsAttribute(
      EndpointListsAttributeCallback callback
    ) {
      readEndpointListsAttribute(chipClusterPtr, callback);
    }
    public void subscribeEndpointListsAttribute(
        EndpointListsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEndpointListsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSetupURLAttribute(
      CharStringAttributeCallback callback
    ) {
      readSetupURLAttribute(chipClusterPtr, callback);
    }
    public void subscribeSetupURLAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSetupURLAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readActionListAttribute(long chipClusterPtr,
        ActionListAttributeCallback callback
    );
    private native void subscribeActionListAttribute(long chipClusterPtr,
        ActionListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEndpointListsAttribute(long chipClusterPtr,
        EndpointListsAttributeCallback callback
    );
    private native void subscribeEndpointListsAttribute(long chipClusterPtr,
        EndpointListsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readSetupURLAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeSetupURLAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class BasicInformationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 40L;

    public BasicInformationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readDataModelRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDataModelRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDataModelRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDataModelRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readVendorNameAttribute(
      CharStringAttributeCallback callback
    ) {
      readVendorNameAttribute(chipClusterPtr, callback);
    }
    public void subscribeVendorNameAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeVendorNameAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readVendorIDAttribute(
      IntegerAttributeCallback callback
    ) {
      readVendorIDAttribute(chipClusterPtr, callback);
    }
    public void subscribeVendorIDAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeVendorIDAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readProductNameAttribute(
      CharStringAttributeCallback callback
    ) {
      readProductNameAttribute(chipClusterPtr, callback);
    }
    public void subscribeProductNameAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeProductNameAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readProductIDAttribute(
      IntegerAttributeCallback callback
    ) {
      readProductIDAttribute(chipClusterPtr, callback);
    }
    public void subscribeProductIDAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeProductIDAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNodeLabelAttribute(
      CharStringAttributeCallback callback
    ) {
      readNodeLabelAttribute(chipClusterPtr, callback);
    }
    public void writeNodeLabelAttribute(DefaultClusterCallback callback, String value) {
      writeNodeLabelAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeNodeLabelAttribute(DefaultClusterCallback callback, String value, int timedWriteTimeoutMs) {
      writeNodeLabelAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeNodeLabelAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNodeLabelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLocationAttribute(
      CharStringAttributeCallback callback
    ) {
      readLocationAttribute(chipClusterPtr, callback);
    }
    public void writeLocationAttribute(DefaultClusterCallback callback, String value) {
      writeLocationAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLocationAttribute(DefaultClusterCallback callback, String value, int timedWriteTimeoutMs) {
      writeLocationAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLocationAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLocationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readHardwareVersionAttribute(
      IntegerAttributeCallback callback
    ) {
      readHardwareVersionAttribute(chipClusterPtr, callback);
    }
    public void subscribeHardwareVersionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeHardwareVersionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readHardwareVersionStringAttribute(
      CharStringAttributeCallback callback
    ) {
      readHardwareVersionStringAttribute(chipClusterPtr, callback);
    }
    public void subscribeHardwareVersionStringAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeHardwareVersionStringAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSoftwareVersionAttribute(
      LongAttributeCallback callback
    ) {
      readSoftwareVersionAttribute(chipClusterPtr, callback);
    }
    public void subscribeSoftwareVersionAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSoftwareVersionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSoftwareVersionStringAttribute(
      CharStringAttributeCallback callback
    ) {
      readSoftwareVersionStringAttribute(chipClusterPtr, callback);
    }
    public void subscribeSoftwareVersionStringAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSoftwareVersionStringAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readManufacturingDateAttribute(
      CharStringAttributeCallback callback
    ) {
      readManufacturingDateAttribute(chipClusterPtr, callback);
    }
    public void subscribeManufacturingDateAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeManufacturingDateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPartNumberAttribute(
      CharStringAttributeCallback callback
    ) {
      readPartNumberAttribute(chipClusterPtr, callback);
    }
    public void subscribePartNumberAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePartNumberAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readProductURLAttribute(
      CharStringAttributeCallback callback
    ) {
      readProductURLAttribute(chipClusterPtr, callback);
    }
    public void subscribeProductURLAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeProductURLAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readProductLabelAttribute(
      CharStringAttributeCallback callback
    ) {
      readProductLabelAttribute(chipClusterPtr, callback);
    }
    public void subscribeProductLabelAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeProductLabelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSerialNumberAttribute(
      CharStringAttributeCallback callback
    ) {
      readSerialNumberAttribute(chipClusterPtr, callback);
    }
    public void subscribeSerialNumberAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSerialNumberAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLocalConfigDisabledAttribute(
      BooleanAttributeCallback callback
    ) {
      readLocalConfigDisabledAttribute(chipClusterPtr, callback);
    }
    public void writeLocalConfigDisabledAttribute(DefaultClusterCallback callback, Boolean value) {
      writeLocalConfigDisabledAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLocalConfigDisabledAttribute(DefaultClusterCallback callback, Boolean value, int timedWriteTimeoutMs) {
      writeLocalConfigDisabledAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLocalConfigDisabledAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLocalConfigDisabledAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readReachableAttribute(
      BooleanAttributeCallback callback
    ) {
      readReachableAttribute(chipClusterPtr, callback);
    }
    public void subscribeReachableAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeReachableAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUniqueIDAttribute(
      CharStringAttributeCallback callback
    ) {
      readUniqueIDAttribute(chipClusterPtr, callback);
    }
    public void subscribeUniqueIDAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeUniqueIDAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readDataModelRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDataModelRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readVendorNameAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeVendorNameAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readVendorIDAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeVendorIDAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readProductNameAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeProductNameAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readProductIDAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeProductIDAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNodeLabelAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );

    private native void writeNodeLabelAttribute(long chipClusterPtr, DefaultClusterCallback callback, String value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeNodeLabelAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLocationAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );

    private native void writeLocationAttribute(long chipClusterPtr, DefaultClusterCallback callback, String value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLocationAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readHardwareVersionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeHardwareVersionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readHardwareVersionStringAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeHardwareVersionStringAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSoftwareVersionAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeSoftwareVersionAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSoftwareVersionStringAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeSoftwareVersionStringAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readManufacturingDateAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeManufacturingDateAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPartNumberAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribePartNumberAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readProductURLAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeProductURLAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readProductLabelAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeProductLabelAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSerialNumberAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeSerialNumberAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLocalConfigDisabledAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );

    private native void writeLocalConfigDisabledAttribute(long chipClusterPtr, DefaultClusterCallback callback, Boolean value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLocalConfigDisabledAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readReachableAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeReachableAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readUniqueIDAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeUniqueIDAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class OtaSoftwareUpdateProviderCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 41L;

    public OtaSoftwareUpdateProviderCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void queryImage(QueryImageResponseCallback callback
      , Integer vendorID, Integer productID, Long softwareVersion, ArrayList<Integer> protocolsSupported, Optional<Integer> hardwareVersion, Optional<String> location, Optional<Boolean> requestorCanConsent, Optional<byte[]> metadataForProvider) {
      queryImage(chipClusterPtr, callback, vendorID, productID, softwareVersion, protocolsSupported, hardwareVersion, location, requestorCanConsent, metadataForProvider, null);
    }

    public void queryImage(QueryImageResponseCallback callback
      , Integer vendorID, Integer productID, Long softwareVersion, ArrayList<Integer> protocolsSupported, Optional<Integer> hardwareVersion, Optional<String> location, Optional<Boolean> requestorCanConsent, Optional<byte[]> metadataForProvider
      , int timedInvokeTimeoutMs) {
      queryImage(chipClusterPtr, callback, vendorID, productID, softwareVersion, protocolsSupported, hardwareVersion, location, requestorCanConsent, metadataForProvider, timedInvokeTimeoutMs);
    }

    public void applyUpdateRequest(ApplyUpdateResponseCallback callback
      , byte[] updateToken, Long newVersion) {
      applyUpdateRequest(chipClusterPtr, callback, updateToken, newVersion, null);
    }

    public void applyUpdateRequest(ApplyUpdateResponseCallback callback
      , byte[] updateToken, Long newVersion
      , int timedInvokeTimeoutMs) {
      applyUpdateRequest(chipClusterPtr, callback, updateToken, newVersion, timedInvokeTimeoutMs);
    }

    public void notifyUpdateApplied(DefaultClusterCallback callback
      , byte[] updateToken, Long softwareVersion) {
      notifyUpdateApplied(chipClusterPtr, callback, updateToken, softwareVersion, null);
    }

    public void notifyUpdateApplied(DefaultClusterCallback callback
      , byte[] updateToken, Long softwareVersion
      , int timedInvokeTimeoutMs) {
      notifyUpdateApplied(chipClusterPtr, callback, updateToken, softwareVersion, timedInvokeTimeoutMs);
    }
    private native void queryImage(long chipClusterPtr, QueryImageResponseCallback Callback
      , Integer vendorID, Integer productID, Long softwareVersion, ArrayList<Integer> protocolsSupported, Optional<Integer> hardwareVersion, Optional<String> location, Optional<Boolean> requestorCanConsent, Optional<byte[]> metadataForProvider
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void applyUpdateRequest(long chipClusterPtr, ApplyUpdateResponseCallback Callback
      , byte[] updateToken, Long newVersion
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void notifyUpdateApplied(long chipClusterPtr, DefaultClusterCallback Callback
      , byte[] updateToken, Long softwareVersion
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface QueryImageResponseCallback {
      void onSuccess(Integer status, Optional<Long> delayedActionTime, Optional<String> imageURI, Optional<Long> softwareVersion, Optional<String> softwareVersionString, Optional<byte[]> updateToken, Optional<Boolean> userConsentNeeded, Optional<byte[]> metadataForRequestor);
      
      void onError(Exception error);
    }

    public interface ApplyUpdateResponseCallback {
      void onSuccess(Integer action, Long delayedActionTime);
      
      void onError(Exception error);
    }


      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class OtaSoftwareUpdateRequestorCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 42L;

    public OtaSoftwareUpdateRequestorCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void announceOTAProvider(DefaultClusterCallback callback
      , Long providerNodeID, Integer vendorID, Integer announcementReason, Optional<byte[]> metadataForNode, Integer endpoint) {
      announceOTAProvider(chipClusterPtr, callback, providerNodeID, vendorID, announcementReason, metadataForNode, endpoint, null);
    }

    public void announceOTAProvider(DefaultClusterCallback callback
      , Long providerNodeID, Integer vendorID, Integer announcementReason, Optional<byte[]> metadataForNode, Integer endpoint
      , int timedInvokeTimeoutMs) {
      announceOTAProvider(chipClusterPtr, callback, providerNodeID, vendorID, announcementReason, metadataForNode, endpoint, timedInvokeTimeoutMs);
    }
    private native void announceOTAProvider(long chipClusterPtr, DefaultClusterCallback Callback
      , Long providerNodeID, Integer vendorID, Integer announcementReason, Optional<byte[]> metadataForNode, Integer endpoint
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface DefaultOTAProvidersAttributeCallback {
        void onSuccess( List<ChipStructs.OtaSoftwareUpdateRequestorClusterProviderLocation> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface UpdateStateProgressAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readDefaultOTAProvidersAttribute(
      DefaultOTAProvidersAttributeCallback callback
    ) {
      readDefaultOTAProvidersAttribute(chipClusterPtr, callback);
    }
    public void writeDefaultOTAProvidersAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.OtaSoftwareUpdateRequestorClusterProviderLocation> value) {
      writeDefaultOTAProvidersAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeDefaultOTAProvidersAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.OtaSoftwareUpdateRequestorClusterProviderLocation> value, int timedWriteTimeoutMs) {
      writeDefaultOTAProvidersAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeDefaultOTAProvidersAttribute(
        DefaultOTAProvidersAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeDefaultOTAProvidersAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUpdatePossibleAttribute(
      BooleanAttributeCallback callback
    ) {
      readUpdatePossibleAttribute(chipClusterPtr, callback);
    }
    public void subscribeUpdatePossibleAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeUpdatePossibleAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUpdateStateAttribute(
      IntegerAttributeCallback callback
    ) {
      readUpdateStateAttribute(chipClusterPtr, callback);
    }
    public void subscribeUpdateStateAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeUpdateStateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUpdateStateProgressAttribute(
      UpdateStateProgressAttributeCallback callback
    ) {
      readUpdateStateProgressAttribute(chipClusterPtr, callback);
    }
    public void subscribeUpdateStateProgressAttribute(
        UpdateStateProgressAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeUpdateStateProgressAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readDefaultOTAProvidersAttribute(long chipClusterPtr,
        DefaultOTAProvidersAttributeCallback callback
    );

    private native void writeDefaultOTAProvidersAttribute(long chipClusterPtr, DefaultClusterCallback callback, ArrayList<ChipStructs.OtaSoftwareUpdateRequestorClusterProviderLocation> value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeDefaultOTAProvidersAttribute(long chipClusterPtr,
        DefaultOTAProvidersAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readUpdatePossibleAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeUpdatePossibleAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readUpdateStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeUpdateStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readUpdateStateProgressAttribute(long chipClusterPtr,
        UpdateStateProgressAttributeCallback callback
    );
    private native void subscribeUpdateStateProgressAttribute(long chipClusterPtr,
        UpdateStateProgressAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class LocalizationConfigurationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 43L;

    public LocalizationConfigurationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface SupportedLocalesAttributeCallback {
        void onSuccess( List<String> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readActiveLocaleAttribute(
      CharStringAttributeCallback callback
    ) {
      readActiveLocaleAttribute(chipClusterPtr, callback);
    }
    public void writeActiveLocaleAttribute(DefaultClusterCallback callback, String value) {
      writeActiveLocaleAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeActiveLocaleAttribute(DefaultClusterCallback callback, String value, int timedWriteTimeoutMs) {
      writeActiveLocaleAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeActiveLocaleAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeActiveLocaleAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSupportedLocalesAttribute(
      SupportedLocalesAttributeCallback callback
    ) {
      readSupportedLocalesAttribute(chipClusterPtr, callback);
    }
    public void subscribeSupportedLocalesAttribute(
        SupportedLocalesAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeSupportedLocalesAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readActiveLocaleAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );

    private native void writeActiveLocaleAttribute(long chipClusterPtr, DefaultClusterCallback callback, String value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeActiveLocaleAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSupportedLocalesAttribute(long chipClusterPtr,
        SupportedLocalesAttributeCallback callback
    );
    private native void subscribeSupportedLocalesAttribute(long chipClusterPtr,
        SupportedLocalesAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class TimeFormatLocalizationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 44L;

    public TimeFormatLocalizationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface SupportedCalendarTypesAttributeCallback {
        void onSuccess( List<Integer> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readHourFormatAttribute(
      IntegerAttributeCallback callback
    ) {
      readHourFormatAttribute(chipClusterPtr, callback);
    }
    public void writeHourFormatAttribute(DefaultClusterCallback callback, Integer value) {
      writeHourFormatAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeHourFormatAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeHourFormatAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeHourFormatAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeHourFormatAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActiveCalendarTypeAttribute(
      IntegerAttributeCallback callback
    ) {
      readActiveCalendarTypeAttribute(chipClusterPtr, callback);
    }
    public void writeActiveCalendarTypeAttribute(DefaultClusterCallback callback, Integer value) {
      writeActiveCalendarTypeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeActiveCalendarTypeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeActiveCalendarTypeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeActiveCalendarTypeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeActiveCalendarTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSupportedCalendarTypesAttribute(
      SupportedCalendarTypesAttributeCallback callback
    ) {
      readSupportedCalendarTypesAttribute(chipClusterPtr, callback);
    }
    public void subscribeSupportedCalendarTypesAttribute(
        SupportedCalendarTypesAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeSupportedCalendarTypesAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readHourFormatAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeHourFormatAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeHourFormatAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readActiveCalendarTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeActiveCalendarTypeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeActiveCalendarTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSupportedCalendarTypesAttribute(long chipClusterPtr,
        SupportedCalendarTypesAttributeCallback callback
    );
    private native void subscribeSupportedCalendarTypesAttribute(long chipClusterPtr,
        SupportedCalendarTypesAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class UnitLocalizationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 45L;

    public UnitLocalizationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readTemperatureUnitAttribute(
      IntegerAttributeCallback callback
    ) {
      readTemperatureUnitAttribute(chipClusterPtr, callback);
    }
    public void writeTemperatureUnitAttribute(DefaultClusterCallback callback, Integer value) {
      writeTemperatureUnitAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeTemperatureUnitAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeTemperatureUnitAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeTemperatureUnitAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTemperatureUnitAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readTemperatureUnitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeTemperatureUnitAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeTemperatureUnitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class PowerSourceConfigurationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 46L;

    public PowerSourceConfigurationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface SourcesAttributeCallback {
        void onSuccess( List<Integer> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readSourcesAttribute(
      SourcesAttributeCallback callback
    ) {
      readSourcesAttribute(chipClusterPtr, callback);
    }
    public void subscribeSourcesAttribute(
        SourcesAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeSourcesAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readSourcesAttribute(long chipClusterPtr,
        SourcesAttributeCallback callback
    );
    private native void subscribeSourcesAttribute(long chipClusterPtr,
        SourcesAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class PowerSourceCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 47L;

    public PowerSourceCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface WiredAssessedInputVoltageAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface WiredAssessedInputFrequencyAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface WiredAssessedCurrentAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ActiveWiredFaultsAttributeCallback {
        void onSuccess( List<Integer> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface BatVoltageAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface BatPercentRemainingAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface BatTimeRemainingAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ActiveBatFaultsAttributeCallback {
        void onSuccess( List<Integer> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface BatTimeToFullChargeAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface BatChargingCurrentAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ActiveBatChargeFaultsAttributeCallback {
        void onSuccess( List<Integer> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readStatusAttribute(
      IntegerAttributeCallback callback
    ) {
      readStatusAttribute(chipClusterPtr, callback);
    }
    public void subscribeStatusAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeStatusAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOrderAttribute(
      IntegerAttributeCallback callback
    ) {
      readOrderAttribute(chipClusterPtr, callback);
    }
    public void subscribeOrderAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOrderAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDescriptionAttribute(
      CharStringAttributeCallback callback
    ) {
      readDescriptionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDescriptionAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDescriptionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWiredAssessedInputVoltageAttribute(
      WiredAssessedInputVoltageAttributeCallback callback
    ) {
      readWiredAssessedInputVoltageAttribute(chipClusterPtr, callback);
    }
    public void subscribeWiredAssessedInputVoltageAttribute(
        WiredAssessedInputVoltageAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeWiredAssessedInputVoltageAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWiredAssessedInputFrequencyAttribute(
      WiredAssessedInputFrequencyAttributeCallback callback
    ) {
      readWiredAssessedInputFrequencyAttribute(chipClusterPtr, callback);
    }
    public void subscribeWiredAssessedInputFrequencyAttribute(
        WiredAssessedInputFrequencyAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeWiredAssessedInputFrequencyAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWiredCurrentTypeAttribute(
      IntegerAttributeCallback callback
    ) {
      readWiredCurrentTypeAttribute(chipClusterPtr, callback);
    }
    public void subscribeWiredCurrentTypeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeWiredCurrentTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWiredAssessedCurrentAttribute(
      WiredAssessedCurrentAttributeCallback callback
    ) {
      readWiredAssessedCurrentAttribute(chipClusterPtr, callback);
    }
    public void subscribeWiredAssessedCurrentAttribute(
        WiredAssessedCurrentAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeWiredAssessedCurrentAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWiredNominalVoltageAttribute(
      LongAttributeCallback callback
    ) {
      readWiredNominalVoltageAttribute(chipClusterPtr, callback);
    }
    public void subscribeWiredNominalVoltageAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeWiredNominalVoltageAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWiredMaximumCurrentAttribute(
      LongAttributeCallback callback
    ) {
      readWiredMaximumCurrentAttribute(chipClusterPtr, callback);
    }
    public void subscribeWiredMaximumCurrentAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeWiredMaximumCurrentAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWiredPresentAttribute(
      BooleanAttributeCallback callback
    ) {
      readWiredPresentAttribute(chipClusterPtr, callback);
    }
    public void subscribeWiredPresentAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeWiredPresentAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActiveWiredFaultsAttribute(
      ActiveWiredFaultsAttributeCallback callback
    ) {
      readActiveWiredFaultsAttribute(chipClusterPtr, callback);
    }
    public void subscribeActiveWiredFaultsAttribute(
        ActiveWiredFaultsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeActiveWiredFaultsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatVoltageAttribute(
      BatVoltageAttributeCallback callback
    ) {
      readBatVoltageAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatVoltageAttribute(
        BatVoltageAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeBatVoltageAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatPercentRemainingAttribute(
      BatPercentRemainingAttributeCallback callback
    ) {
      readBatPercentRemainingAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatPercentRemainingAttribute(
        BatPercentRemainingAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeBatPercentRemainingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatTimeRemainingAttribute(
      BatTimeRemainingAttributeCallback callback
    ) {
      readBatTimeRemainingAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatTimeRemainingAttribute(
        BatTimeRemainingAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeBatTimeRemainingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatChargeLevelAttribute(
      IntegerAttributeCallback callback
    ) {
      readBatChargeLevelAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatChargeLevelAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatChargeLevelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatReplacementNeededAttribute(
      BooleanAttributeCallback callback
    ) {
      readBatReplacementNeededAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatReplacementNeededAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatReplacementNeededAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatReplaceabilityAttribute(
      IntegerAttributeCallback callback
    ) {
      readBatReplaceabilityAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatReplaceabilityAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatReplaceabilityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatPresentAttribute(
      BooleanAttributeCallback callback
    ) {
      readBatPresentAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatPresentAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatPresentAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActiveBatFaultsAttribute(
      ActiveBatFaultsAttributeCallback callback
    ) {
      readActiveBatFaultsAttribute(chipClusterPtr, callback);
    }
    public void subscribeActiveBatFaultsAttribute(
        ActiveBatFaultsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeActiveBatFaultsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatReplacementDescriptionAttribute(
      CharStringAttributeCallback callback
    ) {
      readBatReplacementDescriptionAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatReplacementDescriptionAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatReplacementDescriptionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatCommonDesignationAttribute(
      IntegerAttributeCallback callback
    ) {
      readBatCommonDesignationAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatCommonDesignationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatCommonDesignationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatANSIDesignationAttribute(
      CharStringAttributeCallback callback
    ) {
      readBatANSIDesignationAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatANSIDesignationAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatANSIDesignationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatIECDesignationAttribute(
      CharStringAttributeCallback callback
    ) {
      readBatIECDesignationAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatIECDesignationAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatIECDesignationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatApprovedChemistryAttribute(
      IntegerAttributeCallback callback
    ) {
      readBatApprovedChemistryAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatApprovedChemistryAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatApprovedChemistryAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatCapacityAttribute(
      LongAttributeCallback callback
    ) {
      readBatCapacityAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatCapacityAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatCapacityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatQuantityAttribute(
      IntegerAttributeCallback callback
    ) {
      readBatQuantityAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatQuantityAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatQuantityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatChargeStateAttribute(
      IntegerAttributeCallback callback
    ) {
      readBatChargeStateAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatChargeStateAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatChargeStateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatTimeToFullChargeAttribute(
      BatTimeToFullChargeAttributeCallback callback
    ) {
      readBatTimeToFullChargeAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatTimeToFullChargeAttribute(
        BatTimeToFullChargeAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeBatTimeToFullChargeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatFunctionalWhileChargingAttribute(
      BooleanAttributeCallback callback
    ) {
      readBatFunctionalWhileChargingAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatFunctionalWhileChargingAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatFunctionalWhileChargingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatChargingCurrentAttribute(
      BatChargingCurrentAttributeCallback callback
    ) {
      readBatChargingCurrentAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatChargingCurrentAttribute(
        BatChargingCurrentAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeBatChargingCurrentAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActiveBatChargeFaultsAttribute(
      ActiveBatChargeFaultsAttributeCallback callback
    ) {
      readActiveBatChargeFaultsAttribute(chipClusterPtr, callback);
    }
    public void subscribeActiveBatChargeFaultsAttribute(
        ActiveBatChargeFaultsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeActiveBatChargeFaultsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOrderAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeOrderAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDescriptionAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeDescriptionAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readWiredAssessedInputVoltageAttribute(long chipClusterPtr,
        WiredAssessedInputVoltageAttributeCallback callback
    );
    private native void subscribeWiredAssessedInputVoltageAttribute(long chipClusterPtr,
        WiredAssessedInputVoltageAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readWiredAssessedInputFrequencyAttribute(long chipClusterPtr,
        WiredAssessedInputFrequencyAttributeCallback callback
    );
    private native void subscribeWiredAssessedInputFrequencyAttribute(long chipClusterPtr,
        WiredAssessedInputFrequencyAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readWiredCurrentTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeWiredCurrentTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readWiredAssessedCurrentAttribute(long chipClusterPtr,
        WiredAssessedCurrentAttributeCallback callback
    );
    private native void subscribeWiredAssessedCurrentAttribute(long chipClusterPtr,
        WiredAssessedCurrentAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readWiredNominalVoltageAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeWiredNominalVoltageAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readWiredMaximumCurrentAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeWiredMaximumCurrentAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readWiredPresentAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeWiredPresentAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readActiveWiredFaultsAttribute(long chipClusterPtr,
        ActiveWiredFaultsAttributeCallback callback
    );
    private native void subscribeActiveWiredFaultsAttribute(long chipClusterPtr,
        ActiveWiredFaultsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readBatVoltageAttribute(long chipClusterPtr,
        BatVoltageAttributeCallback callback
    );
    private native void subscribeBatVoltageAttribute(long chipClusterPtr,
        BatVoltageAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readBatPercentRemainingAttribute(long chipClusterPtr,
        BatPercentRemainingAttributeCallback callback
    );
    private native void subscribeBatPercentRemainingAttribute(long chipClusterPtr,
        BatPercentRemainingAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readBatTimeRemainingAttribute(long chipClusterPtr,
        BatTimeRemainingAttributeCallback callback
    );
    private native void subscribeBatTimeRemainingAttribute(long chipClusterPtr,
        BatTimeRemainingAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readBatChargeLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBatChargeLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatReplacementNeededAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeBatReplacementNeededAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatReplaceabilityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBatReplaceabilityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatPresentAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeBatPresentAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readActiveBatFaultsAttribute(long chipClusterPtr,
        ActiveBatFaultsAttributeCallback callback
    );
    private native void subscribeActiveBatFaultsAttribute(long chipClusterPtr,
        ActiveBatFaultsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readBatReplacementDescriptionAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeBatReplacementDescriptionAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatCommonDesignationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBatCommonDesignationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatANSIDesignationAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeBatANSIDesignationAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatIECDesignationAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeBatIECDesignationAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatApprovedChemistryAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBatApprovedChemistryAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatCapacityAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeBatCapacityAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatQuantityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBatQuantityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatChargeStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBatChargeStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatTimeToFullChargeAttribute(long chipClusterPtr,
        BatTimeToFullChargeAttributeCallback callback
    );
    private native void subscribeBatTimeToFullChargeAttribute(long chipClusterPtr,
        BatTimeToFullChargeAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readBatFunctionalWhileChargingAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeBatFunctionalWhileChargingAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatChargingCurrentAttribute(long chipClusterPtr,
        BatChargingCurrentAttributeCallback callback
    );
    private native void subscribeBatChargingCurrentAttribute(long chipClusterPtr,
        BatChargingCurrentAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readActiveBatChargeFaultsAttribute(long chipClusterPtr,
        ActiveBatChargeFaultsAttributeCallback callback
    );
    private native void subscribeActiveBatChargeFaultsAttribute(long chipClusterPtr,
        ActiveBatChargeFaultsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class GeneralCommissioningCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 48L;

    public GeneralCommissioningCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void armFailSafe(ArmFailSafeResponseCallback callback
      , Integer expiryLengthSeconds, Long breadcrumb) {
      armFailSafe(chipClusterPtr, callback, expiryLengthSeconds, breadcrumb, null);
    }

    public void armFailSafe(ArmFailSafeResponseCallback callback
      , Integer expiryLengthSeconds, Long breadcrumb
      , int timedInvokeTimeoutMs) {
      armFailSafe(chipClusterPtr, callback, expiryLengthSeconds, breadcrumb, timedInvokeTimeoutMs);
    }

    public void setRegulatoryConfig(SetRegulatoryConfigResponseCallback callback
      , Integer newRegulatoryConfig, String countryCode, Long breadcrumb) {
      setRegulatoryConfig(chipClusterPtr, callback, newRegulatoryConfig, countryCode, breadcrumb, null);
    }

    public void setRegulatoryConfig(SetRegulatoryConfigResponseCallback callback
      , Integer newRegulatoryConfig, String countryCode, Long breadcrumb
      , int timedInvokeTimeoutMs) {
      setRegulatoryConfig(chipClusterPtr, callback, newRegulatoryConfig, countryCode, breadcrumb, timedInvokeTimeoutMs);
    }

    public void commissioningComplete(CommissioningCompleteResponseCallback callback
      ) {
      commissioningComplete(chipClusterPtr, callback, null);
    }

    public void commissioningComplete(CommissioningCompleteResponseCallback callback
      
      , int timedInvokeTimeoutMs) {
      commissioningComplete(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }
    private native void armFailSafe(long chipClusterPtr, ArmFailSafeResponseCallback Callback
      , Integer expiryLengthSeconds, Long breadcrumb
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void setRegulatoryConfig(long chipClusterPtr, SetRegulatoryConfigResponseCallback Callback
      , Integer newRegulatoryConfig, String countryCode, Long breadcrumb
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void commissioningComplete(long chipClusterPtr, CommissioningCompleteResponseCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface ArmFailSafeResponseCallback {
      void onSuccess(Integer errorCode, String debugText);
      
      void onError(Exception error);
    }

    public interface SetRegulatoryConfigResponseCallback {
      void onSuccess(Integer errorCode, String debugText);
      
      void onError(Exception error);
    }

    public interface CommissioningCompleteResponseCallback {
      void onSuccess(Integer errorCode, String debugText);
      
      void onError(Exception error);
    }


      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readBreadcrumbAttribute(
      LongAttributeCallback callback
    ) {
      readBreadcrumbAttribute(chipClusterPtr, callback);
    }
    public void writeBreadcrumbAttribute(DefaultClusterCallback callback, Long value) {
      writeBreadcrumbAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeBreadcrumbAttribute(DefaultClusterCallback callback, Long value, int timedWriteTimeoutMs) {
      writeBreadcrumbAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeBreadcrumbAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBreadcrumbAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRegulatoryConfigAttribute(
      IntegerAttributeCallback callback
    ) {
      readRegulatoryConfigAttribute(chipClusterPtr, callback);
    }
    public void subscribeRegulatoryConfigAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRegulatoryConfigAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLocationCapabilityAttribute(
      IntegerAttributeCallback callback
    ) {
      readLocationCapabilityAttribute(chipClusterPtr, callback);
    }
    public void subscribeLocationCapabilityAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLocationCapabilityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSupportsConcurrentConnectionAttribute(
      BooleanAttributeCallback callback
    ) {
      readSupportsConcurrentConnectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeSupportsConcurrentConnectionAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSupportsConcurrentConnectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readBreadcrumbAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );

    private native void writeBreadcrumbAttribute(long chipClusterPtr, DefaultClusterCallback callback, Long value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeBreadcrumbAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRegulatoryConfigAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeRegulatoryConfigAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLocationCapabilityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeLocationCapabilityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSupportsConcurrentConnectionAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeSupportsConcurrentConnectionAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class NetworkCommissioningCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 49L;

    public NetworkCommissioningCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void scanNetworks(ScanNetworksResponseCallback callback
      , @Nullable Optional<byte[]> ssid, Optional<Long> breadcrumb) {
      scanNetworks(chipClusterPtr, callback, ssid, breadcrumb, null);
    }

    public void scanNetworks(ScanNetworksResponseCallback callback
      , @Nullable Optional<byte[]> ssid, Optional<Long> breadcrumb
      , int timedInvokeTimeoutMs) {
      scanNetworks(chipClusterPtr, callback, ssid, breadcrumb, timedInvokeTimeoutMs);
    }

    public void addOrUpdateWiFiNetwork(NetworkConfigResponseCallback callback
      , byte[] ssid, byte[] credentials, Optional<Long> breadcrumb) {
      addOrUpdateWiFiNetwork(chipClusterPtr, callback, ssid, credentials, breadcrumb, null);
    }

    public void addOrUpdateWiFiNetwork(NetworkConfigResponseCallback callback
      , byte[] ssid, byte[] credentials, Optional<Long> breadcrumb
      , int timedInvokeTimeoutMs) {
      addOrUpdateWiFiNetwork(chipClusterPtr, callback, ssid, credentials, breadcrumb, timedInvokeTimeoutMs);
    }

    public void addOrUpdateThreadNetwork(NetworkConfigResponseCallback callback
      , byte[] operationalDataset, Optional<Long> breadcrumb) {
      addOrUpdateThreadNetwork(chipClusterPtr, callback, operationalDataset, breadcrumb, null);
    }

    public void addOrUpdateThreadNetwork(NetworkConfigResponseCallback callback
      , byte[] operationalDataset, Optional<Long> breadcrumb
      , int timedInvokeTimeoutMs) {
      addOrUpdateThreadNetwork(chipClusterPtr, callback, operationalDataset, breadcrumb, timedInvokeTimeoutMs);
    }

    public void removeNetwork(NetworkConfigResponseCallback callback
      , byte[] networkID, Optional<Long> breadcrumb) {
      removeNetwork(chipClusterPtr, callback, networkID, breadcrumb, null);
    }

    public void removeNetwork(NetworkConfigResponseCallback callback
      , byte[] networkID, Optional<Long> breadcrumb
      , int timedInvokeTimeoutMs) {
      removeNetwork(chipClusterPtr, callback, networkID, breadcrumb, timedInvokeTimeoutMs);
    }

    public void connectNetwork(ConnectNetworkResponseCallback callback
      , byte[] networkID, Optional<Long> breadcrumb) {
      connectNetwork(chipClusterPtr, callback, networkID, breadcrumb, null);
    }

    public void connectNetwork(ConnectNetworkResponseCallback callback
      , byte[] networkID, Optional<Long> breadcrumb
      , int timedInvokeTimeoutMs) {
      connectNetwork(chipClusterPtr, callback, networkID, breadcrumb, timedInvokeTimeoutMs);
    }

    public void reorderNetwork(NetworkConfigResponseCallback callback
      , byte[] networkID, Integer networkIndex, Optional<Long> breadcrumb) {
      reorderNetwork(chipClusterPtr, callback, networkID, networkIndex, breadcrumb, null);
    }

    public void reorderNetwork(NetworkConfigResponseCallback callback
      , byte[] networkID, Integer networkIndex, Optional<Long> breadcrumb
      , int timedInvokeTimeoutMs) {
      reorderNetwork(chipClusterPtr, callback, networkID, networkIndex, breadcrumb, timedInvokeTimeoutMs);
    }
    private native void scanNetworks(long chipClusterPtr, ScanNetworksResponseCallback Callback
      , @Nullable Optional<byte[]> ssid, Optional<Long> breadcrumb
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void addOrUpdateWiFiNetwork(long chipClusterPtr, NetworkConfigResponseCallback Callback
      , byte[] ssid, byte[] credentials, Optional<Long> breadcrumb
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void addOrUpdateThreadNetwork(long chipClusterPtr, NetworkConfigResponseCallback Callback
      , byte[] operationalDataset, Optional<Long> breadcrumb
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void removeNetwork(long chipClusterPtr, NetworkConfigResponseCallback Callback
      , byte[] networkID, Optional<Long> breadcrumb
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void connectNetwork(long chipClusterPtr, ConnectNetworkResponseCallback Callback
      , byte[] networkID, Optional<Long> breadcrumb
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void reorderNetwork(long chipClusterPtr, NetworkConfigResponseCallback Callback
      , byte[] networkID, Integer networkIndex, Optional<Long> breadcrumb
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface ScanNetworksResponseCallback {
      void onSuccess(Integer networkingStatus, Optional<String> debugText, Optional<ArrayList<ChipStructs.NetworkCommissioningClusterWiFiInterfaceScanResult>> wiFiScanResults, Optional<ArrayList<ChipStructs.NetworkCommissioningClusterThreadInterfaceScanResult>> threadScanResults);
      
      void onError(Exception error);
    }

    public interface NetworkConfigResponseCallback {
      void onSuccess(Integer networkingStatus, Optional<String> debugText, Optional<Integer> networkIndex);
      
      void onError(Exception error);
    }

    public interface ConnectNetworkResponseCallback {
      void onSuccess(Integer networkingStatus, Optional<String> debugText, @Nullable Long errorValue);
      
      void onError(Exception error);
    }


      public interface NetworksAttributeCallback {
        void onSuccess( List<ChipStructs.NetworkCommissioningClusterNetworkInfo> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface LastNetworkingStatusAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface LastNetworkIDAttributeCallback {
        void onSuccess(@Nullable byte[] value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface LastConnectErrorValueAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readMaxNetworksAttribute(
      IntegerAttributeCallback callback
    ) {
      readMaxNetworksAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxNetworksAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaxNetworksAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNetworksAttribute(
      NetworksAttributeCallback callback
    ) {
      readNetworksAttribute(chipClusterPtr, callback);
    }
    public void subscribeNetworksAttribute(
        NetworksAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeNetworksAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readScanMaxTimeSecondsAttribute(
      IntegerAttributeCallback callback
    ) {
      readScanMaxTimeSecondsAttribute(chipClusterPtr, callback);
    }
    public void subscribeScanMaxTimeSecondsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeScanMaxTimeSecondsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readConnectMaxTimeSecondsAttribute(
      IntegerAttributeCallback callback
    ) {
      readConnectMaxTimeSecondsAttribute(chipClusterPtr, callback);
    }
    public void subscribeConnectMaxTimeSecondsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConnectMaxTimeSecondsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInterfaceEnabledAttribute(
      BooleanAttributeCallback callback
    ) {
      readInterfaceEnabledAttribute(chipClusterPtr, callback);
    }
    public void writeInterfaceEnabledAttribute(DefaultClusterCallback callback, Boolean value) {
      writeInterfaceEnabledAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeInterfaceEnabledAttribute(DefaultClusterCallback callback, Boolean value, int timedWriteTimeoutMs) {
      writeInterfaceEnabledAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeInterfaceEnabledAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInterfaceEnabledAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLastNetworkingStatusAttribute(
      LastNetworkingStatusAttributeCallback callback
    ) {
      readLastNetworkingStatusAttribute(chipClusterPtr, callback);
    }
    public void subscribeLastNetworkingStatusAttribute(
        LastNetworkingStatusAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLastNetworkingStatusAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLastNetworkIDAttribute(
      LastNetworkIDAttributeCallback callback
    ) {
      readLastNetworkIDAttribute(chipClusterPtr, callback);
    }
    public void subscribeLastNetworkIDAttribute(
        LastNetworkIDAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLastNetworkIDAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLastConnectErrorValueAttribute(
      LastConnectErrorValueAttributeCallback callback
    ) {
      readLastConnectErrorValueAttribute(chipClusterPtr, callback);
    }
    public void subscribeLastConnectErrorValueAttribute(
        LastConnectErrorValueAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLastConnectErrorValueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readMaxNetworksAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMaxNetworksAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNetworksAttribute(long chipClusterPtr,
        NetworksAttributeCallback callback
    );
    private native void subscribeNetworksAttribute(long chipClusterPtr,
        NetworksAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readScanMaxTimeSecondsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeScanMaxTimeSecondsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readConnectMaxTimeSecondsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConnectMaxTimeSecondsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInterfaceEnabledAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );

    private native void writeInterfaceEnabledAttribute(long chipClusterPtr, DefaultClusterCallback callback, Boolean value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeInterfaceEnabledAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLastNetworkingStatusAttribute(long chipClusterPtr,
        LastNetworkingStatusAttributeCallback callback
    );
    private native void subscribeLastNetworkingStatusAttribute(long chipClusterPtr,
        LastNetworkingStatusAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readLastNetworkIDAttribute(long chipClusterPtr,
        LastNetworkIDAttributeCallback callback
    );
    private native void subscribeLastNetworkIDAttribute(long chipClusterPtr,
        LastNetworkIDAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readLastConnectErrorValueAttribute(long chipClusterPtr,
        LastConnectErrorValueAttributeCallback callback
    );
    private native void subscribeLastConnectErrorValueAttribute(long chipClusterPtr,
        LastConnectErrorValueAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class DiagnosticLogsCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 50L;

    public DiagnosticLogsCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void retrieveLogsRequest(RetrieveLogsResponseCallback callback
      , Integer intent, Integer requestedProtocol, Optional<String> transferFileDesignator) {
      retrieveLogsRequest(chipClusterPtr, callback, intent, requestedProtocol, transferFileDesignator, null);
    }

    public void retrieveLogsRequest(RetrieveLogsResponseCallback callback
      , Integer intent, Integer requestedProtocol, Optional<String> transferFileDesignator
      , int timedInvokeTimeoutMs) {
      retrieveLogsRequest(chipClusterPtr, callback, intent, requestedProtocol, transferFileDesignator, timedInvokeTimeoutMs);
    }
    private native void retrieveLogsRequest(long chipClusterPtr, RetrieveLogsResponseCallback Callback
      , Integer intent, Integer requestedProtocol, Optional<String> transferFileDesignator
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface RetrieveLogsResponseCallback {
      void onSuccess(Integer status, byte[] logContent, Optional<Long> UTCTimeStamp, Optional<Long> timeSinceBoot);
      
      void onError(Exception error);
    }


      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class GeneralDiagnosticsCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 51L;

    public GeneralDiagnosticsCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void testEventTrigger(DefaultClusterCallback callback
      , byte[] enableKey, Long eventTrigger) {
      testEventTrigger(chipClusterPtr, callback, enableKey, eventTrigger, null);
    }

    public void testEventTrigger(DefaultClusterCallback callback
      , byte[] enableKey, Long eventTrigger
      , int timedInvokeTimeoutMs) {
      testEventTrigger(chipClusterPtr, callback, enableKey, eventTrigger, timedInvokeTimeoutMs);
    }
    private native void testEventTrigger(long chipClusterPtr, DefaultClusterCallback Callback
      , byte[] enableKey, Long eventTrigger
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface NetworkInterfacesAttributeCallback {
        void onSuccess( List<ChipStructs.GeneralDiagnosticsClusterNetworkInterface> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ActiveHardwareFaultsAttributeCallback {
        void onSuccess( List<Integer> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ActiveRadioFaultsAttributeCallback {
        void onSuccess( List<Integer> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ActiveNetworkFaultsAttributeCallback {
        void onSuccess( List<Integer> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readNetworkInterfacesAttribute(
      NetworkInterfacesAttributeCallback callback
    ) {
      readNetworkInterfacesAttribute(chipClusterPtr, callback);
    }
    public void subscribeNetworkInterfacesAttribute(
        NetworkInterfacesAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeNetworkInterfacesAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRebootCountAttribute(
      IntegerAttributeCallback callback
    ) {
      readRebootCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRebootCountAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRebootCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUpTimeAttribute(
      LongAttributeCallback callback
    ) {
      readUpTimeAttribute(chipClusterPtr, callback);
    }
    public void subscribeUpTimeAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeUpTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTotalOperationalHoursAttribute(
      LongAttributeCallback callback
    ) {
      readTotalOperationalHoursAttribute(chipClusterPtr, callback);
    }
    public void subscribeTotalOperationalHoursAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTotalOperationalHoursAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBootReasonAttribute(
      IntegerAttributeCallback callback
    ) {
      readBootReasonAttribute(chipClusterPtr, callback);
    }
    public void subscribeBootReasonAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBootReasonAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActiveHardwareFaultsAttribute(
      ActiveHardwareFaultsAttributeCallback callback
    ) {
      readActiveHardwareFaultsAttribute(chipClusterPtr, callback);
    }
    public void subscribeActiveHardwareFaultsAttribute(
        ActiveHardwareFaultsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeActiveHardwareFaultsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActiveRadioFaultsAttribute(
      ActiveRadioFaultsAttributeCallback callback
    ) {
      readActiveRadioFaultsAttribute(chipClusterPtr, callback);
    }
    public void subscribeActiveRadioFaultsAttribute(
        ActiveRadioFaultsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeActiveRadioFaultsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActiveNetworkFaultsAttribute(
      ActiveNetworkFaultsAttributeCallback callback
    ) {
      readActiveNetworkFaultsAttribute(chipClusterPtr, callback);
    }
    public void subscribeActiveNetworkFaultsAttribute(
        ActiveNetworkFaultsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeActiveNetworkFaultsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTestEventTriggersEnabledAttribute(
      BooleanAttributeCallback callback
    ) {
      readTestEventTriggersEnabledAttribute(chipClusterPtr, callback);
    }
    public void subscribeTestEventTriggersEnabledAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTestEventTriggersEnabledAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readNetworkInterfacesAttribute(long chipClusterPtr,
        NetworkInterfacesAttributeCallback callback
    );
    private native void subscribeNetworkInterfacesAttribute(long chipClusterPtr,
        NetworkInterfacesAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readRebootCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeRebootCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readUpTimeAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeUpTimeAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTotalOperationalHoursAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTotalOperationalHoursAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBootReasonAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBootReasonAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readActiveHardwareFaultsAttribute(long chipClusterPtr,
        ActiveHardwareFaultsAttributeCallback callback
    );
    private native void subscribeActiveHardwareFaultsAttribute(long chipClusterPtr,
        ActiveHardwareFaultsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readActiveRadioFaultsAttribute(long chipClusterPtr,
        ActiveRadioFaultsAttributeCallback callback
    );
    private native void subscribeActiveRadioFaultsAttribute(long chipClusterPtr,
        ActiveRadioFaultsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readActiveNetworkFaultsAttribute(long chipClusterPtr,
        ActiveNetworkFaultsAttributeCallback callback
    );
    private native void subscribeActiveNetworkFaultsAttribute(long chipClusterPtr,
        ActiveNetworkFaultsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readTestEventTriggersEnabledAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeTestEventTriggersEnabledAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class SoftwareDiagnosticsCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 52L;

    public SoftwareDiagnosticsCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void resetWatermarks(DefaultClusterCallback callback
      ) {
      resetWatermarks(chipClusterPtr, callback, null);
    }

    public void resetWatermarks(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      resetWatermarks(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }
    private native void resetWatermarks(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface ThreadMetricsAttributeCallback {
        void onSuccess( List<ChipStructs.SoftwareDiagnosticsClusterThreadMetricsStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readThreadMetricsAttribute(
      ThreadMetricsAttributeCallback callback
    ) {
      readThreadMetricsAttribute(chipClusterPtr, callback);
    }
    public void subscribeThreadMetricsAttribute(
        ThreadMetricsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeThreadMetricsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentHeapFreeAttribute(
      LongAttributeCallback callback
    ) {
      readCurrentHeapFreeAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentHeapFreeAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentHeapFreeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentHeapUsedAttribute(
      LongAttributeCallback callback
    ) {
      readCurrentHeapUsedAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentHeapUsedAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentHeapUsedAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentHeapHighWatermarkAttribute(
      LongAttributeCallback callback
    ) {
      readCurrentHeapHighWatermarkAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentHeapHighWatermarkAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentHeapHighWatermarkAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readThreadMetricsAttribute(long chipClusterPtr,
        ThreadMetricsAttributeCallback callback
    );
    private native void subscribeThreadMetricsAttribute(long chipClusterPtr,
        ThreadMetricsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readCurrentHeapFreeAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeCurrentHeapFreeAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentHeapUsedAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeCurrentHeapUsedAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentHeapHighWatermarkAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeCurrentHeapHighWatermarkAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ThreadNetworkDiagnosticsCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 53L;

    public ThreadNetworkDiagnosticsCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void resetCounts(DefaultClusterCallback callback
      ) {
      resetCounts(chipClusterPtr, callback, null);
    }

    public void resetCounts(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      resetCounts(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }
    private native void resetCounts(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface ChannelAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface RoutingRoleAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface NetworkNameAttributeCallback {
        void onSuccess(@Nullable String value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface PanIdAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ExtendedPanIdAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MeshLocalPrefixAttributeCallback {
        void onSuccess(@Nullable byte[] value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface NeighborTableAttributeCallback {
        void onSuccess( List<ChipStructs.ThreadNetworkDiagnosticsClusterNeighborTableStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface RouteTableAttributeCallback {
        void onSuccess( List<ChipStructs.ThreadNetworkDiagnosticsClusterRouteTableStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface PartitionIdAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface WeightingAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface DataVersionAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface StableDataVersionAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface LeaderRouterIdAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ActiveTimestampAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface PendingTimestampAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface DelayAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ChannelPage0MaskAttributeCallback {
        void onSuccess(@Nullable byte[] value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ActiveNetworkFaultsListAttributeCallback {
        void onSuccess( List<Integer> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readChannelAttribute(
      ChannelAttributeCallback callback
    ) {
      readChannelAttribute(chipClusterPtr, callback);
    }
    public void subscribeChannelAttribute(
        ChannelAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeChannelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRoutingRoleAttribute(
      RoutingRoleAttributeCallback callback
    ) {
      readRoutingRoleAttribute(chipClusterPtr, callback);
    }
    public void subscribeRoutingRoleAttribute(
        RoutingRoleAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeRoutingRoleAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNetworkNameAttribute(
      NetworkNameAttributeCallback callback
    ) {
      readNetworkNameAttribute(chipClusterPtr, callback);
    }
    public void subscribeNetworkNameAttribute(
        NetworkNameAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeNetworkNameAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPanIdAttribute(
      PanIdAttributeCallback callback
    ) {
      readPanIdAttribute(chipClusterPtr, callback);
    }
    public void subscribePanIdAttribute(
        PanIdAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePanIdAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readExtendedPanIdAttribute(
      ExtendedPanIdAttributeCallback callback
    ) {
      readExtendedPanIdAttribute(chipClusterPtr, callback);
    }
    public void subscribeExtendedPanIdAttribute(
        ExtendedPanIdAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeExtendedPanIdAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMeshLocalPrefixAttribute(
      MeshLocalPrefixAttributeCallback callback
    ) {
      readMeshLocalPrefixAttribute(chipClusterPtr, callback);
    }
    public void subscribeMeshLocalPrefixAttribute(
        MeshLocalPrefixAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMeshLocalPrefixAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOverrunCountAttribute(
      LongAttributeCallback callback
    ) {
      readOverrunCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeOverrunCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOverrunCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNeighborTableAttribute(
      NeighborTableAttributeCallback callback
    ) {
      readNeighborTableAttribute(chipClusterPtr, callback);
    }
    public void subscribeNeighborTableAttribute(
        NeighborTableAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeNeighborTableAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRouteTableAttribute(
      RouteTableAttributeCallback callback
    ) {
      readRouteTableAttribute(chipClusterPtr, callback);
    }
    public void subscribeRouteTableAttribute(
        RouteTableAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeRouteTableAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPartitionIdAttribute(
      PartitionIdAttributeCallback callback
    ) {
      readPartitionIdAttribute(chipClusterPtr, callback);
    }
    public void subscribePartitionIdAttribute(
        PartitionIdAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePartitionIdAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWeightingAttribute(
      WeightingAttributeCallback callback
    ) {
      readWeightingAttribute(chipClusterPtr, callback);
    }
    public void subscribeWeightingAttribute(
        WeightingAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeWeightingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDataVersionAttribute(
      DataVersionAttributeCallback callback
    ) {
      readDataVersionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDataVersionAttribute(
        DataVersionAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeDataVersionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readStableDataVersionAttribute(
      StableDataVersionAttributeCallback callback
    ) {
      readStableDataVersionAttribute(chipClusterPtr, callback);
    }
    public void subscribeStableDataVersionAttribute(
        StableDataVersionAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeStableDataVersionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLeaderRouterIdAttribute(
      LeaderRouterIdAttributeCallback callback
    ) {
      readLeaderRouterIdAttribute(chipClusterPtr, callback);
    }
    public void subscribeLeaderRouterIdAttribute(
        LeaderRouterIdAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLeaderRouterIdAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDetachedRoleCountAttribute(
      IntegerAttributeCallback callback
    ) {
      readDetachedRoleCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeDetachedRoleCountAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDetachedRoleCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChildRoleCountAttribute(
      IntegerAttributeCallback callback
    ) {
      readChildRoleCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeChildRoleCountAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChildRoleCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRouterRoleCountAttribute(
      IntegerAttributeCallback callback
    ) {
      readRouterRoleCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRouterRoleCountAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRouterRoleCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLeaderRoleCountAttribute(
      IntegerAttributeCallback callback
    ) {
      readLeaderRoleCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeLeaderRoleCountAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLeaderRoleCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttachAttemptCountAttribute(
      IntegerAttributeCallback callback
    ) {
      readAttachAttemptCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttachAttemptCountAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeAttachAttemptCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPartitionIdChangeCountAttribute(
      IntegerAttributeCallback callback
    ) {
      readPartitionIdChangeCountAttribute(chipClusterPtr, callback);
    }
    public void subscribePartitionIdChangeCountAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePartitionIdChangeCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBetterPartitionAttachAttemptCountAttribute(
      IntegerAttributeCallback callback
    ) {
      readBetterPartitionAttachAttemptCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeBetterPartitionAttachAttemptCountAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBetterPartitionAttachAttemptCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readParentChangeCountAttribute(
      IntegerAttributeCallback callback
    ) {
      readParentChangeCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeParentChangeCountAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeParentChangeCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxTotalCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxTotalCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxTotalCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxTotalCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxUnicastCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxUnicastCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxUnicastCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxUnicastCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxBroadcastCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxBroadcastCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxBroadcastCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxBroadcastCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxAckRequestedCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxAckRequestedCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxAckRequestedCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxAckRequestedCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxAckedCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxAckedCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxAckedCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxAckedCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxNoAckRequestedCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxNoAckRequestedCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxNoAckRequestedCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxNoAckRequestedCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxDataCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxDataCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxDataCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxDataCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxDataPollCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxDataPollCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxDataPollCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxDataPollCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxBeaconCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxBeaconCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxBeaconCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxBeaconCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxBeaconRequestCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxBeaconRequestCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxBeaconRequestCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxBeaconRequestCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxOtherCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxOtherCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxOtherCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxOtherCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxRetryCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxRetryCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxRetryCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxRetryCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxDirectMaxRetryExpiryCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxDirectMaxRetryExpiryCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxDirectMaxRetryExpiryCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxDirectMaxRetryExpiryCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxIndirectMaxRetryExpiryCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxIndirectMaxRetryExpiryCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxIndirectMaxRetryExpiryCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxIndirectMaxRetryExpiryCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxErrCcaCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxErrCcaCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxErrCcaCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxErrCcaCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxErrAbortCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxErrAbortCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxErrAbortCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxErrAbortCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxErrBusyChannelCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxErrBusyChannelCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxErrBusyChannelCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxErrBusyChannelCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxTotalCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxTotalCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxTotalCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxTotalCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxUnicastCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxUnicastCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxUnicastCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxUnicastCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxBroadcastCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxBroadcastCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxBroadcastCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxBroadcastCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxDataCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxDataCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxDataCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxDataCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxDataPollCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxDataPollCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxDataPollCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxDataPollCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxBeaconCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxBeaconCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxBeaconCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxBeaconCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxBeaconRequestCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxBeaconRequestCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxBeaconRequestCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxBeaconRequestCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxOtherCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxOtherCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxOtherCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxOtherCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxAddressFilteredCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxAddressFilteredCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxAddressFilteredCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxAddressFilteredCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxDestAddrFilteredCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxDestAddrFilteredCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxDestAddrFilteredCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxDestAddrFilteredCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxDuplicatedCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxDuplicatedCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxDuplicatedCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxDuplicatedCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxErrNoFrameCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxErrNoFrameCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxErrNoFrameCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxErrNoFrameCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxErrUnknownNeighborCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxErrUnknownNeighborCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxErrUnknownNeighborCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxErrUnknownNeighborCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxErrInvalidSrcAddrCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxErrInvalidSrcAddrCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxErrInvalidSrcAddrCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxErrInvalidSrcAddrCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxErrSecCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxErrSecCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxErrSecCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxErrSecCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxErrFcsCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxErrFcsCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxErrFcsCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxErrFcsCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRxErrOtherCountAttribute(
      LongAttributeCallback callback
    ) {
      readRxErrOtherCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeRxErrOtherCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRxErrOtherCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActiveTimestampAttribute(
      ActiveTimestampAttributeCallback callback
    ) {
      readActiveTimestampAttribute(chipClusterPtr, callback);
    }
    public void subscribeActiveTimestampAttribute(
        ActiveTimestampAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeActiveTimestampAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPendingTimestampAttribute(
      PendingTimestampAttributeCallback callback
    ) {
      readPendingTimestampAttribute(chipClusterPtr, callback);
    }
    public void subscribePendingTimestampAttribute(
        PendingTimestampAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePendingTimestampAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDelayAttribute(
      DelayAttributeCallback callback
    ) {
      readDelayAttribute(chipClusterPtr, callback);
    }
    public void subscribeDelayAttribute(
        DelayAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeDelayAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChannelPage0MaskAttribute(
      ChannelPage0MaskAttributeCallback callback
    ) {
      readChannelPage0MaskAttribute(chipClusterPtr, callback);
    }
    public void subscribeChannelPage0MaskAttribute(
        ChannelPage0MaskAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeChannelPage0MaskAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActiveNetworkFaultsListAttribute(
      ActiveNetworkFaultsListAttributeCallback callback
    ) {
      readActiveNetworkFaultsListAttribute(chipClusterPtr, callback);
    }
    public void subscribeActiveNetworkFaultsListAttribute(
        ActiveNetworkFaultsListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeActiveNetworkFaultsListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readChannelAttribute(long chipClusterPtr,
        ChannelAttributeCallback callback
    );
    private native void subscribeChannelAttribute(long chipClusterPtr,
        ChannelAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readRoutingRoleAttribute(long chipClusterPtr,
        RoutingRoleAttributeCallback callback
    );
    private native void subscribeRoutingRoleAttribute(long chipClusterPtr,
        RoutingRoleAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readNetworkNameAttribute(long chipClusterPtr,
        NetworkNameAttributeCallback callback
    );
    private native void subscribeNetworkNameAttribute(long chipClusterPtr,
        NetworkNameAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPanIdAttribute(long chipClusterPtr,
        PanIdAttributeCallback callback
    );
    private native void subscribePanIdAttribute(long chipClusterPtr,
        PanIdAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readExtendedPanIdAttribute(long chipClusterPtr,
        ExtendedPanIdAttributeCallback callback
    );
    private native void subscribeExtendedPanIdAttribute(long chipClusterPtr,
        ExtendedPanIdAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMeshLocalPrefixAttribute(long chipClusterPtr,
        MeshLocalPrefixAttributeCallback callback
    );
    private native void subscribeMeshLocalPrefixAttribute(long chipClusterPtr,
        MeshLocalPrefixAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOverrunCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeOverrunCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNeighborTableAttribute(long chipClusterPtr,
        NeighborTableAttributeCallback callback
    );
    private native void subscribeNeighborTableAttribute(long chipClusterPtr,
        NeighborTableAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readRouteTableAttribute(long chipClusterPtr,
        RouteTableAttributeCallback callback
    );
    private native void subscribeRouteTableAttribute(long chipClusterPtr,
        RouteTableAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPartitionIdAttribute(long chipClusterPtr,
        PartitionIdAttributeCallback callback
    );
    private native void subscribePartitionIdAttribute(long chipClusterPtr,
        PartitionIdAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readWeightingAttribute(long chipClusterPtr,
        WeightingAttributeCallback callback
    );
    private native void subscribeWeightingAttribute(long chipClusterPtr,
        WeightingAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readDataVersionAttribute(long chipClusterPtr,
        DataVersionAttributeCallback callback
    );
    private native void subscribeDataVersionAttribute(long chipClusterPtr,
        DataVersionAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readStableDataVersionAttribute(long chipClusterPtr,
        StableDataVersionAttributeCallback callback
    );
    private native void subscribeStableDataVersionAttribute(long chipClusterPtr,
        StableDataVersionAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readLeaderRouterIdAttribute(long chipClusterPtr,
        LeaderRouterIdAttributeCallback callback
    );
    private native void subscribeLeaderRouterIdAttribute(long chipClusterPtr,
        LeaderRouterIdAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readDetachedRoleCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDetachedRoleCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChildRoleCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChildRoleCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRouterRoleCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeRouterRoleCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLeaderRoleCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeLeaderRoleCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readAttachAttemptCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeAttachAttemptCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPartitionIdChangeCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePartitionIdChangeCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBetterPartitionAttachAttemptCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBetterPartitionAttachAttemptCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readParentChangeCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeParentChangeCountAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxTotalCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxTotalCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxUnicastCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxUnicastCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxBroadcastCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxBroadcastCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxAckRequestedCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxAckRequestedCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxAckedCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxAckedCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxNoAckRequestedCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxNoAckRequestedCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxDataCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxDataCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxDataPollCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxDataPollCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxBeaconCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxBeaconCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxBeaconRequestCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxBeaconRequestCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxOtherCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxOtherCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxRetryCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxRetryCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxDirectMaxRetryExpiryCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxDirectMaxRetryExpiryCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxIndirectMaxRetryExpiryCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxIndirectMaxRetryExpiryCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxErrCcaCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxErrCcaCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxErrAbortCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxErrAbortCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxErrBusyChannelCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxErrBusyChannelCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxTotalCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxTotalCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxUnicastCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxUnicastCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxBroadcastCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxBroadcastCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxDataCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxDataCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxDataPollCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxDataPollCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxBeaconCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxBeaconCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxBeaconRequestCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxBeaconRequestCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxOtherCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxOtherCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxAddressFilteredCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxAddressFilteredCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxDestAddrFilteredCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxDestAddrFilteredCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxDuplicatedCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxDuplicatedCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxErrNoFrameCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxErrNoFrameCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxErrUnknownNeighborCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxErrUnknownNeighborCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxErrInvalidSrcAddrCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxErrInvalidSrcAddrCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxErrSecCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxErrSecCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxErrFcsCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxErrFcsCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRxErrOtherCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeRxErrOtherCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readActiveTimestampAttribute(long chipClusterPtr,
        ActiveTimestampAttributeCallback callback
    );
    private native void subscribeActiveTimestampAttribute(long chipClusterPtr,
        ActiveTimestampAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPendingTimestampAttribute(long chipClusterPtr,
        PendingTimestampAttributeCallback callback
    );
    private native void subscribePendingTimestampAttribute(long chipClusterPtr,
        PendingTimestampAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readDelayAttribute(long chipClusterPtr,
        DelayAttributeCallback callback
    );
    private native void subscribeDelayAttribute(long chipClusterPtr,
        DelayAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readChannelPage0MaskAttribute(long chipClusterPtr,
        ChannelPage0MaskAttributeCallback callback
    );
    private native void subscribeChannelPage0MaskAttribute(long chipClusterPtr,
        ChannelPage0MaskAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readActiveNetworkFaultsListAttribute(long chipClusterPtr,
        ActiveNetworkFaultsListAttributeCallback callback
    );
    private native void subscribeActiveNetworkFaultsListAttribute(long chipClusterPtr,
        ActiveNetworkFaultsListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class WiFiNetworkDiagnosticsCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 54L;

    public WiFiNetworkDiagnosticsCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void resetCounts(DefaultClusterCallback callback
      ) {
      resetCounts(chipClusterPtr, callback, null);
    }

    public void resetCounts(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      resetCounts(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }
    private native void resetCounts(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface BssidAttributeCallback {
        void onSuccess(@Nullable byte[] value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface SecurityTypeAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface WiFiVersionAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ChannelNumberAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface RssiAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface BeaconLostCountAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface BeaconRxCountAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface PacketMulticastRxCountAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface PacketMulticastTxCountAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface PacketUnicastRxCountAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface PacketUnicastTxCountAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface CurrentMaxRateAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface OverrunCountAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readBssidAttribute(
      BssidAttributeCallback callback
    ) {
      readBssidAttribute(chipClusterPtr, callback);
    }
    public void subscribeBssidAttribute(
        BssidAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeBssidAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSecurityTypeAttribute(
      SecurityTypeAttributeCallback callback
    ) {
      readSecurityTypeAttribute(chipClusterPtr, callback);
    }
    public void subscribeSecurityTypeAttribute(
        SecurityTypeAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeSecurityTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWiFiVersionAttribute(
      WiFiVersionAttributeCallback callback
    ) {
      readWiFiVersionAttribute(chipClusterPtr, callback);
    }
    public void subscribeWiFiVersionAttribute(
        WiFiVersionAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeWiFiVersionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChannelNumberAttribute(
      ChannelNumberAttributeCallback callback
    ) {
      readChannelNumberAttribute(chipClusterPtr, callback);
    }
    public void subscribeChannelNumberAttribute(
        ChannelNumberAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeChannelNumberAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRssiAttribute(
      RssiAttributeCallback callback
    ) {
      readRssiAttribute(chipClusterPtr, callback);
    }
    public void subscribeRssiAttribute(
        RssiAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeRssiAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBeaconLostCountAttribute(
      BeaconLostCountAttributeCallback callback
    ) {
      readBeaconLostCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeBeaconLostCountAttribute(
        BeaconLostCountAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeBeaconLostCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBeaconRxCountAttribute(
      BeaconRxCountAttributeCallback callback
    ) {
      readBeaconRxCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeBeaconRxCountAttribute(
        BeaconRxCountAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeBeaconRxCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPacketMulticastRxCountAttribute(
      PacketMulticastRxCountAttributeCallback callback
    ) {
      readPacketMulticastRxCountAttribute(chipClusterPtr, callback);
    }
    public void subscribePacketMulticastRxCountAttribute(
        PacketMulticastRxCountAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePacketMulticastRxCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPacketMulticastTxCountAttribute(
      PacketMulticastTxCountAttributeCallback callback
    ) {
      readPacketMulticastTxCountAttribute(chipClusterPtr, callback);
    }
    public void subscribePacketMulticastTxCountAttribute(
        PacketMulticastTxCountAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePacketMulticastTxCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPacketUnicastRxCountAttribute(
      PacketUnicastRxCountAttributeCallback callback
    ) {
      readPacketUnicastRxCountAttribute(chipClusterPtr, callback);
    }
    public void subscribePacketUnicastRxCountAttribute(
        PacketUnicastRxCountAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePacketUnicastRxCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPacketUnicastTxCountAttribute(
      PacketUnicastTxCountAttributeCallback callback
    ) {
      readPacketUnicastTxCountAttribute(chipClusterPtr, callback);
    }
    public void subscribePacketUnicastTxCountAttribute(
        PacketUnicastTxCountAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePacketUnicastTxCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentMaxRateAttribute(
      CurrentMaxRateAttributeCallback callback
    ) {
      readCurrentMaxRateAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentMaxRateAttribute(
        CurrentMaxRateAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCurrentMaxRateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOverrunCountAttribute(
      OverrunCountAttributeCallback callback
    ) {
      readOverrunCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeOverrunCountAttribute(
        OverrunCountAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeOverrunCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readBssidAttribute(long chipClusterPtr,
        BssidAttributeCallback callback
    );
    private native void subscribeBssidAttribute(long chipClusterPtr,
        BssidAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readSecurityTypeAttribute(long chipClusterPtr,
        SecurityTypeAttributeCallback callback
    );
    private native void subscribeSecurityTypeAttribute(long chipClusterPtr,
        SecurityTypeAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readWiFiVersionAttribute(long chipClusterPtr,
        WiFiVersionAttributeCallback callback
    );
    private native void subscribeWiFiVersionAttribute(long chipClusterPtr,
        WiFiVersionAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readChannelNumberAttribute(long chipClusterPtr,
        ChannelNumberAttributeCallback callback
    );
    private native void subscribeChannelNumberAttribute(long chipClusterPtr,
        ChannelNumberAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readRssiAttribute(long chipClusterPtr,
        RssiAttributeCallback callback
    );
    private native void subscribeRssiAttribute(long chipClusterPtr,
        RssiAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readBeaconLostCountAttribute(long chipClusterPtr,
        BeaconLostCountAttributeCallback callback
    );
    private native void subscribeBeaconLostCountAttribute(long chipClusterPtr,
        BeaconLostCountAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readBeaconRxCountAttribute(long chipClusterPtr,
        BeaconRxCountAttributeCallback callback
    );
    private native void subscribeBeaconRxCountAttribute(long chipClusterPtr,
        BeaconRxCountAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPacketMulticastRxCountAttribute(long chipClusterPtr,
        PacketMulticastRxCountAttributeCallback callback
    );
    private native void subscribePacketMulticastRxCountAttribute(long chipClusterPtr,
        PacketMulticastRxCountAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPacketMulticastTxCountAttribute(long chipClusterPtr,
        PacketMulticastTxCountAttributeCallback callback
    );
    private native void subscribePacketMulticastTxCountAttribute(long chipClusterPtr,
        PacketMulticastTxCountAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPacketUnicastRxCountAttribute(long chipClusterPtr,
        PacketUnicastRxCountAttributeCallback callback
    );
    private native void subscribePacketUnicastRxCountAttribute(long chipClusterPtr,
        PacketUnicastRxCountAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPacketUnicastTxCountAttribute(long chipClusterPtr,
        PacketUnicastTxCountAttributeCallback callback
    );
    private native void subscribePacketUnicastTxCountAttribute(long chipClusterPtr,
        PacketUnicastTxCountAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readCurrentMaxRateAttribute(long chipClusterPtr,
        CurrentMaxRateAttributeCallback callback
    );
    private native void subscribeCurrentMaxRateAttribute(long chipClusterPtr,
        CurrentMaxRateAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOverrunCountAttribute(long chipClusterPtr,
        OverrunCountAttributeCallback callback
    );
    private native void subscribeOverrunCountAttribute(long chipClusterPtr,
        OverrunCountAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class EthernetNetworkDiagnosticsCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 55L;

    public EthernetNetworkDiagnosticsCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void resetCounts(DefaultClusterCallback callback
      ) {
      resetCounts(chipClusterPtr, callback, null);
    }

    public void resetCounts(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      resetCounts(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }
    private native void resetCounts(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface PHYRateAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface FullDuplexAttributeCallback {
        void onSuccess(@Nullable Boolean value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface CarrierDetectAttributeCallback {
        void onSuccess(@Nullable Boolean value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readPHYRateAttribute(
      PHYRateAttributeCallback callback
    ) {
      readPHYRateAttribute(chipClusterPtr, callback);
    }
    public void subscribePHYRateAttribute(
        PHYRateAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePHYRateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFullDuplexAttribute(
      FullDuplexAttributeCallback callback
    ) {
      readFullDuplexAttribute(chipClusterPtr, callback);
    }
    public void subscribeFullDuplexAttribute(
        FullDuplexAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeFullDuplexAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPacketRxCountAttribute(
      LongAttributeCallback callback
    ) {
      readPacketRxCountAttribute(chipClusterPtr, callback);
    }
    public void subscribePacketRxCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePacketRxCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPacketTxCountAttribute(
      LongAttributeCallback callback
    ) {
      readPacketTxCountAttribute(chipClusterPtr, callback);
    }
    public void subscribePacketTxCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePacketTxCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTxErrCountAttribute(
      LongAttributeCallback callback
    ) {
      readTxErrCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeTxErrCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTxErrCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCollisionCountAttribute(
      LongAttributeCallback callback
    ) {
      readCollisionCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeCollisionCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCollisionCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOverrunCountAttribute(
      LongAttributeCallback callback
    ) {
      readOverrunCountAttribute(chipClusterPtr, callback);
    }
    public void subscribeOverrunCountAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOverrunCountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCarrierDetectAttribute(
      CarrierDetectAttributeCallback callback
    ) {
      readCarrierDetectAttribute(chipClusterPtr, callback);
    }
    public void subscribeCarrierDetectAttribute(
        CarrierDetectAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCarrierDetectAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTimeSinceResetAttribute(
      LongAttributeCallback callback
    ) {
      readTimeSinceResetAttribute(chipClusterPtr, callback);
    }
    public void subscribeTimeSinceResetAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTimeSinceResetAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readPHYRateAttribute(long chipClusterPtr,
        PHYRateAttributeCallback callback
    );
    private native void subscribePHYRateAttribute(long chipClusterPtr,
        PHYRateAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFullDuplexAttribute(long chipClusterPtr,
        FullDuplexAttributeCallback callback
    );
    private native void subscribeFullDuplexAttribute(long chipClusterPtr,
        FullDuplexAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPacketRxCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribePacketRxCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPacketTxCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribePacketTxCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTxErrCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTxErrCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCollisionCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeCollisionCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOverrunCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeOverrunCountAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCarrierDetectAttribute(long chipClusterPtr,
        CarrierDetectAttributeCallback callback
    );
    private native void subscribeCarrierDetectAttribute(long chipClusterPtr,
        CarrierDetectAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readTimeSinceResetAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeTimeSinceResetAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class TimeSynchronizationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 56L;

    public TimeSynchronizationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void setUTCTime(DefaultClusterCallback callback
      , Long UTCTime, Integer granularity, Optional<Integer> timeSource) {
      setUTCTime(chipClusterPtr, callback, UTCTime, granularity, timeSource, null);
    }

    public void setUTCTime(DefaultClusterCallback callback
      , Long UTCTime, Integer granularity, Optional<Integer> timeSource
      , int timedInvokeTimeoutMs) {
      setUTCTime(chipClusterPtr, callback, UTCTime, granularity, timeSource, timedInvokeTimeoutMs);
    }

    public void setTrustedTimeSource(DefaultClusterCallback callback
      , @Nullable ChipStructs.TimeSynchronizationClusterFabricScopedTrustedTimeSourceStruct trustedTimeSource) {
      setTrustedTimeSource(chipClusterPtr, callback, trustedTimeSource, null);
    }

    public void setTrustedTimeSource(DefaultClusterCallback callback
      , @Nullable ChipStructs.TimeSynchronizationClusterFabricScopedTrustedTimeSourceStruct trustedTimeSource
      , int timedInvokeTimeoutMs) {
      setTrustedTimeSource(chipClusterPtr, callback, trustedTimeSource, timedInvokeTimeoutMs);
    }

    public void setTimeZone(SetTimeZoneResponseCallback callback
      , ArrayList<ChipStructs.TimeSynchronizationClusterTimeZoneStruct> timeZone) {
      setTimeZone(chipClusterPtr, callback, timeZone, null);
    }

    public void setTimeZone(SetTimeZoneResponseCallback callback
      , ArrayList<ChipStructs.TimeSynchronizationClusterTimeZoneStruct> timeZone
      , int timedInvokeTimeoutMs) {
      setTimeZone(chipClusterPtr, callback, timeZone, timedInvokeTimeoutMs);
    }

    public void setDSTOffset(DefaultClusterCallback callback
      , ArrayList<ChipStructs.TimeSynchronizationClusterDSTOffsetStruct> DSTOffset) {
      setDSTOffset(chipClusterPtr, callback, DSTOffset, null);
    }

    public void setDSTOffset(DefaultClusterCallback callback
      , ArrayList<ChipStructs.TimeSynchronizationClusterDSTOffsetStruct> DSTOffset
      , int timedInvokeTimeoutMs) {
      setDSTOffset(chipClusterPtr, callback, DSTOffset, timedInvokeTimeoutMs);
    }

    public void setDefaultNTP(DefaultClusterCallback callback
      , @Nullable String defaultNTP) {
      setDefaultNTP(chipClusterPtr, callback, defaultNTP, null);
    }

    public void setDefaultNTP(DefaultClusterCallback callback
      , @Nullable String defaultNTP
      , int timedInvokeTimeoutMs) {
      setDefaultNTP(chipClusterPtr, callback, defaultNTP, timedInvokeTimeoutMs);
    }
    private native void setUTCTime(long chipClusterPtr, DefaultClusterCallback Callback
      , Long UTCTime, Integer granularity, Optional<Integer> timeSource
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void setTrustedTimeSource(long chipClusterPtr, DefaultClusterCallback Callback
      , @Nullable ChipStructs.TimeSynchronizationClusterFabricScopedTrustedTimeSourceStruct trustedTimeSource
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void setTimeZone(long chipClusterPtr, SetTimeZoneResponseCallback Callback
      , ArrayList<ChipStructs.TimeSynchronizationClusterTimeZoneStruct> timeZone
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void setDSTOffset(long chipClusterPtr, DefaultClusterCallback Callback
      , ArrayList<ChipStructs.TimeSynchronizationClusterDSTOffsetStruct> DSTOffset
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void setDefaultNTP(long chipClusterPtr, DefaultClusterCallback Callback
      , @Nullable String defaultNTP
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface SetTimeZoneResponseCallback {
      void onSuccess(Boolean DSTOffsetRequired);
      
      void onError(Exception error);
    }


      public interface UTCTimeAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface DefaultNTPAttributeCallback {
        void onSuccess(@Nullable String value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface TimeZoneAttributeCallback {
        void onSuccess( List<ChipStructs.TimeSynchronizationClusterTimeZoneStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface DSTOffsetAttributeCallback {
        void onSuccess( List<ChipStructs.TimeSynchronizationClusterDSTOffsetStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface LocalTimeAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readUTCTimeAttribute(
      UTCTimeAttributeCallback callback
    ) {
      readUTCTimeAttribute(chipClusterPtr, callback);
    }
    public void subscribeUTCTimeAttribute(
        UTCTimeAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeUTCTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGranularityAttribute(
      IntegerAttributeCallback callback
    ) {
      readGranularityAttribute(chipClusterPtr, callback);
    }
    public void subscribeGranularityAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeGranularityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTimeSourceAttribute(
      IntegerAttributeCallback callback
    ) {
      readTimeSourceAttribute(chipClusterPtr, callback);
    }
    public void subscribeTimeSourceAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTimeSourceAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDefaultNTPAttribute(
      DefaultNTPAttributeCallback callback
    ) {
      readDefaultNTPAttribute(chipClusterPtr, callback);
    }
    public void subscribeDefaultNTPAttribute(
        DefaultNTPAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeDefaultNTPAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTimeZoneAttribute(
      TimeZoneAttributeCallback callback
    ) {
      readTimeZoneAttribute(chipClusterPtr, callback);
    }
    public void subscribeTimeZoneAttribute(
        TimeZoneAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeTimeZoneAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDSTOffsetAttribute(
      DSTOffsetAttributeCallback callback
    ) {
      readDSTOffsetAttribute(chipClusterPtr, callback);
    }
    public void subscribeDSTOffsetAttribute(
        DSTOffsetAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeDSTOffsetAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLocalTimeAttribute(
      LocalTimeAttributeCallback callback
    ) {
      readLocalTimeAttribute(chipClusterPtr, callback);
    }
    public void subscribeLocalTimeAttribute(
        LocalTimeAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLocalTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTimeZoneDatabaseAttribute(
      IntegerAttributeCallback callback
    ) {
      readTimeZoneDatabaseAttribute(chipClusterPtr, callback);
    }
    public void subscribeTimeZoneDatabaseAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTimeZoneDatabaseAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNTPServerAvailableAttribute(
      BooleanAttributeCallback callback
    ) {
      readNTPServerAvailableAttribute(chipClusterPtr, callback);
    }
    public void subscribeNTPServerAvailableAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNTPServerAvailableAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTimeZoneListMaxSizeAttribute(
      IntegerAttributeCallback callback
    ) {
      readTimeZoneListMaxSizeAttribute(chipClusterPtr, callback);
    }
    public void subscribeTimeZoneListMaxSizeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTimeZoneListMaxSizeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDSTOffsetListMaxSizeAttribute(
      IntegerAttributeCallback callback
    ) {
      readDSTOffsetListMaxSizeAttribute(chipClusterPtr, callback);
    }
    public void subscribeDSTOffsetListMaxSizeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDSTOffsetListMaxSizeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSupportsDNSResolveAttribute(
      BooleanAttributeCallback callback
    ) {
      readSupportsDNSResolveAttribute(chipClusterPtr, callback);
    }
    public void subscribeSupportsDNSResolveAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSupportsDNSResolveAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readUTCTimeAttribute(long chipClusterPtr,
        UTCTimeAttributeCallback callback
    );
    private native void subscribeUTCTimeAttribute(long chipClusterPtr,
        UTCTimeAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGranularityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeGranularityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTimeSourceAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeTimeSourceAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDefaultNTPAttribute(long chipClusterPtr,
        DefaultNTPAttributeCallback callback
    );
    private native void subscribeDefaultNTPAttribute(long chipClusterPtr,
        DefaultNTPAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readTimeZoneAttribute(long chipClusterPtr,
        TimeZoneAttributeCallback callback
    );
    private native void subscribeTimeZoneAttribute(long chipClusterPtr,
        TimeZoneAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readDSTOffsetAttribute(long chipClusterPtr,
        DSTOffsetAttributeCallback callback
    );
    private native void subscribeDSTOffsetAttribute(long chipClusterPtr,
        DSTOffsetAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readLocalTimeAttribute(long chipClusterPtr,
        LocalTimeAttributeCallback callback
    );
    private native void subscribeLocalTimeAttribute(long chipClusterPtr,
        LocalTimeAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readTimeZoneDatabaseAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeTimeZoneDatabaseAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNTPServerAvailableAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeNTPServerAvailableAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTimeZoneListMaxSizeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeTimeZoneListMaxSizeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDSTOffsetListMaxSizeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDSTOffsetListMaxSizeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSupportsDNSResolveAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeSupportsDNSResolveAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class BridgedDeviceBasicInformationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 57L;

    public BridgedDeviceBasicInformationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readVendorNameAttribute(
      CharStringAttributeCallback callback
    ) {
      readVendorNameAttribute(chipClusterPtr, callback);
    }
    public void subscribeVendorNameAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeVendorNameAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readVendorIDAttribute(
      IntegerAttributeCallback callback
    ) {
      readVendorIDAttribute(chipClusterPtr, callback);
    }
    public void subscribeVendorIDAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeVendorIDAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readProductNameAttribute(
      CharStringAttributeCallback callback
    ) {
      readProductNameAttribute(chipClusterPtr, callback);
    }
    public void subscribeProductNameAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeProductNameAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNodeLabelAttribute(
      CharStringAttributeCallback callback
    ) {
      readNodeLabelAttribute(chipClusterPtr, callback);
    }
    public void writeNodeLabelAttribute(DefaultClusterCallback callback, String value) {
      writeNodeLabelAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeNodeLabelAttribute(DefaultClusterCallback callback, String value, int timedWriteTimeoutMs) {
      writeNodeLabelAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeNodeLabelAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNodeLabelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readHardwareVersionAttribute(
      IntegerAttributeCallback callback
    ) {
      readHardwareVersionAttribute(chipClusterPtr, callback);
    }
    public void subscribeHardwareVersionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeHardwareVersionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readHardwareVersionStringAttribute(
      CharStringAttributeCallback callback
    ) {
      readHardwareVersionStringAttribute(chipClusterPtr, callback);
    }
    public void subscribeHardwareVersionStringAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeHardwareVersionStringAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSoftwareVersionAttribute(
      LongAttributeCallback callback
    ) {
      readSoftwareVersionAttribute(chipClusterPtr, callback);
    }
    public void subscribeSoftwareVersionAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSoftwareVersionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSoftwareVersionStringAttribute(
      CharStringAttributeCallback callback
    ) {
      readSoftwareVersionStringAttribute(chipClusterPtr, callback);
    }
    public void subscribeSoftwareVersionStringAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSoftwareVersionStringAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readManufacturingDateAttribute(
      CharStringAttributeCallback callback
    ) {
      readManufacturingDateAttribute(chipClusterPtr, callback);
    }
    public void subscribeManufacturingDateAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeManufacturingDateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPartNumberAttribute(
      CharStringAttributeCallback callback
    ) {
      readPartNumberAttribute(chipClusterPtr, callback);
    }
    public void subscribePartNumberAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePartNumberAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readProductURLAttribute(
      CharStringAttributeCallback callback
    ) {
      readProductURLAttribute(chipClusterPtr, callback);
    }
    public void subscribeProductURLAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeProductURLAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readProductLabelAttribute(
      CharStringAttributeCallback callback
    ) {
      readProductLabelAttribute(chipClusterPtr, callback);
    }
    public void subscribeProductLabelAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeProductLabelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSerialNumberAttribute(
      CharStringAttributeCallback callback
    ) {
      readSerialNumberAttribute(chipClusterPtr, callback);
    }
    public void subscribeSerialNumberAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSerialNumberAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readReachableAttribute(
      BooleanAttributeCallback callback
    ) {
      readReachableAttribute(chipClusterPtr, callback);
    }
    public void subscribeReachableAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeReachableAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUniqueIDAttribute(
      CharStringAttributeCallback callback
    ) {
      readUniqueIDAttribute(chipClusterPtr, callback);
    }
    public void subscribeUniqueIDAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeUniqueIDAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readVendorNameAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeVendorNameAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readVendorIDAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeVendorIDAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readProductNameAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeProductNameAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNodeLabelAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );

    private native void writeNodeLabelAttribute(long chipClusterPtr, DefaultClusterCallback callback, String value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeNodeLabelAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readHardwareVersionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeHardwareVersionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readHardwareVersionStringAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeHardwareVersionStringAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSoftwareVersionAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeSoftwareVersionAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSoftwareVersionStringAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeSoftwareVersionStringAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readManufacturingDateAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeManufacturingDateAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPartNumberAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribePartNumberAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readProductURLAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeProductURLAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readProductLabelAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeProductLabelAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSerialNumberAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeSerialNumberAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readReachableAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeReachableAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readUniqueIDAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeUniqueIDAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class SwitchCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 59L;

    public SwitchCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readNumberOfPositionsAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfPositionsAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfPositionsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfPositionsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentPositionAttribute(
      IntegerAttributeCallback callback
    ) {
      readCurrentPositionAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentPositionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentPositionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMultiPressMaxAttribute(
      IntegerAttributeCallback callback
    ) {
      readMultiPressMaxAttribute(chipClusterPtr, callback);
    }
    public void subscribeMultiPressMaxAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMultiPressMaxAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readNumberOfPositionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfPositionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentPositionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCurrentPositionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMultiPressMaxAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMultiPressMaxAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class AdministratorCommissioningCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 60L;

    public AdministratorCommissioningCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);


    public void openCommissioningWindow(DefaultClusterCallback callback
      , Integer commissioningTimeout, byte[] PAKEPasscodeVerifier, Integer discriminator, Long iterations, byte[] salt
      , int timedInvokeTimeoutMs) {
      openCommissioningWindow(chipClusterPtr, callback, commissioningTimeout, PAKEPasscodeVerifier, discriminator, iterations, salt, timedInvokeTimeoutMs);
    }


    public void openBasicCommissioningWindow(DefaultClusterCallback callback
      , Integer commissioningTimeout
      , int timedInvokeTimeoutMs) {
      openBasicCommissioningWindow(chipClusterPtr, callback, commissioningTimeout, timedInvokeTimeoutMs);
    }


    public void revokeCommissioning(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      revokeCommissioning(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }
    private native void openCommissioningWindow(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer commissioningTimeout, byte[] PAKEPasscodeVerifier, Integer discriminator, Long iterations, byte[] salt
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void openBasicCommissioningWindow(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer commissioningTimeout
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void revokeCommissioning(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface AdminFabricIndexAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AdminVendorIdAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readWindowStatusAttribute(
      IntegerAttributeCallback callback
    ) {
      readWindowStatusAttribute(chipClusterPtr, callback);
    }
    public void subscribeWindowStatusAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeWindowStatusAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAdminFabricIndexAttribute(
      AdminFabricIndexAttributeCallback callback
    ) {
      readAdminFabricIndexAttribute(chipClusterPtr, callback);
    }
    public void subscribeAdminFabricIndexAttribute(
        AdminFabricIndexAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAdminFabricIndexAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAdminVendorIdAttribute(
      AdminVendorIdAttributeCallback callback
    ) {
      readAdminVendorIdAttribute(chipClusterPtr, callback);
    }
    public void subscribeAdminVendorIdAttribute(
        AdminVendorIdAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAdminVendorIdAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readWindowStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeWindowStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readAdminFabricIndexAttribute(long chipClusterPtr,
        AdminFabricIndexAttributeCallback callback
    );
    private native void subscribeAdminFabricIndexAttribute(long chipClusterPtr,
        AdminFabricIndexAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAdminVendorIdAttribute(long chipClusterPtr,
        AdminVendorIdAttributeCallback callback
    );
    private native void subscribeAdminVendorIdAttribute(long chipClusterPtr,
        AdminVendorIdAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class OperationalCredentialsCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 62L;

    public OperationalCredentialsCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void attestationRequest(AttestationResponseCallback callback
      , byte[] attestationNonce) {
      attestationRequest(chipClusterPtr, callback, attestationNonce, null);
    }

    public void attestationRequest(AttestationResponseCallback callback
      , byte[] attestationNonce
      , int timedInvokeTimeoutMs) {
      attestationRequest(chipClusterPtr, callback, attestationNonce, timedInvokeTimeoutMs);
    }

    public void certificateChainRequest(CertificateChainResponseCallback callback
      , Integer certificateType) {
      certificateChainRequest(chipClusterPtr, callback, certificateType, null);
    }

    public void certificateChainRequest(CertificateChainResponseCallback callback
      , Integer certificateType
      , int timedInvokeTimeoutMs) {
      certificateChainRequest(chipClusterPtr, callback, certificateType, timedInvokeTimeoutMs);
    }

    public void CSRRequest(CSRResponseCallback callback
      , byte[] CSRNonce, Optional<Boolean> isForUpdateNOC) {
      CSRRequest(chipClusterPtr, callback, CSRNonce, isForUpdateNOC, null);
    }

    public void CSRRequest(CSRResponseCallback callback
      , byte[] CSRNonce, Optional<Boolean> isForUpdateNOC
      , int timedInvokeTimeoutMs) {
      CSRRequest(chipClusterPtr, callback, CSRNonce, isForUpdateNOC, timedInvokeTimeoutMs);
    }

    public void addNOC(NOCResponseCallback callback
      , byte[] NOCValue, Optional<byte[]> ICACValue, byte[] IPKValue, Long caseAdminSubject, Integer adminVendorId) {
      addNOC(chipClusterPtr, callback, NOCValue, ICACValue, IPKValue, caseAdminSubject, adminVendorId, null);
    }

    public void addNOC(NOCResponseCallback callback
      , byte[] NOCValue, Optional<byte[]> ICACValue, byte[] IPKValue, Long caseAdminSubject, Integer adminVendorId
      , int timedInvokeTimeoutMs) {
      addNOC(chipClusterPtr, callback, NOCValue, ICACValue, IPKValue, caseAdminSubject, adminVendorId, timedInvokeTimeoutMs);
    }

    public void updateNOC(NOCResponseCallback callback
      , byte[] NOCValue, Optional<byte[]> ICACValue) {
      updateNOC(chipClusterPtr, callback, NOCValue, ICACValue, null);
    }

    public void updateNOC(NOCResponseCallback callback
      , byte[] NOCValue, Optional<byte[]> ICACValue
      , int timedInvokeTimeoutMs) {
      updateNOC(chipClusterPtr, callback, NOCValue, ICACValue, timedInvokeTimeoutMs);
    }

    public void updateFabricLabel(NOCResponseCallback callback
      , String label) {
      updateFabricLabel(chipClusterPtr, callback, label, null);
    }

    public void updateFabricLabel(NOCResponseCallback callback
      , String label
      , int timedInvokeTimeoutMs) {
      updateFabricLabel(chipClusterPtr, callback, label, timedInvokeTimeoutMs);
    }

    public void removeFabric(NOCResponseCallback callback
      , Integer fabricIndex) {
      removeFabric(chipClusterPtr, callback, fabricIndex, null);
    }

    public void removeFabric(NOCResponseCallback callback
      , Integer fabricIndex
      , int timedInvokeTimeoutMs) {
      removeFabric(chipClusterPtr, callback, fabricIndex, timedInvokeTimeoutMs);
    }

    public void addTrustedRootCertificate(DefaultClusterCallback callback
      , byte[] rootCACertificate) {
      addTrustedRootCertificate(chipClusterPtr, callback, rootCACertificate, null);
    }

    public void addTrustedRootCertificate(DefaultClusterCallback callback
      , byte[] rootCACertificate
      , int timedInvokeTimeoutMs) {
      addTrustedRootCertificate(chipClusterPtr, callback, rootCACertificate, timedInvokeTimeoutMs);
    }
    private native void attestationRequest(long chipClusterPtr, AttestationResponseCallback Callback
      , byte[] attestationNonce
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void certificateChainRequest(long chipClusterPtr, CertificateChainResponseCallback Callback
      , Integer certificateType
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void CSRRequest(long chipClusterPtr, CSRResponseCallback Callback
      , byte[] CSRNonce, Optional<Boolean> isForUpdateNOC
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void addNOC(long chipClusterPtr, NOCResponseCallback Callback
      , byte[] NOCValue, Optional<byte[]> ICACValue, byte[] IPKValue, Long caseAdminSubject, Integer adminVendorId
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void updateNOC(long chipClusterPtr, NOCResponseCallback Callback
      , byte[] NOCValue, Optional<byte[]> ICACValue
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void updateFabricLabel(long chipClusterPtr, NOCResponseCallback Callback
      , String label
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void removeFabric(long chipClusterPtr, NOCResponseCallback Callback
      , Integer fabricIndex
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void addTrustedRootCertificate(long chipClusterPtr, DefaultClusterCallback Callback
      , byte[] rootCACertificate
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface AttestationResponseCallback {
      void onSuccess(byte[] attestationElements, byte[] attestationSignature);
      
      void onError(Exception error);
    }

    public interface CertificateChainResponseCallback {
      void onSuccess(byte[] certificate);
      
      void onError(Exception error);
    }

    public interface CSRResponseCallback {
      void onSuccess(byte[] NOCSRElements, byte[] attestationSignature);
      
      void onError(Exception error);
    }

    public interface NOCResponseCallback {
      void onSuccess(Integer statusCode, Optional<Integer> fabricIndex, Optional<String> debugText);
      
      void onError(Exception error);
    }


      public interface NOCsAttributeCallback {
        void onSuccess( List<ChipStructs.OperationalCredentialsClusterNOCStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface FabricsAttributeCallback {
        void onSuccess( List<ChipStructs.OperationalCredentialsClusterFabricDescriptorStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface TrustedRootCertificatesAttributeCallback {
        void onSuccess( List<byte[]> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readNOCsAttribute(
      NOCsAttributeCallback callback
    ) {
      readNOCsAttribute(chipClusterPtr, callback);
    }
    public void subscribeNOCsAttribute(
        NOCsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeNOCsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFabricsAttribute(
      FabricsAttributeCallback callback
    ) {
      readFabricsAttribute(chipClusterPtr, callback);
    }
    public void subscribeFabricsAttribute(
        FabricsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeFabricsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSupportedFabricsAttribute(
      IntegerAttributeCallback callback
    ) {
      readSupportedFabricsAttribute(chipClusterPtr, callback);
    }
    public void subscribeSupportedFabricsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSupportedFabricsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCommissionedFabricsAttribute(
      IntegerAttributeCallback callback
    ) {
      readCommissionedFabricsAttribute(chipClusterPtr, callback);
    }
    public void subscribeCommissionedFabricsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCommissionedFabricsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTrustedRootCertificatesAttribute(
      TrustedRootCertificatesAttributeCallback callback
    ) {
      readTrustedRootCertificatesAttribute(chipClusterPtr, callback);
    }
    public void subscribeTrustedRootCertificatesAttribute(
        TrustedRootCertificatesAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeTrustedRootCertificatesAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentFabricIndexAttribute(
      IntegerAttributeCallback callback
    ) {
      readCurrentFabricIndexAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentFabricIndexAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentFabricIndexAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readNOCsAttribute(long chipClusterPtr,
        NOCsAttributeCallback callback
    );
    private native void subscribeNOCsAttribute(long chipClusterPtr,
        NOCsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFabricsAttribute(long chipClusterPtr,
        FabricsAttributeCallback callback
    );
    private native void subscribeFabricsAttribute(long chipClusterPtr,
        FabricsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readSupportedFabricsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeSupportedFabricsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCommissionedFabricsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCommissionedFabricsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTrustedRootCertificatesAttribute(long chipClusterPtr,
        TrustedRootCertificatesAttributeCallback callback
    );
    private native void subscribeTrustedRootCertificatesAttribute(long chipClusterPtr,
        TrustedRootCertificatesAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readCurrentFabricIndexAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCurrentFabricIndexAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class GroupKeyManagementCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 63L;

    public GroupKeyManagementCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void keySetWrite(DefaultClusterCallback callback
      , ChipStructs.GroupKeyManagementClusterGroupKeySetStruct groupKeySet) {
      keySetWrite(chipClusterPtr, callback, groupKeySet, null);
    }

    public void keySetWrite(DefaultClusterCallback callback
      , ChipStructs.GroupKeyManagementClusterGroupKeySetStruct groupKeySet
      , int timedInvokeTimeoutMs) {
      keySetWrite(chipClusterPtr, callback, groupKeySet, timedInvokeTimeoutMs);
    }

    public void keySetRead(KeySetReadResponseCallback callback
      , Integer groupKeySetID) {
      keySetRead(chipClusterPtr, callback, groupKeySetID, null);
    }

    public void keySetRead(KeySetReadResponseCallback callback
      , Integer groupKeySetID
      , int timedInvokeTimeoutMs) {
      keySetRead(chipClusterPtr, callback, groupKeySetID, timedInvokeTimeoutMs);
    }

    public void keySetRemove(DefaultClusterCallback callback
      , Integer groupKeySetID) {
      keySetRemove(chipClusterPtr, callback, groupKeySetID, null);
    }

    public void keySetRemove(DefaultClusterCallback callback
      , Integer groupKeySetID
      , int timedInvokeTimeoutMs) {
      keySetRemove(chipClusterPtr, callback, groupKeySetID, timedInvokeTimeoutMs);
    }

    public void keySetReadAllIndices(KeySetReadAllIndicesResponseCallback callback
      , ArrayList<Integer> groupKeySetIDs) {
      keySetReadAllIndices(chipClusterPtr, callback, groupKeySetIDs, null);
    }

    public void keySetReadAllIndices(KeySetReadAllIndicesResponseCallback callback
      , ArrayList<Integer> groupKeySetIDs
      , int timedInvokeTimeoutMs) {
      keySetReadAllIndices(chipClusterPtr, callback, groupKeySetIDs, timedInvokeTimeoutMs);
    }
    private native void keySetWrite(long chipClusterPtr, DefaultClusterCallback Callback
      , ChipStructs.GroupKeyManagementClusterGroupKeySetStruct groupKeySet
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void keySetRead(long chipClusterPtr, KeySetReadResponseCallback Callback
      , Integer groupKeySetID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void keySetRemove(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer groupKeySetID
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void keySetReadAllIndices(long chipClusterPtr, KeySetReadAllIndicesResponseCallback Callback
      , ArrayList<Integer> groupKeySetIDs
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface KeySetReadResponseCallback {
      void onSuccess(ChipStructs.GroupKeyManagementClusterGroupKeySetStruct groupKeySet);
      
      void onError(Exception error);
    }

    public interface KeySetReadAllIndicesResponseCallback {
      void onSuccess(ArrayList<Integer> groupKeySetIDs);
      
      void onError(Exception error);
    }


      public interface GroupKeyMapAttributeCallback {
        void onSuccess( List<ChipStructs.GroupKeyManagementClusterGroupKeyMapStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GroupTableAttributeCallback {
        void onSuccess( List<ChipStructs.GroupKeyManagementClusterGroupInfoMapStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readGroupKeyMapAttribute(
      GroupKeyMapAttributeCallback callback
    ) {
      readGroupKeyMapAttribute(chipClusterPtr, callback);
    }
    public void writeGroupKeyMapAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.GroupKeyManagementClusterGroupKeyMapStruct> value) {
      writeGroupKeyMapAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeGroupKeyMapAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.GroupKeyManagementClusterGroupKeyMapStruct> value, int timedWriteTimeoutMs) {
      writeGroupKeyMapAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeGroupKeyMapAttribute(
        GroupKeyMapAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGroupKeyMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGroupTableAttribute(
      GroupTableAttributeCallback callback
    ) {
      readGroupTableAttribute(chipClusterPtr, callback);
    }
    public void subscribeGroupTableAttribute(
        GroupTableAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGroupTableAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxGroupsPerFabricAttribute(
      IntegerAttributeCallback callback
    ) {
      readMaxGroupsPerFabricAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxGroupsPerFabricAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaxGroupsPerFabricAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxGroupKeysPerFabricAttribute(
      IntegerAttributeCallback callback
    ) {
      readMaxGroupKeysPerFabricAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxGroupKeysPerFabricAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaxGroupKeysPerFabricAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readGroupKeyMapAttribute(long chipClusterPtr,
        GroupKeyMapAttributeCallback callback
    );

    private native void writeGroupKeyMapAttribute(long chipClusterPtr, DefaultClusterCallback callback, ArrayList<ChipStructs.GroupKeyManagementClusterGroupKeyMapStruct> value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeGroupKeyMapAttribute(long chipClusterPtr,
        GroupKeyMapAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGroupTableAttribute(long chipClusterPtr,
        GroupTableAttributeCallback callback
    );
    private native void subscribeGroupTableAttribute(long chipClusterPtr,
        GroupTableAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMaxGroupsPerFabricAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMaxGroupsPerFabricAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMaxGroupKeysPerFabricAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMaxGroupKeysPerFabricAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class FixedLabelCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 64L;

    public FixedLabelCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface LabelListAttributeCallback {
        void onSuccess( List<ChipStructs.FixedLabelClusterLabelStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readLabelListAttribute(
      LabelListAttributeCallback callback
    ) {
      readLabelListAttribute(chipClusterPtr, callback);
    }
    public void subscribeLabelListAttribute(
        LabelListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLabelListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readLabelListAttribute(long chipClusterPtr,
        LabelListAttributeCallback callback
    );
    private native void subscribeLabelListAttribute(long chipClusterPtr,
        LabelListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class UserLabelCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 65L;

    public UserLabelCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface LabelListAttributeCallback {
        void onSuccess( List<ChipStructs.UserLabelClusterLabelStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readLabelListAttribute(
      LabelListAttributeCallback callback
    ) {
      readLabelListAttribute(chipClusterPtr, callback);
    }
    public void writeLabelListAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.UserLabelClusterLabelStruct> value) {
      writeLabelListAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLabelListAttribute(DefaultClusterCallback callback, ArrayList<ChipStructs.UserLabelClusterLabelStruct> value, int timedWriteTimeoutMs) {
      writeLabelListAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLabelListAttribute(
        LabelListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLabelListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readLabelListAttribute(long chipClusterPtr,
        LabelListAttributeCallback callback
    );

    private native void writeLabelListAttribute(long chipClusterPtr, DefaultClusterCallback callback, ArrayList<ChipStructs.UserLabelClusterLabelStruct> value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLabelListAttribute(long chipClusterPtr,
        LabelListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ProxyConfigurationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 66L;

    public ProxyConfigurationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ProxyDiscoveryCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 67L;

    public ProxyDiscoveryCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ProxyValidCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 68L;

    public ProxyValidCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class BooleanStateCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 69L;

    public BooleanStateCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readStateValueAttribute(
      BooleanAttributeCallback callback
    ) {
      readStateValueAttribute(chipClusterPtr, callback);
    }
    public void subscribeStateValueAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeStateValueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readStateValueAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeStateValueAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class IcdManagementCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 70L;

    public IcdManagementCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void registerClient(RegisterClientResponseCallback callback
      , Long checkInNodeID, Long monitoredSubject, byte[] key, Optional<byte[]> verificationKey) {
      registerClient(chipClusterPtr, callback, checkInNodeID, monitoredSubject, key, verificationKey, null);
    }

    public void registerClient(RegisterClientResponseCallback callback
      , Long checkInNodeID, Long monitoredSubject, byte[] key, Optional<byte[]> verificationKey
      , int timedInvokeTimeoutMs) {
      registerClient(chipClusterPtr, callback, checkInNodeID, monitoredSubject, key, verificationKey, timedInvokeTimeoutMs);
    }

    public void unregisterClient(DefaultClusterCallback callback
      , Long checkInNodeID, Optional<byte[]> key) {
      unregisterClient(chipClusterPtr, callback, checkInNodeID, key, null);
    }

    public void unregisterClient(DefaultClusterCallback callback
      , Long checkInNodeID, Optional<byte[]> key
      , int timedInvokeTimeoutMs) {
      unregisterClient(chipClusterPtr, callback, checkInNodeID, key, timedInvokeTimeoutMs);
    }

    public void stayActiveRequest(DefaultClusterCallback callback
      ) {
      stayActiveRequest(chipClusterPtr, callback, null);
    }

    public void stayActiveRequest(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      stayActiveRequest(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }
    private native void registerClient(long chipClusterPtr, RegisterClientResponseCallback Callback
      , Long checkInNodeID, Long monitoredSubject, byte[] key, Optional<byte[]> verificationKey
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void unregisterClient(long chipClusterPtr, DefaultClusterCallback Callback
      , Long checkInNodeID, Optional<byte[]> key
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void stayActiveRequest(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface RegisterClientResponseCallback {
      void onSuccess(Long ICDCounter);
      
      void onError(Exception error);
    }


      public interface RegisteredClientsAttributeCallback {
        void onSuccess( List<ChipStructs.IcdManagementClusterMonitoringRegistrationStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readIdleModeIntervalAttribute(
      LongAttributeCallback callback
    ) {
      readIdleModeIntervalAttribute(chipClusterPtr, callback);
    }
    public void subscribeIdleModeIntervalAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeIdleModeIntervalAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActiveModeIntervalAttribute(
      LongAttributeCallback callback
    ) {
      readActiveModeIntervalAttribute(chipClusterPtr, callback);
    }
    public void subscribeActiveModeIntervalAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeActiveModeIntervalAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActiveModeThresholdAttribute(
      IntegerAttributeCallback callback
    ) {
      readActiveModeThresholdAttribute(chipClusterPtr, callback);
    }
    public void subscribeActiveModeThresholdAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeActiveModeThresholdAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRegisteredClientsAttribute(
      RegisteredClientsAttributeCallback callback
    ) {
      readRegisteredClientsAttribute(chipClusterPtr, callback);
    }
    public void subscribeRegisteredClientsAttribute(
        RegisteredClientsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeRegisteredClientsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readICDCounterAttribute(
      LongAttributeCallback callback
    ) {
      readICDCounterAttribute(chipClusterPtr, callback);
    }
    public void subscribeICDCounterAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeICDCounterAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClientsSupportedPerFabricAttribute(
      IntegerAttributeCallback callback
    ) {
      readClientsSupportedPerFabricAttribute(chipClusterPtr, callback);
    }
    public void subscribeClientsSupportedPerFabricAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClientsSupportedPerFabricAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readIdleModeIntervalAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeIdleModeIntervalAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readActiveModeIntervalAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeActiveModeIntervalAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readActiveModeThresholdAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeActiveModeThresholdAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRegisteredClientsAttribute(long chipClusterPtr,
        RegisteredClientsAttributeCallback callback
    );
    private native void subscribeRegisteredClientsAttribute(long chipClusterPtr,
        RegisteredClientsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readICDCounterAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeICDCounterAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClientsSupportedPerFabricAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClientsSupportedPerFabricAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ModeSelectCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 80L;

    public ModeSelectCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void changeToMode(DefaultClusterCallback callback
      , Integer newMode) {
      changeToMode(chipClusterPtr, callback, newMode, null);
    }

    public void changeToMode(DefaultClusterCallback callback
      , Integer newMode
      , int timedInvokeTimeoutMs) {
      changeToMode(chipClusterPtr, callback, newMode, timedInvokeTimeoutMs);
    }
    private native void changeToMode(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer newMode
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface StandardNamespaceAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface SupportedModesAttributeCallback {
        void onSuccess( List<ChipStructs.ModeSelectClusterModeOptionStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface StartUpModeAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface OnModeAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readDescriptionAttribute(
      CharStringAttributeCallback callback
    ) {
      readDescriptionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDescriptionAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDescriptionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readStandardNamespaceAttribute(
      StandardNamespaceAttributeCallback callback
    ) {
      readStandardNamespaceAttribute(chipClusterPtr, callback);
    }
    public void subscribeStandardNamespaceAttribute(
        StandardNamespaceAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeStandardNamespaceAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSupportedModesAttribute(
      SupportedModesAttributeCallback callback
    ) {
      readSupportedModesAttribute(chipClusterPtr, callback);
    }
    public void subscribeSupportedModesAttribute(
        SupportedModesAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeSupportedModesAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readCurrentModeAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readStartUpModeAttribute(
      StartUpModeAttributeCallback callback
    ) {
      readStartUpModeAttribute(chipClusterPtr, callback);
    }
    public void writeStartUpModeAttribute(DefaultClusterCallback callback, Integer value) {
      writeStartUpModeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeStartUpModeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeStartUpModeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeStartUpModeAttribute(
        StartUpModeAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeStartUpModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOnModeAttribute(
      OnModeAttributeCallback callback
    ) {
      readOnModeAttribute(chipClusterPtr, callback);
    }
    public void writeOnModeAttribute(DefaultClusterCallback callback, Integer value) {
      writeOnModeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOnModeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOnModeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOnModeAttribute(
        OnModeAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeOnModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readDescriptionAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeDescriptionAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readStandardNamespaceAttribute(long chipClusterPtr,
        StandardNamespaceAttributeCallback callback
    );
    private native void subscribeStandardNamespaceAttribute(long chipClusterPtr,
        StandardNamespaceAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readSupportedModesAttribute(long chipClusterPtr,
        SupportedModesAttributeCallback callback
    );
    private native void subscribeSupportedModesAttribute(long chipClusterPtr,
        SupportedModesAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readCurrentModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCurrentModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readStartUpModeAttribute(long chipClusterPtr,
        StartUpModeAttributeCallback callback
    );

    private native void writeStartUpModeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeStartUpModeAttribute(long chipClusterPtr,
        StartUpModeAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOnModeAttribute(long chipClusterPtr,
        OnModeAttributeCallback callback
    );

    private native void writeOnModeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOnModeAttribute(long chipClusterPtr,
        OnModeAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class TemperatureControlCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 86L;

    public TemperatureControlCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface SupportedTemperatureLevelsAttributeCallback {
        void onSuccess( List<ChipStructs.TemperatureControlClusterTemperatureLevelStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readTemperatureSetpointAttribute(
      IntegerAttributeCallback callback
    ) {
      readTemperatureSetpointAttribute(chipClusterPtr, callback);
    }
    public void subscribeTemperatureSetpointAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTemperatureSetpointAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinTemperatureAttribute(
      IntegerAttributeCallback callback
    ) {
      readMinTemperatureAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinTemperatureAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMinTemperatureAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxTemperatureAttribute(
      IntegerAttributeCallback callback
    ) {
      readMaxTemperatureAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxTemperatureAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaxTemperatureAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readStepAttribute(
      IntegerAttributeCallback callback
    ) {
      readStepAttribute(chipClusterPtr, callback);
    }
    public void subscribeStepAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeStepAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentTemperatureLevelIndexAttribute(
      IntegerAttributeCallback callback
    ) {
      readCurrentTemperatureLevelIndexAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentTemperatureLevelIndexAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentTemperatureLevelIndexAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSupportedTemperatureLevelsAttribute(
      SupportedTemperatureLevelsAttributeCallback callback
    ) {
      readSupportedTemperatureLevelsAttribute(chipClusterPtr, callback);
    }
    public void subscribeSupportedTemperatureLevelsAttribute(
        SupportedTemperatureLevelsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeSupportedTemperatureLevelsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readTemperatureSetpointAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeTemperatureSetpointAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMinTemperatureAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMinTemperatureAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMaxTemperatureAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMaxTemperatureAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readStepAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeStepAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentTemperatureLevelIndexAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCurrentTemperatureLevelIndexAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSupportedTemperatureLevelsAttribute(long chipClusterPtr,
        SupportedTemperatureLevelsAttributeCallback callback
    );
    private native void subscribeSupportedTemperatureLevelsAttribute(long chipClusterPtr,
        SupportedTemperatureLevelsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class RefrigeratorAlarmCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 87L;

    public RefrigeratorAlarmCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void reset(DefaultClusterCallback callback
      , Long alarms, Optional<Long> mask) {
      reset(chipClusterPtr, callback, alarms, mask, null);
    }

    public void reset(DefaultClusterCallback callback
      , Long alarms, Optional<Long> mask
      , int timedInvokeTimeoutMs) {
      reset(chipClusterPtr, callback, alarms, mask, timedInvokeTimeoutMs);
    }
    private native void reset(long chipClusterPtr, DefaultClusterCallback Callback
      , Long alarms, Optional<Long> mask
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readMaskAttribute(
      LongAttributeCallback callback
    ) {
      readMaskAttribute(chipClusterPtr, callback);
    }
    public void writeMaskAttribute(DefaultClusterCallback callback, Long value) {
      writeMaskAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeMaskAttribute(DefaultClusterCallback callback, Long value, int timedWriteTimeoutMs) {
      writeMaskAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeMaskAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaskAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLatchAttribute(
      LongAttributeCallback callback
    ) {
      readLatchAttribute(chipClusterPtr, callback);
    }
    public void subscribeLatchAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLatchAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readStateAttribute(
      LongAttributeCallback callback
    ) {
      readStateAttribute(chipClusterPtr, callback);
    }
    public void subscribeStateAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeStateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readMaskAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );

    private native void writeMaskAttribute(long chipClusterPtr, DefaultClusterCallback callback, Long value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeMaskAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLatchAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeLatchAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readStateAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeStateAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class AirQualityCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 91L;

    public AirQualityCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readAirQualityAttribute(
      IntegerAttributeCallback callback
    ) {
      readAirQualityAttribute(chipClusterPtr, callback);
    }
    public void subscribeAirQualityAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeAirQualityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readAirQualityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeAirQualityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class SmokeCoAlarmCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 92L;

    public SmokeCoAlarmCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void selfTestRequest(DefaultClusterCallback callback
      ) {
      selfTestRequest(chipClusterPtr, callback, null);
    }

    public void selfTestRequest(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      selfTestRequest(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }
    private native void selfTestRequest(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readExpressedStateAttribute(
      IntegerAttributeCallback callback
    ) {
      readExpressedStateAttribute(chipClusterPtr, callback);
    }
    public void subscribeExpressedStateAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeExpressedStateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSmokeStateAttribute(
      IntegerAttributeCallback callback
    ) {
      readSmokeStateAttribute(chipClusterPtr, callback);
    }
    public void subscribeSmokeStateAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSmokeStateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCOStateAttribute(
      IntegerAttributeCallback callback
    ) {
      readCOStateAttribute(chipClusterPtr, callback);
    }
    public void subscribeCOStateAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCOStateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBatteryAlertAttribute(
      IntegerAttributeCallback callback
    ) {
      readBatteryAlertAttribute(chipClusterPtr, callback);
    }
    public void subscribeBatteryAlertAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBatteryAlertAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDeviceMutedAttribute(
      IntegerAttributeCallback callback
    ) {
      readDeviceMutedAttribute(chipClusterPtr, callback);
    }
    public void subscribeDeviceMutedAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDeviceMutedAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTestInProgressAttribute(
      BooleanAttributeCallback callback
    ) {
      readTestInProgressAttribute(chipClusterPtr, callback);
    }
    public void subscribeTestInProgressAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTestInProgressAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readHardwareFaultAlertAttribute(
      BooleanAttributeCallback callback
    ) {
      readHardwareFaultAlertAttribute(chipClusterPtr, callback);
    }
    public void subscribeHardwareFaultAlertAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeHardwareFaultAlertAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEndOfServiceAlertAttribute(
      IntegerAttributeCallback callback
    ) {
      readEndOfServiceAlertAttribute(chipClusterPtr, callback);
    }
    public void subscribeEndOfServiceAlertAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeEndOfServiceAlertAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInterconnectSmokeAlarmAttribute(
      IntegerAttributeCallback callback
    ) {
      readInterconnectSmokeAlarmAttribute(chipClusterPtr, callback);
    }
    public void subscribeInterconnectSmokeAlarmAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInterconnectSmokeAlarmAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInterconnectCOAlarmAttribute(
      IntegerAttributeCallback callback
    ) {
      readInterconnectCOAlarmAttribute(chipClusterPtr, callback);
    }
    public void subscribeInterconnectCOAlarmAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInterconnectCOAlarmAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readContaminationStateAttribute(
      IntegerAttributeCallback callback
    ) {
      readContaminationStateAttribute(chipClusterPtr, callback);
    }
    public void subscribeContaminationStateAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeContaminationStateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSensitivityLevelAttribute(
      IntegerAttributeCallback callback
    ) {
      readSensitivityLevelAttribute(chipClusterPtr, callback);
    }
    public void writeSensitivityLevelAttribute(DefaultClusterCallback callback, Integer value) {
      writeSensitivityLevelAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeSensitivityLevelAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeSensitivityLevelAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeSensitivityLevelAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSensitivityLevelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readExpressedStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeExpressedStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSmokeStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeSmokeStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCOStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCOStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBatteryAlertAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBatteryAlertAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDeviceMutedAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDeviceMutedAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTestInProgressAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeTestInProgressAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readHardwareFaultAlertAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeHardwareFaultAlertAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readEndOfServiceAlertAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeEndOfServiceAlertAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInterconnectSmokeAlarmAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeInterconnectSmokeAlarmAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInterconnectCOAlarmAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeInterconnectCOAlarmAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readContaminationStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeContaminationStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSensitivityLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeSensitivityLevelAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeSensitivityLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class OperationalStateCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 96L;

    public OperationalStateCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface PhaseListAttributeCallback {
        void onSuccess(@Nullable List<String> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface CurrentPhaseAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface CountdownTimeAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface OperationalStateListAttributeCallback {
        void onSuccess( List<ChipStructs.OperationalStateClusterOperationalStateStruct> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readPhaseListAttribute(
      PhaseListAttributeCallback callback
    ) {
      readPhaseListAttribute(chipClusterPtr, callback);
    }
    public void subscribePhaseListAttribute(
        PhaseListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePhaseListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentPhaseAttribute(
      CurrentPhaseAttributeCallback callback
    ) {
      readCurrentPhaseAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentPhaseAttribute(
        CurrentPhaseAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCurrentPhaseAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCountdownTimeAttribute(
      CountdownTimeAttributeCallback callback
    ) {
      readCountdownTimeAttribute(chipClusterPtr, callback);
    }
    public void subscribeCountdownTimeAttribute(
        CountdownTimeAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCountdownTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOperationalStateListAttribute(
      OperationalStateListAttributeCallback callback
    ) {
      readOperationalStateListAttribute(chipClusterPtr, callback);
    }
    public void subscribeOperationalStateListAttribute(
        OperationalStateListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeOperationalStateListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readPhaseListAttribute(long chipClusterPtr,
        PhaseListAttributeCallback callback
    );
    private native void subscribePhaseListAttribute(long chipClusterPtr,
        PhaseListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readCurrentPhaseAttribute(long chipClusterPtr,
        CurrentPhaseAttributeCallback callback
    );
    private native void subscribeCurrentPhaseAttribute(long chipClusterPtr,
        CurrentPhaseAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readCountdownTimeAttribute(long chipClusterPtr,
        CountdownTimeAttributeCallback callback
    );
    private native void subscribeCountdownTimeAttribute(long chipClusterPtr,
        CountdownTimeAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOperationalStateListAttribute(long chipClusterPtr,
        OperationalStateListAttributeCallback callback
    );
    private native void subscribeOperationalStateListAttribute(long chipClusterPtr,
        OperationalStateListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class HepaFilterMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 113L;

    public HepaFilterMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ActivatedCarbonFilterMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 114L;

    public ActivatedCarbonFilterMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class CeramicFilterMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 115L;

    public CeramicFilterMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ElectrostaticFilterMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 116L;

    public ElectrostaticFilterMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class UvFilterMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 117L;

    public UvFilterMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class IonizingFilterMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 118L;

    public IonizingFilterMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ZeoliteFilterMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 119L;

    public ZeoliteFilterMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class OzoneFilterMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 120L;

    public OzoneFilterMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class WaterTankMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 121L;

    public WaterTankMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class FuelTankMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 122L;

    public FuelTankMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class InkCartridgeMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 123L;

    public InkCartridgeMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class TonerCartridgeMonitoringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 124L;

    public TonerCartridgeMonitoringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readConditionAttribute(
      IntegerAttributeCallback callback
    ) {
      readConditionAttribute(chipClusterPtr, callback);
    }
    public void subscribeConditionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConditionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDegradationDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readDegradationDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeDegradationDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDegradationDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readChangeIndicationAttribute(
      IntegerAttributeCallback callback
    ) {
      readChangeIndicationAttribute(chipClusterPtr, callback);
    }
    public void subscribeChangeIndicationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeChangeIndicationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInPlaceIndicatorAttribute(
      BooleanAttributeCallback callback
    ) {
      readInPlaceIndicatorAttribute(chipClusterPtr, callback);
    }
    public void subscribeInPlaceIndicatorAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInPlaceIndicatorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConditionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDegradationDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeChangeIndicationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeInPlaceIndicatorAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class DoorLockCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 257L;

    public DoorLockCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);


    public void lockDoor(DefaultClusterCallback callback
      , Optional<byte[]> PINCode
      , int timedInvokeTimeoutMs) {
      lockDoor(chipClusterPtr, callback, PINCode, timedInvokeTimeoutMs);
    }


    public void unlockDoor(DefaultClusterCallback callback
      , Optional<byte[]> PINCode
      , int timedInvokeTimeoutMs) {
      unlockDoor(chipClusterPtr, callback, PINCode, timedInvokeTimeoutMs);
    }


    public void unlockWithTimeout(DefaultClusterCallback callback
      , Integer timeout, Optional<byte[]> PINCode
      , int timedInvokeTimeoutMs) {
      unlockWithTimeout(chipClusterPtr, callback, timeout, PINCode, timedInvokeTimeoutMs);
    }

    public void setWeekDaySchedule(DefaultClusterCallback callback
      , Integer weekDayIndex, Integer userIndex, Integer daysMask, Integer startHour, Integer startMinute, Integer endHour, Integer endMinute) {
      setWeekDaySchedule(chipClusterPtr, callback, weekDayIndex, userIndex, daysMask, startHour, startMinute, endHour, endMinute, null);
    }

    public void setWeekDaySchedule(DefaultClusterCallback callback
      , Integer weekDayIndex, Integer userIndex, Integer daysMask, Integer startHour, Integer startMinute, Integer endHour, Integer endMinute
      , int timedInvokeTimeoutMs) {
      setWeekDaySchedule(chipClusterPtr, callback, weekDayIndex, userIndex, daysMask, startHour, startMinute, endHour, endMinute, timedInvokeTimeoutMs);
    }

    public void getWeekDaySchedule(GetWeekDayScheduleResponseCallback callback
      , Integer weekDayIndex, Integer userIndex) {
      getWeekDaySchedule(chipClusterPtr, callback, weekDayIndex, userIndex, null);
    }

    public void getWeekDaySchedule(GetWeekDayScheduleResponseCallback callback
      , Integer weekDayIndex, Integer userIndex
      , int timedInvokeTimeoutMs) {
      getWeekDaySchedule(chipClusterPtr, callback, weekDayIndex, userIndex, timedInvokeTimeoutMs);
    }

    public void clearWeekDaySchedule(DefaultClusterCallback callback
      , Integer weekDayIndex, Integer userIndex) {
      clearWeekDaySchedule(chipClusterPtr, callback, weekDayIndex, userIndex, null);
    }

    public void clearWeekDaySchedule(DefaultClusterCallback callback
      , Integer weekDayIndex, Integer userIndex
      , int timedInvokeTimeoutMs) {
      clearWeekDaySchedule(chipClusterPtr, callback, weekDayIndex, userIndex, timedInvokeTimeoutMs);
    }

    public void setYearDaySchedule(DefaultClusterCallback callback
      , Integer yearDayIndex, Integer userIndex, Long localStartTime, Long localEndTime) {
      setYearDaySchedule(chipClusterPtr, callback, yearDayIndex, userIndex, localStartTime, localEndTime, null);
    }

    public void setYearDaySchedule(DefaultClusterCallback callback
      , Integer yearDayIndex, Integer userIndex, Long localStartTime, Long localEndTime
      , int timedInvokeTimeoutMs) {
      setYearDaySchedule(chipClusterPtr, callback, yearDayIndex, userIndex, localStartTime, localEndTime, timedInvokeTimeoutMs);
    }

    public void getYearDaySchedule(GetYearDayScheduleResponseCallback callback
      , Integer yearDayIndex, Integer userIndex) {
      getYearDaySchedule(chipClusterPtr, callback, yearDayIndex, userIndex, null);
    }

    public void getYearDaySchedule(GetYearDayScheduleResponseCallback callback
      , Integer yearDayIndex, Integer userIndex
      , int timedInvokeTimeoutMs) {
      getYearDaySchedule(chipClusterPtr, callback, yearDayIndex, userIndex, timedInvokeTimeoutMs);
    }

    public void clearYearDaySchedule(DefaultClusterCallback callback
      , Integer yearDayIndex, Integer userIndex) {
      clearYearDaySchedule(chipClusterPtr, callback, yearDayIndex, userIndex, null);
    }

    public void clearYearDaySchedule(DefaultClusterCallback callback
      , Integer yearDayIndex, Integer userIndex
      , int timedInvokeTimeoutMs) {
      clearYearDaySchedule(chipClusterPtr, callback, yearDayIndex, userIndex, timedInvokeTimeoutMs);
    }

    public void setHolidaySchedule(DefaultClusterCallback callback
      , Integer holidayIndex, Long localStartTime, Long localEndTime, Integer operatingMode) {
      setHolidaySchedule(chipClusterPtr, callback, holidayIndex, localStartTime, localEndTime, operatingMode, null);
    }

    public void setHolidaySchedule(DefaultClusterCallback callback
      , Integer holidayIndex, Long localStartTime, Long localEndTime, Integer operatingMode
      , int timedInvokeTimeoutMs) {
      setHolidaySchedule(chipClusterPtr, callback, holidayIndex, localStartTime, localEndTime, operatingMode, timedInvokeTimeoutMs);
    }

    public void getHolidaySchedule(GetHolidayScheduleResponseCallback callback
      , Integer holidayIndex) {
      getHolidaySchedule(chipClusterPtr, callback, holidayIndex, null);
    }

    public void getHolidaySchedule(GetHolidayScheduleResponseCallback callback
      , Integer holidayIndex
      , int timedInvokeTimeoutMs) {
      getHolidaySchedule(chipClusterPtr, callback, holidayIndex, timedInvokeTimeoutMs);
    }

    public void clearHolidaySchedule(DefaultClusterCallback callback
      , Integer holidayIndex) {
      clearHolidaySchedule(chipClusterPtr, callback, holidayIndex, null);
    }

    public void clearHolidaySchedule(DefaultClusterCallback callback
      , Integer holidayIndex
      , int timedInvokeTimeoutMs) {
      clearHolidaySchedule(chipClusterPtr, callback, holidayIndex, timedInvokeTimeoutMs);
    }


    public void setUser(DefaultClusterCallback callback
      , Integer operationType, Integer userIndex, @Nullable String userName, @Nullable Long userUniqueID, @Nullable Integer userStatus, @Nullable Integer userType, @Nullable Integer credentialRule
      , int timedInvokeTimeoutMs) {
      setUser(chipClusterPtr, callback, operationType, userIndex, userName, userUniqueID, userStatus, userType, credentialRule, timedInvokeTimeoutMs);
    }

    public void getUser(GetUserResponseCallback callback
      , Integer userIndex) {
      getUser(chipClusterPtr, callback, userIndex, null);
    }

    public void getUser(GetUserResponseCallback callback
      , Integer userIndex
      , int timedInvokeTimeoutMs) {
      getUser(chipClusterPtr, callback, userIndex, timedInvokeTimeoutMs);
    }


    public void clearUser(DefaultClusterCallback callback
      , Integer userIndex
      , int timedInvokeTimeoutMs) {
      clearUser(chipClusterPtr, callback, userIndex, timedInvokeTimeoutMs);
    }


    public void setCredential(SetCredentialResponseCallback callback
      , Integer operationType, ChipStructs.DoorLockClusterCredentialStruct credential, byte[] credentialData, @Nullable Integer userIndex, @Nullable Integer userStatus, @Nullable Integer userType
      , int timedInvokeTimeoutMs) {
      setCredential(chipClusterPtr, callback, operationType, credential, credentialData, userIndex, userStatus, userType, timedInvokeTimeoutMs);
    }

    public void getCredentialStatus(GetCredentialStatusResponseCallback callback
      , ChipStructs.DoorLockClusterCredentialStruct credential) {
      getCredentialStatus(chipClusterPtr, callback, credential, null);
    }

    public void getCredentialStatus(GetCredentialStatusResponseCallback callback
      , ChipStructs.DoorLockClusterCredentialStruct credential
      , int timedInvokeTimeoutMs) {
      getCredentialStatus(chipClusterPtr, callback, credential, timedInvokeTimeoutMs);
    }


    public void clearCredential(DefaultClusterCallback callback
      , @Nullable ChipStructs.DoorLockClusterCredentialStruct credential
      , int timedInvokeTimeoutMs) {
      clearCredential(chipClusterPtr, callback, credential, timedInvokeTimeoutMs);
    }
    private native void lockDoor(long chipClusterPtr, DefaultClusterCallback Callback
      , Optional<byte[]> PINCode
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void unlockDoor(long chipClusterPtr, DefaultClusterCallback Callback
      , Optional<byte[]> PINCode
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void unlockWithTimeout(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer timeout, Optional<byte[]> PINCode
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void setWeekDaySchedule(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer weekDayIndex, Integer userIndex, Integer daysMask, Integer startHour, Integer startMinute, Integer endHour, Integer endMinute
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void getWeekDaySchedule(long chipClusterPtr, GetWeekDayScheduleResponseCallback Callback
      , Integer weekDayIndex, Integer userIndex
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void clearWeekDaySchedule(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer weekDayIndex, Integer userIndex
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void setYearDaySchedule(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer yearDayIndex, Integer userIndex, Long localStartTime, Long localEndTime
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void getYearDaySchedule(long chipClusterPtr, GetYearDayScheduleResponseCallback Callback
      , Integer yearDayIndex, Integer userIndex
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void clearYearDaySchedule(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer yearDayIndex, Integer userIndex
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void setHolidaySchedule(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer holidayIndex, Long localStartTime, Long localEndTime, Integer operatingMode
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void getHolidaySchedule(long chipClusterPtr, GetHolidayScheduleResponseCallback Callback
      , Integer holidayIndex
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void clearHolidaySchedule(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer holidayIndex
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void setUser(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer operationType, Integer userIndex, @Nullable String userName, @Nullable Long userUniqueID, @Nullable Integer userStatus, @Nullable Integer userType, @Nullable Integer credentialRule
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void getUser(long chipClusterPtr, GetUserResponseCallback Callback
      , Integer userIndex
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void clearUser(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer userIndex
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void setCredential(long chipClusterPtr, SetCredentialResponseCallback Callback
      , Integer operationType, ChipStructs.DoorLockClusterCredentialStruct credential, byte[] credentialData, @Nullable Integer userIndex, @Nullable Integer userStatus, @Nullable Integer userType
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void getCredentialStatus(long chipClusterPtr, GetCredentialStatusResponseCallback Callback
      , ChipStructs.DoorLockClusterCredentialStruct credential
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void clearCredential(long chipClusterPtr, DefaultClusterCallback Callback
      , @Nullable ChipStructs.DoorLockClusterCredentialStruct credential
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface GetWeekDayScheduleResponseCallback {
      void onSuccess(Integer weekDayIndex, Integer userIndex, Integer status, Optional<Integer> daysMask, Optional<Integer> startHour, Optional<Integer> startMinute, Optional<Integer> endHour, Optional<Integer> endMinute);
      
      void onError(Exception error);
    }

    public interface GetYearDayScheduleResponseCallback {
      void onSuccess(Integer yearDayIndex, Integer userIndex, Integer status, Optional<Long> localStartTime, Optional<Long> localEndTime);
      
      void onError(Exception error);
    }

    public interface GetHolidayScheduleResponseCallback {
      void onSuccess(Integer holidayIndex, Integer status, Optional<Long> localStartTime, Optional<Long> localEndTime, Optional<Integer> operatingMode);
      
      void onError(Exception error);
    }

    public interface GetUserResponseCallback {
      void onSuccess(Integer userIndex, @Nullable String userName, @Nullable Long userUniqueID, @Nullable Integer userStatus, @Nullable Integer userType, @Nullable Integer credentialRule, @Nullable ArrayList<ChipStructs.DoorLockClusterCredentialStruct> credentials, @Nullable Integer creatorFabricIndex, @Nullable Integer lastModifiedFabricIndex, @Nullable Integer nextUserIndex);
      
      void onError(Exception error);
    }

    public interface SetCredentialResponseCallback {
      void onSuccess(Integer status, @Nullable Integer userIndex, @Nullable Integer nextCredentialIndex);
      
      void onError(Exception error);
    }

    public interface GetCredentialStatusResponseCallback {
      void onSuccess(Boolean credentialExists, @Nullable Integer userIndex, @Nullable Integer creatorFabricIndex, @Nullable Integer lastModifiedFabricIndex, @Nullable Integer nextCredentialIndex);
      
      void onError(Exception error);
    }


      public interface LockStateAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface DoorStateAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readLockStateAttribute(
      LockStateAttributeCallback callback
    ) {
      readLockStateAttribute(chipClusterPtr, callback);
    }
    public void subscribeLockStateAttribute(
        LockStateAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLockStateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLockTypeAttribute(
      IntegerAttributeCallback callback
    ) {
      readLockTypeAttribute(chipClusterPtr, callback);
    }
    public void subscribeLockTypeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLockTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readActuatorEnabledAttribute(
      BooleanAttributeCallback callback
    ) {
      readActuatorEnabledAttribute(chipClusterPtr, callback);
    }
    public void subscribeActuatorEnabledAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeActuatorEnabledAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDoorStateAttribute(
      DoorStateAttributeCallback callback
    ) {
      readDoorStateAttribute(chipClusterPtr, callback);
    }
    public void subscribeDoorStateAttribute(
        DoorStateAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeDoorStateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDoorOpenEventsAttribute(
      LongAttributeCallback callback
    ) {
      readDoorOpenEventsAttribute(chipClusterPtr, callback);
    }
    public void writeDoorOpenEventsAttribute(DefaultClusterCallback callback, Long value) {
      writeDoorOpenEventsAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeDoorOpenEventsAttribute(DefaultClusterCallback callback, Long value, int timedWriteTimeoutMs) {
      writeDoorOpenEventsAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeDoorOpenEventsAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDoorOpenEventsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDoorClosedEventsAttribute(
      LongAttributeCallback callback
    ) {
      readDoorClosedEventsAttribute(chipClusterPtr, callback);
    }
    public void writeDoorClosedEventsAttribute(DefaultClusterCallback callback, Long value) {
      writeDoorClosedEventsAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeDoorClosedEventsAttribute(DefaultClusterCallback callback, Long value, int timedWriteTimeoutMs) {
      writeDoorClosedEventsAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeDoorClosedEventsAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDoorClosedEventsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOpenPeriodAttribute(
      IntegerAttributeCallback callback
    ) {
      readOpenPeriodAttribute(chipClusterPtr, callback);
    }
    public void writeOpenPeriodAttribute(DefaultClusterCallback callback, Integer value) {
      writeOpenPeriodAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOpenPeriodAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOpenPeriodAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOpenPeriodAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOpenPeriodAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfTotalUsersSupportedAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfTotalUsersSupportedAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfTotalUsersSupportedAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfTotalUsersSupportedAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfPINUsersSupportedAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfPINUsersSupportedAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfPINUsersSupportedAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfPINUsersSupportedAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfRFIDUsersSupportedAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfRFIDUsersSupportedAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfRFIDUsersSupportedAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfRFIDUsersSupportedAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfWeekDaySchedulesSupportedPerUserAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfWeekDaySchedulesSupportedPerUserAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfWeekDaySchedulesSupportedPerUserAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfWeekDaySchedulesSupportedPerUserAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfYearDaySchedulesSupportedPerUserAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfYearDaySchedulesSupportedPerUserAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfYearDaySchedulesSupportedPerUserAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfYearDaySchedulesSupportedPerUserAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfHolidaySchedulesSupportedAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfHolidaySchedulesSupportedAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfHolidaySchedulesSupportedAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfHolidaySchedulesSupportedAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxPINCodeLengthAttribute(
      IntegerAttributeCallback callback
    ) {
      readMaxPINCodeLengthAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxPINCodeLengthAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaxPINCodeLengthAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinPINCodeLengthAttribute(
      IntegerAttributeCallback callback
    ) {
      readMinPINCodeLengthAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinPINCodeLengthAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMinPINCodeLengthAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxRFIDCodeLengthAttribute(
      IntegerAttributeCallback callback
    ) {
      readMaxRFIDCodeLengthAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxRFIDCodeLengthAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaxRFIDCodeLengthAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinRFIDCodeLengthAttribute(
      IntegerAttributeCallback callback
    ) {
      readMinRFIDCodeLengthAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinRFIDCodeLengthAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMinRFIDCodeLengthAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCredentialRulesSupportAttribute(
      IntegerAttributeCallback callback
    ) {
      readCredentialRulesSupportAttribute(chipClusterPtr, callback);
    }
    public void subscribeCredentialRulesSupportAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCredentialRulesSupportAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfCredentialsSupportedPerUserAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfCredentialsSupportedPerUserAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfCredentialsSupportedPerUserAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfCredentialsSupportedPerUserAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLanguageAttribute(
      CharStringAttributeCallback callback
    ) {
      readLanguageAttribute(chipClusterPtr, callback);
    }
    public void writeLanguageAttribute(DefaultClusterCallback callback, String value) {
      writeLanguageAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLanguageAttribute(DefaultClusterCallback callback, String value, int timedWriteTimeoutMs) {
      writeLanguageAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLanguageAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLanguageAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLEDSettingsAttribute(
      IntegerAttributeCallback callback
    ) {
      readLEDSettingsAttribute(chipClusterPtr, callback);
    }
    public void writeLEDSettingsAttribute(DefaultClusterCallback callback, Integer value) {
      writeLEDSettingsAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLEDSettingsAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeLEDSettingsAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLEDSettingsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLEDSettingsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAutoRelockTimeAttribute(
      LongAttributeCallback callback
    ) {
      readAutoRelockTimeAttribute(chipClusterPtr, callback);
    }
    public void writeAutoRelockTimeAttribute(DefaultClusterCallback callback, Long value) {
      writeAutoRelockTimeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeAutoRelockTimeAttribute(DefaultClusterCallback callback, Long value, int timedWriteTimeoutMs) {
      writeAutoRelockTimeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeAutoRelockTimeAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeAutoRelockTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSoundVolumeAttribute(
      IntegerAttributeCallback callback
    ) {
      readSoundVolumeAttribute(chipClusterPtr, callback);
    }
    public void writeSoundVolumeAttribute(DefaultClusterCallback callback, Integer value) {
      writeSoundVolumeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeSoundVolumeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeSoundVolumeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeSoundVolumeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSoundVolumeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOperatingModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readOperatingModeAttribute(chipClusterPtr, callback);
    }
    public void writeOperatingModeAttribute(DefaultClusterCallback callback, Integer value) {
      writeOperatingModeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOperatingModeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOperatingModeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOperatingModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOperatingModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSupportedOperatingModesAttribute(
      IntegerAttributeCallback callback
    ) {
      readSupportedOperatingModesAttribute(chipClusterPtr, callback);
    }
    public void subscribeSupportedOperatingModesAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSupportedOperatingModesAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDefaultConfigurationRegisterAttribute(
      IntegerAttributeCallback callback
    ) {
      readDefaultConfigurationRegisterAttribute(chipClusterPtr, callback);
    }
    public void subscribeDefaultConfigurationRegisterAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDefaultConfigurationRegisterAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEnableLocalProgrammingAttribute(
      BooleanAttributeCallback callback
    ) {
      readEnableLocalProgrammingAttribute(chipClusterPtr, callback);
    }
    public void writeEnableLocalProgrammingAttribute(DefaultClusterCallback callback, Boolean value) {
      writeEnableLocalProgrammingAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeEnableLocalProgrammingAttribute(DefaultClusterCallback callback, Boolean value, int timedWriteTimeoutMs) {
      writeEnableLocalProgrammingAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeEnableLocalProgrammingAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeEnableLocalProgrammingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEnableOneTouchLockingAttribute(
      BooleanAttributeCallback callback
    ) {
      readEnableOneTouchLockingAttribute(chipClusterPtr, callback);
    }
    public void writeEnableOneTouchLockingAttribute(DefaultClusterCallback callback, Boolean value) {
      writeEnableOneTouchLockingAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeEnableOneTouchLockingAttribute(DefaultClusterCallback callback, Boolean value, int timedWriteTimeoutMs) {
      writeEnableOneTouchLockingAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeEnableOneTouchLockingAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeEnableOneTouchLockingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEnableInsideStatusLEDAttribute(
      BooleanAttributeCallback callback
    ) {
      readEnableInsideStatusLEDAttribute(chipClusterPtr, callback);
    }
    public void writeEnableInsideStatusLEDAttribute(DefaultClusterCallback callback, Boolean value) {
      writeEnableInsideStatusLEDAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeEnableInsideStatusLEDAttribute(DefaultClusterCallback callback, Boolean value, int timedWriteTimeoutMs) {
      writeEnableInsideStatusLEDAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeEnableInsideStatusLEDAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeEnableInsideStatusLEDAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEnablePrivacyModeButtonAttribute(
      BooleanAttributeCallback callback
    ) {
      readEnablePrivacyModeButtonAttribute(chipClusterPtr, callback);
    }
    public void writeEnablePrivacyModeButtonAttribute(DefaultClusterCallback callback, Boolean value) {
      writeEnablePrivacyModeButtonAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeEnablePrivacyModeButtonAttribute(DefaultClusterCallback callback, Boolean value, int timedWriteTimeoutMs) {
      writeEnablePrivacyModeButtonAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeEnablePrivacyModeButtonAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeEnablePrivacyModeButtonAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLocalProgrammingFeaturesAttribute(
      IntegerAttributeCallback callback
    ) {
      readLocalProgrammingFeaturesAttribute(chipClusterPtr, callback);
    }
    public void writeLocalProgrammingFeaturesAttribute(DefaultClusterCallback callback, Integer value) {
      writeLocalProgrammingFeaturesAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLocalProgrammingFeaturesAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeLocalProgrammingFeaturesAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLocalProgrammingFeaturesAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLocalProgrammingFeaturesAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWrongCodeEntryLimitAttribute(
      IntegerAttributeCallback callback
    ) {
      readWrongCodeEntryLimitAttribute(chipClusterPtr, callback);
    }
    public void writeWrongCodeEntryLimitAttribute(DefaultClusterCallback callback, Integer value) {
      writeWrongCodeEntryLimitAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeWrongCodeEntryLimitAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeWrongCodeEntryLimitAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeWrongCodeEntryLimitAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeWrongCodeEntryLimitAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUserCodeTemporaryDisableTimeAttribute(
      IntegerAttributeCallback callback
    ) {
      readUserCodeTemporaryDisableTimeAttribute(chipClusterPtr, callback);
    }
    public void writeUserCodeTemporaryDisableTimeAttribute(DefaultClusterCallback callback, Integer value) {
      writeUserCodeTemporaryDisableTimeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeUserCodeTemporaryDisableTimeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeUserCodeTemporaryDisableTimeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeUserCodeTemporaryDisableTimeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeUserCodeTemporaryDisableTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSendPINOverTheAirAttribute(
      BooleanAttributeCallback callback
    ) {
      readSendPINOverTheAirAttribute(chipClusterPtr, callback);
    }
    public void writeSendPINOverTheAirAttribute(DefaultClusterCallback callback, Boolean value) {
      writeSendPINOverTheAirAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeSendPINOverTheAirAttribute(DefaultClusterCallback callback, Boolean value, int timedWriteTimeoutMs) {
      writeSendPINOverTheAirAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeSendPINOverTheAirAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSendPINOverTheAirAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRequirePINforRemoteOperationAttribute(
      BooleanAttributeCallback callback
    ) {
      readRequirePINforRemoteOperationAttribute(chipClusterPtr, callback);
    }
    public void writeRequirePINforRemoteOperationAttribute(DefaultClusterCallback callback, Boolean value) {
      writeRequirePINforRemoteOperationAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeRequirePINforRemoteOperationAttribute(DefaultClusterCallback callback, Boolean value, int timedWriteTimeoutMs) {
      writeRequirePINforRemoteOperationAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeRequirePINforRemoteOperationAttribute(
        BooleanAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRequirePINforRemoteOperationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readExpiringUserTimeoutAttribute(
      IntegerAttributeCallback callback
    ) {
      readExpiringUserTimeoutAttribute(chipClusterPtr, callback);
    }
    public void writeExpiringUserTimeoutAttribute(DefaultClusterCallback callback, Integer value) {
      writeExpiringUserTimeoutAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeExpiringUserTimeoutAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeExpiringUserTimeoutAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeExpiringUserTimeoutAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeExpiringUserTimeoutAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readLockStateAttribute(long chipClusterPtr,
        LockStateAttributeCallback callback
    );
    private native void subscribeLockStateAttribute(long chipClusterPtr,
        LockStateAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readLockTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeLockTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readActuatorEnabledAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );
    private native void subscribeActuatorEnabledAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDoorStateAttribute(long chipClusterPtr,
        DoorStateAttributeCallback callback
    );
    private native void subscribeDoorStateAttribute(long chipClusterPtr,
        DoorStateAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readDoorOpenEventsAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );

    private native void writeDoorOpenEventsAttribute(long chipClusterPtr, DefaultClusterCallback callback, Long value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeDoorOpenEventsAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDoorClosedEventsAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );

    private native void writeDoorClosedEventsAttribute(long chipClusterPtr, DefaultClusterCallback callback, Long value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeDoorClosedEventsAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOpenPeriodAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeOpenPeriodAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOpenPeriodAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNumberOfTotalUsersSupportedAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfTotalUsersSupportedAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNumberOfPINUsersSupportedAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfPINUsersSupportedAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNumberOfRFIDUsersSupportedAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfRFIDUsersSupportedAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNumberOfWeekDaySchedulesSupportedPerUserAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfWeekDaySchedulesSupportedPerUserAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNumberOfYearDaySchedulesSupportedPerUserAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfYearDaySchedulesSupportedPerUserAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNumberOfHolidaySchedulesSupportedAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfHolidaySchedulesSupportedAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMaxPINCodeLengthAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMaxPINCodeLengthAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMinPINCodeLengthAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMinPINCodeLengthAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMaxRFIDCodeLengthAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMaxRFIDCodeLengthAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMinRFIDCodeLengthAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeMinRFIDCodeLengthAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCredentialRulesSupportAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCredentialRulesSupportAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNumberOfCredentialsSupportedPerUserAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfCredentialsSupportedPerUserAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLanguageAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );

    private native void writeLanguageAttribute(long chipClusterPtr, DefaultClusterCallback callback, String value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLanguageAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLEDSettingsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeLEDSettingsAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLEDSettingsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readAutoRelockTimeAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );

    private native void writeAutoRelockTimeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Long value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeAutoRelockTimeAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSoundVolumeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeSoundVolumeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeSoundVolumeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOperatingModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeOperatingModeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOperatingModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSupportedOperatingModesAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeSupportedOperatingModesAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDefaultConfigurationRegisterAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDefaultConfigurationRegisterAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readEnableLocalProgrammingAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );

    private native void writeEnableLocalProgrammingAttribute(long chipClusterPtr, DefaultClusterCallback callback, Boolean value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeEnableLocalProgrammingAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readEnableOneTouchLockingAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );

    private native void writeEnableOneTouchLockingAttribute(long chipClusterPtr, DefaultClusterCallback callback, Boolean value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeEnableOneTouchLockingAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readEnableInsideStatusLEDAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );

    private native void writeEnableInsideStatusLEDAttribute(long chipClusterPtr, DefaultClusterCallback callback, Boolean value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeEnableInsideStatusLEDAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readEnablePrivacyModeButtonAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );

    private native void writeEnablePrivacyModeButtonAttribute(long chipClusterPtr, DefaultClusterCallback callback, Boolean value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeEnablePrivacyModeButtonAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLocalProgrammingFeaturesAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeLocalProgrammingFeaturesAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLocalProgrammingFeaturesAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readWrongCodeEntryLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeWrongCodeEntryLimitAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeWrongCodeEntryLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readUserCodeTemporaryDisableTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeUserCodeTemporaryDisableTimeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeUserCodeTemporaryDisableTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSendPINOverTheAirAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );

    private native void writeSendPINOverTheAirAttribute(long chipClusterPtr, DefaultClusterCallback callback, Boolean value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeSendPINOverTheAirAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRequirePINforRemoteOperationAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
    );

    private native void writeRequirePINforRemoteOperationAttribute(long chipClusterPtr, DefaultClusterCallback callback, Boolean value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeRequirePINforRemoteOperationAttribute(long chipClusterPtr,
        BooleanAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readExpiringUserTimeoutAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeExpiringUserTimeoutAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeExpiringUserTimeoutAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class WindowCoveringCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 258L;

    public WindowCoveringCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void upOrOpen(DefaultClusterCallback callback
      ) {
      upOrOpen(chipClusterPtr, callback, null);
    }

    public void upOrOpen(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      upOrOpen(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }

    public void downOrClose(DefaultClusterCallback callback
      ) {
      downOrClose(chipClusterPtr, callback, null);
    }

    public void downOrClose(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      downOrClose(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }

    public void stopMotion(DefaultClusterCallback callback
      ) {
      stopMotion(chipClusterPtr, callback, null);
    }

    public void stopMotion(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      stopMotion(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }

    public void goToLiftValue(DefaultClusterCallback callback
      , Integer liftValue) {
      goToLiftValue(chipClusterPtr, callback, liftValue, null);
    }

    public void goToLiftValue(DefaultClusterCallback callback
      , Integer liftValue
      , int timedInvokeTimeoutMs) {
      goToLiftValue(chipClusterPtr, callback, liftValue, timedInvokeTimeoutMs);
    }

    public void goToLiftPercentage(DefaultClusterCallback callback
      , Integer liftPercent100thsValue) {
      goToLiftPercentage(chipClusterPtr, callback, liftPercent100thsValue, null);
    }

    public void goToLiftPercentage(DefaultClusterCallback callback
      , Integer liftPercent100thsValue
      , int timedInvokeTimeoutMs) {
      goToLiftPercentage(chipClusterPtr, callback, liftPercent100thsValue, timedInvokeTimeoutMs);
    }

    public void goToTiltValue(DefaultClusterCallback callback
      , Integer tiltValue) {
      goToTiltValue(chipClusterPtr, callback, tiltValue, null);
    }

    public void goToTiltValue(DefaultClusterCallback callback
      , Integer tiltValue
      , int timedInvokeTimeoutMs) {
      goToTiltValue(chipClusterPtr, callback, tiltValue, timedInvokeTimeoutMs);
    }

    public void goToTiltPercentage(DefaultClusterCallback callback
      , Integer tiltPercent100thsValue) {
      goToTiltPercentage(chipClusterPtr, callback, tiltPercent100thsValue, null);
    }

    public void goToTiltPercentage(DefaultClusterCallback callback
      , Integer tiltPercent100thsValue
      , int timedInvokeTimeoutMs) {
      goToTiltPercentage(chipClusterPtr, callback, tiltPercent100thsValue, timedInvokeTimeoutMs);
    }
    private native void upOrOpen(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void downOrClose(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void stopMotion(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void goToLiftValue(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer liftValue
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void goToLiftPercentage(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer liftPercent100thsValue
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void goToTiltValue(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer tiltValue
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void goToTiltPercentage(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer tiltPercent100thsValue
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface CurrentPositionLiftAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface CurrentPositionTiltAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface CurrentPositionLiftPercentageAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface CurrentPositionTiltPercentageAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface TargetPositionLiftPercent100thsAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface TargetPositionTiltPercent100thsAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface CurrentPositionLiftPercent100thsAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface CurrentPositionTiltPercent100thsAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readTypeAttribute(
      IntegerAttributeCallback callback
    ) {
      readTypeAttribute(chipClusterPtr, callback);
    }
    public void subscribeTypeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPhysicalClosedLimitLiftAttribute(
      IntegerAttributeCallback callback
    ) {
      readPhysicalClosedLimitLiftAttribute(chipClusterPtr, callback);
    }
    public void subscribePhysicalClosedLimitLiftAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePhysicalClosedLimitLiftAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPhysicalClosedLimitTiltAttribute(
      IntegerAttributeCallback callback
    ) {
      readPhysicalClosedLimitTiltAttribute(chipClusterPtr, callback);
    }
    public void subscribePhysicalClosedLimitTiltAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePhysicalClosedLimitTiltAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentPositionLiftAttribute(
      CurrentPositionLiftAttributeCallback callback
    ) {
      readCurrentPositionLiftAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentPositionLiftAttribute(
        CurrentPositionLiftAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCurrentPositionLiftAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentPositionTiltAttribute(
      CurrentPositionTiltAttributeCallback callback
    ) {
      readCurrentPositionTiltAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentPositionTiltAttribute(
        CurrentPositionTiltAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCurrentPositionTiltAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfActuationsLiftAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfActuationsLiftAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfActuationsLiftAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfActuationsLiftAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfActuationsTiltAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfActuationsTiltAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfActuationsTiltAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfActuationsTiltAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readConfigStatusAttribute(
      IntegerAttributeCallback callback
    ) {
      readConfigStatusAttribute(chipClusterPtr, callback);
    }
    public void subscribeConfigStatusAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeConfigStatusAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentPositionLiftPercentageAttribute(
      CurrentPositionLiftPercentageAttributeCallback callback
    ) {
      readCurrentPositionLiftPercentageAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentPositionLiftPercentageAttribute(
        CurrentPositionLiftPercentageAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCurrentPositionLiftPercentageAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentPositionTiltPercentageAttribute(
      CurrentPositionTiltPercentageAttributeCallback callback
    ) {
      readCurrentPositionTiltPercentageAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentPositionTiltPercentageAttribute(
        CurrentPositionTiltPercentageAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCurrentPositionTiltPercentageAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOperationalStatusAttribute(
      IntegerAttributeCallback callback
    ) {
      readOperationalStatusAttribute(chipClusterPtr, callback);
    }
    public void subscribeOperationalStatusAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOperationalStatusAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTargetPositionLiftPercent100thsAttribute(
      TargetPositionLiftPercent100thsAttributeCallback callback
    ) {
      readTargetPositionLiftPercent100thsAttribute(chipClusterPtr, callback);
    }
    public void subscribeTargetPositionLiftPercent100thsAttribute(
        TargetPositionLiftPercent100thsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeTargetPositionLiftPercent100thsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTargetPositionTiltPercent100thsAttribute(
      TargetPositionTiltPercent100thsAttributeCallback callback
    ) {
      readTargetPositionTiltPercent100thsAttribute(chipClusterPtr, callback);
    }
    public void subscribeTargetPositionTiltPercent100thsAttribute(
        TargetPositionTiltPercent100thsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeTargetPositionTiltPercent100thsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEndProductTypeAttribute(
      IntegerAttributeCallback callback
    ) {
      readEndProductTypeAttribute(chipClusterPtr, callback);
    }
    public void subscribeEndProductTypeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeEndProductTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentPositionLiftPercent100thsAttribute(
      CurrentPositionLiftPercent100thsAttributeCallback callback
    ) {
      readCurrentPositionLiftPercent100thsAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentPositionLiftPercent100thsAttribute(
        CurrentPositionLiftPercent100thsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCurrentPositionLiftPercent100thsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentPositionTiltPercent100thsAttribute(
      CurrentPositionTiltPercent100thsAttributeCallback callback
    ) {
      readCurrentPositionTiltPercent100thsAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentPositionTiltPercent100thsAttribute(
        CurrentPositionTiltPercent100thsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCurrentPositionTiltPercent100thsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInstalledOpenLimitLiftAttribute(
      IntegerAttributeCallback callback
    ) {
      readInstalledOpenLimitLiftAttribute(chipClusterPtr, callback);
    }
    public void subscribeInstalledOpenLimitLiftAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInstalledOpenLimitLiftAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInstalledClosedLimitLiftAttribute(
      IntegerAttributeCallback callback
    ) {
      readInstalledClosedLimitLiftAttribute(chipClusterPtr, callback);
    }
    public void subscribeInstalledClosedLimitLiftAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInstalledClosedLimitLiftAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInstalledOpenLimitTiltAttribute(
      IntegerAttributeCallback callback
    ) {
      readInstalledOpenLimitTiltAttribute(chipClusterPtr, callback);
    }
    public void subscribeInstalledOpenLimitTiltAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInstalledOpenLimitTiltAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readInstalledClosedLimitTiltAttribute(
      IntegerAttributeCallback callback
    ) {
      readInstalledClosedLimitTiltAttribute(chipClusterPtr, callback);
    }
    public void subscribeInstalledClosedLimitTiltAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeInstalledClosedLimitTiltAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readModeAttribute(chipClusterPtr, callback);
    }
    public void writeModeAttribute(DefaultClusterCallback callback, Integer value) {
      writeModeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeModeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeModeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSafetyStatusAttribute(
      IntegerAttributeCallback callback
    ) {
      readSafetyStatusAttribute(chipClusterPtr, callback);
    }
    public void subscribeSafetyStatusAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSafetyStatusAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPhysicalClosedLimitLiftAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePhysicalClosedLimitLiftAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPhysicalClosedLimitTiltAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePhysicalClosedLimitTiltAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentPositionLiftAttribute(long chipClusterPtr,
        CurrentPositionLiftAttributeCallback callback
    );
    private native void subscribeCurrentPositionLiftAttribute(long chipClusterPtr,
        CurrentPositionLiftAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readCurrentPositionTiltAttribute(long chipClusterPtr,
        CurrentPositionTiltAttributeCallback callback
    );
    private native void subscribeCurrentPositionTiltAttribute(long chipClusterPtr,
        CurrentPositionTiltAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readNumberOfActuationsLiftAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfActuationsLiftAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNumberOfActuationsTiltAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfActuationsTiltAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readConfigStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeConfigStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentPositionLiftPercentageAttribute(long chipClusterPtr,
        CurrentPositionLiftPercentageAttributeCallback callback
    );
    private native void subscribeCurrentPositionLiftPercentageAttribute(long chipClusterPtr,
        CurrentPositionLiftPercentageAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readCurrentPositionTiltPercentageAttribute(long chipClusterPtr,
        CurrentPositionTiltPercentageAttributeCallback callback
    );
    private native void subscribeCurrentPositionTiltPercentageAttribute(long chipClusterPtr,
        CurrentPositionTiltPercentageAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOperationalStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeOperationalStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTargetPositionLiftPercent100thsAttribute(long chipClusterPtr,
        TargetPositionLiftPercent100thsAttributeCallback callback
    );
    private native void subscribeTargetPositionLiftPercent100thsAttribute(long chipClusterPtr,
        TargetPositionLiftPercent100thsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readTargetPositionTiltPercent100thsAttribute(long chipClusterPtr,
        TargetPositionTiltPercent100thsAttributeCallback callback
    );
    private native void subscribeTargetPositionTiltPercent100thsAttribute(long chipClusterPtr,
        TargetPositionTiltPercent100thsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEndProductTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeEndProductTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentPositionLiftPercent100thsAttribute(long chipClusterPtr,
        CurrentPositionLiftPercent100thsAttributeCallback callback
    );
    private native void subscribeCurrentPositionLiftPercent100thsAttribute(long chipClusterPtr,
        CurrentPositionLiftPercent100thsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readCurrentPositionTiltPercent100thsAttribute(long chipClusterPtr,
        CurrentPositionTiltPercent100thsAttributeCallback callback
    );
    private native void subscribeCurrentPositionTiltPercent100thsAttribute(long chipClusterPtr,
        CurrentPositionTiltPercent100thsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readInstalledOpenLimitLiftAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeInstalledOpenLimitLiftAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInstalledClosedLimitLiftAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeInstalledClosedLimitLiftAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInstalledOpenLimitTiltAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeInstalledOpenLimitTiltAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readInstalledClosedLimitTiltAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeInstalledClosedLimitTiltAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeModeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSafetyStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeSafetyStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class BarrierControlCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 259L;

    public BarrierControlCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void barrierControlGoToPercent(DefaultClusterCallback callback
      , Integer percentOpen) {
      barrierControlGoToPercent(chipClusterPtr, callback, percentOpen, null);
    }

    public void barrierControlGoToPercent(DefaultClusterCallback callback
      , Integer percentOpen
      , int timedInvokeTimeoutMs) {
      barrierControlGoToPercent(chipClusterPtr, callback, percentOpen, timedInvokeTimeoutMs);
    }

    public void barrierControlStop(DefaultClusterCallback callback
      ) {
      barrierControlStop(chipClusterPtr, callback, null);
    }

    public void barrierControlStop(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      barrierControlStop(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }
    private native void barrierControlGoToPercent(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer percentOpen
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void barrierControlStop(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readBarrierMovingStateAttribute(
      IntegerAttributeCallback callback
    ) {
      readBarrierMovingStateAttribute(chipClusterPtr, callback);
    }
    public void subscribeBarrierMovingStateAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBarrierMovingStateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBarrierSafetyStatusAttribute(
      IntegerAttributeCallback callback
    ) {
      readBarrierSafetyStatusAttribute(chipClusterPtr, callback);
    }
    public void subscribeBarrierSafetyStatusAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBarrierSafetyStatusAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBarrierCapabilitiesAttribute(
      IntegerAttributeCallback callback
    ) {
      readBarrierCapabilitiesAttribute(chipClusterPtr, callback);
    }
    public void subscribeBarrierCapabilitiesAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBarrierCapabilitiesAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBarrierOpenEventsAttribute(
      IntegerAttributeCallback callback
    ) {
      readBarrierOpenEventsAttribute(chipClusterPtr, callback);
    }
    public void writeBarrierOpenEventsAttribute(DefaultClusterCallback callback, Integer value) {
      writeBarrierOpenEventsAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeBarrierOpenEventsAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeBarrierOpenEventsAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeBarrierOpenEventsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBarrierOpenEventsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBarrierCloseEventsAttribute(
      IntegerAttributeCallback callback
    ) {
      readBarrierCloseEventsAttribute(chipClusterPtr, callback);
    }
    public void writeBarrierCloseEventsAttribute(DefaultClusterCallback callback, Integer value) {
      writeBarrierCloseEventsAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeBarrierCloseEventsAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeBarrierCloseEventsAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeBarrierCloseEventsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBarrierCloseEventsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBarrierCommandOpenEventsAttribute(
      IntegerAttributeCallback callback
    ) {
      readBarrierCommandOpenEventsAttribute(chipClusterPtr, callback);
    }
    public void writeBarrierCommandOpenEventsAttribute(DefaultClusterCallback callback, Integer value) {
      writeBarrierCommandOpenEventsAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeBarrierCommandOpenEventsAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeBarrierCommandOpenEventsAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeBarrierCommandOpenEventsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBarrierCommandOpenEventsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBarrierCommandCloseEventsAttribute(
      IntegerAttributeCallback callback
    ) {
      readBarrierCommandCloseEventsAttribute(chipClusterPtr, callback);
    }
    public void writeBarrierCommandCloseEventsAttribute(DefaultClusterCallback callback, Integer value) {
      writeBarrierCommandCloseEventsAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeBarrierCommandCloseEventsAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeBarrierCommandCloseEventsAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeBarrierCommandCloseEventsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBarrierCommandCloseEventsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBarrierOpenPeriodAttribute(
      IntegerAttributeCallback callback
    ) {
      readBarrierOpenPeriodAttribute(chipClusterPtr, callback);
    }
    public void writeBarrierOpenPeriodAttribute(DefaultClusterCallback callback, Integer value) {
      writeBarrierOpenPeriodAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeBarrierOpenPeriodAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeBarrierOpenPeriodAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeBarrierOpenPeriodAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBarrierOpenPeriodAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBarrierClosePeriodAttribute(
      IntegerAttributeCallback callback
    ) {
      readBarrierClosePeriodAttribute(chipClusterPtr, callback);
    }
    public void writeBarrierClosePeriodAttribute(DefaultClusterCallback callback, Integer value) {
      writeBarrierClosePeriodAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeBarrierClosePeriodAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeBarrierClosePeriodAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeBarrierClosePeriodAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBarrierClosePeriodAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBarrierPositionAttribute(
      IntegerAttributeCallback callback
    ) {
      readBarrierPositionAttribute(chipClusterPtr, callback);
    }
    public void subscribeBarrierPositionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBarrierPositionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readBarrierMovingStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBarrierMovingStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBarrierSafetyStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBarrierSafetyStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBarrierCapabilitiesAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBarrierCapabilitiesAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBarrierOpenEventsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeBarrierOpenEventsAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeBarrierOpenEventsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBarrierCloseEventsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeBarrierCloseEventsAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeBarrierCloseEventsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBarrierCommandOpenEventsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeBarrierCommandOpenEventsAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeBarrierCommandOpenEventsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBarrierCommandCloseEventsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeBarrierCommandCloseEventsAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeBarrierCommandCloseEventsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBarrierOpenPeriodAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeBarrierOpenPeriodAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeBarrierOpenPeriodAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBarrierClosePeriodAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeBarrierClosePeriodAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeBarrierClosePeriodAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBarrierPositionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBarrierPositionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class PumpConfigurationAndControlCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 512L;

    public PumpConfigurationAndControlCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface MaxPressureAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MaxSpeedAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MaxFlowAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MinConstPressureAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MaxConstPressureAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MinCompPressureAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MaxCompPressureAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MinConstSpeedAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MaxConstSpeedAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MinConstFlowAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MaxConstFlowAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MinConstTempAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MaxConstTempAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface CapacityAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface SpeedAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface LifetimeRunningHoursAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface PowerAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface LifetimeEnergyConsumedAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readMaxPressureAttribute(
      MaxPressureAttributeCallback callback
    ) {
      readMaxPressureAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxPressureAttribute(
        MaxPressureAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMaxPressureAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxSpeedAttribute(
      MaxSpeedAttributeCallback callback
    ) {
      readMaxSpeedAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxSpeedAttribute(
        MaxSpeedAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMaxSpeedAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxFlowAttribute(
      MaxFlowAttributeCallback callback
    ) {
      readMaxFlowAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxFlowAttribute(
        MaxFlowAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMaxFlowAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinConstPressureAttribute(
      MinConstPressureAttributeCallback callback
    ) {
      readMinConstPressureAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinConstPressureAttribute(
        MinConstPressureAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMinConstPressureAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxConstPressureAttribute(
      MaxConstPressureAttributeCallback callback
    ) {
      readMaxConstPressureAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxConstPressureAttribute(
        MaxConstPressureAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMaxConstPressureAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinCompPressureAttribute(
      MinCompPressureAttributeCallback callback
    ) {
      readMinCompPressureAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinCompPressureAttribute(
        MinCompPressureAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMinCompPressureAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxCompPressureAttribute(
      MaxCompPressureAttributeCallback callback
    ) {
      readMaxCompPressureAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxCompPressureAttribute(
        MaxCompPressureAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMaxCompPressureAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinConstSpeedAttribute(
      MinConstSpeedAttributeCallback callback
    ) {
      readMinConstSpeedAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinConstSpeedAttribute(
        MinConstSpeedAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMinConstSpeedAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxConstSpeedAttribute(
      MaxConstSpeedAttributeCallback callback
    ) {
      readMaxConstSpeedAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxConstSpeedAttribute(
        MaxConstSpeedAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMaxConstSpeedAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinConstFlowAttribute(
      MinConstFlowAttributeCallback callback
    ) {
      readMinConstFlowAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinConstFlowAttribute(
        MinConstFlowAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMinConstFlowAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxConstFlowAttribute(
      MaxConstFlowAttributeCallback callback
    ) {
      readMaxConstFlowAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxConstFlowAttribute(
        MaxConstFlowAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMaxConstFlowAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinConstTempAttribute(
      MinConstTempAttributeCallback callback
    ) {
      readMinConstTempAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinConstTempAttribute(
        MinConstTempAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMinConstTempAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxConstTempAttribute(
      MaxConstTempAttributeCallback callback
    ) {
      readMaxConstTempAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxConstTempAttribute(
        MaxConstTempAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMaxConstTempAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPumpStatusAttribute(
      IntegerAttributeCallback callback
    ) {
      readPumpStatusAttribute(chipClusterPtr, callback);
    }
    public void subscribePumpStatusAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePumpStatusAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEffectiveOperationModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readEffectiveOperationModeAttribute(chipClusterPtr, callback);
    }
    public void subscribeEffectiveOperationModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeEffectiveOperationModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEffectiveControlModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readEffectiveControlModeAttribute(chipClusterPtr, callback);
    }
    public void subscribeEffectiveControlModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeEffectiveControlModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCapacityAttribute(
      CapacityAttributeCallback callback
    ) {
      readCapacityAttribute(chipClusterPtr, callback);
    }
    public void subscribeCapacityAttribute(
        CapacityAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeCapacityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSpeedAttribute(
      SpeedAttributeCallback callback
    ) {
      readSpeedAttribute(chipClusterPtr, callback);
    }
    public void subscribeSpeedAttribute(
        SpeedAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeSpeedAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLifetimeRunningHoursAttribute(
      LifetimeRunningHoursAttributeCallback callback
    ) {
      readLifetimeRunningHoursAttribute(chipClusterPtr, callback);
    }
    public void writeLifetimeRunningHoursAttribute(DefaultClusterCallback callback, Long value) {
      writeLifetimeRunningHoursAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLifetimeRunningHoursAttribute(DefaultClusterCallback callback, Long value, int timedWriteTimeoutMs) {
      writeLifetimeRunningHoursAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLifetimeRunningHoursAttribute(
        LifetimeRunningHoursAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLifetimeRunningHoursAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPowerAttribute(
      PowerAttributeCallback callback
    ) {
      readPowerAttribute(chipClusterPtr, callback);
    }
    public void subscribePowerAttribute(
        PowerAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePowerAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLifetimeEnergyConsumedAttribute(
      LifetimeEnergyConsumedAttributeCallback callback
    ) {
      readLifetimeEnergyConsumedAttribute(chipClusterPtr, callback);
    }
    public void writeLifetimeEnergyConsumedAttribute(DefaultClusterCallback callback, Long value) {
      writeLifetimeEnergyConsumedAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLifetimeEnergyConsumedAttribute(DefaultClusterCallback callback, Long value, int timedWriteTimeoutMs) {
      writeLifetimeEnergyConsumedAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLifetimeEnergyConsumedAttribute(
        LifetimeEnergyConsumedAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLifetimeEnergyConsumedAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOperationModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readOperationModeAttribute(chipClusterPtr, callback);
    }
    public void writeOperationModeAttribute(DefaultClusterCallback callback, Integer value) {
      writeOperationModeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOperationModeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOperationModeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOperationModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOperationModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readControlModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readControlModeAttribute(chipClusterPtr, callback);
    }
    public void writeControlModeAttribute(DefaultClusterCallback callback, Integer value) {
      writeControlModeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeControlModeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeControlModeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeControlModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeControlModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readMaxPressureAttribute(long chipClusterPtr,
        MaxPressureAttributeCallback callback
    );
    private native void subscribeMaxPressureAttribute(long chipClusterPtr,
        MaxPressureAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMaxSpeedAttribute(long chipClusterPtr,
        MaxSpeedAttributeCallback callback
    );
    private native void subscribeMaxSpeedAttribute(long chipClusterPtr,
        MaxSpeedAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMaxFlowAttribute(long chipClusterPtr,
        MaxFlowAttributeCallback callback
    );
    private native void subscribeMaxFlowAttribute(long chipClusterPtr,
        MaxFlowAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMinConstPressureAttribute(long chipClusterPtr,
        MinConstPressureAttributeCallback callback
    );
    private native void subscribeMinConstPressureAttribute(long chipClusterPtr,
        MinConstPressureAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMaxConstPressureAttribute(long chipClusterPtr,
        MaxConstPressureAttributeCallback callback
    );
    private native void subscribeMaxConstPressureAttribute(long chipClusterPtr,
        MaxConstPressureAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMinCompPressureAttribute(long chipClusterPtr,
        MinCompPressureAttributeCallback callback
    );
    private native void subscribeMinCompPressureAttribute(long chipClusterPtr,
        MinCompPressureAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMaxCompPressureAttribute(long chipClusterPtr,
        MaxCompPressureAttributeCallback callback
    );
    private native void subscribeMaxCompPressureAttribute(long chipClusterPtr,
        MaxCompPressureAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMinConstSpeedAttribute(long chipClusterPtr,
        MinConstSpeedAttributeCallback callback
    );
    private native void subscribeMinConstSpeedAttribute(long chipClusterPtr,
        MinConstSpeedAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMaxConstSpeedAttribute(long chipClusterPtr,
        MaxConstSpeedAttributeCallback callback
    );
    private native void subscribeMaxConstSpeedAttribute(long chipClusterPtr,
        MaxConstSpeedAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMinConstFlowAttribute(long chipClusterPtr,
        MinConstFlowAttributeCallback callback
    );
    private native void subscribeMinConstFlowAttribute(long chipClusterPtr,
        MinConstFlowAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMaxConstFlowAttribute(long chipClusterPtr,
        MaxConstFlowAttributeCallback callback
    );
    private native void subscribeMaxConstFlowAttribute(long chipClusterPtr,
        MaxConstFlowAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMinConstTempAttribute(long chipClusterPtr,
        MinConstTempAttributeCallback callback
    );
    private native void subscribeMinConstTempAttribute(long chipClusterPtr,
        MinConstTempAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMaxConstTempAttribute(long chipClusterPtr,
        MaxConstTempAttributeCallback callback
    );
    private native void subscribeMaxConstTempAttribute(long chipClusterPtr,
        MaxConstTempAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPumpStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePumpStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readEffectiveOperationModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeEffectiveOperationModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readEffectiveControlModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeEffectiveControlModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCapacityAttribute(long chipClusterPtr,
        CapacityAttributeCallback callback
    );
    private native void subscribeCapacityAttribute(long chipClusterPtr,
        CapacityAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readSpeedAttribute(long chipClusterPtr,
        SpeedAttributeCallback callback
    );
    private native void subscribeSpeedAttribute(long chipClusterPtr,
        SpeedAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readLifetimeRunningHoursAttribute(long chipClusterPtr,
        LifetimeRunningHoursAttributeCallback callback
    );

    private native void writeLifetimeRunningHoursAttribute(long chipClusterPtr, DefaultClusterCallback callback, Long value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLifetimeRunningHoursAttribute(long chipClusterPtr,
        LifetimeRunningHoursAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPowerAttribute(long chipClusterPtr,
        PowerAttributeCallback callback
    );
    private native void subscribePowerAttribute(long chipClusterPtr,
        PowerAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readLifetimeEnergyConsumedAttribute(long chipClusterPtr,
        LifetimeEnergyConsumedAttributeCallback callback
    );

    private native void writeLifetimeEnergyConsumedAttribute(long chipClusterPtr, DefaultClusterCallback callback, Long value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLifetimeEnergyConsumedAttribute(long chipClusterPtr,
        LifetimeEnergyConsumedAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOperationModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeOperationModeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOperationModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readControlModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeControlModeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeControlModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ThermostatCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 513L;

    public ThermostatCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void setpointRaiseLower(DefaultClusterCallback callback
      , Integer mode, Integer amount) {
      setpointRaiseLower(chipClusterPtr, callback, mode, amount, null);
    }

    public void setpointRaiseLower(DefaultClusterCallback callback
      , Integer mode, Integer amount
      , int timedInvokeTimeoutMs) {
      setpointRaiseLower(chipClusterPtr, callback, mode, amount, timedInvokeTimeoutMs);
    }

    public void setWeeklySchedule(DefaultClusterCallback callback
      , Integer numberOfTransitionsForSequence, Integer dayOfWeekForSequence, Integer modeForSequence, ArrayList<ChipStructs.ThermostatClusterThermostatScheduleTransition> transitions) {
      setWeeklySchedule(chipClusterPtr, callback, numberOfTransitionsForSequence, dayOfWeekForSequence, modeForSequence, transitions, null);
    }

    public void setWeeklySchedule(DefaultClusterCallback callback
      , Integer numberOfTransitionsForSequence, Integer dayOfWeekForSequence, Integer modeForSequence, ArrayList<ChipStructs.ThermostatClusterThermostatScheduleTransition> transitions
      , int timedInvokeTimeoutMs) {
      setWeeklySchedule(chipClusterPtr, callback, numberOfTransitionsForSequence, dayOfWeekForSequence, modeForSequence, transitions, timedInvokeTimeoutMs);
    }

    public void getWeeklySchedule(GetWeeklyScheduleResponseCallback callback
      , Integer daysToReturn, Integer modeToReturn) {
      getWeeklySchedule(chipClusterPtr, callback, daysToReturn, modeToReturn, null);
    }

    public void getWeeklySchedule(GetWeeklyScheduleResponseCallback callback
      , Integer daysToReturn, Integer modeToReturn
      , int timedInvokeTimeoutMs) {
      getWeeklySchedule(chipClusterPtr, callback, daysToReturn, modeToReturn, timedInvokeTimeoutMs);
    }

    public void clearWeeklySchedule(DefaultClusterCallback callback
      ) {
      clearWeeklySchedule(chipClusterPtr, callback, null);
    }

    public void clearWeeklySchedule(DefaultClusterCallback callback
      
      , int timedInvokeTimeoutMs) {
      clearWeeklySchedule(chipClusterPtr, callback, timedInvokeTimeoutMs);
    }
    private native void setpointRaiseLower(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer mode, Integer amount
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void setWeeklySchedule(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer numberOfTransitionsForSequence, Integer dayOfWeekForSequence, Integer modeForSequence, ArrayList<ChipStructs.ThermostatClusterThermostatScheduleTransition> transitions
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void getWeeklySchedule(long chipClusterPtr, GetWeeklyScheduleResponseCallback Callback
      , Integer daysToReturn, Integer modeToReturn
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void clearWeeklySchedule(long chipClusterPtr, DefaultClusterCallback Callback
      
      , @Nullable Integer timedInvokeTimeoutMs);
    public interface GetWeeklyScheduleResponseCallback {
      void onSuccess(Integer numberOfTransitionsForSequence, Integer dayOfWeekForSequence, Integer modeForSequence, ArrayList<ChipStructs.ThermostatClusterThermostatScheduleTransition> transitions);
      
      void onError(Exception error);
    }


      public interface LocalTemperatureAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface OutdoorTemperatureAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface TemperatureSetpointHoldDurationAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface SetpointChangeAmountAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface OccupiedSetbackAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface OccupiedSetbackMinAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface OccupiedSetbackMaxAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface UnoccupiedSetbackAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface UnoccupiedSetbackMinAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface UnoccupiedSetbackMaxAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ACCoilTemperatureAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readLocalTemperatureAttribute(
      LocalTemperatureAttributeCallback callback
    ) {
      readLocalTemperatureAttribute(chipClusterPtr, callback);
    }
    public void subscribeLocalTemperatureAttribute(
        LocalTemperatureAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLocalTemperatureAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOutdoorTemperatureAttribute(
      OutdoorTemperatureAttributeCallback callback
    ) {
      readOutdoorTemperatureAttribute(chipClusterPtr, callback);
    }
    public void subscribeOutdoorTemperatureAttribute(
        OutdoorTemperatureAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeOutdoorTemperatureAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOccupancyAttribute(
      IntegerAttributeCallback callback
    ) {
      readOccupancyAttribute(chipClusterPtr, callback);
    }
    public void subscribeOccupancyAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOccupancyAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAbsMinHeatSetpointLimitAttribute(
      IntegerAttributeCallback callback
    ) {
      readAbsMinHeatSetpointLimitAttribute(chipClusterPtr, callback);
    }
    public void subscribeAbsMinHeatSetpointLimitAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeAbsMinHeatSetpointLimitAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAbsMaxHeatSetpointLimitAttribute(
      IntegerAttributeCallback callback
    ) {
      readAbsMaxHeatSetpointLimitAttribute(chipClusterPtr, callback);
    }
    public void subscribeAbsMaxHeatSetpointLimitAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeAbsMaxHeatSetpointLimitAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAbsMinCoolSetpointLimitAttribute(
      IntegerAttributeCallback callback
    ) {
      readAbsMinCoolSetpointLimitAttribute(chipClusterPtr, callback);
    }
    public void subscribeAbsMinCoolSetpointLimitAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeAbsMinCoolSetpointLimitAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAbsMaxCoolSetpointLimitAttribute(
      IntegerAttributeCallback callback
    ) {
      readAbsMaxCoolSetpointLimitAttribute(chipClusterPtr, callback);
    }
    public void subscribeAbsMaxCoolSetpointLimitAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeAbsMaxCoolSetpointLimitAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPICoolingDemandAttribute(
      IntegerAttributeCallback callback
    ) {
      readPICoolingDemandAttribute(chipClusterPtr, callback);
    }
    public void subscribePICoolingDemandAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePICoolingDemandAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPIHeatingDemandAttribute(
      IntegerAttributeCallback callback
    ) {
      readPIHeatingDemandAttribute(chipClusterPtr, callback);
    }
    public void subscribePIHeatingDemandAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePIHeatingDemandAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readHVACSystemTypeConfigurationAttribute(
      IntegerAttributeCallback callback
    ) {
      readHVACSystemTypeConfigurationAttribute(chipClusterPtr, callback);
    }
    public void writeHVACSystemTypeConfigurationAttribute(DefaultClusterCallback callback, Integer value) {
      writeHVACSystemTypeConfigurationAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeHVACSystemTypeConfigurationAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeHVACSystemTypeConfigurationAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeHVACSystemTypeConfigurationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeHVACSystemTypeConfigurationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLocalTemperatureCalibrationAttribute(
      IntegerAttributeCallback callback
    ) {
      readLocalTemperatureCalibrationAttribute(chipClusterPtr, callback);
    }
    public void writeLocalTemperatureCalibrationAttribute(DefaultClusterCallback callback, Integer value) {
      writeLocalTemperatureCalibrationAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLocalTemperatureCalibrationAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeLocalTemperatureCalibrationAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLocalTemperatureCalibrationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLocalTemperatureCalibrationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOccupiedCoolingSetpointAttribute(
      IntegerAttributeCallback callback
    ) {
      readOccupiedCoolingSetpointAttribute(chipClusterPtr, callback);
    }
    public void writeOccupiedCoolingSetpointAttribute(DefaultClusterCallback callback, Integer value) {
      writeOccupiedCoolingSetpointAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOccupiedCoolingSetpointAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOccupiedCoolingSetpointAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOccupiedCoolingSetpointAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOccupiedCoolingSetpointAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOccupiedHeatingSetpointAttribute(
      IntegerAttributeCallback callback
    ) {
      readOccupiedHeatingSetpointAttribute(chipClusterPtr, callback);
    }
    public void writeOccupiedHeatingSetpointAttribute(DefaultClusterCallback callback, Integer value) {
      writeOccupiedHeatingSetpointAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOccupiedHeatingSetpointAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOccupiedHeatingSetpointAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOccupiedHeatingSetpointAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOccupiedHeatingSetpointAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUnoccupiedCoolingSetpointAttribute(
      IntegerAttributeCallback callback
    ) {
      readUnoccupiedCoolingSetpointAttribute(chipClusterPtr, callback);
    }
    public void writeUnoccupiedCoolingSetpointAttribute(DefaultClusterCallback callback, Integer value) {
      writeUnoccupiedCoolingSetpointAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeUnoccupiedCoolingSetpointAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeUnoccupiedCoolingSetpointAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeUnoccupiedCoolingSetpointAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeUnoccupiedCoolingSetpointAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUnoccupiedHeatingSetpointAttribute(
      IntegerAttributeCallback callback
    ) {
      readUnoccupiedHeatingSetpointAttribute(chipClusterPtr, callback);
    }
    public void writeUnoccupiedHeatingSetpointAttribute(DefaultClusterCallback callback, Integer value) {
      writeUnoccupiedHeatingSetpointAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeUnoccupiedHeatingSetpointAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeUnoccupiedHeatingSetpointAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeUnoccupiedHeatingSetpointAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeUnoccupiedHeatingSetpointAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinHeatSetpointLimitAttribute(
      IntegerAttributeCallback callback
    ) {
      readMinHeatSetpointLimitAttribute(chipClusterPtr, callback);
    }
    public void writeMinHeatSetpointLimitAttribute(DefaultClusterCallback callback, Integer value) {
      writeMinHeatSetpointLimitAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeMinHeatSetpointLimitAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeMinHeatSetpointLimitAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeMinHeatSetpointLimitAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMinHeatSetpointLimitAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxHeatSetpointLimitAttribute(
      IntegerAttributeCallback callback
    ) {
      readMaxHeatSetpointLimitAttribute(chipClusterPtr, callback);
    }
    public void writeMaxHeatSetpointLimitAttribute(DefaultClusterCallback callback, Integer value) {
      writeMaxHeatSetpointLimitAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeMaxHeatSetpointLimitAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeMaxHeatSetpointLimitAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeMaxHeatSetpointLimitAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaxHeatSetpointLimitAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinCoolSetpointLimitAttribute(
      IntegerAttributeCallback callback
    ) {
      readMinCoolSetpointLimitAttribute(chipClusterPtr, callback);
    }
    public void writeMinCoolSetpointLimitAttribute(DefaultClusterCallback callback, Integer value) {
      writeMinCoolSetpointLimitAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeMinCoolSetpointLimitAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeMinCoolSetpointLimitAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeMinCoolSetpointLimitAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMinCoolSetpointLimitAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxCoolSetpointLimitAttribute(
      IntegerAttributeCallback callback
    ) {
      readMaxCoolSetpointLimitAttribute(chipClusterPtr, callback);
    }
    public void writeMaxCoolSetpointLimitAttribute(DefaultClusterCallback callback, Integer value) {
      writeMaxCoolSetpointLimitAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeMaxCoolSetpointLimitAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeMaxCoolSetpointLimitAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeMaxCoolSetpointLimitAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaxCoolSetpointLimitAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinSetpointDeadBandAttribute(
      IntegerAttributeCallback callback
    ) {
      readMinSetpointDeadBandAttribute(chipClusterPtr, callback);
    }
    public void writeMinSetpointDeadBandAttribute(DefaultClusterCallback callback, Integer value) {
      writeMinSetpointDeadBandAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeMinSetpointDeadBandAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeMinSetpointDeadBandAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeMinSetpointDeadBandAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMinSetpointDeadBandAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRemoteSensingAttribute(
      IntegerAttributeCallback callback
    ) {
      readRemoteSensingAttribute(chipClusterPtr, callback);
    }
    public void writeRemoteSensingAttribute(DefaultClusterCallback callback, Integer value) {
      writeRemoteSensingAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeRemoteSensingAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeRemoteSensingAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeRemoteSensingAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRemoteSensingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readControlSequenceOfOperationAttribute(
      IntegerAttributeCallback callback
    ) {
      readControlSequenceOfOperationAttribute(chipClusterPtr, callback);
    }
    public void writeControlSequenceOfOperationAttribute(DefaultClusterCallback callback, Integer value) {
      writeControlSequenceOfOperationAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeControlSequenceOfOperationAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeControlSequenceOfOperationAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeControlSequenceOfOperationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeControlSequenceOfOperationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSystemModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readSystemModeAttribute(chipClusterPtr, callback);
    }
    public void writeSystemModeAttribute(DefaultClusterCallback callback, Integer value) {
      writeSystemModeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeSystemModeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeSystemModeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeSystemModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSystemModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readThermostatRunningModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readThermostatRunningModeAttribute(chipClusterPtr, callback);
    }
    public void subscribeThermostatRunningModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeThermostatRunningModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readStartOfWeekAttribute(
      IntegerAttributeCallback callback
    ) {
      readStartOfWeekAttribute(chipClusterPtr, callback);
    }
    public void subscribeStartOfWeekAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeStartOfWeekAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfWeeklyTransitionsAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfWeeklyTransitionsAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfWeeklyTransitionsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfWeeklyTransitionsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfDailyTransitionsAttribute(
      IntegerAttributeCallback callback
    ) {
      readNumberOfDailyTransitionsAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfDailyTransitionsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeNumberOfDailyTransitionsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTemperatureSetpointHoldAttribute(
      IntegerAttributeCallback callback
    ) {
      readTemperatureSetpointHoldAttribute(chipClusterPtr, callback);
    }
    public void writeTemperatureSetpointHoldAttribute(DefaultClusterCallback callback, Integer value) {
      writeTemperatureSetpointHoldAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeTemperatureSetpointHoldAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeTemperatureSetpointHoldAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeTemperatureSetpointHoldAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTemperatureSetpointHoldAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readTemperatureSetpointHoldDurationAttribute(
      TemperatureSetpointHoldDurationAttributeCallback callback
    ) {
      readTemperatureSetpointHoldDurationAttribute(chipClusterPtr, callback);
    }
    public void writeTemperatureSetpointHoldDurationAttribute(DefaultClusterCallback callback, Integer value) {
      writeTemperatureSetpointHoldDurationAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeTemperatureSetpointHoldDurationAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeTemperatureSetpointHoldDurationAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeTemperatureSetpointHoldDurationAttribute(
        TemperatureSetpointHoldDurationAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeTemperatureSetpointHoldDurationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readThermostatProgrammingOperationModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readThermostatProgrammingOperationModeAttribute(chipClusterPtr, callback);
    }
    public void writeThermostatProgrammingOperationModeAttribute(DefaultClusterCallback callback, Integer value) {
      writeThermostatProgrammingOperationModeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeThermostatProgrammingOperationModeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeThermostatProgrammingOperationModeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeThermostatProgrammingOperationModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeThermostatProgrammingOperationModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readThermostatRunningStateAttribute(
      IntegerAttributeCallback callback
    ) {
      readThermostatRunningStateAttribute(chipClusterPtr, callback);
    }
    public void subscribeThermostatRunningStateAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeThermostatRunningStateAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSetpointChangeSourceAttribute(
      IntegerAttributeCallback callback
    ) {
      readSetpointChangeSourceAttribute(chipClusterPtr, callback);
    }
    public void subscribeSetpointChangeSourceAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSetpointChangeSourceAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSetpointChangeAmountAttribute(
      SetpointChangeAmountAttributeCallback callback
    ) {
      readSetpointChangeAmountAttribute(chipClusterPtr, callback);
    }
    public void subscribeSetpointChangeAmountAttribute(
        SetpointChangeAmountAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeSetpointChangeAmountAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSetpointChangeSourceTimestampAttribute(
      LongAttributeCallback callback
    ) {
      readSetpointChangeSourceTimestampAttribute(chipClusterPtr, callback);
    }
    public void subscribeSetpointChangeSourceTimestampAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSetpointChangeSourceTimestampAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOccupiedSetbackAttribute(
      OccupiedSetbackAttributeCallback callback
    ) {
      readOccupiedSetbackAttribute(chipClusterPtr, callback);
    }
    public void writeOccupiedSetbackAttribute(DefaultClusterCallback callback, Integer value) {
      writeOccupiedSetbackAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOccupiedSetbackAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOccupiedSetbackAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOccupiedSetbackAttribute(
        OccupiedSetbackAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeOccupiedSetbackAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOccupiedSetbackMinAttribute(
      OccupiedSetbackMinAttributeCallback callback
    ) {
      readOccupiedSetbackMinAttribute(chipClusterPtr, callback);
    }
    public void subscribeOccupiedSetbackMinAttribute(
        OccupiedSetbackMinAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeOccupiedSetbackMinAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOccupiedSetbackMaxAttribute(
      OccupiedSetbackMaxAttributeCallback callback
    ) {
      readOccupiedSetbackMaxAttribute(chipClusterPtr, callback);
    }
    public void subscribeOccupiedSetbackMaxAttribute(
        OccupiedSetbackMaxAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeOccupiedSetbackMaxAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUnoccupiedSetbackAttribute(
      UnoccupiedSetbackAttributeCallback callback
    ) {
      readUnoccupiedSetbackAttribute(chipClusterPtr, callback);
    }
    public void writeUnoccupiedSetbackAttribute(DefaultClusterCallback callback, Integer value) {
      writeUnoccupiedSetbackAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeUnoccupiedSetbackAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeUnoccupiedSetbackAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeUnoccupiedSetbackAttribute(
        UnoccupiedSetbackAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeUnoccupiedSetbackAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUnoccupiedSetbackMinAttribute(
      UnoccupiedSetbackMinAttributeCallback callback
    ) {
      readUnoccupiedSetbackMinAttribute(chipClusterPtr, callback);
    }
    public void subscribeUnoccupiedSetbackMinAttribute(
        UnoccupiedSetbackMinAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeUnoccupiedSetbackMinAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readUnoccupiedSetbackMaxAttribute(
      UnoccupiedSetbackMaxAttributeCallback callback
    ) {
      readUnoccupiedSetbackMaxAttribute(chipClusterPtr, callback);
    }
    public void subscribeUnoccupiedSetbackMaxAttribute(
        UnoccupiedSetbackMaxAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeUnoccupiedSetbackMaxAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEmergencyHeatDeltaAttribute(
      IntegerAttributeCallback callback
    ) {
      readEmergencyHeatDeltaAttribute(chipClusterPtr, callback);
    }
    public void writeEmergencyHeatDeltaAttribute(DefaultClusterCallback callback, Integer value) {
      writeEmergencyHeatDeltaAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeEmergencyHeatDeltaAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeEmergencyHeatDeltaAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeEmergencyHeatDeltaAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeEmergencyHeatDeltaAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readACTypeAttribute(
      IntegerAttributeCallback callback
    ) {
      readACTypeAttribute(chipClusterPtr, callback);
    }
    public void writeACTypeAttribute(DefaultClusterCallback callback, Integer value) {
      writeACTypeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeACTypeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeACTypeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeACTypeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeACTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readACCapacityAttribute(
      IntegerAttributeCallback callback
    ) {
      readACCapacityAttribute(chipClusterPtr, callback);
    }
    public void writeACCapacityAttribute(DefaultClusterCallback callback, Integer value) {
      writeACCapacityAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeACCapacityAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeACCapacityAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeACCapacityAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeACCapacityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readACRefrigerantTypeAttribute(
      IntegerAttributeCallback callback
    ) {
      readACRefrigerantTypeAttribute(chipClusterPtr, callback);
    }
    public void writeACRefrigerantTypeAttribute(DefaultClusterCallback callback, Integer value) {
      writeACRefrigerantTypeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeACRefrigerantTypeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeACRefrigerantTypeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeACRefrigerantTypeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeACRefrigerantTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readACCompressorTypeAttribute(
      IntegerAttributeCallback callback
    ) {
      readACCompressorTypeAttribute(chipClusterPtr, callback);
    }
    public void writeACCompressorTypeAttribute(DefaultClusterCallback callback, Integer value) {
      writeACCompressorTypeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeACCompressorTypeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeACCompressorTypeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeACCompressorTypeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeACCompressorTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readACErrorCodeAttribute(
      LongAttributeCallback callback
    ) {
      readACErrorCodeAttribute(chipClusterPtr, callback);
    }
    public void writeACErrorCodeAttribute(DefaultClusterCallback callback, Long value) {
      writeACErrorCodeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeACErrorCodeAttribute(DefaultClusterCallback callback, Long value, int timedWriteTimeoutMs) {
      writeACErrorCodeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeACErrorCodeAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeACErrorCodeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readACLouverPositionAttribute(
      IntegerAttributeCallback callback
    ) {
      readACLouverPositionAttribute(chipClusterPtr, callback);
    }
    public void writeACLouverPositionAttribute(DefaultClusterCallback callback, Integer value) {
      writeACLouverPositionAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeACLouverPositionAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeACLouverPositionAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeACLouverPositionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeACLouverPositionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readACCoilTemperatureAttribute(
      ACCoilTemperatureAttributeCallback callback
    ) {
      readACCoilTemperatureAttribute(chipClusterPtr, callback);
    }
    public void subscribeACCoilTemperatureAttribute(
        ACCoilTemperatureAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeACCoilTemperatureAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readACCapacityformatAttribute(
      IntegerAttributeCallback callback
    ) {
      readACCapacityformatAttribute(chipClusterPtr, callback);
    }
    public void writeACCapacityformatAttribute(DefaultClusterCallback callback, Integer value) {
      writeACCapacityformatAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeACCapacityformatAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeACCapacityformatAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeACCapacityformatAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeACCapacityformatAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readLocalTemperatureAttribute(long chipClusterPtr,
        LocalTemperatureAttributeCallback callback
    );
    private native void subscribeLocalTemperatureAttribute(long chipClusterPtr,
        LocalTemperatureAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOutdoorTemperatureAttribute(long chipClusterPtr,
        OutdoorTemperatureAttributeCallback callback
    );
    private native void subscribeOutdoorTemperatureAttribute(long chipClusterPtr,
        OutdoorTemperatureAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOccupancyAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeOccupancyAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readAbsMinHeatSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeAbsMinHeatSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readAbsMaxHeatSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeAbsMaxHeatSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readAbsMinCoolSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeAbsMinCoolSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readAbsMaxCoolSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeAbsMaxCoolSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPICoolingDemandAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePICoolingDemandAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPIHeatingDemandAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePIHeatingDemandAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readHVACSystemTypeConfigurationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeHVACSystemTypeConfigurationAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeHVACSystemTypeConfigurationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLocalTemperatureCalibrationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeLocalTemperatureCalibrationAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLocalTemperatureCalibrationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOccupiedCoolingSetpointAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeOccupiedCoolingSetpointAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOccupiedCoolingSetpointAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOccupiedHeatingSetpointAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeOccupiedHeatingSetpointAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOccupiedHeatingSetpointAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readUnoccupiedCoolingSetpointAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeUnoccupiedCoolingSetpointAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeUnoccupiedCoolingSetpointAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readUnoccupiedHeatingSetpointAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeUnoccupiedHeatingSetpointAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeUnoccupiedHeatingSetpointAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMinHeatSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeMinHeatSetpointLimitAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeMinHeatSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMaxHeatSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeMaxHeatSetpointLimitAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeMaxHeatSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMinCoolSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeMinCoolSetpointLimitAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeMinCoolSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMaxCoolSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeMaxCoolSetpointLimitAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeMaxCoolSetpointLimitAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMinSetpointDeadBandAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeMinSetpointDeadBandAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeMinSetpointDeadBandAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRemoteSensingAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeRemoteSensingAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeRemoteSensingAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readControlSequenceOfOperationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeControlSequenceOfOperationAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeControlSequenceOfOperationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSystemModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeSystemModeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeSystemModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readThermostatRunningModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeThermostatRunningModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readStartOfWeekAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeStartOfWeekAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNumberOfWeeklyTransitionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfWeeklyTransitionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNumberOfDailyTransitionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeNumberOfDailyTransitionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTemperatureSetpointHoldAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeTemperatureSetpointHoldAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeTemperatureSetpointHoldAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readTemperatureSetpointHoldDurationAttribute(long chipClusterPtr,
        TemperatureSetpointHoldDurationAttributeCallback callback
    );

    private native void writeTemperatureSetpointHoldDurationAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeTemperatureSetpointHoldDurationAttribute(long chipClusterPtr,
        TemperatureSetpointHoldDurationAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readThermostatProgrammingOperationModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeThermostatProgrammingOperationModeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeThermostatProgrammingOperationModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readThermostatRunningStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeThermostatRunningStateAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSetpointChangeSourceAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeSetpointChangeSourceAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSetpointChangeAmountAttribute(long chipClusterPtr,
        SetpointChangeAmountAttributeCallback callback
    );
    private native void subscribeSetpointChangeAmountAttribute(long chipClusterPtr,
        SetpointChangeAmountAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readSetpointChangeSourceTimestampAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeSetpointChangeSourceTimestampAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOccupiedSetbackAttribute(long chipClusterPtr,
        OccupiedSetbackAttributeCallback callback
    );

    private native void writeOccupiedSetbackAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOccupiedSetbackAttribute(long chipClusterPtr,
        OccupiedSetbackAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOccupiedSetbackMinAttribute(long chipClusterPtr,
        OccupiedSetbackMinAttributeCallback callback
    );
    private native void subscribeOccupiedSetbackMinAttribute(long chipClusterPtr,
        OccupiedSetbackMinAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readOccupiedSetbackMaxAttribute(long chipClusterPtr,
        OccupiedSetbackMaxAttributeCallback callback
    );
    private native void subscribeOccupiedSetbackMaxAttribute(long chipClusterPtr,
        OccupiedSetbackMaxAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readUnoccupiedSetbackAttribute(long chipClusterPtr,
        UnoccupiedSetbackAttributeCallback callback
    );

    private native void writeUnoccupiedSetbackAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeUnoccupiedSetbackAttribute(long chipClusterPtr,
        UnoccupiedSetbackAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readUnoccupiedSetbackMinAttribute(long chipClusterPtr,
        UnoccupiedSetbackMinAttributeCallback callback
    );
    private native void subscribeUnoccupiedSetbackMinAttribute(long chipClusterPtr,
        UnoccupiedSetbackMinAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readUnoccupiedSetbackMaxAttribute(long chipClusterPtr,
        UnoccupiedSetbackMaxAttributeCallback callback
    );
    private native void subscribeUnoccupiedSetbackMaxAttribute(long chipClusterPtr,
        UnoccupiedSetbackMaxAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEmergencyHeatDeltaAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeEmergencyHeatDeltaAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeEmergencyHeatDeltaAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readACTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeACTypeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeACTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readACCapacityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeACCapacityAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeACCapacityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readACRefrigerantTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeACRefrigerantTypeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeACRefrigerantTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readACCompressorTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeACCompressorTypeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeACCompressorTypeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readACErrorCodeAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );

    private native void writeACErrorCodeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Long value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeACErrorCodeAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readACLouverPositionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeACLouverPositionAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeACLouverPositionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readACCoilTemperatureAttribute(long chipClusterPtr,
        ACCoilTemperatureAttributeCallback callback
    );
    private native void subscribeACCoilTemperatureAttribute(long chipClusterPtr,
        ACCoilTemperatureAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readACCapacityformatAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeACCapacityformatAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeACCapacityformatAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class FanControlCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 514L;

    public FanControlCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface PercentSettingAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface SpeedSettingAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readFanModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readFanModeAttribute(chipClusterPtr, callback);
    }
    public void writeFanModeAttribute(DefaultClusterCallback callback, Integer value) {
      writeFanModeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeFanModeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeFanModeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeFanModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFanModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFanModeSequenceAttribute(
      IntegerAttributeCallback callback
    ) {
      readFanModeSequenceAttribute(chipClusterPtr, callback);
    }
    public void writeFanModeSequenceAttribute(DefaultClusterCallback callback, Integer value) {
      writeFanModeSequenceAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeFanModeSequenceAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeFanModeSequenceAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeFanModeSequenceAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFanModeSequenceAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPercentSettingAttribute(
      PercentSettingAttributeCallback callback
    ) {
      readPercentSettingAttribute(chipClusterPtr, callback);
    }
    public void writePercentSettingAttribute(DefaultClusterCallback callback, Integer value) {
      writePercentSettingAttribute(chipClusterPtr, callback, value, null);
    }

    public void writePercentSettingAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writePercentSettingAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribePercentSettingAttribute(
        PercentSettingAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePercentSettingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPercentCurrentAttribute(
      IntegerAttributeCallback callback
    ) {
      readPercentCurrentAttribute(chipClusterPtr, callback);
    }
    public void subscribePercentCurrentAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePercentCurrentAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSpeedMaxAttribute(
      IntegerAttributeCallback callback
    ) {
      readSpeedMaxAttribute(chipClusterPtr, callback);
    }
    public void subscribeSpeedMaxAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSpeedMaxAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSpeedSettingAttribute(
      SpeedSettingAttributeCallback callback
    ) {
      readSpeedSettingAttribute(chipClusterPtr, callback);
    }
    public void writeSpeedSettingAttribute(DefaultClusterCallback callback, Integer value) {
      writeSpeedSettingAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeSpeedSettingAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeSpeedSettingAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeSpeedSettingAttribute(
        SpeedSettingAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeSpeedSettingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readSpeedCurrentAttribute(
      IntegerAttributeCallback callback
    ) {
      readSpeedCurrentAttribute(chipClusterPtr, callback);
    }
    public void subscribeSpeedCurrentAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeSpeedCurrentAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRockSupportAttribute(
      IntegerAttributeCallback callback
    ) {
      readRockSupportAttribute(chipClusterPtr, callback);
    }
    public void subscribeRockSupportAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRockSupportAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRockSettingAttribute(
      IntegerAttributeCallback callback
    ) {
      readRockSettingAttribute(chipClusterPtr, callback);
    }
    public void writeRockSettingAttribute(DefaultClusterCallback callback, Integer value) {
      writeRockSettingAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeRockSettingAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeRockSettingAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeRockSettingAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRockSettingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWindSupportAttribute(
      IntegerAttributeCallback callback
    ) {
      readWindSupportAttribute(chipClusterPtr, callback);
    }
    public void subscribeWindSupportAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeWindSupportAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWindSettingAttribute(
      IntegerAttributeCallback callback
    ) {
      readWindSettingAttribute(chipClusterPtr, callback);
    }
    public void writeWindSettingAttribute(DefaultClusterCallback callback, Integer value) {
      writeWindSettingAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeWindSettingAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeWindSettingAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeWindSettingAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeWindSettingAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAirflowDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readAirflowDirectionAttribute(chipClusterPtr, callback);
    }
    public void writeAirflowDirectionAttribute(DefaultClusterCallback callback, Integer value) {
      writeAirflowDirectionAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeAirflowDirectionAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeAirflowDirectionAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeAirflowDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeAirflowDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readFanModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeFanModeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeFanModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readFanModeSequenceAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeFanModeSequenceAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeFanModeSequenceAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPercentSettingAttribute(long chipClusterPtr,
        PercentSettingAttributeCallback callback
    );

    private native void writePercentSettingAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribePercentSettingAttribute(long chipClusterPtr,
        PercentSettingAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPercentCurrentAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePercentCurrentAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSpeedMaxAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeSpeedMaxAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readSpeedSettingAttribute(long chipClusterPtr,
        SpeedSettingAttributeCallback callback
    );

    private native void writeSpeedSettingAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeSpeedSettingAttribute(long chipClusterPtr,
        SpeedSettingAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readSpeedCurrentAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeSpeedCurrentAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRockSupportAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeRockSupportAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRockSettingAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeRockSettingAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeRockSettingAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readWindSupportAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeWindSupportAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readWindSettingAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeWindSettingAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeWindSettingAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readAirflowDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeAirflowDirectionAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeAirflowDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ThermostatUserInterfaceConfigurationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 516L;

    public ThermostatUserInterfaceConfigurationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readTemperatureDisplayModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readTemperatureDisplayModeAttribute(chipClusterPtr, callback);
    }
    public void writeTemperatureDisplayModeAttribute(DefaultClusterCallback callback, Integer value) {
      writeTemperatureDisplayModeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeTemperatureDisplayModeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeTemperatureDisplayModeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeTemperatureDisplayModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeTemperatureDisplayModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readKeypadLockoutAttribute(
      IntegerAttributeCallback callback
    ) {
      readKeypadLockoutAttribute(chipClusterPtr, callback);
    }
    public void writeKeypadLockoutAttribute(DefaultClusterCallback callback, Integer value) {
      writeKeypadLockoutAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeKeypadLockoutAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeKeypadLockoutAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeKeypadLockoutAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeKeypadLockoutAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readScheduleProgrammingVisibilityAttribute(
      IntegerAttributeCallback callback
    ) {
      readScheduleProgrammingVisibilityAttribute(chipClusterPtr, callback);
    }
    public void writeScheduleProgrammingVisibilityAttribute(DefaultClusterCallback callback, Integer value) {
      writeScheduleProgrammingVisibilityAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeScheduleProgrammingVisibilityAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeScheduleProgrammingVisibilityAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeScheduleProgrammingVisibilityAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeScheduleProgrammingVisibilityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readTemperatureDisplayModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeTemperatureDisplayModeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeTemperatureDisplayModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readKeypadLockoutAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeKeypadLockoutAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeKeypadLockoutAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readScheduleProgrammingVisibilityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeScheduleProgrammingVisibilityAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeScheduleProgrammingVisibilityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class ColorControlCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 768L;

    public ColorControlCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

    public void moveToHue(DefaultClusterCallback callback
      , Integer hue, Integer direction, Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      moveToHue(chipClusterPtr, callback, hue, direction, transitionTime, optionsMask, optionsOverride, null);
    }

    public void moveToHue(DefaultClusterCallback callback
      , Integer hue, Integer direction, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveToHue(chipClusterPtr, callback, hue, direction, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void moveHue(DefaultClusterCallback callback
      , Integer moveMode, Integer rate, Integer optionsMask, Integer optionsOverride) {
      moveHue(chipClusterPtr, callback, moveMode, rate, optionsMask, optionsOverride, null);
    }

    public void moveHue(DefaultClusterCallback callback
      , Integer moveMode, Integer rate, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveHue(chipClusterPtr, callback, moveMode, rate, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void stepHue(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      stepHue(chipClusterPtr, callback, stepMode, stepSize, transitionTime, optionsMask, optionsOverride, null);
    }

    public void stepHue(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      stepHue(chipClusterPtr, callback, stepMode, stepSize, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void moveToSaturation(DefaultClusterCallback callback
      , Integer saturation, Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      moveToSaturation(chipClusterPtr, callback, saturation, transitionTime, optionsMask, optionsOverride, null);
    }

    public void moveToSaturation(DefaultClusterCallback callback
      , Integer saturation, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveToSaturation(chipClusterPtr, callback, saturation, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void moveSaturation(DefaultClusterCallback callback
      , Integer moveMode, Integer rate, Integer optionsMask, Integer optionsOverride) {
      moveSaturation(chipClusterPtr, callback, moveMode, rate, optionsMask, optionsOverride, null);
    }

    public void moveSaturation(DefaultClusterCallback callback
      , Integer moveMode, Integer rate, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveSaturation(chipClusterPtr, callback, moveMode, rate, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void stepSaturation(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      stepSaturation(chipClusterPtr, callback, stepMode, stepSize, transitionTime, optionsMask, optionsOverride, null);
    }

    public void stepSaturation(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      stepSaturation(chipClusterPtr, callback, stepMode, stepSize, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void moveToHueAndSaturation(DefaultClusterCallback callback
      , Integer hue, Integer saturation, Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      moveToHueAndSaturation(chipClusterPtr, callback, hue, saturation, transitionTime, optionsMask, optionsOverride, null);
    }

    public void moveToHueAndSaturation(DefaultClusterCallback callback
      , Integer hue, Integer saturation, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveToHueAndSaturation(chipClusterPtr, callback, hue, saturation, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void moveToColor(DefaultClusterCallback callback
      , Integer colorX, Integer colorY, Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      moveToColor(chipClusterPtr, callback, colorX, colorY, transitionTime, optionsMask, optionsOverride, null);
    }

    public void moveToColor(DefaultClusterCallback callback
      , Integer colorX, Integer colorY, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveToColor(chipClusterPtr, callback, colorX, colorY, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void moveColor(DefaultClusterCallback callback
      , Integer rateX, Integer rateY, Integer optionsMask, Integer optionsOverride) {
      moveColor(chipClusterPtr, callback, rateX, rateY, optionsMask, optionsOverride, null);
    }

    public void moveColor(DefaultClusterCallback callback
      , Integer rateX, Integer rateY, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveColor(chipClusterPtr, callback, rateX, rateY, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void stepColor(DefaultClusterCallback callback
      , Integer stepX, Integer stepY, Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      stepColor(chipClusterPtr, callback, stepX, stepY, transitionTime, optionsMask, optionsOverride, null);
    }

    public void stepColor(DefaultClusterCallback callback
      , Integer stepX, Integer stepY, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      stepColor(chipClusterPtr, callback, stepX, stepY, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void moveToColorTemperature(DefaultClusterCallback callback
      , Integer colorTemperatureMireds, Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      moveToColorTemperature(chipClusterPtr, callback, colorTemperatureMireds, transitionTime, optionsMask, optionsOverride, null);
    }

    public void moveToColorTemperature(DefaultClusterCallback callback
      , Integer colorTemperatureMireds, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveToColorTemperature(chipClusterPtr, callback, colorTemperatureMireds, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void enhancedMoveToHue(DefaultClusterCallback callback
      , Integer enhancedHue, Integer direction, Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      enhancedMoveToHue(chipClusterPtr, callback, enhancedHue, direction, transitionTime, optionsMask, optionsOverride, null);
    }

    public void enhancedMoveToHue(DefaultClusterCallback callback
      , Integer enhancedHue, Integer direction, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      enhancedMoveToHue(chipClusterPtr, callback, enhancedHue, direction, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void enhancedMoveHue(DefaultClusterCallback callback
      , Integer moveMode, Integer rate, Integer optionsMask, Integer optionsOverride) {
      enhancedMoveHue(chipClusterPtr, callback, moveMode, rate, optionsMask, optionsOverride, null);
    }

    public void enhancedMoveHue(DefaultClusterCallback callback
      , Integer moveMode, Integer rate, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      enhancedMoveHue(chipClusterPtr, callback, moveMode, rate, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void enhancedStepHue(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      enhancedStepHue(chipClusterPtr, callback, stepMode, stepSize, transitionTime, optionsMask, optionsOverride, null);
    }

    public void enhancedStepHue(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      enhancedStepHue(chipClusterPtr, callback, stepMode, stepSize, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void enhancedMoveToHueAndSaturation(DefaultClusterCallback callback
      , Integer enhancedHue, Integer saturation, Integer transitionTime, Integer optionsMask, Integer optionsOverride) {
      enhancedMoveToHueAndSaturation(chipClusterPtr, callback, enhancedHue, saturation, transitionTime, optionsMask, optionsOverride, null);
    }

    public void enhancedMoveToHueAndSaturation(DefaultClusterCallback callback
      , Integer enhancedHue, Integer saturation, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      enhancedMoveToHueAndSaturation(chipClusterPtr, callback, enhancedHue, saturation, transitionTime, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void colorLoopSet(DefaultClusterCallback callback
      , Integer updateFlags, Integer action, Integer direction, Integer time, Integer startHue, Integer optionsMask, Integer optionsOverride) {
      colorLoopSet(chipClusterPtr, callback, updateFlags, action, direction, time, startHue, optionsMask, optionsOverride, null);
    }

    public void colorLoopSet(DefaultClusterCallback callback
      , Integer updateFlags, Integer action, Integer direction, Integer time, Integer startHue, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      colorLoopSet(chipClusterPtr, callback, updateFlags, action, direction, time, startHue, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void stopMoveStep(DefaultClusterCallback callback
      , Integer optionsMask, Integer optionsOverride) {
      stopMoveStep(chipClusterPtr, callback, optionsMask, optionsOverride, null);
    }

    public void stopMoveStep(DefaultClusterCallback callback
      , Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      stopMoveStep(chipClusterPtr, callback, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void moveColorTemperature(DefaultClusterCallback callback
      , Integer moveMode, Integer rate, Integer colorTemperatureMinimumMireds, Integer colorTemperatureMaximumMireds, Integer optionsMask, Integer optionsOverride) {
      moveColorTemperature(chipClusterPtr, callback, moveMode, rate, colorTemperatureMinimumMireds, colorTemperatureMaximumMireds, optionsMask, optionsOverride, null);
    }

    public void moveColorTemperature(DefaultClusterCallback callback
      , Integer moveMode, Integer rate, Integer colorTemperatureMinimumMireds, Integer colorTemperatureMaximumMireds, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      moveColorTemperature(chipClusterPtr, callback, moveMode, rate, colorTemperatureMinimumMireds, colorTemperatureMaximumMireds, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }

    public void stepColorTemperature(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer colorTemperatureMinimumMireds, Integer colorTemperatureMaximumMireds, Integer optionsMask, Integer optionsOverride) {
      stepColorTemperature(chipClusterPtr, callback, stepMode, stepSize, transitionTime, colorTemperatureMinimumMireds, colorTemperatureMaximumMireds, optionsMask, optionsOverride, null);
    }

    public void stepColorTemperature(DefaultClusterCallback callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer colorTemperatureMinimumMireds, Integer colorTemperatureMaximumMireds, Integer optionsMask, Integer optionsOverride
      , int timedInvokeTimeoutMs) {
      stepColorTemperature(chipClusterPtr, callback, stepMode, stepSize, transitionTime, colorTemperatureMinimumMireds, colorTemperatureMaximumMireds, optionsMask, optionsOverride, timedInvokeTimeoutMs);
    }
    private native void moveToHue(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer hue, Integer direction, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void moveHue(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer moveMode, Integer rate, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void stepHue(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void moveToSaturation(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer saturation, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void moveSaturation(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer moveMode, Integer rate, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void stepSaturation(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void moveToHueAndSaturation(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer hue, Integer saturation, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void moveToColor(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer colorX, Integer colorY, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void moveColor(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer rateX, Integer rateY, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void stepColor(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer stepX, Integer stepY, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void moveToColorTemperature(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer colorTemperatureMireds, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void enhancedMoveToHue(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer enhancedHue, Integer direction, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void enhancedMoveHue(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer moveMode, Integer rate, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void enhancedStepHue(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void enhancedMoveToHueAndSaturation(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer enhancedHue, Integer saturation, Integer transitionTime, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void colorLoopSet(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer updateFlags, Integer action, Integer direction, Integer time, Integer startHue, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void stopMoveStep(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void moveColorTemperature(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer moveMode, Integer rate, Integer colorTemperatureMinimumMireds, Integer colorTemperatureMaximumMireds, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);
    private native void stepColorTemperature(long chipClusterPtr, DefaultClusterCallback Callback
      , Integer stepMode, Integer stepSize, Integer transitionTime, Integer colorTemperatureMinimumMireds, Integer colorTemperatureMaximumMireds, Integer optionsMask, Integer optionsOverride
      , @Nullable Integer timedInvokeTimeoutMs);

      public interface NumberOfPrimariesAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface Primary1IntensityAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface Primary2IntensityAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface Primary3IntensityAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface Primary4IntensityAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface Primary5IntensityAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface Primary6IntensityAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ColorPointRIntensityAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ColorPointGIntensityAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface ColorPointBIntensityAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface StartUpColorTemperatureMiredsAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readCurrentHueAttribute(
      IntegerAttributeCallback callback
    ) {
      readCurrentHueAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentHueAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentHueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentSaturationAttribute(
      IntegerAttributeCallback callback
    ) {
      readCurrentSaturationAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentSaturationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentSaturationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readRemainingTimeAttribute(
      IntegerAttributeCallback callback
    ) {
      readRemainingTimeAttribute(chipClusterPtr, callback);
    }
    public void subscribeRemainingTimeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeRemainingTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentXAttribute(
      IntegerAttributeCallback callback
    ) {
      readCurrentXAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentXAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentXAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCurrentYAttribute(
      IntegerAttributeCallback callback
    ) {
      readCurrentYAttribute(chipClusterPtr, callback);
    }
    public void subscribeCurrentYAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCurrentYAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readDriftCompensationAttribute(
      IntegerAttributeCallback callback
    ) {
      readDriftCompensationAttribute(chipClusterPtr, callback);
    }
    public void subscribeDriftCompensationAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeDriftCompensationAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCompensationTextAttribute(
      CharStringAttributeCallback callback
    ) {
      readCompensationTextAttribute(chipClusterPtr, callback);
    }
    public void subscribeCompensationTextAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCompensationTextAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorTemperatureMiredsAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorTemperatureMiredsAttribute(chipClusterPtr, callback);
    }
    public void subscribeColorTemperatureMiredsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorTemperatureMiredsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorModeAttribute(chipClusterPtr, callback);
    }
    public void subscribeColorModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readOptionsAttribute(
      IntegerAttributeCallback callback
    ) {
      readOptionsAttribute(chipClusterPtr, callback);
    }
    public void writeOptionsAttribute(DefaultClusterCallback callback, Integer value) {
      writeOptionsAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeOptionsAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeOptionsAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeOptionsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeOptionsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readNumberOfPrimariesAttribute(
      NumberOfPrimariesAttributeCallback callback
    ) {
      readNumberOfPrimariesAttribute(chipClusterPtr, callback);
    }
    public void subscribeNumberOfPrimariesAttribute(
        NumberOfPrimariesAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeNumberOfPrimariesAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary1XAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary1XAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary1XAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary1XAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary1YAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary1YAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary1YAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary1YAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary1IntensityAttribute(
      Primary1IntensityAttributeCallback callback
    ) {
      readPrimary1IntensityAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary1IntensityAttribute(
        Primary1IntensityAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePrimary1IntensityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary2XAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary2XAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary2XAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary2XAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary2YAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary2YAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary2YAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary2YAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary2IntensityAttribute(
      Primary2IntensityAttributeCallback callback
    ) {
      readPrimary2IntensityAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary2IntensityAttribute(
        Primary2IntensityAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePrimary2IntensityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary3XAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary3XAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary3XAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary3XAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary3YAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary3YAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary3YAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary3YAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary3IntensityAttribute(
      Primary3IntensityAttributeCallback callback
    ) {
      readPrimary3IntensityAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary3IntensityAttribute(
        Primary3IntensityAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePrimary3IntensityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary4XAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary4XAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary4XAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary4XAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary4YAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary4YAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary4YAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary4YAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary4IntensityAttribute(
      Primary4IntensityAttributeCallback callback
    ) {
      readPrimary4IntensityAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary4IntensityAttribute(
        Primary4IntensityAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePrimary4IntensityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary5XAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary5XAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary5XAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary5XAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary5YAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary5YAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary5YAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary5YAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary5IntensityAttribute(
      Primary5IntensityAttributeCallback callback
    ) {
      readPrimary5IntensityAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary5IntensityAttribute(
        Primary5IntensityAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePrimary5IntensityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary6XAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary6XAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary6XAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary6XAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary6YAttribute(
      IntegerAttributeCallback callback
    ) {
      readPrimary6YAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary6YAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePrimary6YAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPrimary6IntensityAttribute(
      Primary6IntensityAttributeCallback callback
    ) {
      readPrimary6IntensityAttribute(chipClusterPtr, callback);
    }
    public void subscribePrimary6IntensityAttribute(
        Primary6IntensityAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribePrimary6IntensityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWhitePointXAttribute(
      IntegerAttributeCallback callback
    ) {
      readWhitePointXAttribute(chipClusterPtr, callback);
    }
    public void writeWhitePointXAttribute(DefaultClusterCallback callback, Integer value) {
      writeWhitePointXAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeWhitePointXAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeWhitePointXAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeWhitePointXAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeWhitePointXAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readWhitePointYAttribute(
      IntegerAttributeCallback callback
    ) {
      readWhitePointYAttribute(chipClusterPtr, callback);
    }
    public void writeWhitePointYAttribute(DefaultClusterCallback callback, Integer value) {
      writeWhitePointYAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeWhitePointYAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeWhitePointYAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeWhitePointYAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeWhitePointYAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorPointRXAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorPointRXAttribute(chipClusterPtr, callback);
    }
    public void writeColorPointRXAttribute(DefaultClusterCallback callback, Integer value) {
      writeColorPointRXAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeColorPointRXAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeColorPointRXAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeColorPointRXAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorPointRXAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorPointRYAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorPointRYAttribute(chipClusterPtr, callback);
    }
    public void writeColorPointRYAttribute(DefaultClusterCallback callback, Integer value) {
      writeColorPointRYAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeColorPointRYAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeColorPointRYAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeColorPointRYAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorPointRYAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorPointRIntensityAttribute(
      ColorPointRIntensityAttributeCallback callback
    ) {
      readColorPointRIntensityAttribute(chipClusterPtr, callback);
    }
    public void writeColorPointRIntensityAttribute(DefaultClusterCallback callback, Integer value) {
      writeColorPointRIntensityAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeColorPointRIntensityAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeColorPointRIntensityAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeColorPointRIntensityAttribute(
        ColorPointRIntensityAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeColorPointRIntensityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorPointGXAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorPointGXAttribute(chipClusterPtr, callback);
    }
    public void writeColorPointGXAttribute(DefaultClusterCallback callback, Integer value) {
      writeColorPointGXAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeColorPointGXAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeColorPointGXAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeColorPointGXAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorPointGXAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorPointGYAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorPointGYAttribute(chipClusterPtr, callback);
    }
    public void writeColorPointGYAttribute(DefaultClusterCallback callback, Integer value) {
      writeColorPointGYAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeColorPointGYAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeColorPointGYAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeColorPointGYAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorPointGYAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorPointGIntensityAttribute(
      ColorPointGIntensityAttributeCallback callback
    ) {
      readColorPointGIntensityAttribute(chipClusterPtr, callback);
    }
    public void writeColorPointGIntensityAttribute(DefaultClusterCallback callback, Integer value) {
      writeColorPointGIntensityAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeColorPointGIntensityAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeColorPointGIntensityAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeColorPointGIntensityAttribute(
        ColorPointGIntensityAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeColorPointGIntensityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorPointBXAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorPointBXAttribute(chipClusterPtr, callback);
    }
    public void writeColorPointBXAttribute(DefaultClusterCallback callback, Integer value) {
      writeColorPointBXAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeColorPointBXAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeColorPointBXAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeColorPointBXAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorPointBXAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorPointBYAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorPointBYAttribute(chipClusterPtr, callback);
    }
    public void writeColorPointBYAttribute(DefaultClusterCallback callback, Integer value) {
      writeColorPointBYAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeColorPointBYAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeColorPointBYAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeColorPointBYAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorPointBYAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorPointBIntensityAttribute(
      ColorPointBIntensityAttributeCallback callback
    ) {
      readColorPointBIntensityAttribute(chipClusterPtr, callback);
    }
    public void writeColorPointBIntensityAttribute(DefaultClusterCallback callback, Integer value) {
      writeColorPointBIntensityAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeColorPointBIntensityAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeColorPointBIntensityAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeColorPointBIntensityAttribute(
        ColorPointBIntensityAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeColorPointBIntensityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEnhancedCurrentHueAttribute(
      IntegerAttributeCallback callback
    ) {
      readEnhancedCurrentHueAttribute(chipClusterPtr, callback);
    }
    public void subscribeEnhancedCurrentHueAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeEnhancedCurrentHueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEnhancedColorModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readEnhancedColorModeAttribute(chipClusterPtr, callback);
    }
    public void subscribeEnhancedColorModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeEnhancedColorModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorLoopActiveAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorLoopActiveAttribute(chipClusterPtr, callback);
    }
    public void subscribeColorLoopActiveAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorLoopActiveAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorLoopDirectionAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorLoopDirectionAttribute(chipClusterPtr, callback);
    }
    public void subscribeColorLoopDirectionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorLoopDirectionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorLoopTimeAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorLoopTimeAttribute(chipClusterPtr, callback);
    }
    public void subscribeColorLoopTimeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorLoopTimeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorLoopStartEnhancedHueAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorLoopStartEnhancedHueAttribute(chipClusterPtr, callback);
    }
    public void subscribeColorLoopStartEnhancedHueAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorLoopStartEnhancedHueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorLoopStoredEnhancedHueAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorLoopStoredEnhancedHueAttribute(chipClusterPtr, callback);
    }
    public void subscribeColorLoopStoredEnhancedHueAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorLoopStoredEnhancedHueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorCapabilitiesAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorCapabilitiesAttribute(chipClusterPtr, callback);
    }
    public void subscribeColorCapabilitiesAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorCapabilitiesAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorTempPhysicalMinMiredsAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorTempPhysicalMinMiredsAttribute(chipClusterPtr, callback);
    }
    public void subscribeColorTempPhysicalMinMiredsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorTempPhysicalMinMiredsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readColorTempPhysicalMaxMiredsAttribute(
      IntegerAttributeCallback callback
    ) {
      readColorTempPhysicalMaxMiredsAttribute(chipClusterPtr, callback);
    }
    public void subscribeColorTempPhysicalMaxMiredsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeColorTempPhysicalMaxMiredsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readCoupleColorTempToLevelMinMiredsAttribute(
      IntegerAttributeCallback callback
    ) {
      readCoupleColorTempToLevelMinMiredsAttribute(chipClusterPtr, callback);
    }
    public void subscribeCoupleColorTempToLevelMinMiredsAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeCoupleColorTempToLevelMinMiredsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readStartUpColorTemperatureMiredsAttribute(
      StartUpColorTemperatureMiredsAttributeCallback callback
    ) {
      readStartUpColorTemperatureMiredsAttribute(chipClusterPtr, callback);
    }
    public void writeStartUpColorTemperatureMiredsAttribute(DefaultClusterCallback callback, Integer value) {
      writeStartUpColorTemperatureMiredsAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeStartUpColorTemperatureMiredsAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeStartUpColorTemperatureMiredsAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeStartUpColorTemperatureMiredsAttribute(
        StartUpColorTemperatureMiredsAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeStartUpColorTemperatureMiredsAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readCurrentHueAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCurrentHueAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentSaturationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCurrentSaturationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readRemainingTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeRemainingTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentXAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCurrentXAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCurrentYAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCurrentYAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readDriftCompensationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeDriftCompensationAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCompensationTextAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );
    private native void subscribeCompensationTextAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorTemperatureMiredsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeColorTemperatureMiredsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeColorModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readOptionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeOptionsAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeOptionsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readNumberOfPrimariesAttribute(long chipClusterPtr,
        NumberOfPrimariesAttributeCallback callback
    );
    private native void subscribeNumberOfPrimariesAttribute(long chipClusterPtr,
        NumberOfPrimariesAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPrimary1XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary1XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary1YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary1YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary1IntensityAttribute(long chipClusterPtr,
        Primary1IntensityAttributeCallback callback
    );
    private native void subscribePrimary1IntensityAttribute(long chipClusterPtr,
        Primary1IntensityAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPrimary2XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary2XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary2YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary2YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary2IntensityAttribute(long chipClusterPtr,
        Primary2IntensityAttributeCallback callback
    );
    private native void subscribePrimary2IntensityAttribute(long chipClusterPtr,
        Primary2IntensityAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPrimary3XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary3XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary3YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary3YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary3IntensityAttribute(long chipClusterPtr,
        Primary3IntensityAttributeCallback callback
    );
    private native void subscribePrimary3IntensityAttribute(long chipClusterPtr,
        Primary3IntensityAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPrimary4XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary4XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary4YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary4YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary4IntensityAttribute(long chipClusterPtr,
        Primary4IntensityAttributeCallback callback
    );
    private native void subscribePrimary4IntensityAttribute(long chipClusterPtr,
        Primary4IntensityAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPrimary5XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary5XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary5YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary5YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary5IntensityAttribute(long chipClusterPtr,
        Primary5IntensityAttributeCallback callback
    );
    private native void subscribePrimary5IntensityAttribute(long chipClusterPtr,
        Primary5IntensityAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readPrimary6XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary6XAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary6YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePrimary6YAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPrimary6IntensityAttribute(long chipClusterPtr,
        Primary6IntensityAttributeCallback callback
    );
    private native void subscribePrimary6IntensityAttribute(long chipClusterPtr,
        Primary6IntensityAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readWhitePointXAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeWhitePointXAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeWhitePointXAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readWhitePointYAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeWhitePointYAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeWhitePointYAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorPointRXAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeColorPointRXAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeColorPointRXAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorPointRYAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeColorPointRYAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeColorPointRYAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorPointRIntensityAttribute(long chipClusterPtr,
        ColorPointRIntensityAttributeCallback callback
    );

    private native void writeColorPointRIntensityAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeColorPointRIntensityAttribute(long chipClusterPtr,
        ColorPointRIntensityAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readColorPointGXAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeColorPointGXAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeColorPointGXAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorPointGYAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeColorPointGYAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeColorPointGYAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorPointGIntensityAttribute(long chipClusterPtr,
        ColorPointGIntensityAttributeCallback callback
    );

    private native void writeColorPointGIntensityAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeColorPointGIntensityAttribute(long chipClusterPtr,
        ColorPointGIntensityAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readColorPointBXAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeColorPointBXAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeColorPointBXAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorPointBYAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeColorPointBYAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeColorPointBYAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorPointBIntensityAttribute(long chipClusterPtr,
        ColorPointBIntensityAttributeCallback callback
    );

    private native void writeColorPointBIntensityAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeColorPointBIntensityAttribute(long chipClusterPtr,
        ColorPointBIntensityAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEnhancedCurrentHueAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeEnhancedCurrentHueAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readEnhancedColorModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeEnhancedColorModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorLoopActiveAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeColorLoopActiveAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorLoopDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeColorLoopDirectionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorLoopTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeColorLoopTimeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorLoopStartEnhancedHueAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeColorLoopStartEnhancedHueAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorLoopStoredEnhancedHueAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeColorLoopStoredEnhancedHueAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorCapabilitiesAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeColorCapabilitiesAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorTempPhysicalMinMiredsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeColorTempPhysicalMinMiredsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readColorTempPhysicalMaxMiredsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeColorTempPhysicalMaxMiredsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readCoupleColorTempToLevelMinMiredsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeCoupleColorTempToLevelMinMiredsAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readStartUpColorTemperatureMiredsAttribute(long chipClusterPtr,
        StartUpColorTemperatureMiredsAttributeCallback callback
    );

    private native void writeStartUpColorTemperatureMiredsAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeStartUpColorTemperatureMiredsAttribute(long chipClusterPtr,
        StartUpColorTemperatureMiredsAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class BallastConfigurationCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 769L;

    public BallastConfigurationCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface IntrinsicBallastFactorAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface BallastFactorAdjustmentAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface LampRatedHoursAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface LampBurnHoursAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface LampBurnHoursTripPointAttributeCallback {
        void onSuccess(@Nullable Long value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readPhysicalMinLevelAttribute(
      IntegerAttributeCallback callback
    ) {
      readPhysicalMinLevelAttribute(chipClusterPtr, callback);
    }
    public void subscribePhysicalMinLevelAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePhysicalMinLevelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readPhysicalMaxLevelAttribute(
      IntegerAttributeCallback callback
    ) {
      readPhysicalMaxLevelAttribute(chipClusterPtr, callback);
    }
    public void subscribePhysicalMaxLevelAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribePhysicalMaxLevelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBallastStatusAttribute(
      IntegerAttributeCallback callback
    ) {
      readBallastStatusAttribute(chipClusterPtr, callback);
    }
    public void subscribeBallastStatusAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeBallastStatusAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinLevelAttribute(
      IntegerAttributeCallback callback
    ) {
      readMinLevelAttribute(chipClusterPtr, callback);
    }
    public void writeMinLevelAttribute(DefaultClusterCallback callback, Integer value) {
      writeMinLevelAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeMinLevelAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeMinLevelAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeMinLevelAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMinLevelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxLevelAttribute(
      IntegerAttributeCallback callback
    ) {
      readMaxLevelAttribute(chipClusterPtr, callback);
    }
    public void writeMaxLevelAttribute(DefaultClusterCallback callback, Integer value) {
      writeMaxLevelAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeMaxLevelAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeMaxLevelAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeMaxLevelAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeMaxLevelAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readIntrinsicBallastFactorAttribute(
      IntrinsicBallastFactorAttributeCallback callback
    ) {
      readIntrinsicBallastFactorAttribute(chipClusterPtr, callback);
    }
    public void writeIntrinsicBallastFactorAttribute(DefaultClusterCallback callback, Integer value) {
      writeIntrinsicBallastFactorAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeIntrinsicBallastFactorAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeIntrinsicBallastFactorAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeIntrinsicBallastFactorAttribute(
        IntrinsicBallastFactorAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeIntrinsicBallastFactorAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readBallastFactorAdjustmentAttribute(
      BallastFactorAdjustmentAttributeCallback callback
    ) {
      readBallastFactorAdjustmentAttribute(chipClusterPtr, callback);
    }
    public void writeBallastFactorAdjustmentAttribute(DefaultClusterCallback callback, Integer value) {
      writeBallastFactorAdjustmentAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeBallastFactorAdjustmentAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeBallastFactorAdjustmentAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeBallastFactorAdjustmentAttribute(
        BallastFactorAdjustmentAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeBallastFactorAdjustmentAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLampQuantityAttribute(
      IntegerAttributeCallback callback
    ) {
      readLampQuantityAttribute(chipClusterPtr, callback);
    }
    public void subscribeLampQuantityAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLampQuantityAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLampTypeAttribute(
      CharStringAttributeCallback callback
    ) {
      readLampTypeAttribute(chipClusterPtr, callback);
    }
    public void writeLampTypeAttribute(DefaultClusterCallback callback, String value) {
      writeLampTypeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLampTypeAttribute(DefaultClusterCallback callback, String value, int timedWriteTimeoutMs) {
      writeLampTypeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLampTypeAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLampTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLampManufacturerAttribute(
      CharStringAttributeCallback callback
    ) {
      readLampManufacturerAttribute(chipClusterPtr, callback);
    }
    public void writeLampManufacturerAttribute(DefaultClusterCallback callback, String value) {
      writeLampManufacturerAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLampManufacturerAttribute(DefaultClusterCallback callback, String value, int timedWriteTimeoutMs) {
      writeLampManufacturerAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLampManufacturerAttribute(
        CharStringAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLampManufacturerAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLampRatedHoursAttribute(
      LampRatedHoursAttributeCallback callback
    ) {
      readLampRatedHoursAttribute(chipClusterPtr, callback);
    }
    public void writeLampRatedHoursAttribute(DefaultClusterCallback callback, Long value) {
      writeLampRatedHoursAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLampRatedHoursAttribute(DefaultClusterCallback callback, Long value, int timedWriteTimeoutMs) {
      writeLampRatedHoursAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLampRatedHoursAttribute(
        LampRatedHoursAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLampRatedHoursAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLampBurnHoursAttribute(
      LampBurnHoursAttributeCallback callback
    ) {
      readLampBurnHoursAttribute(chipClusterPtr, callback);
    }
    public void writeLampBurnHoursAttribute(DefaultClusterCallback callback, Long value) {
      writeLampBurnHoursAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLampBurnHoursAttribute(DefaultClusterCallback callback, Long value, int timedWriteTimeoutMs) {
      writeLampBurnHoursAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLampBurnHoursAttribute(
        LampBurnHoursAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLampBurnHoursAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLampAlarmModeAttribute(
      IntegerAttributeCallback callback
    ) {
      readLampAlarmModeAttribute(chipClusterPtr, callback);
    }
    public void writeLampAlarmModeAttribute(DefaultClusterCallback callback, Integer value) {
      writeLampAlarmModeAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLampAlarmModeAttribute(DefaultClusterCallback callback, Integer value, int timedWriteTimeoutMs) {
      writeLampAlarmModeAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLampAlarmModeAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeLampAlarmModeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLampBurnHoursTripPointAttribute(
      LampBurnHoursTripPointAttributeCallback callback
    ) {
      readLampBurnHoursTripPointAttribute(chipClusterPtr, callback);
    }
    public void writeLampBurnHoursTripPointAttribute(DefaultClusterCallback callback, Long value) {
      writeLampBurnHoursTripPointAttribute(chipClusterPtr, callback, value, null);
    }

    public void writeLampBurnHoursTripPointAttribute(DefaultClusterCallback callback, Long value, int timedWriteTimeoutMs) {
      writeLampBurnHoursTripPointAttribute(chipClusterPtr, callback, value, timedWriteTimeoutMs);
    }
    public void subscribeLampBurnHoursTripPointAttribute(
        LampBurnHoursTripPointAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLampBurnHoursTripPointAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readPhysicalMinLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePhysicalMinLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readPhysicalMaxLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribePhysicalMaxLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readBallastStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeBallastStatusAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMinLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeMinLevelAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeMinLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readMaxLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeMaxLevelAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeMaxLevelAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readIntrinsicBallastFactorAttribute(long chipClusterPtr,
        IntrinsicBallastFactorAttributeCallback callback
    );

    private native void writeIntrinsicBallastFactorAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeIntrinsicBallastFactorAttribute(long chipClusterPtr,
        IntrinsicBallastFactorAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readBallastFactorAdjustmentAttribute(long chipClusterPtr,
        BallastFactorAdjustmentAttributeCallback callback
    );

    private native void writeBallastFactorAdjustmentAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeBallastFactorAdjustmentAttribute(long chipClusterPtr,
        BallastFactorAdjustmentAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readLampQuantityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeLampQuantityAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLampTypeAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );

    private native void writeLampTypeAttribute(long chipClusterPtr, DefaultClusterCallback callback, String value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLampTypeAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLampManufacturerAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
    );

    private native void writeLampManufacturerAttribute(long chipClusterPtr, DefaultClusterCallback callback, String value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLampManufacturerAttribute(long chipClusterPtr,
        CharStringAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLampRatedHoursAttribute(long chipClusterPtr,
        LampRatedHoursAttributeCallback callback
    );

    private native void writeLampRatedHoursAttribute(long chipClusterPtr, DefaultClusterCallback callback, Long value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLampRatedHoursAttribute(long chipClusterPtr,
        LampRatedHoursAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readLampBurnHoursAttribute(long chipClusterPtr,
        LampBurnHoursAttributeCallback callback
    );

    private native void writeLampBurnHoursAttribute(long chipClusterPtr, DefaultClusterCallback callback, Long value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLampBurnHoursAttribute(long chipClusterPtr,
        LampBurnHoursAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readLampAlarmModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );

    private native void writeLampAlarmModeAttribute(long chipClusterPtr, DefaultClusterCallback callback, Integer value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLampAlarmModeAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLampBurnHoursTripPointAttribute(long chipClusterPtr,
        LampBurnHoursTripPointAttributeCallback callback
    );

    private native void writeLampBurnHoursTripPointAttribute(long chipClusterPtr, DefaultClusterCallback callback, Long value, @Nullable Integer timedWriteTimeoutMs);
    private native void subscribeLampBurnHoursTripPointAttribute(long chipClusterPtr,
        LampBurnHoursTripPointAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class IlluminanceMeasurementCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 1024L;

    public IlluminanceMeasurementCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface MeasuredValueAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MinMeasuredValueAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MaxMeasuredValueAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface LightSensorTypeAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readMeasuredValueAttribute(
      MeasuredValueAttributeCallback callback
    ) {
      readMeasuredValueAttribute(chipClusterPtr, callback);
    }
    public void subscribeMeasuredValueAttribute(
        MeasuredValueAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMeasuredValueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinMeasuredValueAttribute(
      MinMeasuredValueAttributeCallback callback
    ) {
      readMinMeasuredValueAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinMeasuredValueAttribute(
        MinMeasuredValueAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMinMeasuredValueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxMeasuredValueAttribute(
      MaxMeasuredValueAttributeCallback callback
    ) {
      readMaxMeasuredValueAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxMeasuredValueAttribute(
        MaxMeasuredValueAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMaxMeasuredValueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readToleranceAttribute(
      IntegerAttributeCallback callback
    ) {
      readToleranceAttribute(chipClusterPtr, callback);
    }
    public void subscribeToleranceAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeToleranceAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readLightSensorTypeAttribute(
      LightSensorTypeAttributeCallback callback
    ) {
      readLightSensorTypeAttribute(chipClusterPtr, callback);
    }
    public void subscribeLightSensorTypeAttribute(
        LightSensorTypeAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeLightSensorTypeAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readMeasuredValueAttribute(long chipClusterPtr,
        MeasuredValueAttributeCallback callback
    );
    private native void subscribeMeasuredValueAttribute(long chipClusterPtr,
        MeasuredValueAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMinMeasuredValueAttribute(long chipClusterPtr,
        MinMeasuredValueAttributeCallback callback
    );
    private native void subscribeMinMeasuredValueAttribute(long chipClusterPtr,
        MinMeasuredValueAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMaxMeasuredValueAttribute(long chipClusterPtr,
        MaxMeasuredValueAttributeCallback callback
    );
    private native void subscribeMaxMeasuredValueAttribute(long chipClusterPtr,
        MaxMeasuredValueAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readToleranceAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeToleranceAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readLightSensorTypeAttribute(long chipClusterPtr,
        LightSensorTypeAttributeCallback callback
    );
    private native void subscribeLightSensorTypeAttribute(long chipClusterPtr,
        LightSensorTypeAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
    );
    private native void subscribeGeneratedCommandListAttribute(long chipClusterPtr,
        GeneratedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
    );
    private native void subscribeAcceptedCommandListAttribute(long chipClusterPtr,
        AcceptedCommandListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
    );
    private native void subscribeEventListAttribute(long chipClusterPtr,
        EventListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
    );
    private native void subscribeAttributeListAttribute(long chipClusterPtr,
        AttributeListAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
    );
    private native void subscribeFeatureMapAttribute(long chipClusterPtr,
        LongAttributeCallback callback
, int minInterval, int maxInterval);

    private native void readClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeClusterRevisionAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int minInterval, int maxInterval);
  }

  public static class TemperatureMeasurementCluster extends BaseChipCluster {
    public static final long CLUSTER_ID = 1026L;

    public TemperatureMeasurementCluster(long devicePtr, int endpointId) {
      super(devicePtr, endpointId);
    }

    @Override
    public native long initWithDevice(long devicePtr, int endpointId);

      public interface MeasuredValueAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MinMeasuredValueAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface MaxMeasuredValueAttributeCallback {
        void onSuccess(@Nullable Integer value);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface GeneratedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AcceptedCommandListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface EventListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }
      public interface AttributeListAttributeCallback {
        void onSuccess( List<Long> valueList);
        void onError(Exception ex);
        default void onSubscriptionEstablished(long subscriptionId) {}
      }

    public void readMeasuredValueAttribute(
      MeasuredValueAttributeCallback callback
    ) {
      readMeasuredValueAttribute(chipClusterPtr, callback);
    }
    public void subscribeMeasuredValueAttribute(
        MeasuredValueAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMeasuredValueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMinMeasuredValueAttribute(
      MinMeasuredValueAttributeCallback callback
    ) {
      readMinMeasuredValueAttribute(chipClusterPtr, callback);
    }
    public void subscribeMinMeasuredValueAttribute(
        MinMeasuredValueAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMinMeasuredValueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readMaxMeasuredValueAttribute(
      MaxMeasuredValueAttributeCallback callback
    ) {
      readMaxMeasuredValueAttribute(chipClusterPtr, callback);
    }
    public void subscribeMaxMeasuredValueAttribute(
        MaxMeasuredValueAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeMaxMeasuredValueAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readToleranceAttribute(
      IntegerAttributeCallback callback
    ) {
      readToleranceAttribute(chipClusterPtr, callback);
    }
    public void subscribeToleranceAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeToleranceAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readGeneratedCommandListAttribute(
      GeneratedCommandListAttributeCallback callback
    ) {
      readGeneratedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeGeneratedCommandListAttribute(
        GeneratedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeGeneratedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAcceptedCommandListAttribute(
      AcceptedCommandListAttributeCallback callback
    ) {
      readAcceptedCommandListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAcceptedCommandListAttribute(
        AcceptedCommandListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAcceptedCommandListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readEventListAttribute(
      EventListAttributeCallback callback
    ) {
      readEventListAttribute(chipClusterPtr, callback);
    }
    public void subscribeEventListAttribute(
        EventListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeEventListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readAttributeListAttribute(
      AttributeListAttributeCallback callback
    ) {
      readAttributeListAttribute(chipClusterPtr, callback);
    }
    public void subscribeAttributeListAttribute(
        AttributeListAttributeCallback callback
      ,
      int minInterval, int maxInterval) {
      subscribeAttributeListAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readFeatureMapAttribute(
      LongAttributeCallback callback
    ) {
      readFeatureMapAttribute(chipClusterPtr, callback);
    }
    public void subscribeFeatureMapAttribute(
        LongAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeFeatureMapAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    public void readClusterRevisionAttribute(
      IntegerAttributeCallback callback
    ) {
      readClusterRevisionAttribute(chipClusterPtr, callback);
    }
    public void subscribeClusterRevisionAttribute(
        IntegerAttributeCallback callback
,
      int minInterval, int maxInterval) {
      subscribeClusterRevisionAttribute(chipClusterPtr, callback, minInterval, maxInterval);
    }

    private native void readMeasuredValueAttribute(long chipClusterPtr,
        MeasuredValueAttributeCallback callback
    );
    private native void subscribeMeasuredValueAttribute(long chipClusterPtr,
        MeasuredValueAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMinMeasuredValueAttribute(long chipClusterPtr,
        MinMeasuredValueAttributeCallback callback
    );
    private native void subscribeMinMeasuredValueAttribute(long chipClusterPtr,
        MinMeasuredValueAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readMaxMeasuredValueAttribute(long chipClusterPtr,
        MaxMeasuredValueAttributeCallback callback
    );
    private native void subscribeMaxMeasuredValueAttribute(long chipClusterPtr,
        MaxMeasuredValueAttributeCallback callback
      , int minInterval, int maxInterval);

    private native void readToleranceAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
    );
    private native void subscribeToleranceAttribute(long chipClusterPtr,
        IntegerAttributeCallback callback
, int m