/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP
package chip.devicecontroller;

public final class ChipIdLookup {
  /**
   * Translates cluster ID to a cluster name in upper camel case. If no matching
   * ID is found, returns an empty string.
   */
  public static String clusterIdToName(long clusterId) {
    if (clusterId == 3L) {
      return "Identify";
    }
    if (clusterId == 4L) {
      return "Groups";
    }
    if (clusterId == 5L) {
      return "Scenes";
    }
    if (clusterId == 6L) {
      return "OnOff";
    }
    if (clusterId == 7L) {
      return "OnOffSwitchConfiguration";
    }
    if (clusterId == 8L) {
      return "LevelControl";
    }
    if (clusterId == 15L) {
      return "BinaryInputBasic";
    }
    if (clusterId == 28L) {
      return "PulseWidthModulation";
    }
    if (clusterId == 29L) {
      return "Descriptor";
    }
    if (clusterId == 30L) {
      return "Binding";
    }
    if (clusterId == 31L) {
      return "AccessControl";
    }
    if (clusterId == 37L) {
      return "Actions";
    }
    if (clusterId == 40L) {
      return "BasicInformation";
    }
    if (clusterId == 41L) {
      return "OtaSoftwareUpdateProvider";
    }
    if (clusterId == 42L) {
      return "OtaSoftwareUpdateRequestor";
    }
    if (clusterId == 43L) {
      return "LocalizationConfiguration";
    }
    if (clusterId == 44L) {
      return "TimeFormatLocalization";
    }
    if (clusterId == 45L) {
      return "UnitLocalization";
    }
    if (clusterId == 46L) {
      return "PowerSourceConfiguration";
    }
    if (clusterId == 47L) {
      return "PowerSource";
    }
    if (clusterId == 48L) {
      return "GeneralCommissioning";
    }
    if (clusterId == 49L) {
      return "NetworkCommissioning";
    }
    if (clusterId == 50L) {
      return "DiagnosticLogs";
    }
    if (clusterId == 51L) {
      return "GeneralDiagnostics";
    }
    if (clusterId == 52L) {
      return "SoftwareDiagnostics";
    }
    if (clusterId == 53L) {
      return "ThreadNetworkDiagnostics";
    }
    if (clusterId == 54L) {
      return "WiFiNetworkDiagnostics";
    }
    if (clusterId == 55L) {
      return "EthernetNetworkDiagnostics";
    }
    if (clusterId == 56L) {
      return "TimeSynchronization";
    }
    if (clusterId == 57L) {
      return "BridgedDeviceBasicInformation";
    }
    if (clusterId == 59L) {
      return "Switch";
    }
    if (clusterId == 60L) {
      return "AdministratorCommissioning";
    }
    if (clusterId == 62L) {
      return "OperationalCredentials";
    }
    if (clusterId == 63L) {
      return "GroupKeyManagement";
    }
    if (clusterId == 64L) {
      return "FixedLabel";
    }
    if (clusterId == 65L) {
      return "UserLabel";
    }
    if (clusterId == 66L) {
      return "ProxyConfiguration";
    }
    if (clusterId == 67L) {
      return "ProxyDiscovery";
    }
    if (clusterId == 68L) {
      return "ProxyValid";
    }
    if (clusterId == 69L) {
      return "BooleanState";
    }
    if (clusterId == 70L) {
      return "IcdManagement";
    }
    if (clusterId == 80L) {
      return "ModeSelect";
    }
    if (clusterId == 86L) {
      return "TemperatureControl";
    }
    if (clusterId == 87L) {
      return "RefrigeratorAlarm";
    }
    if (clusterId == 91L) {
      return "AirQuality";
    }
    if (clusterId == 92L) {
      return "SmokeCoAlarm";
    }
    if (clusterId == 96L) {
      return "OperationalState";
    }
    if (clusterId == 113L) {
      return "HepaFilterMonitoring";
    }
    if (clusterId == 114L) {
      return "ActivatedCarbonFilterMonitoring";
    }
    if (clusterId == 115L) {
      return "CeramicFilterMonitoring";
    }
    if (clusterId == 116L) {
      return "ElectrostaticFilterMonitoring";
    }
    if (clusterId == 117L) {
      return "UvFilterMonitoring";
    }
    if (clusterId == 118L) {
      return "IonizingFilterMonitoring";
    }
    if (clusterId == 119L) {
      return "ZeoliteFilterMonitoring";
    }
    if (clusterId == 120L) {
      return "OzoneFilterMonitoring";
    }
    if (clusterId == 121L) {
      return "WaterTankMonitoring";
    }
    if (clusterId == 122L) {
      return "FuelTankMonitoring";
    }
    if (clusterId == 123L) {
      return "InkCartridgeMonitoring";
    }
    if (clusterId == 124L) {
      return "TonerCartridgeMonitoring";
    }
    if (clusterId == 257L) {
      return "DoorLock";
    }
    if (clusterId == 258L) {
      return "WindowCovering";
    }
    if (clusterId == 259L) {
      return "BarrierControl";
    }
    if (clusterId == 512L) {
      return "PumpConfigurationAndControl";
    }
    if (clusterId == 513L) {
      return "Thermostat";
    }
    if (clusterId == 514L) {
      return "FanControl";
    }
    if (clusterId == 516L) {
      return "ThermostatUserInterfaceConfiguration";
    }
    if (clusterId == 768L) {
      return "ColorControl";
    }
    if (clusterId == 769L) {
      return "BallastConfiguration";
    }
    if (clusterId == 1024L) {
      return "IlluminanceMeasurement";
    }
    if (clusterId == 1026L) {
      return "TemperatureMeasurement";
    }
    if (clusterId == 1027L) {
      return "PressureMeasurement";
    }
    if (clusterId == 1028L) {
      return "FlowMeasurement";
    }
    if (clusterId == 1029L) {
      return "RelativeHumidityMeasurement";
    }
    if (clusterId == 1030L) {
      return "OccupancySensing";
    }
    if (clusterId == 1036L) {
      return "CarbonMonoxideConcentrationMeasurement";
    }
    if (clusterId == 1037L) {
      return "CarbonDioxideConcentrationMeasurement";
    }
    if (clusterId == 1038L) {
      return "EthyleneConcentrationMeasurement";
    }
    if (clusterId == 1039L) {
      return "EthyleneOxideConcentrationMeasurement";
    }
    if (clusterId == 1040L) {
      return "HydrogenConcentrationMeasurement";
    }
    if (clusterId == 1041L) {
      return "HydrogenSulfideConcentrationMeasurement";
    }
    if (clusterId == 1042L) {
      return "NitricOxideConcentrationMeasurement";
    }
    if (clusterId == 1043L) {
      return "NitrogenDioxideConcentrationMeasurement";
    }
    if (clusterId == 1044L) {
      return "OxygenConcentrationMeasurement";
    }
    if (clusterId == 1045L) {
      return "OzoneConcentrationMeasurement";
    }
    if (clusterId == 1046L) {
      return "SulfurDioxideConcentrationMeasurement";
    }
    if (clusterId == 1047L) {
      return "DissolvedOxygenConcentrationMeasurement";
    }
    if (clusterId == 1048L) {
      return "BromateConcentrationMeasurement";
    }
    if (clusterId == 1049L) {
      return "ChloraminesConcentrationMeasurement";
    }
    if (clusterId == 1050L) {
      return "ChlorineConcentrationMeasurement";
    }
    if (clusterId == 1051L) {
      return "FecalColiformEColiConcentrationMeasurement";
    }
    if (clusterId == 1052L) {
      return "FluorideConcentrationMeasurement";
    }
    if (clusterId == 1053L) {
      return "HaloaceticAcidsConcentrationMeasurement";
    }
    if (clusterId == 1054L) {
      return "TotalTrihalomethanesConcentrationMeasurement";
    }
    if (clusterId == 1055L) {
      return "TotalColiformBacteriaConcentrationMeasurement";
    }
    if (clusterId == 1056L) {
      return "TurbidityConcentrationMeasurement";
    }
    if (clusterId == 1057L) {
      return "CopperConcentrationMeasurement";
    }
    if (clusterId == 1058L) {
      return "LeadConcentrationMeasurement";
    }
    if (clusterId == 1059L) {
      return "ManganeseConcentrationMeasurement";
    }
    if (clusterId == 1060L) {
      return "SulfateConcentrationMeasurement";
    }
    if (clusterId == 1061L) {
      return "BromodichloromethaneConcentrationMeasurement";
    }
    if (clusterId == 1062L) {
      return "BromoformConcentrationMeasurement";
    }
    if (clusterId == 1063L) {
      return "ChlorodibromomethaneConcentrationMeasurement";
    }
    if (clusterId == 1064L) {
      return "ChloroformConcentrationMeasurement";
    }
    if (clusterId == 1065L) {
      return "SodiumConcentrationMeasurement";
    }
    if (clusterId == 1066L) {
      return "Pm25ConcentrationMeasurement";
    }
    if (clusterId == 1067L) {
      return "FormaldehydeConcentrationMeasurement";
    }
    if (clusterId == 1068L) {
      return "Pm1ConcentrationMeasurement";
    }
    if (clusterId == 1069L) {
      return "Pm10ConcentrationMeasurement";
    }
    if (clusterId == 1070L) {
      return "TotalVolatileOrganicCompoundsConcentrationMeasurement";
    }
    if (clusterId == 1071L) {
      return "RadonConcentrationMeasurement";
    }
    if (clusterId == 1283L) {
      return "WakeOnLan";
    }
    if (clusterId == 1284L) {
      return "Channel";
    }
    if (clusterId == 1285L) {
      return "TargetNavigator";
    }
    if (clusterId == 1286L) {
      return "MediaPlayback";
    }
    if (clusterId == 1287L) {
      return "MediaInput";
    }
    if (clusterId == 1288L) {
      return "LowPower";
    }
    if (clusterId == 1289L) {
      return "KeypadInput";
    }
    if (clusterId == 1290L) {
      return "ContentLauncher";
    }
    if (clusterId == 1291L) {
      return "AudioOutput";
    }
    if (clusterId == 1292L) {
      return "ApplicationLauncher";
    }
    if (clusterId == 1293L) {
      return "ApplicationBasic";
    }
    if (clusterId == 1294L) {
      return "AccountLogin";
    }
    if (clusterId == 2820L) {
      return "ElectricalMeasurement";
    }
    if (clusterId == 4294048773L) {
      return "UnitTesting";
    }
    if (clusterId == 4294048774L) {
      return "FaultInjection";
    }
    return "";
  }

  /**
   * Translates cluster ID and attribute ID to an attribute name in upper camel case.
   * If no matching IDs are found, returns an empty string.
   */
  public static String attributeIdToName(long clusterId, long attributeId) {
    if (clusterId == 3L) {
      if (attributeId == 0L) {
        return "IdentifyTime";
      }
      if (attributeId == 1L) {
        return "IdentifyType";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 4L) {
      if (attributeId == 0L) {
        return "NameSupport";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 5L) {
      if (attributeId == 0L) {
        return "SceneCount";
      }
      if (attributeId == 1L) {
        return "CurrentScene";
      }
      if (attributeId == 2L) {
        return "CurrentGroup";
      }
      if (attributeId == 3L) {
        return "SceneValid";
      }
      if (attributeId == 4L) {
        return "NameSupport";
      }
      if (attributeId == 5L) {
        return "LastConfiguredBy";
      }
      if (attributeId == 6L) {
        return "SceneTableSize";
      }
      if (attributeId == 7L) {
        return "RemainingCapacity";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 6L) {
      if (attributeId == 0L) {
        return "OnOff";
      }
      if (attributeId == 16384L) {
        return "GlobalSceneControl";
      }
      if (attributeId == 16385L) {
        return "OnTime";
      }
      if (attributeId == 16386L) {
        return "OffWaitTime";
      }
      if (attributeId == 16387L) {
        return "StartUpOnOff";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 7L) {
      if (attributeId == 0L) {
        return "SwitchType";
      }
      if (attributeId == 16L) {
        return "SwitchActions";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 8L) {
      if (attributeId == 0L) {
        return "CurrentLevel";
      }
      if (attributeId == 1L) {
        return "RemainingTime";
      }
      if (attributeId == 2L) {
        return "MinLevel";
      }
      if (attributeId == 3L) {
        return "MaxLevel";
      }
      if (attributeId == 4L) {
        return "CurrentFrequency";
      }
      if (attributeId == 5L) {
        return "MinFrequency";
      }
      if (attributeId == 6L) {
        return "MaxFrequency";
      }
      if (attributeId == 15L) {
        return "Options";
      }
      if (attributeId == 16L) {
        return "OnOffTransitionTime";
      }
      if (attributeId == 17L) {
        return "OnLevel";
      }
      if (attributeId == 18L) {
        return "OnTransitionTime";
      }
      if (attributeId == 19L) {
        return "OffTransitionTime";
      }
      if (attributeId == 20L) {
        return "DefaultMoveRate";
      }
      if (attributeId == 16384L) {
        return "StartUpCurrentLevel";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 15L) {
      if (attributeId == 4L) {
        return "ActiveText";
      }
      if (attributeId == 28L) {
        return "Description";
      }
      if (attributeId == 46L) {
        return "InactiveText";
      }
      if (attributeId == 81L) {
        return "OutOfService";
      }
      if (attributeId == 84L) {
        return "Polarity";
      }
      if (attributeId == 85L) {
        return "PresentValue";
      }
      if (attributeId == 103L) {
        return "Reliability";
      }
      if (attributeId == 111L) {
        return "StatusFlags";
      }
      if (attributeId == 256L) {
        return "ApplicationType";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 28L) {
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 29L) {
      if (attributeId == 0L) {
        return "DeviceTypeList";
      }
      if (attributeId == 1L) {
        return "ServerList";
      }
      if (attributeId == 2L) {
        return "ClientList";
      }
      if (attributeId == 3L) {
        return "PartsList";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 30L) {
      if (attributeId == 0L) {
        return "Binding";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 31L) {
      if (attributeId == 0L) {
        return "Acl";
      }
      if (attributeId == 1L) {
        return "Extension";
      }
      if (attributeId == 2L) {
        return "SubjectsPerAccessControlEntry";
      }
      if (attributeId == 3L) {
        return "TargetsPerAccessControlEntry";
      }
      if (attributeId == 4L) {
        return "AccessControlEntriesPerFabric";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 37L) {
      if (attributeId == 0L) {
        return "ActionList";
      }
      if (attributeId == 1L) {
        return "EndpointLists";
      }
      if (attributeId == 2L) {
        return "SetupURL";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 40L) {
      if (attributeId == 0L) {
        return "DataModelRevision";
      }
      if (attributeId == 1L) {
        return "VendorName";
      }
      if (attributeId == 2L) {
        return "VendorID";
      }
      if (attributeId == 3L) {
        return "ProductName";
      }
      if (attributeId == 4L) {
        return "ProductID";
      }
      if (attributeId == 5L) {
        return "NodeLabel";
      }
      if (attributeId == 6L) {
        return "Location";
      }
      if (attributeId == 7L) {
        return "HardwareVersion";
      }
      if (attributeId == 8L) {
        return "HardwareVersionString";
      }
      if (attributeId == 9L) {
        return "SoftwareVersion";
      }
      if (attributeId == 10L) {
        return "SoftwareVersionString";
      }
      if (attributeId == 11L) {
        return "ManufacturingDate";
      }
      if (attributeId == 12L) {
        return "PartNumber";
      }
      if (attributeId == 13L) {
        return "ProductURL";
      }
      if (attributeId == 14L) {
        return "ProductLabel";
      }
      if (attributeId == 15L) {
        return "SerialNumber";
      }
      if (attributeId == 16L) {
        return "LocalConfigDisabled";
      }
      if (attributeId == 17L) {
        return "Reachable";
      }
      if (attributeId == 18L) {
        return "UniqueID";
      }
      if (attributeId == 19L) {
        return "CapabilityMinima";
      }
      if (attributeId == 20L) {
        return "ProductAppearance";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 41L) {
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 42L) {
      if (attributeId == 0L) {
        return "DefaultOTAProviders";
      }
      if (attributeId == 1L) {
        return "UpdatePossible";
      }
      if (attributeId == 2L) {
        return "UpdateState";
      }
      if (attributeId == 3L) {
        return "UpdateStateProgress";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 43L) {
      if (attributeId == 0L) {
        return "ActiveLocale";
      }
      if (attributeId == 1L) {
        return "SupportedLocales";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 44L) {
      if (attributeId == 0L) {
        return "HourFormat";
      }
      if (attributeId == 1L) {
        return "ActiveCalendarType";
      }
      if (attributeId == 2L) {
        return "SupportedCalendarTypes";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 45L) {
      if (attributeId == 0L) {
        return "TemperatureUnit";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 46L) {
      if (attributeId == 0L) {
        return "Sources";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 47L) {
      if (attributeId == 0L) {
        return "Status";
      }
      if (attributeId == 1L) {
        return "Order";
      }
      if (attributeId == 2L) {
        return "Description";
      }
      if (attributeId == 3L) {
        return "WiredAssessedInputVoltage";
      }
      if (attributeId == 4L) {
        return "WiredAssessedInputFrequency";
      }
      if (attributeId == 5L) {
        return "WiredCurrentType";
      }
      if (attributeId == 6L) {
        return "WiredAssessedCurrent";
      }
      if (attributeId == 7L) {
        return "WiredNominalVoltage";
      }
      if (attributeId == 8L) {
        return "WiredMaximumCurrent";
      }
      if (attributeId == 9L) {
        return "WiredPresent";
      }
      if (attributeId == 10L) {
        return "ActiveWiredFaults";
      }
      if (attributeId == 11L) {
        return "BatVoltage";
      }
      if (attributeId == 12L) {
        return "BatPercentRemaining";
      }
      if (attributeId == 13L) {
        return "BatTimeRemaining";
      }
      if (attributeId == 14L) {
        return "BatChargeLevel";
      }
      if (attributeId == 15L) {
        return "BatReplacementNeeded";
      }
      if (attributeId == 16L) {
        return "BatReplaceability";
      }
      if (attributeId == 17L) {
        return "BatPresent";
      }
      if (attributeId == 18L) {
        return "ActiveBatFaults";
      }
      if (attributeId == 19L) {
        return "BatReplacementDescription";
      }
      if (attributeId == 20L) {
        return "BatCommonDesignation";
      }
      if (attributeId == 21L) {
        return "BatANSIDesignation";
      }
      if (attributeId == 22L) {
        return "BatIECDesignation";
      }
      if (attributeId == 23L) {
        return "BatApprovedChemistry";
      }
      if (attributeId == 24L) {
        return "BatCapacity";
      }
      if (attributeId == 25L) {
        return "BatQuantity";
      }
      if (attributeId == 26L) {
        return "BatChargeState";
      }
      if (attributeId == 27L) {
        return "BatTimeToFullCharge";
      }
      if (attributeId == 28L) {
        return "BatFunctionalWhileCharging";
      }
      if (attributeId == 29L) {
        return "BatChargingCurrent";
      }
      if (attributeId == 30L) {
        return "ActiveBatChargeFaults";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 48L) {
      if (attributeId == 0L) {
        return "Breadcrumb";
      }
      if (attributeId == 1L) {
        return "BasicCommissioningInfo";
      }
      if (attributeId == 2L) {
        return "RegulatoryConfig";
      }
      if (attributeId == 3L) {
        return "LocationCapability";
      }
      if (attributeId == 4L) {
        return "SupportsConcurrentConnection";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 49L) {
      if (attributeId == 0L) {
        return "MaxNetworks";
      }
      if (attributeId == 1L) {
        return "Networks";
      }
      if (attributeId == 2L) {
        return "ScanMaxTimeSeconds";
      }
      if (attributeId == 3L) {
        return "ConnectMaxTimeSeconds";
      }
      if (attributeId == 4L) {
        return "InterfaceEnabled";
      }
      if (attributeId == 5L) {
        return "LastNetworkingStatus";
      }
      if (attributeId == 6L) {
        return "LastNetworkID";
      }
      if (attributeId == 7L) {
        return "LastConnectErrorValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 50L) {
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 51L) {
      if (attributeId == 0L) {
        return "NetworkInterfaces";
      }
      if (attributeId == 1L) {
        return "RebootCount";
      }
      if (attributeId == 2L) {
        return "UpTime";
      }
      if (attributeId == 3L) {
        return "TotalOperationalHours";
      }
      if (attributeId == 4L) {
        return "BootReason";
      }
      if (attributeId == 5L) {
        return "ActiveHardwareFaults";
      }
      if (attributeId == 6L) {
        return "ActiveRadioFaults";
      }
      if (attributeId == 7L) {
        return "ActiveNetworkFaults";
      }
      if (attributeId == 8L) {
        return "TestEventTriggersEnabled";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 52L) {
      if (attributeId == 0L) {
        return "ThreadMetrics";
      }
      if (attributeId == 1L) {
        return "CurrentHeapFree";
      }
      if (attributeId == 2L) {
        return "CurrentHeapUsed";
      }
      if (attributeId == 3L) {
        return "CurrentHeapHighWatermark";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 53L) {
      if (attributeId == 0L) {
        return "Channel";
      }
      if (attributeId == 1L) {
        return "RoutingRole";
      }
      if (attributeId == 2L) {
        return "NetworkName";
      }
      if (attributeId == 3L) {
        return "PanId";
      }
      if (attributeId == 4L) {
        return "ExtendedPanId";
      }
      if (attributeId == 5L) {
        return "MeshLocalPrefix";
      }
      if (attributeId == 6L) {
        return "OverrunCount";
      }
      if (attributeId == 7L) {
        return "NeighborTable";
      }
      if (attributeId == 8L) {
        return "RouteTable";
      }
      if (attributeId == 9L) {
        return "PartitionId";
      }
      if (attributeId == 10L) {
        return "Weighting";
      }
      if (attributeId == 11L) {
        return "DataVersion";
      }
      if (attributeId == 12L) {
        return "StableDataVersion";
      }
      if (attributeId == 13L) {
        return "LeaderRouterId";
      }
      if (attributeId == 14L) {
        return "DetachedRoleCount";
      }
      if (attributeId == 15L) {
        return "ChildRoleCount";
      }
      if (attributeId == 16L) {
        return "RouterRoleCount";
      }
      if (attributeId == 17L) {
        return "LeaderRoleCount";
      }
      if (attributeId == 18L) {
        return "AttachAttemptCount";
      }
      if (attributeId == 19L) {
        return "PartitionIdChangeCount";
      }
      if (attributeId == 20L) {
        return "BetterPartitionAttachAttemptCount";
      }
      if (attributeId == 21L) {
        return "ParentChangeCount";
      }
      if (attributeId == 22L) {
        return "TxTotalCount";
      }
      if (attributeId == 23L) {
        return "TxUnicastCount";
      }
      if (attributeId == 24L) {
        return "TxBroadcastCount";
      }
      if (attributeId == 25L) {
        return "TxAckRequestedCount";
      }
      if (attributeId == 26L) {
        return "TxAckedCount";
      }
      if (attributeId == 27L) {
        return "TxNoAckRequestedCount";
      }
      if (attributeId == 28L) {
        return "TxDataCount";
      }
      if (attributeId == 29L) {
        return "TxDataPollCount";
      }
      if (attributeId == 30L) {
        return "TxBeaconCount";
      }
      if (attributeId == 31L) {
        return "TxBeaconRequestCount";
      }
      if (attributeId == 32L) {
        return "TxOtherCount";
      }
      if (attributeId == 33L) {
        return "TxRetryCount";
      }
      if (attributeId == 34L) {
        return "TxDirectMaxRetryExpiryCount";
      }
      if (attributeId == 35L) {
        return "TxIndirectMaxRetryExpiryCount";
      }
      if (attributeId == 36L) {
        return "TxErrCcaCount";
      }
      if (attributeId == 37L) {
        return "TxErrAbortCount";
      }
      if (attributeId == 38L) {
        return "TxErrBusyChannelCount";
      }
      if (attributeId == 39L) {
        return "RxTotalCount";
      }
      if (attributeId == 40L) {
        return "RxUnicastCount";
      }
      if (attributeId == 41L) {
        return "RxBroadcastCount";
      }
      if (attributeId == 42L) {
        return "RxDataCount";
      }
      if (attributeId == 43L) {
        return "RxDataPollCount";
      }
      if (attributeId == 44L) {
        return "RxBeaconCount";
      }
      if (attributeId == 45L) {
        return "RxBeaconRequestCount";
      }
      if (attributeId == 46L) {
        return "RxOtherCount";
      }
      if (attributeId == 47L) {
        return "RxAddressFilteredCount";
      }
      if (attributeId == 48L) {
        return "RxDestAddrFilteredCount";
      }
      if (attributeId == 49L) {
        return "RxDuplicatedCount";
      }
      if (attributeId == 50L) {
        return "RxErrNoFrameCount";
      }
      if (attributeId == 51L) {
        return "RxErrUnknownNeighborCount";
      }
      if (attributeId == 52L) {
        return "RxErrInvalidSrcAddrCount";
      }
      if (attributeId == 53L) {
        return "RxErrSecCount";
      }
      if (attributeId == 54L) {
        return "RxErrFcsCount";
      }
      if (attributeId == 55L) {
        return "RxErrOtherCount";
      }
      if (attributeId == 56L) {
        return "ActiveTimestamp";
      }
      if (attributeId == 57L) {
        return "PendingTimestamp";
      }
      if (attributeId == 58L) {
        return "Delay";
      }
      if (attributeId == 59L) {
        return "SecurityPolicy";
      }
      if (attributeId == 60L) {
        return "ChannelPage0Mask";
      }
      if (attributeId == 61L) {
        return "OperationalDatasetComponents";
      }
      if (attributeId == 62L) {
        return "ActiveNetworkFaultsList";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 54L) {
      if (attributeId == 0L) {
        return "Bssid";
      }
      if (attributeId == 1L) {
        return "SecurityType";
      }
      if (attributeId == 2L) {
        return "WiFiVersion";
      }
      if (attributeId == 3L) {
        return "ChannelNumber";
      }
      if (attributeId == 4L) {
        return "Rssi";
      }
      if (attributeId == 5L) {
        return "BeaconLostCount";
      }
      if (attributeId == 6L) {
        return "BeaconRxCount";
      }
      if (attributeId == 7L) {
        return "PacketMulticastRxCount";
      }
      if (attributeId == 8L) {
        return "PacketMulticastTxCount";
      }
      if (attributeId == 9L) {
        return "PacketUnicastRxCount";
      }
      if (attributeId == 10L) {
        return "PacketUnicastTxCount";
      }
      if (attributeId == 11L) {
        return "CurrentMaxRate";
      }
      if (attributeId == 12L) {
        return "OverrunCount";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 55L) {
      if (attributeId == 0L) {
        return "PHYRate";
      }
      if (attributeId == 1L) {
        return "FullDuplex";
      }
      if (attributeId == 2L) {
        return "PacketRxCount";
      }
      if (attributeId == 3L) {
        return "PacketTxCount";
      }
      if (attributeId == 4L) {
        return "TxErrCount";
      }
      if (attributeId == 5L) {
        return "CollisionCount";
      }
      if (attributeId == 6L) {
        return "OverrunCount";
      }
      if (attributeId == 7L) {
        return "CarrierDetect";
      }
      if (attributeId == 8L) {
        return "TimeSinceReset";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 56L) {
      if (attributeId == 0L) {
        return "UTCTime";
      }
      if (attributeId == 1L) {
        return "Granularity";
      }
      if (attributeId == 2L) {
        return "TimeSource";
      }
      if (attributeId == 3L) {
        return "TrustedTimeSource";
      }
      if (attributeId == 4L) {
        return "DefaultNTP";
      }
      if (attributeId == 5L) {
        return "TimeZone";
      }
      if (attributeId == 6L) {
        return "DSTOffset";
      }
      if (attributeId == 7L) {
        return "LocalTime";
      }
      if (attributeId == 8L) {
        return "TimeZoneDatabase";
      }
      if (attributeId == 9L) {
        return "NTPServerAvailable";
      }
      if (attributeId == 10L) {
        return "TimeZoneListMaxSize";
      }
      if (attributeId == 11L) {
        return "DSTOffsetListMaxSize";
      }
      if (attributeId == 12L) {
        return "SupportsDNSResolve";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 57L) {
      if (attributeId == 1L) {
        return "VendorName";
      }
      if (attributeId == 2L) {
        return "VendorID";
      }
      if (attributeId == 3L) {
        return "ProductName";
      }
      if (attributeId == 5L) {
        return "NodeLabel";
      }
      if (attributeId == 7L) {
        return "HardwareVersion";
      }
      if (attributeId == 8L) {
        return "HardwareVersionString";
      }
      if (attributeId == 9L) {
        return "SoftwareVersion";
      }
      if (attributeId == 10L) {
        return "SoftwareVersionString";
      }
      if (attributeId == 11L) {
        return "ManufacturingDate";
      }
      if (attributeId == 12L) {
        return "PartNumber";
      }
      if (attributeId == 13L) {
        return "ProductURL";
      }
      if (attributeId == 14L) {
        return "ProductLabel";
      }
      if (attributeId == 15L) {
        return "SerialNumber";
      }
      if (attributeId == 17L) {
        return "Reachable";
      }
      if (attributeId == 18L) {
        return "UniqueID";
      }
      if (attributeId == 20L) {
        return "ProductAppearance";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 59L) {
      if (attributeId == 0L) {
        return "NumberOfPositions";
      }
      if (attributeId == 1L) {
        return "CurrentPosition";
      }
      if (attributeId == 2L) {
        return "MultiPressMax";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 60L) {
      if (attributeId == 0L) {
        return "WindowStatus";
      }
      if (attributeId == 1L) {
        return "AdminFabricIndex";
      }
      if (attributeId == 2L) {
        return "AdminVendorId";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 62L) {
      if (attributeId == 0L) {
        return "NOCs";
      }
      if (attributeId == 1L) {
        return "Fabrics";
      }
      if (attributeId == 2L) {
        return "SupportedFabrics";
      }
      if (attributeId == 3L) {
        return "CommissionedFabrics";
      }
      if (attributeId == 4L) {
        return "TrustedRootCertificates";
      }
      if (attributeId == 5L) {
        return "CurrentFabricIndex";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 63L) {
      if (attributeId == 0L) {
        return "GroupKeyMap";
      }
      if (attributeId == 1L) {
        return "GroupTable";
      }
      if (attributeId == 2L) {
        return "MaxGroupsPerFabric";
      }
      if (attributeId == 3L) {
        return "MaxGroupKeysPerFabric";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 64L) {
      if (attributeId == 0L) {
        return "LabelList";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 65L) {
      if (attributeId == 0L) {
        return "LabelList";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 66L) {
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 67L) {
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 68L) {
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 69L) {
      if (attributeId == 0L) {
        return "StateValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 70L) {
      if (attributeId == 0L) {
        return "IdleModeInterval";
      }
      if (attributeId == 1L) {
        return "ActiveModeInterval";
      }
      if (attributeId == 2L) {
        return "ActiveModeThreshold";
      }
      if (attributeId == 3L) {
        return "RegisteredClients";
      }
      if (attributeId == 4L) {
        return "ICDCounter";
      }
      if (attributeId == 5L) {
        return "ClientsSupportedPerFabric";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 80L) {
      if (attributeId == 0L) {
        return "Description";
      }
      if (attributeId == 1L) {
        return "StandardNamespace";
      }
      if (attributeId == 2L) {
        return "SupportedModes";
      }
      if (attributeId == 3L) {
        return "CurrentMode";
      }
      if (attributeId == 4L) {
        return "StartUpMode";
      }
      if (attributeId == 5L) {
        return "OnMode";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 86L) {
      if (attributeId == 0L) {
        return "TemperatureSetpoint";
      }
      if (attributeId == 1L) {
        return "MinTemperature";
      }
      if (attributeId == 2L) {
        return "MaxTemperature";
      }
      if (attributeId == 3L) {
        return "Step";
      }
      if (attributeId == 4L) {
        return "CurrentTemperatureLevelIndex";
      }
      if (attributeId == 5L) {
        return "SupportedTemperatureLevels";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 87L) {
      if (attributeId == 0L) {
        return "Mask";
      }
      if (attributeId == 1L) {
        return "Latch";
      }
      if (attributeId == 2L) {
        return "State";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 91L) {
      if (attributeId == 0L) {
        return "AirQuality";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 92L) {
      if (attributeId == 0L) {
        return "ExpressedState";
      }
      if (attributeId == 1L) {
        return "SmokeState";
      }
      if (attributeId == 2L) {
        return "COState";
      }
      if (attributeId == 3L) {
        return "BatteryAlert";
      }
      if (attributeId == 4L) {
        return "DeviceMuted";
      }
      if (attributeId == 5L) {
        return "TestInProgress";
      }
      if (attributeId == 6L) {
        return "HardwareFaultAlert";
      }
      if (attributeId == 7L) {
        return "EndOfServiceAlert";
      }
      if (attributeId == 8L) {
        return "InterconnectSmokeAlarm";
      }
      if (attributeId == 9L) {
        return "InterconnectCOAlarm";
      }
      if (attributeId == 10L) {
        return "ContaminationState";
      }
      if (attributeId == 11L) {
        return "SensitivityLevel";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 96L) {
      if (attributeId == 0L) {
        return "PhaseList";
      }
      if (attributeId == 1L) {
        return "CurrentPhase";
      }
      if (attributeId == 2L) {
        return "CountdownTime";
      }
      if (attributeId == 3L) {
        return "OperationalStateList";
      }
      if (attributeId == 4L) {
        return "OperationalState";
      }
      if (attributeId == 5L) {
        return "OperationalError";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 113L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 114L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 115L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 116L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 117L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 118L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 119L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 120L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 121L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 122L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 123L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 124L) {
      if (attributeId == 0L) {
        return "Condition";
      }
      if (attributeId == 1L) {
        return "DegradationDirection";
      }
      if (attributeId == 2L) {
        return "ChangeIndication";
      }
      if (attributeId == 3L) {
        return "InPlaceIndicator";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 257L) {
      if (attributeId == 0L) {
        return "LockState";
      }
      if (attributeId == 1L) {
        return "LockType";
      }
      if (attributeId == 2L) {
        return "ActuatorEnabled";
      }
      if (attributeId == 3L) {
        return "DoorState";
      }
      if (attributeId == 4L) {
        return "DoorOpenEvents";
      }
      if (attributeId == 5L) {
        return "DoorClosedEvents";
      }
      if (attributeId == 6L) {
        return "OpenPeriod";
      }
      if (attributeId == 17L) {
        return "NumberOfTotalUsersSupported";
      }
      if (attributeId == 18L) {
        return "NumberOfPINUsersSupported";
      }
      if (attributeId == 19L) {
        return "NumberOfRFIDUsersSupported";
      }
      if (attributeId == 20L) {
        return "NumberOfWeekDaySchedulesSupportedPerUser";
      }
      if (attributeId == 21L) {
        return "NumberOfYearDaySchedulesSupportedPerUser";
      }
      if (attributeId == 22L) {
        return "NumberOfHolidaySchedulesSupported";
      }
      if (attributeId == 23L) {
        return "MaxPINCodeLength";
      }
      if (attributeId == 24L) {
        return "MinPINCodeLength";
      }
      if (attributeId == 25L) {
        return "MaxRFIDCodeLength";
      }
      if (attributeId == 26L) {
        return "MinRFIDCodeLength";
      }
      if (attributeId == 27L) {
        return "CredentialRulesSupport";
      }
      if (attributeId == 28L) {
        return "NumberOfCredentialsSupportedPerUser";
      }
      if (attributeId == 33L) {
        return "Language";
      }
      if (attributeId == 34L) {
        return "LEDSettings";
      }
      if (attributeId == 35L) {
        return "AutoRelockTime";
      }
      if (attributeId == 36L) {
        return "SoundVolume";
      }
      if (attributeId == 37L) {
        return "OperatingMode";
      }
      if (attributeId == 38L) {
        return "SupportedOperatingModes";
      }
      if (attributeId == 39L) {
        return "DefaultConfigurationRegister";
      }
      if (attributeId == 40L) {
        return "EnableLocalProgramming";
      }
      if (attributeId == 41L) {
        return "EnableOneTouchLocking";
      }
      if (attributeId == 42L) {
        return "EnableInsideStatusLED";
      }
      if (attributeId == 43L) {
        return "EnablePrivacyModeButton";
      }
      if (attributeId == 44L) {
        return "LocalProgrammingFeatures";
      }
      if (attributeId == 48L) {
        return "WrongCodeEntryLimit";
      }
      if (attributeId == 49L) {
        return "UserCodeTemporaryDisableTime";
      }
      if (attributeId == 50L) {
        return "SendPINOverTheAir";
      }
      if (attributeId == 51L) {
        return "RequirePINforRemoteOperation";
      }
      if (attributeId == 53L) {
        return "ExpiringUserTimeout";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 258L) {
      if (attributeId == 0L) {
        return "Type";
      }
      if (attributeId == 1L) {
        return "PhysicalClosedLimitLift";
      }
      if (attributeId == 2L) {
        return "PhysicalClosedLimitTilt";
      }
      if (attributeId == 3L) {
        return "CurrentPositionLift";
      }
      if (attributeId == 4L) {
        return "CurrentPositionTilt";
      }
      if (attributeId == 5L) {
        return "NumberOfActuationsLift";
      }
      if (attributeId == 6L) {
        return "NumberOfActuationsTilt";
      }
      if (attributeId == 7L) {
        return "ConfigStatus";
      }
      if (attributeId == 8L) {
        return "CurrentPositionLiftPercentage";
      }
      if (attributeId == 9L) {
        return "CurrentPositionTiltPercentage";
      }
      if (attributeId == 10L) {
        return "OperationalStatus";
      }
      if (attributeId == 11L) {
        return "TargetPositionLiftPercent100ths";
      }
      if (attributeId == 12L) {
        return "TargetPositionTiltPercent100ths";
      }
      if (attributeId == 13L) {
        return "EndProductType";
      }
      if (attributeId == 14L) {
        return "CurrentPositionLiftPercent100ths";
      }
      if (attributeId == 15L) {
        return "CurrentPositionTiltPercent100ths";
      }
      if (attributeId == 16L) {
        return "InstalledOpenLimitLift";
      }
      if (attributeId == 17L) {
        return "InstalledClosedLimitLift";
      }
      if (attributeId == 18L) {
        return "InstalledOpenLimitTilt";
      }
      if (attributeId == 19L) {
        return "InstalledClosedLimitTilt";
      }
      if (attributeId == 23L) {
        return "Mode";
      }
      if (attributeId == 26L) {
        return "SafetyStatus";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 259L) {
      if (attributeId == 1L) {
        return "BarrierMovingState";
      }
      if (attributeId == 2L) {
        return "BarrierSafetyStatus";
      }
      if (attributeId == 3L) {
        return "BarrierCapabilities";
      }
      if (attributeId == 4L) {
        return "BarrierOpenEvents";
      }
      if (attributeId == 5L) {
        return "BarrierCloseEvents";
      }
      if (attributeId == 6L) {
        return "BarrierCommandOpenEvents";
      }
      if (attributeId == 7L) {
        return "BarrierCommandCloseEvents";
      }
      if (attributeId == 8L) {
        return "BarrierOpenPeriod";
      }
      if (attributeId == 9L) {
        return "BarrierClosePeriod";
      }
      if (attributeId == 10L) {
        return "BarrierPosition";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 512L) {
      if (attributeId == 0L) {
        return "MaxPressure";
      }
      if (attributeId == 1L) {
        return "MaxSpeed";
      }
      if (attributeId == 2L) {
        return "MaxFlow";
      }
      if (attributeId == 3L) {
        return "MinConstPressure";
      }
      if (attributeId == 4L) {
        return "MaxConstPressure";
      }
      if (attributeId == 5L) {
        return "MinCompPressure";
      }
      if (attributeId == 6L) {
        return "MaxCompPressure";
      }
      if (attributeId == 7L) {
        return "MinConstSpeed";
      }
      if (attributeId == 8L) {
        return "MaxConstSpeed";
      }
      if (attributeId == 9L) {
        return "MinConstFlow";
      }
      if (attributeId == 10L) {
        return "MaxConstFlow";
      }
      if (attributeId == 11L) {
        return "MinConstTemp";
      }
      if (attributeId == 12L) {
        return "MaxConstTemp";
      }
      if (attributeId == 16L) {
        return "PumpStatus";
      }
      if (attributeId == 17L) {
        return "EffectiveOperationMode";
      }
      if (attributeId == 18L) {
        return "EffectiveControlMode";
      }
      if (attributeId == 19L) {
        return "Capacity";
      }
      if (attributeId == 20L) {
        return "Speed";
      }
      if (attributeId == 21L) {
        return "LifetimeRunningHours";
      }
      if (attributeId == 22L) {
        return "Power";
      }
      if (attributeId == 23L) {
        return "LifetimeEnergyConsumed";
      }
      if (attributeId == 32L) {
        return "OperationMode";
      }
      if (attributeId == 33L) {
        return "ControlMode";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 513L) {
      if (attributeId == 0L) {
        return "LocalTemperature";
      }
      if (attributeId == 1L) {
        return "OutdoorTemperature";
      }
      if (attributeId == 2L) {
        return "Occupancy";
      }
      if (attributeId == 3L) {
        return "AbsMinHeatSetpointLimit";
      }
      if (attributeId == 4L) {
        return "AbsMaxHeatSetpointLimit";
      }
      if (attributeId == 5L) {
        return "AbsMinCoolSetpointLimit";
      }
      if (attributeId == 6L) {
        return "AbsMaxCoolSetpointLimit";
      }
      if (attributeId == 7L) {
        return "PICoolingDemand";
      }
      if (attributeId == 8L) {
        return "PIHeatingDemand";
      }
      if (attributeId == 9L) {
        return "HVACSystemTypeConfiguration";
      }
      if (attributeId == 16L) {
        return "LocalTemperatureCalibration";
      }
      if (attributeId == 17L) {
        return "OccupiedCoolingSetpoint";
      }
      if (attributeId == 18L) {
        return "OccupiedHeatingSetpoint";
      }
      if (attributeId == 19L) {
        return "UnoccupiedCoolingSetpoint";
      }
      if (attributeId == 20L) {
        return "UnoccupiedHeatingSetpoint";
      }
      if (attributeId == 21L) {
        return "MinHeatSetpointLimit";
      }
      if (attributeId == 22L) {
        return "MaxHeatSetpointLimit";
      }
      if (attributeId == 23L) {
        return "MinCoolSetpointLimit";
      }
      if (attributeId == 24L) {
        return "MaxCoolSetpointLimit";
      }
      if (attributeId == 25L) {
        return "MinSetpointDeadBand";
      }
      if (attributeId == 26L) {
        return "RemoteSensing";
      }
      if (attributeId == 27L) {
        return "ControlSequenceOfOperation";
      }
      if (attributeId == 28L) {
        return "SystemMode";
      }
      if (attributeId == 30L) {
        return "ThermostatRunningMode";
      }
      if (attributeId == 32L) {
        return "StartOfWeek";
      }
      if (attributeId == 33L) {
        return "NumberOfWeeklyTransitions";
      }
      if (attributeId == 34L) {
        return "NumberOfDailyTransitions";
      }
      if (attributeId == 35L) {
        return "TemperatureSetpointHold";
      }
      if (attributeId == 36L) {
        return "TemperatureSetpointHoldDuration";
      }
      if (attributeId == 37L) {
        return "ThermostatProgrammingOperationMode";
      }
      if (attributeId == 41L) {
        return "ThermostatRunningState";
      }
      if (attributeId == 48L) {
        return "SetpointChangeSource";
      }
      if (attributeId == 49L) {
        return "SetpointChangeAmount";
      }
      if (attributeId == 50L) {
        return "SetpointChangeSourceTimestamp";
      }
      if (attributeId == 52L) {
        return "OccupiedSetback";
      }
      if (attributeId == 53L) {
        return "OccupiedSetbackMin";
      }
      if (attributeId == 54L) {
        return "OccupiedSetbackMax";
      }
      if (attributeId == 55L) {
        return "UnoccupiedSetback";
      }
      if (attributeId == 56L) {
        return "UnoccupiedSetbackMin";
      }
      if (attributeId == 57L) {
        return "UnoccupiedSetbackMax";
      }
      if (attributeId == 58L) {
        return "EmergencyHeatDelta";
      }
      if (attributeId == 64L) {
        return "ACType";
      }
      if (attributeId == 65L) {
        return "ACCapacity";
      }
      if (attributeId == 66L) {
        return "ACRefrigerantType";
      }
      if (attributeId == 67L) {
        return "ACCompressorType";
      }
      if (attributeId == 68L) {
        return "ACErrorCode";
      }
      if (attributeId == 69L) {
        return "ACLouverPosition";
      }
      if (attributeId == 70L) {
        return "ACCoilTemperature";
      }
      if (attributeId == 71L) {
        return "ACCapacityformat";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 514L) {
      if (attributeId == 0L) {
        return "FanMode";
      }
      if (attributeId == 1L) {
        return "FanModeSequence";
      }
      if (attributeId == 2L) {
        return "PercentSetting";
      }
      if (attributeId == 3L) {
        return "PercentCurrent";
      }
      if (attributeId == 4L) {
        return "SpeedMax";
      }
      if (attributeId == 5L) {
        return "SpeedSetting";
      }
      if (attributeId == 6L) {
        return "SpeedCurrent";
      }
      if (attributeId == 7L) {
        return "RockSupport";
      }
      if (attributeId == 8L) {
        return "RockSetting";
      }
      if (attributeId == 9L) {
        return "WindSupport";
      }
      if (attributeId == 10L) {
        return "WindSetting";
      }
      if (attributeId == 11L) {
        return "AirflowDirection";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 516L) {
      if (attributeId == 0L) {
        return "TemperatureDisplayMode";
      }
      if (attributeId == 1L) {
        return "KeypadLockout";
      }
      if (attributeId == 2L) {
        return "ScheduleProgrammingVisibility";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 768L) {
      if (attributeId == 0L) {
        return "CurrentHue";
      }
      if (attributeId == 1L) {
        return "CurrentSaturation";
      }
      if (attributeId == 2L) {
        return "RemainingTime";
      }
      if (attributeId == 3L) {
        return "CurrentX";
      }
      if (attributeId == 4L) {
        return "CurrentY";
      }
      if (attributeId == 5L) {
        return "DriftCompensation";
      }
      if (attributeId == 6L) {
        return "CompensationText";
      }
      if (attributeId == 7L) {
        return "ColorTemperatureMireds";
      }
      if (attributeId == 8L) {
        return "ColorMode";
      }
      if (attributeId == 15L) {
        return "Options";
      }
      if (attributeId == 16L) {
        return "NumberOfPrimaries";
      }
      if (attributeId == 17L) {
        return "Primary1X";
      }
      if (attributeId == 18L) {
        return "Primary1Y";
      }
      if (attributeId == 19L) {
        return "Primary1Intensity";
      }
      if (attributeId == 21L) {
        return "Primary2X";
      }
      if (attributeId == 22L) {
        return "Primary2Y";
      }
      if (attributeId == 23L) {
        return "Primary2Intensity";
      }
      if (attributeId == 25L) {
        return "Primary3X";
      }
      if (attributeId == 26L) {
        return "Primary3Y";
      }
      if (attributeId == 27L) {
        return "Primary3Intensity";
      }
      if (attributeId == 32L) {
        return "Primary4X";
      }
      if (attributeId == 33L) {
        return "Primary4Y";
      }
      if (attributeId == 34L) {
        return "Primary4Intensity";
      }
      if (attributeId == 36L) {
        return "Primary5X";
      }
      if (attributeId == 37L) {
        return "Primary5Y";
      }
      if (attributeId == 38L) {
        return "Primary5Intensity";
      }
      if (attributeId == 40L) {
        return "Primary6X";
      }
      if (attributeId == 41L) {
        return "Primary6Y";
      }
      if (attributeId == 42L) {
        return "Primary6Intensity";
      }
      if (attributeId == 48L) {
        return "WhitePointX";
      }
      if (attributeId == 49L) {
        return "WhitePointY";
      }
      if (attributeId == 50L) {
        return "ColorPointRX";
      }
      if (attributeId == 51L) {
        return "ColorPointRY";
      }
      if (attributeId == 52L) {
        return "ColorPointRIntensity";
      }
      if (attributeId == 54L) {
        return "ColorPointGX";
      }
      if (attributeId == 55L) {
        return "ColorPointGY";
      }
      if (attributeId == 56L) {
        return "ColorPointGIntensity";
      }
      if (attributeId == 58L) {
        return "ColorPointBX";
      }
      if (attributeId == 59L) {
        return "ColorPointBY";
      }
      if (attributeId == 60L) {
        return "ColorPointBIntensity";
      }
      if (attributeId == 16384L) {
        return "EnhancedCurrentHue";
      }
      if (attributeId == 16385L) {
        return "EnhancedColorMode";
      }
      if (attributeId == 16386L) {
        return "ColorLoopActive";
      }
      if (attributeId == 16387L) {
        return "ColorLoopDirection";
      }
      if (attributeId == 16388L) {
        return "ColorLoopTime";
      }
      if (attributeId == 16389L) {
        return "ColorLoopStartEnhancedHue";
      }
      if (attributeId == 16390L) {
        return "ColorLoopStoredEnhancedHue";
      }
      if (attributeId == 16394L) {
        return "ColorCapabilities";
      }
      if (attributeId == 16395L) {
        return "ColorTempPhysicalMinMireds";
      }
      if (attributeId == 16396L) {
        return "ColorTempPhysicalMaxMireds";
      }
      if (attributeId == 16397L) {
        return "CoupleColorTempToLevelMinMireds";
      }
      if (attributeId == 16400L) {
        return "StartUpColorTemperatureMireds";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 769L) {
      if (attributeId == 0L) {
        return "PhysicalMinLevel";
      }
      if (attributeId == 1L) {
        return "PhysicalMaxLevel";
      }
      if (attributeId == 2L) {
        return "BallastStatus";
      }
      if (attributeId == 16L) {
        return "MinLevel";
      }
      if (attributeId == 17L) {
        return "MaxLevel";
      }
      if (attributeId == 20L) {
        return "IntrinsicBallastFactor";
      }
      if (attributeId == 21L) {
        return "BallastFactorAdjustment";
      }
      if (attributeId == 32L) {
        return "LampQuantity";
      }
      if (attributeId == 48L) {
        return "LampType";
      }
      if (attributeId == 49L) {
        return "LampManufacturer";
      }
      if (attributeId == 50L) {
        return "LampRatedHours";
      }
      if (attributeId == 51L) {
        return "LampBurnHours";
      }
      if (attributeId == 52L) {
        return "LampAlarmMode";
      }
      if (attributeId == 53L) {
        return "LampBurnHoursTripPoint";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1024L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "Tolerance";
      }
      if (attributeId == 4L) {
        return "LightSensorType";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1026L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "Tolerance";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1027L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "Tolerance";
      }
      if (attributeId == 16L) {
        return "ScaledValue";
      }
      if (attributeId == 17L) {
        return "MinScaledValue";
      }
      if (attributeId == 18L) {
        return "MaxScaledValue";
      }
      if (attributeId == 19L) {
        return "ScaledTolerance";
      }
      if (attributeId == 20L) {
        return "Scale";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1028L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "Tolerance";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1029L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "Tolerance";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1030L) {
      if (attributeId == 0L) {
        return "Occupancy";
      }
      if (attributeId == 1L) {
        return "OccupancySensorType";
      }
      if (attributeId == 2L) {
        return "OccupancySensorTypeBitmap";
      }
      if (attributeId == 16L) {
        return "PIROccupiedToUnoccupiedDelay";
      }
      if (attributeId == 17L) {
        return "PIRUnoccupiedToOccupiedDelay";
      }
      if (attributeId == 18L) {
        return "PIRUnoccupiedToOccupiedThreshold";
      }
      if (attributeId == 32L) {
        return "UltrasonicOccupiedToUnoccupiedDelay";
      }
      if (attributeId == 33L) {
        return "UltrasonicUnoccupiedToOccupiedDelay";
      }
      if (attributeId == 34L) {
        return "UltrasonicUnoccupiedToOccupiedThreshold";
      }
      if (attributeId == 48L) {
        return "PhysicalContactOccupiedToUnoccupiedDelay";
      }
      if (attributeId == 49L) {
        return "PhysicalContactUnoccupiedToOccupiedDelay";
      }
      if (attributeId == 50L) {
        return "PhysicalContactUnoccupiedToOccupiedThreshold";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1036L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1037L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1038L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1039L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1040L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1041L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1042L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1043L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1044L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1045L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1046L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1047L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1048L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1049L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1050L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1051L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1052L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1053L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1054L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1055L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1056L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1057L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1058L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1059L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1060L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1061L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1062L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1063L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1064L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1065L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1066L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1067L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1068L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1069L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1070L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1071L) {
      if (attributeId == 0L) {
        return "MeasuredValue";
      }
      if (attributeId == 1L) {
        return "MinMeasuredValue";
      }
      if (attributeId == 2L) {
        return "MaxMeasuredValue";
      }
      if (attributeId == 3L) {
        return "PeakMeasuredValue";
      }
      if (attributeId == 4L) {
        return "PeakMeasuredValueWindow";
      }
      if (attributeId == 5L) {
        return "AverageMeasuredValue";
      }
      if (attributeId == 6L) {
        return "AverageMeasuredValueWindow";
      }
      if (attributeId == 7L) {
        return "Uncertainty";
      }
      if (attributeId == 8L) {
        return "MeasurementUnit";
      }
      if (attributeId == 9L) {
        return "MeasurementMedium";
      }
      if (attributeId == 10L) {
        return "LevelValue";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1283L) {
      if (attributeId == 0L) {
        return "MACAddress";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1284L) {
      if (attributeId == 0L) {
        return "ChannelList";
      }
      if (attributeId == 1L) {
        return "Lineup";
      }
      if (attributeId == 2L) {
        return "CurrentChannel";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1285L) {
      if (attributeId == 0L) {
        return "TargetList";
      }
      if (attributeId == 1L) {
        return "CurrentTarget";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1286L) {
      if (attributeId == 0L) {
        return "CurrentState";
      }
      if (attributeId == 1L) {
        return "StartTime";
      }
      if (attributeId == 2L) {
        return "Duration";
      }
      if (attributeId == 3L) {
        return "SampledPosition";
      }
      if (attributeId == 4L) {
        return "PlaybackSpeed";
      }
      if (attributeId == 5L) {
        return "SeekRangeEnd";
      }
      if (attributeId == 6L) {
        return "SeekRangeStart";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1287L) {
      if (attributeId == 0L) {
        return "InputList";
      }
      if (attributeId == 1L) {
        return "CurrentInput";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1288L) {
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1289L) {
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1290L) {
      if (attributeId == 0L) {
        return "AcceptHeader";
      }
      if (attributeId == 1L) {
        return "SupportedStreamingProtocols";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1291L) {
      if (attributeId == 0L) {
        return "OutputList";
      }
      if (attributeId == 1L) {
        return "CurrentOutput";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1292L) {
      if (attributeId == 0L) {
        return "CatalogList";
      }
      if (attributeId == 1L) {
        return "CurrentApp";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1293L) {
      if (attributeId == 0L) {
        return "VendorName";
      }
      if (attributeId == 1L) {
        return "VendorID";
      }
      if (attributeId == 2L) {
        return "ApplicationName";
      }
      if (attributeId == 3L) {
        return "ProductID";
      }
      if (attributeId == 4L) {
        return "Application";
      }
      if (attributeId == 5L) {
        return "Status";
      }
      if (attributeId == 6L) {
        return "ApplicationVersion";
      }
      if (attributeId == 7L) {
        return "AllowedVendorList";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 1294L) {
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 2820L) {
      if (attributeId == 0L) {
        return "MeasurementType";
      }
      if (attributeId == 256L) {
        return "DcVoltage";
      }
      if (attributeId == 257L) {
        return "DcVoltageMin";
      }
      if (attributeId == 258L) {
        return "DcVoltageMax";
      }
      if (attributeId == 259L) {
        return "DcCurrent";
      }
      if (attributeId == 260L) {
        return "DcCurrentMin";
      }
      if (attributeId == 261L) {
        return "DcCurrentMax";
      }
      if (attributeId == 262L) {
        return "DcPower";
      }
      if (attributeId == 263L) {
        return "DcPowerMin";
      }
      if (attributeId == 264L) {
        return "DcPowerMax";
      }
      if (attributeId == 512L) {
        return "DcVoltageMultiplier";
      }
      if (attributeId == 513L) {
        return "DcVoltageDivisor";
      }
      if (attributeId == 514L) {
        return "DcCurrentMultiplier";
      }
      if (attributeId == 515L) {
        return "DcCurrentDivisor";
      }
      if (attributeId == 516L) {
        return "DcPowerMultiplier";
      }
      if (attributeId == 517L) {
        return "DcPowerDivisor";
      }
      if (attributeId == 768L) {
        return "AcFrequency";
      }
      if (attributeId == 769L) {
        return "AcFrequencyMin";
      }
      if (attributeId == 770L) {
        return "AcFrequencyMax";
      }
      if (attributeId == 771L) {
        return "NeutralCurrent";
      }
      if (attributeId == 772L) {
        return "TotalActivePower";
      }
      if (attributeId == 773L) {
        return "TotalReactivePower";
      }
      if (attributeId == 774L) {
        return "TotalApparentPower";
      }
      if (attributeId == 775L) {
        return "Measured1stHarmonicCurrent";
      }
      if (attributeId == 776L) {
        return "Measured3rdHarmonicCurrent";
      }
      if (attributeId == 777L) {
        return "Measured5thHarmonicCurrent";
      }
      if (attributeId == 778L) {
        return "Measured7thHarmonicCurrent";
      }
      if (attributeId == 779L) {
        return "Measured9thHarmonicCurrent";
      }
      if (attributeId == 780L) {
        return "Measured11thHarmonicCurrent";
      }
      if (attributeId == 781L) {
        return "MeasuredPhase1stHarmonicCurrent";
      }
      if (attributeId == 782L) {
        return "MeasuredPhase3rdHarmonicCurrent";
      }
      if (attributeId == 783L) {
        return "MeasuredPhase5thHarmonicCurrent";
      }
      if (attributeId == 784L) {
        return "MeasuredPhase7thHarmonicCurrent";
      }
      if (attributeId == 785L) {
        return "MeasuredPhase9thHarmonicCurrent";
      }
      if (attributeId == 786L) {
        return "MeasuredPhase11thHarmonicCurrent";
      }
      if (attributeId == 1024L) {
        return "AcFrequencyMultiplier";
      }
      if (attributeId == 1025L) {
        return "AcFrequencyDivisor";
      }
      if (attributeId == 1026L) {
        return "PowerMultiplier";
      }
      if (attributeId == 1027L) {
        return "PowerDivisor";
      }
      if (attributeId == 1028L) {
        return "HarmonicCurrentMultiplier";
      }
      if (attributeId == 1029L) {
        return "PhaseHarmonicCurrentMultiplier";
      }
      if (attributeId == 1280L) {
        return "InstantaneousVoltage";
      }
      if (attributeId == 1281L) {
        return "InstantaneousLineCurrent";
      }
      if (attributeId == 1282L) {
        return "InstantaneousActiveCurrent";
      }
      if (attributeId == 1283L) {
        return "InstantaneousReactiveCurrent";
      }
      if (attributeId == 1284L) {
        return "InstantaneousPower";
      }
      if (attributeId == 1285L) {
        return "RmsVoltage";
      }
      if (attributeId == 1286L) {
        return "RmsVoltageMin";
      }
      if (attributeId == 1287L) {
        return "RmsVoltageMax";
      }
      if (attributeId == 1288L) {
        return "RmsCurrent";
      }
      if (attributeId == 1289L) {
        return "RmsCurrentMin";
      }
      if (attributeId == 1290L) {
        return "RmsCurrentMax";
      }
      if (attributeId == 1291L) {
        return "ActivePower";
      }
      if (attributeId == 1292L) {
        return "ActivePowerMin";
      }
      if (attributeId == 1293L) {
        return "ActivePowerMax";
      }
      if (attributeId == 1294L) {
        return "ReactivePower";
      }
      if (attributeId == 1295L) {
        return "ApparentPower";
      }
      if (attributeId == 1296L) {
        return "PowerFactor";
      }
      if (attributeId == 1297L) {
        return "AverageRmsVoltageMeasurementPeriod";
      }
      if (attributeId == 1299L) {
        return "AverageRmsUnderVoltageCounter";
      }
      if (attributeId == 1300L) {
        return "RmsExtremeOverVoltagePeriod";
      }
      if (attributeId == 1301L) {
        return "RmsExtremeUnderVoltagePeriod";
      }
      if (attributeId == 1302L) {
        return "RmsVoltageSagPeriod";
      }
      if (attributeId == 1303L) {
        return "RmsVoltageSwellPeriod";
      }
      if (attributeId == 1536L) {
        return "AcVoltageMultiplier";
      }
      if (attributeId == 1537L) {
        return "AcVoltageDivisor";
      }
      if (attributeId == 1538L) {
        return "AcCurrentMultiplier";
      }
      if (attributeId == 1539L) {
        return "AcCurrentDivisor";
      }
      if (attributeId == 1540L) {
        return "AcPowerMultiplier";
      }
      if (attributeId == 1541L) {
        return "AcPowerDivisor";
      }
      if (attributeId == 1792L) {
        return "OverloadAlarmsMask";
      }
      if (attributeId == 1793L) {
        return "VoltageOverload";
      }
      if (attributeId == 1794L) {
        return "CurrentOverload";
      }
      if (attributeId == 2048L) {
        return "AcOverloadAlarmsMask";
      }
      if (attributeId == 2049L) {
        return "AcVoltageOverload";
      }
      if (attributeId == 2050L) {
        return "AcCurrentOverload";
      }
      if (attributeId == 2051L) {
        return "AcActivePowerOverload";
      }
      if (attributeId == 2052L) {
        return "AcReactivePowerOverload";
      }
      if (attributeId == 2053L) {
        return "AverageRmsOverVoltage";
      }
      if (attributeId == 2054L) {
        return "AverageRmsUnderVoltage";
      }
      if (attributeId == 2055L) {
        return "RmsExtremeOverVoltage";
      }
      if (attributeId == 2056L) {
        return "RmsExtremeUnderVoltage";
      }
      if (attributeId == 2057L) {
        return "RmsVoltageSag";
      }
      if (attributeId == 2058L) {
        return "RmsVoltageSwell";
      }
      if (attributeId == 2305L) {
        return "LineCurrentPhaseB";
      }
      if (attributeId == 2306L) {
        return "ActiveCurrentPhaseB";
      }
      if (attributeId == 2307L) {
        return "ReactiveCurrentPhaseB";
      }
      if (attributeId == 2309L) {
        return "RmsVoltagePhaseB";
      }
      if (attributeId == 2310L) {
        return "RmsVoltageMinPhaseB";
      }
      if (attributeId == 2311L) {
        return "RmsVoltageMaxPhaseB";
      }
      if (attributeId == 2312L) {
        return "RmsCurrentPhaseB";
      }
      if (attributeId == 2313L) {
        return "RmsCurrentMinPhaseB";
      }
      if (attributeId == 2314L) {
        return "RmsCurrentMaxPhaseB";
      }
      if (attributeId == 2315L) {
        return "ActivePowerPhaseB";
      }
      if (attributeId == 2316L) {
        return "ActivePowerMinPhaseB";
      }
      if (attributeId == 2317L) {
        return "ActivePowerMaxPhaseB";
      }
      if (attributeId == 2318L) {
        return "ReactivePowerPhaseB";
      }
      if (attributeId == 2319L) {
        return "ApparentPowerPhaseB";
      }
      if (attributeId == 2320L) {
        return "PowerFactorPhaseB";
      }
      if (attributeId == 2321L) {
        return "AverageRmsVoltageMeasurementPeriodPhaseB";
      }
      if (attributeId == 2322L) {
        return "AverageRmsOverVoltageCounterPhaseB";
      }
      if (attributeId == 2323L) {
        return "AverageRmsUnderVoltageCounterPhaseB";
      }
      if (attributeId == 2324L) {
        return "RmsExtremeOverVoltagePeriodPhaseB";
      }
      if (attributeId == 2325L) {
        return "RmsExtremeUnderVoltagePeriodPhaseB";
      }
      if (attributeId == 2326L) {
        return "RmsVoltageSagPeriodPhaseB";
      }
      if (attributeId == 2327L) {
        return "RmsVoltageSwellPeriodPhaseB";
      }
      if (attributeId == 2561L) {
        return "LineCurrentPhaseC";
      }
      if (attributeId == 2562L) {
        return "ActiveCurrentPhaseC";
      }
      if (attributeId == 2563L) {
        return "ReactiveCurrentPhaseC";
      }
      if (attributeId == 2565L) {
        return "RmsVoltagePhaseC";
      }
      if (attributeId == 2566L) {
        return "RmsVoltageMinPhaseC";
      }
      if (attributeId == 2567L) {
        return "RmsVoltageMaxPhaseC";
      }
      if (attributeId == 2568L) {
        return "RmsCurrentPhaseC";
      }
      if (attributeId == 2569L) {
        return "RmsCurrentMinPhaseC";
      }
      if (attributeId == 2570L) {
        return "RmsCurrentMaxPhaseC";
      }
      if (attributeId == 2571L) {
        return "ActivePowerPhaseC";
      }
      if (attributeId == 2572L) {
        return "ActivePowerMinPhaseC";
      }
      if (attributeId == 2573L) {
        return "ActivePowerMaxPhaseC";
      }
      if (attributeId == 2574L) {
        return "ReactivePowerPhaseC";
      }
      if (attributeId == 2575L) {
        return "ApparentPowerPhaseC";
      }
      if (attributeId == 2576L) {
        return "PowerFactorPhaseC";
      }
      if (attributeId == 2577L) {
        return "AverageRmsVoltageMeasurementPeriodPhaseC";
      }
      if (attributeId == 2578L) {
        return "AverageRmsOverVoltageCounterPhaseC";
      }
      if (attributeId == 2579L) {
        return "AverageRmsUnderVoltageCounterPhaseC";
      }
      if (attributeId == 2580L) {
        return "RmsExtremeOverVoltagePeriodPhaseC";
      }
      if (attributeId == 2581L) {
        return "RmsExtremeUnderVoltagePeriodPhaseC";
      }
      if (attributeId == 2582L) {
        return "RmsVoltageSagPeriodPhaseC";
      }
      if (attributeId == 2583L) {
        return "RmsVoltageSwellPeriodPhaseC";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 4294048773L) {
      if (attributeId == 0L) {
        return "Boolean";
      }
      if (attributeId == 1L) {
        return "Bitmap8";
      }
      if (attributeId == 2L) {
        return "Bitmap16";
      }
      if (attributeId == 3L) {
        return "Bitmap32";
      }
      if (attributeId == 4L) {
        return "Bitmap64";
      }
      if (attributeId == 5L) {
        return "Int8u";
      }
      if (attributeId == 6L) {
        return "Int16u";
      }
      if (attributeId == 7L) {
        return "Int24u";
      }
      if (attributeId == 8L) {
        return "Int32u";
      }
      if (attributeId == 9L) {
        return "Int40u";
      }
      if (attributeId == 10L) {
        return "Int48u";
      }
      if (attributeId == 11L) {
        return "Int56u";
      }
      if (attributeId == 12L) {
        return "Int64u";
      }
      if (attributeId == 13L) {
        return "Int8s";
      }
      if (attributeId == 14L) {
        return "Int16s";
      }
      if (attributeId == 15L) {
        return "Int24s";
      }
      if (attributeId == 16L) {
        return "Int32s";
      }
      if (attributeId == 17L) {
        return "Int40s";
      }
      if (attributeId == 18L) {
        return "Int48s";
      }
      if (attributeId == 19L) {
        return "Int56s";
      }
      if (attributeId == 20L) {
        return "Int64s";
      }
      if (attributeId == 21L) {
        return "Enum8";
      }
      if (attributeId == 22L) {
        return "Enum16";
      }
      if (attributeId == 23L) {
        return "FloatSingle";
      }
      if (attributeId == 24L) {
        return "FloatDouble";
      }
      if (attributeId == 25L) {
        return "OctetString";
      }
      if (attributeId == 26L) {
        return "ListInt8u";
      }
      if (attributeId == 27L) {
        return "ListOctetString";
      }
      if (attributeId == 28L) {
        return "ListStructOctetString";
      }
      if (attributeId == 29L) {
        return "LongOctetString";
      }
      if (attributeId == 30L) {
        return "CharString";
      }
      if (attributeId == 31L) {
        return "LongCharString";
      }
      if (attributeId == 32L) {
        return "EpochUs";
      }
      if (attributeId == 33L) {
        return "EpochS";
      }
      if (attributeId == 34L) {
        return "VendorId";
      }
      if (attributeId == 35L) {
        return "ListNullablesAndOptionalsStruct";
      }
      if (attributeId == 36L) {
        return "EnumAttr";
      }
      if (attributeId == 37L) {
        return "StructAttr";
      }
      if (attributeId == 38L) {
        return "RangeRestrictedInt8u";
      }
      if (attributeId == 39L) {
        return "RangeRestrictedInt8s";
      }
      if (attributeId == 40L) {
        return "RangeRestrictedInt16u";
      }
      if (attributeId == 41L) {
        return "RangeRestrictedInt16s";
      }
      if (attributeId == 42L) {
        return "ListLongOctetString";
      }
      if (attributeId == 43L) {
        return "ListFabricScoped";
      }
      if (attributeId == 48L) {
        return "TimedWriteBoolean";
      }
      if (attributeId == 49L) {
        return "GeneralErrorBoolean";
      }
      if (attributeId == 50L) {
        return "ClusterErrorBoolean";
      }
      if (attributeId == 255L) {
        return "Unsupported";
      }
      if (attributeId == 16384L) {
        return "NullableBoolean";
      }
      if (attributeId == 16385L) {
        return "NullableBitmap8";
      }
      if (attributeId == 16386L) {
        return "NullableBitmap16";
      }
      if (attributeId == 16387L) {
        return "NullableBitmap32";
      }
      if (attributeId == 16388L) {
        return "NullableBitmap64";
      }
      if (attributeId == 16389L) {
        return "NullableInt8u";
      }
      if (attributeId == 16390L) {
        return "NullableInt16u";
      }
      if (attributeId == 16391L) {
        return "NullableInt24u";
      }
      if (attributeId == 16392L) {
        return "NullableInt32u";
      }
      if (attributeId == 16393L) {
        return "NullableInt40u";
      }
      if (attributeId == 16394L) {
        return "NullableInt48u";
      }
      if (attributeId == 16395L) {
        return "NullableInt56u";
      }
      if (attributeId == 16396L) {
        return "NullableInt64u";
      }
      if (attributeId == 16397L) {
        return "NullableInt8s";
      }
      if (attributeId == 16398L) {
        return "NullableInt16s";
      }
      if (attributeId == 16399L) {
        return "NullableInt24s";
      }
      if (attributeId == 16400L) {
        return "NullableInt32s";
      }
      if (attributeId == 16401L) {
        return "NullableInt40s";
      }
      if (attributeId == 16402L) {
        return "NullableInt48s";
      }
      if (attributeId == 16403L) {
        return "NullableInt56s";
      }
      if (attributeId == 16404L) {
        return "NullableInt64s";
      }
      if (attributeId == 16405L) {
        return "NullableEnum8";
      }
      if (attributeId == 16406L) {
        return "NullableEnum16";
      }
      if (attributeId == 16407L) {
        return "NullableFloatSingle";
      }
      if (attributeId == 16408L) {
        return "NullableFloatDouble";
      }
      if (attributeId == 16409L) {
        return "NullableOctetString";
      }
      if (attributeId == 16414L) {
        return "NullableCharString";
      }
      if (attributeId == 16420L) {
        return "NullableEnumAttr";
      }
      if (attributeId == 16421L) {
        return "NullableStruct";
      }
      if (attributeId == 16422L) {
        return "NullableRangeRestrictedInt8u";
      }
      if (attributeId == 16423L) {
        return "NullableRangeRestrictedInt8s";
      }
      if (attributeId == 16424L) {
        return "NullableRangeRestrictedInt16u";
      }
      if (attributeId == 16425L) {
        return "NullableRangeRestrictedInt16s";
      }
      if (attributeId == 16426L) {
        return "WriteOnlyInt8u";
      }
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    if (clusterId == 4294048774L) {
      if (attributeId == 65528L) {
        return "GeneratedCommandList";
      }
      if (attributeId == 65529L) {
        return "AcceptedCommandList";
      }
      if (attributeId == 65530L) {
        return "EventList";
      }
      if (attributeId == 65531L) {
        return "AttributeList";
      }
      if (attributeId == 65532L) {
        return "FeatureMap";
      }
      if (attributeId == 65533L) {
        return "ClusterRevision";
      }
      return "";
    }
    return "";
  }

  /**
   * Translates cluster ID and event ID to an attribute name in upper camel case.
   * If no matching IDs are found, returns an empty string.
   */
  public static String eventIdToName(long clusterId, long eventId) {
    if (clusterId == 3L) {
      return "";
    }
    if (clusterId == 4L) {
      return "";
    }
    if (clusterId == 5L) {
      return "";
    }
    if (clusterId == 6L) {
      return "";
    }
    if (clusterId == 7L) {
      return "";
    }
    if (clusterId == 8L) {
      return "";
    }
    if (clusterId == 15L) {
      return "";
    }
    if (clusterId == 28L) {
      return "";
    }
    if (clusterId == 29L) {
      return "";
    }
    if (clusterId == 30L) {
      return "";
    }
    if (clusterId == 31L) {
      if (eventId == 0L) {
        return "AccessControlEntryChanged";
      }
      if (eventId == 1L) {
        return "AccessControlExtensionChanged";
      }
      return "";
    }
    if (clusterId == 37L) {
      if (eventId == 0L) {
        return "StateChanged";
      }
      if (eventId == 1L) {
        return "ActionFailed";
      }
      return "";
    }
    if (clusterId == 40L) {
      if (eventId == 0L) {
        return "StartUp";
      }
      if (eventId == 1L) {
        return "ShutDown";
      }
      if (eventId == 2L) {
        return "Leave";
      }
      if (eventId == 3L) {
        return "ReachableChanged";
      }
      return "";
    }
    if (clusterId == 41L) {
      return "";
    }
    if (clusterId == 42L) {
      if (eventId == 0L) {
        return "StateTransition";
      }
      if (eventId == 1L) {
        return "VersionApplied";
      }
      if (eventId == 2L) {
        return "DownloadError";
      }
      return "";
    }
    if (clusterId == 43L) {
      return "";
    }
    if (clusterId == 44L) {
      return "";
    }
    if (clusterId == 45L) {
      return "";
    }
    if (clusterId == 46L) {
      return "";
    }
    if (clusterId == 47L) {
      if (eventId == 0L) {
        return "WiredFaultChange";
      }
      if (eventId == 1L) {
        return "BatFaultChange";
      }
      if (eventId == 2L) {
        return "BatChargeFaultChange";
      }
      return "";
    }
    if (clusterId == 48L) {
      return "";
    }
    if (clusterId == 49L) {
      return "";
    }
    if (clusterId == 50L) {
      return "";
    }
    if (clusterId == 51L) {
      if (eventId == 0L) {
        return "HardwareFaultChange";
      }
      if (eventId == 1L) {
        return "RadioFaultChange";
      }
      if (eventId == 2L) {
        return "NetworkFaultChange";
      }
      if (eventId == 3L) {
        return "BootReason";
      }
      return "";
    }
    if (clusterId == 52L) {
      if (eventId == 0L) {
        return "SoftwareFault";
      }
      return "";
    }
    if (clusterId == 53L) {
      if (eventId == 0L) {
        return "ConnectionStatus";
      }
      if (eventId == 1L) {
        return "NetworkFaultChange";
      }
      return "";
    }
    if (clusterId == 54L) {
      if (eventId == 0L) {
        return "Disconnection";
      }
      if (eventId == 1L) {
        return "AssociationFailure";
      }
      if (eventId == 2L) {
        return "ConnectionStatus";
      }
      return "";
    }
    if (clusterId == 55L) {
      return "";
    }
    if (clusterId == 56L) {
      if (eventId == 0L) {
        return "DSTTableEmpty";
      }
      if (eventId == 1L) {
        return "DSTStatus";
      }
      if (eventId == 2L) {
        return "TimeZoneStatus";
      }
      if (eventId == 3L) {
        return "TimeFailure";
      }
      if (eventId == 4L) {
        return "MissingTrustedTimeSource";
      }
      return "";
    }
    if (clusterId == 57L) {
      if (eventId == 0L) {
        return "StartUp";
      }
      if (eventId == 1L) {
        return "ShutDown";
      }
      if (eventId == 2L) {
        return "Leave";
      }
      if (eventId == 3L) {
        return "ReachableChanged";
      }
      return "";
    }
    if (clusterId == 59L) {
      if (eventId == 0L) {
        return "SwitchLatched";
      }
      if (eventId == 1L) {
        return "InitialPress";
      }
      if (eventId == 2L) {
        return "LongPress";
      }
      if (eventId == 3L) {
        return "ShortRelease";
      }
      if (eventId == 4L) {
        return "LongRelease";
      }
      if (eventId == 5L) {
        return "MultiPressOngoing";
      }
      if (eventId == 6L) {
        return "MultiPressComplete";
      }
      return "";
    }
    if (clusterId == 60L) {
      return "";
    }
    if (clusterId == 62L) {
      return "";
    }
    if (clusterId == 63L) {
      return "";
    }
    if (clusterId == 64L) {
      return "";
    }
    if (clusterId == 65L) {
      return "";
    }
    if (clusterId == 66L) {
      return "";
    }
    if (clusterId == 67L) {
      return "";
    }
    if (clusterId == 68L) {
      return "";
    }
    if (clusterId == 69L) {
      if (eventId == 0L) {
        return "StateChange";
      }
      return "";
    }
    if (clusterId == 70L) {
      return "";
    }
    if (clusterId == 80L) {
      return "";
    }
    if (clusterId == 86L) {
      return "";
    }
    if (clusterId == 87L) {
      if (eventId == 0L) {
        return "Notify";
      }
      return "";
    }
    if (clusterId == 91L) {
      return "";
    }
    if (clusterId == 92L) {
      if (eventId == 0L) {
        return "SmokeAlarm";
      }
      if (eventId == 1L) {
        return "COAlarm";
      }
      if (eventId == 2L) {
        return "LowBattery";
      }
      if (eventId == 3L) {
        return "HardwareFault";
      }
      if (eventId == 4L) {
        return "EndOfService";
      }
      if (eventId == 5L) {
        return "SelfTestComplete";
      }
      if (eventId == 6L) {
        return "AlarmMuted";
      }
      if (eventId == 7L) {
        return "MuteEnded";
      }
      if (eventId == 8L) {
        return "InterconnectSmokeAlarm";
      }
      if (eventId == 9L) {
        return "InterconnectCOAlarm";
      }
      if (eventId == 10L) {
        return "AllClear";
      }
      return "";
    }
    if (clusterId == 96L) {
      if (eventId == 0L) {
        return "OperationalError";
      }
      if (eventId == 1L) {
        return "OperationCompletion";
      }
      return "";
    }
    if (clusterId == 113L) {
      return "";
    }
    if (clusterId == 114L) {
      return "";
    }
    if (clusterId == 115L) {
      return "";
    }
    if (clusterId == 116L) {
      return "";
    }
    if (clusterId == 117L) {
      return "";
    }
    if (clusterId == 118L) {
      return "";
    }
    if (clusterId == 119L) {
      return "";
    }
    if (clusterId == 120L) {
      return "";
    }
    if (clusterId == 121L) {
      return "";
    }
    if (clusterId == 122L) {
      return "";
    }
    if (clusterId == 123L) {
      return "";
    }
    if (clusterId == 124L) {
      return "";
    }
    if (clusterId == 257L) {
      if (eventId == 0L) {
        return "DoorLockAlarm";
      }
      if (eventId == 1L) {
        return "DoorStateChange";
      }
      if (eventId == 2L) {
        return "LockOperation";
      }
      if (eventId == 3L) {
        return "LockOperationError";
      }
      if (eventId == 4L) {
        return "LockUserChange";
      }
      return "";
    }
    if (clusterId == 258L) {
      return "";
    }
    if (clusterId == 259L) {
      return "";
    }
    if (clusterId == 512L) {
      if (eventId == 0L) {
        return "SupplyVoltageLow";
      }
      if (eventId == 1L) {
        return "SupplyVoltageHigh";
      }
      if (eventId == 2L) {
        return "PowerMissingPhase";
      }
      if (eventId == 3L) {
        return "SystemPressureLow";
      }
      if (eventId == 4L) {
        return "SystemPressureHigh";
      }
      if (eventId == 5L) {
        return "DryRunning";
      }
      if (eventId == 6L) {
        return "MotorTemperatureHigh";
      }
      if (eventId == 7L) {
        return "PumpMotorFatalFailure";
      }
      if (eventId == 8L) {
        return "ElectronicTemperatureHigh";
      }
      if (eventId == 9L) {
        return "PumpBlocked";
      }
      if (eventId == 10L) {
        return "SensorFailure";
      }
      if (eventId == 11L) {
        return "ElectronicNonFatalFailure";
      }
      if (eventId == 12L) {
        return "ElectronicFatalFailure";
      }
      if (eventId == 13L) {
        return "GeneralFault";
      }
      if (eventId == 14L) {
        return "Leakage";
      }
      if (eventId == 15L) {
        return "AirDetection";
      }
      if (eventId == 16L) {
        return "TurbineOperation";
      }
      return "";
    }
    if (clusterId == 513L) {
      return "";
    }
    if (clusterId == 514L) {
      return "";
    }
    if (clusterId == 516L) {
      return "";
    }
    if (clusterId == 768L) {
      return "";
    }
    if (clusterId == 769L) {
      return "";
    }
    if (clusterId == 1024L) {
      return "";
    }
    if (clusterId == 1026L) {
      return "";
    }
    if (clusterId == 1027L) {
      return "";
    }
    if (clusterId == 1028L) {
      return "";
    }
    if (clusterId == 1029L) {
      return "";
    }
    if (clusterId == 1030L) {
      return "";
    }
    if (clusterId == 1036L) {
      return "";
    }
    if (clusterId == 1037L) {
      return "";
    }
    if (clusterId == 1038L) {
      return "";
    }
    if (clusterId == 1039L) {
      return "";
    }
    if (clusterId == 1040L) {
      return "";
    }
    if (clusterId == 1041L) {
      return "";
    }
    if (clusterId == 1042L) {
      return "";
    }
    if (clusterId == 1043L) {
      return "";
    }
    if (clusterId == 1044L) {
      return "";
    }
    if (clusterId == 1045L) {
      return "";
    }
    if (clusterId == 1046L) {
      return "";
    }
    if (clusterId == 1047L) {
      return "";
    }
    if (clusterId == 1048L) {
      return "";
    }
    if (clusterId == 1049L) {
      return "";
    }
    if (clusterId == 1050L) {
      return "";
    }
    if (clusterId == 1051L) {
      return "";
    }
    if (clusterId == 1052L) {
      return "";
    }
    if (clusterId == 1053L) {
      return "";
    }
    if (clusterId == 1054L) {
      return "";
    }
    if (clusterId == 1055L) {
      return "";
    }
    if (clusterId == 1056L) {
      return "";
    }
    if (clusterId == 1057L) {
      return "";
    }
    if (clusterId == 1058L) {
      return "";
    }
    if (clusterId == 1059L) {
      return "";
    }
    if (clusterId == 1060L) {
      return "";
    }
    if (clusterId == 1061L) {
      return "";
    }
    if (clusterId == 1062L) {
      return "";
    }
    if (clusterId == 1063L) {
      return "";
    }
    if (clusterId == 1064L) {
      return "";
    }
    if (clusterId == 1065L) {
      return "";
    }
    if (clusterId == 1066L) {
      return "";
    }
    if (clusterId == 1067L) {
      return "";
    }
    if (clusterId == 1068L) {
      return "";
    }
    if (clusterId == 1069L) {
      return "";
    }
    if (clusterId == 1070L) {
      return "";
    }
    if (clusterId == 1071L) {
      return "";
    }
    if (clusterId == 1283L) {
      return "";
    }
    if (clusterId == 1284L) {
      return "";
    }
    if (clusterId == 1285L) {
      return "";
    }
    if (clusterId == 1286L) {
      return "";
    }
    if (clusterId == 1287L) {
      return "";
    }
    if (clusterId == 1288L) {
      return "";
    }
    if (clusterId == 1289L) {
      return "";
    }
    if (clusterId == 1290L) {
      return "";
    }
    if (clusterId == 1291L) {
      return "";
    }
    if (clusterId == 1292L) {
      return "";
    }
    if (clusterId == 1293L) {
      return "";
    }
    if (clusterId == 1294L) {
      return "";
    }
    if (clusterId == 2820L) {
      return "";
    }
    if (clusterId == 4294048773L) {
      if (eventId == 1L) {
        return "TestEvent";
      }
      if (eventId == 2L) {
        return "TestFabricScopedEvent";
      }
      return "";
    }
    if (clusterId == 4294048774L) {
      return "";
    }
    return "";
  }
}

