/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP
package chip.devicecontroller;

import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import chip.clusterinfo.ClusterInfo;
import chip.clusterinfo.InteractionInfo;
import chip.clusterinfo.CommandParameterInfo;
import chip.clusterinfo.DelegatedClusterCallback;
import chip.clusterinfo.ClusterCommandCallback;
import chip.clusterinfo.CommandResponseInfo;
import chip.devicecontroller.ChipClusters.DefaultClusterCallback;
import chip.devicecontroller.ClusterReadMapping;
import chip.devicecontroller.ClusterWriteMapping;

public class ClusterInfoMapping {

  public static class DelegatedCharStringAttributeCallback implements ChipClusters.CharStringAttributeCallback, DelegatedClusterCallback {
    /** Indicates a successful read for a CHAR_STRING attribute. */
    private ClusterCommandCallback callback;

    @Override
    public void setCallbackDelegate(ClusterCommandCallback callback) {
      this.callback = callback;
    }

    @Override
    public void onSuccess(String value) {
      Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
      CommandResponseInfo setupPINResponseValue = new CommandResponseInfo("value", "String");
      responseValues.put(setupPINResponseValue, value);
      callback.onSuccess(responseValues);
    }

    @Override
    public void onError(Exception error) {
      callback.onFailure(error);
    }
  }

  public static class DelegatedOctetStringAttributeCallback implements ChipClusters.OctetStringAttributeCallback, DelegatedClusterCallback {
    /** Indicates a successful read for an OCTET_STRING attribute. */
    private ClusterCommandCallback callback;

    @Override
    public void setCallbackDelegate(ClusterCommandCallback callback) {
      this.callback = callback;
    }

    @Override
    public void onSuccess(byte[] value) {
      Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
      CommandResponseInfo setupPINResponseValue = new CommandResponseInfo("value", "byte[]");
      responseValues.put(setupPINResponseValue, value);
      callback.onSuccess(responseValues);
    }

    @Override
    public void onError(Exception error) {
      callback.onFailure(error);
    }
  }

  public static class DelegatedIntegerAttributeCallback implements ChipClusters.IntegerAttributeCallback, DelegatedClusterCallback {
    private ClusterCommandCallback callback;

    @Override
    public void setCallbackDelegate(ClusterCommandCallback callback) {
      this.callback = callback;
    }

    @Override
    public void onSuccess(int value) {
      Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
      CommandResponseInfo setupPINResponseValue = new CommandResponseInfo("value", "int");
      responseValues.put(setupPINResponseValue, value);
      callback.onSuccess(responseValues);
    }

    @Override
    public void onError(Exception error) {
      callback.onFailure(error);
    }
  }

  public static class DelegatedLongAttributeCallback implements ChipClusters.LongAttributeCallback, DelegatedClusterCallback {
    private ClusterCommandCallback callback;

    @Override
    public void setCallbackDelegate(ClusterCommandCallback callback) {
      this.callback = callback;
    }

    @Override
    public void onSuccess(long value) {
      Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
      CommandResponseInfo setupPINResponseValue = new CommandResponseInfo("value", "long");
      responseValues.put(setupPINResponseValue, value);
      callback.onSuccess(responseValues);
    }

    @Override
    public void onError(Exception error) {
      callback.onFailure(error);
    }
  }

  public static class DelegatedBooleanAttributeCallback implements ChipClusters.BooleanAttributeCallback, DelegatedClusterCallback {
    private ClusterCommandCallback callback;

    @Override
    public void setCallbackDelegate(ClusterCommandCallback callback) {
      this.callback = callback;
    }

    @Override
    public void onSuccess(boolean value) {
      Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
      CommandResponseInfo setupPINResponseValue = new CommandResponseInfo("value", "boolean");
      responseValues.put(setupPINResponseValue, value);
      callback.onSuccess(responseValues);
    }

    @Override
    public void onError(Exception error) {
      callback.onFailure(error);
    }
  }

  public static class DelegatedFloatAttributeCallback implements ChipClusters.FloatAttributeCallback, DelegatedClusterCallback {
    private ClusterCommandCallback callback;

    @Override
    public void setCallbackDelegate(ClusterCommandCallback callback) {
      this.callback = callback;
    }

    @Override
    public void onSuccess(float value) {
      Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
      CommandResponseInfo setupPINResponseValue = new CommandResponseInfo("value", "float");
      responseValues.put(setupPINResponseValue, value);
      callback.onSuccess(responseValues);
    }

    @Override
    public void onError(Exception error) {
      callback.onFailure(error);
    }
  }

  public static class DelegatedDoubleAttributeCallback implements ChipClusters.DoubleAttributeCallback, DelegatedClusterCallback {
    private ClusterCommandCallback callback;

    @Override
    public void setCallbackDelegate(ClusterCommandCallback callback) {
      this.callback = callback;
    }

    @Override
    public void onSuccess(double value) {
      Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
      CommandResponseInfo setupPINResponseValue = new CommandResponseInfo("value", "double");
      responseValues.put(setupPINResponseValue, value);
      callback.onSuccess(responseValues);
    }

    @Override
    public void onError(Exception error) {
      callback.onFailure(error);
    }
  }

  public static class DelegatedDefaultClusterCallback implements DefaultClusterCallback, DelegatedClusterCallback {
    private ClusterCommandCallback callback;

    @Override
    public void setCallbackDelegate(ClusterCommandCallback callback) {
      this.callback = callback;
    }

    // Parameters and list-adds here should be generated - refer to the template code that creates each callback interface.
    @Override
    public void onSuccess() {
      Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
      callback.onSuccess(responseValues);
    }

    @Override
    public void onError(Exception e) {
      callback.onFailure(e);
    }
  }
      public static class DelegatedIdentifyClusterGeneratedCommandListAttributeCallback implements ChipClusters.IdentifyCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIdentifyClusterAcceptedCommandListAttributeCallback implements ChipClusters.IdentifyCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIdentifyClusterEventListAttributeCallback implements ChipClusters.IdentifyCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIdentifyClusterAttributeListAttributeCallback implements ChipClusters.IdentifyCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedGroupsClusterAddGroupResponseCallback implements ChipClusters.GroupsCluster.AddGroupResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Integer GroupID) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo GroupIDResponseValue = new CommandResponseInfo("GroupID", "Integer");
               responseValues.put(GroupIDResponseValue, GroupID);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedGroupsClusterViewGroupResponseCallback implements ChipClusters.GroupsCluster.ViewGroupResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Integer GroupID, String GroupName) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo GroupIDResponseValue = new CommandResponseInfo("GroupID", "Integer");
               responseValues.put(GroupIDResponseValue, GroupID);
               CommandResponseInfo GroupNameResponseValue = new CommandResponseInfo("GroupName", "String");
               responseValues.put(GroupNameResponseValue, GroupName);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedGroupsClusterGetGroupMembershipResponseCallback implements ChipClusters.GroupsCluster.GetGroupMembershipResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(@Nullable Integer Capacity, ArrayList<Integer> GroupList) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo CapacityResponseValue = new CommandResponseInfo("Capacity", "Integer");
               responseValues.put(CapacityResponseValue, Capacity);
               // GroupList: /* TYPE WARNING: array array defaults to */ uint8_t * 
               // Conversion from this type to Java is not properly implemented yet
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedGroupsClusterRemoveGroupResponseCallback implements ChipClusters.GroupsCluster.RemoveGroupResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Integer GroupID) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo GroupIDResponseValue = new CommandResponseInfo("GroupID", "Integer");
               responseValues.put(GroupIDResponseValue, GroupID);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedGroupsClusterGeneratedCommandListAttributeCallback implements ChipClusters.GroupsCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGroupsClusterAcceptedCommandListAttributeCallback implements ChipClusters.GroupsCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGroupsClusterEventListAttributeCallback implements ChipClusters.GroupsCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGroupsClusterAttributeListAttributeCallback implements ChipClusters.GroupsCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedScenesClusterAddSceneResponseCallback implements ChipClusters.ScenesCluster.AddSceneResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Integer GroupID, Integer SceneID) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo GroupIDResponseValue = new CommandResponseInfo("GroupID", "Integer");
               responseValues.put(GroupIDResponseValue, GroupID);
               CommandResponseInfo SceneIDResponseValue = new CommandResponseInfo("SceneID", "Integer");
               responseValues.put(SceneIDResponseValue, SceneID);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedScenesClusterViewSceneResponseCallback implements ChipClusters.ScenesCluster.ViewSceneResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Integer GroupID, Integer SceneID, Optional<Integer> TransitionTime, Optional<String> SceneName, Optional<ArrayList<ChipStructs.ScenesClusterExtensionFieldSet>> ExtensionFieldSets) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo GroupIDResponseValue = new CommandResponseInfo("GroupID", "Integer");
               responseValues.put(GroupIDResponseValue, GroupID);
               CommandResponseInfo SceneIDResponseValue = new CommandResponseInfo("SceneID", "Integer");
               responseValues.put(SceneIDResponseValue, SceneID);
               CommandResponseInfo TransitionTimeResponseValue = new CommandResponseInfo("TransitionTime", "Optional<Integer>");
               responseValues.put(TransitionTimeResponseValue, TransitionTime);
               CommandResponseInfo SceneNameResponseValue = new CommandResponseInfo("SceneName", "Optional<String>");
               responseValues.put(SceneNameResponseValue, SceneName);
               // ExtensionFieldSets: /* TYPE WARNING: array array defaults to */ uint8_t * 
               // Conversion from this type to Java is not properly implemented yet
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedScenesClusterRemoveSceneResponseCallback implements ChipClusters.ScenesCluster.RemoveSceneResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Integer GroupID, Integer SceneID) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo GroupIDResponseValue = new CommandResponseInfo("GroupID", "Integer");
               responseValues.put(GroupIDResponseValue, GroupID);
               CommandResponseInfo SceneIDResponseValue = new CommandResponseInfo("SceneID", "Integer");
               responseValues.put(SceneIDResponseValue, SceneID);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedScenesClusterRemoveAllScenesResponseCallback implements ChipClusters.ScenesCluster.RemoveAllScenesResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Integer GroupID) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo GroupIDResponseValue = new CommandResponseInfo("GroupID", "Integer");
               responseValues.put(GroupIDResponseValue, GroupID);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedScenesClusterStoreSceneResponseCallback implements ChipClusters.ScenesCluster.StoreSceneResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Integer GroupID, Integer SceneID) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo GroupIDResponseValue = new CommandResponseInfo("GroupID", "Integer");
               responseValues.put(GroupIDResponseValue, GroupID);
               CommandResponseInfo SceneIDResponseValue = new CommandResponseInfo("SceneID", "Integer");
               responseValues.put(SceneIDResponseValue, SceneID);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedScenesClusterGetSceneMembershipResponseCallback implements ChipClusters.ScenesCluster.GetSceneMembershipResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, @Nullable Integer Capacity, Integer GroupID, Optional<ArrayList<Integer>> SceneList) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo CapacityResponseValue = new CommandResponseInfo("Capacity", "Integer");
               responseValues.put(CapacityResponseValue, Capacity);
               CommandResponseInfo GroupIDResponseValue = new CommandResponseInfo("GroupID", "Integer");
               responseValues.put(GroupIDResponseValue, GroupID);
               // SceneList: /* TYPE WARNING: array array defaults to */ uint8_t * 
               // Conversion from this type to Java is not properly implemented yet
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedScenesClusterLastConfiguredByAttributeCallback implements ChipClusters.ScenesCluster.LastConfiguredByAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedScenesClusterGeneratedCommandListAttributeCallback implements ChipClusters.ScenesCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedScenesClusterAcceptedCommandListAttributeCallback implements ChipClusters.ScenesCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedScenesClusterEventListAttributeCallback implements ChipClusters.ScenesCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedScenesClusterAttributeListAttributeCallback implements ChipClusters.ScenesCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedOnOffClusterStartUpOnOffAttributeCallback implements ChipClusters.OnOffCluster.StartUpOnOffAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOnOffClusterGeneratedCommandListAttributeCallback implements ChipClusters.OnOffCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOnOffClusterAcceptedCommandListAttributeCallback implements ChipClusters.OnOffCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOnOffClusterEventListAttributeCallback implements ChipClusters.OnOffCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOnOffClusterAttributeListAttributeCallback implements ChipClusters.OnOffCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedOnOffSwitchConfigurationClusterGeneratedCommandListAttributeCallback implements ChipClusters.OnOffSwitchConfigurationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOnOffSwitchConfigurationClusterAcceptedCommandListAttributeCallback implements ChipClusters.OnOffSwitchConfigurationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOnOffSwitchConfigurationClusterEventListAttributeCallback implements ChipClusters.OnOffSwitchConfigurationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOnOffSwitchConfigurationClusterAttributeListAttributeCallback implements ChipClusters.OnOffSwitchConfigurationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedLevelControlClusterCurrentLevelAttributeCallback implements ChipClusters.LevelControlCluster.CurrentLevelAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLevelControlClusterOnLevelAttributeCallback implements ChipClusters.LevelControlCluster.OnLevelAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLevelControlClusterOnTransitionTimeAttributeCallback implements ChipClusters.LevelControlCluster.OnTransitionTimeAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLevelControlClusterOffTransitionTimeAttributeCallback implements ChipClusters.LevelControlCluster.OffTransitionTimeAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLevelControlClusterDefaultMoveRateAttributeCallback implements ChipClusters.LevelControlCluster.DefaultMoveRateAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLevelControlClusterStartUpCurrentLevelAttributeCallback implements ChipClusters.LevelControlCluster.StartUpCurrentLevelAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLevelControlClusterGeneratedCommandListAttributeCallback implements ChipClusters.LevelControlCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLevelControlClusterAcceptedCommandListAttributeCallback implements ChipClusters.LevelControlCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLevelControlClusterEventListAttributeCallback implements ChipClusters.LevelControlCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLevelControlClusterAttributeListAttributeCallback implements ChipClusters.LevelControlCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedBinaryInputBasicClusterGeneratedCommandListAttributeCallback implements ChipClusters.BinaryInputBasicCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBinaryInputBasicClusterAcceptedCommandListAttributeCallback implements ChipClusters.BinaryInputBasicCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBinaryInputBasicClusterEventListAttributeCallback implements ChipClusters.BinaryInputBasicCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBinaryInputBasicClusterAttributeListAttributeCallback implements ChipClusters.BinaryInputBasicCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedPulseWidthModulationClusterGeneratedCommandListAttributeCallback implements ChipClusters.PulseWidthModulationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPulseWidthModulationClusterAcceptedCommandListAttributeCallback implements ChipClusters.PulseWidthModulationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPulseWidthModulationClusterEventListAttributeCallback implements ChipClusters.PulseWidthModulationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPulseWidthModulationClusterAttributeListAttributeCallback implements ChipClusters.PulseWidthModulationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedDescriptorClusterDeviceTypeListAttributeCallback implements ChipClusters.DescriptorCluster.DeviceTypeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.DescriptorClusterDeviceTypeStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.DescriptorClusterDeviceTypeStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDescriptorClusterServerListAttributeCallback implements ChipClusters.DescriptorCluster.ServerListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDescriptorClusterClientListAttributeCallback implements ChipClusters.DescriptorCluster.ClientListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDescriptorClusterPartsListAttributeCallback implements ChipClusters.DescriptorCluster.PartsListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDescriptorClusterGeneratedCommandListAttributeCallback implements ChipClusters.DescriptorCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDescriptorClusterAcceptedCommandListAttributeCallback implements ChipClusters.DescriptorCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDescriptorClusterEventListAttributeCallback implements ChipClusters.DescriptorCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDescriptorClusterAttributeListAttributeCallback implements ChipClusters.DescriptorCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedBindingClusterBindingAttributeCallback implements ChipClusters.BindingCluster.BindingAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.BindingClusterTargetStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.BindingClusterTargetStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBindingClusterGeneratedCommandListAttributeCallback implements ChipClusters.BindingCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBindingClusterAcceptedCommandListAttributeCallback implements ChipClusters.BindingCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBindingClusterEventListAttributeCallback implements ChipClusters.BindingCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBindingClusterAttributeListAttributeCallback implements ChipClusters.BindingCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedAccessControlClusterAclAttributeCallback implements ChipClusters.AccessControlCluster.AclAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.AccessControlClusterAccessControlEntryStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.AccessControlClusterAccessControlEntryStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAccessControlClusterExtensionAttributeCallback implements ChipClusters.AccessControlCluster.ExtensionAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.AccessControlClusterAccessControlExtensionStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.AccessControlClusterAccessControlExtensionStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAccessControlClusterGeneratedCommandListAttributeCallback implements ChipClusters.AccessControlCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAccessControlClusterAcceptedCommandListAttributeCallback implements ChipClusters.AccessControlCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAccessControlClusterEventListAttributeCallback implements ChipClusters.AccessControlCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAccessControlClusterAttributeListAttributeCallback implements ChipClusters.AccessControlCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedActionsClusterActionListAttributeCallback implements ChipClusters.ActionsCluster.ActionListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.ActionsClusterActionStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.ActionsClusterActionStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedActionsClusterEndpointListsAttributeCallback implements ChipClusters.ActionsCluster.EndpointListsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.ActionsClusterEndpointListStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.ActionsClusterEndpointListStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedActionsClusterGeneratedCommandListAttributeCallback implements ChipClusters.ActionsCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedActionsClusterAcceptedCommandListAttributeCallback implements ChipClusters.ActionsCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedActionsClusterEventListAttributeCallback implements ChipClusters.ActionsCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedActionsClusterAttributeListAttributeCallback implements ChipClusters.ActionsCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedBasicInformationClusterGeneratedCommandListAttributeCallback implements ChipClusters.BasicInformationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBasicInformationClusterAcceptedCommandListAttributeCallback implements ChipClusters.BasicInformationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBasicInformationClusterEventListAttributeCallback implements ChipClusters.BasicInformationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBasicInformationClusterAttributeListAttributeCallback implements ChipClusters.BasicInformationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedOtaSoftwareUpdateProviderClusterQueryImageResponseCallback implements ChipClusters.OtaSoftwareUpdateProviderCluster.QueryImageResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Optional<Long> DelayedActionTime, Optional<String> ImageURI, Optional<Long> SoftwareVersion, Optional<String> SoftwareVersionString, Optional<byte[]> UpdateToken, Optional<Boolean> UserConsentNeeded, Optional<byte[]> MetadataForRequestor) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo DelayedActionTimeResponseValue = new CommandResponseInfo("DelayedActionTime", "Optional<Long>");
               responseValues.put(DelayedActionTimeResponseValue, DelayedActionTime);
               CommandResponseInfo ImageURIResponseValue = new CommandResponseInfo("ImageURI", "Optional<String>");
               responseValues.put(ImageURIResponseValue, ImageURI);
               CommandResponseInfo SoftwareVersionResponseValue = new CommandResponseInfo("SoftwareVersion", "Optional<Long>");
               responseValues.put(SoftwareVersionResponseValue, SoftwareVersion);
               CommandResponseInfo SoftwareVersionStringResponseValue = new CommandResponseInfo("SoftwareVersionString", "Optional<String>");
               responseValues.put(SoftwareVersionStringResponseValue, SoftwareVersionString);
               CommandResponseInfo UpdateTokenResponseValue = new CommandResponseInfo("UpdateToken", "Optional<byte[]>");
               responseValues.put(UpdateTokenResponseValue, UpdateToken);
               CommandResponseInfo UserConsentNeededResponseValue = new CommandResponseInfo("UserConsentNeeded", "Optional<Boolean>");
               responseValues.put(UserConsentNeededResponseValue, UserConsentNeeded);
               CommandResponseInfo MetadataForRequestorResponseValue = new CommandResponseInfo("MetadataForRequestor", "Optional<byte[]>");
               responseValues.put(MetadataForRequestorResponseValue, MetadataForRequestor);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedOtaSoftwareUpdateProviderClusterApplyUpdateResponseCallback implements ChipClusters.OtaSoftwareUpdateProviderCluster.ApplyUpdateResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Action, Long DelayedActionTime) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo ActionResponseValue = new CommandResponseInfo("Action", "Integer");
               responseValues.put(ActionResponseValue, Action);
               CommandResponseInfo DelayedActionTimeResponseValue = new CommandResponseInfo("DelayedActionTime", "Long");
               responseValues.put(DelayedActionTimeResponseValue, DelayedActionTime);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedOtaSoftwareUpdateProviderClusterGeneratedCommandListAttributeCallback implements ChipClusters.OtaSoftwareUpdateProviderCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOtaSoftwareUpdateProviderClusterAcceptedCommandListAttributeCallback implements ChipClusters.OtaSoftwareUpdateProviderCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOtaSoftwareUpdateProviderClusterEventListAttributeCallback implements ChipClusters.OtaSoftwareUpdateProviderCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOtaSoftwareUpdateProviderClusterAttributeListAttributeCallback implements ChipClusters.OtaSoftwareUpdateProviderCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedOtaSoftwareUpdateRequestorClusterDefaultOTAProvidersAttributeCallback implements ChipClusters.OtaSoftwareUpdateRequestorCluster.DefaultOTAProvidersAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.OtaSoftwareUpdateRequestorClusterProviderLocation> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.OtaSoftwareUpdateRequestorClusterProviderLocation>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOtaSoftwareUpdateRequestorClusterUpdateStateProgressAttributeCallback implements ChipClusters.OtaSoftwareUpdateRequestorCluster.UpdateStateProgressAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOtaSoftwareUpdateRequestorClusterGeneratedCommandListAttributeCallback implements ChipClusters.OtaSoftwareUpdateRequestorCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOtaSoftwareUpdateRequestorClusterAcceptedCommandListAttributeCallback implements ChipClusters.OtaSoftwareUpdateRequestorCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOtaSoftwareUpdateRequestorClusterEventListAttributeCallback implements ChipClusters.OtaSoftwareUpdateRequestorCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOtaSoftwareUpdateRequestorClusterAttributeListAttributeCallback implements ChipClusters.OtaSoftwareUpdateRequestorCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedLocalizationConfigurationClusterSupportedLocalesAttributeCallback implements ChipClusters.LocalizationConfigurationCluster.SupportedLocalesAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<String> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<String>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLocalizationConfigurationClusterGeneratedCommandListAttributeCallback implements ChipClusters.LocalizationConfigurationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLocalizationConfigurationClusterAcceptedCommandListAttributeCallback implements ChipClusters.LocalizationConfigurationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLocalizationConfigurationClusterEventListAttributeCallback implements ChipClusters.LocalizationConfigurationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLocalizationConfigurationClusterAttributeListAttributeCallback implements ChipClusters.LocalizationConfigurationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedTimeFormatLocalizationClusterSupportedCalendarTypesAttributeCallback implements ChipClusters.TimeFormatLocalizationCluster.SupportedCalendarTypesAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeFormatLocalizationClusterGeneratedCommandListAttributeCallback implements ChipClusters.TimeFormatLocalizationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeFormatLocalizationClusterAcceptedCommandListAttributeCallback implements ChipClusters.TimeFormatLocalizationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeFormatLocalizationClusterEventListAttributeCallback implements ChipClusters.TimeFormatLocalizationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeFormatLocalizationClusterAttributeListAttributeCallback implements ChipClusters.TimeFormatLocalizationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedUnitLocalizationClusterGeneratedCommandListAttributeCallback implements ChipClusters.UnitLocalizationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitLocalizationClusterAcceptedCommandListAttributeCallback implements ChipClusters.UnitLocalizationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitLocalizationClusterEventListAttributeCallback implements ChipClusters.UnitLocalizationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitLocalizationClusterAttributeListAttributeCallback implements ChipClusters.UnitLocalizationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedPowerSourceConfigurationClusterSourcesAttributeCallback implements ChipClusters.PowerSourceConfigurationCluster.SourcesAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceConfigurationClusterGeneratedCommandListAttributeCallback implements ChipClusters.PowerSourceConfigurationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceConfigurationClusterAcceptedCommandListAttributeCallback implements ChipClusters.PowerSourceConfigurationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceConfigurationClusterEventListAttributeCallback implements ChipClusters.PowerSourceConfigurationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceConfigurationClusterAttributeListAttributeCallback implements ChipClusters.PowerSourceConfigurationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedPowerSourceClusterWiredAssessedInputVoltageAttributeCallback implements ChipClusters.PowerSourceCluster.WiredAssessedInputVoltageAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterWiredAssessedInputFrequencyAttributeCallback implements ChipClusters.PowerSourceCluster.WiredAssessedInputFrequencyAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterWiredAssessedCurrentAttributeCallback implements ChipClusters.PowerSourceCluster.WiredAssessedCurrentAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterActiveWiredFaultsAttributeCallback implements ChipClusters.PowerSourceCluster.ActiveWiredFaultsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterBatVoltageAttributeCallback implements ChipClusters.PowerSourceCluster.BatVoltageAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterBatPercentRemainingAttributeCallback implements ChipClusters.PowerSourceCluster.BatPercentRemainingAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterBatTimeRemainingAttributeCallback implements ChipClusters.PowerSourceCluster.BatTimeRemainingAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterActiveBatFaultsAttributeCallback implements ChipClusters.PowerSourceCluster.ActiveBatFaultsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterBatTimeToFullChargeAttributeCallback implements ChipClusters.PowerSourceCluster.BatTimeToFullChargeAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterBatChargingCurrentAttributeCallback implements ChipClusters.PowerSourceCluster.BatChargingCurrentAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterActiveBatChargeFaultsAttributeCallback implements ChipClusters.PowerSourceCluster.ActiveBatChargeFaultsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterGeneratedCommandListAttributeCallback implements ChipClusters.PowerSourceCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterAcceptedCommandListAttributeCallback implements ChipClusters.PowerSourceCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterEventListAttributeCallback implements ChipClusters.PowerSourceCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPowerSourceClusterAttributeListAttributeCallback implements ChipClusters.PowerSourceCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedGeneralCommissioningClusterArmFailSafeResponseCallback implements ChipClusters.GeneralCommissioningCluster.ArmFailSafeResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer ErrorCode, String DebugText) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo ErrorCodeResponseValue = new CommandResponseInfo("ErrorCode", "Integer");
               responseValues.put(ErrorCodeResponseValue, ErrorCode);
               CommandResponseInfo DebugTextResponseValue = new CommandResponseInfo("DebugText", "String");
               responseValues.put(DebugTextResponseValue, DebugText);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedGeneralCommissioningClusterSetRegulatoryConfigResponseCallback implements ChipClusters.GeneralCommissioningCluster.SetRegulatoryConfigResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer ErrorCode, String DebugText) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo ErrorCodeResponseValue = new CommandResponseInfo("ErrorCode", "Integer");
               responseValues.put(ErrorCodeResponseValue, ErrorCode);
               CommandResponseInfo DebugTextResponseValue = new CommandResponseInfo("DebugText", "String");
               responseValues.put(DebugTextResponseValue, DebugText);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedGeneralCommissioningClusterCommissioningCompleteResponseCallback implements ChipClusters.GeneralCommissioningCluster.CommissioningCompleteResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer ErrorCode, String DebugText) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo ErrorCodeResponseValue = new CommandResponseInfo("ErrorCode", "Integer");
               responseValues.put(ErrorCodeResponseValue, ErrorCode);
               CommandResponseInfo DebugTextResponseValue = new CommandResponseInfo("DebugText", "String");
               responseValues.put(DebugTextResponseValue, DebugText);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedGeneralCommissioningClusterGeneratedCommandListAttributeCallback implements ChipClusters.GeneralCommissioningCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGeneralCommissioningClusterAcceptedCommandListAttributeCallback implements ChipClusters.GeneralCommissioningCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGeneralCommissioningClusterEventListAttributeCallback implements ChipClusters.GeneralCommissioningCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGeneralCommissioningClusterAttributeListAttributeCallback implements ChipClusters.GeneralCommissioningCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedNetworkCommissioningClusterScanNetworksResponseCallback implements ChipClusters.NetworkCommissioningCluster.ScanNetworksResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer NetworkingStatus, Optional<String> DebugText, Optional<ArrayList<ChipStructs.NetworkCommissioningClusterWiFiInterfaceScanResult>> WiFiScanResults, Optional<ArrayList<ChipStructs.NetworkCommissioningClusterThreadInterfaceScanResult>> ThreadScanResults) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo NetworkingStatusResponseValue = new CommandResponseInfo("NetworkingStatus", "Integer");
               responseValues.put(NetworkingStatusResponseValue, NetworkingStatus);
               CommandResponseInfo DebugTextResponseValue = new CommandResponseInfo("DebugText", "Optional<String>");
               responseValues.put(DebugTextResponseValue, DebugText);
               // WiFiScanResults: /* TYPE WARNING: array array defaults to */ uint8_t * 
               // Conversion from this type to Java is not properly implemented yet
               // ThreadScanResults: /* TYPE WARNING: array array defaults to */ uint8_t * 
               // Conversion from this type to Java is not properly implemented yet
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedNetworkCommissioningClusterNetworkConfigResponseCallback implements ChipClusters.NetworkCommissioningCluster.NetworkConfigResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer NetworkingStatus, Optional<String> DebugText, Optional<Integer> NetworkIndex) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo NetworkingStatusResponseValue = new CommandResponseInfo("NetworkingStatus", "Integer");
               responseValues.put(NetworkingStatusResponseValue, NetworkingStatus);
               CommandResponseInfo DebugTextResponseValue = new CommandResponseInfo("DebugText", "Optional<String>");
               responseValues.put(DebugTextResponseValue, DebugText);
               CommandResponseInfo NetworkIndexResponseValue = new CommandResponseInfo("NetworkIndex", "Optional<Integer>");
               responseValues.put(NetworkIndexResponseValue, NetworkIndex);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedNetworkCommissioningClusterConnectNetworkResponseCallback implements ChipClusters.NetworkCommissioningCluster.ConnectNetworkResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer NetworkingStatus, Optional<String> DebugText, @Nullable Long ErrorValue) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo NetworkingStatusResponseValue = new CommandResponseInfo("NetworkingStatus", "Integer");
               responseValues.put(NetworkingStatusResponseValue, NetworkingStatus);
               CommandResponseInfo DebugTextResponseValue = new CommandResponseInfo("DebugText", "Optional<String>");
               responseValues.put(DebugTextResponseValue, DebugText);
               CommandResponseInfo ErrorValueResponseValue = new CommandResponseInfo("ErrorValue", "Long");
               responseValues.put(ErrorValueResponseValue, ErrorValue);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedNetworkCommissioningClusterNetworksAttributeCallback implements ChipClusters.NetworkCommissioningCluster.NetworksAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.NetworkCommissioningClusterNetworkInfo> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.NetworkCommissioningClusterNetworkInfo>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNetworkCommissioningClusterLastNetworkingStatusAttributeCallback implements ChipClusters.NetworkCommissioningCluster.LastNetworkingStatusAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNetworkCommissioningClusterLastNetworkIDAttributeCallback implements ChipClusters.NetworkCommissioningCluster.LastNetworkIDAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable byte[] value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "byte[]");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNetworkCommissioningClusterLastConnectErrorValueAttributeCallback implements ChipClusters.NetworkCommissioningCluster.LastConnectErrorValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNetworkCommissioningClusterGeneratedCommandListAttributeCallback implements ChipClusters.NetworkCommissioningCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNetworkCommissioningClusterAcceptedCommandListAttributeCallback implements ChipClusters.NetworkCommissioningCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNetworkCommissioningClusterEventListAttributeCallback implements ChipClusters.NetworkCommissioningCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNetworkCommissioningClusterAttributeListAttributeCallback implements ChipClusters.NetworkCommissioningCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedDiagnosticLogsClusterRetrieveLogsResponseCallback implements ChipClusters.DiagnosticLogsCluster.RetrieveLogsResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, byte[] LogContent, Optional<Long> UTCTimeStamp, Optional<Long> TimeSinceBoot) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo LogContentResponseValue = new CommandResponseInfo("LogContent", "byte[]");
               responseValues.put(LogContentResponseValue, LogContent);
               CommandResponseInfo UTCTimeStampResponseValue = new CommandResponseInfo("UTCTimeStamp", "Optional<Long>");
               responseValues.put(UTCTimeStampResponseValue, UTCTimeStamp);
               CommandResponseInfo TimeSinceBootResponseValue = new CommandResponseInfo("TimeSinceBoot", "Optional<Long>");
               responseValues.put(TimeSinceBootResponseValue, TimeSinceBoot);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedDiagnosticLogsClusterGeneratedCommandListAttributeCallback implements ChipClusters.DiagnosticLogsCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDiagnosticLogsClusterAcceptedCommandListAttributeCallback implements ChipClusters.DiagnosticLogsCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDiagnosticLogsClusterEventListAttributeCallback implements ChipClusters.DiagnosticLogsCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDiagnosticLogsClusterAttributeListAttributeCallback implements ChipClusters.DiagnosticLogsCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedGeneralDiagnosticsClusterNetworkInterfacesAttributeCallback implements ChipClusters.GeneralDiagnosticsCluster.NetworkInterfacesAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.GeneralDiagnosticsClusterNetworkInterface> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.GeneralDiagnosticsClusterNetworkInterface>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGeneralDiagnosticsClusterActiveHardwareFaultsAttributeCallback implements ChipClusters.GeneralDiagnosticsCluster.ActiveHardwareFaultsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGeneralDiagnosticsClusterActiveRadioFaultsAttributeCallback implements ChipClusters.GeneralDiagnosticsCluster.ActiveRadioFaultsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGeneralDiagnosticsClusterActiveNetworkFaultsAttributeCallback implements ChipClusters.GeneralDiagnosticsCluster.ActiveNetworkFaultsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGeneralDiagnosticsClusterGeneratedCommandListAttributeCallback implements ChipClusters.GeneralDiagnosticsCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGeneralDiagnosticsClusterAcceptedCommandListAttributeCallback implements ChipClusters.GeneralDiagnosticsCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGeneralDiagnosticsClusterEventListAttributeCallback implements ChipClusters.GeneralDiagnosticsCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGeneralDiagnosticsClusterAttributeListAttributeCallback implements ChipClusters.GeneralDiagnosticsCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedSoftwareDiagnosticsClusterThreadMetricsAttributeCallback implements ChipClusters.SoftwareDiagnosticsCluster.ThreadMetricsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.SoftwareDiagnosticsClusterThreadMetricsStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.SoftwareDiagnosticsClusterThreadMetricsStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSoftwareDiagnosticsClusterGeneratedCommandListAttributeCallback implements ChipClusters.SoftwareDiagnosticsCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSoftwareDiagnosticsClusterAcceptedCommandListAttributeCallback implements ChipClusters.SoftwareDiagnosticsCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSoftwareDiagnosticsClusterEventListAttributeCallback implements ChipClusters.SoftwareDiagnosticsCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSoftwareDiagnosticsClusterAttributeListAttributeCallback implements ChipClusters.SoftwareDiagnosticsCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedThreadNetworkDiagnosticsClusterChannelAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.ChannelAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterRoutingRoleAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.RoutingRoleAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterNetworkNameAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.NetworkNameAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable String value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "String");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterPanIdAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.PanIdAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterExtendedPanIdAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.ExtendedPanIdAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterMeshLocalPrefixAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.MeshLocalPrefixAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable byte[] value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "byte[]");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterNeighborTableAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.NeighborTableAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.ThreadNetworkDiagnosticsClusterNeighborTableStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.ThreadNetworkDiagnosticsClusterNeighborTableStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterRouteTableAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.RouteTableAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.ThreadNetworkDiagnosticsClusterRouteTableStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.ThreadNetworkDiagnosticsClusterRouteTableStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterPartitionIdAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.PartitionIdAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterWeightingAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.WeightingAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterDataVersionAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.DataVersionAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterStableDataVersionAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.StableDataVersionAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterLeaderRouterIdAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.LeaderRouterIdAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterActiveTimestampAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.ActiveTimestampAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterPendingTimestampAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.PendingTimestampAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterDelayAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.DelayAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterChannelPage0MaskAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.ChannelPage0MaskAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable byte[] value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "byte[]");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterActiveNetworkFaultsListAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.ActiveNetworkFaultsListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterGeneratedCommandListAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterAcceptedCommandListAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterEventListAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThreadNetworkDiagnosticsClusterAttributeListAttributeCallback implements ChipClusters.ThreadNetworkDiagnosticsCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedWiFiNetworkDiagnosticsClusterBssidAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.BssidAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable byte[] value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "byte[]");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterSecurityTypeAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.SecurityTypeAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterWiFiVersionAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.WiFiVersionAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterChannelNumberAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.ChannelNumberAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterRssiAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.RssiAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterBeaconLostCountAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.BeaconLostCountAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterBeaconRxCountAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.BeaconRxCountAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterPacketMulticastRxCountAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.PacketMulticastRxCountAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterPacketMulticastTxCountAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.PacketMulticastTxCountAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterPacketUnicastRxCountAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.PacketUnicastRxCountAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterPacketUnicastTxCountAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.PacketUnicastTxCountAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterCurrentMaxRateAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.CurrentMaxRateAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterOverrunCountAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.OverrunCountAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterGeneratedCommandListAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterAcceptedCommandListAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterEventListAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWiFiNetworkDiagnosticsClusterAttributeListAttributeCallback implements ChipClusters.WiFiNetworkDiagnosticsCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedEthernetNetworkDiagnosticsClusterPHYRateAttributeCallback implements ChipClusters.EthernetNetworkDiagnosticsCluster.PHYRateAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthernetNetworkDiagnosticsClusterFullDuplexAttributeCallback implements ChipClusters.EthernetNetworkDiagnosticsCluster.FullDuplexAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Boolean value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Boolean");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthernetNetworkDiagnosticsClusterCarrierDetectAttributeCallback implements ChipClusters.EthernetNetworkDiagnosticsCluster.CarrierDetectAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Boolean value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Boolean");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthernetNetworkDiagnosticsClusterGeneratedCommandListAttributeCallback implements ChipClusters.EthernetNetworkDiagnosticsCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthernetNetworkDiagnosticsClusterAcceptedCommandListAttributeCallback implements ChipClusters.EthernetNetworkDiagnosticsCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthernetNetworkDiagnosticsClusterEventListAttributeCallback implements ChipClusters.EthernetNetworkDiagnosticsCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthernetNetworkDiagnosticsClusterAttributeListAttributeCallback implements ChipClusters.EthernetNetworkDiagnosticsCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedTimeSynchronizationClusterSetTimeZoneResponseCallback implements ChipClusters.TimeSynchronizationCluster.SetTimeZoneResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Boolean DSTOffsetRequired) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo DSTOffsetRequiredResponseValue = new CommandResponseInfo("DSTOffsetRequired", "Boolean");
               responseValues.put(DSTOffsetRequiredResponseValue, DSTOffsetRequired);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedTimeSynchronizationClusterUTCTimeAttributeCallback implements ChipClusters.TimeSynchronizationCluster.UTCTimeAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeSynchronizationClusterDefaultNTPAttributeCallback implements ChipClusters.TimeSynchronizationCluster.DefaultNTPAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable String value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "String");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeSynchronizationClusterTimeZoneAttributeCallback implements ChipClusters.TimeSynchronizationCluster.TimeZoneAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.TimeSynchronizationClusterTimeZoneStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.TimeSynchronizationClusterTimeZoneStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeSynchronizationClusterDSTOffsetAttributeCallback implements ChipClusters.TimeSynchronizationCluster.DSTOffsetAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.TimeSynchronizationClusterDSTOffsetStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.TimeSynchronizationClusterDSTOffsetStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeSynchronizationClusterLocalTimeAttributeCallback implements ChipClusters.TimeSynchronizationCluster.LocalTimeAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeSynchronizationClusterGeneratedCommandListAttributeCallback implements ChipClusters.TimeSynchronizationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeSynchronizationClusterAcceptedCommandListAttributeCallback implements ChipClusters.TimeSynchronizationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeSynchronizationClusterEventListAttributeCallback implements ChipClusters.TimeSynchronizationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTimeSynchronizationClusterAttributeListAttributeCallback implements ChipClusters.TimeSynchronizationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedBridgedDeviceBasicInformationClusterGeneratedCommandListAttributeCallback implements ChipClusters.BridgedDeviceBasicInformationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBridgedDeviceBasicInformationClusterAcceptedCommandListAttributeCallback implements ChipClusters.BridgedDeviceBasicInformationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBridgedDeviceBasicInformationClusterEventListAttributeCallback implements ChipClusters.BridgedDeviceBasicInformationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBridgedDeviceBasicInformationClusterAttributeListAttributeCallback implements ChipClusters.BridgedDeviceBasicInformationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedSwitchClusterGeneratedCommandListAttributeCallback implements ChipClusters.SwitchCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSwitchClusterAcceptedCommandListAttributeCallback implements ChipClusters.SwitchCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSwitchClusterEventListAttributeCallback implements ChipClusters.SwitchCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSwitchClusterAttributeListAttributeCallback implements ChipClusters.SwitchCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedAdministratorCommissioningClusterAdminFabricIndexAttributeCallback implements ChipClusters.AdministratorCommissioningCluster.AdminFabricIndexAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAdministratorCommissioningClusterAdminVendorIdAttributeCallback implements ChipClusters.AdministratorCommissioningCluster.AdminVendorIdAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAdministratorCommissioningClusterGeneratedCommandListAttributeCallback implements ChipClusters.AdministratorCommissioningCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAdministratorCommissioningClusterAcceptedCommandListAttributeCallback implements ChipClusters.AdministratorCommissioningCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAdministratorCommissioningClusterEventListAttributeCallback implements ChipClusters.AdministratorCommissioningCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAdministratorCommissioningClusterAttributeListAttributeCallback implements ChipClusters.AdministratorCommissioningCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedOperationalCredentialsClusterAttestationResponseCallback implements ChipClusters.OperationalCredentialsCluster.AttestationResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(byte[] AttestationElements, byte[] AttestationSignature) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo AttestationElementsResponseValue = new CommandResponseInfo("AttestationElements", "byte[]");
               responseValues.put(AttestationElementsResponseValue, AttestationElements);
               CommandResponseInfo AttestationSignatureResponseValue = new CommandResponseInfo("AttestationSignature", "byte[]");
               responseValues.put(AttestationSignatureResponseValue, AttestationSignature);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedOperationalCredentialsClusterCertificateChainResponseCallback implements ChipClusters.OperationalCredentialsCluster.CertificateChainResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(byte[] Certificate) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo CertificateResponseValue = new CommandResponseInfo("Certificate", "byte[]");
               responseValues.put(CertificateResponseValue, Certificate);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedOperationalCredentialsClusterCSRResponseCallback implements ChipClusters.OperationalCredentialsCluster.CSRResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(byte[] NOCSRElements, byte[] AttestationSignature) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo NOCSRElementsResponseValue = new CommandResponseInfo("NOCSRElements", "byte[]");
               responseValues.put(NOCSRElementsResponseValue, NOCSRElements);
               CommandResponseInfo AttestationSignatureResponseValue = new CommandResponseInfo("AttestationSignature", "byte[]");
               responseValues.put(AttestationSignatureResponseValue, AttestationSignature);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedOperationalCredentialsClusterNOCResponseCallback implements ChipClusters.OperationalCredentialsCluster.NOCResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer StatusCode, Optional<Integer> FabricIndex, Optional<String> DebugText) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusCodeResponseValue = new CommandResponseInfo("StatusCode", "Integer");
               responseValues.put(StatusCodeResponseValue, StatusCode);
               CommandResponseInfo FabricIndexResponseValue = new CommandResponseInfo("FabricIndex", "Optional<Integer>");
               responseValues.put(FabricIndexResponseValue, FabricIndex);
               CommandResponseInfo DebugTextResponseValue = new CommandResponseInfo("DebugText", "Optional<String>");
               responseValues.put(DebugTextResponseValue, DebugText);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedOperationalCredentialsClusterNOCsAttributeCallback implements ChipClusters.OperationalCredentialsCluster.NOCsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.OperationalCredentialsClusterNOCStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.OperationalCredentialsClusterNOCStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalCredentialsClusterFabricsAttributeCallback implements ChipClusters.OperationalCredentialsCluster.FabricsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.OperationalCredentialsClusterFabricDescriptorStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.OperationalCredentialsClusterFabricDescriptorStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalCredentialsClusterTrustedRootCertificatesAttributeCallback implements ChipClusters.OperationalCredentialsCluster.TrustedRootCertificatesAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<byte[]> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<byte[]>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalCredentialsClusterGeneratedCommandListAttributeCallback implements ChipClusters.OperationalCredentialsCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalCredentialsClusterAcceptedCommandListAttributeCallback implements ChipClusters.OperationalCredentialsCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalCredentialsClusterEventListAttributeCallback implements ChipClusters.OperationalCredentialsCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalCredentialsClusterAttributeListAttributeCallback implements ChipClusters.OperationalCredentialsCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedGroupKeyManagementClusterKeySetReadResponseCallback implements ChipClusters.GroupKeyManagementCluster.KeySetReadResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(ChipStructs.GroupKeyManagementClusterGroupKeySetStruct GroupKeySet) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               // GroupKeySet: Struct GroupKeySetStruct
               // Conversion from this type to Java is not properly implemented yet
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedGroupKeyManagementClusterKeySetReadAllIndicesResponseCallback implements ChipClusters.GroupKeyManagementCluster.KeySetReadAllIndicesResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(ArrayList<Integer> GroupKeySetIDs) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               // GroupKeySetIDs: /* TYPE WARNING: array array defaults to */ uint8_t * 
               // Conversion from this type to Java is not properly implemented yet
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedGroupKeyManagementClusterGroupKeyMapAttributeCallback implements ChipClusters.GroupKeyManagementCluster.GroupKeyMapAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.GroupKeyManagementClusterGroupKeyMapStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.GroupKeyManagementClusterGroupKeyMapStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGroupKeyManagementClusterGroupTableAttributeCallback implements ChipClusters.GroupKeyManagementCluster.GroupTableAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.GroupKeyManagementClusterGroupInfoMapStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.GroupKeyManagementClusterGroupInfoMapStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGroupKeyManagementClusterGeneratedCommandListAttributeCallback implements ChipClusters.GroupKeyManagementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGroupKeyManagementClusterAcceptedCommandListAttributeCallback implements ChipClusters.GroupKeyManagementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGroupKeyManagementClusterEventListAttributeCallback implements ChipClusters.GroupKeyManagementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedGroupKeyManagementClusterAttributeListAttributeCallback implements ChipClusters.GroupKeyManagementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedFixedLabelClusterLabelListAttributeCallback implements ChipClusters.FixedLabelCluster.LabelListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.FixedLabelClusterLabelStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.FixedLabelClusterLabelStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFixedLabelClusterGeneratedCommandListAttributeCallback implements ChipClusters.FixedLabelCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFixedLabelClusterAcceptedCommandListAttributeCallback implements ChipClusters.FixedLabelCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFixedLabelClusterEventListAttributeCallback implements ChipClusters.FixedLabelCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFixedLabelClusterAttributeListAttributeCallback implements ChipClusters.FixedLabelCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedUserLabelClusterLabelListAttributeCallback implements ChipClusters.UserLabelCluster.LabelListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.UserLabelClusterLabelStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.UserLabelClusterLabelStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUserLabelClusterGeneratedCommandListAttributeCallback implements ChipClusters.UserLabelCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUserLabelClusterAcceptedCommandListAttributeCallback implements ChipClusters.UserLabelCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUserLabelClusterEventListAttributeCallback implements ChipClusters.UserLabelCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUserLabelClusterAttributeListAttributeCallback implements ChipClusters.UserLabelCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedProxyConfigurationClusterGeneratedCommandListAttributeCallback implements ChipClusters.ProxyConfigurationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedProxyConfigurationClusterAcceptedCommandListAttributeCallback implements ChipClusters.ProxyConfigurationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedProxyConfigurationClusterEventListAttributeCallback implements ChipClusters.ProxyConfigurationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedProxyConfigurationClusterAttributeListAttributeCallback implements ChipClusters.ProxyConfigurationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedProxyDiscoveryClusterGeneratedCommandListAttributeCallback implements ChipClusters.ProxyDiscoveryCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedProxyDiscoveryClusterAcceptedCommandListAttributeCallback implements ChipClusters.ProxyDiscoveryCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedProxyDiscoveryClusterEventListAttributeCallback implements ChipClusters.ProxyDiscoveryCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedProxyDiscoveryClusterAttributeListAttributeCallback implements ChipClusters.ProxyDiscoveryCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedProxyValidClusterGeneratedCommandListAttributeCallback implements ChipClusters.ProxyValidCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedProxyValidClusterAcceptedCommandListAttributeCallback implements ChipClusters.ProxyValidCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedProxyValidClusterEventListAttributeCallback implements ChipClusters.ProxyValidCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedProxyValidClusterAttributeListAttributeCallback implements ChipClusters.ProxyValidCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedBooleanStateClusterGeneratedCommandListAttributeCallback implements ChipClusters.BooleanStateCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBooleanStateClusterAcceptedCommandListAttributeCallback implements ChipClusters.BooleanStateCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBooleanStateClusterEventListAttributeCallback implements ChipClusters.BooleanStateCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBooleanStateClusterAttributeListAttributeCallback implements ChipClusters.BooleanStateCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedIcdManagementClusterRegisterClientResponseCallback implements ChipClusters.IcdManagementCluster.RegisterClientResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Long ICDCounter) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo ICDCounterResponseValue = new CommandResponseInfo("ICDCounter", "Long");
               responseValues.put(ICDCounterResponseValue, ICDCounter);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedIcdManagementClusterRegisteredClientsAttributeCallback implements ChipClusters.IcdManagementCluster.RegisteredClientsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.IcdManagementClusterMonitoringRegistrationStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.IcdManagementClusterMonitoringRegistrationStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIcdManagementClusterGeneratedCommandListAttributeCallback implements ChipClusters.IcdManagementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIcdManagementClusterAcceptedCommandListAttributeCallback implements ChipClusters.IcdManagementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIcdManagementClusterEventListAttributeCallback implements ChipClusters.IcdManagementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIcdManagementClusterAttributeListAttributeCallback implements ChipClusters.IcdManagementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedModeSelectClusterStandardNamespaceAttributeCallback implements ChipClusters.ModeSelectCluster.StandardNamespaceAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedModeSelectClusterSupportedModesAttributeCallback implements ChipClusters.ModeSelectCluster.SupportedModesAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.ModeSelectClusterModeOptionStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.ModeSelectClusterModeOptionStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedModeSelectClusterStartUpModeAttributeCallback implements ChipClusters.ModeSelectCluster.StartUpModeAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedModeSelectClusterOnModeAttributeCallback implements ChipClusters.ModeSelectCluster.OnModeAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedModeSelectClusterGeneratedCommandListAttributeCallback implements ChipClusters.ModeSelectCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedModeSelectClusterAcceptedCommandListAttributeCallback implements ChipClusters.ModeSelectCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedModeSelectClusterEventListAttributeCallback implements ChipClusters.ModeSelectCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedModeSelectClusterAttributeListAttributeCallback implements ChipClusters.ModeSelectCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedTemperatureControlClusterSupportedTemperatureLevelsAttributeCallback implements ChipClusters.TemperatureControlCluster.SupportedTemperatureLevelsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.TemperatureControlClusterTemperatureLevelStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.TemperatureControlClusterTemperatureLevelStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTemperatureControlClusterGeneratedCommandListAttributeCallback implements ChipClusters.TemperatureControlCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTemperatureControlClusterAcceptedCommandListAttributeCallback implements ChipClusters.TemperatureControlCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTemperatureControlClusterEventListAttributeCallback implements ChipClusters.TemperatureControlCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTemperatureControlClusterAttributeListAttributeCallback implements ChipClusters.TemperatureControlCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedRefrigeratorAlarmClusterGeneratedCommandListAttributeCallback implements ChipClusters.RefrigeratorAlarmCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRefrigeratorAlarmClusterAcceptedCommandListAttributeCallback implements ChipClusters.RefrigeratorAlarmCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRefrigeratorAlarmClusterEventListAttributeCallback implements ChipClusters.RefrigeratorAlarmCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRefrigeratorAlarmClusterAttributeListAttributeCallback implements ChipClusters.RefrigeratorAlarmCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedAirQualityClusterGeneratedCommandListAttributeCallback implements ChipClusters.AirQualityCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAirQualityClusterAcceptedCommandListAttributeCallback implements ChipClusters.AirQualityCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAirQualityClusterEventListAttributeCallback implements ChipClusters.AirQualityCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAirQualityClusterAttributeListAttributeCallback implements ChipClusters.AirQualityCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedSmokeCoAlarmClusterGeneratedCommandListAttributeCallback implements ChipClusters.SmokeCoAlarmCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSmokeCoAlarmClusterAcceptedCommandListAttributeCallback implements ChipClusters.SmokeCoAlarmCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSmokeCoAlarmClusterEventListAttributeCallback implements ChipClusters.SmokeCoAlarmCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSmokeCoAlarmClusterAttributeListAttributeCallback implements ChipClusters.SmokeCoAlarmCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedOperationalStateClusterPhaseListAttributeCallback implements ChipClusters.OperationalStateCluster.PhaseListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable List<String> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<String>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalStateClusterCurrentPhaseAttributeCallback implements ChipClusters.OperationalStateCluster.CurrentPhaseAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalStateClusterCountdownTimeAttributeCallback implements ChipClusters.OperationalStateCluster.CountdownTimeAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalStateClusterOperationalStateListAttributeCallback implements ChipClusters.OperationalStateCluster.OperationalStateListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.OperationalStateClusterOperationalStateStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.OperationalStateClusterOperationalStateStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalStateClusterGeneratedCommandListAttributeCallback implements ChipClusters.OperationalStateCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalStateClusterAcceptedCommandListAttributeCallback implements ChipClusters.OperationalStateCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalStateClusterEventListAttributeCallback implements ChipClusters.OperationalStateCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOperationalStateClusterAttributeListAttributeCallback implements ChipClusters.OperationalStateCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedHepaFilterMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.HepaFilterMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHepaFilterMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.HepaFilterMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHepaFilterMonitoringClusterEventListAttributeCallback implements ChipClusters.HepaFilterMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHepaFilterMonitoringClusterAttributeListAttributeCallback implements ChipClusters.HepaFilterMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedActivatedCarbonFilterMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.ActivatedCarbonFilterMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedActivatedCarbonFilterMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.ActivatedCarbonFilterMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedActivatedCarbonFilterMonitoringClusterEventListAttributeCallback implements ChipClusters.ActivatedCarbonFilterMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedActivatedCarbonFilterMonitoringClusterAttributeListAttributeCallback implements ChipClusters.ActivatedCarbonFilterMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedCeramicFilterMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.CeramicFilterMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCeramicFilterMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.CeramicFilterMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCeramicFilterMonitoringClusterEventListAttributeCallback implements ChipClusters.CeramicFilterMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCeramicFilterMonitoringClusterAttributeListAttributeCallback implements ChipClusters.CeramicFilterMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedElectrostaticFilterMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.ElectrostaticFilterMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedElectrostaticFilterMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.ElectrostaticFilterMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedElectrostaticFilterMonitoringClusterEventListAttributeCallback implements ChipClusters.ElectrostaticFilterMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedElectrostaticFilterMonitoringClusterAttributeListAttributeCallback implements ChipClusters.ElectrostaticFilterMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedUvFilterMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.UvFilterMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUvFilterMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.UvFilterMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUvFilterMonitoringClusterEventListAttributeCallback implements ChipClusters.UvFilterMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUvFilterMonitoringClusterAttributeListAttributeCallback implements ChipClusters.UvFilterMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedIonizingFilterMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.IonizingFilterMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIonizingFilterMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.IonizingFilterMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIonizingFilterMonitoringClusterEventListAttributeCallback implements ChipClusters.IonizingFilterMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIonizingFilterMonitoringClusterAttributeListAttributeCallback implements ChipClusters.IonizingFilterMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedZeoliteFilterMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.ZeoliteFilterMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedZeoliteFilterMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.ZeoliteFilterMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedZeoliteFilterMonitoringClusterEventListAttributeCallback implements ChipClusters.ZeoliteFilterMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedZeoliteFilterMonitoringClusterAttributeListAttributeCallback implements ChipClusters.ZeoliteFilterMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedOzoneFilterMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.OzoneFilterMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOzoneFilterMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.OzoneFilterMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOzoneFilterMonitoringClusterEventListAttributeCallback implements ChipClusters.OzoneFilterMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOzoneFilterMonitoringClusterAttributeListAttributeCallback implements ChipClusters.OzoneFilterMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedWaterTankMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.WaterTankMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWaterTankMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.WaterTankMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWaterTankMonitoringClusterEventListAttributeCallback implements ChipClusters.WaterTankMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWaterTankMonitoringClusterAttributeListAttributeCallback implements ChipClusters.WaterTankMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedFuelTankMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.FuelTankMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFuelTankMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.FuelTankMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFuelTankMonitoringClusterEventListAttributeCallback implements ChipClusters.FuelTankMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFuelTankMonitoringClusterAttributeListAttributeCallback implements ChipClusters.FuelTankMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedInkCartridgeMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.InkCartridgeMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedInkCartridgeMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.InkCartridgeMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedInkCartridgeMonitoringClusterEventListAttributeCallback implements ChipClusters.InkCartridgeMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedInkCartridgeMonitoringClusterAttributeListAttributeCallback implements ChipClusters.InkCartridgeMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedTonerCartridgeMonitoringClusterGeneratedCommandListAttributeCallback implements ChipClusters.TonerCartridgeMonitoringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTonerCartridgeMonitoringClusterAcceptedCommandListAttributeCallback implements ChipClusters.TonerCartridgeMonitoringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTonerCartridgeMonitoringClusterEventListAttributeCallback implements ChipClusters.TonerCartridgeMonitoringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTonerCartridgeMonitoringClusterAttributeListAttributeCallback implements ChipClusters.TonerCartridgeMonitoringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedDoorLockClusterGetWeekDayScheduleResponseCallback implements ChipClusters.DoorLockCluster.GetWeekDayScheduleResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer WeekDayIndex, Integer UserIndex, Integer Status, Optional<Integer> DaysMask, Optional<Integer> StartHour, Optional<Integer> StartMinute, Optional<Integer> EndHour, Optional<Integer> EndMinute) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo WeekDayIndexResponseValue = new CommandResponseInfo("WeekDayIndex", "Integer");
               responseValues.put(WeekDayIndexResponseValue, WeekDayIndex);
               CommandResponseInfo UserIndexResponseValue = new CommandResponseInfo("UserIndex", "Integer");
               responseValues.put(UserIndexResponseValue, UserIndex);
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo DaysMaskResponseValue = new CommandResponseInfo("DaysMask", "Optional<Integer>");
               responseValues.put(DaysMaskResponseValue, DaysMask);
               CommandResponseInfo StartHourResponseValue = new CommandResponseInfo("StartHour", "Optional<Integer>");
               responseValues.put(StartHourResponseValue, StartHour);
               CommandResponseInfo StartMinuteResponseValue = new CommandResponseInfo("StartMinute", "Optional<Integer>");
               responseValues.put(StartMinuteResponseValue, StartMinute);
               CommandResponseInfo EndHourResponseValue = new CommandResponseInfo("EndHour", "Optional<Integer>");
               responseValues.put(EndHourResponseValue, EndHour);
               CommandResponseInfo EndMinuteResponseValue = new CommandResponseInfo("EndMinute", "Optional<Integer>");
               responseValues.put(EndMinuteResponseValue, EndMinute);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedDoorLockClusterGetYearDayScheduleResponseCallback implements ChipClusters.DoorLockCluster.GetYearDayScheduleResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer YearDayIndex, Integer UserIndex, Integer Status, Optional<Long> LocalStartTime, Optional<Long> LocalEndTime) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo YearDayIndexResponseValue = new CommandResponseInfo("YearDayIndex", "Integer");
               responseValues.put(YearDayIndexResponseValue, YearDayIndex);
               CommandResponseInfo UserIndexResponseValue = new CommandResponseInfo("UserIndex", "Integer");
               responseValues.put(UserIndexResponseValue, UserIndex);
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo LocalStartTimeResponseValue = new CommandResponseInfo("LocalStartTime", "Optional<Long>");
               responseValues.put(LocalStartTimeResponseValue, LocalStartTime);
               CommandResponseInfo LocalEndTimeResponseValue = new CommandResponseInfo("LocalEndTime", "Optional<Long>");
               responseValues.put(LocalEndTimeResponseValue, LocalEndTime);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedDoorLockClusterGetHolidayScheduleResponseCallback implements ChipClusters.DoorLockCluster.GetHolidayScheduleResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer HolidayIndex, Integer Status, Optional<Long> LocalStartTime, Optional<Long> LocalEndTime, Optional<Integer> OperatingMode) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo HolidayIndexResponseValue = new CommandResponseInfo("HolidayIndex", "Integer");
               responseValues.put(HolidayIndexResponseValue, HolidayIndex);
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo LocalStartTimeResponseValue = new CommandResponseInfo("LocalStartTime", "Optional<Long>");
               responseValues.put(LocalStartTimeResponseValue, LocalStartTime);
               CommandResponseInfo LocalEndTimeResponseValue = new CommandResponseInfo("LocalEndTime", "Optional<Long>");
               responseValues.put(LocalEndTimeResponseValue, LocalEndTime);
               CommandResponseInfo OperatingModeResponseValue = new CommandResponseInfo("OperatingMode", "Optional<Integer>");
               responseValues.put(OperatingModeResponseValue, OperatingMode);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedDoorLockClusterGetUserResponseCallback implements ChipClusters.DoorLockCluster.GetUserResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer UserIndex, @Nullable String UserName, @Nullable Long UserUniqueID, @Nullable Integer UserStatus, @Nullable Integer UserType, @Nullable Integer CredentialRule, @Nullable ArrayList<ChipStructs.DoorLockClusterCredentialStruct> Credentials, @Nullable Integer CreatorFabricIndex, @Nullable Integer LastModifiedFabricIndex, @Nullable Integer NextUserIndex) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo UserIndexResponseValue = new CommandResponseInfo("UserIndex", "Integer");
               responseValues.put(UserIndexResponseValue, UserIndex);
               CommandResponseInfo UserNameResponseValue = new CommandResponseInfo("UserName", "String");
               responseValues.put(UserNameResponseValue, UserName);
               CommandResponseInfo UserUniqueIDResponseValue = new CommandResponseInfo("UserUniqueID", "Long");
               responseValues.put(UserUniqueIDResponseValue, UserUniqueID);
               CommandResponseInfo UserStatusResponseValue = new CommandResponseInfo("UserStatus", "Integer");
               responseValues.put(UserStatusResponseValue, UserStatus);
               CommandResponseInfo UserTypeResponseValue = new CommandResponseInfo("UserType", "Integer");
               responseValues.put(UserTypeResponseValue, UserType);
               CommandResponseInfo CredentialRuleResponseValue = new CommandResponseInfo("CredentialRule", "Integer");
               responseValues.put(CredentialRuleResponseValue, CredentialRule);
               // Credentials: /* TYPE WARNING: array array defaults to */ uint8_t * 
               // Conversion from this type to Java is not properly implemented yet
               CommandResponseInfo CreatorFabricIndexResponseValue = new CommandResponseInfo("CreatorFabricIndex", "Integer");
               responseValues.put(CreatorFabricIndexResponseValue, CreatorFabricIndex);
               CommandResponseInfo LastModifiedFabricIndexResponseValue = new CommandResponseInfo("LastModifiedFabricIndex", "Integer");
               responseValues.put(LastModifiedFabricIndexResponseValue, LastModifiedFabricIndex);
               CommandResponseInfo NextUserIndexResponseValue = new CommandResponseInfo("NextUserIndex", "Integer");
               responseValues.put(NextUserIndexResponseValue, NextUserIndex);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedDoorLockClusterSetCredentialResponseCallback implements ChipClusters.DoorLockCluster.SetCredentialResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, @Nullable Integer UserIndex, @Nullable Integer NextCredentialIndex) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo UserIndexResponseValue = new CommandResponseInfo("UserIndex", "Integer");
               responseValues.put(UserIndexResponseValue, UserIndex);
               CommandResponseInfo NextCredentialIndexResponseValue = new CommandResponseInfo("NextCredentialIndex", "Integer");
               responseValues.put(NextCredentialIndexResponseValue, NextCredentialIndex);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedDoorLockClusterGetCredentialStatusResponseCallback implements ChipClusters.DoorLockCluster.GetCredentialStatusResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Boolean CredentialExists, @Nullable Integer UserIndex, @Nullable Integer CreatorFabricIndex, @Nullable Integer LastModifiedFabricIndex, @Nullable Integer NextCredentialIndex) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo CredentialExistsResponseValue = new CommandResponseInfo("CredentialExists", "Boolean");
               responseValues.put(CredentialExistsResponseValue, CredentialExists);
               CommandResponseInfo UserIndexResponseValue = new CommandResponseInfo("UserIndex", "Integer");
               responseValues.put(UserIndexResponseValue, UserIndex);
               CommandResponseInfo CreatorFabricIndexResponseValue = new CommandResponseInfo("CreatorFabricIndex", "Integer");
               responseValues.put(CreatorFabricIndexResponseValue, CreatorFabricIndex);
               CommandResponseInfo LastModifiedFabricIndexResponseValue = new CommandResponseInfo("LastModifiedFabricIndex", "Integer");
               responseValues.put(LastModifiedFabricIndexResponseValue, LastModifiedFabricIndex);
               CommandResponseInfo NextCredentialIndexResponseValue = new CommandResponseInfo("NextCredentialIndex", "Integer");
               responseValues.put(NextCredentialIndexResponseValue, NextCredentialIndex);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedDoorLockClusterLockStateAttributeCallback implements ChipClusters.DoorLockCluster.LockStateAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDoorLockClusterDoorStateAttributeCallback implements ChipClusters.DoorLockCluster.DoorStateAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDoorLockClusterGeneratedCommandListAttributeCallback implements ChipClusters.DoorLockCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDoorLockClusterAcceptedCommandListAttributeCallback implements ChipClusters.DoorLockCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDoorLockClusterEventListAttributeCallback implements ChipClusters.DoorLockCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDoorLockClusterAttributeListAttributeCallback implements ChipClusters.DoorLockCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedWindowCoveringClusterCurrentPositionLiftAttributeCallback implements ChipClusters.WindowCoveringCluster.CurrentPositionLiftAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWindowCoveringClusterCurrentPositionTiltAttributeCallback implements ChipClusters.WindowCoveringCluster.CurrentPositionTiltAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWindowCoveringClusterCurrentPositionLiftPercentageAttributeCallback implements ChipClusters.WindowCoveringCluster.CurrentPositionLiftPercentageAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWindowCoveringClusterCurrentPositionTiltPercentageAttributeCallback implements ChipClusters.WindowCoveringCluster.CurrentPositionTiltPercentageAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWindowCoveringClusterTargetPositionLiftPercent100thsAttributeCallback implements ChipClusters.WindowCoveringCluster.TargetPositionLiftPercent100thsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWindowCoveringClusterTargetPositionTiltPercent100thsAttributeCallback implements ChipClusters.WindowCoveringCluster.TargetPositionTiltPercent100thsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWindowCoveringClusterCurrentPositionLiftPercent100thsAttributeCallback implements ChipClusters.WindowCoveringCluster.CurrentPositionLiftPercent100thsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWindowCoveringClusterCurrentPositionTiltPercent100thsAttributeCallback implements ChipClusters.WindowCoveringCluster.CurrentPositionTiltPercent100thsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWindowCoveringClusterGeneratedCommandListAttributeCallback implements ChipClusters.WindowCoveringCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWindowCoveringClusterAcceptedCommandListAttributeCallback implements ChipClusters.WindowCoveringCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWindowCoveringClusterEventListAttributeCallback implements ChipClusters.WindowCoveringCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWindowCoveringClusterAttributeListAttributeCallback implements ChipClusters.WindowCoveringCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedBarrierControlClusterGeneratedCommandListAttributeCallback implements ChipClusters.BarrierControlCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBarrierControlClusterAcceptedCommandListAttributeCallback implements ChipClusters.BarrierControlCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBarrierControlClusterEventListAttributeCallback implements ChipClusters.BarrierControlCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBarrierControlClusterAttributeListAttributeCallback implements ChipClusters.BarrierControlCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedPumpConfigurationAndControlClusterMaxPressureAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MaxPressureAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMaxSpeedAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MaxSpeedAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMaxFlowAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MaxFlowAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMinConstPressureAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MinConstPressureAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMaxConstPressureAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MaxConstPressureAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMinCompPressureAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MinCompPressureAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMaxCompPressureAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MaxCompPressureAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMinConstSpeedAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MinConstSpeedAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMaxConstSpeedAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MaxConstSpeedAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMinConstFlowAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MinConstFlowAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMaxConstFlowAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MaxConstFlowAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMinConstTempAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MinConstTempAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterMaxConstTempAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.MaxConstTempAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterCapacityAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.CapacityAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterSpeedAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.SpeedAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterLifetimeRunningHoursAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.LifetimeRunningHoursAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterPowerAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.PowerAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterLifetimeEnergyConsumedAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.LifetimeEnergyConsumedAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterGeneratedCommandListAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterAcceptedCommandListAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterEventListAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPumpConfigurationAndControlClusterAttributeListAttributeCallback implements ChipClusters.PumpConfigurationAndControlCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedThermostatClusterGetWeeklyScheduleResponseCallback implements ChipClusters.ThermostatCluster.GetWeeklyScheduleResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer NumberOfTransitionsForSequence, Integer DayOfWeekForSequence, Integer ModeForSequence, ArrayList<ChipStructs.ThermostatClusterThermostatScheduleTransition> Transitions) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo NumberOfTransitionsForSequenceResponseValue = new CommandResponseInfo("NumberOfTransitionsForSequence", "Integer");
               responseValues.put(NumberOfTransitionsForSequenceResponseValue, NumberOfTransitionsForSequence);
               CommandResponseInfo DayOfWeekForSequenceResponseValue = new CommandResponseInfo("DayOfWeekForSequence", "Integer");
               responseValues.put(DayOfWeekForSequenceResponseValue, DayOfWeekForSequence);
               CommandResponseInfo ModeForSequenceResponseValue = new CommandResponseInfo("ModeForSequence", "Integer");
               responseValues.put(ModeForSequenceResponseValue, ModeForSequence);
               // Transitions: /* TYPE WARNING: array array defaults to */ uint8_t * 
               // Conversion from this type to Java is not properly implemented yet
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedThermostatClusterLocalTemperatureAttributeCallback implements ChipClusters.ThermostatCluster.LocalTemperatureAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterOutdoorTemperatureAttributeCallback implements ChipClusters.ThermostatCluster.OutdoorTemperatureAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterTemperatureSetpointHoldDurationAttributeCallback implements ChipClusters.ThermostatCluster.TemperatureSetpointHoldDurationAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterSetpointChangeAmountAttributeCallback implements ChipClusters.ThermostatCluster.SetpointChangeAmountAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterOccupiedSetbackAttributeCallback implements ChipClusters.ThermostatCluster.OccupiedSetbackAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterOccupiedSetbackMinAttributeCallback implements ChipClusters.ThermostatCluster.OccupiedSetbackMinAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterOccupiedSetbackMaxAttributeCallback implements ChipClusters.ThermostatCluster.OccupiedSetbackMaxAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterUnoccupiedSetbackAttributeCallback implements ChipClusters.ThermostatCluster.UnoccupiedSetbackAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterUnoccupiedSetbackMinAttributeCallback implements ChipClusters.ThermostatCluster.UnoccupiedSetbackMinAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterUnoccupiedSetbackMaxAttributeCallback implements ChipClusters.ThermostatCluster.UnoccupiedSetbackMaxAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterACCoilTemperatureAttributeCallback implements ChipClusters.ThermostatCluster.ACCoilTemperatureAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterGeneratedCommandListAttributeCallback implements ChipClusters.ThermostatCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterAcceptedCommandListAttributeCallback implements ChipClusters.ThermostatCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterEventListAttributeCallback implements ChipClusters.ThermostatCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatClusterAttributeListAttributeCallback implements ChipClusters.ThermostatCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedFanControlClusterPercentSettingAttributeCallback implements ChipClusters.FanControlCluster.PercentSettingAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFanControlClusterSpeedSettingAttributeCallback implements ChipClusters.FanControlCluster.SpeedSettingAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFanControlClusterGeneratedCommandListAttributeCallback implements ChipClusters.FanControlCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFanControlClusterAcceptedCommandListAttributeCallback implements ChipClusters.FanControlCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFanControlClusterEventListAttributeCallback implements ChipClusters.FanControlCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFanControlClusterAttributeListAttributeCallback implements ChipClusters.FanControlCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedThermostatUserInterfaceConfigurationClusterGeneratedCommandListAttributeCallback implements ChipClusters.ThermostatUserInterfaceConfigurationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatUserInterfaceConfigurationClusterAcceptedCommandListAttributeCallback implements ChipClusters.ThermostatUserInterfaceConfigurationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatUserInterfaceConfigurationClusterEventListAttributeCallback implements ChipClusters.ThermostatUserInterfaceConfigurationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedThermostatUserInterfaceConfigurationClusterAttributeListAttributeCallback implements ChipClusters.ThermostatUserInterfaceConfigurationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedColorControlClusterNumberOfPrimariesAttributeCallback implements ChipClusters.ColorControlCluster.NumberOfPrimariesAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterPrimary1IntensityAttributeCallback implements ChipClusters.ColorControlCluster.Primary1IntensityAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterPrimary2IntensityAttributeCallback implements ChipClusters.ColorControlCluster.Primary2IntensityAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterPrimary3IntensityAttributeCallback implements ChipClusters.ColorControlCluster.Primary3IntensityAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterPrimary4IntensityAttributeCallback implements ChipClusters.ColorControlCluster.Primary4IntensityAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterPrimary5IntensityAttributeCallback implements ChipClusters.ColorControlCluster.Primary5IntensityAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterPrimary6IntensityAttributeCallback implements ChipClusters.ColorControlCluster.Primary6IntensityAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterColorPointRIntensityAttributeCallback implements ChipClusters.ColorControlCluster.ColorPointRIntensityAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterColorPointGIntensityAttributeCallback implements ChipClusters.ColorControlCluster.ColorPointGIntensityAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterColorPointBIntensityAttributeCallback implements ChipClusters.ColorControlCluster.ColorPointBIntensityAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterStartUpColorTemperatureMiredsAttributeCallback implements ChipClusters.ColorControlCluster.StartUpColorTemperatureMiredsAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterGeneratedCommandListAttributeCallback implements ChipClusters.ColorControlCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterAcceptedCommandListAttributeCallback implements ChipClusters.ColorControlCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterEventListAttributeCallback implements ChipClusters.ColorControlCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedColorControlClusterAttributeListAttributeCallback implements ChipClusters.ColorControlCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedBallastConfigurationClusterIntrinsicBallastFactorAttributeCallback implements ChipClusters.BallastConfigurationCluster.IntrinsicBallastFactorAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBallastConfigurationClusterBallastFactorAdjustmentAttributeCallback implements ChipClusters.BallastConfigurationCluster.BallastFactorAdjustmentAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBallastConfigurationClusterLampRatedHoursAttributeCallback implements ChipClusters.BallastConfigurationCluster.LampRatedHoursAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBallastConfigurationClusterLampBurnHoursAttributeCallback implements ChipClusters.BallastConfigurationCluster.LampBurnHoursAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBallastConfigurationClusterLampBurnHoursTripPointAttributeCallback implements ChipClusters.BallastConfigurationCluster.LampBurnHoursTripPointAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBallastConfigurationClusterGeneratedCommandListAttributeCallback implements ChipClusters.BallastConfigurationCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBallastConfigurationClusterAcceptedCommandListAttributeCallback implements ChipClusters.BallastConfigurationCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBallastConfigurationClusterEventListAttributeCallback implements ChipClusters.BallastConfigurationCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBallastConfigurationClusterAttributeListAttributeCallback implements ChipClusters.BallastConfigurationCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedIlluminanceMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.IlluminanceMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIlluminanceMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.IlluminanceMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIlluminanceMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.IlluminanceMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIlluminanceMeasurementClusterLightSensorTypeAttributeCallback implements ChipClusters.IlluminanceMeasurementCluster.LightSensorTypeAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIlluminanceMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.IlluminanceMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIlluminanceMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.IlluminanceMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIlluminanceMeasurementClusterEventListAttributeCallback implements ChipClusters.IlluminanceMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedIlluminanceMeasurementClusterAttributeListAttributeCallback implements ChipClusters.IlluminanceMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedTemperatureMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.TemperatureMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTemperatureMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.TemperatureMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTemperatureMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.TemperatureMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTemperatureMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.TemperatureMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTemperatureMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.TemperatureMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTemperatureMeasurementClusterEventListAttributeCallback implements ChipClusters.TemperatureMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTemperatureMeasurementClusterAttributeListAttributeCallback implements ChipClusters.TemperatureMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedPressureMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.PressureMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPressureMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.PressureMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPressureMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.PressureMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPressureMeasurementClusterScaledValueAttributeCallback implements ChipClusters.PressureMeasurementCluster.ScaledValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPressureMeasurementClusterMinScaledValueAttributeCallback implements ChipClusters.PressureMeasurementCluster.MinScaledValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPressureMeasurementClusterMaxScaledValueAttributeCallback implements ChipClusters.PressureMeasurementCluster.MaxScaledValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPressureMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.PressureMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPressureMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.PressureMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPressureMeasurementClusterEventListAttributeCallback implements ChipClusters.PressureMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPressureMeasurementClusterAttributeListAttributeCallback implements ChipClusters.PressureMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedFlowMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.FlowMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFlowMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.FlowMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFlowMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.FlowMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFlowMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.FlowMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFlowMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.FlowMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFlowMeasurementClusterEventListAttributeCallback implements ChipClusters.FlowMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFlowMeasurementClusterAttributeListAttributeCallback implements ChipClusters.FlowMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedRelativeHumidityMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.RelativeHumidityMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRelativeHumidityMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.RelativeHumidityMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRelativeHumidityMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.RelativeHumidityMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRelativeHumidityMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.RelativeHumidityMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRelativeHumidityMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.RelativeHumidityMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRelativeHumidityMeasurementClusterEventListAttributeCallback implements ChipClusters.RelativeHumidityMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRelativeHumidityMeasurementClusterAttributeListAttributeCallback implements ChipClusters.RelativeHumidityMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedOccupancySensingClusterGeneratedCommandListAttributeCallback implements ChipClusters.OccupancySensingCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOccupancySensingClusterAcceptedCommandListAttributeCallback implements ChipClusters.OccupancySensingCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOccupancySensingClusterEventListAttributeCallback implements ChipClusters.OccupancySensingCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOccupancySensingClusterAttributeListAttributeCallback implements ChipClusters.OccupancySensingCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedCarbonMonoxideConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonMonoxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonMonoxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonMonoxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonMonoxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonMonoxideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonMonoxideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonMonoxideConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonMonoxideConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.CarbonMonoxideConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedCarbonDioxideConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.CarbonDioxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonDioxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.CarbonDioxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonDioxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.CarbonDioxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonDioxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.CarbonDioxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonDioxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.CarbonDioxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonDioxideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.CarbonDioxideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonDioxideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.CarbonDioxideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonDioxideConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.CarbonDioxideConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCarbonDioxideConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.CarbonDioxideConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedEthyleneConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.EthyleneConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.EthyleneConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.EthyleneConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.EthyleneConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.EthyleneConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.EthyleneConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.EthyleneConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.EthyleneConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.EthyleneConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedEthyleneOxideConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.EthyleneOxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneOxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.EthyleneOxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneOxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.EthyleneOxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneOxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.EthyleneOxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneOxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.EthyleneOxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneOxideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.EthyleneOxideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneOxideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.EthyleneOxideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneOxideConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.EthyleneOxideConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedEthyleneOxideConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.EthyleneOxideConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedHydrogenConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.HydrogenConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.HydrogenConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.HydrogenConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.HydrogenConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.HydrogenConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.HydrogenConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.HydrogenConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.HydrogenConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.HydrogenConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedHydrogenSulfideConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenSulfideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenSulfideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenSulfideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenSulfideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenSulfideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenSulfideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenSulfideConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHydrogenSulfideConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.HydrogenSulfideConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedNitricOxideConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.NitricOxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitricOxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.NitricOxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitricOxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.NitricOxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitricOxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.NitricOxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitricOxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.NitricOxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitricOxideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.NitricOxideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitricOxideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.NitricOxideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitricOxideConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.NitricOxideConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitricOxideConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.NitricOxideConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedNitrogenDioxideConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitrogenDioxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitrogenDioxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitrogenDioxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitrogenDioxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitrogenDioxideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitrogenDioxideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitrogenDioxideConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedNitrogenDioxideConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.NitrogenDioxideConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedOxygenConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.OxygenConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOxygenConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.OxygenConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOxygenConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.OxygenConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOxygenConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.OxygenConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOxygenConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.OxygenConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOxygenConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.OxygenConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOxygenConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.OxygenConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOxygenConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.OxygenConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOxygenConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.OxygenConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedOzoneConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.OzoneConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOzoneConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.OzoneConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOzoneConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.OzoneConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOzoneConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.OzoneConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOzoneConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.OzoneConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOzoneConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.OzoneConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOzoneConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.OzoneConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOzoneConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.OzoneConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedOzoneConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.OzoneConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedSulfurDioxideConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.SulfurDioxideConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfurDioxideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.SulfurDioxideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfurDioxideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.SulfurDioxideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfurDioxideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.SulfurDioxideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfurDioxideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.SulfurDioxideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfurDioxideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.SulfurDioxideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfurDioxideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.SulfurDioxideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfurDioxideConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.SulfurDioxideConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfurDioxideConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.SulfurDioxideConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedDissolvedOxygenConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.DissolvedOxygenConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDissolvedOxygenConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.DissolvedOxygenConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDissolvedOxygenConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.DissolvedOxygenConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDissolvedOxygenConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.DissolvedOxygenConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDissolvedOxygenConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.DissolvedOxygenConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDissolvedOxygenConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.DissolvedOxygenConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDissolvedOxygenConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.DissolvedOxygenConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDissolvedOxygenConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.DissolvedOxygenConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedDissolvedOxygenConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.DissolvedOxygenConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedBromateConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.BromateConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromateConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.BromateConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromateConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.BromateConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromateConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.BromateConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromateConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.BromateConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromateConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.BromateConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromateConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.BromateConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromateConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.BromateConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromateConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.BromateConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedChloraminesConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.ChloraminesConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloraminesConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.ChloraminesConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloraminesConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.ChloraminesConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloraminesConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.ChloraminesConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloraminesConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.ChloraminesConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloraminesConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.ChloraminesConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloraminesConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.ChloraminesConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloraminesConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.ChloraminesConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloraminesConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.ChloraminesConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedChlorineConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.ChlorineConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorineConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.ChlorineConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorineConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.ChlorineConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorineConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.ChlorineConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorineConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.ChlorineConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorineConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.ChlorineConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorineConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.ChlorineConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorineConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.ChlorineConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorineConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.ChlorineConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedFecalColiformEColiConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.FecalColiformEColiConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFecalColiformEColiConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.FecalColiformEColiConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFecalColiformEColiConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.FecalColiformEColiConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFecalColiformEColiConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.FecalColiformEColiConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFecalColiformEColiConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.FecalColiformEColiConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFecalColiformEColiConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.FecalColiformEColiConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFecalColiformEColiConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.FecalColiformEColiConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFecalColiformEColiConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.FecalColiformEColiConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFecalColiformEColiConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.FecalColiformEColiConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedFluorideConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.FluorideConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFluorideConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.FluorideConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFluorideConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.FluorideConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFluorideConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.FluorideConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFluorideConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.FluorideConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFluorideConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.FluorideConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFluorideConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.FluorideConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFluorideConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.FluorideConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFluorideConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.FluorideConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedHaloaceticAcidsConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.HaloaceticAcidsConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHaloaceticAcidsConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.HaloaceticAcidsConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHaloaceticAcidsConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.HaloaceticAcidsConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHaloaceticAcidsConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.HaloaceticAcidsConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHaloaceticAcidsConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.HaloaceticAcidsConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHaloaceticAcidsConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.HaloaceticAcidsConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHaloaceticAcidsConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.HaloaceticAcidsConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHaloaceticAcidsConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.HaloaceticAcidsConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedHaloaceticAcidsConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.HaloaceticAcidsConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedTotalTrihalomethanesConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.TotalTrihalomethanesConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalTrihalomethanesConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.TotalTrihalomethanesConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalTrihalomethanesConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.TotalTrihalomethanesConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalTrihalomethanesConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.TotalTrihalomethanesConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalTrihalomethanesConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.TotalTrihalomethanesConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalTrihalomethanesConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.TotalTrihalomethanesConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalTrihalomethanesConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.TotalTrihalomethanesConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalTrihalomethanesConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.TotalTrihalomethanesConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalTrihalomethanesConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.TotalTrihalomethanesConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedTotalColiformBacteriaConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.TotalColiformBacteriaConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalColiformBacteriaConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.TotalColiformBacteriaConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalColiformBacteriaConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.TotalColiformBacteriaConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalColiformBacteriaConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.TotalColiformBacteriaConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalColiformBacteriaConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.TotalColiformBacteriaConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalColiformBacteriaConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.TotalColiformBacteriaConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalColiformBacteriaConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.TotalColiformBacteriaConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalColiformBacteriaConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.TotalColiformBacteriaConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalColiformBacteriaConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.TotalColiformBacteriaConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedTurbidityConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.TurbidityConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTurbidityConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.TurbidityConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTurbidityConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.TurbidityConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTurbidityConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.TurbidityConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTurbidityConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.TurbidityConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTurbidityConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.TurbidityConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTurbidityConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.TurbidityConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTurbidityConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.TurbidityConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTurbidityConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.TurbidityConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedCopperConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.CopperConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCopperConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.CopperConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCopperConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.CopperConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCopperConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.CopperConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCopperConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.CopperConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCopperConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.CopperConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCopperConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.CopperConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCopperConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.CopperConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedCopperConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.CopperConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedLeadConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.LeadConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLeadConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.LeadConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLeadConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.LeadConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLeadConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.LeadConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLeadConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.LeadConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLeadConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.LeadConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLeadConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.LeadConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLeadConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.LeadConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLeadConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.LeadConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedManganeseConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.ManganeseConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedManganeseConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.ManganeseConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedManganeseConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.ManganeseConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedManganeseConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.ManganeseConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedManganeseConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.ManganeseConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedManganeseConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.ManganeseConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedManganeseConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.ManganeseConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedManganeseConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.ManganeseConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedManganeseConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.ManganeseConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedSulfateConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.SulfateConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfateConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.SulfateConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfateConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.SulfateConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfateConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.SulfateConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfateConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.SulfateConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfateConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.SulfateConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfateConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.SulfateConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfateConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.SulfateConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSulfateConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.SulfateConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedBromodichloromethaneConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.BromodichloromethaneConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromodichloromethaneConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.BromodichloromethaneConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromodichloromethaneConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.BromodichloromethaneConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromodichloromethaneConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.BromodichloromethaneConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromodichloromethaneConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.BromodichloromethaneConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromodichloromethaneConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.BromodichloromethaneConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromodichloromethaneConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.BromodichloromethaneConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromodichloromethaneConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.BromodichloromethaneConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromodichloromethaneConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.BromodichloromethaneConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedBromoformConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.BromoformConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromoformConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.BromoformConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromoformConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.BromoformConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromoformConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.BromoformConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromoformConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.BromoformConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromoformConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.BromoformConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromoformConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.BromoformConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromoformConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.BromoformConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedBromoformConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.BromoformConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedChlorodibromomethaneConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.ChlorodibromomethaneConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorodibromomethaneConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.ChlorodibromomethaneConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorodibromomethaneConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.ChlorodibromomethaneConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorodibromomethaneConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.ChlorodibromomethaneConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorodibromomethaneConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.ChlorodibromomethaneConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorodibromomethaneConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.ChlorodibromomethaneConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorodibromomethaneConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.ChlorodibromomethaneConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorodibromomethaneConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.ChlorodibromomethaneConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChlorodibromomethaneConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.ChlorodibromomethaneConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedChloroformConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.ChloroformConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloroformConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.ChloroformConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloroformConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.ChloroformConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloroformConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.ChloroformConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloroformConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.ChloroformConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloroformConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.ChloroformConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloroformConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.ChloroformConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloroformConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.ChloroformConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChloroformConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.ChloroformConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedSodiumConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.SodiumConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSodiumConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.SodiumConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSodiumConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.SodiumConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSodiumConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.SodiumConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSodiumConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.SodiumConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSodiumConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.SodiumConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSodiumConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.SodiumConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSodiumConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.SodiumConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedSodiumConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.SodiumConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedPm25ConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.Pm25ConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm25ConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.Pm25ConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm25ConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.Pm25ConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm25ConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.Pm25ConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm25ConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.Pm25ConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm25ConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.Pm25ConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm25ConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.Pm25ConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm25ConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.Pm25ConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm25ConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.Pm25ConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedFormaldehydeConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.FormaldehydeConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFormaldehydeConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.FormaldehydeConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFormaldehydeConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.FormaldehydeConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFormaldehydeConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.FormaldehydeConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFormaldehydeConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.FormaldehydeConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFormaldehydeConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.FormaldehydeConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFormaldehydeConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.FormaldehydeConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFormaldehydeConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.FormaldehydeConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFormaldehydeConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.FormaldehydeConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedPm1ConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.Pm1ConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm1ConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.Pm1ConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm1ConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.Pm1ConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm1ConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.Pm1ConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm1ConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.Pm1ConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm1ConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.Pm1ConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm1ConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.Pm1ConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm1ConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.Pm1ConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm1ConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.Pm1ConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedPm10ConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.Pm10ConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm10ConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.Pm10ConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm10ConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.Pm10ConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm10ConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.Pm10ConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm10ConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.Pm10ConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm10ConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.Pm10ConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm10ConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.Pm10ConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm10ConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.Pm10ConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedPm10ConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.Pm10ConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedTotalVolatileOrganicCompoundsConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.TotalVolatileOrganicCompoundsConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalVolatileOrganicCompoundsConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.TotalVolatileOrganicCompoundsConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalVolatileOrganicCompoundsConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.TotalVolatileOrganicCompoundsConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalVolatileOrganicCompoundsConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.TotalVolatileOrganicCompoundsConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalVolatileOrganicCompoundsConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.TotalVolatileOrganicCompoundsConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalVolatileOrganicCompoundsConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.TotalVolatileOrganicCompoundsConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalVolatileOrganicCompoundsConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.TotalVolatileOrganicCompoundsConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalVolatileOrganicCompoundsConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.TotalVolatileOrganicCompoundsConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTotalVolatileOrganicCompoundsConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.TotalVolatileOrganicCompoundsConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedRadonConcentrationMeasurementClusterMeasuredValueAttributeCallback implements ChipClusters.RadonConcentrationMeasurementCluster.MeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRadonConcentrationMeasurementClusterMinMeasuredValueAttributeCallback implements ChipClusters.RadonConcentrationMeasurementCluster.MinMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRadonConcentrationMeasurementClusterMaxMeasuredValueAttributeCallback implements ChipClusters.RadonConcentrationMeasurementCluster.MaxMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRadonConcentrationMeasurementClusterPeakMeasuredValueAttributeCallback implements ChipClusters.RadonConcentrationMeasurementCluster.PeakMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRadonConcentrationMeasurementClusterAverageMeasuredValueAttributeCallback implements ChipClusters.RadonConcentrationMeasurementCluster.AverageMeasuredValueAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRadonConcentrationMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.RadonConcentrationMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRadonConcentrationMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.RadonConcentrationMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRadonConcentrationMeasurementClusterEventListAttributeCallback implements ChipClusters.RadonConcentrationMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedRadonConcentrationMeasurementClusterAttributeListAttributeCallback implements ChipClusters.RadonConcentrationMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedWakeOnLanClusterGeneratedCommandListAttributeCallback implements ChipClusters.WakeOnLanCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWakeOnLanClusterAcceptedCommandListAttributeCallback implements ChipClusters.WakeOnLanCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWakeOnLanClusterEventListAttributeCallback implements ChipClusters.WakeOnLanCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedWakeOnLanClusterAttributeListAttributeCallback implements ChipClusters.WakeOnLanCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedChannelClusterChangeChannelResponseCallback implements ChipClusters.ChannelCluster.ChangeChannelResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Optional<String> Data) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo DataResponseValue = new CommandResponseInfo("Data", "Optional<String>");
               responseValues.put(DataResponseValue, Data);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedChannelClusterChannelListAttributeCallback implements ChipClusters.ChannelCluster.ChannelListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.ChannelClusterChannelInfoStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.ChannelClusterChannelInfoStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChannelClusterGeneratedCommandListAttributeCallback implements ChipClusters.ChannelCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChannelClusterAcceptedCommandListAttributeCallback implements ChipClusters.ChannelCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChannelClusterEventListAttributeCallback implements ChipClusters.ChannelCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedChannelClusterAttributeListAttributeCallback implements ChipClusters.ChannelCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedTargetNavigatorClusterNavigateTargetResponseCallback implements ChipClusters.TargetNavigatorCluster.NavigateTargetResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Optional<String> Data) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo DataResponseValue = new CommandResponseInfo("Data", "Optional<String>");
               responseValues.put(DataResponseValue, Data);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedTargetNavigatorClusterTargetListAttributeCallback implements ChipClusters.TargetNavigatorCluster.TargetListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.TargetNavigatorClusterTargetInfoStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.TargetNavigatorClusterTargetInfoStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTargetNavigatorClusterGeneratedCommandListAttributeCallback implements ChipClusters.TargetNavigatorCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTargetNavigatorClusterAcceptedCommandListAttributeCallback implements ChipClusters.TargetNavigatorCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTargetNavigatorClusterEventListAttributeCallback implements ChipClusters.TargetNavigatorCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedTargetNavigatorClusterAttributeListAttributeCallback implements ChipClusters.TargetNavigatorCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedMediaPlaybackClusterPlaybackResponseCallback implements ChipClusters.MediaPlaybackCluster.PlaybackResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Optional<String> Data) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo DataResponseValue = new CommandResponseInfo("Data", "Optional<String>");
               responseValues.put(DataResponseValue, Data);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedMediaPlaybackClusterStartTimeAttributeCallback implements ChipClusters.MediaPlaybackCluster.StartTimeAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedMediaPlaybackClusterDurationAttributeCallback implements ChipClusters.MediaPlaybackCluster.DurationAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedMediaPlaybackClusterSeekRangeEndAttributeCallback implements ChipClusters.MediaPlaybackCluster.SeekRangeEndAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedMediaPlaybackClusterSeekRangeStartAttributeCallback implements ChipClusters.MediaPlaybackCluster.SeekRangeStartAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedMediaPlaybackClusterGeneratedCommandListAttributeCallback implements ChipClusters.MediaPlaybackCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedMediaPlaybackClusterAcceptedCommandListAttributeCallback implements ChipClusters.MediaPlaybackCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedMediaPlaybackClusterEventListAttributeCallback implements ChipClusters.MediaPlaybackCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedMediaPlaybackClusterAttributeListAttributeCallback implements ChipClusters.MediaPlaybackCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedMediaInputClusterInputListAttributeCallback implements ChipClusters.MediaInputCluster.InputListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.MediaInputClusterInputInfoStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.MediaInputClusterInputInfoStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedMediaInputClusterGeneratedCommandListAttributeCallback implements ChipClusters.MediaInputCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedMediaInputClusterAcceptedCommandListAttributeCallback implements ChipClusters.MediaInputCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedMediaInputClusterEventListAttributeCallback implements ChipClusters.MediaInputCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedMediaInputClusterAttributeListAttributeCallback implements ChipClusters.MediaInputCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedLowPowerClusterGeneratedCommandListAttributeCallback implements ChipClusters.LowPowerCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLowPowerClusterAcceptedCommandListAttributeCallback implements ChipClusters.LowPowerCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLowPowerClusterEventListAttributeCallback implements ChipClusters.LowPowerCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedLowPowerClusterAttributeListAttributeCallback implements ChipClusters.LowPowerCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedKeypadInputClusterSendKeyResponseCallback implements ChipClusters.KeypadInputCluster.SendKeyResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedKeypadInputClusterGeneratedCommandListAttributeCallback implements ChipClusters.KeypadInputCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedKeypadInputClusterAcceptedCommandListAttributeCallback implements ChipClusters.KeypadInputCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedKeypadInputClusterEventListAttributeCallback implements ChipClusters.KeypadInputCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedKeypadInputClusterAttributeListAttributeCallback implements ChipClusters.KeypadInputCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedContentLauncherClusterLauncherResponseCallback implements ChipClusters.ContentLauncherCluster.LauncherResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Optional<String> Data) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo DataResponseValue = new CommandResponseInfo("Data", "Optional<String>");
               responseValues.put(DataResponseValue, Data);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedContentLauncherClusterAcceptHeaderAttributeCallback implements ChipClusters.ContentLauncherCluster.AcceptHeaderAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<String> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<String>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedContentLauncherClusterGeneratedCommandListAttributeCallback implements ChipClusters.ContentLauncherCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedContentLauncherClusterAcceptedCommandListAttributeCallback implements ChipClusters.ContentLauncherCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedContentLauncherClusterEventListAttributeCallback implements ChipClusters.ContentLauncherCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedContentLauncherClusterAttributeListAttributeCallback implements ChipClusters.ContentLauncherCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedAudioOutputClusterOutputListAttributeCallback implements ChipClusters.AudioOutputCluster.OutputListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.AudioOutputClusterOutputInfoStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.AudioOutputClusterOutputInfoStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAudioOutputClusterGeneratedCommandListAttributeCallback implements ChipClusters.AudioOutputCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAudioOutputClusterAcceptedCommandListAttributeCallback implements ChipClusters.AudioOutputCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAudioOutputClusterEventListAttributeCallback implements ChipClusters.AudioOutputCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAudioOutputClusterAttributeListAttributeCallback implements ChipClusters.AudioOutputCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedApplicationLauncherClusterLauncherResponseCallback implements ChipClusters.ApplicationLauncherCluster.LauncherResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer Status, Optional<byte[]> Data) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo StatusResponseValue = new CommandResponseInfo("Status", "Integer");
               responseValues.put(StatusResponseValue, Status);
               CommandResponseInfo DataResponseValue = new CommandResponseInfo("Data", "Optional<byte[]>");
               responseValues.put(DataResponseValue, Data);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedApplicationLauncherClusterCatalogListAttributeCallback implements ChipClusters.ApplicationLauncherCluster.CatalogListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedApplicationLauncherClusterGeneratedCommandListAttributeCallback implements ChipClusters.ApplicationLauncherCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedApplicationLauncherClusterAcceptedCommandListAttributeCallback implements ChipClusters.ApplicationLauncherCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedApplicationLauncherClusterEventListAttributeCallback implements ChipClusters.ApplicationLauncherCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedApplicationLauncherClusterAttributeListAttributeCallback implements ChipClusters.ApplicationLauncherCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedApplicationBasicClusterAllowedVendorListAttributeCallback implements ChipClusters.ApplicationBasicCluster.AllowedVendorListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedApplicationBasicClusterGeneratedCommandListAttributeCallback implements ChipClusters.ApplicationBasicCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedApplicationBasicClusterAcceptedCommandListAttributeCallback implements ChipClusters.ApplicationBasicCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedApplicationBasicClusterEventListAttributeCallback implements ChipClusters.ApplicationBasicCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedApplicationBasicClusterAttributeListAttributeCallback implements ChipClusters.ApplicationBasicCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedAccountLoginClusterGetSetupPINResponseCallback implements ChipClusters.AccountLoginCluster.GetSetupPINResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(String SetupPIN) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo SetupPINResponseValue = new CommandResponseInfo("SetupPIN", "String");
               responseValues.put(SetupPINResponseValue, SetupPIN);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedAccountLoginClusterGeneratedCommandListAttributeCallback implements ChipClusters.AccountLoginCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAccountLoginClusterAcceptedCommandListAttributeCallback implements ChipClusters.AccountLoginCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAccountLoginClusterEventListAttributeCallback implements ChipClusters.AccountLoginCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedAccountLoginClusterAttributeListAttributeCallback implements ChipClusters.AccountLoginCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedElectricalMeasurementClusterGeneratedCommandListAttributeCallback implements ChipClusters.ElectricalMeasurementCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedElectricalMeasurementClusterAcceptedCommandListAttributeCallback implements ChipClusters.ElectricalMeasurementCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedElectricalMeasurementClusterEventListAttributeCallback implements ChipClusters.ElectricalMeasurementCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedElectricalMeasurementClusterAttributeListAttributeCallback implements ChipClusters.ElectricalMeasurementCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedUnitTestingClusterTestSpecificResponseCallback implements ChipClusters.UnitTestingCluster.TestSpecificResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer returnValue) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo returnValueResponseValue = new CommandResponseInfo("returnValue", "Integer");
               responseValues.put(returnValueResponseValue, returnValue);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedUnitTestingClusterTestAddArgumentsResponseCallback implements ChipClusters.UnitTestingCluster.TestAddArgumentsResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer returnValue) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo returnValueResponseValue = new CommandResponseInfo("returnValue", "Integer");
               responseValues.put(returnValueResponseValue, returnValue);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedUnitTestingClusterTestListInt8UReverseResponseCallback implements ChipClusters.UnitTestingCluster.TestListInt8UReverseResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(ArrayList<Integer> arg1) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               // arg1: /* TYPE WARNING: array array defaults to */ uint8_t * 
               // Conversion from this type to Java is not properly implemented yet
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedUnitTestingClusterTestEnumsResponseCallback implements ChipClusters.UnitTestingCluster.TestEnumsResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Integer arg1, Integer arg2) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo arg1ResponseValue = new CommandResponseInfo("arg1", "Integer");
               responseValues.put(arg1ResponseValue, arg1);
               CommandResponseInfo arg2ResponseValue = new CommandResponseInfo("arg2", "Integer");
               responseValues.put(arg2ResponseValue, arg2);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedUnitTestingClusterTestNullableOptionalResponseCallback implements ChipClusters.UnitTestingCluster.TestNullableOptionalResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Boolean wasPresent, Optional<Boolean> wasNull, Optional<Integer> value, @Nullable Optional<Integer> originalValue) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo wasPresentResponseValue = new CommandResponseInfo("wasPresent", "Boolean");
               responseValues.put(wasPresentResponseValue, wasPresent);
               CommandResponseInfo wasNullResponseValue = new CommandResponseInfo("wasNull", "Optional<Boolean>");
               responseValues.put(wasNullResponseValue, wasNull);
               CommandResponseInfo valueResponseValue = new CommandResponseInfo("value", "Optional<Integer>");
               responseValues.put(valueResponseValue, value);
               CommandResponseInfo originalValueResponseValue = new CommandResponseInfo("originalValue", "Optional<Integer>");
               responseValues.put(originalValueResponseValue, originalValue);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedUnitTestingClusterBooleanResponseCallback implements ChipClusters.UnitTestingCluster.BooleanResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Boolean value) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo valueResponseValue = new CommandResponseInfo("value", "Boolean");
               responseValues.put(valueResponseValue, value);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedUnitTestingClusterSimpleStructResponseCallback implements ChipClusters.UnitTestingCluster.SimpleStructResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(ChipStructs.UnitTestingClusterSimpleStruct arg1) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               // arg1: Struct SimpleStruct
               // Conversion from this type to Java is not properly implemented yet
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedUnitTestingClusterTestEmitTestEventResponseCallback implements ChipClusters.UnitTestingCluster.TestEmitTestEventResponseCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

        @Override
        public void onSuccess(Long value) {
           Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
               CommandResponseInfo valueResponseValue = new CommandResponseInfo("value", "Long");
               responseValues.put(valueResponseValue, value);
           callback.onSuccess(responseValues);
        }

        @Override
        public void onError(Exception error) {
          callback.onFailure(error);
        }
      }

      public static class DelegatedUnitTestingClusterListInt8uAttributeCallback implements ChipClusters.UnitTestingCluster.ListInt8uAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Integer> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Integer>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterListOctetStringAttributeCallback implements ChipClusters.UnitTestingCluster.ListOctetStringAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<byte[]> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<byte[]>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterListStructOctetStringAttributeCallback implements ChipClusters.UnitTestingCluster.ListStructOctetStringAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.UnitTestingClusterTestListStructOctet> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.UnitTestingClusterTestListStructOctet>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterListNullablesAndOptionalsStructAttributeCallback implements ChipClusters.UnitTestingCluster.ListNullablesAndOptionalsStructAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.UnitTestingClusterNullablesAndOptionalsStruct> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.UnitTestingClusterNullablesAndOptionalsStruct>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterListLongOctetStringAttributeCallback implements ChipClusters.UnitTestingCluster.ListLongOctetStringAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<byte[]> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<byte[]>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterListFabricScopedAttributeCallback implements ChipClusters.UnitTestingCluster.ListFabricScopedAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<ChipStructs.UnitTestingClusterTestFabricScoped> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<ChipStructs.UnitTestingClusterTestFabricScoped>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableBooleanAttributeCallback implements ChipClusters.UnitTestingCluster.NullableBooleanAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Boolean value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Boolean");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableBitmap8AttributeCallback implements ChipClusters.UnitTestingCluster.NullableBitmap8AttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableBitmap16AttributeCallback implements ChipClusters.UnitTestingCluster.NullableBitmap16AttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableBitmap32AttributeCallback implements ChipClusters.UnitTestingCluster.NullableBitmap32AttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableBitmap64AttributeCallback implements ChipClusters.UnitTestingCluster.NullableBitmap64AttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt8uAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt8uAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt16uAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt16uAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt24uAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt24uAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt32uAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt32uAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt40uAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt40uAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt48uAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt48uAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt56uAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt56uAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt64uAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt64uAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt8sAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt8sAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt16sAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt16sAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt24sAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt24sAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt32sAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt32sAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt40sAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt40sAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt48sAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt48sAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt56sAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt56sAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableInt64sAttributeCallback implements ChipClusters.UnitTestingCluster.NullableInt64sAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Long value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Long");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableEnum8AttributeCallback implements ChipClusters.UnitTestingCluster.NullableEnum8AttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableEnum16AttributeCallback implements ChipClusters.UnitTestingCluster.NullableEnum16AttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableFloatSingleAttributeCallback implements ChipClusters.UnitTestingCluster.NullableFloatSingleAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Float value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Float");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableFloatDoubleAttributeCallback implements ChipClusters.UnitTestingCluster.NullableFloatDoubleAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Double value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Double");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableOctetStringAttributeCallback implements ChipClusters.UnitTestingCluster.NullableOctetStringAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable byte[] value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "byte[]");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableCharStringAttributeCallback implements ChipClusters.UnitTestingCluster.NullableCharStringAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable String value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "String");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableEnumAttrAttributeCallback implements ChipClusters.UnitTestingCluster.NullableEnumAttrAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableRangeRestrictedInt8uAttributeCallback implements ChipClusters.UnitTestingCluster.NullableRangeRestrictedInt8uAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableRangeRestrictedInt8sAttributeCallback implements ChipClusters.UnitTestingCluster.NullableRangeRestrictedInt8sAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableRangeRestrictedInt16uAttributeCallback implements ChipClusters.UnitTestingCluster.NullableRangeRestrictedInt16uAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterNullableRangeRestrictedInt16sAttributeCallback implements ChipClusters.UnitTestingCluster.NullableRangeRestrictedInt16sAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess(@Nullable Integer value) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("value", "Integer");
          responseValues.put(commandResponseInfo, value);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterGeneratedCommandListAttributeCallback implements ChipClusters.UnitTestingCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterAcceptedCommandListAttributeCallback implements ChipClusters.UnitTestingCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterEventListAttributeCallback implements ChipClusters.UnitTestingCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedUnitTestingClusterAttributeListAttributeCallback implements ChipClusters.UnitTestingCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }

      public static class DelegatedFaultInjectionClusterGeneratedCommandListAttributeCallback implements ChipClusters.FaultInjectionCluster.GeneratedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFaultInjectionClusterAcceptedCommandListAttributeCallback implements ChipClusters.FaultInjectionCluster.AcceptedCommandListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFaultInjectionClusterEventListAttributeCallback implements ChipClusters.FaultInjectionCluster.EventListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }
      public static class DelegatedFaultInjectionClusterAttributeListAttributeCallback implements ChipClusters.FaultInjectionCluster.AttributeListAttributeCallback, DelegatedClusterCallback {
        private ClusterCommandCallback callback;
        @Override
        public void setCallbackDelegate(ClusterCommandCallback callback) {
          this.callback = callback;
        }

@Override
        public void onSuccess( List<Long> valueList) {
          Map<CommandResponseInfo, Object> responseValues = new LinkedHashMap<>();
          CommandResponseInfo commandResponseInfo = new CommandResponseInfo("valueList", "List<Long>");
          responseValues.put(commandResponseInfo, valueList);
          callback.onSuccess(responseValues);
        }
        @Override
        public void onError(Exception ex) {
          callback.onFailure(ex);
        }
      }


 public Map<String, ClusterInfo> getClusterMap() {
    Map<String, ClusterInfo> clusterMap = initializeClusterMap();
    Map<String, Map<String, InteractionInfo>> commandMap = getCommandMap();
    combineCommand(clusterMap, commandMap);
    Map<String, Map<String, InteractionInfo>> readAttributeMap = new ClusterReadMapping().getReadAttributeMap();
    combineCommand(clusterMap, readAttributeMap);
    Map<String, Map<String, InteractionInfo>> writeAttributeMap = new ClusterWriteMapping().getWriteAttributeMap();
    combineCommand(clusterMap, writeAttributeMap);
    return clusterMap;
 }

 public Map<String, ClusterInfo> initializeClusterMap() {
    Map<String, ClusterInfo> clusterMap = new HashMap<>();
      ClusterInfo identifyClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.IdentifyCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("identify", identifyClusterInfo);
      ClusterInfo groupsClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.GroupsCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("groups", groupsClusterInfo);
      ClusterInfo scenesClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ScenesCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("scenes", scenesClusterInfo);
      ClusterInfo onOffClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.OnOffCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("onOff", onOffClusterInfo);
      ClusterInfo onOffSwitchConfigurationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.OnOffSwitchConfigurationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("onOffSwitchConfiguration", onOffSwitchConfigurationClusterInfo);
      ClusterInfo levelControlClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.LevelControlCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("levelControl", levelControlClusterInfo);
      ClusterInfo binaryInputBasicClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.BinaryInputBasicCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("binaryInputBasic", binaryInputBasicClusterInfo);
      ClusterInfo pulseWidthModulationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.PulseWidthModulationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("pulseWidthModulation", pulseWidthModulationClusterInfo);
      ClusterInfo descriptorClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.DescriptorCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("descriptor", descriptorClusterInfo);
      ClusterInfo bindingClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.BindingCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("binding", bindingClusterInfo);
      ClusterInfo accessControlClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.AccessControlCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("accessControl", accessControlClusterInfo);
      ClusterInfo actionsClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ActionsCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("actions", actionsClusterInfo);
      ClusterInfo basicInformationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.BasicInformationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("basicInformation", basicInformationClusterInfo);
      ClusterInfo otaSoftwareUpdateProviderClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.OtaSoftwareUpdateProviderCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("otaSoftwareUpdateProvider", otaSoftwareUpdateProviderClusterInfo);
      ClusterInfo otaSoftwareUpdateRequestorClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.OtaSoftwareUpdateRequestorCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("otaSoftwareUpdateRequestor", otaSoftwareUpdateRequestorClusterInfo);
      ClusterInfo localizationConfigurationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.LocalizationConfigurationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("localizationConfiguration", localizationConfigurationClusterInfo);
      ClusterInfo timeFormatLocalizationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.TimeFormatLocalizationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("timeFormatLocalization", timeFormatLocalizationClusterInfo);
      ClusterInfo unitLocalizationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.UnitLocalizationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("unitLocalization", unitLocalizationClusterInfo);
      ClusterInfo powerSourceConfigurationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.PowerSourceConfigurationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("powerSourceConfiguration", powerSourceConfigurationClusterInfo);
      ClusterInfo powerSourceClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.PowerSourceCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("powerSource", powerSourceClusterInfo);
      ClusterInfo generalCommissioningClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.GeneralCommissioningCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("generalCommissioning", generalCommissioningClusterInfo);
      ClusterInfo networkCommissioningClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.NetworkCommissioningCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("networkCommissioning", networkCommissioningClusterInfo);
      ClusterInfo diagnosticLogsClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.DiagnosticLogsCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("diagnosticLogs", diagnosticLogsClusterInfo);
      ClusterInfo generalDiagnosticsClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.GeneralDiagnosticsCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("generalDiagnostics", generalDiagnosticsClusterInfo);
      ClusterInfo softwareDiagnosticsClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.SoftwareDiagnosticsCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("softwareDiagnostics", softwareDiagnosticsClusterInfo);
      ClusterInfo threadNetworkDiagnosticsClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ThreadNetworkDiagnosticsCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("threadNetworkDiagnostics", threadNetworkDiagnosticsClusterInfo);
      ClusterInfo wiFiNetworkDiagnosticsClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.WiFiNetworkDiagnosticsCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("wiFiNetworkDiagnostics", wiFiNetworkDiagnosticsClusterInfo);
      ClusterInfo ethernetNetworkDiagnosticsClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.EthernetNetworkDiagnosticsCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("ethernetNetworkDiagnostics", ethernetNetworkDiagnosticsClusterInfo);
      ClusterInfo timeSynchronizationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.TimeSynchronizationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("timeSynchronization", timeSynchronizationClusterInfo);
      ClusterInfo bridgedDeviceBasicInformationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.BridgedDeviceBasicInformationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("bridgedDeviceBasicInformation", bridgedDeviceBasicInformationClusterInfo);
      ClusterInfo switchClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.SwitchCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("switch", switchClusterInfo);
      ClusterInfo administratorCommissioningClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.AdministratorCommissioningCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("administratorCommissioning", administratorCommissioningClusterInfo);
      ClusterInfo operationalCredentialsClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.OperationalCredentialsCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("operationalCredentials", operationalCredentialsClusterInfo);
      ClusterInfo groupKeyManagementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.GroupKeyManagementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("groupKeyManagement", groupKeyManagementClusterInfo);
      ClusterInfo fixedLabelClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.FixedLabelCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("fixedLabel", fixedLabelClusterInfo);
      ClusterInfo userLabelClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.UserLabelCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("userLabel", userLabelClusterInfo);
      ClusterInfo proxyConfigurationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ProxyConfigurationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("proxyConfiguration", proxyConfigurationClusterInfo);
      ClusterInfo proxyDiscoveryClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ProxyDiscoveryCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("proxyDiscovery", proxyDiscoveryClusterInfo);
      ClusterInfo proxyValidClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ProxyValidCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("proxyValid", proxyValidClusterInfo);
      ClusterInfo booleanStateClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.BooleanStateCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("booleanState", booleanStateClusterInfo);
      ClusterInfo icdManagementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.IcdManagementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("icdManagement", icdManagementClusterInfo);
      ClusterInfo modeSelectClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ModeSelectCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("modeSelect", modeSelectClusterInfo);
      ClusterInfo temperatureControlClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.TemperatureControlCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("temperatureControl", temperatureControlClusterInfo);
      ClusterInfo refrigeratorAlarmClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.RefrigeratorAlarmCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("refrigeratorAlarm", refrigeratorAlarmClusterInfo);
      ClusterInfo airQualityClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.AirQualityCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("airQuality", airQualityClusterInfo);
      ClusterInfo smokeCoAlarmClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.SmokeCoAlarmCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("smokeCoAlarm", smokeCoAlarmClusterInfo);
      ClusterInfo operationalStateClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.OperationalStateCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("operationalState", operationalStateClusterInfo);
      ClusterInfo hepaFilterMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.HepaFilterMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("hepaFilterMonitoring", hepaFilterMonitoringClusterInfo);
      ClusterInfo activatedCarbonFilterMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ActivatedCarbonFilterMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("activatedCarbonFilterMonitoring", activatedCarbonFilterMonitoringClusterInfo);
      ClusterInfo ceramicFilterMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.CeramicFilterMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("ceramicFilterMonitoring", ceramicFilterMonitoringClusterInfo);
      ClusterInfo electrostaticFilterMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ElectrostaticFilterMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("electrostaticFilterMonitoring", electrostaticFilterMonitoringClusterInfo);
      ClusterInfo uvFilterMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.UvFilterMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("uvFilterMonitoring", uvFilterMonitoringClusterInfo);
      ClusterInfo ionizingFilterMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.IonizingFilterMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("ionizingFilterMonitoring", ionizingFilterMonitoringClusterInfo);
      ClusterInfo zeoliteFilterMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ZeoliteFilterMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("zeoliteFilterMonitoring", zeoliteFilterMonitoringClusterInfo);
      ClusterInfo ozoneFilterMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.OzoneFilterMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("ozoneFilterMonitoring", ozoneFilterMonitoringClusterInfo);
      ClusterInfo waterTankMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.WaterTankMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("waterTankMonitoring", waterTankMonitoringClusterInfo);
      ClusterInfo fuelTankMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.FuelTankMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("fuelTankMonitoring", fuelTankMonitoringClusterInfo);
      ClusterInfo inkCartridgeMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.InkCartridgeMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("inkCartridgeMonitoring", inkCartridgeMonitoringClusterInfo);
      ClusterInfo tonerCartridgeMonitoringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.TonerCartridgeMonitoringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("tonerCartridgeMonitoring", tonerCartridgeMonitoringClusterInfo);
      ClusterInfo doorLockClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.DoorLockCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("doorLock", doorLockClusterInfo);
      ClusterInfo windowCoveringClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.WindowCoveringCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("windowCovering", windowCoveringClusterInfo);
      ClusterInfo barrierControlClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.BarrierControlCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("barrierControl", barrierControlClusterInfo);
      ClusterInfo pumpConfigurationAndControlClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.PumpConfigurationAndControlCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("pumpConfigurationAndControl", pumpConfigurationAndControlClusterInfo);
      ClusterInfo thermostatClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ThermostatCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("thermostat", thermostatClusterInfo);
      ClusterInfo fanControlClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.FanControlCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("fanControl", fanControlClusterInfo);
      ClusterInfo thermostatUserInterfaceConfigurationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ThermostatUserInterfaceConfigurationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("thermostatUserInterfaceConfiguration", thermostatUserInterfaceConfigurationClusterInfo);
      ClusterInfo colorControlClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ColorControlCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("colorControl", colorControlClusterInfo);
      ClusterInfo ballastConfigurationClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.BallastConfigurationCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("ballastConfiguration", ballastConfigurationClusterInfo);
      ClusterInfo illuminanceMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.IlluminanceMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("illuminanceMeasurement", illuminanceMeasurementClusterInfo);
      ClusterInfo temperatureMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.TemperatureMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("temperatureMeasurement", temperatureMeasurementClusterInfo);
      ClusterInfo pressureMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.PressureMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("pressureMeasurement", pressureMeasurementClusterInfo);
      ClusterInfo flowMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.FlowMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("flowMeasurement", flowMeasurementClusterInfo);
      ClusterInfo relativeHumidityMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.RelativeHumidityMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("relativeHumidityMeasurement", relativeHumidityMeasurementClusterInfo);
      ClusterInfo occupancySensingClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.OccupancySensingCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("occupancySensing", occupancySensingClusterInfo);
      ClusterInfo carbonMonoxideConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.CarbonMonoxideConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("carbonMonoxideConcentrationMeasurement", carbonMonoxideConcentrationMeasurementClusterInfo);
      ClusterInfo carbonDioxideConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.CarbonDioxideConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("carbonDioxideConcentrationMeasurement", carbonDioxideConcentrationMeasurementClusterInfo);
      ClusterInfo ethyleneConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.EthyleneConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("ethyleneConcentrationMeasurement", ethyleneConcentrationMeasurementClusterInfo);
      ClusterInfo ethyleneOxideConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.EthyleneOxideConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("ethyleneOxideConcentrationMeasurement", ethyleneOxideConcentrationMeasurementClusterInfo);
      ClusterInfo hydrogenConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.HydrogenConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("hydrogenConcentrationMeasurement", hydrogenConcentrationMeasurementClusterInfo);
      ClusterInfo hydrogenSulfideConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.HydrogenSulfideConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("hydrogenSulfideConcentrationMeasurement", hydrogenSulfideConcentrationMeasurementClusterInfo);
      ClusterInfo nitricOxideConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.NitricOxideConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("nitricOxideConcentrationMeasurement", nitricOxideConcentrationMeasurementClusterInfo);
      ClusterInfo nitrogenDioxideConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.NitrogenDioxideConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("nitrogenDioxideConcentrationMeasurement", nitrogenDioxideConcentrationMeasurementClusterInfo);
      ClusterInfo oxygenConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.OxygenConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("oxygenConcentrationMeasurement", oxygenConcentrationMeasurementClusterInfo);
      ClusterInfo ozoneConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.OzoneConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("ozoneConcentrationMeasurement", ozoneConcentrationMeasurementClusterInfo);
      ClusterInfo sulfurDioxideConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.SulfurDioxideConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("sulfurDioxideConcentrationMeasurement", sulfurDioxideConcentrationMeasurementClusterInfo);
      ClusterInfo dissolvedOxygenConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.DissolvedOxygenConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("dissolvedOxygenConcentrationMeasurement", dissolvedOxygenConcentrationMeasurementClusterInfo);
      ClusterInfo bromateConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.BromateConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("bromateConcentrationMeasurement", bromateConcentrationMeasurementClusterInfo);
      ClusterInfo chloraminesConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ChloraminesConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("chloraminesConcentrationMeasurement", chloraminesConcentrationMeasurementClusterInfo);
      ClusterInfo chlorineConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ChlorineConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("chlorineConcentrationMeasurement", chlorineConcentrationMeasurementClusterInfo);
      ClusterInfo fecalColiformEColiConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.FecalColiformEColiConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("fecalColiformEColiConcentrationMeasurement", fecalColiformEColiConcentrationMeasurementClusterInfo);
      ClusterInfo fluorideConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.FluorideConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("fluorideConcentrationMeasurement", fluorideConcentrationMeasurementClusterInfo);
      ClusterInfo haloaceticAcidsConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.HaloaceticAcidsConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("haloaceticAcidsConcentrationMeasurement", haloaceticAcidsConcentrationMeasurementClusterInfo);
      ClusterInfo totalTrihalomethanesConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.TotalTrihalomethanesConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("totalTrihalomethanesConcentrationMeasurement", totalTrihalomethanesConcentrationMeasurementClusterInfo);
      ClusterInfo totalColiformBacteriaConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.TotalColiformBacteriaConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("totalColiformBacteriaConcentrationMeasurement", totalColiformBacteriaConcentrationMeasurementClusterInfo);
      ClusterInfo turbidityConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.TurbidityConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("turbidityConcentrationMeasurement", turbidityConcentrationMeasurementClusterInfo);
      ClusterInfo copperConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.CopperConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("copperConcentrationMeasurement", copperConcentrationMeasurementClusterInfo);
      ClusterInfo leadConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.LeadConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("leadConcentrationMeasurement", leadConcentrationMeasurementClusterInfo);
      ClusterInfo manganeseConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ManganeseConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("manganeseConcentrationMeasurement", manganeseConcentrationMeasurementClusterInfo);
      ClusterInfo sulfateConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.SulfateConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("sulfateConcentrationMeasurement", sulfateConcentrationMeasurementClusterInfo);
      ClusterInfo bromodichloromethaneConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.BromodichloromethaneConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("bromodichloromethaneConcentrationMeasurement", bromodichloromethaneConcentrationMeasurementClusterInfo);
      ClusterInfo bromoformConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.BromoformConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("bromoformConcentrationMeasurement", bromoformConcentrationMeasurementClusterInfo);
      ClusterInfo chlorodibromomethaneConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ChlorodibromomethaneConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("chlorodibromomethaneConcentrationMeasurement", chlorodibromomethaneConcentrationMeasurementClusterInfo);
      ClusterInfo chloroformConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ChloroformConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("chloroformConcentrationMeasurement", chloroformConcentrationMeasurementClusterInfo);
      ClusterInfo sodiumConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.SodiumConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("sodiumConcentrationMeasurement", sodiumConcentrationMeasurementClusterInfo);
      ClusterInfo pm25ConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.Pm25ConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("pm25ConcentrationMeasurement", pm25ConcentrationMeasurementClusterInfo);
      ClusterInfo formaldehydeConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.FormaldehydeConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("formaldehydeConcentrationMeasurement", formaldehydeConcentrationMeasurementClusterInfo);
      ClusterInfo pm1ConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.Pm1ConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("pm1ConcentrationMeasurement", pm1ConcentrationMeasurementClusterInfo);
      ClusterInfo pm10ConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.Pm10ConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("pm10ConcentrationMeasurement", pm10ConcentrationMeasurementClusterInfo);
      ClusterInfo totalVolatileOrganicCompoundsConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.TotalVolatileOrganicCompoundsConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("totalVolatileOrganicCompoundsConcentrationMeasurement", totalVolatileOrganicCompoundsConcentrationMeasurementClusterInfo);
      ClusterInfo radonConcentrationMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.RadonConcentrationMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("radonConcentrationMeasurement", radonConcentrationMeasurementClusterInfo);
      ClusterInfo wakeOnLanClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.WakeOnLanCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("wakeOnLan", wakeOnLanClusterInfo);
      ClusterInfo channelClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ChannelCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("channel", channelClusterInfo);
      ClusterInfo targetNavigatorClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.TargetNavigatorCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("targetNavigator", targetNavigatorClusterInfo);
      ClusterInfo mediaPlaybackClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.MediaPlaybackCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("mediaPlayback", mediaPlaybackClusterInfo);
      ClusterInfo mediaInputClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.MediaInputCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("mediaInput", mediaInputClusterInfo);
      ClusterInfo lowPowerClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.LowPowerCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("lowPower", lowPowerClusterInfo);
      ClusterInfo keypadInputClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.KeypadInputCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("keypadInput", keypadInputClusterInfo);
      ClusterInfo contentLauncherClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ContentLauncherCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("contentLauncher", contentLauncherClusterInfo);
      ClusterInfo audioOutputClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.AudioOutputCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("audioOutput", audioOutputClusterInfo);
      ClusterInfo applicationLauncherClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ApplicationLauncherCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("applicationLauncher", applicationLauncherClusterInfo);
      ClusterInfo applicationBasicClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ApplicationBasicCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("applicationBasic", applicationBasicClusterInfo);
      ClusterInfo accountLoginClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.AccountLoginCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("accountLogin", accountLoginClusterInfo);
      ClusterInfo electricalMeasurementClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.ElectricalMeasurementCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("electricalMeasurement", electricalMeasurementClusterInfo);
      ClusterInfo unitTestingClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.UnitTestingCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("unitTesting", unitTestingClusterInfo);
      ClusterInfo faultInjectionClusterInfo = new ClusterInfo(
        (ptr, endpointId) -> new ChipClusters.FaultInjectionCluster(ptr, endpointId), new HashMap<>());
      clusterMap.put("faultInjection", faultInjectionClusterInfo);
    return clusterMap;
 }

 public void combineCommand(Map<String, ClusterInfo> destination, Map<String, Map<String, InteractionInfo>> source) {
      destination.get("identify").combineCommands(source.get("identify"));
      destination.get("groups").combineCommands(source.get("groups"));
      destination.get("scenes").combineCommands(source.get("scenes"));
      destination.get("onOff").combineCommands(source.get("onOff"));
      destination.get("onOffSwitchConfiguration").combineCommands(source.get("onOffSwitchConfiguration"));
      destination.get("levelControl").combineCommands(source.get("levelControl"));
      destination.get("binaryInputBasic").combineCommands(source.get("binaryInputBasic"));
      destination.get("pulseWidthModulation").combineCommands(source.get("pulseWidthModulation"));
      destination.get("descriptor").combineCommands(source.get("descriptor"));
      destination.get("binding").combineCommands(source.get("binding"));
      destination.get("accessControl").combineCommands(source.get("accessControl"));
      destination.get("actions").combineCommands(source.get("actions"));
      destination.get("basicInformation").combineCommands(source.get("basicInformation"));
      destination.get("otaSoftwareUpdateProvider").combineCommands(source.get("otaSoftwareUpdateProvider"));
      destination.get("otaSoftwareUpdateRequestor").combineCommands(source.get("otaSoftwareUpdateRequestor"));
      destination.get("localizationConfiguration").combineCommands(source.get("localizationConfiguration"));
      destination.get("timeFormatLocalization").combineCommands(source.get("timeFormatLocalization"));
      destination.get("unitLocalization").combineCommands(source.get("unitLocalization"));
      destination.get("powerSourceConfiguration").combineCommands(source.get("powerSourceConfiguration"));
      destination.get("powerSource").combineCommands(source.get("powerSource"));
      destination.get("generalCommissioning").combineCommands(source.get("generalCommissioning"));
      destination.get("networkCommissioning").combineCommands(source.get("networkCommissioning"));
      destination.get("diagnosticLogs").combineCommands(source.get("diagnosticLogs"));
      destination.get("generalDiagnostics").combineCommands(source.get("generalDiagnostics"));
      destination.get("softwareDiagnostics").combineCommands(source.get("softwareDiagnostics"));
      destination.get("threadNetworkDiagnostics").combineCommands(source.get("threadNetworkDiagnostics"));
      destination.get("wiFiNetworkDiagnostics").combineCommands(source.get("wiFiNetworkDiagnostics"));
      destination.get("ethernetNetworkDiagnostics").combineCommands(source.get("ethernetNetworkDiagnostics"));
      destination.get("timeSynchronization").combineCommands(source.get("timeSynchronization"));
      destination.get("bridgedDeviceBasicInformation").combineCommands(source.get("bridgedDeviceBasicInformation"));
      destination.get("switch").combineCommands(source.get("switch"));
      destination.get("administratorCommissioning").combineCommands(source.get("administratorCommissioning"));
      destination.get("operationalCredentials").combineCommands(source.get("operationalCredentials"));
      destination.get("groupKeyManagement").combineCommands(source.get("groupKeyManagement"));
      destination.get("fixedLabel").combineCommands(source.get("fixedLabel"));
      destination.get("userLabel").combineCommands(source.get("userLabel"));
      destination.get("proxyConfiguration").combineCommands(source.get("proxyConfiguration"));
      destination.get("proxyDiscovery").combineCommands(source.get("proxyDiscovery"));
      destination.get("proxyValid").combineCommands(source.get("proxyValid"));
      destination.get("booleanState").combineCommands(source.get("booleanState"));
      destination.get("icdManagement").combineCommands(source.get("icdManagement"));
      destination.get("modeSelect").combineCommands(source.get("modeSelect"));
      destination.get("temperatureControl").combineCommands(source.get("temperatureControl"));
      destination.get("refrigeratorAlarm").combineCommands(source.get("refrigeratorAlarm"));
      destination.get("airQuality").combineCommands(source.get("airQuality"));
      destination.get("smokeCoAlarm").combineCommands(source.get("smokeCoAlarm"));
      destination.get("operationalState").combineCommands(source.get("operationalState"));
      destination.get("hepaFilterMonitoring").combineCommands(source.get("hepaFilterMonitoring"));
      destination.get("activatedCarbonFilterMonitoring").combineCommands(source.get("activatedCarbonFilterMonitoring"));
      destination.get("ceramicFilterMonitoring").combineCommands(source.get("ceramicFilterMonitoring"));
      destination.get("electrostaticFilterMonitoring").combineCommands(source.get("electrostaticFilterMonitoring"));
      destination.get("uvFilterMonitoring").combineCommands(source.get("uvFilterMonitoring"));
      destination.get("ionizingFilterMonitoring").combineCommands(source.get("ionizingFilterMonitoring"));
      destination.get("zeoliteFilterMonitoring").combineCommands(source.get("zeoliteFilterMonitoring"));
      destination.get("ozoneFilterMonitoring").combineCommands(source.get("ozoneFilterMonitoring"));
      destination.get("waterTankMonitoring").combineCommands(source.get("waterTankMonitoring"));
      destination.get("fuelTankMonitoring").combineCommands(source.get("fuelTankMonitoring"));
      destination.get("inkCartridgeMonitoring").combineCommands(source.get("inkCartridgeMonitoring"));
      destination.get("tonerCartridgeMonitoring").combineCommands(source.get("tonerCartridgeMonitoring"));
      destination.get("doorLock").combineCommands(source.get("doorLock"));
      destination.get("windowCovering").combineCommands(source.get("windowCovering"));
      destination.get("barrierControl").combineCommands(source.get("barrierControl"));
      destination.get("pumpConfigurationAndControl").combineCommands(source.get("pumpConfigurationAndControl"));
      destination.get("thermostat").combineCommands(source.get("thermostat"));
      destination.get("fanControl").combineCommands(source.get("fanControl"));
      destination.get("thermostatUserInterfaceConfiguration").combineCommands(source.get("thermostatUserInterfaceConfiguration"));
      destination.get("colorControl").combineCommands(source.get("colorControl"));
      destination.get("ballastConfiguration").combineCommands(source.get("ballastConfiguration"));
      destination.get("illuminanceMeasurement").combineCommands(source.get("illuminanceMeasurement"));
      destination.get("temperatureMeasurement").combineCommands(source.get("temperatureMeasurement"));
      destination.get("pressureMeasurement").combineCommands(source.get("pressureMeasurement"));
      destination.get("flowMeasurement").combineCommands(source.get("flowMeasurement"));
      destination.get("relativeHumidityMeasurement").combineCommands(source.get("relativeHumidityMeasurement"));
      destination.get("occupancySensing").combineCommands(source.get("occupancySensing"));
      destination.get("carbonMonoxideConcentrationMeasurement").combineCommands(source.get("carbonMonoxideConcentrationMeasurement"));
      destination.get("carbonDioxideConcentrationMeasurement").combineCommands(source.get("carbonDioxideConcentrationMeasurement"));
      destination.get("ethyleneConcentrationMeasurement").combineCommands(source.get("ethyleneConcentrationMeasurement"));
      destination.get("ethyleneOxideConcentrationMeasurement").combineCommands(source.get("ethyleneOxideConcentrationMeasurement"));
      destination.get("hydrogenConcentrationMeasurement").combineCommands(source.get("hydrogenConcentrationMeasurement"));
      destination.get("hydrogenSulfideConcentrationMeasurement").combineCommands(source.get("hydrogenSulfideConcentrationMeasurement"));
      destination.get("nitricOxideConcentrationMeasurement").combineCommands(source.get("nitricOxideConcentrationMeasurement"));
      destination.get("nitrogenDioxideConcentrationMeasurement").combineCommands(source.get("nitrogenDioxideConcentrationMeasurement"));
      destination.get("oxygenConcentrationMeasurement").combineCommands(source.get("oxygenConcentrationMeasurement"));
      destination.get("ozoneConcentrationMeasurement").combineCommands(source.get("ozoneConcentrationMeasurement"));
      destination.get("sulfurDioxideConcentrationMeasurement").combineCommands(source.get("sulfurDioxideConcentrationMeasurement"));
      destination.get("dissolvedOxygenConcentrationMeasurement").combineCommands(source.get("dissolvedOxygenConcentrationMeasurement"));
      destination.get("bromateConcentrationMeasurement").combineCommands(source.get("bromateConcentrationMeasurement"));
      destination.get("chloraminesConcentrationMeasurement").combineCommands(source.get("chloraminesConcentrationMeasurement"));
      destination.get("chlorineConcentrationMeasurement").combineCommands(source.get("chlorineConcentrationMeasurement"));
      destination.get("fecalColiformEColiConcentrationMeasurement").combineCommands(source.get("fecalColiformEColiConcentrationMeasurement"));
      destination.get("fluorideConcentrationMeasurement").combineCommands(source.get("fluorideConcentrationMeasurement"));
      destination.get("haloaceticAcidsConcentrationMeasurement").combineCommands(source.get("haloaceticAcidsConcentrationMeasurement"));
      destination.get("totalTrihalomethanesConcentrationMeasurement").combineCommands(source.get("totalTrihalomethanesConcentrationMeasurement"));
      destination.get("totalColiformBacteriaConcentrationMeasurement").combineCommands(source.get("totalColiformBacteriaConcentrationMeasurement"));
      destination.get("turbidityConcentrationMeasurement").combineCommands(source.get("turbidityConcentrationMeasurement"));
      destination.get("copperConcentrationMeasurement").combineCommands(source.get("copperConcentrationMeasurement"));
      destination.get("leadConcentrationMeasurement").combineCommands(source.get("leadConcentrationMeasurement"));
      destination.get("manganeseConcentrationMeasurement").combineCommands(source.get("manganeseConcentrationMeasurement"));
      destination.get("sulfateConcentrationMeasurement").combineCommands(source.get("sulfateConcentrationMeasurement"));
      destination.get("bromodichloromethaneConcentrationMeasurement").combineCommands(source.get("bromodichloromethaneConcentrationMeasurement"));
      destination.get("bromoformConcentrationMeasurement").combineCommands(source.get("bromoformConcentrationMeasurement"));
      destination.get("chlorodibromomethaneConcentrationMeasurement").combineCommands(source.get("chlorodibromomethaneConcentrationMeasurement"));
      destination.get("chloroformConcentrationMeasurement").combineCommands(source.get("chloroformConcentrationMeasurement"));
      destination.get("sodiumConcentrationMeasurement").combineCommands(source.get("sodiumConcentrationMeasurement"));
      destination.get("pm25ConcentrationMeasurement").combineCommands(source.get("pm25ConcentrationMeasurement"));
      destination.get("formaldehydeConcentrationMeasurement").combineCommands(source.get("formaldehydeConcentrationMeasurement"));
      destination.get("pm1ConcentrationMeasurement").combineCommands(source.get("pm1ConcentrationMeasurement"));
      destination.get("pm10ConcentrationMeasurement").combineCommands(source.get("pm10ConcentrationMeasurement"));
      destination.get("totalVolatileOrganicCompoundsConcentrationMeasurement").combineCommands(source.get("totalVolatileOrganicCompoundsConcentrationMeasurement"));
      destination.get("radonConcentrationMeasurement").combineCommands(source.get("radonConcentrationMeasurement"));
      destination.get("wakeOnLan").combineCommands(source.get("wakeOnLan"));
      destination.get("channel").combineCommands(source.get("channel"));
      destination.get("targetNavigator").combineCommands(source.get("targetNavigator"));
      destination.get("mediaPlayback").combineCommands(source.get("mediaPlayback"));
      destination.get("mediaInput").combineCommands(source.get("mediaInput"));
      destination.get("lowPower").combineCommands(source.get("lowPower"));
      destination.get("keypadInput").combineCommands(source.get("keypadInput"));
      destination.get("contentLauncher").combineCommands(source.get("contentLauncher"));
      destination.get("audioOutput").combineCommands(source.get("audioOutput"));
      destination.get("applicationLauncher").combineCommands(source.get("applicationLauncher"));
      destination.get("applicationBasic").combineCommands(source.get("applicationBasic"));
      destination.get("accountLogin").combineCommands(source.get("accountLogin"));
      destination.get("electricalMeasurement").combineCommands(source.get("electricalMeasurement"));
      destination.get("unitTesting").combineCommands(source.get("unitTesting"));
      destination.get("faultInjection").combineCommands(source.get("faultInjection"));
 }

 @SuppressWarnings("unchecked")
 public Map<String, Map<String, InteractionInfo>> getCommandMap() {
     Map<String, Map<String, InteractionInfo>> commandMap = new HashMap<>();
     Map<String, InteractionInfo> identifyClusterInteractionInfoMap = new LinkedHashMap<>();
     Map<String, CommandParameterInfo> identifyidentifyCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo identifyidentifyidentifyTimeCommandParameterInfo = new CommandParameterInfo("identifyTime", Integer.class, Integer.class);
       identifyidentifyCommandParams.put("identifyTime",identifyidentifyidentifyTimeCommandParameterInfo);
     
       InteractionInfo identifyidentifyInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.IdentifyCluster) cluster)
           .identify((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("identifyTime")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           identifyidentifyCommandParams
       );
       identifyClusterInteractionInfoMap.put("identify", identifyidentifyInteractionInfo);
     Map<String, CommandParameterInfo> identifytriggerEffectCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo identifytriggerEffecteffectIdentifierCommandParameterInfo = new CommandParameterInfo("effectIdentifier", Integer.class, Integer.class);
       identifytriggerEffectCommandParams.put("effectIdentifier",identifytriggerEffecteffectIdentifierCommandParameterInfo);
      
       CommandParameterInfo identifytriggerEffecteffectVariantCommandParameterInfo = new CommandParameterInfo("effectVariant", Integer.class, Integer.class);
       identifytriggerEffectCommandParams.put("effectVariant",identifytriggerEffecteffectVariantCommandParameterInfo);
     
       InteractionInfo identifytriggerEffectInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.IdentifyCluster) cluster)
           .triggerEffect((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("effectIdentifier")
           , (Integer)
           commandArguments.get("effectVariant")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           identifytriggerEffectCommandParams
       );
       identifyClusterInteractionInfoMap.put("triggerEffect", identifytriggerEffectInteractionInfo);
     commandMap.put("identify", identifyClusterInteractionInfoMap);
     Map<String, InteractionInfo> groupsClusterInteractionInfoMap = new LinkedHashMap<>();
     Map<String, CommandParameterInfo> groupsaddGroupCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo groupsaddGroupgroupIDCommandParameterInfo = new CommandParameterInfo("groupID", Integer.class, Integer.class);
       groupsaddGroupCommandParams.put("groupID",groupsaddGroupgroupIDCommandParameterInfo);
      
       CommandParameterInfo groupsaddGroupgroupNameCommandParameterInfo = new CommandParameterInfo("groupName", String.class, String.class);
       groupsaddGroupCommandParams.put("groupName",groupsaddGroupgroupNameCommandParameterInfo);
     
       InteractionInfo groupsaddGroupInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.GroupsCluster) cluster)
           .addGroup((ChipClusters.GroupsCluster.AddGroupResponseCallback) callback
           , (Integer)
           commandArguments.get("groupID")
           , (String)
           commandArguments.get("groupName")
           
           );
         },
         () -> new DelegatedGroupsClusterAddGroupResponseCallback(),
           groupsaddGroupCommandParams
       );
       groupsClusterInteractionInfoMap.put("addGroup", groupsaddGroupInteractionInfo);
     Map<String, CommandParameterInfo> groupsviewGroupCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo groupsviewGroupgroupIDCommandParameterInfo = new CommandParameterInfo("groupID", Integer.class, Integer.class);
       groupsviewGroupCommandParams.put("groupID",groupsviewGroupgroupIDCommandParameterInfo);
     
       InteractionInfo groupsviewGroupInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.GroupsCluster) cluster)
           .viewGroup((ChipClusters.GroupsCluster.ViewGroupResponseCallback) callback
           , (Integer)
           commandArguments.get("groupID")
           
           );
         },
         () -> new DelegatedGroupsClusterViewGroupResponseCallback(),
           groupsviewGroupCommandParams
       );
       groupsClusterInteractionInfoMap.put("viewGroup", groupsviewGroupInteractionInfo);
     Map<String, CommandParameterInfo> groupsgetGroupMembershipCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo groupsgetGroupMembershipgroupListCommandParameterInfo = new CommandParameterInfo("groupList", ArrayList.class, Integer.class);
       groupsgetGroupMembershipCommandParams.put("groupList",groupsgetGroupMembershipgroupListCommandParameterInfo);
     
       InteractionInfo groupsgetGroupMembershipInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.GroupsCluster) cluster)
           .getGroupMembership((ChipClusters.GroupsCluster.GetGroupMembershipResponseCallback) callback
           , (ArrayList<Integer>)
           commandArguments.get("groupList")
           
           );
         },
         () -> new DelegatedGroupsClusterGetGroupMembershipResponseCallback(),
           groupsgetGroupMembershipCommandParams
       );
       groupsClusterInteractionInfoMap.put("getGroupMembership", groupsgetGroupMembershipInteractionInfo);
     Map<String, CommandParameterInfo> groupsremoveGroupCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo groupsremoveGroupgroupIDCommandParameterInfo = new CommandParameterInfo("groupID", Integer.class, Integer.class);
       groupsremoveGroupCommandParams.put("groupID",groupsremoveGroupgroupIDCommandParameterInfo);
     
       InteractionInfo groupsremoveGroupInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.GroupsCluster) cluster)
           .removeGroup((ChipClusters.GroupsCluster.RemoveGroupResponseCallback) callback
           , (Integer)
           commandArguments.get("groupID")
           
           );
         },
         () -> new DelegatedGroupsClusterRemoveGroupResponseCallback(),
           groupsremoveGroupCommandParams
       );
       groupsClusterInteractionInfoMap.put("removeGroup", groupsremoveGroupInteractionInfo);
     Map<String, CommandParameterInfo> groupsremoveAllGroupsCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       InteractionInfo groupsremoveAllGroupsInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.GroupsCluster) cluster)
           .removeAllGroups((DefaultClusterCallback) callback
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           groupsremoveAllGroupsCommandParams
       );
       groupsClusterInteractionInfoMap.put("removeAllGroups", groupsremoveAllGroupsInteractionInfo);
     Map<String, CommandParameterInfo> groupsaddGroupIfIdentifyingCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo groupsaddGroupIfIdentifyinggroupIDCommandParameterInfo = new CommandParameterInfo("groupID", Integer.class, Integer.class);
       groupsaddGroupIfIdentifyingCommandParams.put("groupID",groupsaddGroupIfIdentifyinggroupIDCommandParameterInfo);
      
       CommandParameterInfo groupsaddGroupIfIdentifyinggroupNameCommandParameterInfo = new CommandParameterInfo("groupName", String.class, String.class);
       groupsaddGroupIfIdentifyingCommandParams.put("groupName",groupsaddGroupIfIdentifyinggroupNameCommandParameterInfo);
     
       InteractionInfo groupsaddGroupIfIdentifyingInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.GroupsCluster) cluster)
           .addGroupIfIdentifying((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("groupID")
           , (String)
           commandArguments.get("groupName")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           groupsaddGroupIfIdentifyingCommandParams
       );
       groupsClusterInteractionInfoMap.put("addGroupIfIdentifying", groupsaddGroupIfIdentifyingInteractionInfo);
     commandMap.put("groups", groupsClusterInteractionInfoMap);
     Map<String, InteractionInfo> scenesClusterInteractionInfoMap = new LinkedHashMap<>();
     Map<String, CommandParameterInfo> scenesaddSceneCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo scenesaddScenegroupIDCommandParameterInfo = new CommandParameterInfo("groupID", Integer.class, Integer.class);
       scenesaddSceneCommandParams.put("groupID",scenesaddScenegroupIDCommandParameterInfo);
      
       CommandParameterInfo scenesaddScenesceneIDCommandParameterInfo = new CommandParameterInfo("sceneID", Integer.class, Integer.class);
       scenesaddSceneCommandParams.put("sceneID",scenesaddScenesceneIDCommandParameterInfo);
      
       CommandParameterInfo scenesaddScenetransitionTimeCommandParameterInfo = new CommandParameterInfo("transitionTime", Integer.class, Integer.class);
       scenesaddSceneCommandParams.put("transitionTime",scenesaddScenetransitionTimeCommandParameterInfo);
      
       CommandParameterInfo scenesaddScenesceneNameCommandParameterInfo = new CommandParameterInfo("sceneName", String.class, String.class);
       scenesaddSceneCommandParams.put("sceneName",scenesaddScenesceneNameCommandParameterInfo);
      
       InteractionInfo scenesaddSceneInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ScenesCluster) cluster)
           .addScene((ChipClusters.ScenesCluster.AddSceneResponseCallback) callback
           , (Integer)
           commandArguments.get("groupID")
           , (Integer)
           commandArguments.get("sceneID")
           , (Integer)
           commandArguments.get("transitionTime")
           , (String)
           commandArguments.get("sceneName")
           , (ArrayList<ChipStructs.ScenesClusterExtensionFieldSet>)
           commandArguments.get("extensionFieldSets")
           
           );
         },
         () -> new DelegatedScenesClusterAddSceneResponseCallback(),
           scenesaddSceneCommandParams
       );
       scenesClusterInteractionInfoMap.put("addScene", scenesaddSceneInteractionInfo);
     Map<String, CommandParameterInfo> scenesviewSceneCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo scenesviewScenegroupIDCommandParameterInfo = new CommandParameterInfo("groupID", Integer.class, Integer.class);
       scenesviewSceneCommandParams.put("groupID",scenesviewScenegroupIDCommandParameterInfo);
      
       CommandParameterInfo scenesviewScenesceneIDCommandParameterInfo = new CommandParameterInfo("sceneID", Integer.class, Integer.class);
       scenesviewSceneCommandParams.put("sceneID",scenesviewScenesceneIDCommandParameterInfo);
     
       InteractionInfo scenesviewSceneInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ScenesCluster) cluster)
           .viewScene((ChipClusters.ScenesCluster.ViewSceneResponseCallback) callback
           , (Integer)
           commandArguments.get("groupID")
           , (Integer)
           commandArguments.get("sceneID")
           
           );
         },
         () -> new DelegatedScenesClusterViewSceneResponseCallback(),
           scenesviewSceneCommandParams
       );
       scenesClusterInteractionInfoMap.put("viewScene", scenesviewSceneInteractionInfo);
     Map<String, CommandParameterInfo> scenesremoveSceneCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo scenesremoveScenegroupIDCommandParameterInfo = new CommandParameterInfo("groupID", Integer.class, Integer.class);
       scenesremoveSceneCommandParams.put("groupID",scenesremoveScenegroupIDCommandParameterInfo);
      
       CommandParameterInfo scenesremoveScenesceneIDCommandParameterInfo = new CommandParameterInfo("sceneID", Integer.class, Integer.class);
       scenesremoveSceneCommandParams.put("sceneID",scenesremoveScenesceneIDCommandParameterInfo);
     
       InteractionInfo scenesremoveSceneInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ScenesCluster) cluster)
           .removeScene((ChipClusters.ScenesCluster.RemoveSceneResponseCallback) callback
           , (Integer)
           commandArguments.get("groupID")
           , (Integer)
           commandArguments.get("sceneID")
           
           );
         },
         () -> new DelegatedScenesClusterRemoveSceneResponseCallback(),
           scenesremoveSceneCommandParams
       );
       scenesClusterInteractionInfoMap.put("removeScene", scenesremoveSceneInteractionInfo);
     Map<String, CommandParameterInfo> scenesremoveAllScenesCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo scenesremoveAllScenesgroupIDCommandParameterInfo = new CommandParameterInfo("groupID", Integer.class, Integer.class);
       scenesremoveAllScenesCommandParams.put("groupID",scenesremoveAllScenesgroupIDCommandParameterInfo);
     
       InteractionInfo scenesremoveAllScenesInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ScenesCluster) cluster)
           .removeAllScenes((ChipClusters.ScenesCluster.RemoveAllScenesResponseCallback) callback
           , (Integer)
           commandArguments.get("groupID")
           
           );
         },
         () -> new DelegatedScenesClusterRemoveAllScenesResponseCallback(),
           scenesremoveAllScenesCommandParams
       );
       scenesClusterInteractionInfoMap.put("removeAllScenes", scenesremoveAllScenesInteractionInfo);
     Map<String, CommandParameterInfo> scenesstoreSceneCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo scenesstoreScenegroupIDCommandParameterInfo = new CommandParameterInfo("groupID", Integer.class, Integer.class);
       scenesstoreSceneCommandParams.put("groupID",scenesstoreScenegroupIDCommandParameterInfo);
      
       CommandParameterInfo scenesstoreScenesceneIDCommandParameterInfo = new CommandParameterInfo("sceneID", Integer.class, Integer.class);
       scenesstoreSceneCommandParams.put("sceneID",scenesstoreScenesceneIDCommandParameterInfo);
     
       InteractionInfo scenesstoreSceneInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ScenesCluster) cluster)
           .storeScene((ChipClusters.ScenesCluster.StoreSceneResponseCallback) callback
           , (Integer)
           commandArguments.get("groupID")
           , (Integer)
           commandArguments.get("sceneID")
           
           );
         },
         () -> new DelegatedScenesClusterStoreSceneResponseCallback(),
           scenesstoreSceneCommandParams
       );
       scenesClusterInteractionInfoMap.put("storeScene", scenesstoreSceneInteractionInfo);
     Map<String, CommandParameterInfo> scenesrecallSceneCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo scenesrecallScenegroupIDCommandParameterInfo = new CommandParameterInfo("groupID", Integer.class, Integer.class);
       scenesrecallSceneCommandParams.put("groupID",scenesrecallScenegroupIDCommandParameterInfo);
      
       CommandParameterInfo scenesrecallScenesceneIDCommandParameterInfo = new CommandParameterInfo("sceneID", Integer.class, Integer.class);
       scenesrecallSceneCommandParams.put("sceneID",scenesrecallScenesceneIDCommandParameterInfo);
      
       CommandParameterInfo scenesrecallScenetransitionTimeCommandParameterInfo = new CommandParameterInfo("transitionTime", Optional.class, Integer.class);
       scenesrecallSceneCommandParams.put("transitionTime",scenesrecallScenetransitionTimeCommandParameterInfo);
     
       InteractionInfo scenesrecallSceneInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ScenesCluster) cluster)
           .recallScene((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("groupID")
           , (Integer)
           commandArguments.get("sceneID")
           , (Optional<Integer>)
           commandArguments.get("transitionTime")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           scenesrecallSceneCommandParams
       );
       scenesClusterInteractionInfoMap.put("recallScene", scenesrecallSceneInteractionInfo);
     Map<String, CommandParameterInfo> scenesgetSceneMembershipCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo scenesgetSceneMembershipgroupIDCommandParameterInfo = new CommandParameterInfo("groupID", Integer.class, Integer.class);
       scenesgetSceneMembershipCommandParams.put("groupID",scenesgetSceneMembershipgroupIDCommandParameterInfo);
     
       InteractionInfo scenesgetSceneMembershipInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ScenesCluster) cluster)
           .getSceneMembership((ChipClusters.ScenesCluster.GetSceneMembershipResponseCallback) callback
           , (Integer)
           commandArguments.get("groupID")
           
           );
         },
         () -> new DelegatedScenesClusterGetSceneMembershipResponseCallback(),
           scenesgetSceneMembershipCommandParams
       );
       scenesClusterInteractionInfoMap.put("getSceneMembership", scenesgetSceneMembershipInteractionInfo);
     commandMap.put("scenes", scenesClusterInteractionInfoMap);
     Map<String, InteractionInfo> onOffClusterInteractionInfoMap = new LinkedHashMap<>();
     Map<String, CommandParameterInfo> onOffoffCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       InteractionInfo onOffoffInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.OnOffCluster) cluster)
           .off((DefaultClusterCallback) callback
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           onOffoffCommandParams
       );
       onOffClusterInteractionInfoMap.put("off", onOffoffInteractionInfo);
     Map<String, CommandParameterInfo> onOffonCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       InteractionInfo onOffonInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.OnOffCluster) cluster)
           .on((DefaultClusterCallback) callback
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           onOffonCommandParams
       );
       onOffClusterInteractionInfoMap.put("on", onOffonInteractionInfo);
     Map<String, CommandParameterInfo> onOfftoggleCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       InteractionInfo onOfftoggleInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.OnOffCluster) cluster)
           .toggle((DefaultClusterCallback) callback
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           onOfftoggleCommandParams
       );
       onOffClusterInteractionInfoMap.put("toggle", onOfftoggleInteractionInfo);
     Map<String, CommandParameterInfo> onOffoffWithEffectCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo onOffoffWithEffecteffectIdentifierCommandParameterInfo = new CommandParameterInfo("effectIdentifier", Integer.class, Integer.class);
       onOffoffWithEffectCommandParams.put("effectIdentifier",onOffoffWithEffecteffectIdentifierCommandParameterInfo);
      
       CommandParameterInfo onOffoffWithEffecteffectVariantCommandParameterInfo = new CommandParameterInfo("effectVariant", Integer.class, Integer.class);
       onOffoffWithEffectCommandParams.put("effectVariant",onOffoffWithEffecteffectVariantCommandParameterInfo);
     
       InteractionInfo onOffoffWithEffectInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.OnOffCluster) cluster)
           .offWithEffect((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("effectIdentifier")
           , (Integer)
           commandArguments.get("effectVariant")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           onOffoffWithEffectCommandParams
       );
       onOffClusterInteractionInfoMap.put("offWithEffect", onOffoffWithEffectInteractionInfo);
     Map<String, CommandParameterInfo> onOffonWithRecallGlobalSceneCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       InteractionInfo onOffonWithRecallGlobalSceneInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.OnOffCluster) cluster)
           .onWithRecallGlobalScene((DefaultClusterCallback) callback
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           onOffonWithRecallGlobalSceneCommandParams
       );
       onOffClusterInteractionInfoMap.put("onWithRecallGlobalScene", onOffonWithRecallGlobalSceneInteractionInfo);
     Map<String, CommandParameterInfo> onOffonWithTimedOffCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo onOffonWithTimedOffonOffControlCommandParameterInfo = new CommandParameterInfo("onOffControl", Integer.class, Integer.class);
       onOffonWithTimedOffCommandParams.put("onOffControl",onOffonWithTimedOffonOffControlCommandParameterInfo);
      
       CommandParameterInfo onOffonWithTimedOffonTimeCommandParameterInfo = new CommandParameterInfo("onTime", Integer.class, Integer.class);
       onOffonWithTimedOffCommandParams.put("onTime",onOffonWithTimedOffonTimeCommandParameterInfo);
      
       CommandParameterInfo onOffonWithTimedOffoffWaitTimeCommandParameterInfo = new CommandParameterInfo("offWaitTime", Integer.class, Integer.class);
       onOffonWithTimedOffCommandParams.put("offWaitTime",onOffonWithTimedOffoffWaitTimeCommandParameterInfo);
     
       InteractionInfo onOffonWithTimedOffInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.OnOffCluster) cluster)
           .onWithTimedOff((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("onOffControl")
           , (Integer)
           commandArguments.get("onTime")
           , (Integer)
           commandArguments.get("offWaitTime")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           onOffonWithTimedOffCommandParams
       );
       onOffClusterInteractionInfoMap.put("onWithTimedOff", onOffonWithTimedOffInteractionInfo);
     commandMap.put("onOff", onOffClusterInteractionInfoMap);
     Map<String, InteractionInfo> onOffSwitchConfigurationClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("onOffSwitchConfiguration", onOffSwitchConfigurationClusterInteractionInfoMap);
     Map<String, InteractionInfo> levelControlClusterInteractionInfoMap = new LinkedHashMap<>();
     Map<String, CommandParameterInfo> levelControlmoveToLevelCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo levelControlmoveToLevellevelCommandParameterInfo = new CommandParameterInfo("level", Integer.class, Integer.class);
       levelControlmoveToLevelCommandParams.put("level",levelControlmoveToLevellevelCommandParameterInfo);
      
       CommandParameterInfo levelControlmoveToLeveltransitionTimeCommandParameterInfo = new CommandParameterInfo("transitionTime", Integer.class, Integer.class);
       levelControlmoveToLevelCommandParams.put("transitionTime",levelControlmoveToLeveltransitionTimeCommandParameterInfo);
      
       CommandParameterInfo levelControlmoveToLeveloptionsMaskCommandParameterInfo = new CommandParameterInfo("optionsMask", Integer.class, Integer.class);
       levelControlmoveToLevelCommandParams.put("optionsMask",levelControlmoveToLeveloptionsMaskCommandParameterInfo);
      
       CommandParameterInfo levelControlmoveToLeveloptionsOverrideCommandParameterInfo = new CommandParameterInfo("optionsOverride", Integer.class, Integer.class);
       levelControlmoveToLevelCommandParams.put("optionsOverride",levelControlmoveToLeveloptionsOverrideCommandParameterInfo);
     
       InteractionInfo levelControlmoveToLevelInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.LevelControlCluster) cluster)
           .moveToLevel((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("level")
           , (Integer)
           commandArguments.get("transitionTime")
           , (Integer)
           commandArguments.get("optionsMask")
           , (Integer)
           commandArguments.get("optionsOverride")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           levelControlmoveToLevelCommandParams
       );
       levelControlClusterInteractionInfoMap.put("moveToLevel", levelControlmoveToLevelInteractionInfo);
     Map<String, CommandParameterInfo> levelControlmoveCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo levelControlmovemoveModeCommandParameterInfo = new CommandParameterInfo("moveMode", Integer.class, Integer.class);
       levelControlmoveCommandParams.put("moveMode",levelControlmovemoveModeCommandParameterInfo);
      
       CommandParameterInfo levelControlmoverateCommandParameterInfo = new CommandParameterInfo("rate", Integer.class, Integer.class);
       levelControlmoveCommandParams.put("rate",levelControlmoverateCommandParameterInfo);
      
       CommandParameterInfo levelControlmoveoptionsMaskCommandParameterInfo = new CommandParameterInfo("optionsMask", Integer.class, Integer.class);
       levelControlmoveCommandParams.put("optionsMask",levelControlmoveoptionsMaskCommandParameterInfo);
      
       CommandParameterInfo levelControlmoveoptionsOverrideCommandParameterInfo = new CommandParameterInfo("optionsOverride", Integer.class, Integer.class);
       levelControlmoveCommandParams.put("optionsOverride",levelControlmoveoptionsOverrideCommandParameterInfo);
     
       InteractionInfo levelControlmoveInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.LevelControlCluster) cluster)
           .move((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("moveMode")
           , (Integer)
           commandArguments.get("rate")
           , (Integer)
           commandArguments.get("optionsMask")
           , (Integer)
           commandArguments.get("optionsOverride")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           levelControlmoveCommandParams
       );
       levelControlClusterInteractionInfoMap.put("move", levelControlmoveInteractionInfo);
     Map<String, CommandParameterInfo> levelControlstepCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo levelControlstepstepModeCommandParameterInfo = new CommandParameterInfo("stepMode", Integer.class, Integer.class);
       levelControlstepCommandParams.put("stepMode",levelControlstepstepModeCommandParameterInfo);
      
       CommandParameterInfo levelControlstepstepSizeCommandParameterInfo = new CommandParameterInfo("stepSize", Integer.class, Integer.class);
       levelControlstepCommandParams.put("stepSize",levelControlstepstepSizeCommandParameterInfo);
      
       CommandParameterInfo levelControlsteptransitionTimeCommandParameterInfo = new CommandParameterInfo("transitionTime", Integer.class, Integer.class);
       levelControlstepCommandParams.put("transitionTime",levelControlsteptransitionTimeCommandParameterInfo);
      
       CommandParameterInfo levelControlstepoptionsMaskCommandParameterInfo = new CommandParameterInfo("optionsMask", Integer.class, Integer.class);
       levelControlstepCommandParams.put("optionsMask",levelControlstepoptionsMaskCommandParameterInfo);
      
       CommandParameterInfo levelControlstepoptionsOverrideCommandParameterInfo = new CommandParameterInfo("optionsOverride", Integer.class, Integer.class);
       levelControlstepCommandParams.put("optionsOverride",levelControlstepoptionsOverrideCommandParameterInfo);
     
       InteractionInfo levelControlstepInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.LevelControlCluster) cluster)
           .step((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("stepMode")
           , (Integer)
           commandArguments.get("stepSize")
           , (Integer)
           commandArguments.get("transitionTime")
           , (Integer)
           commandArguments.get("optionsMask")
           , (Integer)
           commandArguments.get("optionsOverride")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           levelControlstepCommandParams
       );
       levelControlClusterInteractionInfoMap.put("step", levelControlstepInteractionInfo);
     Map<String, CommandParameterInfo> levelControlstopCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo levelControlstopoptionsMaskCommandParameterInfo = new CommandParameterInfo("optionsMask", Integer.class, Integer.class);
       levelControlstopCommandParams.put("optionsMask",levelControlstopoptionsMaskCommandParameterInfo);
      
       CommandParameterInfo levelControlstopoptionsOverrideCommandParameterInfo = new CommandParameterInfo("optionsOverride", Integer.class, Integer.class);
       levelControlstopCommandParams.put("optionsOverride",levelControlstopoptionsOverrideCommandParameterInfo);
     
       InteractionInfo levelControlstopInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.LevelControlCluster) cluster)
           .stop((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("optionsMask")
           , (Integer)
           commandArguments.get("optionsOverride")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           levelControlstopCommandParams
       );
       levelControlClusterInteractionInfoMap.put("stop", levelControlstopInteractionInfo);
     Map<String, CommandParameterInfo> levelControlmoveToLevelWithOnOffCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo levelControlmoveToLevelWithOnOfflevelCommandParameterInfo = new CommandParameterInfo("level", Integer.class, Integer.class);
       levelControlmoveToLevelWithOnOffCommandParams.put("level",levelControlmoveToLevelWithOnOfflevelCommandParameterInfo);
      
       CommandParameterInfo levelControlmoveToLevelWithOnOfftransitionTimeCommandParameterInfo = new CommandParameterInfo("transitionTime", Integer.class, Integer.class);
       levelControlmoveToLevelWithOnOffCommandParams.put("transitionTime",levelControlmoveToLevelWithOnOfftransitionTimeCommandParameterInfo);
      
       CommandParameterInfo levelControlmoveToLevelWithOnOffoptionsMaskCommandParameterInfo = new CommandParameterInfo("optionsMask", Integer.class, Integer.class);
       levelControlmoveToLevelWithOnOffCommandParams.put("optionsMask",levelControlmoveToLevelWithOnOffoptionsMaskCommandParameterInfo);
      
       CommandParameterInfo levelControlmoveToLevelWithOnOffoptionsOverrideCommandParameterInfo = new CommandParameterInfo("optionsOverride", Integer.class, Integer.class);
       levelControlmoveToLevelWithOnOffCommandParams.put("optionsOverride",levelControlmoveToLevelWithOnOffoptionsOverrideCommandParameterInfo);
     
       InteractionInfo levelControlmoveToLevelWithOnOffInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.LevelControlCluster) cluster)
           .moveToLevelWithOnOff((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("level")
           , (Integer)
           commandArguments.get("transitionTime")
           , (Integer)
           commandArguments.get("optionsMask")
           , (Integer)
           commandArguments.get("optionsOverride")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           levelControlmoveToLevelWithOnOffCommandParams
       );
       levelControlClusterInteractionInfoMap.put("moveToLevelWithOnOff", levelControlmoveToLevelWithOnOffInteractionInfo);
     Map<String, CommandParameterInfo> levelControlmoveWithOnOffCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo levelControlmoveWithOnOffmoveModeCommandParameterInfo = new CommandParameterInfo("moveMode", Integer.class, Integer.class);
       levelControlmoveWithOnOffCommandParams.put("moveMode",levelControlmoveWithOnOffmoveModeCommandParameterInfo);
      
       CommandParameterInfo levelControlmoveWithOnOffrateCommandParameterInfo = new CommandParameterInfo("rate", Integer.class, Integer.class);
       levelControlmoveWithOnOffCommandParams.put("rate",levelControlmoveWithOnOffrateCommandParameterInfo);
      
       CommandParameterInfo levelControlmoveWithOnOffoptionsMaskCommandParameterInfo = new CommandParameterInfo("optionsMask", Integer.class, Integer.class);
       levelControlmoveWithOnOffCommandParams.put("optionsMask",levelControlmoveWithOnOffoptionsMaskCommandParameterInfo);
      
       CommandParameterInfo levelControlmoveWithOnOffoptionsOverrideCommandParameterInfo = new CommandParameterInfo("optionsOverride", Integer.class, Integer.class);
       levelControlmoveWithOnOffCommandParams.put("optionsOverride",levelControlmoveWithOnOffoptionsOverrideCommandParameterInfo);
     
       InteractionInfo levelControlmoveWithOnOffInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.LevelControlCluster) cluster)
           .moveWithOnOff((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("moveMode")
           , (Integer)
           commandArguments.get("rate")
           , (Integer)
           commandArguments.get("optionsMask")
           , (Integer)
           commandArguments.get("optionsOverride")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           levelControlmoveWithOnOffCommandParams
       );
       levelControlClusterInteractionInfoMap.put("moveWithOnOff", levelControlmoveWithOnOffInteractionInfo);
     Map<String, CommandParameterInfo> levelControlstepWithOnOffCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo levelControlstepWithOnOffstepModeCommandParameterInfo = new CommandParameterInfo("stepMode", Integer.class, Integer.class);
       levelControlstepWithOnOffCommandParams.put("stepMode",levelControlstepWithOnOffstepModeCommandParameterInfo);
      
       CommandParameterInfo levelControlstepWithOnOffstepSizeCommandParameterInfo = new CommandParameterInfo("stepSize", Integer.class, Integer.class);
       levelControlstepWithOnOffCommandParams.put("stepSize",levelControlstepWithOnOffstepSizeCommandParameterInfo);
      
       CommandParameterInfo levelControlstepWithOnOfftransitionTimeCommandParameterInfo = new CommandParameterInfo("transitionTime", Integer.class, Integer.class);
       levelControlstepWithOnOffCommandParams.put("transitionTime",levelControlstepWithOnOfftransitionTimeCommandParameterInfo);
      
       CommandParameterInfo levelControlstepWithOnOffoptionsMaskCommandParameterInfo = new CommandParameterInfo("optionsMask", Integer.class, Integer.class);
       levelControlstepWithOnOffCommandParams.put("optionsMask",levelControlstepWithOnOffoptionsMaskCommandParameterInfo);
      
       CommandParameterInfo levelControlstepWithOnOffoptionsOverrideCommandParameterInfo = new CommandParameterInfo("optionsOverride", Integer.class, Integer.class);
       levelControlstepWithOnOffCommandParams.put("optionsOverride",levelControlstepWithOnOffoptionsOverrideCommandParameterInfo);
     
       InteractionInfo levelControlstepWithOnOffInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.LevelControlCluster) cluster)
           .stepWithOnOff((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("stepMode")
           , (Integer)
           commandArguments.get("stepSize")
           , (Integer)
           commandArguments.get("transitionTime")
           , (Integer)
           commandArguments.get("optionsMask")
           , (Integer)
           commandArguments.get("optionsOverride")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           levelControlstepWithOnOffCommandParams
       );
       levelControlClusterInteractionInfoMap.put("stepWithOnOff", levelControlstepWithOnOffInteractionInfo);
     Map<String, CommandParameterInfo> levelControlstopWithOnOffCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo levelControlstopWithOnOffoptionsMaskCommandParameterInfo = new CommandParameterInfo("optionsMask", Integer.class, Integer.class);
       levelControlstopWithOnOffCommandParams.put("optionsMask",levelControlstopWithOnOffoptionsMaskCommandParameterInfo);
      
       CommandParameterInfo levelControlstopWithOnOffoptionsOverrideCommandParameterInfo = new CommandParameterInfo("optionsOverride", Integer.class, Integer.class);
       levelControlstopWithOnOffCommandParams.put("optionsOverride",levelControlstopWithOnOffoptionsOverrideCommandParameterInfo);
     
       InteractionInfo levelControlstopWithOnOffInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.LevelControlCluster) cluster)
           .stopWithOnOff((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("optionsMask")
           , (Integer)
           commandArguments.get("optionsOverride")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           levelControlstopWithOnOffCommandParams
       );
       levelControlClusterInteractionInfoMap.put("stopWithOnOff", levelControlstopWithOnOffInteractionInfo);
     commandMap.put("levelControl", levelControlClusterInteractionInfoMap);
     Map<String, InteractionInfo> binaryInputBasicClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("binaryInputBasic", binaryInputBasicClusterInteractionInfoMap);
     Map<String, InteractionInfo> pulseWidthModulationClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("pulseWidthModulation", pulseWidthModulationClusterInteractionInfoMap);
     Map<String, InteractionInfo> descriptorClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("descriptor", descriptorClusterInteractionInfoMap);
     Map<String, InteractionInfo> bindingClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("binding", bindingClusterInteractionInfoMap);
     Map<String, InteractionInfo> accessControlClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("accessControl", accessControlClusterInteractionInfoMap);
     Map<String, InteractionInfo> actionsClusterInteractionInfoMap = new LinkedHashMap<>();
     Map<String, CommandParameterInfo> actionsinstantActionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionsinstantActionactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionsinstantActionCommandParams.put("actionID",actionsinstantActionactionIDCommandParameterInfo);
      
       CommandParameterInfo actionsinstantActioninvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionsinstantActionCommandParams.put("invokeID",actionsinstantActioninvokeIDCommandParameterInfo);
     
       InteractionInfo actionsinstantActionInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .instantAction((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionsinstantActionCommandParams
       );
       actionsClusterInteractionInfoMap.put("instantAction", actionsinstantActionInteractionInfo);
     Map<String, CommandParameterInfo> actionsinstantActionWithTransitionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionsinstantActionWithTransitionactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionsinstantActionWithTransitionCommandParams.put("actionID",actionsinstantActionWithTransitionactionIDCommandParameterInfo);
      
       CommandParameterInfo actionsinstantActionWithTransitioninvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionsinstantActionWithTransitionCommandParams.put("invokeID",actionsinstantActionWithTransitioninvokeIDCommandParameterInfo);
      
       CommandParameterInfo actionsinstantActionWithTransitiontransitionTimeCommandParameterInfo = new CommandParameterInfo("transitionTime", Integer.class, Integer.class);
       actionsinstantActionWithTransitionCommandParams.put("transitionTime",actionsinstantActionWithTransitiontransitionTimeCommandParameterInfo);
     
       InteractionInfo actionsinstantActionWithTransitionInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .instantActionWithTransition((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           , (Integer)
           commandArguments.get("transitionTime")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionsinstantActionWithTransitionCommandParams
       );
       actionsClusterInteractionInfoMap.put("instantActionWithTransition", actionsinstantActionWithTransitionInteractionInfo);
     Map<String, CommandParameterInfo> actionsstartActionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionsstartActionactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionsstartActionCommandParams.put("actionID",actionsstartActionactionIDCommandParameterInfo);
      
       CommandParameterInfo actionsstartActioninvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionsstartActionCommandParams.put("invokeID",actionsstartActioninvokeIDCommandParameterInfo);
     
       InteractionInfo actionsstartActionInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .startAction((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionsstartActionCommandParams
       );
       actionsClusterInteractionInfoMap.put("startAction", actionsstartActionInteractionInfo);
     Map<String, CommandParameterInfo> actionsstartActionWithDurationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionsstartActionWithDurationactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionsstartActionWithDurationCommandParams.put("actionID",actionsstartActionWithDurationactionIDCommandParameterInfo);
      
       CommandParameterInfo actionsstartActionWithDurationinvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionsstartActionWithDurationCommandParams.put("invokeID",actionsstartActionWithDurationinvokeIDCommandParameterInfo);
      
       CommandParameterInfo actionsstartActionWithDurationdurationCommandParameterInfo = new CommandParameterInfo("duration", Long.class, Long.class);
       actionsstartActionWithDurationCommandParams.put("duration",actionsstartActionWithDurationdurationCommandParameterInfo);
     
       InteractionInfo actionsstartActionWithDurationInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .startActionWithDuration((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           , (Long)
           commandArguments.get("duration")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionsstartActionWithDurationCommandParams
       );
       actionsClusterInteractionInfoMap.put("startActionWithDuration", actionsstartActionWithDurationInteractionInfo);
     Map<String, CommandParameterInfo> actionsstopActionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionsstopActionactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionsstopActionCommandParams.put("actionID",actionsstopActionactionIDCommandParameterInfo);
      
       CommandParameterInfo actionsstopActioninvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionsstopActionCommandParams.put("invokeID",actionsstopActioninvokeIDCommandParameterInfo);
     
       InteractionInfo actionsstopActionInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .stopAction((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionsstopActionCommandParams
       );
       actionsClusterInteractionInfoMap.put("stopAction", actionsstopActionInteractionInfo);
     Map<String, CommandParameterInfo> actionspauseActionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionspauseActionactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionspauseActionCommandParams.put("actionID",actionspauseActionactionIDCommandParameterInfo);
      
       CommandParameterInfo actionspauseActioninvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionspauseActionCommandParams.put("invokeID",actionspauseActioninvokeIDCommandParameterInfo);
     
       InteractionInfo actionspauseActionInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .pauseAction((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionspauseActionCommandParams
       );
       actionsClusterInteractionInfoMap.put("pauseAction", actionspauseActionInteractionInfo);
     Map<String, CommandParameterInfo> actionspauseActionWithDurationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionspauseActionWithDurationactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionspauseActionWithDurationCommandParams.put("actionID",actionspauseActionWithDurationactionIDCommandParameterInfo);
      
       CommandParameterInfo actionspauseActionWithDurationinvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionspauseActionWithDurationCommandParams.put("invokeID",actionspauseActionWithDurationinvokeIDCommandParameterInfo);
      
       CommandParameterInfo actionspauseActionWithDurationdurationCommandParameterInfo = new CommandParameterInfo("duration", Long.class, Long.class);
       actionspauseActionWithDurationCommandParams.put("duration",actionspauseActionWithDurationdurationCommandParameterInfo);
     
       InteractionInfo actionspauseActionWithDurationInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .pauseActionWithDuration((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           , (Long)
           commandArguments.get("duration")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionspauseActionWithDurationCommandParams
       );
       actionsClusterInteractionInfoMap.put("pauseActionWithDuration", actionspauseActionWithDurationInteractionInfo);
     Map<String, CommandParameterInfo> actionsresumeActionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionsresumeActionactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionsresumeActionCommandParams.put("actionID",actionsresumeActionactionIDCommandParameterInfo);
      
       CommandParameterInfo actionsresumeActioninvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionsresumeActionCommandParams.put("invokeID",actionsresumeActioninvokeIDCommandParameterInfo);
     
       InteractionInfo actionsresumeActionInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .resumeAction((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionsresumeActionCommandParams
       );
       actionsClusterInteractionInfoMap.put("resumeAction", actionsresumeActionInteractionInfo);
     Map<String, CommandParameterInfo> actionsenableActionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionsenableActionactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionsenableActionCommandParams.put("actionID",actionsenableActionactionIDCommandParameterInfo);
      
       CommandParameterInfo actionsenableActioninvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionsenableActionCommandParams.put("invokeID",actionsenableActioninvokeIDCommandParameterInfo);
     
       InteractionInfo actionsenableActionInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .enableAction((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionsenableActionCommandParams
       );
       actionsClusterInteractionInfoMap.put("enableAction", actionsenableActionInteractionInfo);
     Map<String, CommandParameterInfo> actionsenableActionWithDurationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionsenableActionWithDurationactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionsenableActionWithDurationCommandParams.put("actionID",actionsenableActionWithDurationactionIDCommandParameterInfo);
      
       CommandParameterInfo actionsenableActionWithDurationinvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionsenableActionWithDurationCommandParams.put("invokeID",actionsenableActionWithDurationinvokeIDCommandParameterInfo);
      
       CommandParameterInfo actionsenableActionWithDurationdurationCommandParameterInfo = new CommandParameterInfo("duration", Long.class, Long.class);
       actionsenableActionWithDurationCommandParams.put("duration",actionsenableActionWithDurationdurationCommandParameterInfo);
     
       InteractionInfo actionsenableActionWithDurationInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .enableActionWithDuration((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           , (Long)
           commandArguments.get("duration")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionsenableActionWithDurationCommandParams
       );
       actionsClusterInteractionInfoMap.put("enableActionWithDuration", actionsenableActionWithDurationInteractionInfo);
     Map<String, CommandParameterInfo> actionsdisableActionCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionsdisableActionactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionsdisableActionCommandParams.put("actionID",actionsdisableActionactionIDCommandParameterInfo);
      
       CommandParameterInfo actionsdisableActioninvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionsdisableActionCommandParams.put("invokeID",actionsdisableActioninvokeIDCommandParameterInfo);
     
       InteractionInfo actionsdisableActionInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .disableAction((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionsdisableActionCommandParams
       );
       actionsClusterInteractionInfoMap.put("disableAction", actionsdisableActionInteractionInfo);
     Map<String, CommandParameterInfo> actionsdisableActionWithDurationCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo actionsdisableActionWithDurationactionIDCommandParameterInfo = new CommandParameterInfo("actionID", Integer.class, Integer.class);
       actionsdisableActionWithDurationCommandParams.put("actionID",actionsdisableActionWithDurationactionIDCommandParameterInfo);
      
       CommandParameterInfo actionsdisableActionWithDurationinvokeIDCommandParameterInfo = new CommandParameterInfo("invokeID", Optional.class, Long.class);
       actionsdisableActionWithDurationCommandParams.put("invokeID",actionsdisableActionWithDurationinvokeIDCommandParameterInfo);
      
       CommandParameterInfo actionsdisableActionWithDurationdurationCommandParameterInfo = new CommandParameterInfo("duration", Long.class, Long.class);
       actionsdisableActionWithDurationCommandParams.put("duration",actionsdisableActionWithDurationdurationCommandParameterInfo);
     
       InteractionInfo actionsdisableActionWithDurationInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.ActionsCluster) cluster)
           .disableActionWithDuration((DefaultClusterCallback) callback
           , (Integer)
           commandArguments.get("actionID")
           , (Optional<Long>)
           commandArguments.get("invokeID")
           , (Long)
           commandArguments.get("duration")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           actionsdisableActionWithDurationCommandParams
       );
       actionsClusterInteractionInfoMap.put("disableActionWithDuration", actionsdisableActionWithDurationInteractionInfo);
     commandMap.put("actions", actionsClusterInteractionInfoMap);
     Map<String, InteractionInfo> basicInformationClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("basicInformation", basicInformationClusterInteractionInfoMap);
     Map<String, InteractionInfo> otaSoftwareUpdateProviderClusterInteractionInfoMap = new LinkedHashMap<>();
     Map<String, CommandParameterInfo> otaSoftwareUpdateProviderqueryImageCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo otaSoftwareUpdateProviderqueryImagevendorIDCommandParameterInfo = new CommandParameterInfo("vendorID", Integer.class, Integer.class);
       otaSoftwareUpdateProviderqueryImageCommandParams.put("vendorID",otaSoftwareUpdateProviderqueryImagevendorIDCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateProviderqueryImageproductIDCommandParameterInfo = new CommandParameterInfo("productID", Integer.class, Integer.class);
       otaSoftwareUpdateProviderqueryImageCommandParams.put("productID",otaSoftwareUpdateProviderqueryImageproductIDCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateProviderqueryImagesoftwareVersionCommandParameterInfo = new CommandParameterInfo("softwareVersion", Long.class, Long.class);
       otaSoftwareUpdateProviderqueryImageCommandParams.put("softwareVersion",otaSoftwareUpdateProviderqueryImagesoftwareVersionCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateProviderqueryImageprotocolsSupportedCommandParameterInfo = new CommandParameterInfo("protocolsSupported", ArrayList.class, Integer.class);
       otaSoftwareUpdateProviderqueryImageCommandParams.put("protocolsSupported",otaSoftwareUpdateProviderqueryImageprotocolsSupportedCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateProviderqueryImagehardwareVersionCommandParameterInfo = new CommandParameterInfo("hardwareVersion", Optional.class, Integer.class);
       otaSoftwareUpdateProviderqueryImageCommandParams.put("hardwareVersion",otaSoftwareUpdateProviderqueryImagehardwareVersionCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateProviderqueryImagelocationCommandParameterInfo = new CommandParameterInfo("location", Optional.class, String.class);
       otaSoftwareUpdateProviderqueryImageCommandParams.put("location",otaSoftwareUpdateProviderqueryImagelocationCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateProviderqueryImagerequestorCanConsentCommandParameterInfo = new CommandParameterInfo("requestorCanConsent", Optional.class, Boolean.class);
       otaSoftwareUpdateProviderqueryImageCommandParams.put("requestorCanConsent",otaSoftwareUpdateProviderqueryImagerequestorCanConsentCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateProviderqueryImagemetadataForProviderCommandParameterInfo = new CommandParameterInfo("metadataForProvider", Optional.class, byte[].class);
       otaSoftwareUpdateProviderqueryImageCommandParams.put("metadataForProvider",otaSoftwareUpdateProviderqueryImagemetadataForProviderCommandParameterInfo);
     
       InteractionInfo otaSoftwareUpdateProviderqueryImageInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.OtaSoftwareUpdateProviderCluster) cluster)
           .queryImage((ChipClusters.OtaSoftwareUpdateProviderCluster.QueryImageResponseCallback) callback
           , (Integer)
           commandArguments.get("vendorID")
           , (Integer)
           commandArguments.get("productID")
           , (Long)
           commandArguments.get("softwareVersion")
           , (ArrayList<Integer>)
           commandArguments.get("protocolsSupported")
           , (Optional<Integer>)
           commandArguments.get("hardwareVersion")
           , (Optional<String>)
           commandArguments.get("location")
           , (Optional<Boolean>)
           commandArguments.get("requestorCanConsent")
           , (Optional<byte[]>)
           commandArguments.get("metadataForProvider")
           
           );
         },
         () -> new DelegatedOtaSoftwareUpdateProviderClusterQueryImageResponseCallback(),
           otaSoftwareUpdateProviderqueryImageCommandParams
       );
       otaSoftwareUpdateProviderClusterInteractionInfoMap.put("queryImage", otaSoftwareUpdateProviderqueryImageInteractionInfo);
     Map<String, CommandParameterInfo> otaSoftwareUpdateProviderapplyUpdateRequestCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo otaSoftwareUpdateProviderapplyUpdateRequestupdateTokenCommandParameterInfo = new CommandParameterInfo("updateToken", byte[].class, byte[].class);
       otaSoftwareUpdateProviderapplyUpdateRequestCommandParams.put("updateToken",otaSoftwareUpdateProviderapplyUpdateRequestupdateTokenCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateProviderapplyUpdateRequestnewVersionCommandParameterInfo = new CommandParameterInfo("newVersion", Long.class, Long.class);
       otaSoftwareUpdateProviderapplyUpdateRequestCommandParams.put("newVersion",otaSoftwareUpdateProviderapplyUpdateRequestnewVersionCommandParameterInfo);
     
       InteractionInfo otaSoftwareUpdateProviderapplyUpdateRequestInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.OtaSoftwareUpdateProviderCluster) cluster)
           .applyUpdateRequest((ChipClusters.OtaSoftwareUpdateProviderCluster.ApplyUpdateResponseCallback) callback
           , (byte[])
           commandArguments.get("updateToken")
           , (Long)
           commandArguments.get("newVersion")
           
           );
         },
         () -> new DelegatedOtaSoftwareUpdateProviderClusterApplyUpdateResponseCallback(),
           otaSoftwareUpdateProviderapplyUpdateRequestCommandParams
       );
       otaSoftwareUpdateProviderClusterInteractionInfoMap.put("applyUpdateRequest", otaSoftwareUpdateProviderapplyUpdateRequestInteractionInfo);
     Map<String, CommandParameterInfo> otaSoftwareUpdateProvidernotifyUpdateAppliedCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo otaSoftwareUpdateProvidernotifyUpdateAppliedupdateTokenCommandParameterInfo = new CommandParameterInfo("updateToken", byte[].class, byte[].class);
       otaSoftwareUpdateProvidernotifyUpdateAppliedCommandParams.put("updateToken",otaSoftwareUpdateProvidernotifyUpdateAppliedupdateTokenCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateProvidernotifyUpdateAppliedsoftwareVersionCommandParameterInfo = new CommandParameterInfo("softwareVersion", Long.class, Long.class);
       otaSoftwareUpdateProvidernotifyUpdateAppliedCommandParams.put("softwareVersion",otaSoftwareUpdateProvidernotifyUpdateAppliedsoftwareVersionCommandParameterInfo);
     
       InteractionInfo otaSoftwareUpdateProvidernotifyUpdateAppliedInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.OtaSoftwareUpdateProviderCluster) cluster)
           .notifyUpdateApplied((DefaultClusterCallback) callback
           , (byte[])
           commandArguments.get("updateToken")
           , (Long)
           commandArguments.get("softwareVersion")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           otaSoftwareUpdateProvidernotifyUpdateAppliedCommandParams
       );
       otaSoftwareUpdateProviderClusterInteractionInfoMap.put("notifyUpdateApplied", otaSoftwareUpdateProvidernotifyUpdateAppliedInteractionInfo);
     commandMap.put("otaSoftwareUpdateProvider", otaSoftwareUpdateProviderClusterInteractionInfoMap);
     Map<String, InteractionInfo> otaSoftwareUpdateRequestorClusterInteractionInfoMap = new LinkedHashMap<>();
     Map<String, CommandParameterInfo> otaSoftwareUpdateRequestorannounceOTAProviderCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo otaSoftwareUpdateRequestorannounceOTAProviderproviderNodeIDCommandParameterInfo = new CommandParameterInfo("providerNodeID", Long.class, Long.class);
       otaSoftwareUpdateRequestorannounceOTAProviderCommandParams.put("providerNodeID",otaSoftwareUpdateRequestorannounceOTAProviderproviderNodeIDCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateRequestorannounceOTAProvidervendorIDCommandParameterInfo = new CommandParameterInfo("vendorID", Integer.class, Integer.class);
       otaSoftwareUpdateRequestorannounceOTAProviderCommandParams.put("vendorID",otaSoftwareUpdateRequestorannounceOTAProvidervendorIDCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateRequestorannounceOTAProviderannouncementReasonCommandParameterInfo = new CommandParameterInfo("announcementReason", Integer.class, Integer.class);
       otaSoftwareUpdateRequestorannounceOTAProviderCommandParams.put("announcementReason",otaSoftwareUpdateRequestorannounceOTAProviderannouncementReasonCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateRequestorannounceOTAProvidermetadataForNodeCommandParameterInfo = new CommandParameterInfo("metadataForNode", Optional.class, byte[].class);
       otaSoftwareUpdateRequestorannounceOTAProviderCommandParams.put("metadataForNode",otaSoftwareUpdateRequestorannounceOTAProvidermetadataForNodeCommandParameterInfo);
      
       CommandParameterInfo otaSoftwareUpdateRequestorannounceOTAProviderendpointCommandParameterInfo = new CommandParameterInfo("endpoint", Integer.class, Integer.class);
       otaSoftwareUpdateRequestorannounceOTAProviderCommandParams.put("endpoint",otaSoftwareUpdateRequestorannounceOTAProviderendpointCommandParameterInfo);
     
       InteractionInfo otaSoftwareUpdateRequestorannounceOTAProviderInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.OtaSoftwareUpdateRequestorCluster) cluster)
           .announceOTAProvider((DefaultClusterCallback) callback
           , (Long)
           commandArguments.get("providerNodeID")
           , (Integer)
           commandArguments.get("vendorID")
           , (Integer)
           commandArguments.get("announcementReason")
           , (Optional<byte[]>)
           commandArguments.get("metadataForNode")
           , (Integer)
           commandArguments.get("endpoint")
           
           );
         },
         () -> new DelegatedDefaultClusterCallback(),
           otaSoftwareUpdateRequestorannounceOTAProviderCommandParams
       );
       otaSoftwareUpdateRequestorClusterInteractionInfoMap.put("announceOTAProvider", otaSoftwareUpdateRequestorannounceOTAProviderInteractionInfo);
     commandMap.put("otaSoftwareUpdateRequestor", otaSoftwareUpdateRequestorClusterInteractionInfoMap);
     Map<String, InteractionInfo> localizationConfigurationClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("localizationConfiguration", localizationConfigurationClusterInteractionInfoMap);
     Map<String, InteractionInfo> timeFormatLocalizationClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("timeFormatLocalization", timeFormatLocalizationClusterInteractionInfoMap);
     Map<String, InteractionInfo> unitLocalizationClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("unitLocalization", unitLocalizationClusterInteractionInfoMap);
     Map<String, InteractionInfo> powerSourceConfigurationClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("powerSourceConfiguration", powerSourceConfigurationClusterInteractionInfoMap);
     Map<String, InteractionInfo> powerSourceClusterInteractionInfoMap = new LinkedHashMap<>();
     commandMap.put("powerSource", powerSourceClusterInteractionInfoMap);
     Map<String, InteractionInfo> generalCommissioningClusterInteractionInfoMap = new LinkedHashMap<>();
     Map<String, CommandParameterInfo> generalCommissioningarmFailSafeCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo generalCommissioningarmFailSafeexpiryLengthSecondsCommandParameterInfo = new CommandParameterInfo("expiryLengthSeconds", Integer.class, Integer.class);
       generalCommissioningarmFailSafeCommandParams.put("expiryLengthSeconds",generalCommissioningarmFailSafeexpiryLengthSecondsCommandParameterInfo);
      
       CommandParameterInfo generalCommissioningarmFailSafebreadcrumbCommandParameterInfo = new CommandParameterInfo("breadcrumb", Long.class, Long.class);
       generalCommissioningarmFailSafeCommandParams.put("breadcrumb",generalCommissioningarmFailSafebreadcrumbCommandParameterInfo);
     
       InteractionInfo generalCommissioningarmFailSafeInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.GeneralCommissioningCluster) cluster)
           .armFailSafe((ChipClusters.GeneralCommissioningCluster.ArmFailSafeResponseCallback) callback
           , (Integer)
           commandArguments.get("expiryLengthSeconds")
           , (Long)
           commandArguments.get("breadcrumb")
           
           );
         },
         () -> new DelegatedGeneralCommissioningClusterArmFailSafeResponseCallback(),
           generalCommissioningarmFailSafeCommandParams
       );
       generalCommissioningClusterInteractionInfoMap.put("armFailSafe", generalCommissioningarmFailSafeInteractionInfo);
     Map<String, CommandParameterInfo> generalCommissioningsetRegulatoryConfigCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo generalCommissioningsetRegulatoryConfignewRegulatoryConfigCommandParameterInfo = new CommandParameterInfo("newRegulatoryConfig", Integer.class, Integer.class);
       generalCommissioningsetRegulatoryConfigCommandParams.put("newRegulatoryConfig",generalCommissioningsetRegulatoryConfignewRegulatoryConfigCommandParameterInfo);
      
       CommandParameterInfo generalCommissioningsetRegulatoryConfigcountryCodeCommandParameterInfo = new CommandParameterInfo("countryCode", String.class, String.class);
       generalCommissioningsetRegulatoryConfigCommandParams.put("countryCode",generalCommissioningsetRegulatoryConfigcountryCodeCommandParameterInfo);
      
       CommandParameterInfo generalCommissioningsetRegulatoryConfigbreadcrumbCommandParameterInfo = new CommandParameterInfo("breadcrumb", Long.class, Long.class);
       generalCommissioningsetRegulatoryConfigCommandParams.put("breadcrumb",generalCommissioningsetRegulatoryConfigbreadcrumbCommandParameterInfo);
     
       InteractionInfo generalCommissioningsetRegulatoryConfigInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.GeneralCommissioningCluster) cluster)
           .setRegulatoryConfig((ChipClusters.GeneralCommissioningCluster.SetRegulatoryConfigResponseCallback) callback
           , (Integer)
           commandArguments.get("newRegulatoryConfig")
           , (String)
           commandArguments.get("countryCode")
           , (Long)
           commandArguments.get("breadcrumb")
           
           );
         },
         () -> new DelegatedGeneralCommissioningClusterSetRegulatoryConfigResponseCallback(),
           generalCommissioningsetRegulatoryConfigCommandParams
       );
       generalCommissioningClusterInteractionInfoMap.put("setRegulatoryConfig", generalCommissioningsetRegulatoryConfigInteractionInfo);
     Map<String, CommandParameterInfo> generalCommissioningcommissioningCompleteCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       InteractionInfo generalCommissioningcommissioningCompleteInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.GeneralCommissioningCluster) cluster)
           .commissioningComplete((ChipClusters.GeneralCommissioningCluster.CommissioningCompleteResponseCallback) callback
           
           );
         },
         () -> new DelegatedGeneralCommissioningClusterCommissioningCompleteResponseCallback(),
           generalCommissioningcommissioningCompleteCommandParams
       );
       generalCommissioningClusterInteractionInfoMap.put("commissioningComplete", generalCommissioningcommissioningCompleteInteractionInfo);
     commandMap.put("generalCommissioning", generalCommissioningClusterInteractionInfoMap);
     Map<String, InteractionInfo> networkCommissioningClusterInteractionInfoMap = new LinkedHashMap<>();
     Map<String, CommandParameterInfo> networkCommissioningscanNetworksCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo networkCommissioningscanNetworksssidCommandParameterInfo = new CommandParameterInfo("ssid", Optional.class, byte[].class);
       networkCommissioningscanNetworksCommandParams.put("ssid",networkCommissioningscanNetworksssidCommandParameterInfo);
      
       CommandParameterInfo networkCommissioningscanNetworksbreadcrumbCommandParameterInfo = new CommandParameterInfo("breadcrumb", Optional.class, Long.class);
       networkCommissioningscanNetworksCommandParams.put("breadcrumb",networkCommissioningscanNetworksbreadcrumbCommandParameterInfo);
     
       InteractionInfo networkCommissioningscanNetworksInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.NetworkCommissioningCluster) cluster)
           .scanNetworks((ChipClusters.NetworkCommissioningCluster.ScanNetworksResponseCallback) callback
           , (Optional<byte[]>)
           commandArguments.get("ssid")
           , (Optional<Long>)
           commandArguments.get("breadcrumb")
           
           );
         },
         () -> new DelegatedNetworkCommissioningClusterScanNetworksResponseCallback(),
           networkCommissioningscanNetworksCommandParams
       );
       networkCommissioningClusterInteractionInfoMap.put("scanNetworks", networkCommissioningscanNetworksInteractionInfo);
     Map<String, CommandParameterInfo> networkCommissioningaddOrUpdateWiFiNetworkCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo networkCommissioningaddOrUpdateWiFiNetworkssidCommandParameterInfo = new CommandParameterInfo("ssid", byte[].class, byte[].class);
       networkCommissioningaddOrUpdateWiFiNetworkCommandParams.put("ssid",networkCommissioningaddOrUpdateWiFiNetworkssidCommandParameterInfo);
      
       CommandParameterInfo networkCommissioningaddOrUpdateWiFiNetworkcredentialsCommandParameterInfo = new CommandParameterInfo("credentials", byte[].class, byte[].class);
       networkCommissioningaddOrUpdateWiFiNetworkCommandParams.put("credentials",networkCommissioningaddOrUpdateWiFiNetworkcredentialsCommandParameterInfo);
      
       CommandParameterInfo networkCommissioningaddOrUpdateWiFiNetworkbreadcrumbCommandParameterInfo = new CommandParameterInfo("breadcrumb", Optional.class, Long.class);
       networkCommissioningaddOrUpdateWiFiNetworkCommandParams.put("breadcrumb",networkCommissioningaddOrUpdateWiFiNetworkbreadcrumbCommandParameterInfo);
     
       InteractionInfo networkCommissioningaddOrUpdateWiFiNetworkInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.NetworkCommissioningCluster) cluster)
           .addOrUpdateWiFiNetwork((ChipClusters.NetworkCommissioningCluster.NetworkConfigResponseCallback) callback
           , (byte[])
           commandArguments.get("ssid")
           , (byte[])
           commandArguments.get("credentials")
           , (Optional<Long>)
           commandArguments.get("breadcrumb")
           
           );
         },
         () -> new DelegatedNetworkCommissioningClusterNetworkConfigResponseCallback(),
           networkCommissioningaddOrUpdateWiFiNetworkCommandParams
       );
       networkCommissioningClusterInteractionInfoMap.put("addOrUpdateWiFiNetwork", networkCommissioningaddOrUpdateWiFiNetworkInteractionInfo);
     Map<String, CommandParameterInfo> networkCommissioningaddOrUpdateThreadNetworkCommandParams = new LinkedHashMap<String, CommandParameterInfo>();
       CommandParameterInfo networkCommissioningaddOrUpdateThreadNetworkoperationalDatasetCommandParameterInfo = new CommandParameterInfo("operationalDataset", byte[].class, byte[].class);
       networkCommissioningaddOrUpdateThreadNetworkCommandParams.put("operationalDataset",networkCommissioningaddOrUpdateThreadNetworkoperationalDatasetCommandParameterInfo);
      
       CommandParameterInfo networkCommissioningaddOrUpdateThreadNetworkbreadcrumbCommandParameterInfo = new CommandParameterInfo("breadcrumb", Optional.class, Long.class);
       networkCommissioningaddOrUpdateThreadNetworkCommandParams.put("breadcrumb",networkCommissioningaddOrUpdateThreadNetworkbreadcrumbCommandParameterInfo);
     
       InteractionInfo networkCommissioningaddOrUpdateThreadNetworkInteractionInfo = new InteractionInfo(
         (cluster, callback, commandArguments) -> {
           ((ChipClusters.NetworkCommissioningCluster) cluster)
           .addOrUpdateThreadNetwork((ChipClusters.NetworkCommissioningCluster.NetworkConfigResponseCallback) callback
           , (byte[])
           commandArguments.get("operationalDataset")
           , (Optional<Long>)
           commandArguments.get("breadcrumb")
           
           );
         },
         () -> new DelegatedNetworkCommissioningClusterNetworkConfigResponseCall