'''
/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP
'''

import ctypes

from chip import exceptions

__all__ = ["ChipClusters"]


class ChipClusters:
    SUCCESS_DELEGATE = ctypes.CFUNCTYPE(None)
    FAILURE_DELEGATE = ctypes.CFUNCTYPE(None, ctypes.c_uint8)

    _IDENTIFY_CLUSTER_INFO = {
        "clusterName": "Identify",
        "clusterId": 0x00000003,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "Identify",
                "args": {
                    "identifyTime": "int",
                },
            },
            0x00000040: {
                "commandId": 0x00000040,
                "commandName": "TriggerEffect",
                "args": {
                    "effectIdentifier": "int",
                    "effectVariant": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "IdentifyTime",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000001: {
                "attributeName": "IdentifyType",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _GROUPS_CLUSTER_INFO = {
        "clusterName": "Groups",
        "clusterId": 0x00000004,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "AddGroup",
                "args": {
                    "groupID": "int",
                    "groupName": "str",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "ViewGroup",
                "args": {
                    "groupID": "int",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "GetGroupMembership",
                "args": {
                    "groupList": "int",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "RemoveGroup",
                "args": {
                    "groupID": "int",
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "RemoveAllGroups",
                "args": {
                },
            },
            0x00000005: {
                "commandId": 0x00000005,
                "commandName": "AddGroupIfIdentifying",
                "args": {
                    "groupID": "int",
                    "groupName": "str",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "NameSupport",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _SCENES_CLUSTER_INFO = {
        "clusterName": "Scenes",
        "clusterId": 0x00000005,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "AddScene",
                "args": {
                    "groupID": "int",
                    "sceneID": "int",
                    "transitionTime": "int",
                    "sceneName": "str",
                    "extensionFieldSets": "ExtensionFieldSet",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "ViewScene",
                "args": {
                    "groupID": "int",
                    "sceneID": "int",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "RemoveScene",
                "args": {
                    "groupID": "int",
                    "sceneID": "int",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "RemoveAllScenes",
                "args": {
                    "groupID": "int",
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "StoreScene",
                "args": {
                    "groupID": "int",
                    "sceneID": "int",
                },
            },
            0x00000005: {
                "commandId": 0x00000005,
                "commandName": "RecallScene",
                "args": {
                    "groupID": "int",
                    "sceneID": "int",
                    "transitionTime": "int",
                },
            },
            0x00000006: {
                "commandId": 0x00000006,
                "commandName": "GetSceneMembership",
                "args": {
                    "groupID": "int",
                },
            },
            0x00000040: {
                "commandId": 0x00000040,
                "commandName": "EnhancedAddScene",
                "args": {
                    "groupID": "int",
                    "sceneID": "int",
                    "transitionTime": "int",
                    "sceneName": "str",
                    "extensionFieldSets": "ExtensionFieldSet",
                },
            },
            0x00000041: {
                "commandId": 0x00000041,
                "commandName": "EnhancedViewScene",
                "args": {
                    "groupID": "int",
                    "sceneID": "int",
                },
            },
            0x00000042: {
                "commandId": 0x00000042,
                "commandName": "CopyScene",
                "args": {
                    "mode": "int",
                    "groupIdentifierFrom": "int",
                    "sceneIdentifierFrom": "int",
                    "groupIdentifierTo": "int",
                    "sceneIdentifierTo": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "SceneCount",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "CurrentScene",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "CurrentGroup",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "SceneValid",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "NameSupport",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "LastConfiguredBy",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "SceneTableSize",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "RemainingCapacity",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ON_OFF_CLUSTER_INFO = {
        "clusterName": "OnOff",
        "clusterId": 0x00000006,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "Off",
                "args": {
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "On",
                "args": {
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "Toggle",
                "args": {
                },
            },
            0x00000040: {
                "commandId": 0x00000040,
                "commandName": "OffWithEffect",
                "args": {
                    "effectIdentifier": "int",
                    "effectVariant": "int",
                },
            },
            0x00000041: {
                "commandId": 0x00000041,
                "commandName": "OnWithRecallGlobalScene",
                "args": {
                },
            },
            0x00000042: {
                "commandId": 0x00000042,
                "commandName": "OnWithTimedOff",
                "args": {
                    "onOffControl": "int",
                    "onTime": "int",
                    "offWaitTime": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "OnOff",
                "attributeId": 0x00000000,
                "type": "bool",
                "reportable": True,
            },
            0x00004000: {
                "attributeName": "GlobalSceneControl",
                "attributeId": 0x00004000,
                "type": "bool",
                "reportable": True,
            },
            0x00004001: {
                "attributeName": "OnTime",
                "attributeId": 0x00004001,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004002: {
                "attributeName": "OffWaitTime",
                "attributeId": 0x00004002,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004003: {
                "attributeName": "StartUpOnOff",
                "attributeId": 0x00004003,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ON_OFF_SWITCH_CONFIGURATION_CLUSTER_INFO = {
        "clusterName": "OnOffSwitchConfiguration",
        "clusterId": 0x00000007,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "SwitchType",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000010: {
                "attributeName": "SwitchActions",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _LEVEL_CONTROL_CLUSTER_INFO = {
        "clusterName": "LevelControl",
        "clusterId": 0x00000008,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "MoveToLevel",
                "args": {
                    "level": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "Move",
                "args": {
                    "moveMode": "int",
                    "rate": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "Step",
                "args": {
                    "stepMode": "int",
                    "stepSize": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "Stop",
                "args": {
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "MoveToLevelWithOnOff",
                "args": {
                    "level": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000005: {
                "commandId": 0x00000005,
                "commandName": "MoveWithOnOff",
                "args": {
                    "moveMode": "int",
                    "rate": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000006: {
                "commandId": 0x00000006,
                "commandName": "StepWithOnOff",
                "args": {
                    "stepMode": "int",
                    "stepSize": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000007: {
                "commandId": 0x00000007,
                "commandName": "StopWithOnOff",
                "args": {
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000008: {
                "commandId": 0x00000008,
                "commandName": "MoveToClosestFrequency",
                "args": {
                    "frequency": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "CurrentLevel",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "RemainingTime",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MinLevel",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "MaxLevel",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "CurrentFrequency",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "MinFrequency",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "MaxFrequency",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x0000000F: {
                "attributeName": "Options",
                "attributeId": 0x0000000F,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000010: {
                "attributeName": "OnOffTransitionTime",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000011: {
                "attributeName": "OnLevel",
                "attributeId": 0x00000011,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000012: {
                "attributeName": "OnTransitionTime",
                "attributeId": 0x00000012,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000013: {
                "attributeName": "OffTransitionTime",
                "attributeId": 0x00000013,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000014: {
                "attributeName": "DefaultMoveRate",
                "attributeId": 0x00000014,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004000: {
                "attributeName": "StartUpCurrentLevel",
                "attributeId": 0x00004000,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _BINARY_INPUT_BASIC_CLUSTER_INFO = {
        "clusterName": "BinaryInputBasic",
        "clusterId": 0x0000000F,
        "commands": {
        },
        "attributes": {
            0x00000004: {
                "attributeName": "ActiveText",
                "attributeId": 0x00000004,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x0000001C: {
                "attributeName": "Description",
                "attributeId": 0x0000001C,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x0000002E: {
                "attributeName": "InactiveText",
                "attributeId": 0x0000002E,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x00000051: {
                "attributeName": "OutOfService",
                "attributeId": 0x00000051,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00000054: {
                "attributeName": "Polarity",
                "attributeId": 0x00000054,
                "type": "int",
                "reportable": True,
            },
            0x00000055: {
                "attributeName": "PresentValue",
                "attributeId": 0x00000055,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00000067: {
                "attributeName": "Reliability",
                "attributeId": 0x00000067,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000006F: {
                "attributeName": "StatusFlags",
                "attributeId": 0x0000006F,
                "type": "int",
                "reportable": True,
            },
            0x00000100: {
                "attributeName": "ApplicationType",
                "attributeId": 0x00000100,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _PULSE_WIDTH_MODULATION_CLUSTER_INFO = {
        "clusterName": "PulseWidthModulation",
        "clusterId": 0x0000001C,
        "commands": {
        },
        "attributes": {
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _DESCRIPTOR_CLUSTER_INFO = {
        "clusterName": "Descriptor",
        "clusterId": 0x0000001D,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "DeviceTypeList",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "ServerList",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ClientList",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PartsList",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _BINDING_CLUSTER_INFO = {
        "clusterName": "Binding",
        "clusterId": 0x0000001E,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Binding",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ACCESS_CONTROL_CLUSTER_INFO = {
        "clusterName": "AccessControl",
        "clusterId": 0x0000001F,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Acl",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00000001: {
                "attributeName": "Extension",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00000002: {
                "attributeName": "SubjectsPerAccessControlEntry",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "TargetsPerAccessControlEntry",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "AccessControlEntriesPerFabric",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ACTIONS_CLUSTER_INFO = {
        "clusterName": "Actions",
        "clusterId": 0x00000025,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "InstantAction",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "InstantActionWithTransition",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                    "transitionTime": "int",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "StartAction",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "StartActionWithDuration",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                    "duration": "int",
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "StopAction",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                },
            },
            0x00000005: {
                "commandId": 0x00000005,
                "commandName": "PauseAction",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                },
            },
            0x00000006: {
                "commandId": 0x00000006,
                "commandName": "PauseActionWithDuration",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                    "duration": "int",
                },
            },
            0x00000007: {
                "commandId": 0x00000007,
                "commandName": "ResumeAction",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                },
            },
            0x00000008: {
                "commandId": 0x00000008,
                "commandName": "EnableAction",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                },
            },
            0x00000009: {
                "commandId": 0x00000009,
                "commandName": "EnableActionWithDuration",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                    "duration": "int",
                },
            },
            0x0000000A: {
                "commandId": 0x0000000A,
                "commandName": "DisableAction",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                },
            },
            0x0000000B: {
                "commandId": 0x0000000B,
                "commandName": "DisableActionWithDuration",
                "args": {
                    "actionID": "int",
                    "invokeID": "int",
                    "duration": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "ActionList",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "EndpointLists",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "SetupURL",
                "attributeId": 0x00000002,
                "type": "str",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _BASIC_INFORMATION_CLUSTER_INFO = {
        "clusterName": "BasicInformation",
        "clusterId": 0x00000028,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "MfgSpecificPing",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "DataModelRevision",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "VendorName",
                "attributeId": 0x00000001,
                "type": "str",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "VendorID",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "ProductName",
                "attributeId": 0x00000003,
                "type": "str",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "ProductID",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "NodeLabel",
                "attributeId": 0x00000005,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x00000006: {
                "attributeName": "Location",
                "attributeId": 0x00000006,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x00000007: {
                "attributeName": "HardwareVersion",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "HardwareVersionString",
                "attributeId": 0x00000008,
                "type": "str",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "SoftwareVersion",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "SoftwareVersionString",
                "attributeId": 0x0000000A,
                "type": "str",
                "reportable": True,
            },
            0x0000000B: {
                "attributeName": "ManufacturingDate",
                "attributeId": 0x0000000B,
                "type": "str",
                "reportable": True,
            },
            0x0000000C: {
                "attributeName": "PartNumber",
                "attributeId": 0x0000000C,
                "type": "str",
                "reportable": True,
            },
            0x0000000D: {
                "attributeName": "ProductURL",
                "attributeId": 0x0000000D,
                "type": "str",
                "reportable": True,
            },
            0x0000000E: {
                "attributeName": "ProductLabel",
                "attributeId": 0x0000000E,
                "type": "str",
                "reportable": True,
            },
            0x0000000F: {
                "attributeName": "SerialNumber",
                "attributeId": 0x0000000F,
                "type": "str",
                "reportable": True,
            },
            0x00000010: {
                "attributeName": "LocalConfigDisabled",
                "attributeId": 0x00000010,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00000011: {
                "attributeName": "Reachable",
                "attributeId": 0x00000011,
                "type": "bool",
                "reportable": True,
            },
            0x00000012: {
                "attributeName": "UniqueID",
                "attributeId": 0x00000012,
                "type": "str",
                "reportable": True,
            },
            0x00000013: {
                "attributeName": "CapabilityMinima",
                "attributeId": 0x00000013,
                "type": "",
                "reportable": True,
            },
            0x00000014: {
                "attributeName": "ProductAppearance",
                "attributeId": 0x00000014,
                "type": "",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _OTA_SOFTWARE_UPDATE_PROVIDER_CLUSTER_INFO = {
        "clusterName": "OtaSoftwareUpdateProvider",
        "clusterId": 0x00000029,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "QueryImage",
                "args": {
                    "vendorID": "int",
                    "productID": "int",
                    "softwareVersion": "int",
                    "protocolsSupported": "int",
                    "hardwareVersion": "int",
                    "location": "str",
                    "requestorCanConsent": "bool",
                    "metadataForProvider": "bytes",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "ApplyUpdateRequest",
                "args": {
                    "updateToken": "bytes",
                    "newVersion": "int",
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "NotifyUpdateApplied",
                "args": {
                    "updateToken": "bytes",
                    "softwareVersion": "int",
                },
            },
        },
        "attributes": {
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _OTA_SOFTWARE_UPDATE_REQUESTOR_CLUSTER_INFO = {
        "clusterName": "OtaSoftwareUpdateRequestor",
        "clusterId": 0x0000002A,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "AnnounceOTAProvider",
                "args": {
                    "providerNodeID": "int",
                    "vendorID": "int",
                    "announcementReason": "int",
                    "metadataForNode": "bytes",
                    "endpoint": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "DefaultOTAProviders",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00000001: {
                "attributeName": "UpdatePossible",
                "attributeId": 0x00000001,
                "type": "bool",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "UpdateState",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "UpdateStateProgress",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _LOCALIZATION_CONFIGURATION_CLUSTER_INFO = {
        "clusterName": "LocalizationConfiguration",
        "clusterId": 0x0000002B,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "ActiveLocale",
                "attributeId": 0x00000000,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x00000001: {
                "attributeName": "SupportedLocales",
                "attributeId": 0x00000001,
                "type": "str",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _TIME_FORMAT_LOCALIZATION_CLUSTER_INFO = {
        "clusterName": "TimeFormatLocalization",
        "clusterId": 0x0000002C,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "HourFormat",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000001: {
                "attributeName": "ActiveCalendarType",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000002: {
                "attributeName": "SupportedCalendarTypes",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _UNIT_LOCALIZATION_CLUSTER_INFO = {
        "clusterName": "UnitLocalization",
        "clusterId": 0x0000002D,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "TemperatureUnit",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _POWER_SOURCE_CONFIGURATION_CLUSTER_INFO = {
        "clusterName": "PowerSourceConfiguration",
        "clusterId": 0x0000002E,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Sources",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _POWER_SOURCE_CLUSTER_INFO = {
        "clusterName": "PowerSource",
        "clusterId": 0x0000002F,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Status",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "Order",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "Description",
                "attributeId": 0x00000002,
                "type": "str",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "WiredAssessedInputVoltage",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "WiredAssessedInputFrequency",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "WiredCurrentType",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "WiredAssessedCurrent",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "WiredNominalVoltage",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "WiredMaximumCurrent",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "WiredPresent",
                "attributeId": 0x00000009,
                "type": "bool",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "ActiveWiredFaults",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000000B: {
                "attributeName": "BatVoltage",
                "attributeId": 0x0000000B,
                "type": "int",
                "reportable": True,
            },
            0x0000000C: {
                "attributeName": "BatPercentRemaining",
                "attributeId": 0x0000000C,
                "type": "int",
                "reportable": True,
            },
            0x0000000D: {
                "attributeName": "BatTimeRemaining",
                "attributeId": 0x0000000D,
                "type": "int",
                "reportable": True,
            },
            0x0000000E: {
                "attributeName": "BatChargeLevel",
                "attributeId": 0x0000000E,
                "type": "int",
                "reportable": True,
            },
            0x0000000F: {
                "attributeName": "BatReplacementNeeded",
                "attributeId": 0x0000000F,
                "type": "bool",
                "reportable": True,
            },
            0x00000010: {
                "attributeName": "BatReplaceability",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
            },
            0x00000011: {
                "attributeName": "BatPresent",
                "attributeId": 0x00000011,
                "type": "bool",
                "reportable": True,
            },
            0x00000012: {
                "attributeName": "ActiveBatFaults",
                "attributeId": 0x00000012,
                "type": "int",
                "reportable": True,
            },
            0x00000013: {
                "attributeName": "BatReplacementDescription",
                "attributeId": 0x00000013,
                "type": "str",
                "reportable": True,
            },
            0x00000014: {
                "attributeName": "BatCommonDesignation",
                "attributeId": 0x00000014,
                "type": "int",
                "reportable": True,
            },
            0x00000015: {
                "attributeName": "BatANSIDesignation",
                "attributeId": 0x00000015,
                "type": "str",
                "reportable": True,
            },
            0x00000016: {
                "attributeName": "BatIECDesignation",
                "attributeId": 0x00000016,
                "type": "str",
                "reportable": True,
            },
            0x00000017: {
                "attributeName": "BatApprovedChemistry",
                "attributeId": 0x00000017,
                "type": "int",
                "reportable": True,
            },
            0x00000018: {
                "attributeName": "BatCapacity",
                "attributeId": 0x00000018,
                "type": "int",
                "reportable": True,
            },
            0x00000019: {
                "attributeName": "BatQuantity",
                "attributeId": 0x00000019,
                "type": "int",
                "reportable": True,
            },
            0x0000001A: {
                "attributeName": "BatChargeState",
                "attributeId": 0x0000001A,
                "type": "int",
                "reportable": True,
            },
            0x0000001B: {
                "attributeName": "BatTimeToFullCharge",
                "attributeId": 0x0000001B,
                "type": "int",
                "reportable": True,
            },
            0x0000001C: {
                "attributeName": "BatFunctionalWhileCharging",
                "attributeId": 0x0000001C,
                "type": "bool",
                "reportable": True,
            },
            0x0000001D: {
                "attributeName": "BatChargingCurrent",
                "attributeId": 0x0000001D,
                "type": "int",
                "reportable": True,
            },
            0x0000001E: {
                "attributeName": "ActiveBatChargeFaults",
                "attributeId": 0x0000001E,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _GENERAL_COMMISSIONING_CLUSTER_INFO = {
        "clusterName": "GeneralCommissioning",
        "clusterId": 0x00000030,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ArmFailSafe",
                "args": {
                    "expiryLengthSeconds": "int",
                    "breadcrumb": "int",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "SetRegulatoryConfig",
                "args": {
                    "newRegulatoryConfig": "int",
                    "countryCode": "str",
                    "breadcrumb": "int",
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "CommissioningComplete",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Breadcrumb",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000001: {
                "attributeName": "BasicCommissioningInfo",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "RegulatoryConfig",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "LocationCapability",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "SupportsConcurrentConnection",
                "attributeId": 0x00000004,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _NETWORK_COMMISSIONING_CLUSTER_INFO = {
        "clusterName": "NetworkCommissioning",
        "clusterId": 0x00000031,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ScanNetworks",
                "args": {
                    "ssid": "bytes",
                    "breadcrumb": "int",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "AddOrUpdateWiFiNetwork",
                "args": {
                    "ssid": "bytes",
                    "credentials": "bytes",
                    "breadcrumb": "int",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "AddOrUpdateThreadNetwork",
                "args": {
                    "operationalDataset": "bytes",
                    "breadcrumb": "int",
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "RemoveNetwork",
                "args": {
                    "networkID": "bytes",
                    "breadcrumb": "int",
                },
            },
            0x00000006: {
                "commandId": 0x00000006,
                "commandName": "ConnectNetwork",
                "args": {
                    "networkID": "bytes",
                    "breadcrumb": "int",
                },
            },
            0x00000008: {
                "commandId": 0x00000008,
                "commandName": "ReorderNetwork",
                "args": {
                    "networkID": "bytes",
                    "networkIndex": "int",
                    "breadcrumb": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MaxNetworks",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "Networks",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ScanMaxTimeSeconds",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "ConnectMaxTimeSeconds",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "InterfaceEnabled",
                "attributeId": 0x00000004,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00000005: {
                "attributeName": "LastNetworkingStatus",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "LastNetworkID",
                "attributeId": 0x00000006,
                "type": "bytes",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "LastConnectErrorValue",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _DIAGNOSTIC_LOGS_CLUSTER_INFO = {
        "clusterName": "DiagnosticLogs",
        "clusterId": 0x00000032,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "RetrieveLogsRequest",
                "args": {
                    "intent": "int",
                    "requestedProtocol": "int",
                    "transferFileDesignator": "str",
                },
            },
        },
        "attributes": {
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _GENERAL_DIAGNOSTICS_CLUSTER_INFO = {
        "clusterName": "GeneralDiagnostics",
        "clusterId": 0x00000033,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "TestEventTrigger",
                "args": {
                    "enableKey": "bytes",
                    "eventTrigger": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "NetworkInterfaces",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "RebootCount",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "UpTime",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "TotalOperationalHours",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "BootReason",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "ActiveHardwareFaults",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "ActiveRadioFaults",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "ActiveNetworkFaults",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "TestEventTriggersEnabled",
                "attributeId": 0x00000008,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _SOFTWARE_DIAGNOSTICS_CLUSTER_INFO = {
        "clusterName": "SoftwareDiagnostics",
        "clusterId": 0x00000034,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetWatermarks",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "ThreadMetrics",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "CurrentHeapFree",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "CurrentHeapUsed",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "CurrentHeapHighWatermark",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _THREAD_NETWORK_DIAGNOSTICS_CLUSTER_INFO = {
        "clusterName": "ThreadNetworkDiagnostics",
        "clusterId": 0x00000035,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCounts",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Channel",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "RoutingRole",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "NetworkName",
                "attributeId": 0x00000002,
                "type": "str",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PanId",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "ExtendedPanId",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "MeshLocalPrefix",
                "attributeId": 0x00000005,
                "type": "bytes",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "OverrunCount",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "NeighborTable",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "RouteTable",
                "attributeId": 0x00000008,
                "type": "",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "PartitionId",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "Weighting",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000000B: {
                "attributeName": "DataVersion",
                "attributeId": 0x0000000B,
                "type": "int",
                "reportable": True,
            },
            0x0000000C: {
                "attributeName": "StableDataVersion",
                "attributeId": 0x0000000C,
                "type": "int",
                "reportable": True,
            },
            0x0000000D: {
                "attributeName": "LeaderRouterId",
                "attributeId": 0x0000000D,
                "type": "int",
                "reportable": True,
            },
            0x0000000E: {
                "attributeName": "DetachedRoleCount",
                "attributeId": 0x0000000E,
                "type": "int",
                "reportable": True,
            },
            0x0000000F: {
                "attributeName": "ChildRoleCount",
                "attributeId": 0x0000000F,
                "type": "int",
                "reportable": True,
            },
            0x00000010: {
                "attributeName": "RouterRoleCount",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
            },
            0x00000011: {
                "attributeName": "LeaderRoleCount",
                "attributeId": 0x00000011,
                "type": "int",
                "reportable": True,
            },
            0x00000012: {
                "attributeName": "AttachAttemptCount",
                "attributeId": 0x00000012,
                "type": "int",
                "reportable": True,
            },
            0x00000013: {
                "attributeName": "PartitionIdChangeCount",
                "attributeId": 0x00000013,
                "type": "int",
                "reportable": True,
            },
            0x00000014: {
                "attributeName": "BetterPartitionAttachAttemptCount",
                "attributeId": 0x00000014,
                "type": "int",
                "reportable": True,
            },
            0x00000015: {
                "attributeName": "ParentChangeCount",
                "attributeId": 0x00000015,
                "type": "int",
                "reportable": True,
            },
            0x00000016: {
                "attributeName": "TxTotalCount",
                "attributeId": 0x00000016,
                "type": "int",
                "reportable": True,
            },
            0x00000017: {
                "attributeName": "TxUnicastCount",
                "attributeId": 0x00000017,
                "type": "int",
                "reportable": True,
            },
            0x00000018: {
                "attributeName": "TxBroadcastCount",
                "attributeId": 0x00000018,
                "type": "int",
                "reportable": True,
            },
            0x00000019: {
                "attributeName": "TxAckRequestedCount",
                "attributeId": 0x00000019,
                "type": "int",
                "reportable": True,
            },
            0x0000001A: {
                "attributeName": "TxAckedCount",
                "attributeId": 0x0000001A,
                "type": "int",
                "reportable": True,
            },
            0x0000001B: {
                "attributeName": "TxNoAckRequestedCount",
                "attributeId": 0x0000001B,
                "type": "int",
                "reportable": True,
            },
            0x0000001C: {
                "attributeName": "TxDataCount",
                "attributeId": 0x0000001C,
                "type": "int",
                "reportable": True,
            },
            0x0000001D: {
                "attributeName": "TxDataPollCount",
                "attributeId": 0x0000001D,
                "type": "int",
                "reportable": True,
            },
            0x0000001E: {
                "attributeName": "TxBeaconCount",
                "attributeId": 0x0000001E,
                "type": "int",
                "reportable": True,
            },
            0x0000001F: {
                "attributeName": "TxBeaconRequestCount",
                "attributeId": 0x0000001F,
                "type": "int",
                "reportable": True,
            },
            0x00000020: {
                "attributeName": "TxOtherCount",
                "attributeId": 0x00000020,
                "type": "int",
                "reportable": True,
            },
            0x00000021: {
                "attributeName": "TxRetryCount",
                "attributeId": 0x00000021,
                "type": "int",
                "reportable": True,
            },
            0x00000022: {
                "attributeName": "TxDirectMaxRetryExpiryCount",
                "attributeId": 0x00000022,
                "type": "int",
                "reportable": True,
            },
            0x00000023: {
                "attributeName": "TxIndirectMaxRetryExpiryCount",
                "attributeId": 0x00000023,
                "type": "int",
                "reportable": True,
            },
            0x00000024: {
                "attributeName": "TxErrCcaCount",
                "attributeId": 0x00000024,
                "type": "int",
                "reportable": True,
            },
            0x00000025: {
                "attributeName": "TxErrAbortCount",
                "attributeId": 0x00000025,
                "type": "int",
                "reportable": True,
            },
            0x00000026: {
                "attributeName": "TxErrBusyChannelCount",
                "attributeId": 0x00000026,
                "type": "int",
                "reportable": True,
            },
            0x00000027: {
                "attributeName": "RxTotalCount",
                "attributeId": 0x00000027,
                "type": "int",
                "reportable": True,
            },
            0x00000028: {
                "attributeName": "RxUnicastCount",
                "attributeId": 0x00000028,
                "type": "int",
                "reportable": True,
            },
            0x00000029: {
                "attributeName": "RxBroadcastCount",
                "attributeId": 0x00000029,
                "type": "int",
                "reportable": True,
            },
            0x0000002A: {
                "attributeName": "RxDataCount",
                "attributeId": 0x0000002A,
                "type": "int",
                "reportable": True,
            },
            0x0000002B: {
                "attributeName": "RxDataPollCount",
                "attributeId": 0x0000002B,
                "type": "int",
                "reportable": True,
            },
            0x0000002C: {
                "attributeName": "RxBeaconCount",
                "attributeId": 0x0000002C,
                "type": "int",
                "reportable": True,
            },
            0x0000002D: {
                "attributeName": "RxBeaconRequestCount",
                "attributeId": 0x0000002D,
                "type": "int",
                "reportable": True,
            },
            0x0000002E: {
                "attributeName": "RxOtherCount",
                "attributeId": 0x0000002E,
                "type": "int",
                "reportable": True,
            },
            0x0000002F: {
                "attributeName": "RxAddressFilteredCount",
                "attributeId": 0x0000002F,
                "type": "int",
                "reportable": True,
            },
            0x00000030: {
                "attributeName": "RxDestAddrFilteredCount",
                "attributeId": 0x00000030,
                "type": "int",
                "reportable": True,
            },
            0x00000031: {
                "attributeName": "RxDuplicatedCount",
                "attributeId": 0x00000031,
                "type": "int",
                "reportable": True,
            },
            0x00000032: {
                "attributeName": "RxErrNoFrameCount",
                "attributeId": 0x00000032,
                "type": "int",
                "reportable": True,
            },
            0x00000033: {
                "attributeName": "RxErrUnknownNeighborCount",
                "attributeId": 0x00000033,
                "type": "int",
                "reportable": True,
            },
            0x00000034: {
                "attributeName": "RxErrInvalidSrcAddrCount",
                "attributeId": 0x00000034,
                "type": "int",
                "reportable": True,
            },
            0x00000035: {
                "attributeName": "RxErrSecCount",
                "attributeId": 0x00000035,
                "type": "int",
                "reportable": True,
            },
            0x00000036: {
                "attributeName": "RxErrFcsCount",
                "attributeId": 0x00000036,
                "type": "int",
                "reportable": True,
            },
            0x00000037: {
                "attributeName": "RxErrOtherCount",
                "attributeId": 0x00000037,
                "type": "int",
                "reportable": True,
            },
            0x00000038: {
                "attributeName": "ActiveTimestamp",
                "attributeId": 0x00000038,
                "type": "int",
                "reportable": True,
            },
            0x00000039: {
                "attributeName": "PendingTimestamp",
                "attributeId": 0x00000039,
                "type": "int",
                "reportable": True,
            },
            0x0000003A: {
                "attributeName": "Delay",
                "attributeId": 0x0000003A,
                "type": "int",
                "reportable": True,
            },
            0x0000003B: {
                "attributeName": "SecurityPolicy",
                "attributeId": 0x0000003B,
                "type": "",
                "reportable": True,
            },
            0x0000003C: {
                "attributeName": "ChannelPage0Mask",
                "attributeId": 0x0000003C,
                "type": "bytes",
                "reportable": True,
            },
            0x0000003D: {
                "attributeName": "OperationalDatasetComponents",
                "attributeId": 0x0000003D,
                "type": "",
                "reportable": True,
            },
            0x0000003E: {
                "attributeName": "ActiveNetworkFaultsList",
                "attributeId": 0x0000003E,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _WI_FI_NETWORK_DIAGNOSTICS_CLUSTER_INFO = {
        "clusterName": "WiFiNetworkDiagnostics",
        "clusterId": 0x00000036,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCounts",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Bssid",
                "attributeId": 0x00000000,
                "type": "bytes",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "SecurityType",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "WiFiVersion",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "ChannelNumber",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "Rssi",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "BeaconLostCount",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "BeaconRxCount",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "PacketMulticastRxCount",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "PacketMulticastTxCount",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "PacketUnicastRxCount",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "PacketUnicastTxCount",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000000B: {
                "attributeName": "CurrentMaxRate",
                "attributeId": 0x0000000B,
                "type": "int",
                "reportable": True,
            },
            0x0000000C: {
                "attributeName": "OverrunCount",
                "attributeId": 0x0000000C,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ETHERNET_NETWORK_DIAGNOSTICS_CLUSTER_INFO = {
        "clusterName": "EthernetNetworkDiagnostics",
        "clusterId": 0x00000037,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCounts",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "PHYRate",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "FullDuplex",
                "attributeId": 0x00000001,
                "type": "bool",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "PacketRxCount",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PacketTxCount",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "TxErrCount",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "CollisionCount",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "OverrunCount",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "CarrierDetect",
                "attributeId": 0x00000007,
                "type": "bool",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "TimeSinceReset",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _TIME_SYNCHRONIZATION_CLUSTER_INFO = {
        "clusterName": "TimeSynchronization",
        "clusterId": 0x00000038,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "SetUTCTime",
                "args": {
                    "UTCTime": "int",
                    "granularity": "int",
                    "timeSource": "int",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "SetTrustedTimeSource",
                "args": {
                    "trustedTimeSource": "FabricScopedTrustedTimeSourceStruct",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "SetTimeZone",
                "args": {
                    "timeZone": "TimeZoneStruct",
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "SetDSTOffset",
                "args": {
                    "DSTOffset": "DSTOffsetStruct",
                },
            },
            0x00000005: {
                "commandId": 0x00000005,
                "commandName": "SetDefaultNTP",
                "args": {
                    "defaultNTP": "str",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "UTCTime",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "Granularity",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "TimeSource",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "TrustedTimeSource",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "DefaultNTP",
                "attributeId": 0x00000004,
                "type": "str",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "TimeZone",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "DSTOffset",
                "attributeId": 0x00000006,
                "type": "",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "LocalTime",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "TimeZoneDatabase",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "NTPServerAvailable",
                "attributeId": 0x00000009,
                "type": "bool",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "TimeZoneListMaxSize",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000000B: {
                "attributeName": "DSTOffsetListMaxSize",
                "attributeId": 0x0000000B,
                "type": "int",
                "reportable": True,
            },
            0x0000000C: {
                "attributeName": "SupportsDNSResolve",
                "attributeId": 0x0000000C,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _BRIDGED_DEVICE_BASIC_INFORMATION_CLUSTER_INFO = {
        "clusterName": "BridgedDeviceBasicInformation",
        "clusterId": 0x00000039,
        "commands": {
        },
        "attributes": {
            0x00000001: {
                "attributeName": "VendorName",
                "attributeId": 0x00000001,
                "type": "str",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "VendorID",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "ProductName",
                "attributeId": 0x00000003,
                "type": "str",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "NodeLabel",
                "attributeId": 0x00000005,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x00000007: {
                "attributeName": "HardwareVersion",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "HardwareVersionString",
                "attributeId": 0x00000008,
                "type": "str",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "SoftwareVersion",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "SoftwareVersionString",
                "attributeId": 0x0000000A,
                "type": "str",
                "reportable": True,
            },
            0x0000000B: {
                "attributeName": "ManufacturingDate",
                "attributeId": 0x0000000B,
                "type": "str",
                "reportable": True,
            },
            0x0000000C: {
                "attributeName": "PartNumber",
                "attributeId": 0x0000000C,
                "type": "str",
                "reportable": True,
            },
            0x0000000D: {
                "attributeName": "ProductURL",
                "attributeId": 0x0000000D,
                "type": "str",
                "reportable": True,
            },
            0x0000000E: {
                "attributeName": "ProductLabel",
                "attributeId": 0x0000000E,
                "type": "str",
                "reportable": True,
            },
            0x0000000F: {
                "attributeName": "SerialNumber",
                "attributeId": 0x0000000F,
                "type": "str",
                "reportable": True,
            },
            0x00000011: {
                "attributeName": "Reachable",
                "attributeId": 0x00000011,
                "type": "bool",
                "reportable": True,
            },
            0x00000012: {
                "attributeName": "UniqueID",
                "attributeId": 0x00000012,
                "type": "str",
                "reportable": True,
            },
            0x00000014: {
                "attributeName": "ProductAppearance",
                "attributeId": 0x00000014,
                "type": "",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _SWITCH_CLUSTER_INFO = {
        "clusterName": "Switch",
        "clusterId": 0x0000003B,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "NumberOfPositions",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "CurrentPosition",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MultiPressMax",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ADMINISTRATOR_COMMISSIONING_CLUSTER_INFO = {
        "clusterName": "AdministratorCommissioning",
        "clusterId": 0x0000003C,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "OpenCommissioningWindow",
                "args": {
                    "commissioningTimeout": "int",
                    "PAKEPasscodeVerifier": "bytes",
                    "discriminator": "int",
                    "iterations": "int",
                    "salt": "bytes",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "OpenBasicCommissioningWindow",
                "args": {
                    "commissioningTimeout": "int",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "RevokeCommissioning",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "WindowStatus",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "AdminFabricIndex",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "AdminVendorId",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _OPERATIONAL_CREDENTIALS_CLUSTER_INFO = {
        "clusterName": "OperationalCredentials",
        "clusterId": 0x0000003E,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "AttestationRequest",
                "args": {
                    "attestationNonce": "bytes",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "CertificateChainRequest",
                "args": {
                    "certificateType": "int",
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "CSRRequest",
                "args": {
                    "CSRNonce": "bytes",
                    "isForUpdateNOC": "bool",
                },
            },
            0x00000006: {
                "commandId": 0x00000006,
                "commandName": "AddNOC",
                "args": {
                    "NOCValue": "bytes",
                    "ICACValue": "bytes",
                    "IPKValue": "bytes",
                    "caseAdminSubject": "int",
                    "adminVendorId": "int",
                },
            },
            0x00000007: {
                "commandId": 0x00000007,
                "commandName": "UpdateNOC",
                "args": {
                    "NOCValue": "bytes",
                    "ICACValue": "bytes",
                },
            },
            0x00000009: {
                "commandId": 0x00000009,
                "commandName": "UpdateFabricLabel",
                "args": {
                    "label": "str",
                },
            },
            0x0000000A: {
                "commandId": 0x0000000A,
                "commandName": "RemoveFabric",
                "args": {
                    "fabricIndex": "int",
                },
            },
            0x0000000B: {
                "commandId": 0x0000000B,
                "commandName": "AddTrustedRootCertificate",
                "args": {
                    "rootCACertificate": "bytes",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "NOCs",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "Fabrics",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "SupportedFabrics",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "CommissionedFabrics",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "TrustedRootCertificates",
                "attributeId": 0x00000004,
                "type": "bytes",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "CurrentFabricIndex",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _GROUP_KEY_MANAGEMENT_CLUSTER_INFO = {
        "clusterName": "GroupKeyManagement",
        "clusterId": 0x0000003F,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "KeySetWrite",
                "args": {
                    "groupKeySet": "GroupKeySetStruct",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "KeySetRead",
                "args": {
                    "groupKeySetID": "int",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "KeySetRemove",
                "args": {
                    "groupKeySetID": "int",
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "KeySetReadAllIndices",
                "args": {
                    "groupKeySetIDs": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "GroupKeyMap",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00000001: {
                "attributeName": "GroupTable",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxGroupsPerFabric",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "MaxGroupKeysPerFabric",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _FIXED_LABEL_CLUSTER_INFO = {
        "clusterName": "FixedLabel",
        "clusterId": 0x00000040,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "LabelList",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _USER_LABEL_CLUSTER_INFO = {
        "clusterName": "UserLabel",
        "clusterId": 0x00000041,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "LabelList",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _PROXY_CONFIGURATION_CLUSTER_INFO = {
        "clusterName": "ProxyConfiguration",
        "clusterId": 0x00000042,
        "commands": {
        },
        "attributes": {
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _PROXY_DISCOVERY_CLUSTER_INFO = {
        "clusterName": "ProxyDiscovery",
        "clusterId": 0x00000043,
        "commands": {
        },
        "attributes": {
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _PROXY_VALID_CLUSTER_INFO = {
        "clusterName": "ProxyValid",
        "clusterId": 0x00000044,
        "commands": {
        },
        "attributes": {
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _BOOLEAN_STATE_CLUSTER_INFO = {
        "clusterName": "BooleanState",
        "clusterId": 0x00000045,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "StateValue",
                "attributeId": 0x00000000,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ICD_MANAGEMENT_CLUSTER_INFO = {
        "clusterName": "IcdManagement",
        "clusterId": 0x00000046,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "RegisterClient",
                "args": {
                    "checkInNodeID": "int",
                    "monitoredSubject": "int",
                    "key": "bytes",
                    "verificationKey": "bytes",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "UnregisterClient",
                "args": {
                    "checkInNodeID": "int",
                    "key": "bytes",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "StayActiveRequest",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "IdleModeInterval",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "ActiveModeInterval",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ActiveModeThreshold",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "RegisteredClients",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "ICDCounter",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "ClientsSupportedPerFabric",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _MODE_SELECT_CLUSTER_INFO = {
        "clusterName": "ModeSelect",
        "clusterId": 0x00000050,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ChangeToMode",
                "args": {
                    "newMode": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Description",
                "attributeId": 0x00000000,
                "type": "str",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "StandardNamespace",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "SupportedModes",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "CurrentMode",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "StartUpMode",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000005: {
                "attributeName": "OnMode",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _TEMPERATURE_CONTROL_CLUSTER_INFO = {
        "clusterName": "TemperatureControl",
        "clusterId": 0x00000056,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "SetTemperature",
                "args": {
                    "targetTemperature": "int",
                    "targetTemperatureLevel": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "TemperatureSetpoint",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinTemperature",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxTemperature",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "Step",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "CurrentTemperatureLevelIndex",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "SupportedTemperatureLevels",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _REFRIGERATOR_ALARM_CLUSTER_INFO = {
        "clusterName": "RefrigeratorAlarm",
        "clusterId": 0x00000057,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "Reset",
                "args": {
                    "alarms": "int",
                    "mask": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Mask",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000001: {
                "attributeName": "Latch",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "State",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _AIR_QUALITY_CLUSTER_INFO = {
        "clusterName": "AirQuality",
        "clusterId": 0x0000005B,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "AirQuality",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _SMOKE_CO_ALARM_CLUSTER_INFO = {
        "clusterName": "SmokeCoAlarm",
        "clusterId": 0x0000005C,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "SelfTestRequest",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "ExpressedState",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "SmokeState",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "COState",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "BatteryAlert",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "DeviceMuted",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "TestInProgress",
                "attributeId": 0x00000005,
                "type": "bool",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "HardwareFaultAlert",
                "attributeId": 0x00000006,
                "type": "bool",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "EndOfServiceAlert",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "InterconnectSmokeAlarm",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "InterconnectCOAlarm",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "ContaminationState",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000000B: {
                "attributeName": "SensitivityLevel",
                "attributeId": 0x0000000B,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _OPERATIONAL_STATE_CLUSTER_INFO = {
        "clusterName": "OperationalState",
        "clusterId": 0x00000060,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "Pause",
                "args": {
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "Stop",
                "args": {
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "Start",
                "args": {
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "Resume",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "PhaseList",
                "attributeId": 0x00000000,
                "type": "str",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "CurrentPhase",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "CountdownTime",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "OperationalStateList",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "OperationalState",
                "attributeId": 0x00000004,
                "type": "",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "OperationalError",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _HEPA_FILTER_MONITORING_CLUSTER_INFO = {
        "clusterName": "HepaFilterMonitoring",
        "clusterId": 0x00000071,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ACTIVATED_CARBON_FILTER_MONITORING_CLUSTER_INFO = {
        "clusterName": "ActivatedCarbonFilterMonitoring",
        "clusterId": 0x00000072,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _CERAMIC_FILTER_MONITORING_CLUSTER_INFO = {
        "clusterName": "CeramicFilterMonitoring",
        "clusterId": 0x00000073,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ELECTROSTATIC_FILTER_MONITORING_CLUSTER_INFO = {
        "clusterName": "ElectrostaticFilterMonitoring",
        "clusterId": 0x00000074,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _UV_FILTER_MONITORING_CLUSTER_INFO = {
        "clusterName": "UvFilterMonitoring",
        "clusterId": 0x00000075,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _IONIZING_FILTER_MONITORING_CLUSTER_INFO = {
        "clusterName": "IonizingFilterMonitoring",
        "clusterId": 0x00000076,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ZEOLITE_FILTER_MONITORING_CLUSTER_INFO = {
        "clusterName": "ZeoliteFilterMonitoring",
        "clusterId": 0x00000077,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _OZONE_FILTER_MONITORING_CLUSTER_INFO = {
        "clusterName": "OzoneFilterMonitoring",
        "clusterId": 0x00000078,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _WATER_TANK_MONITORING_CLUSTER_INFO = {
        "clusterName": "WaterTankMonitoring",
        "clusterId": 0x00000079,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _FUEL_TANK_MONITORING_CLUSTER_INFO = {
        "clusterName": "FuelTankMonitoring",
        "clusterId": 0x0000007A,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _INK_CARTRIDGE_MONITORING_CLUSTER_INFO = {
        "clusterName": "InkCartridgeMonitoring",
        "clusterId": 0x0000007B,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _TONER_CARTRIDGE_MONITORING_CLUSTER_INFO = {
        "clusterName": "TonerCartridgeMonitoring",
        "clusterId": 0x0000007C,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ResetCondition",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Condition",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "DegradationDirection",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ChangeIndication",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "InPlaceIndicator",
                "attributeId": 0x00000003,
                "type": "bool",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _DOOR_LOCK_CLUSTER_INFO = {
        "clusterName": "DoorLock",
        "clusterId": 0x00000101,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "LockDoor",
                "args": {
                    "PINCode": "bytes",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "UnlockDoor",
                "args": {
                    "PINCode": "bytes",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "UnlockWithTimeout",
                "args": {
                    "timeout": "int",
                    "PINCode": "bytes",
                },
            },
            0x0000000B: {
                "commandId": 0x0000000B,
                "commandName": "SetWeekDaySchedule",
                "args": {
                    "weekDayIndex": "int",
                    "userIndex": "int",
                    "daysMask": "int",
                    "startHour": "int",
                    "startMinute": "int",
                    "endHour": "int",
                    "endMinute": "int",
                },
            },
            0x0000000C: {
                "commandId": 0x0000000C,
                "commandName": "GetWeekDaySchedule",
                "args": {
                    "weekDayIndex": "int",
                    "userIndex": "int",
                },
            },
            0x0000000D: {
                "commandId": 0x0000000D,
                "commandName": "ClearWeekDaySchedule",
                "args": {
                    "weekDayIndex": "int",
                    "userIndex": "int",
                },
            },
            0x0000000E: {
                "commandId": 0x0000000E,
                "commandName": "SetYearDaySchedule",
                "args": {
                    "yearDayIndex": "int",
                    "userIndex": "int",
                    "localStartTime": "int",
                    "localEndTime": "int",
                },
            },
            0x0000000F: {
                "commandId": 0x0000000F,
                "commandName": "GetYearDaySchedule",
                "args": {
                    "yearDayIndex": "int",
                    "userIndex": "int",
                },
            },
            0x00000010: {
                "commandId": 0x00000010,
                "commandName": "ClearYearDaySchedule",
                "args": {
                    "yearDayIndex": "int",
                    "userIndex": "int",
                },
            },
            0x00000011: {
                "commandId": 0x00000011,
                "commandName": "SetHolidaySchedule",
                "args": {
                    "holidayIndex": "int",
                    "localStartTime": "int",
                    "localEndTime": "int",
                    "operatingMode": "int",
                },
            },
            0x00000012: {
                "commandId": 0x00000012,
                "commandName": "GetHolidaySchedule",
                "args": {
                    "holidayIndex": "int",
                },
            },
            0x00000013: {
                "commandId": 0x00000013,
                "commandName": "ClearHolidaySchedule",
                "args": {
                    "holidayIndex": "int",
                },
            },
            0x0000001A: {
                "commandId": 0x0000001A,
                "commandName": "SetUser",
                "args": {
                    "operationType": "int",
                    "userIndex": "int",
                    "userName": "str",
                    "userUniqueID": "int",
                    "userStatus": "int",
                    "userType": "int",
                    "credentialRule": "int",
                },
            },
            0x0000001B: {
                "commandId": 0x0000001B,
                "commandName": "GetUser",
                "args": {
                    "userIndex": "int",
                },
            },
            0x0000001D: {
                "commandId": 0x0000001D,
                "commandName": "ClearUser",
                "args": {
                    "userIndex": "int",
                },
            },
            0x00000022: {
                "commandId": 0x00000022,
                "commandName": "SetCredential",
                "args": {
                    "operationType": "int",
                    "credential": "CredentialStruct",
                    "credentialData": "bytes",
                    "userIndex": "int",
                    "userStatus": "int",
                    "userType": "int",
                },
            },
            0x00000024: {
                "commandId": 0x00000024,
                "commandName": "GetCredentialStatus",
                "args": {
                    "credential": "CredentialStruct",
                },
            },
            0x00000026: {
                "commandId": 0x00000026,
                "commandName": "ClearCredential",
                "args": {
                    "credential": "CredentialStruct",
                },
            },
            0x00000027: {
                "commandId": 0x00000027,
                "commandName": "UnboltDoor",
                "args": {
                    "PINCode": "bytes",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "LockState",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "LockType",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ActuatorEnabled",
                "attributeId": 0x00000002,
                "type": "bool",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "DoorState",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "DoorOpenEvents",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000005: {
                "attributeName": "DoorClosedEvents",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000006: {
                "attributeName": "OpenPeriod",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000011: {
                "attributeName": "NumberOfTotalUsersSupported",
                "attributeId": 0x00000011,
                "type": "int",
                "reportable": True,
            },
            0x00000012: {
                "attributeName": "NumberOfPINUsersSupported",
                "attributeId": 0x00000012,
                "type": "int",
                "reportable": True,
            },
            0x00000013: {
                "attributeName": "NumberOfRFIDUsersSupported",
                "attributeId": 0x00000013,
                "type": "int",
                "reportable": True,
            },
            0x00000014: {
                "attributeName": "NumberOfWeekDaySchedulesSupportedPerUser",
                "attributeId": 0x00000014,
                "type": "int",
                "reportable": True,
            },
            0x00000015: {
                "attributeName": "NumberOfYearDaySchedulesSupportedPerUser",
                "attributeId": 0x00000015,
                "type": "int",
                "reportable": True,
            },
            0x00000016: {
                "attributeName": "NumberOfHolidaySchedulesSupported",
                "attributeId": 0x00000016,
                "type": "int",
                "reportable": True,
            },
            0x00000017: {
                "attributeName": "MaxPINCodeLength",
                "attributeId": 0x00000017,
                "type": "int",
                "reportable": True,
            },
            0x00000018: {
                "attributeName": "MinPINCodeLength",
                "attributeId": 0x00000018,
                "type": "int",
                "reportable": True,
            },
            0x00000019: {
                "attributeName": "MaxRFIDCodeLength",
                "attributeId": 0x00000019,
                "type": "int",
                "reportable": True,
            },
            0x0000001A: {
                "attributeName": "MinRFIDCodeLength",
                "attributeId": 0x0000001A,
                "type": "int",
                "reportable": True,
            },
            0x0000001B: {
                "attributeName": "CredentialRulesSupport",
                "attributeId": 0x0000001B,
                "type": "int",
                "reportable": True,
            },
            0x0000001C: {
                "attributeName": "NumberOfCredentialsSupportedPerUser",
                "attributeId": 0x0000001C,
                "type": "int",
                "reportable": True,
            },
            0x00000021: {
                "attributeName": "Language",
                "attributeId": 0x00000021,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x00000022: {
                "attributeName": "LEDSettings",
                "attributeId": 0x00000022,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000023: {
                "attributeName": "AutoRelockTime",
                "attributeId": 0x00000023,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000024: {
                "attributeName": "SoundVolume",
                "attributeId": 0x00000024,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000025: {
                "attributeName": "OperatingMode",
                "attributeId": 0x00000025,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000026: {
                "attributeName": "SupportedOperatingModes",
                "attributeId": 0x00000026,
                "type": "int",
                "reportable": True,
            },
            0x00000027: {
                "attributeName": "DefaultConfigurationRegister",
                "attributeId": 0x00000027,
                "type": "int",
                "reportable": True,
            },
            0x00000028: {
                "attributeName": "EnableLocalProgramming",
                "attributeId": 0x00000028,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00000029: {
                "attributeName": "EnableOneTouchLocking",
                "attributeId": 0x00000029,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x0000002A: {
                "attributeName": "EnableInsideStatusLED",
                "attributeId": 0x0000002A,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x0000002B: {
                "attributeName": "EnablePrivacyModeButton",
                "attributeId": 0x0000002B,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x0000002C: {
                "attributeName": "LocalProgrammingFeatures",
                "attributeId": 0x0000002C,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000030: {
                "attributeName": "WrongCodeEntryLimit",
                "attributeId": 0x00000030,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000031: {
                "attributeName": "UserCodeTemporaryDisableTime",
                "attributeId": 0x00000031,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000032: {
                "attributeName": "SendPINOverTheAir",
                "attributeId": 0x00000032,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00000033: {
                "attributeName": "RequirePINforRemoteOperation",
                "attributeId": 0x00000033,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00000035: {
                "attributeName": "ExpiringUserTimeout",
                "attributeId": 0x00000035,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _WINDOW_COVERING_CLUSTER_INFO = {
        "clusterName": "WindowCovering",
        "clusterId": 0x00000102,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "UpOrOpen",
                "args": {
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "DownOrClose",
                "args": {
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "StopMotion",
                "args": {
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "GoToLiftValue",
                "args": {
                    "liftValue": "int",
                },
            },
            0x00000005: {
                "commandId": 0x00000005,
                "commandName": "GoToLiftPercentage",
                "args": {
                    "liftPercent100thsValue": "int",
                },
            },
            0x00000007: {
                "commandId": 0x00000007,
                "commandName": "GoToTiltValue",
                "args": {
                    "tiltValue": "int",
                },
            },
            0x00000008: {
                "commandId": 0x00000008,
                "commandName": "GoToTiltPercentage",
                "args": {
                    "tiltPercent100thsValue": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Type",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "PhysicalClosedLimitLift",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "PhysicalClosedLimitTilt",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "CurrentPositionLift",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "CurrentPositionTilt",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "NumberOfActuationsLift",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "NumberOfActuationsTilt",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "ConfigStatus",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "CurrentPositionLiftPercentage",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "CurrentPositionTiltPercentage",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "OperationalStatus",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000000B: {
                "attributeName": "TargetPositionLiftPercent100ths",
                "attributeId": 0x0000000B,
                "type": "int",
                "reportable": True,
            },
            0x0000000C: {
                "attributeName": "TargetPositionTiltPercent100ths",
                "attributeId": 0x0000000C,
                "type": "int",
                "reportable": True,
            },
            0x0000000D: {
                "attributeName": "EndProductType",
                "attributeId": 0x0000000D,
                "type": "int",
                "reportable": True,
            },
            0x0000000E: {
                "attributeName": "CurrentPositionLiftPercent100ths",
                "attributeId": 0x0000000E,
                "type": "int",
                "reportable": True,
            },
            0x0000000F: {
                "attributeName": "CurrentPositionTiltPercent100ths",
                "attributeId": 0x0000000F,
                "type": "int",
                "reportable": True,
            },
            0x00000010: {
                "attributeName": "InstalledOpenLimitLift",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
            },
            0x00000011: {
                "attributeName": "InstalledClosedLimitLift",
                "attributeId": 0x00000011,
                "type": "int",
                "reportable": True,
            },
            0x00000012: {
                "attributeName": "InstalledOpenLimitTilt",
                "attributeId": 0x00000012,
                "type": "int",
                "reportable": True,
            },
            0x00000013: {
                "attributeName": "InstalledClosedLimitTilt",
                "attributeId": 0x00000013,
                "type": "int",
                "reportable": True,
            },
            0x00000017: {
                "attributeName": "Mode",
                "attributeId": 0x00000017,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000001A: {
                "attributeName": "SafetyStatus",
                "attributeId": 0x0000001A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _BARRIER_CONTROL_CLUSTER_INFO = {
        "clusterName": "BarrierControl",
        "clusterId": 0x00000103,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "BarrierControlGoToPercent",
                "args": {
                    "percentOpen": "int",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "BarrierControlStop",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000001: {
                "attributeName": "BarrierMovingState",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "BarrierSafetyStatus",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "BarrierCapabilities",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "BarrierOpenEvents",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000005: {
                "attributeName": "BarrierCloseEvents",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000006: {
                "attributeName": "BarrierCommandOpenEvents",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000007: {
                "attributeName": "BarrierCommandCloseEvents",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000008: {
                "attributeName": "BarrierOpenPeriod",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000009: {
                "attributeName": "BarrierClosePeriod",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000000A: {
                "attributeName": "BarrierPosition",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _PUMP_CONFIGURATION_AND_CONTROL_CLUSTER_INFO = {
        "clusterName": "PumpConfigurationAndControl",
        "clusterId": 0x00000200,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MaxPressure",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MaxSpeed",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxFlow",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "MinConstPressure",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "MaxConstPressure",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "MinCompPressure",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "MaxCompPressure",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "MinConstSpeed",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MaxConstSpeed",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MinConstFlow",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "MaxConstFlow",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000000B: {
                "attributeName": "MinConstTemp",
                "attributeId": 0x0000000B,
                "type": "int",
                "reportable": True,
            },
            0x0000000C: {
                "attributeName": "MaxConstTemp",
                "attributeId": 0x0000000C,
                "type": "int",
                "reportable": True,
            },
            0x00000010: {
                "attributeName": "PumpStatus",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
            },
            0x00000011: {
                "attributeName": "EffectiveOperationMode",
                "attributeId": 0x00000011,
                "type": "int",
                "reportable": True,
            },
            0x00000012: {
                "attributeName": "EffectiveControlMode",
                "attributeId": 0x00000012,
                "type": "int",
                "reportable": True,
            },
            0x00000013: {
                "attributeName": "Capacity",
                "attributeId": 0x00000013,
                "type": "int",
                "reportable": True,
            },
            0x00000014: {
                "attributeName": "Speed",
                "attributeId": 0x00000014,
                "type": "int",
                "reportable": True,
            },
            0x00000015: {
                "attributeName": "LifetimeRunningHours",
                "attributeId": 0x00000015,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000016: {
                "attributeName": "Power",
                "attributeId": 0x00000016,
                "type": "int",
                "reportable": True,
            },
            0x00000017: {
                "attributeName": "LifetimeEnergyConsumed",
                "attributeId": 0x00000017,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000020: {
                "attributeName": "OperationMode",
                "attributeId": 0x00000020,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000021: {
                "attributeName": "ControlMode",
                "attributeId": 0x00000021,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _THERMOSTAT_CLUSTER_INFO = {
        "clusterName": "Thermostat",
        "clusterId": 0x00000201,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "SetpointRaiseLower",
                "args": {
                    "mode": "int",
                    "amount": "int",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "SetWeeklySchedule",
                "args": {
                    "numberOfTransitionsForSequence": "int",
                    "dayOfWeekForSequence": "int",
                    "modeForSequence": "int",
                    "transitions": "ThermostatScheduleTransition",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "GetWeeklySchedule",
                "args": {
                    "daysToReturn": "int",
                    "modeToReturn": "int",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "ClearWeeklySchedule",
                "args": {
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "LocalTemperature",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "OutdoorTemperature",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "Occupancy",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "AbsMinHeatSetpointLimit",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "AbsMaxHeatSetpointLimit",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AbsMinCoolSetpointLimit",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AbsMaxCoolSetpointLimit",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "PICoolingDemand",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "PIHeatingDemand",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "HVACSystemTypeConfiguration",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000010: {
                "attributeName": "LocalTemperatureCalibration",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000011: {
                "attributeName": "OccupiedCoolingSetpoint",
                "attributeId": 0x00000011,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000012: {
                "attributeName": "OccupiedHeatingSetpoint",
                "attributeId": 0x00000012,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000013: {
                "attributeName": "UnoccupiedCoolingSetpoint",
                "attributeId": 0x00000013,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000014: {
                "attributeName": "UnoccupiedHeatingSetpoint",
                "attributeId": 0x00000014,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000015: {
                "attributeName": "MinHeatSetpointLimit",
                "attributeId": 0x00000015,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000016: {
                "attributeName": "MaxHeatSetpointLimit",
                "attributeId": 0x00000016,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000017: {
                "attributeName": "MinCoolSetpointLimit",
                "attributeId": 0x00000017,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000018: {
                "attributeName": "MaxCoolSetpointLimit",
                "attributeId": 0x00000018,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000019: {
                "attributeName": "MinSetpointDeadBand",
                "attributeId": 0x00000019,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000001A: {
                "attributeName": "RemoteSensing",
                "attributeId": 0x0000001A,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000001B: {
                "attributeName": "ControlSequenceOfOperation",
                "attributeId": 0x0000001B,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000001C: {
                "attributeName": "SystemMode",
                "attributeId": 0x0000001C,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000001E: {
                "attributeName": "ThermostatRunningMode",
                "attributeId": 0x0000001E,
                "type": "int",
                "reportable": True,
            },
            0x00000020: {
                "attributeName": "StartOfWeek",
                "attributeId": 0x00000020,
                "type": "int",
                "reportable": True,
            },
            0x00000021: {
                "attributeName": "NumberOfWeeklyTransitions",
                "attributeId": 0x00000021,
                "type": "int",
                "reportable": True,
            },
            0x00000022: {
                "attributeName": "NumberOfDailyTransitions",
                "attributeId": 0x00000022,
                "type": "int",
                "reportable": True,
            },
            0x00000023: {
                "attributeName": "TemperatureSetpointHold",
                "attributeId": 0x00000023,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000024: {
                "attributeName": "TemperatureSetpointHoldDuration",
                "attributeId": 0x00000024,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000025: {
                "attributeName": "ThermostatProgrammingOperationMode",
                "attributeId": 0x00000025,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000029: {
                "attributeName": "ThermostatRunningState",
                "attributeId": 0x00000029,
                "type": "int",
                "reportable": True,
            },
            0x00000030: {
                "attributeName": "SetpointChangeSource",
                "attributeId": 0x00000030,
                "type": "int",
                "reportable": True,
            },
            0x00000031: {
                "attributeName": "SetpointChangeAmount",
                "attributeId": 0x00000031,
                "type": "int",
                "reportable": True,
            },
            0x00000032: {
                "attributeName": "SetpointChangeSourceTimestamp",
                "attributeId": 0x00000032,
                "type": "int",
                "reportable": True,
            },
            0x00000034: {
                "attributeName": "OccupiedSetback",
                "attributeId": 0x00000034,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000035: {
                "attributeName": "OccupiedSetbackMin",
                "attributeId": 0x00000035,
                "type": "int",
                "reportable": True,
            },
            0x00000036: {
                "attributeName": "OccupiedSetbackMax",
                "attributeId": 0x00000036,
                "type": "int",
                "reportable": True,
            },
            0x00000037: {
                "attributeName": "UnoccupiedSetback",
                "attributeId": 0x00000037,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000038: {
                "attributeName": "UnoccupiedSetbackMin",
                "attributeId": 0x00000038,
                "type": "int",
                "reportable": True,
            },
            0x00000039: {
                "attributeName": "UnoccupiedSetbackMax",
                "attributeId": 0x00000039,
                "type": "int",
                "reportable": True,
            },
            0x0000003A: {
                "attributeName": "EmergencyHeatDelta",
                "attributeId": 0x0000003A,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000040: {
                "attributeName": "ACType",
                "attributeId": 0x00000040,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000041: {
                "attributeName": "ACCapacity",
                "attributeId": 0x00000041,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000042: {
                "attributeName": "ACRefrigerantType",
                "attributeId": 0x00000042,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000043: {
                "attributeName": "ACCompressorType",
                "attributeId": 0x00000043,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000044: {
                "attributeName": "ACErrorCode",
                "attributeId": 0x00000044,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000045: {
                "attributeName": "ACLouverPosition",
                "attributeId": 0x00000045,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000046: {
                "attributeName": "ACCoilTemperature",
                "attributeId": 0x00000046,
                "type": "int",
                "reportable": True,
            },
            0x00000047: {
                "attributeName": "ACCapacityformat",
                "attributeId": 0x00000047,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _FAN_CONTROL_CLUSTER_INFO = {
        "clusterName": "FanControl",
        "clusterId": 0x00000202,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "Step",
                "args": {
                    "direction": "int",
                    "wrap": "bool",
                    "lowestOff": "bool",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "FanMode",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000001: {
                "attributeName": "FanModeSequence",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000002: {
                "attributeName": "PercentSetting",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000003: {
                "attributeName": "PercentCurrent",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "SpeedMax",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "SpeedSetting",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000006: {
                "attributeName": "SpeedCurrent",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "RockSupport",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "RockSetting",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000009: {
                "attributeName": "WindSupport",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "WindSetting",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000000B: {
                "attributeName": "AirflowDirection",
                "attributeId": 0x0000000B,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _THERMOSTAT_USER_INTERFACE_CONFIGURATION_CLUSTER_INFO = {
        "clusterName": "ThermostatUserInterfaceConfiguration",
        "clusterId": 0x00000204,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "TemperatureDisplayMode",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000001: {
                "attributeName": "KeypadLockout",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000002: {
                "attributeName": "ScheduleProgrammingVisibility",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _COLOR_CONTROL_CLUSTER_INFO = {
        "clusterName": "ColorControl",
        "clusterId": 0x00000300,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "MoveToHue",
                "args": {
                    "hue": "int",
                    "direction": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "MoveHue",
                "args": {
                    "moveMode": "int",
                    "rate": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "StepHue",
                "args": {
                    "stepMode": "int",
                    "stepSize": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "MoveToSaturation",
                "args": {
                    "saturation": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "MoveSaturation",
                "args": {
                    "moveMode": "int",
                    "rate": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000005: {
                "commandId": 0x00000005,
                "commandName": "StepSaturation",
                "args": {
                    "stepMode": "int",
                    "stepSize": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000006: {
                "commandId": 0x00000006,
                "commandName": "MoveToHueAndSaturation",
                "args": {
                    "hue": "int",
                    "saturation": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000007: {
                "commandId": 0x00000007,
                "commandName": "MoveToColor",
                "args": {
                    "colorX": "int",
                    "colorY": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000008: {
                "commandId": 0x00000008,
                "commandName": "MoveColor",
                "args": {
                    "rateX": "int",
                    "rateY": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000009: {
                "commandId": 0x00000009,
                "commandName": "StepColor",
                "args": {
                    "stepX": "int",
                    "stepY": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x0000000A: {
                "commandId": 0x0000000A,
                "commandName": "MoveToColorTemperature",
                "args": {
                    "colorTemperatureMireds": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000040: {
                "commandId": 0x00000040,
                "commandName": "EnhancedMoveToHue",
                "args": {
                    "enhancedHue": "int",
                    "direction": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000041: {
                "commandId": 0x00000041,
                "commandName": "EnhancedMoveHue",
                "args": {
                    "moveMode": "int",
                    "rate": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000042: {
                "commandId": 0x00000042,
                "commandName": "EnhancedStepHue",
                "args": {
                    "stepMode": "int",
                    "stepSize": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000043: {
                "commandId": 0x00000043,
                "commandName": "EnhancedMoveToHueAndSaturation",
                "args": {
                    "enhancedHue": "int",
                    "saturation": "int",
                    "transitionTime": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000044: {
                "commandId": 0x00000044,
                "commandName": "ColorLoopSet",
                "args": {
                    "updateFlags": "int",
                    "action": "int",
                    "direction": "int",
                    "time": "int",
                    "startHue": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x00000047: {
                "commandId": 0x00000047,
                "commandName": "StopMoveStep",
                "args": {
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x0000004B: {
                "commandId": 0x0000004B,
                "commandName": "MoveColorTemperature",
                "args": {
                    "moveMode": "int",
                    "rate": "int",
                    "colorTemperatureMinimumMireds": "int",
                    "colorTemperatureMaximumMireds": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
            0x0000004C: {
                "commandId": 0x0000004C,
                "commandName": "StepColorTemperature",
                "args": {
                    "stepMode": "int",
                    "stepSize": "int",
                    "transitionTime": "int",
                    "colorTemperatureMinimumMireds": "int",
                    "colorTemperatureMaximumMireds": "int",
                    "optionsMask": "int",
                    "optionsOverride": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "CurrentHue",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "CurrentSaturation",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "RemainingTime",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "CurrentX",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "CurrentY",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "DriftCompensation",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "CompensationText",
                "attributeId": 0x00000006,
                "type": "str",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "ColorTemperatureMireds",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "ColorMode",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x0000000F: {
                "attributeName": "Options",
                "attributeId": 0x0000000F,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000010: {
                "attributeName": "NumberOfPrimaries",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
            },
            0x00000011: {
                "attributeName": "Primary1X",
                "attributeId": 0x00000011,
                "type": "int",
                "reportable": True,
            },
            0x00000012: {
                "attributeName": "Primary1Y",
                "attributeId": 0x00000012,
                "type": "int",
                "reportable": True,
            },
            0x00000013: {
                "attributeName": "Primary1Intensity",
                "attributeId": 0x00000013,
                "type": "int",
                "reportable": True,
            },
            0x00000015: {
                "attributeName": "Primary2X",
                "attributeId": 0x00000015,
                "type": "int",
                "reportable": True,
            },
            0x00000016: {
                "attributeName": "Primary2Y",
                "attributeId": 0x00000016,
                "type": "int",
                "reportable": True,
            },
            0x00000017: {
                "attributeName": "Primary2Intensity",
                "attributeId": 0x00000017,
                "type": "int",
                "reportable": True,
            },
            0x00000019: {
                "attributeName": "Primary3X",
                "attributeId": 0x00000019,
                "type": "int",
                "reportable": True,
            },
            0x0000001A: {
                "attributeName": "Primary3Y",
                "attributeId": 0x0000001A,
                "type": "int",
                "reportable": True,
            },
            0x0000001B: {
                "attributeName": "Primary3Intensity",
                "attributeId": 0x0000001B,
                "type": "int",
                "reportable": True,
            },
            0x00000020: {
                "attributeName": "Primary4X",
                "attributeId": 0x00000020,
                "type": "int",
                "reportable": True,
            },
            0x00000021: {
                "attributeName": "Primary4Y",
                "attributeId": 0x00000021,
                "type": "int",
                "reportable": True,
            },
            0x00000022: {
                "attributeName": "Primary4Intensity",
                "attributeId": 0x00000022,
                "type": "int",
                "reportable": True,
            },
            0x00000024: {
                "attributeName": "Primary5X",
                "attributeId": 0x00000024,
                "type": "int",
                "reportable": True,
            },
            0x00000025: {
                "attributeName": "Primary5Y",
                "attributeId": 0x00000025,
                "type": "int",
                "reportable": True,
            },
            0x00000026: {
                "attributeName": "Primary5Intensity",
                "attributeId": 0x00000026,
                "type": "int",
                "reportable": True,
            },
            0x00000028: {
                "attributeName": "Primary6X",
                "attributeId": 0x00000028,
                "type": "int",
                "reportable": True,
            },
            0x00000029: {
                "attributeName": "Primary6Y",
                "attributeId": 0x00000029,
                "type": "int",
                "reportable": True,
            },
            0x0000002A: {
                "attributeName": "Primary6Intensity",
                "attributeId": 0x0000002A,
                "type": "int",
                "reportable": True,
            },
            0x00000030: {
                "attributeName": "WhitePointX",
                "attributeId": 0x00000030,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000031: {
                "attributeName": "WhitePointY",
                "attributeId": 0x00000031,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000032: {
                "attributeName": "ColorPointRX",
                "attributeId": 0x00000032,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000033: {
                "attributeName": "ColorPointRY",
                "attributeId": 0x00000033,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000034: {
                "attributeName": "ColorPointRIntensity",
                "attributeId": 0x00000034,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000036: {
                "attributeName": "ColorPointGX",
                "attributeId": 0x00000036,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000037: {
                "attributeName": "ColorPointGY",
                "attributeId": 0x00000037,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000038: {
                "attributeName": "ColorPointGIntensity",
                "attributeId": 0x00000038,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000003A: {
                "attributeName": "ColorPointBX",
                "attributeId": 0x0000003A,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000003B: {
                "attributeName": "ColorPointBY",
                "attributeId": 0x0000003B,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000003C: {
                "attributeName": "ColorPointBIntensity",
                "attributeId": 0x0000003C,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004000: {
                "attributeName": "EnhancedCurrentHue",
                "attributeId": 0x00004000,
                "type": "int",
                "reportable": True,
            },
            0x00004001: {
                "attributeName": "EnhancedColorMode",
                "attributeId": 0x00004001,
                "type": "int",
                "reportable": True,
            },
            0x00004002: {
                "attributeName": "ColorLoopActive",
                "attributeId": 0x00004002,
                "type": "int",
                "reportable": True,
            },
            0x00004003: {
                "attributeName": "ColorLoopDirection",
                "attributeId": 0x00004003,
                "type": "int",
                "reportable": True,
            },
            0x00004004: {
                "attributeName": "ColorLoopTime",
                "attributeId": 0x00004004,
                "type": "int",
                "reportable": True,
            },
            0x00004005: {
                "attributeName": "ColorLoopStartEnhancedHue",
                "attributeId": 0x00004005,
                "type": "int",
                "reportable": True,
            },
            0x00004006: {
                "attributeName": "ColorLoopStoredEnhancedHue",
                "attributeId": 0x00004006,
                "type": "int",
                "reportable": True,
            },
            0x0000400A: {
                "attributeName": "ColorCapabilities",
                "attributeId": 0x0000400A,
                "type": "int",
                "reportable": True,
            },
            0x0000400B: {
                "attributeName": "ColorTempPhysicalMinMireds",
                "attributeId": 0x0000400B,
                "type": "int",
                "reportable": True,
            },
            0x0000400C: {
                "attributeName": "ColorTempPhysicalMaxMireds",
                "attributeId": 0x0000400C,
                "type": "int",
                "reportable": True,
            },
            0x0000400D: {
                "attributeName": "CoupleColorTempToLevelMinMireds",
                "attributeId": 0x0000400D,
                "type": "int",
                "reportable": True,
            },
            0x00004010: {
                "attributeName": "StartUpColorTemperatureMireds",
                "attributeId": 0x00004010,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _BALLAST_CONFIGURATION_CLUSTER_INFO = {
        "clusterName": "BallastConfiguration",
        "clusterId": 0x00000301,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "PhysicalMinLevel",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "PhysicalMaxLevel",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "BallastStatus",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000010: {
                "attributeName": "MinLevel",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000011: {
                "attributeName": "MaxLevel",
                "attributeId": 0x00000011,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000014: {
                "attributeName": "IntrinsicBallastFactor",
                "attributeId": 0x00000014,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000015: {
                "attributeName": "BallastFactorAdjustment",
                "attributeId": 0x00000015,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000020: {
                "attributeName": "LampQuantity",
                "attributeId": 0x00000020,
                "type": "int",
                "reportable": True,
            },
            0x00000030: {
                "attributeName": "LampType",
                "attributeId": 0x00000030,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x00000031: {
                "attributeName": "LampManufacturer",
                "attributeId": 0x00000031,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x00000032: {
                "attributeName": "LampRatedHours",
                "attributeId": 0x00000032,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000033: {
                "attributeName": "LampBurnHours",
                "attributeId": 0x00000033,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000034: {
                "attributeName": "LampAlarmMode",
                "attributeId": 0x00000034,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000035: {
                "attributeName": "LampBurnHoursTripPoint",
                "attributeId": 0x00000035,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ILLUMINANCE_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "IlluminanceMeasurement",
        "clusterId": 0x00000400,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "Tolerance",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "LightSensorType",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _TEMPERATURE_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "TemperatureMeasurement",
        "clusterId": 0x00000402,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "Tolerance",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _PRESSURE_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "PressureMeasurement",
        "clusterId": 0x00000403,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "Tolerance",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000010: {
                "attributeName": "ScaledValue",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
            },
            0x00000011: {
                "attributeName": "MinScaledValue",
                "attributeId": 0x00000011,
                "type": "int",
                "reportable": True,
            },
            0x00000012: {
                "attributeName": "MaxScaledValue",
                "attributeId": 0x00000012,
                "type": "int",
                "reportable": True,
            },
            0x00000013: {
                "attributeName": "ScaledTolerance",
                "attributeId": 0x00000013,
                "type": "int",
                "reportable": True,
            },
            0x00000014: {
                "attributeName": "Scale",
                "attributeId": 0x00000014,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _FLOW_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "FlowMeasurement",
        "clusterId": 0x00000404,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "Tolerance",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "RelativeHumidityMeasurement",
        "clusterId": 0x00000405,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "Tolerance",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _OCCUPANCY_SENSING_CLUSTER_INFO = {
        "clusterName": "OccupancySensing",
        "clusterId": 0x00000406,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Occupancy",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "OccupancySensorType",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "OccupancySensorTypeBitmap",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000010: {
                "attributeName": "PIROccupiedToUnoccupiedDelay",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000011: {
                "attributeName": "PIRUnoccupiedToOccupiedDelay",
                "attributeId": 0x00000011,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000012: {
                "attributeName": "PIRUnoccupiedToOccupiedThreshold",
                "attributeId": 0x00000012,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000020: {
                "attributeName": "UltrasonicOccupiedToUnoccupiedDelay",
                "attributeId": 0x00000020,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000021: {
                "attributeName": "UltrasonicUnoccupiedToOccupiedDelay",
                "attributeId": 0x00000021,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000022: {
                "attributeName": "UltrasonicUnoccupiedToOccupiedThreshold",
                "attributeId": 0x00000022,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000030: {
                "attributeName": "PhysicalContactOccupiedToUnoccupiedDelay",
                "attributeId": 0x00000030,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000031: {
                "attributeName": "PhysicalContactUnoccupiedToOccupiedDelay",
                "attributeId": 0x00000031,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000032: {
                "attributeName": "PhysicalContactUnoccupiedToOccupiedThreshold",
                "attributeId": 0x00000032,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _CARBON_MONOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "CarbonMonoxideConcentrationMeasurement",
        "clusterId": 0x0000040C,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _CARBON_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "CarbonDioxideConcentrationMeasurement",
        "clusterId": 0x0000040D,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ETHYLENE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "EthyleneConcentrationMeasurement",
        "clusterId": 0x0000040E,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ETHYLENE_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "EthyleneOxideConcentrationMeasurement",
        "clusterId": 0x0000040F,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _HYDROGEN_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "HydrogenConcentrationMeasurement",
        "clusterId": 0x00000410,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _HYDROGEN_SULFIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "HydrogenSulfideConcentrationMeasurement",
        "clusterId": 0x00000411,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _NITRIC_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "NitricOxideConcentrationMeasurement",
        "clusterId": 0x00000412,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _NITROGEN_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "NitrogenDioxideConcentrationMeasurement",
        "clusterId": 0x00000413,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "OxygenConcentrationMeasurement",
        "clusterId": 0x00000414,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _OZONE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "OzoneConcentrationMeasurement",
        "clusterId": 0x00000415,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _SULFUR_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "SulfurDioxideConcentrationMeasurement",
        "clusterId": 0x00000416,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _DISSOLVED_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "DissolvedOxygenConcentrationMeasurement",
        "clusterId": 0x00000417,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _BROMATE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "BromateConcentrationMeasurement",
        "clusterId": 0x00000418,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _CHLORAMINES_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "ChloraminesConcentrationMeasurement",
        "clusterId": 0x00000419,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _CHLORINE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "ChlorineConcentrationMeasurement",
        "clusterId": 0x0000041A,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _FECAL_COLIFORM_E_COLI_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "FecalColiformEColiConcentrationMeasurement",
        "clusterId": 0x0000041B,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _FLUORIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "FluorideConcentrationMeasurement",
        "clusterId": 0x0000041C,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _HALOACETIC_ACIDS_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "HaloaceticAcidsConcentrationMeasurement",
        "clusterId": 0x0000041D,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _TOTAL_TRIHALOMETHANES_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "TotalTrihalomethanesConcentrationMeasurement",
        "clusterId": 0x0000041E,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _TOTAL_COLIFORM_BACTERIA_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "TotalColiformBacteriaConcentrationMeasurement",
        "clusterId": 0x0000041F,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _TURBIDITY_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "TurbidityConcentrationMeasurement",
        "clusterId": 0x00000420,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _COPPER_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "CopperConcentrationMeasurement",
        "clusterId": 0x00000421,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _LEAD_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "LeadConcentrationMeasurement",
        "clusterId": 0x00000422,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _MANGANESE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "ManganeseConcentrationMeasurement",
        "clusterId": 0x00000423,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _SULFATE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "SulfateConcentrationMeasurement",
        "clusterId": 0x00000424,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _BROMODICHLOROMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "BromodichloromethaneConcentrationMeasurement",
        "clusterId": 0x00000425,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _BROMOFORM_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "BromoformConcentrationMeasurement",
        "clusterId": 0x00000426,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _CHLORODIBROMOMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "ChlorodibromomethaneConcentrationMeasurement",
        "clusterId": 0x00000427,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _CHLOROFORM_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "ChloroformConcentrationMeasurement",
        "clusterId": 0x00000428,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _SODIUM_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "SodiumConcentrationMeasurement",
        "clusterId": 0x00000429,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _PM2__5_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "Pm25ConcentrationMeasurement",
        "clusterId": 0x0000042A,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _FORMALDEHYDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "FormaldehydeConcentrationMeasurement",
        "clusterId": 0x0000042B,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _PM1_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "Pm1ConcentrationMeasurement",
        "clusterId": 0x0000042C,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _PM10_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "Pm10ConcentrationMeasurement",
        "clusterId": 0x0000042D,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _TOTAL_VOLATILE_ORGANIC_COMPOUNDS_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "TotalVolatileOrganicCompoundsConcentrationMeasurement",
        "clusterId": 0x0000042E,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _RADON_CONCENTRATION_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "RadonConcentrationMeasurement",
        "clusterId": 0x0000042F,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasuredValue",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "MinMeasuredValue",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "MaxMeasuredValue",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "PeakMeasuredValue",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PeakMeasuredValueWindow",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "AverageMeasuredValue",
                "attributeId": 0x00000005,
                "type": "",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "AverageMeasuredValueWindow",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "Uncertainty",
                "attributeId": 0x00000007,
                "type": "",
                "reportable": True,
            },
            0x00000008: {
                "attributeName": "MeasurementUnit",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
            },
            0x00000009: {
                "attributeName": "MeasurementMedium",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
            },
            0x0000000A: {
                "attributeName": "LevelValue",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _WAKE_ON_LAN_CLUSTER_INFO = {
        "clusterName": "WakeOnLan",
        "clusterId": 0x00000503,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MACAddress",
                "attributeId": 0x00000000,
                "type": "str",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _CHANNEL_CLUSTER_INFO = {
        "clusterName": "Channel",
        "clusterId": 0x00000504,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "ChangeChannel",
                "args": {
                    "match": "str",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "ChangeChannelByNumber",
                "args": {
                    "majorNumber": "int",
                    "minorNumber": "int",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "SkipChannel",
                "args": {
                    "count": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "ChannelList",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "Lineup",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "CurrentChannel",
                "attributeId": 0x00000002,
                "type": "",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _TARGET_NAVIGATOR_CLUSTER_INFO = {
        "clusterName": "TargetNavigator",
        "clusterId": 0x00000505,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "NavigateTarget",
                "args": {
                    "target": "int",
                    "data": "str",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "TargetList",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "CurrentTarget",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _MEDIA_PLAYBACK_CLUSTER_INFO = {
        "clusterName": "MediaPlayback",
        "clusterId": 0x00000506,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "Play",
                "args": {
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "Pause",
                "args": {
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "Stop",
                "args": {
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "StartOver",
                "args": {
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "Previous",
                "args": {
                },
            },
            0x00000005: {
                "commandId": 0x00000005,
                "commandName": "Next",
                "args": {
                },
            },
            0x00000006: {
                "commandId": 0x00000006,
                "commandName": "Rewind",
                "args": {
                },
            },
            0x00000007: {
                "commandId": 0x00000007,
                "commandName": "FastForward",
                "args": {
                },
            },
            0x00000008: {
                "commandId": 0x00000008,
                "commandName": "SkipForward",
                "args": {
                    "deltaPositionMilliseconds": "int",
                },
            },
            0x00000009: {
                "commandId": 0x00000009,
                "commandName": "SkipBackward",
                "args": {
                    "deltaPositionMilliseconds": "int",
                },
            },
            0x0000000B: {
                "commandId": 0x0000000B,
                "commandName": "Seek",
                "args": {
                    "position": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "CurrentState",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "StartTime",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "Duration",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "SampledPosition",
                "attributeId": 0x00000003,
                "type": "",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "PlaybackSpeed",
                "attributeId": 0x00000004,
                "type": "",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "SeekRangeEnd",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "SeekRangeStart",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _MEDIA_INPUT_CLUSTER_INFO = {
        "clusterName": "MediaInput",
        "clusterId": 0x00000507,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "SelectInput",
                "args": {
                    "index": "int",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "ShowInputStatus",
                "args": {
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "HideInputStatus",
                "args": {
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "RenameInput",
                "args": {
                    "index": "int",
                    "name": "str",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "InputList",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "CurrentInput",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _LOW_POWER_CLUSTER_INFO = {
        "clusterName": "LowPower",
        "clusterId": 0x00000508,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "Sleep",
                "args": {
                },
            },
        },
        "attributes": {
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _KEYPAD_INPUT_CLUSTER_INFO = {
        "clusterName": "KeypadInput",
        "clusterId": 0x00000509,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "SendKey",
                "args": {
                    "keyCode": "int",
                },
            },
        },
        "attributes": {
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _CONTENT_LAUNCHER_CLUSTER_INFO = {
        "clusterName": "ContentLauncher",
        "clusterId": 0x0000050A,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "LaunchContent",
                "args": {
                    "search": "ContentSearchStruct",
                    "autoPlay": "bool",
                    "data": "str",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "LaunchURL",
                "args": {
                    "contentURL": "str",
                    "displayString": "str",
                    "brandingInformation": "BrandingInformationStruct",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "AcceptHeader",
                "attributeId": 0x00000000,
                "type": "str",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "SupportedStreamingProtocols",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _AUDIO_OUTPUT_CLUSTER_INFO = {
        "clusterName": "AudioOutput",
        "clusterId": 0x0000050B,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "SelectOutput",
                "args": {
                    "index": "int",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "RenameOutput",
                "args": {
                    "index": "int",
                    "name": "str",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "OutputList",
                "attributeId": 0x00000000,
                "type": "",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "CurrentOutput",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _APPLICATION_LAUNCHER_CLUSTER_INFO = {
        "clusterName": "ApplicationLauncher",
        "clusterId": 0x0000050C,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "LaunchApp",
                "args": {
                    "application": "ApplicationStruct",
                    "data": "bytes",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "StopApp",
                "args": {
                    "application": "ApplicationStruct",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "HideApp",
                "args": {
                    "application": "ApplicationStruct",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "CatalogList",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "CurrentApp",
                "attributeId": 0x00000001,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _APPLICATION_BASIC_CLUSTER_INFO = {
        "clusterName": "ApplicationBasic",
        "clusterId": 0x0000050D,
        "commands": {
        },
        "attributes": {
            0x00000000: {
                "attributeName": "VendorName",
                "attributeId": 0x00000000,
                "type": "str",
                "reportable": True,
            },
            0x00000001: {
                "attributeName": "VendorID",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
            },
            0x00000002: {
                "attributeName": "ApplicationName",
                "attributeId": 0x00000002,
                "type": "str",
                "reportable": True,
            },
            0x00000003: {
                "attributeName": "ProductID",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
            },
            0x00000004: {
                "attributeName": "Application",
                "attributeId": 0x00000004,
                "type": "",
                "reportable": True,
            },
            0x00000005: {
                "attributeName": "Status",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
            },
            0x00000006: {
                "attributeName": "ApplicationVersion",
                "attributeId": 0x00000006,
                "type": "str",
                "reportable": True,
            },
            0x00000007: {
                "attributeName": "AllowedVendorList",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ACCOUNT_LOGIN_CLUSTER_INFO = {
        "clusterName": "AccountLogin",
        "clusterId": 0x0000050E,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "GetSetupPIN",
                "args": {
                    "tempAccountIdentifier": "str",
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "Login",
                "args": {
                    "tempAccountIdentifier": "str",
                    "setupPIN": "str",
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "Logout",
                "args": {
                },
            },
        },
        "attributes": {
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _ELECTRICAL_MEASUREMENT_CLUSTER_INFO = {
        "clusterName": "ElectricalMeasurement",
        "clusterId": 0x00000B04,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "GetProfileInfoCommand",
                "args": {
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "GetMeasurementProfileCommand",
                "args": {
                    "attributeId": "int",
                    "startTime": "int",
                    "numberOfIntervals": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "MeasurementType",
                "attributeId": 0x00000000,
                "type": "int",
                "reportable": True,
            },
            0x00000100: {
                "attributeName": "DcVoltage",
                "attributeId": 0x00000100,
                "type": "int",
                "reportable": True,
            },
            0x00000101: {
                "attributeName": "DcVoltageMin",
                "attributeId": 0x00000101,
                "type": "int",
                "reportable": True,
            },
            0x00000102: {
                "attributeName": "DcVoltageMax",
                "attributeId": 0x00000102,
                "type": "int",
                "reportable": True,
            },
            0x00000103: {
                "attributeName": "DcCurrent",
                "attributeId": 0x00000103,
                "type": "int",
                "reportable": True,
            },
            0x00000104: {
                "attributeName": "DcCurrentMin",
                "attributeId": 0x00000104,
                "type": "int",
                "reportable": True,
            },
            0x00000105: {
                "attributeName": "DcCurrentMax",
                "attributeId": 0x00000105,
                "type": "int",
                "reportable": True,
            },
            0x00000106: {
                "attributeName": "DcPower",
                "attributeId": 0x00000106,
                "type": "int",
                "reportable": True,
            },
            0x00000107: {
                "attributeName": "DcPowerMin",
                "attributeId": 0x00000107,
                "type": "int",
                "reportable": True,
            },
            0x00000108: {
                "attributeName": "DcPowerMax",
                "attributeId": 0x00000108,
                "type": "int",
                "reportable": True,
            },
            0x00000200: {
                "attributeName": "DcVoltageMultiplier",
                "attributeId": 0x00000200,
                "type": "int",
                "reportable": True,
            },
            0x00000201: {
                "attributeName": "DcVoltageDivisor",
                "attributeId": 0x00000201,
                "type": "int",
                "reportable": True,
            },
            0x00000202: {
                "attributeName": "DcCurrentMultiplier",
                "attributeId": 0x00000202,
                "type": "int",
                "reportable": True,
            },
            0x00000203: {
                "attributeName": "DcCurrentDivisor",
                "attributeId": 0x00000203,
                "type": "int",
                "reportable": True,
            },
            0x00000204: {
                "attributeName": "DcPowerMultiplier",
                "attributeId": 0x00000204,
                "type": "int",
                "reportable": True,
            },
            0x00000205: {
                "attributeName": "DcPowerDivisor",
                "attributeId": 0x00000205,
                "type": "int",
                "reportable": True,
            },
            0x00000300: {
                "attributeName": "AcFrequency",
                "attributeId": 0x00000300,
                "type": "int",
                "reportable": True,
            },
            0x00000301: {
                "attributeName": "AcFrequencyMin",
                "attributeId": 0x00000301,
                "type": "int",
                "reportable": True,
            },
            0x00000302: {
                "attributeName": "AcFrequencyMax",
                "attributeId": 0x00000302,
                "type": "int",
                "reportable": True,
            },
            0x00000303: {
                "attributeName": "NeutralCurrent",
                "attributeId": 0x00000303,
                "type": "int",
                "reportable": True,
            },
            0x00000304: {
                "attributeName": "TotalActivePower",
                "attributeId": 0x00000304,
                "type": "int",
                "reportable": True,
            },
            0x00000305: {
                "attributeName": "TotalReactivePower",
                "attributeId": 0x00000305,
                "type": "int",
                "reportable": True,
            },
            0x00000306: {
                "attributeName": "TotalApparentPower",
                "attributeId": 0x00000306,
                "type": "int",
                "reportable": True,
            },
            0x00000307: {
                "attributeName": "Measured1stHarmonicCurrent",
                "attributeId": 0x00000307,
                "type": "int",
                "reportable": True,
            },
            0x00000308: {
                "attributeName": "Measured3rdHarmonicCurrent",
                "attributeId": 0x00000308,
                "type": "int",
                "reportable": True,
            },
            0x00000309: {
                "attributeName": "Measured5thHarmonicCurrent",
                "attributeId": 0x00000309,
                "type": "int",
                "reportable": True,
            },
            0x0000030A: {
                "attributeName": "Measured7thHarmonicCurrent",
                "attributeId": 0x0000030A,
                "type": "int",
                "reportable": True,
            },
            0x0000030B: {
                "attributeName": "Measured9thHarmonicCurrent",
                "attributeId": 0x0000030B,
                "type": "int",
                "reportable": True,
            },
            0x0000030C: {
                "attributeName": "Measured11thHarmonicCurrent",
                "attributeId": 0x0000030C,
                "type": "int",
                "reportable": True,
            },
            0x0000030D: {
                "attributeName": "MeasuredPhase1stHarmonicCurrent",
                "attributeId": 0x0000030D,
                "type": "int",
                "reportable": True,
            },
            0x0000030E: {
                "attributeName": "MeasuredPhase3rdHarmonicCurrent",
                "attributeId": 0x0000030E,
                "type": "int",
                "reportable": True,
            },
            0x0000030F: {
                "attributeName": "MeasuredPhase5thHarmonicCurrent",
                "attributeId": 0x0000030F,
                "type": "int",
                "reportable": True,
            },
            0x00000310: {
                "attributeName": "MeasuredPhase7thHarmonicCurrent",
                "attributeId": 0x00000310,
                "type": "int",
                "reportable": True,
            },
            0x00000311: {
                "attributeName": "MeasuredPhase9thHarmonicCurrent",
                "attributeId": 0x00000311,
                "type": "int",
                "reportable": True,
            },
            0x00000312: {
                "attributeName": "MeasuredPhase11thHarmonicCurrent",
                "attributeId": 0x00000312,
                "type": "int",
                "reportable": True,
            },
            0x00000400: {
                "attributeName": "AcFrequencyMultiplier",
                "attributeId": 0x00000400,
                "type": "int",
                "reportable": True,
            },
            0x00000401: {
                "attributeName": "AcFrequencyDivisor",
                "attributeId": 0x00000401,
                "type": "int",
                "reportable": True,
            },
            0x00000402: {
                "attributeName": "PowerMultiplier",
                "attributeId": 0x00000402,
                "type": "int",
                "reportable": True,
            },
            0x00000403: {
                "attributeName": "PowerDivisor",
                "attributeId": 0x00000403,
                "type": "int",
                "reportable": True,
            },
            0x00000404: {
                "attributeName": "HarmonicCurrentMultiplier",
                "attributeId": 0x00000404,
                "type": "int",
                "reportable": True,
            },
            0x00000405: {
                "attributeName": "PhaseHarmonicCurrentMultiplier",
                "attributeId": 0x00000405,
                "type": "int",
                "reportable": True,
            },
            0x00000500: {
                "attributeName": "InstantaneousVoltage",
                "attributeId": 0x00000500,
                "type": "int",
                "reportable": True,
            },
            0x00000501: {
                "attributeName": "InstantaneousLineCurrent",
                "attributeId": 0x00000501,
                "type": "int",
                "reportable": True,
            },
            0x00000502: {
                "attributeName": "InstantaneousActiveCurrent",
                "attributeId": 0x00000502,
                "type": "int",
                "reportable": True,
            },
            0x00000503: {
                "attributeName": "InstantaneousReactiveCurrent",
                "attributeId": 0x00000503,
                "type": "int",
                "reportable": True,
            },
            0x00000504: {
                "attributeName": "InstantaneousPower",
                "attributeId": 0x00000504,
                "type": "int",
                "reportable": True,
            },
            0x00000505: {
                "attributeName": "RmsVoltage",
                "attributeId": 0x00000505,
                "type": "int",
                "reportable": True,
            },
            0x00000506: {
                "attributeName": "RmsVoltageMin",
                "attributeId": 0x00000506,
                "type": "int",
                "reportable": True,
            },
            0x00000507: {
                "attributeName": "RmsVoltageMax",
                "attributeId": 0x00000507,
                "type": "int",
                "reportable": True,
            },
            0x00000508: {
                "attributeName": "RmsCurrent",
                "attributeId": 0x00000508,
                "type": "int",
                "reportable": True,
            },
            0x00000509: {
                "attributeName": "RmsCurrentMin",
                "attributeId": 0x00000509,
                "type": "int",
                "reportable": True,
            },
            0x0000050A: {
                "attributeName": "RmsCurrentMax",
                "attributeId": 0x0000050A,
                "type": "int",
                "reportable": True,
            },
            0x0000050B: {
                "attributeName": "ActivePower",
                "attributeId": 0x0000050B,
                "type": "int",
                "reportable": True,
            },
            0x0000050C: {
                "attributeName": "ActivePowerMin",
                "attributeId": 0x0000050C,
                "type": "int",
                "reportable": True,
            },
            0x0000050D: {
                "attributeName": "ActivePowerMax",
                "attributeId": 0x0000050D,
                "type": "int",
                "reportable": True,
            },
            0x0000050E: {
                "attributeName": "ReactivePower",
                "attributeId": 0x0000050E,
                "type": "int",
                "reportable": True,
            },
            0x0000050F: {
                "attributeName": "ApparentPower",
                "attributeId": 0x0000050F,
                "type": "int",
                "reportable": True,
            },
            0x00000510: {
                "attributeName": "PowerFactor",
                "attributeId": 0x00000510,
                "type": "int",
                "reportable": True,
            },
            0x00000511: {
                "attributeName": "AverageRmsVoltageMeasurementPeriod",
                "attributeId": 0x00000511,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000513: {
                "attributeName": "AverageRmsUnderVoltageCounter",
                "attributeId": 0x00000513,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000514: {
                "attributeName": "RmsExtremeOverVoltagePeriod",
                "attributeId": 0x00000514,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000515: {
                "attributeName": "RmsExtremeUnderVoltagePeriod",
                "attributeId": 0x00000515,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000516: {
                "attributeName": "RmsVoltageSagPeriod",
                "attributeId": 0x00000516,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000517: {
                "attributeName": "RmsVoltageSwellPeriod",
                "attributeId": 0x00000517,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000600: {
                "attributeName": "AcVoltageMultiplier",
                "attributeId": 0x00000600,
                "type": "int",
                "reportable": True,
            },
            0x00000601: {
                "attributeName": "AcVoltageDivisor",
                "attributeId": 0x00000601,
                "type": "int",
                "reportable": True,
            },
            0x00000602: {
                "attributeName": "AcCurrentMultiplier",
                "attributeId": 0x00000602,
                "type": "int",
                "reportable": True,
            },
            0x00000603: {
                "attributeName": "AcCurrentDivisor",
                "attributeId": 0x00000603,
                "type": "int",
                "reportable": True,
            },
            0x00000604: {
                "attributeName": "AcPowerMultiplier",
                "attributeId": 0x00000604,
                "type": "int",
                "reportable": True,
            },
            0x00000605: {
                "attributeName": "AcPowerDivisor",
                "attributeId": 0x00000605,
                "type": "int",
                "reportable": True,
            },
            0x00000700: {
                "attributeName": "OverloadAlarmsMask",
                "attributeId": 0x00000700,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000701: {
                "attributeName": "VoltageOverload",
                "attributeId": 0x00000701,
                "type": "int",
                "reportable": True,
            },
            0x00000702: {
                "attributeName": "CurrentOverload",
                "attributeId": 0x00000702,
                "type": "int",
                "reportable": True,
            },
            0x00000800: {
                "attributeName": "AcOverloadAlarmsMask",
                "attributeId": 0x00000800,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000801: {
                "attributeName": "AcVoltageOverload",
                "attributeId": 0x00000801,
                "type": "int",
                "reportable": True,
            },
            0x00000802: {
                "attributeName": "AcCurrentOverload",
                "attributeId": 0x00000802,
                "type": "int",
                "reportable": True,
            },
            0x00000803: {
                "attributeName": "AcActivePowerOverload",
                "attributeId": 0x00000803,
                "type": "int",
                "reportable": True,
            },
            0x00000804: {
                "attributeName": "AcReactivePowerOverload",
                "attributeId": 0x00000804,
                "type": "int",
                "reportable": True,
            },
            0x00000805: {
                "attributeName": "AverageRmsOverVoltage",
                "attributeId": 0x00000805,
                "type": "int",
                "reportable": True,
            },
            0x00000806: {
                "attributeName": "AverageRmsUnderVoltage",
                "attributeId": 0x00000806,
                "type": "int",
                "reportable": True,
            },
            0x00000807: {
                "attributeName": "RmsExtremeOverVoltage",
                "attributeId": 0x00000807,
                "type": "int",
                "reportable": True,
            },
            0x00000808: {
                "attributeName": "RmsExtremeUnderVoltage",
                "attributeId": 0x00000808,
                "type": "int",
                "reportable": True,
            },
            0x00000809: {
                "attributeName": "RmsVoltageSag",
                "attributeId": 0x00000809,
                "type": "int",
                "reportable": True,
            },
            0x0000080A: {
                "attributeName": "RmsVoltageSwell",
                "attributeId": 0x0000080A,
                "type": "int",
                "reportable": True,
            },
            0x00000901: {
                "attributeName": "LineCurrentPhaseB",
                "attributeId": 0x00000901,
                "type": "int",
                "reportable": True,
            },
            0x00000902: {
                "attributeName": "ActiveCurrentPhaseB",
                "attributeId": 0x00000902,
                "type": "int",
                "reportable": True,
            },
            0x00000903: {
                "attributeName": "ReactiveCurrentPhaseB",
                "attributeId": 0x00000903,
                "type": "int",
                "reportable": True,
            },
            0x00000905: {
                "attributeName": "RmsVoltagePhaseB",
                "attributeId": 0x00000905,
                "type": "int",
                "reportable": True,
            },
            0x00000906: {
                "attributeName": "RmsVoltageMinPhaseB",
                "attributeId": 0x00000906,
                "type": "int",
                "reportable": True,
            },
            0x00000907: {
                "attributeName": "RmsVoltageMaxPhaseB",
                "attributeId": 0x00000907,
                "type": "int",
                "reportable": True,
            },
            0x00000908: {
                "attributeName": "RmsCurrentPhaseB",
                "attributeId": 0x00000908,
                "type": "int",
                "reportable": True,
            },
            0x00000909: {
                "attributeName": "RmsCurrentMinPhaseB",
                "attributeId": 0x00000909,
                "type": "int",
                "reportable": True,
            },
            0x0000090A: {
                "attributeName": "RmsCurrentMaxPhaseB",
                "attributeId": 0x0000090A,
                "type": "int",
                "reportable": True,
            },
            0x0000090B: {
                "attributeName": "ActivePowerPhaseB",
                "attributeId": 0x0000090B,
                "type": "int",
                "reportable": True,
            },
            0x0000090C: {
                "attributeName": "ActivePowerMinPhaseB",
                "attributeId": 0x0000090C,
                "type": "int",
                "reportable": True,
            },
            0x0000090D: {
                "attributeName": "ActivePowerMaxPhaseB",
                "attributeId": 0x0000090D,
                "type": "int",
                "reportable": True,
            },
            0x0000090E: {
                "attributeName": "ReactivePowerPhaseB",
                "attributeId": 0x0000090E,
                "type": "int",
                "reportable": True,
            },
            0x0000090F: {
                "attributeName": "ApparentPowerPhaseB",
                "attributeId": 0x0000090F,
                "type": "int",
                "reportable": True,
            },
            0x00000910: {
                "attributeName": "PowerFactorPhaseB",
                "attributeId": 0x00000910,
                "type": "int",
                "reportable": True,
            },
            0x00000911: {
                "attributeName": "AverageRmsVoltageMeasurementPeriodPhaseB",
                "attributeId": 0x00000911,
                "type": "int",
                "reportable": True,
            },
            0x00000912: {
                "attributeName": "AverageRmsOverVoltageCounterPhaseB",
                "attributeId": 0x00000912,
                "type": "int",
                "reportable": True,
            },
            0x00000913: {
                "attributeName": "AverageRmsUnderVoltageCounterPhaseB",
                "attributeId": 0x00000913,
                "type": "int",
                "reportable": True,
            },
            0x00000914: {
                "attributeName": "RmsExtremeOverVoltagePeriodPhaseB",
                "attributeId": 0x00000914,
                "type": "int",
                "reportable": True,
            },
            0x00000915: {
                "attributeName": "RmsExtremeUnderVoltagePeriodPhaseB",
                "attributeId": 0x00000915,
                "type": "int",
                "reportable": True,
            },
            0x00000916: {
                "attributeName": "RmsVoltageSagPeriodPhaseB",
                "attributeId": 0x00000916,
                "type": "int",
                "reportable": True,
            },
            0x00000917: {
                "attributeName": "RmsVoltageSwellPeriodPhaseB",
                "attributeId": 0x00000917,
                "type": "int",
                "reportable": True,
            },
            0x00000A01: {
                "attributeName": "LineCurrentPhaseC",
                "attributeId": 0x00000A01,
                "type": "int",
                "reportable": True,
            },
            0x00000A02: {
                "attributeName": "ActiveCurrentPhaseC",
                "attributeId": 0x00000A02,
                "type": "int",
                "reportable": True,
            },
            0x00000A03: {
                "attributeName": "ReactiveCurrentPhaseC",
                "attributeId": 0x00000A03,
                "type": "int",
                "reportable": True,
            },
            0x00000A05: {
                "attributeName": "RmsVoltagePhaseC",
                "attributeId": 0x00000A05,
                "type": "int",
                "reportable": True,
            },
            0x00000A06: {
                "attributeName": "RmsVoltageMinPhaseC",
                "attributeId": 0x00000A06,
                "type": "int",
                "reportable": True,
            },
            0x00000A07: {
                "attributeName": "RmsVoltageMaxPhaseC",
                "attributeId": 0x00000A07,
                "type": "int",
                "reportable": True,
            },
            0x00000A08: {
                "attributeName": "RmsCurrentPhaseC",
                "attributeId": 0x00000A08,
                "type": "int",
                "reportable": True,
            },
            0x00000A09: {
                "attributeName": "RmsCurrentMinPhaseC",
                "attributeId": 0x00000A09,
                "type": "int",
                "reportable": True,
            },
            0x00000A0A: {
                "attributeName": "RmsCurrentMaxPhaseC",
                "attributeId": 0x00000A0A,
                "type": "int",
                "reportable": True,
            },
            0x00000A0B: {
                "attributeName": "ActivePowerPhaseC",
                "attributeId": 0x00000A0B,
                "type": "int",
                "reportable": True,
            },
            0x00000A0C: {
                "attributeName": "ActivePowerMinPhaseC",
                "attributeId": 0x00000A0C,
                "type": "int",
                "reportable": True,
            },
            0x00000A0D: {
                "attributeName": "ActivePowerMaxPhaseC",
                "attributeId": 0x00000A0D,
                "type": "int",
                "reportable": True,
            },
            0x00000A0E: {
                "attributeName": "ReactivePowerPhaseC",
                "attributeId": 0x00000A0E,
                "type": "int",
                "reportable": True,
            },
            0x00000A0F: {
                "attributeName": "ApparentPowerPhaseC",
                "attributeId": 0x00000A0F,
                "type": "int",
                "reportable": True,
            },
            0x00000A10: {
                "attributeName": "PowerFactorPhaseC",
                "attributeId": 0x00000A10,
                "type": "int",
                "reportable": True,
            },
            0x00000A11: {
                "attributeName": "AverageRmsVoltageMeasurementPeriodPhaseC",
                "attributeId": 0x00000A11,
                "type": "int",
                "reportable": True,
            },
            0x00000A12: {
                "attributeName": "AverageRmsOverVoltageCounterPhaseC",
                "attributeId": 0x00000A12,
                "type": "int",
                "reportable": True,
            },
            0x00000A13: {
                "attributeName": "AverageRmsUnderVoltageCounterPhaseC",
                "attributeId": 0x00000A13,
                "type": "int",
                "reportable": True,
            },
            0x00000A14: {
                "attributeName": "RmsExtremeOverVoltagePeriodPhaseC",
                "attributeId": 0x00000A14,
                "type": "int",
                "reportable": True,
            },
            0x00000A15: {
                "attributeName": "RmsExtremeUnderVoltagePeriodPhaseC",
                "attributeId": 0x00000A15,
                "type": "int",
                "reportable": True,
            },
            0x00000A16: {
                "attributeName": "RmsVoltageSagPeriodPhaseC",
                "attributeId": 0x00000A16,
                "type": "int",
                "reportable": True,
            },
            0x00000A17: {
                "attributeName": "RmsVoltageSwellPeriodPhaseC",
                "attributeId": 0x00000A17,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _UNIT_TESTING_CLUSTER_INFO = {
        "clusterName": "UnitTesting",
        "clusterId": 0xFFF1FC05,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "Test",
                "args": {
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "TestNotHandled",
                "args": {
                },
            },
            0x00000002: {
                "commandId": 0x00000002,
                "commandName": "TestSpecific",
                "args": {
                },
            },
            0x00000003: {
                "commandId": 0x00000003,
                "commandName": "TestUnknownCommand",
                "args": {
                },
            },
            0x00000004: {
                "commandId": 0x00000004,
                "commandName": "TestAddArguments",
                "args": {
                    "arg1": "int",
                    "arg2": "int",
                },
            },
            0x00000005: {
                "commandId": 0x00000005,
                "commandName": "TestSimpleArgumentRequest",
                "args": {
                    "arg1": "bool",
                },
            },
            0x00000006: {
                "commandId": 0x00000006,
                "commandName": "TestStructArrayArgumentRequest",
                "args": {
                    "arg1": "NestedStructList",
                    "arg2": "SimpleStruct",
                    "arg3": "int",
                    "arg4": "bool",
                    "arg5": "int",
                    "arg6": "bool",
                },
            },
            0x00000007: {
                "commandId": 0x00000007,
                "commandName": "TestStructArgumentRequest",
                "args": {
                    "arg1": "SimpleStruct",
                },
            },
            0x00000008: {
                "commandId": 0x00000008,
                "commandName": "TestNestedStructArgumentRequest",
                "args": {
                    "arg1": "NestedStruct",
                },
            },
            0x00000009: {
                "commandId": 0x00000009,
                "commandName": "TestListStructArgumentRequest",
                "args": {
                    "arg1": "SimpleStruct",
                },
            },
            0x0000000A: {
                "commandId": 0x0000000A,
                "commandName": "TestListInt8UArgumentRequest",
                "args": {
                    "arg1": "int",
                },
            },
            0x0000000B: {
                "commandId": 0x0000000B,
                "commandName": "TestNestedStructListArgumentRequest",
                "args": {
                    "arg1": "NestedStructList",
                },
            },
            0x0000000C: {
                "commandId": 0x0000000C,
                "commandName": "TestListNestedStructListArgumentRequest",
                "args": {
                    "arg1": "NestedStructList",
                },
            },
            0x0000000D: {
                "commandId": 0x0000000D,
                "commandName": "TestListInt8UReverseRequest",
                "args": {
                    "arg1": "int",
                },
            },
            0x0000000E: {
                "commandId": 0x0000000E,
                "commandName": "TestEnumsRequest",
                "args": {
                    "arg1": "int",
                    "arg2": "int",
                },
            },
            0x0000000F: {
                "commandId": 0x0000000F,
                "commandName": "TestNullableOptionalRequest",
                "args": {
                    "arg1": "int",
                },
            },
            0x00000010: {
                "commandId": 0x00000010,
                "commandName": "TestComplexNullableOptionalRequest",
                "args": {
                    "nullableInt": "int",
                    "optionalInt": "int",
                    "nullableOptionalInt": "int",
                    "nullableString": "str",
                    "optionalString": "str",
                    "nullableOptionalString": "str",
                    "nullableStruct": "SimpleStruct",
                    "optionalStruct": "SimpleStruct",
                    "nullableOptionalStruct": "SimpleStruct",
                    "nullableList": "int",
                    "optionalList": "int",
                    "nullableOptionalList": "int",
                },
            },
            0x00000011: {
                "commandId": 0x00000011,
                "commandName": "SimpleStructEchoRequest",
                "args": {
                    "arg1": "SimpleStruct",
                },
            },
            0x00000012: {
                "commandId": 0x00000012,
                "commandName": "TimedInvokeRequest",
                "args": {
                },
            },
            0x00000013: {
                "commandId": 0x00000013,
                "commandName": "TestSimpleOptionalArgumentRequest",
                "args": {
                    "arg1": "bool",
                },
            },
            0x00000014: {
                "commandId": 0x00000014,
                "commandName": "TestEmitTestEventRequest",
                "args": {
                    "arg1": "int",
                    "arg2": "int",
                    "arg3": "bool",
                },
            },
            0x00000015: {
                "commandId": 0x00000015,
                "commandName": "TestEmitTestFabricScopedEventRequest",
                "args": {
                    "arg1": "int",
                },
            },
        },
        "attributes": {
            0x00000000: {
                "attributeName": "Boolean",
                "attributeId": 0x00000000,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00000001: {
                "attributeName": "Bitmap8",
                "attributeId": 0x00000001,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000002: {
                "attributeName": "Bitmap16",
                "attributeId": 0x00000002,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000003: {
                "attributeName": "Bitmap32",
                "attributeId": 0x00000003,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000004: {
                "attributeName": "Bitmap64",
                "attributeId": 0x00000004,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000005: {
                "attributeName": "Int8u",
                "attributeId": 0x00000005,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000006: {
                "attributeName": "Int16u",
                "attributeId": 0x00000006,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000007: {
                "attributeName": "Int24u",
                "attributeId": 0x00000007,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000008: {
                "attributeName": "Int32u",
                "attributeId": 0x00000008,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000009: {
                "attributeName": "Int40u",
                "attributeId": 0x00000009,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000000A: {
                "attributeName": "Int48u",
                "attributeId": 0x0000000A,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000000B: {
                "attributeName": "Int56u",
                "attributeId": 0x0000000B,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000000C: {
                "attributeName": "Int64u",
                "attributeId": 0x0000000C,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000000D: {
                "attributeName": "Int8s",
                "attributeId": 0x0000000D,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000000E: {
                "attributeName": "Int16s",
                "attributeId": 0x0000000E,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000000F: {
                "attributeName": "Int24s",
                "attributeId": 0x0000000F,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000010: {
                "attributeName": "Int32s",
                "attributeId": 0x00000010,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000011: {
                "attributeName": "Int40s",
                "attributeId": 0x00000011,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000012: {
                "attributeName": "Int48s",
                "attributeId": 0x00000012,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000013: {
                "attributeName": "Int56s",
                "attributeId": 0x00000013,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000014: {
                "attributeName": "Int64s",
                "attributeId": 0x00000014,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000015: {
                "attributeName": "Enum8",
                "attributeId": 0x00000015,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000016: {
                "attributeName": "Enum16",
                "attributeId": 0x00000016,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000017: {
                "attributeName": "FloatSingle",
                "attributeId": 0x00000017,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00000018: {
                "attributeName": "FloatDouble",
                "attributeId": 0x00000018,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00000019: {
                "attributeName": "OctetString",
                "attributeId": 0x00000019,
                "type": "bytes",
                "reportable": True,
                "writable": True,
            },
            0x0000001A: {
                "attributeName": "ListInt8u",
                "attributeId": 0x0000001A,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000001B: {
                "attributeName": "ListOctetString",
                "attributeId": 0x0000001B,
                "type": "bytes",
                "reportable": True,
                "writable": True,
            },
            0x0000001C: {
                "attributeName": "ListStructOctetString",
                "attributeId": 0x0000001C,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x0000001D: {
                "attributeName": "LongOctetString",
                "attributeId": 0x0000001D,
                "type": "bytes",
                "reportable": True,
                "writable": True,
            },
            0x0000001E: {
                "attributeName": "CharString",
                "attributeId": 0x0000001E,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x0000001F: {
                "attributeName": "LongCharString",
                "attributeId": 0x0000001F,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x00000020: {
                "attributeName": "EpochUs",
                "attributeId": 0x00000020,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000021: {
                "attributeName": "EpochS",
                "attributeId": 0x00000021,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000022: {
                "attributeName": "VendorId",
                "attributeId": 0x00000022,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000023: {
                "attributeName": "ListNullablesAndOptionalsStruct",
                "attributeId": 0x00000023,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00000024: {
                "attributeName": "EnumAttr",
                "attributeId": 0x00000024,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000025: {
                "attributeName": "StructAttr",
                "attributeId": 0x00000025,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00000026: {
                "attributeName": "RangeRestrictedInt8u",
                "attributeId": 0x00000026,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000027: {
                "attributeName": "RangeRestrictedInt8s",
                "attributeId": 0x00000027,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000028: {
                "attributeName": "RangeRestrictedInt16u",
                "attributeId": 0x00000028,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00000029: {
                "attributeName": "RangeRestrictedInt16s",
                "attributeId": 0x00000029,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000002A: {
                "attributeName": "ListLongOctetString",
                "attributeId": 0x0000002A,
                "type": "bytes",
                "reportable": True,
                "writable": True,
            },
            0x0000002B: {
                "attributeName": "ListFabricScoped",
                "attributeId": 0x0000002B,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00000030: {
                "attributeName": "TimedWriteBoolean",
                "attributeId": 0x00000030,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00000031: {
                "attributeName": "GeneralErrorBoolean",
                "attributeId": 0x00000031,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00000032: {
                "attributeName": "ClusterErrorBoolean",
                "attributeId": 0x00000032,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x000000FF: {
                "attributeName": "Unsupported",
                "attributeId": 0x000000FF,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00004000: {
                "attributeName": "NullableBoolean",
                "attributeId": 0x00004000,
                "type": "bool",
                "reportable": True,
                "writable": True,
            },
            0x00004001: {
                "attributeName": "NullableBitmap8",
                "attributeId": 0x00004001,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004002: {
                "attributeName": "NullableBitmap16",
                "attributeId": 0x00004002,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004003: {
                "attributeName": "NullableBitmap32",
                "attributeId": 0x00004003,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004004: {
                "attributeName": "NullableBitmap64",
                "attributeId": 0x00004004,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004005: {
                "attributeName": "NullableInt8u",
                "attributeId": 0x00004005,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004006: {
                "attributeName": "NullableInt16u",
                "attributeId": 0x00004006,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004007: {
                "attributeName": "NullableInt24u",
                "attributeId": 0x00004007,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004008: {
                "attributeName": "NullableInt32u",
                "attributeId": 0x00004008,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004009: {
                "attributeName": "NullableInt40u",
                "attributeId": 0x00004009,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000400A: {
                "attributeName": "NullableInt48u",
                "attributeId": 0x0000400A,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000400B: {
                "attributeName": "NullableInt56u",
                "attributeId": 0x0000400B,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000400C: {
                "attributeName": "NullableInt64u",
                "attributeId": 0x0000400C,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000400D: {
                "attributeName": "NullableInt8s",
                "attributeId": 0x0000400D,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000400E: {
                "attributeName": "NullableInt16s",
                "attributeId": 0x0000400E,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000400F: {
                "attributeName": "NullableInt24s",
                "attributeId": 0x0000400F,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004010: {
                "attributeName": "NullableInt32s",
                "attributeId": 0x00004010,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004011: {
                "attributeName": "NullableInt40s",
                "attributeId": 0x00004011,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004012: {
                "attributeName": "NullableInt48s",
                "attributeId": 0x00004012,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004013: {
                "attributeName": "NullableInt56s",
                "attributeId": 0x00004013,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004014: {
                "attributeName": "NullableInt64s",
                "attributeId": 0x00004014,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004015: {
                "attributeName": "NullableEnum8",
                "attributeId": 0x00004015,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004016: {
                "attributeName": "NullableEnum16",
                "attributeId": 0x00004016,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004017: {
                "attributeName": "NullableFloatSingle",
                "attributeId": 0x00004017,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00004018: {
                "attributeName": "NullableFloatDouble",
                "attributeId": 0x00004018,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00004019: {
                "attributeName": "NullableOctetString",
                "attributeId": 0x00004019,
                "type": "bytes",
                "reportable": True,
                "writable": True,
            },
            0x0000401E: {
                "attributeName": "NullableCharString",
                "attributeId": 0x0000401E,
                "type": "str",
                "reportable": True,
                "writable": True,
            },
            0x00004024: {
                "attributeName": "NullableEnumAttr",
                "attributeId": 0x00004024,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004025: {
                "attributeName": "NullableStruct",
                "attributeId": 0x00004025,
                "type": "",
                "reportable": True,
                "writable": True,
            },
            0x00004026: {
                "attributeName": "NullableRangeRestrictedInt8u",
                "attributeId": 0x00004026,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004027: {
                "attributeName": "NullableRangeRestrictedInt8s",
                "attributeId": 0x00004027,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004028: {
                "attributeName": "NullableRangeRestrictedInt16u",
                "attributeId": 0x00004028,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x00004029: {
                "attributeName": "NullableRangeRestrictedInt16s",
                "attributeId": 0x00004029,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000402A: {
                "attributeName": "WriteOnlyInt8u",
                "attributeId": 0x0000402A,
                "type": "int",
                "reportable": True,
                "writable": True,
            },
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }
    _FAULT_INJECTION_CLUSTER_INFO = {
        "clusterName": "FaultInjection",
        "clusterId": 0xFFF1FC06,
        "commands": {
            0x00000000: {
                "commandId": 0x00000000,
                "commandName": "FailAtFault",
                "args": {
                    "type": "int",
                    "id": "int",
                    "numCallsToSkip": "int",
                    "numCallsToFail": "int",
                    "takeMutex": "bool",
                },
            },
            0x00000001: {
                "commandId": 0x00000001,
                "commandName": "FailRandomlyAtFault",
                "args": {
                    "type": "int",
                    "id": "int",
                    "percentage": "int",
                },
            },
        },
        "attributes": {
            0x0000FFF8: {
                "attributeName": "GeneratedCommandList",
                "attributeId": 0x0000FFF8,
                "type": "int",
                "reportable": True,
            },
            0x0000FFF9: {
                "attributeName": "AcceptedCommandList",
                "attributeId": 0x0000FFF9,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFA: {
                "attributeName": "EventList",
                "attributeId": 0x0000FFFA,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFB: {
                "attributeName": "AttributeList",
                "attributeId": 0x0000FFFB,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFC: {
                "attributeName": "FeatureMap",
                "attributeId": 0x0000FFFC,
                "type": "int",
                "reportable": True,
            },
            0x0000FFFD: {
                "attributeName": "ClusterRevision",
                "attributeId": 0x0000FFFD,
                "type": "int",
                "reportable": True,
            },
        },
    }

    _CLUSTER_ID_DICT = {
        0x00000003: _IDENTIFY_CLUSTER_INFO,
        0x00000004: _GROUPS_CLUSTER_INFO,
        0x00000005: _SCENES_CLUSTER_INFO,
        0x00000006: _ON_OFF_CLUSTER_INFO,
        0x00000007: _ON_OFF_SWITCH_CONFIGURATION_CLUSTER_INFO,
        0x00000008: _LEVEL_CONTROL_CLUSTER_INFO,
        0x0000000F: _BINARY_INPUT_BASIC_CLUSTER_INFO,
        0x0000001C: _PULSE_WIDTH_MODULATION_CLUSTER_INFO,
        0x0000001D: _DESCRIPTOR_CLUSTER_INFO,
        0x0000001E: _BINDING_CLUSTER_INFO,
        0x0000001F: _ACCESS_CONTROL_CLUSTER_INFO,
        0x00000025: _ACTIONS_CLUSTER_INFO,
        0x00000028: _BASIC_INFORMATION_CLUSTER_INFO,
        0x00000029: _OTA_SOFTWARE_UPDATE_PROVIDER_CLUSTER_INFO,
        0x0000002A: _OTA_SOFTWARE_UPDATE_REQUESTOR_CLUSTER_INFO,
        0x0000002B: _LOCALIZATION_CONFIGURATION_CLUSTER_INFO,
        0x0000002C: _TIME_FORMAT_LOCALIZATION_CLUSTER_INFO,
        0x0000002D: _UNIT_LOCALIZATION_CLUSTER_INFO,
        0x0000002E: _POWER_SOURCE_CONFIGURATION_CLUSTER_INFO,
        0x0000002F: _POWER_SOURCE_CLUSTER_INFO,
        0x00000030: _GENERAL_COMMISSIONING_CLUSTER_INFO,
        0x00000031: _NETWORK_COMMISSIONING_CLUSTER_INFO,
        0x00000032: _DIAGNOSTIC_LOGS_CLUSTER_INFO,
        0x00000033: _GENERAL_DIAGNOSTICS_CLUSTER_INFO,
        0x00000034: _SOFTWARE_DIAGNOSTICS_CLUSTER_INFO,
        0x00000035: _THREAD_NETWORK_DIAGNOSTICS_CLUSTER_INFO,
        0x00000036: _WI_FI_NETWORK_DIAGNOSTICS_CLUSTER_INFO,
        0x00000037: _ETHERNET_NETWORK_DIAGNOSTICS_CLUSTER_INFO,
        0x00000038: _TIME_SYNCHRONIZATION_CLUSTER_INFO,
        0x00000039: _BRIDGED_DEVICE_BASIC_INFORMATION_CLUSTER_INFO,
        0x0000003B: _SWITCH_CLUSTER_INFO,
        0x0000003C: _ADMINISTRATOR_COMMISSIONING_CLUSTER_INFO,
        0x0000003E: _OPERATIONAL_CREDENTIALS_CLUSTER_INFO,
        0x0000003F: _GROUP_KEY_MANAGEMENT_CLUSTER_INFO,
        0x00000040: _FIXED_LABEL_CLUSTER_INFO,
        0x00000041: _USER_LABEL_CLUSTER_INFO,
        0x00000042: _PROXY_CONFIGURATION_CLUSTER_INFO,
        0x00000043: _PROXY_DISCOVERY_CLUSTER_INFO,
        0x00000044: _PROXY_VALID_CLUSTER_INFO,
        0x00000045: _BOOLEAN_STATE_CLUSTER_INFO,
        0x00000046: _ICD_MANAGEMENT_CLUSTER_INFO,
        0x00000050: _MODE_SELECT_CLUSTER_INFO,
        0x00000056: _TEMPERATURE_CONTROL_CLUSTER_INFO,
        0x00000057: _REFRIGERATOR_ALARM_CLUSTER_INFO,
        0x0000005B: _AIR_QUALITY_CLUSTER_INFO,
        0x0000005C: _SMOKE_CO_ALARM_CLUSTER_INFO,
        0x00000060: _OPERATIONAL_STATE_CLUSTER_INFO,
        0x00000071: _HEPA_FILTER_MONITORING_CLUSTER_INFO,
        0x00000072: _ACTIVATED_CARBON_FILTER_MONITORING_CLUSTER_INFO,
        0x00000073: _CERAMIC_FILTER_MONITORING_CLUSTER_INFO,
        0x00000074: _ELECTROSTATIC_FILTER_MONITORING_CLUSTER_INFO,
        0x00000075: _UV_FILTER_MONITORING_CLUSTER_INFO,
        0x00000076: _IONIZING_FILTER_MONITORING_CLUSTER_INFO,
        0x00000077: _ZEOLITE_FILTER_MONITORING_CLUSTER_INFO,
        0x00000078: _OZONE_FILTER_MONITORING_CLUSTER_INFO,
        0x00000079: _WATER_TANK_MONITORING_CLUSTER_INFO,
        0x0000007A: _FUEL_TANK_MONITORING_CLUSTER_INFO,
        0x0000007B: _INK_CARTRIDGE_MONITORING_CLUSTER_INFO,
        0x0000007C: _TONER_CARTRIDGE_MONITORING_CLUSTER_INFO,
        0x00000101: _DOOR_LOCK_CLUSTER_INFO,
        0x00000102: _WINDOW_COVERING_CLUSTER_INFO,
        0x00000103: _BARRIER_CONTROL_CLUSTER_INFO,
        0x00000200: _PUMP_CONFIGURATION_AND_CONTROL_CLUSTER_INFO,
        0x00000201: _THERMOSTAT_CLUSTER_INFO,
        0x00000202: _FAN_CONTROL_CLUSTER_INFO,
        0x00000204: _THERMOSTAT_USER_INTERFACE_CONFIGURATION_CLUSTER_INFO,
        0x00000300: _COLOR_CONTROL_CLUSTER_INFO,
        0x00000301: _BALLAST_CONFIGURATION_CLUSTER_INFO,
        0x00000400: _ILLUMINANCE_MEASUREMENT_CLUSTER_INFO,
        0x00000402: _TEMPERATURE_MEASUREMENT_CLUSTER_INFO,
        0x00000403: _PRESSURE_MEASUREMENT_CLUSTER_INFO,
        0x00000404: _FLOW_MEASUREMENT_CLUSTER_INFO,
        0x00000405: _RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER_INFO,
        0x00000406: _OCCUPANCY_SENSING_CLUSTER_INFO,
        0x0000040C: _CARBON_MONOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000040D: _CARBON_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000040E: _ETHYLENE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000040F: _ETHYLENE_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000410: _HYDROGEN_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000411: _HYDROGEN_SULFIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000412: _NITRIC_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000413: _NITROGEN_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000414: _OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000415: _OZONE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000416: _SULFUR_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000417: _DISSOLVED_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000418: _BROMATE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000419: _CHLORAMINES_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000041A: _CHLORINE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000041B: _FECAL_COLIFORM_E_COLI_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000041C: _FLUORIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000041D: _HALOACETIC_ACIDS_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000041E: _TOTAL_TRIHALOMETHANES_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000041F: _TOTAL_COLIFORM_BACTERIA_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000420: _TURBIDITY_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000421: _COPPER_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000422: _LEAD_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000423: _MANGANESE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000424: _SULFATE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000425: _BROMODICHLOROMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000426: _BROMOFORM_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000427: _CHLORODIBROMOMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000428: _CHLOROFORM_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000429: _SODIUM_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000042A: _PM2__5_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000042B: _FORMALDEHYDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000042C: _PM1_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000042D: _PM10_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000042E: _TOTAL_VOLATILE_ORGANIC_COMPOUNDS_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x0000042F: _RADON_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        0x00000503: _WAKE_ON_LAN_CLUSTER_INFO,
        0x00000504: _CHANNEL_CLUSTER_INFO,
        0x00000505: _TARGET_NAVIGATOR_CLUSTER_INFO,
        0x00000506: _MEDIA_PLAYBACK_CLUSTER_INFO,
        0x00000507: _MEDIA_INPUT_CLUSTER_INFO,
        0x00000508: _LOW_POWER_CLUSTER_INFO,
        0x00000509: _KEYPAD_INPUT_CLUSTER_INFO,
        0x0000050A: _CONTENT_LAUNCHER_CLUSTER_INFO,
        0x0000050B: _AUDIO_OUTPUT_CLUSTER_INFO,
        0x0000050C: _APPLICATION_LAUNCHER_CLUSTER_INFO,
        0x0000050D: _APPLICATION_BASIC_CLUSTER_INFO,
        0x0000050E: _ACCOUNT_LOGIN_CLUSTER_INFO,
        0x00000B04: _ELECTRICAL_MEASUREMENT_CLUSTER_INFO,
        0xFFF1FC05: _UNIT_TESTING_CLUSTER_INFO,
        0xFFF1FC06: _FAULT_INJECTION_CLUSTER_INFO,
    }

    _CLUSTER_NAME_DICT = {
        "Identify": _IDENTIFY_CLUSTER_INFO,
        "Groups": _GROUPS_CLUSTER_INFO,
        "Scenes": _SCENES_CLUSTER_INFO,
        "OnOff": _ON_OFF_CLUSTER_INFO,
        "OnOffSwitchConfiguration": _ON_OFF_SWITCH_CONFIGURATION_CLUSTER_INFO,
        "LevelControl": _LEVEL_CONTROL_CLUSTER_INFO,
        "BinaryInputBasic": _BINARY_INPUT_BASIC_CLUSTER_INFO,
        "PulseWidthModulation": _PULSE_WIDTH_MODULATION_CLUSTER_INFO,
        "Descriptor": _DESCRIPTOR_CLUSTER_INFO,
        "Binding": _BINDING_CLUSTER_INFO,
        "AccessControl": _ACCESS_CONTROL_CLUSTER_INFO,
        "Actions": _ACTIONS_CLUSTER_INFO,
        "BasicInformation": _BASIC_INFORMATION_CLUSTER_INFO,
        "OtaSoftwareUpdateProvider": _OTA_SOFTWARE_UPDATE_PROVIDER_CLUSTER_INFO,
        "OtaSoftwareUpdateRequestor": _OTA_SOFTWARE_UPDATE_REQUESTOR_CLUSTER_INFO,
        "LocalizationConfiguration": _LOCALIZATION_CONFIGURATION_CLUSTER_INFO,
        "TimeFormatLocalization": _TIME_FORMAT_LOCALIZATION_CLUSTER_INFO,
        "UnitLocalization": _UNIT_LOCALIZATION_CLUSTER_INFO,
        "PowerSourceConfiguration": _POWER_SOURCE_CONFIGURATION_CLUSTER_INFO,
        "PowerSource": _POWER_SOURCE_CLUSTER_INFO,
        "GeneralCommissioning": _GENERAL_COMMISSIONING_CLUSTER_INFO,
        "NetworkCommissioning": _NETWORK_COMMISSIONING_CLUSTER_INFO,
        "DiagnosticLogs": _DIAGNOSTIC_LOGS_CLUSTER_INFO,
        "GeneralDiagnostics": _GENERAL_DIAGNOSTICS_CLUSTER_INFO,
        "SoftwareDiagnostics": _SOFTWARE_DIAGNOSTICS_CLUSTER_INFO,
        "ThreadNetworkDiagnostics": _THREAD_NETWORK_DIAGNOSTICS_CLUSTER_INFO,
        "WiFiNetworkDiagnostics": _WI_FI_NETWORK_DIAGNOSTICS_CLUSTER_INFO,
        "EthernetNetworkDiagnostics": _ETHERNET_NETWORK_DIAGNOSTICS_CLUSTER_INFO,
        "TimeSynchronization": _TIME_SYNCHRONIZATION_CLUSTER_INFO,
        "BridgedDeviceBasicInformation": _BRIDGED_DEVICE_BASIC_INFORMATION_CLUSTER_INFO,
        "Switch": _SWITCH_CLUSTER_INFO,
        "AdministratorCommissioning": _ADMINISTRATOR_COMMISSIONING_CLUSTER_INFO,
        "OperationalCredentials": _OPERATIONAL_CREDENTIALS_CLUSTER_INFO,
        "GroupKeyManagement": _GROUP_KEY_MANAGEMENT_CLUSTER_INFO,
        "FixedLabel": _FIXED_LABEL_CLUSTER_INFO,
        "UserLabel": _USER_LABEL_CLUSTER_INFO,
        "ProxyConfiguration": _PROXY_CONFIGURATION_CLUSTER_INFO,
        "ProxyDiscovery": _PROXY_DISCOVERY_CLUSTER_INFO,
        "ProxyValid": _PROXY_VALID_CLUSTER_INFO,
        "BooleanState": _BOOLEAN_STATE_CLUSTER_INFO,
        "IcdManagement": _ICD_MANAGEMENT_CLUSTER_INFO,
        "ModeSelect": _MODE_SELECT_CLUSTER_INFO,
        "TemperatureControl": _TEMPERATURE_CONTROL_CLUSTER_INFO,
        "RefrigeratorAlarm": _REFRIGERATOR_ALARM_CLUSTER_INFO,
        "AirQuality": _AIR_QUALITY_CLUSTER_INFO,
        "SmokeCoAlarm": _SMOKE_CO_ALARM_CLUSTER_INFO,
        "OperationalState": _OPERATIONAL_STATE_CLUSTER_INFO,
        "HepaFilterMonitoring": _HEPA_FILTER_MONITORING_CLUSTER_INFO,
        "ActivatedCarbonFilterMonitoring": _ACTIVATED_CARBON_FILTER_MONITORING_CLUSTER_INFO,
        "CeramicFilterMonitoring": _CERAMIC_FILTER_MONITORING_CLUSTER_INFO,
        "ElectrostaticFilterMonitoring": _ELECTROSTATIC_FILTER_MONITORING_CLUSTER_INFO,
        "UvFilterMonitoring": _UV_FILTER_MONITORING_CLUSTER_INFO,
        "IonizingFilterMonitoring": _IONIZING_FILTER_MONITORING_CLUSTER_INFO,
        "ZeoliteFilterMonitoring": _ZEOLITE_FILTER_MONITORING_CLUSTER_INFO,
        "OzoneFilterMonitoring": _OZONE_FILTER_MONITORING_CLUSTER_INFO,
        "WaterTankMonitoring": _WATER_TANK_MONITORING_CLUSTER_INFO,
        "FuelTankMonitoring": _FUEL_TANK_MONITORING_CLUSTER_INFO,
        "InkCartridgeMonitoring": _INK_CARTRIDGE_MONITORING_CLUSTER_INFO,
        "TonerCartridgeMonitoring": _TONER_CARTRIDGE_MONITORING_CLUSTER_INFO,
        "DoorLock": _DOOR_LOCK_CLUSTER_INFO,
        "WindowCovering": _WINDOW_COVERING_CLUSTER_INFO,
        "BarrierControl": _BARRIER_CONTROL_CLUSTER_INFO,
        "PumpConfigurationAndControl": _PUMP_CONFIGURATION_AND_CONTROL_CLUSTER_INFO,
        "Thermostat": _THERMOSTAT_CLUSTER_INFO,
        "FanControl": _FAN_CONTROL_CLUSTER_INFO,
        "ThermostatUserInterfaceConfiguration": _THERMOSTAT_USER_INTERFACE_CONFIGURATION_CLUSTER_INFO,
        "ColorControl": _COLOR_CONTROL_CLUSTER_INFO,
        "BallastConfiguration": _BALLAST_CONFIGURATION_CLUSTER_INFO,
        "IlluminanceMeasurement": _ILLUMINANCE_MEASUREMENT_CLUSTER_INFO,
        "TemperatureMeasurement": _TEMPERATURE_MEASUREMENT_CLUSTER_INFO,
        "PressureMeasurement": _PRESSURE_MEASUREMENT_CLUSTER_INFO,
        "FlowMeasurement": _FLOW_MEASUREMENT_CLUSTER_INFO,
        "RelativeHumidityMeasurement": _RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER_INFO,
        "OccupancySensing": _OCCUPANCY_SENSING_CLUSTER_INFO,
        "CarbonMonoxideConcentrationMeasurement": _CARBON_MONOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "CarbonDioxideConcentrationMeasurement": _CARBON_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "EthyleneConcentrationMeasurement": _ETHYLENE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "EthyleneOxideConcentrationMeasurement": _ETHYLENE_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "HydrogenConcentrationMeasurement": _HYDROGEN_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "HydrogenSulfideConcentrationMeasurement": _HYDROGEN_SULFIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "NitricOxideConcentrationMeasurement": _NITRIC_OXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "NitrogenDioxideConcentrationMeasurement": _NITROGEN_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "OxygenConcentrationMeasurement": _OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "OzoneConcentrationMeasurement": _OZONE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "SulfurDioxideConcentrationMeasurement": _SULFUR_DIOXIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "DissolvedOxygenConcentrationMeasurement": _DISSOLVED_OXYGEN_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "BromateConcentrationMeasurement": _BROMATE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "ChloraminesConcentrationMeasurement": _CHLORAMINES_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "ChlorineConcentrationMeasurement": _CHLORINE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "FecalColiformEColiConcentrationMeasurement": _FECAL_COLIFORM_E_COLI_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "FluorideConcentrationMeasurement": _FLUORIDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "HaloaceticAcidsConcentrationMeasurement": _HALOACETIC_ACIDS_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "TotalTrihalomethanesConcentrationMeasurement": _TOTAL_TRIHALOMETHANES_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "TotalColiformBacteriaConcentrationMeasurement": _TOTAL_COLIFORM_BACTERIA_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "TurbidityConcentrationMeasurement": _TURBIDITY_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "CopperConcentrationMeasurement": _COPPER_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "LeadConcentrationMeasurement": _LEAD_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "ManganeseConcentrationMeasurement": _MANGANESE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "SulfateConcentrationMeasurement": _SULFATE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "BromodichloromethaneConcentrationMeasurement": _BROMODICHLOROMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "BromoformConcentrationMeasurement": _BROMOFORM_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "ChlorodibromomethaneConcentrationMeasurement": _CHLORODIBROMOMETHANE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "ChloroformConcentrationMeasurement": _CHLOROFORM_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "SodiumConcentrationMeasurement": _SODIUM_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "Pm25ConcentrationMeasurement": _PM2__5_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "FormaldehydeConcentrationMeasurement": _FORMALDEHYDE_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "Pm1ConcentrationMeasurement": _PM1_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "Pm10ConcentrationMeasurement": _PM10_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "TotalVolatileOrganicCompoundsConcentrationMeasurement": _TOTAL_VOLATILE_ORGANIC_COMPOUNDS_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "RadonConcentrationMeasurement": _RADON_CONCENTRATION_MEASUREMENT_CLUSTER_INFO,
        "WakeOnLan": _WAKE_ON_LAN_CLUSTER_INFO,
        "Channel": _CHANNEL_CLUSTER_INFO,
        "TargetNavigator": _TARGET_NAVIGATOR_CLUSTER_INFO,
        "MediaPlayback": _MEDIA_PLAYBACK_CLUSTER_INFO,
        "MediaInput": _MEDIA_INPUT_CLUSTER_INFO,
        "LowPower": _LOW_POWER_CLUSTER_INFO,
        "KeypadInput": _KEYPAD_INPUT_CLUSTER_INFO,
        "ContentLauncher": _CONTENT_LAUNCHER_CLUSTER_INFO,
        "AudioOutput": _AUDIO_OUTPUT_CLUSTER_INFO,
        "ApplicationLauncher": _APPLICATION_LAUNCHER_CLUSTER_INFO,
        "ApplicationBasic": _APPLICATION_BASIC_CLUSTER_INFO,
        "AccountLogin": _ACCOUNT_LOGIN_CLUSTER_INFO,
        "ElectricalMeasurement": _ELECTRICAL_MEASUREMENT_CLUSTER_INFO,
        "UnitTesting": _UNIT_TESTING_CLUSTER_INFO,
        "FaultInjection": _FAULT_INJECTION_CLUSTER_INFO,
    }

    def __init__(self, chipstack):
        self._ChipStack = chipstack

    def GetClusterInfoById(self, cluster_id: int):
        data = ChipClusters._CLUSTER_ID_DICT.get(cluster_id, None)
        if not data:
            raise exceptions.UnknownCluster(cluster_id)
        return data

    def ListClusterInfo(self):
        return ChipClusters._CLUSTER_NAME_DICT

    def ListClusterCommands(self):
        return {clusterName: {
            command["commandName"]: command["args"] for command in clusterInfo["commands"].values()
        } for clusterName, clusterInfo in ChipClusters._CLUSTER_NAME_DICT.items()}

    def ListClusterAttributes(self):
        return {clusterName: {
            attribute["attributeName"]: attribute for attribute in clusterInfo["attributes"].values()
        } for clusterName, clusterInfo in ChipClusters._CLUSTER_NAME_DICT.items()}

    # Init native functions

    def InitLib(self, chipLib):
        self._chipLib = chipLib
