/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * NOTE: This file is generated by src/tools/chip-cert/dacs.py.
 */
#include "ExampleDACs.h"

#include <cstdint>

#include <lib/support/Span.h>
#include <platform/CHIPDeviceConfig.h>

namespace chip {
namespace DevelopmentCerts {

#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8000
const uint8_t kDevelopmentDAC_Cert_FFF1_8000[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x23, 0x8a, 0x64, 0x7b, 0xbc, 0x4c,
    0x30, 0xdd, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x30, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x30, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x62, 0xdb, 0x16, 0xba, 0xde, 0xa3, 0x26, 0xa6,
    0xdb, 0x84, 0x81, 0x4a, 0x06, 0x3f, 0xc6, 0xc7, 0xe9, 0xe2, 0xb1, 0x01, 0xb7, 0x21, 0x64, 0x8e, 0xba, 0x4e, 0x5a, 0xc8, 0x40,
    0xf5, 0xda, 0x30, 0x1e, 0xe6, 0x18, 0x12, 0x4e, 0xb4, 0x18, 0x0e, 0x2f, 0xc3, 0xa2, 0x04, 0x7a, 0x56, 0x4b, 0xa9, 0xbc, 0xfa,
    0x0b, 0xf7, 0x1f, 0x60, 0xce, 0x89, 0x30, 0xf1, 0xe7, 0xf6, 0x6e, 0xc8, 0xd7, 0x28, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xbc, 0xf7, 0xb0, 0x07,
    0x49, 0x70, 0x63, 0x60, 0x6a, 0x26, 0xbe, 0x4e, 0x08, 0x7c, 0x59, 0x56, 0x87, 0x74, 0x5a, 0x5a, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0x97, 0x97, 0x11, 0xec, 0x9e, 0x76, 0x18, 0xce, 0x41, 0x80, 0x11, 0x32, 0xc2, 0x50, 0xdb,
    0x70, 0x76, 0x74, 0x63, 0x0c, 0xd5, 0x8c, 0x12, 0xc6, 0xe2, 0x31, 0x5f, 0x08, 0xd0, 0x1e, 0xe1, 0x78, 0x02, 0x21, 0x00, 0xec,
    0xfc, 0x13, 0x06, 0xbd, 0x2a, 0x13, 0x3d, 0x12, 0x2a, 0x27, 0x86, 0x10, 0xea, 0x3d, 0xca, 0x47, 0xf0, 0x5c, 0x7a, 0x8b, 0x80,
    0x5f, 0xa7, 0x1c, 0x6f, 0xf4, 0x15, 0x38, 0xa8, 0x64, 0xc8,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8000[65] = {
    0x04, 0x62, 0xdb, 0x16, 0xba, 0xde, 0xa3, 0x26, 0xa6, 0xdb, 0x84, 0x81, 0x4a, 0x06, 0x3f, 0xc6, 0xc7,
    0xe9, 0xe2, 0xb1, 0x01, 0xb7, 0x21, 0x64, 0x8e, 0xba, 0x4e, 0x5a, 0xc8, 0x40, 0xf5, 0xda, 0x30, 0x1e,
    0xe6, 0x18, 0x12, 0x4e, 0xb4, 0x18, 0x0e, 0x2f, 0xc3, 0xa2, 0x04, 0x7a, 0x56, 0x4b, 0xa9, 0xbc, 0xfa,
    0x0b, 0xf7, 0x1f, 0x60, 0xce, 0x89, 0x30, 0xf1, 0xe7, 0xf6, 0x6e, 0xc8, 0xd7, 0x28,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8000[32] = {
    0xcc, 0xcf, 0x9d, 0xc7, 0x05, 0x0e, 0xf5, 0xd9, 0x0b, 0xe4, 0x57, 0x07, 0xb9, 0x0e, 0x1f, 0x87,
    0x5d, 0x59, 0xbe, 0x1f, 0xa9, 0x42, 0xe8, 0xed, 0x2e, 0x42, 0x72, 0x03, 0xf6, 0xc2, 0xee, 0x3d,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8000);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8000);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8000);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8001
const uint8_t kDevelopmentDAC_Cert_FFF1_8001[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x69, 0xcd, 0xf1, 0x0d, 0xe9, 0xe5,
    0x4e, 0xd1, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x31, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x46, 0x3a, 0xc6, 0x93, 0x42, 0x91, 0x0a, 0x0e,
    0x55, 0x88, 0xfc, 0x6f, 0xf5, 0x6b, 0xb6, 0x3e, 0x62, 0xec, 0xce, 0xcb, 0x14, 0x8f, 0x7d, 0x4e, 0xb0, 0x3e, 0xe5, 0x52, 0x60,
    0x14, 0x15, 0x76, 0x7d, 0x16, 0xa5, 0xc6, 0x63, 0xf7, 0x93, 0xe4, 0x91, 0x23, 0x26, 0x0b, 0x82, 0x97, 0xa7, 0xcd, 0x7e, 0x7c,
    0xfc, 0x7b, 0x31, 0x6b, 0x39, 0xd9, 0x8e, 0x90, 0xd2, 0x93, 0x77, 0x73, 0x8e, 0x82, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x88, 0xdd, 0xe7, 0xb3,
    0x00, 0x38, 0x29, 0x32, 0xcf, 0xf7, 0x34, 0xc0, 0x46, 0x24, 0x81, 0x0f, 0x44, 0x16, 0x8a, 0x6f, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x01, 0x27, 0xa2, 0x7b, 0x4b, 0x44, 0x61, 0x0e, 0xe2, 0xfc, 0xdc, 0x4d, 0x2b, 0x78, 0x85, 0x56,
    0x36, 0x60, 0xbc, 0x0f, 0x76, 0xf1, 0x72, 0x19, 0xed, 0x6a, 0x08, 0xdf, 0xb2, 0xb3, 0xc1, 0xcd, 0x02, 0x20, 0x6b, 0x59, 0xe0,
    0xaf, 0x45, 0xf3, 0xeb, 0x2a, 0x85, 0xb9, 0x19, 0xd3, 0x57, 0x31, 0x52, 0x8c, 0x60, 0x28, 0xc4, 0x15, 0x23, 0x95, 0x45, 0xe1,
    0x08, 0xe4, 0xe5, 0x4e, 0x70, 0x97, 0x13, 0x53,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8001[65] = {
    0x04, 0x46, 0x3a, 0xc6, 0x93, 0x42, 0x91, 0x0a, 0x0e, 0x55, 0x88, 0xfc, 0x6f, 0xf5, 0x6b, 0xb6, 0x3e,
    0x62, 0xec, 0xce, 0xcb, 0x14, 0x8f, 0x7d, 0x4e, 0xb0, 0x3e, 0xe5, 0x52, 0x60, 0x14, 0x15, 0x76, 0x7d,
    0x16, 0xa5, 0xc6, 0x63, 0xf7, 0x93, 0xe4, 0x91, 0x23, 0x26, 0x0b, 0x82, 0x97, 0xa7, 0xcd, 0x7e, 0x7c,
    0xfc, 0x7b, 0x31, 0x6b, 0x39, 0xd9, 0x8e, 0x90, 0xd2, 0x93, 0x77, 0x73, 0x8e, 0x82,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8001[32] = {
    0xaa, 0xb6, 0x00, 0xae, 0x8a, 0xe8, 0xaa, 0xb7, 0xd7, 0x36, 0x27, 0xc2, 0x17, 0xb7, 0xc2, 0x04,
    0x70, 0x9c, 0xa6, 0x94, 0x6a, 0xf5, 0xf2, 0xf7, 0x53, 0x08, 0x33, 0xa5, 0x2b, 0x44, 0xfb, 0xff,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8001);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8001);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8001);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8002
const uint8_t kDevelopmentDAC_Cert_FFF1_8002[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x52, 0x72, 0x4d, 0x21, 0xe2, 0xc1,
    0x74, 0xaf, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x32, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xda, 0x93, 0xf1, 0x67, 0x36, 0x25, 0x67, 0x50,
    0xd9, 0x03, 0xb0, 0x34, 0xba, 0x45, 0x88, 0xab, 0xaf, 0x58, 0x95, 0x4f, 0x77, 0xaa, 0x9f, 0xd9, 0x98, 0x9d, 0xfd, 0x40, 0x0d,
    0x7a, 0xb3, 0xfd, 0xc9, 0x75, 0x3b, 0x3b, 0x92, 0x1b, 0x29, 0x4c, 0x95, 0x0f, 0xd9, 0xd2, 0x80, 0xd1, 0x4c, 0x43, 0x86, 0x2f,
    0x16, 0xdc, 0x85, 0x4b, 0x00, 0xed, 0x39, 0xe7, 0x50, 0xba, 0xbf, 0x1d, 0xc4, 0xca, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xef, 0x06, 0x56, 0x11,
    0x9c, 0x1c, 0x91, 0xa7, 0x9a, 0x94, 0xe6, 0xdc, 0xf3, 0x79, 0x79, 0xdb, 0xd0, 0x7f, 0xf8, 0xa3, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x46, 0x86, 0x81, 0x07, 0x33, 0xbf, 0x0d, 0xc8, 0xff, 0x4c, 0xb5, 0x14, 0x5a, 0x6b, 0xfa, 0x1a,
    0xec, 0xff, 0xa8, 0xb6, 0xda, 0xb6, 0xc3, 0x51, 0xaa, 0xee, 0xcd, 0xaf, 0xb8, 0xbe, 0x95, 0x7d, 0x02, 0x21, 0x00, 0xe8, 0xc2,
    0x8d, 0x6b, 0xfc, 0xc8, 0x7a, 0x7d, 0x54, 0x2e, 0xad, 0x6e, 0xda, 0xca, 0x14, 0x8d, 0x5f, 0xa5, 0x06, 0x1e, 0x51, 0x7c, 0xbe,
    0x4f, 0x24, 0xa7, 0x20, 0xe1, 0xc0, 0x59, 0xde, 0x1a,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8002[65] = {
    0x04, 0xda, 0x93, 0xf1, 0x67, 0x36, 0x25, 0x67, 0x50, 0xd9, 0x03, 0xb0, 0x34, 0xba, 0x45, 0x88, 0xab,
    0xaf, 0x58, 0x95, 0x4f, 0x77, 0xaa, 0x9f, 0xd9, 0x98, 0x9d, 0xfd, 0x40, 0x0d, 0x7a, 0xb3, 0xfd, 0xc9,
    0x75, 0x3b, 0x3b, 0x92, 0x1b, 0x29, 0x4c, 0x95, 0x0f, 0xd9, 0xd2, 0x80, 0xd1, 0x4c, 0x43, 0x86, 0x2f,
    0x16, 0xdc, 0x85, 0x4b, 0x00, 0xed, 0x39, 0xe7, 0x50, 0xba, 0xbf, 0x1d, 0xc4, 0xca,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8002[32] = {
    0xda, 0xf2, 0x1a, 0x7e, 0xa4, 0x7a, 0x70, 0x48, 0x02, 0xa7, 0xe6, 0x6c, 0x50, 0xeb, 0x10, 0xba,
    0xc3, 0xbd, 0xd1, 0x68, 0x80, 0x39, 0x80, 0x66, 0xff, 0xda, 0xd7, 0xf5, 0x20, 0x98, 0xb6, 0x85,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8002);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8002);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8002);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8003
const uint8_t kDevelopmentDAC_Cert_FFF1_8003[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x4a, 0x22, 0x27, 0xbc, 0xdb, 0xd4,
    0x33, 0xd2, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x33, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x1d, 0xff, 0xac, 0x48, 0xc1, 0x49, 0x3a, 0xc3,
    0xcb, 0x14, 0x19, 0xbc, 0xc0, 0xab, 0x86, 0x4a, 0xc9, 0x51, 0x47, 0xdb, 0x7a, 0xf0, 0x1b, 0xff, 0xb8, 0x1a, 0xc2, 0x9f, 0x46,
    0x90, 0x78, 0x3b, 0xff, 0x44, 0xbe, 0xcf, 0xf5, 0xe6, 0xf3, 0xc3, 0x04, 0x1e, 0xb8, 0xfc, 0x1f, 0xfc, 0xdc, 0x13, 0xa5, 0x5e,
    0x6f, 0xe8, 0x51, 0x74, 0xad, 0xf6, 0x28, 0x01, 0xc9, 0x3f, 0x12, 0xef, 0x05, 0x50, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x7e, 0x51, 0x00, 0x31,
    0x40, 0x20, 0x89, 0xdb, 0x52, 0x56, 0x22, 0x52, 0x40, 0xe4, 0xcc, 0xa8, 0x7e, 0xe6, 0x01, 0x84, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xec, 0x0a, 0xe9, 0xd2, 0x12, 0xf6, 0x16, 0x84, 0x82, 0x79, 0xc9, 0x58, 0x22, 0xa5, 0x64,
    0xcc, 0xde, 0x5e, 0x31, 0x2c, 0xab, 0xdb, 0x90, 0x57, 0xc3, 0x37, 0x12, 0x33, 0x20, 0xab, 0x10, 0x1d, 0x02, 0x21, 0x00, 0x90,
    0x14, 0x09, 0xa1, 0xd1, 0x5e, 0xd0, 0x55, 0x0d, 0x50, 0x1e, 0x35, 0x5b, 0xec, 0x4f, 0x21, 0xc4, 0x84, 0x16, 0x30, 0x13, 0x6a,
    0xc8, 0x76, 0xf8, 0x67, 0x58, 0xd4, 0x5e, 0x7b, 0x3b, 0xec,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8003[65] = {
    0x04, 0x1d, 0xff, 0xac, 0x48, 0xc1, 0x49, 0x3a, 0xc3, 0xcb, 0x14, 0x19, 0xbc, 0xc0, 0xab, 0x86, 0x4a,
    0xc9, 0x51, 0x47, 0xdb, 0x7a, 0xf0, 0x1b, 0xff, 0xb8, 0x1a, 0xc2, 0x9f, 0x46, 0x90, 0x78, 0x3b, 0xff,
    0x44, 0xbe, 0xcf, 0xf5, 0xe6, 0xf3, 0xc3, 0x04, 0x1e, 0xb8, 0xfc, 0x1f, 0xfc, 0xdc, 0x13, 0xa5, 0x5e,
    0x6f, 0xe8, 0x51, 0x74, 0xad, 0xf6, 0x28, 0x01, 0xc9, 0x3f, 0x12, 0xef, 0x05, 0x50,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8003[32] = {
    0x7d, 0x22, 0x4f, 0x97, 0xe1, 0xfc, 0x1b, 0x6d, 0xa8, 0xae, 0x31, 0x0c, 0xa7, 0x2f, 0x8d, 0x3b,
    0x61, 0x1b, 0xbf, 0x32, 0xc6, 0xbc, 0x1f, 0xda, 0xf6, 0xf7, 0x73, 0x44, 0xe9, 0x48, 0xad, 0x13,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8003);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8003);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8003);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8004
const uint8_t kDevelopmentDAC_Cert_FFF1_8004[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x1e, 0x06, 0x7f, 0x3b, 0xfe, 0xcd,
    0xd8, 0x13, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x34, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x34, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x50, 0x41, 0x38, 0xef, 0x31, 0xc9, 0xdd, 0x16,
    0x0e, 0xb4, 0x6c, 0x6c, 0x17, 0x11, 0x4f, 0x9d, 0x72, 0x88, 0x40, 0x80, 0x1f, 0x73, 0xbb, 0x9b, 0x5a, 0x2c, 0x51, 0x91, 0xc9,
    0xb2, 0x06, 0x63, 0x01, 0x9d, 0x94, 0x76, 0xd1, 0x93, 0x1b, 0x93, 0xff, 0x47, 0xf4, 0x32, 0x56, 0x37, 0x90, 0x35, 0xd2, 0x29,
    0x62, 0x0b, 0x7e, 0x21, 0x0e, 0x59, 0x2f, 0x26, 0x43, 0x7d, 0x2d, 0x57, 0x62, 0x05, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xa0, 0xa7, 0x1c, 0x2a,
    0x5f, 0x74, 0x45, 0x20, 0x5b, 0x12, 0xa6, 0x28, 0xca, 0xb7, 0x16, 0x45, 0xba, 0x2d, 0x5e, 0x72, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xe7, 0x79, 0xeb, 0x8b, 0xbb, 0xd8, 0xba, 0x28, 0x68, 0xd3, 0x7b, 0xfc, 0x3a, 0x0e, 0x33,
    0x87, 0x03, 0xdb, 0xe4, 0x5c, 0x54, 0x09, 0x8c, 0x8a, 0xe4, 0xa3, 0x84, 0x4e, 0xf5, 0xc8, 0x2b, 0x5b, 0x02, 0x21, 0x00, 0x90,
    0xe7, 0x6b, 0x2b, 0x83, 0x73, 0x92, 0xab, 0x29, 0x40, 0x39, 0x10, 0x40, 0xf6, 0x4d, 0xc7, 0x8c, 0x53, 0x01, 0xac, 0x9d, 0x08,
    0x66, 0x4f, 0xf6, 0xd0, 0x10, 0x4a, 0xfe, 0x98, 0xfc, 0x80,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8004[65] = {
    0x04, 0x50, 0x41, 0x38, 0xef, 0x31, 0xc9, 0xdd, 0x16, 0x0e, 0xb4, 0x6c, 0x6c, 0x17, 0x11, 0x4f, 0x9d,
    0x72, 0x88, 0x40, 0x80, 0x1f, 0x73, 0xbb, 0x9b, 0x5a, 0x2c, 0x51, 0x91, 0xc9, 0xb2, 0x06, 0x63, 0x01,
    0x9d, 0x94, 0x76, 0xd1, 0x93, 0x1b, 0x93, 0xff, 0x47, 0xf4, 0x32, 0x56, 0x37, 0x90, 0x35, 0xd2, 0x29,
    0x62, 0x0b, 0x7e, 0x21, 0x0e, 0x59, 0x2f, 0x26, 0x43, 0x7d, 0x2d, 0x57, 0x62, 0x05,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8004[32] = {
    0x82, 0x0a, 0x24, 0x2a, 0x03, 0x0e, 0xbc, 0xe1, 0x1f, 0x38, 0x73, 0x5a, 0xcf, 0x1a, 0x6f, 0x37,
    0xc3, 0xad, 0xa6, 0xe4, 0x32, 0xd2, 0x47, 0x0a, 0x8a, 0x41, 0x37, 0x43, 0xf8, 0x95, 0x63, 0xf3,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8004);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8004);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8004);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8005
const uint8_t kDevelopmentDAC_Cert_FFF1_8005[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x6f, 0xdc, 0xb6, 0xed, 0x06, 0xf3,
    0x58, 0xf9, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x35, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x35, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x7e, 0xf2, 0xf1, 0x08, 0x2b, 0x2a, 0x56, 0x4a,
    0x05, 0x44, 0xc0, 0xa6, 0x13, 0xd2, 0x1b, 0x15, 0x75, 0x00, 0x55, 0x2d, 0x03, 0x5f, 0x23, 0x02, 0x25, 0x2f, 0xce, 0xe8, 0x1d,
    0x6e, 0xc6, 0x74, 0x17, 0x34, 0x18, 0xa9, 0x4a, 0x88, 0xdb, 0x73, 0x74, 0x15, 0x58, 0xc9, 0xfc, 0x8a, 0xc9, 0x34, 0x9e, 0xf6,
    0x7e, 0x3e, 0x35, 0xd5, 0xfc, 0x86, 0xe8, 0x62, 0x20, 0x42, 0xb0, 0x28, 0x33, 0x38, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x05, 0x31, 0x00, 0xf0,
    0x99, 0x71, 0x26, 0x87, 0xcf, 0xad, 0x7b, 0x55, 0x41, 0x4a, 0x9f, 0x3e, 0xad, 0x4c, 0xb8, 0x07, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0x81, 0x96, 0x0a, 0x01, 0x9a, 0xc2, 0x21, 0x16, 0xbe, 0x7e, 0xdd, 0x1a, 0x9b, 0x1f, 0xac,
    0x32, 0x76, 0x86, 0x1c, 0x99, 0xbd, 0x43, 0xfb, 0xd5, 0x0c, 0xd5, 0x07, 0x29, 0xc2, 0xee, 0x1a, 0x17, 0x02, 0x20, 0x19, 0xbc,
    0x37, 0x0c, 0x0a, 0x2e, 0x5a, 0xe4, 0xf3, 0xdf, 0xcf, 0x58, 0x71, 0x30, 0xa5, 0x76, 0x16, 0xba, 0x32, 0x09, 0xff, 0x38, 0x83,
    0x53, 0xec, 0x44, 0xa7, 0x06, 0x87, 0xac, 0xe2, 0x41,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8005[65] = {
    0x04, 0x7e, 0xf2, 0xf1, 0x08, 0x2b, 0x2a, 0x56, 0x4a, 0x05, 0x44, 0xc0, 0xa6, 0x13, 0xd2, 0x1b, 0x15,
    0x75, 0x00, 0x55, 0x2d, 0x03, 0x5f, 0x23, 0x02, 0x25, 0x2f, 0xce, 0xe8, 0x1d, 0x6e, 0xc6, 0x74, 0x17,
    0x34, 0x18, 0xa9, 0x4a, 0x88, 0xdb, 0x73, 0x74, 0x15, 0x58, 0xc9, 0xfc, 0x8a, 0xc9, 0x34, 0x9e, 0xf6,
    0x7e, 0x3e, 0x35, 0xd5, 0xfc, 0x86, 0xe8, 0x62, 0x20, 0x42, 0xb0, 0x28, 0x33, 0x38,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8005[32] = {
    0x75, 0x82, 0xa1, 0x4e, 0xcc, 0x92, 0x47, 0x0b, 0x40, 0x5b, 0x9e, 0x16, 0xde, 0xd8, 0xbe, 0x41,
    0x7a, 0x61, 0x0a, 0x13, 0xc3, 0xe0, 0x2b, 0x28, 0x99, 0xb4, 0x70, 0xae, 0x89, 0xcb, 0xf9, 0xe1,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8005);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8005);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8005);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8006
const uint8_t kDevelopmentDAC_Cert_FFF1_8006[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8d, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x07, 0x21, 0xf6, 0x6d, 0xf5, 0x1d, 0x72,
    0x58, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03,
    0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20, 0x30,
    0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01,
    0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30, 0x32,
    0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33,
    0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74,
    0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30, 0x78,
    0x38, 0x30, 0x30, 0x36, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c,
    0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x02,
    0x0c, 0x04, 0x38, 0x30, 0x30, 0x36, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08,
    0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x5e, 0x91, 0xed, 0x92, 0x50, 0x16, 0xcc, 0x82, 0x67,
    0x19, 0x7a, 0x09, 0x0b, 0x75, 0x33, 0xe5, 0x54, 0xe2, 0x5c, 0x8b, 0x09, 0x3c, 0xdd, 0xca, 0x9e, 0xaf, 0xcb, 0xa7, 0x47, 0xfe,
    0xb8, 0xb5, 0xb8, 0xdc, 0x78, 0x9f, 0x0f, 0x9d, 0xb0, 0xd8, 0xfc, 0xae, 0xac, 0x6c, 0xfd, 0x83, 0x9c, 0x51, 0xb3, 0xbd, 0x0e,
    0x4b, 0xc7, 0x69, 0x4e, 0x60, 0x86, 0x9c, 0xf8, 0xea, 0x1e, 0x77, 0xb7, 0x18, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06, 0x03,
    0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04,
    0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xd2, 0x44, 0xf4, 0xa6, 0x59,
    0xd8, 0x0d, 0x57, 0x76, 0x1e, 0xe5, 0x09, 0x4f, 0x74, 0x87, 0x58, 0x96, 0x49, 0x58, 0x43, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d,
    0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62, 0xd1,
    0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48, 0x00,
    0x30, 0x45, 0x02, 0x21, 0x00, 0xfc, 0xd4, 0xbe, 0x8c, 0x51, 0xff, 0xd0, 0xc5, 0x7f, 0xa1, 0xd1, 0x4b, 0xd1, 0x2a, 0x52, 0x2f,
    0x65, 0x8d, 0x52, 0x16, 0x87, 0xb3, 0x1e, 0x84, 0xe6, 0x17, 0xff, 0x3f, 0x36, 0x42, 0xee, 0xeb, 0x02, 0x20, 0x74, 0x2d, 0x63,
    0x54, 0x7a, 0xb3, 0xe4, 0x9a, 0x98, 0x9c, 0xdb, 0xba, 0x78, 0x0b, 0xb5, 0xd9, 0x3a, 0x37, 0xf6, 0xd2, 0xc0, 0xf4, 0xf3, 0x8a,
    0xaa, 0xad, 0xfd, 0xe2, 0x32, 0xc4, 0x25, 0x28,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8006[65] = {
    0x04, 0x5e, 0x91, 0xed, 0x92, 0x50, 0x16, 0xcc, 0x82, 0x67, 0x19, 0x7a, 0x09, 0x0b, 0x75, 0x33, 0xe5,
    0x54, 0xe2, 0x5c, 0x8b, 0x09, 0x3c, 0xdd, 0xca, 0x9e, 0xaf, 0xcb, 0xa7, 0x47, 0xfe, 0xb8, 0xb5, 0xb8,
    0xdc, 0x78, 0x9f, 0x0f, 0x9d, 0xb0, 0xd8, 0xfc, 0xae, 0xac, 0x6c, 0xfd, 0x83, 0x9c, 0x51, 0xb3, 0xbd,
    0x0e, 0x4b, 0xc7, 0x69, 0x4e, 0x60, 0x86, 0x9c, 0xf8, 0xea, 0x1e, 0x77, 0xb7, 0x18,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8006[32] = {
    0x7f, 0xcd, 0x6e, 0xb8, 0x26, 0xee, 0xa6, 0xd6, 0x17, 0x8d, 0x80, 0xe2, 0x65, 0xb6, 0x6f, 0xfd,
    0x83, 0xde, 0x35, 0xdd, 0x8d, 0xa8, 0x8a, 0xfa, 0x1b, 0x8d, 0xdc, 0x0c, 0xf4, 0x9b, 0xde, 0xa2,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8006);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8006);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8006);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8007
const uint8_t kDevelopmentDAC_Cert_FFF1_8007[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x58, 0x48, 0xb6, 0x4f, 0xbd, 0x0c,
    0x9a, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x37, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x37, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x1b, 0x68, 0x65, 0x0f, 0x97, 0xaa, 0xda, 0x54,
    0x62, 0xa0, 0xd4, 0xdb, 0x5f, 0xd7, 0x84, 0x41, 0xb1, 0x48, 0x95, 0xd8, 0xd3, 0xc6, 0x20, 0x18, 0x33, 0x7f, 0x15, 0x23, 0xbb,
    0xea, 0xb6, 0xd5, 0xf0, 0xdd, 0x6e, 0xed, 0x28, 0x83, 0x2e, 0xf9, 0x48, 0x89, 0x1b, 0x97, 0x6a, 0x83, 0x1b, 0xea, 0x82, 0xdb,
    0x9a, 0x77, 0xe3, 0xea, 0x49, 0x47, 0xb4, 0x1d, 0x87, 0x6a, 0x08, 0xe2, 0xdd, 0x62, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xa1, 0x81, 0x0b, 0x1e,
    0xc2, 0x51, 0xe1, 0xb8, 0xb4, 0x45, 0x35, 0x34, 0x91, 0xa9, 0x18, 0x5d, 0x57, 0x52, 0x11, 0x47, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x48, 0x95, 0xd2, 0xfe, 0xf5, 0x23, 0x97, 0x3c, 0x78, 0xdb, 0xc6, 0x05, 0x7d, 0x44, 0xfc, 0xc7,
    0x6e, 0x21, 0xe3, 0x52, 0x53, 0x6e, 0x89, 0x10, 0xf3, 0x2e, 0xec, 0x19, 0xfe, 0x29, 0xbc, 0x24, 0x02, 0x20, 0x08, 0xcc, 0x1b,
    0x3d, 0x21, 0x25, 0x60, 0x74, 0x71, 0x5f, 0xbc, 0x59, 0xe9, 0x07, 0x67, 0xfe, 0x22, 0xee, 0x5f, 0x15, 0xbb, 0xfa, 0x09, 0x40,
    0xb1, 0xdf, 0xd6, 0x52, 0x44, 0xf5, 0x51, 0x63,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8007[65] = {
    0x04, 0x1b, 0x68, 0x65, 0x0f, 0x97, 0xaa, 0xda, 0x54, 0x62, 0xa0, 0xd4, 0xdb, 0x5f, 0xd7, 0x84, 0x41,
    0xb1, 0x48, 0x95, 0xd8, 0xd3, 0xc6, 0x20, 0x18, 0x33, 0x7f, 0x15, 0x23, 0xbb, 0xea, 0xb6, 0xd5, 0xf0,
    0xdd, 0x6e, 0xed, 0x28, 0x83, 0x2e, 0xf9, 0x48, 0x89, 0x1b, 0x97, 0x6a, 0x83, 0x1b, 0xea, 0x82, 0xdb,
    0x9a, 0x77, 0xe3, 0xea, 0x49, 0x47, 0xb4, 0x1d, 0x87, 0x6a, 0x08, 0xe2, 0xdd, 0x62,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8007[32] = {
    0x0a, 0xfd, 0x57, 0xbb, 0xc0, 0x5d, 0x8b, 0xb3, 0x91, 0xfb, 0x5a, 0x3d, 0xec, 0x96, 0x6a, 0xdd,
    0xd5, 0xb8, 0xb2, 0xfe, 0x14, 0x23, 0x5a, 0xd8, 0x16, 0xff, 0xc3, 0x69, 0x8d, 0xe3, 0x7e, 0xaa,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8007);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8007);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8007);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8008
const uint8_t kDevelopmentDAC_Cert_FFF1_8008[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x75, 0xd8, 0x07, 0xdc, 0x88, 0x91,
    0x88, 0x2e, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x38, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x38, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xac, 0x20, 0xf4, 0x17, 0xb6, 0x84, 0x52, 0x52,
    0x2b, 0x41, 0xa1, 0x18, 0x58, 0x5a, 0xe6, 0xb4, 0x5d, 0x73, 0xcb, 0xb1, 0x66, 0x79, 0xec, 0xc1, 0xe9, 0x5d, 0x8f, 0xa9, 0xbc,
    0xe3, 0x3e, 0xbb, 0xe5, 0x75, 0xb0, 0x2e, 0xd7, 0x8d, 0xe9, 0x00, 0xe7, 0x79, 0xa4, 0x62, 0x8c, 0x9b, 0xed, 0x31, 0xa5, 0xd5,
    0xad, 0x4a, 0x1f, 0x84, 0xbb, 0x14, 0xaa, 0xc3, 0xb3, 0xf9, 0x08, 0x5c, 0xca, 0x78, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x0f, 0x2c, 0x91, 0x90,
    0xb4, 0x13, 0xae, 0x80, 0x78, 0x11, 0xd8, 0x91, 0xa5, 0x52, 0x88, 0xc4, 0xc0, 0x7d, 0x4c, 0x4f, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0x84, 0xe9, 0x0e, 0x78, 0x05, 0x97, 0x5c, 0xb2, 0x08, 0xbd, 0xe9, 0x8b, 0xfb, 0x3e, 0x78,
    0x9c, 0x7c, 0xe0, 0x54, 0x45, 0x7f, 0xf0, 0x37, 0xe1, 0x6a, 0x99, 0xe0, 0xeb, 0x62, 0x41, 0x3d, 0x1e, 0x02, 0x20, 0x03, 0x73,
    0x7c, 0x79, 0x44, 0x2a, 0xca, 0xfd, 0x1d, 0x18, 0x6d, 0x2f, 0x21, 0xc3, 0x89, 0xd0, 0x64, 0xbf, 0x63, 0x4a, 0x2a, 0x23, 0x5d,
    0x4a, 0x80, 0x12, 0xc2, 0xa7, 0x9a, 0xb1, 0x50, 0xbd,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8008[65] = {
    0x04, 0xac, 0x20, 0xf4, 0x17, 0xb6, 0x84, 0x52, 0x52, 0x2b, 0x41, 0xa1, 0x18, 0x58, 0x5a, 0xe6, 0xb4,
    0x5d, 0x73, 0xcb, 0xb1, 0x66, 0x79, 0xec, 0xc1, 0xe9, 0x5d, 0x8f, 0xa9, 0xbc, 0xe3, 0x3e, 0xbb, 0xe5,
    0x75, 0xb0, 0x2e, 0xd7, 0x8d, 0xe9, 0x00, 0xe7, 0x79, 0xa4, 0x62, 0x8c, 0x9b, 0xed, 0x31, 0xa5, 0xd5,
    0xad, 0x4a, 0x1f, 0x84, 0xbb, 0x14, 0xaa, 0xc3, 0xb3, 0xf9, 0x08, 0x5c, 0xca, 0x78,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8008[32] = {
    0xb4, 0x54, 0x12, 0xa2, 0x2a, 0x3d, 0x0c, 0x38, 0x44, 0x12, 0xb5, 0x87, 0x5e, 0xeb, 0x1c, 0x6e,
    0xa9, 0x1f, 0x7e, 0xef, 0xa5, 0x2c, 0xc7, 0x3f, 0x90, 0xe8, 0x69, 0x99, 0x0b, 0x4a, 0x4c, 0x99,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8008);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8008);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8008);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8009
const uint8_t kDevelopmentDAC_Cert_FFF1_8009[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x2f, 0x19, 0xf4, 0x97, 0x8d, 0x94,
    0xdf, 0xcf, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x39, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x39, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xd7, 0xd9, 0xd9, 0xb1, 0x02, 0x24, 0x4f, 0x96,
    0xba, 0x73, 0x59, 0x98, 0x11, 0x02, 0xbf, 0xd0, 0xa2, 0x17, 0x47, 0xb3, 0xa2, 0x91, 0x29, 0x6a, 0x8e, 0x7c, 0x3f, 0x61, 0xdc,
    0x45, 0x88, 0xc8, 0xc1, 0xa8, 0xc7, 0x8c, 0x4c, 0x28, 0x36, 0x8c, 0x7e, 0x9c, 0x84, 0x86, 0x82, 0x01, 0xe0, 0xc3, 0x8a, 0x41,
    0x41, 0x5c, 0xc0, 0xf0, 0x06, 0x3e, 0x98, 0xa6, 0x0d, 0x86, 0x9b, 0x6f, 0x9c, 0xf6, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xec, 0x27, 0x10, 0xa5,
    0xf3, 0x25, 0x7e, 0x6e, 0xdb, 0x49, 0xad, 0xfc, 0x9f, 0x51, 0x60, 0x89, 0xe9, 0xdf, 0xbf, 0x25, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x40, 0xef, 0xb7, 0xc5, 0x67, 0x0a, 0x66, 0x3c, 0x7a, 0x35, 0xc1, 0xf1, 0x9d, 0xfd, 0xa7, 0x3b,
    0x36, 0x86, 0x09, 0x6d, 0xf7, 0xa6, 0xcc, 0x61, 0x9d, 0x2f, 0xf9, 0x55, 0x3f, 0x40, 0x34, 0x50, 0x02, 0x20, 0x78, 0x23, 0xe2,
    0xde, 0x5d, 0xcb, 0x08, 0xec, 0xf0, 0x17, 0xc8, 0xcc, 0x52, 0x4d, 0x84, 0xe1, 0x56, 0xbc, 0xeb, 0x74, 0xd1, 0xea, 0x3b, 0xe3,
    0x8d, 0x7c, 0xd3, 0x41, 0xba, 0x61, 0x3a, 0xe6,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8009[65] = {
    0x04, 0xd7, 0xd9, 0xd9, 0xb1, 0x02, 0x24, 0x4f, 0x96, 0xba, 0x73, 0x59, 0x98, 0x11, 0x02, 0xbf, 0xd0,
    0xa2, 0x17, 0x47, 0xb3, 0xa2, 0x91, 0x29, 0x6a, 0x8e, 0x7c, 0x3f, 0x61, 0xdc, 0x45, 0x88, 0xc8, 0xc1,
    0xa8, 0xc7, 0x8c, 0x4c, 0x28, 0x36, 0x8c, 0x7e, 0x9c, 0x84, 0x86, 0x82, 0x01, 0xe0, 0xc3, 0x8a, 0x41,
    0x41, 0x5c, 0xc0, 0xf0, 0x06, 0x3e, 0x98, 0xa6, 0x0d, 0x86, 0x9b, 0x6f, 0x9c, 0xf6,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8009[32] = {
    0xcf, 0xed, 0x4b, 0x3e, 0xbf, 0x88, 0x35, 0x4b, 0x05, 0x9b, 0x8f, 0x8a, 0xfc, 0xd1, 0x42, 0x78,
    0x3b, 0xf5, 0xa4, 0xb5, 0x6e, 0xce, 0xb0, 0xaf, 0x60, 0x5a, 0x32, 0x37, 0x40, 0x3d, 0xb6, 0x9a,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8009);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8009);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8009);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800A
const uint8_t kDevelopmentDAC_Cert_FFF1_800A[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x3d, 0xc4, 0xfb, 0x5c, 0x8e, 0x4d,
    0x26, 0x46, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x41, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x41, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x5f, 0x37, 0x84, 0xbd, 0x6c, 0xbf, 0xb9, 0x2c,
    0xee, 0xf9, 0xf8, 0x44, 0x35, 0x4e, 0x4a, 0xfe, 0x04, 0xbe, 0x20, 0x07, 0x16, 0x1d, 0x01, 0x46, 0x72, 0xc8, 0x69, 0xa7, 0x21,
    0xb8, 0x35, 0xec, 0xf5, 0xd1, 0x15, 0x4d, 0xc7, 0x7b, 0xb9, 0x65, 0xdf, 0x3c, 0xc2, 0x7b, 0x57, 0xb4, 0xbb, 0x5c, 0xe7, 0xd7,
    0xde, 0xd1, 0xc3, 0x8e, 0xbc, 0xbf, 0x31, 0x8d, 0x9d, 0x8c, 0x65, 0xe3, 0xb5, 0x98, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x58, 0xbc, 0x4f, 0xee,
    0x7d, 0x50, 0x14, 0x9b, 0x31, 0x73, 0x93, 0x90, 0x56, 0xad, 0xc7, 0x39, 0x70, 0x39, 0x3c, 0x61, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0x87, 0x65, 0xa7, 0x69, 0x2b, 0x2d, 0x4f, 0x64, 0xa6, 0x57, 0x45, 0x5b, 0x4b, 0x1a, 0xcd,
    0xc5, 0x7b, 0x48, 0x13, 0x23, 0x45, 0x69, 0x84, 0x50, 0x0c, 0x7c, 0x4c, 0xc8, 0xdf, 0x0e, 0xd0, 0xe5, 0x02, 0x20, 0x70, 0xe9,
    0x4f, 0x4a, 0xde, 0xa5, 0x13, 0xd5, 0x0b, 0xfc, 0x29, 0x58, 0x89, 0x8c, 0xc0, 0xae, 0x6e, 0xf8, 0xdf, 0xdc, 0x90, 0x89, 0x46,
    0xeb, 0x11, 0xa5, 0x74, 0xe4, 0x45, 0xd9, 0x1e, 0xdb,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_800A[65] = {
    0x04, 0x5f, 0x37, 0x84, 0xbd, 0x6c, 0xbf, 0xb9, 0x2c, 0xee, 0xf9, 0xf8, 0x44, 0x35, 0x4e, 0x4a, 0xfe,
    0x04, 0xbe, 0x20, 0x07, 0x16, 0x1d, 0x01, 0x46, 0x72, 0xc8, 0x69, 0xa7, 0x21, 0xb8, 0x35, 0xec, 0xf5,
    0xd1, 0x15, 0x4d, 0xc7, 0x7b, 0xb9, 0x65, 0xdf, 0x3c, 0xc2, 0x7b, 0x57, 0xb4, 0xbb, 0x5c, 0xe7, 0xd7,
    0xde, 0xd1, 0xc3, 0x8e, 0xbc, 0xbf, 0x31, 0x8d, 0x9d, 0x8c, 0x65, 0xe3, 0xb5, 0x98,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_800A[32] = {
    0x3f, 0xe9, 0x78, 0x3d, 0x0b, 0x1b, 0x6e, 0xf0, 0xb7, 0x7f, 0x84, 0x3b, 0xe6, 0x3b, 0x0f, 0x7b,
    0xca, 0x9c, 0x93, 0x05, 0x66, 0xbf, 0x5d, 0x31, 0x00, 0x74, 0x5f, 0xd5, 0xe5, 0x3e, 0x5f, 0x4e,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_800A);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_800A);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_800A);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800B
const uint8_t kDevelopmentDAC_Cert_FFF1_800B[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x2b, 0xd5, 0x3d, 0xfc, 0x89, 0x6b,
    0x91, 0x9f, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x42, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x42, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xbe, 0xbf, 0x03, 0x4d, 0x98, 0x8a, 0x2d, 0xa4,
    0x3d, 0x4e, 0x2f, 0x93, 0x3c, 0x26, 0x69, 0xf8, 0x3d, 0xb4, 0x71, 0xe8, 0x10, 0x0d, 0x9f, 0xe5, 0x79, 0xbf, 0x49, 0xe2, 0x3d,
    0x28, 0xa9, 0x22, 0x93, 0x9c, 0x3a, 0x36, 0x54, 0xb4, 0x20, 0x64, 0x88, 0x33, 0x08, 0xe4, 0xf3, 0xf6, 0x41, 0xb2, 0x76, 0xf5,
    0x28, 0x45, 0xa7, 0xc7, 0x7a, 0xe1, 0x9a, 0xe8, 0xb3, 0xf7, 0x06, 0x34, 0x45, 0x55, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xd3, 0x88, 0xe7, 0x66,
    0x4f, 0xfb, 0x67, 0x8f, 0xca, 0xc9, 0xf9, 0x22, 0x30, 0x17, 0xf1, 0x2e, 0x9e, 0x69, 0xfc, 0x66, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0x97, 0xf4, 0xf4, 0xda, 0x4d, 0x3b, 0xa4, 0x3b, 0xfa, 0x2c, 0xb6, 0x68, 0xbe, 0x8a, 0x97,
    0x41, 0xf0, 0x01, 0xbd, 0xf0, 0x2b, 0x63, 0xee, 0xe3, 0x17, 0xe5, 0x45, 0xb2, 0xcd, 0xd6, 0xbe, 0xc8, 0x02, 0x20, 0x36, 0x6d,
    0x9f, 0x7e, 0x90, 0xcd, 0x49, 0xba, 0x30, 0xbe, 0xd9, 0xa1, 0x42, 0xaa, 0xf2, 0xd1, 0x98, 0x4c, 0xda, 0x6d, 0x4a, 0xda, 0x69,
    0x0c, 0x82, 0x25, 0x91, 0xa8, 0x58, 0xbe, 0x02, 0x93,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_800B[65] = {
    0x04, 0xbe, 0xbf, 0x03, 0x4d, 0x98, 0x8a, 0x2d, 0xa4, 0x3d, 0x4e, 0x2f, 0x93, 0x3c, 0x26, 0x69, 0xf8,
    0x3d, 0xb4, 0x71, 0xe8, 0x10, 0x0d, 0x9f, 0xe5, 0x79, 0xbf, 0x49, 0xe2, 0x3d, 0x28, 0xa9, 0x22, 0x93,
    0x9c, 0x3a, 0x36, 0x54, 0xb4, 0x20, 0x64, 0x88, 0x33, 0x08, 0xe4, 0xf3, 0xf6, 0x41, 0xb2, 0x76, 0xf5,
    0x28, 0x45, 0xa7, 0xc7, 0x7a, 0xe1, 0x9a, 0xe8, 0xb3, 0xf7, 0x06, 0x34, 0x45, 0x55,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_800B[32] = {
    0x7f, 0xde, 0x6a, 0xce, 0xeb, 0xcf, 0xa4, 0x67, 0x23, 0xfb, 0x64, 0xf4, 0x01, 0xda, 0x14, 0xab,
    0x65, 0x5f, 0xe8, 0x8f, 0x7e, 0x6e, 0xd6, 0xef, 0x63, 0xb3, 0xbe, 0x49, 0x76, 0xe8, 0xa5, 0xd7,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_800B);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_800B);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_800B);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800C
const uint8_t kDevelopmentDAC_Cert_FFF1_800C[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x58, 0x9e, 0x58, 0x6f, 0xb4, 0xd1,
    0xd3, 0x50, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x43, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x43, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xb7, 0xea, 0x5b, 0x19, 0xc0, 0xa3, 0xa5, 0xb7,
    0xd6, 0xc7, 0x41, 0x8a, 0xaf, 0x95, 0x39, 0xdf, 0xc2, 0x83, 0xa8, 0x7b, 0x20, 0xa8, 0x37, 0x42, 0x2d, 0x4c, 0xaa, 0x9e, 0x7c,
    0x66, 0x64, 0xa2, 0x8a, 0x87, 0x66, 0x49, 0x98, 0x6d, 0x7c, 0x7f, 0x1f, 0xb1, 0xc4, 0xc0, 0xa9, 0xcd, 0xda, 0x28, 0xe6, 0x25,
    0x18, 0xf8, 0x94, 0x84, 0xbe, 0xbe, 0xc0, 0x82, 0xe8, 0x28, 0x54, 0x5d, 0x17, 0xea, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x9f, 0xf4, 0x0b, 0x88,
    0x43, 0x5d, 0x55, 0xab, 0xde, 0x04, 0x31, 0x0a, 0x16, 0x40, 0xd5, 0xf7, 0x76, 0x7e, 0x4c, 0x6a, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xad, 0x7d, 0xd4, 0x32, 0xc0, 0xd8, 0x75, 0x33, 0x6e, 0xb7, 0xc8, 0xbb, 0xb0, 0x69, 0x9a,
    0x14, 0x35, 0x5b, 0x87, 0xa3, 0x35, 0x3c, 0x2a, 0xe5, 0x8b, 0xf6, 0xcc, 0x0e, 0x67, 0x6c, 0xd9, 0xa5, 0x02, 0x20, 0x63, 0x1f,
    0x33, 0xf2, 0x3b, 0x44, 0x4c, 0xff, 0xe0, 0x40, 0xbd, 0xff, 0x91, 0x52, 0x66, 0x1f, 0x8e, 0x00, 0xe4, 0xc3, 0x9a, 0x58, 0x50,
    0xa7, 0x85, 0x85, 0xb5, 0x35, 0x4f, 0xaf, 0x56, 0xcb,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_800C[65] = {
    0x04, 0xb7, 0xea, 0x5b, 0x19, 0xc0, 0xa3, 0xa5, 0xb7, 0xd6, 0xc7, 0x41, 0x8a, 0xaf, 0x95, 0x39, 0xdf,
    0xc2, 0x83, 0xa8, 0x7b, 0x20, 0xa8, 0x37, 0x42, 0x2d, 0x4c, 0xaa, 0x9e, 0x7c, 0x66, 0x64, 0xa2, 0x8a,
    0x87, 0x66, 0x49, 0x98, 0x6d, 0x7c, 0x7f, 0x1f, 0xb1, 0xc4, 0xc0, 0xa9, 0xcd, 0xda, 0x28, 0xe6, 0x25,
    0x18, 0xf8, 0x94, 0x84, 0xbe, 0xbe, 0xc0, 0x82, 0xe8, 0x28, 0x54, 0x5d, 0x17, 0xea,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_800C[32] = {
    0x64, 0xc3, 0xc4, 0x16, 0x41, 0xa7, 0x78, 0xb6, 0xa8, 0x25, 0x5b, 0x5d, 0xa9, 0x25, 0x69, 0xec,
    0xa6, 0x83, 0x5c, 0x3f, 0x64, 0xd9, 0xf0, 0x40, 0xc8, 0x8b, 0xc3, 0xed, 0x1f, 0x5d, 0x32, 0xbd,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_800C);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_800C);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_800C);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800D
const uint8_t kDevelopmentDAC_Cert_FFF1_800D[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x24, 0x01, 0x4c, 0xae, 0x54, 0xae,
    0xbf, 0xa3, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x44, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xcc, 0x06, 0x56, 0x50, 0x7e, 0xcb, 0x0f, 0x6d,
    0xbe, 0x9d, 0x2f, 0xf6, 0x71, 0x89, 0x2b, 0x3b, 0xdc, 0x12, 0x87, 0x2b, 0x16, 0x10, 0x24, 0x7d, 0x4e, 0xac, 0x00, 0x26, 0x3d,
    0x80, 0xea, 0xf8, 0x44, 0xa3, 0x64, 0x21, 0x4b, 0xbb, 0x6a, 0x01, 0xcd, 0xd6, 0xe9, 0xcb, 0xf9, 0xe6, 0x1a, 0x96, 0x79, 0x70,
    0x39, 0x1a, 0x12, 0xaa, 0xbb, 0x04, 0x65, 0x9b, 0x93, 0x0a, 0x4e, 0x7a, 0x13, 0x02, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x25, 0x7b, 0x68, 0x31,
    0xed, 0x8b, 0xa1, 0x43, 0xe9, 0x15, 0xdc, 0xaa, 0x98, 0xee, 0xce, 0x58, 0x92, 0x15, 0xea, 0xfe, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x7c, 0xcf, 0x65, 0xd3, 0xe0, 0x60, 0x2c, 0x9a, 0xb2, 0x8e, 0x07, 0xd2, 0x98, 0x92, 0x5a, 0x87,
    0x43, 0x96, 0x7a, 0x49, 0x3e, 0x2d, 0x47, 0xe9, 0x94, 0xf1, 0x20, 0x19, 0x67, 0x2a, 0xd1, 0xf5, 0x02, 0x20, 0x28, 0x36, 0x85,
    0x93, 0x65, 0xce, 0x97, 0xef, 0x43, 0x9c, 0xd2, 0xb3, 0x54, 0x17, 0x54, 0x86, 0xd0, 0xc8, 0xae, 0xfb, 0x87, 0x1e, 0xe4, 0x63,
    0x47, 0x8d, 0x61, 0x1d, 0x40, 0x48, 0xc6, 0x4a,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_800D[65] = {
    0x04, 0xcc, 0x06, 0x56, 0x50, 0x7e, 0xcb, 0x0f, 0x6d, 0xbe, 0x9d, 0x2f, 0xf6, 0x71, 0x89, 0x2b, 0x3b,
    0xdc, 0x12, 0x87, 0x2b, 0x16, 0x10, 0x24, 0x7d, 0x4e, 0xac, 0x00, 0x26, 0x3d, 0x80, 0xea, 0xf8, 0x44,
    0xa3, 0x64, 0x21, 0x4b, 0xbb, 0x6a, 0x01, 0xcd, 0xd6, 0xe9, 0xcb, 0xf9, 0xe6, 0x1a, 0x96, 0x79, 0x70,
    0x39, 0x1a, 0x12, 0xaa, 0xbb, 0x04, 0x65, 0x9b, 0x93, 0x0a, 0x4e, 0x7a, 0x13, 0x02,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_800D[32] = {
    0x78, 0x34, 0xec, 0x0e, 0xe1, 0x92, 0xba, 0xbf, 0x0f, 0x7b, 0x68, 0x53, 0xe0, 0x27, 0x78, 0x60,
    0x8a, 0x59, 0x1e, 0x23, 0xab, 0xf4, 0x99, 0x22, 0x33, 0x6f, 0x5f, 0x08, 0x44, 0x09, 0x6f, 0xaa,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_800D);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_800D);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_800D);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800E
const uint8_t kDevelopmentDAC_Cert_FFF1_800E[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x63, 0x79, 0x50, 0x90, 0x1e, 0xf6,
    0x99, 0x72, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x45, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x45, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xa7, 0xb0, 0x0d, 0x40, 0xf4, 0x43, 0xc2, 0xae,
    0x5e, 0xbd, 0x8d, 0x59, 0xf4, 0x2d, 0x38, 0x87, 0x66, 0x5f, 0x09, 0x57, 0x86, 0xd5, 0xc0, 0xf4, 0x19, 0xa1, 0xd9, 0x32, 0x1f,
    0xea, 0x9f, 0xf5, 0xc4, 0xc7, 0xb5, 0xcc, 0x86, 0x2f, 0xd0, 0xd2, 0x7e, 0x15, 0x98, 0x37, 0xf2, 0x42, 0xab, 0xac, 0x8b, 0x91,
    0xe6, 0x79, 0x59, 0x88, 0xcd, 0x43, 0x94, 0x90, 0x27, 0x77, 0x4c, 0x9c, 0x6e, 0xda, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xae, 0x19, 0x84, 0xcc,
    0x0c, 0x87, 0xac, 0x1d, 0x14, 0x91, 0xe9, 0xa4, 0xc5, 0xaf, 0x15, 0x73, 0xd2, 0x87, 0x91, 0xc5, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x57, 0x18, 0x0c, 0x76, 0xe7, 0xb0, 0xa6, 0xa2, 0x5d, 0xeb, 0x5c, 0x31, 0x66, 0x29, 0xb7, 0x85,
    0x78, 0xf4, 0x6d, 0x9a, 0xfa, 0x33, 0x39, 0xb7, 0x6f, 0xda, 0x7a, 0x34, 0x38, 0xdd, 0x03, 0xa8, 0x02, 0x20, 0x4b, 0x09, 0xd8,
    0xab, 0x71, 0x6a, 0xfd, 0x26, 0x66, 0x56, 0x3d, 0xfb, 0x56, 0x2d, 0x12, 0x1d, 0x91, 0x04, 0xe1, 0x13, 0xd5, 0x2d, 0x02, 0xce,
    0x8a, 0xfc, 0xaf, 0x13, 0x86, 0x32, 0x0f, 0x8e,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_800E[65] = {
    0x04, 0xa7, 0xb0, 0x0d, 0x40, 0xf4, 0x43, 0xc2, 0xae, 0x5e, 0xbd, 0x8d, 0x59, 0xf4, 0x2d, 0x38, 0x87,
    0x66, 0x5f, 0x09, 0x57, 0x86, 0xd5, 0xc0, 0xf4, 0x19, 0xa1, 0xd9, 0x32, 0x1f, 0xea, 0x9f, 0xf5, 0xc4,
    0xc7, 0xb5, 0xcc, 0x86, 0x2f, 0xd0, 0xd2, 0x7e, 0x15, 0x98, 0x37, 0xf2, 0x42, 0xab, 0xac, 0x8b, 0x91,
    0xe6, 0x79, 0x59, 0x88, 0xcd, 0x43, 0x94, 0x90, 0x27, 0x77, 0x4c, 0x9c, 0x6e, 0xda,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_800E[32] = {
    0x2d, 0x08, 0x2f, 0x08, 0x99, 0x8f, 0x6a, 0x67, 0x2f, 0xcb, 0x5d, 0x61, 0xb8, 0x95, 0x14, 0x3e,
    0x36, 0x1f, 0x52, 0x4c, 0xe4, 0x89, 0xad, 0x44, 0x5a, 0x64, 0xdd, 0xa4, 0x6b, 0xc1, 0xb1, 0x08,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_800E);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_800E);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_800E);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800F
const uint8_t kDevelopmentDAC_Cert_FFF1_800F[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x43, 0x0c, 0xcf, 0x7b, 0x27, 0x46,
    0x74, 0x42, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x46, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x46, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x04, 0xbb, 0x5c, 0xbc, 0x56, 0x9f, 0x41, 0xb6,
    0xcc, 0xd4, 0x74, 0xf9, 0x49, 0xd9, 0x2a, 0x7f, 0xef, 0x00, 0x8d, 0xec, 0xf0, 0x0e, 0x34, 0xc5, 0x82, 0xa6, 0xdd, 0xd7, 0x80,
    0xae, 0x95, 0xa9, 0xa0, 0x01, 0x26, 0x25, 0x09, 0x42, 0x6d, 0x15, 0x20, 0x3e, 0x77, 0x58, 0xde, 0xca, 0x5c, 0xcd, 0x3c, 0x87,
    0xae, 0x1c, 0xbd, 0xbd, 0x37, 0xd4, 0x37, 0xde, 0x8e, 0x07, 0x73, 0x5d, 0x6b, 0x4c, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xff, 0xf7, 0x15, 0x7a,
    0xbd, 0xe1, 0xda, 0xe9, 0xea, 0x86, 0xeb, 0x09, 0xf1, 0x81, 0xa3, 0x9a, 0x92, 0x04, 0x09, 0xe2, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x72, 0x0f, 0xee, 0x9d, 0xd1, 0x31, 0xe6, 0xbd, 0x08, 0x46, 0x9a, 0xdb, 0xe4, 0xa4, 0xe3, 0xb5,
    0x67, 0x08, 0xc7, 0x58, 0x9f, 0xc0, 0x7d, 0xd3, 0xc8, 0x7b, 0xa4, 0x83, 0xa7, 0x8d, 0x22, 0x2e, 0x02, 0x20, 0x19, 0xad, 0x7b,
    0x4c, 0xb2, 0x36, 0x6f, 0x88, 0x7e, 0xc3, 0xda, 0x7e, 0x0a, 0xbb, 0x3f, 0x4e, 0xfa, 0xaf, 0x0b, 0x29, 0x83, 0xa7, 0x54, 0x66,
    0x4c, 0x7c, 0x7c, 0x7b, 0xa1, 0x54, 0xcd, 0xa4,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_800F[65] = {
    0x04, 0x04, 0xbb, 0x5c, 0xbc, 0x56, 0x9f, 0x41, 0xb6, 0xcc, 0xd4, 0x74, 0xf9, 0x49, 0xd9, 0x2a, 0x7f,
    0xef, 0x00, 0x8d, 0xec, 0xf0, 0x0e, 0x34, 0xc5, 0x82, 0xa6, 0xdd, 0xd7, 0x80, 0xae, 0x95, 0xa9, 0xa0,
    0x01, 0x26, 0x25, 0x09, 0x42, 0x6d, 0x15, 0x20, 0x3e, 0x77, 0x58, 0xde, 0xca, 0x5c, 0xcd, 0x3c, 0x87,
    0xae, 0x1c, 0xbd, 0xbd, 0x37, 0xd4, 0x37, 0xde, 0x8e, 0x07, 0x73, 0x5d, 0x6b, 0x4c,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_800F[32] = {
    0x88, 0xe5, 0x2c, 0xdc, 0xf8, 0x83, 0xe8, 0x16, 0x76, 0xdf, 0x27, 0xc0, 0x30, 0x9a, 0xf8, 0x2c,
    0x9d, 0x27, 0x8a, 0x73, 0xc9, 0x41, 0xc3, 0x4f, 0x82, 0x1c, 0xaa, 0xab, 0xac, 0xc1, 0x58, 0x2b,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_800F);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_800F);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_800F);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8010
const uint8_t kDevelopmentDAC_Cert_FFF1_8010[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x46, 0x7f, 0x57, 0x62, 0xc8, 0xdc,
    0x90, 0xd5, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x33, 0x33, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x30, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x30, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x39, 0xef, 0x6c, 0x9d, 0x9c, 0x99, 0x7b, 0xa2,
    0xc7, 0x31, 0x9a, 0x4c, 0x73, 0xc9, 0xbf, 0x47, 0xdb, 0xcd, 0xbc, 0x42, 0xc5, 0x41, 0x3e, 0xec, 0x14, 0x52, 0x75, 0xb8, 0x8f,
    0xc1, 0x1a, 0xb1, 0xad, 0x0b, 0xc3, 0x3e, 0xf1, 0x4c, 0x27, 0x94, 0x04, 0x42, 0x9f, 0x2f, 0x5e, 0xe7, 0x0a, 0x05, 0x1b, 0x72,
    0xe6, 0xc7, 0xb9, 0xe7, 0x35, 0x4e, 0xda, 0xf9, 0x2a, 0xb4, 0xff, 0xf8, 0x84, 0x2f, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x32, 0xfc, 0x27, 0xd1,
    0xef, 0x53, 0x43, 0xa2, 0xf3, 0x64, 0xf0, 0x2c, 0xf4, 0x70, 0xcb, 0x67, 0x47, 0x80, 0xe5, 0xaa, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x6f, 0x11, 0xb2, 0x05, 0x0b, 0xd3, 0xd2, 0xe3, 0x6c, 0x24, 0x61, 0x30, 0x08, 0x6c, 0x22, 0x01,
    0xb0, 0x8c, 0xf9, 0x9d, 0x5a, 0x77, 0xb2, 0x3a, 0x90, 0x05, 0x00, 0xfb, 0xef, 0x09, 0x13, 0xb2, 0x02, 0x20, 0x13, 0x6a, 0xb6,
    0xa0, 0xbb, 0x8b, 0xd4, 0xf4, 0xad, 0xf8, 0x0a, 0x12, 0x34, 0xcf, 0xef, 0xb6, 0x7f, 0x0a, 0xfb, 0x73, 0x55, 0xf1, 0xdc, 0xa4,
    0x72, 0xda, 0x16, 0xac, 0x4a, 0x36, 0x64, 0xe5,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8010[65] = {
    0x04, 0x39, 0xef, 0x6c, 0x9d, 0x9c, 0x99, 0x7b, 0xa2, 0xc7, 0x31, 0x9a, 0x4c, 0x73, 0xc9, 0xbf, 0x47,
    0xdb, 0xcd, 0xbc, 0x42, 0xc5, 0x41, 0x3e, 0xec, 0x14, 0x52, 0x75, 0xb8, 0x8f, 0xc1, 0x1a, 0xb1, 0xad,
    0x0b, 0xc3, 0x3e, 0xf1, 0x4c, 0x27, 0x94, 0x04, 0x42, 0x9f, 0x2f, 0x5e, 0xe7, 0x0a, 0x05, 0x1b, 0x72,
    0xe6, 0xc7, 0xb9, 0xe7, 0x35, 0x4e, 0xda, 0xf9, 0x2a, 0xb4, 0xff, 0xf8, 0x84, 0x2f,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8010[32] = {
    0xda, 0xfb, 0x2c, 0x72, 0x88, 0xa4, 0x70, 0x86, 0x69, 0x23, 0x0d, 0x9f, 0xdb, 0xa8, 0x95, 0x3f,
    0x10, 0x3b, 0xa8, 0x5a, 0xd5, 0xcf, 0x94, 0xaa, 0x71, 0x3d, 0xe0, 0xa2, 0x3e, 0xb4, 0xbe, 0xde,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8010);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8010);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8010);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8011
const uint8_t kDevelopmentDAC_Cert_FFF1_8011[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x0e, 0x5c, 0x88, 0xcc, 0x15, 0xe3,
    0xda, 0xe5, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x33, 0x33, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x31, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x58, 0xb4, 0x75, 0xf4, 0x1b, 0x59, 0xe2, 0x5e,
    0x66, 0xe1, 0x8a, 0xc2, 0x61, 0x0b, 0x8a, 0xc2, 0xbe, 0xd2, 0x80, 0x10, 0xf2, 0x84, 0xbf, 0x58, 0x93, 0x5b, 0x20, 0xac, 0xdb,
    0xbd, 0x55, 0xcf, 0xe9, 0x9a, 0x85, 0x72, 0xbf, 0xca, 0x0d, 0x28, 0xb6, 0x63, 0x2f, 0xf4, 0x88, 0x3f, 0x49, 0xc6, 0x91, 0xda,
    0xd9, 0x9d, 0xdc, 0xaa, 0xad, 0xa4, 0x1e, 0x5c, 0x19, 0x1a, 0x4c, 0x1f, 0x90, 0xb4, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x96, 0x10, 0x85, 0x7f,
    0x58, 0x20, 0xa0, 0x5f, 0x10, 0x2c, 0xfb, 0xd6, 0xe4, 0xf2, 0x6b, 0xce, 0xd2, 0x20, 0x6f, 0x54, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0x93, 0xe6, 0x9c, 0xaa, 0x70, 0x19, 0x21, 0x24, 0x20, 0x4b, 0x51, 0xda, 0x5c, 0xa7, 0x07,
    0xca, 0x9e, 0xf6, 0xb9, 0xbd, 0xe0, 0x67, 0x10, 0xed, 0xbc, 0x59, 0x23, 0xae, 0x70, 0xc5, 0x4e, 0xa6, 0x02, 0x21, 0x00, 0xc5,
    0x4c, 0x59, 0x78, 0xda, 0xa2, 0x1e, 0x53, 0x28, 0x7c, 0xc5, 0xf5, 0x73, 0xc5, 0x48, 0xc8, 0xa8, 0x81, 0xd4, 0xb3, 0xf9, 0x7a,
    0xe9, 0xc6, 0x71, 0xa2, 0xf2, 0xb7, 0x96, 0xb3, 0x04, 0xbd,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8011[65] = {
    0x04, 0x58, 0xb4, 0x75, 0xf4, 0x1b, 0x59, 0xe2, 0x5e, 0x66, 0xe1, 0x8a, 0xc2, 0x61, 0x0b, 0x8a, 0xc2,
    0xbe, 0xd2, 0x80, 0x10, 0xf2, 0x84, 0xbf, 0x58, 0x93, 0x5b, 0x20, 0xac, 0xdb, 0xbd, 0x55, 0xcf, 0xe9,
    0x9a, 0x85, 0x72, 0xbf, 0xca, 0x0d, 0x28, 0xb6, 0x63, 0x2f, 0xf4, 0x88, 0x3f, 0x49, 0xc6, 0x91, 0xda,
    0xd9, 0x9d, 0xdc, 0xaa, 0xad, 0xa4, 0x1e, 0x5c, 0x19, 0x1a, 0x4c, 0x1f, 0x90, 0xb4,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8011[32] = {
    0x07, 0x4a, 0x1d, 0x35, 0x07, 0x79, 0x7b, 0x3e, 0xff, 0x19, 0x3c, 0x8b, 0x73, 0x84, 0xce, 0x18,
    0xe8, 0xe8, 0x2b, 0xef, 0x65, 0x15, 0x2d, 0xf4, 0x08, 0x70, 0x29, 0x8c, 0x4c, 0xc3, 0x2f, 0x30,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8011);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8011);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8011);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8012
const uint8_t kDevelopmentDAC_Cert_FFF1_8012[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x41, 0x2d, 0xc7, 0x93, 0xe5, 0x15,
    0x40, 0x9c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x33, 0x33, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x32, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xdc, 0x2c, 0xc1, 0x6c, 0x4d, 0x80, 0x89, 0xc6,
    0x06, 0x37, 0x33, 0x96, 0xa2, 0x86, 0x2a, 0x05, 0xef, 0x85, 0x17, 0x99, 0xd9, 0xf5, 0xee, 0x70, 0xe6, 0x11, 0x52, 0x27, 0x69,
    0xb7, 0xd1, 0x7c, 0xcf, 0x9a, 0xd4, 0x27, 0x96, 0x2c, 0x2f, 0x32, 0xb8, 0xab, 0x22, 0x27, 0xa2, 0x76, 0x24, 0x1d, 0xa0, 0x8b,
    0x6c, 0xf6, 0x65, 0x71, 0xce, 0x9f, 0x28, 0xe2, 0xe7, 0x57, 0x03, 0x63, 0x77, 0xb3, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xb7, 0x48, 0xb2, 0xcb,
    0xf5, 0x3a, 0xc9, 0xbc, 0x7c, 0xea, 0x84, 0x05, 0x7c, 0xeb, 0xd7, 0xb5, 0x04, 0xd7, 0x04, 0xea, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xd1, 0xe7, 0x78, 0xd4, 0xcd, 0x1e, 0x26, 0xae, 0xdf, 0x8f, 0x49, 0x0b, 0x8e, 0x58, 0x57,
    0x60, 0x60, 0x04, 0xfd, 0x2c, 0x8b, 0x53, 0x74, 0xc9, 0xd8, 0x2c, 0x66, 0x7d, 0x51, 0xcd, 0xaa, 0x28, 0x02, 0x21, 0x00, 0xe8,
    0x3b, 0xca, 0xa1, 0x0f, 0xbc, 0x61, 0x80, 0xc5, 0xee, 0xcb, 0x75, 0xd9, 0x9f, 0x9e, 0x32, 0x95, 0xf4, 0x32, 0xa4, 0x97, 0xda,
    0x25, 0xe7, 0x11, 0xe0, 0x71, 0xc0, 0x11, 0x3b, 0x75, 0xb3,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8012[65] = {
    0x04, 0xdc, 0x2c, 0xc1, 0x6c, 0x4d, 0x80, 0x89, 0xc6, 0x06, 0x37, 0x33, 0x96, 0xa2, 0x86, 0x2a, 0x05,
    0xef, 0x85, 0x17, 0x99, 0xd9, 0xf5, 0xee, 0x70, 0xe6, 0x11, 0x52, 0x27, 0x69, 0xb7, 0xd1, 0x7c, 0xcf,
    0x9a, 0xd4, 0x27, 0x96, 0x2c, 0x2f, 0x32, 0xb8, 0xab, 0x22, 0x27, 0xa2, 0x76, 0x24, 0x1d, 0xa0, 0x8b,
    0x6c, 0xf6, 0x65, 0x71, 0xce, 0x9f, 0x28, 0xe2, 0xe7, 0x57, 0x03, 0x63, 0x77, 0xb3,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8012[32] = {
    0x84, 0xe3, 0x7f, 0xda, 0xb8, 0x9a, 0x80, 0xec, 0xd0, 0x44, 0x5b, 0x2b, 0x36, 0x1f, 0xdc, 0x54,
    0x4f, 0x2d, 0xf1, 0x2f, 0x92, 0x1a, 0x94, 0x7b, 0x93, 0xe8, 0x59, 0xc9, 0xad, 0xb5, 0xc9, 0x1a,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8012);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8012);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8012);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8013
const uint8_t kDevelopmentDAC_Cert_FFF1_8013[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x7b, 0x4d, 0x47, 0x2e, 0x05, 0x9a,
    0xc7, 0x0b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x33, 0x33, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x33, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x31, 0xfb, 0x34, 0xae, 0x4f, 0x09, 0xc0, 0x5b,
    0xd0, 0xbc, 0xaf, 0x37, 0xb5, 0xfa, 0xbe, 0x4d, 0x56, 0x7e, 0xed, 0x1a, 0xe8, 0x14, 0xb0, 0x0d, 0xf8, 0x49, 0xc5, 0x1e, 0x86,
    0x6d, 0x1a, 0x82, 0xf9, 0xc9, 0x14, 0x1f, 0xc7, 0xc7, 0xcc, 0x2f, 0x8b, 0xd3, 0xda, 0xec, 0x30, 0x62, 0x68, 0xc4, 0xad, 0x63,
    0xbf, 0xbf, 0xc4, 0xcd, 0x91, 0xba, 0x54, 0x9e, 0xf9, 0xe3, 0xf6, 0xa9, 0x7a, 0x7a, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x6b, 0x83, 0xbe, 0x0d,
    0x05, 0x5f, 0x28, 0x73, 0xca, 0xc0, 0xba, 0x15, 0x21, 0x1d, 0xdf, 0x16, 0x3d, 0x95, 0xcb, 0x05, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x7d, 0x15, 0x0b, 0xf0, 0x45, 0xed, 0xab, 0xd1, 0x09, 0x14, 0x2a, 0xae, 0xb4, 0xe0, 0x97, 0xd8,
    0xaa, 0xf9, 0x1a, 0x9c, 0xe1, 0x7e, 0xe9, 0x38, 0xa5, 0x6e, 0x24, 0x26, 0x26, 0xa8, 0x43, 0x49, 0x02, 0x21, 0x00, 0xe8, 0x0c,
    0x31, 0x4b, 0x73, 0x8f, 0x88, 0xaf, 0x8c, 0x16, 0x29, 0xd5, 0xf5, 0xa4, 0x60, 0x29, 0x56, 0x50, 0xb5, 0x07, 0x77, 0x0c, 0xc2,
    0xcc, 0x3b, 0xc4, 0xda, 0x28, 0x7a, 0x2d, 0x2c, 0x9f,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8013[65] = {
    0x04, 0x31, 0xfb, 0x34, 0xae, 0x4f, 0x09, 0xc0, 0x5b, 0xd0, 0xbc, 0xaf, 0x37, 0xb5, 0xfa, 0xbe, 0x4d,
    0x56, 0x7e, 0xed, 0x1a, 0xe8, 0x14, 0xb0, 0x0d, 0xf8, 0x49, 0xc5, 0x1e, 0x86, 0x6d, 0x1a, 0x82, 0xf9,
    0xc9, 0x14, 0x1f, 0xc7, 0xc7, 0xcc, 0x2f, 0x8b, 0xd3, 0xda, 0xec, 0x30, 0x62, 0x68, 0xc4, 0xad, 0x63,
    0xbf, 0xbf, 0xc4, 0xcd, 0x91, 0xba, 0x54, 0x9e, 0xf9, 0xe3, 0xf6, 0xa9, 0x7a, 0x7a,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8013[32] = {
    0xe2, 0x7c, 0x65, 0x3b, 0x4d, 0x86, 0x19, 0x9c, 0xe7, 0x12, 0xe6, 0x60, 0xf8, 0xef, 0x80, 0x88,
    0x88, 0xe2, 0x66, 0x33, 0x9e, 0x3e, 0x90, 0x66, 0xf8, 0x29, 0xd5, 0x8f, 0xc4, 0xc8, 0x44, 0xa6,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8013);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8013);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8013);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8014
const uint8_t kDevelopmentDAC_Cert_FFF1_8014[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x69, 0x90, 0x05, 0xe0, 0xed, 0xa8,
    0x50, 0x47, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x33, 0x33, 0x31, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x34, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x34, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xb7, 0x1e, 0x29, 0x0c, 0xab, 0x87, 0x31, 0xc8,
    0x9f, 0x99, 0x5d, 0x51, 0xcc, 0xc4, 0xa1, 0x89, 0x9b, 0xf3, 0x42, 0xa2, 0x0e, 0xd6, 0xdd, 0x23, 0x4c, 0x4e, 0x92, 0xce, 0x0a,
    0x78, 0x43, 0x09, 0xa5, 0x01, 0xd3, 0xd6, 0x40, 0xff, 0x16, 0x9e, 0x13, 0x4c, 0xde, 0x5a, 0xc7, 0x77, 0xb3, 0xda, 0xe6, 0x6a,
    0x54, 0xa3, 0x29, 0x47, 0xb9, 0x07, 0x04, 0x38, 0x4c, 0x51, 0x44, 0xa3, 0xc5, 0x50, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xc3, 0xec, 0xc0, 0xb6,
    0x0a, 0xd9, 0x32, 0xe9, 0x83, 0xb5, 0x7a, 0xf4, 0xc1, 0x4e, 0x9a, 0x79, 0xbd, 0x85, 0x61, 0x1d, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x67, 0x98, 0xb1, 0x51, 0x12, 0x70, 0x13, 0x47, 0x87, 0xe2, 0xcf, 0x95, 0x40, 0x29, 0xdf, 0xb1,
    0xfa, 0x8f, 0xe8, 0x50, 0xe1, 0xbd, 0x24, 0x37, 0x56, 0xb0, 0x40, 0x13, 0xa4, 0x14, 0xc3, 0x09, 0x02, 0x21, 0x00, 0xda, 0xe5,
    0x69, 0x94, 0xf3, 0x28, 0x78, 0x80, 0xd6, 0x5d, 0xb5, 0x13, 0x1a, 0x9b, 0xbd, 0xbb, 0x1a, 0xb5, 0x4d, 0xa5, 0x10, 0xc8, 0x01,
    0x2e, 0xbe, 0x82, 0x62, 0x73, 0xf0, 0x0d, 0x99, 0xe4,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8014[65] = {
    0x04, 0xb7, 0x1e, 0x29, 0x0c, 0xab, 0x87, 0x31, 0xc8, 0x9f, 0x99, 0x5d, 0x51, 0xcc, 0xc4, 0xa1, 0x89,
    0x9b, 0xf3, 0x42, 0xa2, 0x0e, 0xd6, 0xdd, 0x23, 0x4c, 0x4e, 0x92, 0xce, 0x0a, 0x78, 0x43, 0x09, 0xa5,
    0x01, 0xd3, 0xd6, 0x40, 0xff, 0x16, 0x9e, 0x13, 0x4c, 0xde, 0x5a, 0xc7, 0x77, 0xb3, 0xda, 0xe6, 0x6a,
    0x54, 0xa3, 0x29, 0x47, 0xb9, 0x07, 0x04, 0x38, 0x4c, 0x51, 0x44, 0xa3, 0xc5, 0x50,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8014[32] = {
    0xc6, 0xb9, 0x50, 0x77, 0xcc, 0xb6, 0x75, 0x5f, 0xf9, 0xe4, 0x27, 0xf8, 0x06, 0x6e, 0xc4, 0x77,
    0x45, 0xc0, 0x23, 0x23, 0x49, 0x85, 0x4c, 0xd7, 0x10, 0x3f, 0xc6, 0xeb, 0xde, 0x86, 0x1e, 0xc6,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8014);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8014);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8014);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8015
const uint8_t kDevelopmentDAC_Cert_FFF1_8015[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x62, 0x8f, 0xa9, 0x12, 0xcd, 0x16,
    0x5d, 0x7b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x35, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x35, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x9f, 0xfe, 0x35, 0xc3, 0x3e, 0xf0, 0x04, 0x4d,
    0x1d, 0x1d, 0xa5, 0x33, 0x34, 0x7e, 0x7c, 0xf1, 0x1c, 0xb2, 0x5e, 0x39, 0xf5, 0x07, 0x77, 0x0b, 0xd1, 0xb1, 0xfd, 0x51, 0x0e,
    0x23, 0xcf, 0x9f, 0x17, 0x49, 0x2e, 0xc4, 0x8a, 0x9b, 0x80, 0xb0, 0xd6, 0x45, 0x47, 0x10, 0xa0, 0x99, 0x24, 0x3e, 0x67, 0x5b,
    0xd6, 0x98, 0xe1, 0xb2, 0xeb, 0x9c, 0x89, 0x5c, 0x44, 0x00, 0xd2, 0x01, 0x4f, 0x6b, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xd5, 0xaf, 0x1a, 0xca,
    0xe4, 0x57, 0xd0, 0xf9, 0x11, 0x4a, 0xb5, 0x1f, 0xec, 0xa9, 0x69, 0xc3, 0x80, 0x0a, 0x4c, 0xa0, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xd7, 0xc4, 0x1b, 0x16, 0x25, 0x6a, 0x7d, 0x5c, 0xa5, 0x79, 0x81, 0xd1, 0x86, 0x16, 0xbc,
    0x92, 0xb9, 0x64, 0x95, 0x3e, 0xe5, 0xa6, 0xbc, 0x66, 0x77, 0xdb, 0xdd, 0x90, 0x0f, 0x89, 0x34, 0x63, 0x02, 0x20, 0x64, 0x16,
    0x8b, 0x1c, 0x98, 0x02, 0x1b, 0x8a, 0xda, 0x44, 0xf8, 0xda, 0x6d, 0x1e, 0x48, 0x34, 0xeb, 0xe8, 0x5f, 0x82, 0x9d, 0x60, 0x94,
    0x06, 0x8f, 0x27, 0x95, 0x0d, 0xae, 0x56, 0x4a, 0x7b,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8015[65] = {
    0x04, 0x9f, 0xfe, 0x35, 0xc3, 0x3e, 0xf0, 0x04, 0x4d, 0x1d, 0x1d, 0xa5, 0x33, 0x34, 0x7e, 0x7c, 0xf1,
    0x1c, 0xb2, 0x5e, 0x39, 0xf5, 0x07, 0x77, 0x0b, 0xd1, 0xb1, 0xfd, 0x51, 0x0e, 0x23, 0xcf, 0x9f, 0x17,
    0x49, 0x2e, 0xc4, 0x8a, 0x9b, 0x80, 0xb0, 0xd6, 0x45, 0x47, 0x10, 0xa0, 0x99, 0x24, 0x3e, 0x67, 0x5b,
    0xd6, 0x98, 0xe1, 0xb2, 0xeb, 0x9c, 0x89, 0x5c, 0x44, 0x00, 0xd2, 0x01, 0x4f, 0x6b,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8015[32] = {
    0x66, 0xe4, 0x1c, 0xa4, 0xd3, 0x55, 0x10, 0x2e, 0x7b, 0xce, 0xd9, 0x72, 0xfd, 0x19, 0xed, 0x1c,
    0x3c, 0xba, 0x57, 0x2f, 0xb8, 0xdc, 0xaf, 0xc9, 0x48, 0x2c, 0xc8, 0xc8, 0x10, 0xeb, 0x62, 0x46,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8015);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8015);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8015);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8016
const uint8_t kDevelopmentDAC_Cert_FFF1_8016[490] = {
    0x30, 0x82, 0x01, 0xe6, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x35, 0x49, 0xfd, 0x40, 0x21, 0x03,
    0x13, 0x07, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x36, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x36, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x48, 0x72, 0xea, 0xb7, 0x85, 0xe7, 0xa2, 0x75,
    0x9b, 0x4d, 0x48, 0x79, 0xb0, 0xe4, 0x25, 0x1d, 0xe8, 0x9f, 0x93, 0xd0, 0x2a, 0xe0, 0x28, 0xc6, 0xa2, 0x4a, 0xf5, 0x8d, 0xe8,
    0x00, 0x78, 0x4b, 0x39, 0xa1, 0x65, 0x3f, 0xe0, 0xb9, 0x47, 0x7b, 0x8c, 0x42, 0x34, 0xd4, 0x51, 0x0c, 0x4c, 0xf6, 0x5e, 0xa9,
    0x23, 0x67, 0x79, 0xc7, 0xb2, 0x78, 0x3c, 0x1b, 0x01, 0x52, 0xd0, 0x9d, 0xb8, 0xf2, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x3e, 0x4c, 0x8c, 0xd7,
    0xb8, 0xb4, 0xcd, 0x4c, 0x51, 0xe0, 0x10, 0xcc, 0x55, 0x02, 0xee, 0xe6, 0x0d, 0x82, 0xd4, 0x7c, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x46,
    0x00, 0x30, 0x43, 0x02, 0x1f, 0x16, 0x8c, 0x25, 0xc5, 0xaf, 0x66, 0x68, 0x09, 0x60, 0xe5, 0xf5, 0x24, 0xa2, 0xd0, 0x1b, 0x90,
    0x78, 0x6b, 0x92, 0xd1, 0xaf, 0x36, 0xa8, 0xdb, 0x56, 0x65, 0x0c, 0x2b, 0x90, 0x13, 0x0b, 0x02, 0x20, 0x32, 0x69, 0x61, 0x12,
    0xc9, 0x15, 0xd8, 0x65, 0x8a, 0xb3, 0x39, 0xea, 0x1d, 0x2f, 0xde, 0x9d, 0x82, 0x0b, 0x25, 0x80, 0x06, 0xd5, 0x87, 0x17, 0xce,
    0x76, 0x9f, 0x3e, 0x1d, 0xfe, 0x58, 0x46,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8016[65] = {
    0x04, 0x48, 0x72, 0xea, 0xb7, 0x85, 0xe7, 0xa2, 0x75, 0x9b, 0x4d, 0x48, 0x79, 0xb0, 0xe4, 0x25, 0x1d,
    0xe8, 0x9f, 0x93, 0xd0, 0x2a, 0xe0, 0x28, 0xc6, 0xa2, 0x4a, 0xf5, 0x8d, 0xe8, 0x00, 0x78, 0x4b, 0x39,
    0xa1, 0x65, 0x3f, 0xe0, 0xb9, 0x47, 0x7b, 0x8c, 0x42, 0x34, 0xd4, 0x51, 0x0c, 0x4c, 0xf6, 0x5e, 0xa9,
    0x23, 0x67, 0x79, 0xc7, 0xb2, 0x78, 0x3c, 0x1b, 0x01, 0x52, 0xd0, 0x9d, 0xb8, 0xf2,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8016[32] = {
    0xb6, 0x96, 0x4b, 0x2f, 0xc0, 0x8b, 0xe3, 0xe9, 0x48, 0x98, 0xe0, 0x7b, 0x00, 0x2f, 0xe6, 0xb3,
    0xb7, 0x99, 0x98, 0x38, 0x06, 0x1b, 0x18, 0xc1, 0x81, 0xfe, 0x13, 0xc1, 0x6c, 0xda, 0xc9, 0xd0,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8016);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8016);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8016);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8017
const uint8_t kDevelopmentDAC_Cert_FFF1_8017[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x1b, 0x7f, 0x4d, 0x97, 0x13, 0xb2,
    0x91, 0x05, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x37, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x37, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x48, 0xc3, 0xae, 0x48, 0xb1, 0xae, 0x2e, 0xcc,
    0x82, 0x3b, 0xdd, 0x7b, 0x43, 0x57, 0x75, 0x2d, 0xf1, 0x05, 0x17, 0x19, 0x5e, 0xf3, 0xe9, 0xd3, 0x70, 0x97, 0x91, 0xdc, 0x78,
    0xc6, 0x8a, 0x8b, 0xf9, 0x0e, 0xa3, 0xd7, 0x8c, 0x67, 0x71, 0x2f, 0x17, 0xe2, 0xa4, 0xf9, 0x6a, 0x96, 0x93, 0x77, 0xad, 0xac,
    0x6f, 0xc3, 0xc4, 0x8e, 0x65, 0x0b, 0x1c, 0x29, 0x18, 0xbd, 0xa2, 0x2b, 0xdb, 0x1b, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xd2, 0x87, 0x4d, 0xfe,
    0xdf, 0x76, 0x48, 0x0a, 0x8e, 0x96, 0x8a, 0x3a, 0x0a, 0xce, 0x06, 0xae, 0xaa, 0x8d, 0x0b, 0x16, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xd5, 0xb6, 0x5d, 0xbb, 0x56, 0x73, 0x3b, 0x1c, 0xc9, 0x16, 0x02, 0x06, 0x6e, 0x73, 0x1c,
    0x2e, 0x4d, 0x37, 0x0c, 0x30, 0x94, 0x0a, 0x9c, 0xe3, 0xaa, 0x2e, 0x8e, 0xdd, 0xe3, 0x72, 0x54, 0xab, 0x02, 0x21, 0x00, 0xc9,
    0xcb, 0xa6, 0xd3, 0x44, 0xe9, 0x5e, 0x8c, 0x17, 0x96, 0x9e, 0x7c, 0xba, 0xde, 0x94, 0x07, 0xa4, 0x11, 0x93, 0x1e, 0x5a, 0xf3,
    0x53, 0x70, 0x35, 0x79, 0x91, 0x79, 0xa9, 0x27, 0x4d, 0x49,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8017[65] = {
    0x04, 0x48, 0xc3, 0xae, 0x48, 0xb1, 0xae, 0x2e, 0xcc, 0x82, 0x3b, 0xdd, 0x7b, 0x43, 0x57, 0x75, 0x2d,
    0xf1, 0x05, 0x17, 0x19, 0x5e, 0xf3, 0xe9, 0xd3, 0x70, 0x97, 0x91, 0xdc, 0x78, 0xc6, 0x8a, 0x8b, 0xf9,
    0x0e, 0xa3, 0xd7, 0x8c, 0x67, 0x71, 0x2f, 0x17, 0xe2, 0xa4, 0xf9, 0x6a, 0x96, 0x93, 0x77, 0xad, 0xac,
    0x6f, 0xc3, 0xc4, 0x8e, 0x65, 0x0b, 0x1c, 0x29, 0x18, 0xbd, 0xa2, 0x2b, 0xdb, 0x1b,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8017[32] = {
    0x86, 0x8f, 0x69, 0xe3, 0xfc, 0x28, 0xbe, 0x1c, 0x8e, 0x12, 0x2c, 0x76, 0xe8, 0x10, 0x5a, 0xbc,
    0xe0, 0x6b, 0xea, 0x32, 0xac, 0xd6, 0xc3, 0x03, 0x50, 0xa7, 0xde, 0xe1, 0x56, 0xd2, 0x51, 0xbc,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8017);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8017);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8017);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8018
const uint8_t kDevelopmentDAC_Cert_FFF1_8018[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x33, 0x5c, 0xff, 0x1c, 0x68, 0x11,
    0xff, 0xdf, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x38, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x38, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x44, 0x4e, 0x69, 0xb6, 0xee, 0x11, 0x42, 0x0e,
    0xc8, 0xd0, 0x72, 0x4a, 0x72, 0x25, 0x0f, 0x99, 0x48, 0xbc, 0x0f, 0x7b, 0x45, 0xe6, 0x8a, 0xa2, 0x8c, 0x3a, 0x5c, 0x8c, 0xbd,
    0xb1, 0xe9, 0x15, 0xbc, 0x37, 0xd4, 0xde, 0xfb, 0xa4, 0x85, 0xb9, 0xe2, 0xad, 0x8f, 0x4b, 0x84, 0x5c, 0xdf, 0xc3, 0x44, 0x50,
    0xe9, 0x12, 0xb1, 0xf7, 0x3e, 0x9b, 0xcf, 0x12, 0x57, 0xf7, 0xf1, 0x2b, 0xba, 0x92, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x3b, 0x00, 0x6e, 0x95,
    0x7a, 0x6d, 0x31, 0xee, 0x3a, 0x27, 0x18, 0xb6, 0xfb, 0x97, 0x00, 0xaf, 0x86, 0xa0, 0xb4, 0xba, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x69, 0x68, 0x93, 0x8d, 0x48, 0x82, 0x1f, 0x42, 0xba, 0x59, 0x75, 0x0f, 0x20, 0x80, 0xc7, 0x6f,
    0xfc, 0x88, 0xd4, 0xcc, 0xdb, 0x87, 0xc5, 0x6e, 0xaa, 0xb1, 0x98, 0xbc, 0x73, 0x2a, 0xf5, 0x21, 0x02, 0x21, 0x00, 0xf0, 0xbe,
    0xa4, 0xd5, 0xf4, 0xab, 0xf7, 0x9e, 0xe7, 0x16, 0x41, 0x7e, 0x01, 0xb3, 0x12, 0x87, 0x39, 0x49, 0x11, 0x77, 0x9a, 0xfe, 0x5e,
    0x8d, 0x7b, 0xf7, 0x27, 0x25, 0x66, 0xcc, 0x66, 0xa7,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8018[65] = {
    0x04, 0x44, 0x4e, 0x69, 0xb6, 0xee, 0x11, 0x42, 0x0e, 0xc8, 0xd0, 0x72, 0x4a, 0x72, 0x25, 0x0f, 0x99,
    0x48, 0xbc, 0x0f, 0x7b, 0x45, 0xe6, 0x8a, 0xa2, 0x8c, 0x3a, 0x5c, 0x8c, 0xbd, 0xb1, 0xe9, 0x15, 0xbc,
    0x37, 0xd4, 0xde, 0xfb, 0xa4, 0x85, 0xb9, 0xe2, 0xad, 0x8f, 0x4b, 0x84, 0x5c, 0xdf, 0xc3, 0x44, 0x50,
    0xe9, 0x12, 0xb1, 0xf7, 0x3e, 0x9b, 0xcf, 0x12, 0x57, 0xf7, 0xf1, 0x2b, 0xba, 0x92,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8018[32] = {
    0x9b, 0x62, 0xf5, 0xf0, 0x48, 0x71, 0xca, 0x52, 0x1c, 0x20, 0x6a, 0x54, 0xe1, 0x72, 0xcd, 0x68,
    0xc8, 0x53, 0x0d, 0x35, 0xb3, 0x67, 0x0a, 0xb9, 0xa2, 0xf9, 0xdc, 0x00, 0x92, 0xc7, 0x8b, 0xb8,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8018);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8018);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8018);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8019
const uint8_t kDevelopmentDAC_Cert_FFF1_8019[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x33, 0x73, 0x4c, 0xce, 0xe6, 0x97,
    0x6b, 0xcb, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x39, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x39, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xdb, 0x34, 0x07, 0x55, 0x64, 0x3e, 0x66, 0xe8,
    0xe5, 0x51, 0x0a, 0xb3, 0x35, 0xac, 0x18, 0x7a, 0x36, 0x91, 0x8e, 0x31, 0xbb, 0xb0, 0x8b, 0x2e, 0xbe, 0xc0, 0x29, 0x65, 0x1b,
    0x74, 0xc3, 0xa6, 0x4a, 0x42, 0xac, 0x17, 0xe4, 0x97, 0x89, 0x75, 0xfa, 0x91, 0x59, 0x8f, 0x1e, 0x74, 0x1b, 0xaf, 0x06, 0x62,
    0x50, 0x5d, 0x34, 0xd7, 0x0d, 0x56, 0xc1, 0x9b, 0x3a, 0xe6, 0xc7, 0x64, 0x3c, 0x88, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x89, 0x19, 0x6a, 0x4c,
    0x9d, 0xcf, 0xc1, 0x92, 0x5a, 0x54, 0x62, 0xbf, 0x47, 0x67, 0x31, 0xa5, 0x9d, 0x59, 0x7a, 0xa4, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0x8e, 0x50, 0xe8, 0xf0, 0x21, 0xab, 0x20, 0xec, 0x9e, 0x20, 0x08, 0x21, 0xc7, 0x8b, 0x7f,
    0xc2, 0x06, 0xf4, 0xb1, 0x54, 0x0a, 0xd0, 0x42, 0x70, 0x6b, 0xc9, 0x35, 0x6a, 0x74, 0xc4, 0xca, 0x8e, 0x02, 0x21, 0x00, 0xf4,
    0xbd, 0xff, 0x42, 0x05, 0xf4, 0x19, 0x34, 0x75, 0x23, 0xea, 0x92, 0x8d, 0x19, 0x26, 0x3d, 0xad, 0xee, 0x80, 0xaf, 0x0a, 0x61,
    0xe9, 0xa0, 0x30, 0xf9, 0x0f, 0xdb, 0x13, 0x69, 0xf1, 0x3f,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_8019[65] = {
    0x04, 0xdb, 0x34, 0x07, 0x55, 0x64, 0x3e, 0x66, 0xe8, 0xe5, 0x51, 0x0a, 0xb3, 0x35, 0xac, 0x18, 0x7a,
    0x36, 0x91, 0x8e, 0x31, 0xbb, 0xb0, 0x8b, 0x2e, 0xbe, 0xc0, 0x29, 0x65, 0x1b, 0x74, 0xc3, 0xa6, 0x4a,
    0x42, 0xac, 0x17, 0xe4, 0x97, 0x89, 0x75, 0xfa, 0x91, 0x59, 0x8f, 0x1e, 0x74, 0x1b, 0xaf, 0x06, 0x62,
    0x50, 0x5d, 0x34, 0xd7, 0x0d, 0x56, 0xc1, 0x9b, 0x3a, 0xe6, 0xc7, 0x64, 0x3c, 0x88,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_8019[32] = {
    0x5f, 0x40, 0x23, 0x3b, 0x53, 0x8f, 0xf8, 0xd8, 0x26, 0x68, 0xfc, 0x8c, 0x4d, 0x3a, 0x73, 0x9a,
    0x6e, 0x76, 0x9a, 0x63, 0x81, 0x0c, 0x32, 0xe5, 0x1f, 0x9a, 0x02, 0xd0, 0xad, 0x2b, 0x76, 0x8b,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_8019);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_8019);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_8019);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801A
const uint8_t kDevelopmentDAC_Cert_FFF1_801A[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x55, 0x58, 0xd6, 0xd2, 0x2d, 0x4b,
    0x3b, 0xc1, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x41, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x41, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x78, 0xad, 0x5b, 0x69, 0xef, 0x54, 0x50, 0x6c,
    0x97, 0x51, 0xaf, 0x63, 0xfa, 0xaa, 0xd5, 0xd3, 0x19, 0x6a, 0x00, 0x6a, 0xeb, 0xf9, 0x1f, 0x35, 0x73, 0x66, 0xa8, 0x8f, 0x23,
    0xb2, 0x92, 0x20, 0x78, 0x98, 0x8e, 0x56, 0xa2, 0x55, 0x77, 0x8e, 0x44, 0xaa, 0xb0, 0xa5, 0xab, 0x56, 0x90, 0xb3, 0xe1, 0x60,
    0xa1, 0x99, 0x6a, 0xb6, 0x17, 0x52, 0x36, 0xc4, 0xeb, 0x0f, 0x10, 0x4f, 0x9d, 0x12, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xb4, 0x4c, 0x9f, 0xbf,
    0xf3, 0x9b, 0x03, 0xac, 0xa0, 0x10, 0xda, 0x43, 0xdd, 0x68, 0xf1, 0x68, 0x3d, 0x41, 0xab, 0x98, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xbe, 0x45, 0xe8, 0xd9, 0xf0, 0x19, 0x8e, 0x03, 0x18, 0xb6, 0xf5, 0xe8, 0xc5, 0x3e, 0x3b,
    0x9f, 0xa7, 0x6a, 0xea, 0x35, 0x61, 0x1e, 0x5e, 0xc7, 0x82, 0xbe, 0xf9, 0xad, 0x5f, 0x19, 0x22, 0x7b, 0x02, 0x20, 0x43, 0xfa,
    0x45, 0xc3, 0x7d, 0xb0, 0xf7, 0x2c, 0xec, 0x02, 0xa2, 0xe6, 0x42, 0xeb, 0xeb, 0xed, 0x39, 0xd2, 0x17, 0xaf, 0x7e, 0x27, 0x75,
    0x26, 0x17, 0x8e, 0x53, 0xd0, 0xf2, 0x02, 0xed, 0xf9,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_801A[65] = {
    0x04, 0x78, 0xad, 0x5b, 0x69, 0xef, 0x54, 0x50, 0x6c, 0x97, 0x51, 0xaf, 0x63, 0xfa, 0xaa, 0xd5, 0xd3,
    0x19, 0x6a, 0x00, 0x6a, 0xeb, 0xf9, 0x1f, 0x35, 0x73, 0x66, 0xa8, 0x8f, 0x23, 0xb2, 0x92, 0x20, 0x78,
    0x98, 0x8e, 0x56, 0xa2, 0x55, 0x77, 0x8e, 0x44, 0xaa, 0xb0, 0xa5, 0xab, 0x56, 0x90, 0xb3, 0xe1, 0x60,
    0xa1, 0x99, 0x6a, 0xb6, 0x17, 0x52, 0x36, 0xc4, 0xeb, 0x0f, 0x10, 0x4f, 0x9d, 0x12,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_801A[32] = {
    0xba, 0xb9, 0x23, 0x23, 0x30, 0xac, 0xd6, 0xd3, 0x7f, 0xd0, 0xbe, 0x17, 0x57, 0xda, 0x73, 0xa9,
    0x9a, 0x00, 0x8f, 0x99, 0xc5, 0xa6, 0x05, 0x2c, 0xb1, 0x0e, 0xf1, 0x93, 0x5f, 0x95, 0xab, 0x12,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_801A);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_801A);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_801A);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801B
const uint8_t kDevelopmentDAC_Cert_FFF1_801B[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x61, 0x9a, 0x89, 0x0d, 0x6c, 0x3a,
    0x6c, 0xec, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x42, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x42, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xc8, 0x8b, 0xbe, 0x9d, 0x5e, 0xf8, 0xb0, 0x7b,
    0x8f, 0x95, 0x14, 0x65, 0xad, 0xde, 0xb7, 0x2e, 0x79, 0xf1, 0x0d, 0x4a, 0x2f, 0xca, 0x7b, 0xb6, 0xfa, 0xb6, 0x87, 0xeb, 0x22,
    0x8c, 0x78, 0xe6, 0xa8, 0x86, 0xfa, 0x60, 0xfb, 0x45, 0xa9, 0x6f, 0xea, 0x0a, 0xee, 0xbe, 0x9a, 0xb7, 0xfc, 0x48, 0xce, 0x2c,
    0xf8, 0x54, 0xd5, 0x29, 0x1d, 0x42, 0x53, 0xcd, 0x7f, 0x3b, 0xf8, 0xf3, 0x2a, 0x76, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x6f, 0x08, 0x4f, 0x2b,
    0x9a, 0x9c, 0x4b, 0x6d, 0x86, 0x2b, 0x7e, 0xb9, 0xc4, 0x9a, 0x6b, 0xae, 0x2f, 0x7a, 0xb4, 0x42, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xd0, 0x68, 0x7b, 0x68, 0xa6, 0x87, 0xf5, 0x88, 0xed, 0xc4, 0x2e, 0xca, 0xd0, 0x3e, 0x95,
    0x30, 0xb5, 0xec, 0x2d, 0x0e, 0x62, 0x12, 0x98, 0x19, 0x97, 0x27, 0x33, 0x05, 0x20, 0x1b, 0x4b, 0x6a, 0x02, 0x20, 0x0e, 0x34,
    0xda, 0xa7, 0x7a, 0x07, 0x16, 0x17, 0x11, 0x2c, 0xfb, 0xcd, 0xde, 0x75, 0xa5, 0xfa, 0xb2, 0x61, 0xc5, 0xc8, 0xb5, 0xc2, 0x7f,
    0x6a, 0x84, 0x81, 0x2c, 0x30, 0xc9, 0x1c, 0xcc, 0x56,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_801B[65] = {
    0x04, 0xc8, 0x8b, 0xbe, 0x9d, 0x5e, 0xf8, 0xb0, 0x7b, 0x8f, 0x95, 0x14, 0x65, 0xad, 0xde, 0xb7, 0x2e,
    0x79, 0xf1, 0x0d, 0x4a, 0x2f, 0xca, 0x7b, 0xb6, 0xfa, 0xb6, 0x87, 0xeb, 0x22, 0x8c, 0x78, 0xe6, 0xa8,
    0x86, 0xfa, 0x60, 0xfb, 0x45, 0xa9, 0x6f, 0xea, 0x0a, 0xee, 0xbe, 0x9a, 0xb7, 0xfc, 0x48, 0xce, 0x2c,
    0xf8, 0x54, 0xd5, 0x29, 0x1d, 0x42, 0x53, 0xcd, 0x7f, 0x3b, 0xf8, 0xf3, 0x2a, 0x76,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_801B[32] = {
    0x5e, 0x1d, 0x54, 0x34, 0xad, 0x43, 0x58, 0xd7, 0x02, 0xe1, 0xe0, 0xb3, 0x02, 0xd5, 0xd3, 0x18,
    0x15, 0xa1, 0xf2, 0x2e, 0x88, 0x06, 0x80, 0x6d, 0xa7, 0xe7, 0x81, 0xc7, 0x59, 0x13, 0xde, 0x54,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_801B);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_801B);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_801B);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801C
const uint8_t kDevelopmentDAC_Cert_FFF1_801C[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x10, 0x90, 0xb9, 0x25, 0xda, 0x2b,
    0x53, 0x65, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x43, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x43, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x21, 0xe6, 0xe3, 0x95, 0x34, 0x95, 0x6d, 0xa7,
    0x51, 0x60, 0x17, 0xb2, 0x48, 0xb0, 0xb7, 0xc2, 0xb3, 0xcc, 0xf1, 0xb3, 0xa7, 0xe2, 0x92, 0x35, 0xdc, 0xea, 0xfc, 0xc3, 0x41,
    0x5a, 0x8e, 0x16, 0x27, 0xca, 0x5a, 0x41, 0x56, 0x7f, 0x5b, 0xe5, 0xaa, 0x16, 0xf5, 0x69, 0xad, 0x08, 0x25, 0x9e, 0xb9, 0x80,
    0xda, 0x56, 0xb4, 0x26, 0x01, 0x12, 0x6c, 0x46, 0x46, 0x3c, 0xed, 0x5c, 0x56, 0xf4, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x47, 0xb9, 0x53, 0xad,
    0x24, 0x50, 0x47, 0xa0, 0x86, 0x48, 0xe2, 0xc0, 0x4a, 0x25, 0x9d, 0x04, 0xb8, 0xad, 0xc5, 0xa1, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xe4, 0x98, 0x8f, 0xa1, 0xcf, 0x02, 0x77, 0xee, 0x81, 0x3d, 0x20, 0x07, 0x22, 0x7d, 0xfa,
    0x1c, 0x3d, 0xab, 0x83, 0x29, 0xc1, 0xdd, 0x72, 0x0e, 0xdf, 0xff, 0xc6, 0xc3, 0x9e, 0xd9, 0xcd, 0x47, 0x02, 0x20, 0x1a, 0xff,
    0x86, 0xf6, 0x28, 0xba, 0x0e, 0x91, 0xeb, 0xb8, 0x74, 0x4a, 0xae, 0xa5, 0xf7, 0xb4, 0xb3, 0x6c, 0xe1, 0x86, 0x0a, 0xfd, 0xbd,
    0x66, 0x7b, 0xeb, 0x05, 0x86, 0x46, 0x1a, 0x8f, 0x1a,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_801C[65] = {
    0x04, 0x21, 0xe6, 0xe3, 0x95, 0x34, 0x95, 0x6d, 0xa7, 0x51, 0x60, 0x17, 0xb2, 0x48, 0xb0, 0xb7, 0xc2,
    0xb3, 0xcc, 0xf1, 0xb3, 0xa7, 0xe2, 0x92, 0x35, 0xdc, 0xea, 0xfc, 0xc3, 0x41, 0x5a, 0x8e, 0x16, 0x27,
    0xca, 0x5a, 0x41, 0x56, 0x7f, 0x5b, 0xe5, 0xaa, 0x16, 0xf5, 0x69, 0xad, 0x08, 0x25, 0x9e, 0xb9, 0x80,
    0xda, 0x56, 0xb4, 0x26, 0x01, 0x12, 0x6c, 0x46, 0x46, 0x3c, 0xed, 0x5c, 0x56, 0xf4,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_801C[32] = {
    0xf3, 0x49, 0xc7, 0x21, 0x1d, 0x52, 0xfe, 0xa7, 0x73, 0x70, 0xb2, 0xff, 0xbc, 0x10, 0x90, 0xc0,
    0xeb, 0x34, 0x79, 0xb6, 0xa6, 0x9e, 0x98, 0x11, 0xfc, 0xaf, 0x70, 0xba, 0x33, 0x9b, 0x39, 0x65,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_801C);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_801C);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_801C);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801D
const uint8_t kDevelopmentDAC_Cert_FFF1_801D[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x6f, 0x2a, 0x42, 0xc2, 0x9d, 0x3b,
    0x67, 0x7f, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x44, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xfc, 0xb9, 0x60, 0xde, 0x06, 0x18, 0x8e, 0x37,
    0xba, 0xc0, 0x89, 0x8b, 0x80, 0xd1, 0xf9, 0xa1, 0xe7, 0x89, 0xfe, 0xf5, 0xde, 0x72, 0xe5, 0xf3, 0x01, 0x04, 0x26, 0xee, 0x45,
    0x91, 0x07, 0x95, 0xff, 0x33, 0x64, 0x69, 0x4f, 0xc6, 0xb0, 0x1c, 0x0d, 0xf0, 0xc6, 0xd5, 0xe8, 0x94, 0x73, 0xfa, 0x88, 0xca,
    0x66, 0x14, 0x7b, 0x25, 0x5a, 0x5e, 0x13, 0x93, 0x81, 0x1d, 0x37, 0x0c, 0x66, 0x20, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xe8, 0x22, 0xdd, 0x9a,
    0x2d, 0xf8, 0x9f, 0xcf, 0x60, 0x9b, 0xf2, 0x0d, 0xca, 0xb5, 0x77, 0x1f, 0x0d, 0xa8, 0x8c, 0xe3, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xca, 0x05, 0x1b, 0xb9, 0x88, 0x35, 0xbc, 0x6c, 0x3e, 0x87, 0x7e, 0x39, 0x0e, 0x5d, 0x44,
    0xdd, 0xfc, 0xda, 0x53, 0xc2, 0x7e, 0xba, 0x59, 0x4f, 0x0d, 0x38, 0x57, 0xeb, 0x01, 0xf0, 0x37, 0x62, 0x02, 0x21, 0x00, 0x83,
    0xa5, 0xff, 0xec, 0x1c, 0x2f, 0x4d, 0x7b, 0xe8, 0xd1, 0xbc, 0xa2, 0x2b, 0x8f, 0xbd, 0x1b, 0xad, 0xf7, 0xe6, 0x63, 0x7a, 0x8a,
    0xff, 0x26, 0x6d, 0x5f, 0x8c, 0x08, 0x6d, 0xdc, 0xc8, 0x7b,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_801D[65] = {
    0x04, 0xfc, 0xb9, 0x60, 0xde, 0x06, 0x18, 0x8e, 0x37, 0xba, 0xc0, 0x89, 0x8b, 0x80, 0xd1, 0xf9, 0xa1,
    0xe7, 0x89, 0xfe, 0xf5, 0xde, 0x72, 0xe5, 0xf3, 0x01, 0x04, 0x26, 0xee, 0x45, 0x91, 0x07, 0x95, 0xff,
    0x33, 0x64, 0x69, 0x4f, 0xc6, 0xb0, 0x1c, 0x0d, 0xf0, 0xc6, 0xd5, 0xe8, 0x94, 0x73, 0xfa, 0x88, 0xca,
    0x66, 0x14, 0x7b, 0x25, 0x5a, 0x5e, 0x13, 0x93, 0x81, 0x1d, 0x37, 0x0c, 0x66, 0x20,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_801D[32] = {
    0xcb, 0x97, 0xb3, 0x49, 0x2c, 0xed, 0x62, 0xd1, 0xe1, 0xcd, 0x57, 0x19, 0xdd, 0xcc, 0xcd, 0x73,
    0xeb, 0xe0, 0xa2, 0x2b, 0x29, 0x4f, 0x17, 0x85, 0x38, 0xfe, 0x1a, 0xf1, 0xcf, 0x4c, 0x6f, 0xdb,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_801D);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_801D);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_801D);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801E
const uint8_t kDevelopmentDAC_Cert_FFF1_801E[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x48, 0x5c, 0x92, 0xd5, 0xaf, 0x31,
    0xc1, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x45, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x45, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xbd, 0x58, 0xeb, 0x3e, 0xa8, 0x4e, 0x91, 0x0f,
    0xb7, 0xb8, 0xbb, 0x31, 0xfe, 0x7e, 0x6e, 0xcb, 0xf7, 0x32, 0x88, 0xfa, 0xe3, 0xf4, 0xec, 0x44, 0x18, 0x56, 0x68, 0x53, 0xfc,
    0xfd, 0x29, 0x77, 0x8f, 0x5e, 0x98, 0xce, 0x72, 0x76, 0xb3, 0x77, 0x05, 0x75, 0xe8, 0x96, 0xde, 0x9e, 0x0b, 0x09, 0x14, 0xb4,
    0x74, 0xa4, 0x35, 0x48, 0xf1, 0xd3, 0xfd, 0x28, 0xe4, 0xd5, 0x5b, 0xc4, 0xd5, 0x3d, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xd9, 0x0a, 0x72, 0x53,
    0x0f, 0x85, 0xe4, 0x69, 0x0d, 0xcd, 0xee, 0xdd, 0xab, 0xb7, 0x06, 0xc3, 0xba, 0x3a, 0xd4, 0xe0, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xb4, 0x1e, 0xa4, 0x5d, 0xe4, 0xa2, 0x62, 0x35, 0x22, 0x39, 0x5f, 0xcd, 0x7c, 0x30, 0xb7,
    0x8b, 0xe5, 0x7a, 0x5d, 0xaf, 0x0e, 0xcd, 0x15, 0xdd, 0x52, 0xc5, 0x3b, 0x48, 0x19, 0xaf, 0x94, 0x0c, 0x02, 0x21, 0x00, 0xd7,
    0xbd, 0x33, 0x44, 0xc5, 0x93, 0x60, 0xb9, 0x44, 0x23, 0x68, 0xbd, 0x2b, 0xc8, 0xd1, 0xf1, 0xf8, 0xf3, 0xbc, 0xc4, 0x0f, 0x58,
    0xf8, 0x7c, 0x6f, 0x04, 0x53, 0x8e, 0x13, 0x99, 0x39, 0x9b,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_801E[65] = {
    0x04, 0xbd, 0x58, 0xeb, 0x3e, 0xa8, 0x4e, 0x91, 0x0f, 0xb7, 0xb8, 0xbb, 0x31, 0xfe, 0x7e, 0x6e, 0xcb,
    0xf7, 0x32, 0x88, 0xfa, 0xe3, 0xf4, 0xec, 0x44, 0x18, 0x56, 0x68, 0x53, 0xfc, 0xfd, 0x29, 0x77, 0x8f,
    0x5e, 0x98, 0xce, 0x72, 0x76, 0xb3, 0x77, 0x05, 0x75, 0xe8, 0x96, 0xde, 0x9e, 0x0b, 0x09, 0x14, 0xb4,
    0x74, 0xa4, 0x35, 0x48, 0xf1, 0xd3, 0xfd, 0x28, 0xe4, 0xd5, 0x5b, 0xc4, 0xd5, 0x3d,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_801E[32] = {
    0x0e, 0xd0, 0xc8, 0x74, 0x75, 0x87, 0xe3, 0x69, 0xc5, 0x97, 0xcc, 0xd1, 0xb0, 0x4a, 0x40, 0xdd,
    0x03, 0x3b, 0x23, 0xe2, 0x23, 0xc8, 0xfb, 0x0a, 0x5e, 0xd8, 0xb2, 0xaf, 0x41, 0x82, 0xac, 0xa2,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_801E);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_801E);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_801E);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801F
const uint8_t kDevelopmentDAC_Cert_FFF1_801F[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x74, 0xef, 0xa7, 0x97, 0x5e, 0x10,
    0x91, 0x70, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30,
    0x32, 0x30, 0x36, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x46, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x46, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x69, 0xe0, 0xe8, 0x1c, 0x77, 0x34, 0xcd, 0x7a,
    0x1e, 0x4b, 0x02, 0x0d, 0xf5, 0x30, 0x3b, 0xb8, 0x81, 0x6c, 0x21, 0x9d, 0x19, 0x87, 0x69, 0xcf, 0xb6, 0xba, 0x11, 0x26, 0x3f,
    0xd4, 0xa1, 0x8a, 0xa9, 0x97, 0x55, 0x12, 0xf2, 0x9e, 0x60, 0xc6, 0xdc, 0x41, 0xaa, 0xb3, 0x9c, 0x89, 0x62, 0xd5, 0xfc, 0x69,
    0x39, 0x82, 0x73, 0xf0, 0x45, 0x2b, 0x03, 0xc9, 0xdc, 0xf8, 0xd8, 0x8d, 0xdf, 0xd5, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x54, 0x03, 0x71, 0xb6,
    0x5f, 0x5c, 0xf8, 0x96, 0x4f, 0x0a, 0x23, 0x39, 0x5c, 0x62, 0xc4, 0xf6, 0xc8, 0x96, 0x11, 0x96, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4, 0x62,
    0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xcf, 0xde, 0x9c, 0x37, 0x05, 0x66, 0x66, 0x83, 0x92, 0xc5, 0xca, 0x75, 0x18, 0x11, 0x27,
    0x5c, 0x5f, 0x1c, 0x1c, 0x71, 0xc1, 0x75, 0x27, 0x9f, 0xa7, 0xd2, 0x49, 0x90, 0x4a, 0xaf, 0x20, 0x77, 0x02, 0x20, 0x03, 0x1d,
    0x32, 0xdf, 0x4f, 0x9e, 0x17, 0x39, 0x88, 0x11, 0x1d, 0x81, 0x52, 0xa0, 0x35, 0x44, 0x9e, 0xc7, 0x5f, 0x57, 0x9b, 0x12, 0x55,
    0xf9, 0x6c, 0x83, 0x64, 0x7f, 0x90, 0xcc, 0x06, 0x89,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF1_801F[65] = {
    0x04, 0x69, 0xe0, 0xe8, 0x1c, 0x77, 0x34, 0xcd, 0x7a, 0x1e, 0x4b, 0x02, 0x0d, 0xf5, 0x30, 0x3b, 0xb8,
    0x81, 0x6c, 0x21, 0x9d, 0x19, 0x87, 0x69, 0xcf, 0xb6, 0xba, 0x11, 0x26, 0x3f, 0xd4, 0xa1, 0x8a, 0xa9,
    0x97, 0x55, 0x12, 0xf2, 0x9e, 0x60, 0xc6, 0xdc, 0x41, 0xaa, 0xb3, 0x9c, 0x89, 0x62, 0xd5, 0xfc, 0x69,
    0x39, 0x82, 0x73, 0xf0, 0x45, 0x2b, 0x03, 0xc9, 0xdc, 0xf8, 0xd8, 0x8d, 0xdf, 0xd5,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF1_801F[32] = {
    0xdb, 0xbf, 0x93, 0xb4, 0xc8, 0x50, 0x90, 0xd3, 0x43, 0x7e, 0xad, 0x1e, 0x8d, 0x57, 0x01, 0x94,
    0xf9, 0x59, 0xa1, 0x3b, 0x2a, 0xc2, 0xf0, 0x94, 0x49, 0x01, 0x7d, 0xf9, 0x39, 0x9e, 0xf8, 0xed,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF1_801F);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF1_801F);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF1_801F);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8000
const uint8_t kDevelopmentDAC_Cert_FFF2_8000[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x60, 0x7d, 0xdc, 0xfb, 0x54, 0xda,
    0x8c, 0x5d, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x30, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x30, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x7b, 0x39, 0xdb, 0xaa, 0x39, 0x3e, 0xd7, 0x15,
    0x5f, 0x4e, 0x3b, 0x31, 0x55, 0xcf, 0xd8, 0x51, 0xf5, 0xd6, 0x80, 0xc6, 0x3b, 0x2c, 0xe2, 0xef, 0x3d, 0x5b, 0x81, 0x93, 0xf2,
    0x96, 0x3e, 0x5d, 0x07, 0x90, 0x7d, 0x6f, 0xb6, 0x52, 0xf1, 0xb4, 0xe5, 0x06, 0xdb, 0xc2, 0x7f, 0x30, 0xbe, 0x7c, 0xf2, 0x9d,
    0xef, 0xa2, 0x95, 0x36, 0xf6, 0x65, 0xa6, 0xde, 0x56, 0x2d, 0xd5, 0x9a, 0xc6, 0x6b, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xee, 0xae, 0x14, 0xfe,
    0x0f, 0xad, 0x54, 0xd7, 0x84, 0xec, 0xbe, 0x06, 0x02, 0x02, 0x2c, 0xf7, 0xcf, 0x4b, 0xdc, 0xff, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x00, 0xee, 0xc1, 0xf8, 0xc6, 0x0a, 0x17, 0x2d, 0x57, 0x27, 0x01, 0x98, 0x98, 0xc7, 0xbc, 0xd0,
    0xde, 0xa1, 0x2c, 0x76, 0xd3, 0x78, 0x6f, 0x88, 0xc7, 0x09, 0x3b, 0x97, 0xe6, 0xd9, 0x98, 0x95, 0x02, 0x21, 0x00, 0xe2, 0x0e,
    0x99, 0x2c, 0x7e, 0xe0, 0x19, 0x5c, 0xe1, 0x91, 0xae, 0xad, 0x31, 0x6f, 0x40, 0x71, 0x44, 0x23, 0x33, 0xff, 0x83, 0xfc, 0x2e,
    0xfc, 0xee, 0x3b, 0x57, 0xd9, 0x23, 0x95, 0x2e, 0x66,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8000[65] = {
    0x04, 0x7b, 0x39, 0xdb, 0xaa, 0x39, 0x3e, 0xd7, 0x15, 0x5f, 0x4e, 0x3b, 0x31, 0x55, 0xcf, 0xd8, 0x51,
    0xf5, 0xd6, 0x80, 0xc6, 0x3b, 0x2c, 0xe2, 0xef, 0x3d, 0x5b, 0x81, 0x93, 0xf2, 0x96, 0x3e, 0x5d, 0x07,
    0x90, 0x7d, 0x6f, 0xb6, 0x52, 0xf1, 0xb4, 0xe5, 0x06, 0xdb, 0xc2, 0x7f, 0x30, 0xbe, 0x7c, 0xf2, 0x9d,
    0xef, 0xa2, 0x95, 0x36, 0xf6, 0x65, 0xa6, 0xde, 0x56, 0x2d, 0xd5, 0x9a, 0xc6, 0x6b,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8000[32] = {
    0xd5, 0xd6, 0xa3, 0x65, 0x14, 0x36, 0xb1, 0x4c, 0xa3, 0xaf, 0x5f, 0xd0, 0xff, 0x06, 0x16, 0x15,
    0xce, 0xeb, 0x8a, 0x85, 0x0c, 0x7b, 0x21, 0xb5, 0x94, 0xec, 0x90, 0x31, 0x1b, 0x4d, 0xb8, 0x15,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8000);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8000);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8000);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8001
const uint8_t kDevelopmentDAC_Cert_FFF2_8001[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x6c, 0xfc, 0xe4, 0x5d, 0xaa, 0x6b,
    0x0b, 0xb3, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x31, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x4f, 0x80, 0x82, 0x8d, 0x5a, 0xc5, 0x22, 0xa9,
    0x48, 0x04, 0x0d, 0x2e, 0xaf, 0xf7, 0x86, 0xbc, 0xea, 0x76, 0x66, 0x1a, 0x6a, 0xbe, 0x6c, 0x74, 0xf6, 0xaa, 0x80, 0x49, 0x07,
    0x10, 0xa7, 0xbf, 0xd9, 0x6b, 0xec, 0xa9, 0x18, 0x5f, 0xc4, 0x16, 0x0f, 0x2a, 0x55, 0x11, 0x9b, 0x3c, 0x8e, 0x53, 0xe0, 0xa7,
    0x66, 0x6e, 0xf1, 0x2b, 0xc5, 0x5c, 0xf7, 0x2f, 0x44, 0xb6, 0xb0, 0x7c, 0x34, 0x45, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x8d, 0x58, 0x9e, 0x2d,
    0x4d, 0xed, 0xb2, 0x42, 0x95, 0x7f, 0x9d, 0xce, 0x5c, 0x3a, 0x0d, 0xf9, 0x0b, 0x75, 0x1d, 0xcd, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x77, 0x5c, 0x5d, 0x58, 0xf0, 0x3d, 0xb9, 0xa2, 0xa2, 0xcd, 0xab, 0x47, 0xda, 0x4f, 0x21, 0x15,
    0xc8, 0x8f, 0xdc, 0xc1, 0xb5, 0x18, 0x06, 0x6f, 0xa1, 0x11, 0xa9, 0x4e, 0x84, 0x77, 0xc8, 0xa5, 0x02, 0x21, 0x00, 0xc8, 0xee,
    0xd8, 0x81, 0x73, 0x38, 0xe0, 0x51, 0x59, 0x5f, 0x23, 0x39, 0x08, 0xdb, 0xf1, 0x8d, 0x74, 0x6b, 0xd0, 0x14, 0xda, 0x34, 0xa7,
    0x03, 0x74, 0xff, 0xbd, 0xf9, 0x0c, 0x1e, 0xc2, 0x5b,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8001[65] = {
    0x04, 0x4f, 0x80, 0x82, 0x8d, 0x5a, 0xc5, 0x22, 0xa9, 0x48, 0x04, 0x0d, 0x2e, 0xaf, 0xf7, 0x86, 0xbc,
    0xea, 0x76, 0x66, 0x1a, 0x6a, 0xbe, 0x6c, 0x74, 0xf6, 0xaa, 0x80, 0x49, 0x07, 0x10, 0xa7, 0xbf, 0xd9,
    0x6b, 0xec, 0xa9, 0x18, 0x5f, 0xc4, 0x16, 0x0f, 0x2a, 0x55, 0x11, 0x9b, 0x3c, 0x8e, 0x53, 0xe0, 0xa7,
    0x66, 0x6e, 0xf1, 0x2b, 0xc5, 0x5c, 0xf7, 0x2f, 0x44, 0xb6, 0xb0, 0x7c, 0x34, 0x45,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8001[32] = {
    0x93, 0x65, 0x4d, 0x8b, 0x92, 0xd9, 0x12, 0x49, 0x51, 0x6a, 0xb3, 0xd7, 0x38, 0x0c, 0xf6, 0x33,
    0xc2, 0xc8, 0x7e, 0x0c, 0xdf, 0xa9, 0x45, 0x9a, 0xbe, 0x8a, 0x4d, 0x6e, 0x17, 0xaa, 0x89, 0xc4,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8001);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8001);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8001);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8002
const uint8_t kDevelopmentDAC_Cert_FFF2_8002[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x37, 0xf7, 0x7e, 0x87, 0x49, 0xb6,
    0xab, 0x97, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x32, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xe6, 0x6c, 0xaf, 0xaf, 0xe9, 0x26, 0x30, 0x9c,
    0x4b, 0x8c, 0x10, 0xac, 0x3a, 0xe1, 0xd5, 0xd4, 0xb0, 0x55, 0x7c, 0x90, 0xad, 0x11, 0x5d, 0xed, 0x6c, 0x06, 0x08, 0x1a, 0xec,
    0x30, 0x21, 0x30, 0x4d, 0xff, 0xa2, 0xe8, 0x6d, 0xac, 0x6b, 0x5a, 0x1c, 0x8b, 0x8f, 0xba, 0x53, 0xb6, 0xef, 0x5d, 0x10, 0x8c,
    0x38, 0xec, 0x92, 0xf9, 0xf9, 0xf3, 0xd2, 0x4d, 0xb1, 0xb7, 0xb0, 0x8e, 0xb7, 0xdc, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xcd, 0x30, 0xb4, 0x5c,
    0x37, 0xf9, 0xae, 0xf0, 0x0f, 0xa5, 0xb6, 0xe7, 0x71, 0x55, 0x37, 0x84, 0xc3, 0xa4, 0xc4, 0x63, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0x91, 0x4c, 0x5b, 0xdd, 0x0d, 0xae, 0xd6, 0x6e, 0x10, 0x84, 0x02, 0xeb, 0x6f, 0xaa, 0xca,
    0x14, 0x3c, 0x8d, 0xc2, 0xba, 0x4c, 0x2e, 0xb4, 0x50, 0x9e, 0x7d, 0x69, 0x25, 0x74, 0x2a, 0x99, 0xfe, 0x02, 0x20, 0x62, 0x95,
    0x5b, 0x42, 0x15, 0x53, 0x15, 0xeb, 0xf1, 0x83, 0x91, 0x4f, 0x50, 0x8d, 0x14, 0xc9, 0x31, 0x87, 0x50, 0x97, 0xa6, 0xf6, 0x76,
    0x1c, 0x60, 0x5d, 0x8a, 0xac, 0x6e, 0xd9, 0xae, 0xaa,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8002[65] = {
    0x04, 0xe6, 0x6c, 0xaf, 0xaf, 0xe9, 0x26, 0x30, 0x9c, 0x4b, 0x8c, 0x10, 0xac, 0x3a, 0xe1, 0xd5, 0xd4,
    0xb0, 0x55, 0x7c, 0x90, 0xad, 0x11, 0x5d, 0xed, 0x6c, 0x06, 0x08, 0x1a, 0xec, 0x30, 0x21, 0x30, 0x4d,
    0xff, 0xa2, 0xe8, 0x6d, 0xac, 0x6b, 0x5a, 0x1c, 0x8b, 0x8f, 0xba, 0x53, 0xb6, 0xef, 0x5d, 0x10, 0x8c,
    0x38, 0xec, 0x92, 0xf9, 0xf9, 0xf3, 0xd2, 0x4d, 0xb1, 0xb7, 0xb0, 0x8e, 0xb7, 0xdc,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8002[32] = {
    0x4e, 0xee, 0x34, 0xb2, 0xa9, 0x76, 0x96, 0xa5, 0x48, 0x4f, 0xb4, 0xfb, 0xca, 0xf3, 0x5d, 0xb5,
    0x79, 0xbc, 0x22, 0x4a, 0x59, 0x8c, 0xf5, 0xca, 0x37, 0x21, 0x43, 0x5e, 0x8c, 0xf4, 0x73, 0x57,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8002);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8002);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8002);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8003
const uint8_t kDevelopmentDAC_Cert_FFF2_8003[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x62, 0xe7, 0xc3, 0x52, 0x31, 0x54,
    0x61, 0xb7, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x33, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x7f, 0xe1, 0x64, 0x61, 0x3c, 0xd4, 0xd0, 0x94,
    0xd3, 0xf1, 0x50, 0xe9, 0xe7, 0xa5, 0x21, 0x57, 0xb5, 0xa1, 0x89, 0x70, 0xda, 0xf2, 0x61, 0x34, 0xa5, 0xbe, 0xcd, 0x8a, 0x8c,
    0xa5, 0xe4, 0xa2, 0xbb, 0x9c, 0xba, 0x99, 0x69, 0xa5, 0xe9, 0x4f, 0x4b, 0x35, 0xfb, 0x9a, 0x16, 0x89, 0xfc, 0x90, 0xe0, 0xa4,
    0x4f, 0x3d, 0xaf, 0xa9, 0x07, 0x60, 0x2e, 0x13, 0x70, 0xeb, 0x88, 0xd4, 0xca, 0xe1, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x2c, 0xff, 0xa0, 0xbd,
    0x88, 0xef, 0x51, 0x67, 0xfd, 0xcc, 0x2e, 0xf8, 0x94, 0x07, 0xf4, 0x25, 0xfd, 0x7e, 0x93, 0xec, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x08, 0x83, 0x22, 0x7a, 0xaa, 0x52, 0x79, 0x08, 0x3e, 0xb6, 0xfd, 0xb3, 0x93, 0xbb, 0x8f, 0x74,
    0x0b, 0x5e, 0xcc, 0x8c, 0xa3, 0x71, 0xeb, 0x43, 0x36, 0x1e, 0xd6, 0x24, 0x7c, 0x15, 0x31, 0x7d, 0x02, 0x21, 0x00, 0xd4, 0xa0,
    0x9f, 0x8d, 0x25, 0xa6, 0xf2, 0xa0, 0xf7, 0xcc, 0xa6, 0xad, 0xe7, 0xad, 0xba, 0x22, 0x36, 0xe5, 0xaa, 0x54, 0x11, 0xec, 0x46,
    0xf2, 0xea, 0xa5, 0x51, 0x4b, 0x92, 0xd5, 0x6d, 0x2c,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8003[65] = {
    0x04, 0x7f, 0xe1, 0x64, 0x61, 0x3c, 0xd4, 0xd0, 0x94, 0xd3, 0xf1, 0x50, 0xe9, 0xe7, 0xa5, 0x21, 0x57,
    0xb5, 0xa1, 0x89, 0x70, 0xda, 0xf2, 0x61, 0x34, 0xa5, 0xbe, 0xcd, 0x8a, 0x8c, 0xa5, 0xe4, 0xa2, 0xbb,
    0x9c, 0xba, 0x99, 0x69, 0xa5, 0xe9, 0x4f, 0x4b, 0x35, 0xfb, 0x9a, 0x16, 0x89, 0xfc, 0x90, 0xe0, 0xa4,
    0x4f, 0x3d, 0xaf, 0xa9, 0x07, 0x60, 0x2e, 0x13, 0x70, 0xeb, 0x88, 0xd4, 0xca, 0xe1,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8003[32] = {
    0x5c, 0x3e, 0xbf, 0x44, 0x5e, 0x8b, 0x52, 0x7f, 0xf8, 0x14, 0x57, 0x0a, 0x19, 0x13, 0x9c, 0x48,
    0x7d, 0x49, 0x3b, 0x0b, 0x73, 0x1a, 0xc5, 0x14, 0x0a, 0x78, 0x8b, 0x94, 0xb7, 0x43, 0x53, 0x60,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8003);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8003);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8003);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8004
const uint8_t kDevelopmentDAC_Cert_FFF2_8004[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x65, 0x11, 0x67, 0x32, 0x53, 0x2b,
    0xc2, 0x74, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x34, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x34, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xf8, 0x44, 0xee, 0x5a, 0x07, 0x7c, 0x27, 0x9b,
    0x82, 0x0c, 0x16, 0xf7, 0x0e, 0xa8, 0x45, 0x1f, 0x1f, 0xac, 0xce, 0xcb, 0x8a, 0x14, 0x45, 0x3a, 0xab, 0xff, 0xbd, 0x1f, 0x41,
    0x19, 0xe5, 0xde, 0x91, 0x70, 0x31, 0x8d, 0x8e, 0xaa, 0x10, 0x02, 0x5b, 0x44, 0xda, 0x5b, 0xc8, 0x4e, 0x89, 0xac, 0xbc, 0x6f,
    0xb9, 0x31, 0xa1, 0x47, 0x50, 0x66, 0x5b, 0x48, 0x88, 0x1f, 0x82, 0xf0, 0xd6, 0x34, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xbc, 0xb0, 0x7a, 0x1e,
    0xcb, 0x2e, 0xcb, 0x6e, 0xc9, 0x82, 0x4e, 0x3d, 0xc6, 0x54, 0xb9, 0x18, 0x51, 0x22, 0x76, 0x06, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xa0, 0x61, 0xf3, 0xc9, 0x04, 0xf1, 0x3d, 0xe0, 0x68, 0x29, 0xb6, 0xfd, 0x36, 0xf0, 0x9d,
    0xfc, 0x74, 0x63, 0xa1, 0x63, 0x47, 0x3e, 0x26, 0x0b, 0xcb, 0xb9, 0x28, 0xf5, 0x18, 0x2c, 0x19, 0x36, 0x02, 0x21, 0x00, 0xe6,
    0xc1, 0x18, 0xe6, 0xb0, 0x2f, 0x7b, 0x5e, 0x7d, 0x19, 0x2b, 0xef, 0x19, 0x94, 0x0a, 0x86, 0x79, 0x36, 0xc0, 0xab, 0x7e, 0xe4,
    0x82, 0x11, 0x2b, 0x52, 0x74, 0x75, 0x94, 0xbb, 0x05, 0xbd,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8004[65] = {
    0x04, 0xf8, 0x44, 0xee, 0x5a, 0x07, 0x7c, 0x27, 0x9b, 0x82, 0x0c, 0x16, 0xf7, 0x0e, 0xa8, 0x45, 0x1f,
    0x1f, 0xac, 0xce, 0xcb, 0x8a, 0x14, 0x45, 0x3a, 0xab, 0xff, 0xbd, 0x1f, 0x41, 0x19, 0xe5, 0xde, 0x91,
    0x70, 0x31, 0x8d, 0x8e, 0xaa, 0x10, 0x02, 0x5b, 0x44, 0xda, 0x5b, 0xc8, 0x4e, 0x89, 0xac, 0xbc, 0x6f,
    0xb9, 0x31, 0xa1, 0x47, 0x50, 0x66, 0x5b, 0x48, 0x88, 0x1f, 0x82, 0xf0, 0xd6, 0x34,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8004[32] = {
    0x28, 0xf5, 0x27, 0x33, 0x3e, 0x9b, 0xba, 0x3c, 0xce, 0x25, 0xef, 0xc8, 0x3d, 0x03, 0xdf, 0xeb,
    0x51, 0xc8, 0xe8, 0xbc, 0xfc, 0x9c, 0xf6, 0xf5, 0x86, 0x9c, 0xc5, 0x0a, 0xa1, 0x26, 0xf0, 0xf3,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8004);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8004);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8004);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8005
const uint8_t kDevelopmentDAC_Cert_FFF2_8005[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x73, 0xa2, 0x1d, 0x0e, 0x54, 0x33,
    0x71, 0x3a, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x35, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x35, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xb5, 0xd4, 0xc0, 0x26, 0x06, 0x50, 0x86, 0x6d,
    0x76, 0xfb, 0x0e, 0x54, 0x72, 0xa7, 0xa9, 0x9f, 0x76, 0xc4, 0xac, 0xb6, 0xe4, 0x0d, 0x31, 0xec, 0x3e, 0xa6, 0x45, 0x35, 0x2e,
    0x5f, 0xe8, 0x41, 0x49, 0x34, 0x69, 0xbe, 0x36, 0x5a, 0xb6, 0xec, 0x2e, 0x9e, 0x4b, 0x58, 0xfe, 0x39, 0x77, 0xbe, 0x10, 0x7b,
    0xc0, 0xa3, 0xb2, 0x93, 0x37, 0x30, 0xa1, 0x24, 0xd9, 0x11, 0xf8, 0x19, 0xce, 0x2e, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x92, 0xb6, 0x50, 0x19,
    0x78, 0x04, 0x24, 0x4c, 0x9a, 0x39, 0x91, 0xd1, 0x0b, 0x44, 0x01, 0xc3, 0xc9, 0xa8, 0x7f, 0xb0, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x5d, 0xbb, 0x9f, 0x81, 0x4c, 0x6f, 0xdb, 0xba, 0xac, 0x29, 0x1c, 0x8f, 0x85, 0x6e, 0x97, 0xe3,
    0xb2, 0x08, 0xca, 0x1a, 0x47, 0xe8, 0xba, 0x65, 0x39, 0x98, 0xbc, 0x3c, 0x51, 0x76, 0x95, 0xf5, 0x02, 0x20, 0x4f, 0x30, 0xd4,
    0xb5, 0x10, 0xcc, 0x4b, 0x62, 0x17, 0xc0, 0x67, 0xe1, 0x60, 0xba, 0xba, 0x5a, 0xa8, 0x6f, 0x12, 0xf7, 0xcf, 0x68, 0x5d, 0x33,
    0xab, 0xe3, 0x6f, 0x63, 0x1a, 0x49, 0x1b, 0x3a,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8005[65] = {
    0x04, 0xb5, 0xd4, 0xc0, 0x26, 0x06, 0x50, 0x86, 0x6d, 0x76, 0xfb, 0x0e, 0x54, 0x72, 0xa7, 0xa9, 0x9f,
    0x76, 0xc4, 0xac, 0xb6, 0xe4, 0x0d, 0x31, 0xec, 0x3e, 0xa6, 0x45, 0x35, 0x2e, 0x5f, 0xe8, 0x41, 0x49,
    0x34, 0x69, 0xbe, 0x36, 0x5a, 0xb6, 0xec, 0x2e, 0x9e, 0x4b, 0x58, 0xfe, 0x39, 0x77, 0xbe, 0x10, 0x7b,
    0xc0, 0xa3, 0xb2, 0x93, 0x37, 0x30, 0xa1, 0x24, 0xd9, 0x11, 0xf8, 0x19, 0xce, 0x2e,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8005[32] = {
    0xd2, 0x54, 0x77, 0x2b, 0x69, 0x10, 0x90, 0xdd, 0x31, 0x17, 0x49, 0x0b, 0x88, 0x82, 0x68, 0x4b,
    0x20, 0x65, 0x72, 0x63, 0x10, 0x80, 0xb5, 0xcd, 0x70, 0xd1, 0x36, 0xbb, 0x4d, 0x2a, 0xa3, 0x13,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8005);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8005);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8005);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8006
const uint8_t kDevelopmentDAC_Cert_FFF2_8006[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x05, 0xfd, 0x55, 0x73, 0xfc, 0x38,
    0xf6, 0x11, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x36, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x36, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x6a, 0x81, 0x6a, 0x36, 0x1a, 0xab, 0xc5, 0x62,
    0x90, 0x47, 0xe6, 0xb7, 0xef, 0xb2, 0xc2, 0xa4, 0x64, 0x95, 0xa6, 0x78, 0x92, 0x20, 0x71, 0x8b, 0x6f, 0x47, 0x77, 0x07, 0xfb,
    0x52, 0x98, 0xe9, 0xe3, 0x31, 0x5a, 0x4b, 0x9c, 0xc7, 0xa7, 0x8b, 0x60, 0xd6, 0x38, 0xe0, 0x2a, 0x3b, 0xa5, 0x7a, 0x6c, 0x93,
    0xfe, 0x94, 0x89, 0x68, 0xef, 0x04, 0x1f, 0xb9, 0x7b, 0xc2, 0xce, 0x99, 0x1e, 0x50, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x88, 0x39, 0x79, 0xf1,
    0xd2, 0xd7, 0x20, 0x23, 0x15, 0x4d, 0xdf, 0x08, 0x0f, 0x98, 0x69, 0x51, 0x5d, 0x28, 0x97, 0x6b, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x0a, 0xee, 0xc6, 0xb2, 0x18, 0x96, 0x47, 0xd5, 0xb1, 0x02, 0x95, 0xbe, 0xcb, 0xd8, 0xa4, 0x89,
    0x39, 0x44, 0x39, 0x4d, 0x2c, 0x13, 0x62, 0x3d, 0x6a, 0xc6, 0xab, 0x0a, 0x2a, 0x58, 0x6e, 0x3c, 0x02, 0x20, 0x5e, 0x2b, 0xd5,
    0x19, 0xb6, 0x54, 0xb7, 0xab, 0xf3, 0xe7, 0x11, 0x53, 0x9d, 0x25, 0x65, 0x3f, 0x33, 0x10, 0xb9, 0xe2, 0x31, 0x2a, 0x48, 0xd3,
    0x81, 0xe5, 0x41, 0x97, 0x45, 0xe9, 0x71, 0x74,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8006[65] = {
    0x04, 0x6a, 0x81, 0x6a, 0x36, 0x1a, 0xab, 0xc5, 0x62, 0x90, 0x47, 0xe6, 0xb7, 0xef, 0xb2, 0xc2, 0xa4,
    0x64, 0x95, 0xa6, 0x78, 0x92, 0x20, 0x71, 0x8b, 0x6f, 0x47, 0x77, 0x07, 0xfb, 0x52, 0x98, 0xe9, 0xe3,
    0x31, 0x5a, 0x4b, 0x9c, 0xc7, 0xa7, 0x8b, 0x60, 0xd6, 0x38, 0xe0, 0x2a, 0x3b, 0xa5, 0x7a, 0x6c, 0x93,
    0xfe, 0x94, 0x89, 0x68, 0xef, 0x04, 0x1f, 0xb9, 0x7b, 0xc2, 0xce, 0x99, 0x1e, 0x50,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8006[32] = {
    0xe4, 0x35, 0xb9, 0x06, 0x09, 0x25, 0x1f, 0xbc, 0xed, 0x19, 0xed, 0x67, 0xe5, 0x6d, 0x03, 0xaf,
    0xc9, 0x15, 0xf1, 0x13, 0xa8, 0x7a, 0x09, 0xc8, 0x1b, 0x7e, 0xf2, 0xe1, 0x72, 0x20, 0xe4, 0x79,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8006);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8006);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8006);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8007
const uint8_t kDevelopmentDAC_Cert_FFF2_8007[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x1d, 0xd7, 0x91, 0xe8, 0x31, 0x4a,
    0xde, 0x93, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x37, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x37, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x56, 0xc0, 0x98, 0x13, 0x83, 0x59, 0x1d, 0x48,
    0x15, 0xc7, 0x0f, 0xd2, 0x35, 0x17, 0x38, 0xf3, 0xb6, 0x2e, 0x09, 0xdb, 0xee, 0xa3, 0xce, 0x5d, 0x05, 0x59, 0xd3, 0xaf, 0xe7,
    0xab, 0xec, 0x9d, 0xbe, 0xd7, 0xb4, 0x14, 0x25, 0xf8, 0x90, 0x20, 0x37, 0xa9, 0xd5, 0xb5, 0x7c, 0x4c, 0x27, 0x6a, 0xa9, 0x88,
    0x00, 0x73, 0x7e, 0xe1, 0xc1, 0x35, 0x63, 0x66, 0x32, 0x04, 0x69, 0x70, 0x42, 0x48, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xcb, 0x40, 0xe6, 0x29,
    0x95, 0x41, 0x77, 0x5d, 0x1b, 0x57, 0x41, 0x7a, 0xaf, 0xb6, 0xdb, 0xaa, 0x3b, 0x70, 0x63, 0x93, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x19, 0x6a, 0x0b, 0xa8, 0xa1, 0x2d, 0x02, 0x27, 0x6b, 0x5f, 0x42, 0xde, 0xe0, 0x1e, 0xb1, 0xa0,
    0x6d, 0xfb, 0x6c, 0x5c, 0xb4, 0x65, 0xec, 0x4c, 0xc9, 0x9d, 0x88, 0x0d, 0xe0, 0x68, 0x1b, 0x02, 0x02, 0x21, 0x00, 0xba, 0x87,
    0x35, 0x55, 0x9c, 0x18, 0x4c, 0x77, 0x1f, 0x4d, 0x8b, 0xb6, 0xff, 0x36, 0x48, 0xbf, 0xd3, 0x52, 0x75, 0x83, 0x04, 0xd6, 0x58,
    0x5f, 0xc3, 0x1b, 0x76, 0x51, 0x51, 0xf9, 0x86, 0x39,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8007[65] = {
    0x04, 0x56, 0xc0, 0x98, 0x13, 0x83, 0x59, 0x1d, 0x48, 0x15, 0xc7, 0x0f, 0xd2, 0x35, 0x17, 0x38, 0xf3,
    0xb6, 0x2e, 0x09, 0xdb, 0xee, 0xa3, 0xce, 0x5d, 0x05, 0x59, 0xd3, 0xaf, 0xe7, 0xab, 0xec, 0x9d, 0xbe,
    0xd7, 0xb4, 0x14, 0x25, 0xf8, 0x90, 0x20, 0x37, 0xa9, 0xd5, 0xb5, 0x7c, 0x4c, 0x27, 0x6a, 0xa9, 0x88,
    0x00, 0x73, 0x7e, 0xe1, 0xc1, 0x35, 0x63, 0x66, 0x32, 0x04, 0x69, 0x70, 0x42, 0x48,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8007[32] = {
    0x53, 0xf1, 0xab, 0x10, 0xe6, 0xa7, 0x97, 0x4e, 0xae, 0x31, 0x04, 0xb1, 0x5c, 0x65, 0x46, 0xf1,
    0x38, 0x4c, 0xd3, 0x6a, 0x50, 0x78, 0xc8, 0xe5, 0x1e, 0x65, 0xeb, 0x38, 0x06, 0x0a, 0xf4, 0xa1,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8007);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8007);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8007);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8008
const uint8_t kDevelopmentDAC_Cert_FFF2_8008[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x02, 0x6e, 0x54, 0x7c, 0xb2, 0xb5,
    0xa5, 0x83, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x38, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x38, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x52, 0x74, 0xc7, 0x1e, 0x56, 0x96, 0x91, 0x81,
    0x97, 0x04, 0xc9, 0x36, 0x3e, 0xaf, 0x13, 0x21, 0x42, 0x0d, 0x99, 0x64, 0x93, 0xcc, 0x2f, 0xf7, 0x9d, 0xd5, 0x4d, 0x48, 0xce,
    0x19, 0xbe, 0xd2, 0x65, 0x6a, 0xe7, 0xf9, 0xdd, 0xa6, 0x71, 0x29, 0x17, 0x91, 0x4b, 0x74, 0xe9, 0x16, 0xa1, 0x3c, 0x76, 0xe5,
    0x56, 0x63, 0xb3, 0xd9, 0x9d, 0xb8, 0x01, 0x11, 0x70, 0x56, 0x9d, 0x73, 0xec, 0xa4, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x8a, 0x87, 0xfc, 0xd4,
    0x33, 0x97, 0x83, 0x4a, 0xc1, 0xaa, 0x30, 0xe3, 0x40, 0xcf, 0xcc, 0xbf, 0xeb, 0x57, 0xea, 0x5b, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x0b, 0x21, 0x53, 0xf4, 0xa9, 0xc4, 0xde, 0xba, 0x0e, 0x48, 0xd6, 0x64, 0xe8, 0xc3, 0xc8, 0x23,
    0x4f, 0xf7, 0x97, 0x66, 0xa5, 0x1e, 0x10, 0xcf, 0x96, 0xdb, 0x18, 0xf8, 0xc2, 0x3b, 0xf1, 0xb3, 0x02, 0x21, 0x00, 0x8a, 0x7c,
    0x00, 0xbe, 0x52, 0x99, 0x0d, 0x11, 0x9b, 0xd4, 0x07, 0xdc, 0xc1, 0x01, 0xb8, 0x59, 0x87, 0x44, 0x51, 0xd0, 0x30, 0x18, 0x94,
    0x08, 0x7b, 0x4a, 0xfb, 0xfb, 0xe6, 0xa2, 0x36, 0xf0,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8008[65] = {
    0x04, 0x52, 0x74, 0xc7, 0x1e, 0x56, 0x96, 0x91, 0x81, 0x97, 0x04, 0xc9, 0x36, 0x3e, 0xaf, 0x13, 0x21,
    0x42, 0x0d, 0x99, 0x64, 0x93, 0xcc, 0x2f, 0xf7, 0x9d, 0xd5, 0x4d, 0x48, 0xce, 0x19, 0xbe, 0xd2, 0x65,
    0x6a, 0xe7, 0xf9, 0xdd, 0xa6, 0x71, 0x29, 0x17, 0x91, 0x4b, 0x74, 0xe9, 0x16, 0xa1, 0x3c, 0x76, 0xe5,
    0x56, 0x63, 0xb3, 0xd9, 0x9d, 0xb8, 0x01, 0x11, 0x70, 0x56, 0x9d, 0x73, 0xec, 0xa4,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8008[32] = {
    0xb7, 0x10, 0x47, 0xb0, 0xbb, 0xdb, 0xc7, 0x22, 0x51, 0xba, 0xd3, 0xe3, 0x6d, 0xfe, 0x5c, 0xac,
    0xf9, 0x0f, 0xca, 0xae, 0x26, 0xe2, 0xf1, 0x57, 0x7b, 0xd1, 0xb3, 0xca, 0x3c, 0xbb, 0xb8, 0xcf,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8008);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8008);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8008);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8009
const uint8_t kDevelopmentDAC_Cert_FFF2_8009[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x3d, 0xd8, 0x41, 0x54, 0x03, 0x0f,
    0x86, 0xd4, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x39, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x39, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xfb, 0x5c, 0x85, 0x0a, 0xd5, 0x9b, 0xc1, 0xcb,
    0x7f, 0x95, 0xa4, 0x1c, 0xa6, 0x5b, 0x11, 0x5b, 0x7d, 0x16, 0x75, 0x97, 0xd4, 0x63, 0x3a, 0x02, 0x33, 0x2c, 0x76, 0x96, 0x53,
    0xff, 0xeb, 0x6d, 0x6f, 0x73, 0x40, 0x21, 0xa8, 0x85, 0xe1, 0xdb, 0xf6, 0x11, 0x34, 0xe4, 0x5f, 0xa3, 0xf1, 0xcf, 0xcd, 0x30,
    0xee, 0x8b, 0x01, 0x31, 0x2a, 0x94, 0xf1, 0x76, 0x41, 0xd2, 0xc0, 0x71, 0xb9, 0x7d, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x6f, 0xb3, 0xa1, 0xbd,
    0x02, 0xa6, 0xa0, 0x28, 0x92, 0xf9, 0x53, 0xbb, 0x25, 0xfe, 0x06, 0x5b, 0x81, 0x95, 0xc0, 0xcb, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xe5, 0x7b, 0x68, 0xcd, 0x17, 0x5b, 0x18, 0x2a, 0xc3, 0x94, 0xbf, 0x85, 0x37, 0x7f, 0x8b,
    0xa0, 0x9c, 0x0e, 0x9d, 0x72, 0xe8, 0xd0, 0x05, 0x6d, 0x2f, 0x23, 0xb2, 0x26, 0xf9, 0x5c, 0x36, 0x57, 0x02, 0x21, 0x00, 0xc3,
    0xbd, 0xb3, 0xe0, 0xc9, 0x9f, 0x52, 0x06, 0xd2, 0x9b, 0x29, 0x91, 0x7d, 0xe1, 0xc1, 0xcc, 0x07, 0xe7, 0x24, 0x0d, 0xd7, 0x2c,
    0x1b, 0xb2, 0x5c, 0x99, 0x12, 0xf9, 0x45, 0x30, 0xc8, 0x5a,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8009[65] = {
    0x04, 0xfb, 0x5c, 0x85, 0x0a, 0xd5, 0x9b, 0xc1, 0xcb, 0x7f, 0x95, 0xa4, 0x1c, 0xa6, 0x5b, 0x11, 0x5b,
    0x7d, 0x16, 0x75, 0x97, 0xd4, 0x63, 0x3a, 0x02, 0x33, 0x2c, 0x76, 0x96, 0x53, 0xff, 0xeb, 0x6d, 0x6f,
    0x73, 0x40, 0x21, 0xa8, 0x85, 0xe1, 0xdb, 0xf6, 0x11, 0x34, 0xe4, 0x5f, 0xa3, 0xf1, 0xcf, 0xcd, 0x30,
    0xee, 0x8b, 0x01, 0x31, 0x2a, 0x94, 0xf1, 0x76, 0x41, 0xd2, 0xc0, 0x71, 0xb9, 0x7d,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8009[32] = {
    0xb4, 0x35, 0x9a, 0xce, 0x54, 0x2c, 0xac, 0x9a, 0xc6, 0xe3, 0x4a, 0xad, 0xa2, 0x09, 0xbb, 0xb7,
    0xe6, 0x91, 0x12, 0x60, 0xfa, 0xeb, 0x47, 0x42, 0xbb, 0x56, 0x32, 0xe5, 0xbf, 0xfe, 0x2f, 0x74,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8009);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8009);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8009);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800A
const uint8_t kDevelopmentDAC_Cert_FFF2_800A[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x72, 0x65, 0xa7, 0xd8, 0x44, 0x77,
    0xd2, 0x64, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x41, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x41, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x19, 0xb6, 0x16, 0xf3, 0x43, 0x4c, 0x12, 0x59,
    0xcb, 0x60, 0xf6, 0x29, 0x00, 0x3e, 0x96, 0x1c, 0x0a, 0x14, 0x0d, 0x5a, 0xc3, 0xdd, 0x70, 0xec, 0x96, 0xb7, 0x17, 0xc9, 0x9c,
    0xb0, 0x66, 0x3e, 0x1b, 0xb9, 0x3d, 0x28, 0xb0, 0xcc, 0x08, 0xee, 0xd7, 0x9a, 0xff, 0x6c, 0x42, 0x79, 0x2e, 0xde, 0xdb, 0xa8,
    0x22, 0xba, 0xca, 0x52, 0x8a, 0x06, 0xbb, 0x7a, 0xa9, 0x42, 0xc2, 0xdc, 0xff, 0x1c, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x45, 0xdc, 0x53, 0x50,
    0xce, 0x2c, 0xae, 0xcb, 0xcc, 0x50, 0x4a, 0x53, 0x4b, 0x04, 0x28, 0x14, 0x7a, 0x15, 0xd8, 0x35, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x10, 0x1d, 0x16, 0x31, 0x8c, 0xf8, 0xde, 0xe3, 0x2a, 0xba, 0xca, 0xa4, 0x52, 0x46, 0xf5, 0x8b,
    0x35, 0x6e, 0x15, 0xb6, 0x39, 0x16, 0xa0, 0x43, 0x4b, 0x31, 0xcf, 0x23, 0x97, 0x14, 0x95, 0x5f, 0x02, 0x20, 0x69, 0x7c, 0x40,
    0xe1, 0xfb, 0xa2, 0x22, 0xc4, 0x74, 0xcf, 0x2c, 0x92, 0x37, 0xb4, 0x5e, 0x50, 0xcf, 0xf7, 0x87, 0x1e, 0x67, 0x38, 0x7b, 0x1a,
    0xfd, 0xb4, 0x9e, 0x4d, 0xbf, 0x57, 0xeb, 0xfe,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_800A[65] = {
    0x04, 0x19, 0xb6, 0x16, 0xf3, 0x43, 0x4c, 0x12, 0x59, 0xcb, 0x60, 0xf6, 0x29, 0x00, 0x3e, 0x96, 0x1c,
    0x0a, 0x14, 0x0d, 0x5a, 0xc3, 0xdd, 0x70, 0xec, 0x96, 0xb7, 0x17, 0xc9, 0x9c, 0xb0, 0x66, 0x3e, 0x1b,
    0xb9, 0x3d, 0x28, 0xb0, 0xcc, 0x08, 0xee, 0xd7, 0x9a, 0xff, 0x6c, 0x42, 0x79, 0x2e, 0xde, 0xdb, 0xa8,
    0x22, 0xba, 0xca, 0x52, 0x8a, 0x06, 0xbb, 0x7a, 0xa9, 0x42, 0xc2, 0xdc, 0xff, 0x1c,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_800A[32] = {
    0x55, 0x2d, 0xf7, 0xbf, 0x75, 0x23, 0x53, 0x88, 0x11, 0x9f, 0x85, 0x4c, 0x8f, 0x0f, 0xd9, 0xb5,
    0xaf, 0xc0, 0xcf, 0x86, 0xd4, 0x8a, 0xe9, 0xe8, 0x6a, 0x50, 0x62, 0x3c, 0xb3, 0x8f, 0xb0, 0xc1,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_800A);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_800A);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_800A);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800B
const uint8_t kDevelopmentDAC_Cert_FFF2_800B[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x75, 0x76, 0x48, 0x3b, 0xca, 0xda,
    0x0f, 0x0a, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x42, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x42, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xeb, 0xc5, 0x10, 0xa1, 0x46, 0x3d, 0x11, 0xe4,
    0x44, 0x57, 0x09, 0xba, 0x96, 0xab, 0x5c, 0x35, 0xdf, 0xf7, 0x30, 0xc5, 0xcb, 0x0c, 0x37, 0x0e, 0x20, 0xbb, 0x1b, 0xb6, 0x2e,
    0x2d, 0x2a, 0x64, 0xaa, 0xc1, 0x91, 0xe9, 0x76, 0xda, 0x1f, 0x6d, 0x64, 0xe8, 0xd5, 0x6a, 0x6f, 0xf1, 0x2e, 0x39, 0xb2, 0x45,
    0x69, 0x14, 0x9b, 0x23, 0xee, 0x30, 0x4c, 0xbd, 0xeb, 0x01, 0x1f, 0x44, 0xb5, 0x91, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x7a, 0x5d, 0x20, 0x90,
    0x62, 0xe7, 0xe3, 0x40, 0xe8, 0xbc, 0xa3, 0xb0, 0x78, 0x10, 0xe4, 0x40, 0xeb, 0x41, 0x19, 0x31, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x0a, 0x0d, 0x3c, 0x92, 0x97, 0x4a, 0xdb, 0x11, 0x6b, 0x87, 0xd6, 0x08, 0x0e, 0x00, 0x72, 0xb8,
    0xbf, 0x42, 0x6c, 0xe6, 0x2b, 0xee, 0x3e, 0x48, 0x2c, 0xd4, 0x5d, 0xa3, 0x81, 0xc5, 0xa6, 0x5c, 0x02, 0x21, 0x00, 0xf4, 0xa1,
    0xf0, 0xc9, 0x1c, 0x77, 0x24, 0xc8, 0xc2, 0x8f, 0x38, 0x82, 0x45, 0xf9, 0xb8, 0xc8, 0xd3, 0xe3, 0xad, 0x35, 0x2a, 0xee, 0x86,
    0x56, 0x8f, 0xf8, 0x60, 0x40, 0x83, 0xb9, 0x0f, 0x43,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_800B[65] = {
    0x04, 0xeb, 0xc5, 0x10, 0xa1, 0x46, 0x3d, 0x11, 0xe4, 0x44, 0x57, 0x09, 0xba, 0x96, 0xab, 0x5c, 0x35,
    0xdf, 0xf7, 0x30, 0xc5, 0xcb, 0x0c, 0x37, 0x0e, 0x20, 0xbb, 0x1b, 0xb6, 0x2e, 0x2d, 0x2a, 0x64, 0xaa,
    0xc1, 0x91, 0xe9, 0x76, 0xda, 0x1f, 0x6d, 0x64, 0xe8, 0xd5, 0x6a, 0x6f, 0xf1, 0x2e, 0x39, 0xb2, 0x45,
    0x69, 0x14, 0x9b, 0x23, 0xee, 0x30, 0x4c, 0xbd, 0xeb, 0x01, 0x1f, 0x44, 0xb5, 0x91,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_800B[32] = {
    0xf4, 0xa0, 0xc4, 0x1a, 0x95, 0x4b, 0x18, 0x37, 0xf8, 0x7b, 0xc0, 0x57, 0x2a, 0xe1, 0xf0, 0xff,
    0x1f, 0x4c, 0x83, 0x51, 0x5e, 0x13, 0xc0, 0xae, 0x8f, 0xf3, 0xbe, 0x23, 0xc3, 0x10, 0xc2, 0xb3,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_800B);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_800B);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_800B);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800C
const uint8_t kDevelopmentDAC_Cert_FFF2_800C[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x2a, 0x5f, 0x87, 0x29, 0x51, 0xdd,
    0x24, 0xc1, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x43, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x43, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x4a, 0x3c, 0x1b, 0x42, 0x9b, 0xc8, 0xdf, 0xd8,
    0xa6, 0x9f, 0xac, 0x3c, 0x79, 0xee, 0x09, 0x94, 0x7a, 0x71, 0x66, 0x77, 0xe5, 0xed, 0x59, 0x13, 0x29, 0x06, 0xdb, 0x16, 0x0d,
    0x84, 0xee, 0x39, 0xb6, 0xa7, 0x63, 0x3b, 0x96, 0xd1, 0xa7, 0x99, 0xd5, 0xed, 0xf3, 0x29, 0x23, 0x35, 0x3e, 0xd3, 0xc0, 0x6c,
    0xf2, 0x2a, 0x42, 0x9d, 0x34, 0x67, 0x6f, 0x80, 0x8c, 0x82, 0xe7, 0x95, 0xbb, 0x88, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x8c, 0x15, 0xcd, 0x1f,
    0x1a, 0xbb, 0x78, 0x40, 0x9e, 0xec, 0xbb, 0x3f, 0xd4, 0x7f, 0x9c, 0x12, 0xba, 0x7b, 0x70, 0xf6, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xf4, 0xa2, 0x64, 0x29, 0xbd, 0x86, 0x9b, 0x77, 0x9a, 0x21, 0x32, 0x0c, 0x16, 0xeb, 0x3c,
    0x06, 0xab, 0xb2, 0x2a, 0x6b, 0x5c, 0xc8, 0x8b, 0x6e, 0x98, 0x42, 0x83, 0xed, 0xab, 0x19, 0x56, 0x52, 0x02, 0x20, 0x7d, 0xe0,
    0x22, 0x90, 0xd6, 0xf4, 0x6d, 0x6e, 0x9b, 0x27, 0xd9, 0xf2, 0xcf, 0xdc, 0x54, 0xec, 0x25, 0x11, 0x82, 0xf2, 0xf5, 0xed, 0x38,
    0x67, 0x58, 0xcd, 0xe6, 0xd9, 0x14, 0xf1, 0x7b, 0x51,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_800C[65] = {
    0x04, 0x4a, 0x3c, 0x1b, 0x42, 0x9b, 0xc8, 0xdf, 0xd8, 0xa6, 0x9f, 0xac, 0x3c, 0x79, 0xee, 0x09, 0x94,
    0x7a, 0x71, 0x66, 0x77, 0xe5, 0xed, 0x59, 0x13, 0x29, 0x06, 0xdb, 0x16, 0x0d, 0x84, 0xee, 0x39, 0xb6,
    0xa7, 0x63, 0x3b, 0x96, 0xd1, 0xa7, 0x99, 0xd5, 0xed, 0xf3, 0x29, 0x23, 0x35, 0x3e, 0xd3, 0xc0, 0x6c,
    0xf2, 0x2a, 0x42, 0x9d, 0x34, 0x67, 0x6f, 0x80, 0x8c, 0x82, 0xe7, 0x95, 0xbb, 0x88,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_800C[32] = {
    0x10, 0x3f, 0x33, 0x85, 0x5e, 0x6a, 0xe6, 0xbe, 0x4a, 0xad, 0x76, 0xbb, 0xcd, 0xc3, 0x6f, 0x71,
    0x9d, 0x1f, 0x5c, 0xad, 0x27, 0x02, 0xfe, 0x24, 0x9c, 0x1a, 0x63, 0x44, 0x34, 0x14, 0x56, 0x75,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_800C);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_800C);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_800C);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800D
const uint8_t kDevelopmentDAC_Cert_FFF2_800D[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x43, 0x42, 0x90, 0xeb, 0x35, 0xdf,
    0x5e, 0x88, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x44, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x12, 0x3f, 0xee, 0xcd, 0x86, 0x55, 0x0a, 0xb4,
    0x6c, 0x0b, 0x29, 0xfa, 0x36, 0x4d, 0xa9, 0x82, 0xd3, 0xa3, 0x7a, 0xf0, 0xe5, 0xfa, 0x15, 0x1a, 0x65, 0x21, 0xd4, 0x81, 0x08,
    0x36, 0x95, 0xdc, 0x78, 0xaa, 0xe7, 0x6f, 0x5f, 0xda, 0xc0, 0x91, 0x4d, 0x0a, 0x44, 0x34, 0x3b, 0xd6, 0xed, 0x5f, 0xfc, 0xed,
    0x57, 0x50, 0x94, 0xbe, 0xff, 0x54, 0x6a, 0x3d, 0x4a, 0x7f, 0x05, 0x08, 0x83, 0x92, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xb5, 0xb0, 0x56, 0xc9,
    0x5d, 0xf7, 0x5f, 0xd1, 0xb4, 0xea, 0x0e, 0x19, 0xb0, 0x13, 0xc4, 0x34, 0x72, 0xf9, 0x9b, 0xe2, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0x9f, 0x64, 0xab, 0x9d, 0x40, 0xc6, 0x4e, 0x02, 0xd6, 0x46, 0x65, 0xd2, 0x98, 0xb3, 0x6c,
    0x9b, 0x5f, 0x66, 0xee, 0x6d, 0x09, 0xb6, 0xab, 0x97, 0x64, 0x29, 0x13, 0x86, 0xad, 0x3d, 0xc0, 0x3a, 0x02, 0x21, 0x00, 0xe9,
    0xcd, 0x40, 0xbd, 0xa3, 0xe8, 0x03, 0x35, 0xe5, 0xae, 0x26, 0xc0, 0xb0, 0x7f, 0xea, 0x58, 0x46, 0xa9, 0x86, 0x64, 0xc7, 0x51,
    0x13, 0xf5, 0x63, 0x67, 0x2f, 0x7c, 0x22, 0xb9, 0x98, 0xbf,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_800D[65] = {
    0x04, 0x12, 0x3f, 0xee, 0xcd, 0x86, 0x55, 0x0a, 0xb4, 0x6c, 0x0b, 0x29, 0xfa, 0x36, 0x4d, 0xa9, 0x82,
    0xd3, 0xa3, 0x7a, 0xf0, 0xe5, 0xfa, 0x15, 0x1a, 0x65, 0x21, 0xd4, 0x81, 0x08, 0x36, 0x95, 0xdc, 0x78,
    0xaa, 0xe7, 0x6f, 0x5f, 0xda, 0xc0, 0x91, 0x4d, 0x0a, 0x44, 0x34, 0x3b, 0xd6, 0xed, 0x5f, 0xfc, 0xed,
    0x57, 0x50, 0x94, 0xbe, 0xff, 0x54, 0x6a, 0x3d, 0x4a, 0x7f, 0x05, 0x08, 0x83, 0x92,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_800D[32] = {
    0xd5, 0x61, 0xfe, 0x73, 0xd4, 0x75, 0x42, 0x9f, 0xac, 0x2c, 0x49, 0x74, 0x5f, 0x38, 0x98, 0xf1,
    0x1c, 0xc1, 0xc5, 0x4e, 0x93, 0x7c, 0xa2, 0x55, 0x6b, 0x00, 0x8d, 0x87, 0x69, 0x06, 0x6e, 0x73,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_800D);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_800D);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_800D);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800E
const uint8_t kDevelopmentDAC_Cert_FFF2_800E[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x0f, 0x7f, 0x82, 0x6b, 0x2a, 0x7f,
    0xd6, 0x0e, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x45, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x45, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x60, 0x20, 0xca, 0x35, 0x23, 0x8f, 0xd9, 0x9d,
    0x7d, 0x45, 0xe9, 0x0c, 0x61, 0x2c, 0xcf, 0x84, 0x87, 0x2b, 0x3e, 0xdb, 0xe2, 0xa9, 0x6c, 0x25, 0x22, 0xf3, 0xdc, 0x43, 0x30,
    0x90, 0xc4, 0xed, 0x44, 0x7b, 0xe9, 0xb9, 0xf0, 0x1f, 0x8e, 0x68, 0x1f, 0x7f, 0x6e, 0x42, 0x03, 0xec, 0xf3, 0x32, 0x7e, 0x51,
    0xaa, 0x21, 0xde, 0x00, 0x4f, 0xe4, 0x60, 0x5f, 0x45, 0x35, 0xa5, 0x81, 0x2d, 0x20, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x37, 0xf2, 0xce, 0xe4,
    0x94, 0xcd, 0x3d, 0x76, 0x56, 0x48, 0xce, 0x81, 0x9a, 0x97, 0xb3, 0xc6, 0x48, 0x5f, 0x09, 0x47, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xb3, 0x74, 0x58, 0x85, 0x13, 0xff, 0x09, 0x8d, 0x02, 0xef, 0x59, 0x7d, 0x0f, 0x51, 0xd8,
    0xef, 0xd1, 0x15, 0x89, 0xac, 0x05, 0x03, 0xc2, 0x12, 0x31, 0x57, 0x1e, 0x1d, 0xfd, 0xac, 0xe8, 0x71, 0x02, 0x21, 0x00, 0xe7,
    0xce, 0x89, 0x1b, 0x50, 0x0b, 0x6f, 0xd4, 0x7d, 0xe3, 0xb1, 0x33, 0x46, 0x54, 0xed, 0xf2, 0x44, 0x0a, 0x58, 0xec, 0x07, 0x12,
    0x5b, 0x08, 0xab, 0xda, 0x92, 0xc8, 0xd7, 0x78, 0x7c, 0xed,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_800E[65] = {
    0x04, 0x60, 0x20, 0xca, 0x35, 0x23, 0x8f, 0xd9, 0x9d, 0x7d, 0x45, 0xe9, 0x0c, 0x61, 0x2c, 0xcf, 0x84,
    0x87, 0x2b, 0x3e, 0xdb, 0xe2, 0xa9, 0x6c, 0x25, 0x22, 0xf3, 0xdc, 0x43, 0x30, 0x90, 0xc4, 0xed, 0x44,
    0x7b, 0xe9, 0xb9, 0xf0, 0x1f, 0x8e, 0x68, 0x1f, 0x7f, 0x6e, 0x42, 0x03, 0xec, 0xf3, 0x32, 0x7e, 0x51,
    0xaa, 0x21, 0xde, 0x00, 0x4f, 0xe4, 0x60, 0x5f, 0x45, 0x35, 0xa5, 0x81, 0x2d, 0x20,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_800E[32] = {
    0xc7, 0x6c, 0x81, 0xef, 0xd3, 0x3e, 0x35, 0xa5, 0x41, 0x07, 0xd8, 0x6a, 0xa7, 0x41, 0x73, 0x92,
    0x60, 0x95, 0xdf, 0x5d, 0x6c, 0xd7, 0x1a, 0xae, 0xeb, 0x3a, 0xa5, 0x89, 0x37, 0x62, 0x26, 0xd2,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_800E);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_800E);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_800E);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800F
const uint8_t kDevelopmentDAC_Cert_FFF2_800F[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x5e, 0xba, 0xbd, 0x88, 0x53, 0xc9,
    0xda, 0x90, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x46, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x46, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x61, 0xc5, 0x39, 0x7e, 0x10, 0x3c, 0x31, 0x4a,
    0x52, 0x54, 0xd4, 0x15, 0x1f, 0xed, 0x28, 0xd0, 0x12, 0x3a, 0x53, 0x0d, 0x46, 0x20, 0x9e, 0x98, 0xaf, 0x2d, 0xd6, 0xe7, 0x77,
    0xdd, 0x27, 0xaa, 0xff, 0x3c, 0xf1, 0x96, 0xcc, 0xc1, 0x09, 0x15, 0x9c, 0xf5, 0xdf, 0x71, 0xf6, 0x17, 0xe1, 0x44, 0x58, 0xf5,
    0x5b, 0xed, 0xc1, 0xed, 0xfb, 0xfd, 0x4d, 0x72, 0x8c, 0xc4, 0x8c, 0xfb, 0xa4, 0x03, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xbe, 0x48, 0xc1, 0x4d,
    0x30, 0xb1, 0x86, 0x4c, 0x0b, 0x97, 0x07, 0x54, 0xde, 0x82, 0x4e, 0xa8, 0x85, 0xa1, 0x5b, 0xa7, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0x99, 0xc3, 0x2f, 0x1e, 0x78, 0xb2, 0xa9, 0xb0, 0x3e, 0xf7, 0xfa, 0x9d, 0x9a, 0x90, 0x4d,
    0xbe, 0x6c, 0x00, 0x7f, 0xfa, 0xb5, 0xa5, 0x92, 0x8b, 0x5f, 0x3b, 0x52, 0x36, 0x17, 0x47, 0x91, 0x1c, 0x02, 0x20, 0x09, 0x0d,
    0xb8, 0x80, 0xd5, 0x64, 0x0f, 0xf1, 0x3b, 0x6e, 0x9c, 0x2e, 0x87, 0x7e, 0x6e, 0xd4, 0x3a, 0x58, 0x26, 0x8d, 0x20, 0xc5, 0xf0,
    0x50, 0x73, 0x7a, 0xb3, 0xcc, 0xb6, 0xeb, 0x99, 0xe1,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_800F[65] = {
    0x04, 0x61, 0xc5, 0x39, 0x7e, 0x10, 0x3c, 0x31, 0x4a, 0x52, 0x54, 0xd4, 0x15, 0x1f, 0xed, 0x28, 0xd0,
    0x12, 0x3a, 0x53, 0x0d, 0x46, 0x20, 0x9e, 0x98, 0xaf, 0x2d, 0xd6, 0xe7, 0x77, 0xdd, 0x27, 0xaa, 0xff,
    0x3c, 0xf1, 0x96, 0xcc, 0xc1, 0x09, 0x15, 0x9c, 0xf5, 0xdf, 0x71, 0xf6, 0x17, 0xe1, 0x44, 0x58, 0xf5,
    0x5b, 0xed, 0xc1, 0xed, 0xfb, 0xfd, 0x4d, 0x72, 0x8c, 0xc4, 0x8c, 0xfb, 0xa4, 0x03,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_800F[32] = {
    0xcf, 0xd2, 0x08, 0x01, 0x0b, 0xbb, 0xf8, 0xf8, 0x0e, 0xf4, 0x43, 0x44, 0x10, 0x0f, 0x0d, 0x84,
    0xc8, 0x16, 0x74, 0xec, 0x06, 0xc0, 0x7b, 0x02, 0x01, 0x71, 0x06, 0x67, 0xa3, 0xa3, 0xbb, 0xb0,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_800F);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_800F);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_800F);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8010
const uint8_t kDevelopmentDAC_Cert_FFF2_8010[468] = {
    0x30, 0x82, 0x01, 0xd0, 0x30, 0x82, 0x01, 0x76, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x2a, 0x98, 0xff, 0x04, 0x80, 0x74,
    0xa1, 0x06, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3b, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x30, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x30, 0x20, 0x4d, 0x76, 0x69, 0x64, 0x3a, 0x46, 0x46, 0x46, 0x32, 0x20, 0x4d, 0x70, 0x69, 0x64, 0x3a,
    0x38, 0x30, 0x31, 0x30, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x11, 0x8b, 0xde, 0x82, 0x46, 0xeb, 0xed, 0xb7, 0xc3, 0xee, 0xcc,
    0xd6, 0x69, 0x3e, 0x24, 0x0e, 0x24, 0x06, 0xf6, 0x49, 0x44, 0xd1, 0x54, 0x69, 0xce, 0x00, 0x57, 0xd0, 0xb7, 0xa9, 0x9f, 0x45,
    0x8f, 0x4b, 0x1b, 0x6f, 0x3d, 0xc5, 0x71, 0x9d, 0xed, 0xad, 0xe0, 0x62, 0x5f, 0xae, 0xc2, 0x8f, 0xa5, 0x0e, 0x37, 0x21, 0x41,
    0x49, 0xc2, 0xeb, 0x61, 0x55, 0xc1, 0x92, 0x9a, 0xc2, 0xce, 0x28, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d,
    0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
    0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x27, 0x5d, 0x1f, 0x35, 0xa3, 0x10, 0x1c,
    0xc2, 0x9f, 0x07, 0x81, 0x48, 0x76, 0x04, 0x49, 0x48, 0x0f, 0xe6, 0x1e, 0x18, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07, 0x37, 0x8f, 0xf0,
    0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48, 0x00, 0x30, 0x45,
    0x02, 0x20, 0x08, 0xd1, 0xe2, 0x17, 0xbb, 0xbe, 0x3d, 0xb1, 0xaa, 0x1e, 0x45, 0x14, 0x4a, 0xe8, 0xc6, 0xf1, 0x4f, 0x07, 0xd6,
    0x70, 0xed, 0x70, 0x93, 0x26, 0xd3, 0x57, 0x98, 0x21, 0x2f, 0xf5, 0x01, 0x07, 0x02, 0x21, 0x00, 0xcd, 0x53, 0x77, 0xa6, 0x05,
    0x8c, 0x95, 0x13, 0xbf, 0x75, 0x0b, 0x46, 0xa9, 0x49, 0x12, 0x79, 0x83, 0x8b, 0x49, 0xa1, 0x3c, 0xdb, 0x39, 0xce, 0xa1, 0xd5,
    0x4b, 0xfd, 0xb3, 0x8d, 0x30, 0xd4,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8010[65] = {
    0x04, 0x11, 0x8b, 0xde, 0x82, 0x46, 0xeb, 0xed, 0xb7, 0xc3, 0xee, 0xcc, 0xd6, 0x69, 0x3e, 0x24, 0x0e,
    0x24, 0x06, 0xf6, 0x49, 0x44, 0xd1, 0x54, 0x69, 0xce, 0x00, 0x57, 0xd0, 0xb7, 0xa9, 0x9f, 0x45, 0x8f,
    0x4b, 0x1b, 0x6f, 0x3d, 0xc5, 0x71, 0x9d, 0xed, 0xad, 0xe0, 0x62, 0x5f, 0xae, 0xc2, 0x8f, 0xa5, 0x0e,
    0x37, 0x21, 0x41, 0x49, 0xc2, 0xeb, 0x61, 0x55, 0xc1, 0x92, 0x9a, 0xc2, 0xce, 0x28,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8010[32] = {
    0x60, 0xf2, 0xf7, 0x44, 0xbd, 0x4e, 0x9a, 0x6a, 0xfd, 0x99, 0xad, 0xf2, 0x44, 0x8d, 0xbb, 0x1c,
    0xc2, 0x88, 0xb8, 0xc2, 0xbe, 0x33, 0xc6, 0xdc, 0x90, 0x56, 0xd8, 0xfd, 0x87, 0xf7, 0xbc, 0x11,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8010);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8010);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8010);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8011
const uint8_t kDevelopmentDAC_Cert_FFF2_8011[468] = {
    0x30, 0x82, 0x01, 0xd0, 0x30, 0x82, 0x01, 0x76, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x21, 0xef, 0x65, 0x38, 0xc0, 0x7a,
    0x9b, 0xa1, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3b, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x30, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x31, 0x20, 0x4d, 0x76, 0x69, 0x64, 0x3a, 0x46, 0x46, 0x46, 0x32, 0x20, 0x4d, 0x70, 0x69, 0x64, 0x3a,
    0x38, 0x30, 0x31, 0x31, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xa6, 0xaa, 0xac, 0xba, 0x90, 0xce, 0x63, 0x0d, 0x46, 0x05, 0xfb,
    0x96, 0x2f, 0x97, 0x41, 0x7d, 0x77, 0x6f, 0xbd, 0x4f, 0x73, 0x96, 0x37, 0x9d, 0x10, 0xdc, 0x39, 0xd1, 0x28, 0x5f, 0x43, 0xdb,
    0xeb, 0x5e, 0xec, 0x1d, 0x0d, 0xec, 0xd1, 0x85, 0xab, 0x38, 0x3d, 0x31, 0x1a, 0x67, 0x62, 0x49, 0xeb, 0xca, 0x90, 0x5e, 0xa6,
    0x1a, 0x61, 0x47, 0xbe, 0x51, 0xdf, 0x28, 0x05, 0x05, 0xf9, 0x39, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d,
    0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
    0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xb4, 0x09, 0x94, 0x3c, 0x21, 0xe3, 0x25,
    0x0d, 0x1d, 0xea, 0x4a, 0x22, 0x18, 0x68, 0xa2, 0xc8, 0x91, 0xef, 0xc8, 0x3f, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07, 0x37, 0x8f, 0xf0,
    0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48, 0x00, 0x30, 0x45,
    0x02, 0x21, 0x00, 0xa0, 0x73, 0x2a, 0x67, 0xf6, 0x53, 0x2d, 0x02, 0xfd, 0x2d, 0x28, 0x82, 0x30, 0x2e, 0x35, 0x21, 0xdd, 0xec,
    0x05, 0x8e, 0x61, 0xb0, 0x8d, 0x09, 0x61, 0x34, 0x65, 0xb2, 0x03, 0xd1, 0x92, 0x9a, 0x02, 0x20, 0x46, 0xac, 0x48, 0xb1, 0x26,
    0xce, 0x3c, 0xfe, 0x22, 0x39, 0x79, 0x30, 0xbd, 0x54, 0x16, 0xcd, 0x50, 0x3b, 0x9a, 0xfd, 0xbc, 0xbc, 0xbf, 0x55, 0x9a, 0x94,
    0x18, 0xe5, 0x6e, 0x70, 0xae, 0x62,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8011[65] = {
    0x04, 0xa6, 0xaa, 0xac, 0xba, 0x90, 0xce, 0x63, 0x0d, 0x46, 0x05, 0xfb, 0x96, 0x2f, 0x97, 0x41, 0x7d,
    0x77, 0x6f, 0xbd, 0x4f, 0x73, 0x96, 0x37, 0x9d, 0x10, 0xdc, 0x39, 0xd1, 0x28, 0x5f, 0x43, 0xdb, 0xeb,
    0x5e, 0xec, 0x1d, 0x0d, 0xec, 0xd1, 0x85, 0xab, 0x38, 0x3d, 0x31, 0x1a, 0x67, 0x62, 0x49, 0xeb, 0xca,
    0x90, 0x5e, 0xa6, 0x1a, 0x61, 0x47, 0xbe, 0x51, 0xdf, 0x28, 0x05, 0x05, 0xf9, 0x39,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8011[32] = {
    0xcf, 0x5c, 0x8d, 0x0b, 0x8f, 0x83, 0xd8, 0xae, 0x6a, 0xd6, 0xa4, 0xac, 0x6e, 0x87, 0x73, 0x0b,
    0x74, 0x32, 0xb7, 0xf5, 0x55, 0x3a, 0x50, 0x4b, 0x56, 0xce, 0x63, 0xaa, 0xf7, 0xe5, 0x31, 0x49,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8011);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8011);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8011);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8012
const uint8_t kDevelopmentDAC_Cert_FFF2_8012[467] = {
    0x30, 0x82, 0x01, 0xcf, 0x30, 0x82, 0x01, 0x76, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x4f, 0x0e, 0x7a, 0x55, 0xc8, 0x0f,
    0x75, 0x01, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3b, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x30, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x32, 0x20, 0x4d, 0x76, 0x69, 0x64, 0x3a, 0x46, 0x46, 0x46, 0x32, 0x20, 0x4d, 0x70, 0x69, 0x64, 0x3a,
    0x38, 0x30, 0x31, 0x32, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x9e, 0x94, 0x59, 0x77, 0xf2, 0x2d, 0x26, 0x65, 0x90, 0x21, 0xf4,
    0xd0, 0xa6, 0x34, 0x2b, 0x25, 0x3e, 0x1e, 0xa2, 0xdc, 0xfd, 0xb9, 0x5f, 0x76, 0xc3, 0x24, 0xe7, 0x6e, 0x2c, 0x62, 0xb7, 0x70,
    0xb4, 0x3b, 0xfe, 0x0f, 0x08, 0x31, 0x82, 0xc6, 0xb2, 0x60, 0xd6, 0xa2, 0x95, 0xeb, 0xe2, 0xf5, 0x1e, 0xe9, 0x08, 0x17, 0xd6,
    0x6f, 0xea, 0x97, 0xa7, 0x27, 0x0e, 0x1f, 0xb0, 0x77, 0x3a, 0x75, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d,
    0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
    0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x5b, 0x40, 0x51, 0xc6, 0x6a, 0xb0, 0xf6,
    0xce, 0xda, 0x4a, 0x7d, 0xcf, 0x14, 0x36, 0x4f, 0x64, 0x97, 0x21, 0x10, 0x66, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07, 0x37, 0x8f, 0xf0,
    0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47, 0x00, 0x30, 0x44,
    0x02, 0x20, 0x41, 0xe6, 0x27, 0x3e, 0xd6, 0x02, 0xaa, 0xc7, 0x9b, 0x7e, 0xc1, 0x81, 0xd5, 0x7b, 0x74, 0x54, 0x72, 0x5d, 0xbb,
    0xee, 0xbc, 0x0d, 0x68, 0x78, 0xaa, 0xa6, 0x9d, 0x36, 0xbf, 0xc7, 0x82, 0x23, 0x02, 0x20, 0x4e, 0x8c, 0x44, 0x38, 0x22, 0x38,
    0xa0, 0x3f, 0xc5, 0x97, 0x3b, 0x54, 0xaf, 0x52, 0x5e, 0xf3, 0xdc, 0xab, 0xdb, 0x1d, 0xbf, 0x48, 0xe3, 0x08, 0x04, 0x1f, 0x12,
    0x02, 0xa3, 0x36, 0x5e, 0xf9,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8012[65] = {
    0x04, 0x9e, 0x94, 0x59, 0x77, 0xf2, 0x2d, 0x26, 0x65, 0x90, 0x21, 0xf4, 0xd0, 0xa6, 0x34, 0x2b, 0x25,
    0x3e, 0x1e, 0xa2, 0xdc, 0xfd, 0xb9, 0x5f, 0x76, 0xc3, 0x24, 0xe7, 0x6e, 0x2c, 0x62, 0xb7, 0x70, 0xb4,
    0x3b, 0xfe, 0x0f, 0x08, 0x31, 0x82, 0xc6, 0xb2, 0x60, 0xd6, 0xa2, 0x95, 0xeb, 0xe2, 0xf5, 0x1e, 0xe9,
    0x08, 0x17, 0xd6, 0x6f, 0xea, 0x97, 0xa7, 0x27, 0x0e, 0x1f, 0xb0, 0x77, 0x3a, 0x75,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8012[32] = {
    0x45, 0x92, 0x5c, 0x30, 0xbe, 0xb2, 0xb4, 0x02, 0x1e, 0x2c, 0xc2, 0x00, 0xb2, 0x53, 0xe3, 0xd2,
    0x26, 0x01, 0xa0, 0x82, 0x00, 0xe8, 0x11, 0x6e, 0x36, 0x37, 0x13, 0x81, 0xb3, 0x35, 0xd5, 0x6a,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8012);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8012);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8012);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8013
const uint8_t kDevelopmentDAC_Cert_FFF2_8013[467] = {
    0x30, 0x82, 0x01, 0xcf, 0x30, 0x82, 0x01, 0x76, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x3d, 0x9f, 0x94, 0xa3, 0x17, 0x05,
    0xff, 0x29, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3b, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x30, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x33, 0x20, 0x4d, 0x76, 0x69, 0x64, 0x3a, 0x46, 0x46, 0x46, 0x32, 0x20, 0x4d, 0x70, 0x69, 0x64, 0x3a,
    0x38, 0x30, 0x31, 0x33, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xcb, 0x11, 0x03, 0xba, 0x64, 0xe0, 0xe3, 0x1a, 0x96, 0xf8, 0xbc,
    0x5e, 0xde, 0x37, 0xb6, 0x33, 0xd2, 0xbb, 0x12, 0xe3, 0x5b, 0x4f, 0x01, 0xb9, 0x3c, 0x10, 0x0e, 0x03, 0xe0, 0x75, 0xad, 0x53,
    0x28, 0x44, 0x1b, 0x75, 0x93, 0xaa, 0x3e, 0x80, 0x3b, 0xf2, 0x87, 0x3c, 0x01, 0x9d, 0xe4, 0x52, 0x51, 0x24, 0x78, 0xe6, 0x0f,
    0x34, 0x8a, 0xd9, 0x96, 0x00, 0x57, 0xb5, 0x36, 0xca, 0x84, 0x92, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d,
    0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
    0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x6b, 0xeb, 0x11, 0xbb, 0xcb, 0x8d, 0x16,
    0xb3, 0x89, 0x7e, 0x00, 0x42, 0xe0, 0xcb, 0xff, 0x9e, 0x2d, 0xb6, 0x26, 0x50, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07, 0x37, 0x8f, 0xf0,
    0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47, 0x00, 0x30, 0x44,
    0x02, 0x20, 0x01, 0x38, 0xed, 0x71, 0x11, 0xa7, 0xde, 0x55, 0xd7, 0x79, 0xa5, 0xb4, 0xe5, 0x87, 0x4b, 0xe7, 0xc5, 0x7b, 0x82,
    0x1a, 0x1c, 0x36, 0x64, 0x9e, 0x6f, 0xdd, 0x99, 0x97, 0xd3, 0x78, 0xc4, 0xe2, 0x02, 0x20, 0x78, 0x5f, 0xab, 0x3b, 0x3a, 0x77,
    0x6c, 0xd5, 0x76, 0x71, 0x19, 0x2e, 0x95, 0xcb, 0x6e, 0x31, 0x24, 0x4d, 0xc2, 0xb5, 0x8a, 0xce, 0x7c, 0x83, 0x83, 0x0b, 0x6b,
    0x86, 0x48, 0xfd, 0x90, 0x21,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8013[65] = {
    0x04, 0xcb, 0x11, 0x03, 0xba, 0x64, 0xe0, 0xe3, 0x1a, 0x96, 0xf8, 0xbc, 0x5e, 0xde, 0x37, 0xb6, 0x33,
    0xd2, 0xbb, 0x12, 0xe3, 0x5b, 0x4f, 0x01, 0xb9, 0x3c, 0x10, 0x0e, 0x03, 0xe0, 0x75, 0xad, 0x53, 0x28,
    0x44, 0x1b, 0x75, 0x93, 0xaa, 0x3e, 0x80, 0x3b, 0xf2, 0x87, 0x3c, 0x01, 0x9d, 0xe4, 0x52, 0x51, 0x24,
    0x78, 0xe6, 0x0f, 0x34, 0x8a, 0xd9, 0x96, 0x00, 0x57, 0xb5, 0x36, 0xca, 0x84, 0x92,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8013[32] = {
    0x64, 0x01, 0xf6, 0xfa, 0x76, 0xed, 0xe8, 0xfc, 0x96, 0x09, 0x06, 0xba, 0xcb, 0xd2, 0x18, 0x67,
    0xbc, 0xe1, 0xf6, 0x91, 0x84, 0xfb, 0xda, 0x99, 0x4f, 0xa5, 0x98, 0x51, 0x5a, 0xc3, 0x28, 0x89,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8013);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8013);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8013);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8014
const uint8_t kDevelopmentDAC_Cert_FFF2_8014[468] = {
    0x30, 0x82, 0x01, 0xd0, 0x30, 0x82, 0x01, 0x76, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x46, 0xa8, 0x4c, 0xe2, 0xbf, 0x06,
    0x8a, 0xa0, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3b, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x30, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x34, 0x20, 0x4d, 0x76, 0x69, 0x64, 0x3a, 0x46, 0x46, 0x46, 0x32, 0x20, 0x4d, 0x70, 0x69, 0x64, 0x3a,
    0x38, 0x30, 0x31, 0x34, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xe2, 0x60, 0x4e, 0xec, 0x8f, 0x54, 0x1d, 0xaf, 0x80, 0x62, 0xc3,
    0x71, 0xc4, 0x8c, 0x0f, 0xbb, 0x91, 0xc8, 0x7d, 0x7d, 0xb0, 0x4f, 0x2f, 0x64, 0x9a, 0x01, 0x8d, 0xd4, 0x61, 0xd3, 0xf3, 0xf3,
    0x89, 0x95, 0xdd, 0x2f, 0x0b, 0x21, 0x57, 0xcb, 0x7f, 0xb6, 0x73, 0xc1, 0xd3, 0xd7, 0xee, 0xe2, 0x5b, 0x31, 0xf9, 0xec, 0x9e,
    0x3d, 0xc2, 0x16, 0x51, 0xdc, 0x06, 0x6a, 0xad, 0x2b, 0xcb, 0x12, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d,
    0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
    0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x66, 0xb1, 0xdb, 0x13, 0x87, 0xf9, 0xc9,
    0x02, 0x22, 0xd8, 0x73, 0xa5, 0x07, 0x36, 0xe3, 0x46, 0xe0, 0x1f, 0x07, 0x34, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07, 0x37, 0x8f, 0xf0,
    0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48, 0x00, 0x30, 0x45,
    0x02, 0x21, 0x00, 0xc9, 0x2a, 0x13, 0xb8, 0x76, 0x45, 0x00, 0x98, 0x33, 0xd2, 0x57, 0x6c, 0x74, 0xbd, 0x41, 0x39, 0x85, 0x87,
    0x5c, 0x85, 0xbd, 0x3d, 0xbc, 0xad, 0x2c, 0x66, 0x02, 0xa1, 0x57, 0x70, 0x28, 0x93, 0x02, 0x20, 0x0f, 0x84, 0xac, 0x62, 0x3f,
    0xf8, 0xaa, 0x9e, 0xda, 0x3b, 0x02, 0xb7, 0x43, 0x5c, 0xb6, 0x52, 0x59, 0xdc, 0x74, 0x66, 0x57, 0x71, 0xe2, 0x01, 0x8e, 0x36,
    0x6b, 0xac, 0x72, 0x4c, 0x15, 0x2d,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8014[65] = {
    0x04, 0xe2, 0x60, 0x4e, 0xec, 0x8f, 0x54, 0x1d, 0xaf, 0x80, 0x62, 0xc3, 0x71, 0xc4, 0x8c, 0x0f, 0xbb,
    0x91, 0xc8, 0x7d, 0x7d, 0xb0, 0x4f, 0x2f, 0x64, 0x9a, 0x01, 0x8d, 0xd4, 0x61, 0xd3, 0xf3, 0xf3, 0x89,
    0x95, 0xdd, 0x2f, 0x0b, 0x21, 0x57, 0xcb, 0x7f, 0xb6, 0x73, 0xc1, 0xd3, 0xd7, 0xee, 0xe2, 0x5b, 0x31,
    0xf9, 0xec, 0x9e, 0x3d, 0xc2, 0x16, 0x51, 0xdc, 0x06, 0x6a, 0xad, 0x2b, 0xcb, 0x12,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8014[32] = {
    0x9c, 0x97, 0xb6, 0x23, 0x03, 0x62, 0xb6, 0x21, 0xad, 0x06, 0xa9, 0x21, 0x5f, 0x10, 0x1d, 0x07,
    0x5a, 0x95, 0xea, 0x5a, 0xba, 0xcd, 0xd8, 0xf5, 0xf3, 0x19, 0x10, 0x45, 0x2d, 0x86, 0x4e, 0xd9,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8014);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8014);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8014);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8015
const uint8_t kDevelopmentDAC_Cert_FFF2_8015[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x1a, 0xfa, 0x53, 0xd1, 0xa2, 0x7c,
    0x5e, 0xb5, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x35, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x35, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x8a, 0xd3, 0xf5, 0x2d, 0xf5, 0x94, 0xb8, 0x87,
    0xc3, 0xfb, 0xcc, 0x0e, 0x76, 0x9d, 0xbb, 0x51, 0x59, 0x00, 0x66, 0xfe, 0xe3, 0x6a, 0x76, 0xd3, 0xdf, 0x3e, 0x5f, 0xb1, 0xde,
    0xea, 0x22, 0x3a, 0x0d, 0x9c, 0xc7, 0x49, 0xb8, 0x9c, 0x66, 0x38, 0xe9, 0x30, 0x7e, 0x62, 0x0d, 0x66, 0x24, 0x28, 0xde, 0xd2,
    0x8d, 0xa1, 0x0b, 0x0c, 0x4a, 0xde, 0x28, 0x4e, 0xfc, 0x30, 0xfe, 0x4e, 0xe9, 0x20, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xc5, 0x17, 0x1b, 0xe0,
    0x28, 0x86, 0xa7, 0x38, 0x32, 0xc4, 0x58, 0xd5, 0x11, 0x29, 0xb6, 0xdf, 0xf9, 0xde, 0x6e, 0x3a, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xde, 0x0b, 0xb9, 0xa9, 0x50, 0x48, 0x83, 0xe8, 0x67, 0x40, 0xbf, 0xb3, 0xea, 0xb2, 0x7d,
    0x83, 0x79, 0x4e, 0x25, 0x14, 0x00, 0x1a, 0xfd, 0x8e, 0x52, 0xa7, 0xad, 0x4d, 0x1c, 0xda, 0xd0, 0xc2, 0x02, 0x21, 0x00, 0x8c,
    0x58, 0x33, 0x91, 0x67, 0x9b, 0x59, 0xe9, 0xa9, 0xe6, 0x5b, 0x4f, 0xb7, 0xd5, 0x0e, 0x3f, 0xcb, 0x5d, 0x1e, 0xa5, 0x3b, 0xde,
    0xea, 0x4a, 0xc5, 0x47, 0x23, 0xe2, 0x03, 0x2f, 0xbc, 0x25,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8015[65] = {
    0x04, 0x8a, 0xd3, 0xf5, 0x2d, 0xf5, 0x94, 0xb8, 0x87, 0xc3, 0xfb, 0xcc, 0x0e, 0x76, 0x9d, 0xbb, 0x51,
    0x59, 0x00, 0x66, 0xfe, 0xe3, 0x6a, 0x76, 0xd3, 0xdf, 0x3e, 0x5f, 0xb1, 0xde, 0xea, 0x22, 0x3a, 0x0d,
    0x9c, 0xc7, 0x49, 0xb8, 0x9c, 0x66, 0x38, 0xe9, 0x30, 0x7e, 0x62, 0x0d, 0x66, 0x24, 0x28, 0xde, 0xd2,
    0x8d, 0xa1, 0x0b, 0x0c, 0x4a, 0xde, 0x28, 0x4e, 0xfc, 0x30, 0xfe, 0x4e, 0xe9, 0x20,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8015[32] = {
    0x25, 0x81, 0x32, 0xa7, 0x32, 0x17, 0x6b, 0x40, 0x70, 0x75, 0x79, 0x40, 0xdf, 0xb5, 0xa6, 0x01,
    0xff, 0xb0, 0xd7, 0x30, 0x27, 0xc5, 0xf2, 0xde, 0xe7, 0x52, 0x62, 0xe6, 0xe1, 0x04, 0x69, 0x77,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8015);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8015);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8015);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8016
const uint8_t kDevelopmentDAC_Cert_FFF2_8016[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x1c, 0x11, 0x97, 0xbc, 0x3d, 0x59,
    0xa7, 0x12, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x36, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x36, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x3a, 0xa2, 0x2f, 0xe4, 0x69, 0xf8, 0x01, 0x1f,
    0xb8, 0xd1, 0x1c, 0x94, 0xae, 0xc7, 0xcc, 0xcb, 0xe1, 0x91, 0x13, 0x9b, 0x5d, 0xb1, 0x66, 0x78, 0x44, 0x82, 0x2f, 0x7e, 0x9b,
    0x7e, 0xde, 0xf9, 0x3b, 0x3a, 0xb1, 0x61, 0x37, 0xf6, 0xa5, 0xa5, 0xdb, 0x9a, 0xd2, 0x62, 0xd7, 0x98, 0x33, 0xb6, 0x73, 0x58,
    0x7b, 0xff, 0x2b, 0x0f, 0x2e, 0xe0, 0x9e, 0x1f, 0x75, 0xb7, 0xcc, 0x44, 0x0a, 0x80, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x21, 0xe6, 0xe2, 0xb1,
    0x79, 0x44, 0xb9, 0xda, 0xfb, 0x38, 0x1d, 0x2b, 0x93, 0xfe, 0x9d, 0xa0, 0x02, 0x4f, 0xde, 0x4e, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x6b, 0x8c, 0xe1, 0xde, 0xe7, 0xd0, 0xe9, 0xc6, 0x22, 0x1c, 0x1d, 0x57, 0x55, 0x9c, 0x9e, 0xfb,
    0x40, 0x0f, 0x37, 0x56, 0x75, 0x5f, 0xd9, 0xaa, 0xd2, 0x93, 0xf5, 0x18, 0xfa, 0xa7, 0xa5, 0xd3, 0x02, 0x21, 0x00, 0xc9, 0x89,
    0xa4, 0xf0, 0x6b, 0xfe, 0xdf, 0x9a, 0x26, 0xd7, 0x80, 0x62, 0x91, 0x1a, 0x83, 0x49, 0xff, 0x79, 0x0b, 0x6b, 0xe0, 0x1a, 0xa6,
    0xb3, 0x95, 0x16, 0x9e, 0x78, 0xa3, 0xe5, 0x19, 0x48,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8016[65] = {
    0x04, 0x3a, 0xa2, 0x2f, 0xe4, 0x69, 0xf8, 0x01, 0x1f, 0xb8, 0xd1, 0x1c, 0x94, 0xae, 0xc7, 0xcc, 0xcb,
    0xe1, 0x91, 0x13, 0x9b, 0x5d, 0xb1, 0x66, 0x78, 0x44, 0x82, 0x2f, 0x7e, 0x9b, 0x7e, 0xde, 0xf9, 0x3b,
    0x3a, 0xb1, 0x61, 0x37, 0xf6, 0xa5, 0xa5, 0xdb, 0x9a, 0xd2, 0x62, 0xd7, 0x98, 0x33, 0xb6, 0x73, 0x58,
    0x7b, 0xff, 0x2b, 0x0f, 0x2e, 0xe0, 0x9e, 0x1f, 0x75, 0xb7, 0xcc, 0x44, 0x0a, 0x80,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8016[32] = {
    0x29, 0xdc, 0x3b, 0x83, 0x67, 0x48, 0x98, 0x5f, 0xd7, 0x00, 0x9d, 0x07, 0xd6, 0x62, 0x37, 0x5e,
    0xc8, 0x5c, 0x72, 0xff, 0x95, 0xfd, 0xbe, 0x60, 0x64, 0x81, 0x6f, 0x2b, 0x70, 0x3a, 0xe0, 0xc4,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8016);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8016);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8016);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8017
const uint8_t kDevelopmentDAC_Cert_FFF2_8017[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x4b, 0x02, 0x35, 0xca, 0xbe, 0xc5,
    0xf5, 0x0a, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x37, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x37, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x96, 0xf0, 0xeb, 0x64, 0xa4, 0xf0, 0x39, 0x52,
    0x0d, 0xd3, 0x72, 0xe9, 0xb2, 0xd0, 0xca, 0x1a, 0x8d, 0x12, 0x0d, 0xdd, 0x3d, 0xbe, 0x40, 0x4b, 0x26, 0xe8, 0x5d, 0xe9, 0x48,
    0x4c, 0xc4, 0xf4, 0xfb, 0x56, 0x21, 0x5f, 0x5b, 0xf5, 0x4b, 0x72, 0x23, 0xbc, 0xde, 0x64, 0xca, 0xc1, 0x09, 0x9a, 0x3c, 0x5f,
    0xd0, 0x1e, 0xc2, 0xaf, 0x84, 0xf9, 0x5d, 0x7c, 0xe0, 0xc6, 0x3b, 0x24, 0x5e, 0x48, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xb6, 0x2b, 0x6e, 0x8b,
    0x0d, 0xe3, 0x47, 0xae, 0x4a, 0xe6, 0xd8, 0x52, 0x42, 0x33, 0x38, 0x1c, 0x9c, 0x11, 0xa0, 0xdd, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xd0, 0x34, 0x35, 0x8a, 0xb6, 0x2d, 0xf8, 0xe2, 0xbf, 0xd4, 0xfb, 0x54, 0xd4, 0xf8, 0x2b,
    0x89, 0x84, 0x52, 0xef, 0x05, 0x8d, 0x2d, 0x90, 0x0e, 0xa7, 0xba, 0x10, 0x15, 0x96, 0x13, 0x9f, 0x9a, 0x02, 0x20, 0x2b, 0x80,
    0x4e, 0xf3, 0xc4, 0x90, 0xcb, 0x93, 0xc5, 0xec, 0x2f, 0x7d, 0x65, 0xa6, 0x57, 0x2c, 0xb5, 0x6a, 0x92, 0x91, 0xfc, 0x82, 0xda,
    0x23, 0x0a, 0xe5, 0x47, 0xa5, 0x94, 0x69, 0xc2, 0x04,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8017[65] = {
    0x04, 0x96, 0xf0, 0xeb, 0x64, 0xa4, 0xf0, 0x39, 0x52, 0x0d, 0xd3, 0x72, 0xe9, 0xb2, 0xd0, 0xca, 0x1a,
    0x8d, 0x12, 0x0d, 0xdd, 0x3d, 0xbe, 0x40, 0x4b, 0x26, 0xe8, 0x5d, 0xe9, 0x48, 0x4c, 0xc4, 0xf4, 0xfb,
    0x56, 0x21, 0x5f, 0x5b, 0xf5, 0x4b, 0x72, 0x23, 0xbc, 0xde, 0x64, 0xca, 0xc1, 0x09, 0x9a, 0x3c, 0x5f,
    0xd0, 0x1e, 0xc2, 0xaf, 0x84, 0xf9, 0x5d, 0x7c, 0xe0, 0xc6, 0x3b, 0x24, 0x5e, 0x48,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8017[32] = {
    0x0b, 0xc7, 0xd4, 0x0b, 0x37, 0x52, 0x18, 0x1d, 0x93, 0x85, 0xfc, 0x17, 0x03, 0x39, 0x56, 0x0e,
    0xd9, 0x88, 0x5b, 0x45, 0x3e, 0x41, 0x40, 0xcf, 0x76, 0xe3, 0x1d, 0x05, 0xa0, 0x3e, 0x5c, 0x21,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8017);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8017);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8017);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8018
const uint8_t kDevelopmentDAC_Cert_FFF2_8018[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x06, 0x5c, 0xf2, 0xa6, 0x1b, 0x46,
    0xe3, 0x5e, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x38, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x38, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x2e, 0x1b, 0x4f, 0xa4, 0x84, 0x31, 0x83, 0x25,
    0x4a, 0xa5, 0x34, 0xc6, 0xe4, 0xf6, 0x42, 0xf2, 0xec, 0x82, 0xbd, 0xd7, 0xe6, 0xb2, 0x8b, 0xb4, 0x50, 0x6e, 0xc8, 0xee, 0xa6,
    0xb5, 0xb5, 0x63, 0x6a, 0x51, 0x82, 0x23, 0xc0, 0x72, 0x82, 0x38, 0x7c, 0x34, 0xd5, 0x03, 0x03, 0xac, 0xbb, 0xbf, 0xd0, 0xec,
    0x4e, 0x90, 0x84, 0xdc, 0x3f, 0xf6, 0x15, 0xab, 0x64, 0xd3, 0x1c, 0x90, 0xb3, 0xf2, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x46, 0xab, 0x26, 0xde,
    0x4a, 0x0c, 0xd5, 0x2d, 0x76, 0x70, 0x07, 0xad, 0x10, 0x1b, 0xc5, 0xf0, 0x39, 0xe8, 0xd8, 0xf2, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x3a, 0x44, 0x2f, 0x8a, 0x89, 0x95, 0xc7, 0x1c, 0x1f, 0x4a, 0x49, 0x6d, 0x2f, 0xb2, 0xf4, 0x75,
    0xb8, 0xf5, 0xab, 0xcb, 0x76, 0xd3, 0x8e, 0x8d, 0x7c, 0x40, 0x16, 0xc1, 0x86, 0xaa, 0xf6, 0x98, 0x02, 0x21, 0x00, 0xa3, 0x54,
    0xdc, 0xbf, 0xea, 0x2c, 0x8f, 0xa3, 0x96, 0xf7, 0xfb, 0x70, 0xfb, 0x30, 0xc9, 0x05, 0x54, 0xc4, 0xaa, 0x0d, 0x17, 0x34, 0x18,
    0x71, 0x90, 0x28, 0x31, 0x32, 0xff, 0xd6, 0x8f, 0x4f,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8018[65] = {
    0x04, 0x2e, 0x1b, 0x4f, 0xa4, 0x84, 0x31, 0x83, 0x25, 0x4a, 0xa5, 0x34, 0xc6, 0xe4, 0xf6, 0x42, 0xf2,
    0xec, 0x82, 0xbd, 0xd7, 0xe6, 0xb2, 0x8b, 0xb4, 0x50, 0x6e, 0xc8, 0xee, 0xa6, 0xb5, 0xb5, 0x63, 0x6a,
    0x51, 0x82, 0x23, 0xc0, 0x72, 0x82, 0x38, 0x7c, 0x34, 0xd5, 0x03, 0x03, 0xac, 0xbb, 0xbf, 0xd0, 0xec,
    0x4e, 0x90, 0x84, 0xdc, 0x3f, 0xf6, 0x15, 0xab, 0x64, 0xd3, 0x1c, 0x90, 0xb3, 0xf2,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8018[32] = {
    0xb3, 0xd2, 0xb5, 0x2d, 0x8a, 0x0c, 0x7c, 0xad, 0x32, 0x0c, 0xef, 0x91, 0x24, 0x4b, 0x2c, 0xbf,
    0xfe, 0x28, 0x68, 0xdd, 0x87, 0x86, 0xbd, 0x4e, 0xa4, 0x74, 0xbf, 0x2a, 0x1f, 0x78, 0xff, 0xbc,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8018);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8018);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8018);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8019
const uint8_t kDevelopmentDAC_Cert_FFF2_8019[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x7d, 0xf7, 0xec, 0x3e, 0xbb, 0x0f,
    0x52, 0x73, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x39, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x39, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x53, 0xaf, 0x09, 0xcc, 0xd0, 0xe6, 0x0e, 0x83,
    0xcc, 0x89, 0xaa, 0x64, 0xff, 0xfc, 0x50, 0x5f, 0x5f, 0xc6, 0x7b, 0x6d, 0xbb, 0xcb, 0x42, 0xb4, 0x12, 0x04, 0x24, 0x20, 0x20,
    0xfd, 0x6a, 0x21, 0xf0, 0x85, 0xa1, 0x88, 0x48, 0x37, 0xa8, 0x4a, 0x39, 0xf8, 0xe3, 0x5a, 0xb7, 0xba, 0x33, 0xc1, 0x73, 0xca,
    0xd8, 0x5e, 0x8b, 0x8d, 0x58, 0x4b, 0xd5, 0x81, 0xdc, 0xb5, 0x8a, 0x4d, 0x27, 0xda, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x66, 0x91, 0x96, 0xde,
    0x15, 0x9d, 0x96, 0x71, 0x3f, 0x2b, 0xb8, 0xe4, 0x19, 0x9b, 0x80, 0x48, 0x40, 0x2a, 0x1e, 0x9e, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0x8a, 0xd7, 0xf5, 0x64, 0x25, 0x83, 0xdc, 0x6d, 0x93, 0xac, 0xae, 0x62, 0x56, 0x59, 0x4c,
    0x24, 0xd4, 0x8e, 0xa6, 0x90, 0x42, 0x25, 0x60, 0x1e, 0xd1, 0x60, 0x07, 0x9b, 0x1a, 0xf3, 0x82, 0xda, 0x02, 0x20, 0x3b, 0x3e,
    0x90, 0x23, 0x54, 0x85, 0xe5, 0xf5, 0x16, 0xab, 0xb7, 0x02, 0xfd, 0x0e, 0x39, 0x5a, 0x31, 0x68, 0x17, 0x82, 0xf5, 0xb0, 0x91,
    0xc7, 0x19, 0xf5, 0x1c, 0x1d, 0x76, 0x75, 0x1b, 0xcb,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_8019[65] = {
    0x04, 0x53, 0xaf, 0x09, 0xcc, 0xd0, 0xe6, 0x0e, 0x83, 0xcc, 0x89, 0xaa, 0x64, 0xff, 0xfc, 0x50, 0x5f,
    0x5f, 0xc6, 0x7b, 0x6d, 0xbb, 0xcb, 0x42, 0xb4, 0x12, 0x04, 0x24, 0x20, 0x20, 0xfd, 0x6a, 0x21, 0xf0,
    0x85, 0xa1, 0x88, 0x48, 0x37, 0xa8, 0x4a, 0x39, 0xf8, 0xe3, 0x5a, 0xb7, 0xba, 0x33, 0xc1, 0x73, 0xca,
    0xd8, 0x5e, 0x8b, 0x8d, 0x58, 0x4b, 0xd5, 0x81, 0xdc, 0xb5, 0x8a, 0x4d, 0x27, 0xda,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_8019[32] = {
    0x65, 0x99, 0x1d, 0x94, 0xe7, 0x78, 0x09, 0x54, 0xcb, 0xf0, 0x37, 0xee, 0x49, 0xca, 0x37, 0xff,
    0xbd, 0x6c, 0x5e, 0x34, 0xa5, 0x12, 0xa7, 0xae, 0x78, 0xee, 0x97, 0x4e, 0xdc, 0x53, 0x10, 0xda,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_8019);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_8019);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_8019);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801A
const uint8_t kDevelopmentDAC_Cert_FFF2_801A[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x45, 0x7b, 0xca, 0x88, 0x95, 0x25,
    0xbc, 0xb4, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x41, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x41, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xd7, 0xb3, 0x8c, 0xea, 0x97, 0x37, 0x30, 0x8c,
    0x13, 0x28, 0x24, 0xfb, 0x45, 0x4a, 0x64, 0x95, 0x77, 0x0a, 0xa9, 0x3b, 0xa1, 0x91, 0x28, 0xd8, 0xe1, 0xea, 0x0a, 0xcf, 0xd3,
    0xcd, 0xf8, 0x65, 0x03, 0x85, 0x49, 0xcd, 0x39, 0x8d, 0xdf, 0xea, 0x18, 0xc0, 0xa3, 0x4a, 0x85, 0xd7, 0x63, 0xa7, 0x2c, 0xf5,
    0xc4, 0xba, 0x62, 0x10, 0xb4, 0x00, 0x44, 0xdb, 0x04, 0xbf, 0x57, 0x74, 0x2d, 0x79, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x5c, 0x70, 0xcf, 0x06,
    0xff, 0x56, 0x76, 0x0e, 0x82, 0x5c, 0x89, 0xd8, 0xdb, 0xe0, 0x4b, 0x90, 0x7c, 0x1f, 0xdd, 0x66, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x3d, 0xad, 0x48, 0x13, 0x45, 0x64, 0x50, 0x40, 0x48, 0x97, 0x70, 0xe0, 0x52, 0x7d, 0x1b, 0xe3,
    0x87, 0x80, 0x0d, 0x81, 0xee, 0xa8, 0x8e, 0x50, 0xbf, 0x1e, 0xc9, 0x91, 0x25, 0x3a, 0x68, 0x71, 0x02, 0x21, 0x00, 0xfd, 0x19,
    0x68, 0x9f, 0xe3, 0x3f, 0x1f, 0x99, 0x27, 0x41, 0xb5, 0x1c, 0x30, 0xed, 0x0f, 0x7c, 0x83, 0x59, 0x36, 0x81, 0x4a, 0x81, 0xec,
    0x35, 0x5f, 0x82, 0xd7, 0x2d, 0x03, 0xa4, 0x83, 0xc1,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_801A[65] = {
    0x04, 0xd7, 0xb3, 0x8c, 0xea, 0x97, 0x37, 0x30, 0x8c, 0x13, 0x28, 0x24, 0xfb, 0x45, 0x4a, 0x64, 0x95,
    0x77, 0x0a, 0xa9, 0x3b, 0xa1, 0x91, 0x28, 0xd8, 0xe1, 0xea, 0x0a, 0xcf, 0xd3, 0xcd, 0xf8, 0x65, 0x03,
    0x85, 0x49, 0xcd, 0x39, 0x8d, 0xdf, 0xea, 0x18, 0xc0, 0xa3, 0x4a, 0x85, 0xd7, 0x63, 0xa7, 0x2c, 0xf5,
    0xc4, 0xba, 0x62, 0x10, 0xb4, 0x00, 0x44, 0xdb, 0x04, 0xbf, 0x57, 0x74, 0x2d, 0x79,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_801A[32] = {
    0x9f, 0x7f, 0x35, 0x06, 0x1a, 0xb3, 0xd8, 0x78, 0x63, 0xe2, 0xbf, 0x0b, 0x85, 0x74, 0xba, 0x6c,
    0xcc, 0x4c, 0x2e, 0x4f, 0x37, 0x81, 0xce, 0x83, 0xd6, 0xe6, 0xfd, 0xb1, 0xd6, 0x44, 0xb6, 0xce,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_801A);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_801A);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_801A);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801B
const uint8_t kDevelopmentDAC_Cert_FFF2_801B[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x65, 0xc6, 0x34, 0x9f, 0x73, 0xc6,
    0xa7, 0x7f, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x42, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x42, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xe9, 0x93, 0xab, 0x75, 0x2d, 0xfc, 0xb2, 0xff,
    0x7d, 0x88, 0xc5, 0xc2, 0x44, 0xd2, 0x4c, 0x27, 0xd7, 0xfe, 0xe1, 0x04, 0x35, 0x49, 0xc2, 0xe1, 0xed, 0x88, 0x7f, 0xef, 0xf3,
    0x71, 0xad, 0xe5, 0x58, 0x70, 0xf4, 0x04, 0x85, 0x69, 0xa9, 0xcf, 0x00, 0xf7, 0xc1, 0xf3, 0x78, 0x82, 0x7c, 0x5c, 0x05, 0xdb,
    0xb2, 0x79, 0x6f, 0x99, 0x3f, 0x36, 0x7f, 0xd1, 0xc0, 0x0e, 0x89, 0x72, 0xc0, 0xdb, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x31, 0x4d, 0x5d, 0x32,
    0x3a, 0x84, 0xca, 0x5e, 0xcf, 0x92, 0xc6, 0xbe, 0x81, 0xad, 0xee, 0x83, 0x2a, 0x46, 0xdf, 0x6a, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x56, 0x2c, 0x8c, 0x8d, 0xd5, 0x3d, 0x1a, 0xd7, 0xbe, 0xd4, 0xd4, 0xbc, 0x6c, 0xc9, 0x79, 0xab,
    0x2c, 0x2b, 0xee, 0x9c, 0x50, 0x20, 0x69, 0x3f, 0x1e, 0xe3, 0x86, 0xc6, 0x44, 0x70, 0xff, 0xa8, 0x02, 0x21, 0x00, 0x9b, 0x3a,
    0xc8, 0xa5, 0xc2, 0x64, 0xa4, 0x47, 0x07, 0x92, 0x55, 0x1a, 0x60, 0x42, 0xf9, 0x50, 0x60, 0xc9, 0x48, 0xd6, 0xb4, 0x38, 0x91,
    0xd2, 0x04, 0xf1, 0xf1, 0xe5, 0xda, 0x53, 0x78, 0xe2,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_801B[65] = {
    0x04, 0xe9, 0x93, 0xab, 0x75, 0x2d, 0xfc, 0xb2, 0xff, 0x7d, 0x88, 0xc5, 0xc2, 0x44, 0xd2, 0x4c, 0x27,
    0xd7, 0xfe, 0xe1, 0x04, 0x35, 0x49, 0xc2, 0xe1, 0xed, 0x88, 0x7f, 0xef, 0xf3, 0x71, 0xad, 0xe5, 0x58,
    0x70, 0xf4, 0x04, 0x85, 0x69, 0xa9, 0xcf, 0x00, 0xf7, 0xc1, 0xf3, 0x78, 0x82, 0x7c, 0x5c, 0x05, 0xdb,
    0xb2, 0x79, 0x6f, 0x99, 0x3f, 0x36, 0x7f, 0xd1, 0xc0, 0x0e, 0x89, 0x72, 0xc0, 0xdb,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_801B[32] = {
    0xc7, 0xcc, 0x83, 0x64, 0xac, 0x2b, 0x80, 0x38, 0x3b, 0xdd, 0x71, 0xc6, 0xc6, 0x20, 0x64, 0x77,
    0x8b, 0xa2, 0xc3, 0xb7, 0x52, 0xe1, 0x41, 0x6e, 0x2f, 0xba, 0x60, 0x62, 0xc5, 0x30, 0x66, 0xaf,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_801B);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_801B);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_801B);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801C
const uint8_t kDevelopmentDAC_Cert_FFF2_801C[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x4c, 0x3b, 0x3c, 0xfc, 0xe6, 0x60,
    0xa5, 0xe3, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x43, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x43, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x8c, 0x81, 0x52, 0x7c, 0x4b, 0x09, 0xc9, 0x47,
    0xbd, 0x5a, 0x76, 0xc7, 0x4b, 0xbe, 0xba, 0x1a, 0x92, 0xaf, 0x08, 0xb1, 0x5e, 0x87, 0xf8, 0xc5, 0x00, 0x41, 0x97, 0x7f, 0x51,
    0x0f, 0x70, 0x05, 0x4b, 0xc5, 0x62, 0xbd, 0x48, 0x34, 0xd3, 0xf2, 0xd3, 0xd0, 0x4a, 0xae, 0x4f, 0xe8, 0xb9, 0x23, 0x33, 0xcb,
    0xc4, 0xca, 0x9c, 0x3a, 0x95, 0x71, 0xd7, 0x00, 0xc7, 0xdc, 0x5c, 0x8a, 0x6c, 0x23, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x46, 0x2c, 0x5d, 0x48,
    0x8b, 0xa4, 0x68, 0x24, 0xcd, 0x47, 0x68, 0xba, 0x82, 0x77, 0x00, 0xab, 0xca, 0x06, 0x70, 0x1b, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xac, 0x5e, 0xec, 0x0e, 0x18, 0xbb, 0xe7, 0xb9, 0x9d, 0x1c, 0x24, 0x61, 0xa5, 0xb9, 0x6b,
    0x7b, 0x24, 0x6e, 0x15, 0xbf, 0xd6, 0x91, 0xe0, 0xad, 0xaf, 0xa0, 0x3b, 0x37, 0x45, 0x1f, 0x58, 0x89, 0x02, 0x21, 0x00, 0xb2,
    0xa3, 0x2f, 0xbb, 0x69, 0xcb, 0x1a, 0xb0, 0x67, 0x9e, 0x7e, 0x51, 0x9b, 0x9e, 0x59, 0x70, 0x61, 0xc6, 0x34, 0x2d, 0x72, 0xc9,
    0xcd, 0xc9, 0xc3, 0xf4, 0x89, 0xbb, 0xd6, 0xef, 0x67, 0x77,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_801C[65] = {
    0x04, 0x8c, 0x81, 0x52, 0x7c, 0x4b, 0x09, 0xc9, 0x47, 0xbd, 0x5a, 0x76, 0xc7, 0x4b, 0xbe, 0xba, 0x1a,
    0x92, 0xaf, 0x08, 0xb1, 0x5e, 0x87, 0xf8, 0xc5, 0x00, 0x41, 0x97, 0x7f, 0x51, 0x0f, 0x70, 0x05, 0x4b,
    0xc5, 0x62, 0xbd, 0x48, 0x34, 0xd3, 0xf2, 0xd3, 0xd0, 0x4a, 0xae, 0x4f, 0xe8, 0xb9, 0x23, 0x33, 0xcb,
    0xc4, 0xca, 0x9c, 0x3a, 0x95, 0x71, 0xd7, 0x00, 0xc7, 0xdc, 0x5c, 0x8a, 0x6c, 0x23,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_801C[32] = {
    0xb8, 0x5a, 0x6a, 0x37, 0x02, 0x52, 0xc5, 0x57, 0xe6, 0x62, 0x9c, 0x8a, 0xf2, 0xf2, 0xa4, 0xea,
    0x3b, 0xbc, 0x48, 0x8c, 0x68, 0xc1, 0xbc, 0x8d, 0x73, 0x13, 0x7f, 0x6f, 0xb5, 0xcd, 0x3c, 0x9b,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_801C);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_801C);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_801C);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801D
const uint8_t kDevelopmentDAC_Cert_FFF2_801D[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x6b, 0x11, 0xc5, 0xa9, 0x97, 0xe0,
    0x93, 0x75, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x44, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xd8, 0xe1, 0x23, 0x5e, 0x6e, 0x37, 0xe2, 0xde,
    0x10, 0xfc, 0x79, 0x27, 0xf6, 0x95, 0x71, 0x4b, 0xed, 0xd2, 0x3b, 0x1f, 0xb9, 0x8d, 0x3a, 0x64, 0x6d, 0xd8, 0x4f, 0xcf, 0x11,
    0x12, 0x6b, 0x35, 0xc1, 0xa4, 0x42, 0xe7, 0xcf, 0xd8, 0x71, 0xb1, 0x94, 0x0f, 0x25, 0x28, 0xf6, 0x4a, 0x0c, 0x5a, 0xf7, 0x6c,
    0xf1, 0x52, 0xdc, 0xc8, 0x68, 0x25, 0x14, 0xeb, 0xb2, 0x0a, 0x4f, 0x49, 0x25, 0x00, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xf3, 0x61, 0xd7, 0x9f,
    0xce, 0x99, 0xa2, 0xe1, 0x44, 0x58, 0x34, 0x70, 0x7b, 0xfa, 0xcc, 0x01, 0x10, 0x0d, 0x87, 0xc1, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xb4, 0x30, 0x73, 0x49, 0x03, 0xee, 0x8f, 0xf4, 0x8b, 0xc5, 0x7f, 0x27, 0xae, 0x1c, 0x0c,
    0x86, 0xf7, 0x1e, 0xd8, 0x29, 0x8e, 0x30, 0xc8, 0xf1, 0xd3, 0xc5, 0x68, 0xe1, 0xd2, 0x34, 0x75, 0x1e, 0x02, 0x20, 0x40, 0x49,
    0x0d, 0xe4, 0xe8, 0x9d, 0xa1, 0xed, 0xe2, 0xec, 0x54, 0x29, 0x67, 0xeb, 0xbd, 0x3d, 0xb6, 0x90, 0x32, 0x31, 0x5b, 0x54, 0xc2,
    0xe2, 0xc3, 0x70, 0x5c, 0x87, 0xab, 0x0b, 0x5d, 0x5f,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_801D[65] = {
    0x04, 0xd8, 0xe1, 0x23, 0x5e, 0x6e, 0x37, 0xe2, 0xde, 0x10, 0xfc, 0x79, 0x27, 0xf6, 0x95, 0x71, 0x4b,
    0xed, 0xd2, 0x3b, 0x1f, 0xb9, 0x8d, 0x3a, 0x64, 0x6d, 0xd8, 0x4f, 0xcf, 0x11, 0x12, 0x6b, 0x35, 0xc1,
    0xa4, 0x42, 0xe7, 0xcf, 0xd8, 0x71, 0xb1, 0x94, 0x0f, 0x25, 0x28, 0xf6, 0x4a, 0x0c, 0x5a, 0xf7, 0x6c,
    0xf1, 0x52, 0xdc, 0xc8, 0x68, 0x25, 0x14, 0xeb, 0xb2, 0x0a, 0x4f, 0x49, 0x25, 0x00,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_801D[32] = {
    0x87, 0xc5, 0x65, 0x55, 0x7d, 0xaa, 0x33, 0xc4, 0x16, 0xd8, 0x53, 0xdb, 0xe1, 0x14, 0x66, 0xa4,
    0x01, 0x5a, 0x8c, 0x1c, 0x7a, 0xd5, 0xfd, 0x74, 0x9c, 0xf4, 0x12, 0x33, 0x81, 0xc0, 0x85, 0x24,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_801D);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_801D);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_801D);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801E
const uint8_t kDevelopmentDAC_Cert_FFF2_801E[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x55, 0x21, 0xb7, 0x2a, 0xf5, 0xb9,
    0x22, 0x88, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x45, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x45, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xca, 0xa6, 0xf6, 0x74, 0xfa, 0x2b, 0x19, 0x46,
    0xd9, 0x72, 0x14, 0x18, 0x73, 0x08, 0x76, 0x8b, 0x63, 0xf7, 0x28, 0xcc, 0x91, 0x97, 0xe2, 0x9b, 0xde, 0x0e, 0x1b, 0xc8, 0xd7,
    0xa5, 0xb2, 0xd9, 0x90, 0xb9, 0x6e, 0x2b, 0x73, 0xf1, 0x9f, 0x05, 0xc3, 0xe6, 0x06, 0x11, 0x50, 0x78, 0xa5, 0xa3, 0x44, 0xe0,
    0x61, 0x12, 0xf1, 0x43, 0x44, 0xbd, 0xc3, 0x18, 0xb1, 0xfb, 0xec, 0xd5, 0x2c, 0xc6, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x13, 0x20, 0xd7, 0x24,
    0x14, 0xe4, 0x39, 0x21, 0xe5, 0xcb, 0x6e, 0xd7, 0xaf, 0x66, 0xd0, 0x02, 0x73, 0x76, 0xd8, 0x79, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x36, 0x93, 0x9b, 0x2a, 0xde, 0x1e, 0x98, 0x28, 0x3d, 0xca, 0xb4, 0x6c, 0xab, 0xfd, 0xb7, 0xfa,
    0xbc, 0x81, 0x96, 0x17, 0xb5, 0x6d, 0x0f, 0x35, 0xaa, 0x1e, 0x83, 0x9d, 0xfa, 0x69, 0x6e, 0x74, 0x02, 0x20, 0x6e, 0xc1, 0x39,
    0x9d, 0x1e, 0x54, 0x21, 0x0c, 0x18, 0x35, 0x47, 0xe0, 0x10, 0x0d, 0xc5, 0xb4, 0xc9, 0x7b, 0x93, 0x8a, 0x48, 0xc9, 0xaa, 0xf0,
    0x31, 0x36, 0xa4, 0xfc, 0x9c, 0xaa, 0x50, 0x5f,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_801E[65] = {
    0x04, 0xca, 0xa6, 0xf6, 0x74, 0xfa, 0x2b, 0x19, 0x46, 0xd9, 0x72, 0x14, 0x18, 0x73, 0x08, 0x76, 0x8b,
    0x63, 0xf7, 0x28, 0xcc, 0x91, 0x97, 0xe2, 0x9b, 0xde, 0x0e, 0x1b, 0xc8, 0xd7, 0xa5, 0xb2, 0xd9, 0x90,
    0xb9, 0x6e, 0x2b, 0x73, 0xf1, 0x9f, 0x05, 0xc3, 0xe6, 0x06, 0x11, 0x50, 0x78, 0xa5, 0xa3, 0x44, 0xe0,
    0x61, 0x12, 0xf1, 0x43, 0x44, 0xbd, 0xc3, 0x18, 0xb1, 0xfb, 0xec, 0xd5, 0x2c, 0xc6,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_801E[32] = {
    0x56, 0xef, 0x8a, 0xd1, 0x42, 0x63, 0xdc, 0x0b, 0x67, 0x8e, 0x96, 0x90, 0xad, 0x77, 0x09, 0x18,
    0x1b, 0xa6, 0x41, 0x55, 0x57, 0x13, 0x2f, 0x6d, 0xa5, 0xf5, 0xb1, 0x7f, 0xa8, 0x2b, 0xb7, 0x11,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_801E);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_801E);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_801E);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801F
const uint8_t kDevelopmentDAC_Cert_FFF2_801F[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x66, 0x1f, 0xa2, 0xc0, 0x92, 0x43,
    0x94, 0xe8, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x32, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x46, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x46, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x0a, 0x29, 0x69, 0xf8, 0x81, 0xf7, 0x01, 0x98,
    0x58, 0x27, 0x80, 0xa4, 0x39, 0x48, 0x09, 0xe4, 0xf1, 0x3d, 0x38, 0x7e, 0x68, 0x13, 0x31, 0xea, 0x17, 0x11, 0x19, 0x6f, 0xaa,
    0x80, 0x93, 0xe9, 0x85, 0xe1, 0x83, 0x67, 0x45, 0x97, 0xa7, 0xea, 0xe8, 0xa9, 0xa2, 0x27, 0xee, 0xd2, 0x7b, 0x70, 0x1c, 0xf0,
    0x49, 0x7a, 0xf3, 0x8b, 0x80, 0x13, 0x29, 0x59, 0x66, 0x93, 0x6d, 0x47, 0x86, 0x51, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xa7, 0x22, 0x27, 0x27,
    0x90, 0xd8, 0x26, 0x82, 0x8a, 0x04, 0xc9, 0xfc, 0xdc, 0x3a, 0x77, 0x66, 0x62, 0x23, 0x49, 0x42, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x04, 0xce, 0x5b, 0xa1, 0x90, 0xfe, 0xc1, 0x69, 0x1f, 0x44, 0x63, 0x35, 0x44, 0xc4, 0x79, 0x77,
    0x71, 0x09, 0x1f, 0x23, 0x4b, 0x3c, 0xfe, 0xaf, 0x59, 0xde, 0x88, 0xc0, 0x20, 0x73, 0x36, 0xe5, 0x02, 0x20, 0x2d, 0x1c, 0x5f,
    0xc7, 0x1f, 0xee, 0xf0, 0x37, 0x28, 0x36, 0xb7, 0x62, 0x64, 0x0b, 0xfa, 0x7a, 0x2c, 0xe3, 0x30, 0x71, 0x9d, 0x55, 0xbd, 0x6c,
    0xbb, 0xbd, 0xee, 0xbb, 0xf9, 0x25, 0x78, 0x85,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF2_801F[65] = {
    0x04, 0x0a, 0x29, 0x69, 0xf8, 0x81, 0xf7, 0x01, 0x98, 0x58, 0x27, 0x80, 0xa4, 0x39, 0x48, 0x09, 0xe4,
    0xf1, 0x3d, 0x38, 0x7e, 0x68, 0x13, 0x31, 0xea, 0x17, 0x11, 0x19, 0x6f, 0xaa, 0x80, 0x93, 0xe9, 0x85,
    0xe1, 0x83, 0x67, 0x45, 0x97, 0xa7, 0xea, 0xe8, 0xa9, 0xa2, 0x27, 0xee, 0xd2, 0x7b, 0x70, 0x1c, 0xf0,
    0x49, 0x7a, 0xf3, 0x8b, 0x80, 0x13, 0x29, 0x59, 0x66, 0x93, 0x6d, 0x47, 0x86, 0x51,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF2_801F[32] = {
    0x01, 0xd3, 0x8b, 0x6e, 0x9c, 0x63, 0xe2, 0x0f, 0x91, 0x46, 0x46, 0x25, 0x4e, 0x58, 0xb3, 0xa3,
    0x8f, 0xea, 0xa7, 0xf2, 0x1e, 0x71, 0x4d, 0xb0, 0xa3, 0xda, 0x66, 0xe7, 0xb2, 0x62, 0x1d, 0xf0,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF2_801F);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF2_801F);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF2_801F);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8000
const uint8_t kDevelopmentDAC_Cert_FFF3_8000[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x49, 0xa5, 0x4a, 0x7e, 0xfc, 0xac,
    0xf3, 0xd4, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x30, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x30, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x85, 0xef, 0x3b, 0xde, 0xc7, 0x59, 0x2b, 0xbf,
    0xd0, 0xc8, 0xd1, 0x71, 0x3e, 0x95, 0x9f, 0x3a, 0x51, 0x48, 0x3c, 0xcf, 0x56, 0x13, 0xfe, 0x40, 0x85, 0x22, 0x8b, 0x9f, 0xfb,
    0xff, 0x33, 0x92, 0x7e, 0xb4, 0xa0, 0xc0, 0xb7, 0x82, 0x5c, 0x9f, 0xd6, 0x25, 0x56, 0x8b, 0xba, 0x69, 0x20, 0xc7, 0x5e, 0x93,
    0xb3, 0x64, 0x86, 0x77, 0xb2, 0x1b, 0x8a, 0x57, 0x74, 0xd1, 0x69, 0x94, 0xb3, 0xca, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x8c, 0x04, 0x9a, 0xce,
    0xc1, 0x60, 0x89, 0x67, 0xc4, 0xa3, 0x28, 0xa1, 0xaa, 0x5e, 0xd2, 0xe5, 0x64, 0xf6, 0x10, 0xfd, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x10, 0x15, 0xb5, 0xbe, 0x36, 0x4b, 0x80, 0x3f, 0x1e, 0x9d, 0x2f, 0x64, 0x61, 0x00, 0xeb, 0xbc,
    0x3d, 0x13, 0x53, 0x9c, 0x66, 0x4a, 0xea, 0xda, 0xc9, 0xbd, 0x0d, 0x23, 0xee, 0xee, 0x41, 0xf6, 0x02, 0x21, 0x00, 0xad, 0xca,
    0xb1, 0x20, 0xed, 0x41, 0x48, 0xb8, 0x06, 0x41, 0x41, 0x62, 0xb4, 0xd5, 0x42, 0xbb, 0x2e, 0xd0, 0x97, 0x40, 0x52, 0x4d, 0xdf,
    0xf3, 0xfd, 0xef, 0xe5, 0x9d, 0x6a, 0x7b, 0x26, 0x61,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8000[65] = {
    0x04, 0x85, 0xef, 0x3b, 0xde, 0xc7, 0x59, 0x2b, 0xbf, 0xd0, 0xc8, 0xd1, 0x71, 0x3e, 0x95, 0x9f, 0x3a,
    0x51, 0x48, 0x3c, 0xcf, 0x56, 0x13, 0xfe, 0x40, 0x85, 0x22, 0x8b, 0x9f, 0xfb, 0xff, 0x33, 0x92, 0x7e,
    0xb4, 0xa0, 0xc0, 0xb7, 0x82, 0x5c, 0x9f, 0xd6, 0x25, 0x56, 0x8b, 0xba, 0x69, 0x20, 0xc7, 0x5e, 0x93,
    0xb3, 0x64, 0x86, 0x77, 0xb2, 0x1b, 0x8a, 0x57, 0x74, 0xd1, 0x69, 0x94, 0xb3, 0xca,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8000[32] = {
    0x0a, 0x92, 0xdf, 0x57, 0xc2, 0xbb, 0xdd, 0x29, 0x2e, 0x43, 0x0d, 0x4d, 0x7d, 0xf9, 0xdf, 0xaa,
    0xd5, 0xcc, 0x57, 0x8f, 0xde, 0x5a, 0xa3, 0xf3, 0xdb, 0x3d, 0xf3, 0x01, 0x65, 0xbf, 0x35, 0x6b,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8000);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8000);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8000);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8001
const uint8_t kDevelopmentDAC_Cert_FFF3_8001[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x28, 0xf6, 0x0c, 0xc9, 0x74, 0x12,
    0x2b, 0x6f, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x31, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x31, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x97, 0x77, 0x63, 0x37, 0x9f, 0x88, 0xa9, 0xa4,
    0x99, 0xba, 0xfd, 0xf5, 0x31, 0xad, 0x4b, 0x1b, 0xcd, 0xff, 0xd1, 0x00, 0x86, 0xc0, 0x02, 0x29, 0xda, 0xdc, 0xbd, 0xdb, 0xf1,
    0x42, 0x5a, 0x1f, 0xa2, 0xc0, 0x5c, 0x9d, 0x22, 0x35, 0x9e, 0x7d, 0x7b, 0xf8, 0x5d, 0xab, 0xd4, 0xf3, 0xb1, 0x7d, 0x7d, 0xdb,
    0x18, 0xcd, 0xe6, 0x79, 0x18, 0x9c, 0x22, 0x70, 0x7d, 0x0e, 0x3d, 0xb4, 0x99, 0xf8, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x55, 0x4f, 0x29, 0xc3,
    0xe5, 0x7b, 0x6d, 0x20, 0xc4, 0x54, 0x7e, 0x93, 0x05, 0x82, 0xb3, 0x23, 0x0b, 0xbe, 0x7c, 0xd1, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x7a, 0x9d, 0xfc, 0xf5, 0xa7, 0x26, 0x30, 0x0b, 0x96, 0x10, 0x09, 0x28, 0x3f, 0x6d, 0x95, 0x88,
    0x9b, 0x50, 0x4d, 0xfe, 0xb6, 0x7e, 0x72, 0xf4, 0xd2, 0x76, 0xb7, 0x76, 0xcc, 0x14, 0xae, 0x45, 0x02, 0x21, 0x00, 0x87, 0xc9,
    0xe5, 0x7d, 0x95, 0x03, 0x21, 0x1d, 0x8f, 0xac, 0x41, 0xb0, 0xb8, 0x3a, 0x99, 0xee, 0x9c, 0xda, 0x4f, 0xea, 0x1e, 0x5f, 0xc4,
    0xdd, 0xe5, 0xaf, 0x3a, 0x7c, 0xd6, 0xf3, 0xcc, 0xb6,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8001[65] = {
    0x04, 0x97, 0x77, 0x63, 0x37, 0x9f, 0x88, 0xa9, 0xa4, 0x99, 0xba, 0xfd, 0xf5, 0x31, 0xad, 0x4b, 0x1b,
    0xcd, 0xff, 0xd1, 0x00, 0x86, 0xc0, 0x02, 0x29, 0xda, 0xdc, 0xbd, 0xdb, 0xf1, 0x42, 0x5a, 0x1f, 0xa2,
    0xc0, 0x5c, 0x9d, 0x22, 0x35, 0x9e, 0x7d, 0x7b, 0xf8, 0x5d, 0xab, 0xd4, 0xf3, 0xb1, 0x7d, 0x7d, 0xdb,
    0x18, 0xcd, 0xe6, 0x79, 0x18, 0x9c, 0x22, 0x70, 0x7d, 0x0e, 0x3d, 0xb4, 0x99, 0xf8,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8001[32] = {
    0x34, 0x5b, 0x8d, 0xd7, 0xd0, 0x75, 0xa4, 0xc7, 0xb3, 0xcb, 0x73, 0x29, 0x8a, 0x43, 0x78, 0x16,
    0x4b, 0xf6, 0x15, 0xdc, 0x81, 0xbf, 0x91, 0x70, 0x0b, 0x7f, 0xde, 0x40, 0xdd, 0xa4, 0x65, 0x04,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8001);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8001);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8001);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8002
const uint8_t kDevelopmentDAC_Cert_FFF3_8002[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x67, 0xee, 0x26, 0x91, 0xff, 0x4d,
    0x39, 0x69, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x32, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x32, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xf7, 0x05, 0x3d, 0xf1, 0xaa, 0x87, 0x1e, 0x19,
    0x05, 0x11, 0x6d, 0xb5, 0x36, 0x88, 0x99, 0xbd, 0xfa, 0x80, 0x5a, 0x6d, 0xa8, 0x16, 0x20, 0x7b, 0xcc, 0x34, 0x0e, 0x7d, 0xcf,
    0x7c, 0xf5, 0x42, 0x86, 0x34, 0x4a, 0xf3, 0x40, 0x9a, 0x73, 0x8e, 0x57, 0x6f, 0xc5, 0xc0, 0xcd, 0xf3, 0x80, 0x81, 0xe0, 0x9d,
    0x38, 0x31, 0x77, 0xf4, 0x53, 0xe7, 0xce, 0xe4, 0x58, 0xbe, 0x44, 0xe6, 0x6f, 0x52, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x4c, 0xb3, 0xb3, 0x80,
    0xe4, 0xd1, 0xc9, 0x40, 0x10, 0x26, 0x66, 0x96, 0x26, 0x80, 0xad, 0x64, 0xb6, 0xaa, 0x8b, 0x34, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x10, 0x05, 0x03, 0x1d, 0xa9, 0xd2, 0x87, 0xf5, 0x87, 0x36, 0x43, 0x9f, 0x08, 0x3c, 0x99, 0xfe,
    0x02, 0x64, 0x23, 0x07, 0xca, 0x93, 0x22, 0x49, 0x36, 0xbc, 0xd3, 0x7e, 0x97, 0x0d, 0x6d, 0x4c, 0x02, 0x20, 0x05, 0xa6, 0xcd,
    0xfe, 0x44, 0x22, 0x15, 0xe6, 0xbb, 0xac, 0x39, 0xd7, 0x73, 0x8a, 0x3f, 0x07, 0x14, 0x4f, 0x2a, 0xbb, 0x7d, 0x4c, 0x58, 0x55,
    0x0a, 0xe1, 0xd0, 0xd8, 0x75, 0xf5, 0xe5, 0x43,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8002[65] = {
    0x04, 0xf7, 0x05, 0x3d, 0xf1, 0xaa, 0x87, 0x1e, 0x19, 0x05, 0x11, 0x6d, 0xb5, 0x36, 0x88, 0x99, 0xbd,
    0xfa, 0x80, 0x5a, 0x6d, 0xa8, 0x16, 0x20, 0x7b, 0xcc, 0x34, 0x0e, 0x7d, 0xcf, 0x7c, 0xf5, 0x42, 0x86,
    0x34, 0x4a, 0xf3, 0x40, 0x9a, 0x73, 0x8e, 0x57, 0x6f, 0xc5, 0xc0, 0xcd, 0xf3, 0x80, 0x81, 0xe0, 0x9d,
    0x38, 0x31, 0x77, 0xf4, 0x53, 0xe7, 0xce, 0xe4, 0x58, 0xbe, 0x44, 0xe6, 0x6f, 0x52,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8002[32] = {
    0x57, 0xe1, 0xf5, 0xc2, 0xd6, 0x20, 0x2e, 0xd3, 0x0f, 0x5d, 0x64, 0xd2, 0x97, 0x9c, 0x92, 0x31,
    0x95, 0x53, 0x69, 0x17, 0xab, 0xb0, 0xf7, 0xf5, 0x66, 0x12, 0x6a, 0x47, 0x7b, 0x37, 0x60, 0x82,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8002);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8002);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8002);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8003
const uint8_t kDevelopmentDAC_Cert_FFF3_8003[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x28, 0xd6, 0x90, 0x57, 0xeb, 0xcc,
    0x86, 0xe5, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x33, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x0d, 0xc5, 0x9b, 0xea, 0x0a, 0x9c, 0x4c, 0x09,
    0x1c, 0x0f, 0xeb, 0x54, 0x1f, 0xbd, 0x3d, 0xf7, 0x88, 0x95, 0x91, 0xc5, 0x3c, 0xc6, 0x16, 0x1a, 0x5d, 0x1d, 0x6b, 0x4e, 0xb3,
    0xa4, 0x39, 0x91, 0xa3, 0x7f, 0x56, 0xc1, 0x2d, 0xeb, 0x77, 0xfe, 0x81, 0x71, 0xcb, 0x70, 0xb7, 0x04, 0x75, 0x67, 0x17, 0x20,
    0x6f, 0x39, 0x5a, 0x8a, 0x92, 0x5d, 0x91, 0x62, 0x16, 0x72, 0x1d, 0x6d, 0x07, 0x94, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xbc, 0x1f, 0x58, 0x0c,
    0x94, 0x3c, 0x27, 0x19, 0x84, 0x24, 0x0f, 0x5c, 0x74, 0x94, 0x4e, 0xc6, 0x5d, 0xa6, 0xd5, 0xcc, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0x96, 0x12, 0x3a, 0x4c, 0x27, 0x64, 0x7f, 0x0f, 0x5a, 0x3a, 0x43, 0x56, 0x2c, 0x5e, 0x0b,
    0x30, 0xbe, 0xff, 0xb9, 0x52, 0x43, 0x75, 0x91, 0x5f, 0x90, 0x76, 0xa0, 0x73, 0x95, 0x33, 0x68, 0x67, 0x02, 0x21, 0x00, 0x9d,
    0x6c, 0x0e, 0xc1, 0xfc, 0x84, 0x07, 0x27, 0xaf, 0xd8, 0x76, 0xfe, 0xbe, 0xf2, 0x58, 0x69, 0xb8, 0xb2, 0x51, 0x27, 0xfd, 0x5e,
    0xca, 0x94, 0xa5, 0xd3, 0xd1, 0xe5, 0xd2, 0xb3, 0x7e, 0xa3,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8003[65] = {
    0x04, 0x0d, 0xc5, 0x9b, 0xea, 0x0a, 0x9c, 0x4c, 0x09, 0x1c, 0x0f, 0xeb, 0x54, 0x1f, 0xbd, 0x3d, 0xf7,
    0x88, 0x95, 0x91, 0xc5, 0x3c, 0xc6, 0x16, 0x1a, 0x5d, 0x1d, 0x6b, 0x4e, 0xb3, 0xa4, 0x39, 0x91, 0xa3,
    0x7f, 0x56, 0xc1, 0x2d, 0xeb, 0x77, 0xfe, 0x81, 0x71, 0xcb, 0x70, 0xb7, 0x04, 0x75, 0x67, 0x17, 0x20,
    0x6f, 0x39, 0x5a, 0x8a, 0x92, 0x5d, 0x91, 0x62, 0x16, 0x72, 0x1d, 0x6d, 0x07, 0x94,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8003[32] = {
    0x92, 0xb2, 0x36, 0x15, 0xd9, 0x8c, 0x7c, 0xb1, 0x0c, 0x87, 0x21, 0xc5, 0x32, 0xbc, 0xa0, 0x60,
    0xbf, 0x5e, 0x05, 0x95, 0xfd, 0xdc, 0xa7, 0x85, 0x02, 0xe9, 0xe1, 0x7c, 0x35, 0x51, 0xe9, 0x88,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8003);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8003);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8003);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8004
const uint8_t kDevelopmentDAC_Cert_FFF3_8004[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x7b, 0x7c, 0x1a, 0xdf, 0xf1, 0x64,
    0x35, 0x10, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x34, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x34, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xd7, 0xe3, 0xfe, 0x3c, 0x4b, 0x54, 0xc9, 0xd7,
    0xbd, 0xb0, 0x5f, 0x24, 0xd3, 0x70, 0x77, 0xb4, 0xaf, 0xef, 0x98, 0x34, 0x09, 0xad, 0x35, 0x06, 0x53, 0xe9, 0x68, 0xf5, 0x13,
    0x13, 0x71, 0x0c, 0x2d, 0xbc, 0x17, 0x76, 0x74, 0x95, 0x7e, 0x26, 0xc2, 0xd0, 0x04, 0xac, 0x18, 0x98, 0x58, 0xe4, 0x28, 0xf5,
    0x92, 0x4c, 0x5d, 0xda, 0x18, 0xd0, 0xa1, 0xc5, 0x38, 0x8c, 0x97, 0x2d, 0xe6, 0x1a, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xe8, 0xea, 0x40, 0x02,
    0xa6, 0x67, 0x2c, 0x55, 0x32, 0x16, 0x40, 0x05, 0x50, 0x7b, 0xdd, 0x52, 0x55, 0x29, 0x3a, 0x60, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0x94, 0x5e, 0x0f, 0x5e, 0xa1, 0x98, 0x6d, 0xe1, 0x14, 0x58, 0x84, 0x86, 0x19, 0x2d, 0xf5,
    0xaa, 0x03, 0xca, 0x12, 0xf6, 0x68, 0x7c, 0xfb, 0xeb, 0xd7, 0x71, 0xad, 0x10, 0xb7, 0x15, 0x7f, 0x50, 0x02, 0x21, 0x00, 0xe6,
    0x07, 0x1d, 0xe7, 0x16, 0x57, 0xf7, 0x0f, 0x91, 0x99, 0xd6, 0xfe, 0x5c, 0x67, 0x7f, 0xbe, 0x49, 0x2a, 0x74, 0x07, 0x2d, 0x0e,
    0x7a, 0x2b, 0xea, 0x91, 0x36, 0x5e, 0x80, 0x49, 0x95, 0x55,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8004[65] = {
    0x04, 0xd7, 0xe3, 0xfe, 0x3c, 0x4b, 0x54, 0xc9, 0xd7, 0xbd, 0xb0, 0x5f, 0x24, 0xd3, 0x70, 0x77, 0xb4,
    0xaf, 0xef, 0x98, 0x34, 0x09, 0xad, 0x35, 0x06, 0x53, 0xe9, 0x68, 0xf5, 0x13, 0x13, 0x71, 0x0c, 0x2d,
    0xbc, 0x17, 0x76, 0x74, 0x95, 0x7e, 0x26, 0xc2, 0xd0, 0x04, 0xac, 0x18, 0x98, 0x58, 0xe4, 0x28, 0xf5,
    0x92, 0x4c, 0x5d, 0xda, 0x18, 0xd0, 0xa1, 0xc5, 0x38, 0x8c, 0x97, 0x2d, 0xe6, 0x1a,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8004[32] = {
    0x15, 0x25, 0x94, 0xd3, 0xfd, 0x57, 0x39, 0x88, 0x7a, 0x19, 0x80, 0xcb, 0xcb, 0xb6, 0x77, 0x84,
    0x04, 0xa3, 0x89, 0x01, 0x17, 0x28, 0xb7, 0xd3, 0xcc, 0xe9, 0x80, 0x0b, 0xc4, 0x57, 0x77, 0x7c,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8004);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8004);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8004);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8005
const uint8_t kDevelopmentDAC_Cert_FFF3_8005[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x35, 0x77, 0x04, 0x70, 0xfa, 0x15,
    0xb8, 0x4a, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x35, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x35, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x9d, 0x3b, 0x8a, 0x22, 0x6b, 0x77, 0xd0, 0xc8,
    0x9d, 0x71, 0x29, 0xa3, 0x34, 0x33, 0xdb, 0x6b, 0x57, 0xcd, 0x1a, 0x1e, 0xdc, 0xae, 0x99, 0x01, 0xe8, 0x2c, 0xa2, 0xba, 0xc2,
    0x7e, 0x9f, 0xfc, 0x7c, 0x4a, 0xca, 0xa8, 0x23, 0x84, 0x1f, 0x2b, 0x2e, 0x86, 0x63, 0x07, 0xc6, 0x6d, 0x29, 0x19, 0xf7, 0x99,
    0x4e, 0x63, 0xfc, 0xf8, 0xea, 0x8e, 0x43, 0x4f, 0xe1, 0xe1, 0x4e, 0x1f, 0x40, 0x5c, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x17, 0x4b, 0x11, 0x99,
    0xba, 0x32, 0x85, 0xe7, 0xc0, 0x7e, 0xbd, 0xe5, 0x6d, 0xd6, 0xdb, 0xdd, 0xb5, 0xcb, 0x7a, 0x17, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xb9, 0x27, 0x9f, 0xa8, 0xf7, 0x58, 0x39, 0x67, 0x82, 0x92, 0xc5, 0xbb, 0xf2, 0xb0, 0xd4,
    0xb3, 0x3c, 0x39, 0x5d, 0x95, 0xe9, 0x78, 0xe0, 0x70, 0x96, 0x4a, 0x75, 0xa2, 0xed, 0xbc, 0x27, 0x7b, 0x02, 0x20, 0x54, 0x89,
    0xf3, 0xd0, 0x68, 0xa3, 0xc9, 0x19, 0xf2, 0xa0, 0x64, 0x31, 0x71, 0x26, 0x83, 0x86, 0xf6, 0xbe, 0xdc, 0xa0, 0xbc, 0xbc, 0x1c,
    0xdb, 0x07, 0x6e, 0x86, 0xb2, 0xe9, 0x91, 0xa1, 0x0d,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8005[65] = {
    0x04, 0x9d, 0x3b, 0x8a, 0x22, 0x6b, 0x77, 0xd0, 0xc8, 0x9d, 0x71, 0x29, 0xa3, 0x34, 0x33, 0xdb, 0x6b,
    0x57, 0xcd, 0x1a, 0x1e, 0xdc, 0xae, 0x99, 0x01, 0xe8, 0x2c, 0xa2, 0xba, 0xc2, 0x7e, 0x9f, 0xfc, 0x7c,
    0x4a, 0xca, 0xa8, 0x23, 0x84, 0x1f, 0x2b, 0x2e, 0x86, 0x63, 0x07, 0xc6, 0x6d, 0x29, 0x19, 0xf7, 0x99,
    0x4e, 0x63, 0xfc, 0xf8, 0xea, 0x8e, 0x43, 0x4f, 0xe1, 0xe1, 0x4e, 0x1f, 0x40, 0x5c,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8005[32] = {
    0xba, 0x77, 0x8a, 0x4e, 0x10, 0x7d, 0x21, 0xde, 0xb7, 0xe0, 0x61, 0xee, 0x36, 0xa5, 0x29, 0x4f,
    0x0a, 0x74, 0x0c, 0xd7, 0x83, 0x7b, 0xee, 0x11, 0x2a, 0x3c, 0x0e, 0x4a, 0xd7, 0xd6, 0x52, 0xda,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8005);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8005);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8005);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8006
const uint8_t kDevelopmentDAC_Cert_FFF3_8006[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x5b, 0x37, 0xa8, 0x13, 0x59, 0x29,
    0xb6, 0x8b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x36, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x36, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xe3, 0xdd, 0x32, 0x70, 0xc3, 0x56, 0xbc, 0x5b,
    0x24, 0x45, 0x75, 0xd0, 0xec, 0x11, 0x4f, 0x34, 0xb9, 0x53, 0xba, 0x75, 0x6c, 0xb9, 0x55, 0x16, 0xfa, 0x39, 0x04, 0x90, 0x89,
    0x23, 0x04, 0x39, 0x03, 0x90, 0xd6, 0xde, 0xc4, 0x66, 0xdd, 0xac, 0x51, 0xb4, 0x5c, 0xe6, 0xb5, 0xb8, 0x05, 0xf8, 0x1a, 0x1c,
    0xa6, 0x60, 0x43, 0x45, 0x7e, 0x87, 0xd5, 0xe8, 0x86, 0xb2, 0x74, 0xcf, 0x4c, 0x43, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x1e, 0xd7, 0x3d, 0x33,
    0x83, 0xe7, 0xf7, 0x6e, 0xb7, 0x42, 0x5a, 0x66, 0xa5, 0x74, 0xdb, 0x74, 0x47, 0xf4, 0x5d, 0x91, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x3f, 0x44, 0xba, 0x13, 0x93, 0x2b, 0xd4, 0x81, 0x60, 0x19, 0xc0, 0x7f, 0xf0, 0xc6, 0xe7, 0x02,
    0x3f, 0x46, 0x7b, 0xaa, 0x14, 0x8f, 0x13, 0x12, 0x5d, 0x64, 0x69, 0xc5, 0x69, 0x7a, 0xa8, 0x96, 0x02, 0x20, 0x37, 0xc5, 0xeb,
    0xbb, 0x91, 0xaf, 0x89, 0x5c, 0xde, 0x3f, 0x7d, 0x7f, 0x31, 0xd1, 0xa9, 0xb4, 0x85, 0xc1, 0xda, 0x06, 0xb4, 0x76, 0x80, 0x64,
    0xf9, 0xd8, 0x3f, 0x43, 0x45, 0x83, 0xc5, 0x2d,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8006[65] = {
    0x04, 0xe3, 0xdd, 0x32, 0x70, 0xc3, 0x56, 0xbc, 0x5b, 0x24, 0x45, 0x75, 0xd0, 0xec, 0x11, 0x4f, 0x34,
    0xb9, 0x53, 0xba, 0x75, 0x6c, 0xb9, 0x55, 0x16, 0xfa, 0x39, 0x04, 0x90, 0x89, 0x23, 0x04, 0x39, 0x03,
    0x90, 0xd6, 0xde, 0xc4, 0x66, 0xdd, 0xac, 0x51, 0xb4, 0x5c, 0xe6, 0xb5, 0xb8, 0x05, 0xf8, 0x1a, 0x1c,
    0xa6, 0x60, 0x43, 0x45, 0x7e, 0x87, 0xd5, 0xe8, 0x86, 0xb2, 0x74, 0xcf, 0x4c, 0x43,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8006[32] = {
    0xe0, 0xb8, 0x0e, 0xf4, 0x10, 0xfa, 0x0d, 0xd0, 0x6d, 0xbc, 0xc5, 0x18, 0x80, 0xf9, 0xf6, 0xaf,
    0xf9, 0xfa, 0x03, 0x63, 0xf5, 0x11, 0x88, 0xdf, 0x8a, 0x1e, 0x2f, 0xe6, 0xfd, 0x47, 0x5d, 0x24,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8006);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8006);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8006);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8007
const uint8_t kDevelopmentDAC_Cert_FFF3_8007[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x29, 0x62, 0x25, 0xbf, 0x0d, 0xcf,
    0x30, 0x47, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x37, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x37, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xb7, 0xff, 0x2b, 0x36, 0xa1, 0x0a, 0xfe, 0x93,
    0x17, 0x51, 0xa3, 0xc7, 0xbb, 0xeb, 0x1d, 0x6c, 0x7b, 0xd3, 0x0f, 0x7f, 0xde, 0xb7, 0xc0, 0xcc, 0x10, 0x71, 0x67, 0x9a, 0x50,
    0x12, 0xa7, 0x1d, 0x37, 0x19, 0x9f, 0xeb, 0x3a, 0xea, 0xfa, 0x6f, 0xaf, 0x3b, 0x70, 0xb8, 0xf1, 0x12, 0x6b, 0x46, 0xd2, 0xcf,
    0x23, 0xe5, 0x4b, 0x15, 0xff, 0x0f, 0x5a, 0xec, 0x0c, 0xf8, 0xdf, 0x11, 0x2c, 0xde, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x09, 0x00, 0xfa, 0x70,
    0x93, 0x5d, 0xbb, 0x39, 0x5c, 0xc9, 0xc8, 0x18, 0xcb, 0xf3, 0x7b, 0x66, 0xd6, 0x63, 0xba, 0x7b, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x30, 0x54, 0x51, 0xc8, 0x20, 0x5f, 0xe2, 0x01, 0x84, 0x14, 0x78, 0x7f, 0xca, 0xa3, 0xf4, 0xd6,
    0x8a, 0xf8, 0xe0, 0x08, 0xc0, 0x43, 0xaa, 0x6c, 0xb9, 0x71, 0x64, 0x99, 0xa6, 0xcb, 0x9a, 0x8a, 0x02, 0x21, 0x00, 0x84, 0xb1,
    0x70, 0xed, 0xf7, 0xc6, 0xcc, 0x03, 0x0c, 0x7e, 0x1b, 0x79, 0xc8, 0x13, 0x43, 0xb6, 0x80, 0x72, 0x2f, 0x7a, 0x64, 0xcf, 0x22,
    0xb5, 0x6f, 0x27, 0x49, 0x6a, 0x92, 0xef, 0xc6, 0x89,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8007[65] = {
    0x04, 0xb7, 0xff, 0x2b, 0x36, 0xa1, 0x0a, 0xfe, 0x93, 0x17, 0x51, 0xa3, 0xc7, 0xbb, 0xeb, 0x1d, 0x6c,
    0x7b, 0xd3, 0x0f, 0x7f, 0xde, 0xb7, 0xc0, 0xcc, 0x10, 0x71, 0x67, 0x9a, 0x50, 0x12, 0xa7, 0x1d, 0x37,
    0x19, 0x9f, 0xeb, 0x3a, 0xea, 0xfa, 0x6f, 0xaf, 0x3b, 0x70, 0xb8, 0xf1, 0x12, 0x6b, 0x46, 0xd2, 0xcf,
    0x23, 0xe5, 0x4b, 0x15, 0xff, 0x0f, 0x5a, 0xec, 0x0c, 0xf8, 0xdf, 0x11, 0x2c, 0xde,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8007[32] = {
    0x1d, 0xf3, 0xf2, 0x74, 0x14, 0x2a, 0xb1, 0xe2, 0x01, 0x41, 0xed, 0x03, 0xb5, 0x48, 0x7a, 0xb6,
    0xa0, 0x85, 0x3c, 0x8b, 0xbe, 0xd1, 0x4f, 0xa9, 0x66, 0x87, 0xb8, 0x7e, 0x36, 0x1b, 0xaa, 0x20,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8007);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8007);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8007);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8008
const uint8_t kDevelopmentDAC_Cert_FFF3_8008[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x41, 0x5e, 0xab, 0x36, 0xae, 0xc5,
    0x9d, 0x0d, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x38, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x38, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xc2, 0x28, 0xd0, 0x2f, 0x64, 0x7a, 0x1b, 0x29,
    0x33, 0x46, 0xed, 0x06, 0xc8, 0x43, 0x39, 0xa7, 0xd5, 0x0d, 0x07, 0x93, 0x50, 0x8d, 0x59, 0x82, 0x3c, 0x12, 0x3a, 0xa3, 0x28,
    0xce, 0x52, 0xdc, 0xc1, 0xa4, 0xcc, 0x1d, 0x78, 0xfe, 0x69, 0xc6, 0xba, 0xda, 0x89, 0x0e, 0x9c, 0x00, 0xa3, 0x18, 0x4d, 0xbf,
    0xb3, 0x9a, 0xb8, 0x63, 0xd3, 0xf0, 0x22, 0x58, 0x45, 0x59, 0xc3, 0x85, 0x0e, 0xef, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x65, 0x27, 0xc1, 0x12,
    0xf4, 0x42, 0x5b, 0x30, 0xcc, 0x0b, 0x9d, 0xc8, 0x25, 0x9b, 0x2e, 0x0e, 0xb2, 0x05, 0x73, 0x86, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x7c, 0x48, 0x2d, 0x31, 0xda, 0x6a, 0xf5, 0x1a, 0x24, 0xbc, 0xa2, 0xcf, 0x0f, 0x92, 0x0d, 0x4f,
    0x7b, 0x50, 0xe8, 0x96, 0xcd, 0x60, 0x4b, 0x77, 0xa6, 0x3c, 0x6b, 0x80, 0x3b, 0x8a, 0x40, 0xed, 0x02, 0x21, 0x00, 0x89, 0x13,
    0x21, 0x8b, 0x88, 0x51, 0x7a, 0x09, 0x59, 0x17, 0xf3, 0xd7, 0x96, 0xf1, 0x74, 0xda, 0xb7, 0xf1, 0x42, 0x32, 0xde, 0x8a, 0x85,
    0x08, 0xb2, 0x5c, 0x21, 0xe5, 0xd6, 0x7c, 0x5b, 0xa9,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8008[65] = {
    0x04, 0xc2, 0x28, 0xd0, 0x2f, 0x64, 0x7a, 0x1b, 0x29, 0x33, 0x46, 0xed, 0x06, 0xc8, 0x43, 0x39, 0xa7,
    0xd5, 0x0d, 0x07, 0x93, 0x50, 0x8d, 0x59, 0x82, 0x3c, 0x12, 0x3a, 0xa3, 0x28, 0xce, 0x52, 0xdc, 0xc1,
    0xa4, 0xcc, 0x1d, 0x78, 0xfe, 0x69, 0xc6, 0xba, 0xda, 0x89, 0x0e, 0x9c, 0x00, 0xa3, 0x18, 0x4d, 0xbf,
    0xb3, 0x9a, 0xb8, 0x63, 0xd3, 0xf0, 0x22, 0x58, 0x45, 0x59, 0xc3, 0x85, 0x0e, 0xef,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8008[32] = {
    0xae, 0x9d, 0xc9, 0x88, 0x4f, 0x28, 0x2f, 0x3c, 0xb2, 0x9c, 0x68, 0xd1, 0x5a, 0x4b, 0x66, 0x19,
    0x21, 0x9e, 0x64, 0x55, 0x03, 0x7d, 0x32, 0xdc, 0x41, 0x9f, 0xca, 0x7d, 0x1c, 0x8f, 0xfd, 0xf1,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8008);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8008);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8008);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8009
const uint8_t kDevelopmentDAC_Cert_FFF3_8009[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x27, 0xd3, 0x97, 0x49, 0x59, 0xa1,
    0xbb, 0x15, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x39, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x39, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x00, 0x00, 0x49, 0x5d, 0xc0, 0x3b, 0xa7, 0xa8,
    0x36, 0xee, 0xe4, 0x88, 0xa4, 0x70, 0x84, 0xc0, 0x2f, 0xd1, 0xd5, 0x19, 0xf7, 0x69, 0xd0, 0x5a, 0x44, 0xef, 0x2a, 0x2e, 0x0c,
    0xd1, 0x78, 0x9d, 0x58, 0x5a, 0x37, 0xe0, 0x1e, 0x4c, 0x19, 0x5f, 0x0c, 0xcb, 0xca, 0x25, 0x68, 0xa8, 0x4e, 0x90, 0x5e, 0xc1,
    0xfe, 0xd4, 0xe1, 0x92, 0x9f, 0x15, 0x63, 0xd2, 0x50, 0xcb, 0xde, 0x94, 0xea, 0xc5, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x2c, 0x1b, 0x4f, 0xb7,
    0xe4, 0x77, 0x58, 0x71, 0x6e, 0x2f, 0xdc, 0x82, 0x25, 0x7d, 0xf7, 0xfa, 0x74, 0x64, 0x79, 0xfe, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x3f, 0xa8, 0x2b, 0xbb, 0x19, 0x5f, 0x9a, 0x73, 0x8e, 0x4a, 0x04, 0xd0, 0x50, 0x07, 0x01, 0xfc,
    0x18, 0x57, 0x4b, 0xe0, 0x68, 0xa3, 0xfb, 0xd9, 0x69, 0x1c, 0x79, 0x76, 0x37, 0x68, 0xa6, 0x44, 0x02, 0x21, 0x00, 0x9d, 0x03,
    0x71, 0xf5, 0x30, 0xf0, 0xb5, 0x74, 0x78, 0x63, 0x95, 0xc1, 0x07, 0x92, 0xd3, 0xe0, 0xde, 0xaf, 0x07, 0xb3, 0x21, 0xd3, 0xf1,
    0x97, 0xca, 0xe4, 0x38, 0xd8, 0xca, 0xf9, 0xc5, 0x60,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8009[65] = {
    0x04, 0x00, 0x00, 0x49, 0x5d, 0xc0, 0x3b, 0xa7, 0xa8, 0x36, 0xee, 0xe4, 0x88, 0xa4, 0x70, 0x84, 0xc0,
    0x2f, 0xd1, 0xd5, 0x19, 0xf7, 0x69, 0xd0, 0x5a, 0x44, 0xef, 0x2a, 0x2e, 0x0c, 0xd1, 0x78, 0x9d, 0x58,
    0x5a, 0x37, 0xe0, 0x1e, 0x4c, 0x19, 0x5f, 0x0c, 0xcb, 0xca, 0x25, 0x68, 0xa8, 0x4e, 0x90, 0x5e, 0xc1,
    0xfe, 0xd4, 0xe1, 0x92, 0x9f, 0x15, 0x63, 0xd2, 0x50, 0xcb, 0xde, 0x94, 0xea, 0xc5,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8009[32] = {
    0x7c, 0x8b, 0x60, 0xb5, 0x33, 0x34, 0xc7, 0x99, 0xf6, 0xd4, 0xd7, 0x82, 0xa1, 0xf8, 0xd9, 0xe8,
    0xce, 0xf9, 0x1e, 0xdc, 0x06, 0x86, 0x64, 0xbf, 0x51, 0x4c, 0x5f, 0x58, 0x3f, 0xa2, 0x65, 0x56,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8009);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8009);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8009);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800A
const uint8_t kDevelopmentDAC_Cert_FFF3_800A[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x27, 0x4b, 0x11, 0xe2, 0x96, 0x4d,
    0xec, 0x16, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x41, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x41, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xc8, 0x7b, 0x0f, 0x7b, 0x73, 0xb7, 0x95, 0x3f,
    0x69, 0xca, 0xb4, 0xc4, 0xde, 0x35, 0x81, 0xa5, 0xff, 0xb4, 0x94, 0xb2, 0x6b, 0x91, 0xd2, 0xd1, 0xe8, 0x11, 0x33, 0xb7, 0x1a,
    0xa4, 0x07, 0x0d, 0x87, 0x26, 0xe5, 0xe0, 0xb5, 0x6e, 0x2f, 0x20, 0xc2, 0x55, 0xfb, 0xfd, 0xc2, 0x57, 0x48, 0xa0, 0xd2, 0x8a,
    0x3f, 0x7b, 0x68, 0xc0, 0x45, 0xcd, 0x9c, 0xd0, 0x3d, 0x21, 0xf6, 0xbf, 0x35, 0xc6, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x32, 0x8b, 0x00, 0x61,
    0x99, 0x3a, 0xfa, 0x5c, 0xda, 0x9f, 0xf7, 0x29, 0xff, 0x1b, 0x6a, 0xe1, 0x59, 0xdb, 0x45, 0xff, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x5b, 0x0b, 0x90, 0x26, 0xfb, 0xbc, 0x29, 0xf9, 0x83, 0x2b, 0xc6, 0x1a, 0x7c, 0x44, 0x88, 0xc3,
    0x48, 0x3b, 0x9d, 0x2c, 0xcb, 0x0b, 0x99, 0xa3, 0x2f, 0x40, 0x2a, 0x1a, 0x03, 0x2c, 0x1d, 0x6d, 0x02, 0x20, 0x57, 0x4e, 0xd3,
    0xb6, 0xcc, 0xbb, 0x3f, 0x6a, 0xa6, 0xfd, 0xa1, 0x91, 0xa2, 0x22, 0x73, 0x4d, 0xf5, 0xdb, 0xab, 0x85, 0x81, 0xfa, 0xa3, 0xa3,
    0x05, 0x76, 0x66, 0xa7, 0x32, 0x7f, 0x61, 0x39,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_800A[65] = {
    0x04, 0xc8, 0x7b, 0x0f, 0x7b, 0x73, 0xb7, 0x95, 0x3f, 0x69, 0xca, 0xb4, 0xc4, 0xde, 0x35, 0x81, 0xa5,
    0xff, 0xb4, 0x94, 0xb2, 0x6b, 0x91, 0xd2, 0xd1, 0xe8, 0x11, 0x33, 0xb7, 0x1a, 0xa4, 0x07, 0x0d, 0x87,
    0x26, 0xe5, 0xe0, 0xb5, 0x6e, 0x2f, 0x20, 0xc2, 0x55, 0xfb, 0xfd, 0xc2, 0x57, 0x48, 0xa0, 0xd2, 0x8a,
    0x3f, 0x7b, 0x68, 0xc0, 0x45, 0xcd, 0x9c, 0xd0, 0x3d, 0x21, 0xf6, 0xbf, 0x35, 0xc6,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_800A[32] = {
    0x72, 0xed, 0x94, 0x6d, 0x5f, 0xed, 0xa7, 0x2c, 0x0e, 0x6d, 0x52, 0x47, 0x5d, 0x75, 0x1b, 0xb4,
    0xbc, 0xc0, 0x1a, 0xe0, 0x09, 0x02, 0x0d, 0xa7, 0x2c, 0xd4, 0x8b, 0x32, 0x8a, 0x5c, 0x85, 0x8e,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_800A);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_800A);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_800A);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800B
const uint8_t kDevelopmentDAC_Cert_FFF3_800B[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x11, 0x92, 0xa9, 0x26, 0x31, 0x35,
    0x99, 0xbe, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x42, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x42, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x2d, 0x4f, 0x90, 0x38, 0x42, 0xe6, 0x10, 0x28,
    0x39, 0xae, 0xa7, 0x00, 0x15, 0x31, 0x86, 0x7a, 0x7d, 0x3f, 0xd0, 0x73, 0xdd, 0x4c, 0x73, 0xcd, 0x10, 0xf3, 0xaf, 0x52, 0x48,
    0xe2, 0x32, 0xb0, 0x28, 0x82, 0xa5, 0xb1, 0x17, 0x3d, 0x2c, 0x5f, 0xfc, 0x52, 0x49, 0x47, 0x7d, 0x61, 0xed, 0xff, 0xfd, 0x66,
    0x67, 0x29, 0x44, 0xbc, 0x02, 0x5a, 0x87, 0x79, 0x44, 0x67, 0x71, 0x01, 0x68, 0x1d, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x6e, 0x94, 0x5c, 0xee,
    0x51, 0x43, 0x5a, 0x93, 0xf4, 0xe4, 0xbf, 0xfe, 0x1a, 0x3c, 0xab, 0x3f, 0x3d, 0x4f, 0xfd, 0xea, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x0b, 0x8c, 0x81, 0xbd, 0xb8, 0xaf, 0xb3, 0xba, 0x09, 0x57, 0x5a, 0x02, 0x98, 0x45, 0x77, 0xc5,
    0x8a, 0x48, 0x35, 0x20, 0x42, 0x9c, 0xfd, 0xa7, 0x53, 0xd3, 0xf1, 0xba, 0xb0, 0x84, 0x44, 0xa7, 0x02, 0x21, 0x00, 0xa0, 0xba,
    0xeb, 0x9c, 0x57, 0x97, 0xd2, 0x17, 0x35, 0xe4, 0x1f, 0xda, 0x05, 0x0b, 0x30, 0xdd, 0xaa, 0x3f, 0xd7, 0xa1, 0x82, 0xe7, 0xf3,
    0x47, 0xe8, 0xab, 0xa3, 0xcf, 0xf4, 0x66, 0x9b, 0x84,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_800B[65] = {
    0x04, 0x2d, 0x4f, 0x90, 0x38, 0x42, 0xe6, 0x10, 0x28, 0x39, 0xae, 0xa7, 0x00, 0x15, 0x31, 0x86, 0x7a,
    0x7d, 0x3f, 0xd0, 0x73, 0xdd, 0x4c, 0x73, 0xcd, 0x10, 0xf3, 0xaf, 0x52, 0x48, 0xe2, 0x32, 0xb0, 0x28,
    0x82, 0xa5, 0xb1, 0x17, 0x3d, 0x2c, 0x5f, 0xfc, 0x52, 0x49, 0x47, 0x7d, 0x61, 0xed, 0xff, 0xfd, 0x66,
    0x67, 0x29, 0x44, 0xbc, 0x02, 0x5a, 0x87, 0x79, 0x44, 0x67, 0x71, 0x01, 0x68, 0x1d,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_800B[32] = {
    0x3e, 0xc4, 0x9f, 0x3e, 0x33, 0x49, 0xaf, 0xc4, 0xff, 0xf6, 0x9a, 0x55, 0x8a, 0xdb, 0x4e, 0x4b,
    0xd9, 0xd9, 0x72, 0xd1, 0x2e, 0xea, 0xe9, 0x03, 0x18, 0xc4, 0x82, 0x45, 0x2a, 0xd6, 0xc1, 0x9b,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_800B);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_800B);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_800B);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800C
const uint8_t kDevelopmentDAC_Cert_FFF3_800C[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x51, 0xbd, 0xf9, 0xd2, 0xd5, 0x91,
    0x4f, 0x40, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x43, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x43, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x56, 0xb6, 0xc9, 0xab, 0x24, 0x8f, 0x77, 0xe8,
    0x81, 0xb9, 0xb3, 0xca, 0xa5, 0xbc, 0xf1, 0xca, 0x50, 0x2f, 0xe4, 0x01, 0xe6, 0x66, 0x14, 0x03, 0x36, 0x6a, 0x25, 0xfd, 0xe8,
    0x36, 0x88, 0x6b, 0x3f, 0x80, 0x20, 0xd0, 0xa2, 0x2c, 0x6c, 0x48, 0xae, 0xaf, 0x7d, 0xac, 0x72, 0xef, 0x3f, 0xf5, 0x59, 0xcb,
    0x61, 0x79, 0xda, 0xfa, 0x3b, 0xb2, 0x57, 0x1f, 0x84, 0x75, 0xd3, 0xda, 0xe5, 0x27, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x43, 0x6c, 0xdb, 0xb0,
    0x06, 0x8e, 0xdb, 0xa6, 0xb0, 0xa8, 0x8a, 0xdb, 0x4c, 0xba, 0x56, 0xdb, 0x85, 0xbf, 0x30, 0x43, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xf7, 0x8d, 0xf8, 0x77, 0xdd, 0x6e, 0x45, 0xa5, 0x02, 0x00, 0xc6, 0x14, 0x37, 0x79, 0x8c,
    0xdd, 0xda, 0xcd, 0xd2, 0xad, 0xa7, 0xdb, 0xb0, 0x03, 0x2c, 0x96, 0x85, 0xae, 0x43, 0xa7, 0x47, 0xf7, 0x02, 0x20, 0x34, 0x93,
    0xfe, 0x70, 0xc5, 0x81, 0xb6, 0x97, 0xd9, 0x38, 0x89, 0x5c, 0x61, 0xad, 0x7f, 0xf6, 0x8c, 0x3a, 0x82, 0xa4, 0xdf, 0x8f, 0x00,
    0xf9, 0x64, 0x3c, 0x44, 0x2b, 0xf2, 0x5d, 0xee, 0xd0,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_800C[65] = {
    0x04, 0x56, 0xb6, 0xc9, 0xab, 0x24, 0x8f, 0x77, 0xe8, 0x81, 0xb9, 0xb3, 0xca, 0xa5, 0xbc, 0xf1, 0xca,
    0x50, 0x2f, 0xe4, 0x01, 0xe6, 0x66, 0x14, 0x03, 0x36, 0x6a, 0x25, 0xfd, 0xe8, 0x36, 0x88, 0x6b, 0x3f,
    0x80, 0x20, 0xd0, 0xa2, 0x2c, 0x6c, 0x48, 0xae, 0xaf, 0x7d, 0xac, 0x72, 0xef, 0x3f, 0xf5, 0x59, 0xcb,
    0x61, 0x79, 0xda, 0xfa, 0x3b, 0xb2, 0x57, 0x1f, 0x84, 0x75, 0xd3, 0xda, 0xe5, 0x27,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_800C[32] = {
    0x43, 0x52, 0xe5, 0x9c, 0x06, 0x29, 0x7e, 0x0c, 0x37, 0xe6, 0xce, 0x34, 0x59, 0xcb, 0x99, 0x25,
    0xde, 0x14, 0x9f, 0x3c, 0xd1, 0xe7, 0xa2, 0xc7, 0xd8, 0x84, 0xd0, 0xdf, 0x32, 0x57, 0x12, 0x81,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_800C);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_800C);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_800C);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800D
const uint8_t kDevelopmentDAC_Cert_FFF3_800D[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x11, 0xc7, 0x1a, 0x31, 0x42, 0x22,
    0x0d, 0xb6, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x44, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xa3, 0x09, 0x17, 0xc3, 0x87, 0x70, 0x02, 0x5a,
    0x86, 0x4a, 0x98, 0x1c, 0x0a, 0x78, 0x2b, 0x91, 0x9f, 0x95, 0xcc, 0x51, 0x34, 0xf8, 0x3f, 0x30, 0x2b, 0x36, 0x3a, 0xfe, 0x21,
    0x61, 0x7c, 0x03, 0xd4, 0x30, 0x94, 0x32, 0xac, 0xa4, 0xde, 0x5e, 0x77, 0x13, 0x5d, 0x6a, 0xe8, 0x42, 0x13, 0xd5, 0x1c, 0x3f,
    0x92, 0xf5, 0xfa, 0x81, 0x0d, 0xda, 0xe0, 0x19, 0xe5, 0x8d, 0x0e, 0x35, 0x96, 0x7c, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xa3, 0x2c, 0xf1, 0x79,
    0x9a, 0x31, 0xd7, 0x70, 0x93, 0x20, 0x8d, 0xc1, 0x3b, 0x8a, 0xdf, 0xc5, 0x17, 0x2f, 0xc2, 0x0d, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x25, 0x86, 0xc3, 0xc2, 0x73, 0xdc, 0xbc, 0x05, 0x37, 0x7c, 0xdb, 0x13, 0x9c, 0x65, 0xf9, 0xbf,
    0x05, 0xab, 0xe5, 0x0e, 0xb2, 0x03, 0x79, 0xb4, 0xee, 0x8d, 0x99, 0x58, 0xf4, 0x35, 0x2e, 0xd8, 0x02, 0x21, 0x00, 0xb1, 0xab,
    0xc1, 0x55, 0x9d, 0x85, 0xcd, 0x57, 0x15, 0x2f, 0x9b, 0xec, 0x81, 0x90, 0xb5, 0xfa, 0x73, 0xe1, 0xab, 0x6f, 0x91, 0xb2, 0x31,
    0x98, 0x0d, 0xad, 0x32, 0xb3, 0xe1, 0x56, 0x3a, 0xd8,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_800D[65] = {
    0x04, 0xa3, 0x09, 0x17, 0xc3, 0x87, 0x70, 0x02, 0x5a, 0x86, 0x4a, 0x98, 0x1c, 0x0a, 0x78, 0x2b, 0x91,
    0x9f, 0x95, 0xcc, 0x51, 0x34, 0xf8, 0x3f, 0x30, 0x2b, 0x36, 0x3a, 0xfe, 0x21, 0x61, 0x7c, 0x03, 0xd4,
    0x30, 0x94, 0x32, 0xac, 0xa4, 0xde, 0x5e, 0x77, 0x13, 0x5d, 0x6a, 0xe8, 0x42, 0x13, 0xd5, 0x1c, 0x3f,
    0x92, 0xf5, 0xfa, 0x81, 0x0d, 0xda, 0xe0, 0x19, 0xe5, 0x8d, 0x0e, 0x35, 0x96, 0x7c,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_800D[32] = {
    0x40, 0xd6, 0xec, 0xcb, 0x9d, 0x86, 0x4b, 0x35, 0xf2, 0xc0, 0x06, 0x42, 0x89, 0x8b, 0xac, 0x12,
    0x18, 0xee, 0xf0, 0x62, 0x8f, 0xdd, 0xae, 0x71, 0x63, 0x14, 0x31, 0x8c, 0x05, 0x75, 0xed, 0x76,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_800D);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_800D);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_800D);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800E
const uint8_t kDevelopmentDAC_Cert_FFF3_800E[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x28, 0x67, 0x07, 0x03, 0x8c, 0xe6,
    0x6c, 0x62, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x45, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x45, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x46, 0x95, 0x23, 0x99, 0xd7, 0x4e, 0xd1, 0x8c,
    0xb4, 0xd3, 0x0a, 0x8f, 0x81, 0x79, 0x07, 0x01, 0xa0, 0xb6, 0x08, 0x7f, 0x2e, 0x41, 0x59, 0x64, 0x4f, 0x10, 0x5c, 0x26, 0x74,
    0x0a, 0x69, 0xca, 0x37, 0x96, 0x7e, 0xb8, 0x8f, 0x7b, 0xde, 0xb1, 0x7f, 0x8a, 0x5f, 0xba, 0x2f, 0x40, 0x4b, 0xad, 0xea, 0xc6,
    0xba, 0xab, 0x4d, 0x32, 0x61, 0xda, 0x52, 0x28, 0x57, 0xca, 0x65, 0xd8, 0xb0, 0x0a, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x37, 0xb0, 0x60, 0x69,
    0xda, 0x8f, 0x8e, 0xa3, 0x52, 0x70, 0x9e, 0x08, 0xce, 0xae, 0x65, 0x36, 0x12, 0x24, 0x1a, 0xca, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xd4, 0x96, 0x7d, 0x76, 0xcc, 0x66, 0x25, 0x8c, 0xae, 0x60, 0x94, 0x8d, 0xb5, 0x89, 0x87,
    0xf1, 0x07, 0xf4, 0x80, 0x5e, 0x58, 0x1c, 0xcc, 0xb9, 0x17, 0xf1, 0xdb, 0x0d, 0x45, 0xff, 0x9e, 0x63, 0x02, 0x21, 0x00, 0x9c,
    0xb5, 0xbc, 0xa3, 0x6a, 0x73, 0x7d, 0x08, 0x38, 0x00, 0xbf, 0x02, 0x90, 0x4e, 0xd5, 0xfa, 0x57, 0xce, 0xf3, 0x76, 0x5c, 0x47,
    0x46, 0xe0, 0x1d, 0xfb, 0x2b, 0x40, 0xf2, 0x18, 0x2d, 0x32,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_800E[65] = {
    0x04, 0x46, 0x95, 0x23, 0x99, 0xd7, 0x4e, 0xd1, 0x8c, 0xb4, 0xd3, 0x0a, 0x8f, 0x81, 0x79, 0x07, 0x01,
    0xa0, 0xb6, 0x08, 0x7f, 0x2e, 0x41, 0x59, 0x64, 0x4f, 0x10, 0x5c, 0x26, 0x74, 0x0a, 0x69, 0xca, 0x37,
    0x96, 0x7e, 0xb8, 0x8f, 0x7b, 0xde, 0xb1, 0x7f, 0x8a, 0x5f, 0xba, 0x2f, 0x40, 0x4b, 0xad, 0xea, 0xc6,
    0xba, 0xab, 0x4d, 0x32, 0x61, 0xda, 0x52, 0x28, 0x57, 0xca, 0x65, 0xd8, 0xb0, 0x0a,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_800E[32] = {
    0x56, 0x5a, 0x17, 0x80, 0xbf, 0x51, 0x0a, 0x86, 0x7e, 0x9c, 0xce, 0xb3, 0xca, 0x29, 0x13, 0x24,
    0xf0, 0xde, 0x7e, 0x4c, 0x0a, 0x8d, 0x23, 0xbe, 0x54, 0x92, 0x78, 0x78, 0x99, 0x6b, 0x3d, 0x4a,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_800E);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_800E);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_800E);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x800F
const uint8_t kDevelopmentDAC_Cert_FFF3_800F[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x29, 0xac, 0x64, 0x44, 0x09, 0x0d,
    0x07, 0xf7, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x30, 0x46, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x30, 0x46, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xd9, 0x79, 0x99, 0xf4, 0xaf, 0x8b, 0x34, 0x40,
    0x79, 0x4e, 0x11, 0x3e, 0x3e, 0x7a, 0x77, 0x59, 0x6c, 0x58, 0x6c, 0x5a, 0x1a, 0x2f, 0x24, 0x6c, 0x2c, 0xf0, 0xfd, 0x7d, 0xe1,
    0xcd, 0x14, 0xbc, 0xf9, 0x47, 0x01, 0xb0, 0x82, 0xf9, 0x5f, 0x09, 0xb4, 0x5e, 0x4d, 0xf3, 0x6c, 0x3b, 0x91, 0x68, 0xba, 0x71,
    0x97, 0x97, 0x87, 0x91, 0x48, 0x65, 0xa3, 0x69, 0xbd, 0x39, 0x8d, 0xd0, 0x19, 0x5d, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x2f, 0xc2, 0xf9, 0x39,
    0xdc, 0xd8, 0x29, 0x5b, 0x06, 0x47, 0x8d, 0xdc, 0xe9, 0xe2, 0x9f, 0x78, 0x98, 0x16, 0xb6, 0x93, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x0e, 0x07, 0xc9, 0x7d, 0x62, 0x31, 0x4a, 0xa7, 0x2c, 0x25, 0xf6, 0xd3, 0x9f, 0xcd, 0xea, 0x82,
    0xd2, 0x9b, 0x3e, 0x3d, 0x65, 0x29, 0x85, 0x67, 0x94, 0xd2, 0xfc, 0xc0, 0x62, 0x38, 0x0f, 0xc8, 0x02, 0x20, 0x29, 0x98, 0x7f,
    0x5b, 0xd8, 0x58, 0xae, 0xa9, 0xba, 0x7a, 0x65, 0xa7, 0x28, 0x01, 0x71, 0x10, 0x60, 0xaa, 0x91, 0x1f, 0x27, 0x2b, 0x77, 0x41,
    0x9a, 0x66, 0xd1, 0x9e, 0xb7, 0x32, 0x0e, 0x82,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_800F[65] = {
    0x04, 0xd9, 0x79, 0x99, 0xf4, 0xaf, 0x8b, 0x34, 0x40, 0x79, 0x4e, 0x11, 0x3e, 0x3e, 0x7a, 0x77, 0x59,
    0x6c, 0x58, 0x6c, 0x5a, 0x1a, 0x2f, 0x24, 0x6c, 0x2c, 0xf0, 0xfd, 0x7d, 0xe1, 0xcd, 0x14, 0xbc, 0xf9,
    0x47, 0x01, 0xb0, 0x82, 0xf9, 0x5f, 0x09, 0xb4, 0x5e, 0x4d, 0xf3, 0x6c, 0x3b, 0x91, 0x68, 0xba, 0x71,
    0x97, 0x97, 0x87, 0x91, 0x48, 0x65, 0xa3, 0x69, 0xbd, 0x39, 0x8d, 0xd0, 0x19, 0x5d,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_800F[32] = {
    0xca, 0x0c, 0x93, 0xf8, 0x58, 0x6d, 0x0c, 0xef, 0xdc, 0xe2, 0xdd, 0x11, 0x93, 0xc2, 0xfb, 0x73,
    0x8c, 0xb6, 0x99, 0xe0, 0x5f, 0x3a, 0xb6, 0x25, 0xe7, 0xf8, 0x4b, 0x72, 0x9e, 0xa8, 0xf0, 0x32,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_800F);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_800F);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_800F);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8010
const uint8_t kDevelopmentDAC_Cert_FFF3_8010[468] = {
    0x30, 0x82, 0x01, 0xd0, 0x30, 0x82, 0x01, 0x76, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x2d, 0x59, 0xc6, 0xb2, 0x2c, 0x99,
    0x76, 0xee, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3b, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x30, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x30, 0x20, 0x4d, 0x76, 0x69, 0x64, 0x3a, 0x46, 0x46, 0x46, 0x33, 0x20, 0x4d, 0x70, 0x69, 0x64, 0x3a,
    0x38, 0x30, 0x31, 0x30, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x69, 0x99, 0x80, 0x05, 0x76, 0xe1, 0xf4, 0xc5, 0x41, 0x6e, 0x39,
    0x09, 0x2c, 0xf7, 0x60, 0x5c, 0x33, 0xd3, 0x2b, 0x73, 0x61, 0x2b, 0x3b, 0x7a, 0x49, 0x9f, 0x4b, 0x88, 0x0d, 0x16, 0x61, 0x7d,
    0x16, 0x72, 0x44, 0x0c, 0x7a, 0xaf, 0xc4, 0xd1, 0x1d, 0x0b, 0x74, 0xd2, 0x99, 0x37, 0x03, 0x1d, 0x86, 0xa7, 0xa4, 0xf1, 0x56,
    0x3b, 0xf5, 0x56, 0xff, 0xdf, 0xc3, 0xb9, 0xc6, 0xd7, 0x81, 0xd5, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d,
    0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
    0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x0b, 0x61, 0x97, 0x0d, 0x57, 0x3b, 0x61,
    0x60, 0x0a, 0x25, 0x14, 0x2b, 0xc8, 0x7f, 0xb6, 0xd7, 0x4e, 0x31, 0x32, 0x6f, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6, 0x9b, 0x7e, 0x2c,
    0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48, 0x00, 0x30, 0x45,
    0x02, 0x21, 0x00, 0xf5, 0xfd, 0x65, 0xe4, 0x61, 0xf8, 0x66, 0xd0, 0x72, 0x32, 0xae, 0x0b, 0xbd, 0x09, 0xe3, 0x46, 0xe8, 0x8b,
    0x36, 0x10, 0xa5, 0x3f, 0x5f, 0x25, 0x3c, 0x88, 0x77, 0x45, 0xb1, 0xec, 0x5b, 0x9f, 0x02, 0x20, 0x64, 0x08, 0x63, 0xad, 0xbd,
    0x5f, 0xd8, 0x59, 0x5c, 0xa6, 0xdf, 0x92, 0xe2, 0xce, 0x4e, 0xc0, 0x1b, 0x89, 0x17, 0xff, 0xce, 0x8b, 0xe2, 0x45, 0x72, 0x5f,
    0x93, 0xae, 0xdc, 0xf6, 0x1a, 0x6a,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8010[65] = {
    0x04, 0x69, 0x99, 0x80, 0x05, 0x76, 0xe1, 0xf4, 0xc5, 0x41, 0x6e, 0x39, 0x09, 0x2c, 0xf7, 0x60, 0x5c,
    0x33, 0xd3, 0x2b, 0x73, 0x61, 0x2b, 0x3b, 0x7a, 0x49, 0x9f, 0x4b, 0x88, 0x0d, 0x16, 0x61, 0x7d, 0x16,
    0x72, 0x44, 0x0c, 0x7a, 0xaf, 0xc4, 0xd1, 0x1d, 0x0b, 0x74, 0xd2, 0x99, 0x37, 0x03, 0x1d, 0x86, 0xa7,
    0xa4, 0xf1, 0x56, 0x3b, 0xf5, 0x56, 0xff, 0xdf, 0xc3, 0xb9, 0xc6, 0xd7, 0x81, 0xd5,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8010[32] = {
    0x58, 0x36, 0xf4, 0x2e, 0xaa, 0x87, 0x0a, 0x99, 0x8d, 0xbb, 0xff, 0x13, 0xfa, 0x8a, 0xb5, 0x49,
    0xa7, 0xa8, 0xca, 0xac, 0x4e, 0x4c, 0x4e, 0x9d, 0x3f, 0x0d, 0x12, 0x1f, 0xf1, 0x7a, 0x43, 0xa0,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8010);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8010);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8010);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8011
const uint8_t kDevelopmentDAC_Cert_FFF3_8011[468] = {
    0x30, 0x82, 0x01, 0xd0, 0x30, 0x82, 0x01, 0x76, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x29, 0x44, 0x1d, 0xc6, 0x8f, 0x08,
    0x85, 0xec, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3b, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x30, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x31, 0x20, 0x4d, 0x76, 0x69, 0x64, 0x3a, 0x46, 0x46, 0x46, 0x33, 0x20, 0x4d, 0x70, 0x69, 0x64, 0x3a,
    0x38, 0x30, 0x31, 0x31, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xe1, 0x09, 0x2c, 0xfa, 0xfa, 0xd2, 0x97, 0x5f, 0xe2, 0x86, 0x4c,
    0x29, 0xd7, 0x17, 0xf2, 0x06, 0x16, 0xfb, 0x7c, 0xfb, 0x83, 0xcf, 0x38, 0x1f, 0xfa, 0x6f, 0x80, 0x40, 0x41, 0x19, 0xfc, 0x08,
    0x3b, 0x7c, 0xb0, 0xc2, 0x4e, 0x79, 0x33, 0x30, 0x90, 0x2b, 0x84, 0xe8, 0x1a, 0x4f, 0xb7, 0x40, 0xd5, 0xe1, 0x59, 0xad, 0xbd,
    0x4b, 0x34, 0x4d, 0x5f, 0x2a, 0xe4, 0xf0, 0x4c, 0xd5, 0x97, 0x6e, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d,
    0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
    0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x1d, 0x29, 0xb3, 0xdb, 0xa1, 0x1b, 0x08,
    0x1e, 0x76, 0x91, 0x0c, 0x64, 0x43, 0x81, 0x66, 0xca, 0x41, 0xe6, 0xd2, 0x54, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6, 0x9b, 0x7e, 0x2c,
    0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48, 0x00, 0x30, 0x45,
    0x02, 0x21, 0x00, 0xf6, 0x09, 0x72, 0x66, 0x8d, 0xf9, 0xfb, 0x45, 0x02, 0x23, 0x21, 0x8b, 0x76, 0x35, 0x94, 0xb6, 0x02, 0xe7,
    0x0d, 0x67, 0x18, 0x5d, 0x80, 0x5e, 0x88, 0xa8, 0x1e, 0x66, 0x6d, 0x6d, 0x76, 0x3d, 0x02, 0x20, 0x04, 0x86, 0x65, 0x57, 0x3b,
    0x11, 0x12, 0xfb, 0xc3, 0x26, 0x32, 0x87, 0xbc, 0xf4, 0xd9, 0x61, 0x2d, 0x15, 0xbe, 0x3f, 0xfa, 0xe4, 0x02, 0x6f, 0x86, 0x9c,
    0x8f, 0xeb, 0x87, 0x8c, 0x0d, 0x57,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8011[65] = {
    0x04, 0xe1, 0x09, 0x2c, 0xfa, 0xfa, 0xd2, 0x97, 0x5f, 0xe2, 0x86, 0x4c, 0x29, 0xd7, 0x17, 0xf2, 0x06,
    0x16, 0xfb, 0x7c, 0xfb, 0x83, 0xcf, 0x38, 0x1f, 0xfa, 0x6f, 0x80, 0x40, 0x41, 0x19, 0xfc, 0x08, 0x3b,
    0x7c, 0xb0, 0xc2, 0x4e, 0x79, 0x33, 0x30, 0x90, 0x2b, 0x84, 0xe8, 0x1a, 0x4f, 0xb7, 0x40, 0xd5, 0xe1,
    0x59, 0xad, 0xbd, 0x4b, 0x34, 0x4d, 0x5f, 0x2a, 0xe4, 0xf0, 0x4c, 0xd5, 0x97, 0x6e,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8011[32] = {
    0x0c, 0x20, 0x6c, 0x34, 0xa2, 0x41, 0xe8, 0x27, 0x74, 0x8c, 0x41, 0xb6, 0x1e, 0x45, 0xee, 0x0e,
    0xd5, 0xd7, 0x75, 0x5d, 0xbb, 0x6a, 0x28, 0xc2, 0x72, 0x72, 0x7d, 0xbf, 0xd6, 0x5e, 0x40, 0x1c,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8011);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8011);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8011);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8012
const uint8_t kDevelopmentDAC_Cert_FFF3_8012[468] = {
    0x30, 0x82, 0x01, 0xd0, 0x30, 0x82, 0x01, 0x76, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x68, 0xd0, 0xc1, 0x2e, 0x20, 0x59,
    0xef, 0x6e, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3b, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x30, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x32, 0x20, 0x4d, 0x76, 0x69, 0x64, 0x3a, 0x46, 0x46, 0x46, 0x33, 0x20, 0x4d, 0x70, 0x69, 0x64, 0x3a,
    0x38, 0x30, 0x31, 0x32, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x89, 0x6e, 0xf8, 0xac, 0x7c, 0x7a, 0x53, 0x13, 0x4f, 0xaf, 0x0a,
    0x0a, 0x26, 0xf4, 0x61, 0x11, 0xa1, 0xba, 0xaa, 0xe9, 0x6e, 0x3c, 0xbb, 0x4c, 0xc2, 0x89, 0x78, 0x55, 0xce, 0xe2, 0x57, 0xa0,
    0xf2, 0xc1, 0xad, 0x01, 0xb0, 0x5f, 0x7c, 0x78, 0x8d, 0x5a, 0x83, 0xdf, 0xf7, 0x52, 0x41, 0x33, 0xd7, 0x8c, 0x71, 0x0e, 0x63,
    0xa2, 0x3d, 0x15, 0xf6, 0x45, 0xaf, 0x75, 0xac, 0x83, 0x4e, 0x38, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d,
    0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
    0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xde, 0x98, 0x5d, 0xcd, 0xfc, 0xce, 0xfc,
    0x9a, 0xf2, 0xe7, 0x60, 0x0a, 0x2c, 0xbb, 0xbf, 0x67, 0x50, 0x91, 0xc3, 0xef, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6, 0x9b, 0x7e, 0x2c,
    0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48, 0x00, 0x30, 0x45,
    0x02, 0x20, 0x6f, 0x07, 0x9b, 0x60, 0x6d, 0x37, 0x2a, 0x43, 0x92, 0x99, 0xee, 0x62, 0xef, 0x16, 0xd3, 0xa1, 0xb2, 0x39, 0x62,
    0x4d, 0xd5, 0xc2, 0xd6, 0x2e, 0x31, 0x07, 0xc6, 0x34, 0x5e, 0xf9, 0xb1, 0x66, 0x02, 0x21, 0x00, 0xe5, 0x8b, 0x57, 0x07, 0xf0,
    0x1c, 0x55, 0x4e, 0xa3, 0x02, 0xf0, 0x51, 0x27, 0x7d, 0x9f, 0xf8, 0x76, 0xa8, 0x51, 0x2c, 0x28, 0xde, 0x34, 0x02, 0xc5, 0x45,
    0xf2, 0x38, 0xa2, 0xb6, 0x29, 0x00,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8012[65] = {
    0x04, 0x89, 0x6e, 0xf8, 0xac, 0x7c, 0x7a, 0x53, 0x13, 0x4f, 0xaf, 0x0a, 0x0a, 0x26, 0xf4, 0x61, 0x11,
    0xa1, 0xba, 0xaa, 0xe9, 0x6e, 0x3c, 0xbb, 0x4c, 0xc2, 0x89, 0x78, 0x55, 0xce, 0xe2, 0x57, 0xa0, 0xf2,
    0xc1, 0xad, 0x01, 0xb0, 0x5f, 0x7c, 0x78, 0x8d, 0x5a, 0x83, 0xdf, 0xf7, 0x52, 0x41, 0x33, 0xd7, 0x8c,
    0x71, 0x0e, 0x63, 0xa2, 0x3d, 0x15, 0xf6, 0x45, 0xaf, 0x75, 0xac, 0x83, 0x4e, 0x38,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8012[32] = {
    0x76, 0xba, 0xc2, 0x14, 0xb9, 0xfa, 0xcb, 0x64, 0x31, 0xf3, 0x71, 0xa9, 0x33, 0xc0, 0x66, 0x4e,
    0x95, 0x5c, 0xf6, 0x72, 0x8b, 0xe0, 0xa7, 0xe7, 0x20, 0x2f, 0x33, 0x12, 0xd3, 0xd2, 0x21, 0x6a,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8012);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8012);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8012);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8013
const uint8_t kDevelopmentDAC_Cert_FFF3_8013[469] = {
    0x30, 0x82, 0x01, 0xd1, 0x30, 0x82, 0x01, 0x76, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x58, 0xfc, 0xf0, 0x19, 0xc4, 0x86,
    0x43, 0x47, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3b, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x30, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x33, 0x20, 0x4d, 0x76, 0x69, 0x64, 0x3a, 0x46, 0x46, 0x46, 0x33, 0x20, 0x4d, 0x70, 0x69, 0x64, 0x3a,
    0x38, 0x30, 0x31, 0x33, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x9b, 0x9e, 0x47, 0x4a, 0x8d, 0x90, 0x66, 0xdb, 0x89, 0xf9, 0xf6,
    0xda, 0xc4, 0xe3, 0xaa, 0x2b, 0xca, 0x9f, 0x4a, 0x0b, 0xa1, 0x6c, 0x05, 0x6b, 0x3a, 0x0e, 0x3c, 0x12, 0xbb, 0x81, 0x14, 0x68,
    0x0e, 0xc7, 0x34, 0x48, 0x73, 0xb0, 0xec, 0x61, 0x88, 0x84, 0x8d, 0x7c, 0xa8, 0x8f, 0x4d, 0xd9, 0xad, 0xeb, 0xab, 0x0a, 0x81,
    0x5c, 0xdb, 0x01, 0xa0, 0xae, 0x12, 0x57, 0xb6, 0x8a, 0xb7, 0x2c, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d,
    0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
    0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x47, 0xc0, 0x60, 0x71, 0x53, 0xc8, 0x27,
    0x95, 0x40, 0x18, 0x7b, 0x99, 0x8e, 0xfc, 0x6c, 0x46, 0xcc, 0x15, 0x45, 0xba, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6, 0x9b, 0x7e, 0x2c,
    0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49, 0x00, 0x30, 0x46,
    0x02, 0x21, 0x00, 0xbe, 0xef, 0x45, 0xe2, 0x8d, 0x8a, 0x24, 0x38, 0x40, 0x42, 0x55, 0xda, 0x41, 0xe8, 0x19, 0xd1, 0xf0, 0x81,
    0x4d, 0x52, 0x05, 0x4c, 0x6e, 0x9b, 0x50, 0xb9, 0x1e, 0xf1, 0xb3, 0xdb, 0x18, 0x42, 0x02, 0x21, 0x00, 0x81, 0xef, 0x8e, 0xc5,
    0xb0, 0x3c, 0x88, 0x1e, 0x89, 0x32, 0xc9, 0x6c, 0x52, 0xac, 0xeb, 0x06, 0x49, 0xa7, 0x19, 0x95, 0xf1, 0x20, 0x2d, 0x42, 0xa8,
    0x4c, 0xb0, 0x5c, 0xe9, 0x34, 0x03, 0xc3,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8013[65] = {
    0x04, 0x9b, 0x9e, 0x47, 0x4a, 0x8d, 0x90, 0x66, 0xdb, 0x89, 0xf9, 0xf6, 0xda, 0xc4, 0xe3, 0xaa, 0x2b,
    0xca, 0x9f, 0x4a, 0x0b, 0xa1, 0x6c, 0x05, 0x6b, 0x3a, 0x0e, 0x3c, 0x12, 0xbb, 0x81, 0x14, 0x68, 0x0e,
    0xc7, 0x34, 0x48, 0x73, 0xb0, 0xec, 0x61, 0x88, 0x84, 0x8d, 0x7c, 0xa8, 0x8f, 0x4d, 0xd9, 0xad, 0xeb,
    0xab, 0x0a, 0x81, 0x5c, 0xdb, 0x01, 0xa0, 0xae, 0x12, 0x57, 0xb6, 0x8a, 0xb7, 0x2c,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8013[32] = {
    0x7b, 0x04, 0xbb, 0x86, 0x20, 0x68, 0xc1, 0xa1, 0x57, 0x72, 0xfd, 0x93, 0x4f, 0xfc, 0x6f, 0xdd,
    0xe2, 0x87, 0x0b, 0x64, 0x62, 0x93, 0x40, 0xf5, 0xde, 0x76, 0xe9, 0x3a, 0xdb, 0x74, 0x1a, 0x6a,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8013);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8013);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8013);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8014
const uint8_t kDevelopmentDAC_Cert_FFF3_8014[467] = {
    0x30, 0x82, 0x01, 0xcf, 0x30, 0x82, 0x01, 0x76, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x4b, 0xf5, 0x18, 0x60, 0x25, 0x4b,
    0x32, 0xd1, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3b, 0x31, 0x39, 0x30, 0x37, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x30, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x34, 0x20, 0x4d, 0x76, 0x69, 0x64, 0x3a, 0x46, 0x46, 0x46, 0x33, 0x20, 0x4d, 0x70, 0x69, 0x64, 0x3a,
    0x38, 0x30, 0x31, 0x34, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xcd, 0x6f, 0xdf, 0xdf, 0xd5, 0x61, 0xe1, 0x4f, 0xd2, 0x83, 0x43,
    0xdb, 0x45, 0x84, 0x3a, 0x00, 0xaf, 0x07, 0xf3, 0xae, 0xa9, 0xbf, 0xc1, 0x33, 0xf6, 0x8a, 0x14, 0xa3, 0x9e, 0x00, 0x13, 0x04,
    0x4c, 0xdc, 0xc8, 0x3b, 0x9c, 0x9c, 0x98, 0xb8, 0x13, 0x6e, 0xea, 0x20, 0xa6, 0xd9, 0x65, 0x34, 0x60, 0xf4, 0x95, 0xc5, 0x74,
    0x18, 0x68, 0xbc, 0xf6, 0x19, 0x37, 0x65, 0xd1, 0xc6, 0xee, 0x1e, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06, 0x03, 0x55, 0x1d,
    0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03,
    0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xa5, 0x85, 0xda, 0x3e, 0x72, 0x6b, 0x13,
    0xbe, 0x26, 0xce, 0x93, 0xa8, 0xb4, 0x3e, 0x38, 0xef, 0x19, 0x9d, 0xd4, 0x3c, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04,
    0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6, 0x9b, 0x7e, 0x2c,
    0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47, 0x00, 0x30, 0x44,
    0x02, 0x20, 0x2d, 0x28, 0x97, 0xdb, 0x1f, 0x2d, 0xd2, 0x0a, 0x94, 0x92, 0x3e, 0x0f, 0x58, 0xea, 0xd6, 0x9a, 0xb0, 0x16, 0x94,
    0x8c, 0x6c, 0x22, 0x31, 0x65, 0x44, 0xb2, 0x31, 0xa0, 0x57, 0x56, 0x42, 0x11, 0x02, 0x20, 0x30, 0x51, 0x2d, 0x22, 0xd9, 0x02,
    0x3e, 0x20, 0x6e, 0x05, 0xdb, 0xd1, 0x05, 0xba, 0xf3, 0x89, 0x6f, 0xa1, 0x6a, 0xb0, 0xf0, 0xf4, 0x48, 0xc7, 0x9d, 0x08, 0x66,
    0x99, 0xb2, 0xd7, 0x5f, 0xf4,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8014[65] = {
    0x04, 0xcd, 0x6f, 0xdf, 0xdf, 0xd5, 0x61, 0xe1, 0x4f, 0xd2, 0x83, 0x43, 0xdb, 0x45, 0x84, 0x3a, 0x00,
    0xaf, 0x07, 0xf3, 0xae, 0xa9, 0xbf, 0xc1, 0x33, 0xf6, 0x8a, 0x14, 0xa3, 0x9e, 0x00, 0x13, 0x04, 0x4c,
    0xdc, 0xc8, 0x3b, 0x9c, 0x9c, 0x98, 0xb8, 0x13, 0x6e, 0xea, 0x20, 0xa6, 0xd9, 0x65, 0x34, 0x60, 0xf4,
    0x95, 0xc5, 0x74, 0x18, 0x68, 0xbc, 0xf6, 0x19, 0x37, 0x65, 0xd1, 0xc6, 0xee, 0x1e,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8014[32] = {
    0xf2, 0x8d, 0x1f, 0x07, 0xe4, 0x91, 0xbf, 0x72, 0xea, 0x78, 0xea, 0x48, 0xc4, 0x3a, 0x5f, 0xe5,
    0x4f, 0x97, 0x01, 0x6c, 0xec, 0x6a, 0x51, 0xca, 0xda, 0xa4, 0x4f, 0x23, 0xee, 0xa0, 0xad, 0x5c,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8014);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8014);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8014);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8015
const uint8_t kDevelopmentDAC_Cert_FFF3_8015[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x41, 0x10, 0xa2, 0xb1, 0xfe, 0xca,
    0xcd, 0x35, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x35, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x35, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x07, 0xdb, 0x8a, 0x8d, 0xff, 0x6f, 0x8b, 0xe4,
    0x76, 0x01, 0x50, 0x4b, 0x17, 0xb3, 0x27, 0x83, 0x8e, 0xe1, 0x99, 0x60, 0x92, 0x32, 0x96, 0xf2, 0xeb, 0x95, 0x6a, 0x03, 0xce,
    0x74, 0x59, 0x3e, 0xad, 0x45, 0xcc, 0x57, 0x88, 0x87, 0x24, 0x08, 0xa0, 0x1e, 0xa9, 0xc9, 0xe2, 0xe2, 0x6c, 0x4c, 0x2d, 0x41,
    0x52, 0x46, 0xb8, 0xbe, 0x49, 0xcd, 0xec, 0xbd, 0xda, 0x7c, 0x06, 0xf9, 0x7b, 0x31, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x2d, 0xfd, 0x33, 0x2c,
    0x8d, 0xc3, 0x67, 0xbf, 0xba, 0xca, 0xa6, 0xc6, 0xee, 0xf5, 0xb1, 0xf1, 0xfe, 0xbb, 0xb3, 0x5d, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x7d, 0x0f, 0x98, 0xde, 0x80, 0xfa, 0x52, 0x5a, 0x23, 0x29, 0xea, 0xe2, 0x65, 0xa8, 0x5f, 0x9b,
    0x9c, 0x8c, 0x05, 0x17, 0x16, 0x76, 0x9f, 0x0c, 0xf1, 0xc2, 0xb8, 0xd8, 0xa6, 0x3d, 0x54, 0x2a, 0x02, 0x21, 0x00, 0xe8, 0x5e,
    0x64, 0x3a, 0x38, 0xc4, 0xef, 0x9a, 0xda, 0xe3, 0x03, 0xa4, 0xb6, 0xe6, 0xe8, 0x1d, 0xd2, 0xa2, 0xa8, 0x4e, 0x6f, 0xc1, 0xed,
    0x10, 0x2b, 0x74, 0x61, 0x76, 0x50, 0x21, 0x52, 0x7b,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8015[65] = {
    0x04, 0x07, 0xdb, 0x8a, 0x8d, 0xff, 0x6f, 0x8b, 0xe4, 0x76, 0x01, 0x50, 0x4b, 0x17, 0xb3, 0x27, 0x83,
    0x8e, 0xe1, 0x99, 0x60, 0x92, 0x32, 0x96, 0xf2, 0xeb, 0x95, 0x6a, 0x03, 0xce, 0x74, 0x59, 0x3e, 0xad,
    0x45, 0xcc, 0x57, 0x88, 0x87, 0x24, 0x08, 0xa0, 0x1e, 0xa9, 0xc9, 0xe2, 0xe2, 0x6c, 0x4c, 0x2d, 0x41,
    0x52, 0x46, 0xb8, 0xbe, 0x49, 0xcd, 0xec, 0xbd, 0xda, 0x7c, 0x06, 0xf9, 0x7b, 0x31,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8015[32] = {
    0xbf, 0xb2, 0x1f, 0x6a, 0x65, 0xd0, 0x1e, 0x29, 0x18, 0x2b, 0x70, 0x1d, 0x1d, 0x22, 0xea, 0xeb,
    0x68, 0xb9, 0x0f, 0x68, 0xdd, 0x81, 0x8b, 0x85, 0xce, 0x2f, 0xb7, 0xf4, 0xc7, 0xa7, 0xc7, 0xb6,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8015);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8015);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8015);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8016
const uint8_t kDevelopmentDAC_Cert_FFF3_8016[491] = {
    0x30, 0x82, 0x01, 0xe7, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x5e, 0x75, 0x46, 0xb6, 0xdc, 0xac,
    0x9f, 0x34, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x36, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x36, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x3a, 0x54, 0xc0, 0xd8, 0xd8, 0xa9, 0x3b, 0xb6,
    0x45, 0x02, 0xa3, 0xf3, 0x43, 0xde, 0xd8, 0xaa, 0x6c, 0x2d, 0xde, 0x2e, 0x74, 0xc8, 0x60, 0x05, 0xf0, 0xf7, 0x75, 0xa9, 0x96,
    0xba, 0xfc, 0xe9, 0xaa, 0x08, 0xa4, 0x62, 0x2f, 0x82, 0x00, 0xe2, 0xfe, 0x7d, 0x5a, 0xd0, 0x84, 0x0e, 0x8b, 0x70, 0x86, 0x1f,
    0x93, 0xe6, 0x1a, 0x18, 0x0b, 0x09, 0xfd, 0xa1, 0xf5, 0x7a, 0xff, 0x59, 0x6a, 0xa9, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x61, 0x9c, 0xe1, 0x3f,
    0x76, 0x4b, 0x72, 0xac, 0x49, 0x72, 0x50, 0xd0, 0x66, 0xe7, 0xe7, 0x7d, 0xe8, 0x11, 0x0f, 0xb3, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47,
    0x00, 0x30, 0x44, 0x02, 0x20, 0x1a, 0x73, 0x1c, 0x28, 0x4e, 0x4f, 0x44, 0x59, 0xb3, 0x81, 0xa5, 0x8f, 0x23, 0xd9, 0x4a, 0x1c,
    0x74, 0xc1, 0xba, 0xef, 0x55, 0xf2, 0x91, 0x34, 0x19, 0x4a, 0xef, 0xfe, 0xbf, 0xbf, 0xfe, 0xe9, 0x02, 0x20, 0x61, 0x7c, 0x84,
    0xf6, 0x1b, 0x48, 0x13, 0xcd, 0xcb, 0x34, 0x8d, 0xc1, 0x34, 0xa3, 0x08, 0xcd, 0xdd, 0x93, 0xd1, 0x26, 0x5f, 0x0f, 0xc0, 0x85,
    0x47, 0xef, 0x4b, 0xc8, 0x0c, 0x5a, 0x4f, 0x32,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8016[65] = {
    0x04, 0x3a, 0x54, 0xc0, 0xd8, 0xd8, 0xa9, 0x3b, 0xb6, 0x45, 0x02, 0xa3, 0xf3, 0x43, 0xde, 0xd8, 0xaa,
    0x6c, 0x2d, 0xde, 0x2e, 0x74, 0xc8, 0x60, 0x05, 0xf0, 0xf7, 0x75, 0xa9, 0x96, 0xba, 0xfc, 0xe9, 0xaa,
    0x08, 0xa4, 0x62, 0x2f, 0x82, 0x00, 0xe2, 0xfe, 0x7d, 0x5a, 0xd0, 0x84, 0x0e, 0x8b, 0x70, 0x86, 0x1f,
    0x93, 0xe6, 0x1a, 0x18, 0x0b, 0x09, 0xfd, 0xa1, 0xf5, 0x7a, 0xff, 0x59, 0x6a, 0xa9,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8016[32] = {
    0xe6, 0x77, 0x5e, 0xba, 0x60, 0x6b, 0x2c, 0x20, 0xf6, 0x11, 0x35, 0x86, 0xa8, 0xb4, 0x47, 0xe2,
    0x14, 0x41, 0x7b, 0x52, 0x6a, 0xf4, 0xa8, 0xbf, 0x57, 0x71, 0x3d, 0x46, 0x84, 0x7d, 0x70, 0xfe,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8016);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8016);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8016);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8017
const uint8_t kDevelopmentDAC_Cert_FFF3_8017[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x65, 0x2e, 0x7b, 0x0e, 0xcb, 0x0c,
    0x71, 0x78, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x37, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x37, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x8e, 0xdf, 0x9e, 0x13, 0xd3, 0x3f, 0xc3, 0xd5,
    0xe5, 0x24, 0x6e, 0xcd, 0x18, 0x63, 0x26, 0x1d, 0x45, 0xaf, 0x4c, 0x89, 0xe8, 0xcb, 0x4a, 0xc3, 0x6d, 0x37, 0xb2, 0x2e, 0x3c,
    0x8f, 0x66, 0x48, 0x5d, 0x78, 0xe1, 0xf5, 0xf3, 0x68, 0x17, 0xeb, 0xe4, 0x5f, 0xab, 0x50, 0xff, 0x3f, 0x6e, 0x38, 0xa8, 0xa2,
    0x3c, 0x2c, 0xc0, 0x53, 0x1d, 0x00, 0xac, 0xc7, 0xc8, 0x26, 0xa6, 0xb0, 0x33, 0x92, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x15, 0x90, 0x45, 0x6b,
    0x13, 0xa1, 0x74, 0xaa, 0xcb, 0xcb, 0xd0, 0x1c, 0x0b, 0xba, 0x81, 0x77, 0x58, 0x9c, 0x25, 0xaa, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xcf, 0xcb, 0x48, 0x0f, 0x96, 0xe6, 0xb0, 0xac, 0x57, 0x27, 0xe5, 0x25, 0x67, 0x0b, 0x2c,
    0xcd, 0x47, 0x18, 0x86, 0x45, 0xe9, 0xdb, 0x6d, 0xc7, 0x91, 0x3a, 0x6a, 0x34, 0x38, 0x3b, 0x1d, 0xc4, 0x02, 0x20, 0x27, 0x87,
    0xee, 0x99, 0x86, 0x22, 0x82, 0xb2, 0x26, 0x94, 0x4d, 0xd3, 0x83, 0xb5, 0x6a, 0xb5, 0x50, 0xec, 0xbf, 0x0c, 0x2a, 0x22, 0xcf,
    0x89, 0x7d, 0x56, 0x76, 0x4f, 0x90, 0x27, 0x05, 0x6d,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8017[65] = {
    0x04, 0x8e, 0xdf, 0x9e, 0x13, 0xd3, 0x3f, 0xc3, 0xd5, 0xe5, 0x24, 0x6e, 0xcd, 0x18, 0x63, 0x26, 0x1d,
    0x45, 0xaf, 0x4c, 0x89, 0xe8, 0xcb, 0x4a, 0xc3, 0x6d, 0x37, 0xb2, 0x2e, 0x3c, 0x8f, 0x66, 0x48, 0x5d,
    0x78, 0xe1, 0xf5, 0xf3, 0x68, 0x17, 0xeb, 0xe4, 0x5f, 0xab, 0x50, 0xff, 0x3f, 0x6e, 0x38, 0xa8, 0xa2,
    0x3c, 0x2c, 0xc0, 0x53, 0x1d, 0x00, 0xac, 0xc7, 0xc8, 0x26, 0xa6, 0xb0, 0x33, 0x92,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8017[32] = {
    0x8d, 0x1b, 0x47, 0x41, 0x00, 0xee, 0x06, 0xd4, 0x3b, 0x7c, 0xba, 0x97, 0x2c, 0x26, 0x4b, 0xf8,
    0x9e, 0xd6, 0xf6, 0xc5, 0xf1, 0x53, 0xe5, 0xab, 0x05, 0x89, 0x0d, 0x85, 0xb9, 0xc1, 0xd8, 0xc8,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8017);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8017);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8017);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8018
const uint8_t kDevelopmentDAC_Cert_FFF3_8018[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x36, 0xe7, 0x37, 0xe2, 0x8c, 0x3c,
    0xd2, 0xa0, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x38, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x38, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xf1, 0x2a, 0xed, 0xca, 0x3d, 0x84, 0x60, 0x6e,
    0x74, 0x24, 0x8e, 0x44, 0xae, 0x78, 0x72, 0x19, 0x40, 0x98, 0xda, 0x6e, 0xbf, 0xbd, 0xa3, 0x31, 0x74, 0x90, 0x66, 0x6c, 0x8e,
    0x91, 0x0f, 0xb8, 0xea, 0xa1, 0x4d, 0xc4, 0x38, 0x9a, 0xe5, 0xe6, 0xa6, 0x8b, 0x9b, 0xe9, 0x46, 0xa6, 0x52, 0xd7, 0xb3, 0x09,
    0xeb, 0x96, 0x63, 0x02, 0xd5, 0x8e, 0x83, 0x35, 0x49, 0x30, 0xbe, 0x07, 0x5c, 0xe4, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x65, 0x0f, 0xcb, 0xe3,
    0xf9, 0xbc, 0x15, 0xad, 0x53, 0xb9, 0xc0, 0x14, 0x5d, 0xd6, 0x40, 0x57, 0x96, 0x72, 0xe8, 0x41, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0x8f, 0xd4, 0x12, 0x07, 0x5c, 0x71, 0xb8, 0x3f, 0x93, 0x51, 0xfe, 0x0c, 0x88, 0x13, 0x15,
    0x0e, 0xad, 0x19, 0xdb, 0xe9, 0x84, 0x7b, 0x76, 0x33, 0x54, 0x0f, 0x84, 0x63, 0x9b, 0xe0, 0xa3, 0xd9, 0x02, 0x20, 0x59, 0x45,
    0x6e, 0x04, 0xf9, 0xfa, 0x4a, 0x30, 0x8c, 0x4a, 0x45, 0xdf, 0x07, 0x86, 0xd8, 0xc1, 0x2c, 0x97, 0xed, 0x0b, 0xf2, 0x32, 0xdc,
    0xde, 0x44, 0x0a, 0xd8, 0x7b, 0x64, 0xb3, 0x86, 0xca,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8018[65] = {
    0x04, 0xf1, 0x2a, 0xed, 0xca, 0x3d, 0x84, 0x60, 0x6e, 0x74, 0x24, 0x8e, 0x44, 0xae, 0x78, 0x72, 0x19,
    0x40, 0x98, 0xda, 0x6e, 0xbf, 0xbd, 0xa3, 0x31, 0x74, 0x90, 0x66, 0x6c, 0x8e, 0x91, 0x0f, 0xb8, 0xea,
    0xa1, 0x4d, 0xc4, 0x38, 0x9a, 0xe5, 0xe6, 0xa6, 0x8b, 0x9b, 0xe9, 0x46, 0xa6, 0x52, 0xd7, 0xb3, 0x09,
    0xeb, 0x96, 0x63, 0x02, 0xd5, 0x8e, 0x83, 0x35, 0x49, 0x30, 0xbe, 0x07, 0x5c, 0xe4,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8018[32] = {
    0x6b, 0xee, 0x75, 0x3d, 0xdf, 0xe4, 0xec, 0x95, 0x79, 0x40, 0xf7, 0xef, 0x0a, 0x5a, 0x26, 0x7f,
    0xa8, 0xe3, 0x73, 0x44, 0xdd, 0x83, 0x96, 0x4a, 0xa6, 0x54, 0x32, 0x49, 0x10, 0xa5, 0x80, 0x0b,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8018);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8018);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8018);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x8019
const uint8_t kDevelopmentDAC_Cert_FFF3_8019[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x23, 0x02, 0xf5, 0x0f, 0x92, 0x5d,
    0x63, 0x6a, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x39, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x39, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x4d, 0x0f, 0x58, 0xc2, 0xf2, 0x7f, 0x58, 0x95,
    0x71, 0x29, 0x23, 0x88, 0x60, 0xf4, 0x66, 0x81, 0x79, 0xb0, 0xdf, 0x08, 0xdd, 0xe0, 0xf7, 0x00, 0xcc, 0x8c, 0x18, 0x68, 0x9d,
    0xe0, 0x76, 0x93, 0x3f, 0xd0, 0xe2, 0x7f, 0x4e, 0xa5, 0x9e, 0x39, 0x0a, 0x9a, 0xea, 0x8f, 0x4d, 0x4b, 0x10, 0x02, 0x1d, 0x55,
    0xdf, 0xf4, 0x05, 0xd5, 0xc0, 0xcc, 0x7d, 0xcd, 0xb1, 0x76, 0xe3, 0xf7, 0xf7, 0x47, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x18, 0x98, 0xad, 0xa0,
    0x4c, 0xb5, 0x67, 0xc2, 0xfe, 0xe2, 0xaa, 0x80, 0x81, 0x16, 0x81, 0x64, 0x7b, 0x04, 0xa1, 0x56, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xec, 0x44, 0x18, 0x8c, 0xa9, 0x43, 0xca, 0x53, 0xd8, 0xf8, 0x97, 0x61, 0x1f, 0x54, 0xa6,
    0x0e, 0x76, 0x4a, 0x15, 0xd5, 0xfb, 0x84, 0xd3, 0x3d, 0x50, 0x54, 0xa7, 0x1e, 0xfd, 0xab, 0x29, 0xbc, 0x02, 0x21, 0x00, 0xd0,
    0x3b, 0x4e, 0xcc, 0x7c, 0xb5, 0x9a, 0x4f, 0x52, 0xc1, 0xa5, 0xa2, 0x94, 0x06, 0x3e, 0xef, 0xce, 0xc8, 0x84, 0x7a, 0x5a, 0xee,
    0xeb, 0x33, 0x84, 0x02, 0x7a, 0x01, 0x52, 0x2d, 0x32, 0x65,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_8019[65] = {
    0x04, 0x4d, 0x0f, 0x58, 0xc2, 0xf2, 0x7f, 0x58, 0x95, 0x71, 0x29, 0x23, 0x88, 0x60, 0xf4, 0x66, 0x81,
    0x79, 0xb0, 0xdf, 0x08, 0xdd, 0xe0, 0xf7, 0x00, 0xcc, 0x8c, 0x18, 0x68, 0x9d, 0xe0, 0x76, 0x93, 0x3f,
    0xd0, 0xe2, 0x7f, 0x4e, 0xa5, 0x9e, 0x39, 0x0a, 0x9a, 0xea, 0x8f, 0x4d, 0x4b, 0x10, 0x02, 0x1d, 0x55,
    0xdf, 0xf4, 0x05, 0xd5, 0xc0, 0xcc, 0x7d, 0xcd, 0xb1, 0x76, 0xe3, 0xf7, 0xf7, 0x47,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_8019[32] = {
    0xe9, 0xc9, 0x20, 0x76, 0x52, 0xbe, 0x4e, 0x49, 0x95, 0xb9, 0x50, 0xf3, 0x00, 0x87, 0x12, 0x3b,
    0x9f, 0x9e, 0xec, 0x41, 0x96, 0x5d, 0x00, 0xdf, 0x69, 0x49, 0x19, 0x56, 0xcb, 0xe5, 0xb0, 0x49,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_8019);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_8019);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_8019);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801A
const uint8_t kDevelopmentDAC_Cert_FFF3_801A[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x52, 0x79, 0xf4, 0xa7, 0x8e, 0xd4,
    0x62, 0xea, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x41, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x41, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x0d, 0x8d, 0x09, 0xca, 0x49, 0x9b, 0x9c, 0x68,
    0x8c, 0x65, 0x0b, 0x23, 0xdb, 0xfc, 0xf7, 0x87, 0x48, 0xba, 0x9c, 0x52, 0xdd, 0x9b, 0x60, 0xa6, 0xfc, 0x24, 0xed, 0x41, 0x46,
    0xa6, 0xc5, 0xf1, 0x35, 0xd3, 0xaa, 0xb9, 0x05, 0xc0, 0x90, 0xee, 0x13, 0x06, 0x23, 0xce, 0xa1, 0x3f, 0xf5, 0x27, 0x26, 0x0c,
    0x40, 0x05, 0x0e, 0xca, 0xe5, 0x59, 0x71, 0x2d, 0xe4, 0xfc, 0x87, 0x91, 0x56, 0xb0, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x93, 0x7c, 0xe3, 0x97,
    0x8c, 0xb5, 0x99, 0xe3, 0x26, 0xdf, 0xf3, 0xad, 0x2f, 0x09, 0x9b, 0xec, 0x1b, 0x0f, 0x50, 0x62, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xc7, 0x9b, 0x5b, 0xba, 0xc2, 0xa8, 0x0c, 0xa2, 0xbb, 0x65, 0x0d, 0x2c, 0xde, 0x0a, 0xb0,
    0x4a, 0xc9, 0x27, 0x1f, 0x17, 0x72, 0x93, 0xc2, 0xb5, 0x64, 0xfe, 0xb6, 0x85, 0xb5, 0xfe, 0xa8, 0x8b, 0x02, 0x20, 0x08, 0x2d,
    0x18, 0xac, 0xd8, 0xd3, 0xce, 0x0a, 0x72, 0xcd, 0x06, 0x81, 0x0f, 0x19, 0x57, 0xe4, 0x0f, 0xa3, 0xa7, 0x2b, 0x66, 0x54, 0x7a,
    0xf1, 0xe0, 0xd3, 0x8a, 0x75, 0xa9, 0x82, 0x88, 0x24,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_801A[65] = {
    0x04, 0x0d, 0x8d, 0x09, 0xca, 0x49, 0x9b, 0x9c, 0x68, 0x8c, 0x65, 0x0b, 0x23, 0xdb, 0xfc, 0xf7, 0x87,
    0x48, 0xba, 0x9c, 0x52, 0xdd, 0x9b, 0x60, 0xa6, 0xfc, 0x24, 0xed, 0x41, 0x46, 0xa6, 0xc5, 0xf1, 0x35,
    0xd3, 0xaa, 0xb9, 0x05, 0xc0, 0x90, 0xee, 0x13, 0x06, 0x23, 0xce, 0xa1, 0x3f, 0xf5, 0x27, 0x26, 0x0c,
    0x40, 0x05, 0x0e, 0xca, 0xe5, 0x59, 0x71, 0x2d, 0xe4, 0xfc, 0x87, 0x91, 0x56, 0xb0,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_801A[32] = {
    0x71, 0x6d, 0xcb, 0x7a, 0xd3, 0x01, 0xba, 0x31, 0xd3, 0x1f, 0x1e, 0xfe, 0xa8, 0xa8, 0x94, 0x83,
    0x61, 0xe3, 0x33, 0x4a, 0xc0, 0x45, 0x15, 0xba, 0xc6, 0xdc, 0xac, 0x92, 0x71, 0x23, 0x14, 0xa4,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_801A);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_801A);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_801A);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801B
const uint8_t kDevelopmentDAC_Cert_FFF3_801B[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x3b, 0x9d, 0xc5, 0x70, 0x89, 0x62,
    0xd5, 0x33, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x42, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x42, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x9a, 0x98, 0x0c, 0x44, 0x93, 0xbe, 0x44, 0x80,
    0x05, 0xec, 0xad, 0x56, 0x5c, 0x93, 0xb6, 0x6b, 0x64, 0x08, 0x19, 0x6f, 0xe6, 0x0f, 0x43, 0x15, 0xab, 0x85, 0xe3, 0xb7, 0xdb,
    0x82, 0xe0, 0xe2, 0x5d, 0x2e, 0x51, 0x76, 0x29, 0x98, 0x86, 0x4c, 0xb5, 0x06, 0xe9, 0xca, 0x6d, 0xae, 0xf4, 0x0d, 0x2d, 0x18,
    0x28, 0xfe, 0x3b, 0xaf, 0x9c, 0xa0, 0x39, 0x37, 0x8e, 0x5c, 0x3c, 0xca, 0xe7, 0x27, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x54, 0xba, 0x43, 0x5c,
    0x41, 0x77, 0x79, 0x55, 0x6c, 0xab, 0xfb, 0xa7, 0x9e, 0xc1, 0x18, 0x6a, 0x07, 0x05, 0xf2, 0xf4, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xe6, 0xf8, 0x25, 0xa2, 0x9f, 0x79, 0x34, 0x50, 0x5c, 0x6e, 0x21, 0xaf, 0xb7, 0x70, 0x73,
    0xc9, 0xfb, 0xc6, 0xf7, 0x3f, 0x84, 0x61, 0xb4, 0x88, 0x14, 0xd3, 0xea, 0xf9, 0x44, 0x37, 0xa9, 0x21, 0x02, 0x21, 0x00, 0xe0,
    0x9c, 0xac, 0xa0, 0x13, 0x96, 0x58, 0xfd, 0x7a, 0x5a, 0x00, 0x3d, 0x80, 0x7c, 0x6b, 0x8c, 0xf6, 0x69, 0xf3, 0x9f, 0xc4, 0xe1,
    0x14, 0xf0, 0xac, 0x33, 0x32, 0x94, 0x1f, 0x63, 0x1f, 0x86,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_801B[65] = {
    0x04, 0x9a, 0x98, 0x0c, 0x44, 0x93, 0xbe, 0x44, 0x80, 0x05, 0xec, 0xad, 0x56, 0x5c, 0x93, 0xb6, 0x6b,
    0x64, 0x08, 0x19, 0x6f, 0xe6, 0x0f, 0x43, 0x15, 0xab, 0x85, 0xe3, 0xb7, 0xdb, 0x82, 0xe0, 0xe2, 0x5d,
    0x2e, 0x51, 0x76, 0x29, 0x98, 0x86, 0x4c, 0xb5, 0x06, 0xe9, 0xca, 0x6d, 0xae, 0xf4, 0x0d, 0x2d, 0x18,
    0x28, 0xfe, 0x3b, 0xaf, 0x9c, 0xa0, 0x39, 0x37, 0x8e, 0x5c, 0x3c, 0xca, 0xe7, 0x27,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_801B[32] = {
    0xb2, 0x7c, 0x03, 0xfe, 0x49, 0xfa, 0xe3, 0x42, 0x62, 0x50, 0x62, 0xac, 0x57, 0x93, 0x85, 0x49,
    0x2d, 0x36, 0x2c, 0x68, 0x8a, 0x67, 0xd1, 0x1c, 0x36, 0x0e, 0x20, 0x81, 0x10, 0xde, 0x03, 0x89,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_801B);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_801B);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_801B);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801C
const uint8_t kDevelopmentDAC_Cert_FFF3_801C[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x57, 0xab, 0x48, 0x1b, 0x8e, 0xbe,
    0x58, 0x3e, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x43, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x43, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x5f, 0x16, 0x91, 0xf7, 0xfa, 0x9b, 0x1e, 0x1b,
    0x55, 0x6d, 0x59, 0x52, 0x9e, 0x22, 0x1e, 0x79, 0x3f, 0xca, 0x3f, 0x96, 0x99, 0x39, 0x17, 0x5b, 0xcc, 0x4a, 0x6d, 0x1a, 0x60,
    0xc5, 0x78, 0x27, 0x62, 0x31, 0x5f, 0xd3, 0xb5, 0x1e, 0x0c, 0xcd, 0x62, 0xf9, 0x55, 0x5a, 0xc0, 0xbe, 0x72, 0x23, 0x3f, 0x96,
    0x18, 0x1c, 0x0c, 0x69, 0x01, 0x72, 0xc8, 0xd3, 0x01, 0x10, 0x90, 0x8a, 0x82, 0x49, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xb6, 0xc1, 0xec, 0x4c,
    0x73, 0x0a, 0x38, 0x19, 0x46, 0x52, 0x5e, 0x2f, 0xc6, 0x6f, 0x6c, 0xe6, 0x94, 0x62, 0x86, 0x1a, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x20, 0x14, 0x90, 0xaa, 0x97, 0x4e, 0x05, 0x2a, 0x07, 0x18, 0x5e, 0x3b, 0x14, 0x58, 0x42, 0x56, 0x9a,
    0xd6, 0xda, 0x25, 0x59, 0x1e, 0x03, 0x38, 0x87, 0x29, 0x38, 0xeb, 0xca, 0x03, 0x9a, 0xe9, 0x14, 0x02, 0x21, 0x00, 0xcb, 0xa2,
    0x17, 0x19, 0xd9, 0x73, 0xea, 0xc0, 0x8c, 0x5f, 0xd7, 0xdd, 0xa0, 0x22, 0x80, 0xd3, 0x1f, 0x03, 0xd9, 0x3b, 0x1a, 0x2f, 0x6c,
    0x43, 0x2e, 0x0e, 0x9f, 0x53, 0x32, 0xe4, 0x44, 0xb3,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_801C[65] = {
    0x04, 0x5f, 0x16, 0x91, 0xf7, 0xfa, 0x9b, 0x1e, 0x1b, 0x55, 0x6d, 0x59, 0x52, 0x9e, 0x22, 0x1e, 0x79,
    0x3f, 0xca, 0x3f, 0x96, 0x99, 0x39, 0x17, 0x5b, 0xcc, 0x4a, 0x6d, 0x1a, 0x60, 0xc5, 0x78, 0x27, 0x62,
    0x31, 0x5f, 0xd3, 0xb5, 0x1e, 0x0c, 0xcd, 0x62, 0xf9, 0x55, 0x5a, 0xc0, 0xbe, 0x72, 0x23, 0x3f, 0x96,
    0x18, 0x1c, 0x0c, 0x69, 0x01, 0x72, 0xc8, 0xd3, 0x01, 0x10, 0x90, 0x8a, 0x82, 0x49,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_801C[32] = {
    0x71, 0xc5, 0x34, 0x63, 0x3a, 0xce, 0xaf, 0x0d, 0x58, 0x68, 0x6a, 0x5c, 0x71, 0xb0, 0x73, 0xbc,
    0x5f, 0xf3, 0x08, 0x01, 0x6b, 0x0b, 0x0c, 0x14, 0x95, 0x92, 0xa8, 0x80, 0x0d, 0x25, 0x02, 0xe3,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_801C);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_801C);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_801C);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801D
const uint8_t kDevelopmentDAC_Cert_FFF3_801D[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x74, 0xc1, 0xe4, 0x88, 0x13, 0x4f,
    0x28, 0xc4, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x44, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x64, 0x25, 0x72, 0x4b, 0x25, 0x86, 0xe7, 0xd0,
    0xb1, 0xc1, 0xb0, 0x1b, 0x95, 0x9c, 0x00, 0xa0, 0x4d, 0x81, 0xb2, 0x64, 0x2b, 0x30, 0x58, 0x14, 0x28, 0x02, 0xec, 0x10, 0xaa,
    0x2d, 0x2b, 0x40, 0xee, 0xa5, 0x29, 0x30, 0xf3, 0xbc, 0xee, 0x14, 0x19, 0x5c, 0x53, 0x09, 0xe8, 0x09, 0xd8, 0xa0, 0x38, 0x13,
    0x72, 0x60, 0x16, 0x1b, 0xbb, 0xbe, 0x27, 0x67, 0x3b, 0x66, 0x57, 0xe0, 0x56, 0x19, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x9f, 0x77, 0x6f, 0xd0,
    0x90, 0x3e, 0xa8, 0x91, 0x1a, 0x84, 0x93, 0x91, 0xb1, 0xd1, 0x4b, 0x90, 0x5f, 0x9e, 0xf6, 0x22, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xa6, 0xc6, 0xbc, 0xbd, 0x21, 0xf4, 0x94, 0x54, 0xb0, 0x73, 0xbb, 0x9e, 0x6f, 0xb5, 0xde,
    0xf6, 0x2a, 0x6b, 0x25, 0x49, 0x45, 0xd5, 0xa5, 0xe2, 0x44, 0x0f, 0xfa, 0x13, 0xd2, 0x9b, 0xb1, 0x8b, 0x02, 0x20, 0x0d, 0x8c,
    0xbb, 0x90, 0xaf, 0x94, 0xc3, 0xeb, 0xea, 0x43, 0xe8, 0x97, 0xf8, 0x10, 0x54, 0xff, 0xad, 0xc0, 0xc4, 0x7a, 0x50, 0x44, 0x94,
    0x40, 0xef, 0x15, 0xe1, 0x44, 0xc8, 0x9b, 0xea, 0x1e,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_801D[65] = {
    0x04, 0x64, 0x25, 0x72, 0x4b, 0x25, 0x86, 0xe7, 0xd0, 0xb1, 0xc1, 0xb0, 0x1b, 0x95, 0x9c, 0x00, 0xa0,
    0x4d, 0x81, 0xb2, 0x64, 0x2b, 0x30, 0x58, 0x14, 0x28, 0x02, 0xec, 0x10, 0xaa, 0x2d, 0x2b, 0x40, 0xee,
    0xa5, 0x29, 0x30, 0xf3, 0xbc, 0xee, 0x14, 0x19, 0x5c, 0x53, 0x09, 0xe8, 0x09, 0xd8, 0xa0, 0x38, 0x13,
    0x72, 0x60, 0x16, 0x1b, 0xbb, 0xbe, 0x27, 0x67, 0x3b, 0x66, 0x57, 0xe0, 0x56, 0x19,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_801D[32] = {
    0x85, 0xb6, 0x9a, 0x1d, 0x72, 0xd4, 0xba, 0xa1, 0xce, 0xf4, 0x5f, 0x29, 0x05, 0x5b, 0xad, 0x83,
    0xa2, 0x4c, 0x1c, 0x26, 0xf7, 0xa9, 0xae, 0x0f, 0x63, 0x9a, 0xbb, 0x6d, 0x52, 0x31, 0x4d, 0x05,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_801D);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_801D);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_801D);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801E
const uint8_t kDevelopmentDAC_Cert_FFF3_801E[493] = {
    0x30, 0x82, 0x01, 0xe9, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x2c, 0x97, 0xdf, 0xb5, 0x5a, 0x3a,
    0xdf, 0x28, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x45, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x45, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xbf, 0xee, 0x5c, 0x14, 0x05, 0x11, 0x68, 0x54,
    0xdb, 0xee, 0x31, 0x61, 0x1f, 0xad, 0x11, 0xe0, 0xf3, 0xf7, 0x28, 0x0f, 0x92, 0xec, 0x4a, 0x4a, 0xb3, 0xa8, 0xaa, 0x9a, 0xe5,
    0x80, 0xab, 0xe0, 0xdf, 0x89, 0xd5, 0x1c, 0x7c, 0x64, 0x7d, 0x17, 0x85, 0x1d, 0xd0, 0x33, 0xb4, 0x3f, 0x6f, 0x30, 0x0f, 0xb1,
    0xc5, 0x69, 0x38, 0xf3, 0xf1, 0x88, 0xe7, 0xd9, 0x2a, 0x06, 0xf8, 0x98, 0xdc, 0x15, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x0a, 0x9a, 0x6a, 0xfe,
    0x10, 0x06, 0x3c, 0xa1, 0x2a, 0xd3, 0x1b, 0x3e, 0x9b, 0x06, 0xb0, 0x4a, 0xf5, 0x0d, 0xe0, 0x9c, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x49,
    0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0xd2, 0x0f, 0x60, 0x95, 0x54, 0x17, 0x53, 0x2e, 0x3b, 0xe8, 0xce, 0x88, 0x74, 0x58, 0x5b,
    0x46, 0xb7, 0x81, 0x0b, 0xb3, 0x5b, 0xcf, 0x8c, 0xbe, 0x6b, 0x35, 0xeb, 0x22, 0xc5, 0x83, 0xf7, 0x81, 0x02, 0x21, 0x00, 0x84,
    0x83, 0x46, 0x78, 0x2e, 0x4c, 0x03, 0x48, 0x40, 0x1b, 0x28, 0x94, 0x11, 0x44, 0x17, 0xd3, 0x78, 0xc9, 0xc5, 0xc9, 0x7b, 0x21,
    0x7c, 0x31, 0xe1, 0xff, 0x08, 0xfb, 0xbb, 0xcd, 0xb5, 0x40,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_801E[65] = {
    0x04, 0xbf, 0xee, 0x5c, 0x14, 0x05, 0x11, 0x68, 0x54, 0xdb, 0xee, 0x31, 0x61, 0x1f, 0xad, 0x11, 0xe0,
    0xf3, 0xf7, 0x28, 0x0f, 0x92, 0xec, 0x4a, 0x4a, 0xb3, 0xa8, 0xaa, 0x9a, 0xe5, 0x80, 0xab, 0xe0, 0xdf,
    0x89, 0xd5, 0x1c, 0x7c, 0x64, 0x7d, 0x17, 0x85, 0x1d, 0xd0, 0x33, 0xb4, 0x3f, 0x6f, 0x30, 0x0f, 0xb1,
    0xc5, 0x69, 0x38, 0xf3, 0xf1, 0x88, 0xe7, 0xd9, 0x2a, 0x06, 0xf8, 0x98, 0xdc, 0x15,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_801E[32] = {
    0x14, 0xc5, 0x7a, 0xe3, 0x38, 0x4e, 0x66, 0x7f, 0x7b, 0x09, 0x95, 0xef, 0x46, 0x26, 0x3a, 0x89,
    0x60, 0x86, 0xa0, 0xf6, 0xef, 0x6e, 0x2e, 0xb0, 0xbc, 0x76, 0x9d, 0x9b, 0x66, 0xc0, 0xb2, 0x5d,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_801E);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_801E);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_801E);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3 && CHIP_DEVICE_CONFIG_DEVICE_PRODUCT_ID == 0x801F
const uint8_t kDevelopmentDAC_Cert_FFF3_801F[492] = {
    0x30, 0x82, 0x01, 0xe8, 0x30, 0x82, 0x01, 0x8e, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x4b, 0x8f, 0x95, 0x31, 0xfe, 0xe3,
    0x4b, 0x53, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30,
    0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32,
    0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x53, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61,
    0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x44, 0x41, 0x43, 0x20, 0x30, 0x78, 0x46, 0x46, 0x46, 0x33, 0x2f, 0x30,
    0x78, 0x38, 0x30, 0x31, 0x46, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01,
    0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02,
    0x02, 0x0c, 0x04, 0x38, 0x30, 0x31, 0x46, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06,
    0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x26, 0x95, 0xb0, 0xfd, 0x7c, 0x5e, 0xb6, 0x2e,
    0x21, 0xfb, 0xad, 0x3c, 0x58, 0x1c, 0x06, 0x67, 0x7b, 0x87, 0xa4, 0x3f, 0x9d, 0x92, 0x4d, 0x08, 0xb9, 0xf3, 0x39, 0x0a, 0xe1,
    0x8c, 0x51, 0x7e, 0x07, 0x75, 0x25, 0x47, 0x08, 0xc7, 0xc5, 0x3e, 0x23, 0x14, 0x4b, 0x20, 0xde, 0xe1, 0xf3, 0x26, 0x9c, 0x95,
    0x7e, 0xca, 0xab, 0x44, 0x1c, 0x0c, 0xf6, 0xa5, 0x4c, 0x7b, 0xa7, 0x74, 0x70, 0xb7, 0xa3, 0x60, 0x30, 0x5e, 0x30, 0x0c, 0x06,
    0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff,
    0x04, 0x04, 0x03, 0x02, 0x07, 0x80, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x2c, 0x82, 0xf0, 0xcb,
    0x2b, 0x7b, 0x6a, 0x95, 0xd5, 0x40, 0xf0, 0x0d, 0x23, 0x49, 0x0d, 0x4f, 0x33, 0xd2, 0x42, 0x53, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48,
    0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xaf, 0xb1, 0x4b, 0x08, 0x61, 0x81, 0xde, 0xe5, 0x57, 0x58, 0xee, 0x53, 0x8a, 0x61, 0xac,
    0x42, 0x2c, 0x84, 0x42, 0x95, 0x25, 0x3a, 0x81, 0x57, 0xcd, 0x25, 0x81, 0x7f, 0x9e, 0x53, 0xf7, 0x84, 0x02, 0x20, 0x7b, 0x60,
    0x45, 0x4c, 0xd4, 0xfc, 0xe3, 0xcd, 0x2d, 0x55, 0xf6, 0x4e, 0x95, 0x49, 0x2e, 0x90, 0x7d, 0xf2, 0x56, 0x41, 0x7f, 0x1d, 0x1f,
    0xd4, 0x40, 0x3e, 0x55, 0x4d, 0x77, 0x3f, 0xdc, 0x7e,
};
const uint8_t kDevelopmentDAC_PublicKey_FFF3_801F[65] = {
    0x04, 0x26, 0x95, 0xb0, 0xfd, 0x7c, 0x5e, 0xb6, 0x2e, 0x21, 0xfb, 0xad, 0x3c, 0x58, 0x1c, 0x06, 0x67,
    0x7b, 0x87, 0xa4, 0x3f, 0x9d, 0x92, 0x4d, 0x08, 0xb9, 0xf3, 0x39, 0x0a, 0xe1, 0x8c, 0x51, 0x7e, 0x07,
    0x75, 0x25, 0x47, 0x08, 0xc7, 0xc5, 0x3e, 0x23, 0x14, 0x4b, 0x20, 0xde, 0xe1, 0xf3, 0x26, 0x9c, 0x95,
    0x7e, 0xca, 0xab, 0x44, 0x1c, 0x0c, 0xf6, 0xa5, 0x4c, 0x7b, 0xa7, 0x74, 0x70, 0xb7,
};
const uint8_t kDevelopmentDAC_PrivateKey_FFF3_801F[32] = {
    0xcb, 0xd5, 0x46, 0xa2, 0x3a, 0x82, 0xb8, 0xf2, 0x61, 0x73, 0x93, 0xce, 0xa6, 0xcc, 0x6f, 0xc0,
    0x86, 0x9b, 0x20, 0xed, 0x03, 0x0c, 0x84, 0x78, 0x6d, 0x58, 0x38, 0x85, 0x0b, 0x3c, 0xa7, 0x3f,
};
ByteSpan kDacCert       = ByteSpan(kDevelopmentDAC_Cert_FFF3_801F);
ByteSpan kDacPrivateKey = ByteSpan(kDevelopmentDAC_PrivateKey_FFF3_801F);
ByteSpan kDacPublicKey  = ByteSpan(kDevelopmentDAC_PublicKey_FFF3_801F);
#endif
} // namespace DevelopmentCerts
} // namespace chip
