/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * NOTE: This file is generated by src/tools/chip-cert/dacs.py.
 */
#include "ExamplePAI.h"

#include <cstdint>

#include <lib/support/Span.h>
#include <platform/CHIPDeviceConfig.h>

namespace chip {
namespace DevelopmentCerts {

#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF1
const uint8_t kDevelopmentPAI_Cert_FFF1[463] = {
    0x30, 0x82, 0x01, 0xcb, 0x30, 0x82, 0x01, 0x71, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x56, 0xad, 0x82, 0x22, 0xad, 0x94,
    0x5b, 0x64, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x30, 0x31, 0x18, 0x30, 0x16, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x0f, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x50, 0x41, 0x41,
    0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46,
    0x31, 0x30, 0x20, 0x17, 0x0d, 0x32, 0x32, 0x30, 0x32, 0x30, 0x35, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39,
    0x39, 0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20,
    0x30, 0x78, 0x46, 0x46, 0x46, 0x31, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06,
    0x01, 0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x31, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a,
    0x86, 0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x41,
    0x9a, 0x93, 0x15, 0xc2, 0x17, 0x3e, 0x0c, 0x8c, 0x87, 0x6d, 0x03, 0xcc, 0xfc, 0x94, 0x48, 0x52, 0x64, 0x7f, 0x7f, 0xec, 0x5e,
    0x50, 0x82, 0xf4, 0x05, 0x99, 0x28, 0xec, 0xa8, 0x94, 0xc5, 0x94, 0x15, 0x13, 0x09, 0xac, 0x63, 0x1e, 0x4c, 0xb0, 0x33, 0x92,
    0xaf, 0x68, 0x4b, 0x0b, 0xaf, 0xb7, 0xe6, 0x5b, 0x3b, 0x81, 0x62, 0xc2, 0xf5, 0x2b, 0xf9, 0x31, 0xb8, 0xe7, 0x7a, 0xaa, 0x82,
    0xa3, 0x66, 0x30, 0x64, 0x30, 0x12, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x08, 0x30, 0x06, 0x01, 0x01, 0xff,
    0x02, 0x01, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 0x30, 0x1d,
    0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x63, 0x54, 0x0e, 0x47, 0xf6, 0x4b, 0x1c, 0x38, 0xd1, 0x38, 0x84, 0xa4,
    0x62, 0xd1, 0x6c, 0x19, 0x5d, 0x8f, 0xfb, 0x3c, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14,
    0x6a, 0xfd, 0x22, 0x77, 0x1f, 0x51, 0x1f, 0xec, 0xbf, 0x16, 0x41, 0x97, 0x67, 0x10, 0xdc, 0xdc, 0x31, 0xa1, 0x71, 0x7e, 0x30,
    0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48, 0x00, 0x30, 0x45, 0x02, 0x21, 0x00, 0xb2, 0xef,
    0x27, 0xf4, 0x9a, 0xe9, 0xb5, 0x0f, 0xb9, 0x1e, 0xea, 0xc9, 0x4c, 0x4d, 0x0b, 0xdb, 0xb8, 0xd7, 0x92, 0x9c, 0x6c, 0xb8, 0x8f,
    0xac, 0xe5, 0x29, 0x36, 0x8d, 0x12, 0x05, 0x4c, 0x0c, 0x02, 0x20, 0x65, 0x5d, 0xc9, 0x2b, 0x86, 0xbd, 0x90, 0x98, 0x82, 0xa6,
    0xc6, 0x21, 0x77, 0xb8, 0x25, 0xd7, 0xd0, 0x5e, 0xdb, 0xe7, 0xc2, 0x2f, 0x9f, 0xea, 0x71, 0x22, 0x0e, 0x7e, 0xa7, 0x03, 0xf8,
    0x91,
};
const uint8_t kDevelopmentPAI_PublicKey_FFF1[65] = {
    0x04, 0x41, 0x9a, 0x93, 0x15, 0xc2, 0x17, 0x3e, 0x0c, 0x8c, 0x87, 0x6d, 0x03, 0xcc, 0xfc, 0x94, 0x48,
    0x52, 0x64, 0x7f, 0x7f, 0xec, 0x5e, 0x50, 0x82, 0xf4, 0x05, 0x99, 0x28, 0xec, 0xa8, 0x94, 0xc5, 0x94,
    0x15, 0x13, 0x09, 0xac, 0x63, 0x1e, 0x4c, 0xb0, 0x33, 0x92, 0xaf, 0x68, 0x4b, 0x0b, 0xaf, 0xb7, 0xe6,
    0x5b, 0x3b, 0x81, 0x62, 0xc2, 0xf5, 0x2b, 0xf9, 0x31, 0xb8, 0xe7, 0x7a, 0xaa, 0x82,
};
const uint8_t kDevelopmentPAI_PrivateKey_FFF1[32] = {
    0xc1, 0xab, 0x5f, 0xe2, 0x84, 0xb4, 0xc1, 0x89, 0x40, 0xa5, 0x31, 0x61, 0xf8, 0x06, 0x94, 0x40,
    0x50, 0xa1, 0x69, 0x7b, 0x71, 0x76, 0x1d, 0x38, 0x53, 0x37, 0xa8, 0xa3, 0xcd, 0x09, 0x5c, 0x34,
};
ByteSpan kPaiCert       = ByteSpan(kDevelopmentPAI_Cert_FFF1);
ByteSpan kPaiPrivateKey = ByteSpan(kDevelopmentPAI_PrivateKey_FFF1);
ByteSpan kPaiPublicKey  = ByteSpan(kDevelopmentPAI_PublicKey_FFF1);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF2
const uint8_t kDevelopmentPAI_Cert_FFF2[441] = {
    0x30, 0x82, 0x01, 0xb5, 0x30, 0x82, 0x01, 0x5b, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x3d, 0x58, 0xa3, 0xaa, 0x7f, 0x4e,
    0xba, 0x94, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x1a, 0x31, 0x18, 0x30, 0x16, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x0f, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x50, 0x41, 0x41,
    0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30, 0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39,
    0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03,
    0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20, 0x30,
    0x78, 0x46, 0x46, 0x46, 0x32, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01,
    0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x32, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0x04, 0x7a,
    0x12, 0xc6, 0x20, 0xe1, 0x71, 0xa8, 0x0f, 0xea, 0x22, 0xf3, 0x6f, 0xfb, 0x1f, 0x6c, 0xdf, 0xcb, 0x9b, 0x80, 0x65, 0x66, 0x2b,
    0xdb, 0xbd, 0x82, 0x8c, 0x45, 0xb8, 0xf9, 0xc3, 0x50, 0x47, 0xb9, 0x92, 0x50, 0x1e, 0x7d, 0x70, 0x54, 0xf8, 0x5c, 0x05, 0xab,
    0xe2, 0xf7, 0xc7, 0x4b, 0xed, 0x9a, 0x7a, 0x37, 0xae, 0xe9, 0x03, 0x74, 0xcf, 0x63, 0x2f, 0x4b, 0x3d, 0x28, 0xa4, 0x0a, 0xa3,
    0x66, 0x30, 0x64, 0x30, 0x12, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x08, 0x30, 0x06, 0x01, 0x01, 0xff, 0x02,
    0x01, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 0x30, 0x1d, 0x06,
    0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0xab, 0x5f, 0xa3, 0x3b, 0x39, 0xff, 0x28, 0xd7, 0x38, 0x0a, 0xbb, 0x56, 0x07,
    0x37, 0x8f, 0xf0, 0xef, 0x7b, 0x8b, 0xd6, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x78,
    0x5c, 0xe7, 0x05, 0xb8, 0x6b, 0x8f, 0x4e, 0x6f, 0xc7, 0x93, 0xaa, 0x60, 0xcb, 0x43, 0xea, 0x69, 0x68, 0x82, 0xd5, 0x30, 0x0a,
    0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x48, 0x00, 0x30, 0x45, 0x02, 0x20, 0x33, 0x38, 0x04, 0x56,
    0x73, 0xd8, 0x9e, 0x86, 0x18, 0x20, 0x60, 0xc0, 0xfa, 0xa4, 0x39, 0x9c, 0x3a, 0x9b, 0x9b, 0xb3, 0x12, 0x9e, 0xdf, 0x25, 0x89,
    0x4c, 0xcc, 0xc3, 0xc9, 0x57, 0x2d, 0x09, 0x02, 0x21, 0x00, 0xc8, 0x2a, 0x2b, 0xec, 0xb5, 0x12, 0x4c, 0x4e, 0x42, 0xf4, 0x33,
    0x4a, 0xdb, 0xf8, 0x70, 0x2a, 0xee, 0xb2, 0x3b, 0x03, 0x0e, 0xfd, 0xfc, 0xf4, 0x4c, 0xa1, 0x00, 0x4f, 0xc1, 0xc7, 0xc2, 0xe0,
};
const uint8_t kDevelopmentPAI_PublicKey_FFF2[65] = {
    0x04, 0x04, 0x7a, 0x12, 0xc6, 0x20, 0xe1, 0x71, 0xa8, 0x0f, 0xea, 0x22, 0xf3, 0x6f, 0xfb, 0x1f, 0x6c,
    0xdf, 0xcb, 0x9b, 0x80, 0x65, 0x66, 0x2b, 0xdb, 0xbd, 0x82, 0x8c, 0x45, 0xb8, 0xf9, 0xc3, 0x50, 0x47,
    0xb9, 0x92, 0x50, 0x1e, 0x7d, 0x70, 0x54, 0xf8, 0x5c, 0x05, 0xab, 0xe2, 0xf7, 0xc7, 0x4b, 0xed, 0x9a,
    0x7a, 0x37, 0xae, 0xe9, 0x03, 0x74, 0xcf, 0x63, 0x2f, 0x4b, 0x3d, 0x28, 0xa4, 0x0a,
};
const uint8_t kDevelopmentPAI_PrivateKey_FFF2[32] = {
    0x4a, 0x82, 0x62, 0xe8, 0x86, 0x82, 0x85, 0x68, 0x7e, 0x8b, 0xa8, 0x65, 0x0b, 0x63, 0xe3, 0x0b,
    0xa5, 0x06, 0x6c, 0xd2, 0x51, 0x9c, 0xa7, 0x58, 0x22, 0xdc, 0xa5, 0xd5, 0xde, 0xbf, 0x22, 0xc8,
};
ByteSpan kPaiCert       = ByteSpan(kDevelopmentPAI_Cert_FFF2);
ByteSpan kPaiPrivateKey = ByteSpan(kDevelopmentPAI_PrivateKey_FFF2);
ByteSpan kPaiPublicKey  = ByteSpan(kDevelopmentPAI_PublicKey_FFF2);
#endif
#if CHIP_DEVICE_CONFIG_DEVICE_VENDOR_ID == 0xFFF3
const uint8_t kDevelopmentPAI_Cert_FFF3[440] = {
    0x30, 0x82, 0x01, 0xb4, 0x30, 0x82, 0x01, 0x5b, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x23, 0x58, 0x10, 0x1b, 0xf9, 0x4d,
    0x71, 0xf9, 0x30, 0x0a, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x30, 0x1a, 0x31, 0x18, 0x30, 0x16, 0x06,
    0x03, 0x55, 0x04, 0x03, 0x0c, 0x0f, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x54, 0x65, 0x73, 0x74, 0x20, 0x50, 0x41, 0x41,
    0x30, 0x20, 0x17, 0x0d, 0x32, 0x33, 0x30, 0x33, 0x30, 0x37, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x39, 0x39,
    0x39, 0x39, 0x31, 0x32, 0x33, 0x31, 0x32, 0x33, 0x35, 0x39, 0x35, 0x39, 0x5a, 0x30, 0x3d, 0x31, 0x25, 0x30, 0x23, 0x06, 0x03,
    0x55, 0x04, 0x03, 0x0c, 0x1c, 0x4d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x44, 0x65, 0x76, 0x20, 0x50, 0x41, 0x49, 0x20, 0x30,
    0x78, 0x46, 0x46, 0x46, 0x33, 0x20, 0x6e, 0x6f, 0x20, 0x50, 0x49, 0x44, 0x31, 0x14, 0x30, 0x12, 0x06, 0x0a, 0x2b, 0x06, 0x01,
    0x04, 0x01, 0x82, 0xa2, 0x7c, 0x02, 0x01, 0x0c, 0x04, 0x46, 0x46, 0x46, 0x33, 0x30, 0x59, 0x30, 0x13, 0x06, 0x07, 0x2a, 0x86,
    0x48, 0xce, 0x3d, 0x02, 0x01, 0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07, 0x03, 0x42, 0x00, 0x04, 0xfa, 0xa9,
    0x10, 0xd0, 0x3b, 0x54, 0xa0, 0x41, 0xcd, 0x7e, 0x3e, 0x10, 0x85, 0xc6, 0xea, 0x29, 0x93, 0x34, 0xe5, 0x22, 0xb6, 0x42, 0x3a,
    0xc4, 0x90, 0x71, 0x0b, 0xd5, 0x4b, 0x32, 0x26, 0xbf, 0x13, 0x8b, 0xed, 0xf8, 0x5d, 0xed, 0xe1, 0x4b, 0x4f, 0xbb, 0xaf, 0x42,
    0x88, 0x70, 0x66, 0x37, 0x96, 0x87, 0x1e, 0x89, 0xa1, 0x17, 0x8b, 0x2e, 0xd2, 0x08, 0x54, 0x9f, 0xb8, 0xe4, 0x99, 0x90, 0xa3,
    0x66, 0x30, 0x64, 0x30, 0x12, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x08, 0x30, 0x06, 0x01, 0x01, 0xff, 0x02,
    0x01, 0x00, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x06, 0x30, 0x1d, 0x06,
    0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x34, 0x97, 0x42, 0xe6, 0x15, 0x7f, 0x7f, 0xd0, 0x14, 0x9c, 0x55, 0x32, 0xb6,
    0x9b, 0x7e, 0x2c, 0x88, 0xe4, 0xa7, 0x6b, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x78,
    0x5c, 0xe7, 0x05, 0xb8, 0x6b, 0x8f, 0x4e, 0x6f, 0xc7, 0x93, 0xaa, 0x60, 0xcb, 0x43, 0xea, 0x69, 0x68, 0x82, 0xd5, 0x30, 0x0a,
    0x06, 0x08, 0x2a, 0x86, 0x48, 0xce, 0x3d, 0x04, 0x03, 0x02, 0x03, 0x47, 0x00, 0x30, 0x44, 0x02, 0x20, 0x7d, 0xb1, 0xa1, 0xe0,
    0xfd, 0x76, 0xab, 0xdd, 0xff, 0x1d, 0x87, 0x83, 0x61, 0xb0, 0x11, 0x26, 0x7e, 0xd6, 0xe3, 0x22, 0x99, 0xbc, 0xa6, 0x37, 0x9a,
    0x77, 0x21, 0xfb, 0x1c, 0x56, 0x02, 0xf7, 0x02, 0x20, 0x59, 0x09, 0x00, 0x5d, 0x3a, 0x9b, 0xda, 0xe9, 0x68, 0xb8, 0x45, 0xba,
    0x5c, 0x10, 0x26, 0xc6, 0x01, 0x42, 0xa9, 0x40, 0x41, 0xf7, 0x70, 0xd5, 0x50, 0xc0, 0x52, 0xc5, 0xba, 0x14, 0x4f, 0xb2,
};
const uint8_t kDevelopmentPAI_PublicKey_FFF3[65] = {
    0x04, 0xfa, 0xa9, 0x10, 0xd0, 0x3b, 0x54, 0xa0, 0x41, 0xcd, 0x7e, 0x3e, 0x10, 0x85, 0xc6, 0xea, 0x29,
    0x93, 0x34, 0xe5, 0x22, 0xb6, 0x42, 0x3a, 0xc4, 0x90, 0x71, 0x0b, 0xd5, 0x4b, 0x32, 0x26, 0xbf, 0x13,
    0x8b, 0xed, 0xf8, 0x5d, 0xed, 0xe1, 0x4b, 0x4f, 0xbb, 0xaf, 0x42, 0x88, 0x70, 0x66, 0x37, 0x96, 0x87,
    0x1e, 0x89, 0xa1, 0x17, 0x8b, 0x2e, 0xd2, 0x08, 0x54, 0x9f, 0xb8, 0xe4, 0x99, 0x90,
};
const uint8_t kDevelopmentPAI_PrivateKey_FFF3[32] = {
    0x77, 0x7b, 0x30, 0xbf, 0x7b, 0xaa, 0x5d, 0x5d, 0xc9, 0xca, 0x9d, 0x0b, 0x93, 0x01, 0xcb, 0x6f,
    0xea, 0x0e, 0x92, 0x89, 0x6c, 0x97, 0x11, 0x68, 0xfc, 0x95, 0xfc, 0xad, 0x86, 0x54, 0x45, 0x88,
};
ByteSpan kPaiCert       = ByteSpan(kDevelopmentPAI_Cert_FFF3);
ByteSpan kPaiPrivateKey = ByteSpan(kDevelopmentPAI_PrivateKey_FFF3);
ByteSpan kPaiPublicKey  = ByteSpan(kDevelopmentPAI_PublicKey_FFF3);
#endif
} // namespace DevelopmentCerts
} // namespace chip
