/*
 *    Copyright (c) 2022 Project CHIP Authors
 *    All rights reserved.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

#include "CHIPCert_unit_test_vectors.h"

namespace chip {
namespace TestCerts {

// Following parts are generated by command:
//
//   cat src/credentials/tests/certificates/certs | while read i; do
//     ./out/linux-x64-chip-cert/chip-cert convert-cert -c src/credentials/tests/certificates/$i /tmp/certs/$i
//     xxd -i /tmp/certs/$i
//     echo
//   done >> src/credentials/tests/CHIPCert_unit_test_vectors.cpp
//
// With minor edit

// ======== Begin Generated Certs ========
unsigned char UnitTest_RootA_crt[] = {
    0x15, 0x30, 0x01, 0x08, 0x64, 0xb5, 0x3e, 0x16, 0xd1, 0x6c, 0x62, 0x10, 0x24, 0x02, 0x01, 0x37, 0x03, 0x27, 0x14, 0x0a, 0x00,
    0x00, 0x00, 0xca, 0xca, 0xca, 0xca, 0x27, 0x15, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xab, 0xbf, 0xfa, 0x18, 0x26, 0x04, 0x8c, 0xba,
    0x07, 0x2a, 0x26, 0x05, 0x0c, 0x58, 0xa6, 0x4f, 0x37, 0x06, 0x27, 0x14, 0x0a, 0x00, 0x00, 0x00, 0xca, 0xca, 0xca, 0xca, 0x27,
    0x15, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xab, 0xbf, 0xfa, 0x18, 0x24, 0x07, 0x01, 0x24, 0x08, 0x01, 0x30, 0x09, 0x41, 0x04, 0x5b,
    0xdd, 0x96, 0x58, 0x03, 0x5f, 0x6c, 0x26, 0x69, 0xe9, 0x27, 0xf0, 0xc1, 0xab, 0xa0, 0x79, 0xd3, 0x23, 0x44, 0x83, 0xc1, 0x82,
    0x39, 0x78, 0x4b, 0x1a, 0x0d, 0x05, 0x7f, 0x62, 0xce, 0x72, 0x8c, 0xae, 0x3b, 0x9f, 0xef, 0x49, 0x18, 0xf0, 0xe8, 0xe8, 0x3b,
    0x6e, 0x98, 0x71, 0x81, 0x79, 0xb7, 0x8f, 0x66, 0x3a, 0x49, 0x0f, 0x7c, 0x32, 0x0e, 0x5d, 0x8b, 0x7c, 0x76, 0x55, 0x6a, 0x2e,
    0x37, 0x0a, 0x35, 0x01, 0x29, 0x01, 0x18, 0x30, 0x04, 0x14, 0x05, 0xf4, 0x81, 0x3b, 0x07, 0xfc, 0xb2, 0x6e, 0x56, 0xc8, 0x56,
    0x3c, 0x3b, 0x11, 0x97, 0x1f, 0xf6, 0xd1, 0xad, 0x1f, 0x30, 0x05, 0x14, 0x05, 0xf4, 0x81, 0x3b, 0x07, 0xfc, 0xb2, 0x6e, 0x56,
    0xc8, 0x56, 0x3c, 0x3b, 0x11, 0x97, 0x1f, 0xf6, 0xd1, 0xad, 0x1f, 0x24, 0x02, 0x60, 0x18, 0x30, 0x0b, 0x40, 0xe4, 0x18, 0xf4,
    0xf7, 0x54, 0x5b, 0x9d, 0xa1, 0xe3, 0xdd, 0x9f, 0xb4, 0x70, 0x1a, 0x47, 0xda, 0xca, 0x41, 0x80, 0x56, 0xfc, 0x6a, 0xe1, 0x71,
    0x02, 0xa1, 0xfc, 0xc6, 0xd2, 0x82, 0x02, 0x57, 0x6d, 0xfd, 0x4b, 0xa7, 0xeb, 0x1c, 0x1d, 0x38, 0x8a, 0xfb, 0x6e, 0x4d, 0xed,
    0x33, 0x1f, 0xf3, 0x91, 0xf7, 0xfb, 0x2b, 0xb6, 0x59, 0x85, 0x6b, 0x4b, 0x42, 0x1b, 0x35, 0x9b, 0x15, 0xe8, 0xc0, 0x18
};
unsigned int UnitTest_RootA_crt_len = 272;

unsigned char UnitTest_RootB_crt[] = {
    0x15, 0x30, 0x01, 0x08, 0x1d, 0xe8, 0xdc, 0x31, 0x7d, 0x93, 0x8e, 0x8e, 0x24, 0x02, 0x01, 0x37, 0x03, 0x27, 0x14, 0x0b, 0x00,
    0x00, 0x00, 0xca, 0xca, 0xca, 0xca, 0x18, 0x26, 0x04, 0x20, 0xae, 0x07, 0x2a, 0x26, 0x05, 0xa0, 0x4b, 0xa6, 0x4f, 0x37, 0x06,
    0x27, 0x14, 0x0b, 0x00, 0x00, 0x00, 0xca, 0xca, 0xca, 0xca, 0x18, 0x24, 0x07, 0x01, 0x24, 0x08, 0x01, 0x30, 0x09, 0x41, 0x04,
    0x66, 0x90, 0x7a, 0xd6, 0x68, 0xee, 0x8a, 0xc8, 0xbf, 0x9e, 0x98, 0xba, 0xdb, 0x15, 0x47, 0x18, 0x4e, 0x82, 0x6e, 0x5a, 0x22,
    0x41, 0x96, 0x27, 0xe8, 0x5f, 0xc7, 0x47, 0xaf, 0x74, 0xe4, 0x47, 0x44, 0x46, 0x9a, 0x63, 0xed, 0x21, 0x5f, 0x66, 0x85, 0x2d,
    0x0d, 0xfc, 0x23, 0x07, 0x83, 0x74, 0x8c, 0x9e, 0x98, 0x80, 0xe5, 0xcc, 0xd9, 0x79, 0xd0, 0x67, 0x27, 0xeb, 0x45, 0xb3, 0x81,
    0x55, 0x37, 0x0a, 0x35, 0x01, 0x29, 0x01, 0x18, 0x30, 0x04, 0x14, 0xb9, 0xad, 0x57, 0x9d, 0xbc, 0xd9, 0x5a, 0x3f, 0x34, 0x07,
    0x17, 0x8f, 0x04, 0x02, 0x5b, 0x40, 0x29, 0x12, 0xbd, 0xa9, 0x30, 0x05, 0x14, 0xb9, 0xad, 0x57, 0x9d, 0xbc, 0xd9, 0x5a, 0x3f,
    0x34, 0x07, 0x17, 0x8f, 0x04, 0x02, 0x5b, 0x40, 0x29, 0x12, 0xbd, 0xa9, 0x24, 0x02, 0x60, 0x18, 0x30, 0x0b, 0x40, 0xbc, 0xf0,
    0x78, 0x1a, 0xba, 0xd6, 0x85, 0xbc, 0x8e, 0xbc, 0xb3, 0x67, 0x43, 0xcb, 0x9c, 0x45, 0x87, 0xba, 0x89, 0xe9, 0xa1, 0xdb, 0xc1,
    0x79, 0x6f, 0x9d, 0xf5, 0xd6, 0x72, 0xf9, 0x7b, 0x45, 0xa4, 0xa5, 0xa4, 0x96, 0x3a, 0x53, 0x31, 0x73, 0x0f, 0xe3, 0x25, 0x2b,
    0xe4, 0x8a, 0x4c, 0x68, 0x9b, 0xbc, 0x6d, 0xbd, 0x2e, 0x10, 0xda, 0x38, 0x38, 0x08, 0xe3, 0x48, 0x16, 0x47, 0xb4, 0x7c, 0x18
};
unsigned int UnitTest_RootB_crt_len = 252;

unsigned char UnitTest_IA_A1_crt[] = {
    0x15, 0x30, 0x01, 0x08, 0x2e, 0x9f, 0x88, 0x59, 0xb5, 0x0c, 0x2a, 0x26, 0x24, 0x02, 0x01, 0x37, 0x03, 0x27, 0x14, 0x0a, 0x00,
    0x00, 0x00, 0xca, 0xca, 0xca, 0xca, 0x27, 0x15, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xab, 0xbf, 0xfa, 0x18, 0x26, 0x04, 0x68, 0xb1,
    0x07, 0x2a, 0x26, 0x05, 0xe8, 0x4e, 0xa6, 0x4f, 0x37, 0x06, 0x27, 0x13, 0xa1, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x18,
    0x24, 0x07, 0x01, 0x24, 0x08, 0x01, 0x30, 0x09, 0x41, 0x04, 0x0b, 0x93, 0x13, 0x6f, 0xca, 0x1b, 0xc7, 0x38, 0x64, 0x5e, 0xc0,
    0x80, 0x9e, 0xaa, 0x07, 0xa7, 0x89, 0x99, 0x6b, 0x55, 0xfc, 0x65, 0xaa, 0xb1, 0x0c, 0x9f, 0xf9, 0xa7, 0x6f, 0x07, 0x15, 0x78,
    0xcf, 0x2f, 0xbd, 0xf4, 0xdc, 0x06, 0x82, 0xbb, 0x17, 0xdb, 0xc9, 0x1e, 0x36, 0xa7, 0x2e, 0xa4, 0xc7, 0x44, 0xfe, 0xef, 0xf5,
    0x34, 0xc3, 0x44, 0x76, 0xda, 0xb4, 0xdb, 0xa2, 0xba, 0x03, 0xef, 0x37, 0x0a, 0x35, 0x01, 0x29, 0x01, 0x18, 0x30, 0x04, 0x14,
    0xd4, 0x64, 0x18, 0xab, 0x4c, 0xe3, 0x7e, 0x69, 0xcb, 0xe1, 0x13, 0xa1, 0xe9, 0xa8, 0x4a, 0x63, 0x73, 0x94, 0x72, 0x10, 0x30,
    0x05, 0x14, 0x05, 0xf4, 0x81, 0x3b, 0x07, 0xfc, 0xb2, 0x6e, 0x56, 0xc8, 0x56, 0x3c, 0x3b, 0x11, 0x97, 0x1f, 0xf6, 0xd1, 0xad,
    0x1f, 0x24, 0x02, 0x60, 0x18, 0x30, 0x0b, 0x40, 0x6e, 0x10, 0xc5, 0x57, 0x88, 0x1c, 0x96, 0xb6, 0xa8, 0x12, 0xf3, 0x34, 0xe1,
    0x59, 0x26, 0x6e, 0xb5, 0x60, 0x2e, 0x50, 0x3b, 0x49, 0x59, 0xe7, 0x1d, 0xf3, 0x38, 0x42, 0x9c, 0x25, 0xed, 0x32, 0x45, 0xda,
    0x5a, 0x32, 0x1d, 0x72, 0x47, 0x19, 0xa9, 0xa0, 0xed, 0x91, 0x0a, 0xd1, 0x08, 0xad, 0xfd, 0xb4, 0xe6, 0x1d, 0xd0, 0x44, 0x06,
    0xe2, 0xbe, 0xd1, 0xab, 0x69, 0x30, 0x41, 0x71, 0x02, 0x18
};
unsigned int UnitTest_IA_A1_crt_len = 262;

unsigned char UnitTest_IA_A2_crt[] = {
    0x15, 0x30, 0x01, 0x08, 0x11, 0x7c, 0x9c, 0xdc, 0x72, 0x1b, 0x64, 0xa9, 0x24, 0x02, 0x01, 0x37, 0x03, 0x27, 0x14, 0x0a, 0x00,
    0x00, 0x00, 0xca, 0xca, 0xca, 0xca, 0x27, 0x15, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xab, 0xbf, 0xfa, 0x18, 0x26, 0x04, 0xa4, 0xb1,
    0x07, 0x2a, 0x26, 0x05, 0x24, 0x4f, 0xa6, 0x4f, 0x37, 0x06, 0x27, 0x13, 0xa2, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x18,
    0x24, 0x07, 0x01, 0x24, 0x08, 0x01, 0x30, 0x09, 0x41, 0x04, 0x56, 0x42, 0x98, 0x5c, 0x75, 0x68, 0x8c, 0x7e, 0xc3, 0x39, 0x8b,
    0xf4, 0x1f, 0xce, 0xa4, 0xb9, 0x8a, 0x3e, 0xd0, 0xa5, 0x8d, 0x14, 0x95, 0xb8, 0xf5, 0x39, 0x57, 0x6d, 0x8c, 0xae, 0x3b, 0x7f,
    0xa3, 0xb5, 0x27, 0xa7, 0xb4, 0x67, 0xa3, 0xd9, 0xbf, 0x32, 0xd0, 0xae, 0xd4, 0x91, 0x6b, 0x35, 0xc4, 0x40, 0x9e, 0x48, 0x55,
    0x5c, 0xa1, 0x82, 0x2c, 0xec, 0x79, 0xfe, 0x65, 0xf9, 0x89, 0xdc, 0x37, 0x0a, 0x35, 0x01, 0x29, 0x01, 0x18, 0x30, 0x04, 0x14,
    0x0f, 0x84, 0x4c, 0xf6, 0x84, 0x73, 0x3d, 0xec, 0x6c, 0x8b, 0xeb, 0x28, 0x95, 0x4b, 0xbe, 0x1b, 0x89, 0xd3, 0xa7, 0x6c, 0x30,
    0x05, 0x14, 0x05, 0xf4, 0x81, 0x3b, 0x07, 0xfc, 0xb2, 0x6e, 0x56, 0xc8, 0x56, 0x3c, 0x3b, 0x11, 0x97, 0x1f, 0xf6, 0xd1, 0xad,
    0x1f, 0x24, 0x02, 0x60, 0x18, 0x30, 0x0b, 0x40, 0xfa, 0xb8, 0xdf, 0x2c, 0xca, 0x48, 0x9b, 0x7f, 0x7f, 0xcf, 0xef, 0xc1, 0x1b,
    0xa5, 0xb7, 0x25, 0x48, 0x3f, 0xa0, 0xef, 0x6d, 0x62, 0xfe, 0x03, 0xd6, 0xcd, 0x83, 0x8e, 0x86, 0x55, 0x73, 0x63, 0x65, 0x78,
    0x12, 0xe8, 0x0e, 0x37, 0xb9, 0x8b, 0x37, 0x22, 0x1d, 0x97, 0xd3, 0xbf, 0xa0, 0x46, 0x71, 0x4c, 0x82, 0xcd, 0xca, 0x49, 0x8a,
    0xc3, 0x37, 0xf6, 0xa3, 0x00, 0x40, 0x01, 0x6d, 0x26, 0x18
};
unsigned int UnitTest_IA_A2_crt_len = 262;

unsigned char UnitTest_IA_B1_crt[] = {
    0x15, 0x30, 0x01, 0x08, 0x1b, 0xb1, 0x3c, 0x7a, 0x3a, 0xca, 0x74, 0xe2, 0x24, 0x02, 0x01, 0x37, 0x03, 0x27, 0x14, 0x0b, 0x00,
    0x00, 0x00, 0xca, 0xca, 0xca, 0xca, 0x18, 0x26, 0x04, 0x68, 0xb1, 0x07, 0x2a, 0x26, 0x05, 0xa0, 0x4b, 0xa6, 0x4f, 0x37, 0x06,
    0x27, 0x13, 0xb1, 0x00, 0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x18, 0x24, 0x07, 0x01, 0x24, 0x08, 0x01, 0x30, 0x09, 0x41, 0x04,
    0x1e, 0x41, 0xba, 0xee, 0xbb, 0x08, 0x16, 0x58, 0xd4, 0x91, 0x78, 0x7c, 0x1b, 0x1b, 0xea, 0x24, 0xb4, 0xc4, 0x14, 0x2f, 0x47,
    0x86, 0xc3, 0x76, 0x13, 0xfb, 0xdb, 0xdc, 0x1c, 0x65, 0xa9, 0xd0, 0xd2, 0x39, 0x7b, 0x2c, 0xa0, 0xa8, 0xfe, 0x2e, 0xee, 0xcd,
    0x35, 0xc0, 0xd6, 0x26, 0x9c, 0xc8, 0x34, 0x95, 0x44, 0xc8, 0xee, 0xf3, 0xe6, 0x61, 0x39, 0xda, 0xc4, 0x84, 0x21, 0xbe, 0x1e,
    0x89, 0x37, 0x0a, 0x35, 0x01, 0x29, 0x01, 0x18, 0x30, 0x04, 0x14, 0x09, 0x43, 0x17, 0x10, 0x96, 0x73, 0x6a, 0x0b, 0xc8, 0xce,
    0x27, 0x34, 0x2e, 0x43, 0x24, 0xb1, 0xca, 0x98, 0xcf, 0x5a, 0x30, 0x05, 0x14, 0xb9, 0xad, 0x57, 0x9d, 0xbc, 0xd9, 0x5a, 0x3f,
    0x34, 0x07, 0x17, 0x8f, 0x04, 0x02, 0x5b, 0x40, 0x29, 0x12, 0xbd, 0xa9, 0x24, 0x02, 0x60, 0x18, 0x30, 0x0b, 0x40, 0xb6, 0x19,
    0xc8, 0x80, 0x99, 0xbf, 0x5e, 0x17, 0xd4, 0x3d, 0xec, 0x22, 0x01, 0x2c, 0x00, 0xb9, 0x37, 0xac, 0x7e, 0x6b, 0xed, 0x0c, 0x1a,
    0x7b, 0x75, 0x09, 0x0d, 0xa7, 0xb2, 0xde, 0xb1, 0x58, 0x1c, 0xb9, 0x04, 0x61, 0x56, 0xa4, 0x4f, 0xff, 0x31, 0xdb, 0xe4, 0x2a,
    0x22, 0x91, 0xf9, 0x8c, 0x70, 0xcd, 0x59, 0xb9, 0xdc, 0x44, 0x9e, 0xa2, 0xbd, 0x80, 0x72, 0x37, 0x7b, 0x0a, 0x7d, 0x2b, 0x18
};
unsigned int UnitTest_IA_B1_crt_len = 252;

unsigned char UnitTest_NodeA1_crt[] = {
    0x15, 0x30, 0x01, 0x08, 0x09, 0xba, 0xa5, 0xb6, 0x8b, 0x84, 0x71, 0xd8, 0x24, 0x02, 0x01, 0x37, 0x03, 0x27, 0x13, 0xa1, 0x00,
    0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x18, 0x26, 0x04, 0x58, 0xb2, 0x07, 0x2a, 0x26, 0x05, 0xd8, 0x4f, 0xa6, 0x4f, 0x37, 0x06,
    0x26, 0x11, 0x44, 0x33, 0x22, 0x11, 0x27, 0x15, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xab, 0xbf, 0xfa, 0x18, 0x24, 0x07, 0x01, 0x24,
    0x08, 0x01, 0x30, 0x09, 0x41, 0x04, 0x38, 0x9b, 0x9e, 0xc4, 0x9e, 0x84, 0x48, 0xc0, 0x8f, 0x34, 0x14, 0x9c, 0x3e, 0xa9, 0x47,
    0xd1, 0x49, 0xe2, 0xbb, 0xf5, 0x93, 0x93, 0x47, 0x5f, 0xa9, 0x16, 0x71, 0x3a, 0xc7, 0x81, 0xd2, 0x73, 0xf8, 0xb5, 0x29, 0xb2,
    0x8f, 0xbe, 0xba, 0x1e, 0x3a, 0x27, 0xd1, 0x42, 0x67, 0xd4, 0x0c, 0x5e, 0xa7, 0x25, 0x4b, 0x62, 0x57, 0x7d, 0x00, 0x30, 0x30,
    0x27, 0xd8, 0xa8, 0x4f, 0xa1, 0x11, 0xa0, 0x37, 0x0a, 0x35, 0x01, 0x28, 0x01, 0x18, 0x30, 0x04, 0x14, 0x69, 0x8d, 0xfb, 0xed,
    0x4a, 0xac, 0x4d, 0xe7, 0x38, 0x95, 0xc6, 0x4f, 0xbe, 0x5e, 0x6f, 0xee, 0xce, 0x9b, 0xf9, 0x59, 0x30, 0x05, 0x14, 0xd4, 0x64,
    0x18, 0xab, 0x4c, 0xe3, 0x7e, 0x69, 0xcb, 0xe1, 0x13, 0xa1, 0xe9, 0xa8, 0x4a, 0x63, 0x73, 0x94, 0x72, 0x10, 0x24, 0x02, 0x01,
    0x36, 0x03, 0x04, 0x01, 0x04, 0x02, 0x18, 0x18, 0x30, 0x0b, 0x40, 0xba, 0x9e, 0xc3, 0x01, 0x7a, 0x12, 0x1a, 0x8b, 0x72, 0xfd,
    0x9a, 0xc7, 0x4f, 0x00, 0x68, 0x98, 0xa1, 0x28, 0x5d, 0x56, 0xfc, 0x8a, 0xd9, 0x4f, 0x56, 0x55, 0x6f, 0x6b, 0x2b, 0x94, 0x1f,
    0x1c, 0x1a, 0xdd, 0x66, 0x44, 0x2d, 0xe5, 0xc6, 0x8e, 0xae, 0x52, 0xc0, 0xa4, 0x53, 0xbd, 0x50, 0xa4, 0x5f, 0xb5, 0x6a, 0x96,
    0x7a, 0x6b, 0xc2, 0x74, 0x3c, 0x54, 0x81, 0xe2, 0x1c, 0x4a, 0x04, 0x14, 0x18
};
unsigned int UnitTest_NodeA1_crt_len = 265;

unsigned char UnitTest_NodeA2_crt[] = {
    0x15, 0x30, 0x01, 0x08, 0x21, 0xac, 0x81, 0x9d, 0x91, 0x60, 0xf6, 0xf0, 0x24, 0x02, 0x01, 0x37, 0x03, 0x27, 0x13, 0xa1, 0x00,
    0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x18, 0x26, 0x04, 0x58, 0xb2, 0x07, 0x2a, 0x26, 0x05, 0xd8, 0x4f, 0xa6, 0x4f, 0x37, 0x06,
    0x26, 0x11, 0x21, 0x43, 0x34, 0x12, 0x27, 0x15, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xab, 0xbf, 0xfa, 0x18, 0x24, 0x07, 0x01, 0x24,
    0x08, 0x01, 0x30, 0x09, 0x41, 0x04, 0x5c, 0x1b, 0x09, 0xfc, 0x88, 0xf6, 0x2b, 0x91, 0xfa, 0xcb, 0x86, 0xef, 0x7d, 0x79, 0x21,
    0x09, 0x47, 0x06, 0xc9, 0xd9, 0x09, 0x8a, 0x2b, 0xa9, 0x39, 0x2b, 0xfc, 0x2f, 0x57, 0x95, 0x96, 0xf2, 0xda, 0x1b, 0x79, 0x62,
    0x52, 0xa9, 0xc6, 0xe4, 0x29, 0xc6, 0x42, 0xe7, 0x21, 0xb4, 0x99, 0x24, 0x0f, 0x35, 0x04, 0xac, 0xcb, 0x84, 0x97, 0x3a, 0xb7,
    0xba, 0x80, 0xc9, 0xb8, 0x3f, 0x19, 0xc0, 0x37, 0x0a, 0x35, 0x01, 0x28, 0x01, 0x18, 0x30, 0x04, 0x14, 0xfb, 0x0e, 0x82, 0x8a,
    0x91, 0x6d, 0x1a, 0x0f, 0x6a, 0xe9, 0x72, 0x1f, 0xd6, 0x11, 0xc3, 0xca, 0xbd, 0x6f, 0xe6, 0xba, 0x30, 0x05, 0x14, 0xd4, 0x64,
    0x18, 0xab, 0x4c, 0xe3, 0x7e, 0x69, 0xcb, 0xe1, 0x13, 0xa1, 0xe9, 0xa8, 0x4a, 0x63, 0x73, 0x94, 0x72, 0x10, 0x24, 0x02, 0x01,
    0x36, 0x03, 0x04, 0x01, 0x04, 0x02, 0x18, 0x18, 0x30, 0x0b, 0x40, 0xfd, 0x6c, 0xd6, 0x56, 0x6b, 0x69, 0x7f, 0x3b, 0x3b, 0x5e,
    0xf0, 0x36, 0x35, 0x78, 0x2e, 0x2d, 0x09, 0xcd, 0xa1, 0xf5, 0xa5, 0x96, 0x6a, 0xf3, 0xdc, 0x4d, 0x4d, 0xdb, 0x5e, 0x2a, 0x6a,
    0xd4, 0xbe, 0x1c, 0x89, 0xde, 0x26, 0xe9, 0xd8, 0x01, 0x8c, 0x65, 0x6c, 0xcc, 0x67, 0xec, 0xab, 0xb1, 0xa5, 0xc0, 0x0d, 0x95,
    0x4e, 0x0a, 0x12, 0xfd, 0x00, 0xad, 0x4e, 0xbb, 0xa5, 0x99, 0xe7, 0x37, 0x18
};
unsigned int UnitTest_NodeA2_crt_len = 265;

unsigned char UnitTest_NodeA3_crt[] = {
    0x15, 0x30, 0x01, 0x08, 0x6a, 0x6e, 0x7c, 0x02, 0x27, 0xe7, 0x85, 0x44, 0x24, 0x02, 0x01, 0x37, 0x03, 0x27, 0x13, 0xa2, 0x00,
    0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x18, 0x26, 0x04, 0x58, 0xb2, 0x07, 0x2a, 0x26, 0x05, 0x24, 0x4f, 0xa6, 0x4f, 0x37, 0x06,
    0x26, 0x11, 0x44, 0x44, 0x33, 0x33, 0x27, 0x15, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xab, 0xbf, 0xfa, 0x18, 0x24, 0x07, 0x01, 0x24,
    0x08, 0x01, 0x30, 0x09, 0x41, 0x04, 0xdc, 0x86, 0xdf, 0x41, 0xfd, 0x7f, 0x64, 0x7b, 0x06, 0xf4, 0xc1, 0xaf, 0x96, 0x97, 0xe8,
    0x51, 0x85, 0x5b, 0x33, 0x6a, 0xeb, 0x04, 0x2b, 0x38, 0xf0, 0x2b, 0xec, 0x46, 0x19, 0x1a, 0x92, 0x7a, 0xe8, 0x56, 0xec, 0xb3,
    0x1e, 0x94, 0x81, 0x2e, 0x88, 0xf0, 0xc3, 0xff, 0x25, 0xa0, 0x05, 0xfd, 0xcf, 0x65, 0xf7, 0xc2, 0x45, 0xbd, 0x5d, 0xdc, 0xc0,
    0xa7, 0x6d, 0x32, 0xac, 0xc0, 0xf0, 0xe2, 0x37, 0x0a, 0x35, 0x01, 0x28, 0x01, 0x18, 0x30, 0x04, 0x14, 0xff, 0x09, 0xbf, 0x22,
    0xa9, 0x30, 0xc3, 0x52, 0xee, 0x28, 0x43, 0xa6, 0x9b, 0xe3, 0xe1, 0x8a, 0x8f, 0x08, 0x6e, 0x05, 0x30, 0x05, 0x14, 0x0f, 0x84,
    0x4c, 0xf6, 0x84, 0x73, 0x3d, 0xec, 0x6c, 0x8b, 0xeb, 0x28, 0x95, 0x4b, 0xbe, 0x1b, 0x89, 0xd3, 0xa7, 0x6c, 0x24, 0x02, 0x01,
    0x36, 0x03, 0x04, 0x01, 0x04, 0x02, 0x18, 0x18, 0x30, 0x0b, 0x40, 0x43, 0x7b, 0xf2, 0x17, 0xaa, 0x67, 0x77, 0x23, 0x22, 0xb8,
    0x7e, 0xcb, 0x9e, 0x94, 0x34, 0xd1, 0xe3, 0x0e, 0x0d, 0xca, 0x26, 0x09, 0x7e, 0x27, 0x9e, 0xff, 0x49, 0x70, 0x11, 0xe3, 0x81,
    0x7f, 0xfe, 0x6b, 0x2c, 0x1b, 0x7c, 0x51, 0xfa, 0xf4, 0xd8, 0x7f, 0x2d, 0xf4, 0x14, 0x35, 0x4d, 0x4b, 0xe1, 0x81, 0x0f, 0xf0,
    0x58, 0x6d, 0x36, 0xd6, 0x44, 0x63, 0xba, 0x4d, 0x1b, 0xad, 0x94, 0x55, 0x18
};
unsigned int UnitTest_NodeA3_crt_len = 265;

unsigned char UnitTest_NodeA4_crt[] = {
    0x15, 0x30, 0x01, 0x08, 0x64, 0xa9, 0x21, 0xf7, 0x7e, 0xcd, 0x8c, 0x5e, 0x24, 0x02, 0x01, 0x37, 0x03, 0x27, 0x14, 0x0a,
    0x00, 0x00, 0x00, 0xca, 0xca, 0xca, 0xca, 0x27, 0x15, 0x0a, 0x00, 0x00, 0x00, 0x00, 0xab, 0xbf, 0xfa, 0x18, 0x26, 0x04,
    0x8c, 0xba, 0x07, 0x2a, 0x26, 0x05, 0x24, 0x4f, 0xa6, 0x4f, 0x37, 0x06, 0x26, 0x11, 0x33, 0x33, 0x44, 0x44, 0x27, 0x15,
    0x0a, 0x00, 0x00, 0x00, 0x00, 0xab, 0xbf, 0xfa, 0x18, 0x24, 0x07, 0x01, 0x24, 0x08, 0x01, 0x30, 0x09, 0x41, 0x04, 0xe3,
    0x64, 0xa0, 0xf1, 0xb0, 0x00, 0xfd, 0xb1, 0x0b, 0x10, 0x0d, 0xd3, 0xd3, 0xa6, 0x89, 0x10, 0xb6, 0x01, 0xa1, 0xcf, 0xe7,
    0x5d, 0xa2, 0x3b, 0x70, 0xc8, 0xa0, 0x06, 0xe2, 0xbb, 0x0e, 0x6e, 0x34, 0x36, 0x9e, 0xce, 0xa2, 0x30, 0xc0, 0x55, 0xa8,
    0xfa, 0x6b, 0x83, 0x9f, 0x79, 0x41, 0x82, 0xbf, 0x4a, 0x85, 0xaf, 0x74, 0x0f, 0xc7, 0xd4, 0x56, 0xa7, 0xdd, 0x3e, 0xc8,
    0xca, 0x80, 0x2b, 0x37, 0x0a, 0x35, 0x01, 0x28, 0x01, 0x18, 0x30, 0x04, 0x14, 0xe1, 0xea, 0xbd, 0xdd, 0x73, 0xb7, 0x50,
    0x07, 0xaa, 0x80, 0x32, 0xda, 0x74, 0xca, 0xc8, 0x68, 0xb1, 0x28, 0xde, 0x90, 0x30, 0x05, 0x14, 0x05, 0xf4, 0x81, 0x3b,
    0x07, 0xfc, 0xb2, 0x6e, 0x56, 0xc8, 0x56, 0x3c, 0x3b, 0x11, 0x97, 0x1f, 0xf6, 0xd1, 0xad, 0x1f, 0x24, 0x02, 0x01, 0x36,
    0x03, 0x04, 0x01, 0x04, 0x02, 0x18, 0x18, 0x30, 0x0b, 0x40, 0xc5, 0x14, 0x6c, 0x9a, 0x40, 0x97, 0x59, 0x17, 0x01, 0xa1,
    0xae, 0x31, 0x1a, 0x4a, 0x7f, 0xa6, 0xa5, 0xd3, 0x65, 0x11, 0xeb, 0xce, 0x11, 0x93, 0x4f, 0xcb, 0xbb, 0x9c, 0xc6, 0x06,
    0x6c, 0x7d, 0x50, 0x67, 0x99, 0xc3, 0x30, 0xe0, 0x19, 0x6f, 0xa8, 0x36, 0xd7, 0xde, 0x0d, 0x36, 0x4c, 0xea, 0xf8, 0x1d,
    0x94, 0xeb, 0x4a, 0xfb, 0xfb, 0xd5, 0x01, 0x46, 0x81, 0xb8, 0xb7, 0xb0, 0xb1, 0xa7, 0x18
};
unsigned int UnitTest_NodeA4_crt_len = 275;

unsigned char UnitTest_NodeB1_crt[] = {
    0x15, 0x30, 0x01, 0x08, 0x0c, 0xfa, 0x9a, 0xd6, 0x9e, 0x78, 0xbd, 0x76, 0x24, 0x02, 0x01, 0x37, 0x03, 0x27, 0x13, 0xb1, 0x00,
    0x00, 0x00, 0x0a, 0x0a, 0x0a, 0x0a, 0x18, 0x26, 0x04, 0x8c, 0xba, 0x07, 0x2a, 0x26, 0x05, 0xa0, 0x4b, 0xa6, 0x4f, 0x37, 0x06,
    0x26, 0x11, 0x44, 0x33, 0x22, 0x11, 0x27, 0x15, 0x0b, 0x00, 0x00, 0x00, 0x00, 0xab, 0xbf, 0xfa, 0x18, 0x24, 0x07, 0x01, 0x24,
    0x08, 0x01, 0x30, 0x09, 0x41, 0x04, 0xd9, 0xd1, 0x5c, 0x74, 0xa0, 0x9c, 0x12, 0xff, 0xbd, 0x20, 0x54, 0xe9, 0xba, 0xe5, 0xda,
    0xaf, 0x5e, 0xb8, 0x0e, 0xc9, 0xd9, 0x96, 0x86, 0xfa, 0xdc, 0xb3, 0xbe, 0xe4, 0x42, 0xa1, 0x19, 0x7a, 0xa1, 0xbf, 0x08, 0xc4,
    0x90, 0x62, 0xff, 0x80, 0x6c, 0xb8, 0xd1, 0xf3, 0xba, 0x4d, 0xd6, 0xe5, 0xe4, 0x6b, 0xab, 0x3c, 0x9d, 0x27, 0x39, 0x73, 0xf5,
    0xf8, 0xaf, 0x4c, 0x27, 0x0c, 0xf8, 0xd8, 0x37, 0x0a, 0x35, 0x01, 0x28, 0x01, 0x18, 0x30, 0x04, 0x14, 0xf6, 0xe5, 0x82, 0x74,
    0x1a, 0x3c, 0x99, 0x50, 0x2c, 0x2a, 0x43, 0x6f, 0xf4, 0x7c, 0x2b, 0x0f, 0xab, 0xe4, 0x0a, 0xcd, 0x30, 0x05, 0x14, 0x09, 0x43,
    0x17, 0x10, 0x96, 0x73, 0x6a, 0x0b, 0xc8, 0xce, 0x27, 0x34, 0x2e, 0x43, 0x24, 0xb1, 0xca, 0x98, 0xcf, 0x5a, 0x24, 0x02, 0x01,
    0x36, 0x03, 0x04, 0x01, 0x04, 0x02, 0x18, 0x18, 0x30, 0x0b, 0x40, 0x46, 0x0f, 0xf9, 0x9a, 0xaa, 0x08, 0x2c, 0x10, 0x62, 0xec,
    0xb0, 0x79, 0x80, 0xef, 0x30, 0xd6, 0x81, 0x49, 0xb6, 0x34, 0x00, 0xac, 0x34, 0x4e, 0xcf, 0x34, 0x15, 0x89, 0x42, 0x77, 0x0f,
    0xc4, 0x4d, 0xc0, 0x15, 0x6c, 0x68, 0xa6, 0x44, 0x10, 0xa7, 0x4b, 0xef, 0x17, 0x02, 0x5a, 0x48, 0x2a, 0x42, 0x83, 0x75, 0x3c,
    0x37, 0x49, 0x28, 0xc2, 0x95, 0x28, 0xc9, 0x8e, 0xf2, 0xa8, 0xd2, 0x6a, 0x18
};
unsigned int UnitTest_NodeB1_crt_len = 265;

// ======== End Generated Certs ========

// Following parts are generated by command:
//
//   cat src/credentials/tests/certificates/keys | while read i; do
//     chip-cert convert-key src/credentials/tests/certificates/$i /tmp/certs/tmp.chip
//     base64 -d /tmp/certs/tmp.chip > /tmp/certs/$i
//     xxd -i /tmp/certs/$i
//     echo
//   done >> src/credentials/tests/CHIPCert_unit_test_vectors.cpp
//
// With minor edit

// ======== Begin Generated Keys ========
unsigned char UnitTest_RootA_pem[]  = { 0x04, 0x5b, 0xdd, 0x96, 0x58, 0x03, 0x5f, 0x6c, 0x26, 0x69, 0xe9, 0x27, 0xf0, 0xc1,
                                       0xab, 0xa0, 0x79, 0xd3, 0x23, 0x44, 0x83, 0xc1, 0x82, 0x39, 0x78, 0x4b, 0x1a, 0x0d,
                                       0x05, 0x7f, 0x62, 0xce, 0x72, 0x8c, 0xae, 0x3b, 0x9f, 0xef, 0x49, 0x18, 0xf0, 0xe8,
                                       0xe8, 0x3b, 0x6e, 0x98, 0x71, 0x81, 0x79, 0xb7, 0x8f, 0x66, 0x3a, 0x49, 0x0f, 0x7c,
                                       0x32, 0x0e, 0x5d, 0x8b, 0x7c, 0x76, 0x55, 0x6a, 0x2e, 0x88, 0x57, 0xb5, 0xf3, 0xa8,
                                       0xfa, 0xc4, 0x25, 0x86, 0x05, 0x18, 0x6c, 0xb7, 0xb7, 0xbf, 0x1f, 0x19, 0x06, 0x5d,
                                       0xd9, 0x65, 0x98, 0x65, 0xa7, 0x06, 0x0d, 0xeb, 0x94, 0xb5, 0x7b, 0x6d, 0xd5 };
unsigned int UnitTest_RootA_pem_len = 97;

unsigned char UnitTest_RootB_pem[]  = { 0x04, 0x66, 0x90, 0x7a, 0xd6, 0x68, 0xee, 0x8a, 0xc8, 0xbf, 0x9e, 0x98, 0xba, 0xdb,
                                       0x15, 0x47, 0x18, 0x4e, 0x82, 0x6e, 0x5a, 0x22, 0x41, 0x96, 0x27, 0xe8, 0x5f, 0xc7,
                                       0x47, 0xaf, 0x74, 0xe4, 0x47, 0x44, 0x46, 0x9a, 0x63, 0xed, 0x21, 0x5f, 0x66, 0x85,
                                       0x2d, 0x0d, 0xfc, 0x23, 0x07, 0x83, 0x74, 0x8c, 0x9e, 0x98, 0x80, 0xe5, 0xcc, 0xd9,
                                       0x79, 0xd0, 0x67, 0x27, 0xeb, 0x45, 0xb3, 0x81, 0x55, 0x93, 0xca, 0xfd, 0x1f, 0xac,
                                       0x51, 0x2f, 0xa8, 0x7c, 0xc5, 0x97, 0x42, 0xbb, 0x1f, 0x0f, 0xfa, 0xe1, 0xbf, 0xd4,
                                       0x49, 0xfd, 0xbc, 0xa8, 0x81, 0x44, 0x01, 0x4d, 0x4d, 0xed, 0x1e, 0x0d, 0x0d };
unsigned int UnitTest_RootB_pem_len = 97;

unsigned char UnitTest_IA_A1_pem[]  = { 0x04, 0x0b, 0x93, 0x13, 0x6f, 0xca, 0x1b, 0xc7, 0x38, 0x64, 0x5e, 0xc0, 0x80, 0x9e,
                                       0xaa, 0x07, 0xa7, 0x89, 0x99, 0x6b, 0x55, 0xfc, 0x65, 0xaa, 0xb1, 0x0c, 0x9f, 0xf9,
                                       0xa7, 0x6f, 0x07, 0x15, 0x78, 0xcf, 0x2f, 0xbd, 0xf4, 0xdc, 0x06, 0x82, 0xbb, 0x17,
                                       0xdb, 0xc9, 0x1e, 0x36, 0xa7, 0x2e, 0xa4, 0xc7, 0x44, 0xfe, 0xef, 0xf5, 0x34, 0xc3,
                                       0x44, 0x76, 0xda, 0xb4, 0xdb, 0xa2, 0xba, 0x03, 0xef, 0x57, 0x82, 0x57, 0x03, 0x46,
                                       0x65, 0x17, 0xa6, 0x97, 0xa7, 0x9e, 0x07, 0xb6, 0xe2, 0xdd, 0x74, 0xf5, 0x47, 0x02,
                                       0xb0, 0xb1, 0x9f, 0x5c, 0x38, 0x39, 0x9f, 0x7d, 0x45, 0xed, 0x21, 0xa2, 0x55 };
unsigned int UnitTest_IA_A1_pem_len = 97;

unsigned char UnitTest_IA_A2_pem[]  = { 0x04, 0x56, 0x42, 0x98, 0x5c, 0x75, 0x68, 0x8c, 0x7e, 0xc3, 0x39, 0x8b, 0xf4, 0x1f,
                                       0xce, 0xa4, 0xb9, 0x8a, 0x3e, 0xd0, 0xa5, 0x8d, 0x14, 0x95, 0xb8, 0xf5, 0x39, 0x57,
                                       0x6d, 0x8c, 0xae, 0x3b, 0x7f, 0xa3, 0xb5, 0x27, 0xa7, 0xb4, 0x67, 0xa3, 0xd9, 0xbf,
                                       0x32, 0xd0, 0xae, 0xd4, 0x91, 0x6b, 0x35, 0xc4, 0x40, 0x9e, 0x48, 0x55, 0x5c, 0xa1,
                                       0x82, 0x2c, 0xec, 0x79, 0xfe, 0x65, 0xf9, 0x89, 0xdc, 0xff, 0x33, 0x15, 0x8f, 0xfa,
                                       0x10, 0x35, 0x4b, 0xac, 0xcc, 0x5f, 0xc3, 0x3c, 0x85, 0x43, 0x70, 0x92, 0x2f, 0xb5,
                                       0xd8, 0xd9, 0xea, 0x06, 0x7b, 0xa3, 0x14, 0xe9, 0xba, 0xbb, 0x4b, 0xd1, 0x4a };
unsigned int UnitTest_IA_A2_pem_len = 97;

unsigned char UnitTest_IA_B1_pem[]  = { 0x04, 0x1e, 0x41, 0xba, 0xee, 0xbb, 0x08, 0x16, 0x58, 0xd4, 0x91, 0x78, 0x7c, 0x1b,
                                       0x1b, 0xea, 0x24, 0xb4, 0xc4, 0x14, 0x2f, 0x47, 0x86, 0xc3, 0x76, 0x13, 0xfb, 0xdb,
                                       0xdc, 0x1c, 0x65, 0xa9, 0xd0, 0xd2, 0x39, 0x7b, 0x2c, 0xa0, 0xa8, 0xfe, 0x2e, 0xee,
                                       0xcd, 0x35, 0xc0, 0xd6, 0x26, 0x9c, 0xc8, 0x34, 0x95, 0x44, 0xc8, 0xee, 0xf3, 0xe6,
                                       0x61, 0x39, 0xda, 0xc4, 0x84, 0x21, 0xbe, 0x1e, 0x89, 0xcd, 0x09, 0x80, 0x89, 0x25,
                                       0x72, 0x11, 0xfa, 0x6c, 0x5d, 0x81, 0x2c, 0xbc, 0x0e, 0xa7, 0x00, 0xa8, 0xb2, 0x40,
                                       0x56, 0x77, 0x97, 0xdc, 0xe5, 0xca, 0x56, 0xa2, 0xa4, 0x5a, 0x2b, 0xe6, 0xf3 };
unsigned int UnitTest_IA_B1_pem_len = 97;

unsigned char UnitTest_NodeA1_pem[]  = { 0x04, 0x38, 0x9b, 0x9e, 0xc4, 0x9e, 0x84, 0x48, 0xc0, 0x8f, 0x34, 0x14, 0x9c, 0x3e,
                                        0xa9, 0x47, 0xd1, 0x49, 0xe2, 0xbb, 0xf5, 0x93, 0x93, 0x47, 0x5f, 0xa9, 0x16, 0x71,
                                        0x3a, 0xc7, 0x81, 0xd2, 0x73, 0xf8, 0xb5, 0x29, 0xb2, 0x8f, 0xbe, 0xba, 0x1e, 0x3a,
                                        0x27, 0xd1, 0x42, 0x67, 0xd4, 0x0c, 0x5e, 0xa7, 0x25, 0x4b, 0x62, 0x57, 0x7d, 0x00,
                                        0x30, 0x30, 0x27, 0xd8, 0xa8, 0x4f, 0xa1, 0x11, 0xa0, 0xe7, 0x8e, 0xa5, 0x02, 0xbd,
                                        0xc4, 0x75, 0x3c, 0x0b, 0x87, 0x68, 0xd4, 0x3b, 0x68, 0x17, 0x40, 0xca, 0x29, 0xc4,
                                        0x41, 0x63, 0xaa, 0xb8, 0x3a, 0x26, 0xfa, 0xa3, 0xf1, 0x4a, 0x11, 0x30, 0xff };
unsigned int UnitTest_NodeA1_pem_len = 97;

unsigned char UnitTest_NodeA2_pem[]  = { 0x04, 0x5c, 0x1b, 0x09, 0xfc, 0x88, 0xf6, 0x2b, 0x91, 0xfa, 0xcb, 0x86, 0xef, 0x7d,
                                        0x79, 0x21, 0x09, 0x47, 0x06, 0xc9, 0xd9, 0x09, 0x8a, 0x2b, 0xa9, 0x39, 0x2b, 0xfc,
                                        0x2f, 0x57, 0x95, 0x96, 0xf2, 0xda, 0x1b, 0x79, 0x62, 0x52, 0xa9, 0xc6, 0xe4, 0x29,
                                        0xc6, 0x42, 0xe7, 0x21, 0xb4, 0x99, 0x24, 0x0f, 0x35, 0x04, 0xac, 0xcb, 0x84, 0x97,
                                        0x3a, 0xb7, 0xba, 0x80, 0xc9, 0xb8, 0x3f, 0x19, 0xc0, 0xfe, 0xd4, 0xd8, 0x1d, 0x30,
                                        0x3f, 0xb3, 0x04, 0x3a, 0xea, 0x3f, 0x8c, 0x80, 0xf8, 0x00, 0xb9, 0xd3, 0x60, 0x9f,
                                        0x22, 0x2f, 0xed, 0x19, 0xef, 0x82, 0x6b, 0x0d, 0xcd, 0xfa, 0x7d, 0x69, 0xe1 };
unsigned int UnitTest_NodeA2_pem_len = 97;

unsigned char UnitTest_NodeA3_pem[]  = { 0x04, 0xdc, 0x86, 0xdf, 0x41, 0xfd, 0x7f, 0x64, 0x7b, 0x06, 0xf4, 0xc1, 0xaf, 0x96,
                                        0x97, 0xe8, 0x51, 0x85, 0x5b, 0x33, 0x6a, 0xeb, 0x04, 0x2b, 0x38, 0xf0, 0x2b, 0xec,
                                        0x46, 0x19, 0x1a, 0x92, 0x7a, 0xe8, 0x56, 0xec, 0xb3, 0x1e, 0x94, 0x81, 0x2e, 0x88,
                                        0xf0, 0xc3, 0xff, 0x25, 0xa0, 0x05, 0xfd, 0xcf, 0x65, 0xf7, 0xc2, 0x45, 0xbd, 0x5d,
                                        0xdc, 0xc0, 0xa7, 0x6d, 0x32, 0xac, 0xc0, 0xf0, 0xe2, 0xae, 0x05, 0x75, 0x7b, 0x88,
                                        0xeb, 0x87, 0x3b, 0x60, 0x68, 0x85, 0x60, 0xa4, 0xf8, 0x8b, 0xd1, 0x1c, 0x83, 0xa7,
                                        0xb9, 0x16, 0x34, 0x0a, 0xc2, 0xb1, 0xf8, 0x6f, 0x9f, 0xd9, 0x81, 0x3f, 0x82 };
unsigned int UnitTest_NodeA3_pem_len = 97;

unsigned char UnitTest_NodeA4_pem[]  = { 0x04, 0xe3, 0x64, 0xa0, 0xf1, 0xb0, 0x00, 0xfd, 0xb1, 0x0b, 0x10, 0x0d, 0xd3, 0xd3,
                                        0xa6, 0x89, 0x10, 0xb6, 0x01, 0xa1, 0xcf, 0xe7, 0x5d, 0xa2, 0x3b, 0x70, 0xc8, 0xa0,
                                        0x06, 0xe2, 0xbb, 0x0e, 0x6e, 0x34, 0x36, 0x9e, 0xce, 0xa2, 0x30, 0xc0, 0x55, 0xa8,
                                        0xfa, 0x6b, 0x83, 0x9f, 0x79, 0x41, 0x82, 0xbf, 0x4a, 0x85, 0xaf, 0x74, 0x0f, 0xc7,
                                        0xd4, 0x56, 0xa7, 0xdd, 0x3e, 0xc8, 0xca, 0x80, 0x2b, 0xd9, 0x21, 0x3c, 0x75, 0xad,
                                        0x13, 0xc3, 0xf5, 0xb8, 0x91, 0xed, 0x02, 0x41, 0x73, 0xd0, 0x77, 0x93, 0xdc, 0xab,
                                        0x41, 0xa2, 0x26, 0x8d, 0x94, 0xd9, 0x0c, 0xe5, 0x65, 0x08, 0xea, 0xfb, 0xdf };
unsigned int UnitTest_NodeA4_pem_len = 97;

unsigned char UnitTest_NodeB1_pem[]  = { 0x04, 0xd9, 0xd1, 0x5c, 0x74, 0xa0, 0x9c, 0x12, 0xff, 0xbd, 0x20, 0x54, 0xe9, 0xba,
                                        0xe5, 0xda, 0xaf, 0x5e, 0xb8, 0x0e, 0xc9, 0xd9, 0x96, 0x86, 0xfa, 0xdc, 0xb3, 0xbe,
                                        0xe4, 0x42, 0xa1, 0x19, 0x7a, 0xa1, 0xbf, 0x08, 0xc4, 0x90, 0x62, 0xff, 0x80, 0x6c,
                                        0xb8, 0xd1, 0xf3, 0xba, 0x4d, 0xd6, 0xe5, 0xe4, 0x6b, 0xab, 0x3c, 0x9d, 0x27, 0x39,
                                        0x73, 0xf5, 0xf8, 0xaf, 0x4c, 0x27, 0x0c, 0xf8, 0xd8, 0xc9, 0xfa, 0x18, 0x2e, 0x62,
                                        0xb5, 0xd0, 0x0d, 0xbd, 0x79, 0x50, 0x94, 0x1f, 0x49, 0xfb, 0x67, 0xfd, 0x74, 0x1f,
                                        0xa1, 0x3b, 0x65, 0xb2, 0xac, 0x47, 0xd8, 0x5e, 0x6f, 0x0c, 0x56, 0xfb, 0x49 };
unsigned int UnitTest_NodeB1_pem_len = 97;

// ======== End Generated Keys ========

UnitTestCertAsset GetRootACertAsset()
{
    return { ByteSpan(UnitTest_RootA_crt, UnitTest_RootA_crt_len), ByteSpan(UnitTest_RootA_pem, UnitTest_RootA_pem_len) };
}
UnitTestCertAsset GetRootBCertAsset()
{
    return { ByteSpan(UnitTest_RootB_crt, UnitTest_RootB_crt_len), ByteSpan(UnitTest_RootB_pem, UnitTest_RootB_pem_len) };
}
UnitTestCertAsset GetIAA1CertAsset()
{
    return { ByteSpan(UnitTest_IA_A1_crt, UnitTest_IA_A1_crt_len), ByteSpan(UnitTest_IA_A1_pem, UnitTest_IA_A1_pem_len) };
}
UnitTestCertAsset GetIAA2CertAsset()
{
    return { ByteSpan(UnitTest_IA_A2_crt, UnitTest_IA_A2_crt_len), ByteSpan(UnitTest_IA_A2_pem, UnitTest_IA_A2_pem_len) };
}
UnitTestCertAsset GetIAB1CertAsset()
{
    return { ByteSpan(UnitTest_IA_B1_crt, UnitTest_IA_B1_crt_len), ByteSpan(UnitTest_IA_B1_pem, UnitTest_IA_B1_pem_len) };
}
UnitTestCertAsset GetNodeA1CertAsset()
{
    return { ByteSpan(UnitTest_NodeA1_crt, UnitTest_NodeA1_crt_len), ByteSpan(UnitTest_NodeA1_pem, UnitTest_NodeA1_pem_len) };
}
UnitTestCertAsset GetNodeA2CertAsset()
{
    return { ByteSpan(UnitTest_NodeA2_crt, UnitTest_NodeA2_crt_len), ByteSpan(UnitTest_NodeA2_pem, UnitTest_NodeA2_pem_len) };
}
UnitTestCertAsset GetNodeA3CertAsset()
{
    return { ByteSpan(UnitTest_NodeA3_crt, UnitTest_NodeA3_crt_len), ByteSpan(UnitTest_NodeA3_pem, UnitTest_NodeA3_pem_len) };
}
UnitTestCertAsset GetNodeA4CertAsset()
{
    return { ByteSpan(UnitTest_NodeA4_crt, UnitTest_NodeA4_crt_len), ByteSpan(UnitTest_NodeA4_pem, UnitTest_NodeA4_pem_len) };
}
UnitTestCertAsset GetNodeB1CertAsset()
{
    return { ByteSpan(UnitTest_NodeB1_crt, UnitTest_NodeB1_crt_len), ByteSpan(UnitTest_NodeB1_pem, UnitTest_NodeB1_pem_len) };
}

} // namespace TestCerts
} // namespace chip
