/*
 *
 *    Copyright (c) 2020 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * @file - This file contains field element multipication test vectors.
 */

#pragma once

namespace chip {
namespace Crypto {

struct spake2p_fe_mul_tv
{
    const uint8_t * fe1;
    size_t fe1_len;
    const uint8_t * fe2;
    size_t fe2_len;
    const uint8_t * fe_out;
    size_t fe_out_len;
};

static const uint8_t chiptest_63ed1e870cb3_fe1_1[]    = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static const uint8_t chiptest_63ed1e870cb3_fe2_2[]    = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_3[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_4 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_1,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_2,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_3,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_5[]    = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 };
static const uint8_t chiptest_63ed1e870cb3_fe2_6[]    = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_7[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                          0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_8 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_5,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_6,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_7,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_9[]     = { 0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                       0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static const uint8_t chiptest_63ed1e870cb3_fe2_10[]    = { 0x7f, 0xff, 0xff, 0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_11[] = { 0xe2, 0x94, 0x7c, 0xc6, 0xbc, 0x61, 0x74, 0x5b, 0x77, 0x01, 0x57,
                                                           0x46, 0x6f, 0x66, 0x5e, 0x81, 0x11, 0x5c, 0x92, 0x2e, 0x37, 0xbd,
                                                           0xa0, 0xce, 0x91, 0xc7, 0x74, 0xd3, 0x60, 0xcb, 0xa3, 0x7c };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_12 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_9,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_10,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_11,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_13[]    = { 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
                                                        0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
                                                        0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50 };
static const uint8_t chiptest_63ed1e870cb3_fe2_14[]    = { 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff,
                                                        0xff, 0xff, 0xff, 0xff, 0xff, 0xbc, 0xe6, 0xfa, 0xad, 0xa7, 0x17,
                                                        0x9e, 0x84, 0xf3, 0xb9, 0xca, 0xc2, 0xfc, 0x63, 0x25, 0x50 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_15[] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                           0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                                           0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_16 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_13,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_14,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_15,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_17[]    = { 0x2c, 0x5d, 0x31, 0x00, 0xbc, 0x77, 0x83, 0x34, 0x2c, 0x51, 0x49,
                                                        0x7a, 0x2e, 0x2c, 0x03, 0x78, 0x3c, 0x4e, 0x79, 0x93, 0x0f, 0x72,
                                                        0x2e, 0xcd, 0x5b, 0xda, 0xe8, 0x73, 0xea, 0x01, 0xf9, 0x82 };
static const uint8_t chiptest_63ed1e870cb3_fe2_18[]    = { 0x85, 0xe2, 0xc4, 0x91, 0xfa, 0x64, 0xb7, 0x76, 0x8c, 0x46, 0xd0,
                                                        0x1d, 0x1d, 0xe3, 0x1c, 0xb9, 0x84, 0xec, 0xaa, 0x6c, 0xd2, 0xda,
                                                        0xb0, 0x3a, 0xa3, 0x26, 0xd2, 0x54, 0x14, 0xfb, 0x42, 0x70 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_19[] = { 0xb7, 0x32, 0xf0, 0xdd, 0xcb, 0x47, 0xd4, 0x80, 0xda, 0xa5, 0x37,
                                                           0x3a, 0x78, 0xf4, 0x2e, 0x87, 0x40, 0x27, 0x3b, 0x40, 0xf6, 0x04,
                                                           0xc3, 0x7b, 0xa7, 0xb3, 0xb8, 0x62, 0x83, 0xa5, 0x65, 0xc5 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_20 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_17,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_18,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_19,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_21[]    = { 0x37, 0xe8, 0x33, 0xe4, 0x5a, 0x70, 0x08, 0x32, 0x01, 0xcd, 0xbb,
                                                        0xd1, 0x87, 0x4c, 0xfb, 0x83, 0x0b, 0xde, 0xe9, 0xa6, 0x09, 0xc7,
                                                        0x9a, 0x40, 0x73, 0x24, 0x78, 0xba, 0xd5, 0x0b, 0x52, 0x28 };
static const uint8_t chiptest_63ed1e870cb3_fe2_22[]    = { 0x68, 0x4a, 0xec, 0x67, 0x23, 0x0d, 0x8f, 0x92, 0x62, 0x9a, 0x18,
                                                        0x34, 0xa9, 0xce, 0x34, 0x15, 0xed, 0xe2, 0xb2, 0x35, 0xb8, 0xd9,
                                                        0xab, 0xbc, 0xee, 0x3c, 0xe1, 0x19, 0x9a, 0x2d, 0x13, 0xcc };
static const uint8_t chiptest_63ed1e870cb3_fe_out_23[] = { 0x5f, 0xf3, 0xcf, 0x72, 0xf1, 0x70, 0x67, 0xca, 0xde, 0xe7, 0x33,
                                                           0x7b, 0xe3, 0xed, 0x1b, 0xfd, 0x36, 0xbc, 0x22, 0x8f, 0xbd, 0x7a,
                                                           0x49, 0x36, 0xe8, 0x49, 0x3f, 0xb5, 0x16, 0x37, 0xd0, 0x4a };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_24 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_21,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_22,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_23,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_25[]    = { 0x42, 0x08, 0xff, 0x5f, 0x67, 0x45, 0xf8, 0x90, 0x94, 0xdc, 0x66,
                                                        0x28, 0xc4, 0xab, 0x2f, 0xe8, 0x2d, 0x64, 0x6e, 0x1c, 0xd8, 0x47,
                                                        0xa8, 0x14, 0x09, 0x6a, 0x8c, 0x72, 0x08, 0x8a, 0xf2, 0x7b };
static const uint8_t chiptest_63ed1e870cb3_fe2_26[]    = { 0x53, 0xa0, 0x7e, 0xe8, 0xc0, 0x21, 0xf4, 0x63, 0x68, 0x8a, 0xad,
                                                        0x18, 0xf2, 0x84, 0xe7, 0x67, 0xa4, 0xe8, 0x23, 0xf2, 0x08, 0x6c,
                                                        0x7d, 0x0c, 0x2d, 0xa6, 0xd6, 0x53, 0x24, 0xb0, 0x4f, 0xd3 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_27[] = { 0x1a, 0x90, 0x51, 0x21, 0x0e, 0x77, 0x68, 0x81, 0x7a, 0x4a, 0xa2,
                                                           0x80, 0x81, 0xd3, 0xdd, 0x76, 0xdd, 0x07, 0xeb, 0x0f, 0x77, 0xe9,
                                                           0xfb, 0x71, 0x5a, 0x45, 0x1f, 0x96, 0x74, 0x0a, 0xa7, 0x5b };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_28 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_25,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_26,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_27,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_29[]    = { 0x54, 0xe4, 0x9a, 0x4d, 0x59, 0xac, 0x55, 0xe9, 0xc5, 0x12, 0xe1,
                                                        0xd5, 0xb3, 0x29, 0x9b, 0x38, 0xa9, 0x13, 0x01, 0xaa, 0x24, 0x46,
                                                        0x98, 0x6c, 0xd2, 0xf0, 0x1b, 0x3e, 0xbc, 0xac, 0x2b, 0x1e };
static const uint8_t chiptest_63ed1e870cb3_fe2_30[]    = { 0x1c, 0xb4, 0xbf, 0x27, 0xeb, 0xdf, 0xa7, 0xf0, 0x5f, 0x61, 0x16,
                                                        0x18, 0xff, 0x9e, 0x51, 0x7e, 0xe2, 0x2d, 0xbe, 0xa7, 0xd5, 0xe3,
                                                        0x2c, 0x81, 0x90, 0x42, 0x11, 0x76, 0x46, 0x49, 0x78, 0x33 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_31[] = { 0xec, 0xe9, 0x8c, 0xa7, 0x29, 0xd7, 0x87, 0xbc, 0x8b, 0x94, 0x44,
                                                           0x90, 0xfc, 0x0e, 0x23, 0x8f, 0x65, 0xf2, 0x1c, 0xc8, 0x57, 0x52,
                                                           0xd8, 0x72, 0xfd, 0x53, 0xc3, 0x9a, 0xc2, 0x58, 0x86, 0x52 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_32 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_29,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_30,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_31,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_33[]    = { 0x3c, 0xb6, 0xba, 0xa6, 0x1f, 0x42, 0xd1, 0x89, 0xc7, 0x23, 0xa6,
                                                        0x27, 0x94, 0xfb, 0x4c, 0x11, 0x94, 0x8f, 0x58, 0xfe, 0xa2, 0x76,
                                                        0x05, 0xf7, 0x1a, 0xa9, 0x1e, 0x46, 0x23, 0xf7, 0x2a, 0x6e };
static const uint8_t chiptest_63ed1e870cb3_fe2_34[]    = { 0x39, 0xfe, 0xb2, 0xd8, 0x97, 0xca, 0x75, 0x1a, 0x3e, 0xc5, 0x85,
                                                        0x7d, 0x97, 0x02, 0xfd, 0x9a, 0xb0, 0xca, 0xba, 0xc1, 0x0f, 0x31,
                                                        0x0c, 0x4a, 0xcd, 0x4b, 0x95, 0xea, 0xc9, 0xf0, 0x32, 0x96 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_35[] = { 0x27, 0x2e, 0x40, 0x34, 0xa4, 0xf1, 0x35, 0xc8, 0x68, 0x1d, 0xbd,
                                                           0x12, 0x1e, 0x8d, 0x99, 0x96, 0xbb, 0x6d, 0x7e, 0x69, 0x55, 0x19,
                                                           0x35, 0x40, 0xea, 0xd7, 0x63, 0x01, 0x65, 0x92, 0xd4, 0x38 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_36 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_33,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_34,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_35,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_37[]    = { 0x1b, 0x87, 0x82, 0x85, 0xc7, 0xaa, 0x0b, 0xf5, 0xfc, 0xdb, 0xaa,
                                                        0x83, 0xa3, 0x66, 0x45, 0x9f, 0xab, 0x42, 0xa0, 0x7d, 0xb1, 0x61,
                                                        0x38, 0xfb, 0xc9, 0xa2, 0x49, 0xf5, 0x9f, 0xed, 0x09, 0xce };
static const uint8_t chiptest_63ed1e870cb3_fe2_38[]    = { 0x22, 0xe2, 0x3e, 0x7a, 0xed, 0x50, 0x28, 0x7d, 0x98, 0x0b, 0x07,
                                                        0x4f, 0xbf, 0x75, 0x8c, 0x21, 0x0c, 0x36, 0xff, 0x7f, 0xcd, 0x02,
                                                        0x09, 0x0d, 0x08, 0x6f, 0x2e, 0x63, 0x35, 0x57, 0x08, 0x4a };
static const uint8_t chiptest_63ed1e870cb3_fe_out_39[] = { 0xf6, 0x47, 0x28, 0x05, 0xb0, 0x98, 0x49, 0x88, 0x00, 0xfe, 0x0e,
                                                           0x45, 0xdd, 0x27, 0x18, 0x47, 0xd6, 0x0e, 0x39, 0x8f, 0xd8, 0x3b,
                                                           0xb2, 0x72, 0xfb, 0x20, 0xe9, 0x61, 0x67, 0x29, 0xc9, 0xb5 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_40 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_37,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_38,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_39,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_41[]    = { 0x65, 0x44, 0x2d, 0x0e, 0xa5, 0x52, 0xf6, 0x07, 0x84, 0xf5, 0x08,
                                                        0x33, 0x23, 0x38, 0x12, 0xe0, 0x8c, 0xfa, 0xef, 0xc2, 0x6e, 0xb2,
                                                        0x51, 0x37, 0xf9, 0x1f, 0x36, 0x63, 0x0d, 0x85, 0xcb, 0x08 };
static const uint8_t chiptest_63ed1e870cb3_fe2_42[]    = { 0x89, 0xe5, 0xf9, 0xa2, 0xba, 0xef, 0xcc, 0xc1, 0x01, 0xb3, 0xb4,
                                                        0x81, 0xac, 0xd1, 0x3e, 0xb8, 0x3e, 0xf9, 0x01, 0x47, 0xe7, 0x25,
                                                        0x48, 0xe0, 0x08, 0xea, 0xdb, 0xce, 0xaa, 0x72, 0x2a, 0xaa };
static const uint8_t chiptest_63ed1e870cb3_fe_out_43[] = { 0x89, 0x37, 0xd9, 0xe2, 0x2b, 0x5d, 0xb3, 0x11, 0xca, 0xa9, 0xee,
                                                           0xcb, 0x51, 0x69, 0xf6, 0x38, 0x3f, 0x57, 0xaa, 0x36, 0x9a, 0x1a,
                                                           0x04, 0x4f, 0x4d, 0x33, 0x0d, 0x87, 0xb0, 0x1f, 0x56, 0x9f };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_44 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_41,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_42,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_43,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_45[]    = { 0xfa, 0xa7, 0xb9, 0x68, 0x14, 0xf3, 0x0d, 0xbe, 0x37, 0x79, 0x67,
                                                        0xc9, 0xa4, 0x0b, 0xb6, 0xe3, 0x0f, 0x01, 0x3d, 0x05, 0xdb, 0x73,
                                                        0xc7, 0x84, 0x52, 0x0e, 0x0b, 0xef, 0x3a, 0x79, 0xa8, 0x0f };
static const uint8_t chiptest_63ed1e870cb3_fe2_46[]    = { 0xf3, 0x1b, 0xbe, 0x73, 0xef, 0x62, 0xb3, 0xcd, 0x4e, 0x06, 0xc5,
                                                        0x9b, 0x50, 0x1c, 0x7d, 0x5f, 0x26, 0x9e, 0xc1, 0x02, 0x85, 0x37,
                                                        0x1b, 0x96, 0xcf, 0x3b, 0x16, 0xdf, 0x25, 0x76, 0x71, 0xe4 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_47[] = { 0x76, 0xbb, 0x90, 0xd9, 0xb4, 0xaa, 0x1f, 0xd0, 0x64, 0xb2, 0x10,
                                                           0x75, 0x71, 0x84, 0x2b, 0x1e, 0xac, 0x90, 0x10, 0x7e, 0x08, 0xee,
                                                           0xda, 0xee, 0x3a, 0x27, 0xc4, 0x43, 0x2a, 0x51, 0x5f, 0xd9 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_48 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_45,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_46,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_47,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_49[]    = { 0x93, 0xb1, 0x9f, 0xa2, 0x81, 0xce, 0x8e, 0xc6, 0x26, 0x30, 0x83,
                                                        0x8a, 0xd9, 0x32, 0xf1, 0x99, 0x49, 0xc2, 0xc5, 0xdb, 0x50, 0xbf,
                                                        0x82, 0x11, 0x38, 0xce, 0x40, 0xc9, 0x3e, 0x85, 0xd3, 0xc9 };
static const uint8_t chiptest_63ed1e870cb3_fe2_50[]    = { 0x5b, 0xbb, 0x9f, 0x3f, 0x4f, 0x44, 0xd0, 0x72, 0x0f, 0x3a, 0xa9,
                                                        0x4e, 0xd9, 0xaf, 0x1c, 0xe4, 0xf5, 0x7c, 0xce, 0x2e, 0x53, 0x34,
                                                        0xe2, 0x46, 0xcd, 0x5e, 0x14, 0x07, 0x11, 0x62, 0x70, 0xc8 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_51[] = { 0xb0, 0xce, 0x57, 0x4c, 0x66, 0x7e, 0x57, 0x52, 0x10, 0xde, 0x4f,
                                                           0xdb, 0x6c, 0xa9, 0x4a, 0x8d, 0x53, 0x32, 0xbd, 0xcb, 0x9e, 0xd6,
                                                           0x54, 0x97, 0x7d, 0x70, 0xbe, 0x22, 0x42, 0x1a, 0xb1, 0x47 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_52 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_49,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_50,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_51,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_53[]    = { 0xc3, 0x18, 0x0a, 0x9f, 0x58, 0x69, 0x86, 0x34, 0xe3, 0x11, 0x26,
                                                        0x9d, 0xa9, 0x2e, 0xf1, 0xee, 0x88, 0xf4, 0xac, 0x98, 0xc9, 0x68,
                                                        0x43, 0xbc, 0x4d, 0x83, 0x4e, 0x97, 0x0e, 0x04, 0x21, 0x2e };
static const uint8_t chiptest_63ed1e870cb3_fe2_54[]    = { 0xdd, 0x43, 0x95, 0xd5, 0x93, 0x22, 0x26, 0x81, 0x85, 0xc6, 0x0f,
                                                        0x7a, 0x0e, 0x78, 0x2c, 0x3f, 0xad, 0x53, 0x5a, 0x4b, 0x1c, 0x83,
                                                        0x52, 0x84, 0x24, 0x52, 0xdb, 0x0a, 0xe5, 0xee, 0xd0, 0xe6 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_55[] = { 0x3a, 0xa9, 0xa5, 0x34, 0xbc, 0x75, 0x38, 0xcc, 0x5b, 0x55, 0x2e,
                                                           0xaa, 0x61, 0x1c, 0x2a, 0x42, 0x77, 0x27, 0x95, 0x67, 0xe0, 0xf6,
                                                           0x70, 0x1b, 0x39, 0x9c, 0xe0, 0xf7, 0xe9, 0x9b, 0x6c, 0xec };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_56 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_53,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_54,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_55,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_57[]    = { 0xe1, 0xba, 0x1d, 0x51, 0x18, 0xe4, 0xd0, 0x43, 0x89, 0xca, 0xa5,
                                                        0xf7, 0x05, 0xd3, 0x55, 0x95, 0x49, 0xf5, 0xa4, 0x0e, 0x25, 0x8d,
                                                        0x3a, 0xc5, 0x8b, 0x11, 0xe7, 0xc4, 0x09, 0x5b, 0x21, 0x18 };
static const uint8_t chiptest_63ed1e870cb3_fe2_58[]    = { 0xde, 0x34, 0xd2, 0x7c, 0x0b, 0x4c, 0xf6, 0x7a, 0x16, 0xe1, 0x65,
                                                        0x38, 0xe5, 0xfd, 0xf8, 0xe7, 0xc3, 0x9f, 0x91, 0x5c, 0xa2, 0x31,
                                                        0x6e, 0xbf, 0xb9, 0x50, 0xf7, 0x60, 0x06, 0x06, 0xd5, 0xa8 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_59[] = { 0x36, 0xe9, 0xee, 0x98, 0x94, 0x92, 0xba, 0xe5, 0x08, 0xa9, 0xd4,
                                                           0xe4, 0x6c, 0xa2, 0x78, 0xd9, 0x80, 0xd6, 0xa8, 0xaa, 0x69, 0xa6,
                                                           0x14, 0x53, 0xf2, 0x74, 0x0e, 0xc6, 0x96, 0xc1, 0xef, 0x3b };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_60 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_57,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_58,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_59,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_61[]    = { 0xda, 0xe5, 0xdf, 0x2e, 0x15, 0xca, 0xd1, 0xa1, 0x32, 0xd2, 0xa1,
                                                        0xce, 0xb7, 0x58, 0x5f, 0xe6, 0x7c, 0x7a, 0xce, 0xf6, 0xb2, 0x64,
                                                        0x6a, 0x44, 0x81, 0x1a, 0x04, 0xcd, 0xcd, 0x05, 0x6a, 0xe2 };
static const uint8_t chiptest_63ed1e870cb3_fe2_62[]    = { 0xcb, 0xa3, 0xfd, 0x43, 0xdc, 0xc3, 0xca, 0x49, 0x48, 0xc0, 0x2b,
                                                        0x3b, 0xf7, 0x97, 0xb5, 0x50, 0xe7, 0xbb, 0x89, 0xa4, 0x7a, 0xa5,
                                                        0x78, 0x0b, 0xad, 0x25, 0x19, 0xfd, 0x7e, 0x63, 0xca, 0x53 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_63[] = { 0x6c, 0x77, 0xed, 0xe2, 0x2e, 0x73, 0xd2, 0x1a, 0x7c, 0x71, 0x3d,
                                                           0x02, 0xae, 0x3f, 0x75, 0xec, 0xfc, 0xee, 0xeb, 0x2b, 0x0f, 0x9e,
                                                           0x1e, 0x16, 0x08, 0x28, 0x7d, 0x3e, 0xa2, 0x1d, 0xa6, 0xdf };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_64 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_61,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_62,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_63,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_65[]    = { 0x73, 0x6c, 0x42, 0x51, 0x4e, 0x9c, 0xe4, 0x9b, 0x42, 0x8f, 0xbf,
                                                        0x3a, 0x37, 0x0a, 0xf9, 0xf9, 0xac, 0x90, 0xf6, 0x60, 0x5c, 0x14,
                                                        0x2e, 0xd1, 0x52, 0xcf, 0xb4, 0x60, 0x6e, 0x16, 0x49, 0xb7 };
static const uint8_t chiptest_63ed1e870cb3_fe2_66[]    = { 0x42, 0xbc, 0x61, 0xb7, 0xd4, 0x28, 0x3f, 0xfe, 0x2c, 0x5d, 0x3f,
                                                        0xb9, 0x02, 0x20, 0x4b, 0x1f, 0xde, 0x79, 0xe5, 0x27, 0x6e, 0x77,
                                                        0xf6, 0x56, 0xa4, 0xff, 0xcf, 0xed, 0xb9, 0x3e, 0x09, 0x98 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_67[] = { 0x24, 0x8b, 0xc5, 0xe4, 0x35, 0x77, 0x15, 0xa2, 0xfe, 0xf7, 0xa2,
                                                           0xf6, 0xca, 0x86, 0x6f, 0x2b, 0xf6, 0xc7, 0xa9, 0xfd, 0xaf, 0xb4,
                                                           0x87, 0x25, 0xd7, 0x6a, 0x84, 0x96, 0xc3, 0xe2, 0x10, 0x15 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_68 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_65,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_66,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_67,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_69[]    = { 0x69, 0xc6, 0x0f, 0x22, 0xb6, 0xc6, 0x78, 0x84, 0xed, 0x83, 0xdb,
                                                        0x44, 0x0d, 0x33, 0xbf, 0xb4, 0x11, 0x43, 0x69, 0x1c, 0xb3, 0x7c,
                                                        0xec, 0xa9, 0x21, 0xb3, 0xd8, 0xda, 0x3a, 0x7c, 0x15, 0x62 };
static const uint8_t chiptest_63ed1e870cb3_fe2_70[]    = { 0xe2, 0x22, 0x9d, 0xf1, 0x9d, 0xd3, 0x40, 0x0d, 0x10, 0x81, 0x48,
                                                        0x14, 0x71, 0xd8, 0x67, 0x6b, 0xa6, 0xc2, 0x4b, 0x95, 0xc4, 0x64,
                                                        0x53, 0xe8, 0xae, 0xda, 0xe6, 0x83, 0x9c, 0xd3, 0x58, 0x82 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_71[] = { 0x57, 0x53, 0x9a, 0x54, 0x2c, 0xff, 0xb5, 0xa7, 0x88, 0x57, 0x2b,
                                                           0xb3, 0xa2, 0x4b, 0x71, 0x61, 0xd7, 0x1a, 0xfa, 0x28, 0xb9, 0xe6,
                                                           0x33, 0xba, 0x3b, 0x87, 0x0e, 0x78, 0x35, 0xf9, 0xe9, 0x11 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_72 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_69,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_70,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_71,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_73[]    = { 0xfd, 0x1b, 0x88, 0x12, 0x2e, 0x0e, 0xbd, 0xbf, 0xd3, 0x78, 0xd9,
                                                        0xa1, 0xe6, 0x31, 0x70, 0xa8, 0xb7, 0xc3, 0x44, 0x3c, 0x42, 0x83,
                                                        0xba, 0xaa, 0x68, 0x38, 0xc5, 0x69, 0x2f, 0x96, 0xf3, 0xad };
static const uint8_t chiptest_63ed1e870cb3_fe2_74[]    = { 0x06, 0xf2, 0x1a, 0x57, 0x92, 0xd9, 0x6f, 0x10, 0x87, 0x05, 0xcd,
                                                        0x9b, 0x75, 0x6b, 0x70, 0x73, 0x88, 0x7d, 0x3f, 0x03, 0x70, 0x7e,
                                                        0x9f, 0x21, 0x98, 0xd8, 0x56, 0xcd, 0x1b, 0xdc, 0x94, 0x1a };
static const uint8_t chiptest_63ed1e870cb3_fe_out_75[] = { 0x34, 0x23, 0x70, 0x5f, 0xac, 0x64, 0xb9, 0x65, 0xb7, 0x1c, 0x70,
                                                           0xb1, 0x16, 0x4b, 0x8e, 0x1a, 0x97, 0x30, 0x91, 0xef, 0xb7, 0x49,
                                                           0x08, 0xb8, 0xe2, 0x64, 0x94, 0x79, 0x84, 0x3d, 0xad, 0x99 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_76 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_73,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_74,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_75,
    .fe_out_len = 32,
};
static const uint8_t chiptest_63ed1e870cb3_fe1_77[]    = { 0x26, 0x57, 0x4a, 0x69, 0x77, 0x9a, 0x55, 0xc5, 0x8c, 0x3e, 0xe9,
                                                        0x37, 0x6c, 0x3c, 0x26, 0x75, 0x78, 0x00, 0x91, 0x62, 0xba, 0x2f,
                                                        0x76, 0x75, 0x40, 0x79, 0x89, 0x7f, 0x27, 0x65, 0xb7, 0xe0 };
static const uint8_t chiptest_63ed1e870cb3_fe2_78[]    = { 0x79, 0x1a, 0x58, 0x65, 0x3a, 0x33, 0x22, 0xae, 0xc1, 0x4b, 0xfa,
                                                        0x69, 0x61, 0x79, 0x3f, 0xb1, 0x90, 0x32, 0x46, 0x84, 0xc5, 0x1d,
                                                        0x00, 0x16, 0x19, 0x89, 0x44, 0x4a, 0x51, 0xee, 0xbd, 0xe4 };
static const uint8_t chiptest_63ed1e870cb3_fe_out_79[] = { 0xcb, 0x33, 0x20, 0x59, 0x46, 0x96, 0xf5, 0xf3, 0xd3, 0xc9, 0x71,
                                                           0x95, 0x38, 0x45, 0xcd, 0x57, 0xec, 0x61, 0x42, 0xc3, 0xbf, 0xff,
                                                           0x19, 0x19, 0xd1, 0xf5, 0x2f, 0xed, 0x77, 0x99, 0x4c, 0xa2 };
static const struct spake2p_fe_mul_tv chiptest_63ed1e870cb3_test_vector_80 = {
    .fe1        = chiptest_63ed1e870cb3_fe1_77,
    .fe1_len    = 32,
    .fe2        = chiptest_63ed1e870cb3_fe2_78,
    .fe2_len    = 32,
    .fe_out     = chiptest_63ed1e870cb3_fe_out_79,
    .fe_out_len = 32,
};
static const struct spake2p_fe_mul_tv * fe_mul_tvs[] = {
    &chiptest_63ed1e870cb3_test_vector_4,  &chiptest_63ed1e870cb3_test_vector_8,  &chiptest_63ed1e870cb3_test_vector_12,
    &chiptest_63ed1e870cb3_test_vector_16, &chiptest_63ed1e870cb3_test_vector_20, &chiptest_63ed1e870cb3_test_vector_24,
    &chiptest_63ed1e870cb3_test_vector_28, &chiptest_63ed1e870cb3_test_vector_32, &chiptest_63ed1e870cb3_test_vector_36,
    &chiptest_63ed1e870cb3_test_vector_40, &chiptest_63ed1e870cb3_test_vector_44, &chiptest_63ed1e870cb3_test_vector_48,
    &chiptest_63ed1e870cb3_test_vector_52, &chiptest_63ed1e870cb3_test_vector_56, &chiptest_63ed1e870cb3_test_vector_60,
    &chiptest_63ed1e870cb3_test_vector_64, &chiptest_63ed1e870cb3_test_vector_68, &chiptest_63ed1e870cb3_test_vector_72,
    &chiptest_63ed1e870cb3_test_vector_76, &chiptest_63ed1e870cb3_test_vector_80
};

} // namespace Crypto
} // namespace chip
