/*
 *
 *    Copyright (c) 2020 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 * @file - This file contains SPAKE2P HMAC test vectors.
 */

#pragma once

namespace chip {
namespace Crypto {

struct spake2p_hmac_tv
{
    const uint8_t * key;
    size_t key_len;
    const uint8_t * input;
    size_t input_len;
    const uint8_t * output;
    size_t output_len;
};

static const uint8_t chiptest_be68c22260b3_key_1[]    = { 0x28, 0xd7, 0x74, 0x50, 0xc1, 0xc6, 0x64, 0x3b, 0xcc, 0x72, 0xb6,
                                                       0xf0, 0x03, 0xf2, 0x7b, 0x92, 0x37, 0x16, 0xde, 0x1c, 0x9b, 0x38,
                                                       0x1f, 0x1f, 0xee, 0xf7, 0x08, 0xb8, 0x55, 0xa0, 0x2d, 0xbe };
static const uint8_t chiptest_be68c22260b3_input_2[]  = { 0xdd };
static const uint8_t chiptest_be68c22260b3_output_3[] = { 0x87, 0x0b, 0xf5, 0xd9, 0x95, 0x46, 0x0b, 0x9b, 0x69, 0xfa, 0xe8,
                                                          0x73, 0x89, 0xb9, 0x31, 0xb9, 0xe0, 0x97, 0x2a, 0xf8, 0xe1, 0x38,
                                                          0x9e, 0x9a, 0x64, 0xe4, 0x2a, 0xca, 0x7e, 0xaf, 0xdc, 0x5d };
static const struct spake2p_hmac_tv chiptest_be68c22260b3_test_vector_4 = {
    .key        = chiptest_be68c22260b3_key_1,
    .key_len    = 32,
    .input      = chiptest_be68c22260b3_input_2,
    .input_len  = 1,
    .output     = chiptest_be68c22260b3_output_3,
    .output_len = 32,
};
static const uint8_t chiptest_be68c22260b3_key_5[]    = { 0x28, 0xd7, 0x74, 0x50, 0xc1, 0xc6, 0x64, 0x3b, 0xcc, 0x72, 0xb6,
                                                       0xf0, 0x03, 0xf2, 0x7b, 0x92, 0x37, 0x16, 0xde, 0x1c, 0x9b, 0x38,
                                                       0x1f, 0x1f, 0xee, 0xf7, 0x08, 0xb8, 0x55, 0xa0, 0x2d, 0xbe };
static const uint8_t chiptest_be68c22260b3_input_6[]  = { 0x84, 0xb7, 0xf1, 0xda, 0xca, 0x02, 0x91, 0x56, 0xea, 0x47, 0xda, 0x9b };
static const uint8_t chiptest_be68c22260b3_output_7[] = { 0x56, 0x0c, 0x73, 0x79, 0x45, 0xff, 0x4a, 0x10, 0x28, 0x62, 0x9e,
                                                          0xa3, 0x45, 0xda, 0xec, 0x57, 0x8d, 0x2e, 0xc3, 0xa7, 0x14, 0x63,
                                                          0x64, 0xfa, 0x26, 0x9a, 0x14, 0xad, 0x04, 0x4c, 0x1c, 0xaa };
static const struct spake2p_hmac_tv chiptest_be68c22260b3_test_vector_8 = {
    .key        = chiptest_be68c22260b3_key_5,
    .key_len    = 32,
    .input      = chiptest_be68c22260b3_input_6,
    .input_len  = 12,
    .output     = chiptest_be68c22260b3_output_7,
    .output_len = 32,
};
static const uint8_t chiptest_be68c22260b3_key_9[]     = { 0x28, 0xd7, 0x74, 0x50, 0xc1, 0xc6, 0x64, 0x3b, 0xcc, 0x72, 0xb6,
                                                       0xf0, 0x03, 0xf2, 0x7b, 0x92, 0x37, 0x16, 0xde, 0x1c, 0x9b, 0x38,
                                                       0x1f, 0x1f, 0xee, 0xf7, 0x08, 0xb8, 0x55, 0xa0, 0x2d, 0xbe };
static const uint8_t chiptest_be68c22260b3_input_10[]  = { 0xe0, 0x82, 0x91, 0xf0, 0x39, 0xe4, 0x78, 0xc3, 0xdf, 0xb2, 0x82,
                                                          0xb6, 0x99, 0x3b, 0xae, 0x80, 0x1f, 0xa0, 0xd3, 0xd0, 0xb0, 0x39,
                                                          0x20, 0xb6, 0x3e, 0x17, 0xeb, 0x1e, 0xbb, 0x55, 0x0b, 0x64 };
static const uint8_t chiptest_be68c22260b3_output_11[] = { 0xf2, 0x93, 0x0f, 0xcc, 0x89, 0x78, 0xa4, 0x93, 0xc7, 0x79, 0xd4,
                                                           0x1f, 0x7e, 0xb9, 0x6d, 0x50, 0xfe, 0xa3, 0x5b, 0x3f, 0x36, 0xf3,
                                                           0xed, 0x04, 0x80, 0x98, 0x51, 0x37, 0x4b, 0xdf, 0xa3, 0x86 };
static const struct spake2p_hmac_tv chiptest_be68c22260b3_test_vector_12 = {
    .key        = chiptest_be68c22260b3_key_9,
    .key_len    = 32,
    .input      = chiptest_be68c22260b3_input_10,
    .input_len  = 32,
    .output     = chiptest_be68c22260b3_output_11,
    .output_len = 32,
};
static const uint8_t chiptest_be68c22260b3_key_13[]    = { 0x28, 0xd7, 0x74, 0x50, 0xc1, 0xc6, 0x64, 0x3b, 0xcc, 0x72, 0xb6,
                                                        0xf0, 0x03, 0xf2, 0x7b, 0x92, 0x37, 0x16, 0xde, 0x1c, 0x9b, 0x38,
                                                        0x1f, 0x1f, 0xee, 0xf7, 0x08, 0xb8, 0x55, 0xa0, 0x2d, 0xbe };
static const uint8_t chiptest_be68c22260b3_input_14[]  = { 0x2a, 0xc0, 0xae, 0x52, 0xdf, 0x1c, 0x83, 0x0a, 0x95, 0x59, 0x7a,
                                                          0x43, 0xd5, 0xa6, 0xed, 0x1a, 0x46, 0x4d, 0xf6, 0x96, 0x4d, 0x28,
                                                          0x12, 0x2f, 0x98, 0x16, 0x9e, 0xb4, 0x92, 0x0b, 0x8e, 0x56, 0x50,
                                                          0x31, 0x09, 0x74, 0xa0, 0x23, 0x8f, 0x0e, 0x5d, 0x80, 0x7e, 0x91,
                                                          0x8d, 0x9e, 0x4c, 0x89, 0x00, 0x17, 0x0f, 0x95, 0x59, 0x81, 0x5d,
                                                          0x06, 0x1d, 0x71, 0xbf, 0xb7, 0xc6, 0x1d, 0x2c, 0x0d };
static const uint8_t chiptest_be68c22260b3_output_15[] = { 0x97, 0xac, 0x84, 0xe7, 0x3a, 0x68, 0x94, 0xa7, 0x25, 0xb1, 0x11,
                                                           0x92, 0x69, 0x15, 0x95, 0x5a, 0xf8, 0xf6, 0x16, 0xc2, 0xc7, 0xe3,
                                                           0x7c, 0xd8, 0xaf, 0x2c, 0x27, 0x23, 0x9a, 0x33, 0x6f, 0xc4 };
static const struct spake2p_hmac_tv chiptest_be68c22260b3_test_vector_16 = {
    .key        = chiptest_be68c22260b3_key_13,
    .key_len    = 32,
    .input      = chiptest_be68c22260b3_input_14,
    .input_len  = 64,
    .output     = chiptest_be68c22260b3_output_15,
    .output_len = 32,
};
static const uint8_t chiptest_be68c22260b3_key_17[]   = { 0x28, 0xd7, 0x74, 0x50, 0xc1, 0xc6, 0x64, 0x3b, 0xcc, 0x72, 0xb6,
                                                        0xf0, 0x03, 0xf2, 0x7b, 0x92, 0x37, 0x16, 0xde, 0x1c, 0x9b, 0x38,
                                                        0x1f, 0x1f, 0xee, 0xf7, 0x08, 0xb8, 0x55, 0xa0, 0x2d, 0xbe };
static const uint8_t chiptest_be68c22260b3_input_18[] = {
    0x77, 0xf0, 0xd4, 0x66, 0xdb, 0x6e, 0x39, 0x13, 0x60, 0x59, 0xc3, 0xdc, 0x10, 0x6e, 0x3f, 0x1d, 0x79, 0x86, 0xb3,
    0x66, 0xbd, 0x63, 0x0b, 0xdd, 0x65, 0xf3, 0x68, 0x09, 0x27, 0x9d, 0x70, 0x79, 0x90, 0x96, 0xd2, 0x34, 0xbf, 0x86,
    0x21, 0x56, 0x1b, 0x85, 0xce, 0x8c, 0x64, 0xe6, 0x4a, 0x6e, 0x53, 0x6b, 0x84, 0x67, 0x6e, 0xc8, 0x65, 0xc1, 0x2f,
    0x27, 0xcf, 0xeb, 0xd8, 0x5f, 0xb3, 0x29, 0x22, 0x64, 0xc1, 0x35, 0x09, 0x0e, 0x40, 0x49, 0x6c, 0x94, 0xad, 0xd2,
    0x10, 0x3c, 0x49, 0x2b, 0x0c, 0x11, 0x11, 0x82, 0xc3, 0x3c, 0xa2, 0xb7, 0xad, 0x54, 0x16, 0x9b, 0x53, 0xc5, 0xb9,
    0x79, 0xb6, 0xf3, 0xa6, 0xc2, 0x10, 0xf9, 0xc6, 0xec, 0x19, 0xe1, 0x5e, 0x2d, 0x8e, 0x7f, 0xff, 0x51, 0x32, 0x65,
    0x11, 0x1a, 0xc7, 0x64, 0xd1, 0xcc, 0x7a, 0x22, 0x70, 0x70, 0xe0, 0x5c, 0x80, 0x79
};
static const uint8_t chiptest_be68c22260b3_output_19[] = { 0x15, 0x43, 0xb3, 0x80, 0x61, 0xde, 0x82, 0x82, 0x7a, 0x7d, 0x02,
                                                           0xb6, 0x50, 0xae, 0xb6, 0xf8, 0x3f, 0x18, 0xf3, 0xec, 0x67, 0x0a,
                                                           0x6e, 0xcd, 0x8d, 0x04, 0xe1, 0xb1, 0xd0, 0x89, 0xae, 0x66 };
static const struct spake2p_hmac_tv chiptest_be68c22260b3_test_vector_20 = {
    .key        = chiptest_be68c22260b3_key_17,
    .key_len    = 32,
    .input      = chiptest_be68c22260b3_input_18,
    .input_len  = 128,
    .output     = chiptest_be68c22260b3_output_19,
    .output_len = 32,
};
static const struct spake2p_hmac_tv * hmac_tvs[] = { &chiptest_be68c22260b3_test_vector_4, &chiptest_be68c22260b3_test_vector_8,
                                                     &chiptest_be68c22260b3_test_vector_12, &chiptest_be68c22260b3_test_vector_16,
                                                     &chiptest_be68c22260b3_test_vector_20 };

} // namespace Crypto
} // namespace chip
