/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

#import "MTRCallbackBridgeBase.h"
#import <Foundation/Foundation.h>

#include <app-common/zap-generated/cluster-objects.h>
#include <app/data-model/DecodableList.h>
#include <app/util/im-client-callbacks.h>

typedef void (*CommandSuccessCallback)(void *, const chip::app::DataModel::NullObjectType &);
using CommandSuccessCallbackType = CommandSuccessCallback;
typedef void (*DefaultSuccessCallbackType)(void *);

typedef void (*VendorIdAttributeCallback)(void *, chip::VendorId);
typedef void (*NullableVendorIdAttributeCallback)(void *, const chip::app::DataModel::Nullable<chip::VendorId> &);

typedef void (*GroupsClusterAddGroupResponseCallbackType)(
    void *, const chip::app::Clusters::Groups::Commands::AddGroupResponse::DecodableType &);
typedef void (*GroupsClusterViewGroupResponseCallbackType)(
    void *, const chip::app::Clusters::Groups::Commands::ViewGroupResponse::DecodableType &);
typedef void (*GroupsClusterGetGroupMembershipResponseCallbackType)(
    void *, const chip::app::Clusters::Groups::Commands::GetGroupMembershipResponse::DecodableType &);
typedef void (*GroupsClusterRemoveGroupResponseCallbackType)(
    void *, const chip::app::Clusters::Groups::Commands::RemoveGroupResponse::DecodableType &);
typedef void (*ScenesClusterAddSceneResponseCallbackType)(
    void *, const chip::app::Clusters::Scenes::Commands::AddSceneResponse::DecodableType &);
typedef void (*ScenesClusterViewSceneResponseCallbackType)(
    void *, const chip::app::Clusters::Scenes::Commands::ViewSceneResponse::DecodableType &);
typedef void (*ScenesClusterRemoveSceneResponseCallbackType)(
    void *, const chip::app::Clusters::Scenes::Commands::RemoveSceneResponse::DecodableType &);
typedef void (*ScenesClusterRemoveAllScenesResponseCallbackType)(
    void *, const chip::app::Clusters::Scenes::Commands::RemoveAllScenesResponse::DecodableType &);
typedef void (*ScenesClusterStoreSceneResponseCallbackType)(
    void *, const chip::app::Clusters::Scenes::Commands::StoreSceneResponse::DecodableType &);
typedef void (*ScenesClusterGetSceneMembershipResponseCallbackType)(
    void *, const chip::app::Clusters::Scenes::Commands::GetSceneMembershipResponse::DecodableType &);
typedef void (*ScenesClusterEnhancedAddSceneResponseCallbackType)(
    void *, const chip::app::Clusters::Scenes::Commands::EnhancedAddSceneResponse::DecodableType &);
typedef void (*ScenesClusterEnhancedViewSceneResponseCallbackType)(
    void *, const chip::app::Clusters::Scenes::Commands::EnhancedViewSceneResponse::DecodableType &);
typedef void (*ScenesClusterCopySceneResponseCallbackType)(
    void *, const chip::app::Clusters::Scenes::Commands::CopySceneResponse::DecodableType &);
typedef void (*OTASoftwareUpdateProviderClusterQueryImageResponseCallbackType)(
    void *, const chip::app::Clusters::OtaSoftwareUpdateProvider::Commands::QueryImageResponse::DecodableType &);
typedef void (*OTASoftwareUpdateProviderClusterApplyUpdateResponseCallbackType)(
    void *, const chip::app::Clusters::OtaSoftwareUpdateProvider::Commands::ApplyUpdateResponse::DecodableType &);
typedef void (*GeneralCommissioningClusterArmFailSafeResponseCallbackType)(
    void *, const chip::app::Clusters::GeneralCommissioning::Commands::ArmFailSafeResponse::DecodableType &);
typedef void (*GeneralCommissioningClusterSetRegulatoryConfigResponseCallbackType)(
    void *, const chip::app::Clusters::GeneralCommissioning::Commands::SetRegulatoryConfigResponse::DecodableType &);
typedef void (*GeneralCommissioningClusterCommissioningCompleteResponseCallbackType)(
    void *, const chip::app::Clusters::GeneralCommissioning::Commands::CommissioningCompleteResponse::DecodableType &);
typedef void (*NetworkCommissioningClusterScanNetworksResponseCallbackType)(
    void *, const chip::app::Clusters::NetworkCommissioning::Commands::ScanNetworksResponse::DecodableType &);
typedef void (*NetworkCommissioningClusterNetworkConfigResponseCallbackType)(
    void *, const chip::app::Clusters::NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType &);
typedef void (*NetworkCommissioningClusterConnectNetworkResponseCallbackType)(
    void *, const chip::app::Clusters::NetworkCommissioning::Commands::ConnectNetworkResponse::DecodableType &);
typedef void (*DiagnosticLogsClusterRetrieveLogsResponseCallbackType)(
    void *, const chip::app::Clusters::DiagnosticLogs::Commands::RetrieveLogsResponse::DecodableType &);
typedef void (*OperationalCredentialsClusterAttestationResponseCallbackType)(
    void *, const chip::app::Clusters::OperationalCredentials::Commands::AttestationResponse::DecodableType &);
typedef void (*OperationalCredentialsClusterCertificateChainResponseCallbackType)(
    void *, const chip::app::Clusters::OperationalCredentials::Commands::CertificateChainResponse::DecodableType &);
typedef void (*OperationalCredentialsClusterCSRResponseCallbackType)(
    void *, const chip::app::Clusters::OperationalCredentials::Commands::CSRResponse::DecodableType &);
typedef void (*OperationalCredentialsClusterNOCResponseCallbackType)(
    void *, const chip::app::Clusters::OperationalCredentials::Commands::NOCResponse::DecodableType &);
typedef void (*GroupKeyManagementClusterKeySetReadResponseCallbackType)(
    void *, const chip::app::Clusters::GroupKeyManagement::Commands::KeySetReadResponse::DecodableType &);
typedef void (*GroupKeyManagementClusterKeySetReadAllIndicesResponseCallbackType)(
    void *, const chip::app::Clusters::GroupKeyManagement::Commands::KeySetReadAllIndicesResponse::DecodableType &);
typedef void (*OperationalStateClusterOperationalCommandResponseCallbackType)(
    void *, const chip::app::Clusters::OperationalState::Commands::OperationalCommandResponse::DecodableType &);
typedef void (*DoorLockClusterGetWeekDayScheduleResponseCallbackType)(
    void *, const chip::app::Clusters::DoorLock::Commands::GetWeekDayScheduleResponse::DecodableType &);
typedef void (*DoorLockClusterGetYearDayScheduleResponseCallbackType)(
    void *, const chip::app::Clusters::DoorLock::Commands::GetYearDayScheduleResponse::DecodableType &);
typedef void (*DoorLockClusterGetHolidayScheduleResponseCallbackType)(
    void *, const chip::app::Clusters::DoorLock::Commands::GetHolidayScheduleResponse::DecodableType &);
typedef void (*DoorLockClusterGetUserResponseCallbackType)(
    void *, const chip::app::Clusters::DoorLock::Commands::GetUserResponse::DecodableType &);
typedef void (*DoorLockClusterSetCredentialResponseCallbackType)(
    void *, const chip::app::Clusters::DoorLock::Commands::SetCredentialResponse::DecodableType &);
typedef void (*DoorLockClusterGetCredentialStatusResponseCallbackType)(
    void *, const chip::app::Clusters::DoorLock::Commands::GetCredentialStatusResponse::DecodableType &);
typedef void (*ThermostatClusterGetWeeklyScheduleResponseCallbackType)(
    void *, const chip::app::Clusters::Thermostat::Commands::GetWeeklyScheduleResponse::DecodableType &);
typedef void (*ChannelClusterChangeChannelResponseCallbackType)(
    void *, const chip::app::Clusters::Channel::Commands::ChangeChannelResponse::DecodableType &);
typedef void (*TargetNavigatorClusterNavigateTargetResponseCallbackType)(
    void *, const chip::app::Clusters::TargetNavigator::Commands::NavigateTargetResponse::DecodableType &);
typedef void (*MediaPlaybackClusterPlaybackResponseCallbackType)(
    void *, const chip::app::Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType &);
typedef void (*KeypadInputClusterSendKeyResponseCallbackType)(
    void *, const chip::app::Clusters::KeypadInput::Commands::SendKeyResponse::DecodableType &);
typedef void (*ContentLauncherClusterLauncherResponseCallbackType)(
    void *, const chip::app::Clusters::ContentLauncher::Commands::LauncherResponse::DecodableType &);
typedef void (*ApplicationLauncherClusterLauncherResponseCallbackType)(
    void *, const chip::app::Clusters::ApplicationLauncher::Commands::LauncherResponse::DecodableType &);
typedef void (*AccountLoginClusterGetSetupPINResponseCallbackType)(
    void *, const chip::app::Clusters::AccountLogin::Commands::GetSetupPINResponse::DecodableType &);
typedef void (*UnitTestingClusterTestSpecificResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::TestSpecificResponse::DecodableType &);
typedef void (*UnitTestingClusterTestAddArgumentsResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::TestAddArgumentsResponse::DecodableType &);
typedef void (*UnitTestingClusterTestSimpleArgumentResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::TestSimpleArgumentResponse::DecodableType &);
typedef void (*UnitTestingClusterTestStructArrayArgumentResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::TestStructArrayArgumentResponse::DecodableType &);
typedef void (*UnitTestingClusterTestListInt8UReverseResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::TestListInt8UReverseResponse::DecodableType &);
typedef void (*UnitTestingClusterTestEnumsResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::TestEnumsResponse::DecodableType &);
typedef void (*UnitTestingClusterTestNullableOptionalResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::TestNullableOptionalResponse::DecodableType &);
typedef void (*UnitTestingClusterTestComplexNullableOptionalResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::TestComplexNullableOptionalResponse::DecodableType &);
typedef void (*UnitTestingClusterBooleanResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::BooleanResponse::DecodableType &);
typedef void (*UnitTestingClusterSimpleStructResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::SimpleStructResponse::DecodableType &);
typedef void (*UnitTestingClusterTestEmitTestEventResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::TestEmitTestEventResponse::DecodableType &);
typedef void (*UnitTestingClusterTestEmitTestFabricScopedEventResponseCallbackType)(
    void *, const chip::app::Clusters::UnitTesting::Commands::TestEmitTestFabricScopedEventResponse::DecodableType &);

typedef void (*IdentifyClusterEffectIdentifierEnumAttributeCallback)(void *, chip::app::Clusters::Identify::EffectIdentifierEnum);
typedef void (*NullableIdentifyClusterEffectIdentifierEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Identify::EffectIdentifierEnum> &);
typedef void (*IdentifyClusterEffectVariantEnumAttributeCallback)(void *, chip::app::Clusters::Identify::EffectVariantEnum);
typedef void (*NullableIdentifyClusterEffectVariantEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Identify::EffectVariantEnum> &);
typedef void (*IdentifyClusterIdentifyTypeEnumAttributeCallback)(void *, chip::app::Clusters::Identify::IdentifyTypeEnum);
typedef void (*NullableIdentifyClusterIdentifyTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Identify::IdentifyTypeEnum> &);
typedef void (*OnOffClusterOnOffDelayedAllOffEffectVariantAttributeCallback)(
    void *, chip::app::Clusters::OnOff::OnOffDelayedAllOffEffectVariant);
typedef void (*NullableOnOffClusterOnOffDelayedAllOffEffectVariantAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OnOff::OnOffDelayedAllOffEffectVariant> &);
typedef void (*OnOffClusterOnOffDyingLightEffectVariantAttributeCallback)(void *,
                                                                          chip::app::Clusters::OnOff::OnOffDyingLightEffectVariant);
typedef void (*NullableOnOffClusterOnOffDyingLightEffectVariantAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OnOff::OnOffDyingLightEffectVariant> &);
typedef void (*OnOffClusterOnOffEffectIdentifierAttributeCallback)(void *, chip::app::Clusters::OnOff::OnOffEffectIdentifier);
typedef void (*NullableOnOffClusterOnOffEffectIdentifierAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OnOff::OnOffEffectIdentifier> &);
typedef void (*OnOffClusterOnOffStartUpOnOffAttributeCallback)(void *, chip::app::Clusters::OnOff::OnOffStartUpOnOff);
typedef void (*NullableOnOffClusterOnOffStartUpOnOffAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OnOff::OnOffStartUpOnOff> &);
typedef void (*LevelControlClusterMoveModeAttributeCallback)(void *, chip::app::Clusters::LevelControl::MoveMode);
typedef void (*NullableLevelControlClusterMoveModeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::LevelControl::MoveMode> &);
typedef void (*LevelControlClusterStepModeAttributeCallback)(void *, chip::app::Clusters::LevelControl::StepMode);
typedef void (*NullableLevelControlClusterStepModeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::LevelControl::StepMode> &);
typedef void (*AccessControlClusterAccessControlEntryAuthModeEnumAttributeCallback)(
    void *, chip::app::Clusters::AccessControl::AccessControlEntryAuthModeEnum);
typedef void (*NullableAccessControlClusterAccessControlEntryAuthModeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::AccessControl::AccessControlEntryAuthModeEnum> &);
typedef void (*AccessControlClusterAccessControlEntryPrivilegeEnumAttributeCallback)(
    void *, chip::app::Clusters::AccessControl::AccessControlEntryPrivilegeEnum);
typedef void (*NullableAccessControlClusterAccessControlEntryPrivilegeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::AccessControl::AccessControlEntryPrivilegeEnum> &);
typedef void (*AccessControlClusterChangeTypeEnumAttributeCallback)(void *, chip::app::Clusters::AccessControl::ChangeTypeEnum);
typedef void (*NullableAccessControlClusterChangeTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::AccessControl::ChangeTypeEnum> &);
typedef void (*ActionsClusterActionErrorEnumAttributeCallback)(void *, chip::app::Clusters::Actions::ActionErrorEnum);
typedef void (*NullableActionsClusterActionErrorEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Actions::ActionErrorEnum> &);
typedef void (*ActionsClusterActionStateEnumAttributeCallback)(void *, chip::app::Clusters::Actions::ActionStateEnum);
typedef void (*NullableActionsClusterActionStateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Actions::ActionStateEnum> &);
typedef void (*ActionsClusterActionTypeEnumAttributeCallback)(void *, chip::app::Clusters::Actions::ActionTypeEnum);
typedef void (*NullableActionsClusterActionTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Actions::ActionTypeEnum> &);
typedef void (*ActionsClusterEndpointListTypeEnumAttributeCallback)(void *, chip::app::Clusters::Actions::EndpointListTypeEnum);
typedef void (*NullableActionsClusterEndpointListTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Actions::EndpointListTypeEnum> &);
typedef void (*BasicInformationClusterColorEnumAttributeCallback)(void *, chip::app::Clusters::BasicInformation::ColorEnum);
typedef void (*NullableBasicInformationClusterColorEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::BasicInformation::ColorEnum> &);
typedef void (*BasicInformationClusterProductFinishEnumAttributeCallback)(void *,
                                                                          chip::app::Clusters::BasicInformation::ProductFinishEnum);
typedef void (*NullableBasicInformationClusterProductFinishEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::BasicInformation::ProductFinishEnum> &);
typedef void (*OTASoftwareUpdateProviderClusterOTAApplyUpdateActionAttributeCallback)(
    void *, chip::app::Clusters::OtaSoftwareUpdateProvider::OTAApplyUpdateAction);
typedef void (*NullableOTASoftwareUpdateProviderClusterOTAApplyUpdateActionAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OtaSoftwareUpdateProvider::OTAApplyUpdateAction> &);
typedef void (*OTASoftwareUpdateProviderClusterOTADownloadProtocolAttributeCallback)(
    void *, chip::app::Clusters::OtaSoftwareUpdateProvider::OTADownloadProtocol);
typedef void (*NullableOTASoftwareUpdateProviderClusterOTADownloadProtocolAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OtaSoftwareUpdateProvider::OTADownloadProtocol> &);
typedef void (*OTASoftwareUpdateProviderClusterOTAQueryStatusAttributeCallback)(
    void *, chip::app::Clusters::OtaSoftwareUpdateProvider::OTAQueryStatus);
typedef void (*NullableOTASoftwareUpdateProviderClusterOTAQueryStatusAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OtaSoftwareUpdateProvider::OTAQueryStatus> &);
typedef void (*OTASoftwareUpdateRequestorClusterOTAAnnouncementReasonAttributeCallback)(
    void *, chip::app::Clusters::OtaSoftwareUpdateRequestor::OTAAnnouncementReason);
typedef void (*NullableOTASoftwareUpdateRequestorClusterOTAAnnouncementReasonAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OtaSoftwareUpdateRequestor::OTAAnnouncementReason> &);
typedef void (*OTASoftwareUpdateRequestorClusterOTAChangeReasonEnumAttributeCallback)(
    void *, chip::app::Clusters::OtaSoftwareUpdateRequestor::OTAChangeReasonEnum);
typedef void (*NullableOTASoftwareUpdateRequestorClusterOTAChangeReasonEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OtaSoftwareUpdateRequestor::OTAChangeReasonEnum> &);
typedef void (*OTASoftwareUpdateRequestorClusterOTAUpdateStateEnumAttributeCallback)(
    void *, chip::app::Clusters::OtaSoftwareUpdateRequestor::OTAUpdateStateEnum);
typedef void (*NullableOTASoftwareUpdateRequestorClusterOTAUpdateStateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OtaSoftwareUpdateRequestor::OTAUpdateStateEnum> &);
typedef void (*TimeFormatLocalizationClusterCalendarTypeEnumAttributeCallback)(
    void *, chip::app::Clusters::TimeFormatLocalization::CalendarTypeEnum);
typedef void (*NullableTimeFormatLocalizationClusterCalendarTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::TimeFormatLocalization::CalendarTypeEnum> &);
typedef void (*TimeFormatLocalizationClusterHourFormatEnumAttributeCallback)(
    void *, chip::app::Clusters::TimeFormatLocalization::HourFormatEnum);
typedef void (*NullableTimeFormatLocalizationClusterHourFormatEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::TimeFormatLocalization::HourFormatEnum> &);
typedef void (*UnitLocalizationClusterTempUnitEnumAttributeCallback)(void *, chip::app::Clusters::UnitLocalization::TempUnitEnum);
typedef void (*NullableUnitLocalizationClusterTempUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::UnitLocalization::TempUnitEnum> &);
typedef void (*PowerSourceClusterBatApprovedChemistryEnumAttributeCallback)(
    void *, chip::app::Clusters::PowerSource::BatApprovedChemistryEnum);
typedef void (*NullablePowerSourceClusterBatApprovedChemistryEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PowerSource::BatApprovedChemistryEnum> &);
typedef void (*PowerSourceClusterBatChargeFaultEnumAttributeCallback)(void *, chip::app::Clusters::PowerSource::BatChargeFaultEnum);
typedef void (*NullablePowerSourceClusterBatChargeFaultEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PowerSource::BatChargeFaultEnum> &);
typedef void (*PowerSourceClusterBatChargeLevelEnumAttributeCallback)(void *, chip::app::Clusters::PowerSource::BatChargeLevelEnum);
typedef void (*NullablePowerSourceClusterBatChargeLevelEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PowerSource::BatChargeLevelEnum> &);
typedef void (*PowerSourceClusterBatChargeStateEnumAttributeCallback)(void *, chip::app::Clusters::PowerSource::BatChargeStateEnum);
typedef void (*NullablePowerSourceClusterBatChargeStateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PowerSource::BatChargeStateEnum> &);
typedef void (*PowerSourceClusterBatCommonDesignationEnumAttributeCallback)(
    void *, chip::app::Clusters::PowerSource::BatCommonDesignationEnum);
typedef void (*NullablePowerSourceClusterBatCommonDesignationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PowerSource::BatCommonDesignationEnum> &);
typedef void (*PowerSourceClusterBatFaultEnumAttributeCallback)(void *, chip::app::Clusters::PowerSource::BatFaultEnum);
typedef void (*NullablePowerSourceClusterBatFaultEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PowerSource::BatFaultEnum> &);
typedef void (*PowerSourceClusterBatReplaceabilityEnumAttributeCallback)(void *,
                                                                         chip::app::Clusters::PowerSource::BatReplaceabilityEnum);
typedef void (*NullablePowerSourceClusterBatReplaceabilityEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PowerSource::BatReplaceabilityEnum> &);
typedef void (*PowerSourceClusterPowerSourceStatusEnumAttributeCallback)(void *,
                                                                         chip::app::Clusters::PowerSource::PowerSourceStatusEnum);
typedef void (*NullablePowerSourceClusterPowerSourceStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PowerSource::PowerSourceStatusEnum> &);
typedef void (*PowerSourceClusterWiredCurrentTypeEnumAttributeCallback)(void *,
                                                                        chip::app::Clusters::PowerSource::WiredCurrentTypeEnum);
typedef void (*NullablePowerSourceClusterWiredCurrentTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PowerSource::WiredCurrentTypeEnum> &);
typedef void (*PowerSourceClusterWiredFaultEnumAttributeCallback)(void *, chip::app::Clusters::PowerSource::WiredFaultEnum);
typedef void (*NullablePowerSourceClusterWiredFaultEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PowerSource::WiredFaultEnum> &);
typedef void (*GeneralCommissioningClusterCommissioningErrorEnumAttributeCallback)(
    void *, chip::app::Clusters::GeneralCommissioning::CommissioningErrorEnum);
typedef void (*NullableGeneralCommissioningClusterCommissioningErrorEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::GeneralCommissioning::CommissioningErrorEnum> &);
typedef void (*GeneralCommissioningClusterRegulatoryLocationTypeEnumAttributeCallback)(
    void *, chip::app::Clusters::GeneralCommissioning::RegulatoryLocationTypeEnum);
typedef void (*NullableGeneralCommissioningClusterRegulatoryLocationTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::GeneralCommissioning::RegulatoryLocationTypeEnum> &);
typedef void (*NetworkCommissioningClusterNetworkCommissioningStatusAttributeCallback)(
    void *, chip::app::Clusters::NetworkCommissioning::NetworkCommissioningStatus);
typedef void (*NullableNetworkCommissioningClusterNetworkCommissioningStatusAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::NetworkCommissioning::NetworkCommissioningStatus> &);
typedef void (*NetworkCommissioningClusterWiFiBandAttributeCallback)(void *, chip::app::Clusters::NetworkCommissioning::WiFiBand);
typedef void (*NullableNetworkCommissioningClusterWiFiBandAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::NetworkCommissioning::WiFiBand> &);
typedef void (*DiagnosticLogsClusterIntentEnumAttributeCallback)(void *, chip::app::Clusters::DiagnosticLogs::IntentEnum);
typedef void (*NullableDiagnosticLogsClusterIntentEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DiagnosticLogs::IntentEnum> &);
typedef void (*DiagnosticLogsClusterStatusEnumAttributeCallback)(void *, chip::app::Clusters::DiagnosticLogs::StatusEnum);
typedef void (*NullableDiagnosticLogsClusterStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DiagnosticLogs::StatusEnum> &);
typedef void (*DiagnosticLogsClusterTransferProtocolEnumAttributeCallback)(
    void *, chip::app::Clusters::DiagnosticLogs::TransferProtocolEnum);
typedef void (*NullableDiagnosticLogsClusterTransferProtocolEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DiagnosticLogs::TransferProtocolEnum> &);
typedef void (*GeneralDiagnosticsClusterBootReasonEnumAttributeCallback)(void *,
                                                                         chip::app::Clusters::GeneralDiagnostics::BootReasonEnum);
typedef void (*NullableGeneralDiagnosticsClusterBootReasonEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::GeneralDiagnostics::BootReasonEnum> &);
typedef void (*GeneralDiagnosticsClusterHardwareFaultEnumAttributeCallback)(
    void *, chip::app::Clusters::GeneralDiagnostics::HardwareFaultEnum);
typedef void (*NullableGeneralDiagnosticsClusterHardwareFaultEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::GeneralDiagnostics::HardwareFaultEnum> &);
typedef void (*GeneralDiagnosticsClusterInterfaceTypeEnumAttributeCallback)(
    void *, chip::app::Clusters::GeneralDiagnostics::InterfaceTypeEnum);
typedef void (*NullableGeneralDiagnosticsClusterInterfaceTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::GeneralDiagnostics::InterfaceTypeEnum> &);
typedef void (*GeneralDiagnosticsClusterNetworkFaultEnumAttributeCallback)(
    void *, chip::app::Clusters::GeneralDiagnostics::NetworkFaultEnum);
typedef void (*NullableGeneralDiagnosticsClusterNetworkFaultEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::GeneralDiagnostics::NetworkFaultEnum> &);
typedef void (*GeneralDiagnosticsClusterRadioFaultEnumAttributeCallback)(void *,
                                                                         chip::app::Clusters::GeneralDiagnostics::RadioFaultEnum);
typedef void (*NullableGeneralDiagnosticsClusterRadioFaultEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::GeneralDiagnostics::RadioFaultEnum> &);
typedef void (*ThreadNetworkDiagnosticsClusterConnectionStatusEnumAttributeCallback)(
    void *, chip::app::Clusters::ThreadNetworkDiagnostics::ConnectionStatusEnum);
typedef void (*NullableThreadNetworkDiagnosticsClusterConnectionStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::ConnectionStatusEnum> &);
typedef void (*ThreadNetworkDiagnosticsClusterNetworkFaultEnumAttributeCallback)(
    void *, chip::app::Clusters::ThreadNetworkDiagnostics::NetworkFaultEnum);
typedef void (*NullableThreadNetworkDiagnosticsClusterNetworkFaultEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::NetworkFaultEnum> &);
typedef void (*ThreadNetworkDiagnosticsClusterRoutingRoleEnumAttributeCallback)(
    void *, chip::app::Clusters::ThreadNetworkDiagnostics::RoutingRoleEnum);
typedef void (*NullableThreadNetworkDiagnosticsClusterRoutingRoleEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::RoutingRoleEnum> &);
typedef void (*WiFiNetworkDiagnosticsClusterAssociationFailureCauseEnumAttributeCallback)(
    void *, chip::app::Clusters::WiFiNetworkDiagnostics::AssociationFailureCauseEnum);
typedef void (*NullableWiFiNetworkDiagnosticsClusterAssociationFailureCauseEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::AssociationFailureCauseEnum> &);
typedef void (*WiFiNetworkDiagnosticsClusterConnectionStatusEnumAttributeCallback)(
    void *, chip::app::Clusters::WiFiNetworkDiagnostics::ConnectionStatusEnum);
typedef void (*NullableWiFiNetworkDiagnosticsClusterConnectionStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::ConnectionStatusEnum> &);
typedef void (*WiFiNetworkDiagnosticsClusterSecurityTypeEnumAttributeCallback)(
    void *, chip::app::Clusters::WiFiNetworkDiagnostics::SecurityTypeEnum);
typedef void (*NullableWiFiNetworkDiagnosticsClusterSecurityTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::SecurityTypeEnum> &);
typedef void (*WiFiNetworkDiagnosticsClusterWiFiVersionEnumAttributeCallback)(
    void *, chip::app::Clusters::WiFiNetworkDiagnostics::WiFiVersionEnum);
typedef void (*NullableWiFiNetworkDiagnosticsClusterWiFiVersionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::WiFiVersionEnum> &);
typedef void (*EthernetNetworkDiagnosticsClusterPHYRateEnumAttributeCallback)(
    void *, chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateEnum);
typedef void (*NullableEthernetNetworkDiagnosticsClusterPHYRateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateEnum> &);
typedef void (*TimeSynchronizationClusterGranularityEnumAttributeCallback)(
    void *, chip::app::Clusters::TimeSynchronization::GranularityEnum);
typedef void (*NullableTimeSynchronizationClusterGranularityEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::TimeSynchronization::GranularityEnum> &);
typedef void (*TimeSynchronizationClusterTimeSourceEnumAttributeCallback)(void *,
                                                                          chip::app::Clusters::TimeSynchronization::TimeSourceEnum);
typedef void (*NullableTimeSynchronizationClusterTimeSourceEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::TimeSynchronization::TimeSourceEnum> &);
typedef void (*BridgedDeviceBasicInformationClusterColorEnumAttributeCallback)(
    void *, chip::app::Clusters::BridgedDeviceBasicInformation::ColorEnum);
typedef void (*NullableBridgedDeviceBasicInformationClusterColorEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::BridgedDeviceBasicInformation::ColorEnum> &);
typedef void (*BridgedDeviceBasicInformationClusterProductFinishEnumAttributeCallback)(
    void *, chip::app::Clusters::BridgedDeviceBasicInformation::ProductFinishEnum);
typedef void (*NullableBridgedDeviceBasicInformationClusterProductFinishEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::BridgedDeviceBasicInformation::ProductFinishEnum> &);
typedef void (*AdministratorCommissioningClusterCommissioningWindowStatusEnumAttributeCallback)(
    void *, chip::app::Clusters::AdministratorCommissioning::CommissioningWindowStatusEnum);
typedef void (*NullableAdministratorCommissioningClusterCommissioningWindowStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::AdministratorCommissioning::CommissioningWindowStatusEnum> &);
typedef void (*AdministratorCommissioningClusterStatusCodeAttributeCallback)(
    void *, chip::app::Clusters::AdministratorCommissioning::StatusCode);
typedef void (*NullableAdministratorCommissioningClusterStatusCodeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::AdministratorCommissioning::StatusCode> &);
typedef void (*OperationalCredentialsClusterCertificateChainTypeEnumAttributeCallback)(
    void *, chip::app::Clusters::OperationalCredentials::CertificateChainTypeEnum);
typedef void (*NullableOperationalCredentialsClusterCertificateChainTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OperationalCredentials::CertificateChainTypeEnum> &);
typedef void (*OperationalCredentialsClusterNodeOperationalCertStatusEnumAttributeCallback)(
    void *, chip::app::Clusters::OperationalCredentials::NodeOperationalCertStatusEnum);
typedef void (*NullableOperationalCredentialsClusterNodeOperationalCertStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OperationalCredentials::NodeOperationalCertStatusEnum> &);
typedef void (*GroupKeyManagementClusterGroupKeySecurityPolicyEnumAttributeCallback)(
    void *, chip::app::Clusters::GroupKeyManagement::GroupKeySecurityPolicyEnum);
typedef void (*NullableGroupKeyManagementClusterGroupKeySecurityPolicyEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::GroupKeyManagement::GroupKeySecurityPolicyEnum> &);
typedef void (*AirQualityClusterAirQualityEnumAttributeCallback)(void *, chip::app::Clusters::AirQuality::AirQualityEnum);
typedef void (*NullableAirQualityClusterAirQualityEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::AirQuality::AirQualityEnum> &);
typedef void (*SmokeCOAlarmClusterAlarmStateEnumAttributeCallback)(void *, chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum);
typedef void (*NullableSmokeCOAlarmClusterAlarmStateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SmokeCoAlarm::AlarmStateEnum> &);
typedef void (*SmokeCOAlarmClusterContaminationStateEnumAttributeCallback)(
    void *, chip::app::Clusters::SmokeCoAlarm::ContaminationStateEnum);
typedef void (*NullableSmokeCOAlarmClusterContaminationStateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SmokeCoAlarm::ContaminationStateEnum> &);
typedef void (*SmokeCOAlarmClusterEndOfServiceEnumAttributeCallback)(void *, chip::app::Clusters::SmokeCoAlarm::EndOfServiceEnum);
typedef void (*NullableSmokeCOAlarmClusterEndOfServiceEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SmokeCoAlarm::EndOfServiceEnum> &);
typedef void (*SmokeCOAlarmClusterExpressedStateEnumAttributeCallback)(void *,
                                                                       chip::app::Clusters::SmokeCoAlarm::ExpressedStateEnum);
typedef void (*NullableSmokeCOAlarmClusterExpressedStateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SmokeCoAlarm::ExpressedStateEnum> &);
typedef void (*SmokeCOAlarmClusterMuteStateEnumAttributeCallback)(void *, chip::app::Clusters::SmokeCoAlarm::MuteStateEnum);
typedef void (*NullableSmokeCOAlarmClusterMuteStateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SmokeCoAlarm::MuteStateEnum> &);
typedef void (*SmokeCOAlarmClusterSensitivityEnumAttributeCallback)(void *, chip::app::Clusters::SmokeCoAlarm::SensitivityEnum);
typedef void (*NullableSmokeCOAlarmClusterSensitivityEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SmokeCoAlarm::SensitivityEnum> &);
typedef void (*OperationalStateClusterErrorStateEnumAttributeCallback)(void *,
                                                                       chip::app::Clusters::OperationalState::ErrorStateEnum);
typedef void (*NullableOperationalStateClusterErrorStateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OperationalState::ErrorStateEnum> &);
typedef void (*OperationalStateClusterOperationalStateEnumAttributeCallback)(
    void *, chip::app::Clusters::OperationalState::OperationalStateEnum);
typedef void (*NullableOperationalStateClusterOperationalStateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OperationalState::OperationalStateEnum> &);
typedef void (*HEPAFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::HepaFilterMonitoring::ChangeIndicationEnum);
typedef void (*NullableHEPAFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::HepaFilterMonitoring::ChangeIndicationEnum> &);
typedef void (*HEPAFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::HepaFilterMonitoring::DegradationDirectionEnum);
typedef void (*NullableHEPAFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::HepaFilterMonitoring::DegradationDirectionEnum> &);
typedef void (*ActivatedCarbonFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::ActivatedCarbonFilterMonitoring::ChangeIndicationEnum);
typedef void (*NullableActivatedCarbonFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ActivatedCarbonFilterMonitoring::ChangeIndicationEnum> &);
typedef void (*ActivatedCarbonFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::ActivatedCarbonFilterMonitoring::DegradationDirectionEnum);
typedef void (*NullableActivatedCarbonFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ActivatedCarbonFilterMonitoring::DegradationDirectionEnum> &);
typedef void (*CeramicFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::CeramicFilterMonitoring::ChangeIndicationEnum);
typedef void (*NullableCeramicFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::CeramicFilterMonitoring::ChangeIndicationEnum> &);
typedef void (*CeramicFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::CeramicFilterMonitoring::DegradationDirectionEnum);
typedef void (*NullableCeramicFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::CeramicFilterMonitoring::DegradationDirectionEnum> &);
typedef void (*ElectrostaticFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::ElectrostaticFilterMonitoring::ChangeIndicationEnum);
typedef void (*NullableElectrostaticFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ElectrostaticFilterMonitoring::ChangeIndicationEnum> &);
typedef void (*ElectrostaticFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::ElectrostaticFilterMonitoring::DegradationDirectionEnum);
typedef void (*NullableElectrostaticFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ElectrostaticFilterMonitoring::DegradationDirectionEnum> &);
typedef void (*UVFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::UvFilterMonitoring::ChangeIndicationEnum);
typedef void (*NullableUVFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::UvFilterMonitoring::ChangeIndicationEnum> &);
typedef void (*UVFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::UvFilterMonitoring::DegradationDirectionEnum);
typedef void (*NullableUVFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::UvFilterMonitoring::DegradationDirectionEnum> &);
typedef void (*IonizingFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::IonizingFilterMonitoring::ChangeIndicationEnum);
typedef void (*NullableIonizingFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::IonizingFilterMonitoring::ChangeIndicationEnum> &);
typedef void (*IonizingFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::IonizingFilterMonitoring::DegradationDirectionEnum);
typedef void (*NullableIonizingFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::IonizingFilterMonitoring::DegradationDirectionEnum> &);
typedef void (*ZeoliteFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::ZeoliteFilterMonitoring::ChangeIndicationEnum);
typedef void (*NullableZeoliteFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ZeoliteFilterMonitoring::ChangeIndicationEnum> &);
typedef void (*ZeoliteFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::ZeoliteFilterMonitoring::DegradationDirectionEnum);
typedef void (*NullableZeoliteFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ZeoliteFilterMonitoring::DegradationDirectionEnum> &);
typedef void (*OzoneFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::OzoneFilterMonitoring::ChangeIndicationEnum);
typedef void (*NullableOzoneFilterMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OzoneFilterMonitoring::ChangeIndicationEnum> &);
typedef void (*OzoneFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::OzoneFilterMonitoring::DegradationDirectionEnum);
typedef void (*NullableOzoneFilterMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OzoneFilterMonitoring::DegradationDirectionEnum> &);
typedef void (*WaterTankMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::WaterTankMonitoring::ChangeIndicationEnum);
typedef void (*NullableWaterTankMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::WaterTankMonitoring::ChangeIndicationEnum> &);
typedef void (*WaterTankMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::WaterTankMonitoring::DegradationDirectionEnum);
typedef void (*NullableWaterTankMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::WaterTankMonitoring::DegradationDirectionEnum> &);
typedef void (*FuelTankMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::FuelTankMonitoring::ChangeIndicationEnum);
typedef void (*NullableFuelTankMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FuelTankMonitoring::ChangeIndicationEnum> &);
typedef void (*FuelTankMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::FuelTankMonitoring::DegradationDirectionEnum);
typedef void (*NullableFuelTankMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FuelTankMonitoring::DegradationDirectionEnum> &);
typedef void (*InkCartridgeMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::InkCartridgeMonitoring::ChangeIndicationEnum);
typedef void (*NullableInkCartridgeMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::InkCartridgeMonitoring::ChangeIndicationEnum> &);
typedef void (*InkCartridgeMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::InkCartridgeMonitoring::DegradationDirectionEnum);
typedef void (*NullableInkCartridgeMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::InkCartridgeMonitoring::DegradationDirectionEnum> &);
typedef void (*TonerCartridgeMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, chip::app::Clusters::TonerCartridgeMonitoring::ChangeIndicationEnum);
typedef void (*NullableTonerCartridgeMonitoringClusterChangeIndicationEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::TonerCartridgeMonitoring::ChangeIndicationEnum> &);
typedef void (*TonerCartridgeMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, chip::app::Clusters::TonerCartridgeMonitoring::DegradationDirectionEnum);
typedef void (*NullableTonerCartridgeMonitoringClusterDegradationDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::TonerCartridgeMonitoring::DegradationDirectionEnum> &);
typedef void (*DoorLockClusterAlarmCodeEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::AlarmCodeEnum);
typedef void (*NullableDoorLockClusterAlarmCodeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::AlarmCodeEnum> &);
typedef void (*DoorLockClusterCredentialRuleEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::CredentialRuleEnum);
typedef void (*NullableDoorLockClusterCredentialRuleEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::CredentialRuleEnum> &);
typedef void (*DoorLockClusterCredentialTypeEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::CredentialTypeEnum);
typedef void (*NullableDoorLockClusterCredentialTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::CredentialTypeEnum> &);
typedef void (*DoorLockClusterDataOperationTypeEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::DataOperationTypeEnum);
typedef void (*NullableDoorLockClusterDataOperationTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DataOperationTypeEnum> &);
typedef void (*DoorLockClusterDlLockStateAttributeCallback)(void *, chip::app::Clusters::DoorLock::DlLockState);
typedef void (*NullableDoorLockClusterDlLockStateAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlLockState> &);
typedef void (*DoorLockClusterDlLockTypeAttributeCallback)(void *, chip::app::Clusters::DoorLock::DlLockType);
typedef void (*NullableDoorLockClusterDlLockTypeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlLockType> &);
typedef void (*DoorLockClusterDlStatusAttributeCallback)(void *, chip::app::Clusters::DoorLock::DlStatus);
typedef void (*NullableDoorLockClusterDlStatusAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlStatus> &);
typedef void (*DoorLockClusterDoorLockOperationEventCodeAttributeCallback)(
    void *, chip::app::Clusters::DoorLock::DoorLockOperationEventCode);
typedef void (*NullableDoorLockClusterDoorLockOperationEventCodeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DoorLockOperationEventCode> &);
typedef void (*DoorLockClusterDoorLockProgrammingEventCodeAttributeCallback)(
    void *, chip::app::Clusters::DoorLock::DoorLockProgrammingEventCode);
typedef void (*NullableDoorLockClusterDoorLockProgrammingEventCodeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DoorLockProgrammingEventCode> &);
typedef void (*DoorLockClusterDoorLockSetPinOrIdStatusAttributeCallback)(void *,
                                                                         chip::app::Clusters::DoorLock::DoorLockSetPinOrIdStatus);
typedef void (*NullableDoorLockClusterDoorLockSetPinOrIdStatusAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DoorLockSetPinOrIdStatus> &);
typedef void (*DoorLockClusterDoorStateEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::DoorStateEnum);
typedef void (*NullableDoorLockClusterDoorStateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DoorStateEnum> &);
typedef void (*DoorLockClusterLockDataTypeEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::LockDataTypeEnum);
typedef void (*NullableDoorLockClusterLockDataTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::LockDataTypeEnum> &);
typedef void (*DoorLockClusterLockOperationTypeEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::LockOperationTypeEnum);
typedef void (*NullableDoorLockClusterLockOperationTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::LockOperationTypeEnum> &);
typedef void (*DoorLockClusterOperatingModeEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::OperatingModeEnum);
typedef void (*NullableDoorLockClusterOperatingModeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::OperatingModeEnum> &);
typedef void (*DoorLockClusterOperationErrorEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::OperationErrorEnum);
typedef void (*NullableDoorLockClusterOperationErrorEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::OperationErrorEnum> &);
typedef void (*DoorLockClusterOperationSourceEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::OperationSourceEnum);
typedef void (*NullableDoorLockClusterOperationSourceEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::OperationSourceEnum> &);
typedef void (*DoorLockClusterUserStatusEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::UserStatusEnum);
typedef void (*NullableDoorLockClusterUserStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::UserStatusEnum> &);
typedef void (*DoorLockClusterUserTypeEnumAttributeCallback)(void *, chip::app::Clusters::DoorLock::UserTypeEnum);
typedef void (*NullableDoorLockClusterUserTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::UserTypeEnum> &);
typedef void (*WindowCoveringClusterEndProductTypeAttributeCallback)(void *, chip::app::Clusters::WindowCovering::EndProductType);
typedef void (*NullableWindowCoveringClusterEndProductTypeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::WindowCovering::EndProductType> &);
typedef void (*WindowCoveringClusterTypeAttributeCallback)(void *, chip::app::Clusters::WindowCovering::Type);
typedef void (*NullableWindowCoveringClusterTypeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::WindowCovering::Type> &);
typedef void (*PumpConfigurationAndControlClusterControlModeEnumAttributeCallback)(
    void *, chip::app::Clusters::PumpConfigurationAndControl::ControlModeEnum);
typedef void (*NullablePumpConfigurationAndControlClusterControlModeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PumpConfigurationAndControl::ControlModeEnum> &);
typedef void (*PumpConfigurationAndControlClusterOperationModeEnumAttributeCallback)(
    void *, chip::app::Clusters::PumpConfigurationAndControl::OperationModeEnum);
typedef void (*NullablePumpConfigurationAndControlClusterOperationModeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::PumpConfigurationAndControl::OperationModeEnum> &);
typedef void (*ThermostatClusterSetpointAdjustModeAttributeCallback)(void *, chip::app::Clusters::Thermostat::SetpointAdjustMode);
typedef void (*NullableThermostatClusterSetpointAdjustModeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Thermostat::SetpointAdjustMode> &);
typedef void (*ThermostatClusterThermostatControlSequenceAttributeCallback)(
    void *, chip::app::Clusters::Thermostat::ThermostatControlSequence);
typedef void (*NullableThermostatClusterThermostatControlSequenceAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Thermostat::ThermostatControlSequence> &);
typedef void (*ThermostatClusterThermostatRunningModeAttributeCallback)(void *,
                                                                        chip::app::Clusters::Thermostat::ThermostatRunningMode);
typedef void (*NullableThermostatClusterThermostatRunningModeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Thermostat::ThermostatRunningMode> &);
typedef void (*ThermostatClusterThermostatSystemModeAttributeCallback)(void *,
                                                                       chip::app::Clusters::Thermostat::ThermostatSystemMode);
typedef void (*NullableThermostatClusterThermostatSystemModeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Thermostat::ThermostatSystemMode> &);
typedef void (*FanControlClusterAirflowDirectionEnumAttributeCallback)(void *,
                                                                       chip::app::Clusters::FanControl::AirflowDirectionEnum);
typedef void (*NullableFanControlClusterAirflowDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FanControl::AirflowDirectionEnum> &);
typedef void (*FanControlClusterDirectionEnumAttributeCallback)(void *, chip::app::Clusters::FanControl::DirectionEnum);
typedef void (*NullableFanControlClusterDirectionEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FanControl::DirectionEnum> &);
typedef void (*FanControlClusterFanModeSequenceTypeAttributeCallback)(void *, chip::app::Clusters::FanControl::FanModeSequenceType);
typedef void (*NullableFanControlClusterFanModeSequenceTypeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FanControl::FanModeSequenceType> &);
typedef void (*FanControlClusterFanModeTypeAttributeCallback)(void *, chip::app::Clusters::FanControl::FanModeType);
typedef void (*NullableFanControlClusterFanModeTypeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FanControl::FanModeType> &);
typedef void (*ColorControlClusterColorLoopActionAttributeCallback)(void *, chip::app::Clusters::ColorControl::ColorLoopAction);
typedef void (*NullableColorControlClusterColorLoopActionAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ColorControl::ColorLoopAction> &);
typedef void (*ColorControlClusterColorLoopDirectionAttributeCallback)(void *,
                                                                       chip::app::Clusters::ColorControl::ColorLoopDirection);
typedef void (*NullableColorControlClusterColorLoopDirectionAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ColorControl::ColorLoopDirection> &);
typedef void (*ColorControlClusterColorModeAttributeCallback)(void *, chip::app::Clusters::ColorControl::ColorMode);
typedef void (*NullableColorControlClusterColorModeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ColorControl::ColorMode> &);
typedef void (*ColorControlClusterHueDirectionAttributeCallback)(void *, chip::app::Clusters::ColorControl::HueDirection);
typedef void (*NullableColorControlClusterHueDirectionAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ColorControl::HueDirection> &);
typedef void (*ColorControlClusterHueMoveModeAttributeCallback)(void *, chip::app::Clusters::ColorControl::HueMoveMode);
typedef void (*NullableColorControlClusterHueMoveModeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ColorControl::HueMoveMode> &);
typedef void (*ColorControlClusterHueStepModeAttributeCallback)(void *, chip::app::Clusters::ColorControl::HueStepMode);
typedef void (*NullableColorControlClusterHueStepModeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ColorControl::HueStepMode> &);
typedef void (*ColorControlClusterSaturationMoveModeAttributeCallback)(void *,
                                                                       chip::app::Clusters::ColorControl::SaturationMoveMode);
typedef void (*NullableColorControlClusterSaturationMoveModeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ColorControl::SaturationMoveMode> &);
typedef void (*ColorControlClusterSaturationStepModeAttributeCallback)(void *,
                                                                       chip::app::Clusters::ColorControl::SaturationStepMode);
typedef void (*NullableColorControlClusterSaturationStepModeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ColorControl::SaturationStepMode> &);
typedef void (*IlluminanceMeasurementClusterLightSensorTypeEnumAttributeCallback)(
    void *, chip::app::Clusters::IlluminanceMeasurement::LightSensorTypeEnum);
typedef void (*NullableIlluminanceMeasurementClusterLightSensorTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::IlluminanceMeasurement::LightSensorTypeEnum> &);
typedef void (*OccupancySensingClusterOccupancySensorTypeEnumAttributeCallback)(
    void *, chip::app::Clusters::OccupancySensing::OccupancySensorTypeEnum);
typedef void (*NullableOccupancySensingClusterOccupancySensorTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OccupancySensing::OccupancySensorTypeEnum> &);
typedef void (*CarbonMonoxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::CarbonMonoxideConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableCarbonMonoxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::CarbonMonoxideConcentrationMeasurement::LevelValueEnum> &);
typedef void (*CarbonMonoxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::CarbonMonoxideConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableCarbonMonoxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::CarbonMonoxideConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*CarbonMonoxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::CarbonMonoxideConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableCarbonMonoxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::CarbonMonoxideConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*CarbonDioxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::CarbonDioxideConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableCarbonDioxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::CarbonDioxideConcentrationMeasurement::LevelValueEnum> &);
typedef void (*CarbonDioxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::CarbonDioxideConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableCarbonDioxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::CarbonDioxideConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*CarbonDioxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::CarbonDioxideConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableCarbonDioxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::CarbonDioxideConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*EthyleneConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::EthyleneConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableEthyleneConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::EthyleneConcentrationMeasurement::LevelValueEnum> &);
typedef void (*EthyleneConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::EthyleneConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableEthyleneConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::EthyleneConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*EthyleneConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::EthyleneConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableEthyleneConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::EthyleneConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*EthyleneOxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::EthyleneOxideConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableEthyleneOxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::EthyleneOxideConcentrationMeasurement::LevelValueEnum> &);
typedef void (*EthyleneOxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::EthyleneOxideConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableEthyleneOxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::EthyleneOxideConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*EthyleneOxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::EthyleneOxideConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableEthyleneOxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::EthyleneOxideConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*HydrogenConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::HydrogenConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableHydrogenConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::HydrogenConcentrationMeasurement::LevelValueEnum> &);
typedef void (*HydrogenConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::HydrogenConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableHydrogenConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::HydrogenConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*HydrogenConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::HydrogenConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableHydrogenConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::HydrogenConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*HydrogenSulfideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::HydrogenSulfideConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableHydrogenSulfideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::HydrogenSulfideConcentrationMeasurement::LevelValueEnum> &);
typedef void (*HydrogenSulfideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::HydrogenSulfideConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableHydrogenSulfideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::HydrogenSulfideConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*HydrogenSulfideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::HydrogenSulfideConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableHydrogenSulfideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::HydrogenSulfideConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*NitricOxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::NitricOxideConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableNitricOxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::NitricOxideConcentrationMeasurement::LevelValueEnum> &);
typedef void (*NitricOxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::NitricOxideConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableNitricOxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::NitricOxideConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*NitricOxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::NitricOxideConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableNitricOxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::NitricOxideConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*NitrogenDioxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::NitrogenDioxideConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableNitrogenDioxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::NitrogenDioxideConcentrationMeasurement::LevelValueEnum> &);
typedef void (*NitrogenDioxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::NitrogenDioxideConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableNitrogenDioxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::NitrogenDioxideConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*NitrogenDioxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::NitrogenDioxideConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableNitrogenDioxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::NitrogenDioxideConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*OxygenConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::OxygenConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableOxygenConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OxygenConcentrationMeasurement::LevelValueEnum> &);
typedef void (*OxygenConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::OxygenConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableOxygenConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OxygenConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*OxygenConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::OxygenConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableOxygenConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OxygenConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*OzoneConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::OzoneConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableOzoneConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OzoneConcentrationMeasurement::LevelValueEnum> &);
typedef void (*OzoneConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::OzoneConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableOzoneConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OzoneConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*OzoneConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::OzoneConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableOzoneConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::OzoneConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*SulfurDioxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::SulfurDioxideConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableSulfurDioxideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SulfurDioxideConcentrationMeasurement::LevelValueEnum> &);
typedef void (*SulfurDioxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::SulfurDioxideConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableSulfurDioxideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::SulfurDioxideConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*SulfurDioxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::SulfurDioxideConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableSulfurDioxideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::SulfurDioxideConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*DissolvedOxygenConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::DissolvedOxygenConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableDissolvedOxygenConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::DissolvedOxygenConcentrationMeasurement::LevelValueEnum> &);
typedef void (*DissolvedOxygenConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::DissolvedOxygenConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableDissolvedOxygenConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::DissolvedOxygenConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*DissolvedOxygenConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::DissolvedOxygenConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableDissolvedOxygenConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::DissolvedOxygenConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*BromateConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::BromateConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableBromateConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::BromateConcentrationMeasurement::LevelValueEnum> &);
typedef void (*BromateConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::BromateConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableBromateConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::BromateConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*BromateConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::BromateConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableBromateConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::BromateConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*ChloraminesConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::ChloraminesConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableChloraminesConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ChloraminesConcentrationMeasurement::LevelValueEnum> &);
typedef void (*ChloraminesConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::ChloraminesConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableChloraminesConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::ChloraminesConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*ChloraminesConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::ChloraminesConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableChloraminesConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ChloraminesConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*ChlorineConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::ChlorineConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableChlorineConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ChlorineConcentrationMeasurement::LevelValueEnum> &);
typedef void (*ChlorineConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::ChlorineConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableChlorineConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ChlorineConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*ChlorineConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::ChlorineConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableChlorineConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ChlorineConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*FecalColiformEColiConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::FecalColiformEColiConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableFecalColiformEColiConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::FecalColiformEColiConcentrationMeasurement::LevelValueEnum> &);
typedef void (*FecalColiformEColiConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::FecalColiformEColiConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableFecalColiformEColiConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::FecalColiformEColiConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*FecalColiformEColiConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::FecalColiformEColiConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableFecalColiformEColiConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::FecalColiformEColiConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*FluorideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::FluorideConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableFluorideConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FluorideConcentrationMeasurement::LevelValueEnum> &);
typedef void (*FluorideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::FluorideConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableFluorideConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FluorideConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*FluorideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::FluorideConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableFluorideConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FluorideConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*HaloaceticAcidsConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::HaloaceticAcidsConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableHaloaceticAcidsConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::HaloaceticAcidsConcentrationMeasurement::LevelValueEnum> &);
typedef void (*HaloaceticAcidsConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::HaloaceticAcidsConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableHaloaceticAcidsConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::HaloaceticAcidsConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*HaloaceticAcidsConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::HaloaceticAcidsConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableHaloaceticAcidsConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::HaloaceticAcidsConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*TotalTrihalomethanesConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::TotalTrihalomethanesConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableTotalTrihalomethanesConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::TotalTrihalomethanesConcentrationMeasurement::LevelValueEnum> &);
typedef void (*TotalTrihalomethanesConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::TotalTrihalomethanesConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableTotalTrihalomethanesConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<
        chip::app::Clusters::TotalTrihalomethanesConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*TotalTrihalomethanesConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::TotalTrihalomethanesConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableTotalTrihalomethanesConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::TotalTrihalomethanesConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*TotalColiformBacteriaConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::TotalColiformBacteriaConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableTotalColiformBacteriaConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::TotalColiformBacteriaConcentrationMeasurement::LevelValueEnum> &);
typedef void (*TotalColiformBacteriaConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::TotalColiformBacteriaConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableTotalColiformBacteriaConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<
        chip::app::Clusters::TotalColiformBacteriaConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*TotalColiformBacteriaConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::TotalColiformBacteriaConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableTotalColiformBacteriaConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<
        chip::app::Clusters::TotalColiformBacteriaConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*TurbidityConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::TurbidityConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableTurbidityConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::TurbidityConcentrationMeasurement::LevelValueEnum> &);
typedef void (*TurbidityConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::TurbidityConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableTurbidityConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::TurbidityConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*TurbidityConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::TurbidityConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableTurbidityConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::TurbidityConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*CopperConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::CopperConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableCopperConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::CopperConcentrationMeasurement::LevelValueEnum> &);
typedef void (*CopperConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::CopperConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableCopperConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::CopperConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*CopperConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::CopperConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableCopperConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::CopperConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*LeadConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::LeadConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableLeadConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::LeadConcentrationMeasurement::LevelValueEnum> &);
typedef void (*LeadConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::LeadConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableLeadConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::LeadConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*LeadConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::LeadConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableLeadConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::LeadConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*ManganeseConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::ManganeseConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableManganeseConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ManganeseConcentrationMeasurement::LevelValueEnum> &);
typedef void (*ManganeseConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::ManganeseConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableManganeseConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ManganeseConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*ManganeseConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::ManganeseConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableManganeseConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ManganeseConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*SulfateConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::SulfateConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableSulfateConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SulfateConcentrationMeasurement::LevelValueEnum> &);
typedef void (*SulfateConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::SulfateConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableSulfateConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SulfateConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*SulfateConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::SulfateConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableSulfateConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SulfateConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*BromodichloromethaneConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::BromodichloromethaneConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableBromodichloromethaneConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::BromodichloromethaneConcentrationMeasurement::LevelValueEnum> &);
typedef void (*BromodichloromethaneConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::BromodichloromethaneConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableBromodichloromethaneConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<
        chip::app::Clusters::BromodichloromethaneConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*BromodichloromethaneConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::BromodichloromethaneConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableBromodichloromethaneConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::BromodichloromethaneConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*BromoformConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::BromoformConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableBromoformConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::BromoformConcentrationMeasurement::LevelValueEnum> &);
typedef void (*BromoformConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::BromoformConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableBromoformConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::BromoformConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*BromoformConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::BromoformConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableBromoformConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::BromoformConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*ChlorodibromomethaneConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::ChlorodibromomethaneConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableChlorodibromomethaneConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::ChlorodibromomethaneConcentrationMeasurement::LevelValueEnum> &);
typedef void (*ChlorodibromomethaneConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::ChlorodibromomethaneConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableChlorodibromomethaneConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<
        chip::app::Clusters::ChlorodibromomethaneConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*ChlorodibromomethaneConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::ChlorodibromomethaneConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableChlorodibromomethaneConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::ChlorodibromomethaneConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*ChloroformConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::ChloroformConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableChloroformConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ChloroformConcentrationMeasurement::LevelValueEnum> &);
typedef void (*ChloroformConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::ChloroformConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableChloroformConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ChloroformConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*ChloroformConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::ChloroformConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableChloroformConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ChloroformConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*SodiumConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::SodiumConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableSodiumConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SodiumConcentrationMeasurement::LevelValueEnum> &);
typedef void (*SodiumConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::SodiumConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableSodiumConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SodiumConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*SodiumConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::SodiumConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableSodiumConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::SodiumConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*PM25ConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::Pm25ConcentrationMeasurement::LevelValueEnum);
typedef void (*NullablePM25ConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Pm25ConcentrationMeasurement::LevelValueEnum> &);
typedef void (*PM25ConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::Pm25ConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullablePM25ConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Pm25ConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*PM25ConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::Pm25ConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullablePM25ConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Pm25ConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*FormaldehydeConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::FormaldehydeConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableFormaldehydeConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FormaldehydeConcentrationMeasurement::LevelValueEnum> &);
typedef void (*FormaldehydeConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::FormaldehydeConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableFormaldehydeConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::FormaldehydeConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*FormaldehydeConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::FormaldehydeConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableFormaldehydeConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FormaldehydeConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*PM1ConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::Pm1ConcentrationMeasurement::LevelValueEnum);
typedef void (*NullablePM1ConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Pm1ConcentrationMeasurement::LevelValueEnum> &);
typedef void (*PM1ConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::Pm1ConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullablePM1ConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Pm1ConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*PM1ConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::Pm1ConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullablePM1ConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Pm1ConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*PM10ConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::Pm10ConcentrationMeasurement::LevelValueEnum);
typedef void (*NullablePM10ConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Pm10ConcentrationMeasurement::LevelValueEnum> &);
typedef void (*PM10ConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::Pm10ConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullablePM10ConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Pm10ConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*PM10ConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::Pm10ConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullablePM10ConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Pm10ConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*TotalVolatileOrganicCompoundsConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::TotalVolatileOrganicCompoundsConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableTotalVolatileOrganicCompoundsConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<
        chip::app::Clusters::TotalVolatileOrganicCompoundsConcentrationMeasurement::LevelValueEnum> &);
typedef void (*TotalVolatileOrganicCompoundsConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::TotalVolatileOrganicCompoundsConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableTotalVolatileOrganicCompoundsConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<
        chip::app::Clusters::TotalVolatileOrganicCompoundsConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*TotalVolatileOrganicCompoundsConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::TotalVolatileOrganicCompoundsConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableTotalVolatileOrganicCompoundsConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<
        chip::app::Clusters::TotalVolatileOrganicCompoundsConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*RadonConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, chip::app::Clusters::RadonConcentrationMeasurement::LevelValueEnum);
typedef void (*NullableRadonConcentrationMeasurementClusterLevelValueEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::RadonConcentrationMeasurement::LevelValueEnum> &);
typedef void (*RadonConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, chip::app::Clusters::RadonConcentrationMeasurement::MeasurementMediumEnum);
typedef void (*NullableRadonConcentrationMeasurementClusterMeasurementMediumEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::RadonConcentrationMeasurement::MeasurementMediumEnum> &);
typedef void (*RadonConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, chip::app::Clusters::RadonConcentrationMeasurement::MeasurementUnitEnum);
typedef void (*NullableRadonConcentrationMeasurementClusterMeasurementUnitEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::RadonConcentrationMeasurement::MeasurementUnitEnum> &);
typedef void (*ChannelClusterChannelStatusEnumAttributeCallback)(void *, chip::app::Clusters::Channel::ChannelStatusEnum);
typedef void (*NullableChannelClusterChannelStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Channel::ChannelStatusEnum> &);
typedef void (*ChannelClusterLineupInfoTypeEnumAttributeCallback)(void *, chip::app::Clusters::Channel::LineupInfoTypeEnum);
typedef void (*NullableChannelClusterLineupInfoTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Channel::LineupInfoTypeEnum> &);
typedef void (*TargetNavigatorClusterTargetNavigatorStatusEnumAttributeCallback)(
    void *, chip::app::Clusters::TargetNavigator::TargetNavigatorStatusEnum);
typedef void (*NullableTargetNavigatorClusterTargetNavigatorStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::TargetNavigator::TargetNavigatorStatusEnum> &);
typedef void (*MediaPlaybackClusterMediaPlaybackStatusEnumAttributeCallback)(
    void *, chip::app::Clusters::MediaPlayback::MediaPlaybackStatusEnum);
typedef void (*NullableMediaPlaybackClusterMediaPlaybackStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::MediaPlayback::MediaPlaybackStatusEnum> &);
typedef void (*MediaPlaybackClusterPlaybackStateEnumAttributeCallback)(void *,
                                                                       chip::app::Clusters::MediaPlayback::PlaybackStateEnum);
typedef void (*NullableMediaPlaybackClusterPlaybackStateEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::MediaPlayback::PlaybackStateEnum> &);
typedef void (*MediaInputClusterInputTypeEnumAttributeCallback)(void *, chip::app::Clusters::MediaInput::InputTypeEnum);
typedef void (*NullableMediaInputClusterInputTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::MediaInput::InputTypeEnum> &);
typedef void (*KeypadInputClusterCecKeyCodeAttributeCallback)(void *, chip::app::Clusters::KeypadInput::CecKeyCode);
typedef void (*NullableKeypadInputClusterCecKeyCodeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::KeypadInput::CecKeyCode> &);
typedef void (*KeypadInputClusterKeypadInputStatusEnumAttributeCallback)(void *,
                                                                         chip::app::Clusters::KeypadInput::KeypadInputStatusEnum);
typedef void (*NullableKeypadInputClusterKeypadInputStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::KeypadInput::KeypadInputStatusEnum> &);
typedef void (*ContentLauncherClusterContentLaunchStatusEnumAttributeCallback)(
    void *, chip::app::Clusters::ContentLauncher::ContentLaunchStatusEnum);
typedef void (*NullableContentLauncherClusterContentLaunchStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ContentLauncher::ContentLaunchStatusEnum> &);
typedef void (*ContentLauncherClusterMetricTypeEnumAttributeCallback)(void *, chip::app::Clusters::ContentLauncher::MetricTypeEnum);
typedef void (*NullableContentLauncherClusterMetricTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ContentLauncher::MetricTypeEnum> &);
typedef void (*ContentLauncherClusterParameterEnumAttributeCallback)(void *, chip::app::Clusters::ContentLauncher::ParameterEnum);
typedef void (*NullableContentLauncherClusterParameterEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ContentLauncher::ParameterEnum> &);
typedef void (*AudioOutputClusterOutputTypeEnumAttributeCallback)(void *, chip::app::Clusters::AudioOutput::OutputTypeEnum);
typedef void (*NullableAudioOutputClusterOutputTypeEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::AudioOutput::OutputTypeEnum> &);
typedef void (*ApplicationLauncherClusterApplicationLauncherStatusEnumAttributeCallback)(
    void *, chip::app::Clusters::ApplicationLauncher::ApplicationLauncherStatusEnum);
typedef void (*NullableApplicationLauncherClusterApplicationLauncherStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ApplicationLauncher::ApplicationLauncherStatusEnum> &);
typedef void (*ApplicationBasicClusterApplicationStatusEnumAttributeCallback)(
    void *, chip::app::Clusters::ApplicationBasic::ApplicationStatusEnum);
typedef void (*NullableApplicationBasicClusterApplicationStatusEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::ApplicationBasic::ApplicationStatusEnum> &);
typedef void (*UnitTestingClusterSimpleEnumAttributeCallback)(void *, chip::app::Clusters::UnitTesting::SimpleEnum);
typedef void (*NullableUnitTestingClusterSimpleEnumAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::UnitTesting::SimpleEnum> &);
typedef void (*FaultInjectionClusterFaultTypeAttributeCallback)(void *, chip::app::Clusters::FaultInjection::FaultType);
typedef void (*NullableFaultInjectionClusterFaultTypeAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::FaultInjection::FaultType> &);

typedef void (*IdentifyGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*IdentifyAcceptedCommandListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*IdentifyEventListListAttributeCallback)(void * context,
                                                       const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*IdentifyAttributeListListAttributeCallback)(void * context,
                                                           const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*GroupsNameSupportAttributeCallback)(void *, chip::BitMask<chip::app::Clusters::Groups::NameSupportBitmap>);
typedef void (*GroupsGeneratedCommandListListAttributeCallback)(void * context,
                                                                const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*GroupsAcceptedCommandListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*GroupsEventListListAttributeCallback)(void * context,
                                                     const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*GroupsAttributeListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ScenesGeneratedCommandListListAttributeCallback)(void * context,
                                                                const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ScenesAcceptedCommandListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ScenesEventListListAttributeCallback)(void * context,
                                                     const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ScenesAttributeListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*OnOffGeneratedCommandListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OnOffAcceptedCommandListListAttributeCallback)(void * context,
                                                              const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OnOffEventListListAttributeCallback)(void * context,
                                                    const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*OnOffAttributeListListAttributeCallback)(void * context,
                                                        const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*OnOffSwitchConfigurationGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OnOffSwitchConfigurationAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OnOffSwitchConfigurationEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*OnOffSwitchConfigurationAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*LevelControlOptionsAttributeCallback)(void *, chip::BitMask<chip::app::Clusters::LevelControl::LevelControlOptions>);
typedef void (*LevelControlGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*LevelControlAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*LevelControlEventListListAttributeCallback)(void * context,
                                                           const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*LevelControlAttributeListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*BinaryInputBasicGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BinaryInputBasicAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BinaryInputBasicEventListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BinaryInputBasicAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*PulseWidthModulationEventListListAttributeCallback)(void * context,
                                                                   const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*DescriptorDeviceTypeListListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::DecodableType> & data);
typedef void (*DescriptorServerListListAttributeCallback)(void * context,
                                                          const chip::app::DataModel::DecodableList<chip::ClusterId> & data);
typedef void (*DescriptorClientListListAttributeCallback)(void * context,
                                                          const chip::app::DataModel::DecodableList<chip::ClusterId> & data);
typedef void (*DescriptorPartsListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::EndpointId> & data);
typedef void (*DescriptorGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*DescriptorAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*DescriptorEventListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*DescriptorAttributeListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*BindingBindingListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::Binding::Structs::TargetStruct::DecodableType> & data);
typedef void (*BindingGeneratedCommandListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BindingAcceptedCommandListListAttributeCallback)(void * context,
                                                                const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BindingEventListListAttributeCallback)(void * context,
                                                      const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BindingAttributeListListAttributeCallback)(void * context,
                                                          const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*AccessControlACLListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<
        chip::app::Clusters::AccessControl::Structs::AccessControlEntryStruct::DecodableType> & data);
typedef void (*AccessControlExtensionListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<
        chip::app::Clusters::AccessControl::Structs::AccessControlExtensionStruct::DecodableType> & data);
typedef void (*AccessControlGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*AccessControlAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*AccessControlEventListListAttributeCallback)(void * context,
                                                            const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*AccessControlAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ActionsActionListListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::ActionStruct::DecodableType> & data);
typedef void (*ActionsEndpointListsListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::EndpointListStruct::DecodableType> & data);
typedef void (*ActionsGeneratedCommandListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ActionsAcceptedCommandListListAttributeCallback)(void * context,
                                                                const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ActionsEventListListAttributeCallback)(void * context,
                                                      const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ActionsAttributeListListAttributeCallback)(void * context,
                                                          const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*BasicInformationCapabilityMinimaStructAttributeCallback)(
    void *, const chip::app::Clusters::BasicInformation::Structs::CapabilityMinimaStruct::DecodableType &);
typedef void (*BasicInformationProductAppearanceStructAttributeCallback)(
    void *, const chip::app::Clusters::BasicInformation::Structs::ProductAppearanceStruct::DecodableType &);
typedef void (*BasicInformationGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BasicInformationAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BasicInformationEventListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BasicInformationAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*OTASoftwareUpdateProviderGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OTASoftwareUpdateProviderAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OTASoftwareUpdateProviderEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*OTASoftwareUpdateProviderAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*OTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<
        chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::DecodableType> & data);
typedef void (*OTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OTASoftwareUpdateRequestorEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*OTASoftwareUpdateRequestorAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*LocalizationConfigurationSupportedLocalesListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CharSpan> & data);
typedef void (*LocalizationConfigurationGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*LocalizationConfigurationAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*LocalizationConfigurationEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*LocalizationConfigurationAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*TimeFormatLocalizationSupportedCalendarTypesListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::TimeFormatLocalization::CalendarTypeEnum> & data);
typedef void (*TimeFormatLocalizationGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TimeFormatLocalizationAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TimeFormatLocalizationEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*TimeFormatLocalizationAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*UnitLocalizationGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*UnitLocalizationAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*UnitLocalizationEventListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*UnitLocalizationAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*PowerSourceConfigurationSourcesListAttributeCallback)(void * context,
                                                                     const chip::app::DataModel::DecodableList<uint8_t> & data);
typedef void (*PowerSourceConfigurationGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PowerSourceConfigurationAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PowerSourceConfigurationEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*PowerSourceConfigurationAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*PowerSourceActiveWiredFaultsListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::WiredFaultEnum> & data);
typedef void (*PowerSourceActiveBatFaultsListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatFaultEnum> & data);
typedef void (*PowerSourceActiveBatChargeFaultsListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatChargeFaultEnum> & data);
typedef void (*PowerSourceGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PowerSourceAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PowerSourceEventListListAttributeCallback)(void * context,
                                                          const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*PowerSourceAttributeListListAttributeCallback)(void * context,
                                                              const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*GeneralCommissioningBasicCommissioningInfoStructAttributeCallback)(
    void *, const chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::DecodableType &);
typedef void (*GeneralCommissioningGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*GeneralCommissioningAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*GeneralCommissioningEventListListAttributeCallback)(void * context,
                                                                   const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*GeneralCommissioningAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*NetworkCommissioningNetworksListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfo::DecodableType> &
        data);
typedef void (*NetworkCommissioningGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*NetworkCommissioningAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*NetworkCommissioningEventListListAttributeCallback)(void * context,
                                                                   const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*NetworkCommissioningAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*DiagnosticLogsGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*DiagnosticLogsAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*DiagnosticLogsEventListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*DiagnosticLogsAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*GeneralDiagnosticsNetworkInterfacesListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterface::DecodableType> &
        data);
typedef void (*GeneralDiagnosticsActiveHardwareFaultsListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::HardwareFaultEnum> & data);
typedef void (*GeneralDiagnosticsActiveRadioFaultsListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::RadioFaultEnum> & data);
typedef void (*GeneralDiagnosticsActiveNetworkFaultsListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::NetworkFaultEnum> & data);
typedef void (*GeneralDiagnosticsGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*GeneralDiagnosticsAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*GeneralDiagnosticsEventListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*GeneralDiagnosticsAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*SoftwareDiagnosticsThreadMetricsListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<
        chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetricsStruct::DecodableType> & data);
typedef void (*SoftwareDiagnosticsGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SoftwareDiagnosticsAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SoftwareDiagnosticsEventListListAttributeCallback)(void * context,
                                                                  const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*SoftwareDiagnosticsAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ThreadNetworkDiagnosticsNeighborTableListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTableStruct::DecodableType> & data);
typedef void (*ThreadNetworkDiagnosticsRouteTableListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTableStruct::DecodableType> & data);
typedef void (*ThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::DecodableType> &);
typedef void (*ThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::DecodableType> &);
typedef void (*ThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::ThreadNetworkDiagnostics::NetworkFaultEnum> & data);
typedef void (*ThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ThreadNetworkDiagnosticsEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ThreadNetworkDiagnosticsAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*WiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*WiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*WiFiNetworkDiagnosticsEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*WiFiNetworkDiagnosticsAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*EthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*EthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*EthernetNetworkDiagnosticsEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*EthernetNetworkDiagnosticsAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*TimeSynchronizationEventListListAttributeCallback)(void * context,
                                                                  const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BridgedDeviceBasicInformationProductAppearanceStructAttributeCallback)(
    void *, const chip::app::Clusters::BridgedDeviceBasicInformation::Structs::ProductAppearanceStruct::DecodableType &);
typedef void (*BridgedDeviceBasicInformationGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BridgedDeviceBasicInformationAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BridgedDeviceBasicInformationEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BridgedDeviceBasicInformationAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*SwitchGeneratedCommandListListAttributeCallback)(void * context,
                                                                const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SwitchAcceptedCommandListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SwitchEventListListAttributeCallback)(void * context,
                                                     const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*SwitchAttributeListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*AdministratorCommissioningGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*AdministratorCommissioningAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*AdministratorCommissioningEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*AdministratorCommissioningAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*OperationalCredentialsNOCsListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::DecodableType> &
        data);
typedef void (*OperationalCredentialsFabricsListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<
        chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptorStruct::DecodableType> & data);
typedef void (*OperationalCredentialsTrustedRootCertificatesListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::ByteSpan> & data);
typedef void (*OperationalCredentialsGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OperationalCredentialsAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OperationalCredentialsEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*OperationalCredentialsAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*GroupKeyManagementGroupKeyMapListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::DecodableType> &
        data);
typedef void (*GroupKeyManagementGroupTableListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::DecodableType> &
        data);
typedef void (*GroupKeyManagementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*GroupKeyManagementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*GroupKeyManagementEventListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*GroupKeyManagementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*FixedLabelLabelListListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::FixedLabel::Structs::LabelStruct::DecodableType> & data);
typedef void (*FixedLabelGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FixedLabelAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FixedLabelEventListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*FixedLabelAttributeListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*UserLabelLabelListListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::UserLabel::Structs::LabelStruct::DecodableType> & data);
typedef void (*UserLabelGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*UserLabelAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*UserLabelEventListListAttributeCallback)(void * context,
                                                        const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*UserLabelAttributeListListAttributeCallback)(void * context,
                                                            const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ProxyConfigurationEventListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ProxyDiscoveryEventListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ProxyValidEventListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BooleanStateGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BooleanStateAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BooleanStateEventListListAttributeCallback)(void * context,
                                                           const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BooleanStateAttributeListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ModeSelectSupportedModesListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::DecodableType> & data);
typedef void (*ModeSelectGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ModeSelectAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ModeSelectEventListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ModeSelectAttributeListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*TemperatureControlSupportedTemperatureLevelsListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<
        chip::app::Clusters::TemperatureControl::Structs::TemperatureLevelStruct::DecodableType> & data);
typedef void (*TemperatureControlGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TemperatureControlAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TemperatureControlEventListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*TemperatureControlAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*RefrigeratorAlarmMaskAttributeCallback)(void *, chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmMap>);
typedef void (*RefrigeratorAlarmLatchAttributeCallback)(void *, chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmMap>);
typedef void (*RefrigeratorAlarmStateAttributeCallback)(void *, chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmMap>);
typedef void (*RefrigeratorAlarmGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*RefrigeratorAlarmAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*RefrigeratorAlarmEventListListAttributeCallback)(void * context,
                                                                const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*RefrigeratorAlarmAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*AirQualityGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*AirQualityAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*AirQualityEventListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*AirQualityAttributeListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*SmokeCOAlarmGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SmokeCOAlarmAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SmokeCOAlarmEventListListAttributeCallback)(void * context,
                                                           const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*SmokeCOAlarmAttributeListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*OperationalStatePhaseListListAttributeCallback)(
    void * context, const chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<chip::CharSpan>> & data);
typedef void (*OperationalStateOperationalStateListListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<
        chip::app::Clusters::OperationalState::Structs::OperationalStateStruct::DecodableType> & data);
typedef void (*OperationalStateOperationalStateStructAttributeCallback)(
    void *, const chip::app::Clusters::OperationalState::Structs::OperationalStateStruct::DecodableType &);
typedef void (*OperationalStateOperationalErrorStructAttributeCallback)(
    void *, const chip::app::Clusters::OperationalState::Structs::ErrorStateStruct::DecodableType &);
typedef void (*OperationalStateGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OperationalStateAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OperationalStateEventListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*OperationalStateAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*HEPAFilterMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*HEPAFilterMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*HEPAFilterMonitoringEventListListAttributeCallback)(void * context,
                                                                   const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*HEPAFilterMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ActivatedCarbonFilterMonitoringEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ActivatedCarbonFilterMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*CeramicFilterMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*CeramicFilterMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*CeramicFilterMonitoringEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*CeramicFilterMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ElectrostaticFilterMonitoringEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ElectrostaticFilterMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*UVFilterMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*UVFilterMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*UVFilterMonitoringEventListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*UVFilterMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*IonizingFilterMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*IonizingFilterMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*IonizingFilterMonitoringEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*IonizingFilterMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ZeoliteFilterMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ZeoliteFilterMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ZeoliteFilterMonitoringEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ZeoliteFilterMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*OzoneFilterMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OzoneFilterMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OzoneFilterMonitoringEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*OzoneFilterMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*WaterTankMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*WaterTankMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*WaterTankMonitoringEventListListAttributeCallback)(void * context,
                                                                  const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*WaterTankMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*FuelTankMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FuelTankMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FuelTankMonitoringEventListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*FuelTankMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*InkCartridgeMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*InkCartridgeMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*InkCartridgeMonitoringEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*InkCartridgeMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*TonerCartridgeMonitoringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TonerCartridgeMonitoringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TonerCartridgeMonitoringEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*TonerCartridgeMonitoringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*DoorLockCredentialRulesSupportAttributeCallback)(void *,
                                                                chip::BitMask<chip::app::Clusters::DoorLock::DlCredentialRuleMask>);
typedef void (*DoorLockSupportedOperatingModesAttributeCallback)(
    void *, chip::BitMask<chip::app::Clusters::DoorLock::DlSupportedOperatingModes>);
typedef void (*DoorLockDefaultConfigurationRegisterAttributeCallback)(
    void *, chip::BitMask<chip::app::Clusters::DoorLock::DlDefaultConfigurationRegister>);
typedef void (*DoorLockLocalProgrammingFeaturesAttributeCallback)(
    void *, chip::BitMask<chip::app::Clusters::DoorLock::DlLocalProgrammingFeatures>);
typedef void (*DoorLockGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*DoorLockAcceptedCommandListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*DoorLockEventListListAttributeCallback)(void * context,
                                                       const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*DoorLockAttributeListListAttributeCallback)(void * context,
                                                           const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*WindowCoveringConfigStatusAttributeCallback)(void *,
                                                            chip::BitMask<chip::app::Clusters::WindowCovering::ConfigStatus>);
typedef void (*WindowCoveringOperationalStatusAttributeCallback)(
    void *, chip::BitMask<chip::app::Clusters::WindowCovering::OperationalStatus>);
typedef void (*WindowCoveringModeAttributeCallback)(void *, chip::BitMask<chip::app::Clusters::WindowCovering::Mode>);
typedef void (*WindowCoveringSafetyStatusAttributeCallback)(void *,
                                                            chip::BitMask<chip::app::Clusters::WindowCovering::SafetyStatus>);
typedef void (*WindowCoveringGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*WindowCoveringAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*WindowCoveringEventListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*WindowCoveringAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*BarrierControlGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BarrierControlAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BarrierControlEventListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BarrierControlAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*PumpConfigurationAndControlPumpStatusAttributeCallback)(
    void *, chip::BitMask<chip::app::Clusters::PumpConfigurationAndControl::PumpStatusBitmap>);
typedef void (*PumpConfigurationAndControlGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PumpConfigurationAndControlAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PumpConfigurationAndControlEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*PumpConfigurationAndControlAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ThermostatGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ThermostatAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ThermostatEventListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ThermostatAttributeListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*FanControlGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FanControlAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FanControlEventListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*FanControlAttributeListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ThermostatUserInterfaceConfigurationEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ThermostatUserInterfaceConfigurationAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ColorControlGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ColorControlAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ColorControlEventListListAttributeCallback)(void * context,
                                                           const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ColorControlAttributeListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*BallastConfigurationGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BallastConfigurationAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BallastConfigurationEventListListAttributeCallback)(void * context,
                                                                   const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BallastConfigurationAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*IlluminanceMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*IlluminanceMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*IlluminanceMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*IlluminanceMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*TemperatureMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TemperatureMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TemperatureMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*TemperatureMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*PressureMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PressureMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PressureMeasurementEventListListAttributeCallback)(void * context,
                                                                  const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*PressureMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*FlowMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FlowMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FlowMeasurementEventListListAttributeCallback)(void * context,
                                                              const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*FlowMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*RelativeHumidityMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*RelativeHumidityMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*RelativeHumidityMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*RelativeHumidityMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*OccupancySensingOccupancyAttributeCallback)(void *,
                                                           chip::BitMask<chip::app::Clusters::OccupancySensing::OccupancyBitmap>);
typedef void (*OccupancySensingOccupancySensorTypeBitmapAttributeCallback)(
    void *, chip::BitMask<chip::app::Clusters::OccupancySensing::OccupancySensorTypeBitmap>);
typedef void (*OccupancySensingGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OccupancySensingAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OccupancySensingEventListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*OccupancySensingAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*CarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*CarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*CarbonMonoxideConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*CarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*CarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*CarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*CarbonDioxideConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*CarbonDioxideConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*EthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*EthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*EthyleneConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*EthyleneConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*EthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*EthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*EthyleneOxideConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*EthyleneOxideConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*HydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*HydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*HydrogenConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*HydrogenConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*HydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*HydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*HydrogenSulfideConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*HydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*NitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*NitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*NitricOxideConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*NitricOxideConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*NitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*NitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*NitrogenDioxideConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*NitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*OxygenConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OxygenConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OxygenConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*OxygenConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*OzoneConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OzoneConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*OzoneConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*OzoneConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*SulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SulfurDioxideConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*SulfurDioxideConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*DissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*DissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*DissolvedOxygenConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*DissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*BromateConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BromateConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BromateConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BromateConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ChloraminesConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ChloraminesConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ChlorineConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ChlorineConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*FecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FecalColiformEColiConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*FecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*FluorideConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FluorideConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FluorideConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*FluorideConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*HaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*HaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*HaloaceticAcidsConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*HaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*TotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*TotalTrihalomethanesConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*TotalColiformBacteriaConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TotalColiformBacteriaConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TotalColiformBacteriaConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*TotalColiformBacteriaConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*TurbidityConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TurbidityConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TurbidityConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*TurbidityConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*CopperConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*CopperConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*CopperConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*CopperConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*LeadConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*LeadConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*LeadConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*LeadConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ManganeseConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ManganeseConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ManganeseConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ManganeseConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*SulfateConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SulfateConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SulfateConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*SulfateConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*BromodichloromethaneConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BromodichloromethaneConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BromodichloromethaneConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BromodichloromethaneConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*BromoformConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BromoformConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*BromoformConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*BromoformConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ChlorodibromomethaneConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ChlorodibromomethaneConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ChlorodibromomethaneConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ChlorodibromomethaneConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ChloroformConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ChloroformConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ChloroformConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ChloroformConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*SodiumConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SodiumConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*SodiumConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*SodiumConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*PM25ConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PM25ConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PM25ConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*PM25ConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*FormaldehydeConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FormaldehydeConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*FormaldehydeConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*FormaldehydeConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*PM1ConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PM1ConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PM1ConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*PM1ConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*PM10ConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PM10ConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*PM10ConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*PM10ConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*TotalVolatileOrganicCompoundsConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TotalVolatileOrganicCompoundsConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TotalVolatileOrganicCompoundsConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*TotalVolatileOrganicCompoundsConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*RadonConcentrationMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*RadonConcentrationMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*RadonConcentrationMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*RadonConcentrationMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*WakeOnLANGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*WakeOnLANAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*WakeOnLANEventListListAttributeCallback)(void * context,
                                                        const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*WakeOnLANAttributeListListAttributeCallback)(void * context,
                                                            const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ChannelChannelListListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::Channel::Structs::ChannelInfoStruct::DecodableType> & data);
typedef void (*ChannelLineupStructAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Channel::Structs::LineupInfoStruct::DecodableType> &);
typedef void (*ChannelCurrentChannelStructAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::Channel::Structs::ChannelInfoStruct::DecodableType> &);
typedef void (*ChannelGeneratedCommandListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ChannelAcceptedCommandListListAttributeCallback)(void * context,
                                                                const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ChannelEventListListAttributeCallback)(void * context,
                                                      const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ChannelAttributeListListAttributeCallback)(void * context,
                                                          const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*TargetNavigatorTargetListListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::TargetNavigator::Structs::TargetInfoStruct::DecodableType> &
        data);
typedef void (*TargetNavigatorGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TargetNavigatorAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*TargetNavigatorEventListListAttributeCallback)(void * context,
                                                              const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*TargetNavigatorAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*MediaPlaybackSampledPositionStructAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::MediaPlayback::Structs::PlaybackPositionStruct::DecodableType> &);
typedef void (*MediaPlaybackGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*MediaPlaybackAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*MediaPlaybackEventListListAttributeCallback)(void * context,
                                                            const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*MediaPlaybackAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*MediaInputInputListListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::MediaInput::Structs::InputInfoStruct::DecodableType> & data);
typedef void (*MediaInputGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*MediaInputAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*MediaInputEventListListAttributeCallback)(void * context,
                                                         const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*MediaInputAttributeListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*LowPowerGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*LowPowerAcceptedCommandListListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*LowPowerEventListListAttributeCallback)(void * context,
                                                       const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*LowPowerAttributeListListAttributeCallback)(void * context,
                                                           const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*KeypadInputGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*KeypadInputAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*KeypadInputEventListListAttributeCallback)(void * context,
                                                          const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*KeypadInputAttributeListListAttributeCallback)(void * context,
                                                              const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ContentLauncherAcceptHeaderListAttributeCallback)(void * context,
                                                                 const chip::app::DataModel::DecodableList<chip::CharSpan> & data);
typedef void (*ContentLauncherGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ContentLauncherAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ContentLauncherEventListListAttributeCallback)(void * context,
                                                              const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ContentLauncherAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*AudioOutputOutputListListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::AudioOutput::Structs::OutputInfoStruct::DecodableType> & data);
typedef void (*AudioOutputGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*AudioOutputAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*AudioOutputEventListListAttributeCallback)(void * context,
                                                          const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*AudioOutputAttributeListListAttributeCallback)(void * context,
                                                              const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ApplicationLauncherCatalogListListAttributeCallback)(void * context,
                                                                    const chip::app::DataModel::DecodableList<uint16_t> & data);
typedef void (*ApplicationLauncherCurrentAppStructAttributeCallback)(
    void *,
    const chip::app::DataModel::Nullable<chip::app::Clusters::ApplicationLauncher::Structs::ApplicationEPStruct::DecodableType> &);
typedef void (*ApplicationLauncherGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ApplicationLauncherAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ApplicationLauncherEventListListAttributeCallback)(void * context,
                                                                  const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ApplicationLauncherAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ApplicationBasicApplicationStructAttributeCallback)(
    void *, const chip::app::Clusters::ApplicationBasic::Structs::ApplicationStruct::DecodableType &);
typedef void (*ApplicationBasicAllowedVendorListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::VendorId> & data);
typedef void (*ApplicationBasicGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ApplicationBasicAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ApplicationBasicEventListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ApplicationBasicAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*AccountLoginGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*AccountLoginAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*AccountLoginEventListListAttributeCallback)(void * context,
                                                           const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*AccountLoginAttributeListListAttributeCallback)(void * context,
                                                               const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*ElectricalMeasurementGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ElectricalMeasurementAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*ElectricalMeasurementEventListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*ElectricalMeasurementAttributeListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*UnitTestingBitmap8AttributeCallback)(void *, chip::BitMask<chip::app::Clusters::UnitTesting::Bitmap8MaskMap>);
typedef void (*UnitTestingBitmap16AttributeCallback)(void *, chip::BitMask<chip::app::Clusters::UnitTesting::Bitmap16MaskMap>);
typedef void (*UnitTestingBitmap32AttributeCallback)(void *, chip::BitMask<chip::app::Clusters::UnitTesting::Bitmap32MaskMap>);
typedef void (*UnitTestingBitmap64AttributeCallback)(void *, chip::BitMask<chip::app::Clusters::UnitTesting::Bitmap64MaskMap>);
typedef void (*UnitTestingListInt8uListAttributeCallback)(void * context,
                                                          const chip::app::DataModel::DecodableList<uint8_t> & data);
typedef void (*UnitTestingListOctetStringListAttributeCallback)(void * context,
                                                                const chip::app::DataModel::DecodableList<chip::ByteSpan> & data);
typedef void (*UnitTestingListStructOctetStringListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::UnitTesting::Structs::TestListStructOctet::DecodableType> &
        data);
typedef void (*UnitTestingListNullablesAndOptionalsStructListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<
        chip::app::Clusters::UnitTesting::Structs::NullablesAndOptionalsStruct::DecodableType> & data);
typedef void (*UnitTestingStructAttrStructAttributeCallback)(
    void *, const chip::app::Clusters::UnitTesting::Structs::SimpleStruct::DecodableType &);
typedef void (*UnitTestingListLongOctetStringListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::ByteSpan> & data);
typedef void (*UnitTestingListFabricScopedListAttributeCallback)(
    void * context,
    const chip::app::DataModel::DecodableList<chip::app::Clusters::UnitTesting::Structs::TestFabricScoped::DecodableType> & data);
typedef void (*UnitTestingNullableBitmap8AttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::BitMask<chip::app::Clusters::UnitTesting::Bitmap8MaskMap>> &);
typedef void (*UnitTestingNullableBitmap16AttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::BitMask<chip::app::Clusters::UnitTesting::Bitmap16MaskMap>> &);
typedef void (*UnitTestingNullableBitmap32AttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::BitMask<chip::app::Clusters::UnitTesting::Bitmap32MaskMap>> &);
typedef void (*UnitTestingNullableBitmap64AttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::BitMask<chip::app::Clusters::UnitTesting::Bitmap64MaskMap>> &);
typedef void (*UnitTestingNullableStructStructAttributeCallback)(
    void *, const chip::app::DataModel::Nullable<chip::app::Clusters::UnitTesting::Structs::SimpleStruct::DecodableType> &);
typedef void (*UnitTestingGeneratedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*UnitTestingAcceptedCommandListListAttributeCallback)(
    void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & data);
typedef void (*UnitTestingEventListListAttributeCallback)(void * context,
                                                          const chip::app::DataModel::DecodableList<chip::EventId> & data);
typedef void (*UnitTestingAttributeListListAttributeCallback)(void * context,
                                                              const chip::app::DataModel::DecodableList<chip::AttributeId> & data);
typedef void (*FaultInjectionEventListListAttributeCallback)(void * context,
                                                             const chip::app::DataModel::DecodableList<chip::EventId> & data);

class MTRDefaultSuccessCallbackBridge : public MTRCallbackBridge<DefaultSuccessCallback>
{
public:
    MTRDefaultSuccessCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DefaultSuccessCallback>(queue, handler, OnSuccessFn){};

    MTRDefaultSuccessCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<DefaultSuccessCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context);
};

class MTRCommandSuccessCallbackBridge : public MTRCallbackBridge<CommandSuccessCallback>
{
public:
    MTRCommandSuccessCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<CommandSuccessCallback>(queue, handler, OnSuccessFn){};

    MTRCommandSuccessCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<CommandSuccessCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::NullObjectType &);
};

class MTROctetStringAttributeCallbackBridge : public MTRCallbackBridge<OctetStringAttributeCallback>
{
public:
    MTROctetStringAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OctetStringAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROctetStringAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<OctetStringAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::ByteSpan value);
};

class MTROctetStringAttributeCallbackSubscriptionBridge : public MTROctetStringAttributeCallbackBridge
{
public:
    MTROctetStringAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                      MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROctetStringAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROctetStringAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROctetStringAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableOctetStringAttributeCallbackBridge : public MTRCallbackBridge<NullableOctetStringAttributeCallback>
{
public:
    MTRNullableOctetStringAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableOctetStringAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableOctetStringAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableOctetStringAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<chip::ByteSpan> & value);
};

class MTRNullableOctetStringAttributeCallbackSubscriptionBridge : public MTRNullableOctetStringAttributeCallbackBridge
{
public:
    MTRNullableOctetStringAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action,
                                                              MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableOctetStringAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableOctetStringAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableOctetStringAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCharStringAttributeCallbackBridge : public MTRCallbackBridge<CharStringAttributeCallback>
{
public:
    MTRCharStringAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<CharStringAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRCharStringAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<CharStringAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::CharSpan value);
};

class MTRCharStringAttributeCallbackSubscriptionBridge : public MTRCharStringAttributeCallbackBridge
{
public:
    MTRCharStringAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                     MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCharStringAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCharStringAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCharStringAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableCharStringAttributeCallbackBridge : public MTRCallbackBridge<NullableCharStringAttributeCallback>
{
public:
    MTRNullableCharStringAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableCharStringAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableCharStringAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableCharStringAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<chip::CharSpan> & value);
};

class MTRNullableCharStringAttributeCallbackSubscriptionBridge : public MTRNullableCharStringAttributeCallbackBridge
{
public:
    MTRNullableCharStringAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableCharStringAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableCharStringAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableCharStringAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBooleanAttributeCallbackBridge : public MTRCallbackBridge<BooleanAttributeCallback>
{
public:
    MTRBooleanAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BooleanAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBooleanAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<BooleanAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, bool value);
};

class MTRBooleanAttributeCallbackSubscriptionBridge : public MTRBooleanAttributeCallbackBridge
{
public:
    MTRBooleanAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBooleanAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBooleanAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBooleanAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableBooleanAttributeCallbackBridge : public MTRCallbackBridge<NullableBooleanAttributeCallback>
{
public:
    MTRNullableBooleanAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableBooleanAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableBooleanAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableBooleanAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<bool> & value);
};

class MTRNullableBooleanAttributeCallbackSubscriptionBridge : public MTRNullableBooleanAttributeCallbackBridge
{
public:
    MTRNullableBooleanAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableBooleanAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableBooleanAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableBooleanAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInt8uAttributeCallbackBridge : public MTRCallbackBridge<Int8uAttributeCallback>
{
public:
    MTRInt8uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<Int8uAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInt8uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<Int8uAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, uint8_t value);
};

class MTRInt8uAttributeCallbackSubscriptionBridge : public MTRInt8uAttributeCallbackBridge
{
public:
    MTRInt8uAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInt8uAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInt8uAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInt8uAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableInt8uAttributeCallbackBridge : public MTRCallbackBridge<NullableInt8uAttributeCallback>
{
public:
    MTRNullableInt8uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableInt8uAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableInt8uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableInt8uAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<uint8_t> & value);
};

class MTRNullableInt8uAttributeCallbackSubscriptionBridge : public MTRNullableInt8uAttributeCallbackBridge
{
public:
    MTRNullableInt8uAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableInt8uAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableInt8uAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableInt8uAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInt8sAttributeCallbackBridge : public MTRCallbackBridge<Int8sAttributeCallback>
{
public:
    MTRInt8sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<Int8sAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInt8sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<Int8sAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, int8_t value);
};

class MTRInt8sAttributeCallbackSubscriptionBridge : public MTRInt8sAttributeCallbackBridge
{
public:
    MTRInt8sAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInt8sAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInt8sAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInt8sAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableInt8sAttributeCallbackBridge : public MTRCallbackBridge<NullableInt8sAttributeCallback>
{
public:
    MTRNullableInt8sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableInt8sAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableInt8sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableInt8sAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<int8_t> & value);
};

class MTRNullableInt8sAttributeCallbackSubscriptionBridge : public MTRNullableInt8sAttributeCallbackBridge
{
public:
    MTRNullableInt8sAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableInt8sAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableInt8sAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableInt8sAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInt16uAttributeCallbackBridge : public MTRCallbackBridge<Int16uAttributeCallback>
{
public:
    MTRInt16uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<Int16uAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInt16uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<Int16uAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, uint16_t value);
};

class MTRInt16uAttributeCallbackSubscriptionBridge : public MTRInt16uAttributeCallbackBridge
{
public:
    MTRInt16uAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInt16uAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInt16uAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInt16uAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableInt16uAttributeCallbackBridge : public MTRCallbackBridge<NullableInt16uAttributeCallback>
{
public:
    MTRNullableInt16uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableInt16uAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableInt16uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableInt16uAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<uint16_t> & value);
};

class MTRNullableInt16uAttributeCallbackSubscriptionBridge : public MTRNullableInt16uAttributeCallbackBridge
{
public:
    MTRNullableInt16uAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableInt16uAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableInt16uAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableInt16uAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInt16sAttributeCallbackBridge : public MTRCallbackBridge<Int16sAttributeCallback>
{
public:
    MTRInt16sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<Int16sAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInt16sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<Int16sAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, int16_t value);
};

class MTRInt16sAttributeCallbackSubscriptionBridge : public MTRInt16sAttributeCallbackBridge
{
public:
    MTRInt16sAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInt16sAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInt16sAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInt16sAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableInt16sAttributeCallbackBridge : public MTRCallbackBridge<NullableInt16sAttributeCallback>
{
public:
    MTRNullableInt16sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableInt16sAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableInt16sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableInt16sAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<int16_t> & value);
};

class MTRNullableInt16sAttributeCallbackSubscriptionBridge : public MTRNullableInt16sAttributeCallbackBridge
{
public:
    MTRNullableInt16sAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableInt16sAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableInt16sAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableInt16sAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInt32uAttributeCallbackBridge : public MTRCallbackBridge<Int32uAttributeCallback>
{
public:
    MTRInt32uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<Int32uAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInt32uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<Int32uAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, uint32_t value);
};

class MTRInt32uAttributeCallbackSubscriptionBridge : public MTRInt32uAttributeCallbackBridge
{
public:
    MTRInt32uAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInt32uAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInt32uAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInt32uAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableInt32uAttributeCallbackBridge : public MTRCallbackBridge<NullableInt32uAttributeCallback>
{
public:
    MTRNullableInt32uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableInt32uAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableInt32uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableInt32uAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<uint32_t> & value);
};

class MTRNullableInt32uAttributeCallbackSubscriptionBridge : public MTRNullableInt32uAttributeCallbackBridge
{
public:
    MTRNullableInt32uAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableInt32uAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableInt32uAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableInt32uAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInt32sAttributeCallbackBridge : public MTRCallbackBridge<Int32sAttributeCallback>
{
public:
    MTRInt32sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<Int32sAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInt32sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<Int32sAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, int32_t value);
};

class MTRInt32sAttributeCallbackSubscriptionBridge : public MTRInt32sAttributeCallbackBridge
{
public:
    MTRInt32sAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInt32sAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInt32sAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInt32sAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableInt32sAttributeCallbackBridge : public MTRCallbackBridge<NullableInt32sAttributeCallback>
{
public:
    MTRNullableInt32sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableInt32sAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableInt32sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableInt32sAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<int32_t> & value);
};

class MTRNullableInt32sAttributeCallbackSubscriptionBridge : public MTRNullableInt32sAttributeCallbackBridge
{
public:
    MTRNullableInt32sAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableInt32sAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableInt32sAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableInt32sAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInt64uAttributeCallbackBridge : public MTRCallbackBridge<Int64uAttributeCallback>
{
public:
    MTRInt64uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<Int64uAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInt64uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<Int64uAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, uint64_t value);
};

class MTRInt64uAttributeCallbackSubscriptionBridge : public MTRInt64uAttributeCallbackBridge
{
public:
    MTRInt64uAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInt64uAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInt64uAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInt64uAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableInt64uAttributeCallbackBridge : public MTRCallbackBridge<NullableInt64uAttributeCallback>
{
public:
    MTRNullableInt64uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableInt64uAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableInt64uAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableInt64uAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<uint64_t> & value);
};

class MTRNullableInt64uAttributeCallbackSubscriptionBridge : public MTRNullableInt64uAttributeCallbackBridge
{
public:
    MTRNullableInt64uAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableInt64uAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableInt64uAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableInt64uAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInt64sAttributeCallbackBridge : public MTRCallbackBridge<Int64sAttributeCallback>
{
public:
    MTRInt64sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<Int64sAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInt64sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<Int64sAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, int64_t value);
};

class MTRInt64sAttributeCallbackSubscriptionBridge : public MTRInt64sAttributeCallbackBridge
{
public:
    MTRInt64sAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInt64sAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInt64sAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInt64sAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableInt64sAttributeCallbackBridge : public MTRCallbackBridge<NullableInt64sAttributeCallback>
{
public:
    MTRNullableInt64sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableInt64sAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableInt64sAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableInt64sAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<int64_t> & value);
};

class MTRNullableInt64sAttributeCallbackSubscriptionBridge : public MTRNullableInt64sAttributeCallbackBridge
{
public:
    MTRNullableInt64sAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableInt64sAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableInt64sAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableInt64sAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFloatAttributeCallbackBridge : public MTRCallbackBridge<FloatAttributeCallback>
{
public:
    MTRFloatAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FloatAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFloatAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<FloatAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, float value);
};

class MTRFloatAttributeCallbackSubscriptionBridge : public MTRFloatAttributeCallbackBridge
{
public:
    MTRFloatAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFloatAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFloatAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFloatAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableFloatAttributeCallbackBridge : public MTRCallbackBridge<NullableFloatAttributeCallback>
{
public:
    MTRNullableFloatAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableFloatAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableFloatAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableFloatAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<float> & value);
};

class MTRNullableFloatAttributeCallbackSubscriptionBridge : public MTRNullableFloatAttributeCallbackBridge
{
public:
    MTRNullableFloatAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableFloatAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableFloatAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableFloatAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDoubleAttributeCallbackBridge : public MTRCallbackBridge<DoubleAttributeCallback>
{
public:
    MTRDoubleAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DoubleAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDoubleAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<DoubleAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, double value);
};

class MTRDoubleAttributeCallbackSubscriptionBridge : public MTRDoubleAttributeCallbackBridge
{
public:
    MTRDoubleAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDoubleAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDoubleAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDoubleAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableDoubleAttributeCallbackBridge : public MTRCallbackBridge<NullableDoubleAttributeCallback>
{
public:
    MTRNullableDoubleAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableDoubleAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableDoubleAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableDoubleAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<double> & value);
};

class MTRNullableDoubleAttributeCallbackSubscriptionBridge : public MTRNullableDoubleAttributeCallbackBridge
{
public:
    MTRNullableDoubleAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableDoubleAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableDoubleAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableDoubleAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRVendorIdAttributeCallbackBridge : public MTRCallbackBridge<VendorIdAttributeCallback>
{
public:
    MTRVendorIdAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<VendorIdAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRVendorIdAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<VendorIdAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::VendorId value);
};

class MTRVendorIdAttributeCallbackSubscriptionBridge : public MTRVendorIdAttributeCallbackBridge
{
public:
    MTRVendorIdAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                   MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRVendorIdAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRVendorIdAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRVendorIdAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNullableVendorIdAttributeCallbackBridge : public MTRCallbackBridge<NullableVendorIdAttributeCallback>
{
public:
    MTRNullableVendorIdAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NullableVendorIdAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNullableVendorIdAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<NullableVendorIdAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::Nullable<chip::VendorId> & value);
};

class MTRNullableVendorIdAttributeCallbackSubscriptionBridge : public MTRNullableVendorIdAttributeCallbackBridge
{
public:
    MTRNullableVendorIdAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNullableVendorIdAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNullableVendorIdAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNullableVendorIdAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIdentifyGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<IdentifyGeneratedCommandListListAttributeCallback>
{
public:
    MTRIdentifyGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IdentifyGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIdentifyGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<IdentifyGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRIdentifyGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRIdentifyGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRIdentifyGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIdentifyGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIdentifyGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIdentifyGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIdentifyAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<IdentifyAcceptedCommandListListAttributeCallback>
{
public:
    MTRIdentifyAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IdentifyAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIdentifyAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<IdentifyAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRIdentifyAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRIdentifyAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRIdentifyAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIdentifyAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIdentifyAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIdentifyAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIdentifyEventListListAttributeCallbackBridge : public MTRCallbackBridge<IdentifyEventListListAttributeCallback>
{
public:
    MTRIdentifyEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IdentifyEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIdentifyEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<IdentifyEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRIdentifyEventListListAttributeCallbackSubscriptionBridge : public MTRIdentifyEventListListAttributeCallbackBridge
{
public:
    MTRIdentifyEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action,
                                                                MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIdentifyEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIdentifyEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIdentifyEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIdentifyAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<IdentifyAttributeListListAttributeCallback>
{
public:
    MTRIdentifyAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IdentifyAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIdentifyAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<IdentifyAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRIdentifyAttributeListListAttributeCallbackSubscriptionBridge : public MTRIdentifyAttributeListListAttributeCallbackBridge
{
public:
    MTRIdentifyAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action,
                                                                    MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIdentifyAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIdentifyAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIdentifyAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGroupsNameSupportAttributeCallbackBridge : public MTRCallbackBridge<GroupsNameSupportAttributeCallback>
{
public:
    MTRGroupsNameSupportAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GroupsNameSupportAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGroupsNameSupportAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<GroupsNameSupportAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::Groups::NameSupportBitmap> value);
};

class MTRGroupsNameSupportAttributeCallbackSubscriptionBridge : public MTRGroupsNameSupportAttributeCallbackBridge
{
public:
    MTRGroupsNameSupportAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGroupsNameSupportAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGroupsNameSupportAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGroupsNameSupportAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGroupsGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<GroupsGeneratedCommandListListAttributeCallback>
{
public:
    MTRGroupsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GroupsGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGroupsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                             MTRActionBlock action) :
        MTRCallbackBridge<GroupsGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRGroupsGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRGroupsGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRGroupsGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action,
                                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGroupsGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGroupsGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGroupsGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGroupsAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<GroupsAcceptedCommandListListAttributeCallback>
{
public:
    MTRGroupsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GroupsAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGroupsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<GroupsAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRGroupsAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRGroupsAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRGroupsAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGroupsAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGroupsAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGroupsAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGroupsEventListListAttributeCallbackBridge : public MTRCallbackBridge<GroupsEventListListAttributeCallback>
{
public:
    MTRGroupsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GroupsEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGroupsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<GroupsEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRGroupsEventListListAttributeCallbackSubscriptionBridge : public MTRGroupsEventListListAttributeCallbackBridge
{
public:
    MTRGroupsEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action,
                                                              MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGroupsEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGroupsEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGroupsEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGroupsAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<GroupsAttributeListListAttributeCallback>
{
public:
    MTRGroupsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GroupsAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGroupsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<GroupsAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRGroupsAttributeListListAttributeCallbackSubscriptionBridge : public MTRGroupsAttributeListListAttributeCallbackBridge
{
public:
    MTRGroupsAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGroupsAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGroupsAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGroupsAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRScenesGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ScenesGeneratedCommandListListAttributeCallback>
{
public:
    MTRScenesGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ScenesGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRScenesGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                             MTRActionBlock action) :
        MTRCallbackBridge<ScenesGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRScenesGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRScenesGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRScenesGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action,
                                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRScenesGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRScenesGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRScenesGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRScenesAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ScenesAcceptedCommandListListAttributeCallback>
{
public:
    MTRScenesAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ScenesAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRScenesAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<ScenesAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRScenesAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRScenesAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRScenesAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRScenesAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRScenesAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRScenesAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRScenesEventListListAttributeCallbackBridge : public MTRCallbackBridge<ScenesEventListListAttributeCallback>
{
public:
    MTRScenesEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ScenesEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRScenesEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ScenesEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRScenesEventListListAttributeCallbackSubscriptionBridge : public MTRScenesEventListListAttributeCallbackBridge
{
public:
    MTRScenesEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action,
                                                              MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRScenesEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRScenesEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRScenesEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRScenesAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<ScenesAttributeListListAttributeCallback>
{
public:
    MTRScenesAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ScenesAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRScenesAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ScenesAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRScenesAttributeListListAttributeCallbackSubscriptionBridge : public MTRScenesAttributeListListAttributeCallbackBridge
{
public:
    MTRScenesAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRScenesAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRScenesAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRScenesAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROnOffGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OnOffGeneratedCommandListListAttributeCallback>
{
public:
    MTROnOffGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OnOffGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROnOffGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<OnOffGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROnOffGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROnOffGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTROnOffGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROnOffGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROnOffGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROnOffGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROnOffAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OnOffAcceptedCommandListListAttributeCallback>
{
public:
    MTROnOffAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OnOffAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROnOffAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<OnOffAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROnOffAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROnOffAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTROnOffAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action,
                                                                       MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROnOffAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROnOffAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROnOffAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROnOffEventListListAttributeCallbackBridge : public MTRCallbackBridge<OnOffEventListListAttributeCallback>
{
public:
    MTROnOffEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OnOffEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROnOffEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<OnOffEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTROnOffEventListListAttributeCallbackSubscriptionBridge : public MTROnOffEventListListAttributeCallbackBridge
{
public:
    MTROnOffEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROnOffEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROnOffEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROnOffEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROnOffAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<OnOffAttributeListListAttributeCallback>
{
public:
    MTROnOffAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OnOffAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROnOffAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<OnOffAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTROnOffAttributeListListAttributeCallbackSubscriptionBridge : public MTROnOffAttributeListListAttributeCallbackBridge
{
public:
    MTROnOffAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action,
                                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROnOffAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROnOffAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROnOffAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROnOffSwitchConfigurationGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OnOffSwitchConfigurationGeneratedCommandListListAttributeCallback>
{
public:
    MTROnOffSwitchConfigurationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OnOffSwitchConfigurationGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROnOffSwitchConfigurationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<OnOffSwitchConfigurationGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROnOffSwitchConfigurationGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROnOffSwitchConfigurationGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTROnOffSwitchConfigurationGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROnOffSwitchConfigurationGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROnOffSwitchConfigurationGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROnOffSwitchConfigurationGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROnOffSwitchConfigurationAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OnOffSwitchConfigurationAcceptedCommandListListAttributeCallback>
{
public:
    MTROnOffSwitchConfigurationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OnOffSwitchConfigurationAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROnOffSwitchConfigurationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                              MTRActionBlock action) :
        MTRCallbackBridge<OnOffSwitchConfigurationAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROnOffSwitchConfigurationAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROnOffSwitchConfigurationAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTROnOffSwitchConfigurationAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROnOffSwitchConfigurationAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROnOffSwitchConfigurationAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROnOffSwitchConfigurationAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROnOffSwitchConfigurationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<OnOffSwitchConfigurationEventListListAttributeCallback>
{
public:
    MTROnOffSwitchConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OnOffSwitchConfigurationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROnOffSwitchConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<OnOffSwitchConfigurationEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTROnOffSwitchConfigurationEventListListAttributeCallbackSubscriptionBridge
    : public MTROnOffSwitchConfigurationEventListListAttributeCallbackBridge
{
public:
    MTROnOffSwitchConfigurationEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROnOffSwitchConfigurationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROnOffSwitchConfigurationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROnOffSwitchConfigurationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROnOffSwitchConfigurationAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<OnOffSwitchConfigurationAttributeListListAttributeCallback>
{
public:
    MTROnOffSwitchConfigurationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OnOffSwitchConfigurationAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROnOffSwitchConfigurationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<OnOffSwitchConfigurationAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTROnOffSwitchConfigurationAttributeListListAttributeCallbackSubscriptionBridge
    : public MTROnOffSwitchConfigurationAttributeListListAttributeCallbackBridge
{
public:
    MTROnOffSwitchConfigurationAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROnOffSwitchConfigurationAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROnOffSwitchConfigurationAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROnOffSwitchConfigurationAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRLevelControlOptionsAttributeCallbackBridge : public MTRCallbackBridge<LevelControlOptionsAttributeCallback>
{
public:
    MTRLevelControlOptionsAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<LevelControlOptionsAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRLevelControlOptionsAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<LevelControlOptionsAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::LevelControl::LevelControlOptions> value);
};

class MTRLevelControlOptionsAttributeCallbackSubscriptionBridge : public MTRLevelControlOptionsAttributeCallbackBridge
{
public:
    MTRLevelControlOptionsAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action,
                                                              MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRLevelControlOptionsAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRLevelControlOptionsAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRLevelControlOptionsAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRLevelControlGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<LevelControlGeneratedCommandListListAttributeCallback>
{
public:
    MTRLevelControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<LevelControlGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRLevelControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<LevelControlGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRLevelControlGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRLevelControlGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRLevelControlGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRLevelControlGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRLevelControlGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRLevelControlGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRLevelControlAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<LevelControlAcceptedCommandListListAttributeCallback>
{
public:
    MTRLevelControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<LevelControlAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRLevelControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<LevelControlAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRLevelControlAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRLevelControlAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRLevelControlAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRLevelControlAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRLevelControlAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRLevelControlAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRLevelControlEventListListAttributeCallbackBridge : public MTRCallbackBridge<LevelControlEventListListAttributeCallback>
{
public:
    MTRLevelControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<LevelControlEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRLevelControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<LevelControlEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRLevelControlEventListListAttributeCallbackSubscriptionBridge : public MTRLevelControlEventListListAttributeCallbackBridge
{
public:
    MTRLevelControlEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action,
                                                                    MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRLevelControlEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRLevelControlEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRLevelControlEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRLevelControlAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<LevelControlAttributeListListAttributeCallback>
{
public:
    MTRLevelControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<LevelControlAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRLevelControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<LevelControlAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRLevelControlAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRLevelControlAttributeListListAttributeCallbackBridge
{
public:
    MTRLevelControlAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRLevelControlAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRLevelControlAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRLevelControlAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBinaryInputBasicGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BinaryInputBasicGeneratedCommandListListAttributeCallback>
{
public:
    MTRBinaryInputBasicGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BinaryInputBasicGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBinaryInputBasicGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action) :
        MTRCallbackBridge<BinaryInputBasicGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBinaryInputBasicGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBinaryInputBasicGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRBinaryInputBasicGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBinaryInputBasicGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBinaryInputBasicGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBinaryInputBasicGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBinaryInputBasicAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BinaryInputBasicAcceptedCommandListListAttributeCallback>
{
public:
    MTRBinaryInputBasicAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BinaryInputBasicAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBinaryInputBasicAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<BinaryInputBasicAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBinaryInputBasicAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBinaryInputBasicAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRBinaryInputBasicAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBinaryInputBasicAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBinaryInputBasicAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBinaryInputBasicAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBinaryInputBasicEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<BinaryInputBasicEventListListAttributeCallback>
{
public:
    MTRBinaryInputBasicEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BinaryInputBasicEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBinaryInputBasicEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<BinaryInputBasicEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRBinaryInputBasicEventListListAttributeCallbackSubscriptionBridge
    : public MTRBinaryInputBasicEventListListAttributeCallbackBridge
{
public:
    MTRBinaryInputBasicEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBinaryInputBasicEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBinaryInputBasicEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBinaryInputBasicEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBinaryInputBasicAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<BinaryInputBasicAttributeListListAttributeCallback>
{
public:
    MTRBinaryInputBasicAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BinaryInputBasicAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBinaryInputBasicAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<BinaryInputBasicAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRBinaryInputBasicAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRBinaryInputBasicAttributeListListAttributeCallbackBridge
{
public:
    MTRBinaryInputBasicAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBinaryInputBasicAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBinaryInputBasicAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBinaryInputBasicAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPulseWidthModulationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<PulseWidthModulationEventListListAttributeCallback>
{
public:
    MTRPulseWidthModulationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PulseWidthModulationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPulseWidthModulationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<PulseWidthModulationEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRPulseWidthModulationEventListListAttributeCallbackSubscriptionBridge
    : public MTRPulseWidthModulationEventListListAttributeCallbackBridge
{
public:
    MTRPulseWidthModulationEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPulseWidthModulationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPulseWidthModulationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPulseWidthModulationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDescriptorDeviceTypeListListAttributeCallbackBridge
    : public MTRCallbackBridge<DescriptorDeviceTypeListListAttributeCallback>
{
public:
    MTRDescriptorDeviceTypeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DescriptorDeviceTypeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDescriptorDeviceTypeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<DescriptorDeviceTypeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(
        void * context,
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::DecodableType> &
            value);
};

class MTRDescriptorDeviceTypeListListAttributeCallbackSubscriptionBridge
    : public MTRDescriptorDeviceTypeListListAttributeCallbackBridge
{
public:
    MTRDescriptorDeviceTypeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action,
                                                                       MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDescriptorDeviceTypeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDescriptorDeviceTypeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDescriptorDeviceTypeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDescriptorServerListListAttributeCallbackBridge : public MTRCallbackBridge<DescriptorServerListListAttributeCallback>
{
public:
    MTRDescriptorServerListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DescriptorServerListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDescriptorServerListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<DescriptorServerListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::ClusterId> & value);
};

class MTRDescriptorServerListListAttributeCallbackSubscriptionBridge : public MTRDescriptorServerListListAttributeCallbackBridge
{
public:
    MTRDescriptorServerListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action,
                                                                   MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDescriptorServerListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDescriptorServerListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDescriptorServerListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDescriptorClientListListAttributeCallbackBridge : public MTRCallbackBridge<DescriptorClientListListAttributeCallback>
{
public:
    MTRDescriptorClientListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DescriptorClientListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDescriptorClientListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<DescriptorClientListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::ClusterId> & value);
};

class MTRDescriptorClientListListAttributeCallbackSubscriptionBridge : public MTRDescriptorClientListListAttributeCallbackBridge
{
public:
    MTRDescriptorClientListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action,
                                                                   MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDescriptorClientListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDescriptorClientListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDescriptorClientListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDescriptorPartsListListAttributeCallbackBridge : public MTRCallbackBridge<DescriptorPartsListListAttributeCallback>
{
public:
    MTRDescriptorPartsListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DescriptorPartsListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDescriptorPartsListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<DescriptorPartsListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EndpointId> & value);
};

class MTRDescriptorPartsListListAttributeCallbackSubscriptionBridge : public MTRDescriptorPartsListListAttributeCallbackBridge
{
public:
    MTRDescriptorPartsListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDescriptorPartsListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDescriptorPartsListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDescriptorPartsListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDescriptorGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<DescriptorGeneratedCommandListListAttributeCallback>
{
public:
    MTRDescriptorGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DescriptorGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDescriptorGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action) :
        MTRCallbackBridge<DescriptorGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRDescriptorGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRDescriptorGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRDescriptorGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action,
                                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDescriptorGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDescriptorGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDescriptorGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDescriptorAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<DescriptorAcceptedCommandListListAttributeCallback>
{
public:
    MTRDescriptorAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DescriptorAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDescriptorAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<DescriptorAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRDescriptorAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRDescriptorAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRDescriptorAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDescriptorAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDescriptorAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDescriptorAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDescriptorEventListListAttributeCallbackBridge : public MTRCallbackBridge<DescriptorEventListListAttributeCallback>
{
public:
    MTRDescriptorEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DescriptorEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDescriptorEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<DescriptorEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRDescriptorEventListListAttributeCallbackSubscriptionBridge : public MTRDescriptorEventListListAttributeCallbackBridge
{
public:
    MTRDescriptorEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDescriptorEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDescriptorEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDescriptorEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDescriptorAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<DescriptorAttributeListListAttributeCallback>
{
public:
    MTRDescriptorAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DescriptorAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDescriptorAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<DescriptorAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRDescriptorAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRDescriptorAttributeListListAttributeCallbackBridge
{
public:
    MTRDescriptorAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action,
                                                                      MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDescriptorAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDescriptorAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDescriptorAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBindingBindingListAttributeCallbackBridge : public MTRCallbackBridge<BindingBindingListAttributeCallback>
{
public:
    MTRBindingBindingListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BindingBindingListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBindingBindingListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<BindingBindingListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(
        void * context,
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Binding::Structs::TargetStruct::DecodableType> & value);
};

class MTRBindingBindingListAttributeCallbackSubscriptionBridge : public MTRBindingBindingListAttributeCallbackBridge
{
public:
    MTRBindingBindingListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBindingBindingListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBindingBindingListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBindingBindingListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBindingGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BindingGeneratedCommandListListAttributeCallback>
{
public:
    MTRBindingGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BindingGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBindingGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<BindingGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBindingGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBindingGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRBindingGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBindingGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBindingGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBindingGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBindingAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BindingAcceptedCommandListListAttributeCallback>
{
public:
    MTRBindingAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BindingAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBindingAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                             MTRActionBlock action) :
        MTRCallbackBridge<BindingAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBindingAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBindingAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRBindingAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action,
                                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBindingAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBindingAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBindingAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBindingEventListListAttributeCallbackBridge : public MTRCallbackBridge<BindingEventListListAttributeCallback>
{
public:
    MTRBindingEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BindingEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBindingEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<BindingEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRBindingEventListListAttributeCallbackSubscriptionBridge : public MTRBindingEventListListAttributeCallbackBridge
{
public:
    MTRBindingEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action,
                                                               MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBindingEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBindingEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBindingEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBindingAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<BindingAttributeListListAttributeCallback>
{
public:
    MTRBindingAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BindingAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBindingAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<BindingAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRBindingAttributeListListAttributeCallbackSubscriptionBridge : public MTRBindingAttributeListListAttributeCallbackBridge
{
public:
    MTRBindingAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action,
                                                                   MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBindingAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBindingAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBindingAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAccessControlACLListAttributeCallbackBridge : public MTRCallbackBridge<AccessControlACLListAttributeCallback>
{
public:
    MTRAccessControlACLListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AccessControlACLListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAccessControlACLListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<AccessControlACLListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<
                                chip::app::Clusters::AccessControl::Structs::AccessControlEntryStruct::DecodableType> & value);
};

class MTRAccessControlACLListAttributeCallbackSubscriptionBridge : public MTRAccessControlACLListAttributeCallbackBridge
{
public:
    MTRAccessControlACLListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action,
                                                               MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAccessControlACLListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAccessControlACLListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAccessControlACLListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAccessControlExtensionListAttributeCallbackBridge : public MTRCallbackBridge<AccessControlExtensionListAttributeCallback>
{
public:
    MTRAccessControlExtensionListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AccessControlExtensionListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAccessControlExtensionListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<AccessControlExtensionListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<
                                chip::app::Clusters::AccessControl::Structs::AccessControlExtensionStruct::DecodableType> & value);
};

class MTRAccessControlExtensionListAttributeCallbackSubscriptionBridge : public MTRAccessControlExtensionListAttributeCallbackBridge
{
public:
    MTRAccessControlExtensionListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action,
                                                                     MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAccessControlExtensionListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAccessControlExtensionListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAccessControlExtensionListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAccessControlGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<AccessControlGeneratedCommandListListAttributeCallback>
{
public:
    MTRAccessControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AccessControlGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAccessControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<AccessControlGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRAccessControlGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRAccessControlGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRAccessControlGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAccessControlGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAccessControlGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAccessControlGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAccessControlAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<AccessControlAcceptedCommandListListAttributeCallback>
{
public:
    MTRAccessControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AccessControlAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAccessControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<AccessControlAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRAccessControlAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRAccessControlAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRAccessControlAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAccessControlAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAccessControlAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAccessControlAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAccessControlEventListListAttributeCallbackBridge : public MTRCallbackBridge<AccessControlEventListListAttributeCallback>
{
public:
    MTRAccessControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AccessControlEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAccessControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<AccessControlEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRAccessControlEventListListAttributeCallbackSubscriptionBridge : public MTRAccessControlEventListListAttributeCallbackBridge
{
public:
    MTRAccessControlEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action,
                                                                     MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAccessControlEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAccessControlEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAccessControlEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAccessControlAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<AccessControlAttributeListListAttributeCallback>
{
public:
    MTRAccessControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AccessControlAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAccessControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                             MTRActionBlock action) :
        MTRCallbackBridge<AccessControlAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRAccessControlAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRAccessControlAttributeListListAttributeCallbackBridge
{
public:
    MTRAccessControlAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action,
                                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAccessControlAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAccessControlAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAccessControlAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRActionsActionListListAttributeCallbackBridge : public MTRCallbackBridge<ActionsActionListListAttributeCallback>
{
public:
    MTRActionsActionListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ActionsActionListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRActionsActionListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ActionsActionListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(
        void * context,
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::ActionStruct::DecodableType> & value);
};

class MTRActionsActionListListAttributeCallbackSubscriptionBridge : public MTRActionsActionListListAttributeCallbackBridge
{
public:
    MTRActionsActionListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action,
                                                                MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRActionsActionListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRActionsActionListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRActionsActionListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRActionsEndpointListsListAttributeCallbackBridge : public MTRCallbackBridge<ActionsEndpointListsListAttributeCallback>
{
public:
    MTRActionsEndpointListsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ActionsEndpointListsListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRActionsEndpointListsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ActionsEndpointListsListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(
        void * context,
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::EndpointListStruct::DecodableType> &
            value);
};

class MTRActionsEndpointListsListAttributeCallbackSubscriptionBridge : public MTRActionsEndpointListsListAttributeCallbackBridge
{
public:
    MTRActionsEndpointListsListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action,
                                                                   MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRActionsEndpointListsListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRActionsEndpointListsListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRActionsEndpointListsListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRActionsGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ActionsGeneratedCommandListListAttributeCallback>
{
public:
    MTRActionsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ActionsGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRActionsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<ActionsGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRActionsGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRActionsGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRActionsGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRActionsGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRActionsGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRActionsGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRActionsAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ActionsAcceptedCommandListListAttributeCallback>
{
public:
    MTRActionsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ActionsAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRActionsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                             MTRActionBlock action) :
        MTRCallbackBridge<ActionsAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRActionsAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRActionsAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRActionsAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action,
                                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRActionsAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRActionsAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRActionsAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRActionsEventListListAttributeCallbackBridge : public MTRCallbackBridge<ActionsEventListListAttributeCallback>
{
public:
    MTRActionsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ActionsEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRActionsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ActionsEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRActionsEventListListAttributeCallbackSubscriptionBridge : public MTRActionsEventListListAttributeCallbackBridge
{
public:
    MTRActionsEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action,
                                                               MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRActionsEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRActionsEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRActionsEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRActionsAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<ActionsAttributeListListAttributeCallback>
{
public:
    MTRActionsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ActionsAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRActionsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ActionsAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRActionsAttributeListListAttributeCallbackSubscriptionBridge : public MTRActionsAttributeListListAttributeCallbackBridge
{
public:
    MTRActionsAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action,
                                                                   MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRActionsAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRActionsAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRActionsAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBasicInformationCapabilityMinimaStructAttributeCallbackBridge
    : public MTRCallbackBridge<BasicInformationCapabilityMinimaStructAttributeCallback>
{
public:
    MTRBasicInformationCapabilityMinimaStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BasicInformationCapabilityMinimaStructAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBasicInformationCapabilityMinimaStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action) :
        MTRCallbackBridge<BasicInformationCapabilityMinimaStructAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::Clusters::BasicInformation::Structs::CapabilityMinimaStruct::DecodableType & value);
};

class MTRBasicInformationCapabilityMinimaStructAttributeCallbackSubscriptionBridge
    : public MTRBasicInformationCapabilityMinimaStructAttributeCallbackBridge
{
public:
    MTRBasicInformationCapabilityMinimaStructAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBasicInformationCapabilityMinimaStructAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBasicInformationCapabilityMinimaStructAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBasicInformationCapabilityMinimaStructAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBasicInformationProductAppearanceStructAttributeCallbackBridge
    : public MTRCallbackBridge<BasicInformationProductAppearanceStructAttributeCallback>
{
public:
    MTRBasicInformationProductAppearanceStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BasicInformationProductAppearanceStructAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBasicInformationProductAppearanceStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<BasicInformationProductAppearanceStructAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::Clusters::BasicInformation::Structs::ProductAppearanceStruct::DecodableType & value);
};

class MTRBasicInformationProductAppearanceStructAttributeCallbackSubscriptionBridge
    : public MTRBasicInformationProductAppearanceStructAttributeCallbackBridge
{
public:
    MTRBasicInformationProductAppearanceStructAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBasicInformationProductAppearanceStructAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBasicInformationProductAppearanceStructAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBasicInformationProductAppearanceStructAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBasicInformationGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BasicInformationGeneratedCommandListListAttributeCallback>
{
public:
    MTRBasicInformationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BasicInformationGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBasicInformationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action) :
        MTRCallbackBridge<BasicInformationGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBasicInformationGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBasicInformationGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRBasicInformationGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBasicInformationGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBasicInformationGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBasicInformationGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBasicInformationAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BasicInformationAcceptedCommandListListAttributeCallback>
{
public:
    MTRBasicInformationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BasicInformationAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBasicInformationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<BasicInformationAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBasicInformationAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBasicInformationAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRBasicInformationAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBasicInformationAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBasicInformationAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBasicInformationAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBasicInformationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<BasicInformationEventListListAttributeCallback>
{
public:
    MTRBasicInformationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BasicInformationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBasicInformationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<BasicInformationEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRBasicInformationEventListListAttributeCallbackSubscriptionBridge
    : public MTRBasicInformationEventListListAttributeCallbackBridge
{
public:
    MTRBasicInformationEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBasicInformationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBasicInformationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBasicInformationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBasicInformationAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<BasicInformationAttributeListListAttributeCallback>
{
public:
    MTRBasicInformationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BasicInformationAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBasicInformationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<BasicInformationAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRBasicInformationAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRBasicInformationAttributeListListAttributeCallbackBridge
{
public:
    MTRBasicInformationAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBasicInformationAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBasicInformationAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBasicInformationAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROTASoftwareUpdateProviderGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OTASoftwareUpdateProviderGeneratedCommandListListAttributeCallback>
{
public:
    MTROTASoftwareUpdateProviderGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OTASoftwareUpdateProviderGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROTASoftwareUpdateProviderGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<OTASoftwareUpdateProviderGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROTASoftwareUpdateProviderGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROTASoftwareUpdateProviderGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTROTASoftwareUpdateProviderGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROTASoftwareUpdateProviderGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROTASoftwareUpdateProviderGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROTASoftwareUpdateProviderGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROTASoftwareUpdateProviderAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OTASoftwareUpdateProviderAcceptedCommandListListAttributeCallback>
{
public:
    MTROTASoftwareUpdateProviderAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OTASoftwareUpdateProviderAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROTASoftwareUpdateProviderAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<OTASoftwareUpdateProviderAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROTASoftwareUpdateProviderAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROTASoftwareUpdateProviderAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTROTASoftwareUpdateProviderAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROTASoftwareUpdateProviderAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROTASoftwareUpdateProviderAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROTASoftwareUpdateProviderAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROTASoftwareUpdateProviderEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<OTASoftwareUpdateProviderEventListListAttributeCallback>
{
public:
    MTROTASoftwareUpdateProviderEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OTASoftwareUpdateProviderEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROTASoftwareUpdateProviderEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action) :
        MTRCallbackBridge<OTASoftwareUpdateProviderEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTROTASoftwareUpdateProviderEventListListAttributeCallbackSubscriptionBridge
    : public MTROTASoftwareUpdateProviderEventListListAttributeCallbackBridge
{
public:
    MTROTASoftwareUpdateProviderEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROTASoftwareUpdateProviderEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROTASoftwareUpdateProviderEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROTASoftwareUpdateProviderEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROTASoftwareUpdateProviderAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<OTASoftwareUpdateProviderAttributeListListAttributeCallback>
{
public:
    MTROTASoftwareUpdateProviderAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OTASoftwareUpdateProviderAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROTASoftwareUpdateProviderAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<OTASoftwareUpdateProviderAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTROTASoftwareUpdateProviderAttributeListListAttributeCallbackSubscriptionBridge
    : public MTROTASoftwareUpdateProviderAttributeListListAttributeCallbackBridge
{
public:
    MTROTASoftwareUpdateProviderAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROTASoftwareUpdateProviderAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROTASoftwareUpdateProviderAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROTASoftwareUpdateProviderAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallbackBridge
    : public MTRCallbackBridge<OTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallback>
{
public:
    MTROTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<OTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<
                                chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::DecodableType> & value);
};

class MTROTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallbackSubscriptionBridge
    : public MTROTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallbackBridge
{
public:
    MTROTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROTASoftwareUpdateRequestorDefaultOTAProvidersListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallback>
{
public:
    MTROTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                 MTRActionBlock action) :
        MTRCallbackBridge<OTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                               OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTROTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROTASoftwareUpdateRequestorGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallback>
{
public:
    MTROTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<OTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTROTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROTASoftwareUpdateRequestorAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROTASoftwareUpdateRequestorEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<OTASoftwareUpdateRequestorEventListListAttributeCallback>
{
public:
    MTROTASoftwareUpdateRequestorEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OTASoftwareUpdateRequestorEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROTASoftwareUpdateRequestorEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<OTASoftwareUpdateRequestorEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTROTASoftwareUpdateRequestorEventListListAttributeCallbackSubscriptionBridge
    : public MTROTASoftwareUpdateRequestorEventListListAttributeCallbackBridge
{
public:
    MTROTASoftwareUpdateRequestorEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROTASoftwareUpdateRequestorEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROTASoftwareUpdateRequestorEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROTASoftwareUpdateRequestorEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROTASoftwareUpdateRequestorAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<OTASoftwareUpdateRequestorAttributeListListAttributeCallback>
{
public:
    MTROTASoftwareUpdateRequestorAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OTASoftwareUpdateRequestorAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROTASoftwareUpdateRequestorAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action) :
        MTRCallbackBridge<OTASoftwareUpdateRequestorAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTROTASoftwareUpdateRequestorAttributeListListAttributeCallbackSubscriptionBridge
    : public MTROTASoftwareUpdateRequestorAttributeListListAttributeCallbackBridge
{
public:
    MTROTASoftwareUpdateRequestorAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROTASoftwareUpdateRequestorAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROTASoftwareUpdateRequestorAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROTASoftwareUpdateRequestorAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRLocalizationConfigurationSupportedLocalesListAttributeCallbackBridge
    : public MTRCallbackBridge<LocalizationConfigurationSupportedLocalesListAttributeCallback>
{
public:
    MTRLocalizationConfigurationSupportedLocalesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<LocalizationConfigurationSupportedLocalesListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRLocalizationConfigurationSupportedLocalesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<LocalizationConfigurationSupportedLocalesListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CharSpan> & value);
};

class MTRLocalizationConfigurationSupportedLocalesListAttributeCallbackSubscriptionBridge
    : public MTRLocalizationConfigurationSupportedLocalesListAttributeCallbackBridge
{
public:
    MTRLocalizationConfigurationSupportedLocalesListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRLocalizationConfigurationSupportedLocalesListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRLocalizationConfigurationSupportedLocalesListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRLocalizationConfigurationSupportedLocalesListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRLocalizationConfigurationGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<LocalizationConfigurationGeneratedCommandListListAttributeCallback>
{
public:
    MTRLocalizationConfigurationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<LocalizationConfigurationGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRLocalizationConfigurationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<LocalizationConfigurationGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRLocalizationConfigurationGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRLocalizationConfigurationGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRLocalizationConfigurationGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRLocalizationConfigurationGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRLocalizationConfigurationGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRLocalizationConfigurationGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRLocalizationConfigurationAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<LocalizationConfigurationAcceptedCommandListListAttributeCallback>
{
public:
    MTRLocalizationConfigurationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<LocalizationConfigurationAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRLocalizationConfigurationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<LocalizationConfigurationAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRLocalizationConfigurationAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRLocalizationConfigurationAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRLocalizationConfigurationAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRLocalizationConfigurationAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRLocalizationConfigurationAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRLocalizationConfigurationAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRLocalizationConfigurationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<LocalizationConfigurationEventListListAttributeCallback>
{
public:
    MTRLocalizationConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<LocalizationConfigurationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRLocalizationConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action) :
        MTRCallbackBridge<LocalizationConfigurationEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRLocalizationConfigurationEventListListAttributeCallbackSubscriptionBridge
    : public MTRLocalizationConfigurationEventListListAttributeCallbackBridge
{
public:
    MTRLocalizationConfigurationEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRLocalizationConfigurationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRLocalizationConfigurationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRLocalizationConfigurationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRLocalizationConfigurationAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<LocalizationConfigurationAttributeListListAttributeCallback>
{
public:
    MTRLocalizationConfigurationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<LocalizationConfigurationAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRLocalizationConfigurationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<LocalizationConfigurationAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRLocalizationConfigurationAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRLocalizationConfigurationAttributeListListAttributeCallbackBridge
{
public:
    MTRLocalizationConfigurationAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRLocalizationConfigurationAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRLocalizationConfigurationAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRLocalizationConfigurationAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTimeFormatLocalizationSupportedCalendarTypesListAttributeCallbackBridge
    : public MTRCallbackBridge<TimeFormatLocalizationSupportedCalendarTypesListAttributeCallback>
{
public:
    MTRTimeFormatLocalizationSupportedCalendarTypesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TimeFormatLocalizationSupportedCalendarTypesListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTimeFormatLocalizationSupportedCalendarTypesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<TimeFormatLocalizationSupportedCalendarTypesListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void
    OnSuccessFn(void * context,
                const chip::app::DataModel::DecodableList<chip::app::Clusters::TimeFormatLocalization::CalendarTypeEnum> & value);
};

class MTRTimeFormatLocalizationSupportedCalendarTypesListAttributeCallbackSubscriptionBridge
    : public MTRTimeFormatLocalizationSupportedCalendarTypesListAttributeCallbackBridge
{
public:
    MTRTimeFormatLocalizationSupportedCalendarTypesListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTimeFormatLocalizationSupportedCalendarTypesListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTimeFormatLocalizationSupportedCalendarTypesListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTimeFormatLocalizationSupportedCalendarTypesListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTimeFormatLocalizationGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<TimeFormatLocalizationGeneratedCommandListListAttributeCallback>
{
public:
    MTRTimeFormatLocalizationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TimeFormatLocalizationGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTimeFormatLocalizationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action) :
        MTRCallbackBridge<TimeFormatLocalizationGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRTimeFormatLocalizationGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRTimeFormatLocalizationGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRTimeFormatLocalizationGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTimeFormatLocalizationGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTimeFormatLocalizationGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTimeFormatLocalizationGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTimeFormatLocalizationAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<TimeFormatLocalizationAcceptedCommandListListAttributeCallback>
{
public:
    MTRTimeFormatLocalizationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TimeFormatLocalizationAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTimeFormatLocalizationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<TimeFormatLocalizationAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRTimeFormatLocalizationAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRTimeFormatLocalizationAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRTimeFormatLocalizationAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTimeFormatLocalizationAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTimeFormatLocalizationAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTimeFormatLocalizationAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTimeFormatLocalizationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<TimeFormatLocalizationEventListListAttributeCallback>
{
public:
    MTRTimeFormatLocalizationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TimeFormatLocalizationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTimeFormatLocalizationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<TimeFormatLocalizationEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRTimeFormatLocalizationEventListListAttributeCallbackSubscriptionBridge
    : public MTRTimeFormatLocalizationEventListListAttributeCallbackBridge
{
public:
    MTRTimeFormatLocalizationEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTimeFormatLocalizationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTimeFormatLocalizationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTimeFormatLocalizationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTimeFormatLocalizationAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<TimeFormatLocalizationAttributeListListAttributeCallback>
{
public:
    MTRTimeFormatLocalizationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TimeFormatLocalizationAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTimeFormatLocalizationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<TimeFormatLocalizationAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRTimeFormatLocalizationAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRTimeFormatLocalizationAttributeListListAttributeCallbackBridge
{
public:
    MTRTimeFormatLocalizationAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTimeFormatLocalizationAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTimeFormatLocalizationAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTimeFormatLocalizationAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUnitLocalizationGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<UnitLocalizationGeneratedCommandListListAttributeCallback>
{
public:
    MTRUnitLocalizationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UnitLocalizationGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUnitLocalizationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action) :
        MTRCallbackBridge<UnitLocalizationGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRUnitLocalizationGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRUnitLocalizationGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRUnitLocalizationGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUnitLocalizationGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUnitLocalizationGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUnitLocalizationGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUnitLocalizationAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<UnitLocalizationAcceptedCommandListListAttributeCallback>
{
public:
    MTRUnitLocalizationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UnitLocalizationAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUnitLocalizationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<UnitLocalizationAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRUnitLocalizationAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRUnitLocalizationAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRUnitLocalizationAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUnitLocalizationAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUnitLocalizationAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUnitLocalizationAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUnitLocalizationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<UnitLocalizationEventListListAttributeCallback>
{
public:
    MTRUnitLocalizationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UnitLocalizationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUnitLocalizationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<UnitLocalizationEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRUnitLocalizationEventListListAttributeCallbackSubscriptionBridge
    : public MTRUnitLocalizationEventListListAttributeCallbackBridge
{
public:
    MTRUnitLocalizationEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUnitLocalizationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUnitLocalizationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUnitLocalizationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUnitLocalizationAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<UnitLocalizationAttributeListListAttributeCallback>
{
public:
    MTRUnitLocalizationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UnitLocalizationAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUnitLocalizationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<UnitLocalizationAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRUnitLocalizationAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRUnitLocalizationAttributeListListAttributeCallbackBridge
{
public:
    MTRUnitLocalizationAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUnitLocalizationAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUnitLocalizationAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUnitLocalizationAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceConfigurationSourcesListAttributeCallbackBridge
    : public MTRCallbackBridge<PowerSourceConfigurationSourcesListAttributeCallback>
{
public:
    MTRPowerSourceConfigurationSourcesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceConfigurationSourcesListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceConfigurationSourcesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceConfigurationSourcesListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<uint8_t> & value);
};

class MTRPowerSourceConfigurationSourcesListAttributeCallbackSubscriptionBridge
    : public MTRPowerSourceConfigurationSourcesListAttributeCallbackBridge
{
public:
    MTRPowerSourceConfigurationSourcesListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceConfigurationSourcesListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceConfigurationSourcesListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceConfigurationSourcesListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceConfigurationGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<PowerSourceConfigurationGeneratedCommandListListAttributeCallback>
{
public:
    MTRPowerSourceConfigurationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceConfigurationGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceConfigurationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceConfigurationGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRPowerSourceConfigurationGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRPowerSourceConfigurationGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRPowerSourceConfigurationGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceConfigurationGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceConfigurationGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceConfigurationGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceConfigurationAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<PowerSourceConfigurationAcceptedCommandListListAttributeCallback>
{
public:
    MTRPowerSourceConfigurationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceConfigurationAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceConfigurationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                              MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceConfigurationAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRPowerSourceConfigurationAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRPowerSourceConfigurationAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRPowerSourceConfigurationAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceConfigurationAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceConfigurationAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceConfigurationAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceConfigurationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<PowerSourceConfigurationEventListListAttributeCallback>
{
public:
    MTRPowerSourceConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceConfigurationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceConfigurationEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRPowerSourceConfigurationEventListListAttributeCallbackSubscriptionBridge
    : public MTRPowerSourceConfigurationEventListListAttributeCallbackBridge
{
public:
    MTRPowerSourceConfigurationEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceConfigurationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceConfigurationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceConfigurationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceConfigurationAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<PowerSourceConfigurationAttributeListListAttributeCallback>
{
public:
    MTRPowerSourceConfigurationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceConfigurationAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceConfigurationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceConfigurationAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRPowerSourceConfigurationAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRPowerSourceConfigurationAttributeListListAttributeCallbackBridge
{
public:
    MTRPowerSourceConfigurationAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceConfigurationAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceConfigurationAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceConfigurationAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceActiveWiredFaultsListAttributeCallbackBridge
    : public MTRCallbackBridge<PowerSourceActiveWiredFaultsListAttributeCallback>
{
public:
    MTRPowerSourceActiveWiredFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceActiveWiredFaultsListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceActiveWiredFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceActiveWiredFaultsListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::WiredFaultEnum> & value);
};

class MTRPowerSourceActiveWiredFaultsListAttributeCallbackSubscriptionBridge
    : public MTRPowerSourceActiveWiredFaultsListAttributeCallbackBridge
{
public:
    MTRPowerSourceActiveWiredFaultsListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceActiveWiredFaultsListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceActiveWiredFaultsListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceActiveWiredFaultsListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceActiveBatFaultsListAttributeCallbackBridge
    : public MTRCallbackBridge<PowerSourceActiveBatFaultsListAttributeCallback>
{
public:
    MTRPowerSourceActiveBatFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceActiveBatFaultsListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceActiveBatFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                             MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceActiveBatFaultsListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatFaultEnum> & value);
};

class MTRPowerSourceActiveBatFaultsListAttributeCallbackSubscriptionBridge
    : public MTRPowerSourceActiveBatFaultsListAttributeCallbackBridge
{
public:
    MTRPowerSourceActiveBatFaultsListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action,
                                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceActiveBatFaultsListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceActiveBatFaultsListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceActiveBatFaultsListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceActiveBatChargeFaultsListAttributeCallbackBridge
    : public MTRCallbackBridge<PowerSourceActiveBatChargeFaultsListAttributeCallback>
{
public:
    MTRPowerSourceActiveBatChargeFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceActiveBatChargeFaultsListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceActiveBatChargeFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceActiveBatChargeFaultsListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void
    OnSuccessFn(void * context,
                const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatChargeFaultEnum> & value);
};

class MTRPowerSourceActiveBatChargeFaultsListAttributeCallbackSubscriptionBridge
    : public MTRPowerSourceActiveBatChargeFaultsListAttributeCallbackBridge
{
public:
    MTRPowerSourceActiveBatChargeFaultsListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceActiveBatChargeFaultsListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceActiveBatChargeFaultsListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceActiveBatChargeFaultsListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<PowerSourceGeneratedCommandListListAttributeCallback>
{
public:
    MTRPowerSourceGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRPowerSourceGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRPowerSourceGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRPowerSourceGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<PowerSourceAcceptedCommandListListAttributeCallback>
{
public:
    MTRPowerSourceAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRPowerSourceAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRPowerSourceAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRPowerSourceAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action,
                                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceEventListListAttributeCallbackBridge : public MTRCallbackBridge<PowerSourceEventListListAttributeCallback>
{
public:
    MTRPowerSourceEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRPowerSourceEventListListAttributeCallbackSubscriptionBridge : public MTRPowerSourceEventListListAttributeCallbackBridge
{
public:
    MTRPowerSourceEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action,
                                                                   MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPowerSourceAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<PowerSourceAttributeListListAttributeCallback>
{
public:
    MTRPowerSourceAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PowerSourceAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPowerSourceAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<PowerSourceAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRPowerSourceAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRPowerSourceAttributeListListAttributeCallbackBridge
{
public:
    MTRPowerSourceAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action,
                                                                       MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPowerSourceAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPowerSourceAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPowerSourceAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralCommissioningBasicCommissioningInfoStructAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralCommissioningBasicCommissioningInfoStructAttributeCallback>
{
public:
    MTRGeneralCommissioningBasicCommissioningInfoStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralCommissioningBasicCommissioningInfoStructAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralCommissioningBasicCommissioningInfoStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<GeneralCommissioningBasicCommissioningInfoStructAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void
    OnSuccessFn(void * context,
                const chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::DecodableType & value);
};

class MTRGeneralCommissioningBasicCommissioningInfoStructAttributeCallbackSubscriptionBridge
    : public MTRGeneralCommissioningBasicCommissioningInfoStructAttributeCallbackBridge
{
public:
    MTRGeneralCommissioningBasicCommissioningInfoStructAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralCommissioningBasicCommissioningInfoStructAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralCommissioningBasicCommissioningInfoStructAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralCommissioningBasicCommissioningInfoStructAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralCommissioningGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralCommissioningGeneratedCommandListListAttributeCallback>
{
public:
    MTRGeneralCommissioningGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralCommissioningGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralCommissioningGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action) :
        MTRCallbackBridge<GeneralCommissioningGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRGeneralCommissioningGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRGeneralCommissioningGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRGeneralCommissioningGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralCommissioningGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralCommissioningGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralCommissioningGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralCommissioningAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralCommissioningAcceptedCommandListListAttributeCallback>
{
public:
    MTRGeneralCommissioningAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralCommissioningAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralCommissioningAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action) :
        MTRCallbackBridge<GeneralCommissioningAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRGeneralCommissioningAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRGeneralCommissioningAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRGeneralCommissioningAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralCommissioningAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralCommissioningAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralCommissioningAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralCommissioningEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralCommissioningEventListListAttributeCallback>
{
public:
    MTRGeneralCommissioningEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralCommissioningEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralCommissioningEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<GeneralCommissioningEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRGeneralCommissioningEventListListAttributeCallbackSubscriptionBridge
    : public MTRGeneralCommissioningEventListListAttributeCallbackBridge
{
public:
    MTRGeneralCommissioningEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralCommissioningEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralCommissioningEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralCommissioningEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralCommissioningAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralCommissioningAttributeListListAttributeCallback>
{
public:
    MTRGeneralCommissioningAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralCommissioningAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralCommissioningAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<GeneralCommissioningAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRGeneralCommissioningAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRGeneralCommissioningAttributeListListAttributeCallbackBridge
{
public:
    MTRGeneralCommissioningAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralCommissioningAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralCommissioningAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralCommissioningAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNetworkCommissioningNetworksListAttributeCallbackBridge
    : public MTRCallbackBridge<NetworkCommissioningNetworksListAttributeCallback>
{
public:
    MTRNetworkCommissioningNetworksListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NetworkCommissioningNetworksListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNetworkCommissioningNetworksListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<NetworkCommissioningNetworksListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(
        void * context,
        const chip::app::DataModel::DecodableList<chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfo::DecodableType> &
            value);
};

class MTRNetworkCommissioningNetworksListAttributeCallbackSubscriptionBridge
    : public MTRNetworkCommissioningNetworksListAttributeCallbackBridge
{
public:
    MTRNetworkCommissioningNetworksListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNetworkCommissioningNetworksListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNetworkCommissioningNetworksListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNetworkCommissioningNetworksListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNetworkCommissioningGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<NetworkCommissioningGeneratedCommandListListAttributeCallback>
{
public:
    MTRNetworkCommissioningGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NetworkCommissioningGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNetworkCommissioningGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action) :
        MTRCallbackBridge<NetworkCommissioningGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRNetworkCommissioningGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRNetworkCommissioningGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRNetworkCommissioningGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNetworkCommissioningGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNetworkCommissioningGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNetworkCommissioningGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNetworkCommissioningAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<NetworkCommissioningAcceptedCommandListListAttributeCallback>
{
public:
    MTRNetworkCommissioningAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NetworkCommissioningAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNetworkCommissioningAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action) :
        MTRCallbackBridge<NetworkCommissioningAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRNetworkCommissioningAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRNetworkCommissioningAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRNetworkCommissioningAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNetworkCommissioningAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNetworkCommissioningAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNetworkCommissioningAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNetworkCommissioningEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<NetworkCommissioningEventListListAttributeCallback>
{
public:
    MTRNetworkCommissioningEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NetworkCommissioningEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNetworkCommissioningEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<NetworkCommissioningEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRNetworkCommissioningEventListListAttributeCallbackSubscriptionBridge
    : public MTRNetworkCommissioningEventListListAttributeCallbackBridge
{
public:
    MTRNetworkCommissioningEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNetworkCommissioningEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNetworkCommissioningEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNetworkCommissioningEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNetworkCommissioningAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<NetworkCommissioningAttributeListListAttributeCallback>
{
public:
    MTRNetworkCommissioningAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NetworkCommissioningAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNetworkCommissioningAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<NetworkCommissioningAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRNetworkCommissioningAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRNetworkCommissioningAttributeListListAttributeCallbackBridge
{
public:
    MTRNetworkCommissioningAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNetworkCommissioningAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNetworkCommissioningAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNetworkCommissioningAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDiagnosticLogsGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<DiagnosticLogsGeneratedCommandListListAttributeCallback>
{
public:
    MTRDiagnosticLogsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DiagnosticLogsGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDiagnosticLogsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action) :
        MTRCallbackBridge<DiagnosticLogsGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRDiagnosticLogsGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRDiagnosticLogsGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRDiagnosticLogsGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDiagnosticLogsGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDiagnosticLogsGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDiagnosticLogsGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDiagnosticLogsAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<DiagnosticLogsAcceptedCommandListListAttributeCallback>
{
public:
    MTRDiagnosticLogsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DiagnosticLogsAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDiagnosticLogsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<DiagnosticLogsAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRDiagnosticLogsAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRDiagnosticLogsAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRDiagnosticLogsAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDiagnosticLogsAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDiagnosticLogsAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDiagnosticLogsAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDiagnosticLogsEventListListAttributeCallbackBridge : public MTRCallbackBridge<DiagnosticLogsEventListListAttributeCallback>
{
public:
    MTRDiagnosticLogsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DiagnosticLogsEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDiagnosticLogsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<DiagnosticLogsEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRDiagnosticLogsEventListListAttributeCallbackSubscriptionBridge
    : public MTRDiagnosticLogsEventListListAttributeCallbackBridge
{
public:
    MTRDiagnosticLogsEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action,
                                                                      MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDiagnosticLogsEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDiagnosticLogsEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDiagnosticLogsEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDiagnosticLogsAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<DiagnosticLogsAttributeListListAttributeCallback>
{
public:
    MTRDiagnosticLogsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DiagnosticLogsAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDiagnosticLogsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<DiagnosticLogsAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRDiagnosticLogsAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRDiagnosticLogsAttributeListListAttributeCallbackBridge
{
public:
    MTRDiagnosticLogsAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDiagnosticLogsAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDiagnosticLogsAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDiagnosticLogsAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralDiagnosticsNetworkInterfacesListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralDiagnosticsNetworkInterfacesListAttributeCallback>
{
public:
    MTRGeneralDiagnosticsNetworkInterfacesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralDiagnosticsNetworkInterfacesListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralDiagnosticsNetworkInterfacesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<GeneralDiagnosticsNetworkInterfacesListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<
                                chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterface::DecodableType> & value);
};

class MTRGeneralDiagnosticsNetworkInterfacesListAttributeCallbackSubscriptionBridge
    : public MTRGeneralDiagnosticsNetworkInterfacesListAttributeCallbackBridge
{
public:
    MTRGeneralDiagnosticsNetworkInterfacesListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralDiagnosticsNetworkInterfacesListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralDiagnosticsNetworkInterfacesListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralDiagnosticsNetworkInterfacesListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralDiagnosticsActiveHardwareFaultsListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralDiagnosticsActiveHardwareFaultsListAttributeCallback>
{
public:
    MTRGeneralDiagnosticsActiveHardwareFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralDiagnosticsActiveHardwareFaultsListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralDiagnosticsActiveHardwareFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<GeneralDiagnosticsActiveHardwareFaultsListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void
    OnSuccessFn(void * context,
                const chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::HardwareFaultEnum> & value);
};

class MTRGeneralDiagnosticsActiveHardwareFaultsListAttributeCallbackSubscriptionBridge
    : public MTRGeneralDiagnosticsActiveHardwareFaultsListAttributeCallbackBridge
{
public:
    MTRGeneralDiagnosticsActiveHardwareFaultsListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralDiagnosticsActiveHardwareFaultsListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralDiagnosticsActiveHardwareFaultsListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralDiagnosticsActiveHardwareFaultsListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralDiagnosticsActiveRadioFaultsListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralDiagnosticsActiveRadioFaultsListAttributeCallback>
{
public:
    MTRGeneralDiagnosticsActiveRadioFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralDiagnosticsActiveRadioFaultsListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralDiagnosticsActiveRadioFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<GeneralDiagnosticsActiveRadioFaultsListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void
    OnSuccessFn(void * context,
                const chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::RadioFaultEnum> & value);
};

class MTRGeneralDiagnosticsActiveRadioFaultsListAttributeCallbackSubscriptionBridge
    : public MTRGeneralDiagnosticsActiveRadioFaultsListAttributeCallbackBridge
{
public:
    MTRGeneralDiagnosticsActiveRadioFaultsListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralDiagnosticsActiveRadioFaultsListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralDiagnosticsActiveRadioFaultsListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralDiagnosticsActiveRadioFaultsListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralDiagnosticsActiveNetworkFaultsListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralDiagnosticsActiveNetworkFaultsListAttributeCallback>
{
public:
    MTRGeneralDiagnosticsActiveNetworkFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralDiagnosticsActiveNetworkFaultsListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralDiagnosticsActiveNetworkFaultsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<GeneralDiagnosticsActiveNetworkFaultsListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void
    OnSuccessFn(void * context,
                const chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::NetworkFaultEnum> & value);
};

class MTRGeneralDiagnosticsActiveNetworkFaultsListAttributeCallbackSubscriptionBridge
    : public MTRGeneralDiagnosticsActiveNetworkFaultsListAttributeCallbackBridge
{
public:
    MTRGeneralDiagnosticsActiveNetworkFaultsListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralDiagnosticsActiveNetworkFaultsListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralDiagnosticsActiveNetworkFaultsListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralDiagnosticsActiveNetworkFaultsListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralDiagnosticsGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralDiagnosticsGeneratedCommandListListAttributeCallback>
{
public:
    MTRGeneralDiagnosticsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralDiagnosticsGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralDiagnosticsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<GeneralDiagnosticsGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRGeneralDiagnosticsGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRGeneralDiagnosticsGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRGeneralDiagnosticsGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralDiagnosticsGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralDiagnosticsGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralDiagnosticsGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralDiagnosticsAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralDiagnosticsAcceptedCommandListListAttributeCallback>
{
public:
    MTRGeneralDiagnosticsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralDiagnosticsAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralDiagnosticsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<GeneralDiagnosticsAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRGeneralDiagnosticsAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRGeneralDiagnosticsAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRGeneralDiagnosticsAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralDiagnosticsAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralDiagnosticsAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralDiagnosticsAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralDiagnosticsEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralDiagnosticsEventListListAttributeCallback>
{
public:
    MTRGeneralDiagnosticsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralDiagnosticsEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralDiagnosticsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<GeneralDiagnosticsEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRGeneralDiagnosticsEventListListAttributeCallbackSubscriptionBridge
    : public MTRGeneralDiagnosticsEventListListAttributeCallbackBridge
{
public:
    MTRGeneralDiagnosticsEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralDiagnosticsEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralDiagnosticsEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralDiagnosticsEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGeneralDiagnosticsAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<GeneralDiagnosticsAttributeListListAttributeCallback>
{
public:
    MTRGeneralDiagnosticsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GeneralDiagnosticsAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGeneralDiagnosticsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<GeneralDiagnosticsAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRGeneralDiagnosticsAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRGeneralDiagnosticsAttributeListListAttributeCallbackBridge
{
public:
    MTRGeneralDiagnosticsAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGeneralDiagnosticsAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGeneralDiagnosticsAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGeneralDiagnosticsAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSoftwareDiagnosticsThreadMetricsListAttributeCallbackBridge
    : public MTRCallbackBridge<SoftwareDiagnosticsThreadMetricsListAttributeCallback>
{
public:
    MTRSoftwareDiagnosticsThreadMetricsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SoftwareDiagnosticsThreadMetricsListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSoftwareDiagnosticsThreadMetricsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<SoftwareDiagnosticsThreadMetricsListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<
                                chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetricsStruct::DecodableType> & value);
};

class MTRSoftwareDiagnosticsThreadMetricsListAttributeCallbackSubscriptionBridge
    : public MTRSoftwareDiagnosticsThreadMetricsListAttributeCallbackBridge
{
public:
    MTRSoftwareDiagnosticsThreadMetricsListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSoftwareDiagnosticsThreadMetricsListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSoftwareDiagnosticsThreadMetricsListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSoftwareDiagnosticsThreadMetricsListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSoftwareDiagnosticsGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<SoftwareDiagnosticsGeneratedCommandListListAttributeCallback>
{
public:
    MTRSoftwareDiagnosticsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SoftwareDiagnosticsGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSoftwareDiagnosticsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action) :
        MTRCallbackBridge<SoftwareDiagnosticsGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRSoftwareDiagnosticsGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRSoftwareDiagnosticsGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRSoftwareDiagnosticsGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSoftwareDiagnosticsGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSoftwareDiagnosticsGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSoftwareDiagnosticsGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSoftwareDiagnosticsAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<SoftwareDiagnosticsAcceptedCommandListListAttributeCallback>
{
public:
    MTRSoftwareDiagnosticsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SoftwareDiagnosticsAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSoftwareDiagnosticsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<SoftwareDiagnosticsAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRSoftwareDiagnosticsAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRSoftwareDiagnosticsAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRSoftwareDiagnosticsAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSoftwareDiagnosticsAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSoftwareDiagnosticsAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSoftwareDiagnosticsAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSoftwareDiagnosticsEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<SoftwareDiagnosticsEventListListAttributeCallback>
{
public:
    MTRSoftwareDiagnosticsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SoftwareDiagnosticsEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSoftwareDiagnosticsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<SoftwareDiagnosticsEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRSoftwareDiagnosticsEventListListAttributeCallbackSubscriptionBridge
    : public MTRSoftwareDiagnosticsEventListListAttributeCallbackBridge
{
public:
    MTRSoftwareDiagnosticsEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSoftwareDiagnosticsEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSoftwareDiagnosticsEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSoftwareDiagnosticsEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSoftwareDiagnosticsAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<SoftwareDiagnosticsAttributeListListAttributeCallback>
{
public:
    MTRSoftwareDiagnosticsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SoftwareDiagnosticsAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSoftwareDiagnosticsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<SoftwareDiagnosticsAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRSoftwareDiagnosticsAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRSoftwareDiagnosticsAttributeListListAttributeCallbackBridge
{
public:
    MTRSoftwareDiagnosticsAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSoftwareDiagnosticsAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSoftwareDiagnosticsAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSoftwareDiagnosticsAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThreadNetworkDiagnosticsNeighborTableListAttributeCallbackBridge
    : public MTRCallbackBridge<ThreadNetworkDiagnosticsNeighborTableListAttributeCallback>
{
public:
    MTRThreadNetworkDiagnosticsNeighborTableListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsNeighborTableListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThreadNetworkDiagnosticsNeighborTableListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsNeighborTableListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void
    OnSuccessFn(void * context,
                const chip::app::DataModel::DecodableList<
                    chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTableStruct::DecodableType> & value);
};

class MTRThreadNetworkDiagnosticsNeighborTableListAttributeCallbackSubscriptionBridge
    : public MTRThreadNetworkDiagnosticsNeighborTableListAttributeCallbackBridge
{
public:
    MTRThreadNetworkDiagnosticsNeighborTableListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThreadNetworkDiagnosticsNeighborTableListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThreadNetworkDiagnosticsNeighborTableListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThreadNetworkDiagnosticsNeighborTableListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThreadNetworkDiagnosticsRouteTableListAttributeCallbackBridge
    : public MTRCallbackBridge<ThreadNetworkDiagnosticsRouteTableListAttributeCallback>
{
public:
    MTRThreadNetworkDiagnosticsRouteTableListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsRouteTableListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThreadNetworkDiagnosticsRouteTableListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsRouteTableListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<
                                chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTableStruct::DecodableType> & value);
};

class MTRThreadNetworkDiagnosticsRouteTableListAttributeCallbackSubscriptionBridge
    : public MTRThreadNetworkDiagnosticsRouteTableListAttributeCallbackBridge
{
public:
    MTRThreadNetworkDiagnosticsRouteTableListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThreadNetworkDiagnosticsRouteTableListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThreadNetworkDiagnosticsRouteTableListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThreadNetworkDiagnosticsRouteTableListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallbackBridge
    : public MTRCallbackBridge<ThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallback>
{
public:
    MTRThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::Nullable<
                                chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::DecodableType> & value);
};

class MTRThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallbackSubscriptionBridge
    : public MTRThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallbackBridge
{
public:
    MTRThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThreadNetworkDiagnosticsSecurityPolicyStructAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallbackBridge
    : public MTRCallbackBridge<ThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallback>
{
public:
    MTRThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                         ResponseHandler handler) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallback>(queue, handler,
                                                                                                       OnSuccessFn){};

    MTRThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                         ResponseHandler handler,
                                                                                         MTRActionBlock action) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallback>(queue, handler, action,
                                                                                                       OnSuccessFn){};

    static void
    OnSuccessFn(void * context,
                const chip::app::DataModel::Nullable<
                    chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::DecodableType> & value);
};

class MTRThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallbackSubscriptionBridge
    : public MTRThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallbackBridge
{
public:
    MTRThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThreadNetworkDiagnosticsOperationalDatasetComponentsStructAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallbackBridge
    : public MTRCallbackBridge<ThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallback>
{
public:
    MTRThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                  MTRActionBlock action) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallback>(queue, handler, action,
                                                                                                OnSuccessFn){};

    static void
    OnSuccessFn(void * context,
                const chip::app::DataModel::DecodableList<chip::app::Clusters::ThreadNetworkDiagnostics::NetworkFaultEnum> & value);
};

class MTRThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallbackSubscriptionBridge
    : public MTRThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallbackBridge
{
public:
    MTRThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThreadNetworkDiagnosticsActiveNetworkFaultsListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallback>
{
public:
    MTRThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThreadNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallback>
{
public:
    MTRThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                              MTRActionBlock action) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThreadNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThreadNetworkDiagnosticsEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<ThreadNetworkDiagnosticsEventListListAttributeCallback>
{
public:
    MTRThreadNetworkDiagnosticsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThreadNetworkDiagnosticsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRThreadNetworkDiagnosticsEventListListAttributeCallbackSubscriptionBridge
    : public MTRThreadNetworkDiagnosticsEventListListAttributeCallbackBridge
{
public:
    MTRThreadNetworkDiagnosticsEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThreadNetworkDiagnosticsEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThreadNetworkDiagnosticsEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThreadNetworkDiagnosticsEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThreadNetworkDiagnosticsAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<ThreadNetworkDiagnosticsAttributeListListAttributeCallback>
{
public:
    MTRThreadNetworkDiagnosticsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThreadNetworkDiagnosticsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<ThreadNetworkDiagnosticsAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRThreadNetworkDiagnosticsAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRThreadNetworkDiagnosticsAttributeListListAttributeCallbackBridge
{
public:
    MTRThreadNetworkDiagnosticsAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThreadNetworkDiagnosticsAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThreadNetworkDiagnosticsAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThreadNetworkDiagnosticsAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<WiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallback>
{
public:
    MTRWiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action) :
        MTRCallbackBridge<WiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRWiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRWiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRWiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWiFiNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<WiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallback>
{
public:
    MTRWiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<WiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRWiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRWiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRWiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWiFiNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWiFiNetworkDiagnosticsEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<WiFiNetworkDiagnosticsEventListListAttributeCallback>
{
public:
    MTRWiFiNetworkDiagnosticsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WiFiNetworkDiagnosticsEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWiFiNetworkDiagnosticsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<WiFiNetworkDiagnosticsEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRWiFiNetworkDiagnosticsEventListListAttributeCallbackSubscriptionBridge
    : public MTRWiFiNetworkDiagnosticsEventListListAttributeCallbackBridge
{
public:
    MTRWiFiNetworkDiagnosticsEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWiFiNetworkDiagnosticsEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWiFiNetworkDiagnosticsEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWiFiNetworkDiagnosticsEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWiFiNetworkDiagnosticsAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<WiFiNetworkDiagnosticsAttributeListListAttributeCallback>
{
public:
    MTRWiFiNetworkDiagnosticsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WiFiNetworkDiagnosticsAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWiFiNetworkDiagnosticsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<WiFiNetworkDiagnosticsAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRWiFiNetworkDiagnosticsAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRWiFiNetworkDiagnosticsAttributeListListAttributeCallbackBridge
{
public:
    MTRWiFiNetworkDiagnosticsAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWiFiNetworkDiagnosticsAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWiFiNetworkDiagnosticsAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWiFiNetworkDiagnosticsAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallback>
{
public:
    MTREthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<EthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTREthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                 MTRActionBlock action) :
        MTRCallbackBridge<EthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                               OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTREthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTREthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTREthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthernetNetworkDiagnosticsGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallback>
{
public:
    MTREthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<EthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTREthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<EthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTREthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTREthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTREthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthernetNetworkDiagnosticsAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthernetNetworkDiagnosticsEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthernetNetworkDiagnosticsEventListListAttributeCallback>
{
public:
    MTREthernetNetworkDiagnosticsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<EthernetNetworkDiagnosticsEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTREthernetNetworkDiagnosticsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<EthernetNetworkDiagnosticsEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTREthernetNetworkDiagnosticsEventListListAttributeCallbackSubscriptionBridge
    : public MTREthernetNetworkDiagnosticsEventListListAttributeCallbackBridge
{
public:
    MTREthernetNetworkDiagnosticsEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthernetNetworkDiagnosticsEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthernetNetworkDiagnosticsEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthernetNetworkDiagnosticsEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthernetNetworkDiagnosticsAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthernetNetworkDiagnosticsAttributeListListAttributeCallback>
{
public:
    MTREthernetNetworkDiagnosticsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<EthernetNetworkDiagnosticsAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTREthernetNetworkDiagnosticsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action) :
        MTRCallbackBridge<EthernetNetworkDiagnosticsAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTREthernetNetworkDiagnosticsAttributeListListAttributeCallbackSubscriptionBridge
    : public MTREthernetNetworkDiagnosticsAttributeListListAttributeCallbackBridge
{
public:
    MTREthernetNetworkDiagnosticsAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthernetNetworkDiagnosticsAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthernetNetworkDiagnosticsAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthernetNetworkDiagnosticsAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTimeSynchronizationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<TimeSynchronizationEventListListAttributeCallback>
{
public:
    MTRTimeSynchronizationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TimeSynchronizationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTimeSynchronizationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<TimeSynchronizationEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRTimeSynchronizationEventListListAttributeCallbackSubscriptionBridge
    : public MTRTimeSynchronizationEventListListAttributeCallbackBridge
{
public:
    MTRTimeSynchronizationEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTimeSynchronizationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTimeSynchronizationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTimeSynchronizationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBridgedDeviceBasicInformationProductAppearanceStructAttributeCallbackBridge
    : public MTRCallbackBridge<BridgedDeviceBasicInformationProductAppearanceStructAttributeCallback>
{
public:
    MTRBridgedDeviceBasicInformationProductAppearanceStructAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                   ResponseHandler handler) :
        MTRCallbackBridge<BridgedDeviceBasicInformationProductAppearanceStructAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBridgedDeviceBasicInformationProductAppearanceStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                   MTRActionBlock action) :
        MTRCallbackBridge<BridgedDeviceBasicInformationProductAppearanceStructAttributeCallback>(queue, handler, action,
                                                                                                 OnSuccessFn){};

    static void
    OnSuccessFn(void * context,
                const chip::app::Clusters::BridgedDeviceBasicInformation::Structs::ProductAppearanceStruct::DecodableType & value);
};

class MTRBridgedDeviceBasicInformationProductAppearanceStructAttributeCallbackSubscriptionBridge
    : public MTRBridgedDeviceBasicInformationProductAppearanceStructAttributeCallbackBridge
{
public:
    MTRBridgedDeviceBasicInformationProductAppearanceStructAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBridgedDeviceBasicInformationProductAppearanceStructAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBridgedDeviceBasicInformationProductAppearanceStructAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBridgedDeviceBasicInformationProductAppearanceStructAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBridgedDeviceBasicInformationGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BridgedDeviceBasicInformationGeneratedCommandListListAttributeCallback>
{
public:
    MTRBridgedDeviceBasicInformationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                    ResponseHandler handler) :
        MTRCallbackBridge<BridgedDeviceBasicInformationGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBridgedDeviceBasicInformationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                    MTRActionBlock action) :
        MTRCallbackBridge<BridgedDeviceBasicInformationGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                  OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBridgedDeviceBasicInformationGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBridgedDeviceBasicInformationGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRBridgedDeviceBasicInformationGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBridgedDeviceBasicInformationGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBridgedDeviceBasicInformationGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBridgedDeviceBasicInformationGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBridgedDeviceBasicInformationAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BridgedDeviceBasicInformationAcceptedCommandListListAttributeCallback>
{
public:
    MTRBridgedDeviceBasicInformationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                   ResponseHandler handler) :
        MTRCallbackBridge<BridgedDeviceBasicInformationAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBridgedDeviceBasicInformationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                   MTRActionBlock action) :
        MTRCallbackBridge<BridgedDeviceBasicInformationAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                 OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBridgedDeviceBasicInformationAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBridgedDeviceBasicInformationAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRBridgedDeviceBasicInformationAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBridgedDeviceBasicInformationAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBridgedDeviceBasicInformationAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBridgedDeviceBasicInformationAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBridgedDeviceBasicInformationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<BridgedDeviceBasicInformationEventListListAttributeCallback>
{
public:
    MTRBridgedDeviceBasicInformationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BridgedDeviceBasicInformationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBridgedDeviceBasicInformationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<BridgedDeviceBasicInformationEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRBridgedDeviceBasicInformationEventListListAttributeCallbackSubscriptionBridge
    : public MTRBridgedDeviceBasicInformationEventListListAttributeCallbackBridge
{
public:
    MTRBridgedDeviceBasicInformationEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBridgedDeviceBasicInformationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBridgedDeviceBasicInformationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBridgedDeviceBasicInformationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBridgedDeviceBasicInformationAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<BridgedDeviceBasicInformationAttributeListListAttributeCallback>
{
public:
    MTRBridgedDeviceBasicInformationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BridgedDeviceBasicInformationAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBridgedDeviceBasicInformationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action) :
        MTRCallbackBridge<BridgedDeviceBasicInformationAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRBridgedDeviceBasicInformationAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRBridgedDeviceBasicInformationAttributeListListAttributeCallbackBridge
{
public:
    MTRBridgedDeviceBasicInformationAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBridgedDeviceBasicInformationAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBridgedDeviceBasicInformationAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBridgedDeviceBasicInformationAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSwitchGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<SwitchGeneratedCommandListListAttributeCallback>
{
public:
    MTRSwitchGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SwitchGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSwitchGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                             MTRActionBlock action) :
        MTRCallbackBridge<SwitchGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRSwitchGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRSwitchGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRSwitchGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action,
                                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSwitchGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSwitchGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSwitchGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSwitchAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<SwitchAcceptedCommandListListAttributeCallback>
{
public:
    MTRSwitchAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SwitchAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSwitchAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<SwitchAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRSwitchAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRSwitchAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRSwitchAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSwitchAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSwitchAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSwitchAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSwitchEventListListAttributeCallbackBridge : public MTRCallbackBridge<SwitchEventListListAttributeCallback>
{
public:
    MTRSwitchEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SwitchEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSwitchEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<SwitchEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRSwitchEventListListAttributeCallbackSubscriptionBridge : public MTRSwitchEventListListAttributeCallbackBridge
{
public:
    MTRSwitchEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action,
                                                              MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSwitchEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSwitchEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSwitchEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSwitchAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<SwitchAttributeListListAttributeCallback>
{
public:
    MTRSwitchAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SwitchAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSwitchAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<SwitchAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRSwitchAttributeListListAttributeCallbackSubscriptionBridge : public MTRSwitchAttributeListListAttributeCallbackBridge
{
public:
    MTRSwitchAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSwitchAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSwitchAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSwitchAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAdministratorCommissioningGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<AdministratorCommissioningGeneratedCommandListListAttributeCallback>
{
public:
    MTRAdministratorCommissioningGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AdministratorCommissioningGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAdministratorCommissioningGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                 MTRActionBlock action) :
        MTRCallbackBridge<AdministratorCommissioningGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                               OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRAdministratorCommissioningGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRAdministratorCommissioningGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRAdministratorCommissioningGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAdministratorCommissioningGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAdministratorCommissioningGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAdministratorCommissioningGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAdministratorCommissioningAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<AdministratorCommissioningAcceptedCommandListListAttributeCallback>
{
public:
    MTRAdministratorCommissioningAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AdministratorCommissioningAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAdministratorCommissioningAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<AdministratorCommissioningAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRAdministratorCommissioningAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRAdministratorCommissioningAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRAdministratorCommissioningAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAdministratorCommissioningAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAdministratorCommissioningAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAdministratorCommissioningAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAdministratorCommissioningEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<AdministratorCommissioningEventListListAttributeCallback>
{
public:
    MTRAdministratorCommissioningEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AdministratorCommissioningEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAdministratorCommissioningEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<AdministratorCommissioningEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRAdministratorCommissioningEventListListAttributeCallbackSubscriptionBridge
    : public MTRAdministratorCommissioningEventListListAttributeCallbackBridge
{
public:
    MTRAdministratorCommissioningEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAdministratorCommissioningEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAdministratorCommissioningEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAdministratorCommissioningEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAdministratorCommissioningAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<AdministratorCommissioningAttributeListListAttributeCallback>
{
public:
    MTRAdministratorCommissioningAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AdministratorCommissioningAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAdministratorCommissioningAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action) :
        MTRCallbackBridge<AdministratorCommissioningAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRAdministratorCommissioningAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRAdministratorCommissioningAttributeListListAttributeCallbackBridge
{
public:
    MTRAdministratorCommissioningAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAdministratorCommissioningAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAdministratorCommissioningAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAdministratorCommissioningAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalCredentialsNOCsListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalCredentialsNOCsListAttributeCallback>
{
public:
    MTROperationalCredentialsNOCsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalCredentialsNOCsListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalCredentialsNOCsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                             MTRActionBlock action) :
        MTRCallbackBridge<OperationalCredentialsNOCsListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(
        void * context,
        const chip::app::DataModel::DecodableList<chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::DecodableType> &
            value);
};

class MTROperationalCredentialsNOCsListAttributeCallbackSubscriptionBridge
    : public MTROperationalCredentialsNOCsListAttributeCallbackBridge
{
public:
    MTROperationalCredentialsNOCsListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action,
                                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalCredentialsNOCsListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalCredentialsNOCsListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalCredentialsNOCsListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalCredentialsFabricsListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalCredentialsFabricsListAttributeCallback>
{
public:
    MTROperationalCredentialsFabricsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalCredentialsFabricsListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalCredentialsFabricsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<OperationalCredentialsFabricsListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void
    OnSuccessFn(void * context,
                const chip::app::DataModel::DecodableList<
                    chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptorStruct::DecodableType> & value);
};

class MTROperationalCredentialsFabricsListAttributeCallbackSubscriptionBridge
    : public MTROperationalCredentialsFabricsListAttributeCallbackBridge
{
public:
    MTROperationalCredentialsFabricsListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalCredentialsFabricsListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalCredentialsFabricsListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalCredentialsFabricsListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalCredentialsTrustedRootCertificatesListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalCredentialsTrustedRootCertificatesListAttributeCallback>
{
public:
    MTROperationalCredentialsTrustedRootCertificatesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalCredentialsTrustedRootCertificatesListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalCredentialsTrustedRootCertificatesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<OperationalCredentialsTrustedRootCertificatesListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::ByteSpan> & value);
};

class MTROperationalCredentialsTrustedRootCertificatesListAttributeCallbackSubscriptionBridge
    : public MTROperationalCredentialsTrustedRootCertificatesListAttributeCallbackBridge
{
public:
    MTROperationalCredentialsTrustedRootCertificatesListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalCredentialsTrustedRootCertificatesListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalCredentialsTrustedRootCertificatesListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalCredentialsTrustedRootCertificatesListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalCredentialsGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalCredentialsGeneratedCommandListListAttributeCallback>
{
public:
    MTROperationalCredentialsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalCredentialsGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalCredentialsGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action) :
        MTRCallbackBridge<OperationalCredentialsGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROperationalCredentialsGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROperationalCredentialsGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTROperationalCredentialsGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalCredentialsGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalCredentialsGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalCredentialsGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalCredentialsAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalCredentialsAcceptedCommandListListAttributeCallback>
{
public:
    MTROperationalCredentialsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalCredentialsAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalCredentialsAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<OperationalCredentialsAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROperationalCredentialsAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROperationalCredentialsAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTROperationalCredentialsAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalCredentialsAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalCredentialsAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalCredentialsAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalCredentialsEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalCredentialsEventListListAttributeCallback>
{
public:
    MTROperationalCredentialsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalCredentialsEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalCredentialsEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<OperationalCredentialsEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTROperationalCredentialsEventListListAttributeCallbackSubscriptionBridge
    : public MTROperationalCredentialsEventListListAttributeCallbackBridge
{
public:
    MTROperationalCredentialsEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalCredentialsEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalCredentialsEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalCredentialsEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalCredentialsAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalCredentialsAttributeListListAttributeCallback>
{
public:
    MTROperationalCredentialsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalCredentialsAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalCredentialsAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<OperationalCredentialsAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTROperationalCredentialsAttributeListListAttributeCallbackSubscriptionBridge
    : public MTROperationalCredentialsAttributeListListAttributeCallbackBridge
{
public:
    MTROperationalCredentialsAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalCredentialsAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalCredentialsAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalCredentialsAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGroupKeyManagementGroupKeyMapListAttributeCallbackBridge
    : public MTRCallbackBridge<GroupKeyManagementGroupKeyMapListAttributeCallback>
{
public:
    MTRGroupKeyManagementGroupKeyMapListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GroupKeyManagementGroupKeyMapListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGroupKeyManagementGroupKeyMapListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<GroupKeyManagementGroupKeyMapListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<
                                chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::DecodableType> & value);
};

class MTRGroupKeyManagementGroupKeyMapListAttributeCallbackSubscriptionBridge
    : public MTRGroupKeyManagementGroupKeyMapListAttributeCallbackBridge
{
public:
    MTRGroupKeyManagementGroupKeyMapListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGroupKeyManagementGroupKeyMapListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGroupKeyManagementGroupKeyMapListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGroupKeyManagementGroupKeyMapListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGroupKeyManagementGroupTableListAttributeCallbackBridge
    : public MTRCallbackBridge<GroupKeyManagementGroupTableListAttributeCallback>
{
public:
    MTRGroupKeyManagementGroupTableListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GroupKeyManagementGroupTableListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGroupKeyManagementGroupTableListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<GroupKeyManagementGroupTableListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<
                                chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::DecodableType> & value);
};

class MTRGroupKeyManagementGroupTableListAttributeCallbackSubscriptionBridge
    : public MTRGroupKeyManagementGroupTableListAttributeCallbackBridge
{
public:
    MTRGroupKeyManagementGroupTableListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGroupKeyManagementGroupTableListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGroupKeyManagementGroupTableListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGroupKeyManagementGroupTableListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGroupKeyManagementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<GroupKeyManagementGeneratedCommandListListAttributeCallback>
{
public:
    MTRGroupKeyManagementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GroupKeyManagementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGroupKeyManagementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<GroupKeyManagementGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRGroupKeyManagementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRGroupKeyManagementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRGroupKeyManagementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGroupKeyManagementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGroupKeyManagementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGroupKeyManagementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGroupKeyManagementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<GroupKeyManagementAcceptedCommandListListAttributeCallback>
{
public:
    MTRGroupKeyManagementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GroupKeyManagementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGroupKeyManagementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<GroupKeyManagementAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRGroupKeyManagementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRGroupKeyManagementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRGroupKeyManagementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGroupKeyManagementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGroupKeyManagementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGroupKeyManagementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGroupKeyManagementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<GroupKeyManagementEventListListAttributeCallback>
{
public:
    MTRGroupKeyManagementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GroupKeyManagementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGroupKeyManagementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<GroupKeyManagementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRGroupKeyManagementEventListListAttributeCallbackSubscriptionBridge
    : public MTRGroupKeyManagementEventListListAttributeCallbackBridge
{
public:
    MTRGroupKeyManagementEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGroupKeyManagementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGroupKeyManagementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGroupKeyManagementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRGroupKeyManagementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<GroupKeyManagementAttributeListListAttributeCallback>
{
public:
    MTRGroupKeyManagementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<GroupKeyManagementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRGroupKeyManagementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<GroupKeyManagementAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRGroupKeyManagementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRGroupKeyManagementAttributeListListAttributeCallbackBridge
{
public:
    MTRGroupKeyManagementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRGroupKeyManagementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRGroupKeyManagementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRGroupKeyManagementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFixedLabelLabelListListAttributeCallbackBridge : public MTRCallbackBridge<FixedLabelLabelListListAttributeCallback>
{
public:
    MTRFixedLabelLabelListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FixedLabelLabelListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFixedLabelLabelListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<FixedLabelLabelListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(
        void * context,
        const chip::app::DataModel::DecodableList<chip::app::Clusters::FixedLabel::Structs::LabelStruct::DecodableType> & value);
};

class MTRFixedLabelLabelListListAttributeCallbackSubscriptionBridge : public MTRFixedLabelLabelListListAttributeCallbackBridge
{
public:
    MTRFixedLabelLabelListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFixedLabelLabelListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFixedLabelLabelListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFixedLabelLabelListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFixedLabelGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FixedLabelGeneratedCommandListListAttributeCallback>
{
public:
    MTRFixedLabelGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FixedLabelGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFixedLabelGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action) :
        MTRCallbackBridge<FixedLabelGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFixedLabelGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFixedLabelGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRFixedLabelGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action,
                                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFixedLabelGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFixedLabelGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFixedLabelGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFixedLabelAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FixedLabelAcceptedCommandListListAttributeCallback>
{
public:
    MTRFixedLabelAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FixedLabelAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFixedLabelAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<FixedLabelAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFixedLabelAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFixedLabelAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRFixedLabelAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFixedLabelAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFixedLabelAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFixedLabelAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFixedLabelEventListListAttributeCallbackBridge : public MTRCallbackBridge<FixedLabelEventListListAttributeCallback>
{
public:
    MTRFixedLabelEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FixedLabelEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFixedLabelEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<FixedLabelEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRFixedLabelEventListListAttributeCallbackSubscriptionBridge : public MTRFixedLabelEventListListAttributeCallbackBridge
{
public:
    MTRFixedLabelEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFixedLabelEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFixedLabelEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFixedLabelEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFixedLabelAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<FixedLabelAttributeListListAttributeCallback>
{
public:
    MTRFixedLabelAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FixedLabelAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFixedLabelAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<FixedLabelAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRFixedLabelAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRFixedLabelAttributeListListAttributeCallbackBridge
{
public:
    MTRFixedLabelAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action,
                                                                      MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFixedLabelAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFixedLabelAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFixedLabelAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUserLabelLabelListListAttributeCallbackBridge : public MTRCallbackBridge<UserLabelLabelListListAttributeCallback>
{
public:
    MTRUserLabelLabelListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UserLabelLabelListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUserLabelLabelListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<UserLabelLabelListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(
        void * context,
        const chip::app::DataModel::DecodableList<chip::app::Clusters::UserLabel::Structs::LabelStruct::DecodableType> & value);
};

class MTRUserLabelLabelListListAttributeCallbackSubscriptionBridge : public MTRUserLabelLabelListListAttributeCallbackBridge
{
public:
    MTRUserLabelLabelListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action,
                                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUserLabelLabelListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUserLabelLabelListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUserLabelLabelListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUserLabelGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<UserLabelGeneratedCommandListListAttributeCallback>
{
public:
    MTRUserLabelGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UserLabelGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUserLabelGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<UserLabelGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRUserLabelGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRUserLabelGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRUserLabelGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUserLabelGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUserLabelGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUserLabelGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUserLabelAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<UserLabelAcceptedCommandListListAttributeCallback>
{
public:
    MTRUserLabelAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UserLabelAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUserLabelAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<UserLabelAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRUserLabelAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRUserLabelAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRUserLabelAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUserLabelAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUserLabelAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUserLabelAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUserLabelEventListListAttributeCallbackBridge : public MTRCallbackBridge<UserLabelEventListListAttributeCallback>
{
public:
    MTRUserLabelEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UserLabelEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUserLabelEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<UserLabelEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRUserLabelEventListListAttributeCallbackSubscriptionBridge : public MTRUserLabelEventListListAttributeCallbackBridge
{
public:
    MTRUserLabelEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action,
                                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUserLabelEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUserLabelEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUserLabelEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUserLabelAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<UserLabelAttributeListListAttributeCallback>
{
public:
    MTRUserLabelAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UserLabelAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUserLabelAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<UserLabelAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRUserLabelAttributeListListAttributeCallbackSubscriptionBridge : public MTRUserLabelAttributeListListAttributeCallbackBridge
{
public:
    MTRUserLabelAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action,
                                                                     MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUserLabelAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUserLabelAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUserLabelAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRProxyConfigurationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<ProxyConfigurationEventListListAttributeCallback>
{
public:
    MTRProxyConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ProxyConfigurationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRProxyConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<ProxyConfigurationEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRProxyConfigurationEventListListAttributeCallbackSubscriptionBridge
    : public MTRProxyConfigurationEventListListAttributeCallbackBridge
{
public:
    MTRProxyConfigurationEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRProxyConfigurationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRProxyConfigurationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRProxyConfigurationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRProxyDiscoveryEventListListAttributeCallbackBridge : public MTRCallbackBridge<ProxyDiscoveryEventListListAttributeCallback>
{
public:
    MTRProxyDiscoveryEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ProxyDiscoveryEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRProxyDiscoveryEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ProxyDiscoveryEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRProxyDiscoveryEventListListAttributeCallbackSubscriptionBridge
    : public MTRProxyDiscoveryEventListListAttributeCallbackBridge
{
public:
    MTRProxyDiscoveryEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action,
                                                                      MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRProxyDiscoveryEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRProxyDiscoveryEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRProxyDiscoveryEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRProxyValidEventListListAttributeCallbackBridge : public MTRCallbackBridge<ProxyValidEventListListAttributeCallback>
{
public:
    MTRProxyValidEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ProxyValidEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRProxyValidEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ProxyValidEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRProxyValidEventListListAttributeCallbackSubscriptionBridge : public MTRProxyValidEventListListAttributeCallbackBridge
{
public:
    MTRProxyValidEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRProxyValidEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRProxyValidEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRProxyValidEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBooleanStateGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BooleanStateGeneratedCommandListListAttributeCallback>
{
public:
    MTRBooleanStateGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BooleanStateGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBooleanStateGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<BooleanStateGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBooleanStateGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBooleanStateGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRBooleanStateGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBooleanStateGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBooleanStateGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBooleanStateGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBooleanStateAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BooleanStateAcceptedCommandListListAttributeCallback>
{
public:
    MTRBooleanStateAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BooleanStateAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBooleanStateAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<BooleanStateAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBooleanStateAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBooleanStateAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRBooleanStateAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBooleanStateAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBooleanStateAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBooleanStateAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBooleanStateEventListListAttributeCallbackBridge : public MTRCallbackBridge<BooleanStateEventListListAttributeCallback>
{
public:
    MTRBooleanStateEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BooleanStateEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBooleanStateEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<BooleanStateEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRBooleanStateEventListListAttributeCallbackSubscriptionBridge : public MTRBooleanStateEventListListAttributeCallbackBridge
{
public:
    MTRBooleanStateEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action,
                                                                    MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBooleanStateEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBooleanStateEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBooleanStateEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBooleanStateAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<BooleanStateAttributeListListAttributeCallback>
{
public:
    MTRBooleanStateAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BooleanStateAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBooleanStateAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<BooleanStateAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRBooleanStateAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRBooleanStateAttributeListListAttributeCallbackBridge
{
public:
    MTRBooleanStateAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBooleanStateAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBooleanStateAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBooleanStateAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRModeSelectSupportedModesListAttributeCallbackBridge
    : public MTRCallbackBridge<ModeSelectSupportedModesListAttributeCallback>
{
public:
    MTRModeSelectSupportedModesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ModeSelectSupportedModesListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRModeSelectSupportedModesListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ModeSelectSupportedModesListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(
        void * context,
        const chip::app::DataModel::DecodableList<chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::DecodableType> &
            value);
};

class MTRModeSelectSupportedModesListAttributeCallbackSubscriptionBridge
    : public MTRModeSelectSupportedModesListAttributeCallbackBridge
{
public:
    MTRModeSelectSupportedModesListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action,
                                                                       MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRModeSelectSupportedModesListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRModeSelectSupportedModesListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRModeSelectSupportedModesListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRModeSelectGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ModeSelectGeneratedCommandListListAttributeCallback>
{
public:
    MTRModeSelectGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ModeSelectGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRModeSelectGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action) :
        MTRCallbackBridge<ModeSelectGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRModeSelectGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRModeSelectGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRModeSelectGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action,
                                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRModeSelectGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRModeSelectGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRModeSelectGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRModeSelectAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ModeSelectAcceptedCommandListListAttributeCallback>
{
public:
    MTRModeSelectAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ModeSelectAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRModeSelectAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<ModeSelectAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRModeSelectAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRModeSelectAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRModeSelectAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRModeSelectAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRModeSelectAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRModeSelectAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRModeSelectEventListListAttributeCallbackBridge : public MTRCallbackBridge<ModeSelectEventListListAttributeCallback>
{
public:
    MTRModeSelectEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ModeSelectEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRModeSelectEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ModeSelectEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRModeSelectEventListListAttributeCallbackSubscriptionBridge : public MTRModeSelectEventListListAttributeCallbackBridge
{
public:
    MTRModeSelectEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRModeSelectEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRModeSelectEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRModeSelectEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRModeSelectAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<ModeSelectAttributeListListAttributeCallback>
{
public:
    MTRModeSelectAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ModeSelectAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRModeSelectAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ModeSelectAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRModeSelectAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRModeSelectAttributeListListAttributeCallbackBridge
{
public:
    MTRModeSelectAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action,
                                                                      MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRModeSelectAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRModeSelectAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRModeSelectAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTemperatureControlSupportedTemperatureLevelsListAttributeCallbackBridge
    : public MTRCallbackBridge<TemperatureControlSupportedTemperatureLevelsListAttributeCallback>
{
public:
    MTRTemperatureControlSupportedTemperatureLevelsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TemperatureControlSupportedTemperatureLevelsListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTemperatureControlSupportedTemperatureLevelsListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<TemperatureControlSupportedTemperatureLevelsListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<
                                chip::app::Clusters::TemperatureControl::Structs::TemperatureLevelStruct::DecodableType> & value);
};

class MTRTemperatureControlSupportedTemperatureLevelsListAttributeCallbackSubscriptionBridge
    : public MTRTemperatureControlSupportedTemperatureLevelsListAttributeCallbackBridge
{
public:
    MTRTemperatureControlSupportedTemperatureLevelsListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTemperatureControlSupportedTemperatureLevelsListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTemperatureControlSupportedTemperatureLevelsListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTemperatureControlSupportedTemperatureLevelsListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTemperatureControlGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<TemperatureControlGeneratedCommandListListAttributeCallback>
{
public:
    MTRTemperatureControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TemperatureControlGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTemperatureControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<TemperatureControlGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRTemperatureControlGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRTemperatureControlGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRTemperatureControlGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTemperatureControlGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTemperatureControlGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTemperatureControlGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTemperatureControlAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<TemperatureControlAcceptedCommandListListAttributeCallback>
{
public:
    MTRTemperatureControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TemperatureControlAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTemperatureControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<TemperatureControlAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRTemperatureControlAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRTemperatureControlAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRTemperatureControlAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTemperatureControlAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTemperatureControlAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTemperatureControlAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTemperatureControlEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<TemperatureControlEventListListAttributeCallback>
{
public:
    MTRTemperatureControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TemperatureControlEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTemperatureControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<TemperatureControlEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRTemperatureControlEventListListAttributeCallbackSubscriptionBridge
    : public MTRTemperatureControlEventListListAttributeCallbackBridge
{
public:
    MTRTemperatureControlEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTemperatureControlEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTemperatureControlEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTemperatureControlEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTemperatureControlAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<TemperatureControlAttributeListListAttributeCallback>
{
public:
    MTRTemperatureControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TemperatureControlAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTemperatureControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<TemperatureControlAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRTemperatureControlAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRTemperatureControlAttributeListListAttributeCallbackBridge
{
public:
    MTRTemperatureControlAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTemperatureControlAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTemperatureControlAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTemperatureControlAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRRefrigeratorAlarmMaskAttributeCallbackBridge : public MTRCallbackBridge<RefrigeratorAlarmMaskAttributeCallback>
{
public:
    MTRRefrigeratorAlarmMaskAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<RefrigeratorAlarmMaskAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRRefrigeratorAlarmMaskAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<RefrigeratorAlarmMaskAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmMap> value);
};

class MTRRefrigeratorAlarmMaskAttributeCallbackSubscriptionBridge : public MTRRefrigeratorAlarmMaskAttributeCallbackBridge
{
public:
    MTRRefrigeratorAlarmMaskAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action,
                                                                MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRRefrigeratorAlarmMaskAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRRefrigeratorAlarmMaskAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRRefrigeratorAlarmMaskAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRRefrigeratorAlarmLatchAttributeCallbackBridge : public MTRCallbackBridge<RefrigeratorAlarmLatchAttributeCallback>
{
public:
    MTRRefrigeratorAlarmLatchAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<RefrigeratorAlarmLatchAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRRefrigeratorAlarmLatchAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<RefrigeratorAlarmLatchAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmMap> value);
};

class MTRRefrigeratorAlarmLatchAttributeCallbackSubscriptionBridge : public MTRRefrigeratorAlarmLatchAttributeCallbackBridge
{
public:
    MTRRefrigeratorAlarmLatchAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action,
                                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRRefrigeratorAlarmLatchAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRRefrigeratorAlarmLatchAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRRefrigeratorAlarmLatchAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRRefrigeratorAlarmStateAttributeCallbackBridge : public MTRCallbackBridge<RefrigeratorAlarmStateAttributeCallback>
{
public:
    MTRRefrigeratorAlarmStateAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<RefrigeratorAlarmStateAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRRefrigeratorAlarmStateAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<RefrigeratorAlarmStateAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::RefrigeratorAlarm::AlarmMap> value);
};

class MTRRefrigeratorAlarmStateAttributeCallbackSubscriptionBridge : public MTRRefrigeratorAlarmStateAttributeCallbackBridge
{
public:
    MTRRefrigeratorAlarmStateAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action,
                                                                 MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRRefrigeratorAlarmStateAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRRefrigeratorAlarmStateAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRRefrigeratorAlarmStateAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRRefrigeratorAlarmGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<RefrigeratorAlarmGeneratedCommandListListAttributeCallback>
{
public:
    MTRRefrigeratorAlarmGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<RefrigeratorAlarmGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRRefrigeratorAlarmGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<RefrigeratorAlarmGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRRefrigeratorAlarmGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRRefrigeratorAlarmGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRRefrigeratorAlarmGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRRefrigeratorAlarmGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRRefrigeratorAlarmGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRRefrigeratorAlarmGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRRefrigeratorAlarmAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<RefrigeratorAlarmAcceptedCommandListListAttributeCallback>
{
public:
    MTRRefrigeratorAlarmAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<RefrigeratorAlarmAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRRefrigeratorAlarmAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action) :
        MTRCallbackBridge<RefrigeratorAlarmAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRRefrigeratorAlarmAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRRefrigeratorAlarmAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRRefrigeratorAlarmAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRRefrigeratorAlarmAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRRefrigeratorAlarmAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRRefrigeratorAlarmAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRRefrigeratorAlarmEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<RefrigeratorAlarmEventListListAttributeCallback>
{
public:
    MTRRefrigeratorAlarmEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<RefrigeratorAlarmEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRRefrigeratorAlarmEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                             MTRActionBlock action) :
        MTRCallbackBridge<RefrigeratorAlarmEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRRefrigeratorAlarmEventListListAttributeCallbackSubscriptionBridge
    : public MTRRefrigeratorAlarmEventListListAttributeCallbackBridge
{
public:
    MTRRefrigeratorAlarmEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action,
                                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRRefrigeratorAlarmEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRRefrigeratorAlarmEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRRefrigeratorAlarmEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRRefrigeratorAlarmAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<RefrigeratorAlarmAttributeListListAttributeCallback>
{
public:
    MTRRefrigeratorAlarmAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<RefrigeratorAlarmAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRRefrigeratorAlarmAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action) :
        MTRCallbackBridge<RefrigeratorAlarmAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRRefrigeratorAlarmAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRRefrigeratorAlarmAttributeListListAttributeCallbackBridge
{
public:
    MTRRefrigeratorAlarmAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action,
                                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRRefrigeratorAlarmAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRRefrigeratorAlarmAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRRefrigeratorAlarmAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAirQualityGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<AirQualityGeneratedCommandListListAttributeCallback>
{
public:
    MTRAirQualityGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AirQualityGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAirQualityGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action) :
        MTRCallbackBridge<AirQualityGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRAirQualityGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRAirQualityGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRAirQualityGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action,
                                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAirQualityGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAirQualityGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAirQualityGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAirQualityAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<AirQualityAcceptedCommandListListAttributeCallback>
{
public:
    MTRAirQualityAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AirQualityAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAirQualityAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<AirQualityAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRAirQualityAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRAirQualityAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRAirQualityAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAirQualityAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAirQualityAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAirQualityAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAirQualityEventListListAttributeCallbackBridge : public MTRCallbackBridge<AirQualityEventListListAttributeCallback>
{
public:
    MTRAirQualityEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AirQualityEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAirQualityEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<AirQualityEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRAirQualityEventListListAttributeCallbackSubscriptionBridge : public MTRAirQualityEventListListAttributeCallbackBridge
{
public:
    MTRAirQualityEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAirQualityEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAirQualityEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAirQualityEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRAirQualityAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<AirQualityAttributeListListAttributeCallback>
{
public:
    MTRAirQualityAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<AirQualityAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRAirQualityAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<AirQualityAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRAirQualityAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRAirQualityAttributeListListAttributeCallbackBridge
{
public:
    MTRAirQualityAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action,
                                                                      MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRAirQualityAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRAirQualityAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRAirQualityAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSmokeCOAlarmGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<SmokeCOAlarmGeneratedCommandListListAttributeCallback>
{
public:
    MTRSmokeCOAlarmGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SmokeCOAlarmGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSmokeCOAlarmGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<SmokeCOAlarmGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRSmokeCOAlarmGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRSmokeCOAlarmGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRSmokeCOAlarmGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSmokeCOAlarmGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSmokeCOAlarmGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSmokeCOAlarmGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSmokeCOAlarmAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<SmokeCOAlarmAcceptedCommandListListAttributeCallback>
{
public:
    MTRSmokeCOAlarmAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SmokeCOAlarmAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSmokeCOAlarmAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<SmokeCOAlarmAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRSmokeCOAlarmAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRSmokeCOAlarmAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRSmokeCOAlarmAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSmokeCOAlarmAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSmokeCOAlarmAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSmokeCOAlarmAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSmokeCOAlarmEventListListAttributeCallbackBridge : public MTRCallbackBridge<SmokeCOAlarmEventListListAttributeCallback>
{
public:
    MTRSmokeCOAlarmEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SmokeCOAlarmEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSmokeCOAlarmEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<SmokeCOAlarmEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRSmokeCOAlarmEventListListAttributeCallbackSubscriptionBridge : public MTRSmokeCOAlarmEventListListAttributeCallbackBridge
{
public:
    MTRSmokeCOAlarmEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action,
                                                                    MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSmokeCOAlarmEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSmokeCOAlarmEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSmokeCOAlarmEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSmokeCOAlarmAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<SmokeCOAlarmAttributeListListAttributeCallback>
{
public:
    MTRSmokeCOAlarmAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SmokeCOAlarmAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSmokeCOAlarmAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<SmokeCOAlarmAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRSmokeCOAlarmAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRSmokeCOAlarmAttributeListListAttributeCallbackBridge
{
public:
    MTRSmokeCOAlarmAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSmokeCOAlarmAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSmokeCOAlarmAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSmokeCOAlarmAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalStatePhaseListListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalStatePhaseListListAttributeCallback>
{
public:
    MTROperationalStatePhaseListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalStatePhaseListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalStatePhaseListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<OperationalStatePhaseListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::Nullable<chip::app::DataModel::DecodableList<chip::CharSpan>> & value);
};

class MTROperationalStatePhaseListListAttributeCallbackSubscriptionBridge
    : public MTROperationalStatePhaseListListAttributeCallbackBridge
{
public:
    MTROperationalStatePhaseListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalStatePhaseListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalStatePhaseListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalStatePhaseListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalStateOperationalStateListListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalStateOperationalStateListListAttributeCallback>
{
public:
    MTROperationalStateOperationalStateListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalStateOperationalStateListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalStateOperationalStateListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action) :
        MTRCallbackBridge<OperationalStateOperationalStateListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::DataModel::DecodableList<
                                chip::app::Clusters::OperationalState::Structs::OperationalStateStruct::DecodableType> & value);
};

class MTROperationalStateOperationalStateListListAttributeCallbackSubscriptionBridge
    : public MTROperationalStateOperationalStateListListAttributeCallbackBridge
{
public:
    MTROperationalStateOperationalStateListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalStateOperationalStateListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalStateOperationalStateListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalStateOperationalStateListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalStateOperationalStateStructAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalStateOperationalStateStructAttributeCallback>
{
public:
    MTROperationalStateOperationalStateStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalStateOperationalStateStructAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalStateOperationalStateStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action) :
        MTRCallbackBridge<OperationalStateOperationalStateStructAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::Clusters::OperationalState::Structs::OperationalStateStruct::DecodableType & value);
};

class MTROperationalStateOperationalStateStructAttributeCallbackSubscriptionBridge
    : public MTROperationalStateOperationalStateStructAttributeCallbackBridge
{
public:
    MTROperationalStateOperationalStateStructAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalStateOperationalStateStructAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalStateOperationalStateStructAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalStateOperationalStateStructAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalStateOperationalErrorStructAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalStateOperationalErrorStructAttributeCallback>
{
public:
    MTROperationalStateOperationalErrorStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalStateOperationalErrorStructAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalStateOperationalErrorStructAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action) :
        MTRCallbackBridge<OperationalStateOperationalErrorStructAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            const chip::app::Clusters::OperationalState::Structs::ErrorStateStruct::DecodableType & value);
};

class MTROperationalStateOperationalErrorStructAttributeCallbackSubscriptionBridge
    : public MTROperationalStateOperationalErrorStructAttributeCallbackBridge
{
public:
    MTROperationalStateOperationalErrorStructAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalStateOperationalErrorStructAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalStateOperationalErrorStructAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalStateOperationalErrorStructAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalStateGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalStateGeneratedCommandListListAttributeCallback>
{
public:
    MTROperationalStateGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalStateGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalStateGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action) :
        MTRCallbackBridge<OperationalStateGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROperationalStateGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROperationalStateGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTROperationalStateGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalStateGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalStateGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalStateGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalStateAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalStateAcceptedCommandListListAttributeCallback>
{
public:
    MTROperationalStateAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalStateAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalStateAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<OperationalStateAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROperationalStateAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROperationalStateAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTROperationalStateAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalStateAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalStateAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalStateAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalStateEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalStateEventListListAttributeCallback>
{
public:
    MTROperationalStateEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalStateEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalStateEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<OperationalStateEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTROperationalStateEventListListAttributeCallbackSubscriptionBridge
    : public MTROperationalStateEventListListAttributeCallbackBridge
{
public:
    MTROperationalStateEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalStateEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalStateEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalStateEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROperationalStateAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<OperationalStateAttributeListListAttributeCallback>
{
public:
    MTROperationalStateAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OperationalStateAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROperationalStateAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<OperationalStateAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTROperationalStateAttributeListListAttributeCallbackSubscriptionBridge
    : public MTROperationalStateAttributeListListAttributeCallbackBridge
{
public:
    MTROperationalStateAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROperationalStateAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROperationalStateAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROperationalStateAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHEPAFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<HEPAFilterMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTRHEPAFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<HEPAFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHEPAFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action) :
        MTRCallbackBridge<HEPAFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRHEPAFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRHEPAFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRHEPAFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHEPAFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHEPAFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHEPAFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHEPAFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<HEPAFilterMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTRHEPAFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<HEPAFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHEPAFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action) :
        MTRCallbackBridge<HEPAFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRHEPAFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRHEPAFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRHEPAFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHEPAFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHEPAFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHEPAFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHEPAFilterMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<HEPAFilterMonitoringEventListListAttributeCallback>
{
public:
    MTRHEPAFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<HEPAFilterMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHEPAFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<HEPAFilterMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRHEPAFilterMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTRHEPAFilterMonitoringEventListListAttributeCallbackBridge
{
public:
    MTRHEPAFilterMonitoringEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHEPAFilterMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHEPAFilterMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHEPAFilterMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHEPAFilterMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<HEPAFilterMonitoringAttributeListListAttributeCallback>
{
public:
    MTRHEPAFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<HEPAFilterMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHEPAFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<HEPAFilterMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRHEPAFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRHEPAFilterMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTRHEPAFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHEPAFilterMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHEPAFilterMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHEPAFilterMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTRActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler) :
        MTRCallbackBridge<ActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler,
                                                                                      MTRActionBlock action) :
        MTRCallbackBridge<ActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                    OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRActivatedCarbonFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTRActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler) :
        MTRCallbackBridge<ActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler,
                                                                                     MTRActionBlock action) :
        MTRCallbackBridge<ActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                   OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRActivatedCarbonFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRActivatedCarbonFilterMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<ActivatedCarbonFilterMonitoringEventListListAttributeCallback>
{
public:
    MTRActivatedCarbonFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ActivatedCarbonFilterMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRActivatedCarbonFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action) :
        MTRCallbackBridge<ActivatedCarbonFilterMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRActivatedCarbonFilterMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTRActivatedCarbonFilterMonitoringEventListListAttributeCallbackBridge
{
public:
    MTRActivatedCarbonFilterMonitoringEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRActivatedCarbonFilterMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRActivatedCarbonFilterMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRActivatedCarbonFilterMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRActivatedCarbonFilterMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<ActivatedCarbonFilterMonitoringAttributeListListAttributeCallback>
{
public:
    MTRActivatedCarbonFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ActivatedCarbonFilterMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRActivatedCarbonFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<ActivatedCarbonFilterMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRActivatedCarbonFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRActivatedCarbonFilterMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTRActivatedCarbonFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRActivatedCarbonFilterMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRActivatedCarbonFilterMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRActivatedCarbonFilterMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCeramicFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<CeramicFilterMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTRCeramicFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<CeramicFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRCeramicFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                              MTRActionBlock action) :
        MTRCallbackBridge<CeramicFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRCeramicFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRCeramicFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRCeramicFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCeramicFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCeramicFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCeramicFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCeramicFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<CeramicFilterMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTRCeramicFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<CeramicFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRCeramicFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action) :
        MTRCallbackBridge<CeramicFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRCeramicFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRCeramicFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRCeramicFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCeramicFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCeramicFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCeramicFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCeramicFilterMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<CeramicFilterMonitoringEventListListAttributeCallback>
{
public:
    MTRCeramicFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<CeramicFilterMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRCeramicFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<CeramicFilterMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRCeramicFilterMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTRCeramicFilterMonitoringEventListListAttributeCallbackBridge
{
public:
    MTRCeramicFilterMonitoringEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCeramicFilterMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCeramicFilterMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCeramicFilterMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCeramicFilterMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<CeramicFilterMonitoringAttributeListListAttributeCallback>
{
public:
    MTRCeramicFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<CeramicFilterMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRCeramicFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action) :
        MTRCallbackBridge<CeramicFilterMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRCeramicFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRCeramicFilterMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTRCeramicFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCeramicFilterMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCeramicFilterMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCeramicFilterMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTRElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                    ResponseHandler handler) :
        MTRCallbackBridge<ElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                    MTRActionBlock action) :
        MTRCallbackBridge<ElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                  OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRElectrostaticFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTRElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                   ResponseHandler handler) :
        MTRCallbackBridge<ElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                   MTRActionBlock action) :
        MTRCallbackBridge<ElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                 OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRElectrostaticFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRElectrostaticFilterMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<ElectrostaticFilterMonitoringEventListListAttributeCallback>
{
public:
    MTRElectrostaticFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ElectrostaticFilterMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRElectrostaticFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<ElectrostaticFilterMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRElectrostaticFilterMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTRElectrostaticFilterMonitoringEventListListAttributeCallbackBridge
{
public:
    MTRElectrostaticFilterMonitoringEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRElectrostaticFilterMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRElectrostaticFilterMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRElectrostaticFilterMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRElectrostaticFilterMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<ElectrostaticFilterMonitoringAttributeListListAttributeCallback>
{
public:
    MTRElectrostaticFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ElectrostaticFilterMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRElectrostaticFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action) :
        MTRCallbackBridge<ElectrostaticFilterMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRElectrostaticFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRElectrostaticFilterMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTRElectrostaticFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRElectrostaticFilterMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRElectrostaticFilterMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRElectrostaticFilterMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUVFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<UVFilterMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTRUVFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UVFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUVFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<UVFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRUVFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRUVFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRUVFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUVFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUVFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUVFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUVFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<UVFilterMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTRUVFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UVFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUVFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<UVFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRUVFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRUVFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRUVFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUVFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUVFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUVFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUVFilterMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<UVFilterMonitoringEventListListAttributeCallback>
{
public:
    MTRUVFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UVFilterMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUVFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<UVFilterMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRUVFilterMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTRUVFilterMonitoringEventListListAttributeCallbackBridge
{
public:
    MTRUVFilterMonitoringEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUVFilterMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUVFilterMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUVFilterMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRUVFilterMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<UVFilterMonitoringAttributeListListAttributeCallback>
{
public:
    MTRUVFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<UVFilterMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRUVFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<UVFilterMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRUVFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRUVFilterMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTRUVFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRUVFilterMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRUVFilterMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRUVFilterMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIonizingFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<IonizingFilterMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTRIonizingFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IonizingFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIonizingFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<IonizingFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRIonizingFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRIonizingFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRIonizingFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIonizingFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIonizingFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIonizingFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIonizingFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<IonizingFilterMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTRIonizingFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IonizingFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIonizingFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                              MTRActionBlock action) :
        MTRCallbackBridge<IonizingFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRIonizingFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRIonizingFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRIonizingFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIonizingFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIonizingFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIonizingFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIonizingFilterMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<IonizingFilterMonitoringEventListListAttributeCallback>
{
public:
    MTRIonizingFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IonizingFilterMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIonizingFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<IonizingFilterMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRIonizingFilterMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTRIonizingFilterMonitoringEventListListAttributeCallbackBridge
{
public:
    MTRIonizingFilterMonitoringEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIonizingFilterMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIonizingFilterMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIonizingFilterMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIonizingFilterMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<IonizingFilterMonitoringAttributeListListAttributeCallback>
{
public:
    MTRIonizingFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IonizingFilterMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIonizingFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<IonizingFilterMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRIonizingFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRIonizingFilterMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTRIonizingFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIonizingFilterMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIonizingFilterMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIonizingFilterMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRZeoliteFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ZeoliteFilterMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTRZeoliteFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ZeoliteFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRZeoliteFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                              MTRActionBlock action) :
        MTRCallbackBridge<ZeoliteFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRZeoliteFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRZeoliteFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRZeoliteFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRZeoliteFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRZeoliteFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRZeoliteFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRZeoliteFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ZeoliteFilterMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTRZeoliteFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ZeoliteFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRZeoliteFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action) :
        MTRCallbackBridge<ZeoliteFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRZeoliteFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRZeoliteFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRZeoliteFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRZeoliteFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRZeoliteFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRZeoliteFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRZeoliteFilterMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<ZeoliteFilterMonitoringEventListListAttributeCallback>
{
public:
    MTRZeoliteFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ZeoliteFilterMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRZeoliteFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<ZeoliteFilterMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRZeoliteFilterMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTRZeoliteFilterMonitoringEventListListAttributeCallbackBridge
{
public:
    MTRZeoliteFilterMonitoringEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRZeoliteFilterMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRZeoliteFilterMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRZeoliteFilterMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRZeoliteFilterMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<ZeoliteFilterMonitoringAttributeListListAttributeCallback>
{
public:
    MTRZeoliteFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ZeoliteFilterMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRZeoliteFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action) :
        MTRCallbackBridge<ZeoliteFilterMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRZeoliteFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRZeoliteFilterMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTRZeoliteFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRZeoliteFilterMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRZeoliteFilterMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRZeoliteFilterMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROzoneFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OzoneFilterMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTROzoneFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OzoneFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROzoneFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<OzoneFilterMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROzoneFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROzoneFilterMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTROzoneFilterMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROzoneFilterMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROzoneFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROzoneFilterMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROzoneFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OzoneFilterMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTROzoneFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OzoneFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROzoneFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action) :
        MTRCallbackBridge<OzoneFilterMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROzoneFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROzoneFilterMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTROzoneFilterMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROzoneFilterMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROzoneFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROzoneFilterMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROzoneFilterMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<OzoneFilterMonitoringEventListListAttributeCallback>
{
public:
    MTROzoneFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OzoneFilterMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROzoneFilterMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action) :
        MTRCallbackBridge<OzoneFilterMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTROzoneFilterMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTROzoneFilterMonitoringEventListListAttributeCallbackBridge
{
public:
    MTROzoneFilterMonitoringEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action,
                                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROzoneFilterMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROzoneFilterMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROzoneFilterMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROzoneFilterMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<OzoneFilterMonitoringAttributeListListAttributeCallback>
{
public:
    MTROzoneFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OzoneFilterMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROzoneFilterMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action) :
        MTRCallbackBridge<OzoneFilterMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTROzoneFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTROzoneFilterMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTROzoneFilterMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROzoneFilterMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROzoneFilterMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROzoneFilterMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWaterTankMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<WaterTankMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTRWaterTankMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WaterTankMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWaterTankMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action) :
        MTRCallbackBridge<WaterTankMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRWaterTankMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRWaterTankMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRWaterTankMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWaterTankMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWaterTankMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWaterTankMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWaterTankMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<WaterTankMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTRWaterTankMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WaterTankMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWaterTankMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<WaterTankMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRWaterTankMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRWaterTankMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRWaterTankMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWaterTankMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWaterTankMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWaterTankMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWaterTankMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<WaterTankMonitoringEventListListAttributeCallback>
{
public:
    MTRWaterTankMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WaterTankMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWaterTankMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<WaterTankMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRWaterTankMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTRWaterTankMonitoringEventListListAttributeCallbackBridge
{
public:
    MTRWaterTankMonitoringEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWaterTankMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWaterTankMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWaterTankMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWaterTankMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<WaterTankMonitoringAttributeListListAttributeCallback>
{
public:
    MTRWaterTankMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WaterTankMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWaterTankMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<WaterTankMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRWaterTankMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRWaterTankMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTRWaterTankMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWaterTankMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWaterTankMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWaterTankMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFuelTankMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FuelTankMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTRFuelTankMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FuelTankMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFuelTankMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<FuelTankMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFuelTankMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFuelTankMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRFuelTankMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFuelTankMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFuelTankMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFuelTankMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFuelTankMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FuelTankMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTRFuelTankMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FuelTankMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFuelTankMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<FuelTankMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFuelTankMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFuelTankMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRFuelTankMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFuelTankMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFuelTankMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFuelTankMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFuelTankMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<FuelTankMonitoringEventListListAttributeCallback>
{
public:
    MTRFuelTankMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FuelTankMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFuelTankMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<FuelTankMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRFuelTankMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTRFuelTankMonitoringEventListListAttributeCallbackBridge
{
public:
    MTRFuelTankMonitoringEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFuelTankMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFuelTankMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFuelTankMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFuelTankMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<FuelTankMonitoringAttributeListListAttributeCallback>
{
public:
    MTRFuelTankMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FuelTankMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFuelTankMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<FuelTankMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRFuelTankMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRFuelTankMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTRFuelTankMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFuelTankMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFuelTankMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFuelTankMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInkCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<InkCartridgeMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTRInkCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<InkCartridgeMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInkCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action) :
        MTRCallbackBridge<InkCartridgeMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRInkCartridgeMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRInkCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRInkCartridgeMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInkCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInkCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInkCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInkCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<InkCartridgeMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTRInkCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<InkCartridgeMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInkCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<InkCartridgeMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRInkCartridgeMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRInkCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRInkCartridgeMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInkCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInkCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInkCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInkCartridgeMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<InkCartridgeMonitoringEventListListAttributeCallback>
{
public:
    MTRInkCartridgeMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<InkCartridgeMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInkCartridgeMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<InkCartridgeMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRInkCartridgeMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTRInkCartridgeMonitoringEventListListAttributeCallbackBridge
{
public:
    MTRInkCartridgeMonitoringEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInkCartridgeMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInkCartridgeMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInkCartridgeMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRInkCartridgeMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<InkCartridgeMonitoringAttributeListListAttributeCallback>
{
public:
    MTRInkCartridgeMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<InkCartridgeMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRInkCartridgeMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<InkCartridgeMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRInkCartridgeMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRInkCartridgeMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTRInkCartridgeMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRInkCartridgeMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRInkCartridgeMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRInkCartridgeMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTonerCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<TonerCartridgeMonitoringGeneratedCommandListListAttributeCallback>
{
public:
    MTRTonerCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TonerCartridgeMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTonerCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<TonerCartridgeMonitoringGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRTonerCartridgeMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRTonerCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRTonerCartridgeMonitoringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTonerCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTonerCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTonerCartridgeMonitoringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTonerCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<TonerCartridgeMonitoringAcceptedCommandListListAttributeCallback>
{
public:
    MTRTonerCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TonerCartridgeMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTonerCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                              MTRActionBlock action) :
        MTRCallbackBridge<TonerCartridgeMonitoringAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRTonerCartridgeMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRTonerCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRTonerCartridgeMonitoringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTonerCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTonerCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTonerCartridgeMonitoringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTonerCartridgeMonitoringEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<TonerCartridgeMonitoringEventListListAttributeCallback>
{
public:
    MTRTonerCartridgeMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TonerCartridgeMonitoringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTonerCartridgeMonitoringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<TonerCartridgeMonitoringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRTonerCartridgeMonitoringEventListListAttributeCallbackSubscriptionBridge
    : public MTRTonerCartridgeMonitoringEventListListAttributeCallbackBridge
{
public:
    MTRTonerCartridgeMonitoringEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTonerCartridgeMonitoringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTonerCartridgeMonitoringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTonerCartridgeMonitoringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTonerCartridgeMonitoringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<TonerCartridgeMonitoringAttributeListListAttributeCallback>
{
public:
    MTRTonerCartridgeMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TonerCartridgeMonitoringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTonerCartridgeMonitoringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<TonerCartridgeMonitoringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRTonerCartridgeMonitoringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRTonerCartridgeMonitoringAttributeListListAttributeCallbackBridge
{
public:
    MTRTonerCartridgeMonitoringAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTonerCartridgeMonitoringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTonerCartridgeMonitoringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTonerCartridgeMonitoringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDoorLockCredentialRulesSupportAttributeCallbackBridge
    : public MTRCallbackBridge<DoorLockCredentialRulesSupportAttributeCallback>
{
public:
    MTRDoorLockCredentialRulesSupportAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DoorLockCredentialRulesSupportAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDoorLockCredentialRulesSupportAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                             MTRActionBlock action) :
        MTRCallbackBridge<DoorLockCredentialRulesSupportAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::DoorLock::DlCredentialRuleMask> value);
};

class MTRDoorLockCredentialRulesSupportAttributeCallbackSubscriptionBridge
    : public MTRDoorLockCredentialRulesSupportAttributeCallbackBridge
{
public:
    MTRDoorLockCredentialRulesSupportAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action,
                                                                         MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDoorLockCredentialRulesSupportAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDoorLockCredentialRulesSupportAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDoorLockCredentialRulesSupportAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDoorLockSupportedOperatingModesAttributeCallbackBridge
    : public MTRCallbackBridge<DoorLockSupportedOperatingModesAttributeCallback>
{
public:
    MTRDoorLockSupportedOperatingModesAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DoorLockSupportedOperatingModesAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDoorLockSupportedOperatingModesAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<DoorLockSupportedOperatingModesAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::DoorLock::DlSupportedOperatingModes> value);
};

class MTRDoorLockSupportedOperatingModesAttributeCallbackSubscriptionBridge
    : public MTRDoorLockSupportedOperatingModesAttributeCallbackBridge
{
public:
    MTRDoorLockSupportedOperatingModesAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDoorLockSupportedOperatingModesAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDoorLockSupportedOperatingModesAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDoorLockSupportedOperatingModesAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDoorLockDefaultConfigurationRegisterAttributeCallbackBridge
    : public MTRCallbackBridge<DoorLockDefaultConfigurationRegisterAttributeCallback>
{
public:
    MTRDoorLockDefaultConfigurationRegisterAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DoorLockDefaultConfigurationRegisterAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDoorLockDefaultConfigurationRegisterAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<DoorLockDefaultConfigurationRegisterAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::DoorLock::DlDefaultConfigurationRegister> value);
};

class MTRDoorLockDefaultConfigurationRegisterAttributeCallbackSubscriptionBridge
    : public MTRDoorLockDefaultConfigurationRegisterAttributeCallbackBridge
{
public:
    MTRDoorLockDefaultConfigurationRegisterAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDoorLockDefaultConfigurationRegisterAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDoorLockDefaultConfigurationRegisterAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDoorLockDefaultConfigurationRegisterAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDoorLockLocalProgrammingFeaturesAttributeCallbackBridge
    : public MTRCallbackBridge<DoorLockLocalProgrammingFeaturesAttributeCallback>
{
public:
    MTRDoorLockLocalProgrammingFeaturesAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DoorLockLocalProgrammingFeaturesAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDoorLockLocalProgrammingFeaturesAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<DoorLockLocalProgrammingFeaturesAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::DoorLock::DlLocalProgrammingFeatures> value);
};

class MTRDoorLockLocalProgrammingFeaturesAttributeCallbackSubscriptionBridge
    : public MTRDoorLockLocalProgrammingFeaturesAttributeCallbackBridge
{
public:
    MTRDoorLockLocalProgrammingFeaturesAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDoorLockLocalProgrammingFeaturesAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDoorLockLocalProgrammingFeaturesAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDoorLockLocalProgrammingFeaturesAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDoorLockGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<DoorLockGeneratedCommandListListAttributeCallback>
{
public:
    MTRDoorLockGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DoorLockGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDoorLockGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<DoorLockGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRDoorLockGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRDoorLockGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRDoorLockGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDoorLockGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDoorLockGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDoorLockGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDoorLockAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<DoorLockAcceptedCommandListListAttributeCallback>
{
public:
    MTRDoorLockAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DoorLockAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDoorLockAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<DoorLockAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRDoorLockAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRDoorLockAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRDoorLockAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDoorLockAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDoorLockAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDoorLockAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDoorLockEventListListAttributeCallbackBridge : public MTRCallbackBridge<DoorLockEventListListAttributeCallback>
{
public:
    MTRDoorLockEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DoorLockEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDoorLockEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<DoorLockEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRDoorLockEventListListAttributeCallbackSubscriptionBridge : public MTRDoorLockEventListListAttributeCallbackBridge
{
public:
    MTRDoorLockEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action,
                                                                MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDoorLockEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDoorLockEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDoorLockEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDoorLockAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<DoorLockAttributeListListAttributeCallback>
{
public:
    MTRDoorLockAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<DoorLockAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDoorLockAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<DoorLockAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRDoorLockAttributeListListAttributeCallbackSubscriptionBridge : public MTRDoorLockAttributeListListAttributeCallbackBridge
{
public:
    MTRDoorLockAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action,
                                                                    MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDoorLockAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDoorLockAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDoorLockAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWindowCoveringConfigStatusAttributeCallbackBridge : public MTRCallbackBridge<WindowCoveringConfigStatusAttributeCallback>
{
public:
    MTRWindowCoveringConfigStatusAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WindowCoveringConfigStatusAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWindowCoveringConfigStatusAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<WindowCoveringConfigStatusAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::WindowCovering::ConfigStatus> value);
};

class MTRWindowCoveringConfigStatusAttributeCallbackSubscriptionBridge : public MTRWindowCoveringConfigStatusAttributeCallbackBridge
{
public:
    MTRWindowCoveringConfigStatusAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action,
                                                                     MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWindowCoveringConfigStatusAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWindowCoveringConfigStatusAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWindowCoveringConfigStatusAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWindowCoveringOperationalStatusAttributeCallbackBridge
    : public MTRCallbackBridge<WindowCoveringOperationalStatusAttributeCallback>
{
public:
    MTRWindowCoveringOperationalStatusAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WindowCoveringOperationalStatusAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWindowCoveringOperationalStatusAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<WindowCoveringOperationalStatusAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::WindowCovering::OperationalStatus> value);
};

class MTRWindowCoveringOperationalStatusAttributeCallbackSubscriptionBridge
    : public MTRWindowCoveringOperationalStatusAttributeCallbackBridge
{
public:
    MTRWindowCoveringOperationalStatusAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWindowCoveringOperationalStatusAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWindowCoveringOperationalStatusAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWindowCoveringOperationalStatusAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWindowCoveringModeAttributeCallbackBridge : public MTRCallbackBridge<WindowCoveringModeAttributeCallback>
{
public:
    MTRWindowCoveringModeAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WindowCoveringModeAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWindowCoveringModeAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<WindowCoveringModeAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::WindowCovering::Mode> value);
};

class MTRWindowCoveringModeAttributeCallbackSubscriptionBridge : public MTRWindowCoveringModeAttributeCallbackBridge
{
public:
    MTRWindowCoveringModeAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWindowCoveringModeAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWindowCoveringModeAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWindowCoveringModeAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWindowCoveringSafetyStatusAttributeCallbackBridge : public MTRCallbackBridge<WindowCoveringSafetyStatusAttributeCallback>
{
public:
    MTRWindowCoveringSafetyStatusAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WindowCoveringSafetyStatusAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWindowCoveringSafetyStatusAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<WindowCoveringSafetyStatusAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::WindowCovering::SafetyStatus> value);
};

class MTRWindowCoveringSafetyStatusAttributeCallbackSubscriptionBridge : public MTRWindowCoveringSafetyStatusAttributeCallbackBridge
{
public:
    MTRWindowCoveringSafetyStatusAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action,
                                                                     MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWindowCoveringSafetyStatusAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWindowCoveringSafetyStatusAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWindowCoveringSafetyStatusAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWindowCoveringGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<WindowCoveringGeneratedCommandListListAttributeCallback>
{
public:
    MTRWindowCoveringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WindowCoveringGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWindowCoveringGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action) :
        MTRCallbackBridge<WindowCoveringGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRWindowCoveringGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRWindowCoveringGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRWindowCoveringGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWindowCoveringGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWindowCoveringGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWindowCoveringGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWindowCoveringAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<WindowCoveringAcceptedCommandListListAttributeCallback>
{
public:
    MTRWindowCoveringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WindowCoveringAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWindowCoveringAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<WindowCoveringAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRWindowCoveringAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRWindowCoveringAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRWindowCoveringAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWindowCoveringAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWindowCoveringAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWindowCoveringAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWindowCoveringEventListListAttributeCallbackBridge : public MTRCallbackBridge<WindowCoveringEventListListAttributeCallback>
{
public:
    MTRWindowCoveringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WindowCoveringEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWindowCoveringEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<WindowCoveringEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRWindowCoveringEventListListAttributeCallbackSubscriptionBridge
    : public MTRWindowCoveringEventListListAttributeCallbackBridge
{
public:
    MTRWindowCoveringEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action,
                                                                      MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWindowCoveringEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWindowCoveringEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWindowCoveringEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRWindowCoveringAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<WindowCoveringAttributeListListAttributeCallback>
{
public:
    MTRWindowCoveringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<WindowCoveringAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRWindowCoveringAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<WindowCoveringAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRWindowCoveringAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRWindowCoveringAttributeListListAttributeCallbackBridge
{
public:
    MTRWindowCoveringAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRWindowCoveringAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRWindowCoveringAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRWindowCoveringAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBarrierControlGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BarrierControlGeneratedCommandListListAttributeCallback>
{
public:
    MTRBarrierControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BarrierControlGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBarrierControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action) :
        MTRCallbackBridge<BarrierControlGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBarrierControlGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBarrierControlGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRBarrierControlGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBarrierControlGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBarrierControlGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBarrierControlGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBarrierControlAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BarrierControlAcceptedCommandListListAttributeCallback>
{
public:
    MTRBarrierControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BarrierControlAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBarrierControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<BarrierControlAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBarrierControlAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBarrierControlAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRBarrierControlAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBarrierControlAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBarrierControlAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBarrierControlAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBarrierControlEventListListAttributeCallbackBridge : public MTRCallbackBridge<BarrierControlEventListListAttributeCallback>
{
public:
    MTRBarrierControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BarrierControlEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBarrierControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<BarrierControlEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRBarrierControlEventListListAttributeCallbackSubscriptionBridge
    : public MTRBarrierControlEventListListAttributeCallbackBridge
{
public:
    MTRBarrierControlEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action,
                                                                      MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBarrierControlEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBarrierControlEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBarrierControlEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBarrierControlAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<BarrierControlAttributeListListAttributeCallback>
{
public:
    MTRBarrierControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BarrierControlAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBarrierControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                              MTRActionBlock action) :
        MTRCallbackBridge<BarrierControlAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRBarrierControlAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRBarrierControlAttributeListListAttributeCallbackBridge
{
public:
    MTRBarrierControlAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action,
                                                                          MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBarrierControlAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBarrierControlAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBarrierControlAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPumpConfigurationAndControlPumpStatusAttributeCallbackBridge
    : public MTRCallbackBridge<PumpConfigurationAndControlPumpStatusAttributeCallback>
{
public:
    MTRPumpConfigurationAndControlPumpStatusAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PumpConfigurationAndControlPumpStatusAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPumpConfigurationAndControlPumpStatusAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<PumpConfigurationAndControlPumpStatusAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context,
                            chip::BitMask<chip::app::Clusters::PumpConfigurationAndControl::PumpStatusBitmap> value);
};

class MTRPumpConfigurationAndControlPumpStatusAttributeCallbackSubscriptionBridge
    : public MTRPumpConfigurationAndControlPumpStatusAttributeCallbackBridge
{
public:
    MTRPumpConfigurationAndControlPumpStatusAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPumpConfigurationAndControlPumpStatusAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPumpConfigurationAndControlPumpStatusAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPumpConfigurationAndControlPumpStatusAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPumpConfigurationAndControlGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<PumpConfigurationAndControlGeneratedCommandListListAttributeCallback>
{
public:
    MTRPumpConfigurationAndControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PumpConfigurationAndControlGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPumpConfigurationAndControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                  MTRActionBlock action) :
        MTRCallbackBridge<PumpConfigurationAndControlGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRPumpConfigurationAndControlGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRPumpConfigurationAndControlGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRPumpConfigurationAndControlGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPumpConfigurationAndControlGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPumpConfigurationAndControlGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPumpConfigurationAndControlGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPumpConfigurationAndControlAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<PumpConfigurationAndControlAcceptedCommandListListAttributeCallback>
{
public:
    MTRPumpConfigurationAndControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PumpConfigurationAndControlAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPumpConfigurationAndControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                 MTRActionBlock action) :
        MTRCallbackBridge<PumpConfigurationAndControlAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                               OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRPumpConfigurationAndControlAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRPumpConfigurationAndControlAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRPumpConfigurationAndControlAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPumpConfigurationAndControlAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPumpConfigurationAndControlAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPumpConfigurationAndControlAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPumpConfigurationAndControlEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<PumpConfigurationAndControlEventListListAttributeCallback>
{
public:
    MTRPumpConfigurationAndControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PumpConfigurationAndControlEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPumpConfigurationAndControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action) :
        MTRCallbackBridge<PumpConfigurationAndControlEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRPumpConfigurationAndControlEventListListAttributeCallbackSubscriptionBridge
    : public MTRPumpConfigurationAndControlEventListListAttributeCallbackBridge
{
public:
    MTRPumpConfigurationAndControlEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPumpConfigurationAndControlEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPumpConfigurationAndControlEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPumpConfigurationAndControlEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPumpConfigurationAndControlAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<PumpConfigurationAndControlAttributeListListAttributeCallback>
{
public:
    MTRPumpConfigurationAndControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PumpConfigurationAndControlAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPumpConfigurationAndControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action) :
        MTRCallbackBridge<PumpConfigurationAndControlAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRPumpConfigurationAndControlAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRPumpConfigurationAndControlAttributeListListAttributeCallbackBridge
{
public:
    MTRPumpConfigurationAndControlAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPumpConfigurationAndControlAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPumpConfigurationAndControlAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPumpConfigurationAndControlAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThermostatGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ThermostatGeneratedCommandListListAttributeCallback>
{
public:
    MTRThermostatGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThermostatGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThermostatGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action) :
        MTRCallbackBridge<ThermostatGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRThermostatGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRThermostatGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRThermostatGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action,
                                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThermostatGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThermostatGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThermostatGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThermostatAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ThermostatAcceptedCommandListListAttributeCallback>
{
public:
    MTRThermostatAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThermostatAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThermostatAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<ThermostatAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRThermostatAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRThermostatAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRThermostatAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThermostatAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThermostatAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThermostatAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThermostatEventListListAttributeCallbackBridge : public MTRCallbackBridge<ThermostatEventListListAttributeCallback>
{
public:
    MTRThermostatEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThermostatEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThermostatEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ThermostatEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRThermostatEventListListAttributeCallbackSubscriptionBridge : public MTRThermostatEventListListAttributeCallbackBridge
{
public:
    MTRThermostatEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThermostatEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThermostatEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThermostatEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThermostatAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<ThermostatAttributeListListAttributeCallback>
{
public:
    MTRThermostatAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThermostatAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThermostatAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ThermostatAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRThermostatAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRThermostatAttributeListListAttributeCallbackBridge
{
public:
    MTRThermostatAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action,
                                                                      MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThermostatAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThermostatAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThermostatAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFanControlGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FanControlGeneratedCommandListListAttributeCallback>
{
public:
    MTRFanControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FanControlGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFanControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                 MTRActionBlock action) :
        MTRCallbackBridge<FanControlGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFanControlGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFanControlGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRFanControlGeneratedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action,
                                                                             MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFanControlGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFanControlGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFanControlGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFanControlAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FanControlAcceptedCommandListListAttributeCallback>
{
public:
    MTRFanControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FanControlAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFanControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<FanControlAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFanControlAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFanControlAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRFanControlAcceptedCommandListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFanControlAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFanControlAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFanControlAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFanControlEventListListAttributeCallbackBridge : public MTRCallbackBridge<FanControlEventListListAttributeCallback>
{
public:
    MTRFanControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FanControlEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFanControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<FanControlEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRFanControlEventListListAttributeCallbackSubscriptionBridge : public MTRFanControlEventListListAttributeCallbackBridge
{
public:
    MTRFanControlEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action,
                                                                  MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFanControlEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFanControlEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFanControlEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFanControlAttributeListListAttributeCallbackBridge : public MTRCallbackBridge<FanControlAttributeListListAttributeCallback>
{
public:
    MTRFanControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FanControlAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFanControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<FanControlAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRFanControlAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRFanControlAttributeListListAttributeCallbackBridge
{
public:
    MTRFanControlAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action,
                                                                      MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFanControlAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFanControlAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFanControlAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallback>
{
public:
    MTRThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                           ResponseHandler handler) :
        MTRCallbackBridge<ThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                         OnSuccessFn){};

    MTRThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                           ResponseHandler handler,
                                                                                           MTRActionBlock action) :
        MTRCallbackBridge<ThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                         OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThermostatUserInterfaceConfigurationGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallback>
{
public:
    MTRThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                          ResponseHandler handler) :
        MTRCallbackBridge<ThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                        OnSuccessFn){};

    MTRThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                          ResponseHandler handler,
                                                                                          MTRActionBlock action) :
        MTRCallbackBridge<ThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                        OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThermostatUserInterfaceConfigurationAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThermostatUserInterfaceConfigurationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<ThermostatUserInterfaceConfigurationEventListListAttributeCallback>
{
public:
    MTRThermostatUserInterfaceConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ThermostatUserInterfaceConfigurationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThermostatUserInterfaceConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<ThermostatUserInterfaceConfigurationEventListListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRThermostatUserInterfaceConfigurationEventListListAttributeCallbackSubscriptionBridge
    : public MTRThermostatUserInterfaceConfigurationEventListListAttributeCallbackBridge
{
public:
    MTRThermostatUserInterfaceConfigurationEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThermostatUserInterfaceConfigurationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThermostatUserInterfaceConfigurationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThermostatUserInterfaceConfigurationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRThermostatUserInterfaceConfigurationAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<ThermostatUserInterfaceConfigurationAttributeListListAttributeCallback>
{
public:
    MTRThermostatUserInterfaceConfigurationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                    ResponseHandler handler) :
        MTRCallbackBridge<ThermostatUserInterfaceConfigurationAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRThermostatUserInterfaceConfigurationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                    MTRActionBlock action) :
        MTRCallbackBridge<ThermostatUserInterfaceConfigurationAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                  OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRThermostatUserInterfaceConfigurationAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRThermostatUserInterfaceConfigurationAttributeListListAttributeCallbackBridge
{
public:
    MTRThermostatUserInterfaceConfigurationAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRThermostatUserInterfaceConfigurationAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRThermostatUserInterfaceConfigurationAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRThermostatUserInterfaceConfigurationAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRColorControlGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ColorControlGeneratedCommandListListAttributeCallback>
{
public:
    MTRColorControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ColorControlGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRColorControlGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<ColorControlGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRColorControlGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRColorControlGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRColorControlGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRColorControlGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRColorControlGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRColorControlGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRColorControlAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ColorControlAcceptedCommandListListAttributeCallback>
{
public:
    MTRColorControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ColorControlAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRColorControlAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<ColorControlAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRColorControlAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRColorControlAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRColorControlAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRColorControlAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRColorControlAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRColorControlAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRColorControlEventListListAttributeCallbackBridge : public MTRCallbackBridge<ColorControlEventListListAttributeCallback>
{
public:
    MTRColorControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ColorControlEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRColorControlEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<ColorControlEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRColorControlEventListListAttributeCallbackSubscriptionBridge : public MTRColorControlEventListListAttributeCallbackBridge
{
public:
    MTRColorControlEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action,
                                                                    MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRColorControlEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRColorControlEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRColorControlEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRColorControlAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<ColorControlAttributeListListAttributeCallback>
{
public:
    MTRColorControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ColorControlAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRColorControlAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<ColorControlAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRColorControlAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRColorControlAttributeListListAttributeCallbackBridge
{
public:
    MTRColorControlAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRColorControlAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRColorControlAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRColorControlAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBallastConfigurationGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BallastConfigurationGeneratedCommandListListAttributeCallback>
{
public:
    MTRBallastConfigurationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BallastConfigurationGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBallastConfigurationGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action) :
        MTRCallbackBridge<BallastConfigurationGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBallastConfigurationGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBallastConfigurationGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRBallastConfigurationGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBallastConfigurationGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBallastConfigurationGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBallastConfigurationGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBallastConfigurationAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BallastConfigurationAcceptedCommandListListAttributeCallback>
{
public:
    MTRBallastConfigurationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BallastConfigurationAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBallastConfigurationAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action) :
        MTRCallbackBridge<BallastConfigurationAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBallastConfigurationAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBallastConfigurationAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRBallastConfigurationAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBallastConfigurationAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBallastConfigurationAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBallastConfigurationAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBallastConfigurationEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<BallastConfigurationEventListListAttributeCallback>
{
public:
    MTRBallastConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BallastConfigurationEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBallastConfigurationEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<BallastConfigurationEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRBallastConfigurationEventListListAttributeCallbackSubscriptionBridge
    : public MTRBallastConfigurationEventListListAttributeCallbackBridge
{
public:
    MTRBallastConfigurationEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBallastConfigurationEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBallastConfigurationEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBallastConfigurationEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBallastConfigurationAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<BallastConfigurationAttributeListListAttributeCallback>
{
public:
    MTRBallastConfigurationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BallastConfigurationAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBallastConfigurationAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action) :
        MTRCallbackBridge<BallastConfigurationAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRBallastConfigurationAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRBallastConfigurationAttributeListListAttributeCallbackBridge
{
public:
    MTRBallastConfigurationAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBallastConfigurationAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBallastConfigurationAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBallastConfigurationAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIlluminanceMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<IlluminanceMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRIlluminanceMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IlluminanceMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIlluminanceMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action) :
        MTRCallbackBridge<IlluminanceMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRIlluminanceMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRIlluminanceMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRIlluminanceMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIlluminanceMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIlluminanceMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIlluminanceMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIlluminanceMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<IlluminanceMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRIlluminanceMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IlluminanceMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIlluminanceMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<IlluminanceMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRIlluminanceMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRIlluminanceMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRIlluminanceMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIlluminanceMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIlluminanceMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIlluminanceMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIlluminanceMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<IlluminanceMeasurementEventListListAttributeCallback>
{
public:
    MTRIlluminanceMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IlluminanceMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIlluminanceMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<IlluminanceMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRIlluminanceMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRIlluminanceMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRIlluminanceMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIlluminanceMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIlluminanceMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIlluminanceMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRIlluminanceMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<IlluminanceMeasurementAttributeListListAttributeCallback>
{
public:
    MTRIlluminanceMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<IlluminanceMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRIlluminanceMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<IlluminanceMeasurementAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRIlluminanceMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRIlluminanceMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRIlluminanceMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRIlluminanceMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRIlluminanceMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRIlluminanceMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTemperatureMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<TemperatureMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRTemperatureMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TemperatureMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTemperatureMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action) :
        MTRCallbackBridge<TemperatureMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRTemperatureMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRTemperatureMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRTemperatureMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTemperatureMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTemperatureMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTemperatureMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTemperatureMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<TemperatureMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRTemperatureMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TemperatureMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTemperatureMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<TemperatureMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRTemperatureMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRTemperatureMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRTemperatureMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTemperatureMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTemperatureMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTemperatureMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTemperatureMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<TemperatureMeasurementEventListListAttributeCallback>
{
public:
    MTRTemperatureMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TemperatureMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTemperatureMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                  MTRActionBlock action) :
        MTRCallbackBridge<TemperatureMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRTemperatureMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRTemperatureMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRTemperatureMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTemperatureMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTemperatureMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTemperatureMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTemperatureMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<TemperatureMeasurementAttributeListListAttributeCallback>
{
public:
    MTRTemperatureMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<TemperatureMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRTemperatureMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<TemperatureMeasurementAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRTemperatureMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRTemperatureMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRTemperatureMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTemperatureMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTemperatureMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTemperatureMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPressureMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<PressureMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRPressureMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PressureMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPressureMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action) :
        MTRCallbackBridge<PressureMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRPressureMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRPressureMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRPressureMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPressureMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPressureMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPressureMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPressureMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<PressureMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRPressureMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PressureMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPressureMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<PressureMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRPressureMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRPressureMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRPressureMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPressureMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPressureMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPressureMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPressureMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<PressureMeasurementEventListListAttributeCallback>
{
public:
    MTRPressureMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PressureMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPressureMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<PressureMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRPressureMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRPressureMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRPressureMeasurementEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPressureMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPressureMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPressureMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRPressureMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<PressureMeasurementAttributeListListAttributeCallback>
{
public:
    MTRPressureMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<PressureMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRPressureMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                   MTRActionBlock action) :
        MTRCallbackBridge<PressureMeasurementAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRPressureMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRPressureMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRPressureMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRPressureMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRPressureMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRPressureMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFlowMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FlowMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRFlowMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FlowMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFlowMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<FlowMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFlowMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFlowMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRFlowMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFlowMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFlowMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFlowMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFlowMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FlowMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRFlowMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FlowMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFlowMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                     MTRActionBlock action) :
        MTRCallbackBridge<FlowMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFlowMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFlowMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRFlowMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFlowMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFlowMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFlowMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFlowMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<FlowMeasurementEventListListAttributeCallback>
{
public:
    MTRFlowMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FlowMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFlowMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<FlowMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRFlowMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRFlowMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRFlowMeasurementEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action,
                                                                       MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFlowMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFlowMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFlowMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFlowMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<FlowMeasurementAttributeListListAttributeCallback>
{
public:
    MTRFlowMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FlowMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFlowMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                               MTRActionBlock action) :
        MTRCallbackBridge<FlowMeasurementAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRFlowMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRFlowMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRFlowMeasurementAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action,
                                                                           MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFlowMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFlowMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFlowMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRRelativeHumidityMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<RelativeHumidityMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRRelativeHumidityMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<RelativeHumidityMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRRelativeHumidityMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                  MTRActionBlock action) :
        MTRCallbackBridge<RelativeHumidityMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRRelativeHumidityMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRRelativeHumidityMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRRelativeHumidityMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRRelativeHumidityMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRRelativeHumidityMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRRelativeHumidityMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRRelativeHumidityMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<RelativeHumidityMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRRelativeHumidityMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<RelativeHumidityMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRRelativeHumidityMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                 MTRActionBlock action) :
        MTRCallbackBridge<RelativeHumidityMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                               OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRRelativeHumidityMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRRelativeHumidityMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRRelativeHumidityMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRRelativeHumidityMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRRelativeHumidityMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRRelativeHumidityMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRRelativeHumidityMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<RelativeHumidityMeasurementEventListListAttributeCallback>
{
public:
    MTRRelativeHumidityMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<RelativeHumidityMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRRelativeHumidityMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action) :
        MTRCallbackBridge<RelativeHumidityMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRRelativeHumidityMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRRelativeHumidityMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRRelativeHumidityMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRRelativeHumidityMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRRelativeHumidityMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRRelativeHumidityMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRRelativeHumidityMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<RelativeHumidityMeasurementAttributeListListAttributeCallback>
{
public:
    MTRRelativeHumidityMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<RelativeHumidityMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRRelativeHumidityMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action) :
        MTRCallbackBridge<RelativeHumidityMeasurementAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRRelativeHumidityMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRRelativeHumidityMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRRelativeHumidityMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRRelativeHumidityMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRRelativeHumidityMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRRelativeHumidityMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROccupancySensingOccupancyAttributeCallbackBridge : public MTRCallbackBridge<OccupancySensingOccupancyAttributeCallback>
{
public:
    MTROccupancySensingOccupancyAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OccupancySensingOccupancyAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROccupancySensingOccupancyAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action) :
        MTRCallbackBridge<OccupancySensingOccupancyAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::OccupancySensing::OccupancyBitmap> value);
};

class MTROccupancySensingOccupancyAttributeCallbackSubscriptionBridge : public MTROccupancySensingOccupancyAttributeCallbackBridge
{
public:
    MTROccupancySensingOccupancyAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                    MTRActionBlock action,
                                                                    MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROccupancySensingOccupancyAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROccupancySensingOccupancyAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROccupancySensingOccupancyAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROccupancySensingOccupancySensorTypeBitmapAttributeCallbackBridge
    : public MTRCallbackBridge<OccupancySensingOccupancySensorTypeBitmapAttributeCallback>
{
public:
    MTROccupancySensingOccupancySensorTypeBitmapAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OccupancySensingOccupancySensorTypeBitmapAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROccupancySensingOccupancySensorTypeBitmapAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action) :
        MTRCallbackBridge<OccupancySensingOccupancySensorTypeBitmapAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, chip::BitMask<chip::app::Clusters::OccupancySensing::OccupancySensorTypeBitmap> value);
};

class MTROccupancySensingOccupancySensorTypeBitmapAttributeCallbackSubscriptionBridge
    : public MTROccupancySensingOccupancySensorTypeBitmapAttributeCallbackBridge
{
public:
    MTROccupancySensingOccupancySensorTypeBitmapAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROccupancySensingOccupancySensorTypeBitmapAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROccupancySensingOccupancySensorTypeBitmapAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROccupancySensingOccupancySensorTypeBitmapAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROccupancySensingGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OccupancySensingGeneratedCommandListListAttributeCallback>
{
public:
    MTROccupancySensingGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OccupancySensingGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROccupancySensingGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                       MTRActionBlock action) :
        MTRCallbackBridge<OccupancySensingGeneratedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROccupancySensingGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROccupancySensingGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTROccupancySensingGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROccupancySensingGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROccupancySensingGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROccupancySensingGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROccupancySensingAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OccupancySensingAcceptedCommandListListAttributeCallback>
{
public:
    MTROccupancySensingAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OccupancySensingAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROccupancySensingAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                      MTRActionBlock action) :
        MTRCallbackBridge<OccupancySensingAcceptedCommandListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROccupancySensingAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROccupancySensingAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTROccupancySensingAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROccupancySensingAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROccupancySensingAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROccupancySensingAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROccupancySensingEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<OccupancySensingEventListListAttributeCallback>
{
public:
    MTROccupancySensingEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OccupancySensingEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROccupancySensingEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                            MTRActionBlock action) :
        MTRCallbackBridge<OccupancySensingEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTROccupancySensingEventListListAttributeCallbackSubscriptionBridge
    : public MTROccupancySensingEventListListAttributeCallbackBridge
{
public:
    MTROccupancySensingEventListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                        MTRActionBlock action,
                                                                        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROccupancySensingEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROccupancySensingEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROccupancySensingEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROccupancySensingAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<OccupancySensingAttributeListListAttributeCallback>
{
public:
    MTROccupancySensingAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OccupancySensingAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROccupancySensingAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                MTRActionBlock action) :
        MTRCallbackBridge<OccupancySensingAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTROccupancySensingAttributeListListAttributeCallbackSubscriptionBridge
    : public MTROccupancySensingAttributeListListAttributeCallbackBridge
{
public:
    MTROccupancySensingAttributeListListAttributeCallbackSubscriptionBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action,
                                                                            MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROccupancySensingAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROccupancySensingAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROccupancySensingAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRCarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                             ResponseHandler handler) :
        MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                           OnSuccessFn){};

    MTRCarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                             ResponseHandler handler,
                                                                                             MTRActionBlock action) :
        MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                           OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRCarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRCarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRCarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCarbonMonoxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRCarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                            ResponseHandler handler) :
        MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                          OnSuccessFn){};

    MTRCarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                            ResponseHandler handler,
                                                                                            MTRActionBlock action) :
        MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                          OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRCarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRCarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRCarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCarbonMonoxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCarbonMonoxideConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRCarbonMonoxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRCarbonMonoxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                  MTRActionBlock action) :
        MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action,
                                                                                                OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRCarbonMonoxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRCarbonMonoxideConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRCarbonMonoxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCarbonMonoxideConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCarbonMonoxideConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCarbonMonoxideConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRCarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler) :
        MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRCarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler,
                                                                                      MTRActionBlock action) :
        MTRCallbackBridge<CarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                    OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRCarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRCarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRCarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCarbonMonoxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<CarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRCarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                            ResponseHandler handler) :
        MTRCallbackBridge<CarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                          OnSuccessFn){};

    MTRCarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                            ResponseHandler handler,
                                                                                            MTRActionBlock action) :
        MTRCallbackBridge<CarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                          OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRCarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRCarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRCarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCarbonDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<CarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRCarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                           ResponseHandler handler) :
        MTRCallbackBridge<CarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                         OnSuccessFn){};

    MTRCarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                           ResponseHandler handler,
                                                                                           MTRActionBlock action) :
        MTRCallbackBridge<CarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                         OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRCarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRCarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRCarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCarbonDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCarbonDioxideConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<CarbonDioxideConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRCarbonDioxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<CarbonDioxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRCarbonDioxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                 MTRActionBlock action) :
        MTRCallbackBridge<CarbonDioxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action,
                                                                                               OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRCarbonDioxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRCarbonDioxideConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRCarbonDioxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCarbonDioxideConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCarbonDioxideConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCarbonDioxideConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRCarbonDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<CarbonDioxideConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRCarbonDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler) :
        MTRCallbackBridge<CarbonDioxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRCarbonDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler,
                                                                                     MTRActionBlock action) :
        MTRCallbackBridge<CarbonDioxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                   OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRCarbonDioxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRCarbonDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRCarbonDioxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRCarbonDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRCarbonDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRCarbonDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTREthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler) :
        MTRCallbackBridge<EthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTREthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler,
                                                                                       MTRActionBlock action) :
        MTRCallbackBridge<EthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                     OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTREthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTREthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTREthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthyleneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTREthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler) :
        MTRCallbackBridge<EthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTREthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler,
                                                                                      MTRActionBlock action) :
        MTRCallbackBridge<EthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                    OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTREthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTREthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTREthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthyleneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthyleneConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthyleneConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTREthyleneConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<EthyleneConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTREthyleneConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<EthyleneConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTREthyleneConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTREthyleneConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTREthyleneConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthyleneConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthyleneConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthyleneConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthyleneConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthyleneConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTREthyleneConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<EthyleneConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTREthyleneConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<EthyleneConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTREthyleneConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTREthyleneConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTREthyleneConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthyleneConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthyleneConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthyleneConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTREthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                            ResponseHandler handler) :
        MTRCallbackBridge<EthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                          OnSuccessFn){};

    MTREthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                            ResponseHandler handler,
                                                                                            MTRActionBlock action) :
        MTRCallbackBridge<EthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                          OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTREthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTREthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTREthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthyleneOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTREthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                           ResponseHandler handler) :
        MTRCallbackBridge<EthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                         OnSuccessFn){};

    MTREthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                           ResponseHandler handler,
                                                                                           MTRActionBlock action) :
        MTRCallbackBridge<EthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                         OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTREthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTREthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTREthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthyleneOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthyleneOxideConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthyleneOxideConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTREthyleneOxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<EthyleneOxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTREthyleneOxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                 MTRActionBlock action) :
        MTRCallbackBridge<EthyleneOxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action,
                                                                                               OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTREthyleneOxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTREthyleneOxideConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTREthyleneOxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthyleneOxideConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthyleneOxideConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthyleneOxideConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTREthyleneOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<EthyleneOxideConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTREthyleneOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler) :
        MTRCallbackBridge<EthyleneOxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTREthyleneOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler,
                                                                                     MTRActionBlock action) :
        MTRCallbackBridge<EthyleneOxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                   OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTREthyleneOxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTREthyleneOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTREthyleneOxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTREthyleneOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTREthyleneOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTREthyleneOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<HydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRHydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler) :
        MTRCallbackBridge<HydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler,
                                                                                       MTRActionBlock action) :
        MTRCallbackBridge<HydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                     OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRHydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRHydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRHydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHydrogenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<HydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRHydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler) :
        MTRCallbackBridge<HydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler,
                                                                                      MTRActionBlock action) :
        MTRCallbackBridge<HydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                    OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRHydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRHydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRHydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHydrogenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHydrogenConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<HydrogenConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRHydrogenConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<HydrogenConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHydrogenConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<HydrogenConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRHydrogenConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRHydrogenConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRHydrogenConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHydrogenConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHydrogenConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHydrogenConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHydrogenConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<HydrogenConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRHydrogenConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<HydrogenConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHydrogenConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<HydrogenConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRHydrogenConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRHydrogenConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRHydrogenConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHydrogenConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHydrogenConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHydrogenConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRHydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                              ResponseHandler handler) :
        MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                            OnSuccessFn){};

    MTRHydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                              ResponseHandler handler,
                                                                                              MTRActionBlock action) :
        MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                            OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRHydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRHydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRHydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHydrogenSulfideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRHydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                             ResponseHandler handler) :
        MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                           OnSuccessFn){};

    MTRHydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                             ResponseHandler handler,
                                                                                             MTRActionBlock action) :
        MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                           OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRHydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRHydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRHydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHydrogenSulfideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHydrogenSulfideConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRHydrogenSulfideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                   ResponseHandler handler) :
        MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHydrogenSulfideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                   MTRActionBlock action) :
        MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action,
                                                                                                 OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRHydrogenSulfideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRHydrogenSulfideConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRHydrogenSulfideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHydrogenSulfideConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHydrogenSulfideConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHydrogenSulfideConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRHydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler) :
        MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler,
                                                                                       MTRActionBlock action) :
        MTRCallbackBridge<HydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                     OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRHydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRHydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRHydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHydrogenSulfideConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<NitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRNitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                          ResponseHandler handler) :
        MTRCallbackBridge<NitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                        OnSuccessFn){};

    MTRNitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                          ResponseHandler handler,
                                                                                          MTRActionBlock action) :
        MTRCallbackBridge<NitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                        OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRNitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRNitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRNitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNitricOxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<NitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRNitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                         ResponseHandler handler) :
        MTRCallbackBridge<NitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                       OnSuccessFn){};

    MTRNitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                         ResponseHandler handler,
                                                                                         MTRActionBlock action) :
        MTRCallbackBridge<NitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                       OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRNitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRNitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRNitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNitricOxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNitricOxideConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<NitricOxideConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRNitricOxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<NitricOxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNitricOxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<NitricOxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRNitricOxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRNitricOxideConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRNitricOxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNitricOxideConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNitricOxideConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNitricOxideConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNitricOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<NitricOxideConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRNitricOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                   ResponseHandler handler) :
        MTRCallbackBridge<NitricOxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNitricOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                   MTRActionBlock action) :
        MTRCallbackBridge<NitricOxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                 OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRNitricOxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRNitricOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRNitricOxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNitricOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNitricOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNitricOxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRNitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                              ResponseHandler handler) :
        MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                            OnSuccessFn){};

    MTRNitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                              ResponseHandler handler,
                                                                                              MTRActionBlock action) :
        MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                            OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRNitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRNitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRNitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNitrogenDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRNitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                             ResponseHandler handler) :
        MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                           OnSuccessFn){};

    MTRNitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                             ResponseHandler handler,
                                                                                             MTRActionBlock action) :
        MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                           OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRNitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRNitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRNitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNitrogenDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNitrogenDioxideConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRNitrogenDioxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                   ResponseHandler handler) :
        MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNitrogenDioxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                   MTRActionBlock action) :
        MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action,
                                                                                                 OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRNitrogenDioxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRNitrogenDioxideConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRNitrogenDioxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNitrogenDioxideConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNitrogenDioxideConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNitrogenDioxideConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRNitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRNitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler) :
        MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRNitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler,
                                                                                       MTRActionBlock action) :
        MTRCallbackBridge<NitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                     OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRNitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRNitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRNitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRNitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRNitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRNitrogenDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OxygenConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTROxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler) :
        MTRCallbackBridge<OxygenConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler,
                                                                                     MTRActionBlock action) :
        MTRCallbackBridge<OxygenConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                   OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTROxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OxygenConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTROxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                    ResponseHandler handler) :
        MTRCallbackBridge<OxygenConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                    MTRActionBlock action) :
        MTRCallbackBridge<OxygenConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                  OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTROxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROxygenConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<OxygenConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTROxygenConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OxygenConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROxygenConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                          MTRActionBlock action) :
        MTRCallbackBridge<OxygenConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTROxygenConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTROxygenConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTROxygenConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROxygenConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROxygenConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROxygenConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<OxygenConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTROxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OxygenConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                              MTRActionBlock action) :
        MTRCallbackBridge<OxygenConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTROxygenConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTROxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTROxygenConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROzoneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OzoneConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTROzoneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                    ResponseHandler handler) :
        MTRCallbackBridge<OzoneConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROzoneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                    MTRActionBlock action) :
        MTRCallbackBridge<OzoneConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                  OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROzoneConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROzoneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTROzoneConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROzoneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROzoneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROzoneConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROzoneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<OzoneConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTROzoneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                   ResponseHandler handler) :
        MTRCallbackBridge<OzoneConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROzoneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                   MTRActionBlock action) :
        MTRCallbackBridge<OzoneConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                 OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTROzoneConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTROzoneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTROzoneConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROzoneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROzoneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROzoneConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROzoneConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<OzoneConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTROzoneConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OzoneConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROzoneConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                         MTRActionBlock action) :
        MTRCallbackBridge<OzoneConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTROzoneConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTROzoneConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTROzoneConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROzoneConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROzoneConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROzoneConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTROzoneConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<OzoneConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTROzoneConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<OzoneConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTROzoneConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                             MTRActionBlock action) :
        MTRCallbackBridge<OzoneConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTROzoneConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTROzoneConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTROzoneConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTROzoneConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTROzoneConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTROzoneConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<SulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRSulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                            ResponseHandler handler) :
        MTRCallbackBridge<SulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                          OnSuccessFn){};

    MTRSulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                            ResponseHandler handler,
                                                                                            MTRActionBlock action) :
        MTRCallbackBridge<SulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                          OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRSulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRSulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRSulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSulfurDioxideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<SulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRSulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                           ResponseHandler handler) :
        MTRCallbackBridge<SulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                         OnSuccessFn){};

    MTRSulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                           ResponseHandler handler,
                                                                                           MTRActionBlock action) :
        MTRCallbackBridge<SulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                         OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRSulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRSulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRSulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSulfurDioxideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSulfurDioxideConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<SulfurDioxideConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRSulfurDioxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<SulfurDioxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSulfurDioxideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                 MTRActionBlock action) :
        MTRCallbackBridge<SulfurDioxideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action,
                                                                                               OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRSulfurDioxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRSulfurDioxideConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRSulfurDioxideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSulfurDioxideConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSulfurDioxideConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSulfurDioxideConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRSulfurDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<SulfurDioxideConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRSulfurDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler) :
        MTRCallbackBridge<SulfurDioxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRSulfurDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler,
                                                                                     MTRActionBlock action) :
        MTRCallbackBridge<SulfurDioxideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                   OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRSulfurDioxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRSulfurDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRSulfurDioxideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRSulfurDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRSulfurDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRSulfurDioxideConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRDissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                              ResponseHandler handler) :
        MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                            OnSuccessFn){};

    MTRDissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                              ResponseHandler handler,
                                                                                              MTRActionBlock action) :
        MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                            OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRDissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRDissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRDissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDissolvedOxygenConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRDissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                             ResponseHandler handler) :
        MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                           OnSuccessFn){};

    MTRDissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                             ResponseHandler handler,
                                                                                             MTRActionBlock action) :
        MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                           OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRDissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRDissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRDissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDissolvedOxygenConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDissolvedOxygenConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRDissolvedOxygenConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                   ResponseHandler handler) :
        MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDissolvedOxygenConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                   MTRActionBlock action) :
        MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action,
                                                                                                 OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRDissolvedOxygenConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRDissolvedOxygenConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRDissolvedOxygenConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDissolvedOxygenConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDissolvedOxygenConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDissolvedOxygenConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRDissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRDissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler) :
        MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRDissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler,
                                                                                       MTRActionBlock action) :
        MTRCallbackBridge<DissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                     OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRDissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRDissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRDissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRDissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRDissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRDissolvedOxygenConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBromateConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BromateConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRBromateConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler) :
        MTRCallbackBridge<BromateConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBromateConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler,
                                                                                      MTRActionBlock action) :
        MTRCallbackBridge<BromateConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                    OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBromateConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBromateConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRBromateConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBromateConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBromateConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBromateConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBromateConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<BromateConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRBromateConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler) :
        MTRCallbackBridge<BromateConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBromateConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                     ResponseHandler handler,
                                                                                     MTRActionBlock action) :
        MTRCallbackBridge<BromateConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                   OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRBromateConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRBromateConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRBromateConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBromateConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBromateConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBromateConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBromateConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<BromateConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRBromateConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BromateConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBromateConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                           MTRActionBlock action) :
        MTRCallbackBridge<BromateConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRBromateConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRBromateConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRBromateConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBromateConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBromateConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBromateConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRBromateConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<BromateConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRBromateConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<BromateConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRBromateConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<BromateConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRBromateConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRBromateConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRBromateConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRBromateConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRBromateConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRBromateConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                          ResponseHandler handler) :
        MTRCallbackBridge<ChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                        OnSuccessFn){};

    MTRChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                          ResponseHandler handler,
                                                                                          MTRActionBlock action) :
        MTRCallbackBridge<ChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                        OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRChloraminesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                         ResponseHandler handler) :
        MTRCallbackBridge<ChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                       OnSuccessFn){};

    MTRChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                         ResponseHandler handler,
                                                                                         MTRActionBlock action) :
        MTRCallbackBridge<ChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                       OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRChloraminesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRChloraminesConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<ChloraminesConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRChloraminesConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ChloraminesConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRChloraminesConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                               MTRActionBlock action) :
        MTRCallbackBridge<ChloraminesConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRChloraminesConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRChloraminesConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRChloraminesConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRChloraminesConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRChloraminesConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRChloraminesConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRChloraminesConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<ChloraminesConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRChloraminesConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                   ResponseHandler handler) :
        MTRCallbackBridge<ChloraminesConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRChloraminesConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                   MTRActionBlock action) :
        MTRCallbackBridge<ChloraminesConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                 OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRChloraminesConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRChloraminesConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRChloraminesConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRChloraminesConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRChloraminesConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRChloraminesConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler) :
        MTRCallbackBridge<ChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler,
                                                                                       MTRActionBlock action) :
        MTRCallbackBridge<ChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                     OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRChlorineConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<ChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler) :
        MTRCallbackBridge<ChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler,
                                                                                      MTRActionBlock action) :
        MTRCallbackBridge<ChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                    OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRChlorineConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRChlorineConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<ChlorineConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRChlorineConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ChlorineConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRChlorineConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<ChlorineConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRChlorineConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRChlorineConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRChlorineConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRChlorineConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRChlorineConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRChlorineConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRChlorineConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<ChlorineConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRChlorineConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<ChlorineConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRChlorineConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<ChlorineConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRChlorineConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRChlorineConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRChlorineConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRChlorineConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRChlorineConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRChlorineConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRFecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                                 ResponseHandler handler) :
        MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                               OnSuccessFn){};

    MTRFecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                                 ResponseHandler handler,
                                                                                                 MTRActionBlock action) :
        MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallback>(
            queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRFecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFecalColiformEColiConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRFecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                                ResponseHandler handler) :
        MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                              OnSuccessFn){};

    MTRFecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                                ResponseHandler handler,
                                                                                                MTRActionBlock action) :
        MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallback>(
            queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRFecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFecalColiformEColiConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFecalColiformEColiConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRFecalColiformEColiConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler) :
        MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFecalColiformEColiConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler,
                                                                                      MTRActionBlock action) :
        MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action,
                                                                                                    OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRFecalColiformEColiConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRFecalColiformEColiConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRFecalColiformEColiConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFecalColiformEColiConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFecalColiformEColiConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFecalColiformEColiConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRFecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                          ResponseHandler handler) :
        MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler,
                                                                                                        OnSuccessFn){};

    MTRFecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                          ResponseHandler handler,
                                                                                          MTRActionBlock action) :
        MTRCallbackBridge<FecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                        OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRFecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRFecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRFecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFecalColiformEColiConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFluorideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FluorideConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRFluorideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler) :
        MTRCallbackBridge<FluorideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFluorideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler,
                                                                                       MTRActionBlock action) :
        MTRCallbackBridge<FluorideConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                     OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFluorideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFluorideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRFluorideConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFluorideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFluorideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFluorideConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFluorideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<FluorideConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRFluorideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler) :
        MTRCallbackBridge<FluorideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFluorideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                      ResponseHandler handler,
                                                                                      MTRActionBlock action) :
        MTRCallbackBridge<FluorideConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                    OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRFluorideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRFluorideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRFluorideConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFluorideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFluorideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFluorideConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFluorideConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<FluorideConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRFluorideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FluorideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFluorideConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                            MTRActionBlock action) :
        MTRCallbackBridge<FluorideConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRFluorideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRFluorideConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRFluorideConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFluorideConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFluorideConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFluorideConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRFluorideConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<FluorideConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRFluorideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler) :
        MTRCallbackBridge<FluorideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRFluorideConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                MTRActionBlock action) :
        MTRCallbackBridge<FluorideConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                              OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRFluorideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRFluorideConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRFluorideConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRFluorideConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRFluorideConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRFluorideConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRHaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                              ResponseHandler handler) :
        MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                            OnSuccessFn){};

    MTRHaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                              ResponseHandler handler,
                                                                                              MTRActionBlock action) :
        MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                            OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRHaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRHaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRHaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHaloaceticAcidsConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRHaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                             ResponseHandler handler) :
        MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                           OnSuccessFn){};

    MTRHaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                             ResponseHandler handler,
                                                                                             MTRActionBlock action) :
        MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler, action,
                                                                                                           OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRHaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRHaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRHaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHaloaceticAcidsConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHaloaceticAcidsConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRHaloaceticAcidsConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                   ResponseHandler handler) :
        MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementEventListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHaloaceticAcidsConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue, ResponseHandler handler,
                                                                                   MTRActionBlock action) :
        MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action,
                                                                                                 OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRHaloaceticAcidsConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRHaloaceticAcidsConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRHaloaceticAcidsConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHaloaceticAcidsConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHaloaceticAcidsConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHaloaceticAcidsConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRHaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRHaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler) :
        MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, OnSuccessFn){};

    MTRHaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                       ResponseHandler handler,
                                                                                       MTRActionBlock action) :
        MTRCallbackBridge<HaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                     OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRHaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    : public MTRHaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallbackBridge
{
public:
    MTRHaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRHaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRHaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRHaloaceticAcidsConcentrationMeasurementAttributeListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallback>
{
public:
    MTRTotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                                   ResponseHandler handler) :
        MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallback>(queue, handler,
                                                                                                                 OnSuccessFn){};

    MTRTotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                                   ResponseHandler handler,
                                                                                                   MTRActionBlock action) :
        MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallback>(
            queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRTotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRTotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge
{
public:
    MTRTotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTotalTrihalomethanesConcentrationMeasurementGeneratedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
    : public MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallback>
{
public:
    MTRTotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                                  ResponseHandler handler) :
        MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallback>(queue, handler,
                                                                                                                OnSuccessFn){};

    MTRTotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                                  ResponseHandler handler,
                                                                                                  MTRActionBlock action) :
        MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallback>(
            queue, handler, action, OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::CommandId> & value);
};

class MTRTotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge
    : public MTRTotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge
{
public:
    MTRTotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTotalTrihalomethanesConcentrationMeasurementAcceptedCommandListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallbackBridge
    : public MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallback>
{
public:
    MTRTotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                        ResponseHandler handler) :
        MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallback>(queue, handler,
                                                                                                      OnSuccessFn){};

    MTRTotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                        ResponseHandler handler,
                                                                                        MTRActionBlock action) :
        MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallback>(queue, handler, action,
                                                                                                      OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::EventId> & value);
};

class MTRTotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge
    : public MTRTotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallbackBridge
{
public:
    MTRTotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallbackSubscriptionBridge(
        dispatch_queue_t queue, ResponseHandler handler, MTRActionBlock action,
        MTRSubscriptionEstablishedHandler establishedHandler) :
        MTRTotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallbackBridge(queue, handler, action),
        mEstablishedHandler(establishedHandler)
    {}

    void OnSubscriptionEstablished();
    using MTRTotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallbackBridge::KeepAliveOnCallback;
    using MTRTotalTrihalomethanesConcentrationMeasurementEventListListAttributeCallbackBridge::OnDone;

private:
    MTRSubscriptionEstablishedHandler mEstablishedHandler;
};

class MTRTotalTrihalomethanesConcentrationMeasurementAttributeListListAttributeCallbackBridge
    : public MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementAttributeListListAttributeCallback>
{
public:
    MTRTotalTrihalomethanesConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                            ResponseHandler handler) :
        MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler,
                                                                                                          OnSuccessFn){};

    MTRTotalTrihalomethanesConcentrationMeasurementAttributeListListAttributeCallbackBridge(dispatch_queue_t queue,
                                                                                            ResponseHandler handler,
                                                                                            MTRActionBlock action) :
        MTRCallbackBridge<TotalTrihalomethanesConcentrationMeasurementAttributeListListAttributeCallback>(queue, handler, action,
                                                                                                          OnSuccessFn){};

    static void OnSuccessFn(void * context, const chip::app::DataModel::DecodableList<chip::AttributeId> & value);
};

class MTRTotalTrihalomethanesConcentrationMeasurementAttributeListListAttributeCallbackSubscriptionBridge
    :