/*
 *
 *    Copyright (c) 2023 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

#pragma once

#include <lib/core/CHIPError.h>
#include <stdint.h>

namespace chip {
namespace DeviceLayer {
namespace Internal {

struct PlatformVersion
{
    uint8_t mMajor;
    uint8_t mMinor;
};

class SystemInfo
{
public:
    static CHIP_ERROR GetPlatformVersion(PlatformVersion & version);

private:
    static SystemInfo sInstance;
    uint8_t mMajor = 0;
    uint8_t mMinor = 0;
};

} // namespace Internal
} // namespace DeviceLayer
} // namespace chip
