/*
 *
 *    Copyright (c) 2020-2022 Project CHIP Authors
 *    Copyright (c) 2020 Google LLC.
 *    All rights reserved.
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

/**
 *    @file
 *          Platform-specific configuration overrides for CHIP on
 *          NXP platforms.
 */

#pragma once

#include <stdint.h>

// ==================== General Platform Adaptations ====================

#ifndef CHIP_CONFIG_ABORT
#define CHIP_CONFIG_ABORT() abort()
#endif // CHIP_CONFIG_ABORT

#ifndef CHIP_CONFIG_PERSISTED_STORAGE_KEY_TYPE
#define CHIP_CONFIG_PERSISTED_STORAGE_KEY_TYPE uint16_t
#endif // CHIP_CONFIG_PERSISTED_STORAGE_KEY_TYPE

#ifndef CHIP_CONFIG_PERSISTED_STORAGE_ENC_MSG_CNTR_ID
#define CHIP_CONFIG_PERSISTED_STORAGE_ENC_MSG_CNTR_ID 1
#endif // CHIP_CONFIG_PERSISTED_STORAGE_ENC_MSG_CNTR_ID

#ifndef CHIP_CONFIG_PERSISTED_STORAGE_MAX_KEY_LENGTH
#define CHIP_CONFIG_PERSISTED_STORAGE_MAX_KEY_LENGTH 2
#endif // CHIP_CONFIG_PERSISTED_STORAGE_MAX_KEY_LENGTH

#ifndef CHIP_CONFIG_LIFETIIME_PERSISTED_COUNTER_KEY
#define CHIP_CONFIG_LIFETIIME_PERSISTED_COUNTER_KEY 0x01
#endif // CHIP_CONFIG_LIFETIIME_PERSISTED_COUNTER_KEY

#ifndef CHIP_CONFIG_PERSISTED_STORAGE_KEY_GLOBAL_MESSAGE_COUNTER
#define CHIP_CONFIG_PERSISTED_STORAGE_KEY_GLOBAL_MESSAGE_COUNTER 0x2
#endif // CHIP_CONFIG_PERSISTED_STORAGE_KEY_GLOBAL_MESSAGE_COUNTER

#ifndef CHIP_CONFIG_TIME_ENABLE_CLIENT
#define CHIP_CONFIG_TIME_ENABLE_CLIENT 1
#endif // CHIP_CONFIG_TIME_ENABLE_CLIENT

#ifndef CHIP_CONFIG_TIME_ENABLE_SERVER
#define CHIP_CONFIG_TIME_ENABLE_SERVER 0
#endif // CHIP_CONFIG_TIME_ENABLE_SERVER

#ifndef CHIP_CONFIG_ERROR_CLASS
#define CHIP_CONFIG_ERROR_CLASS 1
#endif // CHIP_CONFIG_ERROR_CLASS

#ifndef CHIP_CONFIG_SHA256_CONTEXT_SIZE
#define CHIP_CONFIG_SHA256_CONTEXT_SIZE (sizeof(unsigned int) * 76)
#endif // CHIP_CONFIG_SHA256_CONTEXT_SIZE

// ==================== Security Adaptations ====================

#ifndef CHIP_CONFIG_USE_OPENSSL_ECC
#define CHIP_CONFIG_USE_OPENSSL_ECC 0
#endif // CHIP_CONFIG_USE_OPENSSL_ECC

#ifndef CHIP_CONFIG_USE_MICRO_ECC
#define CHIP_CONFIG_USE_MICRO_ECC 0
#endif // CHIP_CONFIG_USE_MICRO_ECC

#ifndef CHIP_CONFIG_HASH_IMPLEMENTATION_OPENSSL
#define CHIP_CONFIG_HASH_IMPLEMENTATION_OPENSSL 0
#endif // CHIP_CONFIG_HASH_IMPLEMENTATION_OPENSSL

#ifndef CHIP_CONFIG_HASH_IMPLEMENTATION_MINCRYPT
#define CHIP_CONFIG_HASH_IMPLEMENTATION_MINCRYPT 1
#endif // CHIP_CONFIG_HASH_IMPLEMENTATION_MINCRYPT

#ifndef CHIP_CONFIG_HASH_IMPLEMENTATION_MBEDTLS
#define CHIP_CONFIG_HASH_IMPLEMENTATION_MBEDTLS 0
#endif // CHIP_CONFIG_HASH_IMPLEMENTATION_MBEDTLS

#ifndef CHIP_CONFIG_HASH_IMPLEMENTATION_PLATFORM
#define CHIP_CONFIG_HASH_IMPLEMENTATION_PLATFORM 0
#endif // CHIP_CONFIG_HASH_IMPLEMENTATION_PLATFORM

#ifndef CHIP_CONFIG_AES_IMPLEMENTATION_OPENSSL
#define CHIP_CONFIG_AES_IMPLEMENTATION_OPENSSL 0
#endif // CHIP_CONFIG_AES_IMPLEMENTATION_OPENSSL

#ifndef CHIP_CONFIG_AES_IMPLEMENTATION_AESNI
#define CHIP_CONFIG_AES_IMPLEMENTATION_AESNI 0
#endif // CHIP_CONFIG_AES_IMPLEMENTATION_AESNI

#ifndef CHIP_CONFIG_AES_IMPLEMENTATION_MBEDTLS
#define CHIP_CONFIG_AES_IMPLEMENTATION_MBEDTLS 0
#endif // CHIP_CONFIG_AES_IMPLEMENTATION_MBEDTLS

#ifndef CHIP_CONFIG_AES_IMPLEMENTATION_PLATFORM
#define CHIP_CONFIG_AES_IMPLEMENTATION_PLATFORM 1
#endif // CHIP_CONFIG_AES_IMPLEMENTATION_PLATFORM

#ifndef CHIP_CONFIG_RNG_IMPLEMENTATION_OPENSSL
#define CHIP_CONFIG_RNG_IMPLEMENTATION_OPENSSL 0
#endif // CHIP_CONFIG_RNG_IMPLEMENTATION_OPENSSL

#ifndef CHIP_CONFIG_RNG_IMPLEMENTATION_CHIPDRBG
#define CHIP_CONFIG_RNG_IMPLEMENTATION_CHIPDRBG 1
#endif // CHIP_CONFIG_RNG_IMPLEMENTATION_CHIPDRBG

#ifndef CHIP_CONFIG_RNG_IMPLEMENTATION_PLATFORM
#define CHIP_CONFIG_RNG_IMPLEMENTATION_PLATFORM 0
#endif // CHIP_CONFIG_RNG_IMPLEMENTATION_PLATFORM

#ifndef CHIP_CONFIG_ENABLE_PASE_INITIATOR
#define CHIP_CONFIG_ENABLE_PASE_INITIATOR 0
#endif // CHIP_CONFIG_ENABLE_PASE_INITIATOR

#ifndef CHIP_CONFIG_ENABLE_PASE_RESPONDER
#define CHIP_CONFIG_ENABLE_PASE_RESPONDER 1
#endif // CHIP_CONFIG_ENABLE_PASE_RESPONDER

#ifndef CHIP_CONFIG_ENABLE_CASE_INITIATOR
#define CHIP_CONFIG_ENABLE_CASE_INITIATOR 1
#endif // CHIP_CONFIG_ENABLE_CASE_INITIATOR

#ifndef CHIP_CONFIG_SUPPORT_PASE_CONFIG0
#define CHIP_CONFIG_SUPPORT_PASE_CONFIG0 0
#endif // CHIP_CONFIG_SUPPORT_PASE_CONFIG0

#ifndef CHIP_CONFIG_SUPPORT_PASE_CONFIG1
#define CHIP_CONFIG_SUPPORT_PASE_CONFIG1 0
#endif // CHIP_CONFIG_SUPPORT_PASE_CONFIG1

#ifndef CHIP_CONFIG_SUPPORT_PASE_CONFIG2
#define CHIP_CONFIG_SUPPORT_PASE_CONFIG2 0
#endif // CHIP_CONFIG_SUPPORT_PASE_CONFIG2

#ifndef CHIP_CONFIG_SUPPORT_PASE_CONFIG3
#define CHIP_CONFIG_SUPPORT_PASE_CONFIG3 0
#endif // CHIP_CONFIG_SUPPORT_PASE_CONFIG3

#ifndef CHIP_CONFIG_SUPPORT_PASE_CONFIG4
#define CHIP_CONFIG_SUPPORT_PASE_CONFIG4 1
#endif // CHIP_CONFIG_SUPPORT_PASE_CONFIG4

#ifndef CHIP_CONFIG_ENABLE_KEY_EXPORT_INITIATOR
#define CHIP_CONFIG_ENABLE_KEY_EXPORT_INITIATOR 0
#endif // CHIP_CONFIG_ENABLE_KEY_EXPORT_INITIATOR

#ifndef CHIP_CONFIG_ENABLE_PROVISIONING_BUNDLE_SUPPORT
#define CHIP_CONFIG_ENABLE_PROVISIONING_BUNDLE_SUPPORT 0
#endif // CHIP_CONFIG_ENABLE_PROVISIONING_BUNDLE_SUPPORT

// ==================== General Configuration Overrides ====================

#ifndef CHIP_CONFIG_MAX_PEER_NODES
#define CHIP_CONFIG_MAX_PEER_NODES 16
#endif // CHIP_CONFIG_MAX_PEER_NODES

#ifndef CHIP_CONFIG_MAX_UNSOLICITED_MESSAGE_HANDLERS
#define CHIP_CONFIG_MAX_UNSOLICITED_MESSAGE_HANDLERS 16
#endif // CHIP_CONFIG_MAX_UNSOLICITED_MESSAGE_HANDLERS

#ifndef CHIP_CONFIG_MAX_EXCHANGE_CONTEXTS
#define CHIP_CONFIG_MAX_EXCHANGE_CONTEXTS 8
#endif // CHIP_CONFIG_MAX_EXCHANGE_CONTEXTS

#ifndef CHIP_CONFIG_RMP_TIMER_DEFAULT_PERIOD_SHIFT
#define CHIP_CONFIG_RMP_TIMER_DEFAULT_PERIOD_SHIFT 6
#endif // CHIP_CONFIG_RMP_TIMER_DEFAULT_PERIOD_SHIFT

#ifndef CHIP_LOG_FILTERING
#define CHIP_LOG_FILTERING 0
#endif // CHIP_LOG_FILTERING

#ifndef CHIP_CONFIG_BDX_MAX_NUM_TRANSFERS
#define CHIP_CONFIG_BDX_MAX_NUM_TRANSFERS 1
#endif // CHIP_CONFIG_BDX_MAX_NUM_TRANSFERS

// ==================== Security Configuration Overrides ====================

#ifndef CHIP_CONFIG_MAX_APPLICATION_GROUPS
#define CHIP_CONFIG_MAX_APPLICATION_GROUPS 4
#endif // CHIP_CONFIG_MAX_APPLICATION_GROUPS

#ifndef CHIP_CONFIG_DEBUG_CERT_VALIDATION
#define CHIP_CONFIG_DEBUG_CERT_VALIDATION 0
#endif // CHIP_CONFIG_DEBUG_CERT_VALIDATION

#ifndef CHIP_CONFIG_ENABLE_CASE_RESPONDER
#define CHIP_CONFIG_ENABLE_CASE_RESPONDER 1
#endif // CHIP_CONFIG_ENABLE_CASE_RESPONDER

// ==================== WDM Configuration Overrides ====================

#ifndef WDM_MAX_NUM_SUBSCRIPTION_CLIENTS
#define WDM_MAX_NUM_SUBSCRIPTION_CLIENTS 2
#endif // WDM_MAX_NUM_SUBSCRIPTION_CLIENTS

#ifndef WDM_MAX_NUM_SUBSCRIPTION_HANDLERS
#define WDM_MAX_NUM_SUBSCRIPTION_HANDLERS 2
#endif // WDM_MAX_NUM_SUBSCRIPTION_HANDLERS

#ifndef WDM_PUBLISHER_MAX_NOTIFIES_IN_FLIGHT
#define WDM_PUBLISHER_MAX_NOTIFIES_IN_FLIGHT 2
#endif // WDM_PUBLISHER_MAX_NOTIFIES_IN_FLIGHT

// ==================== Other Configuration Overrides ====================

#ifndef CHIP_CONFIG_RMP_DEFAULT_MAX_RETRANS
/*
 * Increasing the default value to 10 to handle potential scenario where there is latency with the radio used
 */
#define CHIP_CONFIG_RMP_DEFAULT_MAX_RETRANS 10
#endif
