/*
* Declare all custom 128-bit UUIDs here using the format:
*
*  UUID128(name, bytes)
*
* where:
*	-name : an unique tag for the newly defined UUID;
                will be used to reference this UUID when defining
                services and characteristics in <<gattDb.h>>
*	-bytes: 16 bytes representing the 128-bit value
*
* One definition per line. No semicolon required after each definition.
*
* example:
*  UUID128(uuid_service_robot_characteristics, 0x12, 0x34, 0x56, 0x78, 0x90, 0xAB, 0xCD, 0xEF, 0x12, 0x34, 0x56, 0x78, 0x90, 0xAB,
0xCD, 0xEF)
*  UUID128(uuid_char_robot_direction, 0x12, 0x34, 0x50, 0x00, 0x90, 0xAB, 0xCD, 0xEF, 0x12, 0x34, 0x56, 0x78, 0x90, 0xAB, 0xCD,
0xEF)
*/
/* Services */

#define gChipoBleService_d 0xFFF6

UUID128(uuid_chipoble_tx, 0x12, 0x9D, 0x9F, 0x42, 0x9C, 0x4F, 0x9F, 0x95, 0x59, 0x45, 0x3D, 0x26, 0xF5, 0x2E, 0xEE, 0x18)
UUID128(uuid_chipoble_rx, 0x11, 0x9D, 0x9F, 0x42, 0x9C, 0x4F, 0x9F, 0x95, 0x59, 0x45, 0x3D, 0x26, 0xF5, 0x2E, 0xEE, 0x18)
UUID128(uuid_chipoble_c3, 0x04, 0x8f, 0x21, 0x83, 0x8a, 0x74, 0x7d, 0xb8, 0xf2, 0x45, 0x72, 0x87, 0x38, 0x02, 0x63, 0x64)
