/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

// Prevent multiple inclusion
#pragma once

// Global cluster attribute ids
#define ZCL_GENERATED_COMMAND_LIST_ATTRIBUTE_ID (0xFFF8)
#define ZCL_ACCEPTED_COMMAND_LIST_ATTRIBUTE_ID (0xFFF9)
#define ZCL_ATTRIBUTE_LIST_SERVER_ATTRIBUTE_ID (0xFFFB)
#define ZCL_FEATURE_MAP_CLIENT_ATTRIBUTE_ID (0xFFFC)
#define ZCL_FEATURE_MAP_SERVER_ATTRIBUTE_ID (0xFFFC)
#define ZCL_CLUSTER_REVISION_CLIENT_ATTRIBUTE_ID (0xFFFD)
#define ZCL_CLUSTER_REVISION_SERVER_ATTRIBUTE_ID (0xFFFD)

// Attribute ids for cluster: Identify

// Client attributes

// Server attributes
#define ZCL_IDENTIFY_TIME_ATTRIBUTE_ID (0x0000)
#define ZCL_IDENTIFY_TYPE_ATTRIBUTE_ID (0x0001)

// Attribute ids for cluster: Groups

// Client attributes

// Server attributes
#define ZCL_GROUP_NAME_SUPPORT_ATTRIBUTE_ID (0x0000)

// Attribute ids for cluster: Scenes

// Client attributes

// Server attributes
#define ZCL_SCENE_COUNT_ATTRIBUTE_ID (0x0000)
#define ZCL_CURRENT_SCENE_ATTRIBUTE_ID (0x0001)
#define ZCL_CURRENT_GROUP_ATTRIBUTE_ID (0x0002)
#define ZCL_SCENE_VALID_ATTRIBUTE_ID (0x0003)
#define ZCL_SCENE_NAME_SUPPORT_ATTRIBUTE_ID (0x0004)
#define ZCL_LAST_CONFIGURED_BY_ATTRIBUTE_ID (0x0005)

// Attribute ids for cluster: On/Off

// Client attributes

// Server attributes
#define ZCL_ON_OFF_ATTRIBUTE_ID (0x0000)
#define ZCL_GLOBAL_SCENE_CONTROL_ATTRIBUTE_ID (0x4000)
#define ZCL_ON_TIME_ATTRIBUTE_ID (0x4001)
#define ZCL_OFF_WAIT_TIME_ATTRIBUTE_ID (0x4002)
#define ZCL_START_UP_ON_OFF_ATTRIBUTE_ID (0x4003)

// Attribute ids for cluster: On/off Switch Configuration

// Client attributes

// Server attributes
#define ZCL_SWITCH_TYPE_ATTRIBUTE_ID (0x0000)
#define ZCL_SWITCH_ACTIONS_ATTRIBUTE_ID (0x0010)

// Attribute ids for cluster: Level Control

// Client attributes

// Server attributes
#define ZCL_CURRENT_LEVEL_ATTRIBUTE_ID (0x0000)
#define ZCL_LEVEL_CONTROL_REMAINING_TIME_ATTRIBUTE_ID (0x0001)
#define ZCL_MINIMUM_LEVEL_ATTRIBUTE_ID (0x0002)
#define ZCL_MAXIMUM_LEVEL_ATTRIBUTE_ID (0x0003)
#define ZCL_CURRENT_FREQUENCY_ATTRIBUTE_ID (0x0004)
#define ZCL_MIN_FREQUENCY_ATTRIBUTE_ID (0x0005)
#define ZCL_MAX_FREQUENCY_ATTRIBUTE_ID (0x0006)
#define ZCL_OPTIONS_ATTRIBUTE_ID (0x000F)
#define ZCL_ON_OFF_TRANSITION_TIME_ATTRIBUTE_ID (0x0010)
#define ZCL_ON_LEVEL_ATTRIBUTE_ID (0x0011)
#define ZCL_ON_TRANSITION_TIME_ATTRIBUTE_ID (0x0012)
#define ZCL_OFF_TRANSITION_TIME_ATTRIBUTE_ID (0x0013)
#define ZCL_DEFAULT_MOVE_RATE_ATTRIBUTE_ID (0x0014)
#define ZCL_START_UP_CURRENT_LEVEL_ATTRIBUTE_ID (0x4000)

// Attribute ids for cluster: Binary Input (Basic)

// Client attributes

// Server attributes
#define ZCL_ACTIVE_TEXT_ATTRIBUTE_ID (0x0004)
#define ZCL_DESCRIPTION_ATTRIBUTE_ID (0x001C)
#define ZCL_INACTIVE_TEXT_ATTRIBUTE_ID (0x002E)
#define ZCL_OUT_OF_SERVICE_ATTRIBUTE_ID (0x0051)
#define ZCL_POLARITY_ATTRIBUTE_ID (0x0054)
#define ZCL_PRESENT_VALUE_ATTRIBUTE_ID (0x0055)
#define ZCL_RELIABILITY_ATTRIBUTE_ID (0x0067)
#define ZCL_STATUS_FLAGS_ATTRIBUTE_ID (0x006F)
#define ZCL_APPLICATION_TYPE_ATTRIBUTE_ID (0x0100)

// Attribute ids for cluster: Pulse Width Modulation

// Client attributes

// Server attributes

// Attribute ids for cluster: Descriptor

// Client attributes

// Server attributes
#define ZCL_DEVICE_LIST_ATTRIBUTE_ID (0x0000)
#define ZCL_SERVER_LIST_ATTRIBUTE_ID (0x0001)
#define ZCL_CLIENT_LIST_ATTRIBUTE_ID (0x0002)
#define ZCL_PARTS_LIST_ATTRIBUTE_ID (0x0003)

// Attribute ids for cluster: Binding

// Client attributes

// Server attributes
#define ZCL_BINDING_LIST_ATTRIBUTE_ID (0x0000)

// Attribute ids for cluster: Access Control

// Client attributes

// Server attributes
#define ZCL_ACL_ATTRIBUTE_ID (0x0000)
#define ZCL_EXTENSION_ATTRIBUTE_ID (0x0001)
#define ZCL_SUBJECTS_PER_ACCESS_CONTROL_ENTRY_ATTRIBUTE_ID (0x0002)
#define ZCL_TARGETS_PER_ACCESS_CONTROL_ENTRY_ATTRIBUTE_ID (0x0003)
#define ZCL_ACCESS_CONTROL_ENTRIES_PER_FABRIC_ATTRIBUTE_ID (0x0004)

// Attribute ids for cluster: Actions

// Client attributes

// Server attributes
#define ZCL_ACTION_LIST_ATTRIBUTE_ID (0x0000)
#define ZCL_ENDPOINT_LIST_ATTRIBUTE_ID (0x0001)
#define ZCL_SETUP_URL_ATTRIBUTE_ID (0x0002)

// Attribute ids for cluster: Basic

// Client attributes

// Server attributes
#define ZCL_DATA_MODEL_REVISION_ATTRIBUTE_ID (0x0000)
#define ZCL_VENDOR_NAME_ATTRIBUTE_ID (0x0001)
#define ZCL_VENDOR_ID_ATTRIBUTE_ID (0x0002)
#define ZCL_PRODUCT_NAME_ATTRIBUTE_ID (0x0003)
#define ZCL_PRODUCT_ID_ATTRIBUTE_ID (0x0004)
#define ZCL_NODE_LABEL_ATTRIBUTE_ID (0x0005)
#define ZCL_LOCATION_ATTRIBUTE_ID (0x0006)
#define ZCL_HARDWARE_VERSION_ATTRIBUTE_ID (0x0007)
#define ZCL_HARDWARE_VERSION_STRING_ATTRIBUTE_ID (0x0008)
#define ZCL_SOFTWARE_VERSION_ATTRIBUTE_ID (0x0009)
#define ZCL_SOFTWARE_VERSION_STRING_ATTRIBUTE_ID (0x000A)
#define ZCL_MANUFACTURING_DATE_ATTRIBUTE_ID (0x000B)
#define ZCL_PART_NUMBER_ATTRIBUTE_ID (0x000C)
#define ZCL_PRODUCT_URL_ATTRIBUTE_ID (0x000D)
#define ZCL_PRODUCT_LABEL_ATTRIBUTE_ID (0x000E)
#define ZCL_SERIAL_NUMBER_ATTRIBUTE_ID (0x000F)
#define ZCL_LOCAL_CONFIG_DISABLED_ATTRIBUTE_ID (0x0010)
#define ZCL_REACHABLE_ATTRIBUTE_ID (0x0011)
#define ZCL_UNIQUE_ID_ATTRIBUTE_ID (0x0012)
#define ZCL_CAPABILITY_MINIMA_ATTRIBUTE_ID (0x0013)

// Attribute ids for cluster: OTA Software Update Provider

// Client attributes

// Server attributes

// Attribute ids for cluster: OTA Software Update Requestor

// Client attributes

// Server attributes
#define ZCL_DEFAULT_OTA_PROVIDERS_ATTRIBUTE_ID (0x0000)
#define ZCL_UPDATE_POSSIBLE_ATTRIBUTE_ID (0x0001)
#define ZCL_UPDATE_STATE_ATTRIBUTE_ID (0x0002)
#define ZCL_UPDATE_STATE_PROGRESS_ATTRIBUTE_ID (0x0003)

// Attribute ids for cluster: Localization Configuration

// Client attributes

// Server attributes
#define ZCL_ACTIVE_LOCALE_ATTRIBUTE_ID (0x0000)
#define ZCL_SUPPORTED_LOCALES_ATTRIBUTE_ID (0x0001)

// Attribute ids for cluster: Time Format Localization

// Client attributes

// Server attributes
#define ZCL_HOUR_FORMAT_ATTRIBUTE_ID (0x0000)
#define ZCL_ACTIVE_CALENDAR_TYPE_ATTRIBUTE_ID (0x0001)
#define ZCL_SUPPORTED_CALENDAR_TYPES_ATTRIBUTE_ID (0x0002)

// Attribute ids for cluster: Unit Localization

// Client attributes

// Server attributes
#define ZCL_TEMPERATURE_UNIT_ATTRIBUTE_ID (0x0000)

// Attribute ids for cluster: Power Source Configuration

// Client attributes

// Server attributes
#define ZCL_SOURCES_ATTRIBUTE_ID (0x0000)

// Attribute ids for cluster: Power Source

// Client attributes

// Server attributes
#define ZCL_POWER_SOURCE_STATUS_ATTRIBUTE_ID (0x0000)
#define ZCL_POWER_SOURCE_ORDER_ATTRIBUTE_ID (0x0001)
#define ZCL_POWER_SOURCE_DESCRIPTION_ATTRIBUTE_ID (0x0002)
#define ZCL_POWER_SOURCE_WIRED_ASSESSED_INPUT_VOLTAGE_ATTRIBUTE_ID (0x0003)
#define ZCL_POWER_SOURCE_WIRED_ASSESSED_INPUT_FREQUENCY_ATTRIBUTE_ID (0x0004)
#define ZCL_POWER_SOURCE_WIRED_CURRENT_TYPE_ATTRIBUTE_ID (0x0005)
#define ZCL_POWER_SOURCE_WIRED_ASSESSED_CURRENT_ATTRIBUTE_ID (0x0006)
#define ZCL_POWER_SOURCE_WIRED_NOMINAL_VOLTAGE_ATTRIBUTE_ID (0x0007)
#define ZCL_POWER_SOURCE_WIRED_MAXIMUM_CURRENT_ATTRIBUTE_ID (0x0008)
#define ZCL_POWER_SOURCE_WIRED_PRESENT_ATTRIBUTE_ID (0x0009)
#define ZCL_POWER_SOURCE_ACTIVE_WIRED_FAULTS_ATTRIBUTE_ID (0x000A)
#define ZCL_POWER_SOURCE_BAT_VOLTAGE_ATTRIBUTE_ID (0x000B)
#define ZCL_POWER_SOURCE_BAT_PERCENT_REMAINING_ATTRIBUTE_ID (0x000C)
#define ZCL_POWER_SOURCE_BAT_TIME_REMAINING_ATTRIBUTE_ID (0x000D)
#define ZCL_POWER_SOURCE_BAT_CHARGE_LEVEL_ATTRIBUTE_ID (0x000E)
#define ZCL_POWER_SOURCE_BAT_REPLACEMENT_NEEDED_ATTRIBUTE_ID (0x000F)
#define ZCL_POWER_SOURCE_BAT_REPLACEABILITY_ATTRIBUTE_ID (0x0010)
#define ZCL_POWER_SOURCE_BAT_PRESENT_ATTRIBUTE_ID (0x0011)
#define ZCL_POWER_SOURCE_ACTIVE_BAT_FAULTS_ATTRIBUTE_ID (0x0012)
#define ZCL_POWER_SOURCE_BAT_REPLACEMENT_DESCRIPTION_ATTRIBUTE_ID (0x0013)
#define ZCL_POWER_SOURCE_BAT_COMMON_DESIGNATION_ATTRIBUTE_ID (0x0014)
#define ZCL_POWER_SOURCE_BAT_ANSI_DESIGNATION_ATTRIBUTE_ID (0x0015)
#define ZCL_POWER_SOURCE_BAT_IEC_DESIGNATION_ATTRIBUTE_ID (0x0016)
#define ZCL_POWER_SOURCE_BAT_APPROVED_CHEMISTRY_ATTRIBUTE_ID (0x0017)
#define ZCL_POWER_SOURCE_BAT_CAPACITY_ATTRIBUTE_ID (0x0018)
#define ZCL_POWER_SOURCE_BAT_QUANTITY_ATTRIBUTE_ID (0x0019)
#define ZCL_POWER_SOURCE_BAT_CHARGE_STATE_ATTRIBUTE_ID (0x001A)
#define ZCL_POWER_SOURCE_BAT_TIME_TO_FULL_CHARGE_ATTRIBUTE_ID (0x001B)
#define ZCL_POWER_SOURCE_BAT_FUNCTIONAL_WHILE_CHARGING_ATTRIBUTE_ID (0x001C)
#define ZCL_POWER_SOURCE_BAT_CHARGING_CURRENT_ATTRIBUTE_ID (0x001D)
#define ZCL_POWER_SOURCE_ACTIVE_BAT_CHARGE_FAULTS_ATTRIBUTE_ID (0x001E)

// Attribute ids for cluster: General Commissioning

// Client attributes

// Server attributes
#define ZCL_BREADCRUMB_ATTRIBUTE_ID (0x0000)
#define ZCL_BASIC_COMMISSIONING_INFO_ATTRIBUTE_ID (0x0001)
#define ZCL_REGULATORY_CONFIG_ATTRIBUTE_ID (0x0002)
#define ZCL_LOCATION_CAPABILITY_ATTRIBUTE_ID (0x0003)
#define ZCL_SUPPORTS_CONCURRENT_CONNECTION_ATTRIBUTE_ID (0x0004)

// Attribute ids for cluster: Network Commissioning

// Client attributes

// Server attributes
#define ZCL_MAX_NETWORKS_ATTRIBUTE_ID (0x0000)
#define ZCL_NETWORKS_ATTRIBUTE_ID (0x0001)
#define ZCL_SCAN_MAX_TIME_SECONDS_ATTRIBUTE_ID (0x0002)
#define ZCL_CONNECT_MAX_TIME_SECONDS_ATTRIBUTE_ID (0x0003)
#define ZCL_INTERFACE_ENABLED_ATTRIBUTE_ID (0x0004)
#define ZCL_LAST_NETWORKING_STATUS_ATTRIBUTE_ID (0x0005)
#define ZCL_LAST_NETWORK_ID_ATTRIBUTE_ID (0x0006)
#define ZCL_LAST_CONNECT_ERROR_VALUE_ATTRIBUTE_ID (0x0007)

// Attribute ids for cluster: Diagnostic Logs

// Client attributes

// Server attributes

// Attribute ids for cluster: General Diagnostics

// Client attributes

// Server attributes
#define ZCL_NETWORK_INTERFACES_ATTRIBUTE_ID (0x0000)
#define ZCL_REBOOT_COUNT_ATTRIBUTE_ID (0x0001)
#define ZCL_UP_TIME_ATTRIBUTE_ID (0x0002)
#define ZCL_TOTAL_OPERATIONAL_HOURS_ATTRIBUTE_ID (0x0003)
#define ZCL_BOOT_REASONS_ATTRIBUTE_ID (0x0004)
#define ZCL_ACTIVE_HARDWARE_FAULTS_ATTRIBUTE_ID (0x0005)
#define ZCL_ACTIVE_RADIO_FAULTS_ATTRIBUTE_ID (0x0006)
#define ZCL_ACTIVE_NETWORK_FAULTS_ATTRIBUTE_ID (0x0007)
#define ZCL_TEST_EVENT_TRIGGERS_ENABLED_ATTRIBUTE_ID (0x0008)

// Attribute ids for cluster: Software Diagnostics

// Client attributes

// Server attributes
#define ZCL_THREAD_METRICS_ATTRIBUTE_ID (0x0000)
#define ZCL_CURRENT_HEAP_FREE_ATTRIBUTE_ID (0x0001)
#define ZCL_CURRENT_HEAP_USED_ATTRIBUTE_ID (0x0002)
#define ZCL_CURRENT_HEAP_HIGH_WATERMARK_ATTRIBUTE_ID (0x0003)

// Attribute ids for cluster: Thread Network Diagnostics

// Client attributes

// Server attributes
#define ZCL_CHANNEL_ATTRIBUTE_ID (0x0000)
#define ZCL_ROUTING_ROLE_ATTRIBUTE_ID (0x0001)
#define ZCL_NETWORK_NAME_ATTRIBUTE_ID (0x0002)
#define ZCL_DIAG_PAN_ID_ATTRIBUTE_ID (0x0003)
#define ZCL_DIAG_EXTENDED_PAN_ID_ATTRIBUTE_ID (0x0004)
#define ZCL_MESH_LOCAL_PREFIX_ATTRIBUTE_ID (0x0005)
#define ZCL_DIAG_OVERRUN_COUNT_ATTRIBUTE_ID (0x0006)
#define ZCL_NEIGHBOR_TABLE_ATTRIBUTE_ID (0x0007)
#define ZCL_ROUTE_TABLE_ATTRIBUTE_ID (0x0008)
#define ZCL_PARTITION_ID_ATTRIBUTE_ID (0x0009)
#define ZCL_WEIGHTING_ATTRIBUTE_ID (0x000A)
#define ZCL_DATA_VERSION_ATTRIBUTE_ID (0x000B)
#define ZCL_STABLE_DATA_VERSION_ATTRIBUTE_ID (0x000C)
#define ZCL_LEADER_ROUTER_ID_ATTRIBUTE_ID (0x000D)
#define ZCL_DETACHED_ROLE_COUNT_ATTRIBUTE_ID (0x000E)
#define ZCL_CHILD_ROLE_COUNT_ATTRIBUTE_ID (0x000F)
#define ZCL_ROUTER_ROLE_COUNT_ATTRIBUTE_ID (0x0010)
#define ZCL_LEADER_ROLE_COUNT_ATTRIBUTE_ID (0x0011)
#define ZCL_ATTACH_ATTEMPT_COUNT_ATTRIBUTE_ID (0x0012)
#define ZCL_PARTITION_ID_CHANGE_COUNT_ATTRIBUTE_ID (0x0013)
#define ZCL_BETTER_PARTITION_ATTACH_ATTEMPT_COUNT_ATTRIBUTE_ID (0x0014)
#define ZCL_PARENT_CHANGE_COUNT_ATTRIBUTE_ID (0x0015)
#define ZCL_TX_TOTAL_COUNT_ATTRIBUTE_ID (0x0016)
#define ZCL_TX_UNICAST_COUNT_ATTRIBUTE_ID (0x0017)
#define ZCL_TX_BROADCAST_COUNT_ATTRIBUTE_ID (0x0018)
#define ZCL_TX_ACK_REQUESTED_COUNT_ATTRIBUTE_ID (0x0019)
#define ZCL_TX_ACKED_COUNT_ATTRIBUTE_ID (0x001A)
#define ZCL_TX_NO_ACK_REQUESTED_COUNT_ATTRIBUTE_ID (0x001B)
#define ZCL_TX_DATA_COUNT_ATTRIBUTE_ID (0x001C)
#define ZCL_TX_DATA_POLL_COUNT_ATTRIBUTE_ID (0x001D)
#define ZCL_TX_BEACON_COUNT_ATTRIBUTE_ID (0x001E)
#define ZCL_TX_BEACON_REQUEST_COUNT_ATTRIBUTE_ID (0x001F)
#define ZCL_TX_OTHER_COUNT_ATTRIBUTE_ID (0x0020)
#define ZCL_TX_RETRY_COUNT_ATTRIBUTE_ID (0x0021)
#define ZCL_TX_DIRECT_MAX_RETRY_EXPIRY_COUNT_ATTRIBUTE_ID (0x0022)
#define ZCL_TX_INDIRECT_MAX_RETRY_EXPIRY_COUNT_ATTRIBUTE_ID (0x0023)
#define ZCL_TX_ERR_CCA_COUNT_ATTRIBUTE_ID (0x0024)
#define ZCL_TX_ERR_ABORT_COUNT_ATTRIBUTE_ID (0x0025)
#define ZCL_TX_ERR_BUSY_CHANNEL_COUNT_ATTRIBUTE_ID (0x0026)
#define ZCL_RX_TOTAL_COUNT_ATTRIBUTE_ID (0x0027)
#define ZCL_RX_UNICAST_COUNT_ATTRIBUTE_ID (0x0028)
#define ZCL_RX_BROADCAST_COUNT_ATTRIBUTE_ID (0x0029)
#define ZCL_RX_DATA_COUNT_ATTRIBUTE_ID (0x002A)
#define ZCL_RX_DATA_POLL_COUNT_ATTRIBUTE_ID (0x002B)
#define ZCL_RX_BEACON_COUNT_ATTRIBUTE_ID (0x002C)
#define ZCL_RX_BEACON_REQUEST_COUNT_ATTRIBUTE_ID (0x002D)
#define ZCL_RX_OTHER_COUNT_ATTRIBUTE_ID (0x002E)
#define ZCL_RX_ADDRESS_FILTERED_COUNT_ATTRIBUTE_ID (0x002F)
#define ZCL_RX_DESTADDR_FILTERED_COUNT_ATTRIBUTE_ID (0x0030)
#define ZCL_RX_DUPLICATED_COUNT_ATTRIBUTE_ID (0x0031)
#define ZCL_RX_ERR_NO_FRAME_COUNT_ATTRIBUTE_ID (0x0032)
#define ZCL_RX_ERR_UNKNOWN_NEIGHBOR_COUNT_ATTRIBUTE_ID (0x0033)
#define ZCL_RX_ERR_INVALID_SRC_ADDR_COUNT_ATTRIBUTE_ID (0x0034)
#define ZCL_RX_ERR_SEC_COUNT_ATTRIBUTE_ID (0x0035)
#define ZCL_RX_ERR_FCS_COUNT_ATTRIBUTE_ID (0x0036)
#define ZCL_RX_ERR_OTHER_COUNT_ATTRIBUTE_ID (0x0037)
#define ZCL_ACTIVE_TIMESTAMP_ATTRIBUTE_ID (0x0038)
#define ZCL_PENDING_TIMESTAMP_ATTRIBUTE_ID (0x0039)
#define ZCL_DELAY_ATTRIBUTE_ID (0x003A)
#define ZCL_SECURITY_POLICY_ATTRIBUTE_ID (0x003B)
#define ZCL_DIAG_CHANNEL_MASK_ATTRIBUTE_ID (0x003C)
#define ZCL_OPERATIONAL_DATASET_COMPONENTS_ATTRIBUTE_ID (0x003D)
#define ZCL_ACTIVE_THREAD_NETWORK_FAULTS_ATTRIBUTE_ID (0x003E)

// Attribute ids for cluster: WiFi Network Diagnostics

// Client attributes

// Server attributes
#define ZCL_BSSID_ATTRIBUTE_ID (0x0000)
#define ZCL_SECURITY_TYPE_ATTRIBUTE_ID (0x0001)
#define ZCL_WIFI_VERSION_ATTRIBUTE_ID (0x0002)
#define ZCL_CHANNEL_NUMBER_ATTRIBUTE_ID (0x0003)
#define ZCL_RSSI_ATTRIBUTE_ID (0x0004)
#define ZCL_BEACON_LOST_COUNT_ATTRIBUTE_ID (0x0005)
#define ZCL_BEACON_RX_COUNT_ATTRIBUTE_ID (0x0006)
#define ZCL_PACKET_MULTICAST_RX_COUNT_ATTRIBUTE_ID (0x0007)
#define ZCL_PACKET_MULTICAST_TX_COUNT_ATTRIBUTE_ID (0x0008)
#define ZCL_PACKET_UNICAST_RX_COUNT_ATTRIBUTE_ID (0x0009)
#define ZCL_PACKET_UNICAST_TX_COUNT_ATTRIBUTE_ID (0x000A)
#define ZCL_CURRENT_MAX_RATE_ATTRIBUTE_ID (0x000B)
#define ZCL_OVERRUN_COUNT_ATTRIBUTE_ID (0x000C)

// Attribute ids for cluster: Ethernet Network Diagnostics

// Client attributes

// Server attributes
#define ZCL_PHY_RATE_ATTRIBUTE_ID (0x0000)
#define ZCL_FULL_DUPLEX_ATTRIBUTE_ID (0x0001)
#define ZCL_PACKET_RX_COUNT_ATTRIBUTE_ID (0x0002)
#define ZCL_PACKET_TX_COUNT_ATTRIBUTE_ID (0x0003)
#define ZCL_TX_ERR_COUNT_ATTRIBUTE_ID (0x0004)
#define ZCL_COLLISION_COUNT_ATTRIBUTE_ID (0x0005)
#define ZCL_ETHERNET_OVERRUN_COUNT_ATTRIBUTE_ID (0x0006)
#define ZCL_CARRIER_DETECT_ATTRIBUTE_ID (0x0007)
#define ZCL_TIME_SINCE_RESET_ATTRIBUTE_ID (0x0008)

// Attribute ids for cluster: Time Synchronization

// Client attributes

// Server attributes
#define ZCL_UTC_TIME_ATTRIBUTE_ID (0x0000)
#define ZCL_GRANULARITY_ATTRIBUTE_ID (0x0001)
#define ZCL_TIME_SOURCE_ATTRIBUTE_ID (0x0002)
#define ZCL_TRUSTED_TIME_NODE_ID_ATTRIBUTE_ID (0x0003)
#define ZCL_DEFAULT_NTP_ATTRIBUTE_ID (0x0004)
#define ZCL_TIME_ZONE_ATTRIBUTE_ID (0x0005)
#define ZCL_DST_OFFSET_ATTRIBUTE_ID (0x0006)
#define ZCL_LOCAL_TIME_ATTRIBUTE_ID (0x0007)
#define ZCL_TIME_ZONE_DATABASE_ATTRIBUTE_ID (0x0008)
#define ZCL_NTP_SERVER_PORT_ATTRIBUTE_ID (0x0009)

// Attribute ids for cluster: Bridged Device Basic

// Client attributes

// Server attributes
#define ZCL_VENDOR_NAME_ATTRIBUTE_ID (0x0001)
#define ZCL_VENDOR_ID_ATTRIBUTE_ID (0x0002)
#define ZCL_PRODUCT_NAME_ATTRIBUTE_ID (0x0003)
#define ZCL_NODE_LABEL_ATTRIBUTE_ID (0x0005)
#define ZCL_HARDWARE_VERSION_ATTRIBUTE_ID (0x0007)
#define ZCL_HARDWARE_VERSION_STRING_ATTRIBUTE_ID (0x0008)
#define ZCL_SOFTWARE_VERSION_ATTRIBUTE_ID (0x0009)
#define ZCL_SOFTWARE_VERSION_STRING_ATTRIBUTE_ID (0x000A)
#define ZCL_MANUFACTURING_DATE_ATTRIBUTE_ID (0x000B)
#define ZCL_PART_NUMBER_ATTRIBUTE_ID (0x000C)
#define ZCL_PRODUCT_URL_ATTRIBUTE_ID (0x000D)
#define ZCL_PRODUCT_LABEL_ATTRIBUTE_ID (0x000E)
#define ZCL_SERIAL_NUMBER_ATTRIBUTE_ID (0x000F)
#define ZCL_REACHABLE_ATTRIBUTE_ID (0x0011)
#define ZCL_UNIQUE_ID_ATTRIBUTE_ID (0x0012)

// Attribute ids for cluster: Switch

// Client attributes

// Server attributes
#define ZCL_NUMBER_OF_POSITIONS_ATTRIBUTE_ID (0x0000)
#define ZCL_CURRENT_POSITION_ATTRIBUTE_ID (0x0001)
#define ZCL_MULTI_PRESS_MAX_ATTRIBUTE_ID (0x0002)

// Attribute ids for cluster: AdministratorCommissioning

// Client attributes

// Server attributes
#define ZCL_WINDOW_STATUS_ATTRIBUTE_ID (0x0000)
#define ZCL_ADMIN_FABRIC_INDEX_ATTRIBUTE_ID (0x0001)
#define ZCL_ADMIN_VENDOR_ID_ATTRIBUTE_ID (0x0002)

// Attribute ids for cluster: Operational Credentials

// Client attributes

// Server attributes
#define ZCL_NOCS_ATTRIBUTE_ID (0x0000)
#define ZCL_FABRICS_ATTRIBUTE_ID (0x0001)
#define ZCL_SUPPORTED_FABRICS_ATTRIBUTE_ID (0x0002)
#define ZCL_COMMISSIONED_FABRICS_ATTRIBUTE_ID (0x0003)
#define ZCL_TRUSTED_ROOT_CERTIFICATES_ATTRIBUTE_ID (0x0004)
#define ZCL_CURRENT_FABRIC_INDEX_ATTRIBUTE_ID (0x0005)

// Attribute ids for cluster: Group Key Management

// Client attributes

// Server attributes
#define ZCL_GROUP_KEY_MAP_ATTRIBUTE_ID (0x0000)
#define ZCL_GROUP_TABLE_ATTRIBUTE_ID (0x0001)
#define ZCL_MAX_GROUPS_PER_FABRIC_ATTRIBUTE_ID (0x0002)
#define ZCL_MAX_GROUP_KEYS_PER_FABRIC_ATTRIBUTE_ID (0x0003)

// Attribute ids for cluster: Fixed Label

// Client attributes

// Server attributes
#define ZCL_LABEL_LIST_ATTRIBUTE_ID (0x0000)

// Attribute ids for cluster: User Label

// Client attributes

// Server attributes
#define ZCL_LABEL_LIST_ATTRIBUTE_ID (0x0000)

// Attribute ids for cluster: Proxy Configuration

// Client attributes

// Server attributes

// Attribute ids for cluster: Proxy Discovery

// Client attributes

// Server attributes

// Attribute ids for cluster: Proxy Valid

// Client attributes

// Server attributes

// Attribute ids for cluster: Boolean State

// Client attributes

// Server attributes
#define ZCL_STATE_VALUE_ATTRIBUTE_ID (0x0000)

// Attribute ids for cluster: Mode Select

// Client attributes

// Server attributes
#define ZCL_MODE_DESCRIPTION_ATTRIBUTE_ID (0x0000)
#define ZCL_STANDARD_NAMESPACE_ATTRIBUTE_ID (0x0001)
#define ZCL_SUPPORTED_MODES_ATTRIBUTE_ID (0x0002)
#define ZCL_CURRENT_MODE_ATTRIBUTE_ID (0x0003)
#define ZCL_START_UP_MODE_ATTRIBUTE_ID (0x0004)
#define ZCL_ON_MODE_ATTRIBUTE_ID (0x0005)

// Attribute ids for cluster: Door Lock

// Client attributes

// Server attributes
#define ZCL_LOCK_STATE_ATTRIBUTE_ID (0x0000)
#define ZCL_LOCK_TYPE_ATTRIBUTE_ID (0x0001)
#define ZCL_ACTUATOR_ENABLED_ATTRIBUTE_ID (0x0002)
#define ZCL_DOOR_STATE_ATTRIBUTE_ID (0x0003)
#define ZCL_DOOR_OPEN_EVENTS_ATTRIBUTE_ID (0x0004)
#define ZCL_DOOR_CLOSED_EVENTS_ATTRIBUTE_ID (0x0005)
#define ZCL_OPEN_PERIOD_ATTRIBUTE_ID (0x0006)
#define ZCL_NUM_TOTAL_USERS_SUPPORTED_ATTRIBUTE_ID (0x0011)
#define ZCL_NUM_PIN_USERS_SUPPORTED_ATTRIBUTE_ID (0x0012)
#define ZCL_NUM_RFID_USERS_SUPPORTED_ATTRIBUTE_ID (0x0013)
#define ZCL_NUM_WEEKDAY_SCHEDULES_SUPPORTED_PER_USER_ATTRIBUTE_ID (0x0014)
#define ZCL_NUM_YEARDAY_SCHEDULES_SUPPORTED_PER_USER_ATTRIBUTE_ID (0x0015)
#define ZCL_NUM_HOLIDAY_SCHEDULES_SUPPORTED_ATTRIBUTE_ID (0x0016)
#define ZCL_MAX_PIN_LENGTH_ATTRIBUTE_ID (0x0017)
#define ZCL_MIN_PIN_LENGTH_ATTRIBUTE_ID (0x0018)
#define ZCL_MAX_RFID_CODE_LENGTH_ATTRIBUTE_ID (0x0019)
#define ZCL_MIN_RFID_CODE_LENGTH_ATTRIBUTE_ID (0x001A)
#define ZCL_CREDENTIAL_RULES_SUPPORT_ATTRIBUTE_ID (0x001B)
#define ZCL_NUM_CREDENTIALS_SUPPORTED_PER_USER_ATTRIBUTE_ID (0x001C)
#define ZCL_LANGUAGE_ATTRIBUTE_ID (0x0021)
#define ZCL_LED_SETTINGS_ATTRIBUTE_ID (0x0022)
#define ZCL_AUTO_RELOCK_TIME_ATTRIBUTE_ID (0x0023)
#define ZCL_SOUND_VOLUME_ATTRIBUTE_ID (0x0024)
#define ZCL_OPERATING_MODE_ATTRIBUTE_ID (0x0025)
#define ZCL_SUPPORTED_OPERATING_MODES_ATTRIBUTE_ID (0x0026)
#define ZCL_DEFAULT_CONFIGURATION_REGISTER_ATTRIBUTE_ID (0x0027)
#define ZCL_ENABLE_LOCAL_PROGRAMMING_ATTRIBUTE_ID (0x0028)
#define ZCL_ENABLE_ONE_TOUCH_LOCKING_ATTRIBUTE_ID (0x0029)
#define ZCL_ENABLE_INSIDE_STATUS_LED_ATTRIBUTE_ID (0x002A)
#define ZCL_ENABLE_PRIVACY_MODE_BUTTON_ATTRIBUTE_ID (0x002B)
#define ZCL_LOCAL_PROGRAMMING_FEATURES_ATTRIBUTE_ID (0x002C)
#define ZCL_WRONG_CODE_ENTRY_LIMIT_ATTRIBUTE_ID (0x0030)
#define ZCL_USER_CODE_TEMPORARY_DISABLE_TIME_ATTRIBUTE_ID (0x0031)
#define ZCL_SEND_PIN_OVER_THE_AIR_ATTRIBUTE_ID (0x0032)
#define ZCL_REQUIRE_PIN_FOR_REMOTE_OPERATION_ATTRIBUTE_ID (0x0033)
#define ZCL_EXPIRING_USER_TIMEOUT_ATTRIBUTE_ID (0x0035)

// Attribute ids for cluster: Window Covering

// Client attributes

// Server attributes
#define ZCL_WC_TYPE_ATTRIBUTE_ID (0x0000)
#define ZCL_WC_PHYSICAL_CLOSED_LIMIT_LIFT_ATTRIBUTE_ID (0x0001)
#define ZCL_WC_PHYSICAL_CLOSED_LIMIT_TILT_ATTRIBUTE_ID (0x0002)
#define ZCL_WC_CURRENT_POSITION_LIFT_ATTRIBUTE_ID (0x0003)
#define ZCL_WC_CURRENT_POSITION_TILT_ATTRIBUTE_ID (0x0004)
#define ZCL_WC_NUMBER_OF_ACTUATIONS_LIFT_ATTRIBUTE_ID (0x0005)
#define ZCL_WC_NUMBER_OF_ACTUATIONS_TILT_ATTRIBUTE_ID (0x0006)
#define ZCL_WC_CONFIG_STATUS_ATTRIBUTE_ID (0x0007)
#define ZCL_WC_CURRENT_POSITION_LIFT_PERCENTAGE_ATTRIBUTE_ID (0x0008)
#define ZCL_WC_CURRENT_POSITION_TILT_PERCENTAGE_ATTRIBUTE_ID (0x0009)
#define ZCL_WC_OPERATIONAL_STATUS_ATTRIBUTE_ID (0x000A)
#define ZCL_WC_TARGET_POSITION_LIFT_PERCENT100_THS_ATTRIBUTE_ID (0x000B)
#define ZCL_WC_TARGET_POSITION_TILT_PERCENT100_THS_ATTRIBUTE_ID (0x000C)
#define ZCL_WC_END_PRODUCT_TYPE_ATTRIBUTE_ID (0x000D)
#define ZCL_WC_CURRENT_POSITION_LIFT_PERCENT100_THS_ATTRIBUTE_ID (0x000E)
#define ZCL_WC_CURRENT_POSITION_TILT_PERCENT100_THS_ATTRIBUTE_ID (0x000F)
#define ZCL_WC_INSTALLED_OPEN_LIMIT_LIFT_ATTRIBUTE_ID (0x0010)
#define ZCL_WC_INSTALLED_CLOSED_LIMIT_LIFT_ATTRIBUTE_ID (0x0011)
#define ZCL_WC_INSTALLED_OPEN_LIMIT_TILT_ATTRIBUTE_ID (0x0012)
#define ZCL_WC_INSTALLED_CLOSED_LIMIT_TILT_ATTRIBUTE_ID (0x0013)
#define ZCL_WC_MODE_ATTRIBUTE_ID (0x0017)
#define ZCL_WC_SAFETY_STATUS_ATTRIBUTE_ID (0x001A)

// Attribute ids for cluster: Barrier Control

// Client attributes

// Server attributes
#define ZCL_BARRIER_MOVING_STATE_ATTRIBUTE_ID (0x0001)
#define ZCL_BARRIER_SAFETY_STATUS_ATTRIBUTE_ID (0x0002)
#define ZCL_BARRIER_CAPABILITIES_ATTRIBUTE_ID (0x0003)
#define ZCL_BARRIER_OPEN_EVENTS_ATTRIBUTE_ID (0x0004)
#define ZCL_BARRIER_CLOSE_EVENTS_ATTRIBUTE_ID (0x0005)
#define ZCL_BARRIER_COMMAND_OPEN_EVENTS_ATTRIBUTE_ID (0x0006)
#define ZCL_BARRIER_COMMAND_CLOSE_EVENTS_ATTRIBUTE_ID (0x0007)
#define ZCL_BARRIER_OPEN_PERIOD_ATTRIBUTE_ID (0x0008)
#define ZCL_BARRIER_CLOSE_PERIOD_ATTRIBUTE_ID (0x0009)
#define ZCL_BARRIER_POSITION_ATTRIBUTE_ID (0x000A)

// Attribute ids for cluster: Pump Configuration and Control

// Client attributes

// Server attributes
#define ZCL_MAX_PRESSURE_ATTRIBUTE_ID (0x0000)
#define ZCL_MAX_SPEED_ATTRIBUTE_ID (0x0001)
#define ZCL_MAX_FLOW_ATTRIBUTE_ID (0x0002)
#define ZCL_MIN_CONST_PRESSURE_ATTRIBUTE_ID (0x0003)
#define ZCL_MAX_CONST_PRESSURE_ATTRIBUTE_ID (0x0004)
#define ZCL_MIN_COMP_PRESSURE_ATTRIBUTE_ID (0x0005)
#define ZCL_MAX_COMP_PRESSURE_ATTRIBUTE_ID (0x0006)
#define ZCL_MIN_CONST_SPEED_ATTRIBUTE_ID (0x0007)
#define ZCL_MAX_CONST_SPEED_ATTRIBUTE_ID (0x0008)
#define ZCL_MIN_CONST_FLOW_ATTRIBUTE_ID (0x0009)
#define ZCL_MAX_CONST_FLOW_ATTRIBUTE_ID (0x000A)
#define ZCL_MIN_CONST_TEMP_ATTRIBUTE_ID (0x000B)
#define ZCL_MAX_CONST_TEMP_ATTRIBUTE_ID (0x000C)
#define ZCL_PUMP_STATUS_ATTRIBUTE_ID (0x0010)
#define ZCL_EFFECTIVE_OPERATION_MODE_ATTRIBUTE_ID (0x0011)
#define ZCL_EFFECTIVE_CONTROL_MODE_ATTRIBUTE_ID (0x0012)
#define ZCL_CAPACITY_ATTRIBUTE_ID (0x0013)
#define ZCL_SPEED_ATTRIBUTE_ID (0x0014)
#define ZCL_LIFETIME_RUNNING_HOURS_ATTRIBUTE_ID (0x0015)
#define ZCL_PUMP_POWER_ATTRIBUTE_ID (0x0016)
#define ZCL_LIFETIME_ENERGY_CONSUMED_ATTRIBUTE_ID (0x0017)
#define ZCL_OPERATION_MODE_ATTRIBUTE_ID (0x0020)
#define ZCL_CONTROL_MODE_ATTRIBUTE_ID (0x0021)

// Attribute ids for cluster: Thermostat

// Client attributes

// Server attributes
#define ZCL_LOCAL_TEMPERATURE_ATTRIBUTE_ID (0x0000)
#define ZCL_OUTDOOR_TEMPERATURE_ATTRIBUTE_ID (0x0001)
#define ZCL_THERMOSTAT_OCCUPANCY_ATTRIBUTE_ID (0x0002)
#define ZCL_ABS_MIN_HEAT_SETPOINT_LIMIT_ATTRIBUTE_ID (0x0003)
#define ZCL_ABS_MAX_HEAT_SETPOINT_LIMIT_ATTRIBUTE_ID (0x0004)
#define ZCL_ABS_MIN_COOL_SETPOINT_LIMIT_ATTRIBUTE_ID (0x0005)
#define ZCL_ABS_MAX_COOL_SETPOINT_LIMIT_ATTRIBUTE_ID (0x0006)
#define ZCL_PI_COOLING_DEMAND_ATTRIBUTE_ID (0x0007)
#define ZCL_PI_HEATING_DEMAND_ATTRIBUTE_ID (0x0008)
#define ZCL_HVAC_SYSTEM_TYPE_CONFIGURATION_ATTRIBUTE_ID (0x0009)
#define ZCL_LOCAL_TEMPERATURE_CALIBRATION_ATTRIBUTE_ID (0x0010)
#define ZCL_OCCUPIED_COOLING_SETPOINT_ATTRIBUTE_ID (0x0011)
#define ZCL_OCCUPIED_HEATING_SETPOINT_ATTRIBUTE_ID (0x0012)
#define ZCL_UNOCCUPIED_COOLING_SETPOINT_ATTRIBUTE_ID (0x0013)
#define ZCL_UNOCCUPIED_HEATING_SETPOINT_ATTRIBUTE_ID (0x0014)
#define ZCL_MIN_HEAT_SETPOINT_LIMIT_ATTRIBUTE_ID (0x0015)
#define ZCL_MAX_HEAT_SETPOINT_LIMIT_ATTRIBUTE_ID (0x0016)
#define ZCL_MIN_COOL_SETPOINT_LIMIT_ATTRIBUTE_ID (0x0017)
#define ZCL_MAX_COOL_SETPOINT_LIMIT_ATTRIBUTE_ID (0x0018)
#define ZCL_MIN_SETPOINT_DEAD_BAND_ATTRIBUTE_ID (0x0019)
#define ZCL_REMOTE_SENSING_ATTRIBUTE_ID (0x001A)
#define ZCL_CONTROL_SEQUENCE_OF_OPERATION_ATTRIBUTE_ID (0x001B)
#define ZCL_SYSTEM_MODE_ATTRIBUTE_ID (0x001C)
#define ZCL_THERMOSTAT_RUNNING_MODE_ATTRIBUTE_ID (0x001E)
#define ZCL_START_OF_WEEK_ATTRIBUTE_ID (0x0020)
#define ZCL_NUMBER_OF_WEEKLY_TRANSITIONS_ATTRIBUTE_ID (0x0021)
#define ZCL_NUMBER_OF_DAILY_TRANSITIONS_ATTRIBUTE_ID (0x0022)
#define ZCL_TEMPERATURE_SETPOINT_HOLD_ATTRIBUTE_ID (0x0023)
#define ZCL_TEMPERATURE_SETPOINT_HOLD_DURATION_ATTRIBUTE_ID (0x0024)
#define ZCL_THERMOSTAT_PROGRAMMING_OPERATION_MODE_ATTRIBUTE_ID (0x0025)
#define ZCL_THERMOSTAT_RUNNING_STATE_ATTRIBUTE_ID (0x0029)
#define ZCL_SETPOINT_CHANGE_SOURCE_ATTRIBUTE_ID (0x0030)
#define ZCL_SETPOINT_CHANGE_AMOUNT_ATTRIBUTE_ID (0x0031)
#define ZCL_SETPOINT_CHANGE_SOURCE_TIMESTAMP_ATTRIBUTE_ID (0x0032)
#define ZCL_OCCUPIED_SETBACK_ATTRIBUTE_ID (0x0034)
#define ZCL_OCCUPIED_SETBACK_MIN_ATTRIBUTE_ID (0x0035)
#define ZCL_OCCUPIED_SETBACK_MAX_ATTRIBUTE_ID (0x0036)
#define ZCL_UNOCCUPIED_SETBACK_ATTRIBUTE_ID (0x0037)
#define ZCL_UNOCCUPIED_SETBACK_MIN_ATTRIBUTE_ID (0x0038)
#define ZCL_UNOCCUPIED_SETBACK_MAX_ATTRIBUTE_ID (0x0039)
#define ZCL_EMERGENCY_HEAT_DELTA_ATTRIBUTE_ID (0x003A)
#define ZCL_AC_TYPE_ATTRIBUTE_ID (0x0040)
#define ZCL_AC_CAPACITY_ATTRIBUTE_ID (0x0041)
#define ZCL_AC_REFRIGERANT_TYPE_ATTRIBUTE_ID (0x0042)
#define ZCL_AC_COMPRESSOR_TYPE_ATTRIBUTE_ID (0x0043)
#define ZCL_AC_ERROR_CODE_ATTRIBUTE_ID (0x0044)
#define ZCL_AC_LOUVER_POSITION_ATTRIBUTE_ID (0x0045)
#define ZCL_AC_COIL_TEMPERATURE_ATTRIBUTE_ID (0x0046)
#define ZCL_AC_CAPACITY_FORMAT_ATTRIBUTE_ID (0x0047)

// Attribute ids for cluster: Fan Control

// Client attributes

// Server attributes
#define ZCL_FAN_MODE_ATTRIBUTE_ID (0x0000)
#define ZCL_FAN_MODE_SEQUENCE_ATTRIBUTE_ID (0x0001)
#define ZCL_PERCENT_SETTING_ATTRIBUTE_ID (0x0002)
#define ZCL_PERCENT_CURRENT_ATTRIBUTE_ID (0x0003)
#define ZCL_SPEED_MAX_ATTRIBUTE_ID (0x0004)
#define ZCL_SPEED_SETTING_ATTRIBUTE_ID (0x0005)
#define ZCL_SPEED_CURRENT_ATTRIBUTE_ID (0x0006)
#define ZCL_ROCK_SUPPORT_ATTRIBUTE_ID (0x0007)
#define ZCL_ROCK_SETTING_ATTRIBUTE_ID (0x0008)
#define ZCL_WIND_SUPPORT_ATTRIBUTE_ID (0x0009)
#define ZCL_WIND_SETTING_ATTRIBUTE_ID (0x000A)

// Attribute ids for cluster: Thermostat User Interface Configuration

// Client attributes

// Server attributes
#define ZCL_TEMPERATURE_DISPLAY_MODE_ATTRIBUTE_ID (0x0000)
#define ZCL_KEYPAD_LOCKOUT_ATTRIBUTE_ID (0x0001)
#define ZCL_SCHEDULE_PROGRAMMING_VISIBILITY_ATTRIBUTE_ID (0x0002)

// Attribute ids for cluster: Color Control

// Client attributes

// Server attributes
#define ZCL_COLOR_CONTROL_CURRENT_HUE_ATTRIBUTE_ID (0x0000)
#define ZCL_COLOR_CONTROL_CURRENT_SATURATION_ATTRIBUTE_ID (0x0001)
#define ZCL_COLOR_CONTROL_REMAINING_TIME_ATTRIBUTE_ID (0x0002)
#define ZCL_COLOR_CONTROL_CURRENT_X_ATTRIBUTE_ID (0x0003)
#define ZCL_COLOR_CONTROL_CURRENT_Y_ATTRIBUTE_ID (0x0004)
#define ZCL_COLOR_CONTROL_DRIFT_COMPENSATION_ATTRIBUTE_ID (0x0005)
#define ZCL_COLOR_CONTROL_COMPENSATION_TEXT_ATTRIBUTE_ID (0x0006)
#define ZCL_COLOR_CONTROL_COLOR_TEMPERATURE_ATTRIBUTE_ID (0x0007)
#define ZCL_COLOR_CONTROL_COLOR_MODE_ATTRIBUTE_ID (0x0008)
#define ZCL_COLOR_CONTROL_OPTIONS_ATTRIBUTE_ID (0x000F)
#define ZCL_COLOR_CONTROL_NUMBER_OF_PRIMARIES_ATTRIBUTE_ID (0x0010)
#define ZCL_COLOR_CONTROL_PRIMARY_1_X_ATTRIBUTE_ID (0x0011)
#define ZCL_COLOR_CONTROL_PRIMARY_1_Y_ATTRIBUTE_ID (0x0012)
#define ZCL_COLOR_CONTROL_PRIMARY_1_INTENSITY_ATTRIBUTE_ID (0x0013)
#define ZCL_COLOR_CONTROL_PRIMARY_2_X_ATTRIBUTE_ID (0x0015)
#define ZCL_COLOR_CONTROL_PRIMARY_2_Y_ATTRIBUTE_ID (0x0016)
#define ZCL_COLOR_CONTROL_PRIMARY_2_INTENSITY_ATTRIBUTE_ID (0x0017)
#define ZCL_COLOR_CONTROL_PRIMARY_3_X_ATTRIBUTE_ID (0x0019)
#define ZCL_COLOR_CONTROL_PRIMARY_3_Y_ATTRIBUTE_ID (0x001A)
#define ZCL_COLOR_CONTROL_PRIMARY_3_INTENSITY_ATTRIBUTE_ID (0x001B)
#define ZCL_COLOR_CONTROL_PRIMARY_4_X_ATTRIBUTE_ID (0x0020)
#define ZCL_COLOR_CONTROL_PRIMARY_4_Y_ATTRIBUTE_ID (0x0021)
#define ZCL_COLOR_CONTROL_PRIMARY_4_INTENSITY_ATTRIBUTE_ID (0x0022)
#define ZCL_COLOR_CONTROL_PRIMARY_5_X_ATTRIBUTE_ID (0x0024)
#define ZCL_COLOR_CONTROL_PRIMARY_5_Y_ATTRIBUTE_ID (0x0025)
#define ZCL_COLOR_CONTROL_PRIMARY_5_INTENSITY_ATTRIBUTE_ID (0x0026)
#define ZCL_COLOR_CONTROL_PRIMARY_6_X_ATTRIBUTE_ID (0x0028)
#define ZCL_COLOR_CONTROL_PRIMARY_6_Y_ATTRIBUTE_ID (0x0029)
#define ZCL_COLOR_CONTROL_PRIMARY_6_INTENSITY_ATTRIBUTE_ID (0x002A)
#define ZCL_COLOR_CONTROL_WHITE_POINT_X_ATTRIBUTE_ID (0x0030)
#define ZCL_COLOR_CONTROL_WHITE_POINT_Y_ATTRIBUTE_ID (0x0031)
#define ZCL_COLOR_CONTROL_COLOR_POINT_R_X_ATTRIBUTE_ID (0x0032)
#define ZCL_COLOR_CONTROL_COLOR_POINT_R_Y_ATTRIBUTE_ID (0x0033)
#define ZCL_COLOR_CONTROL_COLOR_POINT_R_INTENSITY_ATTRIBUTE_ID (0x0034)
#define ZCL_COLOR_CONTROL_COLOR_POINT_G_X_ATTRIBUTE_ID (0x0036)
#define ZCL_COLOR_CONTROL_COLOR_POINT_G_Y_ATTRIBUTE_ID (0x0037)
#define ZCL_COLOR_CONTROL_COLOR_POINT_G_INTENSITY_ATTRIBUTE_ID (0x0038)
#define ZCL_COLOR_CONTROL_COLOR_POINT_B_X_ATTRIBUTE_ID (0x003A)
#define ZCL_COLOR_CONTROL_COLOR_POINT_B_Y_ATTRIBUTE_ID (0x003B)
#define ZCL_COLOR_CONTROL_COLOR_POINT_B_INTENSITY_ATTRIBUTE_ID (0x003C)
#define ZCL_COLOR_CONTROL_ENHANCED_CURRENT_HUE_ATTRIBUTE_ID (0x4000)
#define ZCL_COLOR_CONTROL_ENHANCED_COLOR_MODE_ATTRIBUTE_ID (0x4001)
#define ZCL_COLOR_CONTROL_COLOR_LOOP_ACTIVE_ATTRIBUTE_ID (0x4002)
#define ZCL_COLOR_CONTROL_COLOR_LOOP_DIRECTION_ATTRIBUTE_ID (0x4003)
#define ZCL_COLOR_CONTROL_COLOR_LOOP_TIME_ATTRIBUTE_ID (0x4004)
#define ZCL_COLOR_CONTROL_COLOR_LOOP_START_ENHANCED_HUE_ATTRIBUTE_ID (0x4005)
#define ZCL_COLOR_CONTROL_COLOR_LOOP_STORED_ENHANCED_HUE_ATTRIBUTE_ID (0x4006)
#define ZCL_COLOR_CONTROL_COLOR_CAPABILITIES_ATTRIBUTE_ID (0x400A)
#define ZCL_COLOR_CONTROL_COLOR_TEMP_PHYSICAL_MIN_ATTRIBUTE_ID (0x400B)
#define ZCL_COLOR_CONTROL_COLOR_TEMP_PHYSICAL_MAX_ATTRIBUTE_ID (0x400C)
#define ZCL_COLOR_CONTROL_TEMPERATURE_LEVEL_MIN_MIREDS_ATTRIBUTE_ID (0x400D)
#define ZCL_START_UP_COLOR_TEMPERATURE_MIREDS_ATTRIBUTE_ID (0x4010)

// Attribute ids for cluster: Ballast Configuration

// Client attributes

// Server attributes
#define ZCL_PHYSICAL_MIN_LEVEL_ATTRIBUTE_ID (0x0000)
#define ZCL_PHYSICAL_MAX_LEVEL_ATTRIBUTE_ID (0x0001)
#define ZCL_BALLAST_STATUS_ATTRIBUTE_ID (0x0002)
#define ZCL_MIN_LEVEL_ATTRIBUTE_ID (0x0010)
#define ZCL_MAX_LEVEL_ATTRIBUTE_ID (0x0011)
#define ZCL_INTRINSIC_BALLAST_FACTOR_ATTRIBUTE_ID (0x0014)
#define ZCL_BALLAST_FACTOR_ADJUSTMENT_ATTRIBUTE_ID (0x0015)
#define ZCL_LAMP_QUANTITY_ATTRIBUTE_ID (0x0020)
#define ZCL_LAMP_TYPE_ATTRIBUTE_ID (0x0030)
#define ZCL_LAMP_MANUFACTURER_ATTRIBUTE_ID (0x0031)
#define ZCL_LAMP_RATED_HOURS_ATTRIBUTE_ID (0x0032)
#define ZCL_LAMP_BURN_HOURS_ATTRIBUTE_ID (0x0033)
#define ZCL_LAMP_ALARM_MODE_ATTRIBUTE_ID (0x0034)
#define ZCL_LAMP_BURN_HOURS_TRIP_POINT_ATTRIBUTE_ID (0x0035)

// Attribute ids for cluster: Illuminance Measurement

// Client attributes

// Server attributes
#define ZCL_ILLUM_MEASURED_VALUE_ATTRIBUTE_ID (0x0000)
#define ZCL_ILLUM_MIN_MEASURED_VALUE_ATTRIBUTE_ID (0x0001)
#define ZCL_ILLUM_MAX_MEASURED_VALUE_ATTRIBUTE_ID (0x0002)
#define ZCL_ILLUM_TOLERANCE_ATTRIBUTE_ID (0x0003)
#define ZCL_ILLUM_LIGHT_SENSOR_TYPE_ATTRIBUTE_ID (0x0004)

// Attribute ids for cluster: Temperature Measurement

// Client attributes

// Server attributes
#define ZCL_TEMP_MEASURED_VALUE_ATTRIBUTE_ID (0x0000)
#define ZCL_TEMP_MIN_MEASURED_VALUE_ATTRIBUTE_ID (0x0001)
#define ZCL_TEMP_MAX_MEASURED_VALUE_ATTRIBUTE_ID (0x0002)
#define ZCL_TEMP_TOLERANCE_ATTRIBUTE_ID (0x0003)

// Attribute ids for cluster: Pressure Measurement

// Client attributes

// Server attributes
#define ZCL_PRESSURE_MEASURED_VALUE_ATTRIBUTE_ID (0x0000)
#define ZCL_PRESSURE_MIN_MEASURED_VALUE_ATTRIBUTE_ID (0x0001)
#define ZCL_PRESSURE_MAX_MEASURED_VALUE_ATTRIBUTE_ID (0x0002)
#define ZCL_PRESSURE_TOLERANCE_ATTRIBUTE_ID (0x0003)
#define ZCL_PRESSURE_SCALED_VALUE_ATTRIBUTE_ID (0x0010)
#define ZCL_PRESSURE_MIN_SCALED_VALUE_ATTRIBUTE_ID (0x0011)
#define ZCL_PRESSURE_MAX_SCALED_VALUE_ATTRIBUTE_ID (0x0012)
#define ZCL_PRESSURE_SCALED_TOLERANCE_ATTRIBUTE_ID (0x0013)
#define ZCL_PRESSURE_SCALE_ATTRIBUTE_ID (0x0014)

// Attribute ids for cluster: Flow Measurement

// Client attributes

// Server attributes
#define ZCL_FLOW_MEASURED_VALUE_ATTRIBUTE_ID (0x0000)
#define ZCL_FLOW_MIN_MEASURED_VALUE_ATTRIBUTE_ID (0x0001)
#define ZCL_FLOW_MAX_MEASURED_VALUE_ATTRIBUTE_ID (0x0002)
#define ZCL_FLOW_TOLERANCE_ATTRIBUTE_ID (0x0003)

// Attribute ids for cluster: Relative Humidity Measurement

// Client attributes

// Server attributes
#define ZCL_RELATIVE_HUMIDITY_MEASURED_VALUE_ATTRIBUTE_ID (0x0000)
#define ZCL_RELATIVE_HUMIDITY_MIN_MEASURED_VALUE_ATTRIBUTE_ID (0x0001)
#define ZCL_RELATIVE_HUMIDITY_MAX_MEASURED_VALUE_ATTRIBUTE_ID (0x0002)
#define ZCL_RELATIVE_HUMIDITY_TOLERANCE_ATTRIBUTE_ID (0x0003)

// Attribute ids for cluster: Occupancy Sensing

// Client attributes

// Server attributes
#define ZCL_OCCUPANCY_ATTRIBUTE_ID (0x0000)
#define ZCL_OCCUPANCY_SENSOR_TYPE_ATTRIBUTE_ID (0x0001)
#define ZCL_OCCUPANCY_SENSOR_TYPE_BITMAP_ATTRIBUTE_ID (0x0002)
#define ZCL_PIR_OCCUPIED_TO_UNOCCUPIED_DELAY_ATTRIBUTE_ID (0x0010)
#define ZCL_PIR_UNOCCUPIED_TO_OCCUPIED_DELAY_ATTRIBUTE_ID (0x0011)
#define ZCL_PIR_UNOCCUPIED_TO_OCCUPIED_THRESHOLD_ATTRIBUTE_ID (0x0012)
#define ZCL_ULTRASONIC_OCCUPIED_TO_UNOCCUPIED_DELAY_ATTRIBUTE_ID (0x0020)
#define ZCL_ULTRASONIC_UNOCCUPIED_TO_OCCUPIED_DELAY_ATTRIBUTE_ID (0x0021)
#define ZCL_ULTRASONIC_UNOCCUPIED_TO_OCCUPIED_THRESHOLD_ATTRIBUTE_ID (0x0022)
#define ZCL_PHYSICAL_CONTACT_OCCUPIED_TO_UNOCCUPIED_DELAY_ATTRIBUTE_ID (0x0030)
#define ZCL_PHYSICAL_CONTACT_UNOCCUPIED_TO_OCCUPIED_DELAY_ATTRIBUTE_ID (0x0031)
#define ZCL_PHYSICAL_CONTACT_UNOCCUPIED_TO_OCCUPIED_THRESHOLD_ATTRIBUTE_ID (0x0032)

// Attribute ids for cluster: Wake on LAN

// Client attributes

// Server attributes
#define ZCL_WAKE_ON_LAN_MAC_ADDRESS_ATTRIBUTE_ID (0x0000)

// Attribute ids for cluster: Channel

// Client attributes

// Server attributes
#define ZCL_CHANNEL_LIST_ATTRIBUTE_ID (0x0000)
#define ZCL_CHANNEL_LINEUP_ATTRIBUTE_ID (0x0001)
#define ZCL_CHANNEL_CURRENT_CHANNEL_ATTRIBUTE_ID (0x0002)

// Attribute ids for cluster: Target Navigator

// Client attributes

// Server attributes
#define ZCL_TARGET_NAVIGATOR_LIST_ATTRIBUTE_ID (0x0000)
#define ZCL_TARGET_NAVIGATOR_CURRENT_TARGET_ATTRIBUTE_ID (0x0001)

// Attribute ids for cluster: Media Playback

// Client attributes

// Server attributes
#define ZCL_MEDIA_PLAYBACK_STATE_ATTRIBUTE_ID (0x0000)
#define ZCL_MEDIA_PLAYBACK_START_TIME_ATTRIBUTE_ID (0x0001)
#define ZCL_MEDIA_PLAYBACK_DURATION_ATTRIBUTE_ID (0x0002)
#define ZCL_MEDIA_PLAYBACK_PLAYBACK_POSITION_ATTRIBUTE_ID (0x0003)
#define ZCL_MEDIA_PLAYBACK_PLAYBACK_SPEED_ATTRIBUTE_ID (0x0004)
#define ZCL_MEDIA_PLAYBACK_PLAYBACK_SEEK_RANGE_END_ATTRIBUTE_ID (0x0005)
#define ZCL_MEDIA_PLAYBACK_PLAYBACK_SEEK_RANGE_START_ATTRIBUTE_ID (0x0006)

// Attribute ids for cluster: Media Input

// Client attributes

// Server attributes
#define ZCL_MEDIA_INPUT_LIST_ATTRIBUTE_ID (0x0000)
#define ZCL_MEDIA_INPUT_CURRENT_INPUT_ATTRIBUTE_ID (0x0001)

// Attribute ids for cluster: Low Power

// Client attributes

// Server attributes

// Attribute ids for cluster: Keypad Input

// Client attributes

// Server attributes

// Attribute ids for cluster: Content Launcher

// Client attributes

// Server attributes
#define ZCL_CONTENT_LAUNCHER_ACCEPT_HEADER_ATTRIBUTE_ID (0x0000)
#define ZCL_CONTENT_LAUNCHER_SUPPORTED_STREAMING_PROTOCOLS_ATTRIBUTE_ID (0x0001)

// Attribute ids for cluster: Audio Output

// Client attributes

// Server attributes
#define ZCL_AUDIO_OUTPUT_LIST_ATTRIBUTE_ID (0x0000)
#define ZCL_AUDIO_OUTPUT_CURRENT_OUTPUT_ATTRIBUTE_ID (0x0001)

// Attribute ids for cluster: Application Launcher

// Client attributes

// Server attributes
#define ZCL_APPLICATION_LAUNCHER_LIST_ATTRIBUTE_ID (0x0000)
#define ZCL_APPLICATION_LAUNCHER_CURRENT_APP_ATTRIBUTE_ID (0x0001)

// Attribute ids for cluster: Application Basic

// Client attributes

// Server attributes
#define ZCL_APPLICATION_VENDOR_NAME_ATTRIBUTE_ID (0x0000)
#define ZCL_APPLICATION_VENDOR_ID_ATTRIBUTE_ID (0x0001)
#define ZCL_APPLICATION_NAME_ATTRIBUTE_ID (0x0002)
#define ZCL_APPLICATION_PRODUCT_ID_ATTRIBUTE_ID (0x0003)
#define ZCL_APPLICATION_APP_ATTRIBUTE_ID (0x0004)
#define ZCL_APPLICATION_STATUS_ATTRIBUTE_ID (0x0005)
#define ZCL_APPLICATION_VERSION_ATTRIBUTE_ID (0x0006)
#define ZCL_APPLICATION_ALLOWED_VENDOR_LIST_ATTRIBUTE_ID (0x0007)

// Attribute ids for cluster: Account Login

// Client attributes

// Server attributes

// Attribute ids for cluster: Electrical Measurement

// Client attributes

// Server attributes
#define ZCL_MEASUREMENT_TYPE_ATTRIBUTE_ID (0x0000)
#define ZCL_DC_VOLTAGE_ATTRIBUTE_ID (0x0100)
#define ZCL_DC_VOLTAGE_MIN_ATTRIBUTE_ID (0x0101)
#define ZCL_DC_VOLTAGE_MAX_ATTRIBUTE_ID (0x0102)
#define ZCL_DC_CURRENT_ATTRIBUTE_ID (0x0103)
#define ZCL_DC_CURRENT_MIN_ATTRIBUTE_ID (0x0104)
#define ZCL_DC_CURRENT_MAX_ATTRIBUTE_ID (0x0105)
#define ZCL_DC_POWER_ATTRIBUTE_ID (0x0106)
#define ZCL_DC_POWER_MIN_ATTRIBUTE_ID (0x0107)
#define ZCL_DC_POWER_MAX_ATTRIBUTE_ID (0x0108)
#define ZCL_DC_VOLTAGE_MULTIPLIER_ATTRIBUTE_ID (0x0200)
#define ZCL_DC_VOLTAGE_DIVISOR_ATTRIBUTE_ID (0x0201)
#define ZCL_DC_CURRENT_MULTIPLIER_ATTRIBUTE_ID (0x0202)
#define ZCL_DC_CURRENT_DIVISOR_ATTRIBUTE_ID (0x0203)
#define ZCL_DC_POWER_MULTIPLIER_ATTRIBUTE_ID (0x0204)
#define ZCL_DC_POWER_DIVISOR_ATTRIBUTE_ID (0x0205)
#define ZCL_AC_FREQUENCY_ATTRIBUTE_ID (0x0300)
#define ZCL_AC_FREQUENCY_MIN_ATTRIBUTE_ID (0x0301)
#define ZCL_AC_FREQUENCY_MAX_ATTRIBUTE_ID (0x0302)
#define ZCL_NEUTRAL_CURRENT_ATTRIBUTE_ID (0x0303)
#define ZCL_TOTAL_ACTIVE_POWER_ATTRIBUTE_ID (0x0304)
#define ZCL_TOTAL_REACTIVE_POWER_ATTRIBUTE_ID (0x0305)
#define ZCL_TOTAL_APPARENT_POWER_ATTRIBUTE_ID (0x0306)
#define ZCL_MEASURED_1_ST_HARMONIC_CURRENT_ATTRIBUTE_ID (0x0307)
#define ZCL_MEASURED_3_RD_HARMONIC_CURRENT_ATTRIBUTE_ID (0x0308)
#define ZCL_MEASURED_5_TH_HARMONIC_CURRENT_ATTRIBUTE_ID (0x0309)
#define ZCL_MEASURED_7_TH_HARMONIC_CURRENT_ATTRIBUTE_ID (0x030A)
#define ZCL_MEASURED_9_TH_HARMONIC_CURRENT_ATTRIBUTE_ID (0x030B)
#define ZCL_MEASURED_11_TH_HARMONIC_CURRENT_ATTRIBUTE_ID (0x030C)
#define ZCL_MEASURED_PHASE_1_ST_HARMONIC_CURRENT_ATTRIBUTE_ID (0x030D)
#define ZCL_MEASURED_PHASE_3_RD_HARMONIC_CURRENT_ATTRIBUTE_ID (0x030E)
#define ZCL_MEASURED_PHASE_5_TH_HARMONIC_CURRENT_ATTRIBUTE_ID (0x030F)
#define ZCL_MEASURED_PHASE_7_TH_HARMONIC_CURRENT_ATTRIBUTE_ID (0x0310)
#define ZCL_MEASURED_PHASE_9_TH_HARMONIC_CURRENT_ATTRIBUTE_ID (0x0311)
#define ZCL_MEASURED_PHASE_11_TH_HARMONIC_CURRENT_ATTRIBUTE_ID (0x0312)
#define ZCL_AC_FREQUENCY_MULTIPLIER_ATTRIBUTE_ID (0x0400)
#define ZCL_AC_FREQUENCY_DIVISOR_ATTRIBUTE_ID (0x0401)
#define ZCL_POWER_MULTIPLIER_ATTRIBUTE_ID (0x0402)
#define ZCL_POWER_DIVISOR_ATTRIBUTE_ID (0x0403)
#define ZCL_HARMONIC_CURRENT_MULTIPLIER_ATTRIBUTE_ID (0x0404)
#define ZCL_PHASE_HARMONIC_CURRENT_MULTIPLIER_ATTRIBUTE_ID (0x0405)
#define ZCL_INSTANTANEOUS_VOLTAGE_ATTRIBUTE_ID (0x0500)
#define ZCL_INSTANTANEOUS_LINE_CURRENT_ATTRIBUTE_ID (0x0501)
#define ZCL_INSTANTANEOUS_ACTIVE_CURRENT_ATTRIBUTE_ID (0x0502)
#define ZCL_INSTANTANEOUS_REACTIVE_CURRENT_ATTRIBUTE_ID (0x0503)
#define ZCL_INSTANTANEOUS_POWER_ATTRIBUTE_ID (0x0504)
#define ZCL_RMS_VOLTAGE_ATTRIBUTE_ID (0x0505)
#define ZCL_RMS_VOLTAGE_MIN_ATTRIBUTE_ID (0x0506)
#define ZCL_RMS_VOLTAGE_MAX_ATTRIBUTE_ID (0x0507)
#define ZCL_RMS_CURRENT_ATTRIBUTE_ID (0x0508)
#define ZCL_RMS_CURRENT_MIN_ATTRIBUTE_ID (0x0509)
#define ZCL_RMS_CURRENT_MAX_ATTRIBUTE_ID (0x050A)
#define ZCL_ACTIVE_POWER_ATTRIBUTE_ID (0x050B)
#define ZCL_ACTIVE_POWER_MIN_ATTRIBUTE_ID (0x050C)
#define ZCL_ACTIVE_POWER_MAX_ATTRIBUTE_ID (0x050D)
#define ZCL_REACTIVE_POWER_ATTRIBUTE_ID (0x050E)
#define ZCL_APPARENT_POWER_ATTRIBUTE_ID (0x050F)
#define ZCL_AC_POWER_FACTOR_ATTRIBUTE_ID (0x0510)
#define ZCL_AVERAGE_RMS_VOLTAGE_MEASUREMENT_PERIOD_ATTRIBUTE_ID (0x0511)
#define ZCL_AVERAGE_RMS_UNDER_VOLTAGE_COUNTER_ATTRIBUTE_ID (0x0513)
#define ZCL_RMS_EXTREME_OVER_VOLTAGE_PERIOD_ATTRIBUTE_ID (0x0514)
#define ZCL_RMS_EXTREME_UNDER_VOLTAGE_PERIOD_ATTRIBUTE_ID (0x0515)
#define ZCL_RMS_VOLTAGE_SAG_PERIOD_ATTRIBUTE_ID (0x0516)
#define ZCL_RMS_VOLTAGE_SWELL_PERIOD_ATTRIBUTE_ID (0x0517)
#define ZCL_AC_VOLTAGE_MULTIPLIER_ATTRIBUTE_ID (0x0600)
#define ZCL_AC_VOLTAGE_DIVISOR_ATTRIBUTE_ID (0x0601)
#define ZCL_AC_CURRENT_MULTIPLIER_ATTRIBUTE_ID (0x0602)
#define ZCL_AC_CURRENT_DIVISOR_ATTRIBUTE_ID (0x0603)
#define ZCL_AC_POWER_MULTIPLIER_ATTRIBUTE_ID (0x0604)
#define ZCL_AC_POWER_DIVISOR_ATTRIBUTE_ID (0x0605)
#define ZCL_DC_OVERLOAD_ALARMS_MASK_ATTRIBUTE_ID (0x0700)
#define ZCL_DC_VOLTAGE_OVERLOAD_ATTRIBUTE_ID (0x0701)
#define ZCL_DC_CURRENT_OVERLOAD_ATTRIBUTE_ID (0x0702)
#define ZCL_AC_OVERLOAD_ALARMS_MASK_ATTRIBUTE_ID (0x0800)
#define ZCL_AC_VOLTAGE_OVERLOAD_ATTRIBUTE_ID (0x0801)
#define ZCL_AC_CURRENT_OVERLOAD_ATTRIBUTE_ID (0x0802)
#define ZCL_AC_POWER_OVERLOAD_ATTRIBUTE_ID (0x0803)
#define ZCL_AC_REACTIVE_POWER_OVERLOAD_ATTRIBUTE_ID (0x0804)
#define ZCL_AVERAGE_RMS_OVER_VOLTAGE_ATTRIBUTE_ID (0x0805)
#define ZCL_AVERAGE_RMS_UNDER_VOLTAGE_ATTRIBUTE_ID (0x0806)
#define ZCL_RMS_EXTREME_OVER_VOLTAGE_ATTRIBUTE_ID (0x0807)
#define ZCL_RMS_EXTREME_UNDER_VOLTAGE_ATTRIBUTE_ID (0x0808)
#define ZCL_RMS_VOLTAGE_SAG_ATTRIBUTE_ID (0x0809)
#define ZCL_RMS_VOLTAGE_SWELL_ATTRIBUTE_ID (0x080A)
#define ZCL_LINE_CURRENT_PHASE_B_ATTRIBUTE_ID (0x0901)
#define ZCL_ACTIVE_CURRENT_PHASE_B_ATTRIBUTE_ID (0x0902)
#define ZCL_REACTIVE_CURRENT_PHASE_B_ATTRIBUTE_ID (0x0903)
#define ZCL_RMS_VOLTAGE_PHASE_B_ATTRIBUTE_ID (0x0905)
#define ZCL_RMS_VOLTAGE_MIN_PHASE_B_ATTRIBUTE_ID (0x0906)
#define ZCL_RMS_VOLTAGE_MAX_PHASE_B_ATTRIBUTE_ID (0x0907)
#define ZCL_RMS_CURRENT_PHASE_B_ATTRIBUTE_ID (0x0908)
#define ZCL_RMS_CURRENT_MIN_PHASE_B_ATTRIBUTE_ID (0x0909)
#define ZCL_RMS_CURRENT_MAX_PHASE_B_ATTRIBUTE_ID (0x090A)
#define ZCL_ACTIVE_POWER_PHASE_B_ATTRIBUTE_ID (0x090B)
#define ZCL_ACTIVE_POWER_MIN_PHASE_B_ATTRIBUTE_ID (0x090C)
#define ZCL_ACTIVE_POWER_MAX_PHASE_B_ATTRIBUTE_ID (0x090D)
#define ZCL_REACTIVE_POWER_PHASE_B_ATTRIBUTE_ID (0x090E)
#define ZCL_APPARENT_POWER_PHASE_B_ATTRIBUTE_ID (0x090F)
#define ZCL_POWER_FACTOR_PHASE_B_ATTRIBUTE_ID (0x0910)
#define ZCL_AVERAGE_RMS_VOLTAGE_MEASUREMENT_PERIOD_PHASE_B_ATTRIBUTE_ID (0x0911)
#define ZCL_AVERAGE_RMS_OVER_VOLTAGE_COUNTER_PHASE_B_ATTRIBUTE_ID (0x0912)
#define ZCL_AVERAGE_RMS_UNDER_VOLTAGE_COUNTER_PHASE_B_ATTRIBUTE_ID (0x0913)
#define ZCL_RMS_EXTREME_OVER_VOLTAGE_PERIOD_PHASE_B_ATTRIBUTE_ID (0x0914)
#define ZCL_RMS_EXTREME_UNDER_VOLTAGE_PERIOD_PHASE_B_ATTRIBUTE_ID (0x0915)
#define ZCL_RMS_VOLTAGE_SAG_PERIOD_PHASE_B_ATTRIBUTE_ID (0x0916)
#define ZCL_RMS_VOLTAGE_SWELL_PERIOD_PHASE_B_ATTRIBUTE_ID (0x0917)
#define ZCL_LINE_CURRENT_PHASE_C_ATTRIBUTE_ID (0x0A01)
#define ZCL_ACTIVE_CURRENT_PHASE_C_ATTRIBUTE_ID (0x0A02)
#define ZCL_REACTIVE_CURRENT_PHASE_C_ATTRIBUTE_ID (0x0A03)
#define ZCL_RMS_VOLTAGE_PHASE_C_ATTRIBUTE_ID (0x0A05)
#define ZCL_RMS_VOLTAGE_MIN_PHASE_C_ATTRIBUTE_ID (0x0A06)
#define ZCL_RMS_VOLTAGE_MAX_PHASE_C_ATTRIBUTE_ID (0x0A07)
#define ZCL_RMS_CURRENT_PHASE_C_ATTRIBUTE_ID (0x0A08)
#define ZCL_RMS_CURRENT_MIN_PHASE_C_ATTRIBUTE_ID (0x0A09)
#define ZCL_RMS_CURRENT_MAX_PHASE_C_ATTRIBUTE_ID (0x0A0A)
#define ZCL_ACTIVE_POWER_PHASE_C_ATTRIBUTE_ID (0x0A0B)
#define ZCL_ACTIVE_POWER_MIN_PHASE_C_ATTRIBUTE_ID (0x0A0C)
#define ZCL_ACTIVE_POWER_MAX_PHASE_C_ATTRIBUTE_ID (0x0A0D)
#define ZCL_REACTIVE_POWER_PHASE_C_ATTRIBUTE_ID (0x0A0E)
#define ZCL_APPARENT_POWER_PHASE_C_ATTRIBUTE_ID (0x0A0F)
#define ZCL_POWER_FACTOR_PHASE_C_ATTRIBUTE_ID (0x0A10)
#define ZCL_AVERAGE_RMS_VOLTAGE_MEASUREMENT_PERIOD_PHASE_C_ATTRIBUTE_ID (0x0A11)
#define ZCL_AVERAGE_RMS_OVER_VOLTAGE_COUNTER_PHASE_C_ATTRIBUTE_ID (0x0A12)
#define ZCL_AVERAGE_RMS_UNDER_VOLTAGE_COUNTER_PHASE_C_ATTRIBUTE_ID (0x0A13)
#define ZCL_RMS_EXTREME_OVER_VOLTAGE_PERIOD_PHASE_C_ATTRIBUTE_ID (0x0A14)
#define ZCL_RMS_EXTREME_UNDER_VOLTAGE_PERIOD_PHASE_C_ATTRIBUTE_ID (0x0A15)
#define ZCL_RMS_VOLTAGE_SAG_PERIOD_PHASE_C_ATTRIBUTE_ID (0x0A16)
#define ZCL_RMS_VOLTAGE_SWELL_PERIOD_PHASE_C_ATTRIBUTE_ID (0x0A17)

// Attribute ids for cluster: Test Cluster

// Client attributes

// Server attributes
#define ZCL_BOOLEAN_ATTRIBUTE_ID (0x0000)
#define ZCL_BITMAP8_ATTRIBUTE_ID (0x0001)
#define ZCL_BITMAP16_ATTRIBUTE_ID (0x0002)
#define ZCL_BITMAP32_ATTRIBUTE_ID (0x0003)
#define ZCL_BITMAP64_ATTRIBUTE_ID (0x0004)
#define ZCL_INT8_U_ATTRIBUTE_ID (0x0005)
#define ZCL_INT16_U_ATTRIBUTE_ID (0x0006)
#define ZCL_INT24_U_ATTRIBUTE_ID (0x0007)
#define ZCL_INT32_U_ATTRIBUTE_ID (0x0008)
#define ZCL_INT40_U_ATTRIBUTE_ID (0x0009)
#define ZCL_INT48_U_ATTRIBUTE_ID (0x000A)
#define ZCL_INT56_U_ATTRIBUTE_ID (0x000B)
#define ZCL_INT64_U_ATTRIBUTE_ID (0x000C)
#define ZCL_INT8_S_ATTRIBUTE_ID (0x000D)
#define ZCL_INT16_S_ATTRIBUTE_ID (0x000E)
#define ZCL_INT24_S_ATTRIBUTE_ID (0x000F)
#define ZCL_INT32_S_ATTRIBUTE_ID (0x0010)
#define ZCL_INT40_S_ATTRIBUTE_ID (0x0011)
#define ZCL_INT48_S_ATTRIBUTE_ID (0x0012)
#define ZCL_INT56_S_ATTRIBUTE_ID (0x0013)
#define ZCL_INT64_S_ATTRIBUTE_ID (0x0014)
#define ZCL_ENUM8_ATTRIBUTE_ID (0x0015)
#define ZCL_ENUM16_ATTRIBUTE_ID (0x0016)
#define ZCL_FLOAT_SINGLE_ATTRIBUTE_ID (0x0017)
#define ZCL_FLOAT_DOUBLE_ATTRIBUTE_ID (0x0018)
#define ZCL_OCTET_STRING_ATTRIBUTE_ID (0x0019)
#define ZCL_LIST_ATTRIBUTE_ID (0x001A)
#define ZCL_LIST_OCTET_STRING_ATTRIBUTE_ID (0x001B)
#define ZCL_LIST_STRUCT_OCTET_STRING_ATTRIBUTE_ID (0x001C)
#define ZCL_LONG_OCTET_STRING_ATTRIBUTE_ID (0x001D)
#define ZCL_CHAR_STRING_ATTRIBUTE_ID (0x001E)
#define ZCL_LONG_CHAR_STRING_ATTRIBUTE_ID (0x001F)
#define ZCL_EPOCH_US_ATTRIBUTE_ID (0x0020)
#define ZCL_EPOCH_S_ATTRIBUTE_ID (0x0021)
#define ZCL_TEST_VENDOR_ID_ATTRIBUTE_ID (0x0022)
#define ZCL_LIST_OF_STRUCTS_WITH_OPTIONALS_ATTRIBUTE_ID (0x0023)
#define ZCL_SIMPLE_ENUM_ATTRIBUTE_ID (0x0024)
#define ZCL_STRUCT_ATTRIBUTE_ID (0x0025)
#define ZCL_RANGE_RESTRICTED_INT8_U_ATTRIBUTE_ID (0x0026)
#define ZCL_RANGE_RESTRICTED_INT8S_ATTRIBUTE_ID (0x0027)
#define ZCL_RANGE_RESTRICTED_INT16_U_ATTRIBUTE_ID (0x0028)
#define ZCL_RANGE_RESTRICTED_INT16S_ATTRIBUTE_ID (0x0029)
#define ZCL_LIST_LONG_OCTET_STRING_ATTRIBUTE_ID (0x002A)
#define ZCL_LIST_FABRIC_SCOPED_ATTRIBUTE_ID (0x002B)
#define ZCL_TIMED_WRITE_BOOLEAN_ATTRIBUTE_ID (0x0030)
#define ZCL_GENERAL_ERROR_BOOLEAN_ATTRIBUTE_ID (0x0031)
#define ZCL_CLUSTER_ERROR_BOOLEAN_ATTRIBUTE_ID (0x0032)
#define ZCL_UNSUPPORTED_ATTRIBUTE_ID (0x00FF)
#define ZCL_NULLABLE_BOOLEAN_ATTRIBUTE_ID (0x4000)
#define ZCL_NULLABLE_BITMAP8_ATTRIBUTE_ID (0x4001)
#define ZCL_NULLABLE_BITMAP16_ATTRIBUTE_ID (0x4002)
#define ZCL_NULLABLE_BITMAP32_ATTRIBUTE_ID (0x4003)
#define ZCL_NULLABLE_BITMAP64_ATTRIBUTE_ID (0x4004)
#define ZCL_NULLABLE_INT8_U_ATTRIBUTE_ID (0x4005)
#define ZCL_NULLABLE_INT16_U_ATTRIBUTE_ID (0x4006)
#define ZCL_NULLABLE_INT24_U_ATTRIBUTE_ID (0x4007)
#define ZCL_NULLABLE_INT32_U_ATTRIBUTE_ID (0x4008)
#define ZCL_NULLABLE_INT40_U_ATTRIBUTE_ID (0x4009)
#define ZCL_NULLABLE_INT48_U_ATTRIBUTE_ID (0x400A)
#define ZCL_NULLABLE_INT56_U_ATTRIBUTE_ID (0x400B)
#define ZCL_NULLABLE_INT64_U_ATTRIBUTE_ID (0x400C)
#define ZCL_NULLABLE_INT8_S_ATTRIBUTE_ID (0x400D)
#define ZCL_NULLABLE_INT16_S_ATTRIBUTE_ID (0x400E)
#define ZCL_NULLABLE_INT24_S_ATTRIBUTE_ID (0x400F)
#define ZCL_NULLABLE_INT32_S_ATTRIBUTE_ID (0x4010)
#define ZCL_NULLABLE_INT40_S_ATTRIBUTE_ID (0x4011)
#define ZCL_NULLABLE_INT48_S_ATTRIBUTE_ID (0x4012)
#define ZCL_NULLABLE_INT56_S_ATTRIBUTE_ID (0x4013)
#define ZCL_NULLABLE_INT64_S_ATTRIBUTE_ID (0x4014)
#define ZCL_NULLABLE_ENUM8_ATTRIBUTE_ID (0x4015)
#define ZCL_NULLABLE_ENUM16_ATTRIBUTE_ID (0x4016)
#define ZCL_NULLABLE_FLOAT_SINGLE_ATTRIBUTE_ID (0x4017)
#define ZCL_NULLABLE_FLOAT_DOUBLE_ATTRIBUTE_ID (0x4018)
#define ZCL_NULLABLE_OCTET_STRING_ATTRIBUTE_ID (0x4019)
#define ZCL_NULLABLE_CHAR_STRING_ATTRIBUTE_ID (0x401E)
#define ZCL_NULLABLE_SIMPLE_ENUM_ATTRIBUTE_ID (0x4024)
#define ZCL_NULLABLE_STRUCT_ATTRIBUTE_ID (0x4025)
#define ZCL_NULLABLE_RANGE_RESTRICTED_INT8_U_ATTRIBUTE_ID (0x4026)
#define ZCL_NULLABLE_RANGE_RESTRICTED_INT8S_ATTRIBUTE_ID (0x4027)
#define ZCL_NULLABLE_RANGE_RESTRICTED_INT16_U_ATTRIBUTE_ID (0x4028)
#define ZCL_NULLABLE_RANGE_RESTRICTED_INT16_S_ATTRIBUTE_ID (0x4029)
#define ZCL_WRITE_ONLY_INT8_U_ATTRIBUTE_ID (0x402A)

// Attribute ids for cluster: Fault Injection

// Client attributes

// Server attributes
