/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

// Prevent multiple inclusion
#pragma once

#include <app-common/zap-generated/af-structs.h>
#include <app-common/zap-generated/cluster-objects.h>
#include <app/util/af-types.h>
#include <app/util/basic-types.h>

#include <app/CommandHandler.h>
#include <app/CommandSender.h>
#include <app/ConcreteAttributePath.h>
#include <app/ConcreteCommandPath.h>
#include <lib/support/Span.h>
#include <protocols/interaction_model/Constants.h>

/** @brief Cluster Init
 *
 * This function is called when a specific cluster is initialized. It gives the
 * application an opportunity to take care of cluster initialization procedures.
 * It is called exactly once for each endpoint where cluster is present.
 *
 * @param endpoint   Ver.: always
 * @param clusterId   Ver.: always
 */
void emberAfClusterInitCallback(chip::EndpointId endpoint, chip::ClusterId clusterId);

// Cluster Init Functions

/** @brief Identify Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIdentifyClusterInitCallback(chip::EndpointId endpoint);

/** @brief Groups Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupsClusterInitCallback(chip::EndpointId endpoint);

/** @brief Scenes Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfScenesClusterInitCallback(chip::EndpointId endpoint);

/** @brief On/Off Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOnOffClusterInitCallback(chip::EndpointId endpoint);

/** @brief On/off Switch Configuration Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOnOffSwitchConfigurationClusterInitCallback(chip::EndpointId endpoint);

/** @brief Level Control Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLevelControlClusterInitCallback(chip::EndpointId endpoint);

/** @brief Binary Input (Basic) Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBinaryInputBasicClusterInitCallback(chip::EndpointId endpoint);

/** @brief Pulse Width Modulation Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPulseWidthModulationClusterInitCallback(chip::EndpointId endpoint);

/** @brief Descriptor Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDescriptorClusterInitCallback(chip::EndpointId endpoint);

/** @brief Binding Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBindingClusterInitCallback(chip::EndpointId endpoint);

/** @brief Access Control Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccessControlClusterInitCallback(chip::EndpointId endpoint);

/** @brief Actions Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfActionsClusterInitCallback(chip::EndpointId endpoint);

/** @brief Basic Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBasicClusterInitCallback(chip::EndpointId endpoint);

/** @brief OTA Software Update Provider Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateProviderClusterInitCallback(chip::EndpointId endpoint);

/** @brief OTA Software Update Requestor Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateRequestorClusterInitCallback(chip::EndpointId endpoint);

/** @brief Localization Configuration Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLocalizationConfigurationClusterInitCallback(chip::EndpointId endpoint);

/** @brief Time Format Localization Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeFormatLocalizationClusterInitCallback(chip::EndpointId endpoint);

/** @brief Unit Localization Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUnitLocalizationClusterInitCallback(chip::EndpointId endpoint);

/** @brief Power Source Configuration Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceConfigurationClusterInitCallback(chip::EndpointId endpoint);

/** @brief Power Source Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceClusterInitCallback(chip::EndpointId endpoint);

/** @brief General Commissioning Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralCommissioningClusterInitCallback(chip::EndpointId endpoint);

/** @brief Network Commissioning Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfNetworkCommissioningClusterInitCallback(chip::EndpointId endpoint);

/** @brief Diagnostic Logs Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDiagnosticLogsClusterInitCallback(chip::EndpointId endpoint);

/** @brief General Diagnostics Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralDiagnosticsClusterInitCallback(chip::EndpointId endpoint);

/** @brief Software Diagnostics Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSoftwareDiagnosticsClusterInitCallback(chip::EndpointId endpoint);

/** @brief Thread Network Diagnostics Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadNetworkDiagnosticsClusterInitCallback(chip::EndpointId endpoint);

/** @brief WiFi Network Diagnostics Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWiFiNetworkDiagnosticsClusterInitCallback(chip::EndpointId endpoint);

/** @brief Ethernet Network Diagnostics Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEthernetNetworkDiagnosticsClusterInitCallback(chip::EndpointId endpoint);

/** @brief Time Synchronization Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeSynchronizationClusterInitCallback(chip::EndpointId endpoint);

/** @brief Bridged Device Basic Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBridgedDeviceBasicClusterInitCallback(chip::EndpointId endpoint);

/** @brief Switch Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSwitchClusterInitCallback(chip::EndpointId endpoint);

/** @brief AdministratorCommissioning Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAdministratorCommissioningClusterInitCallback(chip::EndpointId endpoint);

/** @brief Operational Credentials Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOperationalCredentialsClusterInitCallback(chip::EndpointId endpoint);

/** @brief Group Key Management Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupKeyManagementClusterInitCallback(chip::EndpointId endpoint);

/** @brief Fixed Label Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFixedLabelClusterInitCallback(chip::EndpointId endpoint);

/** @brief User Label Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUserLabelClusterInitCallback(chip::EndpointId endpoint);

/** @brief Proxy Configuration Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyConfigurationClusterInitCallback(chip::EndpointId endpoint);

/** @brief Proxy Discovery Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyDiscoveryClusterInitCallback(chip::EndpointId endpoint);

/** @brief Proxy Valid Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyValidClusterInitCallback(chip::EndpointId endpoint);

/** @brief Boolean State Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBooleanStateClusterInitCallback(chip::EndpointId endpoint);

/** @brief Mode Select Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfModeSelectClusterInitCallback(chip::EndpointId endpoint);

/** @brief Door Lock Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDoorLockClusterInitCallback(chip::EndpointId endpoint);

/** @brief Window Covering Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWindowCoveringClusterInitCallback(chip::EndpointId endpoint);

/** @brief Barrier Control Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBarrierControlClusterInitCallback(chip::EndpointId endpoint);

/** @brief Pump Configuration and Control Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPumpConfigurationAndControlClusterInitCallback(chip::EndpointId endpoint);

/** @brief Thermostat Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatClusterInitCallback(chip::EndpointId endpoint);

/** @brief Fan Control Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFanControlClusterInitCallback(chip::EndpointId endpoint);

/** @brief Thermostat User Interface Configuration Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatUserInterfaceConfigurationClusterInitCallback(chip::EndpointId endpoint);

/** @brief Color Control Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfColorControlClusterInitCallback(chip::EndpointId endpoint);

/** @brief Ballast Configuration Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBallastConfigurationClusterInitCallback(chip::EndpointId endpoint);

/** @brief Illuminance Measurement Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIlluminanceMeasurementClusterInitCallback(chip::EndpointId endpoint);

/** @brief Temperature Measurement Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTemperatureMeasurementClusterInitCallback(chip::EndpointId endpoint);

/** @brief Pressure Measurement Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPressureMeasurementClusterInitCallback(chip::EndpointId endpoint);

/** @brief Flow Measurement Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFlowMeasurementClusterInitCallback(chip::EndpointId endpoint);

/** @brief Relative Humidity Measurement Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRelativeHumidityMeasurementClusterInitCallback(chip::EndpointId endpoint);

/** @brief Occupancy Sensing Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOccupancySensingClusterInitCallback(chip::EndpointId endpoint);

/** @brief Wake on LAN Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWakeOnLanClusterInitCallback(chip::EndpointId endpoint);

/** @brief Channel Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfChannelClusterInitCallback(chip::EndpointId endpoint);

/** @brief Target Navigator Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTargetNavigatorClusterInitCallback(chip::EndpointId endpoint);

/** @brief Media Playback Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaPlaybackClusterInitCallback(chip::EndpointId endpoint);

/** @brief Media Input Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaInputClusterInitCallback(chip::EndpointId endpoint);

/** @brief Low Power Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLowPowerClusterInitCallback(chip::EndpointId endpoint);

/** @brief Keypad Input Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfKeypadInputClusterInitCallback(chip::EndpointId endpoint);

/** @brief Content Launcher Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentLauncherClusterInitCallback(chip::EndpointId endpoint);

/** @brief Audio Output Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAudioOutputClusterInitCallback(chip::EndpointId endpoint);

/** @brief Application Launcher Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationLauncherClusterInitCallback(chip::EndpointId endpoint);

/** @brief Application Basic Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationBasicClusterInitCallback(chip::EndpointId endpoint);

/** @brief Account Login Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccountLoginClusterInitCallback(chip::EndpointId endpoint);

/** @brief Electrical Measurement Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfElectricalMeasurementClusterInitCallback(chip::EndpointId endpoint);

/** @brief Test Cluster Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTestClusterClusterInitCallback(chip::EndpointId endpoint);

/** @brief Fault Injection Cluster Init
 *
 * Cluster Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFaultInjectionClusterInitCallback(chip::EndpointId endpoint);

// Cluster Server/Client Init Functions

//
// Identify Cluster
//

/** @brief Identify Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIdentifyClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Identify Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIdentifyClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Identify Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterIdentifyClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Identify Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfIdentifyClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                     uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Identify Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfIdentifyClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                     uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Identify Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterIdentifyClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                       EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Identify Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterIdentifyClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                       EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Identify Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfIdentifyClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Identify Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfIdentifyClusterClientTickCallback(chip::EndpointId endpoint);

//
// Groups Cluster
//

/** @brief Groups Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupsClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Groups Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupsClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Groups Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterGroupsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Groups Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfGroupsClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                   uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Groups Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfGroupsClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                   uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Groups Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterGroupsClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                     EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Groups Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterGroupsClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                     EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Groups Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfGroupsClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Groups Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfGroupsClusterClientTickCallback(chip::EndpointId endpoint);

//
// Scenes Cluster
//

/** @brief Scenes Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfScenesClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Scenes Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfScenesClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Scenes Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterScenesClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Scenes Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfScenesClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                   uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Scenes Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfScenesClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                   uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Scenes Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterScenesClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                     EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Scenes Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterScenesClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                     EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Scenes Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfScenesClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Scenes Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfScenesClusterClientTickCallback(chip::EndpointId endpoint);

//
// On/Off Cluster
//

/** @brief On/Off Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOnOffClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief On/Off Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOnOffClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief On/Off Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterOnOffClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief On/Off Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOnOffClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                  uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief On/Off Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOnOffClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                  uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief On/Off Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterOnOffClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                    EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief On/Off Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterOnOffClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                    EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief On/Off Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOnOffClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief On/Off Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOnOffClusterClientTickCallback(chip::EndpointId endpoint);

//
// On/off Switch Configuration Cluster
//

/** @brief On/off Switch Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOnOffSwitchConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief On/off Switch Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOnOffSwitchConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief On/off Switch Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterOnOffSwitchConfigurationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief On/off Switch Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOnOffSwitchConfigurationClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                     EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                     EmberStatus status);

/** @brief On/off Switch Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOnOffSwitchConfigurationClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                     EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                     EmberStatus status);

/** @brief On/off Switch Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOnOffSwitchConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief On/off Switch Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOnOffSwitchConfigurationClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief On/off Switch Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOnOffSwitchConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief On/off Switch Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOnOffSwitchConfigurationClusterClientTickCallback(chip::EndpointId endpoint);

//
// Level Control Cluster
//

/** @brief Level Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLevelControlClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Level Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLevelControlClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Level Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterLevelControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Level Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfLevelControlClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                         uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Level Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfLevelControlClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                         uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Level Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterLevelControlClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Level Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterLevelControlClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Level Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfLevelControlClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Level Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfLevelControlClusterClientTickCallback(chip::EndpointId endpoint);

//
// Binary Input (Basic) Cluster
//

/** @brief Binary Input (Basic) Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBinaryInputBasicClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Binary Input (Basic) Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBinaryInputBasicClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Binary Input (Basic) Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterBinaryInputBasicClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Binary Input (Basic) Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBinaryInputBasicClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                             EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                             EmberStatus status);

/** @brief Binary Input (Basic) Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBinaryInputBasicClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                             EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                             EmberStatus status);

/** @brief Binary Input (Basic) Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBinaryInputBasicClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Binary Input (Basic) Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBinaryInputBasicClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Binary Input (Basic) Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBinaryInputBasicClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Binary Input (Basic) Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBinaryInputBasicClusterClientTickCallback(chip::EndpointId endpoint);

//
// Pulse Width Modulation Cluster
//

/** @brief Pulse Width Modulation Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPulseWidthModulationClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Pulse Width Modulation Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPulseWidthModulationClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Pulse Width Modulation Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterPulseWidthModulationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Pulse Width Modulation Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfPulseWidthModulationClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                 EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                 EmberStatus status);

/** @brief Pulse Width Modulation Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfPulseWidthModulationClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                 EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                 EmberStatus status);

/** @brief Pulse Width Modulation Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPulseWidthModulationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Pulse Width Modulation Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPulseWidthModulationClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Pulse Width Modulation Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfPulseWidthModulationClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Pulse Width Modulation Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfPulseWidthModulationClusterClientTickCallback(chip::EndpointId endpoint);

//
// Descriptor Cluster
//

/** @brief Descriptor Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDescriptorClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Descriptor Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDescriptorClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Descriptor Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterDescriptorClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Descriptor Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfDescriptorClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Descriptor Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfDescriptorClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Descriptor Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterDescriptorClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Descriptor Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterDescriptorClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Descriptor Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfDescriptorClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Descriptor Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfDescriptorClusterClientTickCallback(chip::EndpointId endpoint);

//
// Binding Cluster
//

/** @brief Binding Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBindingClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Binding Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBindingClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Binding Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterBindingClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Binding Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBindingClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                    uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Binding Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBindingClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                    uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Binding Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBindingClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                      EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Binding Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBindingClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                      EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Binding Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBindingClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Binding Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBindingClusterClientTickCallback(chip::EndpointId endpoint);

//
// Access Control Cluster
//

/** @brief Access Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccessControlClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Access Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccessControlClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Access Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterAccessControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Access Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfAccessControlClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                          EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                          EmberStatus status);

/** @brief Access Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfAccessControlClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                          EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                          EmberStatus status);

/** @brief Access Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterAccessControlClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                            EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Access Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterAccessControlClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                            EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Access Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfAccessControlClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Access Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfAccessControlClusterClientTickCallback(chip::EndpointId endpoint);

//
// Actions Cluster
//

/** @brief Actions Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfActionsClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Actions Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfActionsClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Actions Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterActionsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Actions Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfActionsClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                    uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Actions Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfActionsClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                    uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Actions Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterActionsClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                      EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Actions Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterActionsClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                      EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Actions Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfActionsClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Actions Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfActionsClusterClientTickCallback(chip::EndpointId endpoint);

//
// Basic Cluster
//

/** @brief Basic Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBasicClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Basic Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBasicClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Basic Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterBasicClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Basic Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBasicClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                  uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Basic Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBasicClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                  uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Basic Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBasicClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                    EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Basic Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBasicClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                    EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Basic Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBasicClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Basic Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBasicClusterClientTickCallback(chip::EndpointId endpoint);

//
// OTA Software Update Provider Cluster
//

/** @brief OTA Software Update Provider Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateProviderClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief OTA Software Update Provider Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateProviderClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief OTA Software Update Provider Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterOtaSoftwareUpdateProviderClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief OTA Software Update Provider Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOtaSoftwareUpdateProviderClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                      EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                      EmberStatus status);

/** @brief OTA Software Update Provider Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOtaSoftwareUpdateProviderClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                      EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                      EmberStatus status);

/** @brief OTA Software Update Provider Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOtaSoftwareUpdateProviderClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief OTA Software Update Provider Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOtaSoftwareUpdateProviderClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief OTA Software Update Provider Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOtaSoftwareUpdateProviderClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief OTA Software Update Provider Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOtaSoftwareUpdateProviderClusterClientTickCallback(chip::EndpointId endpoint);

//
// OTA Software Update Requestor Cluster
//

/** @brief OTA Software Update Requestor Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateRequestorClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief OTA Software Update Requestor Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOtaSoftwareUpdateRequestorClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief OTA Software Update Requestor Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterOtaSoftwareUpdateRequestorClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief OTA Software Update Requestor Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOtaSoftwareUpdateRequestorClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                       EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                       EmberStatus status);

/** @brief OTA Software Update Requestor Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOtaSoftwareUpdateRequestorClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                       EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                       EmberStatus status);

/** @brief OTA Software Update Requestor Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOtaSoftwareUpdateRequestorClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief OTA Software Update Requestor Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOtaSoftwareUpdateRequestorClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief OTA Software Update Requestor Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOtaSoftwareUpdateRequestorClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief OTA Software Update Requestor Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOtaSoftwareUpdateRequestorClusterClientTickCallback(chip::EndpointId endpoint);

//
// Localization Configuration Cluster
//

/** @brief Localization Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLocalizationConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Localization Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLocalizationConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Localization Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterLocalizationConfigurationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Localization Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfLocalizationConfigurationClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                      EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                      EmberStatus status);

/** @brief Localization Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfLocalizationConfigurationClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                      EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                      EmberStatus status);

/** @brief Localization Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterLocalizationConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Localization Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterLocalizationConfigurationClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Localization Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfLocalizationConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Localization Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfLocalizationConfigurationClusterClientTickCallback(chip::EndpointId endpoint);

//
// Time Format Localization Cluster
//

/** @brief Time Format Localization Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeFormatLocalizationClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Time Format Localization Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeFormatLocalizationClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Time Format Localization Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterTimeFormatLocalizationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Time Format Localization Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfTimeFormatLocalizationClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                   EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                   EmberStatus status);

/** @brief Time Format Localization Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfTimeFormatLocalizationClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                   EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                   EmberStatus status);

/** @brief Time Format Localization Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterTimeFormatLocalizationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Time Format Localization Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterTimeFormatLocalizationClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Time Format Localization Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfTimeFormatLocalizationClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Time Format Localization Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfTimeFormatLocalizationClusterClientTickCallback(chip::EndpointId endpoint);

//
// Unit Localization Cluster
//

/** @brief Unit Localization Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUnitLocalizationClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Unit Localization Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUnitLocalizationClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Unit Localization Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterUnitLocalizationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Unit Localization Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfUnitLocalizationClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                             EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                             EmberStatus status);

/** @brief Unit Localization Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfUnitLocalizationClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                             EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                             EmberStatus status);

/** @brief Unit Localization Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterUnitLocalizationClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Unit Localization Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterUnitLocalizationClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Unit Localization Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfUnitLocalizationClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Unit Localization Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfUnitLocalizationClusterClientTickCallback(chip::EndpointId endpoint);

//
// Power Source Configuration Cluster
//

/** @brief Power Source Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Power Source Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Power Source Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterPowerSourceConfigurationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Power Source Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfPowerSourceConfigurationClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                     EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                     EmberStatus status);

/** @brief Power Source Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfPowerSourceConfigurationClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                     EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                     EmberStatus status);

/** @brief Power Source Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPowerSourceConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Power Source Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPowerSourceConfigurationClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Power Source Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfPowerSourceConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Power Source Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfPowerSourceConfigurationClusterClientTickCallback(chip::EndpointId endpoint);

//
// Power Source Cluster
//

/** @brief Power Source Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Power Source Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPowerSourceClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Power Source Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterPowerSourceClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Power Source Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfPowerSourceClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                        uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Power Source Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfPowerSourceClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                        uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Power Source Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterPowerSourceClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Power Source Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterPowerSourceClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Power Source Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfPowerSourceClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Power Source Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfPowerSourceClusterClientTickCallback(chip::EndpointId endpoint);

//
// General Commissioning Cluster
//

/** @brief General Commissioning Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralCommissioningClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief General Commissioning Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralCommissioningClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief General Commissioning Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterGeneralCommissioningClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief General Commissioning Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfGeneralCommissioningClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                 EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                 EmberStatus status);

/** @brief General Commissioning Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfGeneralCommissioningClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                 EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                 EmberStatus status);

/** @brief General Commissioning Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterGeneralCommissioningClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief General Commissioning Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterGeneralCommissioningClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief General Commissioning Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfGeneralCommissioningClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief General Commissioning Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfGeneralCommissioningClusterClientTickCallback(chip::EndpointId endpoint);

//
// Network Commissioning Cluster
//

/** @brief Network Commissioning Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfNetworkCommissioningClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Network Commissioning Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfNetworkCommissioningClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Network Commissioning Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterNetworkCommissioningClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Network Commissioning Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfNetworkCommissioningClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                 EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                 EmberStatus status);

/** @brief Network Commissioning Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfNetworkCommissioningClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                 EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                 EmberStatus status);

/** @brief Network Commissioning Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterNetworkCommissioningClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Network Commissioning Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterNetworkCommissioningClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Network Commissioning Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfNetworkCommissioningClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Network Commissioning Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfNetworkCommissioningClusterClientTickCallback(chip::EndpointId endpoint);

//
// Diagnostic Logs Cluster
//

/** @brief Diagnostic Logs Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDiagnosticLogsClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Diagnostic Logs Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDiagnosticLogsClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Diagnostic Logs Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterDiagnosticLogsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Diagnostic Logs Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfDiagnosticLogsClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                           EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                           EmberStatus status);

/** @brief Diagnostic Logs Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfDiagnosticLogsClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                           EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                           EmberStatus status);

/** @brief Diagnostic Logs Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterDiagnosticLogsClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Diagnostic Logs Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterDiagnosticLogsClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Diagnostic Logs Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfDiagnosticLogsClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Diagnostic Logs Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfDiagnosticLogsClusterClientTickCallback(chip::EndpointId endpoint);

//
// General Diagnostics Cluster
//

/** @brief General Diagnostics Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralDiagnosticsClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief General Diagnostics Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGeneralDiagnosticsClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief General Diagnostics Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterGeneralDiagnosticsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief General Diagnostics Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfGeneralDiagnosticsClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                               EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                               EmberStatus status);

/** @brief General Diagnostics Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfGeneralDiagnosticsClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                               EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                               EmberStatus status);

/** @brief General Diagnostics Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterGeneralDiagnosticsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief General Diagnostics Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterGeneralDiagnosticsClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief General Diagnostics Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfGeneralDiagnosticsClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief General Diagnostics Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfGeneralDiagnosticsClusterClientTickCallback(chip::EndpointId endpoint);

//
// Software Diagnostics Cluster
//

/** @brief Software Diagnostics Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSoftwareDiagnosticsClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Software Diagnostics Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSoftwareDiagnosticsClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Software Diagnostics Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterSoftwareDiagnosticsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Software Diagnostics Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfSoftwareDiagnosticsClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                EmberStatus status);

/** @brief Software Diagnostics Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfSoftwareDiagnosticsClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                EmberStatus status);

/** @brief Software Diagnostics Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterSoftwareDiagnosticsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Software Diagnostics Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterSoftwareDiagnosticsClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Software Diagnostics Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfSoftwareDiagnosticsClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Software Diagnostics Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfSoftwareDiagnosticsClusterClientTickCallback(chip::EndpointId endpoint);

//
// Thread Network Diagnostics Cluster
//

/** @brief Thread Network Diagnostics Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadNetworkDiagnosticsClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Thread Network Diagnostics Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThreadNetworkDiagnosticsClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Thread Network Diagnostics Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterThreadNetworkDiagnosticsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Thread Network Diagnostics Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfThreadNetworkDiagnosticsClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                     EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                     EmberStatus status);

/** @brief Thread Network Diagnostics Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfThreadNetworkDiagnosticsClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                     EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                     EmberStatus status);

/** @brief Thread Network Diagnostics Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterThreadNetworkDiagnosticsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Thread Network Diagnostics Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterThreadNetworkDiagnosticsClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Thread Network Diagnostics Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfThreadNetworkDiagnosticsClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Thread Network Diagnostics Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfThreadNetworkDiagnosticsClusterClientTickCallback(chip::EndpointId endpoint);

//
// WiFi Network Diagnostics Cluster
//

/** @brief WiFi Network Diagnostics Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWiFiNetworkDiagnosticsClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief WiFi Network Diagnostics Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWiFiNetworkDiagnosticsClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief WiFi Network Diagnostics Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterWiFiNetworkDiagnosticsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief WiFi Network Diagnostics Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfWiFiNetworkDiagnosticsClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                   EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                   EmberStatus status);

/** @brief WiFi Network Diagnostics Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfWiFiNetworkDiagnosticsClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                   EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                   EmberStatus status);

/** @brief WiFi Network Diagnostics Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterWiFiNetworkDiagnosticsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief WiFi Network Diagnostics Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterWiFiNetworkDiagnosticsClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief WiFi Network Diagnostics Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfWiFiNetworkDiagnosticsClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief WiFi Network Diagnostics Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfWiFiNetworkDiagnosticsClusterClientTickCallback(chip::EndpointId endpoint);

//
// Ethernet Network Diagnostics Cluster
//

/** @brief Ethernet Network Diagnostics Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEthernetNetworkDiagnosticsClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Ethernet Network Diagnostics Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfEthernetNetworkDiagnosticsClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Ethernet Network Diagnostics Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterEthernetNetworkDiagnosticsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Ethernet Network Diagnostics Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfEthernetNetworkDiagnosticsClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                       EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                       EmberStatus status);

/** @brief Ethernet Network Diagnostics Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfEthernetNetworkDiagnosticsClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                       EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                       EmberStatus status);

/** @brief Ethernet Network Diagnostics Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterEthernetNetworkDiagnosticsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Ethernet Network Diagnostics Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterEthernetNetworkDiagnosticsClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Ethernet Network Diagnostics Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfEthernetNetworkDiagnosticsClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Ethernet Network Diagnostics Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfEthernetNetworkDiagnosticsClusterClientTickCallback(chip::EndpointId endpoint);

//
// Time Synchronization Cluster
//

/** @brief Time Synchronization Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeSynchronizationClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Time Synchronization Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTimeSynchronizationClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Time Synchronization Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterTimeSynchronizationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Time Synchronization Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfTimeSynchronizationClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                EmberStatus status);

/** @brief Time Synchronization Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfTimeSynchronizationClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                EmberStatus status);

/** @brief Time Synchronization Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterTimeSynchronizationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Time Synchronization Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterTimeSynchronizationClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Time Synchronization Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfTimeSynchronizationClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Time Synchronization Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfTimeSynchronizationClusterClientTickCallback(chip::EndpointId endpoint);

//
// Bridged Device Basic Cluster
//

/** @brief Bridged Device Basic Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBridgedDeviceBasicClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Bridged Device Basic Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBridgedDeviceBasicClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Bridged Device Basic Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterBridgedDeviceBasicClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Bridged Device Basic Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBridgedDeviceBasicClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                               EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                               EmberStatus status);

/** @brief Bridged Device Basic Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBridgedDeviceBasicClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                               EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                               EmberStatus status);

/** @brief Bridged Device Basic Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterBridgedDeviceBasicClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Bridged Device Basic Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterBridgedDeviceBasicClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Bridged Device Basic Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBridgedDeviceBasicClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Bridged Device Basic Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBridgedDeviceBasicClusterClientTickCallback(chip::EndpointId endpoint);

//
// Switch Cluster
//

/** @brief Switch Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSwitchClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Switch Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfSwitchClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Switch Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterSwitchClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Switch Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfSwitchClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                   uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Switch Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfSwitchClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                   uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Switch Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterSwitchClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                     EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Switch Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterSwitchClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                     EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Switch Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfSwitchClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Switch Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfSwitchClusterClientTickCallback(chip::EndpointId endpoint);

//
// AdministratorCommissioning Cluster
//

/** @brief AdministratorCommissioning Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAdministratorCommissioningClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief AdministratorCommissioning Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAdministratorCommissioningClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief AdministratorCommissioning Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterAdministratorCommissioningClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief AdministratorCommissioning Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfAdministratorCommissioningClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                       EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                       EmberStatus status);

/** @brief AdministratorCommissioning Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfAdministratorCommissioningClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                       EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                       EmberStatus status);

/** @brief AdministratorCommissioning Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterAdministratorCommissioningClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief AdministratorCommissioning Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterAdministratorCommissioningClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief AdministratorCommissioning Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfAdministratorCommissioningClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief AdministratorCommissioning Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfAdministratorCommissioningClusterClientTickCallback(chip::EndpointId endpoint);

//
// Operational Credentials Cluster
//

/** @brief Operational Credentials Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOperationalCredentialsClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Operational Credentials Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOperationalCredentialsClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Operational Credentials Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterOperationalCredentialsClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Operational Credentials Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOperationalCredentialsClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                   EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                   EmberStatus status);

/** @brief Operational Credentials Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOperationalCredentialsClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                   EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                   EmberStatus status);

/** @brief Operational Credentials Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOperationalCredentialsClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Operational Credentials Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterOperationalCredentialsClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Operational Credentials Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOperationalCredentialsClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Operational Credentials Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOperationalCredentialsClusterClientTickCallback(chip::EndpointId endpoint);

//
// Group Key Management Cluster
//

/** @brief Group Key Management Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupKeyManagementClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Group Key Management Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfGroupKeyManagementClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Group Key Management Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterGroupKeyManagementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Group Key Management Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfGroupKeyManagementClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                               EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                               EmberStatus status);

/** @brief Group Key Management Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfGroupKeyManagementClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                               EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                               EmberStatus status);

/** @brief Group Key Management Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterGroupKeyManagementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Group Key Management Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterGroupKeyManagementClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Group Key Management Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfGroupKeyManagementClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Group Key Management Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfGroupKeyManagementClusterClientTickCallback(chip::EndpointId endpoint);

//
// Fixed Label Cluster
//

/** @brief Fixed Label Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFixedLabelClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Fixed Label Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFixedLabelClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Fixed Label Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterFixedLabelClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Fixed Label Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfFixedLabelClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Fixed Label Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfFixedLabelClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Fixed Label Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFixedLabelClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Fixed Label Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFixedLabelClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Fixed Label Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfFixedLabelClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Fixed Label Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfFixedLabelClusterClientTickCallback(chip::EndpointId endpoint);

//
// User Label Cluster
//

/** @brief User Label Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUserLabelClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief User Label Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfUserLabelClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief User Label Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterUserLabelClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief User Label Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfUserLabelClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                      uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief User Label Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfUserLabelClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                      uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief User Label Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterUserLabelClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                        EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief User Label Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterUserLabelClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                        EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief User Label Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfUserLabelClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief User Label Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfUserLabelClusterClientTickCallback(chip::EndpointId endpoint);

//
// Proxy Configuration Cluster
//

/** @brief Proxy Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Proxy Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Proxy Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterProxyConfigurationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Proxy Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfProxyConfigurationClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                               EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                               EmberStatus status);

/** @brief Proxy Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfProxyConfigurationClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                               EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                               EmberStatus status);

/** @brief Proxy Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterProxyConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Proxy Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterProxyConfigurationClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Proxy Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfProxyConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Proxy Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfProxyConfigurationClusterClientTickCallback(chip::EndpointId endpoint);

//
// Proxy Discovery Cluster
//

/** @brief Proxy Discovery Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyDiscoveryClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Proxy Discovery Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyDiscoveryClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Proxy Discovery Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterProxyDiscoveryClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Proxy Discovery Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfProxyDiscoveryClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                           EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                           EmberStatus status);

/** @brief Proxy Discovery Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfProxyDiscoveryClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                           EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                           EmberStatus status);

/** @brief Proxy Discovery Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterProxyDiscoveryClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Proxy Discovery Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterProxyDiscoveryClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Proxy Discovery Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfProxyDiscoveryClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Proxy Discovery Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfProxyDiscoveryClusterClientTickCallback(chip::EndpointId endpoint);

//
// Proxy Valid Cluster
//

/** @brief Proxy Valid Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyValidClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Proxy Valid Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfProxyValidClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Proxy Valid Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterProxyValidClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Proxy Valid Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfProxyValidClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Proxy Valid Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfProxyValidClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Proxy Valid Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterProxyValidClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Proxy Valid Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterProxyValidClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Proxy Valid Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfProxyValidClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Proxy Valid Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfProxyValidClusterClientTickCallback(chip::EndpointId endpoint);

//
// Boolean State Cluster
//

/** @brief Boolean State Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBooleanStateClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Boolean State Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBooleanStateClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Boolean State Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterBooleanStateClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Boolean State Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBooleanStateClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                         uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Boolean State Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBooleanStateClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                         uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Boolean State Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBooleanStateClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Boolean State Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBooleanStateClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Boolean State Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBooleanStateClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Boolean State Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBooleanStateClusterClientTickCallback(chip::EndpointId endpoint);

//
// Mode Select Cluster
//

/** @brief Mode Select Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfModeSelectClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Mode Select Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfModeSelectClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Mode Select Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterModeSelectClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Mode Select Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfModeSelectClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Mode Select Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfModeSelectClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Mode Select Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterModeSelectClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Mode Select Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterModeSelectClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Mode Select Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfModeSelectClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Mode Select Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfModeSelectClusterClientTickCallback(chip::EndpointId endpoint);

//
// Door Lock Cluster
//

/** @brief Door Lock Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDoorLockClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Door Lock Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfDoorLockClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Door Lock Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterDoorLockClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Door Lock Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfDoorLockClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                     uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Door Lock Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfDoorLockClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                     uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Door Lock Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterDoorLockClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                       EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Door Lock Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterDoorLockClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                       EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Door Lock Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfDoorLockClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Door Lock Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfDoorLockClusterClientTickCallback(chip::EndpointId endpoint);

//
// Window Covering Cluster
//

/** @brief Window Covering Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWindowCoveringClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Window Covering Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWindowCoveringClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Window Covering Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterWindowCoveringClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Window Covering Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfWindowCoveringClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                           EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                           EmberStatus status);

/** @brief Window Covering Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfWindowCoveringClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                           EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                           EmberStatus status);

/** @brief Window Covering Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterWindowCoveringClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Window Covering Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterWindowCoveringClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Window Covering Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfWindowCoveringClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Window Covering Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfWindowCoveringClusterClientTickCallback(chip::EndpointId endpoint);

//
// Barrier Control Cluster
//

/** @brief Barrier Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBarrierControlClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Barrier Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBarrierControlClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Barrier Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterBarrierControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Barrier Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBarrierControlClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                           EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                           EmberStatus status);

/** @brief Barrier Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBarrierControlClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                           EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                           EmberStatus status);

/** @brief Barrier Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBarrierControlClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Barrier Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterBarrierControlClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Barrier Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBarrierControlClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Barrier Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBarrierControlClusterClientTickCallback(chip::EndpointId endpoint);

//
// Pump Configuration and Control Cluster
//

/** @brief Pump Configuration and Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPumpConfigurationAndControlClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Pump Configuration and Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPumpConfigurationAndControlClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Pump Configuration and Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterPumpConfigurationAndControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Pump Configuration and Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfPumpConfigurationAndControlClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                        EmberApsFrame * apsFrame, uint16_t msgLen,
                                                                        uint8_t * message, EmberStatus status);

/** @brief Pump Configuration and Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfPumpConfigurationAndControlClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                        EmberApsFrame * apsFrame, uint16_t msgLen,
                                                                        uint8_t * message, EmberStatus status);

/** @brief Pump Configuration and Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPumpConfigurationAndControlClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Pump Configuration and Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPumpConfigurationAndControlClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Pump Configuration and Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfPumpConfigurationAndControlClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Pump Configuration and Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfPumpConfigurationAndControlClusterClientTickCallback(chip::EndpointId endpoint);

//
// Thermostat Cluster
//

/** @brief Thermostat Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Thermostat Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Thermostat Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterThermostatClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Thermostat Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfThermostatClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Thermostat Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfThermostatClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Thermostat Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterThermostatClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Thermostat Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterThermostatClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Thermostat Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfThermostatClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Thermostat Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfThermostatClusterClientTickCallback(chip::EndpointId endpoint);

//
// Fan Control Cluster
//

/** @brief Fan Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFanControlClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Fan Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFanControlClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Fan Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterFanControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Fan Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfFanControlClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Fan Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfFanControlClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Fan Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFanControlClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Fan Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFanControlClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Fan Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfFanControlClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Fan Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfFanControlClusterClientTickCallback(chip::EndpointId endpoint);

//
// Thermostat User Interface Configuration Cluster
//

/** @brief Thermostat User Interface Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatUserInterfaceConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Thermostat User Interface Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfThermostatUserInterfaceConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Thermostat User Interface Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterThermostatUserInterfaceConfigurationClusterServerAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath);

/** @brief Thermostat User Interface Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfThermostatUserInterfaceConfigurationClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                                 EmberApsFrame * apsFrame, uint16_t msgLen,
                                                                                 uint8_t * message, EmberStatus status);

/** @brief Thermostat User Interface Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfThermostatUserInterfaceConfigurationClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                                 EmberApsFrame * apsFrame, uint16_t msgLen,
                                                                                 uint8_t * message, EmberStatus status);

/** @brief Thermostat User Interface Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterThermostatUserInterfaceConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Thermostat User Interface Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterThermostatUserInterfaceConfigurationClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Thermostat User Interface Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfThermostatUserInterfaceConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Thermostat User Interface Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfThermostatUserInterfaceConfigurationClusterClientTickCallback(chip::EndpointId endpoint);

//
// Color Control Cluster
//

/** @brief Color Control Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfColorControlClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Color Control Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfColorControlClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Color Control Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterColorControlClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Color Control Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfColorControlClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                         uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Color Control Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfColorControlClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                         uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Color Control Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterColorControlClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Color Control Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterColorControlClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Color Control Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfColorControlClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Color Control Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfColorControlClusterClientTickCallback(chip::EndpointId endpoint);

//
// Ballast Configuration Cluster
//

/** @brief Ballast Configuration Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBallastConfigurationClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Ballast Configuration Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfBallastConfigurationClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Ballast Configuration Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterBallastConfigurationClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Ballast Configuration Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBallastConfigurationClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                 EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                 EmberStatus status);

/** @brief Ballast Configuration Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfBallastConfigurationClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                 EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                 EmberStatus status);

/** @brief Ballast Configuration Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterBallastConfigurationClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Ballast Configuration Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterBallastConfigurationClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Ballast Configuration Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBallastConfigurationClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Ballast Configuration Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfBallastConfigurationClusterClientTickCallback(chip::EndpointId endpoint);

//
// Illuminance Measurement Cluster
//

/** @brief Illuminance Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIlluminanceMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Illuminance Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfIlluminanceMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Illuminance Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterIlluminanceMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Illuminance Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfIlluminanceMeasurementClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                   EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                   EmberStatus status);

/** @brief Illuminance Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfIlluminanceMeasurementClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                   EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                   EmberStatus status);

/** @brief Illuminance Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterIlluminanceMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Illuminance Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterIlluminanceMeasurementClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Illuminance Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfIlluminanceMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Illuminance Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfIlluminanceMeasurementClusterClientTickCallback(chip::EndpointId endpoint);

//
// Temperature Measurement Cluster
//

/** @brief Temperature Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTemperatureMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Temperature Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTemperatureMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Temperature Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterTemperatureMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Temperature Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfTemperatureMeasurementClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                   EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                   EmberStatus status);

/** @brief Temperature Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfTemperatureMeasurementClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                   EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                   EmberStatus status);

/** @brief Temperature Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterTemperatureMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Temperature Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterTemperatureMeasurementClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Temperature Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfTemperatureMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Temperature Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfTemperatureMeasurementClusterClientTickCallback(chip::EndpointId endpoint);

//
// Pressure Measurement Cluster
//

/** @brief Pressure Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPressureMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Pressure Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfPressureMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Pressure Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterPressureMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Pressure Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfPressureMeasurementClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                EmberStatus status);

/** @brief Pressure Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfPressureMeasurementClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                EmberStatus status);

/** @brief Pressure Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPressureMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Pressure Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterPressureMeasurementClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Pressure Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfPressureMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Pressure Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfPressureMeasurementClusterClientTickCallback(chip::EndpointId endpoint);

//
// Flow Measurement Cluster
//

/** @brief Flow Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFlowMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Flow Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFlowMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Flow Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterFlowMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Flow Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfFlowMeasurementClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                            EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                            EmberStatus status);

/** @brief Flow Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfFlowMeasurementClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                            EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                            EmberStatus status);

/** @brief Flow Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFlowMeasurementClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                              EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Flow Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFlowMeasurementClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                              EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Flow Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfFlowMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Flow Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfFlowMeasurementClusterClientTickCallback(chip::EndpointId endpoint);

//
// Relative Humidity Measurement Cluster
//

/** @brief Relative Humidity Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRelativeHumidityMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Relative Humidity Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfRelativeHumidityMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Relative Humidity Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterRelativeHumidityMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Relative Humidity Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfRelativeHumidityMeasurementClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                        EmberApsFrame * apsFrame, uint16_t msgLen,
                                                                        uint8_t * message, EmberStatus status);

/** @brief Relative Humidity Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfRelativeHumidityMeasurementClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                        EmberApsFrame * apsFrame, uint16_t msgLen,
                                                                        uint8_t * message, EmberStatus status);

/** @brief Relative Humidity Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterRelativeHumidityMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Relative Humidity Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterRelativeHumidityMeasurementClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Relative Humidity Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfRelativeHumidityMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Relative Humidity Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfRelativeHumidityMeasurementClusterClientTickCallback(chip::EndpointId endpoint);

//
// Occupancy Sensing Cluster
//

/** @brief Occupancy Sensing Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOccupancySensingClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Occupancy Sensing Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfOccupancySensingClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Occupancy Sensing Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterOccupancySensingClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Occupancy Sensing Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOccupancySensingClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                             EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                             EmberStatus status);

/** @brief Occupancy Sensing Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfOccupancySensingClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                             EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                             EmberStatus status);

/** @brief Occupancy Sensing Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterOccupancySensingClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Occupancy Sensing Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterOccupancySensingClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Occupancy Sensing Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOccupancySensingClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Occupancy Sensing Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfOccupancySensingClusterClientTickCallback(chip::EndpointId endpoint);

//
// Wake on LAN Cluster
//

/** @brief Wake on LAN Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWakeOnLanClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Wake on LAN Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfWakeOnLanClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Wake on LAN Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterWakeOnLanClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Wake on LAN Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfWakeOnLanClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                      uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Wake on LAN Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfWakeOnLanClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                      uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Wake on LAN Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterWakeOnLanClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                        EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Wake on LAN Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterWakeOnLanClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                        EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Wake on LAN Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfWakeOnLanClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Wake on LAN Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfWakeOnLanClusterClientTickCallback(chip::EndpointId endpoint);

//
// Channel Cluster
//

/** @brief Channel Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfChannelClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Channel Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfChannelClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Channel Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterChannelClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Channel Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfChannelClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                    uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Channel Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfChannelClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                    uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Channel Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterChannelClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                      EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Channel Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterChannelClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                      EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Channel Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfChannelClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Channel Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfChannelClusterClientTickCallback(chip::EndpointId endpoint);

//
// Target Navigator Cluster
//

/** @brief Target Navigator Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTargetNavigatorClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Target Navigator Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTargetNavigatorClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Target Navigator Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterTargetNavigatorClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Target Navigator Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfTargetNavigatorClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                            EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                            EmberStatus status);

/** @brief Target Navigator Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfTargetNavigatorClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                            EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                            EmberStatus status);

/** @brief Target Navigator Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterTargetNavigatorClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                              EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Target Navigator Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterTargetNavigatorClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                              EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Target Navigator Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfTargetNavigatorClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Target Navigator Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfTargetNavigatorClusterClientTickCallback(chip::EndpointId endpoint);

//
// Media Playback Cluster
//

/** @brief Media Playback Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaPlaybackClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Media Playback Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaPlaybackClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Media Playback Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterMediaPlaybackClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Media Playback Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfMediaPlaybackClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                          EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                          EmberStatus status);

/** @brief Media Playback Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfMediaPlaybackClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                          EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                          EmberStatus status);

/** @brief Media Playback Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterMediaPlaybackClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                            EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Media Playback Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterMediaPlaybackClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                            EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Media Playback Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfMediaPlaybackClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Media Playback Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfMediaPlaybackClusterClientTickCallback(chip::EndpointId endpoint);

//
// Media Input Cluster
//

/** @brief Media Input Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaInputClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Media Input Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfMediaInputClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Media Input Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterMediaInputClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Media Input Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfMediaInputClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Media Input Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfMediaInputClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                       uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Media Input Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterMediaInputClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Media Input Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterMediaInputClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                         EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Media Input Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfMediaInputClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Media Input Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfMediaInputClusterClientTickCallback(chip::EndpointId endpoint);

//
// Low Power Cluster
//

/** @brief Low Power Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLowPowerClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Low Power Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfLowPowerClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Low Power Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterLowPowerClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Low Power Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfLowPowerClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                     uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Low Power Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfLowPowerClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                     uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Low Power Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterLowPowerClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                       EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Low Power Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterLowPowerClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                       EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Low Power Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfLowPowerClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Low Power Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfLowPowerClusterClientTickCallback(chip::EndpointId endpoint);

//
// Keypad Input Cluster
//

/** @brief Keypad Input Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfKeypadInputClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Keypad Input Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfKeypadInputClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Keypad Input Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterKeypadInputClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Keypad Input Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfKeypadInputClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                        uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Keypad Input Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfKeypadInputClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                        uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Keypad Input Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterKeypadInputClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Keypad Input Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterKeypadInputClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Keypad Input Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfKeypadInputClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Keypad Input Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfKeypadInputClusterClientTickCallback(chip::EndpointId endpoint);

//
// Content Launcher Cluster
//

/** @brief Content Launcher Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentLauncherClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Content Launcher Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfContentLauncherClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Content Launcher Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterContentLauncherClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Content Launcher Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfContentLauncherClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                            EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                            EmberStatus status);

/** @brief Content Launcher Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfContentLauncherClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                            EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                            EmberStatus status);

/** @brief Content Launcher Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterContentLauncherClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                              EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Content Launcher Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterContentLauncherClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                              EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Content Launcher Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfContentLauncherClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Content Launcher Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfContentLauncherClusterClientTickCallback(chip::EndpointId endpoint);

//
// Audio Output Cluster
//

/** @brief Audio Output Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAudioOutputClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Audio Output Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAudioOutputClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Audio Output Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterAudioOutputClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Audio Output Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfAudioOutputClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                        uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Audio Output Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfAudioOutputClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                        uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Audio Output Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterAudioOutputClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Audio Output Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterAudioOutputClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Audio Output Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfAudioOutputClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Audio Output Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfAudioOutputClusterClientTickCallback(chip::EndpointId endpoint);

//
// Application Launcher Cluster
//

/** @brief Application Launcher Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationLauncherClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Application Launcher Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationLauncherClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Application Launcher Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterApplicationLauncherClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Application Launcher Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfApplicationLauncherClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                EmberStatus status);

/** @brief Application Launcher Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfApplicationLauncherClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                EmberStatus status);

/** @brief Application Launcher Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterApplicationLauncherClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Application Launcher Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterApplicationLauncherClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Application Launcher Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfApplicationLauncherClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Application Launcher Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfApplicationLauncherClusterClientTickCallback(chip::EndpointId endpoint);

//
// Application Basic Cluster
//

/** @brief Application Basic Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationBasicClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Application Basic Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfApplicationBasicClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Application Basic Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterApplicationBasicClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Application Basic Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfApplicationBasicClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                             EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                             EmberStatus status);

/** @brief Application Basic Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfApplicationBasicClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                             EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                             EmberStatus status);

/** @brief Application Basic Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterApplicationBasicClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Application Basic Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterApplicationBasicClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                               EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Application Basic Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfApplicationBasicClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Application Basic Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfApplicationBasicClusterClientTickCallback(chip::EndpointId endpoint);

//
// Account Login Cluster
//

/** @brief Account Login Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccountLoginClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Account Login Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfAccountLoginClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Account Login Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterAccountLoginClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Account Login Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfAccountLoginClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                         uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Account Login Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfAccountLoginClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                         uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Account Login Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterAccountLoginClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Account Login Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterAccountLoginClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                           EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Account Login Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfAccountLoginClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Account Login Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfAccountLoginClusterClientTickCallback(chip::EndpointId endpoint);

//
// Electrical Measurement Cluster
//

/** @brief Electrical Measurement Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfElectricalMeasurementClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Electrical Measurement Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfElectricalMeasurementClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Electrical Measurement Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterElectricalMeasurementClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Electrical Measurement Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfElectricalMeasurementClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                  EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                  EmberStatus status);

/** @brief Electrical Measurement Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfElectricalMeasurementClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                                  EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                                  EmberStatus status);

/** @brief Electrical Measurement Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterElectricalMeasurementClusterServerPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Electrical Measurement Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status MatterElectricalMeasurementClusterClientPreAttributeChangedCallback(
    const chip::app::ConcreteAttributePath & attributePath, EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Electrical Measurement Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfElectricalMeasurementClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Electrical Measurement Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfElectricalMeasurementClusterClientTickCallback(chip::EndpointId endpoint);

//
// Test Cluster Cluster
//

/** @brief Test Cluster Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTestClusterClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Test Cluster Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfTestClusterClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Test Cluster Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterTestClusterClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Test Cluster Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfTestClusterClusterServerMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                        uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Test Cluster Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfTestClusterClusterClientMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame,
                                                        uint16_t msgLen, uint8_t * message, EmberStatus status);

/** @brief Test Cluster Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterTestClusterClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Test Cluster Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterTestClusterClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                          EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Test Cluster Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfTestClusterClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Test Cluster Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfTestClusterClusterClientTickCallback(chip::EndpointId endpoint);

//
// Fault Injection Cluster
//

/** @brief Fault Injection Cluster Server Init
 *
 * Server Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFaultInjectionClusterServerInitCallback(chip::EndpointId endpoint);

/** @brief Fault Injection Cluster Client Init
 *
 * Client Init
 *
 * @param endpoint    Endpoint that is being initialized
 */
void emberAfFaultInjectionClusterClientInitCallback(chip::EndpointId endpoint);

/** @brief Fault Injection Cluster Server Attribute Changed
 *
 * Server Attribute Changed
 *
 * @param attributePath Concrete attribute path that changed
 */
void MatterFaultInjectionClusterServerAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath);

/** @brief Fault Injection Cluster Server Message Sent
 *
 * Server Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfFaultInjectionClusterServerMessageSentCallback(const chip::MessageSendDestination & destination,
                                                           EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                           EmberStatus status);

/** @brief Fault Injection Cluster Client Message Sent
 *
 * Client Message Sent
 *
 * @param destination        The destination to which the message was sent
 * @param apsFrame           The APS frame for the message
 * @param msgLen             The length of the message
 * @param message            The message that was sent
 * @param status             The status of the sent message
 */
void emberAfFaultInjectionClusterClientMessageSentCallback(const chip::MessageSendDestination & destination,
                                                           EmberApsFrame * apsFrame, uint16_t msgLen, uint8_t * message,
                                                           EmberStatus status);

/** @brief Fault Injection Cluster Server Pre Attribute Changed
 *
 * Server Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFaultInjectionClusterServerPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Fault Injection Cluster Client Pre Attribute Changed
 *
 * Client Pre Attribute Changed
 *
 * @param attributePath Concrete attribute path to be changed
 * @param attributeType Attribute type
 * @param size          Attribute size
 * @param value         Attribute value
 */
chip::Protocols::InteractionModel::Status
MatterFaultInjectionClusterClientPreAttributeChangedCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                             EmberAfAttributeType attributeType, uint16_t size, uint8_t * value);

/** @brief Fault Injection Cluster Server Tick
 *
 * Server Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfFaultInjectionClusterServerTickCallback(chip::EndpointId endpoint);

/** @brief Fault Injection Cluster Client Tick
 *
 * Client Tick
 *
 * @param endpoint  Endpoint that is being served
 */
void emberAfFaultInjectionClusterClientTickCallback(chip::EndpointId endpoint);

// Cluster Commands Callback

/**
 * @brief Identify Cluster Identify Command callback (from client)
 */
bool emberAfIdentifyClusterIdentifyCallback(chip::app::CommandHandler * commandObj,
                                            const chip::app::ConcreteCommandPath & commandPath,
                                            const chip::app::Clusters::Identify::Commands::Identify::DecodableType & commandData);
/**
 * @brief Identify Cluster TriggerEffect Command callback (from client)
 */
bool emberAfIdentifyClusterTriggerEffectCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Identify::Commands::TriggerEffect::DecodableType & commandData);
/**
 * @brief Groups Cluster AddGroup Command callback (from client)
 */
bool emberAfGroupsClusterAddGroupCallback(chip::app::CommandHandler * commandObj,
                                          const chip::app::ConcreteCommandPath & commandPath,
                                          const chip::app::Clusters::Groups::Commands::AddGroup::DecodableType & commandData);
/**
 * @brief Groups Cluster AddGroupResponse Command callback (from server)
 */
bool emberAfGroupsClusterAddGroupResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj, uint8_t status,
                                                  chip::GroupId groupId);
/**
 * @brief Groups Cluster ViewGroup Command callback (from client)
 */
bool emberAfGroupsClusterViewGroupCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::Groups::Commands::ViewGroup::DecodableType & commandData);
/**
 * @brief Groups Cluster ViewGroupResponse Command callback (from server)
 */
bool emberAfGroupsClusterViewGroupResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj, uint8_t status,
                                                   chip::GroupId groupId, chip::CharSpan groupName);
/**
 * @brief Groups Cluster GetGroupMembership Command callback (from client)
 */
bool emberAfGroupsClusterGetGroupMembershipCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Groups::Commands::GetGroupMembership::DecodableType & commandData);
/**
 * @brief Groups Cluster GetGroupMembershipResponse Command callback (from server)
 */
bool emberAfGroupsClusterGetGroupMembershipResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                            uint8_t capacity,
                                                            /* TYPE WARNING: array array defaults to */ uint8_t * groupList);
/**
 * @brief Groups Cluster RemoveGroup Command callback (from client)
 */
bool emberAfGroupsClusterRemoveGroupCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::Groups::Commands::RemoveGroup::DecodableType & commandData);
/**
 * @brief Groups Cluster RemoveGroupResponse Command callback (from server)
 */
bool emberAfGroupsClusterRemoveGroupResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                     uint8_t status, chip::GroupId groupId);
/**
 * @brief Groups Cluster RemoveAllGroups Command callback (from client)
 */
bool emberAfGroupsClusterRemoveAllGroupsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Groups::Commands::RemoveAllGroups::DecodableType & commandData);
/**
 * @brief Groups Cluster AddGroupIfIdentifying Command callback (from client)
 */
bool emberAfGroupsClusterAddGroupIfIdentifyingCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Groups::Commands::AddGroupIfIdentifying::DecodableType & commandData);
/**
 * @brief Scenes Cluster AddScene Command callback (from client)
 */
bool emberAfScenesClusterAddSceneCallback(chip::app::CommandHandler * commandObj,
                                          const chip::app::ConcreteCommandPath & commandPath,
                                          const chip::app::Clusters::Scenes::Commands::AddScene::DecodableType & commandData);
/**
 * @brief Scenes Cluster AddSceneResponse Command callback (from server)
 */
bool emberAfScenesClusterAddSceneResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj, uint8_t Status,
                                                  chip::GroupId GroupId, uint8_t SceneId);
/**
 * @brief Scenes Cluster ViewScene Command callback (from client)
 */
bool emberAfScenesClusterViewSceneCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::Scenes::Commands::ViewScene::DecodableType & commandData);
/**
 * @brief Scenes Cluster ViewSceneResponse Command callback (from server)
 */
bool emberAfScenesClusterViewSceneResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj, uint8_t Status,
                                                   chip::GroupId GroupId, uint8_t SceneId, uint16_t TransitionTime,
                                                   chip::CharSpan SceneName,
                                                   /* TYPE WARNING: array array defaults to */ uint8_t * ExtensionFieldSets);
/**
 * @brief Scenes Cluster RemoveScene Command callback (from client)
 */
bool emberAfScenesClusterRemoveSceneCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::Scenes::Commands::RemoveScene::DecodableType & commandData);
/**
 * @brief Scenes Cluster RemoveSceneResponse Command callback (from server)
 */
bool emberAfScenesClusterRemoveSceneResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                     uint8_t Status, chip::GroupId GroupId, uint8_t SceneId);
/**
 * @brief Scenes Cluster RemoveAllScenes Command callback (from client)
 */
bool emberAfScenesClusterRemoveAllScenesCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Scenes::Commands::RemoveAllScenes::DecodableType & commandData);
/**
 * @brief Scenes Cluster RemoveAllScenesResponse Command callback (from server)
 */
bool emberAfScenesClusterRemoveAllScenesResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                         uint8_t Status, chip::GroupId GroupId);
/**
 * @brief Scenes Cluster StoreScene Command callback (from client)
 */
bool emberAfScenesClusterStoreSceneCallback(chip::app::CommandHandler * commandObj,
                                            const chip::app::ConcreteCommandPath & commandPath,
                                            const chip::app::Clusters::Scenes::Commands::StoreScene::DecodableType & commandData);
/**
 * @brief Scenes Cluster StoreSceneResponse Command callback (from server)
 */
bool emberAfScenesClusterStoreSceneResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                    uint8_t Status, chip::GroupId GroupId, uint8_t SceneId);
/**
 * @brief Scenes Cluster RecallScene Command callback (from client)
 */
bool emberAfScenesClusterRecallSceneCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::Scenes::Commands::RecallScene::DecodableType & commandData);
/**
 * @brief Scenes Cluster GetSceneMembership Command callback (from client)
 */
bool emberAfScenesClusterGetSceneMembershipCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Scenes::Commands::GetSceneMembership::DecodableType & commandData);
/**
 * @brief Scenes Cluster GetSceneMembershipResponse Command callback (from server)
 */
bool emberAfScenesClusterGetSceneMembershipResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                            uint8_t Status, uint8_t Capacity, chip::GroupId GroupId,
                                                            /* TYPE WARNING: array array defaults to */ uint8_t * SceneList);
/**
 * @brief Scenes Cluster EnhancedAddScene Command callback (from client)
 */
bool emberAfScenesClusterEnhancedAddSceneCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Scenes::Commands::EnhancedAddScene::DecodableType & commandData);
/**
 * @brief Scenes Cluster EnhancedAddSceneResponse Command callback (from server)
 */
bool emberAfScenesClusterEnhancedAddSceneResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                          uint8_t Status, chip::GroupId GroupId, uint8_t SceneId);
/**
 * @brief Scenes Cluster EnhancedViewScene Command callback (from client)
 */
bool emberAfScenesClusterEnhancedViewSceneCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Scenes::Commands::EnhancedViewScene::DecodableType & commandData);
/**
 * @brief Scenes Cluster EnhancedViewSceneResponse Command callback (from server)
 */
bool emberAfScenesClusterEnhancedViewSceneResponseCallback(
    chip::EndpointId endpoint, chip::app::CommandSender * commandObj, uint8_t Status, chip::GroupId GroupId, uint8_t SceneId,
    uint16_t TransitionTime, chip::CharSpan SceneName, /* TYPE WARNING: array array defaults to */ uint8_t * ExtensionFieldSets);
/**
 * @brief Scenes Cluster CopyScene Command callback (from client)
 */
bool emberAfScenesClusterCopySceneCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::Scenes::Commands::CopyScene::DecodableType & commandData);
/**
 * @brief Scenes Cluster CopySceneResponse Command callback (from server)
 */
bool emberAfScenesClusterCopySceneResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj, uint8_t Status,
                                                   chip::GroupId GroupIdFrom, uint8_t SceneIdFrom);
/**
 * @brief On/Off Cluster Off Command callback (from client)
 */
bool emberAfOnOffClusterOffCallback(chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
                                    const chip::app::Clusters::OnOff::Commands::Off::DecodableType & commandData);
/**
 * @brief On/Off Cluster On Command callback (from client)
 */
bool emberAfOnOffClusterOnCallback(chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
                                   const chip::app::Clusters::OnOff::Commands::On::DecodableType & commandData);
/**
 * @brief On/Off Cluster Toggle Command callback (from client)
 */
bool emberAfOnOffClusterToggleCallback(chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
                                       const chip::app::Clusters::OnOff::Commands::Toggle::DecodableType & commandData);
/**
 * @brief On/Off Cluster OffWithEffect Command callback (from client)
 */
bool emberAfOnOffClusterOffWithEffectCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OnOff::Commands::OffWithEffect::DecodableType & commandData);
/**
 * @brief On/Off Cluster OnWithRecallGlobalScene Command callback (from client)
 */
bool emberAfOnOffClusterOnWithRecallGlobalSceneCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OnOff::Commands::OnWithRecallGlobalScene::DecodableType & commandData);
/**
 * @brief On/Off Cluster OnWithTimedOff Command callback (from client)
 */
bool emberAfOnOffClusterOnWithTimedOffCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OnOff::Commands::OnWithTimedOff::DecodableType & commandData);
/**
 * @brief Level Control Cluster MoveToLevel Command callback (from client)
 */
bool emberAfLevelControlClusterMoveToLevelCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::MoveToLevel::DecodableType & commandData);
/**
 * @brief Level Control Cluster Move Command callback (from client)
 */
bool emberAfLevelControlClusterMoveCallback(chip::app::CommandHandler * commandObj,
                                            const chip::app::ConcreteCommandPath & commandPath,
                                            const chip::app::Clusters::LevelControl::Commands::Move::DecodableType & commandData);
/**
 * @brief Level Control Cluster Step Command callback (from client)
 */
bool emberAfLevelControlClusterStepCallback(chip::app::CommandHandler * commandObj,
                                            const chip::app::ConcreteCommandPath & commandPath,
                                            const chip::app::Clusters::LevelControl::Commands::Step::DecodableType & commandData);
/**
 * @brief Level Control Cluster Stop Command callback (from client)
 */
bool emberAfLevelControlClusterStopCallback(chip::app::CommandHandler * commandObj,
                                            const chip::app::ConcreteCommandPath & commandPath,
                                            const chip::app::Clusters::LevelControl::Commands::Stop::DecodableType & commandData);
/**
 * @brief Level Control Cluster MoveToLevelWithOnOff Command callback (from client)
 */
bool emberAfLevelControlClusterMoveToLevelWithOnOffCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::MoveToLevelWithOnOff::DecodableType & commandData);
/**
 * @brief Level Control Cluster MoveWithOnOff Command callback (from client)
 */
bool emberAfLevelControlClusterMoveWithOnOffCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::MoveWithOnOff::DecodableType & commandData);
/**
 * @brief Level Control Cluster StepWithOnOff Command callback (from client)
 */
bool emberAfLevelControlClusterStepWithOnOffCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::StepWithOnOff::DecodableType & commandData);
/**
 * @brief Level Control Cluster StopWithOnOff Command callback (from client)
 */
bool emberAfLevelControlClusterStopWithOnOffCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::StopWithOnOff::DecodableType & commandData);
/**
 * @brief Level Control Cluster MoveToClosestFrequency Command callback (from client)
 */
bool emberAfLevelControlClusterMoveToClosestFrequencyCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::LevelControl::Commands::MoveToClosestFrequency::DecodableType & commandData);
/**
 * @brief Actions Cluster InstantAction Command callback (from client)
 */
bool emberAfActionsClusterInstantActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::InstantAction::DecodableType & commandData);
/**
 * @brief Actions Cluster InstantActionWithTransition Command callback (from client)
 */
bool emberAfActionsClusterInstantActionWithTransitionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::InstantActionWithTransition::DecodableType & commandData);
/**
 * @brief Actions Cluster StartAction Command callback (from client)
 */
bool emberAfActionsClusterStartActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::StartAction::DecodableType & commandData);
/**
 * @brief Actions Cluster StartActionWithDuration Command callback (from client)
 */
bool emberAfActionsClusterStartActionWithDurationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::StartActionWithDuration::DecodableType & commandData);
/**
 * @brief Actions Cluster StopAction Command callback (from client)
 */
bool emberAfActionsClusterStopActionCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::Actions::Commands::StopAction::DecodableType & commandData);
/**
 * @brief Actions Cluster PauseAction Command callback (from client)
 */
bool emberAfActionsClusterPauseActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::PauseAction::DecodableType & commandData);
/**
 * @brief Actions Cluster PauseActionWithDuration Command callback (from client)
 */
bool emberAfActionsClusterPauseActionWithDurationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::PauseActionWithDuration::DecodableType & commandData);
/**
 * @brief Actions Cluster ResumeAction Command callback (from client)
 */
bool emberAfActionsClusterResumeActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::ResumeAction::DecodableType & commandData);
/**
 * @brief Actions Cluster EnableAction Command callback (from client)
 */
bool emberAfActionsClusterEnableActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::EnableAction::DecodableType & commandData);
/**
 * @brief Actions Cluster EnableActionWithDuration Command callback (from client)
 */
bool emberAfActionsClusterEnableActionWithDurationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::EnableActionWithDuration::DecodableType & commandData);
/**
 * @brief Actions Cluster DisableAction Command callback (from client)
 */
bool emberAfActionsClusterDisableActionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::DisableAction::DecodableType & commandData);
/**
 * @brief Actions Cluster DisableActionWithDuration Command callback (from client)
 */
bool emberAfActionsClusterDisableActionWithDurationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Actions::Commands::DisableActionWithDuration::DecodableType & commandData);
/**
 * @brief Basic Cluster MfgSpecificPing Command callback (from client)
 */
bool emberAfBasicClusterMfgSpecificPingCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Basic::Commands::MfgSpecificPing::DecodableType & commandData);
/**
 * @brief OTA Software Update Provider Cluster QueryImage Command callback (from client)
 */
bool emberAfOtaSoftwareUpdateProviderClusterQueryImageCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OtaSoftwareUpdateProvider::Commands::QueryImage::DecodableType & commandData);
/**
 * @brief OTA Software Update Provider Cluster QueryImageResponse Command callback (from server)
 */
bool emberAfOtaSoftwareUpdateProviderClusterQueryImageResponseCallback(
    chip::EndpointId endpoint, chip::app::CommandSender * commandObj, uint8_t status, uint32_t delayedActionTime,
    chip::CharSpan imageURI, uint32_t softwareVersion, chip::CharSpan softwareVersionString, chip::ByteSpan updateToken,
    bool userConsentNeeded, chip::ByteSpan metadataForRequestor);
/**
 * @brief OTA Software Update Provider Cluster ApplyUpdateRequest Command callback (from client)
 */
bool emberAfOtaSoftwareUpdateProviderClusterApplyUpdateRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OtaSoftwareUpdateProvider::Commands::ApplyUpdateRequest::DecodableType & commandData);
/**
 * @brief OTA Software Update Provider Cluster ApplyUpdateResponse Command callback (from server)
 */
bool emberAfOtaSoftwareUpdateProviderClusterApplyUpdateResponseCallback(chip::EndpointId endpoint,
                                                                        chip::app::CommandSender * commandObj, uint8_t action,
                                                                        uint32_t delayedActionTime);
/**
 * @brief OTA Software Update Provider Cluster NotifyUpdateApplied Command callback (from client)
 */
bool emberAfOtaSoftwareUpdateProviderClusterNotifyUpdateAppliedCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OtaSoftwareUpdateProvider::Commands::NotifyUpdateApplied::DecodableType & commandData);
/**
 * @brief OTA Software Update Requestor Cluster AnnounceOtaProvider Command callback (from client)
 */
bool emberAfOtaSoftwareUpdateRequestorClusterAnnounceOtaProviderCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OtaSoftwareUpdateRequestor::Commands::AnnounceOtaProvider::DecodableType & commandData);
/**
 * @brief General Commissioning Cluster ArmFailSafe Command callback (from client)
 */
bool emberAfGeneralCommissioningClusterArmFailSafeCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GeneralCommissioning::Commands::ArmFailSafe::DecodableType & commandData);
/**
 * @brief General Commissioning Cluster ArmFailSafeResponse Command callback (from server)
 */
bool emberAfGeneralCommissioningClusterArmFailSafeResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                                   uint8_t errorCode, chip::CharSpan debugText);
/**
 * @brief General Commissioning Cluster SetRegulatoryConfig Command callback (from client)
 */
bool emberAfGeneralCommissioningClusterSetRegulatoryConfigCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GeneralCommissioning::Commands::SetRegulatoryConfig::DecodableType & commandData);
/**
 * @brief General Commissioning Cluster SetRegulatoryConfigResponse Command callback (from server)
 */
bool emberAfGeneralCommissioningClusterSetRegulatoryConfigResponseCallback(chip::EndpointId endpoint,
                                                                           chip::app::CommandSender * commandObj, uint8_t errorCode,
                                                                           chip::CharSpan debugText);
/**
 * @brief General Commissioning Cluster CommissioningComplete Command callback (from client)
 */
bool emberAfGeneralCommissioningClusterCommissioningCompleteCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GeneralCommissioning::Commands::CommissioningComplete::DecodableType & commandData);
/**
 * @brief General Commissioning Cluster CommissioningCompleteResponse Command callback (from server)
 */
bool emberAfGeneralCommissioningClusterCommissioningCompleteResponseCallback(chip::EndpointId endpoint,
                                                                             chip::app::CommandSender * commandObj,
                                                                             uint8_t errorCode, chip::CharSpan debugText);
/**
 * @brief Network Commissioning Cluster ScanNetworks Command callback (from client)
 */
bool emberAfNetworkCommissioningClusterScanNetworksCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::NetworkCommissioning::Commands::ScanNetworks::DecodableType & commandData);
/**
 * @brief Network Commissioning Cluster ScanNetworksResponse Command callback (from server)
 */
bool emberAfNetworkCommissioningClusterScanNetworksResponseCallback(
    chip::EndpointId endpoint, chip::app::CommandSender * commandObj, uint8_t NetworkingStatus, chip::CharSpan DebugText,
    /* TYPE WARNING: array array defaults to */ uint8_t * WiFiScanResults,
    /* TYPE WARNING: array array defaults to */ uint8_t * ThreadScanResults);
/**
 * @brief Network Commissioning Cluster AddOrUpdateWiFiNetwork Command callback (from client)
 */
bool emberAfNetworkCommissioningClusterAddOrUpdateWiFiNetworkCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::NetworkCommissioning::Commands::AddOrUpdateWiFiNetwork::DecodableType & commandData);
/**
 * @brief Network Commissioning Cluster AddOrUpdateThreadNetwork Command callback (from client)
 */
bool emberAfNetworkCommissioningClusterAddOrUpdateThreadNetworkCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::NetworkCommissioning::Commands::AddOrUpdateThreadNetwork::DecodableType & commandData);
/**
 * @brief Network Commissioning Cluster RemoveNetwork Command callback (from client)
 */
bool emberAfNetworkCommissioningClusterRemoveNetworkCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::NetworkCommissioning::Commands::RemoveNetwork::DecodableType & commandData);
/**
 * @brief Network Commissioning Cluster NetworkConfigResponse Command callback (from server)
 */
bool emberAfNetworkCommissioningClusterNetworkConfigResponseCallback(chip::EndpointId endpoint,
                                                                     chip::app::CommandSender * commandObj,
                                                                     uint8_t NetworkingStatus, chip::CharSpan DebugText,
                                                                     uint8_t NetworkIndex);
/**
 * @brief Network Commissioning Cluster ConnectNetwork Command callback (from client)
 */
bool emberAfNetworkCommissioningClusterConnectNetworkCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::NetworkCommissioning::Commands::ConnectNetwork::DecodableType & commandData);
/**
 * @brief Network Commissioning Cluster ConnectNetworkResponse Command callback (from server)
 */
bool emberAfNetworkCommissioningClusterConnectNetworkResponseCallback(chip::EndpointId endpoint,
                                                                      chip::app::CommandSender * commandObj,
                                                                      uint8_t NetworkingStatus, chip::CharSpan DebugText,
                                                                      int32_t ErrorValue);
/**
 * @brief Network Commissioning Cluster ReorderNetwork Command callback (from client)
 */
bool emberAfNetworkCommissioningClusterReorderNetworkCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::NetworkCommissioning::Commands::ReorderNetwork::DecodableType & commandData);
/**
 * @brief Diagnostic Logs Cluster RetrieveLogsRequest Command callback (from client)
 */
bool emberAfDiagnosticLogsClusterRetrieveLogsRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DiagnosticLogs::Commands::RetrieveLogsRequest::DecodableType & commandData);
/**
 * @brief Diagnostic Logs Cluster RetrieveLogsResponse Command callback (from server)
 */
bool emberAfDiagnosticLogsClusterRetrieveLogsResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                              uint8_t status, chip::ByteSpan content, uint32_t timeStamp,
                                                              uint32_t timeSinceBoot);
/**
 * @brief General Diagnostics Cluster TestEventTrigger Command callback (from client)
 */
bool emberAfGeneralDiagnosticsClusterTestEventTriggerCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GeneralDiagnostics::Commands::TestEventTrigger::DecodableType & commandData);
/**
 * @brief Software Diagnostics Cluster ResetWatermarks Command callback (from client)
 */
bool emberAfSoftwareDiagnosticsClusterResetWatermarksCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::SoftwareDiagnostics::Commands::ResetWatermarks::DecodableType & commandData);
/**
 * @brief Thread Network Diagnostics Cluster ResetCounts Command callback (from client)
 */
bool emberAfThreadNetworkDiagnosticsClusterResetCountsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ThreadNetworkDiagnostics::Commands::ResetCounts::DecodableType & commandData);
/**
 * @brief WiFi Network Diagnostics Cluster ResetCounts Command callback (from client)
 */
bool emberAfWiFiNetworkDiagnosticsClusterResetCountsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WiFiNetworkDiagnostics::Commands::ResetCounts::DecodableType & commandData);
/**
 * @brief Ethernet Network Diagnostics Cluster ResetCounts Command callback (from client)
 */
bool emberAfEthernetNetworkDiagnosticsClusterResetCountsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::EthernetNetworkDiagnostics::Commands::ResetCounts::DecodableType & commandData);
/**
 * @brief Time Synchronization Cluster SetUtcTime Command callback (from client)
 */
bool emberAfTimeSynchronizationClusterSetUtcTimeCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TimeSynchronization::Commands::SetUtcTime::DecodableType & commandData);
/**
 * @brief AdministratorCommissioning Cluster OpenCommissioningWindow Command callback (from client)
 */
bool emberAfAdministratorCommissioningClusterOpenCommissioningWindowCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AdministratorCommissioning::Commands::OpenCommissioningWindow::DecodableType & commandData);
/**
 * @brief AdministratorCommissioning Cluster OpenBasicCommissioningWindow Command callback (from client)
 */
bool emberAfAdministratorCommissioningClusterOpenBasicCommissioningWindowCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AdministratorCommissioning::Commands::OpenBasicCommissioningWindow::DecodableType & commandData);
/**
 * @brief AdministratorCommissioning Cluster RevokeCommissioning Command callback (from client)
 */
bool emberAfAdministratorCommissioningClusterRevokeCommissioningCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AdministratorCommissioning::Commands::RevokeCommissioning::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster AttestationRequest Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterAttestationRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::AttestationRequest::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster AttestationResponse Command callback (from server)
 */
bool emberAfOperationalCredentialsClusterAttestationResponseCallback(chip::EndpointId endpoint,
                                                                     chip::app::CommandSender * commandObj,
                                                                     chip::ByteSpan AttestationElements, chip::ByteSpan Signature);
/**
 * @brief Operational Credentials Cluster CertificateChainRequest Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterCertificateChainRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::CertificateChainRequest::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster CertificateChainResponse Command callback (from server)
 */
bool emberAfOperationalCredentialsClusterCertificateChainResponseCallback(chip::EndpointId endpoint,
                                                                          chip::app::CommandSender * commandObj,
                                                                          chip::ByteSpan Certificate);
/**
 * @brief Operational Credentials Cluster CSRRequest Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterCSRRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::CSRRequest::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster CSRResponse Command callback (from server)
 */
bool emberAfOperationalCredentialsClusterCSRResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                             chip::ByteSpan NOCSRElements, chip::ByteSpan AttestationSignature);
/**
 * @brief Operational Credentials Cluster AddNOC Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterAddNOCCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::AddNOC::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster UpdateNOC Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterUpdateNOCCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::UpdateNOC::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster NOCResponse Command callback (from server)
 */
bool emberAfOperationalCredentialsClusterNOCResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                             uint8_t StatusCode, chip::FabricIndex FabricIndex,
                                                             chip::CharSpan DebugText);
/**
 * @brief Operational Credentials Cluster UpdateFabricLabel Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterUpdateFabricLabelCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::UpdateFabricLabel::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster RemoveFabric Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterRemoveFabricCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::RemoveFabric::DecodableType & commandData);
/**
 * @brief Operational Credentials Cluster AddTrustedRootCertificate Command callback (from client)
 */
bool emberAfOperationalCredentialsClusterAddTrustedRootCertificateCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::OperationalCredentials::Commands::AddTrustedRootCertificate::DecodableType & commandData);
/**
 * @brief Group Key Management Cluster KeySetWrite Command callback (from client)
 */
bool emberAfGroupKeyManagementClusterKeySetWriteCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GroupKeyManagement::Commands::KeySetWrite::DecodableType & commandData);
/**
 * @brief Group Key Management Cluster KeySetRead Command callback (from client)
 */
bool emberAfGroupKeyManagementClusterKeySetReadCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GroupKeyManagement::Commands::KeySetRead::DecodableType & commandData);
/**
 * @brief Group Key Management Cluster KeySetReadResponse Command callback (from server)
 */
bool emberAfGroupKeyManagementClusterKeySetReadResponseCallback(
    chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
    chip::app::Clusters::GroupKeyManagement::Structs::GroupKeySetStruct::DecodableType GroupKeySet);
/**
 * @brief Group Key Management Cluster KeySetRemove Command callback (from client)
 */
bool emberAfGroupKeyManagementClusterKeySetRemoveCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GroupKeyManagement::Commands::KeySetRemove::DecodableType & commandData);
/**
 * @brief Group Key Management Cluster KeySetReadAllIndices Command callback (from client)
 */
bool emberAfGroupKeyManagementClusterKeySetReadAllIndicesCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::GroupKeyManagement::Commands::KeySetReadAllIndices::DecodableType & commandData);
/**
 * @brief Group Key Management Cluster KeySetReadAllIndicesResponse Command callback (from server)
 */
bool emberAfGroupKeyManagementClusterKeySetReadAllIndicesResponseCallback(
    chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
    /* TYPE WARNING: array array defaults to */ uint8_t * GroupKeySetIDs);
/**
 * @brief Mode Select Cluster ChangeToMode Command callback (from client)
 */
bool emberAfModeSelectClusterChangeToModeCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ModeSelect::Commands::ChangeToMode::DecodableType & commandData);
/**
 * @brief Door Lock Cluster LockDoor Command callback (from client)
 */
bool emberAfDoorLockClusterLockDoorCallback(chip::app::CommandHandler * commandObj,
                                            const chip::app::ConcreteCommandPath & commandPath,
                                            const chip::app::Clusters::DoorLock::Commands::LockDoor::DecodableType & commandData);
/**
 * @brief Door Lock Cluster UnlockDoor Command callback (from client)
 */
bool emberAfDoorLockClusterUnlockDoorCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::UnlockDoor::DecodableType & commandData);
/**
 * @brief Door Lock Cluster UnlockWithTimeout Command callback (from client)
 */
bool emberAfDoorLockClusterUnlockWithTimeoutCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::UnlockWithTimeout::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetWeekDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterSetWeekDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::SetWeekDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetWeekDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterGetWeekDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::GetWeekDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetWeekDayScheduleResponse Command callback (from server)
 */
bool emberAfDoorLockClusterGetWeekDayScheduleResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                              uint8_t weekDayIndex, uint16_t userIndex, uint8_t status,
                                                              uint8_t daysMask, uint8_t startHour, uint8_t startMinute,
                                                              uint8_t endHour, uint8_t endMinute);
/**
 * @brief Door Lock Cluster ClearWeekDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterClearWeekDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::ClearWeekDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetYearDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterSetYearDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::SetYearDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetYearDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterGetYearDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::GetYearDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetYearDayScheduleResponse Command callback (from server)
 */
bool emberAfDoorLockClusterGetYearDayScheduleResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                              uint8_t yearDayIndex, uint16_t userIndex, uint8_t status,
                                                              uint32_t localStartTime, uint32_t localEndTime);
/**
 * @brief Door Lock Cluster ClearYearDaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterClearYearDayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::ClearYearDaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetHolidaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterSetHolidayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::SetHolidaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetHolidaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterGetHolidayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::GetHolidaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetHolidayScheduleResponse Command callback (from server)
 */
bool emberAfDoorLockClusterGetHolidayScheduleResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                              uint8_t holidayIndex, uint8_t status, uint32_t localStartTime,
                                                              uint32_t localEndTime, uint8_t operatingMode);
/**
 * @brief Door Lock Cluster ClearHolidaySchedule Command callback (from client)
 */
bool emberAfDoorLockClusterClearHolidayScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::ClearHolidaySchedule::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetUser Command callback (from client)
 */
bool emberAfDoorLockClusterSetUserCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::DoorLock::Commands::SetUser::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetUser Command callback (from client)
 */
bool emberAfDoorLockClusterGetUserCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::DoorLock::Commands::GetUser::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetUserResponse Command callback (from server)
 */
bool emberAfDoorLockClusterGetUserResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                   uint16_t userIndex, chip::CharSpan userName, uint32_t userUniqueId,
                                                   uint8_t userStatus, uint8_t userType, uint8_t credentialRule,
                                                   /* TYPE WARNING: array array defaults to */ uint8_t * credentials,
                                                   chip::FabricIndex creatorFabricIndex, chip::FabricIndex lastModifiedFabricIndex,
                                                   uint16_t nextUserIndex);
/**
 * @brief Door Lock Cluster ClearUser Command callback (from client)
 */
bool emberAfDoorLockClusterClearUserCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::DoorLock::Commands::ClearUser::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetCredential Command callback (from client)
 */
bool emberAfDoorLockClusterSetCredentialCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::SetCredential::DecodableType & commandData);
/**
 * @brief Door Lock Cluster SetCredentialResponse Command callback (from server)
 */
bool emberAfDoorLockClusterSetCredentialResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                         uint8_t status, uint16_t userIndex, uint16_t nextCredentialIndex);
/**
 * @brief Door Lock Cluster GetCredentialStatus Command callback (from client)
 */
bool emberAfDoorLockClusterGetCredentialStatusCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::GetCredentialStatus::DecodableType & commandData);
/**
 * @brief Door Lock Cluster GetCredentialStatusResponse Command callback (from server)
 */
bool emberAfDoorLockClusterGetCredentialStatusResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                               bool credentialExists, uint16_t userIndex,
                                                               chip::FabricIndex creatorFabricIndex,
                                                               chip::FabricIndex lastModifiedFabricIndex,
                                                               uint16_t nextCredentialIndex);
/**
 * @brief Door Lock Cluster ClearCredential Command callback (from client)
 */
bool emberAfDoorLockClusterClearCredentialCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::DoorLock::Commands::ClearCredential::DecodableType & commandData);
/**
 * @brief Window Covering Cluster UpOrOpen Command callback (from client)
 */
bool emberAfWindowCoveringClusterUpOrOpenCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::UpOrOpen::DecodableType & commandData);
/**
 * @brief Window Covering Cluster DownOrClose Command callback (from client)
 */
bool emberAfWindowCoveringClusterDownOrCloseCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::DownOrClose::DecodableType & commandData);
/**
 * @brief Window Covering Cluster StopMotion Command callback (from client)
 */
bool emberAfWindowCoveringClusterStopMotionCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::StopMotion::DecodableType & commandData);
/**
 * @brief Window Covering Cluster GoToLiftValue Command callback (from client)
 */
bool emberAfWindowCoveringClusterGoToLiftValueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::GoToLiftValue::DecodableType & commandData);
/**
 * @brief Window Covering Cluster GoToLiftPercentage Command callback (from client)
 */
bool emberAfWindowCoveringClusterGoToLiftPercentageCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::GoToLiftPercentage::DecodableType & commandData);
/**
 * @brief Window Covering Cluster GoToTiltValue Command callback (from client)
 */
bool emberAfWindowCoveringClusterGoToTiltValueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::GoToTiltValue::DecodableType & commandData);
/**
 * @brief Window Covering Cluster GoToTiltPercentage Command callback (from client)
 */
bool emberAfWindowCoveringClusterGoToTiltPercentageCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::WindowCovering::Commands::GoToTiltPercentage::DecodableType & commandData);
/**
 * @brief Barrier Control Cluster BarrierControlGoToPercent Command callback (from client)
 */
bool emberAfBarrierControlClusterBarrierControlGoToPercentCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::BarrierControl::Commands::BarrierControlGoToPercent::DecodableType & commandData);
/**
 * @brief Barrier Control Cluster BarrierControlStop Command callback (from client)
 */
bool emberAfBarrierControlClusterBarrierControlStopCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::BarrierControl::Commands::BarrierControlStop::DecodableType & commandData);
/**
 * @brief Thermostat Cluster SetpointRaiseLower Command callback (from client)
 */
bool emberAfThermostatClusterSetpointRaiseLowerCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Thermostat::Commands::SetpointRaiseLower::DecodableType & commandData);
/**
 * @brief Thermostat Cluster GetWeeklyScheduleResponse Command callback (from server)
 */
bool emberAfThermostatClusterGetWeeklyScheduleResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                               uint8_t NumberOfTransitionsForSequence, uint8_t DayOfWeekForSequence,
                                                               uint8_t ModeForSequence,
                                                               /* TYPE WARNING: array array defaults to */ uint8_t * Transitions);
/**
 * @brief Thermostat Cluster SetWeeklySchedule Command callback (from client)
 */
bool emberAfThermostatClusterSetWeeklyScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Thermostat::Commands::SetWeeklySchedule::DecodableType & commandData);
/**
 * @brief Thermostat Cluster GetWeeklySchedule Command callback (from client)
 */
bool emberAfThermostatClusterGetWeeklyScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Thermostat::Commands::GetWeeklySchedule::DecodableType & commandData);
/**
 * @brief Thermostat Cluster ClearWeeklySchedule Command callback (from client)
 */
bool emberAfThermostatClusterClearWeeklyScheduleCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Thermostat::Commands::ClearWeeklySchedule::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveToHue Command callback (from client)
 */
bool emberAfColorControlClusterMoveToHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveToHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveHue Command callback (from client)
 */
bool emberAfColorControlClusterMoveHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster StepHue Command callback (from client)
 */
bool emberAfColorControlClusterStepHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::StepHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveToSaturation Command callback (from client)
 */
bool emberAfColorControlClusterMoveToSaturationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveToSaturation::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveSaturation Command callback (from client)
 */
bool emberAfColorControlClusterMoveSaturationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveSaturation::DecodableType & commandData);
/**
 * @brief Color Control Cluster StepSaturation Command callback (from client)
 */
bool emberAfColorControlClusterStepSaturationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::StepSaturation::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveToHueAndSaturation Command callback (from client)
 */
bool emberAfColorControlClusterMoveToHueAndSaturationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveToHueAndSaturation::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveToColor Command callback (from client)
 */
bool emberAfColorControlClusterMoveToColorCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveToColor::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveColor Command callback (from client)
 */
bool emberAfColorControlClusterMoveColorCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveColor::DecodableType & commandData);
/**
 * @brief Color Control Cluster StepColor Command callback (from client)
 */
bool emberAfColorControlClusterStepColorCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::StepColor::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveToColorTemperature Command callback (from client)
 */
bool emberAfColorControlClusterMoveToColorTemperatureCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveToColorTemperature::DecodableType & commandData);
/**
 * @brief Color Control Cluster EnhancedMoveToHue Command callback (from client)
 */
bool emberAfColorControlClusterEnhancedMoveToHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::EnhancedMoveToHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster EnhancedMoveHue Command callback (from client)
 */
bool emberAfColorControlClusterEnhancedMoveHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::EnhancedMoveHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster EnhancedStepHue Command callback (from client)
 */
bool emberAfColorControlClusterEnhancedStepHueCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::EnhancedStepHue::DecodableType & commandData);
/**
 * @brief Color Control Cluster EnhancedMoveToHueAndSaturation Command callback (from client)
 */
bool emberAfColorControlClusterEnhancedMoveToHueAndSaturationCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::EnhancedMoveToHueAndSaturation::DecodableType & commandData);
/**
 * @brief Color Control Cluster ColorLoopSet Command callback (from client)
 */
bool emberAfColorControlClusterColorLoopSetCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::ColorLoopSet::DecodableType & commandData);
/**
 * @brief Color Control Cluster StopMoveStep Command callback (from client)
 */
bool emberAfColorControlClusterStopMoveStepCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::StopMoveStep::DecodableType & commandData);
/**
 * @brief Color Control Cluster MoveColorTemperature Command callback (from client)
 */
bool emberAfColorControlClusterMoveColorTemperatureCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::MoveColorTemperature::DecodableType & commandData);
/**
 * @brief Color Control Cluster StepColorTemperature Command callback (from client)
 */
bool emberAfColorControlClusterStepColorTemperatureCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ColorControl::Commands::StepColorTemperature::DecodableType & commandData);
/**
 * @brief Channel Cluster ChangeChannel Command callback (from client)
 */
bool emberAfChannelClusterChangeChannelCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Channel::Commands::ChangeChannel::DecodableType & commandData);
/**
 * @brief Channel Cluster ChangeChannelResponse Command callback (from server)
 */
bool emberAfChannelClusterChangeChannelResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                        uint8_t status, chip::CharSpan data);
/**
 * @brief Channel Cluster ChangeChannelByNumber Command callback (from client)
 */
bool emberAfChannelClusterChangeChannelByNumberCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Channel::Commands::ChangeChannelByNumber::DecodableType & commandData);
/**
 * @brief Channel Cluster SkipChannel Command callback (from client)
 */
bool emberAfChannelClusterSkipChannelCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::Channel::Commands::SkipChannel::DecodableType & commandData);
/**
 * @brief Target Navigator Cluster NavigateTarget Command callback (from client)
 */
bool emberAfTargetNavigatorClusterNavigateTargetCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TargetNavigator::Commands::NavigateTarget::DecodableType & commandData);
/**
 * @brief Target Navigator Cluster NavigateTargetResponse Command callback (from server)
 */
bool emberAfTargetNavigatorClusterNavigateTargetResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                                 uint8_t status, chip::CharSpan data);
/**
 * @brief Media Playback Cluster Play Command callback (from client)
 */
bool emberAfMediaPlaybackClusterPlayCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::MediaPlayback::Commands::Play::DecodableType & commandData);
/**
 * @brief Media Playback Cluster Pause Command callback (from client)
 */
bool emberAfMediaPlaybackClusterPauseCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::Pause::DecodableType & commandData);
/**
 * @brief Media Playback Cluster StopPlayback Command callback (from client)
 */
bool emberAfMediaPlaybackClusterStopPlaybackCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::StopPlayback::DecodableType & commandData);
/**
 * @brief Media Playback Cluster StartOver Command callback (from client)
 */
bool emberAfMediaPlaybackClusterStartOverCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::StartOver::DecodableType & commandData);
/**
 * @brief Media Playback Cluster Previous Command callback (from client)
 */
bool emberAfMediaPlaybackClusterPreviousCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::Previous::DecodableType & commandData);
/**
 * @brief Media Playback Cluster Next Command callback (from client)
 */
bool emberAfMediaPlaybackClusterNextCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::MediaPlayback::Commands::Next::DecodableType & commandData);
/**
 * @brief Media Playback Cluster Rewind Command callback (from client)
 */
bool emberAfMediaPlaybackClusterRewindCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::Rewind::DecodableType & commandData);
/**
 * @brief Media Playback Cluster FastForward Command callback (from client)
 */
bool emberAfMediaPlaybackClusterFastForwardCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::FastForward::DecodableType & commandData);
/**
 * @brief Media Playback Cluster SkipForward Command callback (from client)
 */
bool emberAfMediaPlaybackClusterSkipForwardCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::SkipForward::DecodableType & commandData);
/**
 * @brief Media Playback Cluster SkipBackward Command callback (from client)
 */
bool emberAfMediaPlaybackClusterSkipBackwardCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaPlayback::Commands::SkipBackward::DecodableType & commandData);
/**
 * @brief Media Playback Cluster PlaybackResponse Command callback (from server)
 */
bool emberAfMediaPlaybackClusterPlaybackResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                         uint8_t status, chip::CharSpan data);
/**
 * @brief Media Playback Cluster Seek Command callback (from client)
 */
bool emberAfMediaPlaybackClusterSeekCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::MediaPlayback::Commands::Seek::DecodableType & commandData);
/**
 * @brief Media Input Cluster SelectInput Command callback (from client)
 */
bool emberAfMediaInputClusterSelectInputCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaInput::Commands::SelectInput::DecodableType & commandData);
/**
 * @brief Media Input Cluster ShowInputStatus Command callback (from client)
 */
bool emberAfMediaInputClusterShowInputStatusCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaInput::Commands::ShowInputStatus::DecodableType & commandData);
/**
 * @brief Media Input Cluster HideInputStatus Command callback (from client)
 */
bool emberAfMediaInputClusterHideInputStatusCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaInput::Commands::HideInputStatus::DecodableType & commandData);
/**
 * @brief Media Input Cluster RenameInput Command callback (from client)
 */
bool emberAfMediaInputClusterRenameInputCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::MediaInput::Commands::RenameInput::DecodableType & commandData);
/**
 * @brief Low Power Cluster Sleep Command callback (from client)
 */
bool emberAfLowPowerClusterSleepCallback(chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
                                         const chip::app::Clusters::LowPower::Commands::Sleep::DecodableType & commandData);
/**
 * @brief Keypad Input Cluster SendKey Command callback (from client)
 */
bool emberAfKeypadInputClusterSendKeyCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::KeypadInput::Commands::SendKey::DecodableType & commandData);
/**
 * @brief Keypad Input Cluster SendKeyResponse Command callback (from server)
 */
bool emberAfKeypadInputClusterSendKeyResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                      uint8_t status);
/**
 * @brief Content Launcher Cluster LaunchContent Command callback (from client)
 */
bool emberAfContentLauncherClusterLaunchContentCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentLauncher::Commands::LaunchContent::DecodableType & commandData);
/**
 * @brief Content Launcher Cluster LaunchURL Command callback (from client)
 */
bool emberAfContentLauncherClusterLaunchURLCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ContentLauncher::Commands::LaunchURL::DecodableType & commandData);
/**
 * @brief Content Launcher Cluster LaunchResponse Command callback (from server)
 */
bool emberAfContentLauncherClusterLaunchResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                         uint8_t status, chip::CharSpan data);
/**
 * @brief Audio Output Cluster SelectOutput Command callback (from client)
 */
bool emberAfAudioOutputClusterSelectOutputCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AudioOutput::Commands::SelectOutput::DecodableType & commandData);
/**
 * @brief Audio Output Cluster RenameOutput Command callback (from client)
 */
bool emberAfAudioOutputClusterRenameOutputCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AudioOutput::Commands::RenameOutput::DecodableType & commandData);
/**
 * @brief Application Launcher Cluster LaunchApp Command callback (from client)
 */
bool emberAfApplicationLauncherClusterLaunchAppCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ApplicationLauncher::Commands::LaunchApp::DecodableType & commandData);
/**
 * @brief Application Launcher Cluster StopApp Command callback (from client)
 */
bool emberAfApplicationLauncherClusterStopAppCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ApplicationLauncher::Commands::StopApp::DecodableType & commandData);
/**
 * @brief Application Launcher Cluster HideApp Command callback (from client)
 */
bool emberAfApplicationLauncherClusterHideAppCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ApplicationLauncher::Commands::HideApp::DecodableType & commandData);
/**
 * @brief Application Launcher Cluster LauncherResponse Command callback (from server)
 */
bool emberAfApplicationLauncherClusterLauncherResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                               uint8_t status, chip::ByteSpan data);
/**
 * @brief Account Login Cluster GetSetupPIN Command callback (from client)
 */
bool emberAfAccountLoginClusterGetSetupPINCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AccountLogin::Commands::GetSetupPIN::DecodableType & commandData);
/**
 * @brief Account Login Cluster GetSetupPINResponse Command callback (from server)
 */
bool emberAfAccountLoginClusterGetSetupPINResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                           chip::CharSpan setupPIN);
/**
 * @brief Account Login Cluster Login Command callback (from client)
 */
bool emberAfAccountLoginClusterLoginCallback(chip::app::CommandHandler * commandObj,
                                             const chip::app::ConcreteCommandPath & commandPath,
                                             const chip::app::Clusters::AccountLogin::Commands::Login::DecodableType & commandData);
/**
 * @brief Account Login Cluster Logout Command callback (from client)
 */
bool emberAfAccountLoginClusterLogoutCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::AccountLogin::Commands::Logout::DecodableType & commandData);
/**
 * @brief Electrical Measurement Cluster GetProfileInfoResponseCommand Command callback (from server)
 */
bool emberAfElectricalMeasurementClusterGetProfileInfoResponseCommandCallback(
    chip::EndpointId endpoint, chip::app::CommandSender * commandObj, uint8_t profileCount, uint8_t profileIntervalPeriod,
    uint8_t maxNumberOfIntervals, /* TYPE WARNING: array array defaults to */ uint8_t * listOfAttributes);
/**
 * @brief Electrical Measurement Cluster GetProfileInfoCommand Command callback (from client)
 */
bool emberAfElectricalMeasurementClusterGetProfileInfoCommandCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ElectricalMeasurement::Commands::GetProfileInfoCommand::DecodableType & commandData);
/**
 * @brief Electrical Measurement Cluster GetMeasurementProfileResponseCommand Command callback (from server)
 */
bool emberAfElectricalMeasurementClusterGetMeasurementProfileResponseCommandCallback(
    chip::EndpointId endpoint, chip::app::CommandSender * commandObj, uint32_t startTime, uint8_t status,
    uint8_t profileIntervalPeriod, uint8_t numberOfIntervalsDelivered, uint16_t attributeId,
    /* TYPE WARNING: array array defaults to */ uint8_t * intervals);
/**
 * @brief Electrical Measurement Cluster GetMeasurementProfileCommand Command callback (from client)
 */
bool emberAfElectricalMeasurementClusterGetMeasurementProfileCommandCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::ElectricalMeasurement::Commands::GetMeasurementProfileCommand::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster Test Command callback (from client)
 */
bool emberAfTestClusterClusterTestCallback(chip::app::CommandHandler * commandObj,
                                           const chip::app::ConcreteCommandPath & commandPath,
                                           const chip::app::Clusters::TestCluster::Commands::Test::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestSpecificResponse Command callback (from server)
 */
bool emberAfTestClusterClusterTestSpecificResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                           uint8_t returnValue);
/**
 * @brief Test Cluster Cluster TestNotHandled Command callback (from client)
 */
bool emberAfTestClusterClusterTestNotHandledCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestNotHandled::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestAddArgumentsResponse Command callback (from server)
 */
bool emberAfTestClusterClusterTestAddArgumentsResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                               uint8_t returnValue);
/**
 * @brief Test Cluster Cluster TestSpecific Command callback (from client)
 */
bool emberAfTestClusterClusterTestSpecificCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestSpecific::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestSimpleArgumentResponse Command callback (from server)
 */
bool emberAfTestClusterClusterTestSimpleArgumentResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                                 bool returnValue);
/**
 * @brief Test Cluster Cluster TestUnknownCommand Command callback (from client)
 */
bool emberAfTestClusterClusterTestUnknownCommandCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestUnknownCommand::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestStructArrayArgumentResponse Command callback (from server)
 */
bool emberAfTestClusterClusterTestStructArrayArgumentResponseCallback(
    chip::EndpointId endpoint, chip::app::CommandSender * commandObj, /* TYPE WARNING: array array defaults to */ uint8_t * arg1,
    /* TYPE WARNING: array array defaults to */ uint8_t * arg2, /* TYPE WARNING: array array defaults to */ uint8_t * arg3,
    /* TYPE WARNING: array array defaults to */ uint8_t * arg4, uint8_t arg5, bool arg6);
/**
 * @brief Test Cluster Cluster TestAddArguments Command callback (from client)
 */
bool emberAfTestClusterClusterTestAddArgumentsCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestAddArguments::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestListInt8UReverseResponse Command callback (from server)
 */
bool emberAfTestClusterClusterTestListInt8UReverseResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                                   /* TYPE WARNING: array array defaults to */ uint8_t * arg1);
/**
 * @brief Test Cluster Cluster TestSimpleArgumentRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestSimpleArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestSimpleArgumentRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestEnumsResponse Command callback (from server)
 */
bool emberAfTestClusterClusterTestEnumsResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                        chip::VendorId arg1, uint8_t arg2);
/**
 * @brief Test Cluster Cluster TestStructArrayArgumentRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestStructArrayArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestStructArrayArgumentRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestNullableOptionalResponse Command callback (from server)
 */
bool emberAfTestClusterClusterTestNullableOptionalResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                                   bool wasPresent, bool wasNull, uint8_t value,
                                                                   uint8_t originalValue);
/**
 * @brief Test Cluster Cluster TestStructArgumentRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestStructArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestStructArgumentRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestComplexNullableOptionalResponse Command callback (from server)
 */
bool emberAfTestClusterClusterTestComplexNullableOptionalResponseCallback(
    chip::EndpointId endpoint, chip::app::CommandSender * commandObj, bool NullableIntWasNull, uint16_t NullableIntValue,
    bool OptionalIntWasPresent, uint16_t OptionalIntValue, bool NullableOptionalIntWasPresent, bool NullableOptionalIntWasNull,
    uint16_t NullableOptionalIntValue, bool NullableStringWasNull, chip::CharSpan NullableStringValue,
    bool OptionalStringWasPresent, chip::CharSpan OptionalStringValue, bool NullableOptionalStringWasPresent,
    bool NullableOptionalStringWasNull, chip::CharSpan NullableOptionalStringValue, bool NullableStructWasNull,
    chip::Optional<chip::app::Clusters::TestCluster::Structs::SimpleStruct::DecodableType> NullableStructValue,
    bool OptionalStructWasPresent,
    chip::Optional<chip::app::Clusters::TestCluster::Structs::SimpleStruct::DecodableType> OptionalStructValue,
    bool NullableOptionalStructWasPresent, bool NullableOptionalStructWasNull,
    chip::Optional<chip::app::Clusters::TestCluster::Structs::SimpleStruct::DecodableType> NullableOptionalStructValue,
    bool NullableListWasNull, /* TYPE WARNING: array array defaults to */ uint8_t * NullableListValue, bool OptionalListWasPresent,
    /* TYPE WARNING: array array defaults to */ uint8_t * OptionalListValue, bool NullableOptionalListWasPresent,
    bool NullableOptionalListWasNull, /* TYPE WARNING: array array defaults to */ uint8_t * NullableOptionalListValue);
/**
 * @brief Test Cluster Cluster TestNestedStructArgumentRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestNestedStructArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestNestedStructArgumentRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster BooleanResponse Command callback (from server)
 */
bool emberAfTestClusterClusterBooleanResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj, bool value);
/**
 * @brief Test Cluster Cluster TestListStructArgumentRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestListStructArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestListStructArgumentRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster SimpleStructResponse Command callback (from server)
 */
bool emberAfTestClusterClusterSimpleStructResponseCallback(
    chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
    chip::app::Clusters::TestCluster::Structs::SimpleStruct::DecodableType arg1);
/**
 * @brief Test Cluster Cluster TestListInt8UArgumentRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestListInt8UArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestListInt8UArgumentRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestEmitTestEventResponse Command callback (from server)
 */
bool emberAfTestClusterClusterTestEmitTestEventResponseCallback(chip::EndpointId endpoint, chip::app::CommandSender * commandObj,
                                                                uint64_t value);
/**
 * @brief Test Cluster Cluster TestNestedStructListArgumentRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestNestedStructListArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestNestedStructListArgumentRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestEmitTestFabricScopedEventResponse Command callback (from server)
 */
bool emberAfTestClusterClusterTestEmitTestFabricScopedEventResponseCallback(chip::EndpointId endpoint,
                                                                            chip::app::CommandSender * commandObj, uint64_t value);
/**
 * @brief Test Cluster Cluster TestListNestedStructListArgumentRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestListNestedStructListArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestListNestedStructListArgumentRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestListInt8UReverseRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestListInt8UReverseRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestListInt8UReverseRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestEnumsRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestEnumsRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestEnumsRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestNullableOptionalRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestNullableOptionalRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestNullableOptionalRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestComplexNullableOptionalRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestComplexNullableOptionalRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestComplexNullableOptionalRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster SimpleStructEchoRequest Command callback (from client)
 */
bool emberAfTestClusterClusterSimpleStructEchoRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::SimpleStructEchoRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TimedInvokeRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTimedInvokeRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TimedInvokeRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestSimpleOptionalArgumentRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestSimpleOptionalArgumentRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestSimpleOptionalArgumentRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestEmitTestEventRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestEmitTestEventRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestEmitTestEventRequest::DecodableType & commandData);
/**
 * @brief Test Cluster Cluster TestEmitTestFabricScopedEventRequest Command callback (from client)
 */
bool emberAfTestClusterClusterTestEmitTestFabricScopedEventRequestCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::TestCluster::Commands::TestEmitTestFabricScopedEventRequest::DecodableType & commandData);
/**
 * @brief Fault Injection Cluster FailAtFault Command callback (from client)
 */
bool emberAfFaultInjectionClusterFailAtFaultCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::FaultInjection::Commands::FailAtFault::DecodableType & commandData);
/**
 * @brief Fault Injection Cluster FailRandomlyAtFault Command callback (from client)
 */
bool emberAfFaultInjectionClusterFailRandomlyAtFaultCallback(
    chip::app::CommandHandler * commandObj, const chip::app::ConcreteCommandPath & commandPath,
    const chip::app::Clusters::FaultInjection::Commands::FailRandomlyAtFault::DecodableType & commandData);

/** @brief Add To Current App Tasks
 *
 * This function is only useful to sleepy end devices.  This function will note
 * the passed item as part of a set of tasks the application has outstanding
 * (e.g. message sent requiring APS acknwoledgement).  This will affect how the
 * application behaves with regard to sleeping and polling.  Until the
 * outstanding task is completed, the device may poll more frequently and sleep
 * less often.
 */
void emberAfAddToCurrentAppTasksCallback(EmberAfApplicationTask tasks);

/** @brief Remove From Current App Tasks
 *
 * This function is only useful to sleepy end devices.  This function will
 * remove the passed item from the set of tasks the application has outstanding
 * (e.g. message sent requiring APS acknwoledgement).  This will affect how the
 * application behaves with regard to sleeping and polling.  Removing the item
 * from the list of outstanding tasks may allow the device to sleep longer and
 * poll less frequently.  If there are other outstanding tasks the system may
 * still have to stay away and poll more often.
 */
void emberAfRemoveFromCurrentAppTasksCallback(EmberAfApplicationTask tasks);

/** @brief Allow Network Write Attribute
 *
 * This function is called by the application framework before it writes an
 * attribute in response to a write attribute request from an external device.
 * The value passed into this callback is the value to which the attribute is to
 * be set by the framework.
        Example:	In mirroring simple metering data
 * on an Energy Services Interface (ESI) (formerly called Energy Service Portal
 * (ESP) in SE 1.0).), a mirrored simple meter needs to write read-only
 * attributes on its mirror. The-meter-mirror sample application, located in
 * app/framework/sample-apps, uses this callback to allow the mirrored device to
 * write simple metering attributes on the mirror regardless of the fact that
 * most simple metering attributes are defined as read-only by the ZigBee
 * specification.
        Note:	The ZCL specification does not (as of this
 * writing) specify any permission-level security for writing writeable
 * attributes. As far as the ZCL specification is concerned, if an attribute is
 * writeable, any device that has a link key for the device should be able to
 * write that attribute. Furthermore if an attribute is read only, it should not
 * be written over the air. Thus, if you implement permissions for writing
 * attributes as a feature, you MAY be operating outside the specification. This
 * is unlikely to be a problem for writing read-only attributes, but it may be a
 * problem for attributes that are writeable according to the specification but
 * restricted by the application implementing this callback.
 */
EmberAfAttributeWritePermission emberAfAllowNetworkWriteAttributeCallback(chip::EndpointId endpoint, chip::ClusterId clusterId,
                                                                          chip::AttributeId attributeId, uint8_t * value,
                                                                          uint8_t type);

/** @brief Attribute Read Access
 *
 * This function is called whenever the Application Framework needs to check
 * access permission for an attribute read.
 */
bool emberAfAttributeReadAccessCallback(chip::EndpointId endpoint, chip::ClusterId clusterId, chip::AttributeId attributeId);

/** @brief Attribute Write Access
 *
 * This function is called whenever the Application Framework needs to check
 * access permission for an attribute write.
 */
bool emberAfAttributeWriteAccessCallback(chip::EndpointId endpoint, chip::ClusterId clusterId, chip::AttributeId attributeId);

/** @brief Default Response
 *
 * This function is called by the application framework when a Default Response
 * command is received from an external device.  The application should return
 * true if the message was processed or false if it was not.
 *
 * @param clusterId The cluster identifier of this response.
 * @param commandId The command identifier to which this is a response.
 * @param status Specifies either SUCCESS or the nature of the error that was
 * detected in the received command.
 */
bool emberAfDefaultResponseCallback(chip::ClusterId clusterId, chip::CommandId commandId, EmberAfStatus status);

/** @brief Pre Message Send
 *
 * This function is called by the framework when it is about to pass a message
 * to the stack primitives for sending.   This message may or may not be ZCL,
 * ZDO, or some other protocol.  This is called prior to
        any ZigBee
 * fragmentation that may be done.  If the function returns true it is assumed
 * the callback has consumed and processed the message.  The callback must also
 * set the EmberStatus status code to be passed back to the caller.  The
 * framework will do no further processing on the message.
        If the
 * function returns false then it is assumed that the callback has not processed
 * the mesasge and the framework will continue to process accordingly.
 *
 * @param messageStruct The structure containing the parameters of the APS
 * message to be sent.
 * @param status A pointer to the status code value that will be returned to the
 * caller.
 */
bool emberAfPreMessageSendCallback(EmberAfMessageStruct * messageStruct, EmberStatus * status);

/** @brief Message Sent
 *
 * This function is called by the application framework from the message sent
 * handler, when it is informed by the stack regarding the message sent status.
 * All of the values passed to the emberMessageSentHandler are passed on to this
 * callback. This provides an opportunity for the application to verify that its
 * message has been sent successfully and take the appropriate action. This
 * callback should return a bool value of true or false. A value of true
 * indicates that the message sent notification has been handled and should not
 * be handled by the application framework.
 */
bool emberAfMessageSentCallback(const chip::MessageSendDestination & destination, EmberApsFrame * apsFrame, uint16_t msgLen,
                                uint8_t * message, EmberStatus status);

/** @brief External Attribute Read
 *
 * Like emberAfExternalAttributeWriteCallback above, this function is called
 * when the framework needs to read an attribute that is not stored within the
 * Application Framework's data structures.
        All of the important
 * information about the attribute itself is passed as a pointer to an
 * EmberAfAttributeMetadata struct, which is stored within the application and
 * used to manage the attribute. A complete description of the
 * EmberAfAttributeMetadata struct is provided in
 * app/framework/include/af-types.h
        This function assumes that the
 * application is able to read the attribute, write it into the passed buffer,
 * and return immediately. Any attributes that require a state machine for
 * reading and writing are not really candidates for externalization at the
 * present time. The Application Framework does not currently include a state
 * machine for reading or writing attributes that must take place across a
 * series of application ticks. Attributes that cannot be read in a timely
 * manner should be stored within the Application Framework and updated
 * occasionally by the application code from within the
 * emberAfMainTickCallback.
        If the application was successfully able to
 * read the attribute and write it into the passed buffer, it should return a
 * value of EMBER_ZCL_STATUS_SUCCESS. Ensure that the size of the externally
 * managed attribute value is smaller than what the buffer can hold. In the case
 * of a buffer overflow throw an appropriate error such as
 * EMBER_ZCL_STATUS_INSUFFICIENT_SPACE. Any other return value indicates the
 * application was not able to read the attribute.
 */
EmberAfStatus emberAfExternalAttributeReadCallback(chip::EndpointId endpoint, chip::ClusterId clusterId,
                                                   const EmberAfAttributeMetadata * attributeMetadata, uint8_t * buffer,
                                                   uint16_t maxReadLength);

/** @brief External Attribute Write
 *
 * This function is called whenever the Application Framework needs to write an
 * attribute which is not stored within the data structures of the Application
 * Framework itself. One of the new features in Version 2 is the ability to
 * store attributes outside the Framework. This is particularly useful for
 * attributes that do not need to be stored because they can be read off the
 * hardware when they are needed, or are stored in some central location used by
 * many modules within the system. In this case, you can indicate that the
 * attribute is stored externally. When the framework needs to write an external
 * attribute, it makes a call to this callback.
        This callback is very
 * useful for host micros which need to store attributes in persistent memory.
 * Because each host micro (used with an Ember NCP) has its own type of
 * persistent memory storage, the Application Framework does not include the
 * ability to mark attributes as stored in flash the way that it does for Ember
 * SoCs like the EM35x. On a host micro, any attributes that need to be stored
 * in persistent memory should be marked as external and accessed through the
 * external read and write callbacks. Any host code associated with the
 * persistent storage should be implemented within this callback.
        All of
 * the important information about the attribute itself is passed as a pointer
 * to an EmberAfAttributeMetadata struct, which is stored within the application
 * and used to manage the attribute. A complete description of the
 * EmberAfAttributeMetadata struct is provided in
 * app/framework/include/af-types.h.
        This function assumes that the
 * application is able to write the attribute and return immediately. Any
 * attributes that require a state machine for reading and writing are not
 * candidates for externalization at the present time. The Application Framework
 * does not currently include a state machine for reading or writing attributes
 * that must take place across a series of application ticks. Attributes that
 * cannot be written immediately should be stored within the Application
 * Framework and updated occasionally by the application code from within the
 * emberAfMainTickCallback.
        If the application was successfully able to
 * write the attribute, it returns a value of EMBER_ZCL_STATUS_SUCCESS. Any
 * other return value indicates the application was not able to write the
 * attribute.
 */
EmberAfStatus emberAfExternalAttributeWriteCallback(chip::EndpointId endpoint, chip::ClusterId clusterId,
                                                    const EmberAfAttributeMetadata * attributeMetadata, uint8_t * buffer);

/** @brief Get Current Time
 *
 * This callback is called when device attempts to get current time from the
 * hardware. If this device has means to retrieve exact time, then this method
 * should implement it. If the callback can't provide the exact time it should
 * return 0 to indicate failure. Default action is to return 0, which indicates
 * that device does not have access to real time.
 *
 */
uint32_t emberAfGetCurrentTimeCallback();

/** @brief Get Endpoint Info
 *
 * This function is a callback to an application implemented endpoint that
 * operates outside the normal application framework.  When the framework wishes
 * to perform operations with that endpoint it uses this callback to retrieve
 * the endpoint's information.  If the endpoint exists and the application can
 * provide data then true shall be returned.  Otherwise the callback must return
 * false.
 *
 * @param endpoint The endpoint to retrieve data for.  Ver.: always
 * @param returnNetworkIndex The index corresponding to the ZigBee network the
 * endpoint belongs to.  If not using a multi-network device, 0 must be
 * returned.  Otherwise on a multi-network device the stack will switch to this
 * network before sending the message.  Ver.: always
 * @param returnEndpointInfo A pointer to a data struct that will be written
 * with information about the endpoint.  Ver.: always
 */
bool emberAfGetEndpointInfoCallback(chip::EndpointId endpoint, uint8_t * returnNetworkIndex,
                                    EmberAfEndpointInfoStruct * returnEndpointInfo);

/** @brief Registration Abort
 *
 * This callback is called when the device should abort the registration
 * process.
 *
 */
void emberAfRegistrationAbortCallback();

/** @brief Interpan Send Message
 *
 * This function will send a raw MAC message with interpan frame format using
 * the passed parameters.
 *
 * @param header Interpan header info  Ver.: always
 * @param messageLength The length of the message received or to send  Ver.:
 * always
 * @param message The message data received or to send.  Ver.: always
 */
EmberStatus emberAfInterpanSendMessageCallback(EmberAfInterpanHeader * header, uint16_t messageLength, uint8_t * message);

/** @brief Start Move
 *
 * This function is called to initiate the process for a device to move (rejoin)
 * to a new parent.
 *
 */
bool emberAfStartMoveCallback();

/** @brief Pre Attribute Change
 *
 * This function is called by the application framework before it changes an
 * attribute value.  The value passed into this callback is the value to which
 * the attribute is to be set by the framework.  The application should return
 * chip::Protocols::InteractionModel::Status::Success to permit the change or
 * any other code to reject it.
 */
chip::Protocols::InteractionModel::Status MatterPreAttributeChangeCallback(const chip::app::ConcreteAttributePath & attributePath,
                                                                           uint8_t type, uint16_t size, uint8_t * value);

/** @brief Post Attribute Change
 *
 * This function is called by the application framework after it changes an
 * attribute value. The value passed into this callback is the value to which
 * the attribute was set by the framework.
 */
void MatterPostAttributeChangeCallback(const chip::app::ConcreteAttributePath & attributePath, uint8_t type, uint16_t size,
                                       uint8_t * value);
