/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#pragma once

#include <app-common/zap-generated/cluster-enums.h>

namespace chip {
namespace app {
namespace Clusters {
static auto __attribute__((unused)) EnsureKnownEnumValue(Identify::IdentifyEffectIdentifier val)
{
    using EnumType = Identify::IdentifyEffectIdentifier;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kBlink:
    case EnumType::kBreathe:
    case EnumType::kOkay:
    case EnumType::kChannelChange:
    case EnumType::kFinishEffect:
    case EnumType::kStopEffect:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_BLINK:
    case EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_BREATHE:
    case EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_OKAY:
    case EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_CHANNEL_CHANGE:
    case EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_FINISH_EFFECT:
    case EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_STOP_EFFECT:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Identify::IdentifyEffectVariant val)
{
    using EnumType = Identify::IdentifyEffectVariant;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kDefault:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_IDENTIFY_EFFECT_VARIANT_DEFAULT:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(1);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Identify::IdentifyIdentifyType val)
{
    using EnumType = Identify::IdentifyIdentifyType;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kNone:
    case EnumType::kVisibleLight:
    case EnumType::kVisibleLED:
    case EnumType::kAudibleBeep:
    case EnumType::kDisplay:
    case EnumType::kActuator:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_NONE:
    case EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_VISIBLE_LIGHT:
    case EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_VISIBLE_LED:
    case EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_AUDIBLE_BEEP:
    case EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_DISPLAY:
    case EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_ACTUATOR:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(6);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OnOff::OnOffDelayedAllOffEffectVariant val)
{
    using EnumType = OnOff::OnOffDelayedAllOffEffectVariant;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kFadeToOffIn0p8Seconds:
    case EnumType::kNoFade:
    case EnumType::k50PercentDimDownIn0p8SecondsThenFadeToOffIn12Seconds:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_ON_OFF_DELAYED_ALL_OFF_EFFECT_VARIANT_FADE_TO_OFF_IN_0P8_SECONDS:
    case EMBER_ZCL_ON_OFF_DELAYED_ALL_OFF_EFFECT_VARIANT_NO_FADE:
    case EMBER_ZCL_ON_OFF_DELAYED_ALL_OFF_EFFECT_VARIANT_50_PERCENT_DIM_DOWN_IN_0P8_SECONDS_THEN_FADE_TO_OFF_IN_12_SECONDS:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OnOff::OnOffDyingLightEffectVariant val)
{
    using EnumType = OnOff::OnOffDyingLightEffectVariant;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::k20PercenterDimUpIn0p5SecondsThenFadeToOffIn1Second:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_ON_OFF_DYING_LIGHT_EFFECT_VARIANT_20_PERCENTER_DIM_UP_IN_0P5_SECONDS_THEN_FADE_TO_OFF_IN_1_SECOND:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(1);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OnOff::OnOffEffectIdentifier val)
{
    using EnumType = OnOff::OnOffEffectIdentifier;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kDelayedAllOff:
    case EnumType::kDyingLight:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_ON_OFF_EFFECT_IDENTIFIER_DELAYED_ALL_OFF:
    case EMBER_ZCL_ON_OFF_EFFECT_IDENTIFIER_DYING_LIGHT:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OnOff::OnOffStartUpOnOff val)
{
    using EnumType = OnOff::OnOffStartUpOnOff;
    switch (val)
    {
    case EnumType::kOff:
    case EnumType::kOn:
    case EnumType::kTogglePreviousOnOff:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(LevelControl::MoveMode val)
{
    using EnumType = LevelControl::MoveMode;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kUp:
    case EnumType::kDown:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_MOVE_MODE_UP:
    case EMBER_ZCL_MOVE_MODE_DOWN:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(LevelControl::StepMode val)
{
    using EnumType = LevelControl::StepMode;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kUp:
    case EnumType::kDown:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_STEP_MODE_UP:
    case EMBER_ZCL_STEP_MODE_DOWN:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(AccessControl::AuthMode val)
{
    using EnumType = AccessControl::AuthMode;
    switch (val)
    {
    case EnumType::kPase:
    case EnumType::kCase:
    case EnumType::kGroup:
        return val;
    default:
        return static_cast<EnumType>(0);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(AccessControl::ChangeTypeEnum val)
{
    using EnumType = AccessControl::ChangeTypeEnum;
    switch (val)
    {
    case EnumType::kChanged:
    case EnumType::kAdded:
    case EnumType::kRemoved:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(AccessControl::Privilege val)
{
    using EnumType = AccessControl::Privilege;
    switch (val)
    {
    case EnumType::kView:
    case EnumType::kProxyView:
    case EnumType::kOperate:
    case EnumType::kManage:
    case EnumType::kAdminister:
        return val;
    default:
        return static_cast<EnumType>(0);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Actions::ActionErrorEnum val)
{
    using EnumType = Actions::ActionErrorEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kInterrupted:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Actions::ActionStateEnum val)
{
    using EnumType = Actions::ActionStateEnum;
    switch (val)
    {
    case EnumType::kInactive:
    case EnumType::kActive:
    case EnumType::kPaused:
    case EnumType::kDisabled:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Actions::ActionTypeEnum val)
{
    using EnumType = Actions::ActionTypeEnum;
    switch (val)
    {
    case EnumType::kOther:
    case EnumType::kScene:
    case EnumType::kSequence:
    case EnumType::kAutomation:
    case EnumType::kException:
    case EnumType::kNotification:
    case EnumType::kAlarm:
        return val;
    default:
        return static_cast<EnumType>(7);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Actions::EndpointListTypeEnum val)
{
    using EnumType = Actions::EndpointListTypeEnum;
    switch (val)
    {
    case EnumType::kOther:
    case EnumType::kRoom:
    case EnumType::kZone:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateProvider::OTAApplyUpdateAction val)
{
    using EnumType = OtaSoftwareUpdateProvider::OTAApplyUpdateAction;
    switch (val)
    {
    case EnumType::kProceed:
    case EnumType::kAwaitNextAction:
    case EnumType::kDiscontinue:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateProvider::OTADownloadProtocol val)
{
    using EnumType = OtaSoftwareUpdateProvider::OTADownloadProtocol;
    switch (val)
    {
    case EnumType::kBDXSynchronous:
    case EnumType::kBDXAsynchronous:
    case EnumType::kHttps:
    case EnumType::kVendorSpecific:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateProvider::OTAQueryStatus val)
{
    using EnumType = OtaSoftwareUpdateProvider::OTAQueryStatus;
    switch (val)
    {
    case EnumType::kUpdateAvailable:
    case EnumType::kBusy:
    case EnumType::kNotAvailable:
    case EnumType::kDownloadProtocolNotSupported:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateRequestor::OTAAnnouncementReason val)
{
    using EnumType = OtaSoftwareUpdateRequestor::OTAAnnouncementReason;
    switch (val)
    {
    case EnumType::kSimpleAnnouncement:
    case EnumType::kUpdateAvailable:
    case EnumType::kUrgentUpdateAvailable:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateRequestor::OTAChangeReasonEnum val)
{
    using EnumType = OtaSoftwareUpdateRequestor::OTAChangeReasonEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kSuccess:
    case EnumType::kFailure:
    case EnumType::kTimeOut:
    case EnumType::kDelayByProvider:
        return val;
    default:
        return static_cast<EnumType>(5);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(OtaSoftwareUpdateRequestor::OTAUpdateStateEnum val)
{
    using EnumType = OtaSoftwareUpdateRequestor::OTAUpdateStateEnum;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kIdle:
    case EnumType::kQuerying:
    case EnumType::kDelayedOnQuery:
    case EnumType::kDownloading:
    case EnumType::kApplying:
    case EnumType::kDelayedOnApply:
    case EnumType::kRollingBack:
    case EnumType::kDelayedOnUserConsent:
        return val;
    default:
        return static_cast<EnumType>(9);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(TimeFormatLocalization::CalendarType val)
{
    using EnumType = TimeFormatLocalization::CalendarType;
    switch (val)
    {
    case EnumType::kBuddhist:
    case EnumType::kChinese:
    case EnumType::kCoptic:
    case EnumType::kEthiopian:
    case EnumType::kGregorian:
    case EnumType::kHebrew:
    case EnumType::kIndian:
    case EnumType::kIslamic:
    case EnumType::kJapanese:
    case EnumType::kKorean:
    case EnumType::kPersian:
    case EnumType::kTaiwanese:
        return val;
    default:
        return static_cast<EnumType>(12);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(TimeFormatLocalization::HourFormat val)
{
    using EnumType = TimeFormatLocalization::HourFormat;
    switch (val)
    {
    case EnumType::k12hr:
    case EnumType::k24hr:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(UnitLocalization::TempUnit val)
{
    using EnumType = UnitLocalization::TempUnit;
    switch (val)
    {
    case EnumType::kFahrenheit:
    case EnumType::kCelsius:
    case EnumType::kKelvin:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatChargeFault val)
{
    using EnumType = PowerSource::BatChargeFault;
    switch (val)
    {
    case EnumType::kUnspecfied:
    case EnumType::kAmbientTooHot:
    case EnumType::kAmbientTooCold:
    case EnumType::kBatteryTooHot:
    case EnumType::kBatteryTooCold:
    case EnumType::kBatteryAbsent:
    case EnumType::kBatteryOverVoltage:
    case EnumType::kBatteryUnderVoltage:
    case EnumType::kChargerOverVoltage:
    case EnumType::kChargerUnderVoltage:
    case EnumType::kSafetyTimeout:
        return val;
    default:
        return static_cast<EnumType>(11);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatChargeLevel val)
{
    using EnumType = PowerSource::BatChargeLevel;
    switch (val)
    {
    case EnumType::kOk:
    case EnumType::kWarning:
    case EnumType::kCritical:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatChargeState val)
{
    using EnumType = PowerSource::BatChargeState;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kIsCharging:
    case EnumType::kIsAtFullCharge:
    case EnumType::kIsNotCharging:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatFault val)
{
    using EnumType = PowerSource::BatFault;
    switch (val)
    {
    case EnumType::kUnspecfied:
    case EnumType::kOverTemp:
    case EnumType::kUnderTemp:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::BatReplaceability val)
{
    using EnumType = PowerSource::BatReplaceability;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kNotReplaceable:
    case EnumType::kUserReplaceable:
    case EnumType::kFactoryReplaceable:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::PowerSourceStatus val)
{
    using EnumType = PowerSource::PowerSourceStatus;
    switch (val)
    {
    case EnumType::kUnspecfied:
    case EnumType::kActive:
    case EnumType::kStandby:
    case EnumType::kUnavailable:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::WiredCurrentType val)
{
    using EnumType = PowerSource::WiredCurrentType;
    switch (val)
    {
    case EnumType::kAc:
    case EnumType::kDc:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PowerSource::WiredFault val)
{
    using EnumType = PowerSource::WiredFault;
    switch (val)
    {
    case EnumType::kUnspecfied:
    case EnumType::kOverVoltage:
    case EnumType::kUnderVoltage:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralCommissioning::CommissioningError val)
{
    using EnumType = GeneralCommissioning::CommissioningError;
    switch (val)
    {
    case EnumType::kOk:
    case EnumType::kValueOutsideRange:
    case EnumType::kInvalidAuthentication:
    case EnumType::kNoFailSafe:
    case EnumType::kBusyWithOtherAdmin:
        return val;
    default:
        return static_cast<EnumType>(5);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralCommissioning::RegulatoryLocationType val)
{
    using EnumType = GeneralCommissioning::RegulatoryLocationType;
    switch (val)
    {
    case EnumType::kIndoor:
    case EnumType::kOutdoor:
    case EnumType::kIndoorOutdoor:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(NetworkCommissioning::NetworkCommissioningStatus val)
{
    using EnumType = NetworkCommissioning::NetworkCommissioningStatus;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kOutOfRange:
    case EnumType::kBoundsExceeded:
    case EnumType::kNetworkIDNotFound:
    case EnumType::kDuplicateNetworkID:
    case EnumType::kNetworkNotFound:
    case EnumType::kRegulatoryError:
    case EnumType::kAuthFailure:
    case EnumType::kUnsupportedSecurity:
    case EnumType::kOtherConnectionFailure:
    case EnumType::kIPV6Failed:
    case EnumType::kIPBindFailed:
    case EnumType::kUnknownError:
        return val;
    default:
        return static_cast<EnumType>(13);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(NetworkCommissioning::WiFiBand val)
{
    using EnumType = NetworkCommissioning::WiFiBand;
    switch (val)
    {
    case EnumType::k2g4:
    case EnumType::k3g65:
    case EnumType::k5g:
    case EnumType::k6g:
    case EnumType::k60g:
        return val;
    default:
        return static_cast<EnumType>(5);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(DiagnosticLogs::LogsIntent val)
{
    using EnumType = DiagnosticLogs::LogsIntent;
    switch (val)
    {
    case EnumType::kEndUserSupport:
    case EnumType::kNetworkDiag:
    case EnumType::kCrashLogs:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DiagnosticLogs::LogsStatus val)
{
    using EnumType = DiagnosticLogs::LogsStatus;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kExhausted:
    case EnumType::kNoLogs:
    case EnumType::kBusy:
    case EnumType::kDenied:
        return val;
    default:
        return static_cast<EnumType>(5);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DiagnosticLogs::LogsTransferProtocol val)
{
    using EnumType = DiagnosticLogs::LogsTransferProtocol;
    switch (val)
    {
    case EnumType::kResponsePayload:
    case EnumType::kBdx:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralDiagnostics::BootReasonType val)
{
    using EnumType = GeneralDiagnostics::BootReasonType;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kPowerOnReboot:
    case EnumType::kBrownOutReset:
    case EnumType::kSoftwareWatchdogReset:
    case EnumType::kHardwareWatchdogReset:
    case EnumType::kSoftwareUpdateCompleted:
    case EnumType::kSoftwareReset:
        return val;
    default:
        return static_cast<EnumType>(7);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralDiagnostics::HardwareFaultType val)
{
    using EnumType = GeneralDiagnostics::HardwareFaultType;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kUnspecified:
    case EnumType::kRadio:
    case EnumType::kSensor:
    case EnumType::kResettableOverTemp:
    case EnumType::kNonResettableOverTemp:
    case EnumType::kPowerSource:
    case EnumType::kVisualDisplayFault:
    case EnumType::kAudioOutputFault:
    case EnumType::kUserInterfaceFault:
    case EnumType::kNonVolatileMemoryError:
    case EnumType::kTamperDetected:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_HARDWARE_FAULT_TYPE_UNSPECIFIED:
    case EMBER_ZCL_HARDWARE_FAULT_TYPE_RADIO:
    case EMBER_ZCL_HARDWARE_FAULT_TYPE_SENSOR:
    case EMBER_ZCL_HARDWARE_FAULT_TYPE_RESETTABLE_OVER_TEMP:
    case EMBER_ZCL_HARDWARE_FAULT_TYPE_NON_RESETTABLE_OVER_TEMP:
    case EMBER_ZCL_HARDWARE_FAULT_TYPE_POWER_SOURCE:
    case EMBER_ZCL_HARDWARE_FAULT_TYPE_VISUAL_DISPLAY_FAULT:
    case EMBER_ZCL_HARDWARE_FAULT_TYPE_AUDIO_OUTPUT_FAULT:
    case EMBER_ZCL_HARDWARE_FAULT_TYPE_USER_INTERFACE_FAULT:
    case EMBER_ZCL_HARDWARE_FAULT_TYPE_NON_VOLATILE_MEMORY_ERROR:
    case EMBER_ZCL_HARDWARE_FAULT_TYPE_TAMPER_DETECTED:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(11);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralDiagnostics::InterfaceType val)
{
    using EnumType = GeneralDiagnostics::InterfaceType;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kUnspecified:
    case EnumType::kWiFi:
    case EnumType::kEthernet:
    case EnumType::kCellular:
    case EnumType::kThread:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_INTERFACE_TYPE_UNSPECIFIED:
    case EMBER_ZCL_INTERFACE_TYPE_WI_FI:
    case EMBER_ZCL_INTERFACE_TYPE_ETHERNET:
    case EMBER_ZCL_INTERFACE_TYPE_CELLULAR:
    case EMBER_ZCL_INTERFACE_TYPE_THREAD:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(5);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralDiagnostics::NetworkFaultType val)
{
    using EnumType = GeneralDiagnostics::NetworkFaultType;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kUnspecified:
    case EnumType::kHardwareFailure:
    case EnumType::kNetworkJammed:
    case EnumType::kConnectionFailed:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_NETWORK_FAULT_TYPE_UNSPECIFIED:
    case EMBER_ZCL_NETWORK_FAULT_TYPE_HARDWARE_FAILURE:
    case EMBER_ZCL_NETWORK_FAULT_TYPE_NETWORK_JAMMED:
    case EMBER_ZCL_NETWORK_FAULT_TYPE_CONNECTION_FAILED:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(GeneralDiagnostics::RadioFaultType val)
{
    using EnumType = GeneralDiagnostics::RadioFaultType;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kUnspecified:
    case EnumType::kWiFiFault:
    case EnumType::kCellularFault:
    case EnumType::kThreadFault:
    case EnumType::kNFCFault:
    case EnumType::kBLEFault:
    case EnumType::kEthernetFault:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_RADIO_FAULT_TYPE_UNSPECIFIED:
    case EMBER_ZCL_RADIO_FAULT_TYPE_WI_FI_FAULT:
    case EMBER_ZCL_RADIO_FAULT_TYPE_CELLULAR_FAULT:
    case EMBER_ZCL_RADIO_FAULT_TYPE_THREAD_FAULT:
    case EMBER_ZCL_RADIO_FAULT_TYPE_NFC_FAULT:
    case EMBER_ZCL_RADIO_FAULT_TYPE_BLE_FAULT:
    case EMBER_ZCL_RADIO_FAULT_TYPE_ETHERNET_FAULT:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(7);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ThreadNetworkDiagnostics::NetworkFault val)
{
    using EnumType = ThreadNetworkDiagnostics::NetworkFault;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kLinkDown:
    case EnumType::kHardwareFailure:
    case EnumType::kNetworkJammed:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ThreadNetworkDiagnostics::RoutingRole val)
{
    using EnumType = ThreadNetworkDiagnostics::RoutingRole;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kUnspecified:
    case EnumType::kUnassigned:
    case EnumType::kSleepyEndDevice:
    case EnumType::kEndDevice:
    case EnumType::kReed:
    case EnumType::kRouter:
    case EnumType::kLeader:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_ROUTING_ROLE_UNSPECIFIED:
    case EMBER_ZCL_ROUTING_ROLE_UNASSIGNED:
    case EMBER_ZCL_ROUTING_ROLE_SLEEPY_END_DEVICE:
    case EMBER_ZCL_ROUTING_ROLE_END_DEVICE:
    case EMBER_ZCL_ROUTING_ROLE_REED:
    case EMBER_ZCL_ROUTING_ROLE_ROUTER:
    case EMBER_ZCL_ROUTING_ROLE_LEADER:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(7);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ThreadNetworkDiagnostics::ThreadConnectionStatus val)
{
    using EnumType = ThreadNetworkDiagnostics::ThreadConnectionStatus;
    switch (val)
    {
    case EnumType::kConnected:
    case EnumType::kNotConnected:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(WiFiNetworkDiagnostics::AssociationFailureCause val)
{
    using EnumType = WiFiNetworkDiagnostics::AssociationFailureCause;
    switch (val)
    {
    case EnumType::kUnknown:
    case EnumType::kAssociationFailed:
    case EnumType::kAuthenticationFailed:
    case EnumType::kSsidNotFound:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(WiFiNetworkDiagnostics::SecurityType val)
{
    using EnumType = WiFiNetworkDiagnostics::SecurityType;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kUnspecified:
    case EnumType::kNone:
    case EnumType::kWep:
    case EnumType::kWpa:
    case EnumType::kWpa2:
    case EnumType::kWpa3:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_SECURITY_TYPE_UNSPECIFIED:
    case EMBER_ZCL_SECURITY_TYPE_NONE:
    case EMBER_ZCL_SECURITY_TYPE_WEP:
    case EMBER_ZCL_SECURITY_TYPE_WPA:
    case EMBER_ZCL_SECURITY_TYPE_WPA2:
    case EMBER_ZCL_SECURITY_TYPE_WPA3:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(6);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(WiFiNetworkDiagnostics::WiFiConnectionStatus val)
{
    using EnumType = WiFiNetworkDiagnostics::WiFiConnectionStatus;
    switch (val)
    {
    case EnumType::kConnected:
    case EnumType::kNotConnected:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(WiFiNetworkDiagnostics::WiFiVersionType val)
{
    using EnumType = WiFiNetworkDiagnostics::WiFiVersionType;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::k80211a:
    case EnumType::k80211b:
    case EnumType::k80211g:
    case EnumType::k80211n:
    case EnumType::k80211ac:
    case EnumType::k80211ax:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_WI_FI_VERSION_TYPE_802__11A:
    case EMBER_ZCL_WI_FI_VERSION_TYPE_802__11B:
    case EMBER_ZCL_WI_FI_VERSION_TYPE_802__11G:
    case EMBER_ZCL_WI_FI_VERSION_TYPE_802__11N:
    case EMBER_ZCL_WI_FI_VERSION_TYPE_802__11AC:
    case EMBER_ZCL_WI_FI_VERSION_TYPE_802__11AX:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(6);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(EthernetNetworkDiagnostics::PHYRateType val)
{
    using EnumType = EthernetNetworkDiagnostics::PHYRateType;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::k10m:
    case EnumType::k100m:
    case EnumType::k1000m:
    case EnumType::k25g:
    case EnumType::k5g:
    case EnumType::k10g:
    case EnumType::k40g:
    case EnumType::k100g:
    case EnumType::k200g:
    case EnumType::k400g:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_PHY_RATE_TYPE_10_M:
    case EMBER_ZCL_PHY_RATE_TYPE_100_M:
    case EMBER_ZCL_PHY_RATE_TYPE_1000_M:
    case EMBER_ZCL_PHY_RATE_TYPE_2__5_G:
    case EMBER_ZCL_PHY_RATE_TYPE_5_G:
    case EMBER_ZCL_PHY_RATE_TYPE_10_G:
    case EMBER_ZCL_PHY_RATE_TYPE_40_G:
    case EMBER_ZCL_PHY_RATE_TYPE_100_G:
    case EMBER_ZCL_PHY_RATE_TYPE_200_G:
    case EMBER_ZCL_PHY_RATE_TYPE_400_G:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(10);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(TimeSynchronization::GranularityEnum val)
{
    using EnumType = TimeSynchronization::GranularityEnum;
    switch (val)
    {
    case EnumType::kNoTimeGranularity:
    case EnumType::kMinutesGranularity:
    case EnumType::kSecondsGranularity:
    case EnumType::kMillisecondsGranularity:
    case EnumType::kMicrosecondsGranularity:
        return val;
    default:
        return static_cast<EnumType>(5);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(TimeSynchronization::TimeSourceEnum val)
{
    using EnumType = TimeSynchronization::TimeSourceEnum;
    switch (val)
    {
    case EnumType::kNone:
    case EnumType::kUnknown:
    case EnumType::kAdmin:
    case EnumType::kNodeTimeCluster:
    case EnumType::kNonFabricSntp:
    case EnumType::kNonFabricNtp:
    case EnumType::kFabricSntp:
    case EnumType::kFabricNtp:
    case EnumType::kMixedNtp:
    case EnumType::kNonFabricSntpNts:
    case EnumType::kNonFabricNtpNts:
    case EnumType::kFabricSntpNts:
    case EnumType::kFabricNtpNts:
    case EnumType::kMixedNtpNts:
    case EnumType::kCloudSource:
    case EnumType::kPtp:
    case EnumType::kGnss:
        return val;
    default:
        return static_cast<EnumType>(17);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(AdministratorCommissioning::CommissioningWindowStatus val)
{
    using EnumType = AdministratorCommissioning::CommissioningWindowStatus;
    switch (val)
    {
    case EnumType::kWindowNotOpen:
    case EnumType::kEnhancedWindowOpen:
    case EnumType::kBasicWindowOpen:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(AdministratorCommissioning::StatusCode val)
{
    using EnumType = AdministratorCommissioning::StatusCode;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kBusy:
    case EnumType::kPAKEParameterError:
    case EnumType::kWindowNotOpen:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_STATUS_CODE_BUSY:
    case EMBER_ZCL_STATUS_CODE_PAKE_PARAMETER_ERROR:
    case EMBER_ZCL_STATUS_CODE_WINDOW_NOT_OPEN:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(0);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(OperationalCredentials::OperationalCertStatus val)
{
    using EnumType = OperationalCredentials::OperationalCertStatus;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kInvalidPublicKey:
    case EnumType::kInvalidNodeOpId:
    case EnumType::kInvalidNOC:
    case EnumType::kMissingCsr:
    case EnumType::kTableFull:
    case EnumType::kInvalidAdminSubject:
    case EnumType::kFabricConflict:
    case EnumType::kLabelConflict:
    case EnumType::kInvalidFabricIndex:
        return val;
    default:
        return static_cast<EnumType>(7);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(GroupKeyManagement::GroupKeySecurityPolicy val)
{
    using EnumType = GroupKeyManagement::GroupKeySecurityPolicy;
    switch (val)
    {
    case EnumType::kTrustFirst:
    case EnumType::kCacheAndSync:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlAlarmCode val)
{
    using EnumType = DoorLock::DlAlarmCode;
    switch (val)
    {
    case EnumType::kLockJammed:
    case EnumType::kLockFactoryReset:
    case EnumType::kLockRadioPowerCycled:
    case EnumType::kWrongCodeEntryLimit:
    case EnumType::kFrontEsceutcheonRemoved:
    case EnumType::kDoorForcedOpen:
    case EnumType::kDoorAjar:
    case EnumType::kForcedUser:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlCredentialRule val)
{
    using EnumType = DoorLock::DlCredentialRule;
    switch (val)
    {
    case EnumType::kSingle:
    case EnumType::kDouble:
    case EnumType::kTri:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlCredentialType val)
{
    using EnumType = DoorLock::DlCredentialType;
    switch (val)
    {
    case EnumType::kProgrammingPIN:
    case EnumType::kPin:
    case EnumType::kRfid:
    case EnumType::kFingerprint:
    case EnumType::kFingerVein:
    case EnumType::kFace:
        return val;
    default:
        return static_cast<EnumType>(6);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlDataOperationType val)
{
    using EnumType = DoorLock::DlDataOperationType;
    switch (val)
    {
    case EnumType::kAdd:
    case EnumType::kClear:
    case EnumType::kModify:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlDoorState val)
{
    using EnumType = DoorLock::DlDoorState;
    switch (val)
    {
    case EnumType::kDoorOpen:
    case EnumType::kDoorClosed:
    case EnumType::kDoorJammed:
    case EnumType::kDoorForcedOpen:
    case EnumType::kDoorUnspecifiedError:
    case EnumType::kDoorAjar:
        return val;
    default:
        return static_cast<EnumType>(6);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlLockDataType val)
{
    using EnumType = DoorLock::DlLockDataType;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kProgrammingCode:
    case EnumType::kUserIndex:
    case EnumType::kWeekDaySchedule:
    case EnumType::kYearDaySchedule:
    case EnumType::kHolidaySchedule:
    case EnumType::kPin:
    case EnumType::kRfid:
    case EnumType::kFingerprint:
        return val;
    default:
        return static_cast<EnumType>(9);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlLockOperationType val)
{
    using EnumType = DoorLock::DlLockOperationType;
    switch (val)
    {
    case EnumType::kLock:
    case EnumType::kUnlock:
    case EnumType::kNonAccessUserEvent:
    case EnumType::kForcedUserEvent:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlLockState val)
{
    using EnumType = DoorLock::DlLockState;
    switch (val)
    {
    case EnumType::kNotFullyLocked:
    case EnumType::kLocked:
    case EnumType::kUnlocked:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlLockType val)
{
    using EnumType = DoorLock::DlLockType;
    switch (val)
    {
    case EnumType::kDeadBolt:
    case EnumType::kMagnetic:
    case EnumType::kOther:
    case EnumType::kMortise:
    case EnumType::kRim:
    case EnumType::kLatchBolt:
    case EnumType::kCylindricalLock:
    case EnumType::kTubularLock:
    case EnumType::kInterconnectedLock:
    case EnumType::kDeadLatch:
    case EnumType::kDoorFurniture:
        return val;
    default:
        return static_cast<EnumType>(11);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlOperatingMode val)
{
    using EnumType = DoorLock::DlOperatingMode;
    switch (val)
    {
    case EnumType::kNormal:
    case EnumType::kVacation:
    case EnumType::kPrivacy:
    case EnumType::kNoRemoteLockUnlock:
    case EnumType::kPassage:
        return val;
    default:
        return static_cast<EnumType>(5);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlOperationError val)
{
    using EnumType = DoorLock::DlOperationError;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kInvalidCredential:
    case EnumType::kDisabledUserDenied:
    case EnumType::kRestricted:
    case EnumType::kInsufficientBattery:
        return val;
    default:
        return static_cast<EnumType>(5);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlOperationSource val)
{
    using EnumType = DoorLock::DlOperationSource;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kManual:
    case EnumType::kProprietaryRemote:
    case EnumType::kKeypad:
    case EnumType::kAuto:
    case EnumType::kButton:
    case EnumType::kSchedule:
    case EnumType::kRemote:
    case EnumType::kRfid:
    case EnumType::kBiometric:
        return val;
    default:
        return static_cast<EnumType>(10);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlStatus val)
{
    using EnumType = DoorLock::DlStatus;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kFailure:
    case EnumType::kDuplicate:
    case EnumType::kOccupied:
    case EnumType::kInvalidField:
    case EnumType::kResourceExhausted:
    case EnumType::kNotFound:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlUserStatus val)
{
    using EnumType = DoorLock::DlUserStatus;
    switch (val)
    {
    case EnumType::kAvailable:
    case EnumType::kOccupiedEnabled:
    case EnumType::kOccupiedDisabled:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DlUserType val)
{
    using EnumType = DoorLock::DlUserType;
    switch (val)
    {
    case EnumType::kUnrestrictedUser:
    case EnumType::kYearDayScheduleUser:
    case EnumType::kWeekDayScheduleUser:
    case EnumType::kProgrammingUser:
    case EnumType::kNonAccessUser:
    case EnumType::kForcedUser:
    case EnumType::kDisposableUser:
    case EnumType::kExpiringUser:
    case EnumType::kScheduleRestrictedUser:
    case EnumType::kRemoteOnlyUser:
        return val;
    default:
        return static_cast<EnumType>(10);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DoorLockOperationEventCode val)
{
    using EnumType = DoorLock::DoorLockOperationEventCode;
    switch (val)
    {
    case EnumType::kUnknownOrMfgSpecific:
    case EnumType::kLock:
    case EnumType::kUnlock:
    case EnumType::kLockInvalidPinOrId:
    case EnumType::kLockInvalidSchedule:
    case EnumType::kUnlockInvalidPinOrId:
    case EnumType::kUnlockInvalidSchedule:
    case EnumType::kOneTouchLock:
    case EnumType::kKeyLock:
    case EnumType::kKeyUnlock:
    case EnumType::kAutoLock:
    case EnumType::kScheduleLock:
    case EnumType::kScheduleUnlock:
    case EnumType::kManualLock:
    case EnumType::kManualUnlock:
        return val;
    default:
        return static_cast<EnumType>(15);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DoorLockProgrammingEventCode val)
{
    using EnumType = DoorLock::DoorLockProgrammingEventCode;
    switch (val)
    {
    case EnumType::kUnknownOrMfgSpecific:
    case EnumType::kMasterCodeChanged:
    case EnumType::kPinAdded:
    case EnumType::kPinDeleted:
    case EnumType::kPinChanged:
    case EnumType::kIdAdded:
    case EnumType::kIdDeleted:
        return val;
    default:
        return static_cast<EnumType>(7);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DoorLockSetPinOrIdStatus val)
{
    using EnumType = DoorLock::DoorLockSetPinOrIdStatus;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kGeneralFailure:
    case EnumType::kMemoryFull:
    case EnumType::kDuplicateCodeError:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DoorLockUserStatus val)
{
    using EnumType = DoorLock::DoorLockUserStatus;
    switch (val)
    {
    case EnumType::kAvailable:
    case EnumType::kOccupiedEnabled:
    case EnumType::kOccupiedDisabled:
    case EnumType::kNotSupported:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(DoorLock::DoorLockUserType val)
{
    using EnumType = DoorLock::DoorLockUserType;
    switch (val)
    {
    case EnumType::kUnrestricted:
    case EnumType::kYearDayScheduleUser:
    case EnumType::kWeekDayScheduleUser:
    case EnumType::kMasterUser:
    case EnumType::kNonAccessUser:
    case EnumType::kNotSupported:
        return val;
    default:
        return static_cast<EnumType>(5);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(WindowCovering::EndProductType val)
{
    using EnumType = WindowCovering::EndProductType;
    switch (val)
    {
    case EnumType::kRollerShade:
    case EnumType::kRomanShade:
    case EnumType::kBalloonShade:
    case EnumType::kWovenWood:
    case EnumType::kPleatedShade:
    case EnumType::kCellularShade:
    case EnumType::kLayeredShade:
    case EnumType::kLayeredShade2D:
    case EnumType::kSheerShade:
    case EnumType::kTiltOnlyInteriorBlind:
    case EnumType::kInteriorBlind:
    case EnumType::kVerticalBlindStripCurtain:
    case EnumType::kInteriorVenetianBlind:
    case EnumType::kExteriorVenetianBlind:
    case EnumType::kLateralLeftCurtain:
    case EnumType::kLateralRightCurtain:
    case EnumType::kCentralCurtain:
    case EnumType::kRollerShutter:
    case EnumType::kExteriorVerticalScreen:
    case EnumType::kAwningTerracePatio:
    case EnumType::kAwningVerticalScreen:
    case EnumType::kTiltOnlyPergola:
    case EnumType::kSwingingShutter:
    case EnumType::kSlidingShutter:
    case EnumType::kUnknown:
        return val;
    default:
        return static_cast<EnumType>(24);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(WindowCovering::Type val)
{
    using EnumType = WindowCovering::Type;
    switch (val)
    {
    case EnumType::kRollerShade:
    case EnumType::kRollerShade2Motor:
    case EnumType::kRollerShadeExterior:
    case EnumType::kRollerShadeExterior2Motor:
    case EnumType::kDrapery:
    case EnumType::kAwning:
    case EnumType::kShutter:
    case EnumType::kTiltBlindTiltOnly:
    case EnumType::kTiltBlindLiftAndTilt:
    case EnumType::kProjectorScreen:
    case EnumType::kUnknown:
        return val;
    default:
        return static_cast<EnumType>(10);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(PumpConfigurationAndControl::PumpControlMode val)
{
    using EnumType = PumpConfigurationAndControl::PumpControlMode;
    switch (val)
    {
    case EnumType::kConstantSpeed:
    case EnumType::kConstantPressure:
    case EnumType::kProportionalPressure:
    case EnumType::kConstantFlow:
    case EnumType::kConstantTemperature:
    case EnumType::kAutomatic:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(PumpConfigurationAndControl::PumpOperationMode val)
{
    using EnumType = PumpConfigurationAndControl::PumpOperationMode;
    switch (val)
    {
    case EnumType::kNormal:
    case EnumType::kMinimum:
    case EnumType::kMaximum:
    case EnumType::kLocal:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::SetpointAdjustMode val)
{
    using EnumType = Thermostat::SetpointAdjustMode;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kHeatSetpoint:
    case EnumType::kCoolSetpoint:
    case EnumType::kHeatAndCoolSetpoints:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_SETPOINT_ADJUST_MODE_HEAT_SETPOINT:
    case EMBER_ZCL_SETPOINT_ADJUST_MODE_COOL_SETPOINT:
    case EMBER_ZCL_SETPOINT_ADJUST_MODE_HEAT_AND_COOL_SETPOINTS:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::ThermostatControlSequence val)
{
    using EnumType = Thermostat::ThermostatControlSequence;
    switch (val)
    {
    case EnumType::kCoolingOnly:
    case EnumType::kCoolingWithReheat:
    case EnumType::kHeatingOnly:
    case EnumType::kHeatingWithReheat:
    case EnumType::kCoolingAndHeating:
    case EnumType::kCoolingAndHeatingWithReheat:
        return val;
    default:
        return static_cast<EnumType>(6);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::ThermostatRunningMode val)
{
    using EnumType = Thermostat::ThermostatRunningMode;
    switch (val)
    {
    case EnumType::kOff:
    case EnumType::kCool:
    case EnumType::kHeat:
        return val;
    default:
        return static_cast<EnumType>(1);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Thermostat::ThermostatSystemMode val)
{
    using EnumType = Thermostat::ThermostatSystemMode;
    switch (val)
    {
    case EnumType::kOff:
    case EnumType::kAuto:
    case EnumType::kCool:
    case EnumType::kHeat:
    case EnumType::kEmergencyHeating:
    case EnumType::kPrecooling:
    case EnumType::kFanOnly:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(FanControl::FanModeSequenceType val)
{
    using EnumType = FanControl::FanModeSequenceType;
    switch (val)
    {
    case EnumType::kOffLowMedHigh:
    case EnumType::kOffLowHigh:
    case EnumType::kOffLowMedHighAuto:
    case EnumType::kOffLowHighAuto:
    case EnumType::kOffOnAuto:
    case EnumType::kOffOn:
        return val;
    default:
        return static_cast<EnumType>(6);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(FanControl::FanModeType val)
{
    using EnumType = FanControl::FanModeType;
    switch (val)
    {
    case EnumType::kOff:
    case EnumType::kLow:
    case EnumType::kMedium:
    case EnumType::kHigh:
    case EnumType::kOn:
    case EnumType::kAuto:
    case EnumType::kSmart:
        return val;
    default:
        return static_cast<EnumType>(7);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::ColorLoopAction val)
{
    using EnumType = ColorControl::ColorLoopAction;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kDeactivate:
    case EnumType::kActivateFromColorLoopStartEnhancedHue:
    case EnumType::kActivateFromEnhancedCurrentHue:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_COLOR_LOOP_ACTION_DEACTIVATE:
    case EMBER_ZCL_COLOR_LOOP_ACTION_ACTIVATE_FROM_COLOR_LOOP_START_ENHANCED_HUE:
    case EMBER_ZCL_COLOR_LOOP_ACTION_ACTIVATE_FROM_ENHANCED_CURRENT_HUE:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::ColorLoopDirection val)
{
    using EnumType = ColorControl::ColorLoopDirection;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kDecrementHue:
    case EnumType::kIncrementHue:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_COLOR_LOOP_DIRECTION_DECREMENT_HUE:
    case EMBER_ZCL_COLOR_LOOP_DIRECTION_INCREMENT_HUE:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::ColorMode val)
{
    using EnumType = ColorControl::ColorMode;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kCurrentHueAndCurrentSaturation:
    case EnumType::kCurrentXAndCurrentY:
    case EnumType::kColorTemperature:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_COLOR_MODE_CURRENT_HUE_AND_CURRENT_SATURATION:
    case EMBER_ZCL_COLOR_MODE_CURRENT_X_AND_CURRENT_Y:
    case EMBER_ZCL_COLOR_MODE_COLOR_TEMPERATURE:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::HueDirection val)
{
    using EnumType = ColorControl::HueDirection;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kShortestDistance:
    case EnumType::kLongestDistance:
    case EnumType::kUp:
    case EnumType::kDown:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_HUE_DIRECTION_SHORTEST_DISTANCE:
    case EMBER_ZCL_HUE_DIRECTION_LONGEST_DISTANCE:
    case EMBER_ZCL_HUE_DIRECTION_UP:
    case EMBER_ZCL_HUE_DIRECTION_DOWN:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::HueMoveMode val)
{
    using EnumType = ColorControl::HueMoveMode;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kStop:
    case EnumType::kUp:
    case EnumType::kDown:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_HUE_MOVE_MODE_STOP:
    case EMBER_ZCL_HUE_MOVE_MODE_UP:
    case EMBER_ZCL_HUE_MOVE_MODE_DOWN:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::HueStepMode val)
{
    using EnumType = ColorControl::HueStepMode;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kUp:
    case EnumType::kDown:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_HUE_STEP_MODE_UP:
    case EMBER_ZCL_HUE_STEP_MODE_DOWN:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(0);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::SaturationMoveMode val)
{
    using EnumType = ColorControl::SaturationMoveMode;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kStop:
    case EnumType::kUp:
    case EnumType::kDown:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_SATURATION_MOVE_MODE_STOP:
    case EMBER_ZCL_SATURATION_MOVE_MODE_UP:
    case EMBER_ZCL_SATURATION_MOVE_MODE_DOWN:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ColorControl::SaturationStepMode val)
{
    using EnumType = ColorControl::SaturationStepMode;
    switch (val)
    {
// Need to convert consumers to using the new enum classes, so we
// don't just have casts all over.
#ifdef CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EnumType::kUp:
    case EnumType::kDown:
#else  // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
    case EMBER_ZCL_SATURATION_STEP_MODE_UP:
    case EMBER_ZCL_SATURATION_STEP_MODE_DOWN:
#endif // CHIP_USE_ENUM_CLASS_FOR_IM_ENUM
        return val;
    default:
        return static_cast<EnumType>(0);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(IlluminanceMeasurement::LightSensorType val)
{
    using EnumType = IlluminanceMeasurement::LightSensorType;
    switch (val)
    {
    case EnumType::kPhotodiode:
    case EnumType::kCmos:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(Channel::ChannelStatusEnum val)
{
    using EnumType = Channel::ChannelStatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kMultipleMatches:
    case EnumType::kNoMatches:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(Channel::LineupInfoTypeEnum val)
{
    using EnumType = Channel::LineupInfoTypeEnum;
    switch (val)
    {
    case EnumType::kMso:
        return val;
    default:
        return static_cast<EnumType>(1);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(TargetNavigator::TargetNavigatorStatusEnum val)
{
    using EnumType = TargetNavigator::TargetNavigatorStatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kTargetNotFound:
    case EnumType::kNotAllowed:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(MediaPlayback::MediaPlaybackStatusEnum val)
{
    using EnumType = MediaPlayback::MediaPlaybackStatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kInvalidStateForCommand:
    case EnumType::kNotAllowed:
    case EnumType::kNotActive:
    case EnumType::kSpeedOutOfRange:
    case EnumType::kSeekOutOfRange:
        return val;
    default:
        return static_cast<EnumType>(6);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(MediaPlayback::PlaybackStateEnum val)
{
    using EnumType = MediaPlayback::PlaybackStateEnum;
    switch (val)
    {
    case EnumType::kPlaying:
    case EnumType::kPaused:
    case EnumType::kNotPlaying:
    case EnumType::kBuffering:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(MediaInput::InputTypeEnum val)
{
    using EnumType = MediaInput::InputTypeEnum;
    switch (val)
    {
    case EnumType::kInternal:
    case EnumType::kAux:
    case EnumType::kCoax:
    case EnumType::kComposite:
    case EnumType::kHdmi:
    case EnumType::kInput:
    case EnumType::kLine:
    case EnumType::kOptical:
    case EnumType::kVideo:
    case EnumType::kScart:
    case EnumType::kUsb:
    case EnumType::kOther:
        return val;
    default:
        return static_cast<EnumType>(12);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(KeypadInput::CecKeyCode val)
{
    using EnumType = KeypadInput::CecKeyCode;
    switch (val)
    {
    case EnumType::kSelect:
    case EnumType::kUp:
    case EnumType::kDown:
    case EnumType::kLeft:
    case EnumType::kRight:
    case EnumType::kRightUp:
    case EnumType::kRightDown:
    case EnumType::kLeftUp:
    case EnumType::kLeftDown:
    case EnumType::kRootMenu:
    case EnumType::kSetupMenu:
    case EnumType::kContentsMenu:
    case EnumType::kFavoriteMenu:
    case EnumType::kExit:
    case EnumType::kMediaTopMenu:
    case EnumType::kMediaContextSensitiveMenu:
    case EnumType::kNumberEntryMode:
    case EnumType::kNumber11:
    case EnumType::kNumber12:
    case EnumType::kNumber0OrNumber10:
    case EnumType::kNumbers1:
    case EnumType::kNumbers2:
    case EnumType::kNumbers3:
    case EnumType::kNumbers4:
    case EnumType::kNumbers5:
    case EnumType::kNumbers6:
    case EnumType::kNumbers7:
    case EnumType::kNumbers8:
    case EnumType::kNumbers9:
    case EnumType::kDot:
    case EnumType::kEnter:
    case EnumType::kClear:
    case EnumType::kNextFavorite:
    case EnumType::kChannelUp:
    case EnumType::kChannelDown:
    case EnumType::kPreviousChannel:
    case EnumType::kSoundSelect:
    case EnumType::kInputSelect:
    case EnumType::kDisplayInformation:
    case EnumType::kHelp:
    case EnumType::kPageUp:
    case EnumType::kPageDown:
    case EnumType::kPower:
    case EnumType::kVolumeUp:
    case EnumType::kVolumeDown:
    case EnumType::kMute:
    case EnumType::kPlay:
    case EnumType::kStop:
    case EnumType::kPause:
    case EnumType::kRecord:
    case EnumType::kRewind:
    case EnumType::kFastForward:
    case EnumType::kEject:
    case EnumType::kForward:
    case EnumType::kBackward:
    case EnumType::kStopRecord:
    case EnumType::kPauseRecord:
    case EnumType::kReserved:
    case EnumType::kAngle:
    case EnumType::kSubPicture:
    case EnumType::kVideoOnDemand:
    case EnumType::kElectronicProgramGuide:
    case EnumType::kTimerProgramming:
    case EnumType::kInitialConfiguration:
    case EnumType::kSelectBroadcastType:
    case EnumType::kSelectSoundPresentation:
    case EnumType::kPlayFunction:
    case EnumType::kPausePlayFunction:
    case EnumType::kRecordFunction:
    case EnumType::kPauseRecordFunction:
    case EnumType::kStopFunction:
    case EnumType::kMuteFunction:
    case EnumType::kRestoreVolumeFunction:
    case EnumType::kTuneFunction:
    case EnumType::kSelectMediaFunction:
    case EnumType::kSelectAvInputFunction:
    case EnumType::kSelectAudioInputFunction:
    case EnumType::kPowerToggleFunction:
    case EnumType::kPowerOffFunction:
    case EnumType::kPowerOnFunction:
    case EnumType::kF1Blue:
    case EnumType::kF2Red:
    case EnumType::kF3Green:
    case EnumType::kF4Yellow:
    case EnumType::kF5:
    case EnumType::kData:
        return val;
    default:
        return static_cast<EnumType>(14);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(KeypadInput::KeypadInputStatusEnum val)
{
    using EnumType = KeypadInput::KeypadInputStatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kUnsupportedKey:
    case EnumType::kInvalidKeyInCurrentState:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ContentLauncher::ContentLaunchStatusEnum val)
{
    using EnumType = ContentLauncher::ContentLaunchStatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kUrlNotAvailable:
    case EnumType::kAuthFailed:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ContentLauncher::MetricTypeEnum val)
{
    using EnumType = ContentLauncher::MetricTypeEnum;
    switch (val)
    {
    case EnumType::kPixels:
    case EnumType::kPercentage:
        return val;
    default:
        return static_cast<EnumType>(2);
    }
}
static auto __attribute__((unused)) EnsureKnownEnumValue(ContentLauncher::ParameterEnum val)
{
    using EnumType = ContentLauncher::ParameterEnum;
    switch (val)
    {
    case EnumType::kActor:
    case EnumType::kChannel:
    case EnumType::kCharacter:
    case EnumType::kDirector:
    case EnumType::kEvent:
    case EnumType::kFranchise:
    case EnumType::kGenre:
    case EnumType::kLeague:
    case EnumType::kPopularity:
    case EnumType::kProvider:
    case EnumType::kSport:
    case EnumType::kSportsTeam:
    case EnumType::kType:
        return val;
    default:
        return static_cast<EnumType>(13);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(AudioOutput::OutputTypeEnum val)
{
    using EnumType = AudioOutput::OutputTypeEnum;
    switch (val)
    {
    case EnumType::kHdmi:
    case EnumType::kBt:
    case EnumType::kOptical:
    case EnumType::kHeadphone:
    case EnumType::kInternal:
    case EnumType::kOther:
        return val;
    default:
        return static_cast<EnumType>(6);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ApplicationLauncher::ApplicationLauncherStatusEnum val)
{
    using EnumType = ApplicationLauncher::ApplicationLauncherStatusEnum;
    switch (val)
    {
    case EnumType::kSuccess:
    case EnumType::kAppNotAvailable:
    case EnumType::kSystemBusy:
        return val;
    default:
        return static_cast<EnumType>(3);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(ApplicationBasic::ApplicationStatusEnum val)
{
    using EnumType = ApplicationBasic::ApplicationStatusEnum;
    switch (val)
    {
    case EnumType::kStopped:
    case EnumType::kActiveVisibleFocus:
    case EnumType::kActiveHidden:
    case EnumType::kActiveVisibleNotFocus:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(TestCluster::SimpleEnum val)
{
    using EnumType = TestCluster::SimpleEnum;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kValueA:
    case EnumType::kValueB:
    case EnumType::kValueC:
        return val;
    default:
        return static_cast<EnumType>(4);
    }
}

static auto __attribute__((unused)) EnsureKnownEnumValue(FaultInjection::FaultType val)
{
    using EnumType = FaultInjection::FaultType;
    switch (val)
    {
    case EnumType::kUnspecified:
    case EnumType::kSystemFault:
    case EnumType::kInetFault:
    case EnumType::kChipFault:
    case EnumType::kCertFault:
        return val;
    default:
        return static_cast<EnumType>(5);
    }
}

} // namespace Clusters
} // namespace app
} // namespace chip
