/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#pragma once

#include <app-common/zap-generated/enums.h>
#include <app-common/zap-generated/ids/Attributes.h>
#include <app-common/zap-generated/ids/Clusters.h>
#include <app-common/zap-generated/ids/Commands.h>
#include <app-common/zap-generated/ids/Events.h>
#include <app/ConcreteAttributePath.h>
#include <app/EventLoggingTypes.h>
#include <app/data-model/DecodableList.h>
#include <app/data-model/Decode.h>
#include <app/data-model/Encode.h>
#include <app/data-model/List.h>
#include <app/data-model/NullObject.h>
#include <app/util/basic-types.h>
#include <lib/core/ClusterEnums.h>
#include <lib/support/BitMask.h>
#include <protocols/interaction_model/Constants.h>

namespace chip {
namespace app {
namespace Clusters {

namespace detail {
// Structs shared across multiple clusters.
namespace Structs {
namespace LabelStruct {
enum class Fields
{
    kLabel = 0,
    kValue = 1,
};

struct Type
{
public:
    chip::CharSpan label;
    chip::CharSpan value;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace LabelStruct
} // namespace Structs
} // namespace detail

namespace Globals {
namespace Attributes {
namespace GeneratedCommandList {
struct TypeInfo
{
    using Type             = DataModel::List<const chip::CommandId>;
    using DecodableType    = DataModel::DecodableList<chip::CommandId>;
    using DecodableArgType = const DataModel::DecodableList<chip::CommandId> &;

    static constexpr AttributeId GetAttributeId() { return Attributes::GeneratedCommandList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
struct TypeInfo
{
    using Type             = DataModel::List<const chip::CommandId>;
    using DecodableType    = DataModel::DecodableList<chip::CommandId>;
    using DecodableArgType = const DataModel::DecodableList<chip::CommandId> &;

    static constexpr AttributeId GetAttributeId() { return Attributes::AcceptedCommandList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcceptedCommandList

namespace AttributeList {
struct TypeInfo
{
    using Type             = DataModel::List<const chip::AttributeId>;
    using DecodableType    = DataModel::DecodableList<chip::AttributeId>;
    using DecodableArgType = const DataModel::DecodableList<chip::AttributeId> &;

    static constexpr AttributeId GetAttributeId() { return Attributes::AttributeList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AttributeList

namespace FeatureMap {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr AttributeId GetAttributeId() { return Attributes::FeatureMap::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace FeatureMap

namespace ClusterRevision {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr AttributeId GetAttributeId() { return Attributes::ClusterRevision::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Globals

namespace Identify {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Identify {
struct Type;
struct DecodableType;
} // namespace Identify

namespace TriggerEffect {
struct Type;
struct DecodableType;
} // namespace TriggerEffect

} // namespace Commands

namespace Commands {
namespace Identify {
enum class Fields
{
    kIdentifyTime = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Identify::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }

    uint16_t identifyTime = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Identify::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }

    uint16_t identifyTime = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Identify
namespace TriggerEffect {
enum class Fields
{
    kEffectIdentifier = 0,
    kEffectVariant    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TriggerEffect::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }

    IdentifyEffectIdentifier effectIdentifier = static_cast<IdentifyEffectIdentifier>(0);
    IdentifyEffectVariant effectVariant       = static_cast<IdentifyEffectVariant>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TriggerEffect::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }

    IdentifyEffectIdentifier effectIdentifier = static_cast<IdentifyEffectIdentifier>(0);
    IdentifyEffectVariant effectVariant       = static_cast<IdentifyEffectVariant>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TriggerEffect
} // namespace Commands

namespace Attributes {

namespace IdentifyTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::IdentifyTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace IdentifyTime
namespace IdentifyType {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::IdentifyType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace IdentifyType
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Identify::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::IdentifyTime::TypeInfo::DecodableType identifyTime = static_cast<uint16_t>(0);
        Attributes::IdentifyType::TypeInfo::DecodableType identifyType = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Identify
namespace Groups {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace AddGroup {
struct Type;
struct DecodableType;
} // namespace AddGroup

namespace AddGroupResponse {
struct Type;
struct DecodableType;
} // namespace AddGroupResponse

namespace ViewGroup {
struct Type;
struct DecodableType;
} // namespace ViewGroup

namespace ViewGroupResponse {
struct Type;
struct DecodableType;
} // namespace ViewGroupResponse

namespace GetGroupMembership {
struct Type;
struct DecodableType;
} // namespace GetGroupMembership

namespace GetGroupMembershipResponse {
struct Type;
struct DecodableType;
} // namespace GetGroupMembershipResponse

namespace RemoveGroup {
struct Type;
struct DecodableType;
} // namespace RemoveGroup

namespace RemoveGroupResponse {
struct Type;
struct DecodableType;
} // namespace RemoveGroupResponse

namespace RemoveAllGroups {
struct Type;
struct DecodableType;
} // namespace RemoveAllGroups

namespace AddGroupIfIdentifying {
struct Type;
struct DecodableType;
} // namespace AddGroupIfIdentifying

} // namespace Commands

namespace Commands {
namespace AddGroup {
enum class Fields
{
    kGroupId   = 0,
    kGroupName = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Groups::Commands::AddGroupResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddGroup
namespace AddGroupResponse {
enum class Fields
{
    kStatus  = 0,
    kGroupId = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddGroupResponse
namespace ViewGroup {
enum class Fields
{
    kGroupId = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ViewGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Groups::Commands::ViewGroupResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ViewGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ViewGroup
namespace ViewGroupResponse {
enum class Fields
{
    kStatus    = 0,
    kGroupId   = 1,
    kGroupName = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ViewGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ViewGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ViewGroupResponse
namespace GetGroupMembership {
enum class Fields
{
    kGroupList = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetGroupMembership::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    DataModel::List<const chip::GroupId> groupList;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Groups::Commands::GetGroupMembershipResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetGroupMembership::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    DataModel::DecodableList<chip::GroupId> groupList;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetGroupMembership
namespace GetGroupMembershipResponse {
enum class Fields
{
    kCapacity  = 0,
    kGroupList = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetGroupMembershipResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    DataModel::Nullable<uint8_t> capacity;
    DataModel::List<const chip::GroupId> groupList;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetGroupMembershipResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    DataModel::Nullable<uint8_t> capacity;
    DataModel::DecodableList<chip::GroupId> groupList;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetGroupMembershipResponse
namespace RemoveGroup {
enum class Fields
{
    kGroupId = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Groups::Commands::RemoveGroupResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveGroup::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveGroup
namespace RemoveGroupResponse {
enum class Fields
{
    kStatus  = 0,
    kGroupId = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveGroupResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveGroupResponse
namespace RemoveAllGroups {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllGroups::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllGroups::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveAllGroups
namespace AddGroupIfIdentifying {
enum class Fields
{
    kGroupId   = 0,
    kGroupName = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddGroupIfIdentifying::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddGroupIfIdentifying::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    chip::CharSpan groupName;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddGroupIfIdentifying
} // namespace Commands

namespace Attributes {

namespace NameSupport {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NameSupport::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NameSupport
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Groups::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::NameSupport::TypeInfo::DecodableType nameSupport = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Groups
namespace Scenes {
namespace Structs {
namespace AttributeValuePair {
enum class Fields
{
    kAttributeId    = 0,
    kAttributeValue = 1,
};

struct Type
{
public:
    Optional<chip::AttributeId> attributeId;
    DataModel::List<const uint8_t> attributeValue;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    Optional<chip::AttributeId> attributeId;
    DataModel::DecodableList<uint8_t> attributeValue;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace AttributeValuePair
namespace ExtensionFieldSet {
enum class Fields
{
    kClusterId          = 0,
    kAttributeValueList = 1,
};

struct Type
{
public:
    chip::ClusterId clusterId = static_cast<chip::ClusterId>(0);
    DataModel::List<const Structs::AttributeValuePair::Type> attributeValueList;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    chip::ClusterId clusterId = static_cast<chip::ClusterId>(0);
    DataModel::DecodableList<Structs::AttributeValuePair::DecodableType> attributeValueList;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace ExtensionFieldSet
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace AddScene {
struct Type;
struct DecodableType;
} // namespace AddScene

namespace AddSceneResponse {
struct Type;
struct DecodableType;
} // namespace AddSceneResponse

namespace ViewScene {
struct Type;
struct DecodableType;
} // namespace ViewScene

namespace ViewSceneResponse {
struct Type;
struct DecodableType;
} // namespace ViewSceneResponse

namespace RemoveScene {
struct Type;
struct DecodableType;
} // namespace RemoveScene

namespace RemoveSceneResponse {
struct Type;
struct DecodableType;
} // namespace RemoveSceneResponse

namespace RemoveAllScenes {
struct Type;
struct DecodableType;
} // namespace RemoveAllScenes

namespace RemoveAllScenesResponse {
struct Type;
struct DecodableType;
} // namespace RemoveAllScenesResponse

namespace StoreScene {
struct Type;
struct DecodableType;
} // namespace StoreScene

namespace StoreSceneResponse {
struct Type;
struct DecodableType;
} // namespace StoreSceneResponse

namespace RecallScene {
struct Type;
struct DecodableType;
} // namespace RecallScene

namespace GetSceneMembership {
struct Type;
struct DecodableType;
} // namespace GetSceneMembership

namespace GetSceneMembershipResponse {
struct Type;
struct DecodableType;
} // namespace GetSceneMembershipResponse

namespace EnhancedAddScene {
struct Type;
struct DecodableType;
} // namespace EnhancedAddScene

namespace EnhancedAddSceneResponse {
struct Type;
struct DecodableType;
} // namespace EnhancedAddSceneResponse

namespace EnhancedViewScene {
struct Type;
struct DecodableType;
} // namespace EnhancedViewScene

namespace EnhancedViewSceneResponse {
struct Type;
struct DecodableType;
} // namespace EnhancedViewSceneResponse

namespace CopyScene {
struct Type;
struct DecodableType;
} // namespace CopyScene

namespace CopySceneResponse {
struct Type;
struct DecodableType;
} // namespace CopySceneResponse

} // namespace Commands

namespace Commands {
namespace AddScene {
enum class Fields
{
    kGroupId            = 0,
    kSceneId            = 1,
    kTransitionTime     = 2,
    kSceneName          = 3,
    kExtensionFieldSets = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId   = static_cast<chip::GroupId>(0);
    uint8_t sceneId         = static_cast<uint8_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    chip::CharSpan sceneName;
    DataModel::List<const Structs::ExtensionFieldSet::Type> extensionFieldSets;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Scenes::Commands::AddSceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId   = static_cast<chip::GroupId>(0);
    uint8_t sceneId         = static_cast<uint8_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    chip::CharSpan sceneName;
    DataModel::DecodableList<Structs::ExtensionFieldSet::DecodableType> extensionFieldSets;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddScene
namespace AddSceneResponse {
enum class Fields
{
    kStatus  = 0,
    kGroupId = 1,
    kSceneId = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddSceneResponse
namespace ViewScene {
enum class Fields
{
    kGroupId = 0,
    kSceneId = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ViewScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Scenes::Commands::ViewSceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ViewScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ViewScene
namespace ViewSceneResponse {
enum class Fields
{
    kStatus             = 0,
    kGroupId            = 1,
    kSceneId            = 2,
    kTransitionTime     = 3,
    kSceneName          = 4,
    kExtensionFieldSets = 5,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ViewSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    Optional<uint16_t> transitionTime;
    Optional<chip::CharSpan> sceneName;
    Optional<DataModel::List<const Structs::ExtensionFieldSet::Type>> extensionFieldSets;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ViewSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    Optional<uint16_t> transitionTime;
    Optional<chip::CharSpan> sceneName;
    Optional<DataModel::DecodableList<Structs::ExtensionFieldSet::DecodableType>> extensionFieldSets;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ViewSceneResponse
namespace RemoveScene {
enum class Fields
{
    kGroupId = 0,
    kSceneId = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Scenes::Commands::RemoveSceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveScene
namespace RemoveSceneResponse {
enum class Fields
{
    kStatus  = 0,
    kGroupId = 1,
    kSceneId = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveSceneResponse
namespace RemoveAllScenes {
enum class Fields
{
    kGroupId = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllScenes::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Scenes::Commands::RemoveAllScenesResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllScenes::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveAllScenes
namespace RemoveAllScenesResponse {
enum class Fields
{
    kStatus  = 0,
    kGroupId = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllScenesResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveAllScenesResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveAllScenesResponse
namespace StoreScene {
enum class Fields
{
    kGroupId = 0,
    kSceneId = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StoreScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Scenes::Commands::StoreSceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StoreScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StoreScene
namespace StoreSceneResponse {
enum class Fields
{
    kStatus  = 0,
    kGroupId = 1,
    kSceneId = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StoreSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StoreSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StoreSceneResponse
namespace RecallScene {
enum class Fields
{
    kGroupId        = 0,
    kSceneId        = 1,
    kTransitionTime = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RecallScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    Optional<DataModel::Nullable<uint16_t>> transitionTime;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RecallScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    Optional<DataModel::Nullable<uint16_t>> transitionTime;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RecallScene
namespace GetSceneMembership {
enum class Fields
{
    kGroupId = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetSceneMembership::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Scenes::Commands::GetSceneMembershipResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetSceneMembership::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetSceneMembership
namespace GetSceneMembershipResponse {
enum class Fields
{
    kStatus    = 0,
    kCapacity  = 1,
    kGroupId   = 2,
    kSceneList = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetSceneMembershipResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    DataModel::Nullable<uint8_t> capacity;
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    Optional<DataModel::List<const uint8_t>> sceneList;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetSceneMembershipResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status = static_cast<uint8_t>(0);
    DataModel::Nullable<uint8_t> capacity;
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    Optional<DataModel::DecodableList<uint8_t>> sceneList;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetSceneMembershipResponse
namespace EnhancedAddScene {
enum class Fields
{
    kGroupId            = 0,
    kSceneId            = 1,
    kTransitionTime     = 2,
    kSceneName          = 3,
    kExtensionFieldSets = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnhancedAddScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId   = static_cast<chip::GroupId>(0);
    uint8_t sceneId         = static_cast<uint8_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    chip::CharSpan sceneName;
    DataModel::List<const Structs::ExtensionFieldSet::Type> extensionFieldSets;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Scenes::Commands::EnhancedAddSceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnhancedAddScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId   = static_cast<chip::GroupId>(0);
    uint8_t sceneId         = static_cast<uint8_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    chip::CharSpan sceneName;
    DataModel::DecodableList<Structs::ExtensionFieldSet::DecodableType> extensionFieldSets;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnhancedAddScene
namespace EnhancedAddSceneResponse {
enum class Fields
{
    kStatus  = 0,
    kGroupId = 1,
    kSceneId = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnhancedAddSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnhancedAddSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnhancedAddSceneResponse
namespace EnhancedViewScene {
enum class Fields
{
    kGroupId = 0,
    kSceneId = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnhancedViewScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Scenes::Commands::EnhancedViewSceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnhancedViewScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnhancedViewScene
namespace EnhancedViewSceneResponse {
enum class Fields
{
    kStatus             = 0,
    kGroupId            = 1,
    kSceneId            = 2,
    kTransitionTime     = 3,
    kSceneName          = 4,
    kExtensionFieldSets = 5,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnhancedViewSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    Optional<uint16_t> transitionTime;
    Optional<chip::CharSpan> sceneName;
    Optional<DataModel::List<const Structs::ExtensionFieldSet::Type>> extensionFieldSets;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnhancedViewSceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status        = static_cast<uint8_t>(0);
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    uint8_t sceneId       = static_cast<uint8_t>(0);
    Optional<uint16_t> transitionTime;
    Optional<chip::CharSpan> sceneName;
    Optional<DataModel::DecodableList<Structs::ExtensionFieldSet::DecodableType>> extensionFieldSets;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnhancedViewSceneResponse
namespace CopyScene {
enum class Fields
{
    kMode        = 0,
    kGroupIdFrom = 1,
    kSceneIdFrom = 2,
    kGroupIdTo   = 3,
    kSceneIdTo   = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CopyScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::BitMask<ScenesCopyMode> mode = static_cast<chip::BitMask<ScenesCopyMode>>(0);
    chip::GroupId groupIdFrom          = static_cast<chip::GroupId>(0);
    uint8_t sceneIdFrom                = static_cast<uint8_t>(0);
    chip::GroupId groupIdTo            = static_cast<chip::GroupId>(0);
    uint8_t sceneIdTo                  = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Scenes::Commands::CopySceneResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CopyScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    chip::BitMask<ScenesCopyMode> mode = static_cast<chip::BitMask<ScenesCopyMode>>(0);
    chip::GroupId groupIdFrom          = static_cast<chip::GroupId>(0);
    uint8_t sceneIdFrom                = static_cast<uint8_t>(0);
    chip::GroupId groupIdTo            = static_cast<chip::GroupId>(0);
    uint8_t sceneIdTo                  = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CopyScene
namespace CopySceneResponse {
enum class Fields
{
    kStatus      = 0,
    kGroupIdFrom = 1,
    kSceneIdFrom = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CopySceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status            = static_cast<uint8_t>(0);
    chip::GroupId groupIdFrom = static_cast<chip::GroupId>(0);
    uint8_t sceneIdFrom       = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CopySceneResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

    uint8_t status            = static_cast<uint8_t>(0);
    chip::GroupId groupIdFrom = static_cast<chip::GroupId>(0);
    uint8_t sceneIdFrom       = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CopySceneResponse
} // namespace Commands

namespace Attributes {

namespace SceneCount {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SceneCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SceneCount
namespace CurrentScene {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentScene::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentScene
namespace CurrentGroup {
struct TypeInfo
{
    using Type             = chip::GroupId;
    using DecodableType    = chip::GroupId;
    using DecodableArgType = chip::GroupId;

    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentGroup::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentGroup
namespace SceneValid {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SceneValid::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SceneValid
namespace NameSupport {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NameSupport::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NameSupport
namespace LastConfiguredBy {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::NodeId>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::NodeId>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::NodeId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LastConfiguredBy::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LastConfiguredBy
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Scenes::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SceneCount::TypeInfo::DecodableType sceneCount     = static_cast<uint8_t>(0);
        Attributes::CurrentScene::TypeInfo::DecodableType currentScene = static_cast<uint8_t>(0);
        Attributes::CurrentGroup::TypeInfo::DecodableType currentGroup = static_cast<chip::GroupId>(0);
        Attributes::SceneValid::TypeInfo::DecodableType sceneValid     = static_cast<bool>(0);
        Attributes::NameSupport::TypeInfo::DecodableType nameSupport   = static_cast<uint8_t>(0);
        Attributes::LastConfiguredBy::TypeInfo::DecodableType lastConfiguredBy;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Scenes
namespace OnOff {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Off {
struct Type;
struct DecodableType;
} // namespace Off

namespace On {
struct Type;
struct DecodableType;
} // namespace On

namespace Toggle {
struct Type;
struct DecodableType;
} // namespace Toggle

namespace OffWithEffect {
struct Type;
struct DecodableType;
} // namespace OffWithEffect

namespace OnWithRecallGlobalScene {
struct Type;
struct DecodableType;
} // namespace OnWithRecallGlobalScene

namespace OnWithTimedOff {
struct Type;
struct DecodableType;
} // namespace OnWithTimedOff

} // namespace Commands

namespace Commands {
namespace Off {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Off::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Off::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Off
namespace On {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::On::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::On::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace On
namespace Toggle {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Toggle::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Toggle::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Toggle
namespace OffWithEffect {
enum class Fields
{
    kEffectId      = 0,
    kEffectVariant = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OffWithEffect::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    OnOffEffectIdentifier effectId                = static_cast<OnOffEffectIdentifier>(0);
    OnOffDelayedAllOffEffectVariant effectVariant = static_cast<OnOffDelayedAllOffEffectVariant>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OffWithEffect::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    OnOffEffectIdentifier effectId                = static_cast<OnOffEffectIdentifier>(0);
    OnOffDelayedAllOffEffectVariant effectVariant = static_cast<OnOffDelayedAllOffEffectVariant>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OffWithEffect
namespace OnWithRecallGlobalScene {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OnWithRecallGlobalScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OnWithRecallGlobalScene::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OnWithRecallGlobalScene
namespace OnWithTimedOff {
enum class Fields
{
    kOnOffControl = 0,
    kOnTime       = 1,
    kOffWaitTime  = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OnWithTimedOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    chip::BitMask<OnOffControl> onOffControl = static_cast<chip::BitMask<OnOffControl>>(0);
    uint16_t onTime                          = static_cast<uint16_t>(0);
    uint16_t offWaitTime                     = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OnWithTimedOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

    chip::BitMask<OnOffControl> onOffControl = static_cast<chip::BitMask<OnOffControl>>(0);
    uint16_t onTime                          = static_cast<uint16_t>(0);
    uint16_t offWaitTime                     = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OnWithTimedOff
} // namespace Commands

namespace Attributes {

namespace OnOff {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnOff::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnOff
namespace GlobalSceneControl {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::GlobalSceneControl::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace GlobalSceneControl
namespace OnTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnTime
namespace OffWaitTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OffWaitTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OffWaitTime
namespace StartUpOnOff {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::OnOff::OnOffStartUpOnOff>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::OnOff::OnOffStartUpOnOff>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::OnOff::OnOffStartUpOnOff> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpOnOff::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpOnOff
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OnOff::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::OnOff::TypeInfo::DecodableType onOff                           = static_cast<bool>(0);
        Attributes::GlobalSceneControl::TypeInfo::DecodableType globalSceneControl = static_cast<bool>(0);
        Attributes::OnTime::TypeInfo::DecodableType onTime                         = static_cast<uint16_t>(0);
        Attributes::OffWaitTime::TypeInfo::DecodableType offWaitTime               = static_cast<uint16_t>(0);
        Attributes::StartUpOnOff::TypeInfo::DecodableType startUpOnOff;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace OnOff
namespace OnOffSwitchConfiguration {

namespace Attributes {

namespace SwitchType {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOffSwitchConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SwitchType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SwitchType
namespace SwitchActions {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OnOffSwitchConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SwitchActions::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SwitchActions
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOffSwitchConfiguration::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOffSwitchConfiguration::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOffSwitchConfiguration::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOffSwitchConfiguration::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OnOffSwitchConfiguration::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OnOffSwitchConfiguration::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::SwitchType::TypeInfo::DecodableType switchType       = static_cast<uint8_t>(0);
        Attributes::SwitchActions::TypeInfo::DecodableType switchActions = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace OnOffSwitchConfiguration
namespace LevelControl {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace MoveToLevel {
struct Type;
struct DecodableType;
} // namespace MoveToLevel

namespace Move {
struct Type;
struct DecodableType;
} // namespace Move

namespace Step {
struct Type;
struct DecodableType;
} // namespace Step

namespace Stop {
struct Type;
struct DecodableType;
} // namespace Stop

namespace MoveToLevelWithOnOff {
struct Type;
struct DecodableType;
} // namespace MoveToLevelWithOnOff

namespace MoveWithOnOff {
struct Type;
struct DecodableType;
} // namespace MoveWithOnOff

namespace StepWithOnOff {
struct Type;
struct DecodableType;
} // namespace StepWithOnOff

namespace StopWithOnOff {
struct Type;
struct DecodableType;
} // namespace StopWithOnOff

namespace MoveToClosestFrequency {
struct Type;
struct DecodableType;
} // namespace MoveToClosestFrequency

} // namespace Commands

namespace Commands {
namespace MoveToLevel {
enum class Fields
{
    kLevel           = 0,
    kTransitionTime  = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveToLevel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t level = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveToLevel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t level = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveToLevel
namespace Move {
enum class Fields
{
    kMoveMode        = 0,
    kRate            = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Move::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    MoveMode moveMode = static_cast<MoveMode>(0);
    DataModel::Nullable<uint8_t> rate;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Move::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    MoveMode moveMode = static_cast<MoveMode>(0);
    DataModel::Nullable<uint8_t> rate;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Move
namespace Step {
enum class Fields
{
    kStepMode        = 0,
    kStepSize        = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Step::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    StepMode stepMode = static_cast<StepMode>(0);
    uint8_t stepSize  = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Step::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    StepMode stepMode = static_cast<StepMode>(0);
    uint8_t stepSize  = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Step
namespace Stop {
enum class Fields
{
    kOptionsMask     = 0,
    kOptionsOverride = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Stop::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Stop::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Stop
namespace MoveToLevelWithOnOff {
enum class Fields
{
    kLevel           = 0,
    kTransitionTime  = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveToLevelWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t level = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveToLevelWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t level = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveToLevelWithOnOff
namespace MoveWithOnOff {
enum class Fields
{
    kMoveMode        = 0,
    kRate            = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    MoveMode moveMode = static_cast<MoveMode>(0);
    DataModel::Nullable<uint8_t> rate;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    MoveMode moveMode = static_cast<MoveMode>(0);
    DataModel::Nullable<uint8_t> rate;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveWithOnOff
namespace StepWithOnOff {
enum class Fields
{
    kStepMode        = 0,
    kStepSize        = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StepWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    StepMode stepMode = static_cast<StepMode>(0);
    uint8_t stepSize  = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StepWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    StepMode stepMode = static_cast<StepMode>(0);
    uint8_t stepSize  = static_cast<uint8_t>(0);
    DataModel::Nullable<uint16_t> transitionTime;
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StepWithOnOff
namespace StopWithOnOff {
enum class Fields
{
    kOptionsMask     = 0,
    kOptionsOverride = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StopWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StopWithOnOff::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StopWithOnOff
namespace MoveToClosestFrequency {
enum class Fields
{
    kFrequency = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveToClosestFrequency::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint16_t frequency = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveToClosestFrequency::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

    uint16_t frequency = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveToClosestFrequency
} // namespace Commands

namespace Attributes {

namespace CurrentLevel {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentLevel
namespace RemainingTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RemainingTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RemainingTime
namespace MinLevel {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinLevel
namespace MaxLevel {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxLevel
namespace CurrentFrequency {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentFrequency::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentFrequency
namespace MinFrequency {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinFrequency::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinFrequency
namespace MaxFrequency {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxFrequency::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxFrequency
namespace Options {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Options::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Options
namespace OnOffTransitionTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnOffTransitionTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnOffTransitionTime
namespace OnLevel {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnLevel
namespace OnTransitionTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnTransitionTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnTransitionTime
namespace OffTransitionTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OffTransitionTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OffTransitionTime
namespace DefaultMoveRate {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultMoveRate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DefaultMoveRate
namespace StartUpCurrentLevel {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpCurrentLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpCurrentLevel
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::LevelControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::CurrentLevel::TypeInfo::DecodableType currentLevel;
        Attributes::RemainingTime::TypeInfo::DecodableType remainingTime             = static_cast<uint16_t>(0);
        Attributes::MinLevel::TypeInfo::DecodableType minLevel                       = static_cast<uint8_t>(0);
        Attributes::MaxLevel::TypeInfo::DecodableType maxLevel                       = static_cast<uint8_t>(0);
        Attributes::CurrentFrequency::TypeInfo::DecodableType currentFrequency       = static_cast<uint16_t>(0);
        Attributes::MinFrequency::TypeInfo::DecodableType minFrequency               = static_cast<uint16_t>(0);
        Attributes::MaxFrequency::TypeInfo::DecodableType maxFrequency               = static_cast<uint16_t>(0);
        Attributes::Options::TypeInfo::DecodableType options                         = static_cast<uint8_t>(0);
        Attributes::OnOffTransitionTime::TypeInfo::DecodableType onOffTransitionTime = static_cast<uint16_t>(0);
        Attributes::OnLevel::TypeInfo::DecodableType onLevel;
        Attributes::OnTransitionTime::TypeInfo::DecodableType onTransitionTime;
        Attributes::OffTransitionTime::TypeInfo::DecodableType offTransitionTime;
        Attributes::DefaultMoveRate::TypeInfo::DecodableType defaultMoveRate;
        Attributes::StartUpCurrentLevel::TypeInfo::DecodableType startUpCurrentLevel;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace LevelControl
namespace BinaryInputBasic {

namespace Attributes {

namespace ActiveText {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveText::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace ActiveText
namespace Description {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Description::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace Description
namespace InactiveText {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InactiveText::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace InactiveText
namespace OutOfService {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OutOfService::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OutOfService
namespace Polarity {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Polarity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Polarity
namespace PresentValue {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PresentValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PresentValue
namespace Reliability {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Reliability::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Reliability
namespace StatusFlags {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StatusFlags::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StatusFlags
namespace ApplicationType {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ApplicationType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ApplicationType
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::BinaryInputBasic::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::ActiveText::TypeInfo::DecodableType activeText;
        Attributes::Description::TypeInfo::DecodableType description;
        Attributes::InactiveText::TypeInfo::DecodableType inactiveText;
        Attributes::OutOfService::TypeInfo::DecodableType outOfService       = static_cast<bool>(0);
        Attributes::Polarity::TypeInfo::DecodableType polarity               = static_cast<uint8_t>(0);
        Attributes::PresentValue::TypeInfo::DecodableType presentValue       = static_cast<bool>(0);
        Attributes::Reliability::TypeInfo::DecodableType reliability         = static_cast<uint8_t>(0);
        Attributes::StatusFlags::TypeInfo::DecodableType statusFlags         = static_cast<uint8_t>(0);
        Attributes::ApplicationType::TypeInfo::DecodableType applicationType = static_cast<uint32_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace BinaryInputBasic
namespace PulseWidthModulation {

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::PulseWidthModulation::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace PulseWidthModulation
namespace Descriptor {
namespace Structs {
namespace DeviceTypeStruct {
enum class Fields
{
    kType     = 0,
    kRevision = 1,
};

struct Type
{
public:
    chip::DeviceTypeId type = static_cast<chip::DeviceTypeId>(0);
    uint16_t revision       = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace DeviceTypeStruct
} // namespace Structs

namespace Attributes {

namespace DeviceTypeList {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DeviceTypeList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DeviceTypeList
namespace ServerList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::ClusterId>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::ClusterId>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::ClusterId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ServerList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ServerList
namespace ClientList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::ClusterId>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::ClusterId>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::ClusterId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ClientList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ClientList
namespace PartsList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::EndpointId>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::EndpointId>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::EndpointId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PartsList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PartsList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Descriptor::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::DeviceTypeList::TypeInfo::DecodableType deviceTypeList;
        Attributes::ServerList::TypeInfo::DecodableType serverList;
        Attributes::ClientList::TypeInfo::DecodableType clientList;
        Attributes::PartsList::TypeInfo::DecodableType partsList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Descriptor
namespace Binding {
namespace Structs {
namespace TargetStruct {
enum class Fields
{
    kNode        = 1,
    kGroup       = 2,
    kEndpoint    = 3,
    kCluster     = 4,
    kFabricIndex = 254,
};

struct Type
{
public:
    Optional<chip::NodeId> node;
    Optional<chip::GroupId> group;
    Optional<chip::EndpointId> endpoint;
    Optional<chip::ClusterId> cluster;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & writer, TLV::Tag tag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & writer, TLV::Tag tag, FabricIndex accessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & writer, TLV::Tag tag, const Optional<FabricIndex> & accessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace TargetStruct
} // namespace Structs

namespace Attributes {

namespace Binding {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::Binding::Structs::TargetStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::Binding::Structs::TargetStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Binding::Structs::TargetStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Binding::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Binding
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Binding::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Binding::TypeInfo::DecodableType binding;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Binding
namespace AccessControl {
namespace Structs {
namespace Target {
enum class Fields
{
    kCluster    = 0,
    kEndpoint   = 1,
    kDeviceType = 2,
};

struct Type
{
public:
    DataModel::Nullable<chip::ClusterId> cluster;
    DataModel::Nullable<chip::EndpointId> endpoint;
    DataModel::Nullable<chip::DeviceTypeId> deviceType;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace Target
namespace AccessControlEntry {
enum class Fields
{
    kPrivilege   = 1,
    kAuthMode    = 2,
    kSubjects    = 3,
    kTargets     = 4,
    kFabricIndex = 254,
};

struct Type
{
public:
    Privilege privilege = static_cast<Privilege>(0);
    AuthMode authMode   = static_cast<AuthMode>(0);
    DataModel::Nullable<DataModel::List<const uint64_t>> subjects;
    DataModel::Nullable<DataModel::List<const Structs::Target::Type>> targets;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & writer, TLV::Tag tag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & writer, TLV::Tag tag, FabricIndex accessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & writer, TLV::Tag tag, const Optional<FabricIndex> & accessingFabricIndex) const;
};

struct DecodableType
{
public:
    Privilege privilege = static_cast<Privilege>(0);
    AuthMode authMode   = static_cast<AuthMode>(0);
    DataModel::Nullable<DataModel::DecodableList<uint64_t>> subjects;
    DataModel::Nullable<DataModel::DecodableList<Structs::Target::DecodableType>> targets;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }
};

} // namespace AccessControlEntry
namespace ExtensionEntry {
enum class Fields
{
    kData        = 1,
    kFabricIndex = 254,
};

struct Type
{
public:
    chip::ByteSpan data;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & writer, TLV::Tag tag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & writer, TLV::Tag tag, FabricIndex accessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & writer, TLV::Tag tag, const Optional<FabricIndex> & accessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace ExtensionEntry
} // namespace Structs

namespace Attributes {

namespace Acl {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Acl::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Acl
namespace Extension {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::ExtensionEntry::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::ExtensionEntry::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::ExtensionEntry::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Extension::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Extension
namespace SubjectsPerAccessControlEntry {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SubjectsPerAccessControlEntry::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SubjectsPerAccessControlEntry
namespace TargetsPerAccessControlEntry {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TargetsPerAccessControlEntry::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TargetsPerAccessControlEntry
namespace AccessControlEntriesPerFabric {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AccessControlEntriesPerFabric::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AccessControlEntriesPerFabric
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Acl::TypeInfo::DecodableType acl;
        Attributes::Extension::TypeInfo::DecodableType extension;
        Attributes::SubjectsPerAccessControlEntry::TypeInfo::DecodableType subjectsPerAccessControlEntry = static_cast<uint16_t>(0);
        Attributes::TargetsPerAccessControlEntry::TypeInfo::DecodableType targetsPerAccessControlEntry   = static_cast<uint16_t>(0);
        Attributes::AccessControlEntriesPerFabric::TypeInfo::DecodableType accessControlEntriesPerFabric = static_cast<uint16_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace AccessControlEntryChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kAdminNodeID     = 1,
    kAdminPasscodeID = 2,
    kChangeType      = 3,
    kLatestValue     = 4,
    kFabricIndex     = 254,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AccessControlEntryChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr bool kIsFabricScoped = true;

    DataModel::Nullable<chip::NodeId> adminNodeID;
    DataModel::Nullable<uint16_t> adminPasscodeID;
    ChangeTypeEnum changeType = static_cast<ChangeTypeEnum>(0);
    DataModel::Nullable<Structs::AccessControlEntry::Type> latestValue;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    auto GetFabricIndex() const { return fabricIndex; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AccessControlEntryChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }

    DataModel::Nullable<chip::NodeId> adminNodeID;
    DataModel::Nullable<uint16_t> adminPasscodeID;
    ChangeTypeEnum changeType = static_cast<ChangeTypeEnum>(0);
    DataModel::Nullable<Structs::AccessControlEntry::DecodableType> latestValue;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace AccessControlEntryChanged
namespace AccessControlExtensionChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kAdminNodeID     = 1,
    kAdminPasscodeID = 2,
    kChangeType      = 3,
    kLatestValue     = 4,
    kFabricIndex     = 254,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AccessControlExtensionChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }
    static constexpr bool kIsFabricScoped = true;

    DataModel::Nullable<chip::NodeId> adminNodeID;
    DataModel::Nullable<uint16_t> adminPasscodeID;
    ChangeTypeEnum changeType = static_cast<ChangeTypeEnum>(0);
    DataModel::Nullable<Structs::ExtensionEntry::Type> latestValue;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    auto GetFabricIndex() const { return fabricIndex; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AccessControlExtensionChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccessControl::Id; }

    DataModel::Nullable<chip::NodeId> adminNodeID;
    DataModel::Nullable<uint16_t> adminPasscodeID;
    ChangeTypeEnum changeType = static_cast<ChangeTypeEnum>(0);
    DataModel::Nullable<Structs::ExtensionEntry::DecodableType> latestValue;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace AccessControlExtensionChanged
} // namespace Events
} // namespace AccessControl
namespace Actions {
namespace Structs {
namespace ActionStruct {
enum class Fields
{
    kActionID          = 0,
    kName              = 1,
    kType              = 2,
    kEndpointListID    = 3,
    kSupportedCommands = 4,
    kState             = 5,
};

struct Type
{
public:
    uint16_t actionID = static_cast<uint16_t>(0);
    chip::CharSpan name;
    ActionTypeEnum type                          = static_cast<ActionTypeEnum>(0);
    uint16_t endpointListID                      = static_cast<uint16_t>(0);
    chip::BitMask<CommandBits> supportedCommands = static_cast<chip::BitMask<CommandBits>>(0);
    ActionStateEnum state                        = static_cast<ActionStateEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace ActionStruct
namespace EndpointListStruct {
enum class Fields
{
    kEndpointListID = 0,
    kName           = 1,
    kType           = 2,
    kEndpoints      = 3,
};

struct Type
{
public:
    uint16_t endpointListID = static_cast<uint16_t>(0);
    chip::CharSpan name;
    EndpointListTypeEnum type = static_cast<EndpointListTypeEnum>(0);
    DataModel::List<const chip::EndpointId> endpoints;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    uint16_t endpointListID = static_cast<uint16_t>(0);
    chip::CharSpan name;
    EndpointListTypeEnum type = static_cast<EndpointListTypeEnum>(0);
    DataModel::DecodableList<chip::EndpointId> endpoints;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace EndpointListStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace InstantAction {
struct Type;
struct DecodableType;
} // namespace InstantAction

namespace InstantActionWithTransition {
struct Type;
struct DecodableType;
} // namespace InstantActionWithTransition

namespace StartAction {
struct Type;
struct DecodableType;
} // namespace StartAction

namespace StartActionWithDuration {
struct Type;
struct DecodableType;
} // namespace StartActionWithDuration

namespace StopAction {
struct Type;
struct DecodableType;
} // namespace StopAction

namespace PauseAction {
struct Type;
struct DecodableType;
} // namespace PauseAction

namespace PauseActionWithDuration {
struct Type;
struct DecodableType;
} // namespace PauseActionWithDuration

namespace ResumeAction {
struct Type;
struct DecodableType;
} // namespace ResumeAction

namespace EnableAction {
struct Type;
struct DecodableType;
} // namespace EnableAction

namespace EnableActionWithDuration {
struct Type;
struct DecodableType;
} // namespace EnableActionWithDuration

namespace DisableAction {
struct Type;
struct DecodableType;
} // namespace DisableAction

namespace DisableActionWithDuration {
struct Type;
struct DecodableType;
} // namespace DisableActionWithDuration

} // namespace Commands

namespace Commands {
namespace InstantAction {
enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::InstantAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::InstantAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace InstantAction
namespace InstantActionWithTransition {
enum class Fields
{
    kActionID       = 0,
    kInvokeID       = 1,
    kTransitionTime = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::InstantActionWithTransition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint16_t transitionTime = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::InstantActionWithTransition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint16_t transitionTime = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace InstantActionWithTransition
namespace StartAction {
enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StartAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StartAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StartAction
namespace StartActionWithDuration {
enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
    kDuration = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StartActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StartActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StartActionWithDuration
namespace StopAction {
enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StopAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StopAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StopAction
namespace PauseAction {
enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::PauseAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::PauseAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace PauseAction
namespace PauseActionWithDuration {
enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
    kDuration = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::PauseActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::PauseActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace PauseActionWithDuration
namespace ResumeAction {
enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResumeAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResumeAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResumeAction
namespace EnableAction {
enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnableAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnableAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnableAction
namespace EnableActionWithDuration {
enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
    kDuration = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnableActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnableActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnableActionWithDuration
namespace DisableAction {
enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::DisableAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::DisableAction::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace DisableAction
namespace DisableActionWithDuration {
enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
    kDuration = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::DisableActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::DisableActionWithDuration::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID = static_cast<uint16_t>(0);
    Optional<uint32_t> invokeID;
    uint32_t duration = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace DisableActionWithDuration
} // namespace Commands

namespace Attributes {

namespace ActionList {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::Actions::Structs::ActionStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::ActionStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::ActionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActionList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActionList
namespace EndpointLists {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::Actions::Structs::EndpointListStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::EndpointListStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::EndpointListStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EndpointLists::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EndpointLists
namespace SetupURL {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SetupURL::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 512; }
};
} // namespace SetupURL
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::ActionList::TypeInfo::DecodableType actionList;
        Attributes::EndpointLists::TypeInfo::DecodableType endpointLists;
        Attributes::SetupURL::TypeInfo::DecodableType setupURL;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace StateChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
    kNewState = 2,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint16_t actionID        = static_cast<uint16_t>(0);
    uint32_t invokeID        = static_cast<uint32_t>(0);
    ActionStateEnum newState = static_cast<ActionStateEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID        = static_cast<uint16_t>(0);
    uint32_t invokeID        = static_cast<uint32_t>(0);
    ActionStateEnum newState = static_cast<ActionStateEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace StateChanged
namespace ActionFailed {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kActionID = 0,
    kInvokeID = 1,
    kNewState = 2,
    kError    = 3,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ActionFailed::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint16_t actionID        = static_cast<uint16_t>(0);
    uint32_t invokeID        = static_cast<uint32_t>(0);
    ActionStateEnum newState = static_cast<ActionStateEnum>(0);
    ActionErrorEnum error    = static_cast<ActionErrorEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ActionFailed::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Actions::Id; }

    uint16_t actionID        = static_cast<uint16_t>(0);
    uint32_t invokeID        = static_cast<uint32_t>(0);
    ActionStateEnum newState = static_cast<ActionStateEnum>(0);
    ActionErrorEnum error    = static_cast<ActionErrorEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ActionFailed
} // namespace Events
} // namespace Actions
namespace Basic {
namespace Structs {
namespace CapabilityMinimaStruct {
enum class Fields
{
    kCaseSessionsPerFabric  = 0,
    kSubscriptionsPerFabric = 1,
};

struct Type
{
public:
    uint16_t caseSessionsPerFabric  = static_cast<uint16_t>(0);
    uint16_t subscriptionsPerFabric = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace CapabilityMinimaStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace MfgSpecificPing {
struct Type;
struct DecodableType;
} // namespace MfgSpecificPing

} // namespace Commands

namespace Commands {
namespace MfgSpecificPing {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MfgSpecificPing::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MfgSpecificPing::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MfgSpecificPing
} // namespace Commands

namespace Attributes {

namespace DataModelRevision {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DataModelRevision::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DataModelRevision
namespace VendorName {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VendorName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace VendorName
namespace VendorID {
struct TypeInfo
{
    using Type             = chip::VendorId;
    using DecodableType    = chip::VendorId;
    using DecodableArgType = chip::VendorId;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VendorID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace VendorID
namespace ProductName {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace ProductName
namespace ProductID {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ProductID
namespace NodeLabel {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NodeLabel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace NodeLabel
namespace Location {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Location::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 2; }
};
} // namespace Location
namespace HardwareVersion {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HardwareVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HardwareVersion
namespace HardwareVersionString {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HardwareVersionString::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace HardwareVersionString
namespace SoftwareVersion {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SoftwareVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SoftwareVersion
namespace SoftwareVersionString {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SoftwareVersionString::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace SoftwareVersionString
namespace ManufacturingDate {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ManufacturingDate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace ManufacturingDate
namespace PartNumber {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PartNumber::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace PartNumber
namespace ProductURL {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductURL::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 256; }
};
} // namespace ProductURL
namespace ProductLabel {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductLabel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace ProductLabel
namespace SerialNumber {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SerialNumber::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace SerialNumber
namespace LocalConfigDisabled {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LocalConfigDisabled::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LocalConfigDisabled
namespace Reachable {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Reachable::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Reachable
namespace UniqueID {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UniqueID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace UniqueID
namespace CapabilityMinima {
struct TypeInfo
{
    using Type             = chip::app::Clusters::Basic::Structs::CapabilityMinimaStruct::Type;
    using DecodableType    = chip::app::Clusters::Basic::Structs::CapabilityMinimaStruct::DecodableType;
    using DecodableArgType = const chip::app::Clusters::Basic::Structs::CapabilityMinimaStruct::DecodableType &;

    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CapabilityMinima::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CapabilityMinima
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::DataModelRevision::TypeInfo::DecodableType dataModelRevision = static_cast<uint16_t>(0);
        Attributes::VendorName::TypeInfo::DecodableType vendorName;
        Attributes::VendorID::TypeInfo::DecodableType vendorID = static_cast<chip::VendorId>(0);
        Attributes::ProductName::TypeInfo::DecodableType productName;
        Attributes::ProductID::TypeInfo::DecodableType productID = static_cast<uint16_t>(0);
        Attributes::NodeLabel::TypeInfo::DecodableType nodeLabel;
        Attributes::Location::TypeInfo::DecodableType location;
        Attributes::HardwareVersion::TypeInfo::DecodableType hardwareVersion = static_cast<uint16_t>(0);
        Attributes::HardwareVersionString::TypeInfo::DecodableType hardwareVersionString;
        Attributes::SoftwareVersion::TypeInfo::DecodableType softwareVersion = static_cast<uint32_t>(0);
        Attributes::SoftwareVersionString::TypeInfo::DecodableType softwareVersionString;
        Attributes::ManufacturingDate::TypeInfo::DecodableType manufacturingDate;
        Attributes::PartNumber::TypeInfo::DecodableType partNumber;
        Attributes::ProductURL::TypeInfo::DecodableType productURL;
        Attributes::ProductLabel::TypeInfo::DecodableType productLabel;
        Attributes::SerialNumber::TypeInfo::DecodableType serialNumber;
        Attributes::LocalConfigDisabled::TypeInfo::DecodableType localConfigDisabled = static_cast<bool>(0);
        Attributes::Reachable::TypeInfo::DecodableType reachable                     = static_cast<bool>(0);
        Attributes::UniqueID::TypeInfo::DecodableType uniqueID;
        Attributes::CapabilityMinima::TypeInfo::DecodableType capabilityMinima;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace StartUp {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
    kSoftwareVersion = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StartUp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t softwareVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StartUp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }

    uint32_t softwareVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace StartUp
namespace ShutDown {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShutDown::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShutDown::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ShutDown
namespace Leave {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kFabricIndex = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Leave::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr bool kIsFabricScoped = false;

    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Leave::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }

    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Leave
namespace ReachableChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kReachableNewValue = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ReachableChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }
    static constexpr bool kIsFabricScoped = false;

    bool reachableNewValue = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ReachableChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Basic::Id; }

    bool reachableNewValue = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ReachableChanged
} // namespace Events
} // namespace Basic
namespace OtaSoftwareUpdateProvider {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace QueryImage {
struct Type;
struct DecodableType;
} // namespace QueryImage

namespace QueryImageResponse {
struct Type;
struct DecodableType;
} // namespace QueryImageResponse

namespace ApplyUpdateRequest {
struct Type;
struct DecodableType;
} // namespace ApplyUpdateRequest

namespace ApplyUpdateResponse {
struct Type;
struct DecodableType;
} // namespace ApplyUpdateResponse

namespace NotifyUpdateApplied {
struct Type;
struct DecodableType;
} // namespace NotifyUpdateApplied

} // namespace Commands

namespace Commands {
namespace QueryImage {
enum class Fields
{
    kVendorId            = 0,
    kProductId           = 1,
    kSoftwareVersion     = 2,
    kProtocolsSupported  = 3,
    kHardwareVersion     = 4,
    kLocation            = 5,
    kRequestorCanConsent = 6,
    kMetadataForProvider = 7,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::QueryImage::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::VendorId vendorId  = static_cast<chip::VendorId>(0);
    uint16_t productId       = static_cast<uint16_t>(0);
    uint32_t softwareVersion = static_cast<uint32_t>(0);
    DataModel::List<const OTADownloadProtocol> protocolsSupported;
    Optional<uint16_t> hardwareVersion;
    Optional<chip::CharSpan> location;
    Optional<bool> requestorCanConsent;
    Optional<chip::ByteSpan> metadataForProvider;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::OtaSoftwareUpdateProvider::Commands::QueryImageResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::QueryImage::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::VendorId vendorId  = static_cast<chip::VendorId>(0);
    uint16_t productId       = static_cast<uint16_t>(0);
    uint32_t softwareVersion = static_cast<uint32_t>(0);
    DataModel::DecodableList<OTADownloadProtocol> protocolsSupported;
    Optional<uint16_t> hardwareVersion;
    Optional<chip::CharSpan> location;
    Optional<bool> requestorCanConsent;
    Optional<chip::ByteSpan> metadataForProvider;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace QueryImage
namespace QueryImageResponse {
enum class Fields
{
    kStatus                = 0,
    kDelayedActionTime     = 1,
    kImageURI              = 2,
    kSoftwareVersion       = 3,
    kSoftwareVersionString = 4,
    kUpdateToken           = 5,
    kUserConsentNeeded     = 6,
    kMetadataForRequestor  = 7,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::QueryImageResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    OTAQueryStatus status = static_cast<OTAQueryStatus>(0);
    Optional<uint32_t> delayedActionTime;
    Optional<chip::CharSpan> imageURI;
    Optional<uint32_t> softwareVersion;
    Optional<chip::CharSpan> softwareVersionString;
    Optional<chip::ByteSpan> updateToken;
    Optional<bool> userConsentNeeded;
    Optional<chip::ByteSpan> metadataForRequestor;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::QueryImageResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    OTAQueryStatus status = static_cast<OTAQueryStatus>(0);
    Optional<uint32_t> delayedActionTime;
    Optional<chip::CharSpan> imageURI;
    Optional<uint32_t> softwareVersion;
    Optional<chip::CharSpan> softwareVersionString;
    Optional<chip::ByteSpan> updateToken;
    Optional<bool> userConsentNeeded;
    Optional<chip::ByteSpan> metadataForRequestor;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace QueryImageResponse
namespace ApplyUpdateRequest {
enum class Fields
{
    kUpdateToken = 0,
    kNewVersion  = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ApplyUpdateRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::ByteSpan updateToken;
    uint32_t newVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::OtaSoftwareUpdateProvider::Commands::ApplyUpdateResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ApplyUpdateRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::ByteSpan updateToken;
    uint32_t newVersion = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ApplyUpdateRequest
namespace ApplyUpdateResponse {
enum class Fields
{
    kAction            = 0,
    kDelayedActionTime = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ApplyUpdateResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    OTAApplyUpdateAction action = static_cast<OTAApplyUpdateAction>(0);
    uint32_t delayedActionTime  = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ApplyUpdateResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    OTAApplyUpdateAction action = static_cast<OTAApplyUpdateAction>(0);
    uint32_t delayedActionTime  = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ApplyUpdateResponse
namespace NotifyUpdateApplied {
enum class Fields
{
    kUpdateToken     = 0,
    kSoftwareVersion = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::NotifyUpdateApplied::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::ByteSpan updateToken;
    uint32_t softwareVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::NotifyUpdateApplied::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

    chip::ByteSpan updateToken;
    uint32_t softwareVersion = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace NotifyUpdateApplied
} // namespace Commands

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateProvider::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace OtaSoftwareUpdateProvider
namespace OtaSoftwareUpdateRequestor {
namespace Structs {
namespace ProviderLocation {
enum class Fields
{
    kProviderNodeID = 1,
    kEndpoint       = 2,
    kFabricIndex    = 254,
};

struct Type
{
public:
    chip::NodeId providerNodeID   = static_cast<chip::NodeId>(0);
    chip::EndpointId endpoint     = static_cast<chip::EndpointId>(0);
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & writer, TLV::Tag tag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & writer, TLV::Tag tag, FabricIndex accessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & writer, TLV::Tag tag, const Optional<FabricIndex> & accessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace ProviderLocation
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace AnnounceOtaProvider {
struct Type;
struct DecodableType;
} // namespace AnnounceOtaProvider

} // namespace Commands

namespace Commands {
namespace AnnounceOtaProvider {
enum class Fields
{
    kProviderNodeId     = 0,
    kVendorId           = 1,
    kAnnouncementReason = 2,
    kMetadataForNode    = 3,
    kEndpoint           = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AnnounceOtaProvider::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

    chip::NodeId providerNodeId              = static_cast<chip::NodeId>(0);
    chip::VendorId vendorId                  = static_cast<chip::VendorId>(0);
    OTAAnnouncementReason announcementReason = static_cast<OTAAnnouncementReason>(0);
    Optional<chip::ByteSpan> metadataForNode;
    chip::EndpointId endpoint = static_cast<chip::EndpointId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AnnounceOtaProvider::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

    chip::NodeId providerNodeId              = static_cast<chip::NodeId>(0);
    chip::VendorId vendorId                  = static_cast<chip::VendorId>(0);
    OTAAnnouncementReason announcementReason = static_cast<OTAAnnouncementReason>(0);
    Optional<chip::ByteSpan> metadataForNode;
    chip::EndpointId endpoint = static_cast<chip::EndpointId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AnnounceOtaProvider
} // namespace Commands

namespace Attributes {

namespace DefaultOtaProviders {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<
        chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultOtaProviders::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DefaultOtaProviders
namespace UpdatePossible {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UpdatePossible::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UpdatePossible
namespace UpdateState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::OtaSoftwareUpdateRequestor::OTAUpdateStateEnum;
    using DecodableType    = chip::app::Clusters::OtaSoftwareUpdateRequestor::OTAUpdateStateEnum;
    using DecodableArgType = chip::app::Clusters::OtaSoftwareUpdateRequestor::OTAUpdateStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UpdateState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UpdateState
namespace UpdateStateProgress {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UpdateStateProgress::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UpdateStateProgress
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::DefaultOtaProviders::TypeInfo::DecodableType defaultOtaProviders;
        Attributes::UpdatePossible::TypeInfo::DecodableType updatePossible = static_cast<bool>(0);
        Attributes::UpdateState::TypeInfo::DecodableType updateState =
            static_cast<chip::app::Clusters::OtaSoftwareUpdateRequestor::OTAUpdateStateEnum>(0);
        Attributes::UpdateStateProgress::TypeInfo::DecodableType updateStateProgress;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace StateTransition {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kPreviousState         = 0,
    kNewState              = 1,
    kReason                = 2,
    kTargetSoftwareVersion = 3,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateTransition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr bool kIsFabricScoped = false;

    OTAUpdateStateEnum previousState = static_cast<OTAUpdateStateEnum>(0);
    OTAUpdateStateEnum newState      = static_cast<OTAUpdateStateEnum>(0);
    OTAChangeReasonEnum reason       = static_cast<OTAChangeReasonEnum>(0);
    DataModel::Nullable<uint32_t> targetSoftwareVersion;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateTransition::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

    OTAUpdateStateEnum previousState = static_cast<OTAUpdateStateEnum>(0);
    OTAUpdateStateEnum newState      = static_cast<OTAUpdateStateEnum>(0);
    OTAChangeReasonEnum reason       = static_cast<OTAChangeReasonEnum>(0);
    DataModel::Nullable<uint32_t> targetSoftwareVersion;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace StateTransition
namespace VersionApplied {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
    kSoftwareVersion = 0,
    kProductID       = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::VersionApplied::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t softwareVersion = static_cast<uint32_t>(0);
    uint16_t productID       = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::VersionApplied::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

    uint32_t softwareVersion = static_cast<uint32_t>(0);
    uint16_t productID       = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace VersionApplied
namespace DownloadError {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kSoftwareVersion = 0,
    kBytesDownloaded = 1,
    kProgressPercent = 2,
    kPlatformCode    = 3,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DownloadError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t softwareVersion = static_cast<uint32_t>(0);
    uint64_t bytesDownloaded = static_cast<uint64_t>(0);
    DataModel::Nullable<uint8_t> progressPercent;
    DataModel::Nullable<int64_t> platformCode;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DownloadError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OtaSoftwareUpdateRequestor::Id; }

    uint32_t softwareVersion = static_cast<uint32_t>(0);
    uint64_t bytesDownloaded = static_cast<uint64_t>(0);
    DataModel::Nullable<uint8_t> progressPercent;
    DataModel::Nullable<int64_t> platformCode;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace DownloadError
} // namespace Events
} // namespace OtaSoftwareUpdateRequestor
namespace LocalizationConfiguration {

namespace Attributes {

namespace ActiveLocale {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveLocale::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 35; }
};
} // namespace ActiveLocale
namespace SupportedLocales {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::CharSpan>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::CharSpan>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::CharSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedLocales::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedLocales
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::LocalizationConfiguration::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::ActiveLocale::TypeInfo::DecodableType activeLocale;
        Attributes::SupportedLocales::TypeInfo::DecodableType supportedLocales;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace LocalizationConfiguration
namespace TimeFormatLocalization {

namespace Attributes {

namespace HourFormat {
struct TypeInfo
{
    using Type             = chip::app::Clusters::TimeFormatLocalization::HourFormat;
    using DecodableType    = chip::app::Clusters::TimeFormatLocalization::HourFormat;
    using DecodableArgType = chip::app::Clusters::TimeFormatLocalization::HourFormat;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HourFormat::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HourFormat
namespace ActiveCalendarType {
struct TypeInfo
{
    using Type             = chip::app::Clusters::TimeFormatLocalization::CalendarType;
    using DecodableType    = chip::app::Clusters::TimeFormatLocalization::CalendarType;
    using DecodableArgType = chip::app::Clusters::TimeFormatLocalization::CalendarType;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveCalendarType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveCalendarType
namespace SupportedCalendarTypes {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::app::Clusters::TimeFormatLocalization::CalendarType>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::app::Clusters::TimeFormatLocalization::CalendarType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::app::Clusters::TimeFormatLocalization::CalendarType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedCalendarTypes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedCalendarTypes
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::TimeFormatLocalization::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::HourFormat::TypeInfo::DecodableType hourFormat =
            static_cast<chip::app::Clusters::TimeFormatLocalization::HourFormat>(0);
        Attributes::ActiveCalendarType::TypeInfo::DecodableType activeCalendarType =
            static_cast<chip::app::Clusters::TimeFormatLocalization::CalendarType>(0);
        Attributes::SupportedCalendarTypes::TypeInfo::DecodableType supportedCalendarTypes;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace TimeFormatLocalization
namespace UnitLocalization {

namespace Attributes {

namespace TemperatureUnit {
struct TypeInfo
{
    using Type             = chip::app::Clusters::UnitLocalization::TempUnit;
    using DecodableType    = chip::app::Clusters::UnitLocalization::TempUnit;
    using DecodableArgType = chip::app::Clusters::UnitLocalization::TempUnit;

    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TemperatureUnit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TemperatureUnit
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::UnitLocalization::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::TemperatureUnit::TypeInfo::DecodableType temperatureUnit =
            static_cast<chip::app::Clusters::UnitLocalization::TempUnit>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace UnitLocalization
namespace PowerSourceConfiguration {

namespace Attributes {

namespace Sources {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const uint8_t>;
    using DecodableType    = chip::app::DataModel::DecodableList<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Sources::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Sources
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::PowerSourceConfiguration::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Sources::TypeInfo::DecodableType sources;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace PowerSourceConfiguration
namespace PowerSource {
namespace Structs {
namespace BatChargeFaultChangeType {
enum class Fields
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    DataModel::List<const BatChargeFault> current;
    DataModel::List<const BatChargeFault> previous;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    DataModel::DecodableList<BatChargeFault> current;
    DataModel::DecodableList<BatChargeFault> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace BatChargeFaultChangeType
namespace BatFaultChangeType {
enum class Fields
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    DataModel::List<const BatFault> current;
    DataModel::List<const BatFault> previous;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    DataModel::DecodableList<BatFault> current;
    DataModel::DecodableList<BatFault> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace BatFaultChangeType
namespace WiredFaultChangeType {
enum class Fields
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    DataModel::List<const WiredFault> current;
    DataModel::List<const WiredFault> previous;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    DataModel::DecodableList<WiredFault> current;
    DataModel::DecodableList<WiredFault> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace WiredFaultChangeType
} // namespace Structs

namespace Attributes {

namespace Status {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::PowerSourceStatus;
    using DecodableType    = chip::app::Clusters::PowerSource::PowerSourceStatus;
    using DecodableArgType = chip::app::Clusters::PowerSource::PowerSourceStatus;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Status::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Status
namespace Order {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Order::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Order
namespace Description {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Description::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 60; }
};
} // namespace Description
namespace WiredAssessedInputVoltage {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredAssessedInputVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredAssessedInputVoltage
namespace WiredAssessedInputFrequency {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredAssessedInputFrequency::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredAssessedInputFrequency
namespace WiredCurrentType {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::WiredCurrentType;
    using DecodableType    = chip::app::Clusters::PowerSource::WiredCurrentType;
    using DecodableArgType = chip::app::Clusters::PowerSource::WiredCurrentType;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredCurrentType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredCurrentType
namespace WiredAssessedCurrent {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredAssessedCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredAssessedCurrent
namespace WiredNominalVoltage {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredNominalVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredNominalVoltage
namespace WiredMaximumCurrent {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredMaximumCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredMaximumCurrent
namespace WiredPresent {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiredPresent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiredPresent
namespace ActiveWiredFaults {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::app::Clusters::PowerSource::WiredFault>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::WiredFault>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::WiredFault> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveWiredFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveWiredFaults
namespace BatVoltage {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatVoltage
namespace BatPercentRemaining {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatPercentRemaining::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatPercentRemaining
namespace BatTimeRemaining {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatTimeRemaining::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatTimeRemaining
namespace BatChargeLevel {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::BatChargeLevel;
    using DecodableType    = chip::app::Clusters::PowerSource::BatChargeLevel;
    using DecodableArgType = chip::app::Clusters::PowerSource::BatChargeLevel;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatChargeLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatChargeLevel
namespace BatReplacementNeeded {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatReplacementNeeded::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatReplacementNeeded
namespace BatReplaceability {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::BatReplaceability;
    using DecodableType    = chip::app::Clusters::PowerSource::BatReplaceability;
    using DecodableArgType = chip::app::Clusters::PowerSource::BatReplaceability;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatReplaceability::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatReplaceability
namespace BatPresent {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatPresent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatPresent
namespace ActiveBatFaults {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::app::Clusters::PowerSource::BatFault>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatFault>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatFault> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveBatFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveBatFaults
namespace BatReplacementDescription {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatReplacementDescription::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 60; }
};
} // namespace BatReplacementDescription
namespace BatCommonDesignation {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatCommonDesignation::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatCommonDesignation
namespace BatANSIDesignation {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatANSIDesignation::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 20; }
};
} // namespace BatANSIDesignation
namespace BatIECDesignation {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatIECDesignation::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 20; }
};
} // namespace BatIECDesignation
namespace BatApprovedChemistry {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatApprovedChemistry::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatApprovedChemistry
namespace BatCapacity {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatCapacity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatCapacity
namespace BatQuantity {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatQuantity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatQuantity
namespace BatChargeState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PowerSource::BatChargeState;
    using DecodableType    = chip::app::Clusters::PowerSource::BatChargeState;
    using DecodableArgType = chip::app::Clusters::PowerSource::BatChargeState;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatChargeState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatChargeState
namespace BatTimeToFullCharge {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatTimeToFullCharge::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatTimeToFullCharge
namespace BatFunctionalWhileCharging {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatFunctionalWhileCharging::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatFunctionalWhileCharging
namespace BatChargingCurrent {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BatChargingCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BatChargingCurrent
namespace ActiveBatChargeFaults {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::app::Clusters::PowerSource::BatChargeFault>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatChargeFault>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatChargeFault> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveBatChargeFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveBatChargeFaults
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::PowerSource::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Status::TypeInfo::DecodableType status = static_cast<chip::app::Clusters::PowerSource::PowerSourceStatus>(0);
        Attributes::Order::TypeInfo::DecodableType order   = static_cast<uint8_t>(0);
        Attributes::Description::TypeInfo::DecodableType description;
        Attributes::WiredAssessedInputVoltage::TypeInfo::DecodableType wiredAssessedInputVoltage;
        Attributes::WiredAssessedInputFrequency::TypeInfo::DecodableType wiredAssessedInputFrequency;
        Attributes::WiredCurrentType::TypeInfo::DecodableType wiredCurrentType =
            static_cast<chip::app::Clusters::PowerSource::WiredCurrentType>(0);
        Attributes::WiredAssessedCurrent::TypeInfo::DecodableType wiredAssessedCurrent;
        Attributes::WiredNominalVoltage::TypeInfo::DecodableType wiredNominalVoltage = static_cast<uint32_t>(0);
        Attributes::WiredMaximumCurrent::TypeInfo::DecodableType wiredMaximumCurrent = static_cast<uint32_t>(0);
        Attributes::WiredPresent::TypeInfo::DecodableType wiredPresent               = static_cast<bool>(0);
        Attributes::ActiveWiredFaults::TypeInfo::DecodableType activeWiredFaults;
        Attributes::BatVoltage::TypeInfo::DecodableType batVoltage;
        Attributes::BatPercentRemaining::TypeInfo::DecodableType batPercentRemaining;
        Attributes::BatTimeRemaining::TypeInfo::DecodableType batTimeRemaining;
        Attributes::BatChargeLevel::TypeInfo::DecodableType batChargeLevel =
            static_cast<chip::app::Clusters::PowerSource::BatChargeLevel>(0);
        Attributes::BatReplacementNeeded::TypeInfo::DecodableType batReplacementNeeded = static_cast<bool>(0);
        Attributes::BatReplaceability::TypeInfo::DecodableType batReplaceability =
            static_cast<chip::app::Clusters::PowerSource::BatReplaceability>(0);
        Attributes::BatPresent::TypeInfo::DecodableType batPresent = static_cast<bool>(0);
        Attributes::ActiveBatFaults::TypeInfo::DecodableType activeBatFaults;
        Attributes::BatReplacementDescription::TypeInfo::DecodableType batReplacementDescription;
        Attributes::BatCommonDesignation::TypeInfo::DecodableType batCommonDesignation = static_cast<uint32_t>(0);
        Attributes::BatANSIDesignation::TypeInfo::DecodableType batANSIDesignation;
        Attributes::BatIECDesignation::TypeInfo::DecodableType batIECDesignation;
        Attributes::BatApprovedChemistry::TypeInfo::DecodableType batApprovedChemistry = static_cast<uint32_t>(0);
        Attributes::BatCapacity::TypeInfo::DecodableType batCapacity                   = static_cast<uint32_t>(0);
        Attributes::BatQuantity::TypeInfo::DecodableType batQuantity                   = static_cast<uint8_t>(0);
        Attributes::BatChargeState::TypeInfo::DecodableType batChargeState =
            static_cast<chip::app::Clusters::PowerSource::BatChargeState>(0);
        Attributes::BatTimeToFullCharge::TypeInfo::DecodableType batTimeToFullCharge;
        Attributes::BatFunctionalWhileCharging::TypeInfo::DecodableType batFunctionalWhileCharging = static_cast<bool>(0);
        Attributes::BatChargingCurrent::TypeInfo::DecodableType batChargingCurrent;
        Attributes::ActiveBatChargeFaults::TypeInfo::DecodableType activeBatChargeFaults;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace PowerSource
namespace GeneralCommissioning {
namespace Structs {
namespace BasicCommissioningInfo {
enum class Fields
{
    kFailSafeExpiryLengthSeconds  = 0,
    kMaxCumulativeFailsafeSeconds = 1,
};

struct Type
{
public:
    uint16_t failSafeExpiryLengthSeconds  = static_cast<uint16_t>(0);
    uint16_t maxCumulativeFailsafeSeconds = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace BasicCommissioningInfo
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ArmFailSafe {
struct Type;
struct DecodableType;
} // namespace ArmFailSafe

namespace ArmFailSafeResponse {
struct Type;
struct DecodableType;
} // namespace ArmFailSafeResponse

namespace SetRegulatoryConfig {
struct Type;
struct DecodableType;
} // namespace SetRegulatoryConfig

namespace SetRegulatoryConfigResponse {
struct Type;
struct DecodableType;
} // namespace SetRegulatoryConfigResponse

namespace CommissioningComplete {
struct Type;
struct DecodableType;
} // namespace CommissioningComplete

namespace CommissioningCompleteResponse {
struct Type;
struct DecodableType;
} // namespace CommissioningCompleteResponse

} // namespace Commands

namespace Commands {
namespace ArmFailSafe {
enum class Fields
{
    kExpiryLengthSeconds = 0,
    kBreadcrumb          = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ArmFailSafe::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    uint16_t expiryLengthSeconds = static_cast<uint16_t>(0);
    uint64_t breadcrumb          = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::GeneralCommissioning::Commands::ArmFailSafeResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ArmFailSafe::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    uint16_t expiryLengthSeconds = static_cast<uint16_t>(0);
    uint64_t breadcrumb          = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ArmFailSafe
namespace ArmFailSafeResponse {
enum class Fields
{
    kErrorCode = 0,
    kDebugText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ArmFailSafeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningError errorCode = static_cast<CommissioningError>(0);
    chip::CharSpan debugText;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ArmFailSafeResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningError errorCode = static_cast<CommissioningError>(0);
    chip::CharSpan debugText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ArmFailSafeResponse
namespace SetRegulatoryConfig {
enum class Fields
{
    kNewRegulatoryConfig = 0,
    kCountryCode         = 1,
    kBreadcrumb          = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetRegulatoryConfig::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    RegulatoryLocationType newRegulatoryConfig = static_cast<RegulatoryLocationType>(0);
    chip::CharSpan countryCode;
    uint64_t breadcrumb = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::GeneralCommissioning::Commands::SetRegulatoryConfigResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetRegulatoryConfig::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    RegulatoryLocationType newRegulatoryConfig = static_cast<RegulatoryLocationType>(0);
    chip::CharSpan countryCode;
    uint64_t breadcrumb = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetRegulatoryConfig
namespace SetRegulatoryConfigResponse {
enum class Fields
{
    kErrorCode = 0,
    kDebugText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetRegulatoryConfigResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningError errorCode = static_cast<CommissioningError>(0);
    chip::CharSpan debugText;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetRegulatoryConfigResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningError errorCode = static_cast<CommissioningError>(0);
    chip::CharSpan debugText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetRegulatoryConfigResponse
namespace CommissioningComplete {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CommissioningComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::GeneralCommissioning::Commands::CommissioningCompleteResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CommissioningComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CommissioningComplete
namespace CommissioningCompleteResponse {
enum class Fields
{
    kErrorCode = 0,
    kDebugText = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CommissioningCompleteResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningError errorCode = static_cast<CommissioningError>(0);
    chip::CharSpan debugText;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CommissioningCompleteResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

    CommissioningError errorCode = static_cast<CommissioningError>(0);
    chip::CharSpan debugText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CommissioningCompleteResponse
} // namespace Commands

namespace Attributes {

namespace Breadcrumb {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Breadcrumb::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Breadcrumb
namespace BasicCommissioningInfo {
struct TypeInfo
{
    using Type             = chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::Type;
    using DecodableType    = chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::DecodableType;
    using DecodableArgType = const chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::DecodableType &;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BasicCommissioningInfo::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BasicCommissioningInfo
namespace RegulatoryConfig {
struct TypeInfo
{
    using Type             = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType;
    using DecodableType    = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType;
    using DecodableArgType = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RegulatoryConfig::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RegulatoryConfig
namespace LocationCapability {
struct TypeInfo
{
    using Type             = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType;
    using DecodableType    = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType;
    using DecodableArgType = chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LocationCapability::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LocationCapability
namespace SupportsConcurrentConnection {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportsConcurrentConnection::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportsConcurrentConnection
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::GeneralCommissioning::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Breadcrumb::TypeInfo::DecodableType breadcrumb = static_cast<uint64_t>(0);
        Attributes::BasicCommissioningInfo::TypeInfo::DecodableType basicCommissioningInfo;
        Attributes::RegulatoryConfig::TypeInfo::DecodableType regulatoryConfig =
            static_cast<chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType>(0);
        Attributes::LocationCapability::TypeInfo::DecodableType locationCapability =
            static_cast<chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType>(0);
        Attributes::SupportsConcurrentConnection::TypeInfo::DecodableType supportsConcurrentConnection = static_cast<bool>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace GeneralCommissioning
namespace NetworkCommissioning {
namespace Structs {
namespace NetworkInfo {
enum class Fields
{
    kNetworkID = 0,
    kConnected = 1,
};

struct Type
{
public:
    chip::ByteSpan networkID;
    bool connected = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace NetworkInfo
namespace ThreadInterfaceScanResult {
enum class Fields
{
    kPanId           = 0,
    kExtendedPanId   = 1,
    kNetworkName     = 2,
    kChannel         = 3,
    kVersion         = 4,
    kExtendedAddress = 5,
    kRssi            = 6,
    kLqi             = 7,
};

struct Type
{
public:
    uint16_t panId         = static_cast<uint16_t>(0);
    uint64_t extendedPanId = static_cast<uint64_t>(0);
    chip::CharSpan networkName;
    uint16_t channel = static_cast<uint16_t>(0);
    uint8_t version  = static_cast<uint8_t>(0);
    chip::ByteSpan extendedAddress;
    int8_t rssi = static_cast<int8_t>(0);
    uint8_t lqi = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace ThreadInterfaceScanResult
namespace WiFiInterfaceScanResult {
enum class Fields
{
    kSecurity = 0,
    kSsid     = 1,
    kBssid    = 2,
    kChannel  = 3,
    kWiFiBand = 4,
    kRssi     = 5,
};

struct Type
{
public:
    chip::BitMask<WiFiSecurity> security = static_cast<chip::BitMask<WiFiSecurity>>(0);
    chip::ByteSpan ssid;
    chip::ByteSpan bssid;
    uint16_t channel  = static_cast<uint16_t>(0);
    WiFiBand wiFiBand = static_cast<WiFiBand>(0);
    int8_t rssi       = static_cast<int8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace WiFiInterfaceScanResult
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ScanNetworks {
struct Type;
struct DecodableType;
} // namespace ScanNetworks

namespace ScanNetworksResponse {
struct Type;
struct DecodableType;
} // namespace ScanNetworksResponse

namespace AddOrUpdateWiFiNetwork {
struct Type;
struct DecodableType;
} // namespace AddOrUpdateWiFiNetwork

namespace AddOrUpdateThreadNetwork {
struct Type;
struct DecodableType;
} // namespace AddOrUpdateThreadNetwork

namespace RemoveNetwork {
struct Type;
struct DecodableType;
} // namespace RemoveNetwork

namespace NetworkConfigResponse {
struct Type;
struct DecodableType;
} // namespace NetworkConfigResponse

namespace ConnectNetwork {
struct Type;
struct DecodableType;
} // namespace ConnectNetwork

namespace ConnectNetworkResponse {
struct Type;
struct DecodableType;
} // namespace ConnectNetworkResponse

namespace ReorderNetwork {
struct Type;
struct DecodableType;
} // namespace ReorderNetwork

} // namespace Commands

namespace Commands {
namespace ScanNetworks {
enum class Fields
{
    kSsid       = 0,
    kBreadcrumb = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ScanNetworks::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    Optional<DataModel::Nullable<chip::ByteSpan>> ssid;
    Optional<uint64_t> breadcrumb;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::ScanNetworksResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ScanNetworks::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    Optional<DataModel::Nullable<chip::ByteSpan>> ssid;
    Optional<uint64_t> breadcrumb;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ScanNetworks
namespace ScanNetworksResponse {
enum class Fields
{
    kNetworkingStatus  = 0,
    kDebugText         = 1,
    kWiFiScanResults   = 2,
    kThreadScanResults = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ScanNetworksResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatus networkingStatus = static_cast<NetworkCommissioningStatus>(0);
    Optional<chip::CharSpan> debugText;
    Optional<DataModel::List<const Structs::WiFiInterfaceScanResult::Type>> wiFiScanResults;
    Optional<DataModel::List<const Structs::ThreadInterfaceScanResult::Type>> threadScanResults;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ScanNetworksResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatus networkingStatus = static_cast<NetworkCommissioningStatus>(0);
    Optional<chip::CharSpan> debugText;
    Optional<DataModel::DecodableList<Structs::WiFiInterfaceScanResult::DecodableType>> wiFiScanResults;
    Optional<DataModel::DecodableList<Structs::ThreadInterfaceScanResult::DecodableType>> threadScanResults;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ScanNetworksResponse
namespace AddOrUpdateWiFiNetwork {
enum class Fields
{
    kSsid        = 0,
    kCredentials = 1,
    kBreadcrumb  = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddOrUpdateWiFiNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan ssid;
    chip::ByteSpan credentials;
    Optional<uint64_t> breadcrumb;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddOrUpdateWiFiNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan ssid;
    chip::ByteSpan credentials;
    Optional<uint64_t> breadcrumb;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddOrUpdateWiFiNetwork
namespace AddOrUpdateThreadNetwork {
enum class Fields
{
    kOperationalDataset = 0,
    kBreadcrumb         = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddOrUpdateThreadNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan operationalDataset;
    Optional<uint64_t> breadcrumb;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddOrUpdateThreadNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan operationalDataset;
    Optional<uint64_t> breadcrumb;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddOrUpdateThreadNetwork
namespace RemoveNetwork {
enum class Fields
{
    kNetworkID  = 0,
    kBreadcrumb = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    Optional<uint64_t> breadcrumb;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    Optional<uint64_t> breadcrumb;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveNetwork
namespace NetworkConfigResponse {
enum class Fields
{
    kNetworkingStatus = 0,
    kDebugText        = 1,
    kNetworkIndex     = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::NetworkConfigResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatus networkingStatus = static_cast<NetworkCommissioningStatus>(0);
    Optional<chip::CharSpan> debugText;
    Optional<uint8_t> networkIndex;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::NetworkConfigResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatus networkingStatus = static_cast<NetworkCommissioningStatus>(0);
    Optional<chip::CharSpan> debugText;
    Optional<uint8_t> networkIndex;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace NetworkConfigResponse
namespace ConnectNetwork {
enum class Fields
{
    kNetworkID  = 0,
    kBreadcrumb = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ConnectNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    Optional<uint64_t> breadcrumb;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::ConnectNetworkResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ConnectNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    Optional<uint64_t> breadcrumb;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ConnectNetwork
namespace ConnectNetworkResponse {
enum class Fields
{
    kNetworkingStatus = 0,
    kDebugText        = 1,
    kErrorValue       = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ConnectNetworkResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatus networkingStatus = static_cast<NetworkCommissioningStatus>(0);
    Optional<chip::CharSpan> debugText;
    DataModel::Nullable<int32_t> errorValue;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ConnectNetworkResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    NetworkCommissioningStatus networkingStatus = static_cast<NetworkCommissioningStatus>(0);
    Optional<chip::CharSpan> debugText;
    DataModel::Nullable<int32_t> errorValue;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ConnectNetworkResponse
namespace ReorderNetwork {
enum class Fields
{
    kNetworkID    = 0,
    kNetworkIndex = 1,
    kBreadcrumb   = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ReorderNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    uint8_t networkIndex = static_cast<uint8_t>(0);
    Optional<uint64_t> breadcrumb;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ReorderNetwork::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

    chip::ByteSpan networkID;
    uint8_t networkIndex = static_cast<uint8_t>(0);
    Optional<uint64_t> breadcrumb;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ReorderNetwork
} // namespace Commands

namespace Attributes {

namespace MaxNetworks {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxNetworks::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxNetworks
namespace Networks {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfo::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfo::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfo::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Networks::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Networks
namespace ScanMaxTimeSeconds {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ScanMaxTimeSeconds::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ScanMaxTimeSeconds
namespace ConnectMaxTimeSeconds {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ConnectMaxTimeSeconds::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ConnectMaxTimeSeconds
namespace InterfaceEnabled {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InterfaceEnabled::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InterfaceEnabled
namespace LastNetworkingStatus {
struct TypeInfo
{
    using Type          = chip::app::DataModel::Nullable<chip::app::Clusters::NetworkCommissioning::NetworkCommissioningStatus>;
    using DecodableType = chip::app::DataModel::Nullable<chip::app::Clusters::NetworkCommissioning::NetworkCommissioningStatus>;
    using DecodableArgType =
        const chip::app::DataModel::Nullable<chip::app::Clusters::NetworkCommissioning::NetworkCommissioningStatus> &;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LastNetworkingStatus::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LastNetworkingStatus
namespace LastNetworkID {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LastNetworkID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace LastNetworkID
namespace LastConnectErrorValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LastConnectErrorValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LastConnectErrorValue
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::NetworkCommissioning::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::MaxNetworks::TypeInfo::DecodableType maxNetworks = static_cast<uint8_t>(0);
        Attributes::Networks::TypeInfo::DecodableType networks;
        Attributes::ScanMaxTimeSeconds::TypeInfo::DecodableType scanMaxTimeSeconds       = static_cast<uint8_t>(0);
        Attributes::ConnectMaxTimeSeconds::TypeInfo::DecodableType connectMaxTimeSeconds = static_cast<uint8_t>(0);
        Attributes::InterfaceEnabled::TypeInfo::DecodableType interfaceEnabled           = static_cast<bool>(0);
        Attributes::LastNetworkingStatus::TypeInfo::DecodableType lastNetworkingStatus;
        Attributes::LastNetworkID::TypeInfo::DecodableType lastNetworkID;
        Attributes::LastConnectErrorValue::TypeInfo::DecodableType lastConnectErrorValue;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace NetworkCommissioning
namespace DiagnosticLogs {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace RetrieveLogsRequest {
struct Type;
struct DecodableType;
} // namespace RetrieveLogsRequest

namespace RetrieveLogsResponse {
struct Type;
struct DecodableType;
} // namespace RetrieveLogsResponse

} // namespace Commands

namespace Commands {
namespace RetrieveLogsRequest {
enum class Fields
{
    kIntent                 = 0,
    kRequestedProtocol      = 1,
    kTransferFileDesignator = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RetrieveLogsRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }

    LogsIntent intent                      = static_cast<LogsIntent>(0);
    LogsTransferProtocol requestedProtocol = static_cast<LogsTransferProtocol>(0);
    chip::ByteSpan transferFileDesignator;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::DiagnosticLogs::Commands::RetrieveLogsResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RetrieveLogsRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }

    LogsIntent intent                      = static_cast<LogsIntent>(0);
    LogsTransferProtocol requestedProtocol = static_cast<LogsTransferProtocol>(0);
    chip::ByteSpan transferFileDesignator;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RetrieveLogsRequest
namespace RetrieveLogsResponse {
enum class Fields
{
    kStatus        = 0,
    kContent       = 1,
    kTimeStamp     = 2,
    kTimeSinceBoot = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RetrieveLogsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }

    LogsStatus status = static_cast<LogsStatus>(0);
    chip::ByteSpan content;
    uint32_t timeStamp     = static_cast<uint32_t>(0);
    uint32_t timeSinceBoot = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RetrieveLogsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }

    LogsStatus status = static_cast<LogsStatus>(0);
    chip::ByteSpan content;
    uint32_t timeStamp     = static_cast<uint32_t>(0);
    uint32_t timeSinceBoot = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RetrieveLogsResponse
} // namespace Commands

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::DiagnosticLogs::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace DiagnosticLogs
namespace GeneralDiagnostics {
namespace Structs {
namespace NetworkInterfaceType {
enum class Fields
{
    kName                            = 0,
    kIsOperational                   = 1,
    kOffPremiseServicesReachableIPv4 = 2,
    kOffPremiseServicesReachableIPv6 = 3,
    kHardwareAddress                 = 4,
    kIPv4Addresses                   = 5,
    kIPv6Addresses                   = 6,
    kType                            = 7,
};

struct Type
{
public:
    chip::CharSpan name;
    bool isOperational = static_cast<bool>(0);
    DataModel::Nullable<bool> offPremiseServicesReachableIPv4;
    DataModel::Nullable<bool> offPremiseServicesReachableIPv6;
    chip::ByteSpan hardwareAddress;
    DataModel::List<const chip::ByteSpan> IPv4Addresses;
    DataModel::List<const chip::ByteSpan> IPv6Addresses;
    InterfaceType type = static_cast<InterfaceType>(0);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    chip::CharSpan name;
    bool isOperational = static_cast<bool>(0);
    DataModel::Nullable<bool> offPremiseServicesReachableIPv4;
    DataModel::Nullable<bool> offPremiseServicesReachableIPv6;
    chip::ByteSpan hardwareAddress;
    DataModel::DecodableList<chip::ByteSpan> IPv4Addresses;
    DataModel::DecodableList<chip::ByteSpan> IPv6Addresses;
    InterfaceType type = static_cast<InterfaceType>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace NetworkInterfaceType
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace TestEventTrigger {
struct Type;
struct DecodableType;
} // namespace TestEventTrigger

} // namespace Commands

namespace Commands {
namespace TestEventTrigger {
enum class Fields
{
    kEnableKey    = 0,
    kEventTrigger = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestEventTrigger::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    chip::ByteSpan enableKey;
    uint64_t eventTrigger = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestEventTrigger::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    chip::ByteSpan enableKey;
    uint64_t eventTrigger = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestEventTrigger
} // namespace Commands

namespace Attributes {

namespace NetworkInterfaces {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterfaceType::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterfaceType::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterfaceType::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NetworkInterfaces::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NetworkInterfaces
namespace RebootCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RebootCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RebootCount
namespace UpTime {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UpTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UpTime
namespace TotalOperationalHours {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TotalOperationalHours::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TotalOperationalHours
namespace BootReasons {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BootReasons::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BootReasons
namespace ActiveHardwareFaults {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const uint8_t>;
    using DecodableType    = chip::app::DataModel::DecodableList<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveHardwareFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveHardwareFaults
namespace ActiveRadioFaults {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const uint8_t>;
    using DecodableType    = chip::app::DataModel::DecodableList<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveRadioFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveRadioFaults
namespace ActiveNetworkFaults {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const uint8_t>;
    using DecodableType    = chip::app::DataModel::DecodableList<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveNetworkFaults::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveNetworkFaults
namespace TestEventTriggersEnabled {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TestEventTriggersEnabled::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TestEventTriggersEnabled
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::NetworkInterfaces::TypeInfo::DecodableType networkInterfaces;
        Attributes::RebootCount::TypeInfo::DecodableType rebootCount                     = static_cast<uint16_t>(0);
        Attributes::UpTime::TypeInfo::DecodableType upTime                               = static_cast<uint64_t>(0);
        Attributes::TotalOperationalHours::TypeInfo::DecodableType totalOperationalHours = static_cast<uint32_t>(0);
        Attributes::BootReasons::TypeInfo::DecodableType bootReasons                     = static_cast<uint8_t>(0);
        Attributes::ActiveHardwareFaults::TypeInfo::DecodableType activeHardwareFaults;
        Attributes::ActiveRadioFaults::TypeInfo::DecodableType activeRadioFaults;
        Attributes::ActiveNetworkFaults::TypeInfo::DecodableType activeNetworkFaults;
        Attributes::TestEventTriggersEnabled::TypeInfo::DecodableType testEventTriggersEnabled = static_cast<bool>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace HardwareFaultChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::HardwareFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const HardwareFaultType> current;
    DataModel::List<const HardwareFaultType> previous;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::HardwareFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    DataModel::DecodableList<HardwareFaultType> current;
    DataModel::DecodableList<HardwareFaultType> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace HardwareFaultChange
namespace RadioFaultChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::RadioFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const RadioFaultType> current;
    DataModel::List<const RadioFaultType> previous;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::RadioFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    DataModel::DecodableList<RadioFaultType> current;
    DataModel::DecodableList<RadioFaultType> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace RadioFaultChange
namespace NetworkFaultChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::NetworkFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const NetworkFaultType> current;
    DataModel::List<const NetworkFaultType> previous;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::NetworkFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    DataModel::DecodableList<NetworkFaultType> current;
    DataModel::DecodableList<NetworkFaultType> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace NetworkFaultChange
namespace BootReason {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
    kBootReason = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BootReason::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    BootReasonType bootReason = static_cast<BootReasonType>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::BootReason::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GeneralDiagnostics::Id; }

    BootReasonType bootReason = static_cast<BootReasonType>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace BootReason
} // namespace Events
} // namespace GeneralDiagnostics
namespace SoftwareDiagnostics {
namespace Structs {
namespace ThreadMetrics {
enum class Fields
{
    kId               = 0,
    kName             = 1,
    kStackFreeCurrent = 2,
    kStackFreeMinimum = 3,
    kStackSize        = 4,
};

struct Type
{
public:
    uint64_t id = static_cast<uint64_t>(0);
    Optional<chip::CharSpan> name;
    Optional<uint32_t> stackFreeCurrent;
    Optional<uint32_t> stackFreeMinimum;
    Optional<uint32_t> stackSize;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace ThreadMetrics
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ResetWatermarks {
struct Type;
struct DecodableType;
} // namespace ResetWatermarks

} // namespace Commands

namespace Commands {
namespace ResetWatermarks {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResetWatermarks::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResetWatermarks::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResetWatermarks
} // namespace Commands

namespace Attributes {

namespace ThreadMetrics {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetrics::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetrics::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetrics::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ThreadMetrics::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ThreadMetrics
namespace CurrentHeapFree {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentHeapFree::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentHeapFree
namespace CurrentHeapUsed {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentHeapUsed::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentHeapUsed
namespace CurrentHeapHighWatermark {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentHeapHighWatermark::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentHeapHighWatermark
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::ThreadMetrics::TypeInfo::DecodableType threadMetrics;
        Attributes::CurrentHeapFree::TypeInfo::DecodableType currentHeapFree                   = static_cast<uint64_t>(0);
        Attributes::CurrentHeapUsed::TypeInfo::DecodableType currentHeapUsed                   = static_cast<uint64_t>(0);
        Attributes::CurrentHeapHighWatermark::TypeInfo::DecodableType currentHeapHighWatermark = static_cast<uint64_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace SoftwareFault {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kId             = 0,
    kName           = 1,
    kFaultRecording = 2,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SoftwareFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint64_t id = static_cast<uint64_t>(0);
    Optional<chip::CharSpan> name;
    Optional<chip::ByteSpan> faultRecording;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SoftwareFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::SoftwareDiagnostics::Id; }

    uint64_t id = static_cast<uint64_t>(0);
    Optional<chip::CharSpan> name;
    Optional<chip::ByteSpan> faultRecording;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SoftwareFault
} // namespace Events
} // namespace SoftwareDiagnostics
namespace ThreadNetworkDiagnostics {
namespace Structs {
namespace NeighborTable {
enum class Fields
{
    kExtAddress       = 0,
    kAge              = 1,
    kRloc16           = 2,
    kLinkFrameCounter = 3,
    kMleFrameCounter  = 4,
    kLqi              = 5,
    kAverageRssi      = 6,
    kLastRssi         = 7,
    kFrameErrorRate   = 8,
    kMessageErrorRate = 9,
    kRxOnWhenIdle     = 10,
    kFullThreadDevice = 11,
    kFullNetworkData  = 12,
    kIsChild          = 13,
};

struct Type
{
public:
    uint64_t extAddress       = static_cast<uint64_t>(0);
    uint32_t age              = static_cast<uint32_t>(0);
    uint16_t rloc16           = static_cast<uint16_t>(0);
    uint32_t linkFrameCounter = static_cast<uint32_t>(0);
    uint32_t mleFrameCounter  = static_cast<uint32_t>(0);
    uint8_t lqi               = static_cast<uint8_t>(0);
    DataModel::Nullable<int8_t> averageRssi;
    DataModel::Nullable<int8_t> lastRssi;
    uint8_t frameErrorRate   = static_cast<uint8_t>(0);
    uint8_t messageErrorRate = static_cast<uint8_t>(0);
    bool rxOnWhenIdle        = static_cast<bool>(0);
    bool fullThreadDevice    = static_cast<bool>(0);
    bool fullNetworkData     = static_cast<bool>(0);
    bool isChild             = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace NeighborTable
namespace OperationalDatasetComponents {
enum class Fields
{
    kActiveTimestampPresent  = 0,
    kPendingTimestampPresent = 1,
    kMasterKeyPresent        = 2,
    kNetworkNamePresent      = 3,
    kExtendedPanIdPresent    = 4,
    kMeshLocalPrefixPresent  = 5,
    kDelayPresent            = 6,
    kPanIdPresent            = 7,
    kChannelPresent          = 8,
    kPskcPresent             = 9,
    kSecurityPolicyPresent   = 10,
    kChannelMaskPresent      = 11,
};

struct Type
{
public:
    bool activeTimestampPresent  = static_cast<bool>(0);
    bool pendingTimestampPresent = static_cast<bool>(0);
    bool masterKeyPresent        = static_cast<bool>(0);
    bool networkNamePresent      = static_cast<bool>(0);
    bool extendedPanIdPresent    = static_cast<bool>(0);
    bool meshLocalPrefixPresent  = static_cast<bool>(0);
    bool delayPresent            = static_cast<bool>(0);
    bool panIdPresent            = static_cast<bool>(0);
    bool channelPresent          = static_cast<bool>(0);
    bool pskcPresent             = static_cast<bool>(0);
    bool securityPolicyPresent   = static_cast<bool>(0);
    bool channelMaskPresent      = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace OperationalDatasetComponents
namespace RouteTable {
enum class Fields
{
    kExtAddress      = 0,
    kRloc16          = 1,
    kRouterId        = 2,
    kNextHop         = 3,
    kPathCost        = 4,
    kLQIIn           = 5,
    kLQIOut          = 6,
    kAge             = 7,
    kAllocated       = 8,
    kLinkEstablished = 9,
};

struct Type
{
public:
    uint64_t extAddress  = static_cast<uint64_t>(0);
    uint16_t rloc16      = static_cast<uint16_t>(0);
    uint8_t routerId     = static_cast<uint8_t>(0);
    uint8_t nextHop      = static_cast<uint8_t>(0);
    uint8_t pathCost     = static_cast<uint8_t>(0);
    uint8_t LQIIn        = static_cast<uint8_t>(0);
    uint8_t LQIOut       = static_cast<uint8_t>(0);
    uint8_t age          = static_cast<uint8_t>(0);
    bool allocated       = static_cast<bool>(0);
    bool linkEstablished = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace RouteTable
namespace SecurityPolicy {
enum class Fields
{
    kRotationTime = 0,
    kFlags        = 1,
};

struct Type
{
public:
    uint16_t rotationTime = static_cast<uint16_t>(0);
    uint16_t flags        = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace SecurityPolicy
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ResetCounts {
struct Type;
struct DecodableType;
} // namespace ResetCounts

} // namespace Commands

namespace Commands {
namespace ResetCounts {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResetCounts
} // namespace Commands

namespace Attributes {

namespace Channel {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Channel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Channel
namespace RoutingRole {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::RoutingRole>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::RoutingRole>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::RoutingRole> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RoutingRole::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RoutingRole
namespace NetworkName {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::CharSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::CharSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::CharSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NetworkName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace NetworkName
namespace PanId {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PanId::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PanId
namespace ExtendedPanId {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ExtendedPanId::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ExtendedPanId
namespace MeshLocalPrefix {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeshLocalPrefix::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 17; }
};
} // namespace MeshLocalPrefix
namespace OverrunCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OverrunCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OverrunCount
namespace NeighborTableList {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTable::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTable::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTable::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NeighborTableList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NeighborTableList
namespace RouteTableList {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTable::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTable::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTable::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RouteTableList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RouteTableList
namespace PartitionId {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PartitionId::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PartitionId
namespace Weighting {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Weighting::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Weighting
namespace DataVersion {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DataVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DataVersion
namespace StableDataVersion {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StableDataVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StableDataVersion
namespace LeaderRouterId {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LeaderRouterId::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LeaderRouterId
namespace DetachedRoleCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DetachedRoleCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DetachedRoleCount
namespace ChildRoleCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ChildRoleCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ChildRoleCount
namespace RouterRoleCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RouterRoleCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RouterRoleCount
namespace LeaderRoleCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LeaderRoleCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LeaderRoleCount
namespace AttachAttemptCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AttachAttemptCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AttachAttemptCount
namespace PartitionIdChangeCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PartitionIdChangeCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PartitionIdChangeCount
namespace BetterPartitionAttachAttemptCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BetterPartitionAttachAttemptCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BetterPartitionAttachAttemptCount
namespace ParentChangeCount {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ParentChangeCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ParentChangeCount
namespace TxTotalCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxTotalCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxTotalCount
namespace TxUnicastCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxUnicastCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxUnicastCount
namespace TxBroadcastCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxBroadcastCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxBroadcastCount
namespace TxAckRequestedCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxAckRequestedCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxAckRequestedCount
namespace TxAckedCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxAckedCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxAckedCount
namespace TxNoAckRequestedCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxNoAckRequestedCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxNoAckRequestedCount
namespace TxDataCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxDataCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxDataCount
namespace TxDataPollCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxDataPollCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxDataPollCount
namespace TxBeaconCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxBeaconCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxBeaconCount
namespace TxBeaconRequestCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxBeaconRequestCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxBeaconRequestCount
namespace TxOtherCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxOtherCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxOtherCount
namespace TxRetryCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxRetryCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxRetryCount
namespace TxDirectMaxRetryExpiryCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxDirectMaxRetryExpiryCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxDirectMaxRetryExpiryCount
namespace TxIndirectMaxRetryExpiryCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxIndirectMaxRetryExpiryCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxIndirectMaxRetryExpiryCount
namespace TxErrCcaCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxErrCcaCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxErrCcaCount
namespace TxErrAbortCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxErrAbortCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxErrAbortCount
namespace TxErrBusyChannelCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxErrBusyChannelCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxErrBusyChannelCount
namespace RxTotalCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxTotalCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxTotalCount
namespace RxUnicastCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxUnicastCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxUnicastCount
namespace RxBroadcastCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxBroadcastCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxBroadcastCount
namespace RxDataCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxDataCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxDataCount
namespace RxDataPollCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxDataPollCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxDataPollCount
namespace RxBeaconCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxBeaconCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxBeaconCount
namespace RxBeaconRequestCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxBeaconRequestCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxBeaconRequestCount
namespace RxOtherCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxOtherCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxOtherCount
namespace RxAddressFilteredCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxAddressFilteredCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxAddressFilteredCount
namespace RxDestAddrFilteredCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxDestAddrFilteredCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxDestAddrFilteredCount
namespace RxDuplicatedCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxDuplicatedCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxDuplicatedCount
namespace RxErrNoFrameCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrNoFrameCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrNoFrameCount
namespace RxErrUnknownNeighborCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrUnknownNeighborCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrUnknownNeighborCount
namespace RxErrInvalidSrcAddrCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrInvalidSrcAddrCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrInvalidSrcAddrCount
namespace RxErrSecCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrSecCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrSecCount
namespace RxErrFcsCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrFcsCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrFcsCount
namespace RxErrOtherCount {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RxErrOtherCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RxErrOtherCount
namespace ActiveTimestamp {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveTimestamp::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveTimestamp
namespace PendingTimestamp {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PendingTimestamp::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PendingTimestamp
namespace Delay {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Delay::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Delay
namespace SecurityPolicy {
struct TypeInfo
{
    using Type = chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::Type>;
    using DecodableType =
        chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SecurityPolicy::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SecurityPolicy
namespace ChannelPage0Mask {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ChannelPage0Mask::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 4; }
};
} // namespace ChannelPage0Mask
namespace OperationalDatasetComponents {
struct TypeInfo
{
    using Type =
        chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::Type>;
    using DecodableType = chip::app::DataModel::Nullable<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<
        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalDatasetComponents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalDatasetComponents
namespace ActiveNetworkFaultsList {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::ThreadNetworkDiagnostics::NetworkFault>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::ThreadNetworkDiagnostics::NetworkFault>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::ThreadNetworkDiagnostics::NetworkFault> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveNetworkFaultsList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveNetworkFaultsList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Channel::TypeInfo::DecodableType channel;
        Attributes::RoutingRole::TypeInfo::DecodableType routingRole;
        Attributes::NetworkName::TypeInfo::DecodableType networkName;
        Attributes::PanId::TypeInfo::DecodableType panId;
        Attributes::ExtendedPanId::TypeInfo::DecodableType extendedPanId;
        Attributes::MeshLocalPrefix::TypeInfo::DecodableType meshLocalPrefix;
        Attributes::OverrunCount::TypeInfo::DecodableType overrunCount = static_cast<uint64_t>(0);
        Attributes::NeighborTableList::TypeInfo::DecodableType neighborTableList;
        Attributes::RouteTableList::TypeInfo::DecodableType routeTableList;
        Attributes::PartitionId::TypeInfo::DecodableType partitionId;
        Attributes::Weighting::TypeInfo::DecodableType weighting;
        Attributes::DataVersion::TypeInfo::DecodableType dataVersion;
        Attributes::StableDataVersion::TypeInfo::DecodableType stableDataVersion;
        Attributes::LeaderRouterId::TypeInfo::DecodableType leaderRouterId;
        Attributes::DetachedRoleCount::TypeInfo::DecodableType detachedRoleCount           = static_cast<uint16_t>(0);
        Attributes::ChildRoleCount::TypeInfo::DecodableType childRoleCount                 = static_cast<uint16_t>(0);
        Attributes::RouterRoleCount::TypeInfo::DecodableType routerRoleCount               = static_cast<uint16_t>(0);
        Attributes::LeaderRoleCount::TypeInfo::DecodableType leaderRoleCount               = static_cast<uint16_t>(0);
        Attributes::AttachAttemptCount::TypeInfo::DecodableType attachAttemptCount         = static_cast<uint16_t>(0);
        Attributes::PartitionIdChangeCount::TypeInfo::DecodableType partitionIdChangeCount = static_cast<uint16_t>(0);
        Attributes::BetterPartitionAttachAttemptCount::TypeInfo::DecodableType betterPartitionAttachAttemptCount =
            static_cast<uint16_t>(0);
        Attributes::ParentChangeCount::TypeInfo::DecodableType parentChangeCount                         = static_cast<uint16_t>(0);
        Attributes::TxTotalCount::TypeInfo::DecodableType txTotalCount                                   = static_cast<uint32_t>(0);
        Attributes::TxUnicastCount::TypeInfo::DecodableType txUnicastCount                               = static_cast<uint32_t>(0);
        Attributes::TxBroadcastCount::TypeInfo::DecodableType txBroadcastCount                           = static_cast<uint32_t>(0);
        Attributes::TxAckRequestedCount::TypeInfo::DecodableType txAckRequestedCount                     = static_cast<uint32_t>(0);
        Attributes::TxAckedCount::TypeInfo::DecodableType txAckedCount                                   = static_cast<uint32_t>(0);
        Attributes::TxNoAckRequestedCount::TypeInfo::DecodableType txNoAckRequestedCount                 = static_cast<uint32_t>(0);
        Attributes::TxDataCount::TypeInfo::DecodableType txDataCount                                     = static_cast<uint32_t>(0);
        Attributes::TxDataPollCount::TypeInfo::DecodableType txDataPollCount                             = static_cast<uint32_t>(0);
        Attributes::TxBeaconCount::TypeInfo::DecodableType txBeaconCount                                 = static_cast<uint32_t>(0);
        Attributes::TxBeaconRequestCount::TypeInfo::DecodableType txBeaconRequestCount                   = static_cast<uint32_t>(0);
        Attributes::TxOtherCount::TypeInfo::DecodableType txOtherCount                                   = static_cast<uint32_t>(0);
        Attributes::TxRetryCount::TypeInfo::DecodableType txRetryCount                                   = static_cast<uint32_t>(0);
        Attributes::TxDirectMaxRetryExpiryCount::TypeInfo::DecodableType txDirectMaxRetryExpiryCount     = static_cast<uint32_t>(0);
        Attributes::TxIndirectMaxRetryExpiryCount::TypeInfo::DecodableType txIndirectMaxRetryExpiryCount = static_cast<uint32_t>(0);
        Attributes::TxErrCcaCount::TypeInfo::DecodableType txErrCcaCount                                 = static_cast<uint32_t>(0);
        Attributes::TxErrAbortCount::TypeInfo::DecodableType txErrAbortCount                             = static_cast<uint32_t>(0);
        Attributes::TxErrBusyChannelCount::TypeInfo::DecodableType txErrBusyChannelCount                 = static_cast<uint32_t>(0);
        Attributes::RxTotalCount::TypeInfo::DecodableType rxTotalCount                                   = static_cast<uint32_t>(0);
        Attributes::RxUnicastCount::TypeInfo::DecodableType rxUnicastCount                               = static_cast<uint32_t>(0);
        Attributes::RxBroadcastCount::TypeInfo::DecodableType rxBroadcastCount                           = static_cast<uint32_t>(0);
        Attributes::RxDataCount::TypeInfo::DecodableType rxDataCount                                     = static_cast<uint32_t>(0);
        Attributes::RxDataPollCount::TypeInfo::DecodableType rxDataPollCount                             = static_cast<uint32_t>(0);
        Attributes::RxBeaconCount::TypeInfo::DecodableType rxBeaconCount                                 = static_cast<uint32_t>(0);
        Attributes::RxBeaconRequestCount::TypeInfo::DecodableType rxBeaconRequestCount                   = static_cast<uint32_t>(0);
        Attributes::RxOtherCount::TypeInfo::DecodableType rxOtherCount                                   = static_cast<uint32_t>(0);
        Attributes::RxAddressFilteredCount::TypeInfo::DecodableType rxAddressFilteredCount               = static_cast<uint32_t>(0);
        Attributes::RxDestAddrFilteredCount::TypeInfo::DecodableType rxDestAddrFilteredCount             = static_cast<uint32_t>(0);
        Attributes::RxDuplicatedCount::TypeInfo::DecodableType rxDuplicatedCount                         = static_cast<uint32_t>(0);
        Attributes::RxErrNoFrameCount::TypeInfo::DecodableType rxErrNoFrameCount                         = static_cast<uint32_t>(0);
        Attributes::RxErrUnknownNeighborCount::TypeInfo::DecodableType rxErrUnknownNeighborCount         = static_cast<uint32_t>(0);
        Attributes::RxErrInvalidSrcAddrCount::TypeInfo::DecodableType rxErrInvalidSrcAddrCount           = static_cast<uint32_t>(0);
        Attributes::RxErrSecCount::TypeInfo::DecodableType rxErrSecCount                                 = static_cast<uint32_t>(0);
        Attributes::RxErrFcsCount::TypeInfo::DecodableType rxErrFcsCount                                 = static_cast<uint32_t>(0);
        Attributes::RxErrOtherCount::TypeInfo::DecodableType rxErrOtherCount                             = static_cast<uint32_t>(0);
        Attributes::ActiveTimestamp::TypeInfo::DecodableType activeTimestamp;
        Attributes::PendingTimestamp::TypeInfo::DecodableType pendingTimestamp;
        Attributes::Delay::TypeInfo::DecodableType delay;
        Attributes::SecurityPolicy::TypeInfo::DecodableType securityPolicy;
        Attributes::ChannelPage0Mask::TypeInfo::DecodableType channelPage0Mask;
        Attributes::OperationalDatasetComponents::TypeInfo::DecodableType operationalDatasetComponents;
        Attributes::ActiveNetworkFaultsList::TypeInfo::DecodableType activeNetworkFaultsList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace ConnectionStatus {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kConnectionStatus = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ConnectionStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    ThreadConnectionStatus connectionStatus = static_cast<ThreadConnectionStatus>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ConnectionStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }

    ThreadConnectionStatus connectionStatus = static_cast<ThreadConnectionStatus>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ConnectionStatus
namespace NetworkFaultChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kCurrent  = 0,
    kPrevious = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::NetworkFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    DataModel::List<const NetworkFault> current;
    DataModel::List<const NetworkFault> previous;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::NetworkFaultChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ThreadNetworkDiagnostics::Id; }

    DataModel::DecodableList<NetworkFault> current;
    DataModel::DecodableList<NetworkFault> previous;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace NetworkFaultChange
} // namespace Events
} // namespace ThreadNetworkDiagnostics
namespace WiFiNetworkDiagnostics {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ResetCounts {
struct Type;
struct DecodableType;
} // namespace ResetCounts

} // namespace Commands

namespace Commands {
namespace ResetCounts {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResetCounts
} // namespace Commands

namespace Attributes {

namespace Bssid {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Bssid::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 6; }
};
} // namespace Bssid
namespace SecurityType {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::SecurityType>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::SecurityType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::SecurityType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SecurityType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SecurityType
namespace WiFiVersion {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::WiFiVersionType>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::WiFiVersionType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::WiFiVersionType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WiFiVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WiFiVersion
namespace ChannelNumber {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ChannelNumber::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ChannelNumber
namespace Rssi {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Rssi::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Rssi
namespace BeaconLostCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BeaconLostCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BeaconLostCount
namespace BeaconRxCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BeaconRxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BeaconRxCount
namespace PacketMulticastRxCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketMulticastRxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketMulticastRxCount
namespace PacketMulticastTxCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketMulticastTxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketMulticastTxCount
namespace PacketUnicastRxCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketUnicastRxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketUnicastRxCount
namespace PacketUnicastTxCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketUnicastTxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketUnicastTxCount
namespace CurrentMaxRate {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMaxRate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMaxRate
namespace OverrunCount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OverrunCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OverrunCount
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Bssid::TypeInfo::DecodableType bssid;
        Attributes::SecurityType::TypeInfo::DecodableType securityType;
        Attributes::WiFiVersion::TypeInfo::DecodableType wiFiVersion;
        Attributes::ChannelNumber::TypeInfo::DecodableType channelNumber;
        Attributes::Rssi::TypeInfo::DecodableType rssi;
        Attributes::BeaconLostCount::TypeInfo::DecodableType beaconLostCount;
        Attributes::BeaconRxCount::TypeInfo::DecodableType beaconRxCount;
        Attributes::PacketMulticastRxCount::TypeInfo::DecodableType packetMulticastRxCount;
        Attributes::PacketMulticastTxCount::TypeInfo::DecodableType packetMulticastTxCount;
        Attributes::PacketUnicastRxCount::TypeInfo::DecodableType packetUnicastRxCount;
        Attributes::PacketUnicastTxCount::TypeInfo::DecodableType packetUnicastTxCount;
        Attributes::CurrentMaxRate::TypeInfo::DecodableType currentMaxRate;
        Attributes::OverrunCount::TypeInfo::DecodableType overrunCount;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace Disconnection {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kReasonCode = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Disconnection::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint16_t reasonCode = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Disconnection::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

    uint16_t reasonCode = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Disconnection
namespace AssociationFailure {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kAssociationFailure = 0,
    kStatus             = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AssociationFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    AssociationFailureCause associationFailure = static_cast<AssociationFailureCause>(0);
    uint16_t status                            = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AssociationFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

    AssociationFailureCause associationFailure = static_cast<AssociationFailureCause>(0);
    uint16_t status                            = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace AssociationFailure
namespace ConnectionStatus {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kConnectionStatus = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ConnectionStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }
    static constexpr bool kIsFabricScoped = false;

    WiFiConnectionStatus connectionStatus = static_cast<WiFiConnectionStatus>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ConnectionStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WiFiNetworkDiagnostics::Id; }

    WiFiConnectionStatus connectionStatus = static_cast<WiFiConnectionStatus>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ConnectionStatus
} // namespace Events
} // namespace WiFiNetworkDiagnostics
namespace EthernetNetworkDiagnostics {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ResetCounts {
struct Type;
struct DecodableType;
} // namespace ResetCounts

} // namespace Commands

namespace Commands {
namespace ResetCounts {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ResetCounts::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ResetCounts
} // namespace Commands

namespace Attributes {

namespace PHYRate {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PHYRate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PHYRate
namespace FullDuplex {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<bool>;
    using DecodableType    = chip::app::DataModel::Nullable<bool>;
    using DecodableArgType = const chip::app::DataModel::Nullable<bool> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::FullDuplex::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace FullDuplex
namespace PacketRxCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketRxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketRxCount
namespace PacketTxCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PacketTxCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PacketTxCount
namespace TxErrCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TxErrCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TxErrCount
namespace CollisionCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CollisionCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CollisionCount
namespace OverrunCount {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OverrunCount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OverrunCount
namespace CarrierDetect {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<bool>;
    using DecodableType    = chip::app::DataModel::Nullable<bool>;
    using DecodableArgType = const chip::app::DataModel::Nullable<bool> &;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CarrierDetect::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CarrierDetect
namespace TimeSinceReset {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TimeSinceReset::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TimeSinceReset
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::EthernetNetworkDiagnostics::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::PHYRate::TypeInfo::DecodableType PHYRate;
        Attributes::FullDuplex::TypeInfo::DecodableType fullDuplex;
        Attributes::PacketRxCount::TypeInfo::DecodableType packetRxCount   = static_cast<uint64_t>(0);
        Attributes::PacketTxCount::TypeInfo::DecodableType packetTxCount   = static_cast<uint64_t>(0);
        Attributes::TxErrCount::TypeInfo::DecodableType txErrCount         = static_cast<uint64_t>(0);
        Attributes::CollisionCount::TypeInfo::DecodableType collisionCount = static_cast<uint64_t>(0);
        Attributes::OverrunCount::TypeInfo::DecodableType overrunCount     = static_cast<uint64_t>(0);
        Attributes::CarrierDetect::TypeInfo::DecodableType carrierDetect;
        Attributes::TimeSinceReset::TypeInfo::DecodableType timeSinceReset = static_cast<uint64_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace EthernetNetworkDiagnostics
namespace TimeSynchronization {
namespace Structs {
namespace DstOffsetType {
enum class Fields
{
    kOffset        = 0,
    kValidStarting = 1,
    kValidUntil    = 2,
};

struct Type
{
public:
    int32_t offset         = static_cast<int32_t>(0);
    uint64_t validStarting = static_cast<uint64_t>(0);
    uint64_t validUntil    = static_cast<uint64_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace DstOffsetType
namespace TimeZoneType {
enum class Fields
{
    kOffset  = 0,
    kValidAt = 1,
    kName    = 2,
};

struct Type
{
public:
    int32_t offset   = static_cast<int32_t>(0);
    uint64_t validAt = static_cast<uint64_t>(0);
    Optional<chip::CharSpan> name;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace TimeZoneType
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace SetUtcTime {
struct Type;
struct DecodableType;
} // namespace SetUtcTime

} // namespace Commands

namespace Commands {
namespace SetUtcTime {
enum class Fields
{
    kUtcTime     = 0,
    kGranularity = 1,
    kTimeSource  = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetUtcTime::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    uint64_t utcTime            = static_cast<uint64_t>(0);
    GranularityEnum granularity = static_cast<GranularityEnum>(0);
    Optional<TimeSourceEnum> timeSource;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetUtcTime::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

    uint64_t utcTime            = static_cast<uint64_t>(0);
    GranularityEnum granularity = static_cast<GranularityEnum>(0);
    Optional<TimeSourceEnum> timeSource;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetUtcTime
} // namespace Commands

namespace Attributes {

namespace UTCTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UTCTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UTCTime
namespace Granularity {
struct TypeInfo
{
    using Type             = chip::app::Clusters::TimeSynchronization::GranularityEnum;
    using DecodableType    = chip::app::Clusters::TimeSynchronization::GranularityEnum;
    using DecodableArgType = chip::app::Clusters::TimeSynchronization::GranularityEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Granularity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Granularity
namespace TimeSource {
struct TypeInfo
{
    using Type             = chip::app::Clusters::TimeSynchronization::TimeSourceEnum;
    using DecodableType    = chip::app::Clusters::TimeSynchronization::TimeSourceEnum;
    using DecodableArgType = chip::app::Clusters::TimeSynchronization::TimeSourceEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TimeSource::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TimeSource
namespace TrustedTimeNodeId {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::NodeId>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::NodeId>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::NodeId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TrustedTimeNodeId::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TrustedTimeNodeId
namespace DefaultNtp {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::CharSpan>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::CharSpan>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::CharSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultNtp::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 128; }
};
} // namespace DefaultNtp
namespace TimeZone {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::TimeSynchronization::Structs::TimeZoneType::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::TimeSynchronization::Structs::TimeZoneType::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::TimeSynchronization::Structs::TimeZoneType::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TimeZone::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TimeZone
namespace DstOffset {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::TimeSynchronization::Structs::DstOffsetType::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::TimeSynchronization::Structs::DstOffsetType::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::TimeSynchronization::Structs::DstOffsetType::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DstOffset::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DstOffset
namespace LocalTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LocalTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LocalTime
namespace TimeZoneDatabase {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TimeZoneDatabase::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TimeZoneDatabase
namespace NtpServerPort {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NtpServerPort::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NtpServerPort
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::TimeSynchronization::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::UTCTime::TypeInfo::DecodableType UTCTime;
        Attributes::Granularity::TypeInfo::DecodableType granularity =
            static_cast<chip::app::Clusters::TimeSynchronization::GranularityEnum>(0);
        Attributes::TimeSource::TypeInfo::DecodableType timeSource =
            static_cast<chip::app::Clusters::TimeSynchronization::TimeSourceEnum>(0);
        Attributes::TrustedTimeNodeId::TypeInfo::DecodableType trustedTimeNodeId;
        Attributes::DefaultNtp::TypeInfo::DecodableType defaultNtp;
        Attributes::TimeZone::TypeInfo::DecodableType timeZone;
        Attributes::DstOffset::TypeInfo::DecodableType dstOffset;
        Attributes::LocalTime::TypeInfo::DecodableType localTime;
        Attributes::TimeZoneDatabase::TypeInfo::DecodableType timeZoneDatabase = static_cast<bool>(0);
        Attributes::NtpServerPort::TypeInfo::DecodableType ntpServerPort;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace TimeSynchronization
namespace BridgedDeviceBasic {

namespace Attributes {

namespace VendorName {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VendorName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace VendorName
namespace VendorID {
struct TypeInfo
{
    using Type             = chip::VendorId;
    using DecodableType    = chip::VendorId;
    using DecodableArgType = chip::VendorId;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VendorID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace VendorID
namespace ProductName {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace ProductName
namespace NodeLabel {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NodeLabel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace NodeLabel
namespace HardwareVersion {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HardwareVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HardwareVersion
namespace HardwareVersionString {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HardwareVersionString::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace HardwareVersionString
namespace SoftwareVersion {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SoftwareVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SoftwareVersion
namespace SoftwareVersionString {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SoftwareVersionString::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace SoftwareVersionString
namespace ManufacturingDate {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ManufacturingDate::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace ManufacturingDate
namespace PartNumber {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PartNumber::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace PartNumber
namespace ProductURL {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductURL::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 256; }
};
} // namespace ProductURL
namespace ProductLabel {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductLabel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 64; }
};
} // namespace ProductLabel
namespace SerialNumber {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SerialNumber::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace SerialNumber
namespace Reachable {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Reachable::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Reachable
namespace UniqueID {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UniqueID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace UniqueID
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::VendorName::TypeInfo::DecodableType vendorName;
        Attributes::VendorID::TypeInfo::DecodableType vendorID = static_cast<chip::VendorId>(0);
        Attributes::ProductName::TypeInfo::DecodableType productName;
        Attributes::NodeLabel::TypeInfo::DecodableType nodeLabel;
        Attributes::HardwareVersion::TypeInfo::DecodableType hardwareVersion = static_cast<uint16_t>(0);
        Attributes::HardwareVersionString::TypeInfo::DecodableType hardwareVersionString;
        Attributes::SoftwareVersion::TypeInfo::DecodableType softwareVersion = static_cast<uint32_t>(0);
        Attributes::SoftwareVersionString::TypeInfo::DecodableType softwareVersionString;
        Attributes::ManufacturingDate::TypeInfo::DecodableType manufacturingDate;
        Attributes::PartNumber::TypeInfo::DecodableType partNumber;
        Attributes::ProductURL::TypeInfo::DecodableType productURL;
        Attributes::ProductLabel::TypeInfo::DecodableType productLabel;
        Attributes::SerialNumber::TypeInfo::DecodableType serialNumber;
        Attributes::Reachable::TypeInfo::DecodableType reachable = static_cast<bool>(0);
        Attributes::UniqueID::TypeInfo::DecodableType uniqueID;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace StartUp {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
    kSoftwareVersion = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StartUp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint32_t softwareVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StartUp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }

    uint32_t softwareVersion = static_cast<uint32_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace StartUp
namespace ShutDown {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShutDown::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShutDown::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ShutDown
namespace Leave {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Leave::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Leave::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Leave
namespace ReachableChanged {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kReachableNewValue = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ReachableChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }
    static constexpr bool kIsFabricScoped = false;

    bool reachableNewValue = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ReachableChanged::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BridgedDeviceBasic::Id; }

    bool reachableNewValue = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ReachableChanged
} // namespace Events
} // namespace BridgedDeviceBasic
namespace Switch {

namespace Attributes {

namespace NumberOfPositions {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfPositions::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfPositions
namespace CurrentPosition {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentPosition::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentPosition
namespace MultiPressMax {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MultiPressMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MultiPressMax
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::NumberOfPositions::TypeInfo::DecodableType numberOfPositions = static_cast<uint8_t>(0);
        Attributes::CurrentPosition::TypeInfo::DecodableType currentPosition     = static_cast<uint8_t>(0);
        Attributes::MultiPressMax::TypeInfo::DecodableType multiPressMax         = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace SwitchLatched {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kNewPosition = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SwitchLatched::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SwitchLatched::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SwitchLatched
namespace InitialPress {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kNewPosition = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::InitialPress::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::InitialPress::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace InitialPress
namespace LongPress {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kNewPosition = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LongPress::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LongPress::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t newPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace LongPress
namespace ShortRelease {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kPreviousPosition = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShortRelease::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t previousPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ShortRelease::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t previousPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ShortRelease
namespace LongRelease {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kPreviousPosition = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LongRelease::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t previousPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LongRelease::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t previousPosition = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace LongRelease
namespace MultiPressOngoing {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kNewPosition                   = 0,
    kCurrentNumberOfPressesCounted = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MultiPressOngoing::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t newPosition                   = static_cast<uint8_t>(0);
    uint8_t currentNumberOfPressesCounted = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MultiPressOngoing::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t newPosition                   = static_cast<uint8_t>(0);
    uint8_t currentNumberOfPressesCounted = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace MultiPressOngoing
namespace MultiPressComplete {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kNewPosition                 = 0,
    kTotalNumberOfPressesCounted = 1,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MultiPressComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }
    static constexpr bool kIsFabricScoped = false;

    uint8_t newPosition                 = static_cast<uint8_t>(0);
    uint8_t totalNumberOfPressesCounted = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MultiPressComplete::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Switch::Id; }

    uint8_t newPosition                 = static_cast<uint8_t>(0);
    uint8_t totalNumberOfPressesCounted = static_cast<uint8_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace MultiPressComplete
} // namespace Events
} // namespace Switch
namespace AdministratorCommissioning {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace OpenCommissioningWindow {
struct Type;
struct DecodableType;
} // namespace OpenCommissioningWindow

namespace OpenBasicCommissioningWindow {
struct Type;
struct DecodableType;
} // namespace OpenBasicCommissioningWindow

namespace RevokeCommissioning {
struct Type;
struct DecodableType;
} // namespace RevokeCommissioning

} // namespace Commands

namespace Commands {
namespace OpenCommissioningWindow {
enum class Fields
{
    kCommissioningTimeout = 0,
    kPAKEVerifier         = 1,
    kDiscriminator        = 2,
    kIterations           = 3,
    kSalt                 = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OpenCommissioningWindow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    uint16_t commissioningTimeout = static_cast<uint16_t>(0);
    chip::ByteSpan PAKEVerifier;
    uint16_t discriminator = static_cast<uint16_t>(0);
    uint32_t iterations    = static_cast<uint32_t>(0);
    chip::ByteSpan salt;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OpenCommissioningWindow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    uint16_t commissioningTimeout = static_cast<uint16_t>(0);
    chip::ByteSpan PAKEVerifier;
    uint16_t discriminator = static_cast<uint16_t>(0);
    uint32_t iterations    = static_cast<uint32_t>(0);
    chip::ByteSpan salt;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OpenCommissioningWindow
namespace OpenBasicCommissioningWindow {
enum class Fields
{
    kCommissioningTimeout = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::OpenBasicCommissioningWindow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    uint16_t commissioningTimeout = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::OpenBasicCommissioningWindow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    uint16_t commissioningTimeout = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace OpenBasicCommissioningWindow
namespace RevokeCommissioning {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RevokeCommissioning::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RevokeCommissioning::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RevokeCommissioning
} // namespace Commands

namespace Attributes {

namespace WindowStatus {
struct TypeInfo
{
    using Type             = chip::app::Clusters::AdministratorCommissioning::CommissioningWindowStatus;
    using DecodableType    = chip::app::Clusters::AdministratorCommissioning::CommissioningWindowStatus;
    using DecodableArgType = chip::app::Clusters::AdministratorCommissioning::CommissioningWindowStatus;

    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WindowStatus::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WindowStatus
namespace AdminFabricIndex {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::FabricIndex>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::FabricIndex>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::FabricIndex> &;

    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AdminFabricIndex::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AdminFabricIndex
namespace AdminVendorId {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AdminVendorId::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AdminVendorId
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::AdministratorCommissioning::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::WindowStatus::TypeInfo::DecodableType windowStatus =
            static_cast<chip::app::Clusters::AdministratorCommissioning::CommissioningWindowStatus>(0);
        Attributes::AdminFabricIndex::TypeInfo::DecodableType adminFabricIndex;
        Attributes::AdminVendorId::TypeInfo::DecodableType adminVendorId;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace AdministratorCommissioning
namespace OperationalCredentials {
namespace Structs {
namespace FabricDescriptor {
enum class Fields
{
    kRootPublicKey = 1,
    kVendorId      = 2,
    kFabricId      = 3,
    kNodeId        = 4,
    kLabel         = 5,
    kFabricIndex   = 254,
};

struct Type
{
public:
    chip::ByteSpan rootPublicKey;
    chip::VendorId vendorId = static_cast<chip::VendorId>(0);
    chip::FabricId fabricId = static_cast<chip::FabricId>(0);
    chip::NodeId nodeId     = static_cast<chip::NodeId>(0);
    chip::CharSpan label;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & writer, TLV::Tag tag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & writer, TLV::Tag tag, FabricIndex accessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & writer, TLV::Tag tag, const Optional<FabricIndex> & accessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace FabricDescriptor
namespace NOCStruct {
enum class Fields
{
    kNoc         = 1,
    kIcac        = 2,
    kFabricIndex = 254,
};

struct Type
{
public:
    chip::ByteSpan noc;
    DataModel::Nullable<chip::ByteSpan> icac;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & writer, TLV::Tag tag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & writer, TLV::Tag tag, FabricIndex accessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & writer, TLV::Tag tag, const Optional<FabricIndex> & accessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace NOCStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace AttestationRequest {
struct Type;
struct DecodableType;
} // namespace AttestationRequest

namespace AttestationResponse {
struct Type;
struct DecodableType;
} // namespace AttestationResponse

namespace CertificateChainRequest {
struct Type;
struct DecodableType;
} // namespace CertificateChainRequest

namespace CertificateChainResponse {
struct Type;
struct DecodableType;
} // namespace CertificateChainResponse

namespace CSRRequest {
struct Type;
struct DecodableType;
} // namespace CSRRequest

namespace CSRResponse {
struct Type;
struct DecodableType;
} // namespace CSRResponse

namespace AddNOC {
struct Type;
struct DecodableType;
} // namespace AddNOC

namespace UpdateNOC {
struct Type;
struct DecodableType;
} // namespace UpdateNOC

namespace NOCResponse {
struct Type;
struct DecodableType;
} // namespace NOCResponse

namespace UpdateFabricLabel {
struct Type;
struct DecodableType;
} // namespace UpdateFabricLabel

namespace RemoveFabric {
struct Type;
struct DecodableType;
} // namespace RemoveFabric

namespace AddTrustedRootCertificate {
struct Type;
struct DecodableType;
} // namespace AddTrustedRootCertificate

} // namespace Commands

namespace Commands {
namespace AttestationRequest {
enum class Fields
{
    kAttestationNonce = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AttestationRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan attestationNonce;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::AttestationResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AttestationRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan attestationNonce;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AttestationRequest
namespace AttestationResponse {
enum class Fields
{
    kAttestationElements = 0,
    kSignature           = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AttestationResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan attestationElements;
    chip::ByteSpan signature;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AttestationResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan attestationElements;
    chip::ByteSpan signature;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AttestationResponse
namespace CertificateChainRequest {
enum class Fields
{
    kCertificateType = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CertificateChainRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    uint8_t certificateType = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::CertificateChainResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CertificateChainRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    uint8_t certificateType = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CertificateChainRequest
namespace CertificateChainResponse {
enum class Fields
{
    kCertificate = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CertificateChainResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan certificate;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CertificateChainResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan certificate;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CertificateChainResponse
namespace CSRRequest {
enum class Fields
{
    kCSRNonce       = 0,
    kIsForUpdateNOC = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CSRRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan CSRNonce;
    Optional<bool> isForUpdateNOC;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::CSRResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CSRRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan CSRNonce;
    Optional<bool> isForUpdateNOC;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CSRRequest
namespace CSRResponse {
enum class Fields
{
    kNOCSRElements        = 0,
    kAttestationSignature = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::CSRResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCSRElements;
    chip::ByteSpan attestationSignature;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::CSRResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCSRElements;
    chip::ByteSpan attestationSignature;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace CSRResponse
namespace AddNOC {
enum class Fields
{
    kNOCValue         = 0,
    kICACValue        = 1,
    kIPKValue         = 2,
    kCaseAdminSubject = 3,
    kAdminVendorId    = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddNOC::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCValue;
    Optional<chip::ByteSpan> ICACValue;
    chip::ByteSpan IPKValue;
    uint64_t caseAdminSubject    = static_cast<uint64_t>(0);
    chip::VendorId adminVendorId = static_cast<chip::VendorId>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::NOCResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddNOC::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCValue;
    Optional<chip::ByteSpan> ICACValue;
    chip::ByteSpan IPKValue;
    uint64_t caseAdminSubject    = static_cast<uint64_t>(0);
    chip::VendorId adminVendorId = static_cast<chip::VendorId>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddNOC
namespace UpdateNOC {
enum class Fields
{
    kNOCValue  = 0,
    kICACValue = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UpdateNOC::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCValue;
    Optional<chip::ByteSpan> ICACValue;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::NOCResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UpdateNOC::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan NOCValue;
    Optional<chip::ByteSpan> ICACValue;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UpdateNOC
namespace NOCResponse {
enum class Fields
{
    kStatusCode  = 0,
    kFabricIndex = 1,
    kDebugText   = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::NOCResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    OperationalCertStatus statusCode = static_cast<OperationalCertStatus>(0);
    Optional<chip::FabricIndex> fabricIndex;
    Optional<chip::CharSpan> debugText;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::NOCResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    OperationalCertStatus statusCode = static_cast<OperationalCertStatus>(0);
    Optional<chip::FabricIndex> fabricIndex;
    Optional<chip::CharSpan> debugText;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace NOCResponse
namespace UpdateFabricLabel {
enum class Fields
{
    kLabel = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UpdateFabricLabel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::CharSpan label;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::NOCResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UpdateFabricLabel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::CharSpan label;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UpdateFabricLabel
namespace RemoveFabric {
enum class Fields
{
    kFabricIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RemoveFabric::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::OperationalCredentials::Commands::NOCResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RemoveFabric::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RemoveFabric
namespace AddTrustedRootCertificate {
enum class Fields
{
    kRootCertificate = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::AddTrustedRootCertificate::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan rootCertificate;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::AddTrustedRootCertificate::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

    chip::ByteSpan rootCertificate;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace AddTrustedRootCertificate
} // namespace Commands

namespace Attributes {

namespace NOCs {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NOCs::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NOCs
namespace Fabrics {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptor::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptor::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptor::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Fabrics::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Fabrics
namespace SupportedFabrics {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedFabrics::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedFabrics
namespace CommissionedFabrics {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CommissionedFabrics::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CommissionedFabrics
namespace TrustedRootCertificates {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::ByteSpan>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::ByteSpan>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::ByteSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TrustedRootCertificates::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TrustedRootCertificates
namespace CurrentFabricIndex {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentFabricIndex::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentFabricIndex
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OperationalCredentials::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::NOCs::TypeInfo::DecodableType NOCs;
        Attributes::Fabrics::TypeInfo::DecodableType fabrics;
        Attributes::SupportedFabrics::TypeInfo::DecodableType supportedFabrics       = static_cast<uint8_t>(0);
        Attributes::CommissionedFabrics::TypeInfo::DecodableType commissionedFabrics = static_cast<uint8_t>(0);
        Attributes::TrustedRootCertificates::TypeInfo::DecodableType trustedRootCertificates;
        Attributes::CurrentFabricIndex::TypeInfo::DecodableType currentFabricIndex = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace OperationalCredentials
namespace GroupKeyManagement {
namespace Structs {
namespace GroupInfoMapStruct {
enum class Fields
{
    kGroupId     = 1,
    kEndpoints   = 2,
    kGroupName   = 3,
    kFabricIndex = 254,
};

struct Type
{
public:
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    DataModel::List<const chip::EndpointId> endpoints;
    Optional<chip::CharSpan> groupName;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & writer, TLV::Tag tag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & writer, TLV::Tag tag, FabricIndex accessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & writer, TLV::Tag tag, const Optional<FabricIndex> & accessingFabricIndex) const;
};

struct DecodableType
{
public:
    chip::GroupId groupId = static_cast<chip::GroupId>(0);
    DataModel::DecodableList<chip::EndpointId> endpoints;
    Optional<chip::CharSpan> groupName;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }
};

} // namespace GroupInfoMapStruct
namespace GroupKeyMapStruct {
enum class Fields
{
    kGroupId       = 1,
    kGroupKeySetID = 2,
    kFabricIndex   = 254,
};

struct Type
{
public:
    chip::GroupId groupId         = static_cast<chip::GroupId>(0);
    uint16_t groupKeySetID        = static_cast<uint16_t>(0);
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & writer, TLV::Tag tag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & writer, TLV::Tag tag, FabricIndex accessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & writer, TLV::Tag tag, const Optional<FabricIndex> & accessingFabricIndex) const;
};

using DecodableType = Type;

} // namespace GroupKeyMapStruct
namespace GroupKeySetStruct {
enum class Fields
{
    kGroupKeySetID          = 0,
    kGroupKeySecurityPolicy = 1,
    kEpochKey0              = 2,
    kEpochStartTime0        = 3,
    kEpochKey1              = 4,
    kEpochStartTime1        = 5,
    kEpochKey2              = 6,
    kEpochStartTime2        = 7,
};

struct Type
{
public:
    uint16_t groupKeySetID                        = static_cast<uint16_t>(0);
    GroupKeySecurityPolicy groupKeySecurityPolicy = static_cast<GroupKeySecurityPolicy>(0);
    DataModel::Nullable<chip::ByteSpan> epochKey0;
    DataModel::Nullable<uint64_t> epochStartTime0;
    DataModel::Nullable<chip::ByteSpan> epochKey1;
    DataModel::Nullable<uint64_t> epochStartTime1;
    DataModel::Nullable<chip::ByteSpan> epochKey2;
    DataModel::Nullable<uint64_t> epochStartTime2;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace GroupKeySetStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace KeySetWrite {
struct Type;
struct DecodableType;
} // namespace KeySetWrite

namespace KeySetRead {
struct Type;
struct DecodableType;
} // namespace KeySetRead

namespace KeySetReadResponse {
struct Type;
struct DecodableType;
} // namespace KeySetReadResponse

namespace KeySetRemove {
struct Type;
struct DecodableType;
} // namespace KeySetRemove

namespace KeySetReadAllIndices {
struct Type;
struct DecodableType;
} // namespace KeySetReadAllIndices

namespace KeySetReadAllIndicesResponse {
struct Type;
struct DecodableType;
} // namespace KeySetReadAllIndicesResponse

} // namespace Commands

namespace Commands {
namespace KeySetWrite {
enum class Fields
{
    kGroupKeySet = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetWrite::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    Structs::GroupKeySetStruct::Type groupKeySet;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetWrite::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    Structs::GroupKeySetStruct::DecodableType groupKeySet;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetWrite
namespace KeySetRead {
enum class Fields
{
    kGroupKeySetID = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetRead::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    uint16_t groupKeySetID = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::GroupKeyManagement::Commands::KeySetReadResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetRead::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    uint16_t groupKeySetID = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetRead
namespace KeySetReadResponse {
enum class Fields
{
    kGroupKeySet = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    Structs::GroupKeySetStruct::Type groupKeySet;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    Structs::GroupKeySetStruct::DecodableType groupKeySet;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetReadResponse
namespace KeySetRemove {
enum class Fields
{
    kGroupKeySetID = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetRemove::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    uint16_t groupKeySetID = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetRemove::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    uint16_t groupKeySetID = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetRemove
namespace KeySetReadAllIndices {
enum class Fields
{
    kGroupKeySetIDs = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadAllIndices::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    DataModel::List<const uint16_t> groupKeySetIDs;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::GroupKeyManagement::Commands::KeySetReadAllIndicesResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadAllIndices::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    DataModel::DecodableList<uint16_t> groupKeySetIDs;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetReadAllIndices
namespace KeySetReadAllIndicesResponse {
enum class Fields
{
    kGroupKeySetIDs = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadAllIndicesResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    DataModel::List<const uint16_t> groupKeySetIDs;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::KeySetReadAllIndicesResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

    DataModel::DecodableList<uint16_t> groupKeySetIDs;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace KeySetReadAllIndicesResponse
} // namespace Commands

namespace Attributes {

namespace GroupKeyMap {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::GroupKeyMap::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace GroupKeyMap
namespace GroupTable {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::DecodableType>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<
        chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::GroupTable::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace GroupTable
namespace MaxGroupsPerFabric {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxGroupsPerFabric::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxGroupsPerFabric
namespace MaxGroupKeysPerFabric {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxGroupKeysPerFabric::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxGroupKeysPerFabric
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::GroupKeyManagement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GroupKeyMap::TypeInfo::DecodableType groupKeyMap;
        Attributes::GroupTable::TypeInfo::DecodableType groupTable;
        Attributes::MaxGroupsPerFabric::TypeInfo::DecodableType maxGroupsPerFabric       = static_cast<uint16_t>(0);
        Attributes::MaxGroupKeysPerFabric::TypeInfo::DecodableType maxGroupKeysPerFabric = static_cast<uint16_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace GroupKeyManagement
namespace FixedLabel {
namespace Structs {
namespace LabelStruct = Clusters::detail::Structs::LabelStruct;
} // namespace Structs

namespace Attributes {

namespace LabelList {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::FixedLabel::Structs::LabelStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::FixedLabel::Structs::LabelStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::FixedLabel::Structs::LabelStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LabelList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LabelList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::FixedLabel::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::LabelList::TypeInfo::DecodableType labelList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace FixedLabel
namespace UserLabel {
namespace Structs {
namespace LabelStruct = Clusters::detail::Structs::LabelStruct;
} // namespace Structs

namespace Attributes {

namespace LabelList {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::UserLabel::Structs::LabelStruct::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::UserLabel::Structs::LabelStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::UserLabel::Structs::LabelStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LabelList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LabelList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::UserLabel::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::LabelList::TypeInfo::DecodableType labelList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace UserLabel
namespace ProxyConfiguration {

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ProxyConfiguration::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ProxyConfiguration
namespace ProxyDiscovery {

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ProxyDiscovery::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ProxyDiscovery
namespace ProxyValid {

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ProxyValid::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ProxyValid
namespace BooleanState {

namespace Attributes {

namespace StateValue {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StateValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StateValue
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::StateValue::TypeInfo::DecodableType stateValue = static_cast<bool>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace StateChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kStateValue = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }
    static constexpr bool kIsFabricScoped = false;

    bool stateValue = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::StateChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BooleanState::Id; }

    bool stateValue = static_cast<bool>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace StateChange
} // namespace Events
} // namespace BooleanState
namespace ModeSelect {
namespace Structs {
namespace SemanticTag {
enum class Fields
{
    kMfgCode = 0,
    kValue   = 1,
};

struct Type
{
public:
    uint16_t mfgCode = static_cast<uint16_t>(0);
    uint16_t value   = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace SemanticTag
namespace ModeOptionStruct {
enum class Fields
{
    kLabel        = 0,
    kMode         = 1,
    kSemanticTags = 2,
};

struct Type
{
public:
    chip::CharSpan label;
    uint8_t mode = static_cast<uint8_t>(0);
    DataModel::List<const Structs::SemanticTag::Type> semanticTags;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    chip::CharSpan label;
    uint8_t mode = static_cast<uint8_t>(0);
    DataModel::DecodableList<Structs::SemanticTag::DecodableType> semanticTags;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace ModeOptionStruct
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeToMode {
struct Type;
struct DecodableType;
} // namespace ChangeToMode

} // namespace Commands

namespace Commands {
namespace ChangeToMode {
enum class Fields
{
    kNewMode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeToMode::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }

    uint8_t newMode = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeToMode
} // namespace Commands

namespace Attributes {

namespace Description {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Description::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace Description
namespace StandardNamespace {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StandardNamespace::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StandardNamespace
namespace SupportedModes {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedModes
namespace CurrentMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentMode
namespace StartUpMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpMode
namespace OnMode {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OnMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OnMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ModeSelect::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Description::TypeInfo::DecodableType description;
        Attributes::StandardNamespace::TypeInfo::DecodableType standardNamespace;
        Attributes::SupportedModes::TypeInfo::DecodableType supportedModes;
        Attributes::CurrentMode::TypeInfo::DecodableType currentMode = static_cast<uint8_t>(0);
        Attributes::StartUpMode::TypeInfo::DecodableType startUpMode;
        Attributes::OnMode::TypeInfo::DecodableType onMode;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ModeSelect
namespace DoorLock {
namespace Structs {
namespace DlCredential {
enum class Fields
{
    kCredentialType  = 0,
    kCredentialIndex = 1,
};

struct Type
{
public:
    DlCredentialType credentialType = static_cast<DlCredentialType>(0);
    uint16_t credentialIndex        = static_cast<uint16_t>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace DlCredential
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace LockDoor {
struct Type;
struct DecodableType;
} // namespace LockDoor

namespace UnlockDoor {
struct Type;
struct DecodableType;
} // namespace UnlockDoor

namespace UnlockWithTimeout {
struct Type;
struct DecodableType;
} // namespace UnlockWithTimeout

namespace SetWeekDaySchedule {
struct Type;
struct DecodableType;
} // namespace SetWeekDaySchedule

namespace GetWeekDaySchedule {
struct Type;
struct DecodableType;
} // namespace GetWeekDaySchedule

namespace GetWeekDayScheduleResponse {
struct Type;
struct DecodableType;
} // namespace GetWeekDayScheduleResponse

namespace ClearWeekDaySchedule {
struct Type;
struct DecodableType;
} // namespace ClearWeekDaySchedule

namespace SetYearDaySchedule {
struct Type;
struct DecodableType;
} // namespace SetYearDaySchedule

namespace GetYearDaySchedule {
struct Type;
struct DecodableType;
} // namespace GetYearDaySchedule

namespace GetYearDayScheduleResponse {
struct Type;
struct DecodableType;
} // namespace GetYearDayScheduleResponse

namespace ClearYearDaySchedule {
struct Type;
struct DecodableType;
} // namespace ClearYearDaySchedule

namespace SetHolidaySchedule {
struct Type;
struct DecodableType;
} // namespace SetHolidaySchedule

namespace GetHolidaySchedule {
struct Type;
struct DecodableType;
} // namespace GetHolidaySchedule

namespace GetHolidayScheduleResponse {
struct Type;
struct DecodableType;
} // namespace GetHolidayScheduleResponse

namespace ClearHolidaySchedule {
struct Type;
struct DecodableType;
} // namespace ClearHolidaySchedule

namespace SetUser {
struct Type;
struct DecodableType;
} // namespace SetUser

namespace GetUser {
struct Type;
struct DecodableType;
} // namespace GetUser

namespace GetUserResponse {
struct Type;
struct DecodableType;
} // namespace GetUserResponse

namespace ClearUser {
struct Type;
struct DecodableType;
} // namespace ClearUser

namespace SetCredential {
struct Type;
struct DecodableType;
} // namespace SetCredential

namespace SetCredentialResponse {
struct Type;
struct DecodableType;
} // namespace SetCredentialResponse

namespace GetCredentialStatus {
struct Type;
struct DecodableType;
} // namespace GetCredentialStatus

namespace GetCredentialStatusResponse {
struct Type;
struct DecodableType;
} // namespace GetCredentialStatusResponse

namespace ClearCredential {
struct Type;
struct DecodableType;
} // namespace ClearCredential

} // namespace Commands

namespace Commands {
namespace LockDoor {
enum class Fields
{
    kPinCode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::LockDoor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Optional<chip::ByteSpan> pinCode;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::LockDoor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Optional<chip::ByteSpan> pinCode;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace LockDoor
namespace UnlockDoor {
enum class Fields
{
    kPinCode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UnlockDoor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Optional<chip::ByteSpan> pinCode;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UnlockDoor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Optional<chip::ByteSpan> pinCode;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UnlockDoor
namespace UnlockWithTimeout {
enum class Fields
{
    kTimeout = 0,
    kPinCode = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UnlockWithTimeout::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t timeout = static_cast<uint16_t>(0);
    Optional<chip::ByteSpan> pinCode;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UnlockWithTimeout::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t timeout = static_cast<uint16_t>(0);
    Optional<chip::ByteSpan> pinCode;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UnlockWithTimeout
namespace SetWeekDaySchedule {
enum class Fields
{
    kWeekDayIndex = 0,
    kUserIndex    = 1,
    kDaysMask     = 2,
    kStartHour    = 3,
    kStartMinute  = 4,
    kEndHour      = 5,
    kEndMinute    = 6,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex                  = static_cast<uint8_t>(0);
    uint16_t userIndex                    = static_cast<uint16_t>(0);
    chip::BitMask<DlDaysMaskMap> daysMask = static_cast<chip::BitMask<DlDaysMaskMap>>(0);
    uint8_t startHour                     = static_cast<uint8_t>(0);
    uint8_t startMinute                   = static_cast<uint8_t>(0);
    uint8_t endHour                       = static_cast<uint8_t>(0);
    uint8_t endMinute                     = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex                  = static_cast<uint8_t>(0);
    uint16_t userIndex                    = static_cast<uint16_t>(0);
    chip::BitMask<DlDaysMaskMap> daysMask = static_cast<chip::BitMask<DlDaysMaskMap>>(0);
    uint8_t startHour                     = static_cast<uint8_t>(0);
    uint8_t startMinute                   = static_cast<uint8_t>(0);
    uint8_t endHour                       = static_cast<uint8_t>(0);
    uint8_t endMinute                     = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetWeekDaySchedule
namespace GetWeekDaySchedule {
enum class Fields
{
    kWeekDayIndex = 0,
    kUserIndex    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::DoorLock::Commands::GetWeekDayScheduleResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetWeekDaySchedule
namespace GetWeekDayScheduleResponse {
enum class Fields
{
    kWeekDayIndex = 0,
    kUserIndex    = 1,
    kStatus       = 2,
    kDaysMask     = 3,
    kStartHour    = 4,
    kStartMinute  = 5,
    kEndHour      = 6,
    kEndMinute    = 7,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetWeekDayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<chip::BitMask<DlDaysMaskMap>> daysMask;
    Optional<uint8_t> startHour;
    Optional<uint8_t> startMinute;
    Optional<uint8_t> endHour;
    Optional<uint8_t> endMinute;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetWeekDayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<chip::BitMask<DlDaysMaskMap>> daysMask;
    Optional<uint8_t> startHour;
    Optional<uint8_t> startMinute;
    Optional<uint8_t> endHour;
    Optional<uint8_t> endMinute;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetWeekDayScheduleResponse
namespace ClearWeekDaySchedule {
enum class Fields
{
    kWeekDayIndex = 0,
    kUserIndex    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearWeekDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t weekDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearWeekDaySchedule
namespace SetYearDaySchedule {
enum class Fields
{
    kYearDayIndex   = 0,
    kUserIndex      = 1,
    kLocalStartTime = 2,
    kLocalEndTime   = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex    = static_cast<uint8_t>(0);
    uint16_t userIndex      = static_cast<uint16_t>(0);
    uint32_t localStartTime = static_cast<uint32_t>(0);
    uint32_t localEndTime   = static_cast<uint32_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex    = static_cast<uint8_t>(0);
    uint16_t userIndex      = static_cast<uint16_t>(0);
    uint32_t localStartTime = static_cast<uint32_t>(0);
    uint32_t localEndTime   = static_cast<uint32_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetYearDaySchedule
namespace GetYearDaySchedule {
enum class Fields
{
    kYearDayIndex = 0,
    kUserIndex    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::DoorLock::Commands::GetYearDayScheduleResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetYearDaySchedule
namespace GetYearDayScheduleResponse {
enum class Fields
{
    kYearDayIndex   = 0,
    kUserIndex      = 1,
    kStatus         = 2,
    kLocalStartTime = 3,
    kLocalEndTime   = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetYearDayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<uint32_t> localStartTime;
    Optional<uint32_t> localEndTime;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetYearDayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<uint32_t> localStartTime;
    Optional<uint32_t> localEndTime;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetYearDayScheduleResponse
namespace ClearYearDaySchedule {
enum class Fields
{
    kYearDayIndex = 0,
    kUserIndex    = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearYearDaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t yearDayIndex = static_cast<uint8_t>(0);
    uint16_t userIndex   = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearYearDaySchedule
namespace SetHolidaySchedule {
enum class Fields
{
    kHolidayIndex   = 0,
    kLocalStartTime = 1,
    kLocalEndTime   = 2,
    kOperatingMode  = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex          = static_cast<uint8_t>(0);
    uint32_t localStartTime       = static_cast<uint32_t>(0);
    uint32_t localEndTime         = static_cast<uint32_t>(0);
    DlOperatingMode operatingMode = static_cast<DlOperatingMode>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex          = static_cast<uint8_t>(0);
    uint32_t localStartTime       = static_cast<uint32_t>(0);
    uint32_t localEndTime         = static_cast<uint32_t>(0);
    DlOperatingMode operatingMode = static_cast<DlOperatingMode>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetHolidaySchedule
namespace GetHolidaySchedule {
enum class Fields
{
    kHolidayIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::DoorLock::Commands::GetHolidayScheduleResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetHolidaySchedule
namespace GetHolidayScheduleResponse {
enum class Fields
{
    kHolidayIndex   = 0,
    kStatus         = 1,
    kLocalStartTime = 2,
    kLocalEndTime   = 3,
    kOperatingMode  = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetHolidayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<uint32_t> localStartTime;
    Optional<uint32_t> localEndTime;
    Optional<DlOperatingMode> operatingMode;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetHolidayScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);
    DlStatus status      = static_cast<DlStatus>(0);
    Optional<uint32_t> localStartTime;
    Optional<uint32_t> localEndTime;
    Optional<DlOperatingMode> operatingMode;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetHolidayScheduleResponse
namespace ClearHolidaySchedule {
enum class Fields
{
    kHolidayIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearHolidaySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint8_t holidayIndex = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearHolidaySchedule
namespace SetUser {
enum class Fields
{
    kOperationType  = 0,
    kUserIndex      = 1,
    kUserName       = 2,
    kUserUniqueId   = 3,
    kUserStatus     = 4,
    kUserType       = 5,
    kCredentialRule = 6,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlDataOperationType operationType = static_cast<DlDataOperationType>(0);
    uint16_t userIndex                = static_cast<uint16_t>(0);
    DataModel::Nullable<chip::CharSpan> userName;
    DataModel::Nullable<uint32_t> userUniqueId;
    DataModel::Nullable<DlUserStatus> userStatus;
    DataModel::Nullable<DlUserType> userType;
    DataModel::Nullable<DlCredentialRule> credentialRule;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlDataOperationType operationType = static_cast<DlDataOperationType>(0);
    uint16_t userIndex                = static_cast<uint16_t>(0);
    DataModel::Nullable<chip::CharSpan> userName;
    DataModel::Nullable<uint32_t> userUniqueId;
    DataModel::Nullable<DlUserStatus> userStatus;
    DataModel::Nullable<DlUserType> userType;
    DataModel::Nullable<DlCredentialRule> credentialRule;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetUser
namespace GetUser {
enum class Fields
{
    kUserIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::DoorLock::Commands::GetUserResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetUser
namespace GetUserResponse {
enum class Fields
{
    kUserIndex               = 0,
    kUserName                = 1,
    kUserUniqueId            = 2,
    kUserStatus              = 3,
    kUserType                = 4,
    kCredentialRule          = 5,
    kCredentials             = 6,
    kCreatorFabricIndex      = 7,
    kLastModifiedFabricIndex = 8,
    kNextUserIndex           = 9,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetUserResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);
    DataModel::Nullable<chip::CharSpan> userName;
    DataModel::Nullable<uint32_t> userUniqueId;
    DataModel::Nullable<DlUserStatus> userStatus;
    DataModel::Nullable<DlUserType> userType;
    DataModel::Nullable<DlCredentialRule> credentialRule;
    DataModel::Nullable<DataModel::List<const Structs::DlCredential::Type>> credentials;
    DataModel::Nullable<chip::FabricIndex> creatorFabricIndex;
    DataModel::Nullable<chip::FabricIndex> lastModifiedFabricIndex;
    DataModel::Nullable<uint16_t> nextUserIndex;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetUserResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);
    DataModel::Nullable<chip::CharSpan> userName;
    DataModel::Nullable<uint32_t> userUniqueId;
    DataModel::Nullable<DlUserStatus> userStatus;
    DataModel::Nullable<DlUserType> userType;
    DataModel::Nullable<DlCredentialRule> credentialRule;
    DataModel::Nullable<DataModel::DecodableList<Structs::DlCredential::DecodableType>> credentials;
    DataModel::Nullable<chip::FabricIndex> creatorFabricIndex;
    DataModel::Nullable<chip::FabricIndex> lastModifiedFabricIndex;
    DataModel::Nullable<uint16_t> nextUserIndex;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetUserResponse
namespace ClearUser {
enum class Fields
{
    kUserIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearUser::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    uint16_t userIndex = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearUser
namespace SetCredential {
enum class Fields
{
    kOperationType  = 0,
    kCredential     = 1,
    kCredentialData = 2,
    kUserIndex      = 3,
    kUserStatus     = 4,
    kUserType       = 5,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetCredential::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlDataOperationType operationType = static_cast<DlDataOperationType>(0);
    Structs::DlCredential::Type credential;
    chip::ByteSpan credentialData;
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<DlUserStatus> userStatus;
    DataModel::Nullable<DlUserType> userType;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::DoorLock::Commands::SetCredentialResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetCredential::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlDataOperationType operationType = static_cast<DlDataOperationType>(0);
    Structs::DlCredential::DecodableType credential;
    chip::ByteSpan credentialData;
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<DlUserStatus> userStatus;
    DataModel::Nullable<DlUserType> userType;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetCredential
namespace SetCredentialResponse {
enum class Fields
{
    kStatus              = 0,
    kUserIndex           = 1,
    kNextCredentialIndex = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetCredentialResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlStatus status = static_cast<DlStatus>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<uint16_t> nextCredentialIndex;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetCredentialResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlStatus status = static_cast<DlStatus>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<uint16_t> nextCredentialIndex;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetCredentialResponse
namespace GetCredentialStatus {
enum class Fields
{
    kCredential = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetCredentialStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Structs::DlCredential::Type credential;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::DoorLock::Commands::GetCredentialStatusResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetCredentialStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    Structs::DlCredential::DecodableType credential;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetCredentialStatus
namespace GetCredentialStatusResponse {
enum class Fields
{
    kCredentialExists        = 0,
    kUserIndex               = 1,
    kCreatorFabricIndex      = 2,
    kLastModifiedFabricIndex = 3,
    kNextCredentialIndex     = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetCredentialStatusResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    bool credentialExists = static_cast<bool>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<chip::FabricIndex> creatorFabricIndex;
    DataModel::Nullable<chip::FabricIndex> lastModifiedFabricIndex;
    DataModel::Nullable<uint16_t> nextCredentialIndex;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetCredentialStatusResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    bool credentialExists = static_cast<bool>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<chip::FabricIndex> creatorFabricIndex;
    DataModel::Nullable<chip::FabricIndex> lastModifiedFabricIndex;
    DataModel::Nullable<uint16_t> nextCredentialIndex;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetCredentialStatusResponse
namespace ClearCredential {
enum class Fields
{
    kCredential = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearCredential::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DataModel::Nullable<Structs::DlCredential::Type> credential;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearCredential::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DataModel::Nullable<Structs::DlCredential::DecodableType> credential;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearCredential
} // namespace Commands

namespace Attributes {

namespace LockState {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlLockState>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlLockState>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlLockState> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LockState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LockState
namespace LockType {
struct TypeInfo
{
    using Type             = chip::app::Clusters::DoorLock::DlLockType;
    using DecodableType    = chip::app::Clusters::DoorLock::DlLockType;
    using DecodableArgType = chip::app::Clusters::DoorLock::DlLockType;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LockType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LockType
namespace ActuatorEnabled {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActuatorEnabled::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActuatorEnabled
namespace DoorState {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlDoorState>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlDoorState>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlDoorState> &;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DoorState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DoorState
namespace DoorOpenEvents {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DoorOpenEvents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DoorOpenEvents
namespace DoorClosedEvents {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DoorClosedEvents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DoorClosedEvents
namespace OpenPeriod {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OpenPeriod::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OpenPeriod
namespace NumberOfTotalUsersSupported {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfTotalUsersSupported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfTotalUsersSupported
namespace NumberOfPINUsersSupported {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfPINUsersSupported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfPINUsersSupported
namespace NumberOfRFIDUsersSupported {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfRFIDUsersSupported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfRFIDUsersSupported
namespace NumberOfWeekDaySchedulesSupportedPerUser {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfWeekDaySchedulesSupportedPerUser::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfWeekDaySchedulesSupportedPerUser
namespace NumberOfYearDaySchedulesSupportedPerUser {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfYearDaySchedulesSupportedPerUser::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfYearDaySchedulesSupportedPerUser
namespace NumberOfHolidaySchedulesSupported {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfHolidaySchedulesSupported::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfHolidaySchedulesSupported
namespace MaxPINCodeLength {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxPINCodeLength::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxPINCodeLength
namespace MinPINCodeLength {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinPINCodeLength::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinPINCodeLength
namespace MaxRFIDCodeLength {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxRFIDCodeLength::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxRFIDCodeLength
namespace MinRFIDCodeLength {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinRFIDCodeLength::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinRFIDCodeLength
namespace CredentialRulesSupport {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DoorLock::DlCredentialRuleMask>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DoorLock::DlCredentialRuleMask>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DoorLock::DlCredentialRuleMask>;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CredentialRulesSupport::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CredentialRulesSupport
namespace NumberOfCredentialsSupportedPerUser {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfCredentialsSupportedPerUser::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfCredentialsSupportedPerUser
namespace Language {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Language::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 3; }
};
} // namespace Language
namespace LEDSettings {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LEDSettings::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LEDSettings
namespace AutoRelockTime {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AutoRelockTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AutoRelockTime
namespace SoundVolume {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SoundVolume::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SoundVolume
namespace OperatingMode {
struct TypeInfo
{
    using Type             = chip::app::Clusters::DoorLock::DlOperatingMode;
    using DecodableType    = chip::app::Clusters::DoorLock::DlOperatingMode;
    using DecodableArgType = chip::app::Clusters::DoorLock::DlOperatingMode;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperatingMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperatingMode
namespace SupportedOperatingModes {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DoorLock::DlSupportedOperatingModes>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DoorLock::DlSupportedOperatingModes>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DoorLock::DlSupportedOperatingModes>;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedOperatingModes::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedOperatingModes
namespace DefaultConfigurationRegister {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DoorLock::DlDefaultConfigurationRegister>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DoorLock::DlDefaultConfigurationRegister>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DoorLock::DlDefaultConfigurationRegister>;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DefaultConfigurationRegister::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DefaultConfigurationRegister
namespace EnableLocalProgramming {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnableLocalProgramming::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnableLocalProgramming
namespace EnableOneTouchLocking {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnableOneTouchLocking::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnableOneTouchLocking
namespace EnableInsideStatusLED {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnableInsideStatusLED::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnableInsideStatusLED
namespace EnablePrivacyModeButton {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnablePrivacyModeButton::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnablePrivacyModeButton
namespace LocalProgrammingFeatures {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::DoorLock::DlLocalProgrammingFeatures>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::DoorLock::DlLocalProgrammingFeatures>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::DoorLock::DlLocalProgrammingFeatures>;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LocalProgrammingFeatures::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LocalProgrammingFeatures
namespace WrongCodeEntryLimit {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WrongCodeEntryLimit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WrongCodeEntryLimit
namespace UserCodeTemporaryDisableTime {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UserCodeTemporaryDisableTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UserCodeTemporaryDisableTime
namespace SendPINOverTheAir {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SendPINOverTheAir::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SendPINOverTheAir
namespace RequirePINforRemoteOperation {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RequirePINforRemoteOperation::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RequirePINforRemoteOperation
namespace ExpiringUserTimeout {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ExpiringUserTimeout::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ExpiringUserTimeout
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::LockState::TypeInfo::DecodableType lockState;
        Attributes::LockType::TypeInfo::DecodableType lockType = static_cast<chip::app::Clusters::DoorLock::DlLockType>(0);
        Attributes::ActuatorEnabled::TypeInfo::DecodableType actuatorEnabled = static_cast<bool>(0);
        Attributes::DoorState::TypeInfo::DecodableType doorState;
        Attributes::DoorOpenEvents::TypeInfo::DecodableType doorOpenEvents                           = static_cast<uint32_t>(0);
        Attributes::DoorClosedEvents::TypeInfo::DecodableType doorClosedEvents                       = static_cast<uint32_t>(0);
        Attributes::OpenPeriod::TypeInfo::DecodableType openPeriod                                   = static_cast<uint16_t>(0);
        Attributes::NumberOfTotalUsersSupported::TypeInfo::DecodableType numberOfTotalUsersSupported = static_cast<uint16_t>(0);
        Attributes::NumberOfPINUsersSupported::TypeInfo::DecodableType numberOfPINUsersSupported     = static_cast<uint16_t>(0);
        Attributes::NumberOfRFIDUsersSupported::TypeInfo::DecodableType numberOfRFIDUsersSupported   = static_cast<uint16_t>(0);
        Attributes::NumberOfWeekDaySchedulesSupportedPerUser::TypeInfo::DecodableType numberOfWeekDaySchedulesSupportedPerUser =
            static_cast<uint8_t>(0);
        Attributes::NumberOfYearDaySchedulesSupportedPerUser::TypeInfo::DecodableType numberOfYearDaySchedulesSupportedPerUser =
            static_cast<uint8_t>(0);
        Attributes::NumberOfHolidaySchedulesSupported::TypeInfo::DecodableType numberOfHolidaySchedulesSupported =
            static_cast<uint8_t>(0);
        Attributes::MaxPINCodeLength::TypeInfo::DecodableType maxPINCodeLength   = static_cast<uint8_t>(0);
        Attributes::MinPINCodeLength::TypeInfo::DecodableType minPINCodeLength   = static_cast<uint8_t>(0);
        Attributes::MaxRFIDCodeLength::TypeInfo::DecodableType maxRFIDCodeLength = static_cast<uint8_t>(0);
        Attributes::MinRFIDCodeLength::TypeInfo::DecodableType minRFIDCodeLength = static_cast<uint8_t>(0);
        Attributes::CredentialRulesSupport::TypeInfo::DecodableType credentialRulesSupport =
            static_cast<chip::BitMask<chip::app::Clusters::DoorLock::DlCredentialRuleMask>>(0);
        Attributes::NumberOfCredentialsSupportedPerUser::TypeInfo::DecodableType numberOfCredentialsSupportedPerUser =
            static_cast<uint8_t>(0);
        Attributes::Language::TypeInfo::DecodableType language;
        Attributes::LEDSettings::TypeInfo::DecodableType LEDSettings       = static_cast<uint8_t>(0);
        Attributes::AutoRelockTime::TypeInfo::DecodableType autoRelockTime = static_cast<uint32_t>(0);
        Attributes::SoundVolume::TypeInfo::DecodableType soundVolume       = static_cast<uint8_t>(0);
        Attributes::OperatingMode::TypeInfo::DecodableType operatingMode =
            static_cast<chip::app::Clusters::DoorLock::DlOperatingMode>(0);
        Attributes::SupportedOperatingModes::TypeInfo::DecodableType supportedOperatingModes =
            static_cast<chip::BitMask<chip::app::Clusters::DoorLock::DlSupportedOperatingModes>>(0);
        Attributes::DefaultConfigurationRegister::TypeInfo::DecodableType defaultConfigurationRegister =
            static_cast<chip::BitMask<chip::app::Clusters::DoorLock::DlDefaultConfigurationRegister>>(0);
        Attributes::EnableLocalProgramming::TypeInfo::DecodableType enableLocalProgramming   = static_cast<bool>(0);
        Attributes::EnableOneTouchLocking::TypeInfo::DecodableType enableOneTouchLocking     = static_cast<bool>(0);
        Attributes::EnableInsideStatusLED::TypeInfo::DecodableType enableInsideStatusLED     = static_cast<bool>(0);
        Attributes::EnablePrivacyModeButton::TypeInfo::DecodableType enablePrivacyModeButton = static_cast<bool>(0);
        Attributes::LocalProgrammingFeatures::TypeInfo::DecodableType localProgrammingFeatures =
            static_cast<chip::BitMask<chip::app::Clusters::DoorLock::DlLocalProgrammingFeatures>>(0);
        Attributes::WrongCodeEntryLimit::TypeInfo::DecodableType wrongCodeEntryLimit                   = static_cast<uint8_t>(0);
        Attributes::UserCodeTemporaryDisableTime::TypeInfo::DecodableType userCodeTemporaryDisableTime = static_cast<uint8_t>(0);
        Attributes::SendPINOverTheAir::TypeInfo::DecodableType sendPINOverTheAir                       = static_cast<bool>(0);
        Attributes::RequirePINforRemoteOperation::TypeInfo::DecodableType requirePINforRemoteOperation = static_cast<bool>(0);
        Attributes::ExpiringUserTimeout::TypeInfo::DecodableType expiringUserTimeout                   = static_cast<uint16_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace DoorLockAlarm {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
    kAlarmCode = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DoorLockAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr bool kIsFabricScoped = false;

    DlAlarmCode alarmCode = static_cast<DlAlarmCode>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DoorLockAlarm::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlAlarmCode alarmCode = static_cast<DlAlarmCode>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace DoorLockAlarm
namespace DoorStateChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
    kDoorState = 0,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DoorStateChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr bool kIsFabricScoped = false;

    DlDoorState doorState = static_cast<DlDoorState>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DoorStateChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlDoorState doorState = static_cast<DlDoorState>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace DoorStateChange
namespace LockOperation {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
    kLockOperationType = 0,
    kOperationSource   = 1,
    kUserIndex         = 2,
    kFabricIndex       = 3,
    kSourceNode        = 4,
    kCredentials       = 5,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LockOperation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr bool kIsFabricScoped = false;

    DlLockOperationType lockOperationType = static_cast<DlLockOperationType>(0);
    DlOperationSource operationSource     = static_cast<DlOperationSource>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<chip::FabricIndex> fabricIndex;
    DataModel::Nullable<chip::NodeId> sourceNode;
    Optional<DataModel::Nullable<DataModel::List<const Structs::DlCredential::Type>>> credentials;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LockOperation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlLockOperationType lockOperationType = static_cast<DlLockOperationType>(0);
    DlOperationSource operationSource     = static_cast<DlOperationSource>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<chip::FabricIndex> fabricIndex;
    DataModel::Nullable<chip::NodeId> sourceNode;
    Optional<DataModel::Nullable<DataModel::DecodableList<Structs::DlCredential::DecodableType>>> credentials;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace LockOperation
namespace LockOperationError {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
    kLockOperationType = 0,
    kOperationSource   = 1,
    kOperationError    = 2,
    kUserIndex         = 3,
    kFabricIndex       = 4,
    kSourceNode        = 5,
    kCredentials       = 6,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LockOperationError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr bool kIsFabricScoped = false;

    DlLockOperationType lockOperationType = static_cast<DlLockOperationType>(0);
    DlOperationSource operationSource     = static_cast<DlOperationSource>(0);
    DlOperationError operationError       = static_cast<DlOperationError>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<chip::FabricIndex> fabricIndex;
    DataModel::Nullable<chip::NodeId> sourceNode;
    Optional<DataModel::Nullable<DataModel::List<const Structs::DlCredential::Type>>> credentials;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LockOperationError::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlLockOperationType lockOperationType = static_cast<DlLockOperationType>(0);
    DlOperationSource operationSource     = static_cast<DlOperationSource>(0);
    DlOperationError operationError       = static_cast<DlOperationError>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<chip::FabricIndex> fabricIndex;
    DataModel::Nullable<chip::NodeId> sourceNode;
    Optional<DataModel::Nullable<DataModel::DecodableList<Structs::DlCredential::DecodableType>>> credentials;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace LockOperationError
namespace LockUserChange {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
    kLockDataType      = 0,
    kDataOperationType = 1,
    kOperationSource   = 2,
    kUserIndex         = 3,
    kFabricIndex       = 4,
    kSourceNode        = 5,
    kDataIndex         = 6,
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LockUserChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }
    static constexpr bool kIsFabricScoped = false;

    DlLockDataType lockDataType           = static_cast<DlLockDataType>(0);
    DlDataOperationType dataOperationType = static_cast<DlDataOperationType>(0);
    DlOperationSource operationSource     = static_cast<DlOperationSource>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<chip::FabricIndex> fabricIndex;
    DataModel::Nullable<chip::NodeId> sourceNode;
    DataModel::Nullable<uint16_t> dataIndex;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::LockUserChange::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::DoorLock::Id; }

    DlLockDataType lockDataType           = static_cast<DlLockDataType>(0);
    DlDataOperationType dataOperationType = static_cast<DlDataOperationType>(0);
    DlOperationSource operationSource     = static_cast<DlOperationSource>(0);
    DataModel::Nullable<uint16_t> userIndex;
    DataModel::Nullable<chip::FabricIndex> fabricIndex;
    DataModel::Nullable<chip::NodeId> sourceNode;
    DataModel::Nullable<uint16_t> dataIndex;

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace LockUserChange
} // namespace Events
} // namespace DoorLock
namespace WindowCovering {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace UpOrOpen {
struct Type;
struct DecodableType;
} // namespace UpOrOpen

namespace DownOrClose {
struct Type;
struct DecodableType;
} // namespace DownOrClose

namespace StopMotion {
struct Type;
struct DecodableType;
} // namespace StopMotion

namespace GoToLiftValue {
struct Type;
struct DecodableType;
} // namespace GoToLiftValue

namespace GoToLiftPercentage {
struct Type;
struct DecodableType;
} // namespace GoToLiftPercentage

namespace GoToTiltValue {
struct Type;
struct DecodableType;
} // namespace GoToTiltValue

namespace GoToTiltPercentage {
struct Type;
struct DecodableType;
} // namespace GoToTiltPercentage

} // namespace Commands

namespace Commands {
namespace UpOrOpen {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::UpOrOpen::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::UpOrOpen::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace UpOrOpen
namespace DownOrClose {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::DownOrClose::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::DownOrClose::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace DownOrClose
namespace StopMotion {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StopMotion::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StopMotion::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StopMotion
namespace GoToLiftValue {
enum class Fields
{
    kLiftValue = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GoToLiftValue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    uint16_t liftValue = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GoToLiftValue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    uint16_t liftValue = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GoToLiftValue
namespace GoToLiftPercentage {
enum class Fields
{
    kLiftPercent100thsValue = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GoToLiftPercentage::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    chip::Percent100ths liftPercent100thsValue = static_cast<chip::Percent100ths>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GoToLiftPercentage::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    chip::Percent100ths liftPercent100thsValue = static_cast<chip::Percent100ths>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GoToLiftPercentage
namespace GoToTiltValue {
enum class Fields
{
    kTiltValue = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GoToTiltValue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    uint16_t tiltValue = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GoToTiltValue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    uint16_t tiltValue = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GoToTiltValue
namespace GoToTiltPercentage {
enum class Fields
{
    kTiltPercent100thsValue = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GoToTiltPercentage::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    chip::Percent100ths tiltPercent100thsValue = static_cast<chip::Percent100ths>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GoToTiltPercentage::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

    chip::Percent100ths tiltPercent100thsValue = static_cast<chip::Percent100ths>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GoToTiltPercentage
} // namespace Commands

namespace Attributes {

namespace Type {
struct TypeInfo
{
    using Type             = chip::app::Clusters::WindowCovering::Type;
    using DecodableType    = chip::app::Clusters::WindowCovering::Type;
    using DecodableArgType = chip::app::Clusters::WindowCovering::Type;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Type::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Type
namespace PhysicalClosedLimitLift {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PhysicalClosedLimitLift::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PhysicalClosedLimitLift
namespace PhysicalClosedLimitTilt {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PhysicalClosedLimitTilt::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PhysicalClosedLimitTilt
namespace CurrentPositionLift {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentPositionLift::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentPositionLift
namespace CurrentPositionTilt {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentPositionTilt::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentPositionTilt
namespace NumberOfActuationsLift {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfActuationsLift::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfActuationsLift
namespace NumberOfActuationsTilt {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfActuationsTilt::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfActuationsTilt
namespace ConfigStatus {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::WindowCovering::ConfigStatus>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::WindowCovering::ConfigStatus>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::WindowCovering::ConfigStatus>;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ConfigStatus::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ConfigStatus
namespace CurrentPositionLiftPercentage {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::Percent> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentPositionLiftPercentage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentPositionLiftPercentage
namespace CurrentPositionTiltPercentage {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::Percent>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::Percent> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentPositionTiltPercentage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentPositionTiltPercentage
namespace OperationalStatus {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::WindowCovering::OperationalStatus>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::WindowCovering::OperationalStatus>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::WindowCovering::OperationalStatus>;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationalStatus::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationalStatus
namespace TargetPositionLiftPercent100ths {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::Percent100ths>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::Percent100ths>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::Percent100ths> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TargetPositionLiftPercent100ths::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TargetPositionLiftPercent100ths
namespace TargetPositionTiltPercent100ths {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::Percent100ths>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::Percent100ths>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::Percent100ths> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TargetPositionTiltPercent100ths::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TargetPositionTiltPercent100ths
namespace EndProductType {
struct TypeInfo
{
    using Type             = chip::app::Clusters::WindowCovering::EndProductType;
    using DecodableType    = chip::app::Clusters::WindowCovering::EndProductType;
    using DecodableArgType = chip::app::Clusters::WindowCovering::EndProductType;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EndProductType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EndProductType
namespace CurrentPositionLiftPercent100ths {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::Percent100ths>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::Percent100ths>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::Percent100ths> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentPositionLiftPercent100ths::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentPositionLiftPercent100ths
namespace CurrentPositionTiltPercent100ths {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<chip::Percent100ths>;
    using DecodableType    = chip::app::DataModel::Nullable<chip::Percent100ths>;
    using DecodableArgType = const chip::app::DataModel::Nullable<chip::Percent100ths> &;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentPositionTiltPercent100ths::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentPositionTiltPercent100ths
namespace InstalledOpenLimitLift {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InstalledOpenLimitLift::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InstalledOpenLimitLift
namespace InstalledClosedLimitLift {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InstalledClosedLimitLift::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InstalledClosedLimitLift
namespace InstalledOpenLimitTilt {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InstalledOpenLimitTilt::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InstalledOpenLimitTilt
namespace InstalledClosedLimitTilt {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InstalledClosedLimitTilt::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InstalledClosedLimitTilt
namespace Mode {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::WindowCovering::Mode>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::WindowCovering::Mode>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::WindowCovering::Mode>;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Mode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Mode
namespace SafetyStatus {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::WindowCovering::SafetyStatus>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::WindowCovering::SafetyStatus>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::WindowCovering::SafetyStatus>;

    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SafetyStatus::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SafetyStatus
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::WindowCovering::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Type::TypeInfo::DecodableType type = static_cast<chip::app::Clusters::WindowCovering::Type>(0);
        Attributes::PhysicalClosedLimitLift::TypeInfo::DecodableType physicalClosedLimitLift = static_cast<uint16_t>(0);
        Attributes::PhysicalClosedLimitTilt::TypeInfo::DecodableType physicalClosedLimitTilt = static_cast<uint16_t>(0);
        Attributes::CurrentPositionLift::TypeInfo::DecodableType currentPositionLift;
        Attributes::CurrentPositionTilt::TypeInfo::DecodableType currentPositionTilt;
        Attributes::NumberOfActuationsLift::TypeInfo::DecodableType numberOfActuationsLift = static_cast<uint16_t>(0);
        Attributes::NumberOfActuationsTilt::TypeInfo::DecodableType numberOfActuationsTilt = static_cast<uint16_t>(0);
        Attributes::ConfigStatus::TypeInfo::DecodableType configStatus =
            static_cast<chip::BitMask<chip::app::Clusters::WindowCovering::ConfigStatus>>(0);
        Attributes::CurrentPositionLiftPercentage::TypeInfo::DecodableType currentPositionLiftPercentage;
        Attributes::CurrentPositionTiltPercentage::TypeInfo::DecodableType currentPositionTiltPercentage;
        Attributes::OperationalStatus::TypeInfo::DecodableType operationalStatus =
            static_cast<chip::BitMask<chip::app::Clusters::WindowCovering::OperationalStatus>>(0);
        Attributes::TargetPositionLiftPercent100ths::TypeInfo::DecodableType targetPositionLiftPercent100ths;
        Attributes::TargetPositionTiltPercent100ths::TypeInfo::DecodableType targetPositionTiltPercent100ths;
        Attributes::EndProductType::TypeInfo::DecodableType endProductType =
            static_cast<chip::app::Clusters::WindowCovering::EndProductType>(0);
        Attributes::CurrentPositionLiftPercent100ths::TypeInfo::DecodableType currentPositionLiftPercent100ths;
        Attributes::CurrentPositionTiltPercent100ths::TypeInfo::DecodableType currentPositionTiltPercent100ths;
        Attributes::InstalledOpenLimitLift::TypeInfo::DecodableType installedOpenLimitLift     = static_cast<uint16_t>(0);
        Attributes::InstalledClosedLimitLift::TypeInfo::DecodableType installedClosedLimitLift = static_cast<uint16_t>(0);
        Attributes::InstalledOpenLimitTilt::TypeInfo::DecodableType installedOpenLimitTilt     = static_cast<uint16_t>(0);
        Attributes::InstalledClosedLimitTilt::TypeInfo::DecodableType installedClosedLimitTilt = static_cast<uint16_t>(0);
        Attributes::Mode::TypeInfo::DecodableType mode = static_cast<chip::BitMask<chip::app::Clusters::WindowCovering::Mode>>(0);
        Attributes::SafetyStatus::TypeInfo::DecodableType safetyStatus =
            static_cast<chip::BitMask<chip::app::Clusters::WindowCovering::SafetyStatus>>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace WindowCovering
namespace BarrierControl {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace BarrierControlGoToPercent {
struct Type;
struct DecodableType;
} // namespace BarrierControlGoToPercent

namespace BarrierControlStop {
struct Type;
struct DecodableType;
} // namespace BarrierControlStop

} // namespace Commands

namespace Commands {
namespace BarrierControlGoToPercent {
enum class Fields
{
    kPercentOpen = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::BarrierControlGoToPercent::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }

    uint8_t percentOpen = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::BarrierControlGoToPercent::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }

    uint8_t percentOpen = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace BarrierControlGoToPercent
namespace BarrierControlStop {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::BarrierControlStop::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::BarrierControlStop::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace BarrierControlStop
} // namespace Commands

namespace Attributes {

namespace BarrierMovingState {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BarrierMovingState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BarrierMovingState
namespace BarrierSafetyStatus {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BarrierSafetyStatus::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BarrierSafetyStatus
namespace BarrierCapabilities {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BarrierCapabilities::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BarrierCapabilities
namespace BarrierOpenEvents {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BarrierOpenEvents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BarrierOpenEvents
namespace BarrierCloseEvents {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BarrierCloseEvents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BarrierCloseEvents
namespace BarrierCommandOpenEvents {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BarrierCommandOpenEvents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BarrierCommandOpenEvents
namespace BarrierCommandCloseEvents {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BarrierCommandCloseEvents::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BarrierCommandCloseEvents
namespace BarrierOpenPeriod {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BarrierOpenPeriod::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BarrierOpenPeriod
namespace BarrierClosePeriod {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BarrierClosePeriod::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BarrierClosePeriod
namespace BarrierPosition {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BarrierPosition::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BarrierPosition
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::BarrierControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::BarrierMovingState::TypeInfo::DecodableType barrierMovingState               = static_cast<uint8_t>(0);
        Attributes::BarrierSafetyStatus::TypeInfo::DecodableType barrierSafetyStatus             = static_cast<uint16_t>(0);
        Attributes::BarrierCapabilities::TypeInfo::DecodableType barrierCapabilities             = static_cast<uint8_t>(0);
        Attributes::BarrierOpenEvents::TypeInfo::DecodableType barrierOpenEvents                 = static_cast<uint16_t>(0);
        Attributes::BarrierCloseEvents::TypeInfo::DecodableType barrierCloseEvents               = static_cast<uint16_t>(0);
        Attributes::BarrierCommandOpenEvents::TypeInfo::DecodableType barrierCommandOpenEvents   = static_cast<uint16_t>(0);
        Attributes::BarrierCommandCloseEvents::TypeInfo::DecodableType barrierCommandCloseEvents = static_cast<uint16_t>(0);
        Attributes::BarrierOpenPeriod::TypeInfo::DecodableType barrierOpenPeriod                 = static_cast<uint16_t>(0);
        Attributes::BarrierClosePeriod::TypeInfo::DecodableType barrierClosePeriod               = static_cast<uint16_t>(0);
        Attributes::BarrierPosition::TypeInfo::DecodableType barrierPosition                     = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace BarrierControl
namespace PumpConfigurationAndControl {

namespace Attributes {

namespace MaxPressure {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxPressure::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxPressure
namespace MaxSpeed {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxSpeed::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxSpeed
namespace MaxFlow {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxFlow::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxFlow
namespace MinConstPressure {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinConstPressure::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinConstPressure
namespace MaxConstPressure {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxConstPressure::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxConstPressure
namespace MinCompPressure {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinCompPressure::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinCompPressure
namespace MaxCompPressure {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxCompPressure::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxCompPressure
namespace MinConstSpeed {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinConstSpeed::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinConstSpeed
namespace MaxConstSpeed {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxConstSpeed::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxConstSpeed
namespace MinConstFlow {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinConstFlow::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinConstFlow
namespace MaxConstFlow {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxConstFlow::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxConstFlow
namespace MinConstTemp {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinConstTemp::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinConstTemp
namespace MaxConstTemp {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxConstTemp::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxConstTemp
namespace PumpStatus {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::PumpConfigurationAndControl::PumpStatus>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::PumpConfigurationAndControl::PumpStatus>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::PumpConfigurationAndControl::PumpStatus>;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PumpStatus::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PumpStatus
namespace EffectiveOperationMode {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PumpConfigurationAndControl::PumpOperationMode;
    using DecodableType    = chip::app::Clusters::PumpConfigurationAndControl::PumpOperationMode;
    using DecodableArgType = chip::app::Clusters::PumpConfigurationAndControl::PumpOperationMode;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EffectiveOperationMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EffectiveOperationMode
namespace EffectiveControlMode {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PumpConfigurationAndControl::PumpControlMode;
    using DecodableType    = chip::app::Clusters::PumpConfigurationAndControl::PumpControlMode;
    using DecodableArgType = chip::app::Clusters::PumpConfigurationAndControl::PumpControlMode;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EffectiveControlMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EffectiveControlMode
namespace Capacity {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Capacity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Capacity
namespace Speed {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Speed::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Speed
namespace LifetimeRunningHours {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LifetimeRunningHours::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LifetimeRunningHours
namespace Power {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Power::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Power
namespace LifetimeEnergyConsumed {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LifetimeEnergyConsumed::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LifetimeEnergyConsumed
namespace OperationMode {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PumpConfigurationAndControl::PumpOperationMode;
    using DecodableType    = chip::app::Clusters::PumpConfigurationAndControl::PumpOperationMode;
    using DecodableArgType = chip::app::Clusters::PumpConfigurationAndControl::PumpOperationMode;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OperationMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OperationMode
namespace ControlMode {
struct TypeInfo
{
    using Type             = chip::app::Clusters::PumpConfigurationAndControl::PumpControlMode;
    using DecodableType    = chip::app::Clusters::PumpConfigurationAndControl::PumpControlMode;
    using DecodableArgType = chip::app::Clusters::PumpConfigurationAndControl::PumpControlMode;

    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ControlMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ControlMode
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::MaxPressure::TypeInfo::DecodableType maxPressure;
        Attributes::MaxSpeed::TypeInfo::DecodableType maxSpeed;
        Attributes::MaxFlow::TypeInfo::DecodableType maxFlow;
        Attributes::MinConstPressure::TypeInfo::DecodableType minConstPressure;
        Attributes::MaxConstPressure::TypeInfo::DecodableType maxConstPressure;
        Attributes::MinCompPressure::TypeInfo::DecodableType minCompPressure;
        Attributes::MaxCompPressure::TypeInfo::DecodableType maxCompPressure;
        Attributes::MinConstSpeed::TypeInfo::DecodableType minConstSpeed;
        Attributes::MaxConstSpeed::TypeInfo::DecodableType maxConstSpeed;
        Attributes::MinConstFlow::TypeInfo::DecodableType minConstFlow;
        Attributes::MaxConstFlow::TypeInfo::DecodableType maxConstFlow;
        Attributes::MinConstTemp::TypeInfo::DecodableType minConstTemp;
        Attributes::MaxConstTemp::TypeInfo::DecodableType maxConstTemp;
        Attributes::PumpStatus::TypeInfo::DecodableType pumpStatus =
            static_cast<chip::BitMask<chip::app::Clusters::PumpConfigurationAndControl::PumpStatus>>(0);
        Attributes::EffectiveOperationMode::TypeInfo::DecodableType effectiveOperationMode =
            static_cast<chip::app::Clusters::PumpConfigurationAndControl::PumpOperationMode>(0);
        Attributes::EffectiveControlMode::TypeInfo::DecodableType effectiveControlMode =
            static_cast<chip::app::Clusters::PumpConfigurationAndControl::PumpControlMode>(0);
        Attributes::Capacity::TypeInfo::DecodableType capacity;
        Attributes::Speed::TypeInfo::DecodableType speed;
        Attributes::LifetimeRunningHours::TypeInfo::DecodableType lifetimeRunningHours;
        Attributes::Power::TypeInfo::DecodableType power;
        Attributes::LifetimeEnergyConsumed::TypeInfo::DecodableType lifetimeEnergyConsumed;
        Attributes::OperationMode::TypeInfo::DecodableType operationMode =
            static_cast<chip::app::Clusters::PumpConfigurationAndControl::PumpOperationMode>(0);
        Attributes::ControlMode::TypeInfo::DecodableType controlMode =
            static_cast<chip::app::Clusters::PumpConfigurationAndControl::PumpControlMode>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
namespace Events {
namespace SupplyVoltageLow {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SupplyVoltageLow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SupplyVoltageLow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SupplyVoltageLow
namespace SupplyVoltageHigh {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SupplyVoltageHigh::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SupplyVoltageHigh::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SupplyVoltageHigh
namespace PowerMissingPhase {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PowerMissingPhase::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PowerMissingPhase::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace PowerMissingPhase
namespace SystemPressureLow {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SystemPressureLow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SystemPressureLow::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SystemPressureLow
namespace SystemPressureHigh {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SystemPressureHigh::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SystemPressureHigh::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SystemPressureHigh
namespace DryRunning {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DryRunning::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::DryRunning::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace DryRunning
namespace MotorTemperatureHigh {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MotorTemperatureHigh::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::MotorTemperatureHigh::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace MotorTemperatureHigh
namespace PumpMotorFatalFailure {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PumpMotorFatalFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PumpMotorFatalFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace PumpMotorFatalFailure
namespace ElectronicTemperatureHigh {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ElectronicTemperatureHigh::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ElectronicTemperatureHigh::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ElectronicTemperatureHigh
namespace PumpBlocked {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PumpBlocked::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::PumpBlocked::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace PumpBlocked
namespace SensorFailure {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SensorFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::SensorFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace SensorFailure
namespace ElectronicNonFatalFailure {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ElectronicNonFatalFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ElectronicNonFatalFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ElectronicNonFatalFailure
namespace ElectronicFatalFailure {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Critical;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ElectronicFatalFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::ElectronicFatalFailure::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace ElectronicFatalFailure
namespace GeneralFault {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::GeneralFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::GeneralFault::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace GeneralFault
namespace Leakage {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Leakage::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::Leakage::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace Leakage
namespace AirDetection {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AirDetection::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::AirDetection::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace AirDetection
namespace TurbineOperation {
static constexpr PriorityLevel kPriorityLevel = PriorityLevel::Info;

enum class Fields
{
};

struct Type
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::TurbineOperation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }
    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    static constexpr PriorityLevel GetPriorityLevel() { return kPriorityLevel; }
    static constexpr EventId GetEventId() { return Events::TurbineOperation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::PumpConfigurationAndControl::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
} // namespace TurbineOperation
} // namespace Events
} // namespace PumpConfigurationAndControl
namespace Thermostat {
namespace Structs {
namespace ThermostatScheduleTransition {
enum class Fields
{
    kTransitionTime = 0,
    kHeatSetpoint   = 1,
    kCoolSetpoint   = 2,
};

struct Type
{
public:
    uint16_t transitionTime = static_cast<uint16_t>(0);
    DataModel::Nullable<int16_t> heatSetpoint;
    DataModel::Nullable<int16_t> coolSetpoint;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace ThermostatScheduleTransition
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace SetpointRaiseLower {
struct Type;
struct DecodableType;
} // namespace SetpointRaiseLower

namespace GetWeeklyScheduleResponse {
struct Type;
struct DecodableType;
} // namespace GetWeeklyScheduleResponse

namespace SetWeeklySchedule {
struct Type;
struct DecodableType;
} // namespace SetWeeklySchedule

namespace GetWeeklySchedule {
struct Type;
struct DecodableType;
} // namespace GetWeeklySchedule

namespace ClearWeeklySchedule {
struct Type;
struct DecodableType;
} // namespace ClearWeeklySchedule

} // namespace Commands

namespace Commands {
namespace SetpointRaiseLower {
enum class Fields
{
    kMode   = 0,
    kAmount = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetpointRaiseLower::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }

    SetpointAdjustMode mode = static_cast<SetpointAdjustMode>(0);
    int8_t amount           = static_cast<int8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetpointRaiseLower::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }

    SetpointAdjustMode mode = static_cast<SetpointAdjustMode>(0);
    int8_t amount           = static_cast<int8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetpointRaiseLower
namespace GetWeeklyScheduleResponse {
enum class Fields
{
    kNumberOfTransitionsForSequence = 0,
    kDayOfWeekForSequence           = 1,
    kModeForSequence                = 2,
    kTransitions                    = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetWeeklyScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }

    uint8_t numberOfTransitionsForSequence         = static_cast<uint8_t>(0);
    chip::BitMask<DayOfWeek> dayOfWeekForSequence  = static_cast<chip::BitMask<DayOfWeek>>(0);
    chip::BitMask<ModeForSequence> modeForSequence = static_cast<chip::BitMask<ModeForSequence>>(0);
    DataModel::List<const Structs::ThermostatScheduleTransition::Type> transitions;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetWeeklyScheduleResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }

    uint8_t numberOfTransitionsForSequence         = static_cast<uint8_t>(0);
    chip::BitMask<DayOfWeek> dayOfWeekForSequence  = static_cast<chip::BitMask<DayOfWeek>>(0);
    chip::BitMask<ModeForSequence> modeForSequence = static_cast<chip::BitMask<ModeForSequence>>(0);
    DataModel::DecodableList<Structs::ThermostatScheduleTransition::DecodableType> transitions;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetWeeklyScheduleResponse
namespace SetWeeklySchedule {
enum class Fields
{
    kNumberOfTransitionsForSequence = 0,
    kDayOfWeekForSequence           = 1,
    kModeForSequence                = 2,
    kTransitions                    = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SetWeeklySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }

    uint8_t numberOfTransitionsForSequence         = static_cast<uint8_t>(0);
    chip::BitMask<DayOfWeek> dayOfWeekForSequence  = static_cast<chip::BitMask<DayOfWeek>>(0);
    chip::BitMask<ModeForSequence> modeForSequence = static_cast<chip::BitMask<ModeForSequence>>(0);
    DataModel::List<const Structs::ThermostatScheduleTransition::Type> transitions;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SetWeeklySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }

    uint8_t numberOfTransitionsForSequence         = static_cast<uint8_t>(0);
    chip::BitMask<DayOfWeek> dayOfWeekForSequence  = static_cast<chip::BitMask<DayOfWeek>>(0);
    chip::BitMask<ModeForSequence> modeForSequence = static_cast<chip::BitMask<ModeForSequence>>(0);
    DataModel::DecodableList<Structs::ThermostatScheduleTransition::DecodableType> transitions;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SetWeeklySchedule
namespace GetWeeklySchedule {
enum class Fields
{
    kDaysToReturn = 0,
    kModeToReturn = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetWeeklySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }

    chip::BitMask<DayOfWeek> daysToReturn       = static_cast<chip::BitMask<DayOfWeek>>(0);
    chip::BitMask<ModeForSequence> modeToReturn = static_cast<chip::BitMask<ModeForSequence>>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Thermostat::Commands::GetWeeklyScheduleResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetWeeklySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }

    chip::BitMask<DayOfWeek> daysToReturn       = static_cast<chip::BitMask<DayOfWeek>>(0);
    chip::BitMask<ModeForSequence> modeToReturn = static_cast<chip::BitMask<ModeForSequence>>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetWeeklySchedule
namespace ClearWeeklySchedule {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ClearWeeklySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ClearWeeklySchedule::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ClearWeeklySchedule
} // namespace Commands

namespace Attributes {

namespace LocalTemperature {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LocalTemperature::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LocalTemperature
namespace OutdoorTemperature {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OutdoorTemperature::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OutdoorTemperature
namespace Occupancy {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Occupancy::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Occupancy
namespace AbsMinHeatSetpointLimit {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AbsMinHeatSetpointLimit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AbsMinHeatSetpointLimit
namespace AbsMaxHeatSetpointLimit {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AbsMaxHeatSetpointLimit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AbsMaxHeatSetpointLimit
namespace AbsMinCoolSetpointLimit {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AbsMinCoolSetpointLimit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AbsMinCoolSetpointLimit
namespace AbsMaxCoolSetpointLimit {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AbsMaxCoolSetpointLimit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AbsMaxCoolSetpointLimit
namespace PICoolingDemand {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PICoolingDemand::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PICoolingDemand
namespace PIHeatingDemand {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PIHeatingDemand::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PIHeatingDemand
namespace HVACSystemTypeConfiguration {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HVACSystemTypeConfiguration::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HVACSystemTypeConfiguration
namespace LocalTemperatureCalibration {
struct TypeInfo
{
    using Type             = int8_t;
    using DecodableType    = int8_t;
    using DecodableArgType = int8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LocalTemperatureCalibration::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LocalTemperatureCalibration
namespace OccupiedCoolingSetpoint {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OccupiedCoolingSetpoint::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OccupiedCoolingSetpoint
namespace OccupiedHeatingSetpoint {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OccupiedHeatingSetpoint::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OccupiedHeatingSetpoint
namespace UnoccupiedCoolingSetpoint {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UnoccupiedCoolingSetpoint::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UnoccupiedCoolingSetpoint
namespace UnoccupiedHeatingSetpoint {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UnoccupiedHeatingSetpoint::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UnoccupiedHeatingSetpoint
namespace MinHeatSetpointLimit {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinHeatSetpointLimit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinHeatSetpointLimit
namespace MaxHeatSetpointLimit {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxHeatSetpointLimit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxHeatSetpointLimit
namespace MinCoolSetpointLimit {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinCoolSetpointLimit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinCoolSetpointLimit
namespace MaxCoolSetpointLimit {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxCoolSetpointLimit::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxCoolSetpointLimit
namespace MinSetpointDeadBand {
struct TypeInfo
{
    using Type             = int8_t;
    using DecodableType    = int8_t;
    using DecodableArgType = int8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinSetpointDeadBand::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinSetpointDeadBand
namespace RemoteSensing {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RemoteSensing::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RemoteSensing
namespace ControlSequenceOfOperation {
struct TypeInfo
{
    using Type             = chip::app::Clusters::Thermostat::ThermostatControlSequence;
    using DecodableType    = chip::app::Clusters::Thermostat::ThermostatControlSequence;
    using DecodableArgType = chip::app::Clusters::Thermostat::ThermostatControlSequence;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ControlSequenceOfOperation::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ControlSequenceOfOperation
namespace SystemMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SystemMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SystemMode
namespace ThermostatRunningMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ThermostatRunningMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ThermostatRunningMode
namespace StartOfWeek {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartOfWeek::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartOfWeek
namespace NumberOfWeeklyTransitions {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfWeeklyTransitions::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfWeeklyTransitions
namespace NumberOfDailyTransitions {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfDailyTransitions::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfDailyTransitions
namespace TemperatureSetpointHold {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TemperatureSetpointHold::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TemperatureSetpointHold
namespace TemperatureSetpointHoldDuration {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TemperatureSetpointHoldDuration::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TemperatureSetpointHoldDuration
namespace ThermostatProgrammingOperationMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ThermostatProgrammingOperationMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ThermostatProgrammingOperationMode
namespace ThermostatRunningState {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ThermostatRunningState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ThermostatRunningState
namespace SetpointChangeSource {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SetpointChangeSource::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SetpointChangeSource
namespace SetpointChangeAmount {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SetpointChangeAmount::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SetpointChangeAmount
namespace SetpointChangeSourceTimestamp {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SetpointChangeSourceTimestamp::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SetpointChangeSourceTimestamp
namespace OccupiedSetback {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OccupiedSetback::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OccupiedSetback
namespace OccupiedSetbackMin {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OccupiedSetbackMin::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OccupiedSetbackMin
namespace OccupiedSetbackMax {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OccupiedSetbackMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OccupiedSetbackMax
namespace UnoccupiedSetback {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UnoccupiedSetback::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UnoccupiedSetback
namespace UnoccupiedSetbackMin {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UnoccupiedSetbackMin::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UnoccupiedSetbackMin
namespace UnoccupiedSetbackMax {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UnoccupiedSetbackMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UnoccupiedSetbackMax
namespace EmergencyHeatDelta {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EmergencyHeatDelta::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EmergencyHeatDelta
namespace ACType {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ACType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ACType
namespace ACCapacity {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ACCapacity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ACCapacity
namespace ACRefrigerantType {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ACRefrigerantType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ACRefrigerantType
namespace ACCompressorType {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ACCompressorType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ACCompressorType
namespace ACErrorCode {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ACErrorCode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ACErrorCode
namespace ACLouverPosition {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ACLouverPosition::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ACLouverPosition
namespace ACCoilTemperature {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ACCoilTemperature::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ACCoilTemperature
namespace ACCapacityformat {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ACCapacityformat::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ACCapacityformat
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Thermostat::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::LocalTemperature::TypeInfo::DecodableType localTemperature;
        Attributes::OutdoorTemperature::TypeInfo::DecodableType outdoorTemperature;
        Attributes::Occupancy::TypeInfo::DecodableType occupancy                                     = static_cast<uint8_t>(0);
        Attributes::AbsMinHeatSetpointLimit::TypeInfo::DecodableType absMinHeatSetpointLimit         = static_cast<int16_t>(0);
        Attributes::AbsMaxHeatSetpointLimit::TypeInfo::DecodableType absMaxHeatSetpointLimit         = static_cast<int16_t>(0);
        Attributes::AbsMinCoolSetpointLimit::TypeInfo::DecodableType absMinCoolSetpointLimit         = static_cast<int16_t>(0);
        Attributes::AbsMaxCoolSetpointLimit::TypeInfo::DecodableType absMaxCoolSetpointLimit         = static_cast<int16_t>(0);
        Attributes::PICoolingDemand::TypeInfo::DecodableType PICoolingDemand                         = static_cast<uint8_t>(0);
        Attributes::PIHeatingDemand::TypeInfo::DecodableType PIHeatingDemand                         = static_cast<uint8_t>(0);
        Attributes::HVACSystemTypeConfiguration::TypeInfo::DecodableType HVACSystemTypeConfiguration = static_cast<uint8_t>(0);
        Attributes::LocalTemperatureCalibration::TypeInfo::DecodableType localTemperatureCalibration = static_cast<int8_t>(0);
        Attributes::OccupiedCoolingSetpoint::TypeInfo::DecodableType occupiedCoolingSetpoint         = static_cast<int16_t>(0);
        Attributes::OccupiedHeatingSetpoint::TypeInfo::DecodableType occupiedHeatingSetpoint         = static_cast<int16_t>(0);
        Attributes::UnoccupiedCoolingSetpoint::TypeInfo::DecodableType unoccupiedCoolingSetpoint     = static_cast<int16_t>(0);
        Attributes::UnoccupiedHeatingSetpoint::TypeInfo::DecodableType unoccupiedHeatingSetpoint     = static_cast<int16_t>(0);
        Attributes::MinHeatSetpointLimit::TypeInfo::DecodableType minHeatSetpointLimit               = static_cast<int16_t>(0);
        Attributes::MaxHeatSetpointLimit::TypeInfo::DecodableType maxHeatSetpointLimit               = static_cast<int16_t>(0);
        Attributes::MinCoolSetpointLimit::TypeInfo::DecodableType minCoolSetpointLimit               = static_cast<int16_t>(0);
        Attributes::MaxCoolSetpointLimit::TypeInfo::DecodableType maxCoolSetpointLimit               = static_cast<int16_t>(0);
        Attributes::MinSetpointDeadBand::TypeInfo::DecodableType minSetpointDeadBand                 = static_cast<int8_t>(0);
        Attributes::RemoteSensing::TypeInfo::DecodableType remoteSensing                             = static_cast<uint8_t>(0);
        Attributes::ControlSequenceOfOperation::TypeInfo::DecodableType controlSequenceOfOperation =
            static_cast<chip::app::Clusters::Thermostat::ThermostatControlSequence>(0);
        Attributes::SystemMode::TypeInfo::DecodableType systemMode                               = static_cast<uint8_t>(0);
        Attributes::ThermostatRunningMode::TypeInfo::DecodableType thermostatRunningMode         = static_cast<uint8_t>(0);
        Attributes::StartOfWeek::TypeInfo::DecodableType startOfWeek                             = static_cast<uint8_t>(0);
        Attributes::NumberOfWeeklyTransitions::TypeInfo::DecodableType numberOfWeeklyTransitions = static_cast<uint8_t>(0);
        Attributes::NumberOfDailyTransitions::TypeInfo::DecodableType numberOfDailyTransitions   = static_cast<uint8_t>(0);
        Attributes::TemperatureSetpointHold::TypeInfo::DecodableType temperatureSetpointHold     = static_cast<uint8_t>(0);
        Attributes::TemperatureSetpointHoldDuration::TypeInfo::DecodableType temperatureSetpointHoldDuration;
        Attributes::ThermostatProgrammingOperationMode::TypeInfo::DecodableType thermostatProgrammingOperationMode =
            static_cast<uint8_t>(0);
        Attributes::ThermostatRunningState::TypeInfo::DecodableType thermostatRunningState = static_cast<uint16_t>(0);
        Attributes::SetpointChangeSource::TypeInfo::DecodableType setpointChangeSource     = static_cast<uint8_t>(0);
        Attributes::SetpointChangeAmount::TypeInfo::DecodableType setpointChangeAmount;
        Attributes::SetpointChangeSourceTimestamp::TypeInfo::DecodableType setpointChangeSourceTimestamp = static_cast<uint32_t>(0);
        Attributes::OccupiedSetback::TypeInfo::DecodableType occupiedSetback;
        Attributes::OccupiedSetbackMin::TypeInfo::DecodableType occupiedSetbackMin;
        Attributes::OccupiedSetbackMax::TypeInfo::DecodableType occupiedSetbackMax;
        Attributes::UnoccupiedSetback::TypeInfo::DecodableType unoccupiedSetback;
        Attributes::UnoccupiedSetbackMin::TypeInfo::DecodableType unoccupiedSetbackMin;
        Attributes::UnoccupiedSetbackMax::TypeInfo::DecodableType unoccupiedSetbackMax;
        Attributes::EmergencyHeatDelta::TypeInfo::DecodableType emergencyHeatDelta = static_cast<uint8_t>(0);
        Attributes::ACType::TypeInfo::DecodableType ACType                         = static_cast<uint8_t>(0);
        Attributes::ACCapacity::TypeInfo::DecodableType ACCapacity                 = static_cast<uint16_t>(0);
        Attributes::ACRefrigerantType::TypeInfo::DecodableType ACRefrigerantType   = static_cast<uint8_t>(0);
        Attributes::ACCompressorType::TypeInfo::DecodableType ACCompressorType     = static_cast<uint8_t>(0);
        Attributes::ACErrorCode::TypeInfo::DecodableType ACErrorCode               = static_cast<uint32_t>(0);
        Attributes::ACLouverPosition::TypeInfo::DecodableType ACLouverPosition     = static_cast<uint8_t>(0);
        Attributes::ACCoilTemperature::TypeInfo::DecodableType ACCoilTemperature;
        Attributes::ACCapacityformat::TypeInfo::DecodableType ACCapacityformat = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Thermostat
namespace FanControl {

namespace Attributes {

namespace FanMode {
struct TypeInfo
{
    using Type             = chip::app::Clusters::FanControl::FanModeType;
    using DecodableType    = chip::app::Clusters::FanControl::FanModeType;
    using DecodableArgType = chip::app::Clusters::FanControl::FanModeType;

    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::FanMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace FanMode
namespace FanModeSequence {
struct TypeInfo
{
    using Type             = chip::app::Clusters::FanControl::FanModeSequenceType;
    using DecodableType    = chip::app::Clusters::FanControl::FanModeSequenceType;
    using DecodableArgType = chip::app::Clusters::FanControl::FanModeSequenceType;

    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::FanModeSequence::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace FanModeSequence
namespace PercentSetting {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PercentSetting::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PercentSetting
namespace PercentCurrent {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PercentCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PercentCurrent
namespace SpeedMax {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SpeedMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SpeedMax
namespace SpeedSetting {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SpeedSetting::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SpeedSetting
namespace SpeedCurrent {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SpeedCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SpeedCurrent
namespace RockSupport {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RockSupport::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RockSupport
namespace RockSetting {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RockSetting::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RockSetting
namespace WindSupport {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WindSupport::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WindSupport
namespace WindSetting {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WindSetting::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WindSetting
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::FanControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::FanMode::TypeInfo::DecodableType fanMode = static_cast<chip::app::Clusters::FanControl::FanModeType>(0);
        Attributes::FanModeSequence::TypeInfo::DecodableType fanModeSequence =
            static_cast<chip::app::Clusters::FanControl::FanModeSequenceType>(0);
        Attributes::PercentSetting::TypeInfo::DecodableType percentSetting;
        Attributes::PercentCurrent::TypeInfo::DecodableType percentCurrent = static_cast<uint8_t>(0);
        Attributes::SpeedMax::TypeInfo::DecodableType speedMax             = static_cast<uint8_t>(0);
        Attributes::SpeedSetting::TypeInfo::DecodableType speedSetting;
        Attributes::SpeedCurrent::TypeInfo::DecodableType speedCurrent = static_cast<uint8_t>(0);
        Attributes::RockSupport::TypeInfo::DecodableType rockSupport   = static_cast<uint8_t>(0);
        Attributes::RockSetting::TypeInfo::DecodableType rockSetting   = static_cast<uint8_t>(0);
        Attributes::WindSupport::TypeInfo::DecodableType windSupport   = static_cast<uint8_t>(0);
        Attributes::WindSetting::TypeInfo::DecodableType windSetting   = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace FanControl
namespace ThermostatUserInterfaceConfiguration {

namespace Attributes {

namespace TemperatureDisplayMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThermostatUserInterfaceConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TemperatureDisplayMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TemperatureDisplayMode
namespace KeypadLockout {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThermostatUserInterfaceConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::KeypadLockout::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace KeypadLockout
namespace ScheduleProgrammingVisibility {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ThermostatUserInterfaceConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ScheduleProgrammingVisibility::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ScheduleProgrammingVisibility
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThermostatUserInterfaceConfiguration::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThermostatUserInterfaceConfiguration::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThermostatUserInterfaceConfiguration::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThermostatUserInterfaceConfiguration::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ThermostatUserInterfaceConfiguration::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ThermostatUserInterfaceConfiguration::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::TemperatureDisplayMode::TypeInfo::DecodableType temperatureDisplayMode               = static_cast<uint8_t>(0);
        Attributes::KeypadLockout::TypeInfo::DecodableType keypadLockout                                 = static_cast<uint8_t>(0);
        Attributes::ScheduleProgrammingVisibility::TypeInfo::DecodableType scheduleProgrammingVisibility = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ThermostatUserInterfaceConfiguration
namespace ColorControl {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace MoveToHue {
struct Type;
struct DecodableType;
} // namespace MoveToHue

namespace MoveHue {
struct Type;
struct DecodableType;
} // namespace MoveHue

namespace StepHue {
struct Type;
struct DecodableType;
} // namespace StepHue

namespace MoveToSaturation {
struct Type;
struct DecodableType;
} // namespace MoveToSaturation

namespace MoveSaturation {
struct Type;
struct DecodableType;
} // namespace MoveSaturation

namespace StepSaturation {
struct Type;
struct DecodableType;
} // namespace StepSaturation

namespace MoveToHueAndSaturation {
struct Type;
struct DecodableType;
} // namespace MoveToHueAndSaturation

namespace MoveToColor {
struct Type;
struct DecodableType;
} // namespace MoveToColor

namespace MoveColor {
struct Type;
struct DecodableType;
} // namespace MoveColor

namespace StepColor {
struct Type;
struct DecodableType;
} // namespace StepColor

namespace MoveToColorTemperature {
struct Type;
struct DecodableType;
} // namespace MoveToColorTemperature

namespace EnhancedMoveToHue {
struct Type;
struct DecodableType;
} // namespace EnhancedMoveToHue

namespace EnhancedMoveHue {
struct Type;
struct DecodableType;
} // namespace EnhancedMoveHue

namespace EnhancedStepHue {
struct Type;
struct DecodableType;
} // namespace EnhancedStepHue

namespace EnhancedMoveToHueAndSaturation {
struct Type;
struct DecodableType;
} // namespace EnhancedMoveToHueAndSaturation

namespace ColorLoopSet {
struct Type;
struct DecodableType;
} // namespace ColorLoopSet

namespace StopMoveStep {
struct Type;
struct DecodableType;
} // namespace StopMoveStep

namespace MoveColorTemperature {
struct Type;
struct DecodableType;
} // namespace MoveColorTemperature

namespace StepColorTemperature {
struct Type;
struct DecodableType;
} // namespace StepColorTemperature

} // namespace Commands

namespace Commands {
namespace MoveToHue {
enum class Fields
{
    kHue             = 0,
    kDirection       = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveToHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint8_t hue             = static_cast<uint8_t>(0);
    HueDirection direction  = static_cast<HueDirection>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveToHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint8_t hue             = static_cast<uint8_t>(0);
    HueDirection direction  = static_cast<HueDirection>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveToHue
namespace MoveHue {
enum class Fields
{
    kMoveMode        = 0,
    kRate            = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueMoveMode moveMode    = static_cast<HueMoveMode>(0);
    uint8_t rate            = static_cast<uint8_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueMoveMode moveMode    = static_cast<HueMoveMode>(0);
    uint8_t rate            = static_cast<uint8_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveHue
namespace StepHue {
enum class Fields
{
    kStepMode        = 0,
    kStepSize        = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StepHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueStepMode stepMode    = static_cast<HueStepMode>(0);
    uint8_t stepSize        = static_cast<uint8_t>(0);
    uint8_t transitionTime  = static_cast<uint8_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StepHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueStepMode stepMode    = static_cast<HueStepMode>(0);
    uint8_t stepSize        = static_cast<uint8_t>(0);
    uint8_t transitionTime  = static_cast<uint8_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StepHue
namespace MoveToSaturation {
enum class Fields
{
    kSaturation      = 0,
    kTransitionTime  = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveToSaturation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint8_t saturation      = static_cast<uint8_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveToSaturation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint8_t saturation      = static_cast<uint8_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveToSaturation
namespace MoveSaturation {
enum class Fields
{
    kMoveMode        = 0,
    kRate            = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveSaturation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    SaturationMoveMode moveMode = static_cast<SaturationMoveMode>(0);
    uint8_t rate                = static_cast<uint8_t>(0);
    uint8_t optionsMask         = static_cast<uint8_t>(0);
    uint8_t optionsOverride     = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveSaturation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    SaturationMoveMode moveMode = static_cast<SaturationMoveMode>(0);
    uint8_t rate                = static_cast<uint8_t>(0);
    uint8_t optionsMask         = static_cast<uint8_t>(0);
    uint8_t optionsOverride     = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveSaturation
namespace StepSaturation {
enum class Fields
{
    kStepMode        = 0,
    kStepSize        = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StepSaturation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    SaturationStepMode stepMode = static_cast<SaturationStepMode>(0);
    uint8_t stepSize            = static_cast<uint8_t>(0);
    uint8_t transitionTime      = static_cast<uint8_t>(0);
    uint8_t optionsMask         = static_cast<uint8_t>(0);
    uint8_t optionsOverride     = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StepSaturation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    SaturationStepMode stepMode = static_cast<SaturationStepMode>(0);
    uint8_t stepSize            = static_cast<uint8_t>(0);
    uint8_t transitionTime      = static_cast<uint8_t>(0);
    uint8_t optionsMask         = static_cast<uint8_t>(0);
    uint8_t optionsOverride     = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StepSaturation
namespace MoveToHueAndSaturation {
enum class Fields
{
    kHue             = 0,
    kSaturation      = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveToHueAndSaturation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint8_t hue             = static_cast<uint8_t>(0);
    uint8_t saturation      = static_cast<uint8_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveToHueAndSaturation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint8_t hue             = static_cast<uint8_t>(0);
    uint8_t saturation      = static_cast<uint8_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveToHueAndSaturation
namespace MoveToColor {
enum class Fields
{
    kColorX          = 0,
    kColorY          = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveToColor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint16_t colorX         = static_cast<uint16_t>(0);
    uint16_t colorY         = static_cast<uint16_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveToColor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint16_t colorX         = static_cast<uint16_t>(0);
    uint16_t colorY         = static_cast<uint16_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveToColor
namespace MoveColor {
enum class Fields
{
    kRateX           = 0,
    kRateY           = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveColor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    int16_t rateX           = static_cast<int16_t>(0);
    int16_t rateY           = static_cast<int16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveColor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    int16_t rateX           = static_cast<int16_t>(0);
    int16_t rateY           = static_cast<int16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveColor
namespace StepColor {
enum class Fields
{
    kStepX           = 0,
    kStepY           = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StepColor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    int16_t stepX           = static_cast<int16_t>(0);
    int16_t stepY           = static_cast<int16_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StepColor::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    int16_t stepX           = static_cast<int16_t>(0);
    int16_t stepY           = static_cast<int16_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StepColor
namespace MoveToColorTemperature {
enum class Fields
{
    kColorTemperature = 0,
    kTransitionTime   = 1,
    kOptionsMask      = 2,
    kOptionsOverride  = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveToColorTemperature::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint16_t colorTemperature = static_cast<uint16_t>(0);
    uint16_t transitionTime   = static_cast<uint16_t>(0);
    uint8_t optionsMask       = static_cast<uint8_t>(0);
    uint8_t optionsOverride   = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveToColorTemperature::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint16_t colorTemperature = static_cast<uint16_t>(0);
    uint16_t transitionTime   = static_cast<uint16_t>(0);
    uint8_t optionsMask       = static_cast<uint8_t>(0);
    uint8_t optionsOverride   = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveToColorTemperature
namespace EnhancedMoveToHue {
enum class Fields
{
    kEnhancedHue     = 0,
    kDirection       = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnhancedMoveToHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint16_t enhancedHue    = static_cast<uint16_t>(0);
    HueDirection direction  = static_cast<HueDirection>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnhancedMoveToHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint16_t enhancedHue    = static_cast<uint16_t>(0);
    HueDirection direction  = static_cast<HueDirection>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnhancedMoveToHue
namespace EnhancedMoveHue {
enum class Fields
{
    kMoveMode        = 0,
    kRate            = 1,
    kOptionsMask     = 2,
    kOptionsOverride = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnhancedMoveHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueMoveMode moveMode    = static_cast<HueMoveMode>(0);
    uint16_t rate           = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnhancedMoveHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueMoveMode moveMode    = static_cast<HueMoveMode>(0);
    uint16_t rate           = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnhancedMoveHue
namespace EnhancedStepHue {
enum class Fields
{
    kStepMode        = 0,
    kStepSize        = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnhancedStepHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueStepMode stepMode    = static_cast<HueStepMode>(0);
    uint16_t stepSize       = static_cast<uint16_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnhancedStepHue::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueStepMode stepMode    = static_cast<HueStepMode>(0);
    uint16_t stepSize       = static_cast<uint16_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnhancedStepHue
namespace EnhancedMoveToHueAndSaturation {
enum class Fields
{
    kEnhancedHue     = 0,
    kSaturation      = 1,
    kTransitionTime  = 2,
    kOptionsMask     = 3,
    kOptionsOverride = 4,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::EnhancedMoveToHueAndSaturation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint16_t enhancedHue    = static_cast<uint16_t>(0);
    uint8_t saturation      = static_cast<uint8_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::EnhancedMoveToHueAndSaturation::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint16_t enhancedHue    = static_cast<uint16_t>(0);
    uint8_t saturation      = static_cast<uint8_t>(0);
    uint16_t transitionTime = static_cast<uint16_t>(0);
    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace EnhancedMoveToHueAndSaturation
namespace ColorLoopSet {
enum class Fields
{
    kUpdateFlags     = 0,
    kAction          = 1,
    kDirection       = 2,
    kTime            = 3,
    kStartHue        = 4,
    kOptionsMask     = 5,
    kOptionsOverride = 6,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ColorLoopSet::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    chip::BitMask<ColorLoopUpdateFlags> updateFlags = static_cast<chip::BitMask<ColorLoopUpdateFlags>>(0);
    ColorLoopAction action                          = static_cast<ColorLoopAction>(0);
    ColorLoopDirection direction                    = static_cast<ColorLoopDirection>(0);
    uint16_t time                                   = static_cast<uint16_t>(0);
    uint16_t startHue                               = static_cast<uint16_t>(0);
    uint8_t optionsMask                             = static_cast<uint8_t>(0);
    uint8_t optionsOverride                         = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ColorLoopSet::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    chip::BitMask<ColorLoopUpdateFlags> updateFlags = static_cast<chip::BitMask<ColorLoopUpdateFlags>>(0);
    ColorLoopAction action                          = static_cast<ColorLoopAction>(0);
    ColorLoopDirection direction                    = static_cast<ColorLoopDirection>(0);
    uint16_t time                                   = static_cast<uint16_t>(0);
    uint16_t startHue                               = static_cast<uint16_t>(0);
    uint8_t optionsMask                             = static_cast<uint8_t>(0);
    uint8_t optionsOverride                         = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ColorLoopSet
namespace StopMoveStep {
enum class Fields
{
    kOptionsMask     = 0,
    kOptionsOverride = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StopMoveStep::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StopMoveStep::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    uint8_t optionsMask     = static_cast<uint8_t>(0);
    uint8_t optionsOverride = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StopMoveStep
namespace MoveColorTemperature {
enum class Fields
{
    kMoveMode                      = 0,
    kRate                          = 1,
    kColorTemperatureMinimumMireds = 2,
    kColorTemperatureMaximumMireds = 3,
    kOptionsMask                   = 4,
    kOptionsOverride               = 5,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::MoveColorTemperature::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueMoveMode moveMode                   = static_cast<HueMoveMode>(0);
    uint16_t rate                          = static_cast<uint16_t>(0);
    uint16_t colorTemperatureMinimumMireds = static_cast<uint16_t>(0);
    uint16_t colorTemperatureMaximumMireds = static_cast<uint16_t>(0);
    uint8_t optionsMask                    = static_cast<uint8_t>(0);
    uint8_t optionsOverride                = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::MoveColorTemperature::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueMoveMode moveMode                   = static_cast<HueMoveMode>(0);
    uint16_t rate                          = static_cast<uint16_t>(0);
    uint16_t colorTemperatureMinimumMireds = static_cast<uint16_t>(0);
    uint16_t colorTemperatureMaximumMireds = static_cast<uint16_t>(0);
    uint8_t optionsMask                    = static_cast<uint8_t>(0);
    uint8_t optionsOverride                = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace MoveColorTemperature
namespace StepColorTemperature {
enum class Fields
{
    kStepMode                      = 0,
    kStepSize                      = 1,
    kTransitionTime                = 2,
    kColorTemperatureMinimumMireds = 3,
    kColorTemperatureMaximumMireds = 4,
    kOptionsMask                   = 5,
    kOptionsOverride               = 6,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StepColorTemperature::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueStepMode stepMode                   = static_cast<HueStepMode>(0);
    uint16_t stepSize                      = static_cast<uint16_t>(0);
    uint16_t transitionTime                = static_cast<uint16_t>(0);
    uint16_t colorTemperatureMinimumMireds = static_cast<uint16_t>(0);
    uint16_t colorTemperatureMaximumMireds = static_cast<uint16_t>(0);
    uint8_t optionsMask                    = static_cast<uint8_t>(0);
    uint8_t optionsOverride                = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StepColorTemperature::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

    HueStepMode stepMode                   = static_cast<HueStepMode>(0);
    uint16_t stepSize                      = static_cast<uint16_t>(0);
    uint16_t transitionTime                = static_cast<uint16_t>(0);
    uint16_t colorTemperatureMinimumMireds = static_cast<uint16_t>(0);
    uint16_t colorTemperatureMaximumMireds = static_cast<uint16_t>(0);
    uint8_t optionsMask                    = static_cast<uint8_t>(0);
    uint8_t optionsOverride                = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StepColorTemperature
} // namespace Commands

namespace Attributes {

namespace CurrentHue {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentHue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentHue
namespace CurrentSaturation {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentSaturation::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentSaturation
namespace RemainingTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RemainingTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RemainingTime
namespace CurrentX {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentX::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentX
namespace CurrentY {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentY::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentY
namespace DriftCompensation {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DriftCompensation::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DriftCompensation
namespace CompensationText {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CompensationText::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 254; }
};
} // namespace CompensationText
namespace ColorTemperatureMireds {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorTemperatureMireds::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorTemperatureMireds
namespace ColorMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorMode
namespace Options {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Options::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Options
namespace NumberOfPrimaries {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NumberOfPrimaries::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NumberOfPrimaries
namespace Primary1X {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary1X::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary1X
namespace Primary1Y {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary1Y::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary1Y
namespace Primary1Intensity {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary1Intensity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary1Intensity
namespace Primary2X {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary2X::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary2X
namespace Primary2Y {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary2Y::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary2Y
namespace Primary2Intensity {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary2Intensity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary2Intensity
namespace Primary3X {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary3X::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary3X
namespace Primary3Y {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary3Y::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary3Y
namespace Primary3Intensity {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary3Intensity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary3Intensity
namespace Primary4X {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary4X::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary4X
namespace Primary4Y {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary4Y::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary4Y
namespace Primary4Intensity {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary4Intensity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary4Intensity
namespace Primary5X {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary5X::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary5X
namespace Primary5Y {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary5Y::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary5Y
namespace Primary5Intensity {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary5Intensity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary5Intensity
namespace Primary6X {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary6X::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary6X
namespace Primary6Y {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary6Y::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary6Y
namespace Primary6Intensity {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Primary6Intensity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Primary6Intensity
namespace WhitePointX {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WhitePointX::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WhitePointX
namespace WhitePointY {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::WhitePointY::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace WhitePointY
namespace ColorPointRX {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorPointRX::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorPointRX
namespace ColorPointRY {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorPointRY::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorPointRY
namespace ColorPointRIntensity {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorPointRIntensity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorPointRIntensity
namespace ColorPointGX {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorPointGX::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorPointGX
namespace ColorPointGY {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorPointGY::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorPointGY
namespace ColorPointGIntensity {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorPointGIntensity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorPointGIntensity
namespace ColorPointBX {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorPointBX::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorPointBX
namespace ColorPointBY {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorPointBY::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorPointBY
namespace ColorPointBIntensity {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorPointBIntensity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorPointBIntensity
namespace EnhancedCurrentHue {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnhancedCurrentHue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnhancedCurrentHue
namespace EnhancedColorMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::EnhancedColorMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace EnhancedColorMode
namespace ColorLoopActive {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorLoopActive::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorLoopActive
namespace ColorLoopDirection {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorLoopDirection::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorLoopDirection
namespace ColorLoopTime {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorLoopTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorLoopTime
namespace ColorLoopStartEnhancedHue {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorLoopStartEnhancedHue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorLoopStartEnhancedHue
namespace ColorLoopStoredEnhancedHue {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorLoopStoredEnhancedHue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorLoopStoredEnhancedHue
namespace ColorCapabilities {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorCapabilities::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorCapabilities
namespace ColorTempPhysicalMinMireds {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorTempPhysicalMinMireds::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorTempPhysicalMinMireds
namespace ColorTempPhysicalMaxMireds {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ColorTempPhysicalMaxMireds::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ColorTempPhysicalMaxMireds
namespace CoupleColorTempToLevelMinMireds {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CoupleColorTempToLevelMinMireds::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CoupleColorTempToLevelMinMireds
namespace StartUpColorTemperatureMireds {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartUpColorTemperatureMireds::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartUpColorTemperatureMireds
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ColorControl::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::CurrentHue::TypeInfo::DecodableType currentHue               = static_cast<uint8_t>(0);
        Attributes::CurrentSaturation::TypeInfo::DecodableType currentSaturation = static_cast<uint8_t>(0);
        Attributes::RemainingTime::TypeInfo::DecodableType remainingTime         = static_cast<uint16_t>(0);
        Attributes::CurrentX::TypeInfo::DecodableType currentX                   = static_cast<uint16_t>(0);
        Attributes::CurrentY::TypeInfo::DecodableType currentY                   = static_cast<uint16_t>(0);
        Attributes::DriftCompensation::TypeInfo::DecodableType driftCompensation = static_cast<uint8_t>(0);
        Attributes::CompensationText::TypeInfo::DecodableType compensationText;
        Attributes::ColorTemperatureMireds::TypeInfo::DecodableType colorTemperatureMireds = static_cast<uint16_t>(0);
        Attributes::ColorMode::TypeInfo::DecodableType colorMode                           = static_cast<uint8_t>(0);
        Attributes::Options::TypeInfo::DecodableType options                               = static_cast<uint8_t>(0);
        Attributes::NumberOfPrimaries::TypeInfo::DecodableType numberOfPrimaries;
        Attributes::Primary1X::TypeInfo::DecodableType primary1X = static_cast<uint16_t>(0);
        Attributes::Primary1Y::TypeInfo::DecodableType primary1Y = static_cast<uint16_t>(0);
        Attributes::Primary1Intensity::TypeInfo::DecodableType primary1Intensity;
        Attributes::Primary2X::TypeInfo::DecodableType primary2X = static_cast<uint16_t>(0);
        Attributes::Primary2Y::TypeInfo::DecodableType primary2Y = static_cast<uint16_t>(0);
        Attributes::Primary2Intensity::TypeInfo::DecodableType primary2Intensity;
        Attributes::Primary3X::TypeInfo::DecodableType primary3X = static_cast<uint16_t>(0);
        Attributes::Primary3Y::TypeInfo::DecodableType primary3Y = static_cast<uint16_t>(0);
        Attributes::Primary3Intensity::TypeInfo::DecodableType primary3Intensity;
        Attributes::Primary4X::TypeInfo::DecodableType primary4X = static_cast<uint16_t>(0);
        Attributes::Primary4Y::TypeInfo::DecodableType primary4Y = static_cast<uint16_t>(0);
        Attributes::Primary4Intensity::TypeInfo::DecodableType primary4Intensity;
        Attributes::Primary5X::TypeInfo::DecodableType primary5X = static_cast<uint16_t>(0);
        Attributes::Primary5Y::TypeInfo::DecodableType primary5Y = static_cast<uint16_t>(0);
        Attributes::Primary5Intensity::TypeInfo::DecodableType primary5Intensity;
        Attributes::Primary6X::TypeInfo::DecodableType primary6X = static_cast<uint16_t>(0);
        Attributes::Primary6Y::TypeInfo::DecodableType primary6Y = static_cast<uint16_t>(0);
        Attributes::Primary6Intensity::TypeInfo::DecodableType primary6Intensity;
        Attributes::WhitePointX::TypeInfo::DecodableType whitePointX   = static_cast<uint16_t>(0);
        Attributes::WhitePointY::TypeInfo::DecodableType whitePointY   = static_cast<uint16_t>(0);
        Attributes::ColorPointRX::TypeInfo::DecodableType colorPointRX = static_cast<uint16_t>(0);
        Attributes::ColorPointRY::TypeInfo::DecodableType colorPointRY = static_cast<uint16_t>(0);
        Attributes::ColorPointRIntensity::TypeInfo::DecodableType colorPointRIntensity;
        Attributes::ColorPointGX::TypeInfo::DecodableType colorPointGX = static_cast<uint16_t>(0);
        Attributes::ColorPointGY::TypeInfo::DecodableType colorPointGY = static_cast<uint16_t>(0);
        Attributes::ColorPointGIntensity::TypeInfo::DecodableType colorPointGIntensity;
        Attributes::ColorPointBX::TypeInfo::DecodableType colorPointBX = static_cast<uint16_t>(0);
        Attributes::ColorPointBY::TypeInfo::DecodableType colorPointBY = static_cast<uint16_t>(0);
        Attributes::ColorPointBIntensity::TypeInfo::DecodableType colorPointBIntensity;
        Attributes::EnhancedCurrentHue::TypeInfo::DecodableType enhancedCurrentHue                 = static_cast<uint16_t>(0);
        Attributes::EnhancedColorMode::TypeInfo::DecodableType enhancedColorMode                   = static_cast<uint8_t>(0);
        Attributes::ColorLoopActive::TypeInfo::DecodableType colorLoopActive                       = static_cast<uint8_t>(0);
        Attributes::ColorLoopDirection::TypeInfo::DecodableType colorLoopDirection                 = static_cast<uint8_t>(0);
        Attributes::ColorLoopTime::TypeInfo::DecodableType colorLoopTime                           = static_cast<uint16_t>(0);
        Attributes::ColorLoopStartEnhancedHue::TypeInfo::DecodableType colorLoopStartEnhancedHue   = static_cast<uint16_t>(0);
        Attributes::ColorLoopStoredEnhancedHue::TypeInfo::DecodableType colorLoopStoredEnhancedHue = static_cast<uint16_t>(0);
        Attributes::ColorCapabilities::TypeInfo::DecodableType colorCapabilities                   = static_cast<uint16_t>(0);
        Attributes::ColorTempPhysicalMinMireds::TypeInfo::DecodableType colorTempPhysicalMinMireds = static_cast<uint16_t>(0);
        Attributes::ColorTempPhysicalMaxMireds::TypeInfo::DecodableType colorTempPhysicalMaxMireds = static_cast<uint16_t>(0);
        Attributes::CoupleColorTempToLevelMinMireds::TypeInfo::DecodableType coupleColorTempToLevelMinMireds =
            static_cast<uint16_t>(0);
        Attributes::StartUpColorTemperatureMireds::TypeInfo::DecodableType startUpColorTemperatureMireds;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ColorControl
namespace BallastConfiguration {

namespace Attributes {

namespace PhysicalMinLevel {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PhysicalMinLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PhysicalMinLevel
namespace PhysicalMaxLevel {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PhysicalMaxLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PhysicalMaxLevel
namespace BallastStatus {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BallastStatus::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BallastStatus
namespace MinLevel {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinLevel
namespace MaxLevel {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxLevel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxLevel
namespace IntrinsicBalanceFactor {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::IntrinsicBalanceFactor::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace IntrinsicBalanceFactor
namespace BallastFactorAdjustment {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::BallastFactorAdjustment::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace BallastFactorAdjustment
namespace LampQuantity {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LampQuantity::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LampQuantity
namespace LampType {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LampType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace LampType
namespace LampManufacturer {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LampManufacturer::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 16; }
};
} // namespace LampManufacturer
namespace LampRatedHours {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LampRatedHours::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LampRatedHours
namespace LampBurnHours {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LampBurnHours::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LampBurnHours
namespace LampAlarmMode {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LampAlarmMode::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LampAlarmMode
namespace LampBurnHoursTripPoint {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint32_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint32_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LampBurnHoursTripPoint::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LampBurnHoursTripPoint
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::BallastConfiguration::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::PhysicalMinLevel::TypeInfo::DecodableType physicalMinLevel = static_cast<uint8_t>(0);
        Attributes::PhysicalMaxLevel::TypeInfo::DecodableType physicalMaxLevel = static_cast<uint8_t>(0);
        Attributes::BallastStatus::TypeInfo::DecodableType ballastStatus       = static_cast<uint8_t>(0);
        Attributes::MinLevel::TypeInfo::DecodableType minLevel                 = static_cast<uint8_t>(0);
        Attributes::MaxLevel::TypeInfo::DecodableType maxLevel                 = static_cast<uint8_t>(0);
        Attributes::IntrinsicBalanceFactor::TypeInfo::DecodableType intrinsicBalanceFactor;
        Attributes::BallastFactorAdjustment::TypeInfo::DecodableType ballastFactorAdjustment;
        Attributes::LampQuantity::TypeInfo::DecodableType lampQuantity = static_cast<uint8_t>(0);
        Attributes::LampType::TypeInfo::DecodableType lampType;
        Attributes::LampManufacturer::TypeInfo::DecodableType lampManufacturer;
        Attributes::LampRatedHours::TypeInfo::DecodableType lampRatedHours;
        Attributes::LampBurnHours::TypeInfo::DecodableType lampBurnHours;
        Attributes::LampAlarmMode::TypeInfo::DecodableType lampAlarmMode = static_cast<uint8_t>(0);
        Attributes::LampBurnHoursTripPoint::TypeInfo::DecodableType lampBurnHoursTripPoint;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace BallastConfiguration
namespace IlluminanceMeasurement {

namespace Attributes {

namespace MeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::IlluminanceMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasuredValue
namespace MinMeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::IlluminanceMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinMeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinMeasuredValue
namespace MaxMeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::IlluminanceMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxMeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxMeasuredValue
namespace Tolerance {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::IlluminanceMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Tolerance::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Tolerance
namespace LightSensorType {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint8_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint8_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::IlluminanceMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LightSensorType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LightSensorType
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::IlluminanceMeasurement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::IlluminanceMeasurement::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::IlluminanceMeasurement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::IlluminanceMeasurement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::IlluminanceMeasurement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::IlluminanceMeasurement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::MeasuredValue::TypeInfo::DecodableType measuredValue;
        Attributes::MinMeasuredValue::TypeInfo::DecodableType minMeasuredValue;
        Attributes::MaxMeasuredValue::TypeInfo::DecodableType maxMeasuredValue;
        Attributes::Tolerance::TypeInfo::DecodableType tolerance = static_cast<uint16_t>(0);
        Attributes::LightSensorType::TypeInfo::DecodableType lightSensorType;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace IlluminanceMeasurement
namespace TemperatureMeasurement {

namespace Attributes {

namespace MeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasuredValue
namespace MinMeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinMeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinMeasuredValue
namespace MaxMeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxMeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxMeasuredValue
namespace Tolerance {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Tolerance::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Tolerance
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureMeasurement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureMeasurement::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureMeasurement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureMeasurement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TemperatureMeasurement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::TemperatureMeasurement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::MeasuredValue::TypeInfo::DecodableType measuredValue;
        Attributes::MinMeasuredValue::TypeInfo::DecodableType minMeasuredValue;
        Attributes::MaxMeasuredValue::TypeInfo::DecodableType maxMeasuredValue;
        Attributes::Tolerance::TypeInfo::DecodableType tolerance = static_cast<uint16_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace TemperatureMeasurement
namespace PressureMeasurement {

namespace Attributes {

namespace MeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasuredValue
namespace MinMeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinMeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinMeasuredValue
namespace MaxMeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxMeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxMeasuredValue
namespace Tolerance {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Tolerance::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Tolerance
namespace ScaledValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ScaledValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ScaledValue
namespace MinScaledValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinScaledValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinScaledValue
namespace MaxScaledValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<int16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<int16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<int16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxScaledValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxScaledValue
namespace ScaledTolerance {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ScaledTolerance::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ScaledTolerance
namespace Scale {
struct TypeInfo
{
    using Type             = int8_t;
    using DecodableType    = int8_t;
    using DecodableArgType = int8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Scale::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Scale
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::PressureMeasurement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::MeasuredValue::TypeInfo::DecodableType measuredValue;
        Attributes::MinMeasuredValue::TypeInfo::DecodableType minMeasuredValue;
        Attributes::MaxMeasuredValue::TypeInfo::DecodableType maxMeasuredValue;
        Attributes::Tolerance::TypeInfo::DecodableType tolerance = static_cast<uint16_t>(0);
        Attributes::ScaledValue::TypeInfo::DecodableType scaledValue;
        Attributes::MinScaledValue::TypeInfo::DecodableType minScaledValue;
        Attributes::MaxScaledValue::TypeInfo::DecodableType maxScaledValue;
        Attributes::ScaledTolerance::TypeInfo::DecodableType scaledTolerance = static_cast<uint16_t>(0);
        Attributes::Scale::TypeInfo::DecodableType scale                     = static_cast<int8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace PressureMeasurement
namespace FlowMeasurement {

namespace Attributes {

namespace MeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::FlowMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasuredValue
namespace MinMeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::FlowMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinMeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinMeasuredValue
namespace MaxMeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::FlowMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxMeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxMeasuredValue
namespace Tolerance {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::FlowMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Tolerance::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Tolerance
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FlowMeasurement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FlowMeasurement::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FlowMeasurement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FlowMeasurement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::FlowMeasurement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::FlowMeasurement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::MeasuredValue::TypeInfo::DecodableType measuredValue;
        Attributes::MinMeasuredValue::TypeInfo::DecodableType minMeasuredValue;
        Attributes::MaxMeasuredValue::TypeInfo::DecodableType maxMeasuredValue;
        Attributes::Tolerance::TypeInfo::DecodableType tolerance = static_cast<uint16_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace FlowMeasurement
namespace RelativeHumidityMeasurement {

namespace Attributes {

namespace MeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RelativeHumidityMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasuredValue
namespace MinMeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RelativeHumidityMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MinMeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MinMeasuredValue
namespace MaxMeasuredValue {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::RelativeHumidityMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MaxMeasuredValue::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MaxMeasuredValue
namespace Tolerance {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::RelativeHumidityMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Tolerance::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Tolerance
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RelativeHumidityMeasurement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RelativeHumidityMeasurement::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RelativeHumidityMeasurement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RelativeHumidityMeasurement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::RelativeHumidityMeasurement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::RelativeHumidityMeasurement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::MeasuredValue::TypeInfo::DecodableType measuredValue;
        Attributes::MinMeasuredValue::TypeInfo::DecodableType minMeasuredValue;
        Attributes::MaxMeasuredValue::TypeInfo::DecodableType maxMeasuredValue;
        Attributes::Tolerance::TypeInfo::DecodableType tolerance = static_cast<uint16_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace RelativeHumidityMeasurement
namespace OccupancySensing {

namespace Attributes {

namespace Occupancy {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Occupancy::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Occupancy
namespace OccupancySensorType {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OccupancySensorType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OccupancySensorType
namespace OccupancySensorTypeBitmap {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OccupancySensorTypeBitmap::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OccupancySensorTypeBitmap
namespace PirOccupiedToUnoccupiedDelay {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PirOccupiedToUnoccupiedDelay::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PirOccupiedToUnoccupiedDelay
namespace PirUnoccupiedToOccupiedDelay {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PirUnoccupiedToOccupiedDelay::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PirUnoccupiedToOccupiedDelay
namespace PirUnoccupiedToOccupiedThreshold {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PirUnoccupiedToOccupiedThreshold::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PirUnoccupiedToOccupiedThreshold
namespace UltrasonicOccupiedToUnoccupiedDelay {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UltrasonicOccupiedToUnoccupiedDelay::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UltrasonicOccupiedToUnoccupiedDelay
namespace UltrasonicUnoccupiedToOccupiedDelay {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UltrasonicUnoccupiedToOccupiedDelay::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UltrasonicUnoccupiedToOccupiedDelay
namespace UltrasonicUnoccupiedToOccupiedThreshold {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::UltrasonicUnoccupiedToOccupiedThreshold::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace UltrasonicUnoccupiedToOccupiedThreshold
namespace PhysicalContactOccupiedToUnoccupiedDelay {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PhysicalContactOccupiedToUnoccupiedDelay::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PhysicalContactOccupiedToUnoccupiedDelay
namespace PhysicalContactUnoccupiedToOccupiedDelay {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PhysicalContactUnoccupiedToOccupiedDelay::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PhysicalContactUnoccupiedToOccupiedDelay
namespace PhysicalContactUnoccupiedToOccupiedThreshold {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PhysicalContactUnoccupiedToOccupiedThreshold::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PhysicalContactUnoccupiedToOccupiedThreshold
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::OccupancySensing::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::Occupancy::TypeInfo::DecodableType occupancy                                       = static_cast<uint8_t>(0);
        Attributes::OccupancySensorType::TypeInfo::DecodableType occupancySensorType                   = static_cast<uint8_t>(0);
        Attributes::OccupancySensorTypeBitmap::TypeInfo::DecodableType occupancySensorTypeBitmap       = static_cast<uint8_t>(0);
        Attributes::PirOccupiedToUnoccupiedDelay::TypeInfo::DecodableType pirOccupiedToUnoccupiedDelay = static_cast<uint16_t>(0);
        Attributes::PirUnoccupiedToOccupiedDelay::TypeInfo::DecodableType pirUnoccupiedToOccupiedDelay = static_cast<uint16_t>(0);
        Attributes::PirUnoccupiedToOccupiedThreshold::TypeInfo::DecodableType pirUnoccupiedToOccupiedThreshold =
            static_cast<uint8_t>(0);
        Attributes::UltrasonicOccupiedToUnoccupiedDelay::TypeInfo::DecodableType ultrasonicOccupiedToUnoccupiedDelay =
            static_cast<uint16_t>(0);
        Attributes::UltrasonicUnoccupiedToOccupiedDelay::TypeInfo::DecodableType ultrasonicUnoccupiedToOccupiedDelay =
            static_cast<uint16_t>(0);
        Attributes::UltrasonicUnoccupiedToOccupiedThreshold::TypeInfo::DecodableType ultrasonicUnoccupiedToOccupiedThreshold =
            static_cast<uint8_t>(0);
        Attributes::PhysicalContactOccupiedToUnoccupiedDelay::TypeInfo::DecodableType physicalContactOccupiedToUnoccupiedDelay =
            static_cast<uint16_t>(0);
        Attributes::PhysicalContactUnoccupiedToOccupiedDelay::TypeInfo::DecodableType physicalContactUnoccupiedToOccupiedDelay =
            static_cast<uint16_t>(0);
        Attributes::PhysicalContactUnoccupiedToOccupiedThreshold::TypeInfo::DecodableType
            physicalContactUnoccupiedToOccupiedThreshold = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace OccupancySensing
namespace WakeOnLan {

namespace Attributes {

namespace MACAddress {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::WakeOnLan::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MACAddress::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace MACAddress
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WakeOnLan::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WakeOnLan::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WakeOnLan::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WakeOnLan::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::WakeOnLan::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::WakeOnLan::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::MACAddress::TypeInfo::DecodableType MACAddress;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace WakeOnLan
namespace Channel {
namespace Structs {
namespace ChannelInfo {
enum class Fields
{
    kMajorNumber       = 0,
    kMinorNumber       = 1,
    kName              = 2,
    kCallSign          = 3,
    kAffiliateCallSign = 4,
};

struct Type
{
public:
    uint16_t majorNumber = static_cast<uint16_t>(0);
    uint16_t minorNumber = static_cast<uint16_t>(0);
    Optional<chip::CharSpan> name;
    Optional<chip::CharSpan> callSign;
    Optional<chip::CharSpan> affiliateCallSign;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace ChannelInfo
namespace LineupInfo {
enum class Fields
{
    kOperatorName   = 0,
    kLineupName     = 1,
    kPostalCode     = 2,
    kLineupInfoType = 3,
};

struct Type
{
public:
    chip::CharSpan operatorName;
    Optional<chip::CharSpan> lineupName;
    Optional<chip::CharSpan> postalCode;
    LineupInfoTypeEnum lineupInfoType = static_cast<LineupInfoTypeEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace LineupInfo
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace ChangeChannel {
struct Type;
struct DecodableType;
} // namespace ChangeChannel

namespace ChangeChannelResponse {
struct Type;
struct DecodableType;
} // namespace ChangeChannelResponse

namespace ChangeChannelByNumber {
struct Type;
struct DecodableType;
} // namespace ChangeChannelByNumber

namespace SkipChannel {
struct Type;
struct DecodableType;
} // namespace SkipChannel

} // namespace Commands

namespace Commands {
namespace ChangeChannel {
enum class Fields
{
    kMatch = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeChannel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }

    chip::CharSpan match;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::Channel::Commands::ChangeChannelResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeChannel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }

    chip::CharSpan match;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeChannel
namespace ChangeChannelResponse {
enum class Fields
{
    kStatus = 0,
    kData   = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeChannelResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }

    ChannelStatusEnum status = static_cast<ChannelStatusEnum>(0);
    Optional<chip::CharSpan> data;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeChannelResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }

    ChannelStatusEnum status = static_cast<ChannelStatusEnum>(0);
    Optional<chip::CharSpan> data;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeChannelResponse
namespace ChangeChannelByNumber {
enum class Fields
{
    kMajorNumber = 0,
    kMinorNumber = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ChangeChannelByNumber::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }

    uint16_t majorNumber = static_cast<uint16_t>(0);
    uint16_t minorNumber = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ChangeChannelByNumber::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }

    uint16_t majorNumber = static_cast<uint16_t>(0);
    uint16_t minorNumber = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ChangeChannelByNumber
namespace SkipChannel {
enum class Fields
{
    kCount = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SkipChannel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }

    uint16_t count = static_cast<uint16_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SkipChannel::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }

    uint16_t count = static_cast<uint16_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SkipChannel
} // namespace Commands

namespace Attributes {

namespace ChannelList {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::Channel::Structs::ChannelInfo::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::Channel::Structs::ChannelInfo::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::Channel::Structs::ChannelInfo::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ChannelList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ChannelList
namespace Lineup {
struct TypeInfo
{
    using Type          = chip::app::DataModel::Nullable<chip::app::Clusters::Channel::Structs::LineupInfo::Type>;
    using DecodableType = chip::app::DataModel::Nullable<chip::app::Clusters::Channel::Structs::LineupInfo::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::Nullable<chip::app::Clusters::Channel::Structs::LineupInfo::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Lineup::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Lineup
namespace CurrentChannel {
struct TypeInfo
{
    using Type          = chip::app::DataModel::Nullable<chip::app::Clusters::Channel::Structs::ChannelInfo::Type>;
    using DecodableType = chip::app::DataModel::Nullable<chip::app::Clusters::Channel::Structs::ChannelInfo::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::Nullable<chip::app::Clusters::Channel::Structs::ChannelInfo::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentChannel::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentChannel
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::Channel::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::ChannelList::TypeInfo::DecodableType channelList;
        Attributes::Lineup::TypeInfo::DecodableType lineup;
        Attributes::CurrentChannel::TypeInfo::DecodableType currentChannel;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace Channel
namespace TargetNavigator {
namespace Structs {
namespace TargetInfo {
enum class Fields
{
    kIdentifier = 0,
    kName       = 1,
};

struct Type
{
public:
    uint8_t identifier = static_cast<uint8_t>(0);
    chip::CharSpan name;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace TargetInfo
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace NavigateTarget {
struct Type;
struct DecodableType;
} // namespace NavigateTarget

namespace NavigateTargetResponse {
struct Type;
struct DecodableType;
} // namespace NavigateTargetResponse

} // namespace Commands

namespace Commands {
namespace NavigateTarget {
enum class Fields
{
    kTarget = 0,
    kData   = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::NavigateTarget::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }

    uint8_t target = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> data;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TargetNavigator::Commands::NavigateTargetResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::NavigateTarget::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }

    uint8_t target = static_cast<uint8_t>(0);
    Optional<chip::CharSpan> data;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace NavigateTarget
namespace NavigateTargetResponse {
enum class Fields
{
    kStatus = 0,
    kData   = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::NavigateTargetResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }

    TargetNavigatorStatusEnum status = static_cast<TargetNavigatorStatusEnum>(0);
    Optional<chip::CharSpan> data;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::NavigateTargetResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }

    TargetNavigatorStatusEnum status = static_cast<TargetNavigatorStatusEnum>(0);
    Optional<chip::CharSpan> data;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace NavigateTargetResponse
} // namespace Commands

namespace Attributes {

namespace TargetList {
struct TypeInfo
{
    using Type = chip::app::DataModel::List<const chip::app::Clusters::TargetNavigator::Structs::TargetInfo::Type>;
    using DecodableType =
        chip::app::DataModel::DecodableList<chip::app::Clusters::TargetNavigator::Structs::TargetInfo::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::TargetNavigator::Structs::TargetInfo::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TargetList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TargetList
namespace CurrentTarget {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentTarget::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentTarget
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::TargetNavigator::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::TargetList::TypeInfo::DecodableType targetList;
        Attributes::CurrentTarget::TypeInfo::DecodableType currentTarget = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace TargetNavigator
namespace MediaPlayback {
namespace Structs {
namespace PlaybackPosition {
enum class Fields
{
    kUpdatedAt = 0,
    kPosition  = 1,
};

struct Type
{
public:
    uint64_t updatedAt = static_cast<uint64_t>(0);
    DataModel::Nullable<uint64_t> position;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace PlaybackPosition
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Play {
struct Type;
struct DecodableType;
} // namespace Play

namespace Pause {
struct Type;
struct DecodableType;
} // namespace Pause

namespace StopPlayback {
struct Type;
struct DecodableType;
} // namespace StopPlayback

namespace StartOver {
struct Type;
struct DecodableType;
} // namespace StartOver

namespace Previous {
struct Type;
struct DecodableType;
} // namespace Previous

namespace Next {
struct Type;
struct DecodableType;
} // namespace Next

namespace Rewind {
struct Type;
struct DecodableType;
} // namespace Rewind

namespace FastForward {
struct Type;
struct DecodableType;
} // namespace FastForward

namespace SkipForward {
struct Type;
struct DecodableType;
} // namespace SkipForward

namespace SkipBackward {
struct Type;
struct DecodableType;
} // namespace SkipBackward

namespace PlaybackResponse {
struct Type;
struct DecodableType;
} // namespace PlaybackResponse

namespace Seek {
struct Type;
struct DecodableType;
} // namespace Seek

} // namespace Commands

namespace Commands {
namespace Play {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Play::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Play::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Play
namespace Pause {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Pause::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Pause::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Pause
namespace StopPlayback {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StopPlayback::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StopPlayback::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StopPlayback
namespace StartOver {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StartOver::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StartOver::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StartOver
namespace Previous {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Previous::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Previous::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Previous
namespace Next {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Next::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Next::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Next
namespace Rewind {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Rewind::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Rewind::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Rewind
namespace FastForward {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::FastForward::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::FastForward::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace FastForward
namespace SkipForward {
enum class Fields
{
    kDeltaPositionMilliseconds = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SkipForward::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    uint64_t deltaPositionMilliseconds = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SkipForward::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    uint64_t deltaPositionMilliseconds = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SkipForward
namespace SkipBackward {
enum class Fields
{
    kDeltaPositionMilliseconds = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SkipBackward::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    uint64_t deltaPositionMilliseconds = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SkipBackward::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    uint64_t deltaPositionMilliseconds = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SkipBackward
namespace PlaybackResponse {
enum class Fields
{
    kStatus = 0,
    kData   = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::PlaybackResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    MediaPlaybackStatusEnum status = static_cast<MediaPlaybackStatusEnum>(0);
    Optional<chip::CharSpan> data;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::PlaybackResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    MediaPlaybackStatusEnum status = static_cast<MediaPlaybackStatusEnum>(0);
    Optional<chip::CharSpan> data;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace PlaybackResponse
namespace Seek {
enum class Fields
{
    kPosition = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Seek::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    uint64_t position = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::MediaPlayback::Commands::PlaybackResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Seek::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

    uint64_t position = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Seek
} // namespace Commands

namespace Attributes {

namespace CurrentState {
struct TypeInfo
{
    using Type             = chip::app::Clusters::MediaPlayback::PlaybackStateEnum;
    using DecodableType    = chip::app::Clusters::MediaPlayback::PlaybackStateEnum;
    using DecodableArgType = chip::app::Clusters::MediaPlayback::PlaybackStateEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentState::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentState
namespace StartTime {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::StartTime::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace StartTime
namespace Duration {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Duration::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Duration
namespace SampledPosition {
struct TypeInfo
{
    using Type = chip::app::DataModel::Nullable<chip::app::Clusters::MediaPlayback::Structs::PlaybackPosition::Type>;
    using DecodableType =
        chip::app::DataModel::Nullable<chip::app::Clusters::MediaPlayback::Structs::PlaybackPosition::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::Nullable<chip::app::Clusters::MediaPlayback::Structs::PlaybackPosition::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SampledPosition::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SampledPosition
namespace PlaybackSpeed {
struct TypeInfo
{
    using Type             = float;
    using DecodableType    = float;
    using DecodableArgType = float;

    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PlaybackSpeed::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PlaybackSpeed
namespace SeekRangeEnd {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SeekRangeEnd::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SeekRangeEnd
namespace SeekRangeStart {
struct TypeInfo
{
    using Type             = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableType    = chip::app::DataModel::Nullable<uint64_t>;
    using DecodableArgType = const chip::app::DataModel::Nullable<uint64_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SeekRangeStart::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SeekRangeStart
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::MediaPlayback::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::CurrentState::TypeInfo::DecodableType currentState =
            static_cast<chip::app::Clusters::MediaPlayback::PlaybackStateEnum>(0);
        Attributes::StartTime::TypeInfo::DecodableType startTime;
        Attributes::Duration::TypeInfo::DecodableType duration;
        Attributes::SampledPosition::TypeInfo::DecodableType sampledPosition;
        Attributes::PlaybackSpeed::TypeInfo::DecodableType playbackSpeed = static_cast<float>(0);
        Attributes::SeekRangeEnd::TypeInfo::DecodableType seekRangeEnd;
        Attributes::SeekRangeStart::TypeInfo::DecodableType seekRangeStart;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace MediaPlayback
namespace MediaInput {
namespace Structs {
namespace InputInfo {
enum class Fields
{
    kIndex       = 0,
    kInputType   = 1,
    kName        = 2,
    kDescription = 3,
};

struct Type
{
public:
    uint8_t index           = static_cast<uint8_t>(0);
    InputTypeEnum inputType = static_cast<InputTypeEnum>(0);
    chip::CharSpan name;
    chip::CharSpan description;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace InputInfo
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace SelectInput {
struct Type;
struct DecodableType;
} // namespace SelectInput

namespace ShowInputStatus {
struct Type;
struct DecodableType;
} // namespace ShowInputStatus

namespace HideInputStatus {
struct Type;
struct DecodableType;
} // namespace HideInputStatus

namespace RenameInput {
struct Type;
struct DecodableType;
} // namespace RenameInput

} // namespace Commands

namespace Commands {
namespace SelectInput {
enum class Fields
{
    kIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SelectInput::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }

    uint8_t index = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SelectInput::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }

    uint8_t index = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SelectInput
namespace ShowInputStatus {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::ShowInputStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::ShowInputStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace ShowInputStatus
namespace HideInputStatus {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::HideInputStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::HideInputStatus::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace HideInputStatus
namespace RenameInput {
enum class Fields
{
    kIndex = 0,
    kName  = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RenameInput::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }

    uint8_t index = static_cast<uint8_t>(0);
    chip::CharSpan name;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RenameInput::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }

    uint8_t index = static_cast<uint8_t>(0);
    chip::CharSpan name;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RenameInput
} // namespace Commands

namespace Attributes {

namespace InputList {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::MediaInput::Structs::InputInfo::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::MediaInput::Structs::InputInfo::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::MediaInput::Structs::InputInfo::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InputList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InputList
namespace CurrentInput {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentInput::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentInput
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::MediaInput::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::InputList::TypeInfo::DecodableType inputList;
        Attributes::CurrentInput::TypeInfo::DecodableType currentInput = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace MediaInput
namespace LowPower {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Sleep {
struct Type;
struct DecodableType;
} // namespace Sleep

} // namespace Commands

namespace Commands {
namespace Sleep {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Sleep::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LowPower::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Sleep::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::LowPower::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Sleep
} // namespace Commands

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LowPower::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LowPower::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LowPower::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LowPower::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::LowPower::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::LowPower::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace LowPower
namespace KeypadInput {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace SendKey {
struct Type;
struct DecodableType;
} // namespace SendKey

namespace SendKeyResponse {
struct Type;
struct DecodableType;
} // namespace SendKeyResponse

} // namespace Commands

namespace Commands {
namespace SendKey {
enum class Fields
{
    kKeyCode = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SendKey::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::KeypadInput::Id; }

    CecKeyCode keyCode = static_cast<CecKeyCode>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::KeypadInput::Commands::SendKeyResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SendKey::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::KeypadInput::Id; }

    CecKeyCode keyCode = static_cast<CecKeyCode>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SendKey
namespace SendKeyResponse {
enum class Fields
{
    kStatus = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SendKeyResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::KeypadInput::Id; }

    KeypadInputStatusEnum status = static_cast<KeypadInputStatusEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SendKeyResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::KeypadInput::Id; }

    KeypadInputStatusEnum status = static_cast<KeypadInputStatusEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SendKeyResponse
} // namespace Commands

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::KeypadInput::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::KeypadInput::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::KeypadInput::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::KeypadInput::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::KeypadInput::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::KeypadInput::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace KeypadInput
namespace ContentLauncher {
namespace Structs {
namespace Dimension {
enum class Fields
{
    kWidth  = 0,
    kHeight = 1,
    kMetric = 2,
};

struct Type
{
public:
    double width          = static_cast<double>(0);
    double height         = static_cast<double>(0);
    MetricTypeEnum metric = static_cast<MetricTypeEnum>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace Dimension
namespace AdditionalInfo {
enum class Fields
{
    kName  = 0,
    kValue = 1,
};

struct Type
{
public:
    chip::CharSpan name;
    chip::CharSpan value;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace AdditionalInfo
namespace Parameter {
enum class Fields
{
    kType           = 0,
    kValue          = 1,
    kExternalIDList = 2,
};

struct Type
{
public:
    ParameterEnum type = static_cast<ParameterEnum>(0);
    chip::CharSpan value;
    Optional<DataModel::List<const Structs::AdditionalInfo::Type>> externalIDList;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    ParameterEnum type = static_cast<ParameterEnum>(0);
    chip::CharSpan value;
    Optional<DataModel::DecodableList<Structs::AdditionalInfo::DecodableType>> externalIDList;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace Parameter
namespace ContentSearch {
enum class Fields
{
    kParameterList = 0,
};

struct Type
{
public:
    DataModel::List<const Structs::Parameter::Type> parameterList;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    DataModel::DecodableList<Structs::Parameter::DecodableType> parameterList;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace ContentSearch
namespace StyleInformation {
enum class Fields
{
    kImageUrl = 0,
    kColor    = 1,
    kSize     = 2,
};

struct Type
{
public:
    Optional<chip::CharSpan> imageUrl;
    Optional<chip::CharSpan> color;
    Optional<Structs::Dimension::Type> size;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace StyleInformation
namespace BrandingInformation {
enum class Fields
{
    kProviderName = 0,
    kBackground   = 1,
    kLogo         = 2,
    kProgressBar  = 3,
    kSplash       = 4,
    kWaterMark    = 5,
};

struct Type
{
public:
    chip::CharSpan providerName;
    Optional<Structs::StyleInformation::Type> background;
    Optional<Structs::StyleInformation::Type> logo;
    Optional<Structs::StyleInformation::Type> progressBar;
    Optional<Structs::StyleInformation::Type> splash;
    Optional<Structs::StyleInformation::Type> waterMark;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace BrandingInformation
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace LaunchContent {
struct Type;
struct DecodableType;
} // namespace LaunchContent

namespace LaunchURL {
struct Type;
struct DecodableType;
} // namespace LaunchURL

namespace LaunchResponse {
struct Type;
struct DecodableType;
} // namespace LaunchResponse

} // namespace Commands

namespace Commands {
namespace LaunchContent {
enum class Fields
{
    kSearch   = 0,
    kAutoPlay = 1,
    kData     = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::LaunchContent::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }

    Structs::ContentSearch::Type search;
    bool autoPlay = static_cast<bool>(0);
    Optional<chip::CharSpan> data;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::ContentLauncher::Commands::LaunchResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::LaunchContent::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }

    Structs::ContentSearch::DecodableType search;
    bool autoPlay = static_cast<bool>(0);
    Optional<chip::CharSpan> data;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace LaunchContent
namespace LaunchURL {
enum class Fields
{
    kContentURL          = 0,
    kDisplayString       = 1,
    kBrandingInformation = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::LaunchURL::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }

    chip::CharSpan contentURL;
    Optional<chip::CharSpan> displayString;
    Optional<Structs::BrandingInformation::Type> brandingInformation;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::ContentLauncher::Commands::LaunchResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::LaunchURL::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }

    chip::CharSpan contentURL;
    Optional<chip::CharSpan> displayString;
    Optional<Structs::BrandingInformation::DecodableType> brandingInformation;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace LaunchURL
namespace LaunchResponse {
enum class Fields
{
    kStatus = 0,
    kData   = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::LaunchResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }

    ContentLaunchStatusEnum status = static_cast<ContentLaunchStatusEnum>(0);
    Optional<chip::CharSpan> data;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::LaunchResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }

    ContentLaunchStatusEnum status = static_cast<ContentLaunchStatusEnum>(0);
    Optional<chip::CharSpan> data;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace LaunchResponse
} // namespace Commands

namespace Attributes {

namespace AcceptHeader {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::CharSpan>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::CharSpan>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::CharSpan> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcceptHeader::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcceptHeader
namespace SupportedStreamingProtocols {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::SupportedStreamingProtocols::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace SupportedStreamingProtocols
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ContentLauncher::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::AcceptHeader::TypeInfo::DecodableType acceptHeader;
        Attributes::SupportedStreamingProtocols::TypeInfo::DecodableType supportedStreamingProtocols = static_cast<uint32_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ContentLauncher
namespace AudioOutput {
namespace Structs {
namespace OutputInfo {
enum class Fields
{
    kIndex      = 0,
    kOutputType = 1,
    kName       = 2,
};

struct Type
{
public:
    uint8_t index             = static_cast<uint8_t>(0);
    OutputTypeEnum outputType = static_cast<OutputTypeEnum>(0);
    chip::CharSpan name;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace OutputInfo
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace SelectOutput {
struct Type;
struct DecodableType;
} // namespace SelectOutput

namespace RenameOutput {
struct Type;
struct DecodableType;
} // namespace RenameOutput

} // namespace Commands

namespace Commands {
namespace SelectOutput {
enum class Fields
{
    kIndex = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SelectOutput::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }

    uint8_t index = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SelectOutput::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }

    uint8_t index = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SelectOutput
namespace RenameOutput {
enum class Fields
{
    kIndex = 0,
    kName  = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::RenameOutput::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }

    uint8_t index = static_cast<uint8_t>(0);
    chip::CharSpan name;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::RenameOutput::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }

    uint8_t index = static_cast<uint8_t>(0);
    chip::CharSpan name;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace RenameOutput
} // namespace Commands

namespace Attributes {

namespace OutputList {
struct TypeInfo
{
    using Type          = chip::app::DataModel::List<const chip::app::Clusters::AudioOutput::Structs::OutputInfo::Type>;
    using DecodableType = chip::app::DataModel::DecodableList<chip::app::Clusters::AudioOutput::Structs::OutputInfo::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::DecodableList<chip::app::Clusters::AudioOutput::Structs::OutputInfo::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OutputList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OutputList
namespace CurrentOutput {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentOutput::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentOutput
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::AudioOutput::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::OutputList::TypeInfo::DecodableType outputList;
        Attributes::CurrentOutput::TypeInfo::DecodableType currentOutput = static_cast<uint8_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace AudioOutput
namespace ApplicationLauncher {
namespace Structs {
namespace Application {
enum class Fields
{
    kCatalogVendorId = 0,
    kApplicationId   = 1,
};

struct Type
{
public:
    uint16_t catalogVendorId = static_cast<uint16_t>(0);
    chip::CharSpan applicationId;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace Application
namespace ApplicationEP {
enum class Fields
{
    kApplication = 0,
    kEndpoint    = 1,
};

struct Type
{
public:
    Structs::Application::Type application;
    Optional<chip::EndpointId> endpoint;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace ApplicationEP
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace LaunchApp {
struct Type;
struct DecodableType;
} // namespace LaunchApp

namespace StopApp {
struct Type;
struct DecodableType;
} // namespace StopApp

namespace HideApp {
struct Type;
struct DecodableType;
} // namespace HideApp

namespace LauncherResponse {
struct Type;
struct DecodableType;
} // namespace LauncherResponse

} // namespace Commands

namespace Commands {
namespace LaunchApp {
enum class Fields
{
    kApplication = 0,
    kData        = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::LaunchApp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }

    Structs::Application::Type application;
    Optional<chip::ByteSpan> data;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::ApplicationLauncher::Commands::LauncherResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::LaunchApp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }

    Structs::Application::DecodableType application;
    Optional<chip::ByteSpan> data;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace LaunchApp
namespace StopApp {
enum class Fields
{
    kApplication = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::StopApp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }

    Structs::Application::Type application;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::ApplicationLauncher::Commands::LauncherResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::StopApp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }

    Structs::Application::DecodableType application;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace StopApp
namespace HideApp {
enum class Fields
{
    kApplication = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::HideApp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }

    Structs::Application::Type application;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::ApplicationLauncher::Commands::LauncherResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::HideApp::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }

    Structs::Application::DecodableType application;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace HideApp
namespace LauncherResponse {
enum class Fields
{
    kStatus = 0,
    kData   = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::LauncherResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }

    ApplicationLauncherStatusEnum status = static_cast<ApplicationLauncherStatusEnum>(0);
    chip::ByteSpan data;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::LauncherResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }

    ApplicationLauncherStatusEnum status = static_cast<ApplicationLauncherStatusEnum>(0);
    chip::ByteSpan data;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace LauncherResponse
} // namespace Commands

namespace Attributes {

namespace CatalogList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const uint16_t>;
    using DecodableType    = chip::app::DataModel::DecodableList<uint16_t>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<uint16_t> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CatalogList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CatalogList
namespace CurrentApp {
struct TypeInfo
{
    using Type = chip::app::DataModel::Nullable<chip::app::Clusters::ApplicationLauncher::Structs::ApplicationEP::Type>;
    using DecodableType =
        chip::app::DataModel::Nullable<chip::app::Clusters::ApplicationLauncher::Structs::ApplicationEP::DecodableType>;
    using DecodableArgType =
        const chip::app::DataModel::Nullable<chip::app::Clusters::ApplicationLauncher::Structs::ApplicationEP::DecodableType> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentApp::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentApp
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ApplicationLauncher::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::CatalogList::TypeInfo::DecodableType catalogList;
        Attributes::CurrentApp::TypeInfo::DecodableType currentApp;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ApplicationLauncher
namespace ApplicationBasic {
namespace Structs {
namespace ApplicationBasicApplication {
enum class Fields
{
    kCatalogVendorId = 0,
    kApplicationId   = 1,
};

struct Type
{
public:
    uint16_t catalogVendorId = static_cast<uint16_t>(0);
    chip::CharSpan applicationId;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace ApplicationBasicApplication
} // namespace Structs

namespace Attributes {

namespace VendorName {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VendorName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace VendorName
namespace VendorID {
struct TypeInfo
{
    using Type             = chip::VendorId;
    using DecodableType    = chip::VendorId;
    using DecodableArgType = chip::VendorId;

    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VendorID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace VendorID
namespace ApplicationName {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ApplicationName::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace ApplicationName
namespace ProductID {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ProductID::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ProductID
namespace Application {
struct TypeInfo
{
    using Type             = chip::app::Clusters::ApplicationBasic::Structs::ApplicationBasicApplication::Type;
    using DecodableType    = chip::app::Clusters::ApplicationBasic::Structs::ApplicationBasicApplication::DecodableType;
    using DecodableArgType = const chip::app::Clusters::ApplicationBasic::Structs::ApplicationBasicApplication::DecodableType &;

    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Application::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Application
namespace Status {
struct TypeInfo
{
    using Type             = chip::app::Clusters::ApplicationBasic::ApplicationStatusEnum;
    using DecodableType    = chip::app::Clusters::ApplicationBasic::ApplicationStatusEnum;
    using DecodableArgType = chip::app::Clusters::ApplicationBasic::ApplicationStatusEnum;

    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Status::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Status
namespace ApplicationVersion {
struct TypeInfo
{
    using Type             = chip::CharSpan;
    using DecodableType    = chip::CharSpan;
    using DecodableArgType = chip::CharSpan;

    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ApplicationVersion::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
    static constexpr size_t MaxLength() { return 32; }
};
} // namespace ApplicationVersion
namespace AllowedVendorList {
struct TypeInfo
{
    using Type             = chip::app::DataModel::List<const chip::VendorId>;
    using DecodableType    = chip::app::DataModel::DecodableList<chip::VendorId>;
    using DecodableArgType = const chip::app::DataModel::DecodableList<chip::VendorId> &;

    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AllowedVendorList::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AllowedVendorList
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ApplicationBasic::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::VendorName::TypeInfo::DecodableType vendorName;
        Attributes::VendorID::TypeInfo::DecodableType vendorID = static_cast<chip::VendorId>(0);
        Attributes::ApplicationName::TypeInfo::DecodableType applicationName;
        Attributes::ProductID::TypeInfo::DecodableType productID = static_cast<uint16_t>(0);
        Attributes::Application::TypeInfo::DecodableType application;
        Attributes::Status::TypeInfo::DecodableType status =
            static_cast<chip::app::Clusters::ApplicationBasic::ApplicationStatusEnum>(0);
        Attributes::ApplicationVersion::TypeInfo::DecodableType applicationVersion;
        Attributes::AllowedVendorList::TypeInfo::DecodableType allowedVendorList;
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ApplicationBasic
namespace AccountLogin {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace GetSetupPIN {
struct Type;
struct DecodableType;
} // namespace GetSetupPIN

namespace GetSetupPINResponse {
struct Type;
struct DecodableType;
} // namespace GetSetupPINResponse

namespace Login {
struct Type;
struct DecodableType;
} // namespace Login

namespace Logout {
struct Type;
struct DecodableType;
} // namespace Logout

} // namespace Commands

namespace Commands {
namespace GetSetupPIN {
enum class Fields
{
    kTempAccountIdentifier = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetSetupPIN::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }

    chip::CharSpan tempAccountIdentifier;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::AccountLogin::Commands::GetSetupPINResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetSetupPIN::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }

    chip::CharSpan tempAccountIdentifier;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetSetupPIN
namespace GetSetupPINResponse {
enum class Fields
{
    kSetupPIN = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetSetupPINResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }

    chip::CharSpan setupPIN;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetSetupPINResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }

    chip::CharSpan setupPIN;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetSetupPINResponse
namespace Login {
enum class Fields
{
    kTempAccountIdentifier = 0,
    kSetupPIN              = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Login::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }

    chip::CharSpan tempAccountIdentifier;
    chip::CharSpan setupPIN;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Login::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }

    chip::CharSpan tempAccountIdentifier;
    chip::CharSpan setupPIN;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Login
namespace Logout {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Logout::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Logout::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Logout
} // namespace Commands

namespace Attributes {

namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::AccountLogin::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace AccountLogin
namespace ElectricalMeasurement {

namespace Commands {
// Forward-declarations so we can reference these later.

namespace GetProfileInfoResponseCommand {
struct Type;
struct DecodableType;
} // namespace GetProfileInfoResponseCommand

namespace GetProfileInfoCommand {
struct Type;
struct DecodableType;
} // namespace GetProfileInfoCommand

namespace GetMeasurementProfileResponseCommand {
struct Type;
struct DecodableType;
} // namespace GetMeasurementProfileResponseCommand

namespace GetMeasurementProfileCommand {
struct Type;
struct DecodableType;
} // namespace GetMeasurementProfileCommand

} // namespace Commands

namespace Commands {
namespace GetProfileInfoResponseCommand {
enum class Fields
{
    kProfileCount          = 0,
    kProfileIntervalPeriod = 1,
    kMaxNumberOfIntervals  = 2,
    kListOfAttributes      = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetProfileInfoResponseCommand::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }

    uint8_t profileCount          = static_cast<uint8_t>(0);
    uint8_t profileIntervalPeriod = static_cast<uint8_t>(0);
    uint8_t maxNumberOfIntervals  = static_cast<uint8_t>(0);
    DataModel::List<const uint16_t> listOfAttributes;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetProfileInfoResponseCommand::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }

    uint8_t profileCount          = static_cast<uint8_t>(0);
    uint8_t profileIntervalPeriod = static_cast<uint8_t>(0);
    uint8_t maxNumberOfIntervals  = static_cast<uint8_t>(0);
    DataModel::DecodableList<uint16_t> listOfAttributes;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetProfileInfoResponseCommand
namespace GetProfileInfoCommand {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetProfileInfoCommand::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetProfileInfoCommand::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetProfileInfoCommand
namespace GetMeasurementProfileResponseCommand {
enum class Fields
{
    kStartTime                  = 0,
    kStatus                     = 1,
    kProfileIntervalPeriod      = 2,
    kNumberOfIntervalsDelivered = 3,
    kAttributeId                = 4,
    kIntervals                  = 5,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetMeasurementProfileResponseCommand::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }

    uint32_t startTime                 = static_cast<uint32_t>(0);
    uint8_t status                     = static_cast<uint8_t>(0);
    uint8_t profileIntervalPeriod      = static_cast<uint8_t>(0);
    uint8_t numberOfIntervalsDelivered = static_cast<uint8_t>(0);
    uint16_t attributeId               = static_cast<uint16_t>(0);
    DataModel::List<const uint8_t> intervals;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetMeasurementProfileResponseCommand::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }

    uint32_t startTime                 = static_cast<uint32_t>(0);
    uint8_t status                     = static_cast<uint8_t>(0);
    uint8_t profileIntervalPeriod      = static_cast<uint8_t>(0);
    uint8_t numberOfIntervalsDelivered = static_cast<uint8_t>(0);
    uint16_t attributeId               = static_cast<uint16_t>(0);
    DataModel::DecodableList<uint8_t> intervals;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetMeasurementProfileResponseCommand
namespace GetMeasurementProfileCommand {
enum class Fields
{
    kAttributeId       = 0,
    kStartTime         = 1,
    kNumberOfIntervals = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::GetMeasurementProfileCommand::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }

    uint16_t attributeId      = static_cast<uint16_t>(0);
    uint32_t startTime        = static_cast<uint32_t>(0);
    uint8_t numberOfIntervals = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::GetMeasurementProfileCommand::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }

    uint16_t attributeId      = static_cast<uint16_t>(0);
    uint32_t startTime        = static_cast<uint32_t>(0);
    uint8_t numberOfIntervals = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace GetMeasurementProfileCommand
} // namespace Commands

namespace Attributes {

namespace MeasurementType {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasurementType::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasurementType
namespace DcVoltage {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcVoltage
namespace DcVoltageMin {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcVoltageMin::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcVoltageMin
namespace DcVoltageMax {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcVoltageMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcVoltageMax
namespace DcCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcCurrent
namespace DcCurrentMin {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcCurrentMin::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcCurrentMin
namespace DcCurrentMax {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcCurrentMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcCurrentMax
namespace DcPower {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcPower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcPower
namespace DcPowerMin {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcPowerMin::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcPowerMin
namespace DcPowerMax {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcPowerMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcPowerMax
namespace DcVoltageMultiplier {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcVoltageMultiplier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcVoltageMultiplier
namespace DcVoltageDivisor {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcVoltageDivisor::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcVoltageDivisor
namespace DcCurrentMultiplier {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcCurrentMultiplier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcCurrentMultiplier
namespace DcCurrentDivisor {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcCurrentDivisor::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcCurrentDivisor
namespace DcPowerMultiplier {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcPowerMultiplier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcPowerMultiplier
namespace DcPowerDivisor {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::DcPowerDivisor::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace DcPowerDivisor
namespace AcFrequency {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcFrequency::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcFrequency
namespace AcFrequencyMin {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcFrequencyMin::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcFrequencyMin
namespace AcFrequencyMax {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcFrequencyMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcFrequencyMax
namespace NeutralCurrent {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::NeutralCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace NeutralCurrent
namespace TotalActivePower {
struct TypeInfo
{
    using Type             = int32_t;
    using DecodableType    = int32_t;
    using DecodableArgType = int32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TotalActivePower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TotalActivePower
namespace TotalReactivePower {
struct TypeInfo
{
    using Type             = int32_t;
    using DecodableType    = int32_t;
    using DecodableArgType = int32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TotalReactivePower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TotalReactivePower
namespace TotalApparentPower {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::TotalApparentPower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace TotalApparentPower
namespace Measured1stHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Measured1stHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Measured1stHarmonicCurrent
namespace Measured3rdHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Measured3rdHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Measured3rdHarmonicCurrent
namespace Measured5thHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Measured5thHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Measured5thHarmonicCurrent
namespace Measured7thHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Measured7thHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Measured7thHarmonicCurrent
namespace Measured9thHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Measured9thHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Measured9thHarmonicCurrent
namespace Measured11thHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Measured11thHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Measured11thHarmonicCurrent
namespace MeasuredPhase1stHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasuredPhase1stHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasuredPhase1stHarmonicCurrent
namespace MeasuredPhase3rdHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasuredPhase3rdHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasuredPhase3rdHarmonicCurrent
namespace MeasuredPhase5thHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasuredPhase5thHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasuredPhase5thHarmonicCurrent
namespace MeasuredPhase7thHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasuredPhase7thHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasuredPhase7thHarmonicCurrent
namespace MeasuredPhase9thHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasuredPhase9thHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasuredPhase9thHarmonicCurrent
namespace MeasuredPhase11thHarmonicCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::MeasuredPhase11thHarmonicCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace MeasuredPhase11thHarmonicCurrent
namespace AcFrequencyMultiplier {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcFrequencyMultiplier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcFrequencyMultiplier
namespace AcFrequencyDivisor {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcFrequencyDivisor::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcFrequencyDivisor
namespace PowerMultiplier {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PowerMultiplier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PowerMultiplier
namespace PowerDivisor {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PowerDivisor::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PowerDivisor
namespace HarmonicCurrentMultiplier {
struct TypeInfo
{
    using Type             = int8_t;
    using DecodableType    = int8_t;
    using DecodableArgType = int8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::HarmonicCurrentMultiplier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace HarmonicCurrentMultiplier
namespace PhaseHarmonicCurrentMultiplier {
struct TypeInfo
{
    using Type             = int8_t;
    using DecodableType    = int8_t;
    using DecodableArgType = int8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PhaseHarmonicCurrentMultiplier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PhaseHarmonicCurrentMultiplier
namespace InstantaneousVoltage {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InstantaneousVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InstantaneousVoltage
namespace InstantaneousLineCurrent {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InstantaneousLineCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InstantaneousLineCurrent
namespace InstantaneousActiveCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InstantaneousActiveCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InstantaneousActiveCurrent
namespace InstantaneousReactiveCurrent {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InstantaneousReactiveCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InstantaneousReactiveCurrent
namespace InstantaneousPower {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::InstantaneousPower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace InstantaneousPower
namespace RmsVoltage {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltage
namespace RmsVoltageMin {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageMin::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageMin
namespace RmsVoltageMax {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageMax
namespace RmsCurrent {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsCurrent::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsCurrent
namespace RmsCurrentMin {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsCurrentMin::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsCurrentMin
namespace RmsCurrentMax {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsCurrentMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsCurrentMax
namespace ActivePower {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActivePower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActivePower
namespace ActivePowerMin {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActivePowerMin::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActivePowerMin
namespace ActivePowerMax {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActivePowerMax::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActivePowerMax
namespace ReactivePower {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ReactivePower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ReactivePower
namespace ApparentPower {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ApparentPower::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ApparentPower
namespace PowerFactor {
struct TypeInfo
{
    using Type             = int8_t;
    using DecodableType    = int8_t;
    using DecodableArgType = int8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PowerFactor::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PowerFactor
namespace AverageRmsVoltageMeasurementPeriod {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AverageRmsVoltageMeasurementPeriod::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AverageRmsVoltageMeasurementPeriod
namespace AverageRmsUnderVoltageCounter {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AverageRmsUnderVoltageCounter::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AverageRmsUnderVoltageCounter
namespace RmsExtremeOverVoltagePeriod {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsExtremeOverVoltagePeriod::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsExtremeOverVoltagePeriod
namespace RmsExtremeUnderVoltagePeriod {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsExtremeUnderVoltagePeriod::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsExtremeUnderVoltagePeriod
namespace RmsVoltageSagPeriod {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageSagPeriod::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageSagPeriod
namespace RmsVoltageSwellPeriod {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageSwellPeriod::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageSwellPeriod
namespace AcVoltageMultiplier {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcVoltageMultiplier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcVoltageMultiplier
namespace AcVoltageDivisor {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcVoltageDivisor::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcVoltageDivisor
namespace AcCurrentMultiplier {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcCurrentMultiplier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcCurrentMultiplier
namespace AcCurrentDivisor {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcCurrentDivisor::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcCurrentDivisor
namespace AcPowerMultiplier {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcPowerMultiplier::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcPowerMultiplier
namespace AcPowerDivisor {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcPowerDivisor::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcPowerDivisor
namespace OverloadAlarmsMask {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::OverloadAlarmsMask::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace OverloadAlarmsMask
namespace VoltageOverload {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::VoltageOverload::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace VoltageOverload
namespace CurrentOverload {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::CurrentOverload::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace CurrentOverload
namespace AcOverloadAlarmsMask {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcOverloadAlarmsMask::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcOverloadAlarmsMask
namespace AcVoltageOverload {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcVoltageOverload::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcVoltageOverload
namespace AcCurrentOverload {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcCurrentOverload::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcCurrentOverload
namespace AcActivePowerOverload {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcActivePowerOverload::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcActivePowerOverload
namespace AcReactivePowerOverload {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AcReactivePowerOverload::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AcReactivePowerOverload
namespace AverageRmsOverVoltage {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AverageRmsOverVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AverageRmsOverVoltage
namespace AverageRmsUnderVoltage {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AverageRmsUnderVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AverageRmsUnderVoltage
namespace RmsExtremeOverVoltage {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsExtremeOverVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsExtremeOverVoltage
namespace RmsExtremeUnderVoltage {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsExtremeUnderVoltage::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsExtremeUnderVoltage
namespace RmsVoltageSag {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageSag::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageSag
namespace RmsVoltageSwell {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageSwell::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageSwell
namespace LineCurrentPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LineCurrentPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LineCurrentPhaseB
namespace ActiveCurrentPhaseB {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveCurrentPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveCurrentPhaseB
namespace ReactiveCurrentPhaseB {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ReactiveCurrentPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ReactiveCurrentPhaseB
namespace RmsVoltagePhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltagePhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltagePhaseB
namespace RmsVoltageMinPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageMinPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageMinPhaseB
namespace RmsVoltageMaxPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageMaxPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageMaxPhaseB
namespace RmsCurrentPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsCurrentPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsCurrentPhaseB
namespace RmsCurrentMinPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsCurrentMinPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsCurrentMinPhaseB
namespace RmsCurrentMaxPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsCurrentMaxPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsCurrentMaxPhaseB
namespace ActivePowerPhaseB {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActivePowerPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActivePowerPhaseB
namespace ActivePowerMinPhaseB {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActivePowerMinPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActivePowerMinPhaseB
namespace ActivePowerMaxPhaseB {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActivePowerMaxPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActivePowerMaxPhaseB
namespace ReactivePowerPhaseB {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ReactivePowerPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ReactivePowerPhaseB
namespace ApparentPowerPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ApparentPowerPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ApparentPowerPhaseB
namespace PowerFactorPhaseB {
struct TypeInfo
{
    using Type             = int8_t;
    using DecodableType    = int8_t;
    using DecodableArgType = int8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PowerFactorPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PowerFactorPhaseB
namespace AverageRmsVoltageMeasurementPeriodPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AverageRmsVoltageMeasurementPeriodPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AverageRmsVoltageMeasurementPeriodPhaseB
namespace AverageRmsOverVoltageCounterPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AverageRmsOverVoltageCounterPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AverageRmsOverVoltageCounterPhaseB
namespace AverageRmsUnderVoltageCounterPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AverageRmsUnderVoltageCounterPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AverageRmsUnderVoltageCounterPhaseB
namespace RmsExtremeOverVoltagePeriodPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsExtremeOverVoltagePeriodPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsExtremeOverVoltagePeriodPhaseB
namespace RmsExtremeUnderVoltagePeriodPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsExtremeUnderVoltagePeriodPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsExtremeUnderVoltagePeriodPhaseB
namespace RmsVoltageSagPeriodPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageSagPeriodPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageSagPeriodPhaseB
namespace RmsVoltageSwellPeriodPhaseB {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageSwellPeriodPhaseB::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageSwellPeriodPhaseB
namespace LineCurrentPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::LineCurrentPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace LineCurrentPhaseC
namespace ActiveCurrentPhaseC {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActiveCurrentPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActiveCurrentPhaseC
namespace ReactiveCurrentPhaseC {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ReactiveCurrentPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ReactiveCurrentPhaseC
namespace RmsVoltagePhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltagePhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltagePhaseC
namespace RmsVoltageMinPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageMinPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageMinPhaseC
namespace RmsVoltageMaxPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageMaxPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageMaxPhaseC
namespace RmsCurrentPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsCurrentPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsCurrentPhaseC
namespace RmsCurrentMinPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsCurrentMinPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsCurrentMinPhaseC
namespace RmsCurrentMaxPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsCurrentMaxPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsCurrentMaxPhaseC
namespace ActivePowerPhaseC {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActivePowerPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActivePowerPhaseC
namespace ActivePowerMinPhaseC {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActivePowerMinPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActivePowerMinPhaseC
namespace ActivePowerMaxPhaseC {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ActivePowerMaxPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ActivePowerMaxPhaseC
namespace ReactivePowerPhaseC {
struct TypeInfo
{
    using Type             = int16_t;
    using DecodableType    = int16_t;
    using DecodableArgType = int16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ReactivePowerPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ReactivePowerPhaseC
namespace ApparentPowerPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::ApparentPowerPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace ApparentPowerPhaseC
namespace PowerFactorPhaseC {
struct TypeInfo
{
    using Type             = int8_t;
    using DecodableType    = int8_t;
    using DecodableArgType = int8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::PowerFactorPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace PowerFactorPhaseC
namespace AverageRmsVoltageMeasurementPeriodPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AverageRmsVoltageMeasurementPeriodPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AverageRmsVoltageMeasurementPeriodPhaseC
namespace AverageRmsOverVoltageCounterPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AverageRmsOverVoltageCounterPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AverageRmsOverVoltageCounterPhaseC
namespace AverageRmsUnderVoltageCounterPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::AverageRmsUnderVoltageCounterPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace AverageRmsUnderVoltageCounterPhaseC
namespace RmsExtremeOverVoltagePeriodPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsExtremeOverVoltagePeriodPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsExtremeOverVoltagePeriodPhaseC
namespace RmsExtremeUnderVoltagePeriodPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsExtremeUnderVoltagePeriodPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsExtremeUnderVoltagePeriodPhaseC
namespace RmsVoltageSagPeriodPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageSagPeriodPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageSagPeriodPhaseC
namespace RmsVoltageSwellPeriodPhaseC {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::RmsVoltageSwellPeriodPhaseC::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace RmsVoltageSwellPeriodPhaseC
namespace GeneratedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::GeneratedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
};
} // namespace GeneratedCommandList
namespace AcceptedCommandList {
struct TypeInfo : public Clusters::Globals::Attributes::AcceptedCommandList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
};
} // namespace AcceptedCommandList
namespace AttributeList {
struct TypeInfo : public Clusters::Globals::Attributes::AttributeList::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
};
} // namespace AttributeList
namespace FeatureMap {
struct TypeInfo : public Clusters::Globals::Attributes::FeatureMap::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
};
} // namespace FeatureMap
namespace ClusterRevision {
struct TypeInfo : public Clusters::Globals::Attributes::ClusterRevision::TypeInfo
{
    static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }
};
} // namespace ClusterRevision

struct TypeInfo
{
    struct DecodableType
    {
        static constexpr ClusterId GetClusterId() { return Clusters::ElectricalMeasurement::Id; }

        CHIP_ERROR Decode(TLV::TLVReader & reader, const ConcreteAttributePath & path);

        Attributes::MeasurementType::TypeInfo::DecodableType measurementType                         = static_cast<uint32_t>(0);
        Attributes::DcVoltage::TypeInfo::DecodableType dcVoltage                                     = static_cast<int16_t>(0);
        Attributes::DcVoltageMin::TypeInfo::DecodableType dcVoltageMin                               = static_cast<int16_t>(0);
        Attributes::DcVoltageMax::TypeInfo::DecodableType dcVoltageMax                               = static_cast<int16_t>(0);
        Attributes::DcCurrent::TypeInfo::DecodableType dcCurrent                                     = static_cast<int16_t>(0);
        Attributes::DcCurrentMin::TypeInfo::DecodableType dcCurrentMin                               = static_cast<int16_t>(0);
        Attributes::DcCurrentMax::TypeInfo::DecodableType dcCurrentMax                               = static_cast<int16_t>(0);
        Attributes::DcPower::TypeInfo::DecodableType dcPower                                         = static_cast<int16_t>(0);
        Attributes::DcPowerMin::TypeInfo::DecodableType dcPowerMin                                   = static_cast<int16_t>(0);
        Attributes::DcPowerMax::TypeInfo::DecodableType dcPowerMax                                   = static_cast<int16_t>(0);
        Attributes::DcVoltageMultiplier::TypeInfo::DecodableType dcVoltageMultiplier                 = static_cast<uint16_t>(0);
        Attributes::DcVoltageDivisor::TypeInfo::DecodableType dcVoltageDivisor                       = static_cast<uint16_t>(0);
        Attributes::DcCurrentMultiplier::TypeInfo::DecodableType dcCurrentMultiplier                 = static_cast<uint16_t>(0);
        Attributes::DcCurrentDivisor::TypeInfo::DecodableType dcCurrentDivisor                       = static_cast<uint16_t>(0);
        Attributes::DcPowerMultiplier::TypeInfo::DecodableType dcPowerMultiplier                     = static_cast<uint16_t>(0);
        Attributes::DcPowerDivisor::TypeInfo::DecodableType dcPowerDivisor                           = static_cast<uint16_t>(0);
        Attributes::AcFrequency::TypeInfo::DecodableType acFrequency                                 = static_cast<uint16_t>(0);
        Attributes::AcFrequencyMin::TypeInfo::DecodableType acFrequencyMin                           = static_cast<uint16_t>(0);
        Attributes::AcFrequencyMax::TypeInfo::DecodableType acFrequencyMax                           = static_cast<uint16_t>(0);
        Attributes::NeutralCurrent::TypeInfo::DecodableType neutralCurrent                           = static_cast<uint16_t>(0);
        Attributes::TotalActivePower::TypeInfo::DecodableType totalActivePower                       = static_cast<int32_t>(0);
        Attributes::TotalReactivePower::TypeInfo::DecodableType totalReactivePower                   = static_cast<int32_t>(0);
        Attributes::TotalApparentPower::TypeInfo::DecodableType totalApparentPower                   = static_cast<uint32_t>(0);
        Attributes::Measured1stHarmonicCurrent::TypeInfo::DecodableType measured1stHarmonicCurrent   = static_cast<int16_t>(0);
        Attributes::Measured3rdHarmonicCurrent::TypeInfo::DecodableType measured3rdHarmonicCurrent   = static_cast<int16_t>(0);
        Attributes::Measured5thHarmonicCurrent::TypeInfo::DecodableType measured5thHarmonicCurrent   = static_cast<int16_t>(0);
        Attributes::Measured7thHarmonicCurrent::TypeInfo::DecodableType measured7thHarmonicCurrent   = static_cast<int16_t>(0);
        Attributes::Measured9thHarmonicCurrent::TypeInfo::DecodableType measured9thHarmonicCurrent   = static_cast<int16_t>(0);
        Attributes::Measured11thHarmonicCurrent::TypeInfo::DecodableType measured11thHarmonicCurrent = static_cast<int16_t>(0);
        Attributes::MeasuredPhase1stHarmonicCurrent::TypeInfo::DecodableType measuredPhase1stHarmonicCurrent =
            static_cast<int16_t>(0);
        Attributes::MeasuredPhase3rdHarmonicCurrent::TypeInfo::DecodableType measuredPhase3rdHarmonicCurrent =
            static_cast<int16_t>(0);
        Attributes::MeasuredPhase5thHarmonicCurrent::TypeInfo::DecodableType measuredPhase5thHarmonicCurrent =
            static_cast<int16_t>(0);
        Attributes::MeasuredPhase7thHarmonicCurrent::TypeInfo::DecodableType measuredPhase7thHarmonicCurrent =
            static_cast<int16_t>(0);
        Attributes::MeasuredPhase9thHarmonicCurrent::TypeInfo::DecodableType measuredPhase9thHarmonicCurrent =
            static_cast<int16_t>(0);
        Attributes::MeasuredPhase11thHarmonicCurrent::TypeInfo::DecodableType measuredPhase11thHarmonicCurrent =
            static_cast<int16_t>(0);
        Attributes::AcFrequencyMultiplier::TypeInfo::DecodableType acFrequencyMultiplier         = static_cast<uint16_t>(0);
        Attributes::AcFrequencyDivisor::TypeInfo::DecodableType acFrequencyDivisor               = static_cast<uint16_t>(0);
        Attributes::PowerMultiplier::TypeInfo::DecodableType powerMultiplier                     = static_cast<uint32_t>(0);
        Attributes::PowerDivisor::TypeInfo::DecodableType powerDivisor                           = static_cast<uint32_t>(0);
        Attributes::HarmonicCurrentMultiplier::TypeInfo::DecodableType harmonicCurrentMultiplier = static_cast<int8_t>(0);
        Attributes::PhaseHarmonicCurrentMultiplier::TypeInfo::DecodableType phaseHarmonicCurrentMultiplier = static_cast<int8_t>(0);
        Attributes::InstantaneousVoltage::TypeInfo::DecodableType instantaneousVoltage                 = static_cast<int16_t>(0);
        Attributes::InstantaneousLineCurrent::TypeInfo::DecodableType instantaneousLineCurrent         = static_cast<uint16_t>(0);
        Attributes::InstantaneousActiveCurrent::TypeInfo::DecodableType instantaneousActiveCurrent     = static_cast<int16_t>(0);
        Attributes::InstantaneousReactiveCurrent::TypeInfo::DecodableType instantaneousReactiveCurrent = static_cast<int16_t>(0);
        Attributes::InstantaneousPower::TypeInfo::DecodableType instantaneousPower                     = static_cast<int16_t>(0);
        Attributes::RmsVoltage::TypeInfo::DecodableType rmsVoltage                                     = static_cast<uint16_t>(0);
        Attributes::RmsVoltageMin::TypeInfo::DecodableType rmsVoltageMin                               = static_cast<uint16_t>(0);
        Attributes::RmsVoltageMax::TypeInfo::DecodableType rmsVoltageMax                               = static_cast<uint16_t>(0);
        Attributes::RmsCurrent::TypeInfo::DecodableType rmsCurrent                                     = static_cast<uint16_t>(0);
        Attributes::RmsCurrentMin::TypeInfo::DecodableType rmsCurrentMin                               = static_cast<uint16_t>(0);
        Attributes::RmsCurrentMax::TypeInfo::DecodableType rmsCurrentMax                               = static_cast<uint16_t>(0);
        Attributes::ActivePower::TypeInfo::DecodableType activePower                                   = static_cast<int16_t>(0);
        Attributes::ActivePowerMin::TypeInfo::DecodableType activePowerMin                             = static_cast<int16_t>(0);
        Attributes::ActivePowerMax::TypeInfo::DecodableType activePowerMax                             = static_cast<int16_t>(0);
        Attributes::ReactivePower::TypeInfo::DecodableType reactivePower                               = static_cast<int16_t>(0);
        Attributes::ApparentPower::TypeInfo::DecodableType apparentPower                               = static_cast<uint16_t>(0);
        Attributes::PowerFactor::TypeInfo::DecodableType powerFactor                                   = static_cast<int8_t>(0);
        Attributes::AverageRmsVoltageMeasurementPeriod::TypeInfo::DecodableType averageRmsVoltageMeasurementPeriod =
            static_cast<uint16_t>(0);
        Attributes::AverageRmsUnderVoltageCounter::TypeInfo::DecodableType averageRmsUnderVoltageCounter = static_cast<uint16_t>(0);
        Attributes::RmsExtremeOverVoltagePeriod::TypeInfo::DecodableType rmsExtremeOverVoltagePeriod     = static_cast<uint16_t>(0);
        Attributes::RmsExtremeUnderVoltagePeriod::TypeInfo::DecodableType rmsExtremeUnderVoltagePeriod   = static_cast<uint16_t>(0);
        Attributes::RmsVoltageSagPeriod::TypeInfo::DecodableType rmsVoltageSagPeriod                     = static_cast<uint16_t>(0);
        Attributes::RmsVoltageSwellPeriod::TypeInfo::DecodableType rmsVoltageSwellPeriod                 = static_cast<uint16_t>(0);
        Attributes::AcVoltageMultiplier::TypeInfo::DecodableType acVoltageMultiplier                     = static_cast<uint16_t>(0);
        Attributes::AcVoltageDivisor::TypeInfo::DecodableType acVoltageDivisor                           = static_cast<uint16_t>(0);
        Attributes::AcCurrentMultiplier::TypeInfo::DecodableType acCurrentMultiplier                     = static_cast<uint16_t>(0);
        Attributes::AcCurrentDivisor::TypeInfo::DecodableType acCurrentDivisor                           = static_cast<uint16_t>(0);
        Attributes::AcPowerMultiplier::TypeInfo::DecodableType acPowerMultiplier                         = static_cast<uint16_t>(0);
        Attributes::AcPowerDivisor::TypeInfo::DecodableType acPowerDivisor                               = static_cast<uint16_t>(0);
        Attributes::OverloadAlarmsMask::TypeInfo::DecodableType overloadAlarmsMask                       = static_cast<uint8_t>(0);
        Attributes::VoltageOverload::TypeInfo::DecodableType voltageOverload                             = static_cast<int16_t>(0);
        Attributes::CurrentOverload::TypeInfo::DecodableType currentOverload                             = static_cast<int16_t>(0);
        Attributes::AcOverloadAlarmsMask::TypeInfo::DecodableType acOverloadAlarmsMask                   = static_cast<uint16_t>(0);
        Attributes::AcVoltageOverload::TypeInfo::DecodableType acVoltageOverload                         = static_cast<int16_t>(0);
        Attributes::AcCurrentOverload::TypeInfo::DecodableType acCurrentOverload                         = static_cast<int16_t>(0);
        Attributes::AcActivePowerOverload::TypeInfo::DecodableType acActivePowerOverload                 = static_cast<int16_t>(0);
        Attributes::AcReactivePowerOverload::TypeInfo::DecodableType acReactivePowerOverload             = static_cast<int16_t>(0);
        Attributes::AverageRmsOverVoltage::TypeInfo::DecodableType averageRmsOverVoltage                 = static_cast<int16_t>(0);
        Attributes::AverageRmsUnderVoltage::TypeInfo::DecodableType averageRmsUnderVoltage               = static_cast<int16_t>(0);
        Attributes::RmsExtremeOverVoltage::TypeInfo::DecodableType rmsExtremeOverVoltage                 = static_cast<int16_t>(0);
        Attributes::RmsExtremeUnderVoltage::TypeInfo::DecodableType rmsExtremeUnderVoltage               = static_cast<int16_t>(0);
        Attributes::RmsVoltageSag::TypeInfo::DecodableType rmsVoltageSag                                 = static_cast<int16_t>(0);
        Attributes::RmsVoltageSwell::TypeInfo::DecodableType rmsVoltageSwell                             = static_cast<int16_t>(0);
        Attributes::LineCurrentPhaseB::TypeInfo::DecodableType lineCurrentPhaseB                         = static_cast<uint16_t>(0);
        Attributes::ActiveCurrentPhaseB::TypeInfo::DecodableType activeCurrentPhaseB                     = static_cast<int16_t>(0);
        Attributes::ReactiveCurrentPhaseB::TypeInfo::DecodableType reactiveCurrentPhaseB                 = static_cast<int16_t>(0);
        Attributes::RmsVoltagePhaseB::TypeInfo::DecodableType rmsVoltagePhaseB                           = static_cast<uint16_t>(0);
        Attributes::RmsVoltageMinPhaseB::TypeInfo::DecodableType rmsVoltageMinPhaseB                     = static_cast<uint16_t>(0);
        Attributes::RmsVoltageMaxPhaseB::TypeInfo::DecodableType rmsVoltageMaxPhaseB                     = static_cast<uint16_t>(0);
        Attributes::RmsCurrentPhaseB::TypeInfo::DecodableType rmsCurrentPhaseB                           = static_cast<uint16_t>(0);
        Attributes::RmsCurrentMinPhaseB::TypeInfo::DecodableType rmsCurrentMinPhaseB                     = static_cast<uint16_t>(0);
        Attributes::RmsCurrentMaxPhaseB::TypeInfo::DecodableType rmsCurrentMaxPhaseB                     = static_cast<uint16_t>(0);
        Attributes::ActivePowerPhaseB::TypeInfo::DecodableType activePowerPhaseB                         = static_cast<int16_t>(0);
        Attributes::ActivePowerMinPhaseB::TypeInfo::DecodableType activePowerMinPhaseB                   = static_cast<int16_t>(0);
        Attributes::ActivePowerMaxPhaseB::TypeInfo::DecodableType activePowerMaxPhaseB                   = static_cast<int16_t>(0);
        Attributes::ReactivePowerPhaseB::TypeInfo::DecodableType reactivePowerPhaseB                     = static_cast<int16_t>(0);
        Attributes::ApparentPowerPhaseB::TypeInfo::DecodableType apparentPowerPhaseB                     = static_cast<uint16_t>(0);
        Attributes::PowerFactorPhaseB::TypeInfo::DecodableType powerFactorPhaseB                         = static_cast<int8_t>(0);
        Attributes::AverageRmsVoltageMeasurementPeriodPhaseB::TypeInfo::DecodableType averageRmsVoltageMeasurementPeriodPhaseB =
            static_cast<uint16_t>(0);
        Attributes::AverageRmsOverVoltageCounterPhaseB::TypeInfo::DecodableType averageRmsOverVoltageCounterPhaseB =
            static_cast<uint16_t>(0);
        Attributes::AverageRmsUnderVoltageCounterPhaseB::TypeInfo::DecodableType averageRmsUnderVoltageCounterPhaseB =
            static_cast<uint16_t>(0);
        Attributes::RmsExtremeOverVoltagePeriodPhaseB::TypeInfo::DecodableType rmsExtremeOverVoltagePeriodPhaseB =
            static_cast<uint16_t>(0);
        Attributes::RmsExtremeUnderVoltagePeriodPhaseB::TypeInfo::DecodableType rmsExtremeUnderVoltagePeriodPhaseB =
            static_cast<uint16_t>(0);
        Attributes::RmsVoltageSagPeriodPhaseB::TypeInfo::DecodableType rmsVoltageSagPeriodPhaseB     = static_cast<uint16_t>(0);
        Attributes::RmsVoltageSwellPeriodPhaseB::TypeInfo::DecodableType rmsVoltageSwellPeriodPhaseB = static_cast<uint16_t>(0);
        Attributes::LineCurrentPhaseC::TypeInfo::DecodableType lineCurrentPhaseC                     = static_cast<uint16_t>(0);
        Attributes::ActiveCurrentPhaseC::TypeInfo::DecodableType activeCurrentPhaseC                 = static_cast<int16_t>(0);
        Attributes::ReactiveCurrentPhaseC::TypeInfo::DecodableType reactiveCurrentPhaseC             = static_cast<int16_t>(0);
        Attributes::RmsVoltagePhaseC::TypeInfo::DecodableType rmsVoltagePhaseC                       = static_cast<uint16_t>(0);
        Attributes::RmsVoltageMinPhaseC::TypeInfo::DecodableType rmsVoltageMinPhaseC                 = static_cast<uint16_t>(0);
        Attributes::RmsVoltageMaxPhaseC::TypeInfo::DecodableType rmsVoltageMaxPhaseC                 = static_cast<uint16_t>(0);
        Attributes::RmsCurrentPhaseC::TypeInfo::DecodableType rmsCurrentPhaseC                       = static_cast<uint16_t>(0);
        Attributes::RmsCurrentMinPhaseC::TypeInfo::DecodableType rmsCurrentMinPhaseC                 = static_cast<uint16_t>(0);
        Attributes::RmsCurrentMaxPhaseC::TypeInfo::DecodableType rmsCurrentMaxPhaseC                 = static_cast<uint16_t>(0);
        Attributes::ActivePowerPhaseC::TypeInfo::DecodableType activePowerPhaseC                     = static_cast<int16_t>(0);
        Attributes::ActivePowerMinPhaseC::TypeInfo::DecodableType activePowerMinPhaseC               = static_cast<int16_t>(0);
        Attributes::ActivePowerMaxPhaseC::TypeInfo::DecodableType activePowerMaxPhaseC               = static_cast<int16_t>(0);
        Attributes::ReactivePowerPhaseC::TypeInfo::DecodableType reactivePowerPhaseC                 = static_cast<int16_t>(0);
        Attributes::ApparentPowerPhaseC::TypeInfo::DecodableType apparentPowerPhaseC                 = static_cast<uint16_t>(0);
        Attributes::PowerFactorPhaseC::TypeInfo::DecodableType powerFactorPhaseC                     = static_cast<int8_t>(0);
        Attributes::AverageRmsVoltageMeasurementPeriodPhaseC::TypeInfo::DecodableType averageRmsVoltageMeasurementPeriodPhaseC =
            static_cast<uint16_t>(0);
        Attributes::AverageRmsOverVoltageCounterPhaseC::TypeInfo::DecodableType averageRmsOverVoltageCounterPhaseC =
            static_cast<uint16_t>(0);
        Attributes::AverageRmsUnderVoltageCounterPhaseC::TypeInfo::DecodableType averageRmsUnderVoltageCounterPhaseC =
            static_cast<uint16_t>(0);
        Attributes::RmsExtremeOverVoltagePeriodPhaseC::TypeInfo::DecodableType rmsExtremeOverVoltagePeriodPhaseC =
            static_cast<uint16_t>(0);
        Attributes::RmsExtremeUnderVoltagePeriodPhaseC::TypeInfo::DecodableType rmsExtremeUnderVoltagePeriodPhaseC =
            static_cast<uint16_t>(0);
        Attributes::RmsVoltageSagPeriodPhaseC::TypeInfo::DecodableType rmsVoltageSagPeriodPhaseC     = static_cast<uint16_t>(0);
        Attributes::RmsVoltageSwellPeriodPhaseC::TypeInfo::DecodableType rmsVoltageSwellPeriodPhaseC = static_cast<uint16_t>(0);
        Attributes::GeneratedCommandList::TypeInfo::DecodableType generatedCommandList;
        Attributes::AcceptedCommandList::TypeInfo::DecodableType acceptedCommandList;
        Attributes::AttributeList::TypeInfo::DecodableType attributeList;
        Attributes::FeatureMap::TypeInfo::DecodableType featureMap           = static_cast<uint32_t>(0);
        Attributes::ClusterRevision::TypeInfo::DecodableType clusterRevision = static_cast<uint16_t>(0);
    };
};
} // namespace Attributes
} // namespace ElectricalMeasurement
namespace TestCluster {
namespace Structs {
namespace SimpleStruct {
enum class Fields
{
    kA = 0,
    kB = 1,
    kC = 2,
    kD = 3,
    kE = 4,
    kF = 5,
    kG = 6,
    kH = 7,
};

struct Type
{
public:
    uint8_t a    = static_cast<uint8_t>(0);
    bool b       = static_cast<bool>(0);
    SimpleEnum c = static_cast<SimpleEnum>(0);
    chip::ByteSpan d;
    chip::CharSpan e;
    chip::BitMask<SimpleBitmap> f = static_cast<chip::BitMask<SimpleBitmap>>(0);
    float g                       = static_cast<float>(0);
    double h                      = static_cast<double>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace SimpleStruct
namespace TestFabricScoped {
enum class Fields
{
    kFabricSensitiveInt8u                 = 1,
    kOptionalFabricSensitiveInt8u         = 2,
    kNullableFabricSensitiveInt8u         = 3,
    kNullableOptionalFabricSensitiveInt8u = 4,
    kFabricSensitiveCharString            = 5,
    kFabricSensitiveStruct                = 6,
    kFabricSensitiveInt8uList             = 7,
    kFabricIndex                          = 254,
};

struct Type
{
public:
    uint8_t fabricSensitiveInt8u = static_cast<uint8_t>(0);
    Optional<uint8_t> optionalFabricSensitiveInt8u;
    DataModel::Nullable<uint8_t> nullableFabricSensitiveInt8u;
    Optional<DataModel::Nullable<uint8_t>> nullableOptionalFabricSensitiveInt8u;
    chip::CharSpan fabricSensitiveCharString;
    Structs::SimpleStruct::Type fabricSensitiveStruct;
    DataModel::List<const uint8_t> fabricSensitiveInt8uList;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }

    CHIP_ERROR EncodeForWrite(TLV::TLVWriter & writer, TLV::Tag tag) const;
    CHIP_ERROR EncodeForRead(TLV::TLVWriter & writer, TLV::Tag tag, FabricIndex accessingFabricIndex) const;

private:
    CHIP_ERROR DoEncode(TLV::TLVWriter & writer, TLV::Tag tag, const Optional<FabricIndex> & accessingFabricIndex) const;
};

struct DecodableType
{
public:
    uint8_t fabricSensitiveInt8u = static_cast<uint8_t>(0);
    Optional<uint8_t> optionalFabricSensitiveInt8u;
    DataModel::Nullable<uint8_t> nullableFabricSensitiveInt8u;
    Optional<DataModel::Nullable<uint8_t>> nullableOptionalFabricSensitiveInt8u;
    chip::CharSpan fabricSensitiveCharString;
    Structs::SimpleStruct::DecodableType fabricSensitiveStruct;
    DataModel::DecodableList<uint8_t> fabricSensitiveInt8uList;
    chip::FabricIndex fabricIndex = static_cast<chip::FabricIndex>(0);

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = true;

    auto GetFabricIndex() const { return fabricIndex; }

    void SetFabricIndex(chip::FabricIndex fabricIndex_) { fabricIndex = fabricIndex_; }
};

} // namespace TestFabricScoped
namespace NullablesAndOptionalsStruct {
enum class Fields
{
    kNullableInt            = 0,
    kOptionalInt            = 1,
    kNullableOptionalInt    = 2,
    kNullableString         = 3,
    kOptionalString         = 4,
    kNullableOptionalString = 5,
    kNullableStruct         = 6,
    kOptionalStruct         = 7,
    kNullableOptionalStruct = 8,
    kNullableList           = 9,
    kOptionalList           = 10,
    kNullableOptionalList   = 11,
};

struct Type
{
public:
    DataModel::Nullable<uint16_t> nullableInt;
    Optional<uint16_t> optionalInt;
    Optional<DataModel::Nullable<uint16_t>> nullableOptionalInt;
    DataModel::Nullable<chip::CharSpan> nullableString;
    Optional<chip::CharSpan> optionalString;
    Optional<DataModel::Nullable<chip::CharSpan>> nullableOptionalString;
    DataModel::Nullable<Structs::SimpleStruct::Type> nullableStruct;
    Optional<Structs::SimpleStruct::Type> optionalStruct;
    Optional<DataModel::Nullable<Structs::SimpleStruct::Type>> nullableOptionalStruct;
    DataModel::Nullable<DataModel::List<const SimpleEnum>> nullableList;
    Optional<DataModel::List<const SimpleEnum>> optionalList;
    Optional<DataModel::Nullable<DataModel::List<const SimpleEnum>>> nullableOptionalList;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    DataModel::Nullable<uint16_t> nullableInt;
    Optional<uint16_t> optionalInt;
    Optional<DataModel::Nullable<uint16_t>> nullableOptionalInt;
    DataModel::Nullable<chip::CharSpan> nullableString;
    Optional<chip::CharSpan> optionalString;
    Optional<DataModel::Nullable<chip::CharSpan>> nullableOptionalString;
    DataModel::Nullable<Structs::SimpleStruct::DecodableType> nullableStruct;
    Optional<Structs::SimpleStruct::DecodableType> optionalStruct;
    Optional<DataModel::Nullable<Structs::SimpleStruct::DecodableType>> nullableOptionalStruct;
    DataModel::Nullable<DataModel::DecodableList<SimpleEnum>> nullableList;
    Optional<DataModel::DecodableList<SimpleEnum>> optionalList;
    Optional<DataModel::Nullable<DataModel::DecodableList<SimpleEnum>>> nullableOptionalList;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace NullablesAndOptionalsStruct
namespace NestedStruct {
enum class Fields
{
    kA = 0,
    kB = 1,
    kC = 2,
};

struct Type
{
public:
    uint8_t a = static_cast<uint8_t>(0);
    bool b    = static_cast<bool>(0);
    Structs::SimpleStruct::Type c;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace NestedStruct
namespace NestedStructList {
enum class Fields
{
    kA = 0,
    kB = 1,
    kC = 2,
    kD = 3,
    kE = 4,
    kF = 5,
    kG = 6,
};

struct Type
{
public:
    uint8_t a = static_cast<uint8_t>(0);
    bool b    = static_cast<bool>(0);
    Structs::SimpleStruct::Type c;
    DataModel::List<const Structs::SimpleStruct::Type> d;
    DataModel::List<const uint32_t> e;
    DataModel::List<const chip::ByteSpan> f;
    DataModel::List<const uint8_t> g;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    uint8_t a = static_cast<uint8_t>(0);
    bool b    = static_cast<bool>(0);
    Structs::SimpleStruct::DecodableType c;
    DataModel::DecodableList<Structs::SimpleStruct::DecodableType> d;
    DataModel::DecodableList<uint32_t> e;
    DataModel::DecodableList<chip::ByteSpan> f;
    DataModel::DecodableList<uint8_t> g;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace NestedStructList
namespace DoubleNestedStructList {
enum class Fields
{
    kA = 0,
};

struct Type
{
public:
    DataModel::List<const Structs::NestedStructList::Type> a;

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

struct DecodableType
{
public:
    DataModel::DecodableList<Structs::NestedStructList::DecodableType> a;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;
};

} // namespace DoubleNestedStructList
namespace TestListStructOctet {
enum class Fields
{
    kMember1 = 0,
    kMember2 = 1,
};

struct Type
{
public:
    uint64_t member1 = static_cast<uint64_t>(0);
    chip::ByteSpan member2;

    CHIP_ERROR Decode(TLV::TLVReader & reader);

    static constexpr bool kIsFabricScoped = false;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;
};

using DecodableType = Type;

} // namespace TestListStructOctet
} // namespace Structs

namespace Commands {
// Forward-declarations so we can reference these later.

namespace Test {
struct Type;
struct DecodableType;
} // namespace Test

namespace TestSpecificResponse {
struct Type;
struct DecodableType;
} // namespace TestSpecificResponse

namespace TestNotHandled {
struct Type;
struct DecodableType;
} // namespace TestNotHandled

namespace TestAddArgumentsResponse {
struct Type;
struct DecodableType;
} // namespace TestAddArgumentsResponse

namespace TestSpecific {
struct Type;
struct DecodableType;
} // namespace TestSpecific

namespace TestSimpleArgumentResponse {
struct Type;
struct DecodableType;
} // namespace TestSimpleArgumentResponse

namespace TestUnknownCommand {
struct Type;
struct DecodableType;
} // namespace TestUnknownCommand

namespace TestStructArrayArgumentResponse {
struct Type;
struct DecodableType;
} // namespace TestStructArrayArgumentResponse

namespace TestAddArguments {
struct Type;
struct DecodableType;
} // namespace TestAddArguments

namespace TestListInt8UReverseResponse {
struct Type;
struct DecodableType;
} // namespace TestListInt8UReverseResponse

namespace TestSimpleArgumentRequest {
struct Type;
struct DecodableType;
} // namespace TestSimpleArgumentRequest

namespace TestEnumsResponse {
struct Type;
struct DecodableType;
} // namespace TestEnumsResponse

namespace TestStructArrayArgumentRequest {
struct Type;
struct DecodableType;
} // namespace TestStructArrayArgumentRequest

namespace TestNullableOptionalResponse {
struct Type;
struct DecodableType;
} // namespace TestNullableOptionalResponse

namespace TestStructArgumentRequest {
struct Type;
struct DecodableType;
} // namespace TestStructArgumentRequest

namespace TestComplexNullableOptionalResponse {
struct Type;
struct DecodableType;
} // namespace TestComplexNullableOptionalResponse

namespace TestNestedStructArgumentRequest {
struct Type;
struct DecodableType;
} // namespace TestNestedStructArgumentRequest

namespace BooleanResponse {
struct Type;
struct DecodableType;
} // namespace BooleanResponse

namespace TestListStructArgumentRequest {
struct Type;
struct DecodableType;
} // namespace TestListStructArgumentRequest

namespace SimpleStructResponse {
struct Type;
struct DecodableType;
} // namespace SimpleStructResponse

namespace TestListInt8UArgumentRequest {
struct Type;
struct DecodableType;
} // namespace TestListInt8UArgumentRequest

namespace TestEmitTestEventResponse {
struct Type;
struct DecodableType;
} // namespace TestEmitTestEventResponse

namespace TestNestedStructListArgumentRequest {
struct Type;
struct DecodableType;
} // namespace TestNestedStructListArgumentRequest

namespace TestEmitTestFabricScopedEventResponse {
struct Type;
struct DecodableType;
} // namespace TestEmitTestFabricScopedEventResponse

namespace TestListNestedStructListArgumentRequest {
struct Type;
struct DecodableType;
} // namespace TestListNestedStructListArgumentRequest

namespace TestListInt8UReverseRequest {
struct Type;
struct DecodableType;
} // namespace TestListInt8UReverseRequest

namespace TestEnumsRequest {
struct Type;
struct DecodableType;
} // namespace TestEnumsRequest

namespace TestNullableOptionalRequest {
struct Type;
struct DecodableType;
} // namespace TestNullableOptionalRequest

namespace TestComplexNullableOptionalRequest {
struct Type;
struct DecodableType;
} // namespace TestComplexNullableOptionalRequest

namespace SimpleStructEchoRequest {
struct Type;
struct DecodableType;
} // namespace SimpleStructEchoRequest

namespace TimedInvokeRequest {
struct Type;
struct DecodableType;
} // namespace TimedInvokeRequest

namespace TestSimpleOptionalArgumentRequest {
struct Type;
struct DecodableType;
} // namespace TestSimpleOptionalArgumentRequest

namespace TestEmitTestEventRequest {
struct Type;
struct DecodableType;
} // namespace TestEmitTestEventRequest

namespace TestEmitTestFabricScopedEventRequest {
struct Type;
struct DecodableType;
} // namespace TestEmitTestFabricScopedEventRequest

} // namespace Commands

namespace Commands {
namespace Test {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::Test::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::Test::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace Test
namespace TestSpecificResponse {
enum class Fields
{
    kReturnValue = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestSpecificResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint8_t returnValue = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestSpecificResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint8_t returnValue = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestSpecificResponse
namespace TestNotHandled {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestNotHandled::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestNotHandled::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestNotHandled
namespace TestAddArgumentsResponse {
enum class Fields
{
    kReturnValue = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestAddArgumentsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint8_t returnValue = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestAddArgumentsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint8_t returnValue = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestAddArgumentsResponse
namespace TestSpecific {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestSpecific::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::TestSpecificResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestSpecific::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestSpecific
namespace TestSimpleArgumentResponse {
enum class Fields
{
    kReturnValue = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestSimpleArgumentResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    bool returnValue = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestSimpleArgumentResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    bool returnValue = static_cast<bool>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestSimpleArgumentResponse
namespace TestUnknownCommand {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestUnknownCommand::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestUnknownCommand::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestUnknownCommand
namespace TestStructArrayArgumentResponse {
enum class Fields
{
    kArg1 = 0,
    kArg2 = 1,
    kArg3 = 2,
    kArg4 = 3,
    kArg5 = 4,
    kArg6 = 5,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestStructArrayArgumentResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::List<const Structs::NestedStructList::Type> arg1;
    DataModel::List<const Structs::SimpleStruct::Type> arg2;
    DataModel::List<const SimpleEnum> arg3;
    DataModel::List<const bool> arg4;
    SimpleEnum arg5 = static_cast<SimpleEnum>(0);
    bool arg6       = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestStructArrayArgumentResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::DecodableList<Structs::NestedStructList::DecodableType> arg1;
    DataModel::DecodableList<Structs::SimpleStruct::DecodableType> arg2;
    DataModel::DecodableList<SimpleEnum> arg3;
    DataModel::DecodableList<bool> arg4;
    SimpleEnum arg5 = static_cast<SimpleEnum>(0);
    bool arg6       = static_cast<bool>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestStructArrayArgumentResponse
namespace TestAddArguments {
enum class Fields
{
    kArg1 = 0,
    kArg2 = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestAddArguments::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint8_t arg1 = static_cast<uint8_t>(0);
    uint8_t arg2 = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::TestAddArgumentsResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestAddArguments::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint8_t arg1 = static_cast<uint8_t>(0);
    uint8_t arg2 = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestAddArguments
namespace TestListInt8UReverseResponse {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestListInt8UReverseResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::List<const uint8_t> arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestListInt8UReverseResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::DecodableList<uint8_t> arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestListInt8UReverseResponse
namespace TestSimpleArgumentRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestSimpleArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    bool arg1 = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::TestSimpleArgumentResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestSimpleArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    bool arg1 = static_cast<bool>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestSimpleArgumentRequest
namespace TestEnumsResponse {
enum class Fields
{
    kArg1 = 0,
    kArg2 = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestEnumsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    chip::VendorId arg1 = static_cast<chip::VendorId>(0);
    SimpleEnum arg2     = static_cast<SimpleEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestEnumsResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    chip::VendorId arg1 = static_cast<chip::VendorId>(0);
    SimpleEnum arg2     = static_cast<SimpleEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestEnumsResponse
namespace TestStructArrayArgumentRequest {
enum class Fields
{
    kArg1 = 0,
    kArg2 = 1,
    kArg3 = 2,
    kArg4 = 3,
    kArg5 = 4,
    kArg6 = 5,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestStructArrayArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::List<const Structs::NestedStructList::Type> arg1;
    DataModel::List<const Structs::SimpleStruct::Type> arg2;
    DataModel::List<const SimpleEnum> arg3;
    DataModel::List<const bool> arg4;
    SimpleEnum arg5 = static_cast<SimpleEnum>(0);
    bool arg6       = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::TestStructArrayArgumentResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestStructArrayArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::DecodableList<Structs::NestedStructList::DecodableType> arg1;
    DataModel::DecodableList<Structs::SimpleStruct::DecodableType> arg2;
    DataModel::DecodableList<SimpleEnum> arg3;
    DataModel::DecodableList<bool> arg4;
    SimpleEnum arg5 = static_cast<SimpleEnum>(0);
    bool arg6       = static_cast<bool>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestStructArrayArgumentRequest
namespace TestNullableOptionalResponse {
enum class Fields
{
    kWasPresent    = 0,
    kWasNull       = 1,
    kValue         = 2,
    kOriginalValue = 3,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestNullableOptionalResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    bool wasPresent = static_cast<bool>(0);
    Optional<bool> wasNull;
    Optional<uint8_t> value;
    Optional<DataModel::Nullable<uint8_t>> originalValue;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestNullableOptionalResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    bool wasPresent = static_cast<bool>(0);
    Optional<bool> wasNull;
    Optional<uint8_t> value;
    Optional<DataModel::Nullable<uint8_t>> originalValue;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestNullableOptionalResponse
namespace TestStructArgumentRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestStructArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Structs::SimpleStruct::Type arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::BooleanResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestStructArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Structs::SimpleStruct::DecodableType arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestStructArgumentRequest
namespace TestComplexNullableOptionalResponse {
enum class Fields
{
    kNullableIntWasNull               = 0,
    kNullableIntValue                 = 1,
    kOptionalIntWasPresent            = 2,
    kOptionalIntValue                 = 3,
    kNullableOptionalIntWasPresent    = 4,
    kNullableOptionalIntWasNull       = 5,
    kNullableOptionalIntValue         = 6,
    kNullableStringWasNull            = 7,
    kNullableStringValue              = 8,
    kOptionalStringWasPresent         = 9,
    kOptionalStringValue              = 10,
    kNullableOptionalStringWasPresent = 11,
    kNullableOptionalStringWasNull    = 12,
    kNullableOptionalStringValue      = 13,
    kNullableStructWasNull            = 14,
    kNullableStructValue              = 15,
    kOptionalStructWasPresent         = 16,
    kOptionalStructValue              = 17,
    kNullableOptionalStructWasPresent = 18,
    kNullableOptionalStructWasNull    = 19,
    kNullableOptionalStructValue      = 20,
    kNullableListWasNull              = 21,
    kNullableListValue                = 22,
    kOptionalListWasPresent           = 23,
    kOptionalListValue                = 24,
    kNullableOptionalListWasPresent   = 25,
    kNullableOptionalListWasNull      = 26,
    kNullableOptionalListValue        = 27,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestComplexNullableOptionalResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    bool nullableIntWasNull = static_cast<bool>(0);
    Optional<uint16_t> nullableIntValue;
    bool optionalIntWasPresent = static_cast<bool>(0);
    Optional<uint16_t> optionalIntValue;
    bool nullableOptionalIntWasPresent = static_cast<bool>(0);
    Optional<bool> nullableOptionalIntWasNull;
    Optional<uint16_t> nullableOptionalIntValue;
    bool nullableStringWasNull = static_cast<bool>(0);
    Optional<chip::CharSpan> nullableStringValue;
    bool optionalStringWasPresent = static_cast<bool>(0);
    Optional<chip::CharSpan> optionalStringValue;
    bool nullableOptionalStringWasPresent = static_cast<bool>(0);
    Optional<bool> nullableOptionalStringWasNull;
    Optional<chip::CharSpan> nullableOptionalStringValue;
    bool nullableStructWasNull = static_cast<bool>(0);
    Optional<Structs::SimpleStruct::Type> nullableStructValue;
    bool optionalStructWasPresent = static_cast<bool>(0);
    Optional<Structs::SimpleStruct::Type> optionalStructValue;
    bool nullableOptionalStructWasPresent = static_cast<bool>(0);
    Optional<bool> nullableOptionalStructWasNull;
    Optional<Structs::SimpleStruct::Type> nullableOptionalStructValue;
    bool nullableListWasNull = static_cast<bool>(0);
    Optional<DataModel::List<const SimpleEnum>> nullableListValue;
    bool optionalListWasPresent = static_cast<bool>(0);
    Optional<DataModel::List<const SimpleEnum>> optionalListValue;
    bool nullableOptionalListWasPresent = static_cast<bool>(0);
    Optional<bool> nullableOptionalListWasNull;
    Optional<DataModel::List<const SimpleEnum>> nullableOptionalListValue;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestComplexNullableOptionalResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    bool nullableIntWasNull = static_cast<bool>(0);
    Optional<uint16_t> nullableIntValue;
    bool optionalIntWasPresent = static_cast<bool>(0);
    Optional<uint16_t> optionalIntValue;
    bool nullableOptionalIntWasPresent = static_cast<bool>(0);
    Optional<bool> nullableOptionalIntWasNull;
    Optional<uint16_t> nullableOptionalIntValue;
    bool nullableStringWasNull = static_cast<bool>(0);
    Optional<chip::CharSpan> nullableStringValue;
    bool optionalStringWasPresent = static_cast<bool>(0);
    Optional<chip::CharSpan> optionalStringValue;
    bool nullableOptionalStringWasPresent = static_cast<bool>(0);
    Optional<bool> nullableOptionalStringWasNull;
    Optional<chip::CharSpan> nullableOptionalStringValue;
    bool nullableStructWasNull = static_cast<bool>(0);
    Optional<Structs::SimpleStruct::DecodableType> nullableStructValue;
    bool optionalStructWasPresent = static_cast<bool>(0);
    Optional<Structs::SimpleStruct::DecodableType> optionalStructValue;
    bool nullableOptionalStructWasPresent = static_cast<bool>(0);
    Optional<bool> nullableOptionalStructWasNull;
    Optional<Structs::SimpleStruct::DecodableType> nullableOptionalStructValue;
    bool nullableListWasNull = static_cast<bool>(0);
    Optional<DataModel::DecodableList<SimpleEnum>> nullableListValue;
    bool optionalListWasPresent = static_cast<bool>(0);
    Optional<DataModel::DecodableList<SimpleEnum>> optionalListValue;
    bool nullableOptionalListWasPresent = static_cast<bool>(0);
    Optional<bool> nullableOptionalListWasNull;
    Optional<DataModel::DecodableList<SimpleEnum>> nullableOptionalListValue;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestComplexNullableOptionalResponse
namespace TestNestedStructArgumentRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestNestedStructArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Structs::NestedStruct::Type arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::BooleanResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestNestedStructArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Structs::NestedStruct::DecodableType arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestNestedStructArgumentRequest
namespace BooleanResponse {
enum class Fields
{
    kValue = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::BooleanResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    bool value = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::BooleanResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    bool value = static_cast<bool>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace BooleanResponse
namespace TestListStructArgumentRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestListStructArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::List<const Structs::SimpleStruct::Type> arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::BooleanResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestListStructArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::DecodableList<Structs::SimpleStruct::DecodableType> arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestListStructArgumentRequest
namespace SimpleStructResponse {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SimpleStructResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Structs::SimpleStruct::Type arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SimpleStructResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Structs::SimpleStruct::DecodableType arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SimpleStructResponse
namespace TestListInt8UArgumentRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestListInt8UArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::List<const uint8_t> arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::BooleanResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestListInt8UArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::DecodableList<uint8_t> arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestListInt8UArgumentRequest
namespace TestEmitTestEventResponse {
enum class Fields
{
    kValue = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestEmitTestEventResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint64_t value = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestEmitTestEventResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint64_t value = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestEmitTestEventResponse
namespace TestNestedStructListArgumentRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestNestedStructListArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Structs::NestedStructList::Type arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::BooleanResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestNestedStructListArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Structs::NestedStructList::DecodableType arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestNestedStructListArgumentRequest
namespace TestEmitTestFabricScopedEventResponse {
enum class Fields
{
    kValue = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestEmitTestFabricScopedEventResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint64_t value = static_cast<uint64_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestEmitTestFabricScopedEventResponse::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint64_t value = static_cast<uint64_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestEmitTestFabricScopedEventResponse
namespace TestListNestedStructListArgumentRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestListNestedStructListArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::List<const Structs::NestedStructList::Type> arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::BooleanResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestListNestedStructListArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::DecodableList<Structs::NestedStructList::DecodableType> arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestListNestedStructListArgumentRequest
namespace TestListInt8UReverseRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestListInt8UReverseRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::List<const uint8_t> arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::TestListInt8UReverseResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestListInt8UReverseRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::DecodableList<uint8_t> arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestListInt8UReverseRequest
namespace TestEnumsRequest {
enum class Fields
{
    kArg1 = 0,
    kArg2 = 1,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestEnumsRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    chip::VendorId arg1 = static_cast<chip::VendorId>(0);
    SimpleEnum arg2     = static_cast<SimpleEnum>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::TestEnumsResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestEnumsRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    chip::VendorId arg1 = static_cast<chip::VendorId>(0);
    SimpleEnum arg2     = static_cast<SimpleEnum>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestEnumsRequest
namespace TestNullableOptionalRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestNullableOptionalRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Optional<DataModel::Nullable<uint8_t>> arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::TestNullableOptionalResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestNullableOptionalRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Optional<DataModel::Nullable<uint8_t>> arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestNullableOptionalRequest
namespace TestComplexNullableOptionalRequest {
enum class Fields
{
    kNullableInt            = 0,
    kOptionalInt            = 1,
    kNullableOptionalInt    = 2,
    kNullableString         = 3,
    kOptionalString         = 4,
    kNullableOptionalString = 5,
    kNullableStruct         = 6,
    kOptionalStruct         = 7,
    kNullableOptionalStruct = 8,
    kNullableList           = 9,
    kOptionalList           = 10,
    kNullableOptionalList   = 11,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestComplexNullableOptionalRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::Nullable<uint16_t> nullableInt;
    Optional<uint16_t> optionalInt;
    Optional<DataModel::Nullable<uint16_t>> nullableOptionalInt;
    DataModel::Nullable<chip::CharSpan> nullableString;
    Optional<chip::CharSpan> optionalString;
    Optional<DataModel::Nullable<chip::CharSpan>> nullableOptionalString;
    DataModel::Nullable<Structs::SimpleStruct::Type> nullableStruct;
    Optional<Structs::SimpleStruct::Type> optionalStruct;
    Optional<DataModel::Nullable<Structs::SimpleStruct::Type>> nullableOptionalStruct;
    DataModel::Nullable<DataModel::List<const SimpleEnum>> nullableList;
    Optional<DataModel::List<const SimpleEnum>> optionalList;
    Optional<DataModel::Nullable<DataModel::List<const SimpleEnum>>> nullableOptionalList;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::TestComplexNullableOptionalResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestComplexNullableOptionalRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    DataModel::Nullable<uint16_t> nullableInt;
    Optional<uint16_t> optionalInt;
    Optional<DataModel::Nullable<uint16_t>> nullableOptionalInt;
    DataModel::Nullable<chip::CharSpan> nullableString;
    Optional<chip::CharSpan> optionalString;
    Optional<DataModel::Nullable<chip::CharSpan>> nullableOptionalString;
    DataModel::Nullable<Structs::SimpleStruct::DecodableType> nullableStruct;
    Optional<Structs::SimpleStruct::DecodableType> optionalStruct;
    Optional<DataModel::Nullable<Structs::SimpleStruct::DecodableType>> nullableOptionalStruct;
    DataModel::Nullable<DataModel::DecodableList<SimpleEnum>> nullableList;
    Optional<DataModel::DecodableList<SimpleEnum>> optionalList;
    Optional<DataModel::Nullable<DataModel::DecodableList<SimpleEnum>>> nullableOptionalList;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestComplexNullableOptionalRequest
namespace SimpleStructEchoRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::SimpleStructEchoRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Structs::SimpleStruct::Type arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::SimpleStructResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::SimpleStructEchoRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Structs::SimpleStruct::DecodableType arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace SimpleStructEchoRequest
namespace TimedInvokeRequest {
enum class Fields
{
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TimedInvokeRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return true; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TimedInvokeRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TimedInvokeRequest
namespace TestSimpleOptionalArgumentRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestSimpleOptionalArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Optional<bool> arg1;

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = DataModel::NullObjectType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestSimpleOptionalArgumentRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    Optional<bool> arg1;
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestSimpleOptionalArgumentRequest
namespace TestEmitTestEventRequest {
enum class Fields
{
    kArg1 = 0,
    kArg2 = 1,
    kArg3 = 2,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestEmitTestEventRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint8_t arg1    = static_cast<uint8_t>(0);
    SimpleEnum arg2 = static_cast<SimpleEnum>(0);
    bool arg3       = static_cast<bool>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::TestEmitTestEventResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestEmitTestEventRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint8_t arg1    = static_cast<uint8_t>(0);
    SimpleEnum arg2 = static_cast<SimpleEnum>(0);
    bool arg3       = static_cast<bool>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestEmitTestEventRequest
namespace TestEmitTestFabricScopedEventRequest {
enum class Fields
{
    kArg1 = 0,
};

struct Type
{
public:
    // Use GetCommandId instead of commandId directly to avoid naming conflict with CommandIdentification in ExecutionOfACommand
    static constexpr CommandId GetCommandId() { return Commands::TestEmitTestFabricScopedEventRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint8_t arg1 = static_cast<uint8_t>(0);

    CHIP_ERROR Encode(TLV::TLVWriter & writer, TLV::Tag tag) const;

    using ResponseType = Clusters::TestCluster::Commands::TestEmitTestFabricScopedEventResponse::DecodableType;

    static constexpr bool MustUseTimedInvoke() { return false; }
};

struct DecodableType
{
public:
    static constexpr CommandId GetCommandId() { return Commands::TestEmitTestFabricScopedEventRequest::Id; }
    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }

    uint8_t arg1 = static_cast<uint8_t>(0);
    CHIP_ERROR Decode(TLV::TLVReader & reader);
};
}; // namespace TestEmitTestFabricScopedEventRequest
} // namespace Commands

namespace Attributes {

namespace Boolean {
struct TypeInfo
{
    using Type             = bool;
    using DecodableType    = bool;
    using DecodableArgType = bool;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Boolean::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Boolean
namespace Bitmap8 {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap8MaskMap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap8MaskMap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap8MaskMap>;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Bitmap8::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Bitmap8
namespace Bitmap16 {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap16MaskMap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap16MaskMap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap16MaskMap>;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Bitmap16::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Bitmap16
namespace Bitmap32 {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap32MaskMap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap32MaskMap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap32MaskMap>;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Bitmap32::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Bitmap32
namespace Bitmap64 {
struct TypeInfo
{
    using Type             = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap64MaskMap>;
    using DecodableType    = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap64MaskMap>;
    using DecodableArgType = chip::BitMask<chip::app::Clusters::TestCluster::Bitmap64MaskMap>;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Bitmap64::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Bitmap64
namespace Int8u {
struct TypeInfo
{
    using Type             = uint8_t;
    using DecodableType    = uint8_t;
    using DecodableArgType = uint8_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Int8u::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Int8u
namespace Int16u {
struct TypeInfo
{
    using Type             = uint16_t;
    using DecodableType    = uint16_t;
    using DecodableArgType = uint16_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Int16u::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Int16u
namespace Int24u {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Int24u::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Int24u
namespace Int32u {
struct TypeInfo
{
    using Type             = uint32_t;
    using DecodableType    = uint32_t;
    using DecodableArgType = uint32_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Int32u::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Int32u
namespace Int40u {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Int40u::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Int40u
namespace Int48u {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Int48u::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Int48u
namespace Int56u {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::TestCluster::Id; }
    static constexpr AttributeId GetAttributeId() { return Attributes::Int56u::Id; }
    static constexpr bool MustUseTimedWrite() { return false; }
};
} // namespace Int56u
namespace Int64u {
struct TypeInfo
{
    using Type             = uint64_t;
    using DecodableType    = uint64_t;
    using DecodableArgType = uint64_t;

    static constexpr ClusterId GetClusterId() { return Clusters::Te