/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

// Prevent multiple inclusion
#pragma once

#include <stdint.h>

// ZCL enums

// Enum for AttributeWritePermission
enum EmberAfAttributeWritePermission : uint8_t
{
    EMBER_ZCL_ATTRIBUTE_WRITE_PERMISSION_DENY_WRITE               = 0,
    EMBER_ZCL_ATTRIBUTE_WRITE_PERMISSION_ALLOW_WRITE_NORMAL       = 1,
    EMBER_ZCL_ATTRIBUTE_WRITE_PERMISSION_ALLOW_WRITE_OF_READ_ONLY = 2,
    EMBER_ZCL_ATTRIBUTE_WRITE_PERMISSION_UNSUPPORTED_ATTRIBUTE    = 134,
    EMBER_ZCL_ATTRIBUTE_WRITE_PERMISSION_INVALID_VALUE            = 135,
    EMBER_ZCL_ATTRIBUTE_WRITE_PERMISSION_READ_ONLY                = 136,
    EMBER_ZCL_ATTRIBUTE_WRITE_PERMISSION_INVALID_DATA_TYPE        = 141,
};

// Enum for BarrierControlBarrierPosition
enum EmberAfBarrierControlBarrierPosition : uint8_t
{
    EMBER_ZCL_BARRIER_CONTROL_BARRIER_POSITION_CLOSED  = 0,
    EMBER_ZCL_BARRIER_CONTROL_BARRIER_POSITION_OPEN    = 100,
    EMBER_ZCL_BARRIER_CONTROL_BARRIER_POSITION_UNKNOWN = 255,
};

// Enum for BarrierControlMovingState
enum EmberAfBarrierControlMovingState : uint8_t
{
    EMBER_ZCL_BARRIER_CONTROL_MOVING_STATE_STOPPED = 0,
    EMBER_ZCL_BARRIER_CONTROL_MOVING_STATE_CLOSING = 1,
    EMBER_ZCL_BARRIER_CONTROL_MOVING_STATE_OPENING = 2,
};

// Enum for ColorControlOptions
enum EmberAfColorControlOptions : uint8_t
{
    EMBER_ZCL_COLOR_CONTROL_OPTIONS_EXECUTE_IF_OFF = 1,
};

// Enum for ColorLoopAction
enum EmberAfColorLoopAction : uint8_t
{
    EMBER_ZCL_COLOR_LOOP_ACTION_DEACTIVATE                                  = 0,
    EMBER_ZCL_COLOR_LOOP_ACTION_ACTIVATE_FROM_COLOR_LOOP_START_ENHANCED_HUE = 1,
    EMBER_ZCL_COLOR_LOOP_ACTION_ACTIVATE_FROM_ENHANCED_CURRENT_HUE          = 2,
};

// Enum for ColorLoopDirection
enum EmberAfColorLoopDirection : uint8_t
{
    EMBER_ZCL_COLOR_LOOP_DIRECTION_DECREMENT_HUE = 0,
    EMBER_ZCL_COLOR_LOOP_DIRECTION_INCREMENT_HUE = 1,
};

// Enum for ColorMode
enum EmberAfColorMode : uint8_t
{
    EMBER_ZCL_COLOR_MODE_CURRENT_HUE_AND_CURRENT_SATURATION = 0,
    EMBER_ZCL_COLOR_MODE_CURRENT_X_AND_CURRENT_Y            = 1,
    EMBER_ZCL_COLOR_MODE_COLOR_TEMPERATURE                  = 2,
};

// Enum for EnhancedColorMode
enum EmberAfEnhancedColorMode : uint8_t
{
    EMBER_ZCL_ENHANCED_COLOR_MODE_CURRENT_HUE_AND_CURRENT_SATURATION          = 0,
    EMBER_ZCL_ENHANCED_COLOR_MODE_CURRENT_X_AND_CURRENT_Y                     = 1,
    EMBER_ZCL_ENHANCED_COLOR_MODE_COLOR_TEMPERATURE                           = 2,
    EMBER_ZCL_ENHANCED_COLOR_MODE_ENHANCED_CURRENT_HUE_AND_CURRENT_SATURATION = 3,
};

// Enum for HardwareFaultType
enum EmberAfHardwareFaultType : uint8_t
{
    EMBER_ZCL_HARDWARE_FAULT_TYPE_UNSPECIFIED               = 0,
    EMBER_ZCL_HARDWARE_FAULT_TYPE_RADIO                     = 1,
    EMBER_ZCL_HARDWARE_FAULT_TYPE_SENSOR                    = 2,
    EMBER_ZCL_HARDWARE_FAULT_TYPE_RESETTABLE_OVER_TEMP      = 3,
    EMBER_ZCL_HARDWARE_FAULT_TYPE_NON_RESETTABLE_OVER_TEMP  = 4,
    EMBER_ZCL_HARDWARE_FAULT_TYPE_POWER_SOURCE              = 5,
    EMBER_ZCL_HARDWARE_FAULT_TYPE_VISUAL_DISPLAY_FAULT      = 6,
    EMBER_ZCL_HARDWARE_FAULT_TYPE_AUDIO_OUTPUT_FAULT        = 7,
    EMBER_ZCL_HARDWARE_FAULT_TYPE_USER_INTERFACE_FAULT      = 8,
    EMBER_ZCL_HARDWARE_FAULT_TYPE_NON_VOLATILE_MEMORY_ERROR = 9,
    EMBER_ZCL_HARDWARE_FAULT_TYPE_TAMPER_DETECTED           = 10,
};

// Enum for HueDirection
enum EmberAfHueDirection : uint8_t
{
    EMBER_ZCL_HUE_DIRECTION_SHORTEST_DISTANCE = 0,
    EMBER_ZCL_HUE_DIRECTION_LONGEST_DISTANCE  = 1,
    EMBER_ZCL_HUE_DIRECTION_UP                = 2,
    EMBER_ZCL_HUE_DIRECTION_DOWN              = 3,
};

// Enum for HueMoveMode
enum EmberAfHueMoveMode : uint8_t
{
    EMBER_ZCL_HUE_MOVE_MODE_STOP = 0,
    EMBER_ZCL_HUE_MOVE_MODE_UP   = 1,
    EMBER_ZCL_HUE_MOVE_MODE_DOWN = 3,
};

// Enum for HueStepMode
enum EmberAfHueStepMode : uint8_t
{
    EMBER_ZCL_HUE_STEP_MODE_UP   = 1,
    EMBER_ZCL_HUE_STEP_MODE_DOWN = 3,
};

// Enum for IdentifyEffectIdentifier
enum EmberAfIdentifyEffectIdentifier : uint8_t
{
    EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_BLINK          = 0,
    EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_BREATHE        = 1,
    EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_OKAY           = 2,
    EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_CHANNEL_CHANGE = 11,
    EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_FINISH_EFFECT  = 254,
    EMBER_ZCL_IDENTIFY_EFFECT_IDENTIFIER_STOP_EFFECT    = 255,
};

// Enum for IdentifyEffectVariant
enum EmberAfIdentifyEffectVariant : uint8_t
{
    EMBER_ZCL_IDENTIFY_EFFECT_VARIANT_DEFAULT = 0,
};

// Enum for IdentifyIdentifyType
enum EmberAfIdentifyIdentifyType : uint8_t
{
    EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_NONE          = 0,
    EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_VISIBLE_LIGHT = 1,
    EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_VISIBLE_LED   = 2,
    EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_AUDIBLE_BEEP  = 3,
    EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_DISPLAY       = 4,
    EMBER_ZCL_IDENTIFY_IDENTIFY_TYPE_ACTUATOR      = 5,
};

// Enum for InterfaceType
enum EmberAfInterfaceType : uint8_t
{
    EMBER_ZCL_INTERFACE_TYPE_UNSPECIFIED = 0,
    EMBER_ZCL_INTERFACE_TYPE_WI_FI       = 1,
    EMBER_ZCL_INTERFACE_TYPE_ETHERNET    = 2,
    EMBER_ZCL_INTERFACE_TYPE_CELLULAR    = 3,
    EMBER_ZCL_INTERFACE_TYPE_THREAD      = 4,
};

// Enum for KeypadLockout
enum EmberAfKeypadLockout : uint8_t
{
    EMBER_ZCL_KEYPAD_LOCKOUT_NO_LOCKOUT          = 0,
    EMBER_ZCL_KEYPAD_LOCKOUT_LEVEL_ONE_LOCKOUT   = 1,
    EMBER_ZCL_KEYPAD_LOCKOUT_LEVEL_TWO_LOCKOUT   = 2,
    EMBER_ZCL_KEYPAD_LOCKOUT_LEVEL_THREE_LOCKOUT = 3,
    EMBER_ZCL_KEYPAD_LOCKOUT_LEVEL_FOUR_LOCKOUT  = 4,
    EMBER_ZCL_KEYPAD_LOCKOUT_LEVELFIVE_LOCKOUT   = 5,
};

// Enum for LevelControlOptions
enum EmberAfLevelControlOptions : uint8_t
{
    EMBER_ZCL_LEVEL_CONTROL_OPTIONS_EXECUTE_IF_OFF             = 1,
    EMBER_ZCL_LEVEL_CONTROL_OPTIONS_COUPLE_COLOR_TEMP_TO_LEVEL = 2,
};

// Enum for MoveMode
enum EmberAfMoveMode : uint8_t
{
    EMBER_ZCL_MOVE_MODE_UP   = 0,
    EMBER_ZCL_MOVE_MODE_DOWN = 1,
};

// Enum for NetworkFaultType
enum EmberAfNetworkFaultType : uint8_t
{
    EMBER_ZCL_NETWORK_FAULT_TYPE_UNSPECIFIED       = 0,
    EMBER_ZCL_NETWORK_FAULT_TYPE_HARDWARE_FAILURE  = 1,
    EMBER_ZCL_NETWORK_FAULT_TYPE_NETWORK_JAMMED    = 2,
    EMBER_ZCL_NETWORK_FAULT_TYPE_CONNECTION_FAILED = 3,
};

// Enum for OnOffDelayedAllOffEffectVariant
enum EmberAfOnOffDelayedAllOffEffectVariant : uint8_t
{
    EMBER_ZCL_ON_OFF_DELAYED_ALL_OFF_EFFECT_VARIANT_FADE_TO_OFF_IN_0P8_SECONDS                                        = 0,
    EMBER_ZCL_ON_OFF_DELAYED_ALL_OFF_EFFECT_VARIANT_NO_FADE                                                           = 1,
    EMBER_ZCL_ON_OFF_DELAYED_ALL_OFF_EFFECT_VARIANT_50_PERCENT_DIM_DOWN_IN_0P8_SECONDS_THEN_FADE_TO_OFF_IN_12_SECONDS = 2,
};

// Enum for OnOffDyingLightEffectVariant
enum EmberAfOnOffDyingLightEffectVariant : uint8_t
{
    EMBER_ZCL_ON_OFF_DYING_LIGHT_EFFECT_VARIANT_20_PERCENTER_DIM_UP_IN_0P5_SECONDS_THEN_FADE_TO_OFF_IN_1_SECOND = 0,
};

// Enum for OnOffEffectIdentifier
enum EmberAfOnOffEffectIdentifier : uint8_t
{
    EMBER_ZCL_ON_OFF_EFFECT_IDENTIFIER_DELAYED_ALL_OFF = 0,
    EMBER_ZCL_ON_OFF_EFFECT_IDENTIFIER_DYING_LIGHT     = 1,
};

// Enum for PHYRateType
enum EmberAfPHYRateType : uint8_t
{
    EMBER_ZCL_PHY_RATE_TYPE_10_M   = 0,
    EMBER_ZCL_PHY_RATE_TYPE_100_M  = 1,
    EMBER_ZCL_PHY_RATE_TYPE_1000_M = 2,
    EMBER_ZCL_PHY_RATE_TYPE_2__5_G = 3,
    EMBER_ZCL_PHY_RATE_TYPE_5_G    = 4,
    EMBER_ZCL_PHY_RATE_TYPE_10_G   = 5,
    EMBER_ZCL_PHY_RATE_TYPE_40_G   = 6,
    EMBER_ZCL_PHY_RATE_TYPE_100_G  = 7,
    EMBER_ZCL_PHY_RATE_TYPE_200_G  = 8,
    EMBER_ZCL_PHY_RATE_TYPE_400_G  = 9,
};

// Enum for RadioFaultType
enum EmberAfRadioFaultType : uint8_t
{
    EMBER_ZCL_RADIO_FAULT_TYPE_UNSPECIFIED    = 0,
    EMBER_ZCL_RADIO_FAULT_TYPE_WI_FI_FAULT    = 1,
    EMBER_ZCL_RADIO_FAULT_TYPE_CELLULAR_FAULT = 2,
    EMBER_ZCL_RADIO_FAULT_TYPE_THREAD_FAULT   = 3,
    EMBER_ZCL_RADIO_FAULT_TYPE_NFC_FAULT      = 4,
    EMBER_ZCL_RADIO_FAULT_TYPE_BLE_FAULT      = 5,
    EMBER_ZCL_RADIO_FAULT_TYPE_ETHERNET_FAULT = 6,
};

// Enum for RoutingRole
enum EmberAfRoutingRole : uint8_t
{
    EMBER_ZCL_ROUTING_ROLE_UNSPECIFIED       = 0,
    EMBER_ZCL_ROUTING_ROLE_UNASSIGNED        = 1,
    EMBER_ZCL_ROUTING_ROLE_SLEEPY_END_DEVICE = 2,
    EMBER_ZCL_ROUTING_ROLE_END_DEVICE        = 3,
    EMBER_ZCL_ROUTING_ROLE_REED              = 4,
    EMBER_ZCL_ROUTING_ROLE_ROUTER            = 5,
    EMBER_ZCL_ROUTING_ROLE_LEADER            = 6,
};

// Enum for SaturationMoveMode
enum EmberAfSaturationMoveMode : uint8_t
{
    EMBER_ZCL_SATURATION_MOVE_MODE_STOP = 0,
    EMBER_ZCL_SATURATION_MOVE_MODE_UP   = 1,
    EMBER_ZCL_SATURATION_MOVE_MODE_DOWN = 3,
};

// Enum for SaturationStepMode
enum EmberAfSaturationStepMode : uint8_t
{
    EMBER_ZCL_SATURATION_STEP_MODE_UP   = 1,
    EMBER_ZCL_SATURATION_STEP_MODE_DOWN = 3,
};

// Enum for SecurityType
enum EmberAfSecurityType : uint8_t
{
    EMBER_ZCL_SECURITY_TYPE_UNSPECIFIED = 0,
    EMBER_ZCL_SECURITY_TYPE_NONE        = 1,
    EMBER_ZCL_SECURITY_TYPE_WEP         = 2,
    EMBER_ZCL_SECURITY_TYPE_WPA         = 3,
    EMBER_ZCL_SECURITY_TYPE_WPA2        = 4,
    EMBER_ZCL_SECURITY_TYPE_WPA3        = 5,
};

// Enum for SetpointAdjustMode
enum EmberAfSetpointAdjustMode : uint8_t
{
    EMBER_ZCL_SETPOINT_ADJUST_MODE_HEAT_SETPOINT           = 0,
    EMBER_ZCL_SETPOINT_ADJUST_MODE_COOL_SETPOINT           = 1,
    EMBER_ZCL_SETPOINT_ADJUST_MODE_HEAT_AND_COOL_SETPOINTS = 2,
};

// Enum for StartUpOnOffValue
enum EmberAfStartUpOnOffValue : uint8_t
{
    EMBER_ZCL_START_UP_ON_OFF_VALUE_SET_TO_OFF    = 0,
    EMBER_ZCL_START_UP_ON_OFF_VALUE_SET_TO_ON     = 1,
    EMBER_ZCL_START_UP_ON_OFF_VALUE_SET_TO_TOGGLE = 2,
};

// Enum for StatusCode
enum EmberAfStatusCode : uint8_t
{
    EMBER_ZCL_STATUS_CODE_BUSY                 = 2,
    EMBER_ZCL_STATUS_CODE_PAKE_PARAMETER_ERROR = 3,
    EMBER_ZCL_STATUS_CODE_WINDOW_NOT_OPEN      = 4,
};

// Enum for StepMode
enum EmberAfStepMode : uint8_t
{
    EMBER_ZCL_STEP_MODE_UP   = 0,
    EMBER_ZCL_STEP_MODE_DOWN = 1,
};

// Enum for TemperatureDisplayMode
enum EmberAfTemperatureDisplayMode : uint8_t
{
    EMBER_ZCL_TEMPERATURE_DISPLAY_MODE_CELSIUS    = 0,
    EMBER_ZCL_TEMPERATURE_DISPLAY_MODE_FAHRENHEIT = 1,
};

// Enum for WiFiVersionType
enum EmberAfWiFiVersionType : uint8_t
{
    EMBER_ZCL_WI_FI_VERSION_TYPE_802__11A  = 0,
    EMBER_ZCL_WI_FI_VERSION_TYPE_802__11B  = 1,
    EMBER_ZCL_WI_FI_VERSION_TYPE_802__11G  = 2,
    EMBER_ZCL_WI_FI_VERSION_TYPE_802__11N  = 3,
    EMBER_ZCL_WI_FI_VERSION_TYPE_802__11AC = 4,
    EMBER_ZCL_WI_FI_VERSION_TYPE_802__11AX = 5,
};

#define EMBER_AF_ALARM_MASK_GENERAL_HW_FAULT (1)
#define EMBER_AF_ALARM_MASK_GENERAL_HW_FAULT_OFFSET (0)
#define EMBER_AF_ALARM_MASK_GENERAL_SW_FAULT (2)
#define EMBER_AF_ALARM_MASK_GENERAL_SW_FAULT_OFFSET (1)
#define EMBER_AF_APPLICATION_LAUNCHER_FEATURE_APPLICATION_PLATFORM (1)
#define EMBER_AF_APPLICATION_LAUNCHER_FEATURE_APPLICATION_PLATFORM_OFFSET (0)
#define EMBER_AF_AUDIO_OUTPUT_FEATURE_NAME_UPDATES (1)
#define EMBER_AF_AUDIO_OUTPUT_FEATURE_NAME_UPDATES_OFFSET (0)
#define EMBER_AF_BALLAST_STATUS_NON_OPERATIONAL (1)
#define EMBER_AF_BALLAST_STATUS_NON_OPERATIONAL_OFFSET (0)
#define EMBER_AF_BALLAST_STATUS_LAMP_NOT_IN_SOCKET (2)
#define EMBER_AF_BALLAST_STATUS_LAMP_NOT_IN_SOCKET_OFFSET (1)
#define EMBER_AF_BARRIER_CONTROL_CAPABILITIES_PARTIAL_BARRIER (1)
#define EMBER_AF_BARRIER_CONTROL_CAPABILITIES_PARTIAL_BARRIER_OFFSET (0)
#define EMBER_AF_BARRIER_CONTROL_SAFETY_STATUS_REMOTE_LOCKOUT (1)
#define EMBER_AF_BARRIER_CONTROL_SAFETY_STATUS_REMOTE_LOCKOUT_OFFSET (0)
#define EMBER_AF_BARRIER_CONTROL_SAFETY_STATUS_TEMPER_DETECTED (2)
#define EMBER_AF_BARRIER_CONTROL_SAFETY_STATUS_TEMPER_DETECTED_OFFSET (1)
#define EMBER_AF_BARRIER_CONTROL_SAFETY_STATUS_FAILED_COMMUNICATION (4)
#define EMBER_AF_BARRIER_CONTROL_SAFETY_STATUS_FAILED_COMMUNICATION_OFFSET (2)
#define EMBER_AF_BARRIER_CONTROL_SAFETY_STATUS_POSITION_FAILURE (8)
#define EMBER_AF_BARRIER_CONTROL_SAFETY_STATUS_POSITION_FAILURE_OFFSET (3)
#define EMBER_AF_BATTERY_ALARM_MASK_VOLTAGE_TOO_LOW (1)
#define EMBER_AF_BATTERY_ALARM_MASK_VOLTAGE_TOO_LOW_OFFSET (0)
#define EMBER_AF_BITMAP16_MASK_MAP_MASK_VAL1 (1)
#define EMBER_AF_BITMAP16_MASK_MAP_MASK_VAL1_OFFSET (0)
#define EMBER_AF_BITMAP16_MASK_MAP_MASK_VAL2 (2)
#define EMBER_AF_BITMAP16_MASK_MAP_MASK_VAL2_OFFSET (1)
#define EMBER_AF_BITMAP16_MASK_MAP_MASK_VAL3 (4)
#define EMBER_AF_BITMAP16_MASK_MAP_MASK_VAL3_OFFSET (2)
#define EMBER_AF_BITMAP16_MASK_MAP_MASK_VAL4 (16384)
#define EMBER_AF_BITMAP16_MASK_MAP_MASK_VAL4_OFFSET (14)
#define EMBER_AF_BITMAP32_MASK_MAP_MASK_VAL1 (1)
#define EMBER_AF_BITMAP32_MASK_MAP_MASK_VAL1_OFFSET (0)
#define EMBER_AF_BITMAP32_MASK_MAP_MASK_VAL2 (2)
#define EMBER_AF_BITMAP32_MASK_MAP_MASK_VAL2_OFFSET (1)
#define EMBER_AF_BITMAP32_MASK_MAP_MASK_VAL3 (4)
#define EMBER_AF_BITMAP32_MASK_MAP_MASK_VAL3_OFFSET (2)
#define EMBER_AF_BITMAP32_MASK_MAP_MASK_VAL4 (1073741824)
#define EMBER_AF_BITMAP32_MASK_MAP_MASK_VAL4_OFFSET (30)
#define EMBER_AF_BITMAP64_MASK_MAP_MASK_VAL1 (1)
#define EMBER_AF_BITMAP64_MASK_MAP_MASK_VAL1_OFFSET (0)
#define EMBER_AF_BITMAP64_MASK_MAP_MASK_VAL2 (2)
#define EMBER_AF_BITMAP64_MASK_MAP_MASK_VAL2_OFFSET (1)
#define EMBER_AF_BITMAP64_MASK_MAP_MASK_VAL3 (4)
#define EMBER_AF_BITMAP64_MASK_MAP_MASK_VAL3_OFFSET (2)
#define EMBER_AF_BITMAP64_MASK_MAP_MASK_VAL4 (4611686018427388000)
#define EMBER_AF_BITMAP64_MASK_MAP_MASK_VAL4_OFFSET (62)
#define EMBER_AF_BITMAP8_MASK_MAP_MASK_VAL1 (1)
#define EMBER_AF_BITMAP8_MASK_MAP_MASK_VAL1_OFFSET (0)
#define EMBER_AF_BITMAP8_MASK_MAP_MASK_VAL2 (2)
#define EMBER_AF_BITMAP8_MASK_MAP_MASK_VAL2_OFFSET (1)
#define EMBER_AF_BITMAP8_MASK_MAP_MASK_VAL3 (4)
#define EMBER_AF_BITMAP8_MASK_MAP_MASK_VAL3_OFFSET (2)
#define EMBER_AF_BITMAP8_MASK_MAP_MASK_VAL4 (64)
#define EMBER_AF_BITMAP8_MASK_MAP_MASK_VAL4_OFFSET (6)
#define EMBER_AF_CHANNEL_FEATURE_CHANNEL_LIST (1)
#define EMBER_AF_CHANNEL_FEATURE_CHANNEL_LIST_OFFSET (0)
#define EMBER_AF_CHANNEL_FEATURE_LINEUP_INFO (2)
#define EMBER_AF_CHANNEL_FEATURE_LINEUP_INFO_OFFSET (1)
#define EMBER_AF_COLOR_CAPABILITIES_HUE_SATURATION_SUPPORTED (1)
#define EMBER_AF_COLOR_CAPABILITIES_HUE_SATURATION_SUPPORTED_OFFSET (0)
#define EMBER_AF_COLOR_CAPABILITIES_ENHANCED_HUE_SUPPORTED (2)
#define EMBER_AF_COLOR_CAPABILITIES_ENHANCED_HUE_SUPPORTED_OFFSET (1)
#define EMBER_AF_COLOR_CAPABILITIES_COLOR_LOOP_SUPPORTED (4)
#define EMBER_AF_COLOR_CAPABILITIES_COLOR_LOOP_SUPPORTED_OFFSET (2)
#define EMBER_AF_COLOR_CAPABILITIES_XY_ATTRIBUTES_SUPPORTED (8)
#define EMBER_AF_COLOR_CAPABILITIES_XY_ATTRIBUTES_SUPPORTED_OFFSET (3)
#define EMBER_AF_COLOR_CAPABILITIES_COLOR_TEMPERATURE_SUPPORTED (16)
#define EMBER_AF_COLOR_CAPABILITIES_COLOR_TEMPERATURE_SUPPORTED_OFFSET (4)
#define EMBER_AF_COLOR_CONTROL_FEATURE_HUE_AND_SATURATION (1)
#define EMBER_AF_COLOR_CONTROL_FEATURE_HUE_AND_SATURATION_OFFSET (0)
#define EMBER_AF_COLOR_CONTROL_FEATURE_ENHANCED_HUE (2)
#define EMBER_AF_COLOR_CONTROL_FEATURE_ENHANCED_HUE_OFFSET (1)
#define EMBER_AF_COLOR_CONTROL_FEATURE_COLOR_LOOP (4)
#define EMBER_AF_COLOR_CONTROL_FEATURE_COLOR_LOOP_OFFSET (2)
#define EMBER_AF_COLOR_CONTROL_FEATURE_XY (8)
#define EMBER_AF_COLOR_CONTROL_FEATURE_XY_OFFSET (3)
#define EMBER_AF_COLOR_CONTROL_FEATURE_COLOR_TEMPERATURE (16)
#define EMBER_AF_COLOR_CONTROL_FEATURE_COLOR_TEMPERATURE_OFFSET (4)
#define EMBER_AF_COLOR_LOOP_UPDATE_FLAGS_UPDATE_ACTION (1)
#define EMBER_AF_COLOR_LOOP_UPDATE_FLAGS_UPDATE_ACTION_OFFSET (0)
#define EMBER_AF_COLOR_LOOP_UPDATE_FLAGS_UPDATE_DIRECTION (2)
#define EMBER_AF_COLOR_LOOP_UPDATE_FLAGS_UPDATE_DIRECTION_OFFSET (1)
#define EMBER_AF_COLOR_LOOP_UPDATE_FLAGS_UPDATE_TIME (4)
#define EMBER_AF_COLOR_LOOP_UPDATE_FLAGS_UPDATE_TIME_OFFSET (2)
#define EMBER_AF_COLOR_LOOP_UPDATE_FLAGS_UPDATE_START_HUE (8)
#define EMBER_AF_COLOR_LOOP_UPDATE_FLAGS_UPDATE_START_HUE_OFFSET (3)
#define EMBER_AF_COMMAND_BITS_INSTANT_ACTION (1)
#define EMBER_AF_COMMAND_BITS_INSTANT_ACTION_OFFSET (0)
#define EMBER_AF_COMMAND_BITS_INSTANT_ACTION_WITH_TRANSITION (2)
#define EMBER_AF_COMMAND_BITS_INSTANT_ACTION_WITH_TRANSITION_OFFSET (1)
#define EMBER_AF_COMMAND_BITS_START_ACTION (4)
#define EMBER_AF_COMMAND_BITS_START_ACTION_OFFSET (2)
#define EMBER_AF_COMMAND_BITS_START_ACTION_WITH_DURATION (8)
#define EMBER_AF_COMMAND_BITS_START_ACTION_WITH_DURATION_OFFSET (3)
#define EMBER_AF_COMMAND_BITS_STOP_ACTION (16)
#define EMBER_AF_COMMAND_BITS_STOP_ACTION_OFFSET (4)
#define EMBER_AF_COMMAND_BITS_PAUSE_ACTION (32)
#define EMBER_AF_COMMAND_BITS_PAUSE_ACTION_OFFSET (5)
#define EMBER_AF_COMMAND_BITS_PAUSE_ACTION_WITH_DURATION (64)
#define EMBER_AF_COMMAND_BITS_PAUSE_ACTION_WITH_DURATION_OFFSET (6)
#define EMBER_AF_COMMAND_BITS_RESUME_ACTION (128)
#define EMBER_AF_COMMAND_BITS_RESUME_ACTION_OFFSET (7)
#define EMBER_AF_COMMAND_BITS_ENABLE_ACTION (256)
#define EMBER_AF_COMMAND_BITS_ENABLE_ACTION_OFFSET (8)
#define EMBER_AF_COMMAND_BITS_ENABLE_ACTION_WITH_DURATION (512)
#define EMBER_AF_COMMAND_BITS_ENABLE_ACTION_WITH_DURATION_OFFSET (9)
#define EMBER_AF_COMMAND_BITS_DISABLE_ACTION (1024)
#define EMBER_AF_COMMAND_BITS_DISABLE_ACTION_OFFSET (10)
#define EMBER_AF_COMMAND_BITS_DISABLE_ACTION_WITH_DURATION (2048)
#define EMBER_AF_COMMAND_BITS_DISABLE_ACTION_WITH_DURATION_OFFSET (11)
#define EMBER_AF_CONFIG_STATUS_OPERATIONAL (1)
#define EMBER_AF_CONFIG_STATUS_OPERATIONAL_OFFSET (0)
#define EMBER_AF_CONFIG_STATUS_ONLINE_RESERVED (2)
#define EMBER_AF_CONFIG_STATUS_ONLINE_RESERVED_OFFSET (1)
#define EMBER_AF_CONFIG_STATUS_LIFT_MOVEMENT_REVERSED (4)
#define EMBER_AF_CONFIG_STATUS_LIFT_MOVEMENT_REVERSED_OFFSET (2)
#define EMBER_AF_CONFIG_STATUS_LIFT_POSITION_AWARE (8)
#define EMBER_AF_CONFIG_STATUS_LIFT_POSITION_AWARE_OFFSET (3)
#define EMBER_AF_CONFIG_STATUS_TILT_POSITION_AWARE (16)
#define EMBER_AF_CONFIG_STATUS_TILT_POSITION_AWARE_OFFSET (4)
#define EMBER_AF_CONFIG_STATUS_LIFT_ENCODER_CONTROLLED (32)
#define EMBER_AF_CONFIG_STATUS_LIFT_ENCODER_CONTROLLED_OFFSET (5)
#define EMBER_AF_CONFIG_STATUS_TILT_ENCODER_CONTROLLED (64)
#define EMBER_AF_CONFIG_STATUS_TILT_ENCODER_CONTROLLED_OFFSET (6)
#define EMBER_AF_CONTENT_LAUNCHER_FEATURE_CONTENT_SEARCH (1)
#define EMBER_AF_CONTENT_LAUNCHER_FEATURE_CONTENT_SEARCH_OFFSET (0)
#define EMBER_AF_CONTENT_LAUNCHER_FEATURE_URL_PLAYBACK (2)
#define EMBER_AF_CONTENT_LAUNCHER_FEATURE_URL_PLAYBACK_OFFSET (1)
#define EMBER_AF_DAY_OF_WEEK_SUNDAY (1)
#define EMBER_AF_DAY_OF_WEEK_SUNDAY_OFFSET (0)
#define EMBER_AF_DAY_OF_WEEK_MONDAY (2)
#define EMBER_AF_DAY_OF_WEEK_MONDAY_OFFSET (1)
#define EMBER_AF_DAY_OF_WEEK_TUESDAY (4)
#define EMBER_AF_DAY_OF_WEEK_TUESDAY_OFFSET (2)
#define EMBER_AF_DAY_OF_WEEK_WEDNESDAY (8)
#define EMBER_AF_DAY_OF_WEEK_WEDNESDAY_OFFSET (3)
#define EMBER_AF_DAY_OF_WEEK_THURSDAY (16)
#define EMBER_AF_DAY_OF_WEEK_THURSDAY_OFFSET (4)
#define EMBER_AF_DAY_OF_WEEK_FRIDAY (32)
#define EMBER_AF_DAY_OF_WEEK_FRIDAY_OFFSET (5)
#define EMBER_AF_DAY_OF_WEEK_SATURDAY (64)
#define EMBER_AF_DAY_OF_WEEK_SATURDAY_OFFSET (6)
#define EMBER_AF_DAY_OF_WEEK_AWAY_OR_VACATION (128)
#define EMBER_AF_DAY_OF_WEEK_AWAY_OR_VACATION_OFFSET (7)
#define EMBER_AF_DEVICE_TEMP_ALARM_MASK_TOO_LOW (1)
#define EMBER_AF_DEVICE_TEMP_ALARM_MASK_TOO_LOW_OFFSET (0)
#define EMBER_AF_DEVICE_TEMP_ALARM_MASK_TOO_HIGH (2)
#define EMBER_AF_DEVICE_TEMP_ALARM_MASK_TOO_HIGH_OFFSET (1)
#define EMBER_AF_DL_CREDENTIAL_RULE_MASK_SINGLE (1)
#define EMBER_AF_DL_CREDENTIAL_RULE_MASK_SINGLE_OFFSET (0)
#define EMBER_AF_DL_CREDENTIAL_RULE_MASK_DUAL (2)
#define EMBER_AF_DL_CREDENTIAL_RULE_MASK_DUAL_OFFSET (1)
#define EMBER_AF_DL_CREDENTIAL_RULE_MASK_TRI (4)
#define EMBER_AF_DL_CREDENTIAL_RULE_MASK_TRI_OFFSET (2)
#define EMBER_AF_DL_CREDENTIAL_RULES_SUPPORT_SINGLE (1)
#define EMBER_AF_DL_CREDENTIAL_RULES_SUPPORT_SINGLE_OFFSET (0)
#define EMBER_AF_DL_CREDENTIAL_RULES_SUPPORT_DUAL (2)
#define EMBER_AF_DL_CREDENTIAL_RULES_SUPPORT_DUAL_OFFSET (1)
#define EMBER_AF_DL_CREDENTIAL_RULES_SUPPORT_TRI (4)
#define EMBER_AF_DL_CREDENTIAL_RULES_SUPPORT_TRI_OFFSET (2)
#define EMBER_AF_DL_DAYS_MASK_MAP_SUNDAY (1)
#define EMBER_AF_DL_DAYS_MASK_MAP_SUNDAY_OFFSET (0)
#define EMBER_AF_DL_DAYS_MASK_MAP_MONDAY (2)
#define EMBER_AF_DL_DAYS_MASK_MAP_MONDAY_OFFSET (1)
#define EMBER_AF_DL_DAYS_MASK_MAP_TUESDAY (4)
#define EMBER_AF_DL_DAYS_MASK_MAP_TUESDAY_OFFSET (2)
#define EMBER_AF_DL_DAYS_MASK_MAP_WEDNESDAY (8)
#define EMBER_AF_DL_DAYS_MASK_MAP_WEDNESDAY_OFFSET (3)
#define EMBER_AF_DL_DAYS_MASK_MAP_THURSDAY (16)
#define EMBER_AF_DL_DAYS_MASK_MAP_THURSDAY_OFFSET (4)
#define EMBER_AF_DL_DAYS_MASK_MAP_FRIDAY (32)
#define EMBER_AF_DL_DAYS_MASK_MAP_FRIDAY_OFFSET (5)
#define EMBER_AF_DL_DAYS_MASK_MAP_SATURDAY (64)
#define EMBER_AF_DL_DAYS_MASK_MAP_SATURDAY_OFFSET (6)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_ENABLE_LOCAL_PROGRAMMING_ENABLED (1)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_ENABLE_LOCAL_PROGRAMMING_ENABLED_OFFSET (0)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_KEYPAD_INTERFACE_DEFAULT_ACCESS_ENABLED (2)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_KEYPAD_INTERFACE_DEFAULT_ACCESS_ENABLED_OFFSET (1)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_REMOTE_INTERFACE_DEFAULT_ACCESS_IS_ENABLED (4)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_REMOTE_INTERFACE_DEFAULT_ACCESS_IS_ENABLED_OFFSET (2)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_SOUND_ENABLED (32)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_SOUND_ENABLED_OFFSET (5)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_AUTO_RELOCK_TIME_SET (64)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_AUTO_RELOCK_TIME_SET_OFFSET (6)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_LED_SETTINGS_SET (128)
#define EMBER_AF_DL_DEFAULT_CONFIGURATION_REGISTER_LED_SETTINGS_SET_OFFSET (7)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_UNKNOWN (1)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_UNKNOWN_OFFSET (0)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_LOCK (2)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_LOCK_OFFSET (1)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_UNLOCK (4)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_UNLOCK_OFFSET (2)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_LOCK_INVALID_PIN (8)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_LOCK_INVALID_PIN_OFFSET (3)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_LOCK_INVALID_SCHEDULE (16)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_LOCK_INVALID_SCHEDULE_OFFSET (4)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_UNLOCK_INVALID_CODE (32)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_UNLOCK_INVALID_CODE_OFFSET (5)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_UNLOCK_INVALID_SCHEDULE (64)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_UNLOCK_INVALID_SCHEDULE_OFFSET (6)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_NON_ACCESS_USER_OP_EVENT (128)
#define EMBER_AF_DL_KEYPAD_OPERATION_EVENT_MASK_NON_ACCESS_USER_OP_EVENT_OFFSET (7)
#define EMBER_AF_DL_KEYPAD_PROGRAMMING_EVENT_MASK_UNKNOWN (1)
#define EMBER_AF_DL_KEYPAD_PROGRAMMING_EVENT_MASK_UNKNOWN_OFFSET (0)
#define EMBER_AF_DL_KEYPAD_PROGRAMMING_EVENT_MASK_PROGRAMMING_PIN_CHANGED (2)
#define EMBER_AF_DL_KEYPAD_PROGRAMMING_EVENT_MASK_PROGRAMMING_PIN_CHANGED_OFFSET (1)
#define EMBER_AF_DL_KEYPAD_PROGRAMMING_EVENT_MASK_PIN_ADDED (4)
#define EMBER_AF_DL_KEYPAD_PROGRAMMING_EVENT_MASK_PIN_ADDED_OFFSET (2)
#define EMBER_AF_DL_KEYPAD_PROGRAMMING_EVENT_MASK_PIN_CLEARED (8)
#define EMBER_AF_DL_KEYPAD_PROGRAMMING_EVENT_MASK_PIN_CLEARED_OFFSET (3)
#define EMBER_AF_DL_KEYPAD_PROGRAMMING_EVENT_MASK_PIN_CHANGED (16)
#define EMBER_AF_DL_KEYPAD_PROGRAMMING_EVENT_MASK_PIN_CHANGED_OFFSET (4)
#define EMBER_AF_DL_LOCAL_PROGRAMMING_FEATURES_ADD_USERS_CREDENTIALS_SCHEDULES_LOCALLY (1)
#define EMBER_AF_DL_LOCAL_PROGRAMMING_FEATURES_ADD_USERS_CREDENTIALS_SCHEDULES_LOCALLY_OFFSET (0)
#define EMBER_AF_DL_LOCAL_PROGRAMMING_FEATURES_MODIFY_USERS_CREDENTIALS_SCHEDULES_LOCALLY (2)
#define EMBER_AF_DL_LOCAL_PROGRAMMING_FEATURES_MODIFY_USERS_CREDENTIALS_SCHEDULES_LOCALLY_OFFSET (1)
#define EMBER_AF_DL_LOCAL_PROGRAMMING_FEATURES_CLEAR_USERS_CREDENTIALS_SCHEDULES_LOCALLY (4)
#define EMBER_AF_DL_LOCAL_PROGRAMMING_FEATURES_CLEAR_USERS_CREDENTIALS_SCHEDULES_LOCALLY_OFFSET (2)
#define EMBER_AF_DL_LOCAL_PROGRAMMING_FEATURES_ADJUST_LOCK_SETTINGS_LOCALLY (8)
#define EMBER_AF_DL_LOCAL_PROGRAMMING_FEATURES_ADJUST_LOCK_SETTINGS_LOCALLY_OFFSET (3)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_UNKNOWN (1)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_UNKNOWN_OFFSET (0)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_THUMBTURN_LOCK (2)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_THUMBTURN_LOCK_OFFSET (1)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_THUMBTURN_UNLOCK (4)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_THUMBTURN_UNLOCK_OFFSET (2)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_ONE_TOUCH_LOCK (8)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_ONE_TOUCH_LOCK_OFFSET (3)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_KEY_LOCK (16)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_KEY_LOCK_OFFSET (4)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_KEY_UNLOCK (32)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_KEY_UNLOCK_OFFSET (5)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_AUTO_LOCK (64)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_AUTO_LOCK_OFFSET (6)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_SCHEDULE_LOCK (128)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_SCHEDULE_LOCK_OFFSET (7)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_SCHEDULE_UNLOCK (256)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_SCHEDULE_UNLOCK_OFFSET (8)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_MANUAL_LOCK (512)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_MANUAL_LOCK_OFFSET (9)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_MANUAL_UNLOCK (1024)
#define EMBER_AF_DL_MANUAL_OPERATION_EVENT_MASK_MANUAL_UNLOCK_OFFSET (10)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_UNKNOWN (1)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_UNKNOWN_OFFSET (0)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_LOCK (2)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_LOCK_OFFSET (1)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_UNLOCK (4)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_UNLOCK_OFFSET (2)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_LOCK_INVALID_RFID (8)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_LOCK_INVALID_RFID_OFFSET (3)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_LOCK_INVALID_SCHEDULE (16)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_LOCK_INVALID_SCHEDULE_OFFSET (4)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_UNLOCK_INVALID_RFID (32)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_UNLOCK_INVALID_RFID_OFFSET (5)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_UNLOCK_INVALID_SCHEDULE (64)
#define EMBER_AF_DL_RFID_OPERATION_EVENT_MASK_UNLOCK_INVALID_SCHEDULE_OFFSET (6)
#define EMBER_AF_DL_RFID_PROGRAMMING_EVENT_MASK_UNKNOWN (1)
#define EMBER_AF_DL_RFID_PROGRAMMING_EVENT_MASK_UNKNOWN_OFFSET (0)
#define EMBER_AF_DL_RFID_PROGRAMMING_EVENT_MASK_RFID_CODE_ADDED (32)
#define EMBER_AF_DL_RFID_PROGRAMMING_EVENT_MASK_RFID_CODE_ADDED_OFFSET (5)
#define EMBER_AF_DL_RFID_PROGRAMMING_EVENT_MASK_RFID_CODE_CLEARED (64)
#define EMBER_AF_DL_RFID_PROGRAMMING_EVENT_MASK_RFID_CODE_CLEARED_OFFSET (6)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_UNKNOWN (1)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_UNKNOWN_OFFSET (0)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_LOCK (2)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_LOCK_OFFSET (1)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_UNLOCK (4)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_UNLOCK_OFFSET (2)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_LOCK_INVALID_CODE (8)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_LOCK_INVALID_CODE_OFFSET (3)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_LOCK_INVALID_SCHEDULE (16)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_LOCK_INVALID_SCHEDULE_OFFSET (4)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_UNLOCK_INVALID_CODE (32)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_UNLOCK_INVALID_CODE_OFFSET (5)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_UNLOCK_INVALID_SCHEDULE (64)
#define EMBER_AF_DL_REMOTE_OPERATION_EVENT_MASK_UNLOCK_INVALID_SCHEDULE_OFFSET (6)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_UNKNOWN (1)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_UNKNOWN_OFFSET (0)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_PROGRAMMING_PIN_CHANGED (2)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_PROGRAMMING_PIN_CHANGED_OFFSET (1)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_PIN_ADDED (4)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_PIN_ADDED_OFFSET (2)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_PIN_CLEARED (8)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_PIN_CLEARED_OFFSET (3)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_PIN_CHANGED (16)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_PIN_CHANGED_OFFSET (4)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_RFID_CODE_ADDED (32)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_RFID_CODE_ADDED_OFFSET (5)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_RFID_CODE_CLEARED (64)
#define EMBER_AF_DL_REMOTE_PROGRAMMING_EVENT_MASK_RFID_CODE_CLEARED_OFFSET (6)
#define EMBER_AF_DL_SUPPORTED_OPERATING_MODES_NORMAL (1)
#define EMBER_AF_DL_SUPPORTED_OPERATING_MODES_NORMAL_OFFSET (0)
#define EMBER_AF_DL_SUPPORTED_OPERATING_MODES_VACATION (2)
#define EMBER_AF_DL_SUPPORTED_OPERATING_MODES_VACATION_OFFSET (1)
#define EMBER_AF_DL_SUPPORTED_OPERATING_MODES_PRIVACY (4)
#define EMBER_AF_DL_SUPPORTED_OPERATING_MODES_PRIVACY_OFFSET (2)
#define EMBER_AF_DL_SUPPORTED_OPERATING_MODES_NO_REMOTE_LOCK_UNLOCK (8)
#define EMBER_AF_DL_SUPPORTED_OPERATING_MODES_NO_REMOTE_LOCK_UNLOCK_OFFSET (3)
#define EMBER_AF_DL_SUPPORTED_OPERATING_MODES_PASSAGE (16)
#define EMBER_AF_DL_SUPPORTED_OPERATING_MODES_PASSAGE_OFFSET (4)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_SUNDAY (1)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_SUNDAY_OFFSET (0)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_MONDAY (2)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_MONDAY_OFFSET (1)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_TUESDAY (4)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_TUESDAY_OFFSET (2)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_WEDNESDAY (8)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_WEDNESDAY_OFFSET (3)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_THURSDAY (16)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_THURSDAY_OFFSET (4)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_FRIDAY (32)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_FRIDAY_OFFSET (5)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_SATURDAY (64)
#define EMBER_AF_DOOR_LOCK_DAY_OF_WEEK_SATURDAY_OFFSET (6)
#define EMBER_AF_DOOR_LOCK_FEATURE_PIN_CREDENTIALS (1)
#define EMBER_AF_DOOR_LOCK_FEATURE_PIN_CREDENTIALS_OFFSET (0)
#define EMBER_AF_DOOR_LOCK_FEATURE_RFID_CREDENTIALS (2)
#define EMBER_AF_DOOR_LOCK_FEATURE_RFID_CREDENTIALS_OFFSET (1)
#define EMBER_AF_DOOR_LOCK_FEATURE_FINGER_CREDENTIALS (4)
#define EMBER_AF_DOOR_LOCK_FEATURE_FINGER_CREDENTIALS_OFFSET (2)
#define EMBER_AF_DOOR_LOCK_FEATURE_LOGGING (8)
#define EMBER_AF_DOOR_LOCK_FEATURE_LOGGING_OFFSET (3)
#define EMBER_AF_DOOR_LOCK_FEATURE_WEEK_DAY_SCHEDULES (16)
#define EMBER_AF_DOOR_LOCK_FEATURE_WEEK_DAY_SCHEDULES_OFFSET (4)
#define EMBER_AF_DOOR_LOCK_FEATURE_DOOR_POSITION_SENSOR (32)
#define EMBER_AF_DOOR_LOCK_FEATURE_DOOR_POSITION_SENSOR_OFFSET (5)
#define EMBER_AF_DOOR_LOCK_FEATURE_FACE_CREDENTIALS (64)
#define EMBER_AF_DOOR_LOCK_FEATURE_FACE_CREDENTIALS_OFFSET (6)
#define EMBER_AF_DOOR_LOCK_FEATURE_CREDENTIALS_OTA (128)
#define EMBER_AF_DOOR_LOCK_FEATURE_CREDENTIALS_OTA_OFFSET (7)
#define EMBER_AF_DOOR_LOCK_FEATURE_USERS_MANAGEMENT (256)
#define EMBER_AF_DOOR_LOCK_FEATURE_USERS_MANAGEMENT_OFFSET (8)
#define EMBER_AF_DOOR_LOCK_FEATURE_NOTIFICATIONS (512)
#define EMBER_AF_DOOR_LOCK_FEATURE_NOTIFICATIONS_OFFSET (9)
#define EMBER_AF_DOOR_LOCK_FEATURE_YEAR_DAY_SCHEDULES (1024)
#define EMBER_AF_DOOR_LOCK_FEATURE_YEAR_DAY_SCHEDULES_OFFSET (10)
#define EMBER_AF_DOOR_LOCK_FEATURE_HOLIDAY_SCHEDULES (2048)
#define EMBER_AF_DOOR_LOCK_FEATURE_HOLIDAY_SCHEDULES_OFFSET (11)
#define EMBER_AF_ENERGY_FORMATTING_NUMBER_OF_DIGITS_TO_THE_RIGHT_OF_THE_DECIMAL_POINT (7)
#define EMBER_AF_ENERGY_FORMATTING_NUMBER_OF_DIGITS_TO_THE_RIGHT_OF_THE_DECIMAL_POINT_OFFSET (0)
#define EMBER_AF_ENERGY_FORMATTING_NUMBER_OF_DIGITS_TO_THE_LEFT_OF_THE_DECIMAL_POINT (120)
#define EMBER_AF_ENERGY_FORMATTING_NUMBER_OF_DIGITS_TO_THE_LEFT_OF_THE_DECIMAL_POINT_OFFSET (3)
#define EMBER_AF_ENERGY_FORMATTING_SUPPRESS_LEADING_ZEROS (128)
#define EMBER_AF_ENERGY_FORMATTING_SUPPRESS_LEADING_ZEROS_OFFSET (7)
#define EMBER_AF_ETHERNET_NETWORK_DIAGNOSTICS_FEATURE_PACKET_COUNTS (1)
#define EMBER_AF_ETHERNET_NETWORK_DIAGNOSTICS_FEATURE_PACKET_COUNTS_OFFSET (0)
#define EMBER_AF_ETHERNET_NETWORK_DIAGNOSTICS_FEATURE_ERROR_COUNTS (2)
#define EMBER_AF_ETHERNET_NETWORK_DIAGNOSTICS_FEATURE_ERROR_COUNTS_OFFSET (1)
#define EMBER_AF_FAN_CONTROL_FEATURE_MULTI_SPEED (1)
#define EMBER_AF_FAN_CONTROL_FEATURE_MULTI_SPEED_OFFSET (0)
#define EMBER_AF_FAN_CONTROL_FEATURE_AUTO (2)
#define EMBER_AF_FAN_CONTROL_FEATURE_AUTO_OFFSET (1)
#define EMBER_AF_FAN_CONTROL_FEATURE_ROCKING (4)
#define EMBER_AF_FAN_CONTROL_FEATURE_ROCKING_OFFSET (2)
#define EMBER_AF_FAN_CONTROL_FEATURE_WIND (8)
#define EMBER_AF_FAN_CONTROL_FEATURE_WIND_OFFSET (3)
#define EMBER_AF_FEATURE_LIFT (1)
#define EMBER_AF_FEATURE_LIFT_OFFSET (0)
#define EMBER_AF_FEATURE_TILT (2)
#define EMBER_AF_FEATURE_TILT_OFFSET (1)
#define EMBER_AF_FEATURE_POSITION_AWARE_LIFT (4)
#define EMBER_AF_FEATURE_POSITION_AWARE_LIFT_OFFSET (2)
#define EMBER_AF_FEATURE_ABSOLUTE_POSITION (8)
#define EMBER_AF_FEATURE_ABSOLUTE_POSITION_OFFSET (3)
#define EMBER_AF_FEATURE_POSITION_AWARE_TILT (16)
#define EMBER_AF_FEATURE_POSITION_AWARE_TILT_OFFSET (4)
#define EMBER_AF_GROUP_CLUSTER_FEATURE_GROUP_NAMES (1)
#define EMBER_AF_GROUP_CLUSTER_FEATURE_GROUP_NAMES_OFFSET (0)
#define EMBER_AF_IAS_ZONE_STATUS_ALARM1 (1)
#define EMBER_AF_IAS_ZONE_STATUS_ALARM1_OFFSET (0)
#define EMBER_AF_IAS_ZONE_STATUS_ALARM2 (2)
#define EMBER_AF_IAS_ZONE_STATUS_ALARM2_OFFSET (1)
#define EMBER_AF_IAS_ZONE_STATUS_TAMPER (4)
#define EMBER_AF_IAS_ZONE_STATUS_TAMPER_OFFSET (2)
#define EMBER_AF_IAS_ZONE_STATUS_BATTERY (8)
#define EMBER_AF_IAS_ZONE_STATUS_BATTERY_OFFSET (3)
#define EMBER_AF_IAS_ZONE_STATUS_SUPERVISION_REPORTS (16)
#define EMBER_AF_IAS_ZONE_STATUS_SUPERVISION_REPORTS_OFFSET (4)
#define EMBER_AF_IAS_ZONE_STATUS_RESTORE_REPORTS (32)
#define EMBER_AF_IAS_ZONE_STATUS_RESTORE_REPORTS_OFFSET (5)
#define EMBER_AF_IAS_ZONE_STATUS_TROUBLE (64)
#define EMBER_AF_IAS_ZONE_STATUS_TROUBLE_OFFSET (6)
#define EMBER_AF_IAS_ZONE_STATUS_AC (128)
#define EMBER_AF_IAS_ZONE_STATUS_AC_OFFSET (7)
#define EMBER_AF_IAS_ZONE_STATUS_TEST (256)
#define EMBER_AF_IAS_ZONE_STATUS_TEST_OFFSET (8)
#define EMBER_AF_IAS_ZONE_STATUS_BATTERY_DEFECT (512)
#define EMBER_AF_IAS_ZONE_STATUS_BATTERY_DEFECT_OFFSET (9)
#define EMBER_AF_KEYPAD_INPUT_FEATURE_NAVIGATION_KEY_CODES (1)
#define EMBER_AF_KEYPAD_INPUT_FEATURE_NAVIGATION_KEY_CODES_OFFSET (0)
#define EMBER_AF_KEYPAD_INPUT_FEATURE_LOCATION_KEYS (2)
#define EMBER_AF_KEYPAD_INPUT_FEATURE_LOCATION_KEYS_OFFSET (1)
#define EMBER_AF_KEYPAD_INPUT_FEATURE_NUMBER_KEYS (4)
#define EMBER_AF_KEYPAD_INPUT_FEATURE_NUMBER_KEYS_OFFSET (2)
#define EMBER_AF_LAMP_ALARM_MODE_LAMP_BURN_HOURS (1)
#define EMBER_AF_LAMP_ALARM_MODE_LAMP_BURN_HOURS_OFFSET (0)
#define EMBER_AF_LEVEL_CONTROL_FEATURE_ON_OFF (1)
#define EMBER_AF_LEVEL_CONTROL_FEATURE_ON_OFF_OFFSET (0)
#define EMBER_AF_LEVEL_CONTROL_FEATURE_LIGHTING (2)
#define EMBER_AF_LEVEL_CONTROL_FEATURE_LIGHTING_OFFSET (1)
#define EMBER_AF_LEVEL_CONTROL_FEATURE_FREQUENCY (4)
#define EMBER_AF_LEVEL_CONTROL_FEATURE_FREQUENCY_OFFSET (2)
#define EMBER_AF_MAINS_ALARM_MASK_VOLTAGE_TOO_LOW (1)
#define EMBER_AF_MAINS_ALARM_MASK_VOLTAGE_TOO_LOW_OFFSET (0)
#define EMBER_AF_MAINS_ALARM_MASK_VOLTAGE_TOO_HIGH (2)
#define EMBER_AF_MAINS_ALARM_MASK_VOLTAGE_TOO_HIGH_OFFSET (1)
#define EMBER_AF_MAINS_ALARM_MASK_MAINS_POWER_SUPPLY_LOST (4)
#define EMBER_AF_MAINS_ALARM_MASK_MAINS_POWER_SUPPLY_LOST_OFFSET (2)
#define EMBER_AF_MEDIA_INPUT_FEATURE_NAME_UPDATES (1)
#define EMBER_AF_MEDIA_INPUT_FEATURE_NAME_UPDATES_OFFSET (0)
#define EMBER_AF_MEDIA_PLAYBACK_FEATURE_ADVANCED_SEEK (1)
#define EMBER_AF_MEDIA_PLAYBACK_FEATURE_ADVANCED_SEEK_OFFSET (0)
#define EMBER_AF_MEDIA_PLAYBACK_FEATURE_VARIABLE_SPEED (2)
#define EMBER_AF_MEDIA_PLAYBACK_FEATURE_VARIABLE_SPEED_OFFSET (1)
#define EMBER_AF_MODE_MOTOR_DIRECTION_REVERSED (1)
#define EMBER_AF_MODE_MOTOR_DIRECTION_REVERSED_OFFSET (0)
#define EMBER_AF_MODE_CALIBRATION_MODE (2)
#define EMBER_AF_MODE_CALIBRATION_MODE_OFFSET (1)
#define EMBER_AF_MODE_MAINTENANCE_MODE (4)
#define EMBER_AF_MODE_MAINTENANCE_MODE_OFFSET (2)
#define EMBER_AF_MODE_LED_FEEDBACK (8)
#define EMBER_AF_MODE_LED_FEEDBACK_OFFSET (3)
#define EMBER_AF_MODE_FOR_SEQUENCE_HEAT_SETPOINT_FIELD_PRESENT (1)
#define EMBER_AF_MODE_FOR_SEQUENCE_HEAT_SETPOINT_FIELD_PRESENT_OFFSET (0)
#define EMBER_AF_MODE_FOR_SEQUENCE_COOL_SETPOINT_FIELD_PRESENT (2)
#define EMBER_AF_MODE_FOR_SEQUENCE_COOL_SETPOINT_FIELD_PRESENT_OFFSET (1)
#define EMBER_AF_MODE_SELECT_FEATURE_DEPONOFF (1)
#define EMBER_AF_MODE_SELECT_FEATURE_DEPONOFF_OFFSET (0)
#define EMBER_AF_NETWORK_COMMISSIONING_FEATURE_WI_FI_NETWORK_INTERFACE (1)
#define EMBER_AF_NETWORK_COMMISSIONING_FEATURE_WI_FI_NETWORK_INTERFACE_OFFSET (0)
#define EMBER_AF_NETWORK_COMMISSIONING_FEATURE_THREAD_NETWORK_INTERFACE (2)
#define EMBER_AF_NETWORK_COMMISSIONING_FEATURE_THREAD_NETWORK_INTERFACE_OFFSET (1)
#define EMBER_AF_NETWORK_COMMISSIONING_FEATURE_ETHERNET_NETWORK_INTERFACE (4)
#define EMBER_AF_NETWORK_COMMISSIONING_FEATURE_ETHERNET_NETWORK_INTERFACE_OFFSET (2)
#define EMBER_AF_OCCUPANCY_OCCUPIED (1)
#define EMBER_AF_OCCUPANCY_OCCUPIED_OFFSET (0)
#define EMBER_AF_OCCUPANCY_SENSOR_TYPE_BITMAP_PIR (1)
#define EMBER_AF_OCCUPANCY_SENSOR_TYPE_BITMAP_PIR_OFFSET (0)
#define EMBER_AF_OCCUPANCY_SENSOR_TYPE_BITMAP_ULTRASONIC (2)
#define EMBER_AF_OCCUPANCY_SENSOR_TYPE_BITMAP_ULTRASONIC_OFFSET (1)
#define EMBER_AF_OCCUPANCY_SENSOR_TYPE_BITMAP_PHYSICAL_CONTACT (4)
#define EMBER_AF_OCCUPANCY_SENSOR_TYPE_BITMAP_PHYSICAL_CONTACT_OFFSET (2)
#define EMBER_AF_ON_OFF_CONTROL_ACCEPT_ONLY_WHEN_ON (1)
#define EMBER_AF_ON_OFF_CONTROL_ACCEPT_ONLY_WHEN_ON_OFFSET (0)
#define EMBER_AF_ON_OFF_FEATURE_LIGHTING (1)
#define EMBER_AF_ON_OFF_FEATURE_LIGHTING_OFFSET (0)
#define EMBER_AF_OPERATIONAL_STATUS_GLOBAL (3)
#define EMBER_AF_OPERATIONAL_STATUS_GLOBAL_OFFSET (0)
#define EMBER_AF_OPERATIONAL_STATUS_LIFT (12)
#define EMBER_AF_OPERATIONAL_STATUS_LIFT_OFFSET (2)
#define EMBER_AF_OPERATIONAL_STATUS_TILT (48)
#define EMBER_AF_OPERATIONAL_STATUS_TILT_OFFSET (4)
#define EMBER_AF_POWER_SOURCE_FEATURE_WIRED (1)
#define EMBER_AF_POWER_SOURCE_FEATURE_WIRED_OFFSET (0)
#define EMBER_AF_POWER_SOURCE_FEATURE_BATTERY (2)
#define EMBER_AF_POWER_SOURCE_FEATURE_BATTERY_OFFSET (1)
#define EMBER_AF_POWER_SOURCE_FEATURE_RECHARGEABLE (4)
#define EMBER_AF_POWER_SOURCE_FEATURE_RECHARGEABLE_OFFSET (2)
#define EMBER_AF_POWER_SOURCE_FEATURE_REPLACEABLE (8)
#define EMBER_AF_POWER_SOURCE_FEATURE_REPLACEABLE_OFFSET (3)
#define EMBER_AF_PRESSURE_FEATURE_EXT (1)
#define EMBER_AF_PRESSURE_FEATURE_EXT_OFFSET (0)
#define EMBER_AF_PUMP_STATUS_DEVICE_FAULT (1)
#define EMBER_AF_PUMP_STATUS_DEVICE_FAULT_OFFSET (0)
#define EMBER_AF_PUMP_STATUS_SUPPLYFAULT (2)
#define EMBER_AF_PUMP_STATUS_SUPPLYFAULT_OFFSET (1)
#define EMBER_AF_PUMP_STATUS_SPEED_LOW (4)
#define EMBER_AF_PUMP_STATUS_SPEED_LOW_OFFSET (2)
#define EMBER_AF_PUMP_STATUS_SPEED_HIGH (8)
#define EMBER_AF_PUMP_STATUS_SPEED_HIGH_OFFSET (3)
#define EMBER_AF_PUMP_STATUS_LOCAL_OVERRIDE (16)
#define EMBER_AF_PUMP_STATUS_LOCAL_OVERRIDE_OFFSET (4)
#define EMBER_AF_PUMP_STATUS_RUNNING (32)
#define EMBER_AF_PUMP_STATUS_RUNNING_OFFSET (5)
#define EMBER_AF_PUMP_STATUS_REMOTE_PRESSURE (64)
#define EMBER_AF_PUMP_STATUS_REMOTE_PRESSURE_OFFSET (6)
#define EMBER_AF_PUMP_STATUS_REMOTE_FLOW (128)
#define EMBER_AF_PUMP_STATUS_REMOTE_FLOW_OFFSET (7)
#define EMBER_AF_PUMP_STATUS_REMOTE_TEMPERATURE (256)
#define EMBER_AF_PUMP_STATUS_REMOTE_TEMPERATURE_OFFSET (8)
#define EMBER_AF_ROCK_SUPPORT_MASK_ROCK_LEFT_RIGHT (1)
#define EMBER_AF_ROCK_SUPPORT_MASK_ROCK_LEFT_RIGHT_OFFSET (0)
#define EMBER_AF_ROCK_SUPPORT_MASK_ROCK_UP_DOWN (2)
#define EMBER_AF_ROCK_SUPPORT_MASK_ROCK_UP_DOWN_OFFSET (1)
#define EMBER_AF_ROCK_SUPPORT_MASK_ROCK_ROUND (4)
#define EMBER_AF_ROCK_SUPPORT_MASK_ROCK_ROUND_OFFSET (2)
#define EMBER_AF_SAFETY_STATUS_REMOTE_LOCKOUT (1)
#define EMBER_AF_SAFETY_STATUS_REMOTE_LOCKOUT_OFFSET (0)
#define EMBER_AF_SAFETY_STATUS_TAMPER_DETECTION (2)
#define EMBER_AF_SAFETY_STATUS_TAMPER_DETECTION_OFFSET (1)
#define EMBER_AF_SAFETY_STATUS_FAILED_COMMUNICATION (4)
#define EMBER_AF_SAFETY_STATUS_FAILED_COMMUNICATION_OFFSET (2)
#define EMBER_AF_SAFETY_STATUS_POSITION_FAILURE (8)
#define EMBER_AF_SAFETY_STATUS_POSITION_FAILURE_OFFSET (3)
#define EMBER_AF_SAFETY_STATUS_THERMAL_PROTECTION (16)
#define EMBER_AF_SAFETY_STATUS_THERMAL_PROTECTION_OFFSET (4)
#define EMBER_AF_SAFETY_STATUS_OBSTACLE_DETECTED (32)
#define EMBER_AF_SAFETY_STATUS_OBSTACLE_DETECTED_OFFSET (5)
#define EMBER_AF_SAFETY_STATUS_POWER (64)
#define EMBER_AF_SAFETY_STATUS_POWER_OFFSET (6)
#define EMBER_AF_SAFETY_STATUS_STOP_INPUT (128)
#define EMBER_AF_SAFETY_STATUS_STOP_INPUT_OFFSET (7)
#define EMBER_AF_SAFETY_STATUS_MOTOR_JAMMED (256)
#define EMBER_AF_SAFETY_STATUS_MOTOR_JAMMED_OFFSET (8)
#define EMBER_AF_SAFETY_STATUS_HARDWARE_FAILURE (512)
#define EMBER_AF_SAFETY_STATUS_HARDWARE_FAILURE_OFFSET (9)
#define EMBER_AF_SAFETY_STATUS_MANUAL_OPERATION (1024)
#define EMBER_AF_SAFETY_STATUS_MANUAL_OPERATION_OFFSET (10)
#define EMBER_AF_SAFETY_STATUS_PROTECTION (2048)
#define EMBER_AF_SAFETY_STATUS_PROTECTION_OFFSET (11)
#define EMBER_AF_SCENE_FEATURES_SCENE_NAMES (1)
#define EMBER_AF_SCENE_FEATURES_SCENE_NAMES_OFFSET (0)
#define EMBER_AF_SCENES_COPY_MODE_COPY_ALL_SCENES (1)
#define EMBER_AF_SCENES_COPY_MODE_COPY_ALL_SCENES_OFFSET (0)
#define EMBER_AF_SHADE_CLOSURE_STATUS_OPERATIONAL (1)
#define EMBER_AF_SHADE_CLOSURE_STATUS_OPERATIONAL_OFFSET (0)
#define EMBER_AF_SHADE_CLOSURE_STATUS_ADJUSTING (2)
#define EMBER_AF_SHADE_CLOSURE_STATUS_ADJUSTING_OFFSET (1)
#define EMBER_AF_SHADE_CLOSURE_STATUS_OPENING (4)
#define EMBER_AF_SHADE_CLOSURE_STATUS_OPENING_OFFSET (2)
#define EMBER_AF_SHADE_CLOSURE_STATUS_MOTOR_OPENING (8)
#define EMBER_AF_SHADE_CLOSURE_STATUS_MOTOR_OPENING_OFFSET (3)
#define EMBER_AF_SIMPLE_BITMAP_VALUE_A (1)
#define EMBER_AF_SIMPLE_BITMAP_VALUE_A_OFFSET (0)
#define EMBER_AF_SIMPLE_BITMAP_VALUE_B (2)
#define EMBER_AF_SIMPLE_BITMAP_VALUE_B_OFFSET (1)
#define EMBER_AF_SIMPLE_BITMAP_VALUE_C (4)
#define EMBER_AF_SIMPLE_BITMAP_VALUE_C_OFFSET (2)
#define EMBER_AF_SOFTWARE_DIAGNOSTICS_FEATURE_WATER_MARKS (1)
#define EMBER_AF_SOFTWARE_DIAGNOSTICS_FEATURE_WATER_MARKS_OFFSET (0)
#define EMBER_AF_SQUAWK_INFO_MODE (240)
#define EMBER_AF_SQUAWK_INFO_MODE_OFFSET (4)
#define EMBER_AF_SQUAWK_INFO_STROBE (8)
#define EMBER_AF_SQUAWK_INFO_STROBE_OFFSET (3)
#define EMBER_AF_SQUAWK_INFO_LEVEL (3)
#define EMBER_AF_SQUAWK_INFO_LEVEL_OFFSET (0)
#define EMBER_AF_START_TIME_MINUTES (63)
#define EMBER_AF_START_TIME_MINUTES_OFFSET (0)
#define EMBER_AF_START_TIME_TIME_ENCODING (192)
#define EMBER_AF_START_TIME_TIME_ENCODING_OFFSET (6)
#define EMBER_AF_START_TIME_HOURS (65280)
#define EMBER_AF_START_TIME_HOURS_OFFSET (8)
#define EMBER_AF_SUPPORTED_STREAMING_PROTOCOL_DASH (1)
#define EMBER_AF_SUPPORTED_STREAMING_PROTOCOL_DASH_OFFSET (0)
#define EMBER_AF_SUPPORTED_STREAMING_PROTOCOL_HLS (2)
#define EMBER_AF_SUPPORTED_STREAMING_PROTOCOL_HLS_OFFSET (1)
#define EMBER_AF_SWITCH_FEATURE_LATCHING_SWITCH (1)
#define EMBER_AF_SWITCH_FEATURE_LATCHING_SWITCH_OFFSET (0)
#define EMBER_AF_SWITCH_FEATURE_MOMENTARY_SWITCH (2)
#define EMBER_AF_SWITCH_FEATURE_MOMENTARY_SWITCH_OFFSET (1)
#define EMBER_AF_SWITCH_FEATURE_MOMENTARY_SWITCH_RELEASE (4)
#define EMBER_AF_SWITCH_FEATURE_MOMENTARY_SWITCH_RELEASE_OFFSET (2)
#define EMBER_AF_SWITCH_FEATURE_MOMENTARY_SWITCH_LONG_PRESS (8)
#define EMBER_AF_SWITCH_FEATURE_MOMENTARY_SWITCH_LONG_PRESS_OFFSET (3)
#define EMBER_AF_SWITCH_FEATURE_MOMENTARY_SWITCH_MULTI_PRESS (16)
#define EMBER_AF_SWITCH_FEATURE_MOMENTARY_SWITCH_MULTI_PRESS_OFFSET (4)
#define EMBER_AF_THERMOSTAT_ALARM_MASK_INITIALIZATION_FAILURE (1)
#define EMBER_AF_THERMOSTAT_ALARM_MASK_INITIALIZATION_FAILURE_OFFSET (0)
#define EMBER_AF_THERMOSTAT_ALARM_MASK_HARDWARE_FAILURE (2)
#define EMBER_AF_THERMOSTAT_ALARM_MASK_HARDWARE_FAILURE_OFFSET (1)
#define EMBER_AF_THERMOSTAT_ALARM_MASK_SELFCALIBRATION_FAILURE (4)
#define EMBER_AF_THERMOSTAT_ALARM_MASK_SELFCALIBRATION_FAILURE_OFFSET (2)
#define EMBER_AF_THERMOSTAT_FEATURE_HEATING (1)
#define EMBER_AF_THERMOSTAT_FEATURE_HEATING_OFFSET (0)
#define EMBER_AF_THERMOSTAT_FEATURE_COOLING (2)
#define EMBER_AF_THERMOSTAT_FEATURE_COOLING_OFFSET (1)
#define EMBER_AF_THERMOSTAT_FEATURE_OCCUPANCY (4)
#define EMBER_AF_THERMOSTAT_FEATURE_OCCUPANCY_OFFSET (2)
#define EMBER_AF_THERMOSTAT_FEATURE_SCHEDULE (8)
#define EMBER_AF_THERMOSTAT_FEATURE_SCHEDULE_OFFSET (3)
#define EMBER_AF_THERMOSTAT_FEATURE_SETBACK (16)
#define EMBER_AF_THERMOSTAT_FEATURE_SETBACK_OFFSET (4)
#define EMBER_AF_THERMOSTAT_FEATURE_AUTOMODE (32)
#define EMBER_AF_THERMOSTAT_FEATURE_AUTOMODE_OFFSET (5)
#define EMBER_AF_THERMOSTAT_OCCUPANCY_OCCUPIED (1)
#define EMBER_AF_THERMOSTAT_OCCUPANCY_OCCUPIED_OFFSET (0)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_HEAT_STATE_ON (1)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_HEAT_STATE_ON_OFFSET (0)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_COOL_STATE_ON (2)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_COOL_STATE_ON_OFFSET (1)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_FAN_STATE_ON (4)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_FAN_STATE_ON_OFFSET (2)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_HEAT_SECOND_STAGE_STATE_ON (8)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_HEAT_SECOND_STAGE_STATE_ON_OFFSET (3)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_COOL_SECOND_STAGE_STATE_ON (16)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_COOL_SECOND_STAGE_STATE_ON_OFFSET (4)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_FAN_SECOND_STAGE_STATE_ON (32)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_FAN_SECOND_STAGE_STATE_ON_OFFSET (5)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_FAN_THIRD_STAGE_STATE_ON (64)
#define EMBER_AF_THERMOSTAT_RUNNING_STATE_FAN_THIRD_STAGE_STATE_ON_OFFSET (6)
#define EMBER_AF_THERMOSTAT_SENSING_LOCAL_TEMP_SENSED_REMOTELY (1)
#define EMBER_AF_THERMOSTAT_SENSING_LOCAL_TEMP_SENSED_REMOTELY_OFFSET (0)
#define EMBER_AF_THERMOSTAT_SENSING_OUTDOOR_TEMP_SENSED_REMOTELY (2)
#define EMBER_AF_THERMOSTAT_SENSING_OUTDOOR_TEMP_SENSED_REMOTELY_OFFSET (1)
#define EMBER_AF_THERMOSTAT_SENSING_OCCUPANCY_SENSED_REMOTELY (4)
#define EMBER_AF_THERMOSTAT_SENSING_OCCUPANCY_SENSED_REMOTELY_OFFSET (2)
#define EMBER_AF_THREAD_NETWORK_DIAGNOSTICS_FEATURE_PACKET_COUNTS (1)
#define EMBER_AF_THREAD_NETWORK_DIAGNOSTICS_FEATURE_PACKET_COUNTS_OFFSET (0)
#define EMBER_AF_THREAD_NETWORK_DIAGNOSTICS_FEATURE_ERROR_COUNTS (2)
#define EMBER_AF_THREAD_NETWORK_DIAGNOSTICS_FEATURE_ERROR_COUNTS_OFFSET (1)
#define EMBER_AF_THREAD_NETWORK_DIAGNOSTICS_FEATURE_MLE_COUNTS (4)
#define EMBER_AF_THREAD_NETWORK_DIAGNOSTICS_FEATURE_MLE_COUNTS_OFFSET (2)
#define EMBER_AF_THREAD_NETWORK_DIAGNOSTICS_FEATURE_MAC_COUNTS (8)
#define EMBER_AF_THREAD_NETWORK_DIAGNOSTICS_FEATURE_MAC_COUNTS_OFFSET (3)
#define EMBER_AF_TIME_STATUS_MASK_MASTER_CLOCK (1)
#define EMBER_AF_TIME_STATUS_MASK_MASTER_CLOCK_OFFSET (0)
#define EMBER_AF_TIME_STATUS_MASK_SYNCHRONIZED (2)
#define EMBER_AF_TIME_STATUS_MASK_SYNCHRONIZED_OFFSET (1)
#define EMBER_AF_TIME_STATUS_MASK_MASTER_ZONE_DST (4)
#define EMBER_AF_TIME_STATUS_MASK_MASTER_ZONE_DST_OFFSET (2)
#define EMBER_AF_TIME_STATUS_MASK_SUPERSEDING (8)
#define EMBER_AF_TIME_STATUS_MASK_SUPERSEDING_OFFSET (3)
#define EMBER_AF_UNIT_LOCALIZATION_FEATURE_TEMPERATURE_UNIT (1)
#define EMBER_AF_UNIT_LOCALIZATION_FEATURE_TEMPERATURE_UNIT_OFFSET (0)
#define EMBER_AF_WARNING_INFO_MODE (240)
#define EMBER_AF_WARNING_INFO_MODE_OFFSET (4)
#define EMBER_AF_WARNING_INFO_STROBE (12)
#define EMBER_AF_WARNING_INFO_STROBE_OFFSET (2)
#define EMBER_AF_WARNING_INFO_SIREN_LEVEL (3)
#define EMBER_AF_WARNING_INFO_SIREN_LEVEL_OFFSET (0)
#define EMBER_AF_WI_FI_NETWORK_DIAGNOSTICS_FEATURE_PACKET_COUNTS (1)
#define EMBER_AF_WI_FI_NETWORK_DIAGNOSTICS_FEATURE_PACKET_COUNTS_OFFSET (0)
#define EMBER_AF_WI_FI_NETWORK_DIAGNOSTICS_FEATURE_ERROR_COUNTS (2)
#define EMBER_AF_WI_FI_NETWORK_DIAGNOSTICS_FEATURE_ERROR_COUNTS_OFFSET (1)
#define EMBER_AF_WI_FI_SECURITY_UNENCRYPTED (1)
#define EMBER_AF_WI_FI_SECURITY_UNENCRYPTED_OFFSET (0)
#define EMBER_AF_WI_FI_SECURITY_WEP_PERSONAL (2)
#define EMBER_AF_WI_FI_SECURITY_WEP_PERSONAL_OFFSET (1)
#define EMBER_AF_WI_FI_SECURITY_WPA_PERSONAL (4)
#define EMBER_AF_WI_FI_SECURITY_WPA_PERSONAL_OFFSET (2)
#define EMBER_AF_WI_FI_SECURITY_WPA2_PERSONAL (8)
#define EMBER_AF_WI_FI_SECURITY_WPA2_PERSONAL_OFFSET (3)
#define EMBER_AF_WI_FI_SECURITY_WPA3_PERSONAL (16)
#define EMBER_AF_WI_FI_SECURITY_WPA3_PERSONAL_OFFSET (4)
#define EMBER_AF_WIND_SETTING_MASK_SLEEP_WIND (1)
#define EMBER_AF_WIND_SETTING_MASK_SLEEP_WIND_OFFSET (0)
#define EMBER_AF_WIND_SETTING_MASK_NATURAL_WIND (2)
#define EMBER_AF_WIND_SETTING_MASK_NATURAL_WIND_OFFSET (1)
#define EMBER_AF_WIND_SUPPORT_MASK_SLEEP_WIND (1)
#define EMBER_AF_WIND_SUPPORT_MASK_SLEEP_WIND_OFFSET (0)
#define EMBER_AF_WIND_SUPPORT_MASK_NATURAL_WIND (2)
#define EMBER_AF_WIND_SUPPORT_MASK_NATURAL_WIND_OFFSET (1)
