/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#pragma once

#include <app/util/basic-types.h>

namespace chip {
namespace app {
namespace Clusters {

namespace Globals {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = 0x0000FFF8;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = 0x0000FFF9;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = 0x0000FFFB;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = 0x0000FFFC;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = 0x0000FFFD;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Globals

namespace Identify {
namespace Attributes {

namespace IdentifyTime {
static constexpr AttributeId Id = 0x00000000;
} // namespace IdentifyTime

namespace IdentifyType {
static constexpr AttributeId Id = 0x00000001;
} // namespace IdentifyType

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Identify

namespace Groups {
namespace Attributes {

namespace NameSupport {
static constexpr AttributeId Id = 0x00000000;
} // namespace NameSupport

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Groups

namespace Scenes {
namespace Attributes {

namespace SceneCount {
static constexpr AttributeId Id = 0x00000000;
} // namespace SceneCount

namespace CurrentScene {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentScene

namespace CurrentGroup {
static constexpr AttributeId Id = 0x00000002;
} // namespace CurrentGroup

namespace SceneValid {
static constexpr AttributeId Id = 0x00000003;
} // namespace SceneValid

namespace NameSupport {
static constexpr AttributeId Id = 0x00000004;
} // namespace NameSupport

namespace LastConfiguredBy {
static constexpr AttributeId Id = 0x00000005;
} // namespace LastConfiguredBy

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Scenes

namespace OnOff {
namespace Attributes {

namespace OnOff {
static constexpr AttributeId Id = 0x00000000;
} // namespace OnOff

namespace GlobalSceneControl {
static constexpr AttributeId Id = 0x00004000;
} // namespace GlobalSceneControl

namespace OnTime {
static constexpr AttributeId Id = 0x00004001;
} // namespace OnTime

namespace OffWaitTime {
static constexpr AttributeId Id = 0x00004002;
} // namespace OffWaitTime

namespace StartUpOnOff {
static constexpr AttributeId Id = 0x00004003;
} // namespace StartUpOnOff

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OnOff

namespace OnOffSwitchConfiguration {
namespace Attributes {

namespace SwitchType {
static constexpr AttributeId Id = 0x00000000;
} // namespace SwitchType

namespace SwitchActions {
static constexpr AttributeId Id = 0x00000010;
} // namespace SwitchActions

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OnOffSwitchConfiguration

namespace LevelControl {
namespace Attributes {

namespace CurrentLevel {
static constexpr AttributeId Id = 0x00000000;
} // namespace CurrentLevel

namespace RemainingTime {
static constexpr AttributeId Id = 0x00000001;
} // namespace RemainingTime

namespace MinLevel {
static constexpr AttributeId Id = 0x00000002;
} // namespace MinLevel

namespace MaxLevel {
static constexpr AttributeId Id = 0x00000003;
} // namespace MaxLevel

namespace CurrentFrequency {
static constexpr AttributeId Id = 0x00000004;
} // namespace CurrentFrequency

namespace MinFrequency {
static constexpr AttributeId Id = 0x00000005;
} // namespace MinFrequency

namespace MaxFrequency {
static constexpr AttributeId Id = 0x00000006;
} // namespace MaxFrequency

namespace Options {
static constexpr AttributeId Id = 0x0000000F;
} // namespace Options

namespace OnOffTransitionTime {
static constexpr AttributeId Id = 0x00000010;
} // namespace OnOffTransitionTime

namespace OnLevel {
static constexpr AttributeId Id = 0x00000011;
} // namespace OnLevel

namespace OnTransitionTime {
static constexpr AttributeId Id = 0x00000012;
} // namespace OnTransitionTime

namespace OffTransitionTime {
static constexpr AttributeId Id = 0x00000013;
} // namespace OffTransitionTime

namespace DefaultMoveRate {
static constexpr AttributeId Id = 0x00000014;
} // namespace DefaultMoveRate

namespace StartUpCurrentLevel {
static constexpr AttributeId Id = 0x00004000;
} // namespace StartUpCurrentLevel

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace LevelControl

namespace BinaryInputBasic {
namespace Attributes {

namespace ActiveText {
static constexpr AttributeId Id = 0x00000004;
} // namespace ActiveText

namespace Description {
static constexpr AttributeId Id = 0x0000001C;
} // namespace Description

namespace InactiveText {
static constexpr AttributeId Id = 0x0000002E;
} // namespace InactiveText

namespace OutOfService {
static constexpr AttributeId Id = 0x00000051;
} // namespace OutOfService

namespace Polarity {
static constexpr AttributeId Id = 0x00000054;
} // namespace Polarity

namespace PresentValue {
static constexpr AttributeId Id = 0x00000055;
} // namespace PresentValue

namespace Reliability {
static constexpr AttributeId Id = 0x00000067;
} // namespace Reliability

namespace StatusFlags {
static constexpr AttributeId Id = 0x0000006F;
} // namespace StatusFlags

namespace ApplicationType {
static constexpr AttributeId Id = 0x00000100;
} // namespace ApplicationType

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace BinaryInputBasic

namespace PulseWidthModulation {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace PulseWidthModulation

namespace Descriptor {
namespace Attributes {

namespace DeviceTypeList {
static constexpr AttributeId Id = 0x00000000;
} // namespace DeviceTypeList

namespace ServerList {
static constexpr AttributeId Id = 0x00000001;
} // namespace ServerList

namespace ClientList {
static constexpr AttributeId Id = 0x00000002;
} // namespace ClientList

namespace PartsList {
static constexpr AttributeId Id = 0x00000003;
} // namespace PartsList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Descriptor

namespace Binding {
namespace Attributes {

namespace Binding {
static constexpr AttributeId Id = 0x00000000;
} // namespace Binding

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Binding

namespace AccessControl {
namespace Attributes {

namespace Acl {
static constexpr AttributeId Id = 0x00000000;
} // namespace Acl

namespace Extension {
static constexpr AttributeId Id = 0x00000001;
} // namespace Extension

namespace SubjectsPerAccessControlEntry {
static constexpr AttributeId Id = 0x00000002;
} // namespace SubjectsPerAccessControlEntry

namespace TargetsPerAccessControlEntry {
static constexpr AttributeId Id = 0x00000003;
} // namespace TargetsPerAccessControlEntry

namespace AccessControlEntriesPerFabric {
static constexpr AttributeId Id = 0x00000004;
} // namespace AccessControlEntriesPerFabric

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace AccessControl

namespace Actions {
namespace Attributes {

namespace ActionList {
static constexpr AttributeId Id = 0x00000000;
} // namespace ActionList

namespace EndpointLists {
static constexpr AttributeId Id = 0x00000001;
} // namespace EndpointLists

namespace SetupURL {
static constexpr AttributeId Id = 0x00000002;
} // namespace SetupURL

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Actions

namespace Basic {
namespace Attributes {

namespace DataModelRevision {
static constexpr AttributeId Id = 0x00000000;
} // namespace DataModelRevision

namespace VendorName {
static constexpr AttributeId Id = 0x00000001;
} // namespace VendorName

namespace VendorID {
static constexpr AttributeId Id = 0x00000002;
} // namespace VendorID

namespace ProductName {
static constexpr AttributeId Id = 0x00000003;
} // namespace ProductName

namespace ProductID {
static constexpr AttributeId Id = 0x00000004;
} // namespace ProductID

namespace NodeLabel {
static constexpr AttributeId Id = 0x00000005;
} // namespace NodeLabel

namespace Location {
static constexpr AttributeId Id = 0x00000006;
} // namespace Location

namespace HardwareVersion {
static constexpr AttributeId Id = 0x00000007;
} // namespace HardwareVersion

namespace HardwareVersionString {
static constexpr AttributeId Id = 0x00000008;
} // namespace HardwareVersionString

namespace SoftwareVersion {
static constexpr AttributeId Id = 0x00000009;
} // namespace SoftwareVersion

namespace SoftwareVersionString {
static constexpr AttributeId Id = 0x0000000A;
} // namespace SoftwareVersionString

namespace ManufacturingDate {
static constexpr AttributeId Id = 0x0000000B;
} // namespace ManufacturingDate

namespace PartNumber {
static constexpr AttributeId Id = 0x0000000C;
} // namespace PartNumber

namespace ProductURL {
static constexpr AttributeId Id = 0x0000000D;
} // namespace ProductURL

namespace ProductLabel {
static constexpr AttributeId Id = 0x0000000E;
} // namespace ProductLabel

namespace SerialNumber {
static constexpr AttributeId Id = 0x0000000F;
} // namespace SerialNumber

namespace LocalConfigDisabled {
static constexpr AttributeId Id = 0x00000010;
} // namespace LocalConfigDisabled

namespace Reachable {
static constexpr AttributeId Id = 0x00000011;
} // namespace Reachable

namespace UniqueID {
static constexpr AttributeId Id = 0x00000012;
} // namespace UniqueID

namespace CapabilityMinima {
static constexpr AttributeId Id = 0x00000013;
} // namespace CapabilityMinima

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Basic

namespace OtaSoftwareUpdateProvider {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OtaSoftwareUpdateProvider

namespace OtaSoftwareUpdateRequestor {
namespace Attributes {

namespace DefaultOtaProviders {
static constexpr AttributeId Id = 0x00000000;
} // namespace DefaultOtaProviders

namespace UpdatePossible {
static constexpr AttributeId Id = 0x00000001;
} // namespace UpdatePossible

namespace UpdateState {
static constexpr AttributeId Id = 0x00000002;
} // namespace UpdateState

namespace UpdateStateProgress {
static constexpr AttributeId Id = 0x00000003;
} // namespace UpdateStateProgress

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OtaSoftwareUpdateRequestor

namespace LocalizationConfiguration {
namespace Attributes {

namespace ActiveLocale {
static constexpr AttributeId Id = 0x00000000;
} // namespace ActiveLocale

namespace SupportedLocales {
static constexpr AttributeId Id = 0x00000001;
} // namespace SupportedLocales

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace LocalizationConfiguration

namespace TimeFormatLocalization {
namespace Attributes {

namespace HourFormat {
static constexpr AttributeId Id = 0x00000000;
} // namespace HourFormat

namespace ActiveCalendarType {
static constexpr AttributeId Id = 0x00000001;
} // namespace ActiveCalendarType

namespace SupportedCalendarTypes {
static constexpr AttributeId Id = 0x00000002;
} // namespace SupportedCalendarTypes

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace TimeFormatLocalization

namespace UnitLocalization {
namespace Attributes {

namespace TemperatureUnit {
static constexpr AttributeId Id = 0x00000000;
} // namespace TemperatureUnit

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace UnitLocalization

namespace PowerSourceConfiguration {
namespace Attributes {

namespace Sources {
static constexpr AttributeId Id = 0x00000000;
} // namespace Sources

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace PowerSourceConfiguration

namespace PowerSource {
namespace Attributes {

namespace Status {
static constexpr AttributeId Id = 0x00000000;
} // namespace Status

namespace Order {
static constexpr AttributeId Id = 0x00000001;
} // namespace Order

namespace Description {
static constexpr AttributeId Id = 0x00000002;
} // namespace Description

namespace WiredAssessedInputVoltage {
static constexpr AttributeId Id = 0x00000003;
} // namespace WiredAssessedInputVoltage

namespace WiredAssessedInputFrequency {
static constexpr AttributeId Id = 0x00000004;
} // namespace WiredAssessedInputFrequency

namespace WiredCurrentType {
static constexpr AttributeId Id = 0x00000005;
} // namespace WiredCurrentType

namespace WiredAssessedCurrent {
static constexpr AttributeId Id = 0x00000006;
} // namespace WiredAssessedCurrent

namespace WiredNominalVoltage {
static constexpr AttributeId Id = 0x00000007;
} // namespace WiredNominalVoltage

namespace WiredMaximumCurrent {
static constexpr AttributeId Id = 0x00000008;
} // namespace WiredMaximumCurrent

namespace WiredPresent {
static constexpr AttributeId Id = 0x00000009;
} // namespace WiredPresent

namespace ActiveWiredFaults {
static constexpr AttributeId Id = 0x0000000A;
} // namespace ActiveWiredFaults

namespace BatVoltage {
static constexpr AttributeId Id = 0x0000000B;
} // namespace BatVoltage

namespace BatPercentRemaining {
static constexpr AttributeId Id = 0x0000000C;
} // namespace BatPercentRemaining

namespace BatTimeRemaining {
static constexpr AttributeId Id = 0x0000000D;
} // namespace BatTimeRemaining

namespace BatChargeLevel {
static constexpr AttributeId Id = 0x0000000E;
} // namespace BatChargeLevel

namespace BatReplacementNeeded {
static constexpr AttributeId Id = 0x0000000F;
} // namespace BatReplacementNeeded

namespace BatReplaceability {
static constexpr AttributeId Id = 0x00000010;
} // namespace BatReplaceability

namespace BatPresent {
static constexpr AttributeId Id = 0x00000011;
} // namespace BatPresent

namespace ActiveBatFaults {
static constexpr AttributeId Id = 0x00000012;
} // namespace ActiveBatFaults

namespace BatReplacementDescription {
static constexpr AttributeId Id = 0x00000013;
} // namespace BatReplacementDescription

namespace BatCommonDesignation {
static constexpr AttributeId Id = 0x00000014;
} // namespace BatCommonDesignation

namespace BatANSIDesignation {
static constexpr AttributeId Id = 0x00000015;
} // namespace BatANSIDesignation

namespace BatIECDesignation {
static constexpr AttributeId Id = 0x00000016;
} // namespace BatIECDesignation

namespace BatApprovedChemistry {
static constexpr AttributeId Id = 0x00000017;
} // namespace BatApprovedChemistry

namespace BatCapacity {
static constexpr AttributeId Id = 0x00000018;
} // namespace BatCapacity

namespace BatQuantity {
static constexpr AttributeId Id = 0x00000019;
} // namespace BatQuantity

namespace BatChargeState {
static constexpr AttributeId Id = 0x0000001A;
} // namespace BatChargeState

namespace BatTimeToFullCharge {
static constexpr AttributeId Id = 0x0000001B;
} // namespace BatTimeToFullCharge

namespace BatFunctionalWhileCharging {
static constexpr AttributeId Id = 0x0000001C;
} // namespace BatFunctionalWhileCharging

namespace BatChargingCurrent {
static constexpr AttributeId Id = 0x0000001D;
} // namespace BatChargingCurrent

namespace ActiveBatChargeFaults {
static constexpr AttributeId Id = 0x0000001E;
} // namespace ActiveBatChargeFaults

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace PowerSource

namespace GeneralCommissioning {
namespace Attributes {

namespace Breadcrumb {
static constexpr AttributeId Id = 0x00000000;
} // namespace Breadcrumb

namespace BasicCommissioningInfo {
static constexpr AttributeId Id = 0x00000001;
} // namespace BasicCommissioningInfo

namespace RegulatoryConfig {
static constexpr AttributeId Id = 0x00000002;
} // namespace RegulatoryConfig

namespace LocationCapability {
static constexpr AttributeId Id = 0x00000003;
} // namespace LocationCapability

namespace SupportsConcurrentConnection {
static constexpr AttributeId Id = 0x00000004;
} // namespace SupportsConcurrentConnection

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace GeneralCommissioning

namespace NetworkCommissioning {
namespace Attributes {

namespace MaxNetworks {
static constexpr AttributeId Id = 0x00000000;
} // namespace MaxNetworks

namespace Networks {
static constexpr AttributeId Id = 0x00000001;
} // namespace Networks

namespace ScanMaxTimeSeconds {
static constexpr AttributeId Id = 0x00000002;
} // namespace ScanMaxTimeSeconds

namespace ConnectMaxTimeSeconds {
static constexpr AttributeId Id = 0x00000003;
} // namespace ConnectMaxTimeSeconds

namespace InterfaceEnabled {
static constexpr AttributeId Id = 0x00000004;
} // namespace InterfaceEnabled

namespace LastNetworkingStatus {
static constexpr AttributeId Id = 0x00000005;
} // namespace LastNetworkingStatus

namespace LastNetworkID {
static constexpr AttributeId Id = 0x00000006;
} // namespace LastNetworkID

namespace LastConnectErrorValue {
static constexpr AttributeId Id = 0x00000007;
} // namespace LastConnectErrorValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace NetworkCommissioning

namespace DiagnosticLogs {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace DiagnosticLogs

namespace GeneralDiagnostics {
namespace Attributes {

namespace NetworkInterfaces {
static constexpr AttributeId Id = 0x00000000;
} // namespace NetworkInterfaces

namespace RebootCount {
static constexpr AttributeId Id = 0x00000001;
} // namespace RebootCount

namespace UpTime {
static constexpr AttributeId Id = 0x00000002;
} // namespace UpTime

namespace TotalOperationalHours {
static constexpr AttributeId Id = 0x00000003;
} // namespace TotalOperationalHours

namespace BootReasons {
static constexpr AttributeId Id = 0x00000004;
} // namespace BootReasons

namespace ActiveHardwareFaults {
static constexpr AttributeId Id = 0x00000005;
} // namespace ActiveHardwareFaults

namespace ActiveRadioFaults {
static constexpr AttributeId Id = 0x00000006;
} // namespace ActiveRadioFaults

namespace ActiveNetworkFaults {
static constexpr AttributeId Id = 0x00000007;
} // namespace ActiveNetworkFaults

namespace TestEventTriggersEnabled {
static constexpr AttributeId Id = 0x00000008;
} // namespace TestEventTriggersEnabled

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace GeneralDiagnostics

namespace SoftwareDiagnostics {
namespace Attributes {

namespace ThreadMetrics {
static constexpr AttributeId Id = 0x00000000;
} // namespace ThreadMetrics

namespace CurrentHeapFree {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentHeapFree

namespace CurrentHeapUsed {
static constexpr AttributeId Id = 0x00000002;
} // namespace CurrentHeapUsed

namespace CurrentHeapHighWatermark {
static constexpr AttributeId Id = 0x00000003;
} // namespace CurrentHeapHighWatermark

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace SoftwareDiagnostics

namespace ThreadNetworkDiagnostics {
namespace Attributes {

namespace Channel {
static constexpr AttributeId Id = 0x00000000;
} // namespace Channel

namespace RoutingRole {
static constexpr AttributeId Id = 0x00000001;
} // namespace RoutingRole

namespace NetworkName {
static constexpr AttributeId Id = 0x00000002;
} // namespace NetworkName

namespace PanId {
static constexpr AttributeId Id = 0x00000003;
} // namespace PanId

namespace ExtendedPanId {
static constexpr AttributeId Id = 0x00000004;
} // namespace ExtendedPanId

namespace MeshLocalPrefix {
static constexpr AttributeId Id = 0x00000005;
} // namespace MeshLocalPrefix

namespace OverrunCount {
static constexpr AttributeId Id = 0x00000006;
} // namespace OverrunCount

namespace NeighborTableList {
static constexpr AttributeId Id = 0x00000007;
} // namespace NeighborTableList

namespace RouteTableList {
static constexpr AttributeId Id = 0x00000008;
} // namespace RouteTableList

namespace PartitionId {
static constexpr AttributeId Id = 0x00000009;
} // namespace PartitionId

namespace Weighting {
static constexpr AttributeId Id = 0x0000000A;
} // namespace Weighting

namespace DataVersion {
static constexpr AttributeId Id = 0x0000000B;
} // namespace DataVersion

namespace StableDataVersion {
static constexpr AttributeId Id = 0x0000000C;
} // namespace StableDataVersion

namespace LeaderRouterId {
static constexpr AttributeId Id = 0x0000000D;
} // namespace LeaderRouterId

namespace DetachedRoleCount {
static constexpr AttributeId Id = 0x0000000E;
} // namespace DetachedRoleCount

namespace ChildRoleCount {
static constexpr AttributeId Id = 0x0000000F;
} // namespace ChildRoleCount

namespace RouterRoleCount {
static constexpr AttributeId Id = 0x00000010;
} // namespace RouterRoleCount

namespace LeaderRoleCount {
static constexpr AttributeId Id = 0x00000011;
} // namespace LeaderRoleCount

namespace AttachAttemptCount {
static constexpr AttributeId Id = 0x00000012;
} // namespace AttachAttemptCount

namespace PartitionIdChangeCount {
static constexpr AttributeId Id = 0x00000013;
} // namespace PartitionIdChangeCount

namespace BetterPartitionAttachAttemptCount {
static constexpr AttributeId Id = 0x00000014;
} // namespace BetterPartitionAttachAttemptCount

namespace ParentChangeCount {
static constexpr AttributeId Id = 0x00000015;
} // namespace ParentChangeCount

namespace TxTotalCount {
static constexpr AttributeId Id = 0x00000016;
} // namespace TxTotalCount

namespace TxUnicastCount {
static constexpr AttributeId Id = 0x00000017;
} // namespace TxUnicastCount

namespace TxBroadcastCount {
static constexpr AttributeId Id = 0x00000018;
} // namespace TxBroadcastCount

namespace TxAckRequestedCount {
static constexpr AttributeId Id = 0x00000019;
} // namespace TxAckRequestedCount

namespace TxAckedCount {
static constexpr AttributeId Id = 0x0000001A;
} // namespace TxAckedCount

namespace TxNoAckRequestedCount {
static constexpr AttributeId Id = 0x0000001B;
} // namespace TxNoAckRequestedCount

namespace TxDataCount {
static constexpr AttributeId Id = 0x0000001C;
} // namespace TxDataCount

namespace TxDataPollCount {
static constexpr AttributeId Id = 0x0000001D;
} // namespace TxDataPollCount

namespace TxBeaconCount {
static constexpr AttributeId Id = 0x0000001E;
} // namespace TxBeaconCount

namespace TxBeaconRequestCount {
static constexpr AttributeId Id = 0x0000001F;
} // namespace TxBeaconRequestCount

namespace TxOtherCount {
static constexpr AttributeId Id = 0x00000020;
} // namespace TxOtherCount

namespace TxRetryCount {
static constexpr AttributeId Id = 0x00000021;
} // namespace TxRetryCount

namespace TxDirectMaxRetryExpiryCount {
static constexpr AttributeId Id = 0x00000022;
} // namespace TxDirectMaxRetryExpiryCount

namespace TxIndirectMaxRetryExpiryCount {
static constexpr AttributeId Id = 0x00000023;
} // namespace TxIndirectMaxRetryExpiryCount

namespace TxErrCcaCount {
static constexpr AttributeId Id = 0x00000024;
} // namespace TxErrCcaCount

namespace TxErrAbortCount {
static constexpr AttributeId Id = 0x00000025;
} // namespace TxErrAbortCount

namespace TxErrBusyChannelCount {
static constexpr AttributeId Id = 0x00000026;
} // namespace TxErrBusyChannelCount

namespace RxTotalCount {
static constexpr AttributeId Id = 0x00000027;
} // namespace RxTotalCount

namespace RxUnicastCount {
static constexpr AttributeId Id = 0x00000028;
} // namespace RxUnicastCount

namespace RxBroadcastCount {
static constexpr AttributeId Id = 0x00000029;
} // namespace RxBroadcastCount

namespace RxDataCount {
static constexpr AttributeId Id = 0x0000002A;
} // namespace RxDataCount

namespace RxDataPollCount {
static constexpr AttributeId Id = 0x0000002B;
} // namespace RxDataPollCount

namespace RxBeaconCount {
static constexpr AttributeId Id = 0x0000002C;
} // namespace RxBeaconCount

namespace RxBeaconRequestCount {
static constexpr AttributeId Id = 0x0000002D;
} // namespace RxBeaconRequestCount

namespace RxOtherCount {
static constexpr AttributeId Id = 0x0000002E;
} // namespace RxOtherCount

namespace RxAddressFilteredCount {
static constexpr AttributeId Id = 0x0000002F;
} // namespace RxAddressFilteredCount

namespace RxDestAddrFilteredCount {
static constexpr AttributeId Id = 0x00000030;
} // namespace RxDestAddrFilteredCount

namespace RxDuplicatedCount {
static constexpr AttributeId Id = 0x00000031;
} // namespace RxDuplicatedCount

namespace RxErrNoFrameCount {
static constexpr AttributeId Id = 0x00000032;
} // namespace RxErrNoFrameCount

namespace RxErrUnknownNeighborCount {
static constexpr AttributeId Id = 0x00000033;
} // namespace RxErrUnknownNeighborCount

namespace RxErrInvalidSrcAddrCount {
static constexpr AttributeId Id = 0x00000034;
} // namespace RxErrInvalidSrcAddrCount

namespace RxErrSecCount {
static constexpr AttributeId Id = 0x00000035;
} // namespace RxErrSecCount

namespace RxErrFcsCount {
static constexpr AttributeId Id = 0x00000036;
} // namespace RxErrFcsCount

namespace RxErrOtherCount {
static constexpr AttributeId Id = 0x00000037;
} // namespace RxErrOtherCount

namespace ActiveTimestamp {
static constexpr AttributeId Id = 0x00000038;
} // namespace ActiveTimestamp

namespace PendingTimestamp {
static constexpr AttributeId Id = 0x00000039;
} // namespace PendingTimestamp

namespace Delay {
static constexpr AttributeId Id = 0x0000003A;
} // namespace Delay

namespace SecurityPolicy {
static constexpr AttributeId Id = 0x0000003B;
} // namespace SecurityPolicy

namespace ChannelPage0Mask {
static constexpr AttributeId Id = 0x0000003C;
} // namespace ChannelPage0Mask

namespace OperationalDatasetComponents {
static constexpr AttributeId Id = 0x0000003D;
} // namespace OperationalDatasetComponents

namespace ActiveNetworkFaultsList {
static constexpr AttributeId Id = 0x0000003E;
} // namespace ActiveNetworkFaultsList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ThreadNetworkDiagnostics

namespace WiFiNetworkDiagnostics {
namespace Attributes {

namespace Bssid {
static constexpr AttributeId Id = 0x00000000;
} // namespace Bssid

namespace SecurityType {
static constexpr AttributeId Id = 0x00000001;
} // namespace SecurityType

namespace WiFiVersion {
static constexpr AttributeId Id = 0x00000002;
} // namespace WiFiVersion

namespace ChannelNumber {
static constexpr AttributeId Id = 0x00000003;
} // namespace ChannelNumber

namespace Rssi {
static constexpr AttributeId Id = 0x00000004;
} // namespace Rssi

namespace BeaconLostCount {
static constexpr AttributeId Id = 0x00000005;
} // namespace BeaconLostCount

namespace BeaconRxCount {
static constexpr AttributeId Id = 0x00000006;
} // namespace BeaconRxCount

namespace PacketMulticastRxCount {
static constexpr AttributeId Id = 0x00000007;
} // namespace PacketMulticastRxCount

namespace PacketMulticastTxCount {
static constexpr AttributeId Id = 0x00000008;
} // namespace PacketMulticastTxCount

namespace PacketUnicastRxCount {
static constexpr AttributeId Id = 0x00000009;
} // namespace PacketUnicastRxCount

namespace PacketUnicastTxCount {
static constexpr AttributeId Id = 0x0000000A;
} // namespace PacketUnicastTxCount

namespace CurrentMaxRate {
static constexpr AttributeId Id = 0x0000000B;
} // namespace CurrentMaxRate

namespace OverrunCount {
static constexpr AttributeId Id = 0x0000000C;
} // namespace OverrunCount

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace WiFiNetworkDiagnostics

namespace EthernetNetworkDiagnostics {
namespace Attributes {

namespace PHYRate {
static constexpr AttributeId Id = 0x00000000;
} // namespace PHYRate

namespace FullDuplex {
static constexpr AttributeId Id = 0x00000001;
} // namespace FullDuplex

namespace PacketRxCount {
static constexpr AttributeId Id = 0x00000002;
} // namespace PacketRxCount

namespace PacketTxCount {
static constexpr AttributeId Id = 0x00000003;
} // namespace PacketTxCount

namespace TxErrCount {
static constexpr AttributeId Id = 0x00000004;
} // namespace TxErrCount

namespace CollisionCount {
static constexpr AttributeId Id = 0x00000005;
} // namespace CollisionCount

namespace OverrunCount {
static constexpr AttributeId Id = 0x00000006;
} // namespace OverrunCount

namespace CarrierDetect {
static constexpr AttributeId Id = 0x00000007;
} // namespace CarrierDetect

namespace TimeSinceReset {
static constexpr AttributeId Id = 0x00000008;
} // namespace TimeSinceReset

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace EthernetNetworkDiagnostics

namespace TimeSynchronization {
namespace Attributes {

namespace UTCTime {
static constexpr AttributeId Id = 0x00000000;
} // namespace UTCTime

namespace Granularity {
static constexpr AttributeId Id = 0x00000001;
} // namespace Granularity

namespace TimeSource {
static constexpr AttributeId Id = 0x00000002;
} // namespace TimeSource

namespace TrustedTimeNodeId {
static constexpr AttributeId Id = 0x00000003;
} // namespace TrustedTimeNodeId

namespace DefaultNtp {
static constexpr AttributeId Id = 0x00000004;
} // namespace DefaultNtp

namespace TimeZone {
static constexpr AttributeId Id = 0x00000005;
} // namespace TimeZone

namespace DstOffset {
static constexpr AttributeId Id = 0x00000006;
} // namespace DstOffset

namespace LocalTime {
static constexpr AttributeId Id = 0x00000007;
} // namespace LocalTime

namespace TimeZoneDatabase {
static constexpr AttributeId Id = 0x00000008;
} // namespace TimeZoneDatabase

namespace NtpServerPort {
static constexpr AttributeId Id = 0x00000009;
} // namespace NtpServerPort

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace TimeSynchronization

namespace BridgedDeviceBasic {
namespace Attributes {

namespace VendorName {
static constexpr AttributeId Id = 0x00000001;
} // namespace VendorName

namespace VendorID {
static constexpr AttributeId Id = 0x00000002;
} // namespace VendorID

namespace ProductName {
static constexpr AttributeId Id = 0x00000003;
} // namespace ProductName

namespace NodeLabel {
static constexpr AttributeId Id = 0x00000005;
} // namespace NodeLabel

namespace HardwareVersion {
static constexpr AttributeId Id = 0x00000007;
} // namespace HardwareVersion

namespace HardwareVersionString {
static constexpr AttributeId Id = 0x00000008;
} // namespace HardwareVersionString

namespace SoftwareVersion {
static constexpr AttributeId Id = 0x00000009;
} // namespace SoftwareVersion

namespace SoftwareVersionString {
static constexpr AttributeId Id = 0x0000000A;
} // namespace SoftwareVersionString

namespace ManufacturingDate {
static constexpr AttributeId Id = 0x0000000B;
} // namespace ManufacturingDate

namespace PartNumber {
static constexpr AttributeId Id = 0x0000000C;
} // namespace PartNumber

namespace ProductURL {
static constexpr AttributeId Id = 0x0000000D;
} // namespace ProductURL

namespace ProductLabel {
static constexpr AttributeId Id = 0x0000000E;
} // namespace ProductLabel

namespace SerialNumber {
static constexpr AttributeId Id = 0x0000000F;
} // namespace SerialNumber

namespace Reachable {
static constexpr AttributeId Id = 0x00000011;
} // namespace Reachable

namespace UniqueID {
static constexpr AttributeId Id = 0x00000012;
} // namespace UniqueID

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace BridgedDeviceBasic

namespace Switch {
namespace Attributes {

namespace NumberOfPositions {
static constexpr AttributeId Id = 0x00000000;
} // namespace NumberOfPositions

namespace CurrentPosition {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentPosition

namespace MultiPressMax {
static constexpr AttributeId Id = 0x00000002;
} // namespace MultiPressMax

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Switch

namespace AdministratorCommissioning {
namespace Attributes {

namespace WindowStatus {
static constexpr AttributeId Id = 0x00000000;
} // namespace WindowStatus

namespace AdminFabricIndex {
static constexpr AttributeId Id = 0x00000001;
} // namespace AdminFabricIndex

namespace AdminVendorId {
static constexpr AttributeId Id = 0x00000002;
} // namespace AdminVendorId

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace AdministratorCommissioning

namespace OperationalCredentials {
namespace Attributes {

namespace NOCs {
static constexpr AttributeId Id = 0x00000000;
} // namespace NOCs

namespace Fabrics {
static constexpr AttributeId Id = 0x00000001;
} // namespace Fabrics

namespace SupportedFabrics {
static constexpr AttributeId Id = 0x00000002;
} // namespace SupportedFabrics

namespace CommissionedFabrics {
static constexpr AttributeId Id = 0x00000003;
} // namespace CommissionedFabrics

namespace TrustedRootCertificates {
static constexpr AttributeId Id = 0x00000004;
} // namespace TrustedRootCertificates

namespace CurrentFabricIndex {
static constexpr AttributeId Id = 0x00000005;
} // namespace CurrentFabricIndex

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OperationalCredentials

namespace GroupKeyManagement {
namespace Attributes {

namespace GroupKeyMap {
static constexpr AttributeId Id = 0x00000000;
} // namespace GroupKeyMap

namespace GroupTable {
static constexpr AttributeId Id = 0x00000001;
} // namespace GroupTable

namespace MaxGroupsPerFabric {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxGroupsPerFabric

namespace MaxGroupKeysPerFabric {
static constexpr AttributeId Id = 0x00000003;
} // namespace MaxGroupKeysPerFabric

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace GroupKeyManagement

namespace FixedLabel {
namespace Attributes {

namespace LabelList {
static constexpr AttributeId Id = 0x00000000;
} // namespace LabelList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace FixedLabel

namespace UserLabel {
namespace Attributes {

namespace LabelList {
static constexpr AttributeId Id = 0x00000000;
} // namespace LabelList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace UserLabel

namespace ProxyConfiguration {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ProxyConfiguration

namespace ProxyDiscovery {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ProxyDiscovery

namespace ProxyValid {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ProxyValid

namespace BooleanState {
namespace Attributes {

namespace StateValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace StateValue

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace BooleanState

namespace ModeSelect {
namespace Attributes {

namespace Description {
static constexpr AttributeId Id = 0x00000000;
} // namespace Description

namespace StandardNamespace {
static constexpr AttributeId Id = 0x00000001;
} // namespace StandardNamespace

namespace SupportedModes {
static constexpr AttributeId Id = 0x00000002;
} // namespace SupportedModes

namespace CurrentMode {
static constexpr AttributeId Id = 0x00000003;
} // namespace CurrentMode

namespace StartUpMode {
static constexpr AttributeId Id = 0x00000004;
} // namespace StartUpMode

namespace OnMode {
static constexpr AttributeId Id = 0x00000005;
} // namespace OnMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ModeSelect

namespace DoorLock {
namespace Attributes {

namespace LockState {
static constexpr AttributeId Id = 0x00000000;
} // namespace LockState

namespace LockType {
static constexpr AttributeId Id = 0x00000001;
} // namespace LockType

namespace ActuatorEnabled {
static constexpr AttributeId Id = 0x00000002;
} // namespace ActuatorEnabled

namespace DoorState {
static constexpr AttributeId Id = 0x00000003;
} // namespace DoorState

namespace DoorOpenEvents {
static constexpr AttributeId Id = 0x00000004;
} // namespace DoorOpenEvents

namespace DoorClosedEvents {
static constexpr AttributeId Id = 0x00000005;
} // namespace DoorClosedEvents

namespace OpenPeriod {
static constexpr AttributeId Id = 0x00000006;
} // namespace OpenPeriod

namespace NumberOfTotalUsersSupported {
static constexpr AttributeId Id = 0x00000011;
} // namespace NumberOfTotalUsersSupported

namespace NumberOfPINUsersSupported {
static constexpr AttributeId Id = 0x00000012;
} // namespace NumberOfPINUsersSupported

namespace NumberOfRFIDUsersSupported {
static constexpr AttributeId Id = 0x00000013;
} // namespace NumberOfRFIDUsersSupported

namespace NumberOfWeekDaySchedulesSupportedPerUser {
static constexpr AttributeId Id = 0x00000014;
} // namespace NumberOfWeekDaySchedulesSupportedPerUser

namespace NumberOfYearDaySchedulesSupportedPerUser {
static constexpr AttributeId Id = 0x00000015;
} // namespace NumberOfYearDaySchedulesSupportedPerUser

namespace NumberOfHolidaySchedulesSupported {
static constexpr AttributeId Id = 0x00000016;
} // namespace NumberOfHolidaySchedulesSupported

namespace MaxPINCodeLength {
static constexpr AttributeId Id = 0x00000017;
} // namespace MaxPINCodeLength

namespace MinPINCodeLength {
static constexpr AttributeId Id = 0x00000018;
} // namespace MinPINCodeLength

namespace MaxRFIDCodeLength {
static constexpr AttributeId Id = 0x00000019;
} // namespace MaxRFIDCodeLength

namespace MinRFIDCodeLength {
static constexpr AttributeId Id = 0x0000001A;
} // namespace MinRFIDCodeLength

namespace CredentialRulesSupport {
static constexpr AttributeId Id = 0x0000001B;
} // namespace CredentialRulesSupport

namespace NumberOfCredentialsSupportedPerUser {
static constexpr AttributeId Id = 0x0000001C;
} // namespace NumberOfCredentialsSupportedPerUser

namespace Language {
static constexpr AttributeId Id = 0x00000021;
} // namespace Language

namespace LEDSettings {
static constexpr AttributeId Id = 0x00000022;
} // namespace LEDSettings

namespace AutoRelockTime {
static constexpr AttributeId Id = 0x00000023;
} // namespace AutoRelockTime

namespace SoundVolume {
static constexpr AttributeId Id = 0x00000024;
} // namespace SoundVolume

namespace OperatingMode {
static constexpr AttributeId Id = 0x00000025;
} // namespace OperatingMode

namespace SupportedOperatingModes {
static constexpr AttributeId Id = 0x00000026;
} // namespace SupportedOperatingModes

namespace DefaultConfigurationRegister {
static constexpr AttributeId Id = 0x00000027;
} // namespace DefaultConfigurationRegister

namespace EnableLocalProgramming {
static constexpr AttributeId Id = 0x00000028;
} // namespace EnableLocalProgramming

namespace EnableOneTouchLocking {
static constexpr AttributeId Id = 0x00000029;
} // namespace EnableOneTouchLocking

namespace EnableInsideStatusLED {
static constexpr AttributeId Id = 0x0000002A;
} // namespace EnableInsideStatusLED

namespace EnablePrivacyModeButton {
static constexpr AttributeId Id = 0x0000002B;
} // namespace EnablePrivacyModeButton

namespace LocalProgrammingFeatures {
static constexpr AttributeId Id = 0x0000002C;
} // namespace LocalProgrammingFeatures

namespace WrongCodeEntryLimit {
static constexpr AttributeId Id = 0x00000030;
} // namespace WrongCodeEntryLimit

namespace UserCodeTemporaryDisableTime {
static constexpr AttributeId Id = 0x00000031;
} // namespace UserCodeTemporaryDisableTime

namespace SendPINOverTheAir {
static constexpr AttributeId Id = 0x00000032;
} // namespace SendPINOverTheAir

namespace RequirePINforRemoteOperation {
static constexpr AttributeId Id = 0x00000033;
} // namespace RequirePINforRemoteOperation

namespace ExpiringUserTimeout {
static constexpr AttributeId Id = 0x00000035;
} // namespace ExpiringUserTimeout

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace DoorLock

namespace WindowCovering {
namespace Attributes {

namespace Type {
static constexpr AttributeId Id = 0x00000000;
} // namespace Type

namespace PhysicalClosedLimitLift {
static constexpr AttributeId Id = 0x00000001;
} // namespace PhysicalClosedLimitLift

namespace PhysicalClosedLimitTilt {
static constexpr AttributeId Id = 0x00000002;
} // namespace PhysicalClosedLimitTilt

namespace CurrentPositionLift {
static constexpr AttributeId Id = 0x00000003;
} // namespace CurrentPositionLift

namespace CurrentPositionTilt {
static constexpr AttributeId Id = 0x00000004;
} // namespace CurrentPositionTilt

namespace NumberOfActuationsLift {
static constexpr AttributeId Id = 0x00000005;
} // namespace NumberOfActuationsLift

namespace NumberOfActuationsTilt {
static constexpr AttributeId Id = 0x00000006;
} // namespace NumberOfActuationsTilt

namespace ConfigStatus {
static constexpr AttributeId Id = 0x00000007;
} // namespace ConfigStatus

namespace CurrentPositionLiftPercentage {
static constexpr AttributeId Id = 0x00000008;
} // namespace CurrentPositionLiftPercentage

namespace CurrentPositionTiltPercentage {
static constexpr AttributeId Id = 0x00000009;
} // namespace CurrentPositionTiltPercentage

namespace OperationalStatus {
static constexpr AttributeId Id = 0x0000000A;
} // namespace OperationalStatus

namespace TargetPositionLiftPercent100ths {
static constexpr AttributeId Id = 0x0000000B;
} // namespace TargetPositionLiftPercent100ths

namespace TargetPositionTiltPercent100ths {
static constexpr AttributeId Id = 0x0000000C;
} // namespace TargetPositionTiltPercent100ths

namespace EndProductType {
static constexpr AttributeId Id = 0x0000000D;
} // namespace EndProductType

namespace CurrentPositionLiftPercent100ths {
static constexpr AttributeId Id = 0x0000000E;
} // namespace CurrentPositionLiftPercent100ths

namespace CurrentPositionTiltPercent100ths {
static constexpr AttributeId Id = 0x0000000F;
} // namespace CurrentPositionTiltPercent100ths

namespace InstalledOpenLimitLift {
static constexpr AttributeId Id = 0x00000010;
} // namespace InstalledOpenLimitLift

namespace InstalledClosedLimitLift {
static constexpr AttributeId Id = 0x00000011;
} // namespace InstalledClosedLimitLift

namespace InstalledOpenLimitTilt {
static constexpr AttributeId Id = 0x00000012;
} // namespace InstalledOpenLimitTilt

namespace InstalledClosedLimitTilt {
static constexpr AttributeId Id = 0x00000013;
} // namespace InstalledClosedLimitTilt

namespace Mode {
static constexpr AttributeId Id = 0x00000017;
} // namespace Mode

namespace SafetyStatus {
static constexpr AttributeId Id = 0x0000001A;
} // namespace SafetyStatus

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace WindowCovering

namespace BarrierControl {
namespace Attributes {

namespace BarrierMovingState {
static constexpr AttributeId Id = 0x00000001;
} // namespace BarrierMovingState

namespace BarrierSafetyStatus {
static constexpr AttributeId Id = 0x00000002;
} // namespace BarrierSafetyStatus

namespace BarrierCapabilities {
static constexpr AttributeId Id = 0x00000003;
} // namespace BarrierCapabilities

namespace BarrierOpenEvents {
static constexpr AttributeId Id = 0x00000004;
} // namespace BarrierOpenEvents

namespace BarrierCloseEvents {
static constexpr AttributeId Id = 0x00000005;
} // namespace BarrierCloseEvents

namespace BarrierCommandOpenEvents {
static constexpr AttributeId Id = 0x00000006;
} // namespace BarrierCommandOpenEvents

namespace BarrierCommandCloseEvents {
static constexpr AttributeId Id = 0x00000007;
} // namespace BarrierCommandCloseEvents

namespace BarrierOpenPeriod {
static constexpr AttributeId Id = 0x00000008;
} // namespace BarrierOpenPeriod

namespace BarrierClosePeriod {
static constexpr AttributeId Id = 0x00000009;
} // namespace BarrierClosePeriod

namespace BarrierPosition {
static constexpr AttributeId Id = 0x0000000A;
} // namespace BarrierPosition

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace BarrierControl

namespace PumpConfigurationAndControl {
namespace Attributes {

namespace MaxPressure {
static constexpr AttributeId Id = 0x00000000;
} // namespace MaxPressure

namespace MaxSpeed {
static constexpr AttributeId Id = 0x00000001;
} // namespace MaxSpeed

namespace MaxFlow {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxFlow

namespace MinConstPressure {
static constexpr AttributeId Id = 0x00000003;
} // namespace MinConstPressure

namespace MaxConstPressure {
static constexpr AttributeId Id = 0x00000004;
} // namespace MaxConstPressure

namespace MinCompPressure {
static constexpr AttributeId Id = 0x00000005;
} // namespace MinCompPressure

namespace MaxCompPressure {
static constexpr AttributeId Id = 0x00000006;
} // namespace MaxCompPressure

namespace MinConstSpeed {
static constexpr AttributeId Id = 0x00000007;
} // namespace MinConstSpeed

namespace MaxConstSpeed {
static constexpr AttributeId Id = 0x00000008;
} // namespace MaxConstSpeed

namespace MinConstFlow {
static constexpr AttributeId Id = 0x00000009;
} // namespace MinConstFlow

namespace MaxConstFlow {
static constexpr AttributeId Id = 0x0000000A;
} // namespace MaxConstFlow

namespace MinConstTemp {
static constexpr AttributeId Id = 0x0000000B;
} // namespace MinConstTemp

namespace MaxConstTemp {
static constexpr AttributeId Id = 0x0000000C;
} // namespace MaxConstTemp

namespace PumpStatus {
static constexpr AttributeId Id = 0x00000010;
} // namespace PumpStatus

namespace EffectiveOperationMode {
static constexpr AttributeId Id = 0x00000011;
} // namespace EffectiveOperationMode

namespace EffectiveControlMode {
static constexpr AttributeId Id = 0x00000012;
} // namespace EffectiveControlMode

namespace Capacity {
static constexpr AttributeId Id = 0x00000013;
} // namespace Capacity

namespace Speed {
static constexpr AttributeId Id = 0x00000014;
} // namespace Speed

namespace LifetimeRunningHours {
static constexpr AttributeId Id = 0x00000015;
} // namespace LifetimeRunningHours

namespace Power {
static constexpr AttributeId Id = 0x00000016;
} // namespace Power

namespace LifetimeEnergyConsumed {
static constexpr AttributeId Id = 0x00000017;
} // namespace LifetimeEnergyConsumed

namespace OperationMode {
static constexpr AttributeId Id = 0x00000020;
} // namespace OperationMode

namespace ControlMode {
static constexpr AttributeId Id = 0x00000021;
} // namespace ControlMode

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace PumpConfigurationAndControl

namespace Thermostat {
namespace Attributes {

namespace LocalTemperature {
static constexpr AttributeId Id = 0x00000000;
} // namespace LocalTemperature

namespace OutdoorTemperature {
static constexpr AttributeId Id = 0x00000001;
} // namespace OutdoorTemperature

namespace Occupancy {
static constexpr AttributeId Id = 0x00000002;
} // namespace Occupancy

namespace AbsMinHeatSetpointLimit {
static constexpr AttributeId Id = 0x00000003;
} // namespace AbsMinHeatSetpointLimit

namespace AbsMaxHeatSetpointLimit {
static constexpr AttributeId Id = 0x00000004;
} // namespace AbsMaxHeatSetpointLimit

namespace AbsMinCoolSetpointLimit {
static constexpr AttributeId Id = 0x00000005;
} // namespace AbsMinCoolSetpointLimit

namespace AbsMaxCoolSetpointLimit {
static constexpr AttributeId Id = 0x00000006;
} // namespace AbsMaxCoolSetpointLimit

namespace PICoolingDemand {
static constexpr AttributeId Id = 0x00000007;
} // namespace PICoolingDemand

namespace PIHeatingDemand {
static constexpr AttributeId Id = 0x00000008;
} // namespace PIHeatingDemand

namespace HVACSystemTypeConfiguration {
static constexpr AttributeId Id = 0x00000009;
} // namespace HVACSystemTypeConfiguration

namespace LocalTemperatureCalibration {
static constexpr AttributeId Id = 0x00000010;
} // namespace LocalTemperatureCalibration

namespace OccupiedCoolingSetpoint {
static constexpr AttributeId Id = 0x00000011;
} // namespace OccupiedCoolingSetpoint

namespace OccupiedHeatingSetpoint {
static constexpr AttributeId Id = 0x00000012;
} // namespace OccupiedHeatingSetpoint

namespace UnoccupiedCoolingSetpoint {
static constexpr AttributeId Id = 0x00000013;
} // namespace UnoccupiedCoolingSetpoint

namespace UnoccupiedHeatingSetpoint {
static constexpr AttributeId Id = 0x00000014;
} // namespace UnoccupiedHeatingSetpoint

namespace MinHeatSetpointLimit {
static constexpr AttributeId Id = 0x00000015;
} // namespace MinHeatSetpointLimit

namespace MaxHeatSetpointLimit {
static constexpr AttributeId Id = 0x00000016;
} // namespace MaxHeatSetpointLimit

namespace MinCoolSetpointLimit {
static constexpr AttributeId Id = 0x00000017;
} // namespace MinCoolSetpointLimit

namespace MaxCoolSetpointLimit {
static constexpr AttributeId Id = 0x00000018;
} // namespace MaxCoolSetpointLimit

namespace MinSetpointDeadBand {
static constexpr AttributeId Id = 0x00000019;
} // namespace MinSetpointDeadBand

namespace RemoteSensing {
static constexpr AttributeId Id = 0x0000001A;
} // namespace RemoteSensing

namespace ControlSequenceOfOperation {
static constexpr AttributeId Id = 0x0000001B;
} // namespace ControlSequenceOfOperation

namespace SystemMode {
static constexpr AttributeId Id = 0x0000001C;
} // namespace SystemMode

namespace ThermostatRunningMode {
static constexpr AttributeId Id = 0x0000001E;
} // namespace ThermostatRunningMode

namespace StartOfWeek {
static constexpr AttributeId Id = 0x00000020;
} // namespace StartOfWeek

namespace NumberOfWeeklyTransitions {
static constexpr AttributeId Id = 0x00000021;
} // namespace NumberOfWeeklyTransitions

namespace NumberOfDailyTransitions {
static constexpr AttributeId Id = 0x00000022;
} // namespace NumberOfDailyTransitions

namespace TemperatureSetpointHold {
static constexpr AttributeId Id = 0x00000023;
} // namespace TemperatureSetpointHold

namespace TemperatureSetpointHoldDuration {
static constexpr AttributeId Id = 0x00000024;
} // namespace TemperatureSetpointHoldDuration

namespace ThermostatProgrammingOperationMode {
static constexpr AttributeId Id = 0x00000025;
} // namespace ThermostatProgrammingOperationMode

namespace ThermostatRunningState {
static constexpr AttributeId Id = 0x00000029;
} // namespace ThermostatRunningState

namespace SetpointChangeSource {
static constexpr AttributeId Id = 0x00000030;
} // namespace SetpointChangeSource

namespace SetpointChangeAmount {
static constexpr AttributeId Id = 0x00000031;
} // namespace SetpointChangeAmount

namespace SetpointChangeSourceTimestamp {
static constexpr AttributeId Id = 0x00000032;
} // namespace SetpointChangeSourceTimestamp

namespace OccupiedSetback {
static constexpr AttributeId Id = 0x00000034;
} // namespace OccupiedSetback

namespace OccupiedSetbackMin {
static constexpr AttributeId Id = 0x00000035;
} // namespace OccupiedSetbackMin

namespace OccupiedSetbackMax {
static constexpr AttributeId Id = 0x00000036;
} // namespace OccupiedSetbackMax

namespace UnoccupiedSetback {
static constexpr AttributeId Id = 0x00000037;
} // namespace UnoccupiedSetback

namespace UnoccupiedSetbackMin {
static constexpr AttributeId Id = 0x00000038;
} // namespace UnoccupiedSetbackMin

namespace UnoccupiedSetbackMax {
static constexpr AttributeId Id = 0x00000039;
} // namespace UnoccupiedSetbackMax

namespace EmergencyHeatDelta {
static constexpr AttributeId Id = 0x0000003A;
} // namespace EmergencyHeatDelta

namespace ACType {
static constexpr AttributeId Id = 0x00000040;
} // namespace ACType

namespace ACCapacity {
static constexpr AttributeId Id = 0x00000041;
} // namespace ACCapacity

namespace ACRefrigerantType {
static constexpr AttributeId Id = 0x00000042;
} // namespace ACRefrigerantType

namespace ACCompressorType {
static constexpr AttributeId Id = 0x00000043;
} // namespace ACCompressorType

namespace ACErrorCode {
static constexpr AttributeId Id = 0x00000044;
} // namespace ACErrorCode

namespace ACLouverPosition {
static constexpr AttributeId Id = 0x00000045;
} // namespace ACLouverPosition

namespace ACCoilTemperature {
static constexpr AttributeId Id = 0x00000046;
} // namespace ACCoilTemperature

namespace ACCapacityformat {
static constexpr AttributeId Id = 0x00000047;
} // namespace ACCapacityformat

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Thermostat

namespace FanControl {
namespace Attributes {

namespace FanMode {
static constexpr AttributeId Id = 0x00000000;
} // namespace FanMode

namespace FanModeSequence {
static constexpr AttributeId Id = 0x00000001;
} // namespace FanModeSequence

namespace PercentSetting {
static constexpr AttributeId Id = 0x00000002;
} // namespace PercentSetting

namespace PercentCurrent {
static constexpr AttributeId Id = 0x00000003;
} // namespace PercentCurrent

namespace SpeedMax {
static constexpr AttributeId Id = 0x00000004;
} // namespace SpeedMax

namespace SpeedSetting {
static constexpr AttributeId Id = 0x00000005;
} // namespace SpeedSetting

namespace SpeedCurrent {
static constexpr AttributeId Id = 0x00000006;
} // namespace SpeedCurrent

namespace RockSupport {
static constexpr AttributeId Id = 0x00000007;
} // namespace RockSupport

namespace RockSetting {
static constexpr AttributeId Id = 0x00000008;
} // namespace RockSetting

namespace WindSupport {
static constexpr AttributeId Id = 0x00000009;
} // namespace WindSupport

namespace WindSetting {
static constexpr AttributeId Id = 0x0000000A;
} // namespace WindSetting

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace FanControl

namespace ThermostatUserInterfaceConfiguration {
namespace Attributes {

namespace TemperatureDisplayMode {
static constexpr AttributeId Id = 0x00000000;
} // namespace TemperatureDisplayMode

namespace KeypadLockout {
static constexpr AttributeId Id = 0x00000001;
} // namespace KeypadLockout

namespace ScheduleProgrammingVisibility {
static constexpr AttributeId Id = 0x00000002;
} // namespace ScheduleProgrammingVisibility

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ThermostatUserInterfaceConfiguration

namespace ColorControl {
namespace Attributes {

namespace CurrentHue {
static constexpr AttributeId Id = 0x00000000;
} // namespace CurrentHue

namespace CurrentSaturation {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentSaturation

namespace RemainingTime {
static constexpr AttributeId Id = 0x00000002;
} // namespace RemainingTime

namespace CurrentX {
static constexpr AttributeId Id = 0x00000003;
} // namespace CurrentX

namespace CurrentY {
static constexpr AttributeId Id = 0x00000004;
} // namespace CurrentY

namespace DriftCompensation {
static constexpr AttributeId Id = 0x00000005;
} // namespace DriftCompensation

namespace CompensationText {
static constexpr AttributeId Id = 0x00000006;
} // namespace CompensationText

namespace ColorTemperatureMireds {
static constexpr AttributeId Id = 0x00000007;
} // namespace ColorTemperatureMireds

namespace ColorMode {
static constexpr AttributeId Id = 0x00000008;
} // namespace ColorMode

namespace Options {
static constexpr AttributeId Id = 0x0000000F;
} // namespace Options

namespace NumberOfPrimaries {
static constexpr AttributeId Id = 0x00000010;
} // namespace NumberOfPrimaries

namespace Primary1X {
static constexpr AttributeId Id = 0x00000011;
} // namespace Primary1X

namespace Primary1Y {
static constexpr AttributeId Id = 0x00000012;
} // namespace Primary1Y

namespace Primary1Intensity {
static constexpr AttributeId Id = 0x00000013;
} // namespace Primary1Intensity

namespace Primary2X {
static constexpr AttributeId Id = 0x00000015;
} // namespace Primary2X

namespace Primary2Y {
static constexpr AttributeId Id = 0x00000016;
} // namespace Primary2Y

namespace Primary2Intensity {
static constexpr AttributeId Id = 0x00000017;
} // namespace Primary2Intensity

namespace Primary3X {
static constexpr AttributeId Id = 0x00000019;
} // namespace Primary3X

namespace Primary3Y {
static constexpr AttributeId Id = 0x0000001A;
} // namespace Primary3Y

namespace Primary3Intensity {
static constexpr AttributeId Id = 0x0000001B;
} // namespace Primary3Intensity

namespace Primary4X {
static constexpr AttributeId Id = 0x00000020;
} // namespace Primary4X

namespace Primary4Y {
static constexpr AttributeId Id = 0x00000021;
} // namespace Primary4Y

namespace Primary4Intensity {
static constexpr AttributeId Id = 0x00000022;
} // namespace Primary4Intensity

namespace Primary5X {
static constexpr AttributeId Id = 0x00000024;
} // namespace Primary5X

namespace Primary5Y {
static constexpr AttributeId Id = 0x00000025;
} // namespace Primary5Y

namespace Primary5Intensity {
static constexpr AttributeId Id = 0x00000026;
} // namespace Primary5Intensity

namespace Primary6X {
static constexpr AttributeId Id = 0x00000028;
} // namespace Primary6X

namespace Primary6Y {
static constexpr AttributeId Id = 0x00000029;
} // namespace Primary6Y

namespace Primary6Intensity {
static constexpr AttributeId Id = 0x0000002A;
} // namespace Primary6Intensity

namespace WhitePointX {
static constexpr AttributeId Id = 0x00000030;
} // namespace WhitePointX

namespace WhitePointY {
static constexpr AttributeId Id = 0x00000031;
} // namespace WhitePointY

namespace ColorPointRX {
static constexpr AttributeId Id = 0x00000032;
} // namespace ColorPointRX

namespace ColorPointRY {
static constexpr AttributeId Id = 0x00000033;
} // namespace ColorPointRY

namespace ColorPointRIntensity {
static constexpr AttributeId Id = 0x00000034;
} // namespace ColorPointRIntensity

namespace ColorPointGX {
static constexpr AttributeId Id = 0x00000036;
} // namespace ColorPointGX

namespace ColorPointGY {
static constexpr AttributeId Id = 0x00000037;
} // namespace ColorPointGY

namespace ColorPointGIntensity {
static constexpr AttributeId Id = 0x00000038;
} // namespace ColorPointGIntensity

namespace ColorPointBX {
static constexpr AttributeId Id = 0x0000003A;
} // namespace ColorPointBX

namespace ColorPointBY {
static constexpr AttributeId Id = 0x0000003B;
} // namespace ColorPointBY

namespace ColorPointBIntensity {
static constexpr AttributeId Id = 0x0000003C;
} // namespace ColorPointBIntensity

namespace EnhancedCurrentHue {
static constexpr AttributeId Id = 0x00004000;
} // namespace EnhancedCurrentHue

namespace EnhancedColorMode {
static constexpr AttributeId Id = 0x00004001;
} // namespace EnhancedColorMode

namespace ColorLoopActive {
static constexpr AttributeId Id = 0x00004002;
} // namespace ColorLoopActive

namespace ColorLoopDirection {
static constexpr AttributeId Id = 0x00004003;
} // namespace ColorLoopDirection

namespace ColorLoopTime {
static constexpr AttributeId Id = 0x00004004;
} // namespace ColorLoopTime

namespace ColorLoopStartEnhancedHue {
static constexpr AttributeId Id = 0x00004005;
} // namespace ColorLoopStartEnhancedHue

namespace ColorLoopStoredEnhancedHue {
static constexpr AttributeId Id = 0x00004006;
} // namespace ColorLoopStoredEnhancedHue

namespace ColorCapabilities {
static constexpr AttributeId Id = 0x0000400A;
} // namespace ColorCapabilities

namespace ColorTempPhysicalMinMireds {
static constexpr AttributeId Id = 0x0000400B;
} // namespace ColorTempPhysicalMinMireds

namespace ColorTempPhysicalMaxMireds {
static constexpr AttributeId Id = 0x0000400C;
} // namespace ColorTempPhysicalMaxMireds

namespace CoupleColorTempToLevelMinMireds {
static constexpr AttributeId Id = 0x0000400D;
} // namespace CoupleColorTempToLevelMinMireds

namespace StartUpColorTemperatureMireds {
static constexpr AttributeId Id = 0x00004010;
} // namespace StartUpColorTemperatureMireds

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ColorControl

namespace BallastConfiguration {
namespace Attributes {

namespace PhysicalMinLevel {
static constexpr AttributeId Id = 0x00000000;
} // namespace PhysicalMinLevel

namespace PhysicalMaxLevel {
static constexpr AttributeId Id = 0x00000001;
} // namespace PhysicalMaxLevel

namespace BallastStatus {
static constexpr AttributeId Id = 0x00000002;
} // namespace BallastStatus

namespace MinLevel {
static constexpr AttributeId Id = 0x00000010;
} // namespace MinLevel

namespace MaxLevel {
static constexpr AttributeId Id = 0x00000011;
} // namespace MaxLevel

namespace IntrinsicBalanceFactor {
static constexpr AttributeId Id = 0x00000014;
} // namespace IntrinsicBalanceFactor

namespace BallastFactorAdjustment {
static constexpr AttributeId Id = 0x00000015;
} // namespace BallastFactorAdjustment

namespace LampQuantity {
static constexpr AttributeId Id = 0x00000020;
} // namespace LampQuantity

namespace LampType {
static constexpr AttributeId Id = 0x00000030;
} // namespace LampType

namespace LampManufacturer {
static constexpr AttributeId Id = 0x00000031;
} // namespace LampManufacturer

namespace LampRatedHours {
static constexpr AttributeId Id = 0x00000032;
} // namespace LampRatedHours

namespace LampBurnHours {
static constexpr AttributeId Id = 0x00000033;
} // namespace LampBurnHours

namespace LampAlarmMode {
static constexpr AttributeId Id = 0x00000034;
} // namespace LampAlarmMode

namespace LampBurnHoursTripPoint {
static constexpr AttributeId Id = 0x00000035;
} // namespace LampBurnHoursTripPoint

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace BallastConfiguration

namespace IlluminanceMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace Tolerance {
static constexpr AttributeId Id = 0x00000003;
} // namespace Tolerance

namespace LightSensorType {
static constexpr AttributeId Id = 0x00000004;
} // namespace LightSensorType

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace IlluminanceMeasurement

namespace TemperatureMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace Tolerance {
static constexpr AttributeId Id = 0x00000003;
} // namespace Tolerance

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace TemperatureMeasurement

namespace PressureMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace Tolerance {
static constexpr AttributeId Id = 0x00000003;
} // namespace Tolerance

namespace ScaledValue {
static constexpr AttributeId Id = 0x00000010;
} // namespace ScaledValue

namespace MinScaledValue {
static constexpr AttributeId Id = 0x00000011;
} // namespace MinScaledValue

namespace MaxScaledValue {
static constexpr AttributeId Id = 0x00000012;
} // namespace MaxScaledValue

namespace ScaledTolerance {
static constexpr AttributeId Id = 0x00000013;
} // namespace ScaledTolerance

namespace Scale {
static constexpr AttributeId Id = 0x00000014;
} // namespace Scale

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace PressureMeasurement

namespace FlowMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace Tolerance {
static constexpr AttributeId Id = 0x00000003;
} // namespace Tolerance

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace FlowMeasurement

namespace RelativeHumidityMeasurement {
namespace Attributes {

namespace MeasuredValue {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasuredValue

namespace MinMeasuredValue {
static constexpr AttributeId Id = 0x00000001;
} // namespace MinMeasuredValue

namespace MaxMeasuredValue {
static constexpr AttributeId Id = 0x00000002;
} // namespace MaxMeasuredValue

namespace Tolerance {
static constexpr AttributeId Id = 0x00000003;
} // namespace Tolerance

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace RelativeHumidityMeasurement

namespace OccupancySensing {
namespace Attributes {

namespace Occupancy {
static constexpr AttributeId Id = 0x00000000;
} // namespace Occupancy

namespace OccupancySensorType {
static constexpr AttributeId Id = 0x00000001;
} // namespace OccupancySensorType

namespace OccupancySensorTypeBitmap {
static constexpr AttributeId Id = 0x00000002;
} // namespace OccupancySensorTypeBitmap

namespace PirOccupiedToUnoccupiedDelay {
static constexpr AttributeId Id = 0x00000010;
} // namespace PirOccupiedToUnoccupiedDelay

namespace PirUnoccupiedToOccupiedDelay {
static constexpr AttributeId Id = 0x00000011;
} // namespace PirUnoccupiedToOccupiedDelay

namespace PirUnoccupiedToOccupiedThreshold {
static constexpr AttributeId Id = 0x00000012;
} // namespace PirUnoccupiedToOccupiedThreshold

namespace UltrasonicOccupiedToUnoccupiedDelay {
static constexpr AttributeId Id = 0x00000020;
} // namespace UltrasonicOccupiedToUnoccupiedDelay

namespace UltrasonicUnoccupiedToOccupiedDelay {
static constexpr AttributeId Id = 0x00000021;
} // namespace UltrasonicUnoccupiedToOccupiedDelay

namespace UltrasonicUnoccupiedToOccupiedThreshold {
static constexpr AttributeId Id = 0x00000022;
} // namespace UltrasonicUnoccupiedToOccupiedThreshold

namespace PhysicalContactOccupiedToUnoccupiedDelay {
static constexpr AttributeId Id = 0x00000030;
} // namespace PhysicalContactOccupiedToUnoccupiedDelay

namespace PhysicalContactUnoccupiedToOccupiedDelay {
static constexpr AttributeId Id = 0x00000031;
} // namespace PhysicalContactUnoccupiedToOccupiedDelay

namespace PhysicalContactUnoccupiedToOccupiedThreshold {
static constexpr AttributeId Id = 0x00000032;
} // namespace PhysicalContactUnoccupiedToOccupiedThreshold

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace OccupancySensing

namespace WakeOnLan {
namespace Attributes {

namespace MACAddress {
static constexpr AttributeId Id = 0x00000000;
} // namespace MACAddress

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace WakeOnLan

namespace Channel {
namespace Attributes {

namespace ChannelList {
static constexpr AttributeId Id = 0x00000000;
} // namespace ChannelList

namespace Lineup {
static constexpr AttributeId Id = 0x00000001;
} // namespace Lineup

namespace CurrentChannel {
static constexpr AttributeId Id = 0x00000002;
} // namespace CurrentChannel

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace Channel

namespace TargetNavigator {
namespace Attributes {

namespace TargetList {
static constexpr AttributeId Id = 0x00000000;
} // namespace TargetList

namespace CurrentTarget {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentTarget

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace TargetNavigator

namespace MediaPlayback {
namespace Attributes {

namespace CurrentState {
static constexpr AttributeId Id = 0x00000000;
} // namespace CurrentState

namespace StartTime {
static constexpr AttributeId Id = 0x00000001;
} // namespace StartTime

namespace Duration {
static constexpr AttributeId Id = 0x00000002;
} // namespace Duration

namespace SampledPosition {
static constexpr AttributeId Id = 0x00000003;
} // namespace SampledPosition

namespace PlaybackSpeed {
static constexpr AttributeId Id = 0x00000004;
} // namespace PlaybackSpeed

namespace SeekRangeEnd {
static constexpr AttributeId Id = 0x00000005;
} // namespace SeekRangeEnd

namespace SeekRangeStart {
static constexpr AttributeId Id = 0x00000006;
} // namespace SeekRangeStart

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace MediaPlayback

namespace MediaInput {
namespace Attributes {

namespace InputList {
static constexpr AttributeId Id = 0x00000000;
} // namespace InputList

namespace CurrentInput {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentInput

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace MediaInput

namespace LowPower {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace LowPower

namespace KeypadInput {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace KeypadInput

namespace ContentLauncher {
namespace Attributes {

namespace AcceptHeader {
static constexpr AttributeId Id = 0x00000000;
} // namespace AcceptHeader

namespace SupportedStreamingProtocols {
static constexpr AttributeId Id = 0x00000001;
} // namespace SupportedStreamingProtocols

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ContentLauncher

namespace AudioOutput {
namespace Attributes {

namespace OutputList {
static constexpr AttributeId Id = 0x00000000;
} // namespace OutputList

namespace CurrentOutput {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentOutput

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace AudioOutput

namespace ApplicationLauncher {
namespace Attributes {

namespace CatalogList {
static constexpr AttributeId Id = 0x00000000;
} // namespace CatalogList

namespace CurrentApp {
static constexpr AttributeId Id = 0x00000001;
} // namespace CurrentApp

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ApplicationLauncher

namespace ApplicationBasic {
namespace Attributes {

namespace VendorName {
static constexpr AttributeId Id = 0x00000000;
} // namespace VendorName

namespace VendorID {
static constexpr AttributeId Id = 0x00000001;
} // namespace VendorID

namespace ApplicationName {
static constexpr AttributeId Id = 0x00000002;
} // namespace ApplicationName

namespace ProductID {
static constexpr AttributeId Id = 0x00000003;
} // namespace ProductID

namespace Application {
static constexpr AttributeId Id = 0x00000004;
} // namespace Application

namespace Status {
static constexpr AttributeId Id = 0x00000005;
} // namespace Status

namespace ApplicationVersion {
static constexpr AttributeId Id = 0x00000006;
} // namespace ApplicationVersion

namespace AllowedVendorList {
static constexpr AttributeId Id = 0x00000007;
} // namespace AllowedVendorList

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ApplicationBasic

namespace AccountLogin {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace AccountLogin

namespace ElectricalMeasurement {
namespace Attributes {

namespace MeasurementType {
static constexpr AttributeId Id = 0x00000000;
} // namespace MeasurementType

namespace DcVoltage {
static constexpr AttributeId Id = 0x00000100;
} // namespace DcVoltage

namespace DcVoltageMin {
static constexpr AttributeId Id = 0x00000101;
} // namespace DcVoltageMin

namespace DcVoltageMax {
static constexpr AttributeId Id = 0x00000102;
} // namespace DcVoltageMax

namespace DcCurrent {
static constexpr AttributeId Id = 0x00000103;
} // namespace DcCurrent

namespace DcCurrentMin {
static constexpr AttributeId Id = 0x00000104;
} // namespace DcCurrentMin

namespace DcCurrentMax {
static constexpr AttributeId Id = 0x00000105;
} // namespace DcCurrentMax

namespace DcPower {
static constexpr AttributeId Id = 0x00000106;
} // namespace DcPower

namespace DcPowerMin {
static constexpr AttributeId Id = 0x00000107;
} // namespace DcPowerMin

namespace DcPowerMax {
static constexpr AttributeId Id = 0x00000108;
} // namespace DcPowerMax

namespace DcVoltageMultiplier {
static constexpr AttributeId Id = 0x00000200;
} // namespace DcVoltageMultiplier

namespace DcVoltageDivisor {
static constexpr AttributeId Id = 0x00000201;
} // namespace DcVoltageDivisor

namespace DcCurrentMultiplier {
static constexpr AttributeId Id = 0x00000202;
} // namespace DcCurrentMultiplier

namespace DcCurrentDivisor {
static constexpr AttributeId Id = 0x00000203;
} // namespace DcCurrentDivisor

namespace DcPowerMultiplier {
static constexpr AttributeId Id = 0x00000204;
} // namespace DcPowerMultiplier

namespace DcPowerDivisor {
static constexpr AttributeId Id = 0x00000205;
} // namespace DcPowerDivisor

namespace AcFrequency {
static constexpr AttributeId Id = 0x00000300;
} // namespace AcFrequency

namespace AcFrequencyMin {
static constexpr AttributeId Id = 0x00000301;
} // namespace AcFrequencyMin

namespace AcFrequencyMax {
static constexpr AttributeId Id = 0x00000302;
} // namespace AcFrequencyMax

namespace NeutralCurrent {
static constexpr AttributeId Id = 0x00000303;
} // namespace NeutralCurrent

namespace TotalActivePower {
static constexpr AttributeId Id = 0x00000304;
} // namespace TotalActivePower

namespace TotalReactivePower {
static constexpr AttributeId Id = 0x00000305;
} // namespace TotalReactivePower

namespace TotalApparentPower {
static constexpr AttributeId Id = 0x00000306;
} // namespace TotalApparentPower

namespace Measured1stHarmonicCurrent {
static constexpr AttributeId Id = 0x00000307;
} // namespace Measured1stHarmonicCurrent

namespace Measured3rdHarmonicCurrent {
static constexpr AttributeId Id = 0x00000308;
} // namespace Measured3rdHarmonicCurrent

namespace Measured5thHarmonicCurrent {
static constexpr AttributeId Id = 0x00000309;
} // namespace Measured5thHarmonicCurrent

namespace Measured7thHarmonicCurrent {
static constexpr AttributeId Id = 0x0000030A;
} // namespace Measured7thHarmonicCurrent

namespace Measured9thHarmonicCurrent {
static constexpr AttributeId Id = 0x0000030B;
} // namespace Measured9thHarmonicCurrent

namespace Measured11thHarmonicCurrent {
static constexpr AttributeId Id = 0x0000030C;
} // namespace Measured11thHarmonicCurrent

namespace MeasuredPhase1stHarmonicCurrent {
static constexpr AttributeId Id = 0x0000030D;
} // namespace MeasuredPhase1stHarmonicCurrent

namespace MeasuredPhase3rdHarmonicCurrent {
static constexpr AttributeId Id = 0x0000030E;
} // namespace MeasuredPhase3rdHarmonicCurrent

namespace MeasuredPhase5thHarmonicCurrent {
static constexpr AttributeId Id = 0x0000030F;
} // namespace MeasuredPhase5thHarmonicCurrent

namespace MeasuredPhase7thHarmonicCurrent {
static constexpr AttributeId Id = 0x00000310;
} // namespace MeasuredPhase7thHarmonicCurrent

namespace MeasuredPhase9thHarmonicCurrent {
static constexpr AttributeId Id = 0x00000311;
} // namespace MeasuredPhase9thHarmonicCurrent

namespace MeasuredPhase11thHarmonicCurrent {
static constexpr AttributeId Id = 0x00000312;
} // namespace MeasuredPhase11thHarmonicCurrent

namespace AcFrequencyMultiplier {
static constexpr AttributeId Id = 0x00000400;
} // namespace AcFrequencyMultiplier

namespace AcFrequencyDivisor {
static constexpr AttributeId Id = 0x00000401;
} // namespace AcFrequencyDivisor

namespace PowerMultiplier {
static constexpr AttributeId Id = 0x00000402;
} // namespace PowerMultiplier

namespace PowerDivisor {
static constexpr AttributeId Id = 0x00000403;
} // namespace PowerDivisor

namespace HarmonicCurrentMultiplier {
static constexpr AttributeId Id = 0x00000404;
} // namespace HarmonicCurrentMultiplier

namespace PhaseHarmonicCurrentMultiplier {
static constexpr AttributeId Id = 0x00000405;
} // namespace PhaseHarmonicCurrentMultiplier

namespace InstantaneousVoltage {
static constexpr AttributeId Id = 0x00000500;
} // namespace InstantaneousVoltage

namespace InstantaneousLineCurrent {
static constexpr AttributeId Id = 0x00000501;
} // namespace InstantaneousLineCurrent

namespace InstantaneousActiveCurrent {
static constexpr AttributeId Id = 0x00000502;
} // namespace InstantaneousActiveCurrent

namespace InstantaneousReactiveCurrent {
static constexpr AttributeId Id = 0x00000503;
} // namespace InstantaneousReactiveCurrent

namespace InstantaneousPower {
static constexpr AttributeId Id = 0x00000504;
} // namespace InstantaneousPower

namespace RmsVoltage {
static constexpr AttributeId Id = 0x00000505;
} // namespace RmsVoltage

namespace RmsVoltageMin {
static constexpr AttributeId Id = 0x00000506;
} // namespace RmsVoltageMin

namespace RmsVoltageMax {
static constexpr AttributeId Id = 0x00000507;
} // namespace RmsVoltageMax

namespace RmsCurrent {
static constexpr AttributeId Id = 0x00000508;
} // namespace RmsCurrent

namespace RmsCurrentMin {
static constexpr AttributeId Id = 0x00000509;
} // namespace RmsCurrentMin

namespace RmsCurrentMax {
static constexpr AttributeId Id = 0x0000050A;
} // namespace RmsCurrentMax

namespace ActivePower {
static constexpr AttributeId Id = 0x0000050B;
} // namespace ActivePower

namespace ActivePowerMin {
static constexpr AttributeId Id = 0x0000050C;
} // namespace ActivePowerMin

namespace ActivePowerMax {
static constexpr AttributeId Id = 0x0000050D;
} // namespace ActivePowerMax

namespace ReactivePower {
static constexpr AttributeId Id = 0x0000050E;
} // namespace ReactivePower

namespace ApparentPower {
static constexpr AttributeId Id = 0x0000050F;
} // namespace ApparentPower

namespace PowerFactor {
static constexpr AttributeId Id = 0x00000510;
} // namespace PowerFactor

namespace AverageRmsVoltageMeasurementPeriod {
static constexpr AttributeId Id = 0x00000511;
} // namespace AverageRmsVoltageMeasurementPeriod

namespace AverageRmsUnderVoltageCounter {
static constexpr AttributeId Id = 0x00000513;
} // namespace AverageRmsUnderVoltageCounter

namespace RmsExtremeOverVoltagePeriod {
static constexpr AttributeId Id = 0x00000514;
} // namespace RmsExtremeOverVoltagePeriod

namespace RmsExtremeUnderVoltagePeriod {
static constexpr AttributeId Id = 0x00000515;
} // namespace RmsExtremeUnderVoltagePeriod

namespace RmsVoltageSagPeriod {
static constexpr AttributeId Id = 0x00000516;
} // namespace RmsVoltageSagPeriod

namespace RmsVoltageSwellPeriod {
static constexpr AttributeId Id = 0x00000517;
} // namespace RmsVoltageSwellPeriod

namespace AcVoltageMultiplier {
static constexpr AttributeId Id = 0x00000600;
} // namespace AcVoltageMultiplier

namespace AcVoltageDivisor {
static constexpr AttributeId Id = 0x00000601;
} // namespace AcVoltageDivisor

namespace AcCurrentMultiplier {
static constexpr AttributeId Id = 0x00000602;
} // namespace AcCurrentMultiplier

namespace AcCurrentDivisor {
static constexpr AttributeId Id = 0x00000603;
} // namespace AcCurrentDivisor

namespace AcPowerMultiplier {
static constexpr AttributeId Id = 0x00000604;
} // namespace AcPowerMultiplier

namespace AcPowerDivisor {
static constexpr AttributeId Id = 0x00000605;
} // namespace AcPowerDivisor

namespace OverloadAlarmsMask {
static constexpr AttributeId Id = 0x00000700;
} // namespace OverloadAlarmsMask

namespace VoltageOverload {
static constexpr AttributeId Id = 0x00000701;
} // namespace VoltageOverload

namespace CurrentOverload {
static constexpr AttributeId Id = 0x00000702;
} // namespace CurrentOverload

namespace AcOverloadAlarmsMask {
static constexpr AttributeId Id = 0x00000800;
} // namespace AcOverloadAlarmsMask

namespace AcVoltageOverload {
static constexpr AttributeId Id = 0x00000801;
} // namespace AcVoltageOverload

namespace AcCurrentOverload {
static constexpr AttributeId Id = 0x00000802;
} // namespace AcCurrentOverload

namespace AcActivePowerOverload {
static constexpr AttributeId Id = 0x00000803;
} // namespace AcActivePowerOverload

namespace AcReactivePowerOverload {
static constexpr AttributeId Id = 0x00000804;
} // namespace AcReactivePowerOverload

namespace AverageRmsOverVoltage {
static constexpr AttributeId Id = 0x00000805;
} // namespace AverageRmsOverVoltage

namespace AverageRmsUnderVoltage {
static constexpr AttributeId Id = 0x00000806;
} // namespace AverageRmsUnderVoltage

namespace RmsExtremeOverVoltage {
static constexpr AttributeId Id = 0x00000807;
} // namespace RmsExtremeOverVoltage

namespace RmsExtremeUnderVoltage {
static constexpr AttributeId Id = 0x00000808;
} // namespace RmsExtremeUnderVoltage

namespace RmsVoltageSag {
static constexpr AttributeId Id = 0x00000809;
} // namespace RmsVoltageSag

namespace RmsVoltageSwell {
static constexpr AttributeId Id = 0x0000080A;
} // namespace RmsVoltageSwell

namespace LineCurrentPhaseB {
static constexpr AttributeId Id = 0x00000901;
} // namespace LineCurrentPhaseB

namespace ActiveCurrentPhaseB {
static constexpr AttributeId Id = 0x00000902;
} // namespace ActiveCurrentPhaseB

namespace ReactiveCurrentPhaseB {
static constexpr AttributeId Id = 0x00000903;
} // namespace ReactiveCurrentPhaseB

namespace RmsVoltagePhaseB {
static constexpr AttributeId Id = 0x00000905;
} // namespace RmsVoltagePhaseB

namespace RmsVoltageMinPhaseB {
static constexpr AttributeId Id = 0x00000906;
} // namespace RmsVoltageMinPhaseB

namespace RmsVoltageMaxPhaseB {
static constexpr AttributeId Id = 0x00000907;
} // namespace RmsVoltageMaxPhaseB

namespace RmsCurrentPhaseB {
static constexpr AttributeId Id = 0x00000908;
} // namespace RmsCurrentPhaseB

namespace RmsCurrentMinPhaseB {
static constexpr AttributeId Id = 0x00000909;
} // namespace RmsCurrentMinPhaseB

namespace RmsCurrentMaxPhaseB {
static constexpr AttributeId Id = 0x0000090A;
} // namespace RmsCurrentMaxPhaseB

namespace ActivePowerPhaseB {
static constexpr AttributeId Id = 0x0000090B;
} // namespace ActivePowerPhaseB

namespace ActivePowerMinPhaseB {
static constexpr AttributeId Id = 0x0000090C;
} // namespace ActivePowerMinPhaseB

namespace ActivePowerMaxPhaseB {
static constexpr AttributeId Id = 0x0000090D;
} // namespace ActivePowerMaxPhaseB

namespace ReactivePowerPhaseB {
static constexpr AttributeId Id = 0x0000090E;
} // namespace ReactivePowerPhaseB

namespace ApparentPowerPhaseB {
static constexpr AttributeId Id = 0x0000090F;
} // namespace ApparentPowerPhaseB

namespace PowerFactorPhaseB {
static constexpr AttributeId Id = 0x00000910;
} // namespace PowerFactorPhaseB

namespace AverageRmsVoltageMeasurementPeriodPhaseB {
static constexpr AttributeId Id = 0x00000911;
} // namespace AverageRmsVoltageMeasurementPeriodPhaseB

namespace AverageRmsOverVoltageCounterPhaseB {
static constexpr AttributeId Id = 0x00000912;
} // namespace AverageRmsOverVoltageCounterPhaseB

namespace AverageRmsUnderVoltageCounterPhaseB {
static constexpr AttributeId Id = 0x00000913;
} // namespace AverageRmsUnderVoltageCounterPhaseB

namespace RmsExtremeOverVoltagePeriodPhaseB {
static constexpr AttributeId Id = 0x00000914;
} // namespace RmsExtremeOverVoltagePeriodPhaseB

namespace RmsExtremeUnderVoltagePeriodPhaseB {
static constexpr AttributeId Id = 0x00000915;
} // namespace RmsExtremeUnderVoltagePeriodPhaseB

namespace RmsVoltageSagPeriodPhaseB {
static constexpr AttributeId Id = 0x00000916;
} // namespace RmsVoltageSagPeriodPhaseB

namespace RmsVoltageSwellPeriodPhaseB {
static constexpr AttributeId Id = 0x00000917;
} // namespace RmsVoltageSwellPeriodPhaseB

namespace LineCurrentPhaseC {
static constexpr AttributeId Id = 0x00000A01;
} // namespace LineCurrentPhaseC

namespace ActiveCurrentPhaseC {
static constexpr AttributeId Id = 0x00000A02;
} // namespace ActiveCurrentPhaseC

namespace ReactiveCurrentPhaseC {
static constexpr AttributeId Id = 0x00000A03;
} // namespace ReactiveCurrentPhaseC

namespace RmsVoltagePhaseC {
static constexpr AttributeId Id = 0x00000A05;
} // namespace RmsVoltagePhaseC

namespace RmsVoltageMinPhaseC {
static constexpr AttributeId Id = 0x00000A06;
} // namespace RmsVoltageMinPhaseC

namespace RmsVoltageMaxPhaseC {
static constexpr AttributeId Id = 0x00000A07;
} // namespace RmsVoltageMaxPhaseC

namespace RmsCurrentPhaseC {
static constexpr AttributeId Id = 0x00000A08;
} // namespace RmsCurrentPhaseC

namespace RmsCurrentMinPhaseC {
static constexpr AttributeId Id = 0x00000A09;
} // namespace RmsCurrentMinPhaseC

namespace RmsCurrentMaxPhaseC {
static constexpr AttributeId Id = 0x00000A0A;
} // namespace RmsCurrentMaxPhaseC

namespace ActivePowerPhaseC {
static constexpr AttributeId Id = 0x00000A0B;
} // namespace ActivePowerPhaseC

namespace ActivePowerMinPhaseC {
static constexpr AttributeId Id = 0x00000A0C;
} // namespace ActivePowerMinPhaseC

namespace ActivePowerMaxPhaseC {
static constexpr AttributeId Id = 0x00000A0D;
} // namespace ActivePowerMaxPhaseC

namespace ReactivePowerPhaseC {
static constexpr AttributeId Id = 0x00000A0E;
} // namespace ReactivePowerPhaseC

namespace ApparentPowerPhaseC {
static constexpr AttributeId Id = 0x00000A0F;
} // namespace ApparentPowerPhaseC

namespace PowerFactorPhaseC {
static constexpr AttributeId Id = 0x00000A10;
} // namespace PowerFactorPhaseC

namespace AverageRmsVoltageMeasurementPeriodPhaseC {
static constexpr AttributeId Id = 0x00000A11;
} // namespace AverageRmsVoltageMeasurementPeriodPhaseC

namespace AverageRmsOverVoltageCounterPhaseC {
static constexpr AttributeId Id = 0x00000A12;
} // namespace AverageRmsOverVoltageCounterPhaseC

namespace AverageRmsUnderVoltageCounterPhaseC {
static constexpr AttributeId Id = 0x00000A13;
} // namespace AverageRmsUnderVoltageCounterPhaseC

namespace RmsExtremeOverVoltagePeriodPhaseC {
static constexpr AttributeId Id = 0x00000A14;
} // namespace RmsExtremeOverVoltagePeriodPhaseC

namespace RmsExtremeUnderVoltagePeriodPhaseC {
static constexpr AttributeId Id = 0x00000A15;
} // namespace RmsExtremeUnderVoltagePeriodPhaseC

namespace RmsVoltageSagPeriodPhaseC {
static constexpr AttributeId Id = 0x00000A16;
} // namespace RmsVoltageSagPeriodPhaseC

namespace RmsVoltageSwellPeriodPhaseC {
static constexpr AttributeId Id = 0x00000A17;
} // namespace RmsVoltageSwellPeriodPhaseC

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace ElectricalMeasurement

namespace TestCluster {
namespace Attributes {

namespace Boolean {
static constexpr AttributeId Id = 0x00000000;
} // namespace Boolean

namespace Bitmap8 {
static constexpr AttributeId Id = 0x00000001;
} // namespace Bitmap8

namespace Bitmap16 {
static constexpr AttributeId Id = 0x00000002;
} // namespace Bitmap16

namespace Bitmap32 {
static constexpr AttributeId Id = 0x00000003;
} // namespace Bitmap32

namespace Bitmap64 {
static constexpr AttributeId Id = 0x00000004;
} // namespace Bitmap64

namespace Int8u {
static constexpr AttributeId Id = 0x00000005;
} // namespace Int8u

namespace Int16u {
static constexpr AttributeId Id = 0x00000006;
} // namespace Int16u

namespace Int24u {
static constexpr AttributeId Id = 0x00000007;
} // namespace Int24u

namespace Int32u {
static constexpr AttributeId Id = 0x00000008;
} // namespace Int32u

namespace Int40u {
static constexpr AttributeId Id = 0x00000009;
} // namespace Int40u

namespace Int48u {
static constexpr AttributeId Id = 0x0000000A;
} // namespace Int48u

namespace Int56u {
static constexpr AttributeId Id = 0x0000000B;
} // namespace Int56u

namespace Int64u {
static constexpr AttributeId Id = 0x0000000C;
} // namespace Int64u

namespace Int8s {
static constexpr AttributeId Id = 0x0000000D;
} // namespace Int8s

namespace Int16s {
static constexpr AttributeId Id = 0x0000000E;
} // namespace Int16s

namespace Int24s {
static constexpr AttributeId Id = 0x0000000F;
} // namespace Int24s

namespace Int32s {
static constexpr AttributeId Id = 0x00000010;
} // namespace Int32s

namespace Int40s {
static constexpr AttributeId Id = 0x00000011;
} // namespace Int40s

namespace Int48s {
static constexpr AttributeId Id = 0x00000012;
} // namespace Int48s

namespace Int56s {
static constexpr AttributeId Id = 0x00000013;
} // namespace Int56s

namespace Int64s {
static constexpr AttributeId Id = 0x00000014;
} // namespace Int64s

namespace Enum8 {
static constexpr AttributeId Id = 0x00000015;
} // namespace Enum8

namespace Enum16 {
static constexpr AttributeId Id = 0x00000016;
} // namespace Enum16

namespace FloatSingle {
static constexpr AttributeId Id = 0x00000017;
} // namespace FloatSingle

namespace FloatDouble {
static constexpr AttributeId Id = 0x00000018;
} // namespace FloatDouble

namespace OctetString {
static constexpr AttributeId Id = 0x00000019;
} // namespace OctetString

namespace ListInt8u {
static constexpr AttributeId Id = 0x0000001A;
} // namespace ListInt8u

namespace ListOctetString {
static constexpr AttributeId Id = 0x0000001B;
} // namespace ListOctetString

namespace ListStructOctetString {
static constexpr AttributeId Id = 0x0000001C;
} // namespace ListStructOctetString

namespace LongOctetString {
static constexpr AttributeId Id = 0x0000001D;
} // namespace LongOctetString

namespace CharString {
static constexpr AttributeId Id = 0x0000001E;
} // namespace CharString

namespace LongCharString {
static constexpr AttributeId Id = 0x0000001F;
} // namespace LongCharString

namespace EpochUs {
static constexpr AttributeId Id = 0x00000020;
} // namespace EpochUs

namespace EpochS {
static constexpr AttributeId Id = 0x00000021;
} // namespace EpochS

namespace VendorId {
static constexpr AttributeId Id = 0x00000022;
} // namespace VendorId

namespace ListNullablesAndOptionalsStruct {
static constexpr AttributeId Id = 0x00000023;
} // namespace ListNullablesAndOptionalsStruct

namespace EnumAttr {
static constexpr AttributeId Id = 0x00000024;
} // namespace EnumAttr

namespace StructAttr {
static constexpr AttributeId Id = 0x00000025;
} // namespace StructAttr

namespace RangeRestrictedInt8u {
static constexpr AttributeId Id = 0x00000026;
} // namespace RangeRestrictedInt8u

namespace RangeRestrictedInt8s {
static constexpr AttributeId Id = 0x00000027;
} // namespace RangeRestrictedInt8s

namespace RangeRestrictedInt16u {
static constexpr AttributeId Id = 0x00000028;
} // namespace RangeRestrictedInt16u

namespace RangeRestrictedInt16s {
static constexpr AttributeId Id = 0x00000029;
} // namespace RangeRestrictedInt16s

namespace ListLongOctetString {
static constexpr AttributeId Id = 0x0000002A;
} // namespace ListLongOctetString

namespace ListFabricScoped {
static constexpr AttributeId Id = 0x0000002B;
} // namespace ListFabricScoped

namespace TimedWriteBoolean {
static constexpr AttributeId Id = 0x00000030;
} // namespace TimedWriteBoolean

namespace GeneralErrorBoolean {
static constexpr AttributeId Id = 0x00000031;
} // namespace GeneralErrorBoolean

namespace ClusterErrorBoolean {
static constexpr AttributeId Id = 0x00000032;
} // namespace ClusterErrorBoolean

namespace Unsupported {
static constexpr AttributeId Id = 0x000000FF;
} // namespace Unsupported

namespace NullableBoolean {
static constexpr AttributeId Id = 0x00004000;
} // namespace NullableBoolean

namespace NullableBitmap8 {
static constexpr AttributeId Id = 0x00004001;
} // namespace NullableBitmap8

namespace NullableBitmap16 {
static constexpr AttributeId Id = 0x00004002;
} // namespace NullableBitmap16

namespace NullableBitmap32 {
static constexpr AttributeId Id = 0x00004003;
} // namespace NullableBitmap32

namespace NullableBitmap64 {
static constexpr AttributeId Id = 0x00004004;
} // namespace NullableBitmap64

namespace NullableInt8u {
static constexpr AttributeId Id = 0x00004005;
} // namespace NullableInt8u

namespace NullableInt16u {
static constexpr AttributeId Id = 0x00004006;
} // namespace NullableInt16u

namespace NullableInt24u {
static constexpr AttributeId Id = 0x00004007;
} // namespace NullableInt24u

namespace NullableInt32u {
static constexpr AttributeId Id = 0x00004008;
} // namespace NullableInt32u

namespace NullableInt40u {
static constexpr AttributeId Id = 0x00004009;
} // namespace NullableInt40u

namespace NullableInt48u {
static constexpr AttributeId Id = 0x0000400A;
} // namespace NullableInt48u

namespace NullableInt56u {
static constexpr AttributeId Id = 0x0000400B;
} // namespace NullableInt56u

namespace NullableInt64u {
static constexpr AttributeId Id = 0x0000400C;
} // namespace NullableInt64u

namespace NullableInt8s {
static constexpr AttributeId Id = 0x0000400D;
} // namespace NullableInt8s

namespace NullableInt16s {
static constexpr AttributeId Id = 0x0000400E;
} // namespace NullableInt16s

namespace NullableInt24s {
static constexpr AttributeId Id = 0x0000400F;
} // namespace NullableInt24s

namespace NullableInt32s {
static constexpr AttributeId Id = 0x00004010;
} // namespace NullableInt32s

namespace NullableInt40s {
static constexpr AttributeId Id = 0x00004011;
} // namespace NullableInt40s

namespace NullableInt48s {
static constexpr AttributeId Id = 0x00004012;
} // namespace NullableInt48s

namespace NullableInt56s {
static constexpr AttributeId Id = 0x00004013;
} // namespace NullableInt56s

namespace NullableInt64s {
static constexpr AttributeId Id = 0x00004014;
} // namespace NullableInt64s

namespace NullableEnum8 {
static constexpr AttributeId Id = 0x00004015;
} // namespace NullableEnum8

namespace NullableEnum16 {
static constexpr AttributeId Id = 0x00004016;
} // namespace NullableEnum16

namespace NullableFloatSingle {
static constexpr AttributeId Id = 0x00004017;
} // namespace NullableFloatSingle

namespace NullableFloatDouble {
static constexpr AttributeId Id = 0x00004018;
} // namespace NullableFloatDouble

namespace NullableOctetString {
static constexpr AttributeId Id = 0x00004019;
} // namespace NullableOctetString

namespace NullableCharString {
static constexpr AttributeId Id = 0x0000401E;
} // namespace NullableCharString

namespace NullableEnumAttr {
static constexpr AttributeId Id = 0x00004024;
} // namespace NullableEnumAttr

namespace NullableStruct {
static constexpr AttributeId Id = 0x00004025;
} // namespace NullableStruct

namespace NullableRangeRestrictedInt8u {
static constexpr AttributeId Id = 0x00004026;
} // namespace NullableRangeRestrictedInt8u

namespace NullableRangeRestrictedInt8s {
static constexpr AttributeId Id = 0x00004027;
} // namespace NullableRangeRestrictedInt8s

namespace NullableRangeRestrictedInt16u {
static constexpr AttributeId Id = 0x00004028;
} // namespace NullableRangeRestrictedInt16u

namespace NullableRangeRestrictedInt16s {
static constexpr AttributeId Id = 0x00004029;
} // namespace NullableRangeRestrictedInt16s

namespace WriteOnlyInt8u {
static constexpr AttributeId Id = 0x0000402A;
} // namespace WriteOnlyInt8u

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace TestCluster

namespace FaultInjection {
namespace Attributes {

namespace GeneratedCommandList {
static constexpr AttributeId Id = Globals::Attributes::GeneratedCommandList::Id;
} // namespace GeneratedCommandList

namespace AcceptedCommandList {
static constexpr AttributeId Id = Globals::Attributes::AcceptedCommandList::Id;
} // namespace AcceptedCommandList

namespace AttributeList {
static constexpr AttributeId Id = Globals::Attributes::AttributeList::Id;
} // namespace AttributeList

namespace FeatureMap {
static constexpr AttributeId Id = Globals::Attributes::FeatureMap::Id;
} // namespace FeatureMap

namespace ClusterRevision {
static constexpr AttributeId Id = Globals::Attributes::ClusterRevision::Id;
} // namespace ClusterRevision

} // namespace Attributes
} // namespace FaultInjection

} // namespace Clusters
} // namespace app
} // namespace chip
