/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

// Prevent multiple inclusion
#pragma once

// This is the mapping of IDs to cluster names assuming a format according
// to the "EmberAfClusterName" defined in the ZCL header.
// The names of clusters that are not present, are removed.

#if defined(ZCL_USING_IDENTIFY_CLUSTER_SERVER) || defined(ZCL_USING_IDENTIFY_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_IDENTIFY_CLUSTER { ZCL_IDENTIFY_CLUSTER_ID, "Identify" },
#else
#define CHIP_PRINTCLUSTER_IDENTIFY_CLUSTER
#endif

#if defined(ZCL_USING_GROUPS_CLUSTER_SERVER) || defined(ZCL_USING_GROUPS_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_GROUPS_CLUSTER { ZCL_GROUPS_CLUSTER_ID, "Groups" },
#else
#define CHIP_PRINTCLUSTER_GROUPS_CLUSTER
#endif

#if defined(ZCL_USING_SCENES_CLUSTER_SERVER) || defined(ZCL_USING_SCENES_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_SCENES_CLUSTER { ZCL_SCENES_CLUSTER_ID, "Scenes" },
#else
#define CHIP_PRINTCLUSTER_SCENES_CLUSTER
#endif

#if defined(ZCL_USING_ON_OFF_CLUSTER_SERVER) || defined(ZCL_USING_ON_OFF_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_ON_OFF_CLUSTER { ZCL_ON_OFF_CLUSTER_ID, "On/Off" },
#else
#define CHIP_PRINTCLUSTER_ON_OFF_CLUSTER
#endif

#if defined(ZCL_USING_ON_OFF_SWITCH_CONFIG_CLUSTER_SERVER) || defined(ZCL_USING_ON_OFF_SWITCH_CONFIG_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_ON_OFF_SWITCH_CONFIG_CLUSTER { ZCL_ON_OFF_SWITCH_CONFIG_CLUSTER_ID, "On/off Switch Configuration" },
#else
#define CHIP_PRINTCLUSTER_ON_OFF_SWITCH_CONFIG_CLUSTER
#endif

#if defined(ZCL_USING_LEVEL_CONTROL_CLUSTER_SERVER) || defined(ZCL_USING_LEVEL_CONTROL_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_LEVEL_CONTROL_CLUSTER { ZCL_LEVEL_CONTROL_CLUSTER_ID, "Level Control" },
#else
#define CHIP_PRINTCLUSTER_LEVEL_CONTROL_CLUSTER
#endif

#if defined(ZCL_USING_BINARY_INPUT_BASIC_CLUSTER_SERVER) || defined(ZCL_USING_BINARY_INPUT_BASIC_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_BINARY_INPUT_BASIC_CLUSTER { ZCL_BINARY_INPUT_BASIC_CLUSTER_ID, "Binary Input (Basic)" },
#else
#define CHIP_PRINTCLUSTER_BINARY_INPUT_BASIC_CLUSTER
#endif

#if defined(ZCL_USING_PWM_CLUSTER_SERVER) || defined(ZCL_USING_PWM_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_PWM_CLUSTER { ZCL_PWM_CLUSTER_ID, "Pulse Width Modulation" },
#else
#define CHIP_PRINTCLUSTER_PWM_CLUSTER
#endif

#if defined(ZCL_USING_DESCRIPTOR_CLUSTER_SERVER) || defined(ZCL_USING_DESCRIPTOR_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_DESCRIPTOR_CLUSTER { ZCL_DESCRIPTOR_CLUSTER_ID, "Descriptor" },
#else
#define CHIP_PRINTCLUSTER_DESCRIPTOR_CLUSTER
#endif

#if defined(ZCL_USING_BINDING_CLUSTER_SERVER) || defined(ZCL_USING_BINDING_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_BINDING_CLUSTER { ZCL_BINDING_CLUSTER_ID, "Binding" },
#else
#define CHIP_PRINTCLUSTER_BINDING_CLUSTER
#endif

#if defined(ZCL_USING_ACCESS_CONTROL_CLUSTER_SERVER) || defined(ZCL_USING_ACCESS_CONTROL_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_ACCESS_CONTROL_CLUSTER { ZCL_ACCESS_CONTROL_CLUSTER_ID, "Access Control" },
#else
#define CHIP_PRINTCLUSTER_ACCESS_CONTROL_CLUSTER
#endif

#if defined(ZCL_USING_ACTIONS_CLUSTER_SERVER) || defined(ZCL_USING_ACTIONS_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_ACTIONS_CLUSTER { ZCL_ACTIONS_CLUSTER_ID, "Actions" },
#else
#define CHIP_PRINTCLUSTER_ACTIONS_CLUSTER
#endif

#if defined(ZCL_USING_BASIC_CLUSTER_SERVER) || defined(ZCL_USING_BASIC_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_BASIC_CLUSTER { ZCL_BASIC_CLUSTER_ID, "Basic" },
#else
#define CHIP_PRINTCLUSTER_BASIC_CLUSTER
#endif

#if defined(ZCL_USING_OTA_PROVIDER_CLUSTER_SERVER) || defined(ZCL_USING_OTA_PROVIDER_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_OTA_PROVIDER_CLUSTER { ZCL_OTA_PROVIDER_CLUSTER_ID, "OTA Software Update Provider" },
#else
#define CHIP_PRINTCLUSTER_OTA_PROVIDER_CLUSTER
#endif

#if defined(ZCL_USING_OTA_REQUESTOR_CLUSTER_SERVER) || defined(ZCL_USING_OTA_REQUESTOR_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_OTA_REQUESTOR_CLUSTER { ZCL_OTA_REQUESTOR_CLUSTER_ID, "OTA Software Update Requestor" },
#else
#define CHIP_PRINTCLUSTER_OTA_REQUESTOR_CLUSTER
#endif

#if defined(ZCL_USING_LOCALIZATION_CONFIGURATION_CLUSTER_SERVER) || defined(ZCL_USING_LOCALIZATION_CONFIGURATION_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_LOCALIZATION_CONFIGURATION_CLUSTER                                                                       \
    { ZCL_LOCALIZATION_CONFIGURATION_CLUSTER_ID, "Localization Configuration" },
#else
#define CHIP_PRINTCLUSTER_LOCALIZATION_CONFIGURATION_CLUSTER
#endif

#if defined(ZCL_USING_TIME_FORMAT_LOCALIZATION_CLUSTER_SERVER) || defined(ZCL_USING_TIME_FORMAT_LOCALIZATION_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_TIME_FORMAT_LOCALIZATION_CLUSTER { ZCL_TIME_FORMAT_LOCALIZATION_CLUSTER_ID, "Time Format Localization" },
#else
#define CHIP_PRINTCLUSTER_TIME_FORMAT_LOCALIZATION_CLUSTER
#endif

#if defined(ZCL_USING_UNIT_LOCALIZATION_CLUSTER_SERVER) || defined(ZCL_USING_UNIT_LOCALIZATION_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_UNIT_LOCALIZATION_CLUSTER { ZCL_UNIT_LOCALIZATION_CLUSTER_ID, "Unit Localization" },
#else
#define CHIP_PRINTCLUSTER_UNIT_LOCALIZATION_CLUSTER
#endif

#if defined(ZCL_USING_POWER_SOURCE_CONFIGURATION_CLUSTER_SERVER) || defined(ZCL_USING_POWER_SOURCE_CONFIGURATION_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_POWER_SOURCE_CONFIGURATION_CLUSTER                                                                       \
    { ZCL_POWER_SOURCE_CONFIGURATION_CLUSTER_ID, "Power Source Configuration" },
#else
#define CHIP_PRINTCLUSTER_POWER_SOURCE_CONFIGURATION_CLUSTER
#endif

#if defined(ZCL_USING_POWER_SOURCE_CLUSTER_SERVER) || defined(ZCL_USING_POWER_SOURCE_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_POWER_SOURCE_CLUSTER { ZCL_POWER_SOURCE_CLUSTER_ID, "Power Source" },
#else
#define CHIP_PRINTCLUSTER_POWER_SOURCE_CLUSTER
#endif

#if defined(ZCL_USING_GENERAL_COMMISSIONING_CLUSTER_SERVER) || defined(ZCL_USING_GENERAL_COMMISSIONING_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_GENERAL_COMMISSIONING_CLUSTER { ZCL_GENERAL_COMMISSIONING_CLUSTER_ID, "General Commissioning" },
#else
#define CHIP_PRINTCLUSTER_GENERAL_COMMISSIONING_CLUSTER
#endif

#if defined(ZCL_USING_NETWORK_COMMISSIONING_CLUSTER_SERVER) || defined(ZCL_USING_NETWORK_COMMISSIONING_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_NETWORK_COMMISSIONING_CLUSTER { ZCL_NETWORK_COMMISSIONING_CLUSTER_ID, "Network Commissioning" },
#else
#define CHIP_PRINTCLUSTER_NETWORK_COMMISSIONING_CLUSTER
#endif

#if defined(ZCL_USING_DIAGNOSTIC_LOGS_CLUSTER_SERVER) || defined(ZCL_USING_DIAGNOSTIC_LOGS_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_DIAGNOSTIC_LOGS_CLUSTER { ZCL_DIAGNOSTIC_LOGS_CLUSTER_ID, "Diagnostic Logs" },
#else
#define CHIP_PRINTCLUSTER_DIAGNOSTIC_LOGS_CLUSTER
#endif

#if defined(ZCL_USING_GENERAL_DIAGNOSTICS_CLUSTER_SERVER) || defined(ZCL_USING_GENERAL_DIAGNOSTICS_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_GENERAL_DIAGNOSTICS_CLUSTER { ZCL_GENERAL_DIAGNOSTICS_CLUSTER_ID, "General Diagnostics" },
#else
#define CHIP_PRINTCLUSTER_GENERAL_DIAGNOSTICS_CLUSTER
#endif

#if defined(ZCL_USING_SOFTWARE_DIAGNOSTICS_CLUSTER_SERVER) || defined(ZCL_USING_SOFTWARE_DIAGNOSTICS_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_SOFTWARE_DIAGNOSTICS_CLUSTER { ZCL_SOFTWARE_DIAGNOSTICS_CLUSTER_ID, "Software Diagnostics" },
#else
#define CHIP_PRINTCLUSTER_SOFTWARE_DIAGNOSTICS_CLUSTER
#endif

#if defined(ZCL_USING_THREAD_NETWORK_DIAGNOSTICS_CLUSTER_SERVER) || defined(ZCL_USING_THREAD_NETWORK_DIAGNOSTICS_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_THREAD_NETWORK_DIAGNOSTICS_CLUSTER                                                                       \
    { ZCL_THREAD_NETWORK_DIAGNOSTICS_CLUSTER_ID, "Thread Network Diagnostics" },
#else
#define CHIP_PRINTCLUSTER_THREAD_NETWORK_DIAGNOSTICS_CLUSTER
#endif

#if defined(ZCL_USING_WIFI_NETWORK_DIAGNOSTICS_CLUSTER_SERVER) || defined(ZCL_USING_WIFI_NETWORK_DIAGNOSTICS_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_WIFI_NETWORK_DIAGNOSTICS_CLUSTER { ZCL_WIFI_NETWORK_DIAGNOSTICS_CLUSTER_ID, "WiFi Network Diagnostics" },
#else
#define CHIP_PRINTCLUSTER_WIFI_NETWORK_DIAGNOSTICS_CLUSTER
#endif

#if defined(ZCL_USING_ETHERNET_NETWORK_DIAGNOSTICS_CLUSTER_SERVER) || defined(ZCL_USING_ETHERNET_NETWORK_DIAGNOSTICS_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_ETHERNET_NETWORK_DIAGNOSTICS_CLUSTER                                                                     \
    { ZCL_ETHERNET_NETWORK_DIAGNOSTICS_CLUSTER_ID, "Ethernet Network Diagnostics" },
#else
#define CHIP_PRINTCLUSTER_ETHERNET_NETWORK_DIAGNOSTICS_CLUSTER
#endif

#if defined(ZCL_USING_TIME_SYNCHRONIZATION_CLUSTER_SERVER) || defined(ZCL_USING_TIME_SYNCHRONIZATION_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_TIME_SYNCHRONIZATION_CLUSTER { ZCL_TIME_SYNCHRONIZATION_CLUSTER_ID, "Time Synchronization" },
#else
#define CHIP_PRINTCLUSTER_TIME_SYNCHRONIZATION_CLUSTER
#endif

#if defined(ZCL_USING_BRIDGED_DEVICE_BASIC_CLUSTER_SERVER) || defined(ZCL_USING_BRIDGED_DEVICE_BASIC_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_BRIDGED_DEVICE_BASIC_CLUSTER { ZCL_BRIDGED_DEVICE_BASIC_CLUSTER_ID, "Bridged Device Basic" },
#else
#define CHIP_PRINTCLUSTER_BRIDGED_DEVICE_BASIC_CLUSTER
#endif

#if defined(ZCL_USING_SWITCH_CLUSTER_SERVER) || defined(ZCL_USING_SWITCH_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_SWITCH_CLUSTER { ZCL_SWITCH_CLUSTER_ID, "Switch" },
#else
#define CHIP_PRINTCLUSTER_SWITCH_CLUSTER
#endif

#if defined(ZCL_USING_ADMINISTRATOR_COMMISSIONING_CLUSTER_SERVER) || defined(ZCL_USING_ADMINISTRATOR_COMMISSIONING_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_ADMINISTRATOR_COMMISSIONING_CLUSTER                                                                      \
    { ZCL_ADMINISTRATOR_COMMISSIONING_CLUSTER_ID, "AdministratorCommissioning" },
#else
#define CHIP_PRINTCLUSTER_ADMINISTRATOR_COMMISSIONING_CLUSTER
#endif

#if defined(ZCL_USING_OPERATIONAL_CREDENTIALS_CLUSTER_SERVER) || defined(ZCL_USING_OPERATIONAL_CREDENTIALS_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_OPERATIONAL_CREDENTIALS_CLUSTER { ZCL_OPERATIONAL_CREDENTIALS_CLUSTER_ID, "Operational Credentials" },
#else
#define CHIP_PRINTCLUSTER_OPERATIONAL_CREDENTIALS_CLUSTER
#endif

#if defined(ZCL_USING_GROUP_KEY_MANAGEMENT_CLUSTER_SERVER) || defined(ZCL_USING_GROUP_KEY_MANAGEMENT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_GROUP_KEY_MANAGEMENT_CLUSTER { ZCL_GROUP_KEY_MANAGEMENT_CLUSTER_ID, "Group Key Management" },
#else
#define CHIP_PRINTCLUSTER_GROUP_KEY_MANAGEMENT_CLUSTER
#endif

#if defined(ZCL_USING_FIXED_LABEL_CLUSTER_SERVER) || defined(ZCL_USING_FIXED_LABEL_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_FIXED_LABEL_CLUSTER { ZCL_FIXED_LABEL_CLUSTER_ID, "Fixed Label" },
#else
#define CHIP_PRINTCLUSTER_FIXED_LABEL_CLUSTER
#endif

#if defined(ZCL_USING_USER_LABEL_CLUSTER_SERVER) || defined(ZCL_USING_USER_LABEL_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_USER_LABEL_CLUSTER { ZCL_USER_LABEL_CLUSTER_ID, "User Label" },
#else
#define CHIP_PRINTCLUSTER_USER_LABEL_CLUSTER
#endif

#if defined(ZCL_USING_PROXY_CONFIGURATION_CLUSTER_SERVER) || defined(ZCL_USING_PROXY_CONFIGURATION_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_PROXY_CONFIGURATION_CLUSTER { ZCL_PROXY_CONFIGURATION_CLUSTER_ID, "Proxy Configuration" },
#else
#define CHIP_PRINTCLUSTER_PROXY_CONFIGURATION_CLUSTER
#endif

#if defined(ZCL_USING_PROXY_DISCOVERY_CLUSTER_SERVER) || defined(ZCL_USING_PROXY_DISCOVERY_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_PROXY_DISCOVERY_CLUSTER { ZCL_PROXY_DISCOVERY_CLUSTER_ID, "Proxy Discovery" },
#else
#define CHIP_PRINTCLUSTER_PROXY_DISCOVERY_CLUSTER
#endif

#if defined(ZCL_USING_PROXY_VALID_CLUSTER_SERVER) || defined(ZCL_USING_PROXY_VALID_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_PROXY_VALID_CLUSTER { ZCL_PROXY_VALID_CLUSTER_ID, "Proxy Valid" },
#else
#define CHIP_PRINTCLUSTER_PROXY_VALID_CLUSTER
#endif

#if defined(ZCL_USING_BOOLEAN_STATE_CLUSTER_SERVER) || defined(ZCL_USING_BOOLEAN_STATE_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_BOOLEAN_STATE_CLUSTER { ZCL_BOOLEAN_STATE_CLUSTER_ID, "Boolean State" },
#else
#define CHIP_PRINTCLUSTER_BOOLEAN_STATE_CLUSTER
#endif

#if defined(ZCL_USING_MODE_SELECT_CLUSTER_SERVER) || defined(ZCL_USING_MODE_SELECT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_MODE_SELECT_CLUSTER { ZCL_MODE_SELECT_CLUSTER_ID, "Mode Select" },
#else
#define CHIP_PRINTCLUSTER_MODE_SELECT_CLUSTER
#endif

#if defined(ZCL_USING_DOOR_LOCK_CLUSTER_SERVER) || defined(ZCL_USING_DOOR_LOCK_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_DOOR_LOCK_CLUSTER { ZCL_DOOR_LOCK_CLUSTER_ID, "Door Lock" },
#else
#define CHIP_PRINTCLUSTER_DOOR_LOCK_CLUSTER
#endif

#if defined(ZCL_USING_WINDOW_COVERING_CLUSTER_SERVER) || defined(ZCL_USING_WINDOW_COVERING_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_WINDOW_COVERING_CLUSTER { ZCL_WINDOW_COVERING_CLUSTER_ID, "Window Covering" },
#else
#define CHIP_PRINTCLUSTER_WINDOW_COVERING_CLUSTER
#endif

#if defined(ZCL_USING_BARRIER_CONTROL_CLUSTER_SERVER) || defined(ZCL_USING_BARRIER_CONTROL_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_BARRIER_CONTROL_CLUSTER { ZCL_BARRIER_CONTROL_CLUSTER_ID, "Barrier Control" },
#else
#define CHIP_PRINTCLUSTER_BARRIER_CONTROL_CLUSTER
#endif

#if defined(ZCL_USING_PUMP_CONFIG_CONTROL_CLUSTER_SERVER) || defined(ZCL_USING_PUMP_CONFIG_CONTROL_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_PUMP_CONFIG_CONTROL_CLUSTER { ZCL_PUMP_CONFIG_CONTROL_CLUSTER_ID, "Pump Configuration and Control" },
#else
#define CHIP_PRINTCLUSTER_PUMP_CONFIG_CONTROL_CLUSTER
#endif

#if defined(ZCL_USING_THERMOSTAT_CLUSTER_SERVER) || defined(ZCL_USING_THERMOSTAT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_THERMOSTAT_CLUSTER { ZCL_THERMOSTAT_CLUSTER_ID, "Thermostat" },
#else
#define CHIP_PRINTCLUSTER_THERMOSTAT_CLUSTER
#endif

#if defined(ZCL_USING_FAN_CONTROL_CLUSTER_SERVER) || defined(ZCL_USING_FAN_CONTROL_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_FAN_CONTROL_CLUSTER { ZCL_FAN_CONTROL_CLUSTER_ID, "Fan Control" },
#else
#define CHIP_PRINTCLUSTER_FAN_CONTROL_CLUSTER
#endif

#if defined(ZCL_USING_THERMOSTAT_UI_CONFIG_CLUSTER_SERVER) || defined(ZCL_USING_THERMOSTAT_UI_CONFIG_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_THERMOSTAT_UI_CONFIG_CLUSTER                                                                             \
    { ZCL_THERMOSTAT_UI_CONFIG_CLUSTER_ID, "Thermostat User Interface Configuration" },
#else
#define CHIP_PRINTCLUSTER_THERMOSTAT_UI_CONFIG_CLUSTER
#endif

#if defined(ZCL_USING_COLOR_CONTROL_CLUSTER_SERVER) || defined(ZCL_USING_COLOR_CONTROL_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_COLOR_CONTROL_CLUSTER { ZCL_COLOR_CONTROL_CLUSTER_ID, "Color Control" },
#else
#define CHIP_PRINTCLUSTER_COLOR_CONTROL_CLUSTER
#endif

#if defined(ZCL_USING_BALLAST_CONFIGURATION_CLUSTER_SERVER) || defined(ZCL_USING_BALLAST_CONFIGURATION_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_BALLAST_CONFIGURATION_CLUSTER { ZCL_BALLAST_CONFIGURATION_CLUSTER_ID, "Ballast Configuration" },
#else
#define CHIP_PRINTCLUSTER_BALLAST_CONFIGURATION_CLUSTER
#endif

#if defined(ZCL_USING_ILLUMINANCE_MEASUREMENT_CLUSTER_SERVER) || defined(ZCL_USING_ILLUMINANCE_MEASUREMENT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_ILLUMINANCE_MEASUREMENT_CLUSTER { ZCL_ILLUMINANCE_MEASUREMENT_CLUSTER_ID, "Illuminance Measurement" },
#else
#define CHIP_PRINTCLUSTER_ILLUMINANCE_MEASUREMENT_CLUSTER
#endif

#if defined(ZCL_USING_TEMP_MEASUREMENT_CLUSTER_SERVER) || defined(ZCL_USING_TEMP_MEASUREMENT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_TEMP_MEASUREMENT_CLUSTER { ZCL_TEMP_MEASUREMENT_CLUSTER_ID, "Temperature Measurement" },
#else
#define CHIP_PRINTCLUSTER_TEMP_MEASUREMENT_CLUSTER
#endif

#if defined(ZCL_USING_PRESSURE_MEASUREMENT_CLUSTER_SERVER) || defined(ZCL_USING_PRESSURE_MEASUREMENT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_PRESSURE_MEASUREMENT_CLUSTER { ZCL_PRESSURE_MEASUREMENT_CLUSTER_ID, "Pressure Measurement" },
#else
#define CHIP_PRINTCLUSTER_PRESSURE_MEASUREMENT_CLUSTER
#endif

#if defined(ZCL_USING_FLOW_MEASUREMENT_CLUSTER_SERVER) || defined(ZCL_USING_FLOW_MEASUREMENT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_FLOW_MEASUREMENT_CLUSTER { ZCL_FLOW_MEASUREMENT_CLUSTER_ID, "Flow Measurement" },
#else
#define CHIP_PRINTCLUSTER_FLOW_MEASUREMENT_CLUSTER
#endif

#if defined(ZCL_USING_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER_SERVER) ||                                                             \
    defined(ZCL_USING_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER                                                                    \
    { ZCL_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER_ID, "Relative Humidity Measurement" },
#else
#define CHIP_PRINTCLUSTER_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER
#endif

#if defined(ZCL_USING_OCCUPANCY_SENSING_CLUSTER_SERVER) || defined(ZCL_USING_OCCUPANCY_SENSING_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_OCCUPANCY_SENSING_CLUSTER { ZCL_OCCUPANCY_SENSING_CLUSTER_ID, "Occupancy Sensing" },
#else
#define CHIP_PRINTCLUSTER_OCCUPANCY_SENSING_CLUSTER
#endif

#if defined(ZCL_USING_WAKE_ON_LAN_CLUSTER_SERVER) || defined(ZCL_USING_WAKE_ON_LAN_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_WAKE_ON_LAN_CLUSTER { ZCL_WAKE_ON_LAN_CLUSTER_ID, "Wake on LAN" },
#else
#define CHIP_PRINTCLUSTER_WAKE_ON_LAN_CLUSTER
#endif

#if defined(ZCL_USING_CHANNEL_CLUSTER_SERVER) || defined(ZCL_USING_CHANNEL_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_CHANNEL_CLUSTER { ZCL_CHANNEL_CLUSTER_ID, "Channel" },
#else
#define CHIP_PRINTCLUSTER_CHANNEL_CLUSTER
#endif

#if defined(ZCL_USING_TARGET_NAVIGATOR_CLUSTER_SERVER) || defined(ZCL_USING_TARGET_NAVIGATOR_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_TARGET_NAVIGATOR_CLUSTER { ZCL_TARGET_NAVIGATOR_CLUSTER_ID, "Target Navigator" },
#else
#define CHIP_PRINTCLUSTER_TARGET_NAVIGATOR_CLUSTER
#endif

#if defined(ZCL_USING_MEDIA_PLAYBACK_CLUSTER_SERVER) || defined(ZCL_USING_MEDIA_PLAYBACK_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_MEDIA_PLAYBACK_CLUSTER { ZCL_MEDIA_PLAYBACK_CLUSTER_ID, "Media Playback" },
#else
#define CHIP_PRINTCLUSTER_MEDIA_PLAYBACK_CLUSTER
#endif

#if defined(ZCL_USING_MEDIA_INPUT_CLUSTER_SERVER) || defined(ZCL_USING_MEDIA_INPUT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_MEDIA_INPUT_CLUSTER { ZCL_MEDIA_INPUT_CLUSTER_ID, "Media Input" },
#else
#define CHIP_PRINTCLUSTER_MEDIA_INPUT_CLUSTER
#endif

#if defined(ZCL_USING_LOW_POWER_CLUSTER_SERVER) || defined(ZCL_USING_LOW_POWER_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_LOW_POWER_CLUSTER { ZCL_LOW_POWER_CLUSTER_ID, "Low Power" },
#else
#define CHIP_PRINTCLUSTER_LOW_POWER_CLUSTER
#endif

#if defined(ZCL_USING_KEYPAD_INPUT_CLUSTER_SERVER) || defined(ZCL_USING_KEYPAD_INPUT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_KEYPAD_INPUT_CLUSTER { ZCL_KEYPAD_INPUT_CLUSTER_ID, "Keypad Input" },
#else
#define CHIP_PRINTCLUSTER_KEYPAD_INPUT_CLUSTER
#endif

#if defined(ZCL_USING_CONTENT_LAUNCH_CLUSTER_SERVER) || defined(ZCL_USING_CONTENT_LAUNCH_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_CONTENT_LAUNCH_CLUSTER { ZCL_CONTENT_LAUNCH_CLUSTER_ID, "Content Launcher" },
#else
#define CHIP_PRINTCLUSTER_CONTENT_LAUNCH_CLUSTER
#endif

#if defined(ZCL_USING_AUDIO_OUTPUT_CLUSTER_SERVER) || defined(ZCL_USING_AUDIO_OUTPUT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_AUDIO_OUTPUT_CLUSTER { ZCL_AUDIO_OUTPUT_CLUSTER_ID, "Audio Output" },
#else
#define CHIP_PRINTCLUSTER_AUDIO_OUTPUT_CLUSTER
#endif

#if defined(ZCL_USING_APPLICATION_LAUNCHER_CLUSTER_SERVER) || defined(ZCL_USING_APPLICATION_LAUNCHER_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_APPLICATION_LAUNCHER_CLUSTER { ZCL_APPLICATION_LAUNCHER_CLUSTER_ID, "Application Launcher" },
#else
#define CHIP_PRINTCLUSTER_APPLICATION_LAUNCHER_CLUSTER
#endif

#if defined(ZCL_USING_APPLICATION_BASIC_CLUSTER_SERVER) || defined(ZCL_USING_APPLICATION_BASIC_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_APPLICATION_BASIC_CLUSTER { ZCL_APPLICATION_BASIC_CLUSTER_ID, "Application Basic" },
#else
#define CHIP_PRINTCLUSTER_APPLICATION_BASIC_CLUSTER
#endif

#if defined(ZCL_USING_ACCOUNT_LOGIN_CLUSTER_SERVER) || defined(ZCL_USING_ACCOUNT_LOGIN_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_ACCOUNT_LOGIN_CLUSTER { ZCL_ACCOUNT_LOGIN_CLUSTER_ID, "Account Login" },
#else
#define CHIP_PRINTCLUSTER_ACCOUNT_LOGIN_CLUSTER
#endif

#if defined(ZCL_USING_ELECTRICAL_MEASUREMENT_CLUSTER_SERVER) || defined(ZCL_USING_ELECTRICAL_MEASUREMENT_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_ELECTRICAL_MEASUREMENT_CLUSTER { ZCL_ELECTRICAL_MEASUREMENT_CLUSTER_ID, "Electrical Measurement" },
#else
#define CHIP_PRINTCLUSTER_ELECTRICAL_MEASUREMENT_CLUSTER
#endif

#if defined(ZCL_USING_TEST_CLUSTER_SERVER) || defined(ZCL_USING_TEST_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_TEST_CLUSTER { ZCL_TEST_CLUSTER_ID, "Test Cluster" },
#else
#define CHIP_PRINTCLUSTER_TEST_CLUSTER
#endif

#if defined(ZCL_USING_FAULT_INJECTION_CLUSTER_SERVER) || defined(ZCL_USING_FAULT_INJECTION_CLUSTER_CLIENT)
#define CHIP_PRINTCLUSTER_FAULT_INJECTION_CLUSTER { ZCL_FAULT_INJECTION_CLUSTER_ID, "Fault Injection" },
#else
#define CHIP_PRINTCLUSTER_FAULT_INJECTION_CLUSTER
#endif

#define CLUSTER_IDS_TO_NAMES                                                                                                       \
    CHIP_PRINTCLUSTER_IDENTIFY_CLUSTER                                                                                             \
    CHIP_PRINTCLUSTER_GROUPS_CLUSTER                                                                                               \
    CHIP_PRINTCLUSTER_SCENES_CLUSTER                                                                                               \
    CHIP_PRINTCLUSTER_ON_OFF_CLUSTER                                                                                               \
    CHIP_PRINTCLUSTER_ON_OFF_SWITCH_CONFIG_CLUSTER                                                                                 \
    CHIP_PRINTCLUSTER_LEVEL_CONTROL_CLUSTER                                                                                        \
    CHIP_PRINTCLUSTER_BINARY_INPUT_BASIC_CLUSTER                                                                                   \
    CHIP_PRINTCLUSTER_PWM_CLUSTER                                                                                                  \
    CHIP_PRINTCLUSTER_DESCRIPTOR_CLUSTER                                                                                           \
    CHIP_PRINTCLUSTER_BINDING_CLUSTER                                                                                              \
    CHIP_PRINTCLUSTER_ACCESS_CONTROL_CLUSTER                                                                                       \
    CHIP_PRINTCLUSTER_ACTIONS_CLUSTER                                                                                              \
    CHIP_PRINTCLUSTER_BASIC_CLUSTER                                                                                                \
    CHIP_PRINTCLUSTER_OTA_PROVIDER_CLUSTER                                                                                         \
    CHIP_PRINTCLUSTER_OTA_REQUESTOR_CLUSTER                                                                                        \
    CHIP_PRINTCLUSTER_LOCALIZATION_CONFIGURATION_CLUSTER                                                                           \
    CHIP_PRINTCLUSTER_TIME_FORMAT_LOCALIZATION_CLUSTER                                                                             \
    CHIP_PRINTCLUSTER_UNIT_LOCALIZATION_CLUSTER                                                                                    \
    CHIP_PRINTCLUSTER_POWER_SOURCE_CONFIGURATION_CLUSTER                                                                           \
    CHIP_PRINTCLUSTER_POWER_SOURCE_CLUSTER                                                                                         \
    CHIP_PRINTCLUSTER_GENERAL_COMMISSIONING_CLUSTER                                                                                \
    CHIP_PRINTCLUSTER_NETWORK_COMMISSIONING_CLUSTER                                                                                \
    CHIP_PRINTCLUSTER_DIAGNOSTIC_LOGS_CLUSTER                                                                                      \
    CHIP_PRINTCLUSTER_GENERAL_DIAGNOSTICS_CLUSTER                                                                                  \
    CHIP_PRINTCLUSTER_SOFTWARE_DIAGNOSTICS_CLUSTER                                                                                 \
    CHIP_PRINTCLUSTER_THREAD_NETWORK_DIAGNOSTICS_CLUSTER                                                                           \
    CHIP_PRINTCLUSTER_WIFI_NETWORK_DIAGNOSTICS_CLUSTER                                                                             \
    CHIP_PRINTCLUSTER_ETHERNET_NETWORK_DIAGNOSTICS_CLUSTER                                                                         \
    CHIP_PRINTCLUSTER_TIME_SYNCHRONIZATION_CLUSTER                                                                                 \
    CHIP_PRINTCLUSTER_BRIDGED_DEVICE_BASIC_CLUSTER                                                                                 \
    CHIP_PRINTCLUSTER_SWITCH_CLUSTER                                                                                               \
    CHIP_PRINTCLUSTER_ADMINISTRATOR_COMMISSIONING_CLUSTER                                                                          \
    CHIP_PRINTCLUSTER_OPERATIONAL_CREDENTIALS_CLUSTER                                                                              \
    CHIP_PRINTCLUSTER_GROUP_KEY_MANAGEMENT_CLUSTER                                                                                 \
    CHIP_PRINTCLUSTER_FIXED_LABEL_CLUSTER                                                                                          \
    CHIP_PRINTCLUSTER_USER_LABEL_CLUSTER                                                                                           \
    CHIP_PRINTCLUSTER_PROXY_CONFIGURATION_CLUSTER                                                                                  \
    CHIP_PRINTCLUSTER_PROXY_DISCOVERY_CLUSTER                                                                                      \
    CHIP_PRINTCLUSTER_PROXY_VALID_CLUSTER                                                                                          \
    CHIP_PRINTCLUSTER_BOOLEAN_STATE_CLUSTER                                                                                        \
    CHIP_PRINTCLUSTER_MODE_SELECT_CLUSTER                                                                                          \
    CHIP_PRINTCLUSTER_DOOR_LOCK_CLUSTER                                                                                            \
    CHIP_PRINTCLUSTER_WINDOW_COVERING_CLUSTER                                                                                      \
    CHIP_PRINTCLUSTER_BARRIER_CONTROL_CLUSTER                                                                                      \
    CHIP_PRINTCLUSTER_PUMP_CONFIG_CONTROL_CLUSTER                                                                                  \
    CHIP_PRINTCLUSTER_THERMOSTAT_CLUSTER                                                                                           \
    CHIP_PRINTCLUSTER_FAN_CONTROL_CLUSTER                                                                                          \
    CHIP_PRINTCLUSTER_THERMOSTAT_UI_CONFIG_CLUSTER                                                                                 \
    CHIP_PRINTCLUSTER_COLOR_CONTROL_CLUSTER                                                                                        \
    CHIP_PRINTCLUSTER_BALLAST_CONFIGURATION_CLUSTER                                                                                \
    CHIP_PRINTCLUSTER_ILLUMINANCE_MEASUREMENT_CLUSTER                                                                              \
    CHIP_PRINTCLUSTER_TEMP_MEASUREMENT_CLUSTER                                                                                     \
    CHIP_PRINTCLUSTER_PRESSURE_MEASUREMENT_CLUSTER                                                                                 \
    CHIP_PRINTCLUSTER_FLOW_MEASUREMENT_CLUSTER                                                                                     \
    CHIP_PRINTCLUSTER_RELATIVE_HUMIDITY_MEASUREMENT_CLUSTER                                                                        \
    CHIP_PRINTCLUSTER_OCCUPANCY_SENSING_CLUSTER                                                                                    \
    CHIP_PRINTCLUSTER_WAKE_ON_LAN_CLUSTER                                                                                          \
    CHIP_PRINTCLUSTER_CHANNEL_CLUSTER                                                                                              \
    CHIP_PRINTCLUSTER_TARGET_NAVIGATOR_CLUSTER                                                                                     \
    CHIP_PRINTCLUSTER_MEDIA_PLAYBACK_CLUSTER                                                                                       \
    CHIP_PRINTCLUSTER_MEDIA_INPUT_CLUSTER                                                                                          \
    CHIP_PRINTCLUSTER_LOW_POWER_CLUSTER                                                                                            \
    CHIP_PRINTCLUSTER_KEYPAD_INPUT_CLUSTER                                                                                         \
    CHIP_PRINTCLUSTER_CONTENT_LAUNCH_CLUSTER                                                                                       \
    CHIP_PRINTCLUSTER_AUDIO_OUTPUT_CLUSTER                                                                                         \
    CHIP_PRINTCLUSTER_APPLICATION_LAUNCHER_CLUSTER                                                                                 \
    CHIP_PRINTCLUSTER_APPLICATION_BASIC_CLUSTER                                                                                    \
    CHIP_PRINTCLUSTER_ACCOUNT_LOGIN_CLUSTER                                                                                        \
    CHIP_PRINTCLUSTER_ELECTRICAL_MEASUREMENT_CLUSTER                                                                               \
    CHIP_PRINTCLUSTER_TEST_CLUSTER                                                                                                 \
    CHIP_PRINTCLUSTER_FAULT_INJECTION_CLUSTER

#define MAX_CLUSTER_NAME_LENGTH 39
