/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#include <commands/clusters/ComplexArgument.h>

CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("AccessControlEntry.privilege", "privilege", value.isMember("privilege")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("AccessControlEntry.authMode", "authMode", value.isMember("authMode")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("AccessControlEntry.subjects", "subjects", value.isMember("subjects")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("AccessControlEntry.targets", "targets", value.isMember("targets")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "privilege");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.privilege, value["privilege"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "authMode");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.authMode, value["authMode"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "subjects");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.subjects, value["subjects"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "targets");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.targets, value["targets"]));

    if (value.isMember("fabricIndex"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricIndex");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fabricIndex, value["fabricIndex"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type & request)
{
    ComplexArgumentParser::Finalize(request.privilege);
    ComplexArgumentParser::Finalize(request.authMode);
    ComplexArgumentParser::Finalize(request.subjects);
    ComplexArgumentParser::Finalize(request.targets);
    ComplexArgumentParser::Finalize(request.fabricIndex);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::Actions::Structs::ActionStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ActionStruct.actionID", "actionID", value.isMember("actionID")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ActionStruct.name", "name", value.isMember("name")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ActionStruct.type", "type", value.isMember("type")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ActionStruct.endpointListID", "endpointListID",
                                                                  value.isMember("endpointListID")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ActionStruct.supportedCommands", "supportedCommands",
                                                                  value.isMember("supportedCommands")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ActionStruct.state", "state", value.isMember("state")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "actionID");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.actionID, value["actionID"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "name");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.name, value["name"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "type");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.type, value["type"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "endpointListID");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.endpointListID, value["endpointListID"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "supportedCommands");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.supportedCommands, value["supportedCommands"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "state");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.state, value["state"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::Actions::Structs::ActionStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.actionID);
    ComplexArgumentParser::Finalize(request.name);
    ComplexArgumentParser::Finalize(request.type);
    ComplexArgumentParser::Finalize(request.endpointListID);
    ComplexArgumentParser::Finalize(request.supportedCommands);
    ComplexArgumentParser::Finalize(request.state);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ContentLauncher::Structs::AdditionalInfo::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("AdditionalInfo.name", "name", value.isMember("name")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("AdditionalInfo.value", "value", value.isMember("value")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "name");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.name, value["name"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "value");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.value, value["value"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ContentLauncher::Structs::AdditionalInfo::Type & request)
{
    ComplexArgumentParser::Finalize(request.name);
    ComplexArgumentParser::Finalize(request.value);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ApplicationLauncher::Structs::Application::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("Application.catalogVendorId", "catalogVendorId",
                                                                  value.isMember("catalogVendorId")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("Application.applicationId", "applicationId", value.isMember("applicationId")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "catalogVendorId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.catalogVendorId, value["catalogVendorId"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "applicationId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.applicationId, value["applicationId"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ApplicationLauncher::Structs::Application::Type & request)
{
    ComplexArgumentParser::Finalize(request.catalogVendorId);
    ComplexArgumentParser::Finalize(request.applicationId);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ApplicationBasic::Structs::ApplicationBasicApplication::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ApplicationBasicApplication.catalogVendorId", "catalogVendorId",
                                                                  value.isMember("catalogVendorId")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ApplicationBasicApplication.applicationId", "applicationId",
                                                                  value.isMember("applicationId")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "catalogVendorId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.catalogVendorId, value["catalogVendorId"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "applicationId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.applicationId, value["applicationId"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ApplicationBasic::Structs::ApplicationBasicApplication::Type & request)
{
    ComplexArgumentParser::Finalize(request.catalogVendorId);
    ComplexArgumentParser::Finalize(request.applicationId);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ApplicationLauncher::Structs::ApplicationEP::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("ApplicationEP.application", "application", value.isMember("application")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "application");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.application, value["application"]));

    if (value.isMember("endpoint"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "endpoint");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.endpoint, value["endpoint"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ApplicationLauncher::Structs::ApplicationEP::Type & request)
{
    ComplexArgumentParser::Finalize(request.application);
    ComplexArgumentParser::Finalize(request.endpoint);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::Scenes::Structs::AttributeValuePair::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("AttributeValuePair.attributeValue", "attributeValue",
                                                                  value.isMember("attributeValue")));

    char labelWithMember[kMaxLabelLength];
    if (value.isMember("attributeId"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "attributeId");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.attributeId, value["attributeId"]));
    }

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "attributeValue");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.attributeValue, value["attributeValue"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::Scenes::Structs::AttributeValuePair::Type & request)
{
    ComplexArgumentParser::Finalize(request.attributeId);
    ComplexArgumentParser::Finalize(request.attributeValue);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("BasicCommissioningInfo.failSafeExpiryLengthSeconds",
                                                                  "failSafeExpiryLengthSeconds",
                                                                  value.isMember("failSafeExpiryLengthSeconds")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("BasicCommissioningInfo.maxCumulativeFailsafeSeconds",
                                                                  "maxCumulativeFailsafeSeconds",
                                                                  value.isMember("maxCumulativeFailsafeSeconds")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "failSafeExpiryLengthSeconds");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.failSafeExpiryLengthSeconds, value["failSafeExpiryLengthSeconds"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "maxCumulativeFailsafeSeconds");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.maxCumulativeFailsafeSeconds, value["maxCumulativeFailsafeSeconds"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::Type & request)
{
    ComplexArgumentParser::Finalize(request.failSafeExpiryLengthSeconds);
    ComplexArgumentParser::Finalize(request.maxCumulativeFailsafeSeconds);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::PowerSource::Structs::BatChargeFaultChangeType::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("BatChargeFaultChangeType.current", "current", value.isMember("current")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("BatChargeFaultChangeType.previous", "previous", value.isMember("previous")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "current");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.current, value["current"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "previous");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.previous, value["previous"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::PowerSource::Structs::BatChargeFaultChangeType::Type & request)
{
    ComplexArgumentParser::Finalize(request.current);
    ComplexArgumentParser::Finalize(request.previous);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::PowerSource::Structs::BatFaultChangeType::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("BatFaultChangeType.current", "current", value.isMember("current")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("BatFaultChangeType.previous", "previous", value.isMember("previous")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "current");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.current, value["current"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "previous");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.previous, value["previous"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::PowerSource::Structs::BatFaultChangeType::Type & request)
{
    ComplexArgumentParser::Finalize(request.current);
    ComplexArgumentParser::Finalize(request.previous);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ContentLauncher::Structs::BrandingInformation::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("BrandingInformation.providerName", "providerName",
                                                                  value.isMember("providerName")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "providerName");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.providerName, value["providerName"]));

    if (value.isMember("background"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "background");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.background, value["background"]));
    }

    if (value.isMember("logo"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "logo");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.logo, value["logo"]));
    }

    if (value.isMember("progressBar"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "progressBar");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.progressBar, value["progressBar"]));
    }

    if (value.isMember("splash"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "splash");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.splash, value["splash"]));
    }

    if (value.isMember("waterMark"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "waterMark");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.waterMark, value["waterMark"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ContentLauncher::Structs::BrandingInformation::Type & request)
{
    ComplexArgumentParser::Finalize(request.providerName);
    ComplexArgumentParser::Finalize(request.background);
    ComplexArgumentParser::Finalize(request.logo);
    ComplexArgumentParser::Finalize(request.progressBar);
    ComplexArgumentParser::Finalize(request.splash);
    ComplexArgumentParser::Finalize(request.waterMark);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::Basic::Structs::CapabilityMinimaStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist(
        "CapabilityMinimaStruct.caseSessionsPerFabric", "caseSessionsPerFabric", value.isMember("caseSessionsPerFabric")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist(
        "CapabilityMinimaStruct.subscriptionsPerFabric", "subscriptionsPerFabric", value.isMember("subscriptionsPerFabric")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "caseSessionsPerFabric");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.caseSessionsPerFabric, value["caseSessionsPerFabric"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "subscriptionsPerFabric");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.subscriptionsPerFabric, value["subscriptionsPerFabric"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::Basic::Structs::CapabilityMinimaStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.caseSessionsPerFabric);
    ComplexArgumentParser::Finalize(request.subscriptionsPerFabric);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::Channel::Structs::ChannelInfo::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("ChannelInfo.majorNumber", "majorNumber", value.isMember("majorNumber")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("ChannelInfo.minorNumber", "minorNumber", value.isMember("minorNumber")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "majorNumber");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.majorNumber, value["majorNumber"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "minorNumber");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.minorNumber, value["minorNumber"]));

    if (value.isMember("name"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "name");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.name, value["name"]));
    }

    if (value.isMember("callSign"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "callSign");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.callSign, value["callSign"]));
    }

    if (value.isMember("affiliateCallSign"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "affiliateCallSign");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.affiliateCallSign, value["affiliateCallSign"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::Channel::Structs::ChannelInfo::Type & request)
{
    ComplexArgumentParser::Finalize(request.majorNumber);
    ComplexArgumentParser::Finalize(request.minorNumber);
    ComplexArgumentParser::Finalize(request.name);
    ComplexArgumentParser::Finalize(request.callSign);
    ComplexArgumentParser::Finalize(request.affiliateCallSign);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ContentLauncher::Structs::ContentSearch::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("ContentSearch.parameterList", "parameterList", value.isMember("parameterList")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "parameterList");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.parameterList, value["parameterList"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ContentLauncher::Structs::ContentSearch::Type & request)
{
    ComplexArgumentParser::Finalize(request.parameterList);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("DeviceTypeStruct.type", "type", value.isMember("type")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("DeviceTypeStruct.revision", "revision", value.isMember("revision")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "type");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.type, value["type"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "revision");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.revision, value["revision"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.type);
    ComplexArgumentParser::Finalize(request.revision);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ContentLauncher::Structs::Dimension::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("Dimension.width", "width", value.isMember("width")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("Dimension.height", "height", value.isMember("height")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("Dimension.metric", "metric", value.isMember("metric")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "width");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.width, value["width"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "height");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.height, value["height"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "metric");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.metric, value["metric"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ContentLauncher::Structs::Dimension::Type & request)
{
    ComplexArgumentParser::Finalize(request.width);
    ComplexArgumentParser::Finalize(request.height);
    ComplexArgumentParser::Finalize(request.metric);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::DoorLock::Structs::DlCredential::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("DlCredential.credentialType", "credentialType",
                                                                  value.isMember("credentialType")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("DlCredential.credentialIndex", "credentialIndex",
                                                                  value.isMember("credentialIndex")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "credentialType");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.credentialType, value["credentialType"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "credentialIndex");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.credentialIndex, value["credentialIndex"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::DoorLock::Structs::DlCredential::Type & request)
{
    ComplexArgumentParser::Finalize(request.credentialType);
    ComplexArgumentParser::Finalize(request.credentialIndex);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::TestCluster::Structs::DoubleNestedStructList::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("DoubleNestedStructList.a", "a", value.isMember("a")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "a");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.a, value["a"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::TestCluster::Structs::DoubleNestedStructList::Type & request)
{
    ComplexArgumentParser::Finalize(request.a);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::TimeSynchronization::Structs::DstOffsetType::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("DstOffsetType.offset", "offset", value.isMember("offset")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("DstOffsetType.validStarting", "validStarting", value.isMember("validStarting")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("DstOffsetType.validUntil", "validUntil", value.isMember("validUntil")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "offset");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.offset, value["offset"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "validStarting");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.validStarting, value["validStarting"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "validUntil");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.validUntil, value["validUntil"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::TimeSynchronization::Structs::DstOffsetType::Type & request)
{
    ComplexArgumentParser::Finalize(request.offset);
    ComplexArgumentParser::Finalize(request.validStarting);
    ComplexArgumentParser::Finalize(request.validUntil);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::Actions::Structs::EndpointListStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("EndpointListStruct.endpointListID", "endpointListID",
                                                                  value.isMember("endpointListID")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("EndpointListStruct.name", "name", value.isMember("name")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("EndpointListStruct.type", "type", value.isMember("type")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("EndpointListStruct.endpoints", "endpoints", value.isMember("endpoints")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "endpointListID");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.endpointListID, value["endpointListID"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "name");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.name, value["name"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "type");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.type, value["type"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "endpoints");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.endpoints, value["endpoints"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::Actions::Structs::EndpointListStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.endpointListID);
    ComplexArgumentParser::Finalize(request.name);
    ComplexArgumentParser::Finalize(request.type);
    ComplexArgumentParser::Finalize(request.endpoints);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::AccessControl::Structs::ExtensionEntry::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ExtensionEntry.data", "data", value.isMember("data")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "data");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.data, value["data"]));

    if (value.isMember("fabricIndex"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricIndex");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fabricIndex, value["fabricIndex"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::AccessControl::Structs::ExtensionEntry::Type & request)
{
    ComplexArgumentParser::Finalize(request.data);
    ComplexArgumentParser::Finalize(request.fabricIndex);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::Scenes::Structs::ExtensionFieldSet::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("ExtensionFieldSet.clusterId", "clusterId", value.isMember("clusterId")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ExtensionFieldSet.attributeValueList", "attributeValueList",
                                                                  value.isMember("attributeValueList")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "clusterId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.clusterId, value["clusterId"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "attributeValueList");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.attributeValueList, value["attributeValueList"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::Scenes::Structs::ExtensionFieldSet::Type & request)
{
    ComplexArgumentParser::Finalize(request.clusterId);
    ComplexArgumentParser::Finalize(request.attributeValueList);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptor::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("FabricDescriptor.rootPublicKey", "rootPublicKey",
                                                                  value.isMember("rootPublicKey")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("FabricDescriptor.vendorId", "vendorId", value.isMember("vendorId")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("FabricDescriptor.fabricId", "fabricId", value.isMember("fabricId")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("FabricDescriptor.nodeId", "nodeId", value.isMember("nodeId")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("FabricDescriptor.label", "label", value.isMember("label")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "rootPublicKey");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.rootPublicKey, value["rootPublicKey"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "vendorId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.vendorId, value["vendorId"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fabricId, value["fabricId"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nodeId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.nodeId, value["nodeId"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "label");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.label, value["label"]));

    if (value.isMember("fabricIndex"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricIndex");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fabricIndex, value["fabricIndex"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptor::Type & request)
{
    ComplexArgumentParser::Finalize(request.rootPublicKey);
    ComplexArgumentParser::Finalize(request.vendorId);
    ComplexArgumentParser::Finalize(request.fabricId);
    ComplexArgumentParser::Finalize(request.nodeId);
    ComplexArgumentParser::Finalize(request.label);
    ComplexArgumentParser::Finalize(request.fabricIndex);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("GroupInfoMapStruct.groupId", "groupId", value.isMember("groupId")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("GroupInfoMapStruct.endpoints", "endpoints", value.isMember("endpoints")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "groupId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.groupId, value["groupId"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "endpoints");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.endpoints, value["endpoints"]));

    if (value.isMember("groupName"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "groupName");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.groupName, value["groupName"]));
    }

    if (value.isMember("fabricIndex"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricIndex");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fabricIndex, value["fabricIndex"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.groupId);
    ComplexArgumentParser::Finalize(request.endpoints);
    ComplexArgumentParser::Finalize(request.groupName);
    ComplexArgumentParser::Finalize(request.fabricIndex);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("GroupKeyMapStruct.groupId", "groupId", value.isMember("groupId")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("GroupKeyMapStruct.groupKeySetID", "groupKeySetID",
                                                                  value.isMember("groupKeySetID")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "groupId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.groupId, value["groupId"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "groupKeySetID");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.groupKeySetID, value["groupKeySetID"]));

    if (value.isMember("fabricIndex"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricIndex");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fabricIndex, value["fabricIndex"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.groupId);
    ComplexArgumentParser::Finalize(request.groupKeySetID);
    ComplexArgumentParser::Finalize(request.fabricIndex);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::GroupKeyManagement::Structs::GroupKeySetStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("GroupKeySetStruct.groupKeySetID", "groupKeySetID",
                                                                  value.isMember("groupKeySetID")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist(
        "GroupKeySetStruct.groupKeySecurityPolicy", "groupKeySecurityPolicy", value.isMember("groupKeySecurityPolicy")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("GroupKeySetStruct.epochKey0", "epochKey0", value.isMember("epochKey0")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("GroupKeySetStruct.epochStartTime0", "epochStartTime0",
                                                                  value.isMember("epochStartTime0")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("GroupKeySetStruct.epochKey1", "epochKey1", value.isMember("epochKey1")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("GroupKeySetStruct.epochStartTime1", "epochStartTime1",
                                                                  value.isMember("epochStartTime1")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("GroupKeySetStruct.epochKey2", "epochKey2", value.isMember("epochKey2")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("GroupKeySetStruct.epochStartTime2", "epochStartTime2",
                                                                  value.isMember("epochStartTime2")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "groupKeySetID");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.groupKeySetID, value["groupKeySetID"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "groupKeySecurityPolicy");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.groupKeySecurityPolicy, value["groupKeySecurityPolicy"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "epochKey0");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.epochKey0, value["epochKey0"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "epochStartTime0");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.epochStartTime0, value["epochStartTime0"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "epochKey1");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.epochKey1, value["epochKey1"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "epochStartTime1");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.epochStartTime1, value["epochStartTime1"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "epochKey2");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.epochKey2, value["epochKey2"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "epochStartTime2");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.epochStartTime2, value["epochStartTime2"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::GroupKeyManagement::Structs::GroupKeySetStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.groupKeySetID);
    ComplexArgumentParser::Finalize(request.groupKeySecurityPolicy);
    ComplexArgumentParser::Finalize(request.epochKey0);
    ComplexArgumentParser::Finalize(request.epochStartTime0);
    ComplexArgumentParser::Finalize(request.epochKey1);
    ComplexArgumentParser::Finalize(request.epochStartTime1);
    ComplexArgumentParser::Finalize(request.epochKey2);
    ComplexArgumentParser::Finalize(request.epochStartTime2);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::MediaInput::Structs::InputInfo::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("InputInfo.index", "index", value.isMember("index")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("InputInfo.inputType", "inputType", value.isMember("inputType")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("InputInfo.name", "name", value.isMember("name")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("InputInfo.description", "description", value.isMember("description")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "index");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.index, value["index"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "inputType");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.inputType, value["inputType"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "name");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.name, value["name"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "description");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.description, value["description"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::MediaInput::Structs::InputInfo::Type & request)
{
    ComplexArgumentParser::Finalize(request.index);
    ComplexArgumentParser::Finalize(request.inputType);
    ComplexArgumentParser::Finalize(request.name);
    ComplexArgumentParser::Finalize(request.description);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::detail::Structs::LabelStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("LabelStruct.label", "label", value.isMember("label")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("LabelStruct.value", "value", value.isMember("value")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "label");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.label, value["label"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "value");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.value, value["value"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::detail::Structs::LabelStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.label);
    ComplexArgumentParser::Finalize(request.value);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::Channel::Structs::LineupInfo::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("LineupInfo.operatorName", "operatorName", value.isMember("operatorName")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("LineupInfo.lineupInfoType", "lineupInfoType", value.isMember("lineupInfoType")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "operatorName");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.operatorName, value["operatorName"]));

    if (value.isMember("lineupName"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "lineupName");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.lineupName, value["lineupName"]));
    }

    if (value.isMember("postalCode"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "postalCode");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.postalCode, value["postalCode"]));
    }

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "lineupInfoType");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.lineupInfoType, value["lineupInfoType"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::Channel::Structs::LineupInfo::Type & request)
{
    ComplexArgumentParser::Finalize(request.operatorName);
    ComplexArgumentParser::Finalize(request.lineupName);
    ComplexArgumentParser::Finalize(request.postalCode);
    ComplexArgumentParser::Finalize(request.lineupInfoType);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ModeOptionStruct.label", "label", value.isMember("label")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ModeOptionStruct.mode", "mode", value.isMember("mode")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("ModeOptionStruct.semanticTags", "semanticTags", value.isMember("semanticTags")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "label");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.label, value["label"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "mode");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.mode, value["mode"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "semanticTags");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.semanticTags, value["semanticTags"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.label);
    ComplexArgumentParser::Finalize(request.mode);
    ComplexArgumentParser::Finalize(request.semanticTags);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NOCStruct.noc", "noc", value.isMember("noc")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NOCStruct.icac", "icac", value.isMember("icac")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "noc");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.noc, value["noc"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "icac");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.icac, value["icac"]));

    if (value.isMember("fabricIndex"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricIndex");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fabricIndex, value["fabricIndex"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.noc);
    ComplexArgumentParser::Finalize(request.icac);
    ComplexArgumentParser::Finalize(request.fabricIndex);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTable::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("NeighborTable.extAddress", "extAddress", value.isMember("extAddress")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NeighborTable.age", "age", value.isMember("age")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NeighborTable.rloc16", "rloc16", value.isMember("rloc16")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NeighborTable.linkFrameCounter", "linkFrameCounter",
                                                                  value.isMember("linkFrameCounter")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NeighborTable.mleFrameCounter", "mleFrameCounter",
                                                                  value.isMember("mleFrameCounter")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NeighborTable.lqi", "lqi", value.isMember("lqi")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("NeighborTable.averageRssi", "averageRssi", value.isMember("averageRssi")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("NeighborTable.lastRssi", "lastRssi", value.isMember("lastRssi")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NeighborTable.frameErrorRate", "frameErrorRate",
                                                                  value.isMember("frameErrorRate")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NeighborTable.messageErrorRate", "messageErrorRate",
                                                                  value.isMember("messageErrorRate")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("NeighborTable.rxOnWhenIdle", "rxOnWhenIdle", value.isMember("rxOnWhenIdle")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NeighborTable.fullThreadDevice", "fullThreadDevice",
                                                                  value.isMember("fullThreadDevice")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NeighborTable.fullNetworkData", "fullNetworkData",
                                                                  value.isMember("fullNetworkData")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NeighborTable.isChild", "isChild", value.isMember("isChild")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "extAddress");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.extAddress, value["extAddress"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "age");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.age, value["age"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "rloc16");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.rloc16, value["rloc16"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "linkFrameCounter");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.linkFrameCounter, value["linkFrameCounter"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "mleFrameCounter");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.mleFrameCounter, value["mleFrameCounter"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "lqi");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.lqi, value["lqi"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "averageRssi");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.averageRssi, value["averageRssi"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "lastRssi");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.lastRssi, value["lastRssi"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "frameErrorRate");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.frameErrorRate, value["frameErrorRate"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "messageErrorRate");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.messageErrorRate, value["messageErrorRate"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "rxOnWhenIdle");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.rxOnWhenIdle, value["rxOnWhenIdle"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fullThreadDevice");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fullThreadDevice, value["fullThreadDevice"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fullNetworkData");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fullNetworkData, value["fullNetworkData"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "isChild");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.isChild, value["isChild"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTable::Type & request)
{
    ComplexArgumentParser::Finalize(request.extAddress);
    ComplexArgumentParser::Finalize(request.age);
    ComplexArgumentParser::Finalize(request.rloc16);
    ComplexArgumentParser::Finalize(request.linkFrameCounter);
    ComplexArgumentParser::Finalize(request.mleFrameCounter);
    ComplexArgumentParser::Finalize(request.lqi);
    ComplexArgumentParser::Finalize(request.averageRssi);
    ComplexArgumentParser::Finalize(request.lastRssi);
    ComplexArgumentParser::Finalize(request.frameErrorRate);
    ComplexArgumentParser::Finalize(request.messageErrorRate);
    ComplexArgumentParser::Finalize(request.rxOnWhenIdle);
    ComplexArgumentParser::Finalize(request.fullThreadDevice);
    ComplexArgumentParser::Finalize(request.fullNetworkData);
    ComplexArgumentParser::Finalize(request.isChild);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::TestCluster::Structs::NestedStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NestedStruct.a", "a", value.isMember("a")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NestedStruct.b", "b", value.isMember("b")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NestedStruct.c", "c", value.isMember("c")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "a");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.a, value["a"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "b");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.b, value["b"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "c");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.c, value["c"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::TestCluster::Structs::NestedStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.a);
    ComplexArgumentParser::Finalize(request.b);
    ComplexArgumentParser::Finalize(request.c);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::TestCluster::Structs::NestedStructList::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NestedStructList.a", "a", value.isMember("a")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NestedStructList.b", "b", value.isMember("b")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NestedStructList.c", "c", value.isMember("c")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NestedStructList.d", "d", value.isMember("d")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NestedStructList.e", "e", value.isMember("e")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NestedStructList.f", "f", value.isMember("f")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NestedStructList.g", "g", value.isMember("g")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "a");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.a, value["a"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "b");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.b, value["b"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "c");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.c, value["c"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "d");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.d, value["d"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "e");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.e, value["e"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "f");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.f, value["f"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "g");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.g, value["g"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::TestCluster::Structs::NestedStructList::Type & request)
{
    ComplexArgumentParser::Finalize(request.a);
    ComplexArgumentParser::Finalize(request.b);
    ComplexArgumentParser::Finalize(request.c);
    ComplexArgumentParser::Finalize(request.d);
    ComplexArgumentParser::Finalize(request.e);
    ComplexArgumentParser::Finalize(request.f);
    ComplexArgumentParser::Finalize(request.g);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfo::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("NetworkInfo.networkID", "networkID", value.isMember("networkID")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("NetworkInfo.connected", "connected", value.isMember("connected")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "networkID");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.networkID, value["networkID"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "connected");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.connected, value["connected"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfo::Type & request)
{
    ComplexArgumentParser::Finalize(request.networkID);
    ComplexArgumentParser::Finalize(request.connected);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterfaceType::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NetworkInterfaceType.name", "name", value.isMember("name")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NetworkInterfaceType.isOperational", "isOperational",
                                                                  value.isMember("isOperational")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NetworkInterfaceType.offPremiseServicesReachableIPv4",
                                                                  "offPremiseServicesReachableIPv4",
                                                                  value.isMember("offPremiseServicesReachableIPv4")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NetworkInterfaceType.offPremiseServicesReachableIPv6",
                                                                  "offPremiseServicesReachableIPv6",
                                                                  value.isMember("offPremiseServicesReachableIPv6")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NetworkInterfaceType.hardwareAddress", "hardwareAddress",
                                                                  value.isMember("hardwareAddress")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NetworkInterfaceType.IPv4Addresses", "IPv4Addresses",
                                                                  value.isMember("IPv4Addresses")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NetworkInterfaceType.IPv6Addresses", "IPv6Addresses",
                                                                  value.isMember("IPv6Addresses")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NetworkInterfaceType.type", "type", value.isMember("type")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "name");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.name, value["name"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "isOperational");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.isOperational, value["isOperational"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "offPremiseServicesReachableIPv4");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.offPremiseServicesReachableIPv4,
                                                      value["offPremiseServicesReachableIPv4"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "offPremiseServicesReachableIPv6");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.offPremiseServicesReachableIPv6,
                                                      value["offPremiseServicesReachableIPv6"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "hardwareAddress");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.hardwareAddress, value["hardwareAddress"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "IPv4Addresses");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.IPv4Addresses, value["IPv4Addresses"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "IPv6Addresses");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.IPv6Addresses, value["IPv6Addresses"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "type");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.type, value["type"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterfaceType::Type & request)
{
    ComplexArgumentParser::Finalize(request.name);
    ComplexArgumentParser::Finalize(request.isOperational);
    ComplexArgumentParser::Finalize(request.offPremiseServicesReachableIPv4);
    ComplexArgumentParser::Finalize(request.offPremiseServicesReachableIPv6);
    ComplexArgumentParser::Finalize(request.hardwareAddress);
    ComplexArgumentParser::Finalize(request.IPv4Addresses);
    ComplexArgumentParser::Finalize(request.IPv6Addresses);
    ComplexArgumentParser::Finalize(request.type);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::TestCluster::Structs::NullablesAndOptionalsStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NullablesAndOptionalsStruct.nullableInt", "nullableInt",
                                                                  value.isMember("nullableInt")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NullablesAndOptionalsStruct.nullableString", "nullableString",
                                                                  value.isMember("nullableString")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NullablesAndOptionalsStruct.nullableStruct", "nullableStruct",
                                                                  value.isMember("nullableStruct")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("NullablesAndOptionalsStruct.nullableList", "nullableList",
                                                                  value.isMember("nullableList")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nullableInt");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.nullableInt, value["nullableInt"]));

    if (value.isMember("optionalInt"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "optionalInt");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.optionalInt, value["optionalInt"]));
    }

    if (value.isMember("nullableOptionalInt"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nullableOptionalInt");
        ReturnErrorOnFailure(
            ComplexArgumentParser::Setup(labelWithMember, request.nullableOptionalInt, value["nullableOptionalInt"]));
    }

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nullableString");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.nullableString, value["nullableString"]));

    if (value.isMember("optionalString"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "optionalString");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.optionalString, value["optionalString"]));
    }

    if (value.isMember("nullableOptionalString"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nullableOptionalString");
        ReturnErrorOnFailure(
            ComplexArgumentParser::Setup(labelWithMember, request.nullableOptionalString, value["nullableOptionalString"]));
    }

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nullableStruct");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.nullableStruct, value["nullableStruct"]));

    if (value.isMember("optionalStruct"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "optionalStruct");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.optionalStruct, value["optionalStruct"]));
    }

    if (value.isMember("nullableOptionalStruct"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nullableOptionalStruct");
        ReturnErrorOnFailure(
            ComplexArgumentParser::Setup(labelWithMember, request.nullableOptionalStruct, value["nullableOptionalStruct"]));
    }

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nullableList");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.nullableList, value["nullableList"]));

    if (value.isMember("optionalList"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "optionalList");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.optionalList, value["optionalList"]));
    }

    if (value.isMember("nullableOptionalList"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nullableOptionalList");
        ReturnErrorOnFailure(
            ComplexArgumentParser::Setup(labelWithMember, request.nullableOptionalList, value["nullableOptionalList"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::TestCluster::Structs::NullablesAndOptionalsStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.nullableInt);
    ComplexArgumentParser::Finalize(request.optionalInt);
    ComplexArgumentParser::Finalize(request.nullableOptionalInt);
    ComplexArgumentParser::Finalize(request.nullableString);
    ComplexArgumentParser::Finalize(request.optionalString);
    ComplexArgumentParser::Finalize(request.nullableOptionalString);
    ComplexArgumentParser::Finalize(request.nullableStruct);
    ComplexArgumentParser::Finalize(request.optionalStruct);
    ComplexArgumentParser::Finalize(request.nullableOptionalStruct);
    ComplexArgumentParser::Finalize(request.nullableList);
    ComplexArgumentParser::Finalize(request.optionalList);
    ComplexArgumentParser::Finalize(request.nullableOptionalList);
}
CHIP_ERROR
ComplexArgumentParser::Setup(const char * label,
                             chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::Type & request,
                             Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist(
        "OperationalDatasetComponents.activeTimestampPresent", "activeTimestampPresent", value.isMember("activeTimestampPresent")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("OperationalDatasetComponents.pendingTimestampPresent",
                                                                  "pendingTimestampPresent",
                                                                  value.isMember("pendingTimestampPresent")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("OperationalDatasetComponents.masterKeyPresent",
                                                                  "masterKeyPresent", value.isMember("masterKeyPresent")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("OperationalDatasetComponents.networkNamePresent",
                                                                  "networkNamePresent", value.isMember("networkNamePresent")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("OperationalDatasetComponents.extendedPanIdPresent",
                                                                  "extendedPanIdPresent", value.isMember("extendedPanIdPresent")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist(
        "OperationalDatasetComponents.meshLocalPrefixPresent", "meshLocalPrefixPresent", value.isMember("meshLocalPrefixPresent")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("OperationalDatasetComponents.delayPresent", "delayPresent",
                                                                  value.isMember("delayPresent")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("OperationalDatasetComponents.panIdPresent", "panIdPresent",
                                                                  value.isMember("panIdPresent")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("OperationalDatasetComponents.channelPresent", "channelPresent",
                                                                  value.isMember("channelPresent")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("OperationalDatasetComponents.pskcPresent", "pskcPresent",
                                                                  value.isMember("pskcPresent")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist(
        "OperationalDatasetComponents.securityPolicyPresent", "securityPolicyPresent", value.isMember("securityPolicyPresent")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("OperationalDatasetComponents.channelMaskPresent",
                                                                  "channelMaskPresent", value.isMember("channelMaskPresent")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "activeTimestampPresent");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.activeTimestampPresent, value["activeTimestampPresent"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "pendingTimestampPresent");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.pendingTimestampPresent, value["pendingTimestampPresent"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "masterKeyPresent");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.masterKeyPresent, value["masterKeyPresent"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "networkNamePresent");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.networkNamePresent, value["networkNamePresent"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "extendedPanIdPresent");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.extendedPanIdPresent, value["extendedPanIdPresent"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "meshLocalPrefixPresent");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.meshLocalPrefixPresent, value["meshLocalPrefixPresent"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "delayPresent");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.delayPresent, value["delayPresent"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "panIdPresent");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.panIdPresent, value["panIdPresent"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "channelPresent");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.channelPresent, value["channelPresent"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "pskcPresent");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.pskcPresent, value["pskcPresent"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "securityPolicyPresent");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.securityPolicyPresent, value["securityPolicyPresent"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "channelMaskPresent");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.channelMaskPresent, value["channelMaskPresent"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(
    chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::Type & request)
{
    ComplexArgumentParser::Finalize(request.activeTimestampPresent);
    ComplexArgumentParser::Finalize(request.pendingTimestampPresent);
    ComplexArgumentParser::Finalize(request.masterKeyPresent);
    ComplexArgumentParser::Finalize(request.networkNamePresent);
    ComplexArgumentParser::Finalize(request.extendedPanIdPresent);
    ComplexArgumentParser::Finalize(request.meshLocalPrefixPresent);
    ComplexArgumentParser::Finalize(request.delayPresent);
    ComplexArgumentParser::Finalize(request.panIdPresent);
    ComplexArgumentParser::Finalize(request.channelPresent);
    ComplexArgumentParser::Finalize(request.pskcPresent);
    ComplexArgumentParser::Finalize(request.securityPolicyPresent);
    ComplexArgumentParser::Finalize(request.channelMaskPresent);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::AudioOutput::Structs::OutputInfo::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("OutputInfo.index", "index", value.isMember("index")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("OutputInfo.outputType", "outputType", value.isMember("outputType")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("OutputInfo.name", "name", value.isMember("name")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "index");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.index, value["index"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "outputType");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.outputType, value["outputType"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "name");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.name, value["name"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::AudioOutput::Structs::OutputInfo::Type & request)
{
    ComplexArgumentParser::Finalize(request.index);
    ComplexArgumentParser::Finalize(request.outputType);
    ComplexArgumentParser::Finalize(request.name);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ContentLauncher::Structs::Parameter::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("Parameter.type", "type", value.isMember("type")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("Parameter.value", "value", value.isMember("value")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "type");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.type, value["type"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "value");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.value, value["value"]));

    if (value.isMember("externalIDList"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "externalIDList");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.externalIDList, value["externalIDList"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ContentLauncher::Structs::Parameter::Type & request)
{
    ComplexArgumentParser::Finalize(request.type);
    ComplexArgumentParser::Finalize(request.value);
    ComplexArgumentParser::Finalize(request.externalIDList);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::MediaPlayback::Structs::PlaybackPosition::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("PlaybackPosition.updatedAt", "updatedAt", value.isMember("updatedAt")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("PlaybackPosition.position", "position", value.isMember("position")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "updatedAt");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.updatedAt, value["updatedAt"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "position");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.position, value["position"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::MediaPlayback::Structs::PlaybackPosition::Type & request)
{
    ComplexArgumentParser::Finalize(request.updatedAt);
    ComplexArgumentParser::Finalize(request.position);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ProviderLocation.providerNodeID", "providerNodeID",
                                                                  value.isMember("providerNodeID")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("ProviderLocation.endpoint", "endpoint", value.isMember("endpoint")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "providerNodeID");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.providerNodeID, value["providerNodeID"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "endpoint");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.endpoint, value["endpoint"]));

    if (value.isMember("fabricIndex"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricIndex");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fabricIndex, value["fabricIndex"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::Type & request)
{
    ComplexArgumentParser::Finalize(request.providerNodeID);
    ComplexArgumentParser::Finalize(request.endpoint);
    ComplexArgumentParser::Finalize(request.fabricIndex);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTable::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("RouteTable.extAddress", "extAddress", value.isMember("extAddress")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("RouteTable.rloc16", "rloc16", value.isMember("rloc16")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("RouteTable.routerId", "routerId", value.isMember("routerId")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("RouteTable.nextHop", "nextHop", value.isMember("nextHop")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("RouteTable.pathCost", "pathCost", value.isMember("pathCost")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("RouteTable.LQIIn", "LQIIn", value.isMember("LQIIn")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("RouteTable.LQIOut", "LQIOut", value.isMember("LQIOut")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("RouteTable.age", "age", value.isMember("age")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("RouteTable.allocated", "allocated", value.isMember("allocated")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("RouteTable.linkEstablished", "linkEstablished",
                                                                  value.isMember("linkEstablished")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "extAddress");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.extAddress, value["extAddress"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "rloc16");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.rloc16, value["rloc16"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "routerId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.routerId, value["routerId"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nextHop");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.nextHop, value["nextHop"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "pathCost");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.pathCost, value["pathCost"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "LQIIn");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.LQIIn, value["LQIIn"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "LQIOut");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.LQIOut, value["LQIOut"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "age");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.age, value["age"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "allocated");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.allocated, value["allocated"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "linkEstablished");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.linkEstablished, value["linkEstablished"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTable::Type & request)
{
    ComplexArgumentParser::Finalize(request.extAddress);
    ComplexArgumentParser::Finalize(request.rloc16);
    ComplexArgumentParser::Finalize(request.routerId);
    ComplexArgumentParser::Finalize(request.nextHop);
    ComplexArgumentParser::Finalize(request.pathCost);
    ComplexArgumentParser::Finalize(request.LQIIn);
    ComplexArgumentParser::Finalize(request.LQIOut);
    ComplexArgumentParser::Finalize(request.age);
    ComplexArgumentParser::Finalize(request.allocated);
    ComplexArgumentParser::Finalize(request.linkEstablished);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("SecurityPolicy.rotationTime", "rotationTime", value.isMember("rotationTime")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("SecurityPolicy.flags", "flags", value.isMember("flags")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "rotationTime");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.rotationTime, value["rotationTime"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "flags");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.flags, value["flags"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::Type & request)
{
    ComplexArgumentParser::Finalize(request.rotationTime);
    ComplexArgumentParser::Finalize(request.flags);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::ModeSelect::Structs::SemanticTag::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("SemanticTag.mfgCode", "mfgCode", value.isMember("mfgCode")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("SemanticTag.value", "value", value.isMember("value")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "mfgCode");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.mfgCode, value["mfgCode"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "value");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.value, value["value"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ModeSelect::Structs::SemanticTag::Type & request)
{
    ComplexArgumentParser::Finalize(request.mfgCode);
    ComplexArgumentParser::Finalize(request.value);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::TestCluster::Structs::SimpleStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("SimpleStruct.a", "a", value.isMember("a")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("SimpleStruct.b", "b", value.isMember("b")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("SimpleStruct.c", "c", value.isMember("c")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("SimpleStruct.d", "d", value.isMember("d")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("SimpleStruct.e", "e", value.isMember("e")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("SimpleStruct.f", "f", value.isMember("f")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("SimpleStruct.g", "g", value.isMember("g")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("SimpleStruct.h", "h", value.isMember("h")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "a");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.a, value["a"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "b");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.b, value["b"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "c");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.c, value["c"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "d");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.d, value["d"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "e");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.e, value["e"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "f");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.f, value["f"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "g");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.g, value["g"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "h");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.h, value["h"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::TestCluster::Structs::SimpleStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.a);
    ComplexArgumentParser::Finalize(request.b);
    ComplexArgumentParser::Finalize(request.c);
    ComplexArgumentParser::Finalize(request.d);
    ComplexArgumentParser::Finalize(request.e);
    ComplexArgumentParser::Finalize(request.f);
    ComplexArgumentParser::Finalize(request.g);
    ComplexArgumentParser::Finalize(request.h);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::ContentLauncher::Structs::StyleInformation::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    char labelWithMember[kMaxLabelLength];
    if (value.isMember("imageUrl"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "imageUrl");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.imageUrl, value["imageUrl"]));
    }

    if (value.isMember("color"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "color");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.color, value["color"]));
    }

    if (value.isMember("size"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "size");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.size, value["size"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::ContentLauncher::Structs::StyleInformation::Type & request)
{
    ComplexArgumentParser::Finalize(request.imageUrl);
    ComplexArgumentParser::Finalize(request.color);
    ComplexArgumentParser::Finalize(request.size);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::AccessControl::Structs::Target::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("Target.cluster", "cluster", value.isMember("cluster")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("Target.endpoint", "endpoint", value.isMember("endpoint")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("Target.deviceType", "deviceType", value.isMember("deviceType")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "cluster");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.cluster, value["cluster"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "endpoint");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.endpoint, value["endpoint"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "deviceType");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.deviceType, value["deviceType"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::AccessControl::Structs::Target::Type & request)
{
    ComplexArgumentParser::Finalize(request.cluster);
    ComplexArgumentParser::Finalize(request.endpoint);
    ComplexArgumentParser::Finalize(request.deviceType);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::TargetNavigator::Structs::TargetInfo::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("TargetInfo.identifier", "identifier", value.isMember("identifier")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("TargetInfo.name", "name", value.isMember("name")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "identifier");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.identifier, value["identifier"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "name");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.name, value["name"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::TargetNavigator::Structs::TargetInfo::Type & request)
{
    ComplexArgumentParser::Finalize(request.identifier);
    ComplexArgumentParser::Finalize(request.name);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label, chip::app::Clusters::Binding::Structs::TargetStruct::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    char labelWithMember[kMaxLabelLength];
    if (value.isMember("node"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "node");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.node, value["node"]));
    }

    if (value.isMember("group"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "group");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.group, value["group"]));
    }

    if (value.isMember("endpoint"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "endpoint");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.endpoint, value["endpoint"]));
    }

    if (value.isMember("cluster"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "cluster");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.cluster, value["cluster"]));
    }

    if (value.isMember("fabricIndex"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricIndex");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fabricIndex, value["fabricIndex"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::Binding::Structs::TargetStruct::Type & request)
{
    ComplexArgumentParser::Finalize(request.node);
    ComplexArgumentParser::Finalize(request.group);
    ComplexArgumentParser::Finalize(request.endpoint);
    ComplexArgumentParser::Finalize(request.cluster);
    ComplexArgumentParser::Finalize(request.fabricIndex);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::TestCluster::Structs::TestFabricScoped::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("TestFabricScoped.fabricSensitiveInt8u", "fabricSensitiveInt8u",
                                                                  value.isMember("fabricSensitiveInt8u")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("TestFabricScoped.nullableFabricSensitiveInt8u",
                                                                  "nullableFabricSensitiveInt8u",
                                                                  value.isMember("nullableFabricSensitiveInt8u")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist(
        "TestFabricScoped.fabricSensitiveCharString", "fabricSensitiveCharString", value.isMember("fabricSensitiveCharString")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("TestFabricScoped.fabricSensitiveStruct", "fabricSensitiveStruct",
                                                                  value.isMember("fabricSensitiveStruct")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist(
        "TestFabricScoped.fabricSensitiveInt8uList", "fabricSensitiveInt8uList", value.isMember("fabricSensitiveInt8uList")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricSensitiveInt8u");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.fabricSensitiveInt8u, value["fabricSensitiveInt8u"]));

    if (value.isMember("optionalFabricSensitiveInt8u"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "optionalFabricSensitiveInt8u");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.optionalFabricSensitiveInt8u,
                                                          value["optionalFabricSensitiveInt8u"]));
    }

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nullableFabricSensitiveInt8u");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.nullableFabricSensitiveInt8u, value["nullableFabricSensitiveInt8u"]));

    if (value.isMember("nullableOptionalFabricSensitiveInt8u"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "nullableOptionalFabricSensitiveInt8u");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.nullableOptionalFabricSensitiveInt8u,
                                                          value["nullableOptionalFabricSensitiveInt8u"]));
    }

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricSensitiveCharString");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.fabricSensitiveCharString, value["fabricSensitiveCharString"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricSensitiveStruct");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.fabricSensitiveStruct, value["fabricSensitiveStruct"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricSensitiveInt8uList");
    ReturnErrorOnFailure(
        ComplexArgumentParser::Setup(labelWithMember, request.fabricSensitiveInt8uList, value["fabricSensitiveInt8uList"]));

    if (value.isMember("fabricIndex"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "fabricIndex");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.fabricIndex, value["fabricIndex"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::TestCluster::Structs::TestFabricScoped::Type & request)
{
    ComplexArgumentParser::Finalize(request.fabricSensitiveInt8u);
    ComplexArgumentParser::Finalize(request.optionalFabricSensitiveInt8u);
    ComplexArgumentParser::Finalize(request.nullableFabricSensitiveInt8u);
    ComplexArgumentParser::Finalize(request.nullableOptionalFabricSensitiveInt8u);
    ComplexArgumentParser::Finalize(request.fabricSensitiveCharString);
    ComplexArgumentParser::Finalize(request.fabricSensitiveStruct);
    ComplexArgumentParser::Finalize(request.fabricSensitiveInt8uList);
    ComplexArgumentParser::Finalize(request.fabricIndex);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::TestCluster::Structs::TestListStructOctet::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("TestListStructOctet.member1", "member1", value.isMember("member1")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("TestListStructOctet.member2", "member2", value.isMember("member2")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "member1");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.member1, value["member1"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "member2");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.member2, value["member2"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::TestCluster::Structs::TestListStructOctet::Type & request)
{
    ComplexArgumentParser::Finalize(request.member1);
    ComplexArgumentParser::Finalize(request.member2);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::Thermostat::Structs::ThermostatScheduleTransition::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ThermostatScheduleTransition.transitionTime", "transitionTime",
                                                                  value.isMember("transitionTime")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ThermostatScheduleTransition.heatSetpoint", "heatSetpoint",
                                                                  value.isMember("heatSetpoint")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ThermostatScheduleTransition.coolSetpoint", "coolSetpoint",
                                                                  value.isMember("coolSetpoint")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "transitionTime");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.transitionTime, value["transitionTime"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "heatSetpoint");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.heatSetpoint, value["heatSetpoint"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "coolSetpoint");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.coolSetpoint, value["coolSetpoint"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::Thermostat::Structs::ThermostatScheduleTransition::Type & request)
{
    ComplexArgumentParser::Finalize(request.transitionTime);
    ComplexArgumentParser::Finalize(request.heatSetpoint);
    ComplexArgumentParser::Finalize(request.coolSetpoint);
}
CHIP_ERROR
ComplexArgumentParser::Setup(const char * label,
                             chip::app::Clusters::NetworkCommissioning::Structs::ThreadInterfaceScanResult::Type & request,
                             Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("ThreadInterfaceScanResult.panId", "panId", value.isMember("panId")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ThreadInterfaceScanResult.extendedPanId", "extendedPanId",
                                                                  value.isMember("extendedPanId")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ThreadInterfaceScanResult.networkName", "networkName",
                                                                  value.isMember("networkName")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("ThreadInterfaceScanResult.channel", "channel", value.isMember("channel")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("ThreadInterfaceScanResult.version", "version", value.isMember("version")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ThreadInterfaceScanResult.extendedAddress", "extendedAddress",
                                                                  value.isMember("extendedAddress")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("ThreadInterfaceScanResult.rssi", "rssi", value.isMember("rssi")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ThreadInterfaceScanResult.lqi", "lqi", value.isMember("lqi")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "panId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.panId, value["panId"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "extendedPanId");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.extendedPanId, value["extendedPanId"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "networkName");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.networkName, value["networkName"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "channel");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.channel, value["channel"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "version");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.version, value["version"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "extendedAddress");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.extendedAddress, value["extendedAddress"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "rssi");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.rssi, value["rssi"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "lqi");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.lqi, value["lqi"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::NetworkCommissioning::Structs::ThreadInterfaceScanResult::Type & request)
{
    ComplexArgumentParser::Finalize(request.panId);
    ComplexArgumentParser::Finalize(request.extendedPanId);
    ComplexArgumentParser::Finalize(request.networkName);
    ComplexArgumentParser::Finalize(request.channel);
    ComplexArgumentParser::Finalize(request.version);
    ComplexArgumentParser::Finalize(request.extendedAddress);
    ComplexArgumentParser::Finalize(request.rssi);
    ComplexArgumentParser::Finalize(request.lqi);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetrics::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("ThreadMetrics.id", "id", value.isMember("id")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "id");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.id, value["id"]));

    if (value.isMember("name"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "name");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.name, value["name"]));
    }

    if (value.isMember("stackFreeCurrent"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "stackFreeCurrent");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.stackFreeCurrent, value["stackFreeCurrent"]));
    }

    if (value.isMember("stackFreeMinimum"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "stackFreeMinimum");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.stackFreeMinimum, value["stackFreeMinimum"]));
    }

    if (value.isMember("stackSize"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "stackSize");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.stackSize, value["stackSize"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetrics::Type & request)
{
    ComplexArgumentParser::Finalize(request.id);
    ComplexArgumentParser::Finalize(request.name);
    ComplexArgumentParser::Finalize(request.stackFreeCurrent);
    ComplexArgumentParser::Finalize(request.stackFreeMinimum);
    ComplexArgumentParser::Finalize(request.stackSize);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::TimeSynchronization::Structs::TimeZoneType::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("TimeZoneType.offset", "offset", value.isMember("offset")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("TimeZoneType.validAt", "validAt", value.isMember("validAt")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "offset");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.offset, value["offset"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "validAt");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.validAt, value["validAt"]));

    if (value.isMember("name"))
    {
        snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "name");
        ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.name, value["name"]));
    }

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::TimeSynchronization::Structs::TimeZoneType::Type & request)
{
    ComplexArgumentParser::Finalize(request.offset);
    ComplexArgumentParser::Finalize(request.validAt);
    ComplexArgumentParser::Finalize(request.name);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::NetworkCommissioning::Structs::WiFiInterfaceScanResult::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("WiFiInterfaceScanResult.security", "security", value.isMember("security")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("WiFiInterfaceScanResult.ssid", "ssid", value.isMember("ssid")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("WiFiInterfaceScanResult.bssid", "bssid", value.isMember("bssid")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("WiFiInterfaceScanResult.channel", "channel", value.isMember("channel")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("WiFiInterfaceScanResult.wiFiBand", "wiFiBand", value.isMember("wiFiBand")));
    ReturnErrorOnFailure(ComplexArgumentParser::EnsureMemberExist("WiFiInterfaceScanResult.rssi", "rssi", value.isMember("rssi")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "security");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.security, value["security"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "ssid");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.ssid, value["ssid"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "bssid");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.bssid, value["bssid"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "channel");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.channel, value["channel"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "wiFiBand");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.wiFiBand, value["wiFiBand"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "rssi");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.rssi, value["rssi"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::NetworkCommissioning::Structs::WiFiInterfaceScanResult::Type & request)
{
    ComplexArgumentParser::Finalize(request.security);
    ComplexArgumentParser::Finalize(request.ssid);
    ComplexArgumentParser::Finalize(request.bssid);
    ComplexArgumentParser::Finalize(request.channel);
    ComplexArgumentParser::Finalize(request.wiFiBand);
    ComplexArgumentParser::Finalize(request.rssi);
}
CHIP_ERROR ComplexArgumentParser::Setup(const char * label,
                                        chip::app::Clusters::PowerSource::Structs::WiredFaultChangeType::Type & request,
                                        Json::Value & value)
{
    VerifyOrReturnError(value.isObject(), CHIP_ERROR_INVALID_ARGUMENT);

    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("WiredFaultChangeType.current", "current", value.isMember("current")));
    ReturnErrorOnFailure(
        ComplexArgumentParser::EnsureMemberExist("WiredFaultChangeType.previous", "previous", value.isMember("previous")));

    char labelWithMember[kMaxLabelLength];
    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "current");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.current, value["current"]));

    snprintf(labelWithMember, sizeof(labelWithMember), "%s.%s", label, "previous");
    ReturnErrorOnFailure(ComplexArgumentParser::Setup(labelWithMember, request.previous, value["previous"]));

    return CHIP_NO_ERROR;
}

void ComplexArgumentParser::Finalize(chip::app::Clusters::PowerSource::Structs::WiredFaultChangeType::Type & request)
{
    ComplexArgumentParser::Finalize(request.current);
    ComplexArgumentParser::Finalize(request.previous);
}
