/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#include <commands/clusters/DataModelLogger.h>

using namespace chip::app::Clusters;

CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Privilege", indent + 1, value.privilege);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Privilege'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("AuthMode", indent + 1, value.authMode);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'AuthMode'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Subjects", indent + 1, value.subjects);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Subjects'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Targets", indent + 1, value.targets);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Targets'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::Actions::Structs::ActionStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("ActionID", indent + 1, value.actionID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ActionID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Name", indent + 1, value.name);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Name'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Type", indent + 1, value.type);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Type'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("EndpointListID", indent + 1, value.endpointListID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'EndpointListID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("SupportedCommands", indent + 1, value.supportedCommands);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'SupportedCommands'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("State", indent + 1, value.state);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'State'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::ContentLauncher::Structs::AdditionalInfo::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Name", indent + 1, value.name);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Name'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Value", indent + 1, value.value);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Value'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::ApplicationLauncher::Structs::Application::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("CatalogVendorId", indent + 1, value.catalogVendorId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'CatalogVendorId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ApplicationId", indent + 1, value.applicationId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ApplicationId'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::ApplicationBasic::Structs::ApplicationBasicApplication::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("CatalogVendorId", indent + 1, value.catalogVendorId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'CatalogVendorId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ApplicationId", indent + 1, value.applicationId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ApplicationId'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::ApplicationLauncher::Structs::ApplicationEP::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Application", indent + 1, value.application);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Application'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Endpoint", indent + 1, value.endpoint);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Endpoint'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::Scenes::Structs::AttributeValuePair::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("AttributeId", indent + 1, value.attributeId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'AttributeId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("AttributeValue", indent + 1, value.attributeValue);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'AttributeValue'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("FailSafeExpiryLengthSeconds", indent + 1, value.failSafeExpiryLengthSeconds);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FailSafeExpiryLengthSeconds'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("MaxCumulativeFailsafeSeconds", indent + 1, value.maxCumulativeFailsafeSeconds);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'MaxCumulativeFailsafeSeconds'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::PowerSource::Structs::BatChargeFaultChangeType::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Current", indent + 1, value.current);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Current'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Previous", indent + 1, value.previous);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Previous'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::PowerSource::Structs::BatFaultChangeType::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Current", indent + 1, value.current);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Current'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Previous", indent + 1, value.previous);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Previous'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::ContentLauncher::Structs::BrandingInformation::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("ProviderName", indent + 1, value.providerName);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ProviderName'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Background", indent + 1, value.background);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Background'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Logo", indent + 1, value.logo);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Logo'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ProgressBar", indent + 1, value.progressBar);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ProgressBar'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Splash", indent + 1, value.splash);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Splash'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("WaterMark", indent + 1, value.waterMark);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'WaterMark'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::Basic::Structs::CapabilityMinimaStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("CaseSessionsPerFabric", indent + 1, value.caseSessionsPerFabric);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'CaseSessionsPerFabric'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("SubscriptionsPerFabric", indent + 1, value.subscriptionsPerFabric);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'SubscriptionsPerFabric'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::Channel::Structs::ChannelInfo::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("MajorNumber", indent + 1, value.majorNumber);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'MajorNumber'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("MinorNumber", indent + 1, value.minorNumber);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'MinorNumber'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Name", indent + 1, value.name);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Name'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("CallSign", indent + 1, value.callSign);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'CallSign'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("AffiliateCallSign", indent + 1, value.affiliateCallSign);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'AffiliateCallSign'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::ContentLauncher::Structs::ContentSearch::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("ParameterList", indent + 1, value.parameterList);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ParameterList'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Type", indent + 1, value.type);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Type'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Revision", indent + 1, value.revision);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Revision'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::ContentLauncher::Structs::Dimension::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Width", indent + 1, value.width);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Width'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Height", indent + 1, value.height);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Height'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Metric", indent + 1, value.metric);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Metric'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::DoorLock::Structs::DlCredential::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("CredentialType", indent + 1, value.credentialType);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'CredentialType'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("CredentialIndex", indent + 1, value.credentialIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'CredentialIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::TestCluster::Structs::DoubleNestedStructList::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("A", indent + 1, value.a);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'A'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::TimeSynchronization::Structs::DstOffsetType::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Offset", indent + 1, value.offset);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Offset'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ValidStarting", indent + 1, value.validStarting);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ValidStarting'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ValidUntil", indent + 1, value.validUntil);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ValidUntil'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::Actions::Structs::EndpointListStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("EndpointListID", indent + 1, value.endpointListID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'EndpointListID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Name", indent + 1, value.name);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Name'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Type", indent + 1, value.type);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Type'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Endpoints", indent + 1, value.endpoints);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Endpoints'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::AccessControl::Structs::ExtensionEntry::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Data", indent + 1, value.data);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Data'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::Scenes::Structs::ExtensionFieldSet::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("ClusterId", indent + 1, value.clusterId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ClusterId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("AttributeValueList", indent + 1, value.attributeValueList);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'AttributeValueList'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptor::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("RootPublicKey", indent + 1, value.rootPublicKey);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'RootPublicKey'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("VendorId", indent + 1, value.vendorId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'VendorId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricId", indent + 1, value.fabricId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NodeId", indent + 1, value.nodeId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NodeId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Label", indent + 1, value.label);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Label'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("GroupId", indent + 1, value.groupId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'GroupId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Endpoints", indent + 1, value.endpoints);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Endpoints'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("GroupName", indent + 1, value.groupName);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'GroupName'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("GroupId", indent + 1, value.groupId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'GroupId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("GroupKeySetID", indent + 1, value.groupKeySetID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'GroupKeySetID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::GroupKeyManagement::Structs::GroupKeySetStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("GroupKeySetID", indent + 1, value.groupKeySetID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'GroupKeySetID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("GroupKeySecurityPolicy", indent + 1, value.groupKeySecurityPolicy);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'GroupKeySecurityPolicy'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("EpochKey0", indent + 1, value.epochKey0);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'EpochKey0'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("EpochStartTime0", indent + 1, value.epochStartTime0);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'EpochStartTime0'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("EpochKey1", indent + 1, value.epochKey1);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'EpochKey1'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("EpochStartTime1", indent + 1, value.epochStartTime1);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'EpochStartTime1'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("EpochKey2", indent + 1, value.epochKey2);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'EpochKey2'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("EpochStartTime2", indent + 1, value.epochStartTime2);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'EpochStartTime2'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::MediaInput::Structs::InputInfo::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Index", indent + 1, value.index);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Index'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("InputType", indent + 1, value.inputType);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'InputType'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Name", indent + 1, value.name);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Name'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Description", indent + 1, value.description);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Description'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::detail::Structs::LabelStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Label", indent + 1, value.label);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Label'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Value", indent + 1, value.value);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Value'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::Channel::Structs::LineupInfo::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("OperatorName", indent + 1, value.operatorName);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'OperatorName'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("LineupName", indent + 1, value.lineupName);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'LineupName'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("PostalCode", indent + 1, value.postalCode);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'PostalCode'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("LineupInfoType", indent + 1, value.lineupInfoType);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'LineupInfoType'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Label", indent + 1, value.label);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Label'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Mode", indent + 1, value.mode);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Mode'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("SemanticTags", indent + 1, value.semanticTags);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'SemanticTags'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Noc", indent + 1, value.noc);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Noc'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Icac", indent + 1, value.icac);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Icac'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTable::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("ExtAddress", indent + 1, value.extAddress);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ExtAddress'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Age", indent + 1, value.age);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Age'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Rloc16", indent + 1, value.rloc16);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Rloc16'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("LinkFrameCounter", indent + 1, value.linkFrameCounter);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'LinkFrameCounter'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("MleFrameCounter", indent + 1, value.mleFrameCounter);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'MleFrameCounter'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Lqi", indent + 1, value.lqi);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Lqi'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("AverageRssi", indent + 1, value.averageRssi);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'AverageRssi'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("LastRssi", indent + 1, value.lastRssi);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'LastRssi'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FrameErrorRate", indent + 1, value.frameErrorRate);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FrameErrorRate'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("MessageErrorRate", indent + 1, value.messageErrorRate);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'MessageErrorRate'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("RxOnWhenIdle", indent + 1, value.rxOnWhenIdle);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'RxOnWhenIdle'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FullThreadDevice", indent + 1, value.fullThreadDevice);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FullThreadDevice'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FullNetworkData", indent + 1, value.fullNetworkData);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FullNetworkData'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("IsChild", indent + 1, value.isChild);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'IsChild'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::TestCluster::Structs::NestedStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("A", indent + 1, value.a);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'A'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("B", indent + 1, value.b);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'B'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("C", indent + 1, value.c);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'C'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::TestCluster::Structs::NestedStructList::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("A", indent + 1, value.a);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'A'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("B", indent + 1, value.b);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'B'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("C", indent + 1, value.c);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'C'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("D", indent + 1, value.d);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'D'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("E", indent + 1, value.e);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'E'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("F", indent + 1, value.f);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'F'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("G", indent + 1, value.g);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'G'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfo::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("NetworkID", indent + 1, value.networkID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NetworkID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Connected", indent + 1, value.connected);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Connected'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterfaceType::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Name", indent + 1, value.name);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Name'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("IsOperational", indent + 1, value.isOperational);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'IsOperational'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("OffPremiseServicesReachableIPv4", indent + 1, value.offPremiseServicesReachableIPv4);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'OffPremiseServicesReachableIPv4'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("OffPremiseServicesReachableIPv6", indent + 1, value.offPremiseServicesReachableIPv6);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'OffPremiseServicesReachableIPv6'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("HardwareAddress", indent + 1, value.hardwareAddress);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'HardwareAddress'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("IPv4Addresses", indent + 1, value.IPv4Addresses);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'IPv4Addresses'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("IPv6Addresses", indent + 1, value.IPv6Addresses);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'IPv6Addresses'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Type", indent + 1, value.type);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Type'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::TestCluster::Structs::NullablesAndOptionalsStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("NullableInt", indent + 1, value.nullableInt);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NullableInt'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("OptionalInt", indent + 1, value.optionalInt);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'OptionalInt'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NullableOptionalInt", indent + 1, value.nullableOptionalInt);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NullableOptionalInt'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NullableString", indent + 1, value.nullableString);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NullableString'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("OptionalString", indent + 1, value.optionalString);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'OptionalString'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NullableOptionalString", indent + 1, value.nullableOptionalString);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NullableOptionalString'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NullableStruct", indent + 1, value.nullableStruct);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NullableStruct'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("OptionalStruct", indent + 1, value.optionalStruct);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'OptionalStruct'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NullableOptionalStruct", indent + 1, value.nullableOptionalStruct);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NullableOptionalStruct'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NullableList", indent + 1, value.nullableList);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NullableList'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("OptionalList", indent + 1, value.optionalList);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'OptionalList'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NullableOptionalList", indent + 1, value.nullableOptionalList);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NullableOptionalList'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(
    const char * label, size_t indent,
    const chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("ActiveTimestampPresent", indent + 1, value.activeTimestampPresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ActiveTimestampPresent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("PendingTimestampPresent", indent + 1, value.pendingTimestampPresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'PendingTimestampPresent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("MasterKeyPresent", indent + 1, value.masterKeyPresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'MasterKeyPresent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NetworkNamePresent", indent + 1, value.networkNamePresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NetworkNamePresent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ExtendedPanIdPresent", indent + 1, value.extendedPanIdPresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ExtendedPanIdPresent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("MeshLocalPrefixPresent", indent + 1, value.meshLocalPrefixPresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'MeshLocalPrefixPresent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("DelayPresent", indent + 1, value.delayPresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'DelayPresent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("PanIdPresent", indent + 1, value.panIdPresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'PanIdPresent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ChannelPresent", indent + 1, value.channelPresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ChannelPresent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("PskcPresent", indent + 1, value.pskcPresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'PskcPresent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("SecurityPolicyPresent", indent + 1, value.securityPolicyPresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'SecurityPolicyPresent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ChannelMaskPresent", indent + 1, value.channelMaskPresent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ChannelMaskPresent'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::AudioOutput::Structs::OutputInfo::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Index", indent + 1, value.index);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Index'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("OutputType", indent + 1, value.outputType);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'OutputType'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Name", indent + 1, value.name);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Name'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::ContentLauncher::Structs::Parameter::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Type", indent + 1, value.type);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Type'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Value", indent + 1, value.value);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Value'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ExternalIDList", indent + 1, value.externalIDList);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ExternalIDList'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::MediaPlayback::Structs::PlaybackPosition::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("UpdatedAt", indent + 1, value.updatedAt);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'UpdatedAt'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Position", indent + 1, value.position);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Position'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("ProviderNodeID", indent + 1, value.providerNodeID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ProviderNodeID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Endpoint", indent + 1, value.endpoint);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Endpoint'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTable::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("ExtAddress", indent + 1, value.extAddress);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ExtAddress'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Rloc16", indent + 1, value.rloc16);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Rloc16'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("RouterId", indent + 1, value.routerId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'RouterId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NextHop", indent + 1, value.nextHop);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NextHop'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("PathCost", indent + 1, value.pathCost);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'PathCost'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("LQIIn", indent + 1, value.LQIIn);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'LQIIn'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("LQIOut", indent + 1, value.LQIOut);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'LQIOut'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Age", indent + 1, value.age);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Age'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Allocated", indent + 1, value.allocated);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Allocated'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("LinkEstablished", indent + 1, value.linkEstablished);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'LinkEstablished'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("RotationTime", indent + 1, value.rotationTime);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'RotationTime'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Flags", indent + 1, value.flags);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Flags'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::ModeSelect::Structs::SemanticTag::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("MfgCode", indent + 1, value.mfgCode);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'MfgCode'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Value", indent + 1, value.value);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Value'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::TestCluster::Structs::SimpleStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("A", indent + 1, value.a);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'A'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("B", indent + 1, value.b);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'B'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("C", indent + 1, value.c);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'C'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("D", indent + 1, value.d);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'D'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("E", indent + 1, value.e);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'E'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("F", indent + 1, value.f);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'F'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("G", indent + 1, value.g);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'G'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("H", indent + 1, value.h);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'H'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::ContentLauncher::Structs::StyleInformation::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("ImageUrl", indent + 1, value.imageUrl);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ImageUrl'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Color", indent + 1, value.color);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Color'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Size", indent + 1, value.size);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Size'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::AccessControl::Structs::Target::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Cluster", indent + 1, value.cluster);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Cluster'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Endpoint", indent + 1, value.endpoint);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Endpoint'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("DeviceType", indent + 1, value.deviceType);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'DeviceType'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::TargetNavigator::Structs::TargetInfo::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Identifier", indent + 1, value.identifier);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Identifier'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Name", indent + 1, value.name);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Name'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::Binding::Structs::TargetStruct::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Node", indent + 1, value.node);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Node'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Group", indent + 1, value.group);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Group'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Endpoint", indent + 1, value.endpoint);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Endpoint'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Cluster", indent + 1, value.cluster);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Cluster'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::TestCluster::Structs::TestFabricScoped::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("FabricSensitiveInt8u", indent + 1, value.fabricSensitiveInt8u);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricSensitiveInt8u'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("OptionalFabricSensitiveInt8u", indent + 1, value.optionalFabricSensitiveInt8u);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'OptionalFabricSensitiveInt8u'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NullableFabricSensitiveInt8u", indent + 1, value.nullableFabricSensitiveInt8u);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NullableFabricSensitiveInt8u'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NullableOptionalFabricSensitiveInt8u", indent + 1, value.nullableOptionalFabricSensitiveInt8u);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1,
                                       "Struct truncated due to invalid value for 'NullableOptionalFabricSensitiveInt8u'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricSensitiveCharString", indent + 1, value.fabricSensitiveCharString);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricSensitiveCharString'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricSensitiveStruct", indent + 1, value.fabricSensitiveStruct);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricSensitiveStruct'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricSensitiveInt8uList", indent + 1, value.fabricSensitiveInt8uList);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricSensitiveInt8uList'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::TestCluster::Structs::TestListStructOctet::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Member1", indent + 1, value.member1);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Member1'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Member2", indent + 1, value.member2);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Member2'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::Thermostat::Structs::ThermostatScheduleTransition::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("TransitionTime", indent + 1, value.transitionTime);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'TransitionTime'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("HeatSetpoint", indent + 1, value.heatSetpoint);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'HeatSetpoint'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("CoolSetpoint", indent + 1, value.coolSetpoint);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'CoolSetpoint'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(
    const char * label, size_t indent,
    const chip::app::Clusters::NetworkCommissioning::Structs::ThreadInterfaceScanResult::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("PanId", indent + 1, value.panId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'PanId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ExtendedPanId", indent + 1, value.extendedPanId);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ExtendedPanId'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("NetworkName", indent + 1, value.networkName);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'NetworkName'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Channel", indent + 1, value.channel);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Channel'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Version", indent + 1, value.version);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Version'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ExtendedAddress", indent + 1, value.extendedAddress);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ExtendedAddress'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Rssi", indent + 1, value.rssi);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Rssi'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Lqi", indent + 1, value.lqi);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Lqi'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetrics::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Id", indent + 1, value.id);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Id'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Name", indent + 1, value.name);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Name'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("StackFreeCurrent", indent + 1, value.stackFreeCurrent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'StackFreeCurrent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("StackFreeMinimum", indent + 1, value.stackFreeMinimum);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'StackFreeMinimum'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("StackSize", indent + 1, value.stackSize);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'StackSize'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::TimeSynchronization::Structs::TimeZoneType::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Offset", indent + 1, value.offset);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Offset'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("ValidAt", indent + 1, value.validAt);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'ValidAt'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Name", indent + 1, value.name);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Name'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const chip::app::Clusters::NetworkCommissioning::Structs::WiFiInterfaceScanResult::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Security", indent + 1, value.security);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Security'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Ssid", indent + 1, value.ssid);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Ssid'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Bssid", indent + 1, value.bssid);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Bssid'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Channel", indent + 1, value.channel);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Channel'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("WiFiBand", indent + 1, value.wiFiBand);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'WiFiBand'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Rssi", indent + 1, value.rssi);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Rssi'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const chip::app::Clusters::PowerSource::Structs::WiredFaultChangeType::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = LogValue("Current", indent + 1, value.current);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Current'");
            return err;
        }
    }
    {
        CHIP_ERROR err = LogValue("Previous", indent + 1, value.previous);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Struct truncated due to invalid value for 'Previous'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}

CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const AccessControl::Events::AccessControlEntryChanged::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("AdminNodeID", indent + 1, value.adminNodeID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'AdminNodeID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("AdminPasscodeID", indent + 1, value.adminPasscodeID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'AdminPasscodeID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("ChangeType", indent + 1, value.changeType);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'ChangeType'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("LatestValue", indent + 1, value.latestValue);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'LatestValue'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const AccessControl::Events::AccessControlExtensionChanged::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("AdminNodeID", indent + 1, value.adminNodeID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'AdminNodeID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("AdminPasscodeID", indent + 1, value.adminPasscodeID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'AdminPasscodeID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("ChangeType", indent + 1, value.changeType);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'ChangeType'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("LatestValue", indent + 1, value.latestValue);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'LatestValue'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent, const Actions::Events::StateChanged::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("ActionID", indent + 1, value.actionID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'ActionID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("InvokeID", indent + 1, value.invokeID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'InvokeID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("NewState", indent + 1, value.newState);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'NewState'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent, const Actions::Events::ActionFailed::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("ActionID", indent + 1, value.actionID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'ActionID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("InvokeID", indent + 1, value.invokeID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'InvokeID'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("NewState", indent + 1, value.newState);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'NewState'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Error", indent + 1, value.error);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Error'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent, const Basic::Events::StartUp::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("SoftwareVersion", indent + 1, value.softwareVersion);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'SoftwareVersion'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent, const Basic::Events::ShutDown::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent, const Basic::Events::Leave::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Basic::Events::ReachableChanged::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("ReachableNewValue", indent + 1, value.reachableNewValue);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'ReachableNewValue'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const OtaSoftwareUpdateRequestor::Events::StateTransition::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("PreviousState", indent + 1, value.previousState);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'PreviousState'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("NewState", indent + 1, value.newState);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'NewState'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Reason", indent + 1, value.reason);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Reason'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("TargetSoftwareVersion", indent + 1, value.targetSoftwareVersion);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'TargetSoftwareVersion'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const OtaSoftwareUpdateRequestor::Events::VersionApplied::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("SoftwareVersion", indent + 1, value.softwareVersion);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'SoftwareVersion'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("ProductID", indent + 1, value.productID);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'ProductID'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const OtaSoftwareUpdateRequestor::Events::DownloadError::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("SoftwareVersion", indent + 1, value.softwareVersion);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'SoftwareVersion'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("BytesDownloaded", indent + 1, value.bytesDownloaded);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'BytesDownloaded'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("ProgressPercent", indent + 1, value.progressPercent);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'ProgressPercent'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("PlatformCode", indent + 1, value.platformCode);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'PlatformCode'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const GeneralDiagnostics::Events::HardwareFaultChange::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Current", indent + 1, value.current);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Current'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Previous", indent + 1, value.previous);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Previous'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const GeneralDiagnostics::Events::RadioFaultChange::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Current", indent + 1, value.current);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Current'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Previous", indent + 1, value.previous);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Previous'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const GeneralDiagnostics::Events::NetworkFaultChange::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Current", indent + 1, value.current);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Current'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Previous", indent + 1, value.previous);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Previous'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const GeneralDiagnostics::Events::BootReason::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("BootReason", indent + 1, value.bootReason);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'BootReason'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const SoftwareDiagnostics::Events::SoftwareFault::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Id", indent + 1, value.id);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Id'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Name", indent + 1, value.name);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Name'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("FaultRecording", indent + 1, value.faultRecording);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'FaultRecording'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const ThreadNetworkDiagnostics::Events::ConnectionStatus::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("ConnectionStatus", indent + 1, value.connectionStatus);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'ConnectionStatus'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const ThreadNetworkDiagnostics::Events::NetworkFaultChange::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Current", indent + 1, value.current);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Current'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Previous", indent + 1, value.previous);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Previous'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const WiFiNetworkDiagnostics::Events::Disconnection::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("ReasonCode", indent + 1, value.reasonCode);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'ReasonCode'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const WiFiNetworkDiagnostics::Events::AssociationFailure::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("AssociationFailure", indent + 1, value.associationFailure);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'AssociationFailure'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Status", indent + 1, value.status);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Status'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const WiFiNetworkDiagnostics::Events::ConnectionStatus::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("ConnectionStatus", indent + 1, value.connectionStatus);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'ConnectionStatus'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const BridgedDeviceBasic::Events::StartUp::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("SoftwareVersion", indent + 1, value.softwareVersion);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'SoftwareVersion'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const BridgedDeviceBasic::Events::ShutDown::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const BridgedDeviceBasic::Events::Leave::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const BridgedDeviceBasic::Events::ReachableChanged::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("ReachableNewValue", indent + 1, value.reachableNewValue);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'ReachableNewValue'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent, const Switch::Events::SwitchLatched::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("NewPosition", indent + 1, value.newPosition);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'NewPosition'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent, const Switch::Events::InitialPress::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("NewPosition", indent + 1, value.newPosition);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'NewPosition'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent, const Switch::Events::LongPress::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("NewPosition", indent + 1, value.newPosition);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'NewPosition'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent, const Switch::Events::ShortRelease::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("PreviousPosition", indent + 1, value.previousPosition);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'PreviousPosition'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent, const Switch::Events::LongRelease::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("PreviousPosition", indent + 1, value.previousPosition);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'PreviousPosition'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Switch::Events::MultiPressOngoing::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("NewPosition", indent + 1, value.newPosition);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'NewPosition'");
            return err;
        }
    }
    {
        CHIP_ERROR err =
            DataModelLogger::LogValue("CurrentNumberOfPressesCounted", indent + 1, value.currentNumberOfPressesCounted);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'CurrentNumberOfPressesCounted'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Switch::Events::MultiPressComplete::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("NewPosition", indent + 1, value.newPosition);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'NewPosition'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("TotalNumberOfPressesCounted", indent + 1, value.totalNumberOfPressesCounted);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'TotalNumberOfPressesCounted'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const BooleanState::Events::StateChange::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("StateValue", indent + 1, value.stateValue);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'StateValue'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DoorLock::Events::DoorLockAlarm::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("AlarmCode", indent + 1, value.alarmCode);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'AlarmCode'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DoorLock::Events::DoorStateChange::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("DoorState", indent + 1, value.doorState);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'DoorState'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DoorLock::Events::LockOperation::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("LockOperationType", indent + 1, value.lockOperationType);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'LockOperationType'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("OperationSource", indent + 1, value.operationSource);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'OperationSource'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("UserIndex", indent + 1, value.userIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'UserIndex'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("SourceNode", indent + 1, value.sourceNode);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'SourceNode'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Credentials", indent + 1, value.credentials);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Credentials'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DoorLock::Events::LockOperationError::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("LockOperationType", indent + 1, value.lockOperationType);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'LockOperationType'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("OperationSource", indent + 1, value.operationSource);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'OperationSource'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("OperationError", indent + 1, value.operationError);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'OperationError'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("UserIndex", indent + 1, value.userIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'UserIndex'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("SourceNode", indent + 1, value.sourceNode);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'SourceNode'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Credentials", indent + 1, value.credentials);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Credentials'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DoorLock::Events::LockUserChange::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("LockDataType", indent + 1, value.lockDataType);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'LockDataType'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("DataOperationType", indent + 1, value.dataOperationType);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'DataOperationType'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("OperationSource", indent + 1, value.operationSource);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'OperationSource'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("UserIndex", indent + 1, value.userIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'UserIndex'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("SourceNode", indent + 1, value.sourceNode);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'SourceNode'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("DataIndex", indent + 1, value.dataIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'DataIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::SupplyVoltageLow::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::SupplyVoltageHigh::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::PowerMissingPhase::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::SystemPressureLow::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::SystemPressureHigh::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::DryRunning::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::MotorTemperatureHigh::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::PumpMotorFatalFailure::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::ElectronicTemperatureHigh::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::PumpBlocked::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::SensorFailure::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::ElectronicNonFatalFailure::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::ElectronicFatalFailure::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::GeneralFault::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::Leakage::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::AirDetection::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const PumpConfigurationAndControl::Events::TurbineOperation::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent, const TestCluster::Events::TestEvent::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Arg1", indent + 1, value.arg1);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Arg1'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Arg2", indent + 1, value.arg2);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Arg2'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Arg3", indent + 1, value.arg3);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Arg3'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Arg4", indent + 1, value.arg4);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Arg4'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Arg5", indent + 1, value.arg5);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Arg5'");
            return err;
        }
    }
    {
        CHIP_ERROR err = DataModelLogger::LogValue("Arg6", indent + 1, value.arg6);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'Arg6'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Events::TestFabricScopedEvent::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    {
        CHIP_ERROR err = DataModelLogger::LogValue("FabricIndex", indent + 1, value.fabricIndex);
        if (err != CHIP_NO_ERROR)
        {
            DataModelLogger::LogString(indent + 1, "Event truncated due to invalid value for 'FabricIndex'");
            return err;
        }
    }
    DataModelLogger::LogString(indent, "}");

    return CHIP_NO_ERROR;
}

CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Groups::Commands::AddGroupResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupId", indent + 1, value.groupId));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Groups::Commands::ViewGroupResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupId", indent + 1, value.groupId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupName", indent + 1, value.groupName));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Groups::Commands::GetGroupMembershipResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("capacity", indent + 1, value.capacity));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupList", indent + 1, value.groupList));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Groups::Commands::RemoveGroupResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupId", indent + 1, value.groupId));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Scenes::Commands::AddSceneResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupId", indent + 1, value.groupId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("sceneId", indent + 1, value.sceneId));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Scenes::Commands::ViewSceneResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupId", indent + 1, value.groupId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("sceneId", indent + 1, value.sceneId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("transitionTime", indent + 1, value.transitionTime));
    ReturnErrorOnFailure(DataModelLogger::LogValue("sceneName", indent + 1, value.sceneName));
    ReturnErrorOnFailure(DataModelLogger::LogValue("extensionFieldSets", indent + 1, value.extensionFieldSets));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Scenes::Commands::RemoveSceneResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupId", indent + 1, value.groupId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("sceneId", indent + 1, value.sceneId));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Scenes::Commands::RemoveAllScenesResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupId", indent + 1, value.groupId));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Scenes::Commands::StoreSceneResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupId", indent + 1, value.groupId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("sceneId", indent + 1, value.sceneId));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Scenes::Commands::GetSceneMembershipResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("capacity", indent + 1, value.capacity));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupId", indent + 1, value.groupId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("sceneList", indent + 1, value.sceneList));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Scenes::Commands::EnhancedAddSceneResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupId", indent + 1, value.groupId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("sceneId", indent + 1, value.sceneId));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Scenes::Commands::EnhancedViewSceneResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupId", indent + 1, value.groupId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("sceneId", indent + 1, value.sceneId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("transitionTime", indent + 1, value.transitionTime));
    ReturnErrorOnFailure(DataModelLogger::LogValue("sceneName", indent + 1, value.sceneName));
    ReturnErrorOnFailure(DataModelLogger::LogValue("extensionFieldSets", indent + 1, value.extensionFieldSets));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Scenes::Commands::CopySceneResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupIdFrom", indent + 1, value.groupIdFrom));
    ReturnErrorOnFailure(DataModelLogger::LogValue("sceneIdFrom", indent + 1, value.sceneIdFrom));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const OtaSoftwareUpdateProvider::Commands::QueryImageResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("delayedActionTime", indent + 1, value.delayedActionTime));
    ReturnErrorOnFailure(DataModelLogger::LogValue("imageURI", indent + 1, value.imageURI));
    ReturnErrorOnFailure(DataModelLogger::LogValue("softwareVersion", indent + 1, value.softwareVersion));
    ReturnErrorOnFailure(DataModelLogger::LogValue("softwareVersionString", indent + 1, value.softwareVersionString));
    ReturnErrorOnFailure(DataModelLogger::LogValue("updateToken", indent + 1, value.updateToken));
    ReturnErrorOnFailure(DataModelLogger::LogValue("userConsentNeeded", indent + 1, value.userConsentNeeded));
    ReturnErrorOnFailure(DataModelLogger::LogValue("metadataForRequestor", indent + 1, value.metadataForRequestor));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const OtaSoftwareUpdateProvider::Commands::ApplyUpdateResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("action", indent + 1, value.action));
    ReturnErrorOnFailure(DataModelLogger::LogValue("delayedActionTime", indent + 1, value.delayedActionTime));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const GeneralCommissioning::Commands::ArmFailSafeResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("errorCode", indent + 1, value.errorCode));
    ReturnErrorOnFailure(DataModelLogger::LogValue("debugText", indent + 1, value.debugText));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const GeneralCommissioning::Commands::SetRegulatoryConfigResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("errorCode", indent + 1, value.errorCode));
    ReturnErrorOnFailure(DataModelLogger::LogValue("debugText", indent + 1, value.debugText));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const GeneralCommissioning::Commands::CommissioningCompleteResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("errorCode", indent + 1, value.errorCode));
    ReturnErrorOnFailure(DataModelLogger::LogValue("debugText", indent + 1, value.debugText));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const NetworkCommissioning::Commands::ScanNetworksResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("networkingStatus", indent + 1, value.networkingStatus));
    ReturnErrorOnFailure(DataModelLogger::LogValue("debugText", indent + 1, value.debugText));
    ReturnErrorOnFailure(DataModelLogger::LogValue("wiFiScanResults", indent + 1, value.wiFiScanResults));
    ReturnErrorOnFailure(DataModelLogger::LogValue("threadScanResults", indent + 1, value.threadScanResults));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("networkingStatus", indent + 1, value.networkingStatus));
    ReturnErrorOnFailure(DataModelLogger::LogValue("debugText", indent + 1, value.debugText));
    ReturnErrorOnFailure(DataModelLogger::LogValue("networkIndex", indent + 1, value.networkIndex));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const NetworkCommissioning::Commands::ConnectNetworkResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("networkingStatus", indent + 1, value.networkingStatus));
    ReturnErrorOnFailure(DataModelLogger::LogValue("debugText", indent + 1, value.debugText));
    ReturnErrorOnFailure(DataModelLogger::LogValue("errorValue", indent + 1, value.errorValue));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DiagnosticLogs::Commands::RetrieveLogsResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("content", indent + 1, value.content));
    ReturnErrorOnFailure(DataModelLogger::LogValue("timeStamp", indent + 1, value.timeStamp));
    ReturnErrorOnFailure(DataModelLogger::LogValue("timeSinceBoot", indent + 1, value.timeSinceBoot));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const OperationalCredentials::Commands::AttestationResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("attestationElements", indent + 1, value.attestationElements));
    ReturnErrorOnFailure(DataModelLogger::LogValue("signature", indent + 1, value.signature));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const OperationalCredentials::Commands::CertificateChainResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("certificate", indent + 1, value.certificate));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const OperationalCredentials::Commands::CSRResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("NOCSRElements", indent + 1, value.NOCSRElements));
    ReturnErrorOnFailure(DataModelLogger::LogValue("attestationSignature", indent + 1, value.attestationSignature));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const OperationalCredentials::Commands::NOCResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("statusCode", indent + 1, value.statusCode));
    ReturnErrorOnFailure(DataModelLogger::LogValue("fabricIndex", indent + 1, value.fabricIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("debugText", indent + 1, value.debugText));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const GroupKeyManagement::Commands::KeySetReadResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupKeySet", indent + 1, value.groupKeySet));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const GroupKeyManagement::Commands::KeySetReadAllIndicesResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("groupKeySetIDs", indent + 1, value.groupKeySetIDs));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DoorLock::Commands::GetWeekDayScheduleResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("weekDayIndex", indent + 1, value.weekDayIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("userIndex", indent + 1, value.userIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("daysMask", indent + 1, value.daysMask));
    ReturnErrorOnFailure(DataModelLogger::LogValue("startHour", indent + 1, value.startHour));
    ReturnErrorOnFailure(DataModelLogger::LogValue("startMinute", indent + 1, value.startMinute));
    ReturnErrorOnFailure(DataModelLogger::LogValue("endHour", indent + 1, value.endHour));
    ReturnErrorOnFailure(DataModelLogger::LogValue("endMinute", indent + 1, value.endMinute));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DoorLock::Commands::GetYearDayScheduleResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("yearDayIndex", indent + 1, value.yearDayIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("userIndex", indent + 1, value.userIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("localStartTime", indent + 1, value.localStartTime));
    ReturnErrorOnFailure(DataModelLogger::LogValue("localEndTime", indent + 1, value.localEndTime));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DoorLock::Commands::GetHolidayScheduleResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("holidayIndex", indent + 1, value.holidayIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("localStartTime", indent + 1, value.localStartTime));
    ReturnErrorOnFailure(DataModelLogger::LogValue("localEndTime", indent + 1, value.localEndTime));
    ReturnErrorOnFailure(DataModelLogger::LogValue("operatingMode", indent + 1, value.operatingMode));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DoorLock::Commands::GetUserResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("userIndex", indent + 1, value.userIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("userName", indent + 1, value.userName));
    ReturnErrorOnFailure(DataModelLogger::LogValue("userUniqueId", indent + 1, value.userUniqueId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("userStatus", indent + 1, value.userStatus));
    ReturnErrorOnFailure(DataModelLogger::LogValue("userType", indent + 1, value.userType));
    ReturnErrorOnFailure(DataModelLogger::LogValue("credentialRule", indent + 1, value.credentialRule));
    ReturnErrorOnFailure(DataModelLogger::LogValue("credentials", indent + 1, value.credentials));
    ReturnErrorOnFailure(DataModelLogger::LogValue("creatorFabricIndex", indent + 1, value.creatorFabricIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("lastModifiedFabricIndex", indent + 1, value.lastModifiedFabricIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nextUserIndex", indent + 1, value.nextUserIndex));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DoorLock::Commands::SetCredentialResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("userIndex", indent + 1, value.userIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nextCredentialIndex", indent + 1, value.nextCredentialIndex));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const DoorLock::Commands::GetCredentialStatusResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("credentialExists", indent + 1, value.credentialExists));
    ReturnErrorOnFailure(DataModelLogger::LogValue("userIndex", indent + 1, value.userIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("creatorFabricIndex", indent + 1, value.creatorFabricIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("lastModifiedFabricIndex", indent + 1, value.lastModifiedFabricIndex));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nextCredentialIndex", indent + 1, value.nextCredentialIndex));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Thermostat::Commands::GetWeeklyScheduleResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(
        DataModelLogger::LogValue("numberOfTransitionsForSequence", indent + 1, value.numberOfTransitionsForSequence));
    ReturnErrorOnFailure(DataModelLogger::LogValue("dayOfWeekForSequence", indent + 1, value.dayOfWeekForSequence));
    ReturnErrorOnFailure(DataModelLogger::LogValue("modeForSequence", indent + 1, value.modeForSequence));
    ReturnErrorOnFailure(DataModelLogger::LogValue("transitions", indent + 1, value.transitions));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const Channel::Commands::ChangeChannelResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("data", indent + 1, value.data));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TargetNavigator::Commands::NavigateTargetResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("data", indent + 1, value.data));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const MediaPlayback::Commands::PlaybackResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("data", indent + 1, value.data));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const KeypadInput::Commands::SendKeyResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const ContentLauncher::Commands::LaunchResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("data", indent + 1, value.data));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const ApplicationLauncher::Commands::LauncherResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("data", indent + 1, value.data));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const AccountLogin::Commands::GetSetupPINResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("setupPIN", indent + 1, value.setupPIN));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const ElectricalMeasurement::Commands::GetProfileInfoResponseCommand::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("profileCount", indent + 1, value.profileCount));
    ReturnErrorOnFailure(DataModelLogger::LogValue("profileIntervalPeriod", indent + 1, value.profileIntervalPeriod));
    ReturnErrorOnFailure(DataModelLogger::LogValue("maxNumberOfIntervals", indent + 1, value.maxNumberOfIntervals));
    ReturnErrorOnFailure(DataModelLogger::LogValue("listOfAttributes", indent + 1, value.listOfAttributes));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR
DataModelLogger::LogValue(const char * label, size_t indent,
                          const ElectricalMeasurement::Commands::GetMeasurementProfileResponseCommand::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("startTime", indent + 1, value.startTime));
    ReturnErrorOnFailure(DataModelLogger::LogValue("status", indent + 1, value.status));
    ReturnErrorOnFailure(DataModelLogger::LogValue("profileIntervalPeriod", indent + 1, value.profileIntervalPeriod));
    ReturnErrorOnFailure(DataModelLogger::LogValue("numberOfIntervalsDelivered", indent + 1, value.numberOfIntervalsDelivered));
    ReturnErrorOnFailure(DataModelLogger::LogValue("attributeId", indent + 1, value.attributeId));
    ReturnErrorOnFailure(DataModelLogger::LogValue("intervals", indent + 1, value.intervals));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::TestSpecificResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("returnValue", indent + 1, value.returnValue));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::TestAddArgumentsResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("returnValue", indent + 1, value.returnValue));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::TestSimpleArgumentResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("returnValue", indent + 1, value.returnValue));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::TestStructArrayArgumentResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("arg1", indent + 1, value.arg1));
    ReturnErrorOnFailure(DataModelLogger::LogValue("arg2", indent + 1, value.arg2));
    ReturnErrorOnFailure(DataModelLogger::LogValue("arg3", indent + 1, value.arg3));
    ReturnErrorOnFailure(DataModelLogger::LogValue("arg4", indent + 1, value.arg4));
    ReturnErrorOnFailure(DataModelLogger::LogValue("arg5", indent + 1, value.arg5));
    ReturnErrorOnFailure(DataModelLogger::LogValue("arg6", indent + 1, value.arg6));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::TestListInt8UReverseResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("arg1", indent + 1, value.arg1));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::TestEnumsResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("arg1", indent + 1, value.arg1));
    ReturnErrorOnFailure(DataModelLogger::LogValue("arg2", indent + 1, value.arg2));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::TestNullableOptionalResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("wasPresent", indent + 1, value.wasPresent));
    ReturnErrorOnFailure(DataModelLogger::LogValue("wasNull", indent + 1, value.wasNull));
    ReturnErrorOnFailure(DataModelLogger::LogValue("value", indent + 1, value.value));
    ReturnErrorOnFailure(DataModelLogger::LogValue("originalValue", indent + 1, value.originalValue));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::TestComplexNullableOptionalResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableIntWasNull", indent + 1, value.nullableIntWasNull));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableIntValue", indent + 1, value.nullableIntValue));
    ReturnErrorOnFailure(DataModelLogger::LogValue("optionalIntWasPresent", indent + 1, value.optionalIntWasPresent));
    ReturnErrorOnFailure(DataModelLogger::LogValue("optionalIntValue", indent + 1, value.optionalIntValue));
    ReturnErrorOnFailure(
        DataModelLogger::LogValue("nullableOptionalIntWasPresent", indent + 1, value.nullableOptionalIntWasPresent));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableOptionalIntWasNull", indent + 1, value.nullableOptionalIntWasNull));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableOptionalIntValue", indent + 1, value.nullableOptionalIntValue));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableStringWasNull", indent + 1, value.nullableStringWasNull));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableStringValue", indent + 1, value.nullableStringValue));
    ReturnErrorOnFailure(DataModelLogger::LogValue("optionalStringWasPresent", indent + 1, value.optionalStringWasPresent));
    ReturnErrorOnFailure(DataModelLogger::LogValue("optionalStringValue", indent + 1, value.optionalStringValue));
    ReturnErrorOnFailure(
        DataModelLogger::LogValue("nullableOptionalStringWasPresent", indent + 1, value.nullableOptionalStringWasPresent));
    ReturnErrorOnFailure(
        DataModelLogger::LogValue("nullableOptionalStringWasNull", indent + 1, value.nullableOptionalStringWasNull));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableOptionalStringValue", indent + 1, value.nullableOptionalStringValue));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableStructWasNull", indent + 1, value.nullableStructWasNull));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableStructValue", indent + 1, value.nullableStructValue));
    ReturnErrorOnFailure(DataModelLogger::LogValue("optionalStructWasPresent", indent + 1, value.optionalStructWasPresent));
    ReturnErrorOnFailure(DataModelLogger::LogValue("optionalStructValue", indent + 1, value.optionalStructValue));
    ReturnErrorOnFailure(
        DataModelLogger::LogValue("nullableOptionalStructWasPresent", indent + 1, value.nullableOptionalStructWasPresent));
    ReturnErrorOnFailure(
        DataModelLogger::LogValue("nullableOptionalStructWasNull", indent + 1, value.nullableOptionalStructWasNull));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableOptionalStructValue", indent + 1, value.nullableOptionalStructValue));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableListWasNull", indent + 1, value.nullableListWasNull));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableListValue", indent + 1, value.nullableListValue));
    ReturnErrorOnFailure(DataModelLogger::LogValue("optionalListWasPresent", indent + 1, value.optionalListWasPresent));
    ReturnErrorOnFailure(DataModelLogger::LogValue("optionalListValue", indent + 1, value.optionalListValue));
    ReturnErrorOnFailure(
        DataModelLogger::LogValue("nullableOptionalListWasPresent", indent + 1, value.nullableOptionalListWasPresent));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableOptionalListWasNull", indent + 1, value.nullableOptionalListWasNull));
    ReturnErrorOnFailure(DataModelLogger::LogValue("nullableOptionalListValue", indent + 1, value.nullableOptionalListValue));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::BooleanResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("value", indent + 1, value.value));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::SimpleStructResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("arg1", indent + 1, value.arg1));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::TestEmitTestEventResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("value", indent + 1, value.value));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}
CHIP_ERROR DataModelLogger::LogValue(const char * label, size_t indent,
                                     const TestCluster::Commands::TestEmitTestFabricScopedEventResponse::DecodableType & value)
{
    DataModelLogger::LogString(label, indent, "{");
    ReturnErrorOnFailure(DataModelLogger::LogValue("value", indent + 1, value.value));
    DataModelLogger::LogString(indent, "}");
    return CHIP_NO_ERROR;
}

CHIP_ERROR DataModelLogger::LogAttribute(const chip::app::ConcreteDataAttributePath & path, chip::TLV::TLVReader * data)
{
    ChipLogProgress(chipTool, "Endpoint: %u Cluster: " ChipLogFormatMEI " Attribute " ChipLogFormatMEI " DataVersion: %" PRIu32,
                    path.mEndpointId, ChipLogValueMEI(path.mClusterId), ChipLogValueMEI(path.mAttributeId),
                    path.mDataVersion.ValueOr(0));

    switch (path.mClusterId)
    {
    case Identify::Id: {
        switch (path.mAttributeId)
        {
        case Identify::Attributes::IdentifyTime::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("identify time", 1, value);
        }
        case Identify::Attributes::IdentifyType::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("identify type", 1, value);
        }
        case Identify::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case Identify::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case Identify::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case Identify::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case Identify::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case Groups::Id: {
        switch (path.mAttributeId)
        {
        case Groups::Attributes::NameSupport::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NameSupport", 1, value);
        }
        case Groups::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case Groups::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case Groups::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case Groups::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case Groups::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case Scenes::Id: {
        switch (path.mAttributeId)
        {
        case Scenes::Attributes::SceneCount::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SceneCount", 1, value);
        }
        case Scenes::Attributes::CurrentScene::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentScene", 1, value);
        }
        case Scenes::Attributes::CurrentGroup::Id: {
            chip::GroupId value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentGroup", 1, value);
        }
        case Scenes::Attributes::SceneValid::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SceneValid", 1, value);
        }
        case Scenes::Attributes::NameSupport::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NameSupport", 1, value);
        }
        case Scenes::Attributes::LastConfiguredBy::Id: {
            chip::app::DataModel::Nullable<chip::NodeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LastConfiguredBy", 1, value);
        }
        case Scenes::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case Scenes::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case Scenes::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case Scenes::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case Scenes::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case OnOff::Id: {
        switch (path.mAttributeId)
        {
        case OnOff::Attributes::OnOff::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OnOff", 1, value);
        }
        case OnOff::Attributes::GlobalSceneControl::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GlobalSceneControl", 1, value);
        }
        case OnOff::Attributes::OnTime::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OnTime", 1, value);
        }
        case OnOff::Attributes::OffWaitTime::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OffWaitTime", 1, value);
        }
        case OnOff::Attributes::StartUpOnOff::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::OnOff::OnOffStartUpOnOff> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StartUpOnOff", 1, value);
        }
        case OnOff::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case OnOff::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case OnOff::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case OnOff::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case OnOff::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case OnOffSwitchConfiguration::Id: {
        switch (path.mAttributeId)
        {
        case OnOffSwitchConfiguration::Attributes::SwitchType::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("switch type", 1, value);
        }
        case OnOffSwitchConfiguration::Attributes::SwitchActions::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("switch actions", 1, value);
        }
        case OnOffSwitchConfiguration::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case OnOffSwitchConfiguration::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case OnOffSwitchConfiguration::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case OnOffSwitchConfiguration::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case OnOffSwitchConfiguration::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case LevelControl::Id: {
        switch (path.mAttributeId)
        {
        case LevelControl::Attributes::CurrentLevel::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentLevel", 1, value);
        }
        case LevelControl::Attributes::RemainingTime::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RemainingTime", 1, value);
        }
        case LevelControl::Attributes::MinLevel::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinLevel", 1, value);
        }
        case LevelControl::Attributes::MaxLevel::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxLevel", 1, value);
        }
        case LevelControl::Attributes::CurrentFrequency::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentFrequency", 1, value);
        }
        case LevelControl::Attributes::MinFrequency::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinFrequency", 1, value);
        }
        case LevelControl::Attributes::MaxFrequency::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxFrequency", 1, value);
        }
        case LevelControl::Attributes::Options::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Options", 1, value);
        }
        case LevelControl::Attributes::OnOffTransitionTime::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OnOffTransitionTime", 1, value);
        }
        case LevelControl::Attributes::OnLevel::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OnLevel", 1, value);
        }
        case LevelControl::Attributes::OnTransitionTime::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OnTransitionTime", 1, value);
        }
        case LevelControl::Attributes::OffTransitionTime::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OffTransitionTime", 1, value);
        }
        case LevelControl::Attributes::DefaultMoveRate::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DefaultMoveRate", 1, value);
        }
        case LevelControl::Attributes::StartUpCurrentLevel::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StartUpCurrentLevel", 1, value);
        }
        case LevelControl::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case LevelControl::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case LevelControl::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case LevelControl::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case LevelControl::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case BinaryInputBasic::Id: {
        switch (path.mAttributeId)
        {
        case BinaryInputBasic::Attributes::ActiveText::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active text", 1, value);
        }
        case BinaryInputBasic::Attributes::Description::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("description", 1, value);
        }
        case BinaryInputBasic::Attributes::InactiveText::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("inactive text", 1, value);
        }
        case BinaryInputBasic::Attributes::OutOfService::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("out of service", 1, value);
        }
        case BinaryInputBasic::Attributes::Polarity::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("polarity", 1, value);
        }
        case BinaryInputBasic::Attributes::PresentValue::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("present value", 1, value);
        }
        case BinaryInputBasic::Attributes::Reliability::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("reliability", 1, value);
        }
        case BinaryInputBasic::Attributes::StatusFlags::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("status flags", 1, value);
        }
        case BinaryInputBasic::Attributes::ApplicationType::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("application type", 1, value);
        }
        case BinaryInputBasic::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case BinaryInputBasic::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case BinaryInputBasic::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case BinaryInputBasic::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case BinaryInputBasic::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case Descriptor::Id: {
        switch (path.mAttributeId)
        {
        case Descriptor::Attributes::DeviceTypeList::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::Descriptor::Structs::DeviceTypeStruct::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DeviceTypeList", 1, value);
        }
        case Descriptor::Attributes::ServerList::Id: {
            chip::app::DataModel::DecodableList<chip::ClusterId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ServerList", 1, value);
        }
        case Descriptor::Attributes::ClientList::Id: {
            chip::app::DataModel::DecodableList<chip::ClusterId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClientList", 1, value);
        }
        case Descriptor::Attributes::PartsList::Id: {
            chip::app::DataModel::DecodableList<chip::EndpointId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PartsList", 1, value);
        }
        case Descriptor::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case Descriptor::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case Descriptor::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case Descriptor::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case Descriptor::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case Binding::Id: {
        switch (path.mAttributeId)
        {
        case Binding::Attributes::Binding::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::Binding::Structs::TargetStruct::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Binding", 1, value);
        }
        case Binding::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case Binding::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case Binding::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case Binding::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case Binding::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case AccessControl::Id: {
        switch (path.mAttributeId)
        {
        case AccessControl::Attributes::Acl::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ACL", 1, value);
        }
        case AccessControl::Attributes::Extension::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::ExtensionEntry::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Extension", 1, value);
        }
        case AccessControl::Attributes::SubjectsPerAccessControlEntry::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SubjectsPerAccessControlEntry", 1, value);
        }
        case AccessControl::Attributes::TargetsPerAccessControlEntry::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TargetsPerAccessControlEntry", 1, value);
        }
        case AccessControl::Attributes::AccessControlEntriesPerFabric::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AccessControlEntriesPerFabric", 1, value);
        }
        case AccessControl::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case AccessControl::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case AccessControl::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case AccessControl::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case AccessControl::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case Actions::Id: {
        switch (path.mAttributeId)
        {
        case Actions::Attributes::ActionList::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::ActionStruct::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActionList", 1, value);
        }
        case Actions::Attributes::EndpointLists::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::Actions::Structs::EndpointListStruct::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EndpointLists", 1, value);
        }
        case Actions::Attributes::SetupURL::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SetupURL", 1, value);
        }
        case Actions::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case Actions::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case Actions::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case Actions::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case Actions::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case Basic::Id: {
        switch (path.mAttributeId)
        {
        case Basic::Attributes::DataModelRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DataModelRevision", 1, value);
        }
        case Basic::Attributes::VendorName::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("VendorName", 1, value);
        }
        case Basic::Attributes::VendorID::Id: {
            chip::VendorId value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("VendorID", 1, value);
        }
        case Basic::Attributes::ProductName::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ProductName", 1, value);
        }
        case Basic::Attributes::ProductID::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ProductID", 1, value);
        }
        case Basic::Attributes::NodeLabel::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NodeLabel", 1, value);
        }
        case Basic::Attributes::Location::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Location", 1, value);
        }
        case Basic::Attributes::HardwareVersion::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("HardwareVersion", 1, value);
        }
        case Basic::Attributes::HardwareVersionString::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("HardwareVersionString", 1, value);
        }
        case Basic::Attributes::SoftwareVersion::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SoftwareVersion", 1, value);
        }
        case Basic::Attributes::SoftwareVersionString::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SoftwareVersionString", 1, value);
        }
        case Basic::Attributes::ManufacturingDate::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ManufacturingDate", 1, value);
        }
        case Basic::Attributes::PartNumber::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PartNumber", 1, value);
        }
        case Basic::Attributes::ProductURL::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ProductURL", 1, value);
        }
        case Basic::Attributes::ProductLabel::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ProductLabel", 1, value);
        }
        case Basic::Attributes::SerialNumber::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SerialNumber", 1, value);
        }
        case Basic::Attributes::LocalConfigDisabled::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LocalConfigDisabled", 1, value);
        }
        case Basic::Attributes::Reachable::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Reachable", 1, value);
        }
        case Basic::Attributes::UniqueID::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UniqueID", 1, value);
        }
        case Basic::Attributes::CapabilityMinima::Id: {
            chip::app::Clusters::Basic::Structs::CapabilityMinimaStruct::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CapabilityMinima", 1, value);
        }
        case Basic::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case Basic::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case Basic::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case Basic::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case Basic::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case OtaSoftwareUpdateProvider::Id: {
        switch (path.mAttributeId)
        {
        case OtaSoftwareUpdateProvider::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case OtaSoftwareUpdateProvider::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case OtaSoftwareUpdateProvider::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case OtaSoftwareUpdateProvider::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case OtaSoftwareUpdateProvider::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case OtaSoftwareUpdateRequestor::Id: {
        switch (path.mAttributeId)
        {
        case OtaSoftwareUpdateRequestor::Attributes::DefaultOtaProviders::Id: {
            chip::app::DataModel::DecodableList<
                chip::app::Clusters::OtaSoftwareUpdateRequestor::Structs::ProviderLocation::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DefaultOtaProviders", 1, value);
        }
        case OtaSoftwareUpdateRequestor::Attributes::UpdatePossible::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UpdatePossible", 1, value);
        }
        case OtaSoftwareUpdateRequestor::Attributes::UpdateState::Id: {
            chip::app::Clusters::OtaSoftwareUpdateRequestor::OTAUpdateStateEnum value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UpdateState", 1, value);
        }
        case OtaSoftwareUpdateRequestor::Attributes::UpdateStateProgress::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UpdateStateProgress", 1, value);
        }
        case OtaSoftwareUpdateRequestor::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case OtaSoftwareUpdateRequestor::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case OtaSoftwareUpdateRequestor::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case OtaSoftwareUpdateRequestor::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case OtaSoftwareUpdateRequestor::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case LocalizationConfiguration::Id: {
        switch (path.mAttributeId)
        {
        case LocalizationConfiguration::Attributes::ActiveLocale::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActiveLocale", 1, value);
        }
        case LocalizationConfiguration::Attributes::SupportedLocales::Id: {
            chip::app::DataModel::DecodableList<chip::CharSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SupportedLocales", 1, value);
        }
        case LocalizationConfiguration::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case LocalizationConfiguration::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case LocalizationConfiguration::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case LocalizationConfiguration::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case LocalizationConfiguration::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case TimeFormatLocalization::Id: {
        switch (path.mAttributeId)
        {
        case TimeFormatLocalization::Attributes::HourFormat::Id: {
            chip::app::Clusters::TimeFormatLocalization::HourFormat value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("HourFormat", 1, value);
        }
        case TimeFormatLocalization::Attributes::ActiveCalendarType::Id: {
            chip::app::Clusters::TimeFormatLocalization::CalendarType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActiveCalendarType", 1, value);
        }
        case TimeFormatLocalization::Attributes::SupportedCalendarTypes::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::TimeFormatLocalization::CalendarType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SupportedCalendarTypes", 1, value);
        }
        case TimeFormatLocalization::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case TimeFormatLocalization::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case TimeFormatLocalization::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case TimeFormatLocalization::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case TimeFormatLocalization::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case UnitLocalization::Id: {
        switch (path.mAttributeId)
        {
        case UnitLocalization::Attributes::TemperatureUnit::Id: {
            chip::app::Clusters::UnitLocalization::TempUnit value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TemperatureUnit", 1, value);
        }
        case UnitLocalization::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case UnitLocalization::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case UnitLocalization::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case UnitLocalization::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case UnitLocalization::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case PowerSourceConfiguration::Id: {
        switch (path.mAttributeId)
        {
        case PowerSourceConfiguration::Attributes::Sources::Id: {
            chip::app::DataModel::DecodableList<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Sources", 1, value);
        }
        case PowerSourceConfiguration::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case PowerSourceConfiguration::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case PowerSourceConfiguration::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case PowerSourceConfiguration::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case PowerSourceConfiguration::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case PowerSource::Id: {
        switch (path.mAttributeId)
        {
        case PowerSource::Attributes::Status::Id: {
            chip::app::Clusters::PowerSource::PowerSourceStatus value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Status", 1, value);
        }
        case PowerSource::Attributes::Order::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Order", 1, value);
        }
        case PowerSource::Attributes::Description::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Description", 1, value);
        }
        case PowerSource::Attributes::WiredAssessedInputVoltage::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WiredAssessedInputVoltage", 1, value);
        }
        case PowerSource::Attributes::WiredAssessedInputFrequency::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WiredAssessedInputFrequency", 1, value);
        }
        case PowerSource::Attributes::WiredCurrentType::Id: {
            chip::app::Clusters::PowerSource::WiredCurrentType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WiredCurrentType", 1, value);
        }
        case PowerSource::Attributes::WiredAssessedCurrent::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WiredAssessedCurrent", 1, value);
        }
        case PowerSource::Attributes::WiredNominalVoltage::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WiredNominalVoltage", 1, value);
        }
        case PowerSource::Attributes::WiredMaximumCurrent::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WiredMaximumCurrent", 1, value);
        }
        case PowerSource::Attributes::WiredPresent::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WiredPresent", 1, value);
        }
        case PowerSource::Attributes::ActiveWiredFaults::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::WiredFault> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActiveWiredFaults", 1, value);
        }
        case PowerSource::Attributes::BatVoltage::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatVoltage", 1, value);
        }
        case PowerSource::Attributes::BatPercentRemaining::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatPercentRemaining", 1, value);
        }
        case PowerSource::Attributes::BatTimeRemaining::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatTimeRemaining", 1, value);
        }
        case PowerSource::Attributes::BatChargeLevel::Id: {
            chip::app::Clusters::PowerSource::BatChargeLevel value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatChargeLevel", 1, value);
        }
        case PowerSource::Attributes::BatReplacementNeeded::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatReplacementNeeded", 1, value);
        }
        case PowerSource::Attributes::BatReplaceability::Id: {
            chip::app::Clusters::PowerSource::BatReplaceability value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatReplaceability", 1, value);
        }
        case PowerSource::Attributes::BatPresent::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatPresent", 1, value);
        }
        case PowerSource::Attributes::ActiveBatFaults::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatFault> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActiveBatFaults", 1, value);
        }
        case PowerSource::Attributes::BatReplacementDescription::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatReplacementDescription", 1, value);
        }
        case PowerSource::Attributes::BatCommonDesignation::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatCommonDesignation", 1, value);
        }
        case PowerSource::Attributes::BatANSIDesignation::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatANSIDesignation", 1, value);
        }
        case PowerSource::Attributes::BatIECDesignation::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatIECDesignation", 1, value);
        }
        case PowerSource::Attributes::BatApprovedChemistry::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatApprovedChemistry", 1, value);
        }
        case PowerSource::Attributes::BatCapacity::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatCapacity", 1, value);
        }
        case PowerSource::Attributes::BatQuantity::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatQuantity", 1, value);
        }
        case PowerSource::Attributes::BatChargeState::Id: {
            chip::app::Clusters::PowerSource::BatChargeState value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatChargeState", 1, value);
        }
        case PowerSource::Attributes::BatTimeToFullCharge::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatTimeToFullCharge", 1, value);
        }
        case PowerSource::Attributes::BatFunctionalWhileCharging::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatFunctionalWhileCharging", 1, value);
        }
        case PowerSource::Attributes::BatChargingCurrent::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BatChargingCurrent", 1, value);
        }
        case PowerSource::Attributes::ActiveBatChargeFaults::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::PowerSource::BatChargeFault> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActiveBatChargeFaults", 1, value);
        }
        case PowerSource::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case PowerSource::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case PowerSource::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case PowerSource::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case PowerSource::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case GeneralCommissioning::Id: {
        switch (path.mAttributeId)
        {
        case GeneralCommissioning::Attributes::Breadcrumb::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Breadcrumb", 1, value);
        }
        case GeneralCommissioning::Attributes::BasicCommissioningInfo::Id: {
            chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BasicCommissioningInfo", 1, value);
        }
        case GeneralCommissioning::Attributes::RegulatoryConfig::Id: {
            chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RegulatoryConfig", 1, value);
        }
        case GeneralCommissioning::Attributes::LocationCapability::Id: {
            chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LocationCapability", 1, value);
        }
        case GeneralCommissioning::Attributes::SupportsConcurrentConnection::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SupportsConcurrentConnection", 1, value);
        }
        case GeneralCommissioning::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case GeneralCommissioning::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case GeneralCommissioning::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case GeneralCommissioning::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case GeneralCommissioning::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case NetworkCommissioning::Id: {
        switch (path.mAttributeId)
        {
        case NetworkCommissioning::Attributes::MaxNetworks::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxNetworks", 1, value);
        }
        case NetworkCommissioning::Attributes::Networks::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::NetworkCommissioning::Structs::NetworkInfo::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Networks", 1, value);
        }
        case NetworkCommissioning::Attributes::ScanMaxTimeSeconds::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ScanMaxTimeSeconds", 1, value);
        }
        case NetworkCommissioning::Attributes::ConnectMaxTimeSeconds::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ConnectMaxTimeSeconds", 1, value);
        }
        case NetworkCommissioning::Attributes::InterfaceEnabled::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("InterfaceEnabled", 1, value);
        }
        case NetworkCommissioning::Attributes::LastNetworkingStatus::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::NetworkCommissioning::NetworkCommissioningStatus> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LastNetworkingStatus", 1, value);
        }
        case NetworkCommissioning::Attributes::LastNetworkID::Id: {
            chip::app::DataModel::Nullable<chip::ByteSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LastNetworkID", 1, value);
        }
        case NetworkCommissioning::Attributes::LastConnectErrorValue::Id: {
            chip::app::DataModel::Nullable<int32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LastConnectErrorValue", 1, value);
        }
        case NetworkCommissioning::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case NetworkCommissioning::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case NetworkCommissioning::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case NetworkCommissioning::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case NetworkCommissioning::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case DiagnosticLogs::Id: {
        switch (path.mAttributeId)
        {
        case DiagnosticLogs::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case DiagnosticLogs::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case DiagnosticLogs::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case DiagnosticLogs::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case DiagnosticLogs::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case GeneralDiagnostics::Id: {
        switch (path.mAttributeId)
        {
        case GeneralDiagnostics::Attributes::NetworkInterfaces::Id: {
            chip::app::DataModel::DecodableList<
                chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterfaceType::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NetworkInterfaces", 1, value);
        }
        case GeneralDiagnostics::Attributes::RebootCount::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RebootCount", 1, value);
        }
        case GeneralDiagnostics::Attributes::UpTime::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UpTime", 1, value);
        }
        case GeneralDiagnostics::Attributes::TotalOperationalHours::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TotalOperationalHours", 1, value);
        }
        case GeneralDiagnostics::Attributes::BootReasons::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BootReasons", 1, value);
        }
        case GeneralDiagnostics::Attributes::ActiveHardwareFaults::Id: {
            chip::app::DataModel::DecodableList<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActiveHardwareFaults", 1, value);
        }
        case GeneralDiagnostics::Attributes::ActiveRadioFaults::Id: {
            chip::app::DataModel::DecodableList<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActiveRadioFaults", 1, value);
        }
        case GeneralDiagnostics::Attributes::ActiveNetworkFaults::Id: {
            chip::app::DataModel::DecodableList<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActiveNetworkFaults", 1, value);
        }
        case GeneralDiagnostics::Attributes::TestEventTriggersEnabled::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestEventTriggersEnabled", 1, value);
        }
        case GeneralDiagnostics::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case GeneralDiagnostics::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case GeneralDiagnostics::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case GeneralDiagnostics::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case GeneralDiagnostics::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case SoftwareDiagnostics::Id: {
        switch (path.mAttributeId)
        {
        case SoftwareDiagnostics::Attributes::ThreadMetrics::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::SoftwareDiagnostics::Structs::ThreadMetrics::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ThreadMetrics", 1, value);
        }
        case SoftwareDiagnostics::Attributes::CurrentHeapFree::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentHeapFree", 1, value);
        }
        case SoftwareDiagnostics::Attributes::CurrentHeapUsed::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentHeapUsed", 1, value);
        }
        case SoftwareDiagnostics::Attributes::CurrentHeapHighWatermark::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentHeapHighWatermark", 1, value);
        }
        case SoftwareDiagnostics::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case SoftwareDiagnostics::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case SoftwareDiagnostics::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case SoftwareDiagnostics::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case SoftwareDiagnostics::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case ThreadNetworkDiagnostics::Id: {
        switch (path.mAttributeId)
        {
        case ThreadNetworkDiagnostics::Attributes::Channel::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("channel", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RoutingRole::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::RoutingRole> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RoutingRole", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::NetworkName::Id: {
            chip::app::DataModel::Nullable<chip::CharSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NetworkName", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::PanId::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PanId", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::ExtendedPanId::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ExtendedPanId", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::MeshLocalPrefix::Id: {
            chip::app::DataModel::Nullable<chip::ByteSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MeshLocalPrefix", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::OverrunCount::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OverrunCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::NeighborTableList::Id: {
            chip::app::DataModel::DecodableList<
                chip::app::Clusters::ThreadNetworkDiagnostics::Structs::NeighborTable::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NeighborTableList", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RouteTableList::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::ThreadNetworkDiagnostics::Structs::RouteTable::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RouteTableList", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::PartitionId::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PartitionId", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::Weighting::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("weighting", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::DataVersion::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DataVersion", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::StableDataVersion::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StableDataVersion", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::LeaderRouterId::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LeaderRouterId", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::DetachedRoleCount::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DetachedRoleCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::ChildRoleCount::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ChildRoleCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RouterRoleCount::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RouterRoleCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::LeaderRoleCount::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LeaderRoleCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::AttachAttemptCount::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttachAttemptCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::PartitionIdChangeCount::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PartitionIdChangeCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::BetterPartitionAttachAttemptCount::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BetterPartitionAttachAttemptCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::ParentChangeCount::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ParentChangeCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxTotalCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxTotalCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxUnicastCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxUnicastCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxBroadcastCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxBroadcastCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxAckRequestedCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxAckRequestedCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxAckedCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxAckedCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxNoAckRequestedCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxNoAckRequestedCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxDataCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxDataCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxDataPollCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxDataPollCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxBeaconCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxBeaconCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxBeaconRequestCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxBeaconRequestCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxOtherCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxOtherCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxRetryCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxRetryCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxDirectMaxRetryExpiryCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxDirectMaxRetryExpiryCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxIndirectMaxRetryExpiryCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxIndirectMaxRetryExpiryCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxErrCcaCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxErrCcaCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxErrAbortCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxErrAbortCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::TxErrBusyChannelCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxErrBusyChannelCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxTotalCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxTotalCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxUnicastCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxUnicastCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxBroadcastCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxBroadcastCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxDataCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxDataCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxDataPollCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxDataPollCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxBeaconCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxBeaconCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxBeaconRequestCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxBeaconRequestCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxOtherCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxOtherCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxAddressFilteredCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxAddressFilteredCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxDestAddrFilteredCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxDestAddrFilteredCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxDuplicatedCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxDuplicatedCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxErrNoFrameCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxErrNoFrameCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxErrUnknownNeighborCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxErrUnknownNeighborCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxErrInvalidSrcAddrCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxErrInvalidSrcAddrCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxErrSecCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxErrSecCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxErrFcsCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxErrFcsCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::RxErrOtherCount::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RxErrOtherCount", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::ActiveTimestamp::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActiveTimestamp", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::PendingTimestamp::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PendingTimestamp", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::Delay::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Delay", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::SecurityPolicy::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::ThreadNetworkDiagnostics::Structs::SecurityPolicy::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SecurityPolicy", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::ChannelPage0Mask::Id: {
            chip::app::DataModel::Nullable<chip::ByteSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ChannelPage0Mask", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::OperationalDatasetComponents::Id: {
            chip::app::DataModel::Nullable<
                chip::app::Clusters::ThreadNetworkDiagnostics::Structs::OperationalDatasetComponents::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OperationalDatasetComponents", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::ActiveNetworkFaultsList::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::ThreadNetworkDiagnostics::NetworkFault> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActiveNetworkFaultsList", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case ThreadNetworkDiagnostics::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case WiFiNetworkDiagnostics::Id: {
        switch (path.mAttributeId)
        {
        case WiFiNetworkDiagnostics::Attributes::Bssid::Id: {
            chip::app::DataModel::Nullable<chip::ByteSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("bssid", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::SecurityType::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::SecurityType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SecurityType", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::WiFiVersion::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::WiFiNetworkDiagnostics::WiFiVersionType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WiFiVersion", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::ChannelNumber::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ChannelNumber", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::Rssi::Id: {
            chip::app::DataModel::Nullable<int8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Rssi", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::BeaconLostCount::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BeaconLostCount", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::BeaconRxCount::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BeaconRxCount", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::PacketMulticastRxCount::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PacketMulticastRxCount", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::PacketMulticastTxCount::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PacketMulticastTxCount", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::PacketUnicastRxCount::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PacketUnicastRxCount", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::PacketUnicastTxCount::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PacketUnicastTxCount", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::CurrentMaxRate::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentMaxRate", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::OverrunCount::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OverrunCount", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case WiFiNetworkDiagnostics::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case EthernetNetworkDiagnostics::Id: {
        switch (path.mAttributeId)
        {
        case EthernetNetworkDiagnostics::Attributes::PHYRate::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PHYRate", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::FullDuplex::Id: {
            chip::app::DataModel::Nullable<bool> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FullDuplex", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::PacketRxCount::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PacketRxCount", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::PacketTxCount::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PacketTxCount", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::TxErrCount::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TxErrCount", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::CollisionCount::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CollisionCount", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::OverrunCount::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OverrunCount", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::CarrierDetect::Id: {
            chip::app::DataModel::Nullable<bool> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CarrierDetect", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::TimeSinceReset::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TimeSinceReset", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case EthernetNetworkDiagnostics::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case BridgedDeviceBasic::Id: {
        switch (path.mAttributeId)
        {
        case BridgedDeviceBasic::Attributes::VendorName::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("VendorName", 1, value);
        }
        case BridgedDeviceBasic::Attributes::VendorID::Id: {
            chip::VendorId value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("VendorID", 1, value);
        }
        case BridgedDeviceBasic::Attributes::ProductName::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ProductName", 1, value);
        }
        case BridgedDeviceBasic::Attributes::NodeLabel::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NodeLabel", 1, value);
        }
        case BridgedDeviceBasic::Attributes::HardwareVersion::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("HardwareVersion", 1, value);
        }
        case BridgedDeviceBasic::Attributes::HardwareVersionString::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("HardwareVersionString", 1, value);
        }
        case BridgedDeviceBasic::Attributes::SoftwareVersion::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SoftwareVersion", 1, value);
        }
        case BridgedDeviceBasic::Attributes::SoftwareVersionString::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SoftwareVersionString", 1, value);
        }
        case BridgedDeviceBasic::Attributes::ManufacturingDate::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ManufacturingDate", 1, value);
        }
        case BridgedDeviceBasic::Attributes::PartNumber::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PartNumber", 1, value);
        }
        case BridgedDeviceBasic::Attributes::ProductURL::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ProductURL", 1, value);
        }
        case BridgedDeviceBasic::Attributes::ProductLabel::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ProductLabel", 1, value);
        }
        case BridgedDeviceBasic::Attributes::SerialNumber::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SerialNumber", 1, value);
        }
        case BridgedDeviceBasic::Attributes::Reachable::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Reachable", 1, value);
        }
        case BridgedDeviceBasic::Attributes::UniqueID::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UniqueID", 1, value);
        }
        case BridgedDeviceBasic::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case BridgedDeviceBasic::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case BridgedDeviceBasic::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case BridgedDeviceBasic::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case BridgedDeviceBasic::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case Switch::Id: {
        switch (path.mAttributeId)
        {
        case Switch::Attributes::NumberOfPositions::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("number of positions", 1, value);
        }
        case Switch::Attributes::CurrentPosition::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("current position", 1, value);
        }
        case Switch::Attributes::MultiPressMax::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("multi press max", 1, value);
        }
        case Switch::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case Switch::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case Switch::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case Switch::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case Switch::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case AdministratorCommissioning::Id: {
        switch (path.mAttributeId)
        {
        case AdministratorCommissioning::Attributes::WindowStatus::Id: {
            chip::app::Clusters::AdministratorCommissioning::CommissioningWindowStatus value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WindowStatus", 1, value);
        }
        case AdministratorCommissioning::Attributes::AdminFabricIndex::Id: {
            chip::app::DataModel::Nullable<chip::FabricIndex> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AdminFabricIndex", 1, value);
        }
        case AdministratorCommissioning::Attributes::AdminVendorId::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AdminVendorId", 1, value);
        }
        case AdministratorCommissioning::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case AdministratorCommissioning::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case AdministratorCommissioning::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case AdministratorCommissioning::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case AdministratorCommissioning::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case OperationalCredentials::Id: {
        switch (path.mAttributeId)
        {
        case OperationalCredentials::Attributes::NOCs::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::OperationalCredentials::Structs::NOCStruct::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NOCs", 1, value);
        }
        case OperationalCredentials::Attributes::Fabrics::Id: {
            chip::app::DataModel::DecodableList<
                chip::app::Clusters::OperationalCredentials::Structs::FabricDescriptor::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Fabrics", 1, value);
        }
        case OperationalCredentials::Attributes::SupportedFabrics::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SupportedFabrics", 1, value);
        }
        case OperationalCredentials::Attributes::CommissionedFabrics::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CommissionedFabrics", 1, value);
        }
        case OperationalCredentials::Attributes::TrustedRootCertificates::Id: {
            chip::app::DataModel::DecodableList<chip::ByteSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TrustedRootCertificates", 1, value);
        }
        case OperationalCredentials::Attributes::CurrentFabricIndex::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentFabricIndex", 1, value);
        }
        case OperationalCredentials::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case OperationalCredentials::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case OperationalCredentials::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case OperationalCredentials::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case OperationalCredentials::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case GroupKeyManagement::Id: {
        switch (path.mAttributeId)
        {
        case GroupKeyManagement::Attributes::GroupKeyMap::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::GroupKeyManagement::Structs::GroupKeyMapStruct::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GroupKeyMap", 1, value);
        }
        case GroupKeyManagement::Attributes::GroupTable::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::GroupKeyManagement::Structs::GroupInfoMapStruct::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GroupTable", 1, value);
        }
        case GroupKeyManagement::Attributes::MaxGroupsPerFabric::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxGroupsPerFabric", 1, value);
        }
        case GroupKeyManagement::Attributes::MaxGroupKeysPerFabric::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxGroupKeysPerFabric", 1, value);
        }
        case GroupKeyManagement::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case GroupKeyManagement::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case GroupKeyManagement::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case GroupKeyManagement::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case GroupKeyManagement::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case FixedLabel::Id: {
        switch (path.mAttributeId)
        {
        case FixedLabel::Attributes::LabelList::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::FixedLabel::Structs::LabelStruct::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("label list", 1, value);
        }
        case FixedLabel::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case FixedLabel::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case FixedLabel::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case FixedLabel::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case FixedLabel::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case UserLabel::Id: {
        switch (path.mAttributeId)
        {
        case UserLabel::Attributes::LabelList::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::UserLabel::Structs::LabelStruct::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("label list", 1, value);
        }
        case UserLabel::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case UserLabel::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case UserLabel::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case UserLabel::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case UserLabel::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case BooleanState::Id: {
        switch (path.mAttributeId)
        {
        case BooleanState::Attributes::StateValue::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StateValue", 1, value);
        }
        case BooleanState::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case BooleanState::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case BooleanState::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case BooleanState::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case BooleanState::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case ModeSelect::Id: {
        switch (path.mAttributeId)
        {
        case ModeSelect::Attributes::Description::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Description", 1, value);
        }
        case ModeSelect::Attributes::StandardNamespace::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StandardNamespace", 1, value);
        }
        case ModeSelect::Attributes::SupportedModes::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::ModeSelect::Structs::ModeOptionStruct::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SupportedModes", 1, value);
        }
        case ModeSelect::Attributes::CurrentMode::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentMode", 1, value);
        }
        case ModeSelect::Attributes::StartUpMode::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StartUpMode", 1, value);
        }
        case ModeSelect::Attributes::OnMode::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OnMode", 1, value);
        }
        case ModeSelect::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case ModeSelect::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case ModeSelect::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case ModeSelect::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case ModeSelect::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case DoorLock::Id: {
        switch (path.mAttributeId)
        {
        case DoorLock::Attributes::LockState::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlLockState> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LockState", 1, value);
        }
        case DoorLock::Attributes::LockType::Id: {
            chip::app::Clusters::DoorLock::DlLockType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LockType", 1, value);
        }
        case DoorLock::Attributes::ActuatorEnabled::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActuatorEnabled", 1, value);
        }
        case DoorLock::Attributes::DoorState::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::DoorLock::DlDoorState> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DoorState", 1, value);
        }
        case DoorLock::Attributes::DoorOpenEvents::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DoorOpenEvents", 1, value);
        }
        case DoorLock::Attributes::DoorClosedEvents::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DoorClosedEvents", 1, value);
        }
        case DoorLock::Attributes::OpenPeriod::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OpenPeriod", 1, value);
        }
        case DoorLock::Attributes::NumberOfTotalUsersSupported::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfTotalUsersSupported", 1, value);
        }
        case DoorLock::Attributes::NumberOfPINUsersSupported::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfPINUsersSupported", 1, value);
        }
        case DoorLock::Attributes::NumberOfRFIDUsersSupported::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfRFIDUsersSupported", 1, value);
        }
        case DoorLock::Attributes::NumberOfWeekDaySchedulesSupportedPerUser::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfWeekDaySchedulesSupportedPerUser", 1, value);
        }
        case DoorLock::Attributes::NumberOfYearDaySchedulesSupportedPerUser::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfYearDaySchedulesSupportedPerUser", 1, value);
        }
        case DoorLock::Attributes::NumberOfHolidaySchedulesSupported::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfHolidaySchedulesSupported", 1, value);
        }
        case DoorLock::Attributes::MaxPINCodeLength::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxPINCodeLength", 1, value);
        }
        case DoorLock::Attributes::MinPINCodeLength::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinPINCodeLength", 1, value);
        }
        case DoorLock::Attributes::MaxRFIDCodeLength::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxRFIDCodeLength", 1, value);
        }
        case DoorLock::Attributes::MinRFIDCodeLength::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinRFIDCodeLength", 1, value);
        }
        case DoorLock::Attributes::CredentialRulesSupport::Id: {
            chip::BitMask<chip::app::Clusters::DoorLock::DlCredentialRuleMask> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CredentialRulesSupport", 1, value);
        }
        case DoorLock::Attributes::NumberOfCredentialsSupportedPerUser::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfCredentialsSupportedPerUser", 1, value);
        }
        case DoorLock::Attributes::Language::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Language", 1, value);
        }
        case DoorLock::Attributes::LEDSettings::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LEDSettings", 1, value);
        }
        case DoorLock::Attributes::AutoRelockTime::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AutoRelockTime", 1, value);
        }
        case DoorLock::Attributes::SoundVolume::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SoundVolume", 1, value);
        }
        case DoorLock::Attributes::OperatingMode::Id: {
            chip::app::Clusters::DoorLock::DlOperatingMode value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OperatingMode", 1, value);
        }
        case DoorLock::Attributes::SupportedOperatingModes::Id: {
            chip::BitMask<chip::app::Clusters::DoorLock::DlSupportedOperatingModes> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SupportedOperatingModes", 1, value);
        }
        case DoorLock::Attributes::DefaultConfigurationRegister::Id: {
            chip::BitMask<chip::app::Clusters::DoorLock::DlDefaultConfigurationRegister> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DefaultConfigurationRegister", 1, value);
        }
        case DoorLock::Attributes::EnableLocalProgramming::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EnableLocalProgramming", 1, value);
        }
        case DoorLock::Attributes::EnableOneTouchLocking::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EnableOneTouchLocking", 1, value);
        }
        case DoorLock::Attributes::EnableInsideStatusLED::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EnableInsideStatusLED", 1, value);
        }
        case DoorLock::Attributes::EnablePrivacyModeButton::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EnablePrivacyModeButton", 1, value);
        }
        case DoorLock::Attributes::LocalProgrammingFeatures::Id: {
            chip::BitMask<chip::app::Clusters::DoorLock::DlLocalProgrammingFeatures> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LocalProgrammingFeatures", 1, value);
        }
        case DoorLock::Attributes::WrongCodeEntryLimit::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WrongCodeEntryLimit", 1, value);
        }
        case DoorLock::Attributes::UserCodeTemporaryDisableTime::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UserCodeTemporaryDisableTime", 1, value);
        }
        case DoorLock::Attributes::SendPINOverTheAir::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SendPINOverTheAir", 1, value);
        }
        case DoorLock::Attributes::RequirePINforRemoteOperation::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RequirePINforRemoteOperation", 1, value);
        }
        case DoorLock::Attributes::ExpiringUserTimeout::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ExpiringUserTimeout", 1, value);
        }
        case DoorLock::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case DoorLock::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case DoorLock::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case DoorLock::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case DoorLock::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case WindowCovering::Id: {
        switch (path.mAttributeId)
        {
        case WindowCovering::Attributes::Type::Id: {
            chip::app::Clusters::WindowCovering::Type value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Type", 1, value);
        }
        case WindowCovering::Attributes::PhysicalClosedLimitLift::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PhysicalClosedLimitLift", 1, value);
        }
        case WindowCovering::Attributes::PhysicalClosedLimitTilt::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PhysicalClosedLimitTilt", 1, value);
        }
        case WindowCovering::Attributes::CurrentPositionLift::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentPositionLift", 1, value);
        }
        case WindowCovering::Attributes::CurrentPositionTilt::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentPositionTilt", 1, value);
        }
        case WindowCovering::Attributes::NumberOfActuationsLift::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfActuationsLift", 1, value);
        }
        case WindowCovering::Attributes::NumberOfActuationsTilt::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfActuationsTilt", 1, value);
        }
        case WindowCovering::Attributes::ConfigStatus::Id: {
            chip::BitMask<chip::app::Clusters::WindowCovering::ConfigStatus> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ConfigStatus", 1, value);
        }
        case WindowCovering::Attributes::CurrentPositionLiftPercentage::Id: {
            chip::app::DataModel::Nullable<chip::Percent> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentPositionLiftPercentage", 1, value);
        }
        case WindowCovering::Attributes::CurrentPositionTiltPercentage::Id: {
            chip::app::DataModel::Nullable<chip::Percent> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentPositionTiltPercentage", 1, value);
        }
        case WindowCovering::Attributes::OperationalStatus::Id: {
            chip::BitMask<chip::app::Clusters::WindowCovering::OperationalStatus> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OperationalStatus", 1, value);
        }
        case WindowCovering::Attributes::TargetPositionLiftPercent100ths::Id: {
            chip::app::DataModel::Nullable<chip::Percent100ths> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TargetPositionLiftPercent100ths", 1, value);
        }
        case WindowCovering::Attributes::TargetPositionTiltPercent100ths::Id: {
            chip::app::DataModel::Nullable<chip::Percent100ths> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TargetPositionTiltPercent100ths", 1, value);
        }
        case WindowCovering::Attributes::EndProductType::Id: {
            chip::app::Clusters::WindowCovering::EndProductType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EndProductType", 1, value);
        }
        case WindowCovering::Attributes::CurrentPositionLiftPercent100ths::Id: {
            chip::app::DataModel::Nullable<chip::Percent100ths> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentPositionLiftPercent100ths", 1, value);
        }
        case WindowCovering::Attributes::CurrentPositionTiltPercent100ths::Id: {
            chip::app::DataModel::Nullable<chip::Percent100ths> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentPositionTiltPercent100ths", 1, value);
        }
        case WindowCovering::Attributes::InstalledOpenLimitLift::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("InstalledOpenLimitLift", 1, value);
        }
        case WindowCovering::Attributes::InstalledClosedLimitLift::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("InstalledClosedLimitLift", 1, value);
        }
        case WindowCovering::Attributes::InstalledOpenLimitTilt::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("InstalledOpenLimitTilt", 1, value);
        }
        case WindowCovering::Attributes::InstalledClosedLimitTilt::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("InstalledClosedLimitTilt", 1, value);
        }
        case WindowCovering::Attributes::Mode::Id: {
            chip::BitMask<chip::app::Clusters::WindowCovering::Mode> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Mode", 1, value);
        }
        case WindowCovering::Attributes::SafetyStatus::Id: {
            chip::BitMask<chip::app::Clusters::WindowCovering::SafetyStatus> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SafetyStatus", 1, value);
        }
        case WindowCovering::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case WindowCovering::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case WindowCovering::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case WindowCovering::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case WindowCovering::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case BarrierControl::Id: {
        switch (path.mAttributeId)
        {
        case BarrierControl::Attributes::BarrierMovingState::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("barrier moving state", 1, value);
        }
        case BarrierControl::Attributes::BarrierSafetyStatus::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("barrier safety status", 1, value);
        }
        case BarrierControl::Attributes::BarrierCapabilities::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("barrier capabilities", 1, value);
        }
        case BarrierControl::Attributes::BarrierOpenEvents::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("barrier open events", 1, value);
        }
        case BarrierControl::Attributes::BarrierCloseEvents::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("barrier close events", 1, value);
        }
        case BarrierControl::Attributes::BarrierCommandOpenEvents::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("barrier command open events", 1, value);
        }
        case BarrierControl::Attributes::BarrierCommandCloseEvents::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("barrier command close events", 1, value);
        }
        case BarrierControl::Attributes::BarrierOpenPeriod::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("barrier open period", 1, value);
        }
        case BarrierControl::Attributes::BarrierClosePeriod::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("barrier close period", 1, value);
        }
        case BarrierControl::Attributes::BarrierPosition::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("barrier position", 1, value);
        }
        case BarrierControl::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case BarrierControl::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case BarrierControl::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case BarrierControl::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case BarrierControl::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case PumpConfigurationAndControl::Id: {
        switch (path.mAttributeId)
        {
        case PumpConfigurationAndControl::Attributes::MaxPressure::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxPressure", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MaxSpeed::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxSpeed", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MaxFlow::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxFlow", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MinConstPressure::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinConstPressure", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MaxConstPressure::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxConstPressure", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MinCompPressure::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinCompPressure", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MaxCompPressure::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxCompPressure", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MinConstSpeed::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinConstSpeed", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MaxConstSpeed::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxConstSpeed", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MinConstFlow::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinConstFlow", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MaxConstFlow::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxConstFlow", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MinConstTemp::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinConstTemp", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::MaxConstTemp::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxConstTemp", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::PumpStatus::Id: {
            chip::BitMask<chip::app::Clusters::PumpConfigurationAndControl::PumpStatus> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PumpStatus", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::EffectiveOperationMode::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::PumpOperationMode value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EffectiveOperationMode", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::EffectiveControlMode::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::PumpControlMode value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EffectiveControlMode", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::Capacity::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Capacity", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::Speed::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Speed", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::LifetimeRunningHours::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LifetimeRunningHours", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::Power::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Power", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::LifetimeEnergyConsumed::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LifetimeEnergyConsumed", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::OperationMode::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::PumpOperationMode value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OperationMode", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::ControlMode::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::PumpControlMode value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ControlMode", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case PumpConfigurationAndControl::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case Thermostat::Id: {
        switch (path.mAttributeId)
        {
        case Thermostat::Attributes::LocalTemperature::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LocalTemperature", 1, value);
        }
        case Thermostat::Attributes::OutdoorTemperature::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OutdoorTemperature", 1, value);
        }
        case Thermostat::Attributes::Occupancy::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Occupancy", 1, value);
        }
        case Thermostat::Attributes::AbsMinHeatSetpointLimit::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AbsMinHeatSetpointLimit", 1, value);
        }
        case Thermostat::Attributes::AbsMaxHeatSetpointLimit::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AbsMaxHeatSetpointLimit", 1, value);
        }
        case Thermostat::Attributes::AbsMinCoolSetpointLimit::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AbsMinCoolSetpointLimit", 1, value);
        }
        case Thermostat::Attributes::AbsMaxCoolSetpointLimit::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AbsMaxCoolSetpointLimit", 1, value);
        }
        case Thermostat::Attributes::PICoolingDemand::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PICoolingDemand", 1, value);
        }
        case Thermostat::Attributes::PIHeatingDemand::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PIHeatingDemand", 1, value);
        }
        case Thermostat::Attributes::HVACSystemTypeConfiguration::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("HVACSystemTypeConfiguration", 1, value);
        }
        case Thermostat::Attributes::LocalTemperatureCalibration::Id: {
            int8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LocalTemperatureCalibration", 1, value);
        }
        case Thermostat::Attributes::OccupiedCoolingSetpoint::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OccupiedCoolingSetpoint", 1, value);
        }
        case Thermostat::Attributes::OccupiedHeatingSetpoint::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OccupiedHeatingSetpoint", 1, value);
        }
        case Thermostat::Attributes::UnoccupiedCoolingSetpoint::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UnoccupiedCoolingSetpoint", 1, value);
        }
        case Thermostat::Attributes::UnoccupiedHeatingSetpoint::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UnoccupiedHeatingSetpoint", 1, value);
        }
        case Thermostat::Attributes::MinHeatSetpointLimit::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinHeatSetpointLimit", 1, value);
        }
        case Thermostat::Attributes::MaxHeatSetpointLimit::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxHeatSetpointLimit", 1, value);
        }
        case Thermostat::Attributes::MinCoolSetpointLimit::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinCoolSetpointLimit", 1, value);
        }
        case Thermostat::Attributes::MaxCoolSetpointLimit::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxCoolSetpointLimit", 1, value);
        }
        case Thermostat::Attributes::MinSetpointDeadBand::Id: {
            int8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinSetpointDeadBand", 1, value);
        }
        case Thermostat::Attributes::RemoteSensing::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RemoteSensing", 1, value);
        }
        case Thermostat::Attributes::ControlSequenceOfOperation::Id: {
            chip::app::Clusters::Thermostat::ThermostatControlSequence value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ControlSequenceOfOperation", 1, value);
        }
        case Thermostat::Attributes::SystemMode::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SystemMode", 1, value);
        }
        case Thermostat::Attributes::ThermostatRunningMode::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ThermostatRunningMode", 1, value);
        }
        case Thermostat::Attributes::StartOfWeek::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StartOfWeek", 1, value);
        }
        case Thermostat::Attributes::NumberOfWeeklyTransitions::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfWeeklyTransitions", 1, value);
        }
        case Thermostat::Attributes::NumberOfDailyTransitions::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfDailyTransitions", 1, value);
        }
        case Thermostat::Attributes::TemperatureSetpointHold::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TemperatureSetpointHold", 1, value);
        }
        case Thermostat::Attributes::TemperatureSetpointHoldDuration::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TemperatureSetpointHoldDuration", 1, value);
        }
        case Thermostat::Attributes::ThermostatProgrammingOperationMode::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ThermostatProgrammingOperationMode", 1, value);
        }
        case Thermostat::Attributes::ThermostatRunningState::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ThermostatRunningState", 1, value);
        }
        case Thermostat::Attributes::SetpointChangeSource::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SetpointChangeSource", 1, value);
        }
        case Thermostat::Attributes::SetpointChangeAmount::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SetpointChangeAmount", 1, value);
        }
        case Thermostat::Attributes::SetpointChangeSourceTimestamp::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SetpointChangeSourceTimestamp", 1, value);
        }
        case Thermostat::Attributes::OccupiedSetback::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OccupiedSetback", 1, value);
        }
        case Thermostat::Attributes::OccupiedSetbackMin::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OccupiedSetbackMin", 1, value);
        }
        case Thermostat::Attributes::OccupiedSetbackMax::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OccupiedSetbackMax", 1, value);
        }
        case Thermostat::Attributes::UnoccupiedSetback::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UnoccupiedSetback", 1, value);
        }
        case Thermostat::Attributes::UnoccupiedSetbackMin::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UnoccupiedSetbackMin", 1, value);
        }
        case Thermostat::Attributes::UnoccupiedSetbackMax::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("UnoccupiedSetbackMax", 1, value);
        }
        case Thermostat::Attributes::EmergencyHeatDelta::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EmergencyHeatDelta", 1, value);
        }
        case Thermostat::Attributes::ACType::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ACType", 1, value);
        }
        case Thermostat::Attributes::ACCapacity::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ACCapacity", 1, value);
        }
        case Thermostat::Attributes::ACRefrigerantType::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ACRefrigerantType", 1, value);
        }
        case Thermostat::Attributes::ACCompressorType::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ACCompressorType", 1, value);
        }
        case Thermostat::Attributes::ACErrorCode::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ACErrorCode", 1, value);
        }
        case Thermostat::Attributes::ACLouverPosition::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ACLouverPosition", 1, value);
        }
        case Thermostat::Attributes::ACCoilTemperature::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ACCoilTemperature", 1, value);
        }
        case Thermostat::Attributes::ACCapacityformat::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ACCapacityformat", 1, value);
        }
        case Thermostat::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case Thermostat::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case Thermostat::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case Thermostat::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case Thermostat::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case FanControl::Id: {
        switch (path.mAttributeId)
        {
        case FanControl::Attributes::FanMode::Id: {
            chip::app::Clusters::FanControl::FanModeType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("fan mode", 1, value);
        }
        case FanControl::Attributes::FanModeSequence::Id: {
            chip::app::Clusters::FanControl::FanModeSequenceType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("fan mode sequence", 1, value);
        }
        case FanControl::Attributes::PercentSetting::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("percent setting", 1, value);
        }
        case FanControl::Attributes::PercentCurrent::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("percent current", 1, value);
        }
        case FanControl::Attributes::SpeedMax::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("speed max", 1, value);
        }
        case FanControl::Attributes::SpeedSetting::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("speed setting", 1, value);
        }
        case FanControl::Attributes::SpeedCurrent::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("speed current", 1, value);
        }
        case FanControl::Attributes::RockSupport::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rock support", 1, value);
        }
        case FanControl::Attributes::RockSetting::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rock setting", 1, value);
        }
        case FanControl::Attributes::WindSupport::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("wind support", 1, value);
        }
        case FanControl::Attributes::WindSetting::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("wind setting", 1, value);
        }
        case FanControl::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case FanControl::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case FanControl::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case FanControl::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case FanControl::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case ThermostatUserInterfaceConfiguration::Id: {
        switch (path.mAttributeId)
        {
        case ThermostatUserInterfaceConfiguration::Attributes::TemperatureDisplayMode::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("temperature display mode", 1, value);
        }
        case ThermostatUserInterfaceConfiguration::Attributes::KeypadLockout::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("keypad lockout", 1, value);
        }
        case ThermostatUserInterfaceConfiguration::Attributes::ScheduleProgrammingVisibility::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("schedule programming visibility", 1, value);
        }
        case ThermostatUserInterfaceConfiguration::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case ThermostatUserInterfaceConfiguration::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case ThermostatUserInterfaceConfiguration::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case ThermostatUserInterfaceConfiguration::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case ThermostatUserInterfaceConfiguration::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case ColorControl::Id: {
        switch (path.mAttributeId)
        {
        case ColorControl::Attributes::CurrentHue::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentHue", 1, value);
        }
        case ColorControl::Attributes::CurrentSaturation::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentSaturation", 1, value);
        }
        case ColorControl::Attributes::RemainingTime::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RemainingTime", 1, value);
        }
        case ColorControl::Attributes::CurrentX::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentX", 1, value);
        }
        case ColorControl::Attributes::CurrentY::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentY", 1, value);
        }
        case ColorControl::Attributes::DriftCompensation::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DriftCompensation", 1, value);
        }
        case ColorControl::Attributes::CompensationText::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CompensationText", 1, value);
        }
        case ColorControl::Attributes::ColorTemperatureMireds::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorTemperatureMireds", 1, value);
        }
        case ColorControl::Attributes::ColorMode::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorMode", 1, value);
        }
        case ColorControl::Attributes::Options::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Options", 1, value);
        }
        case ColorControl::Attributes::NumberOfPrimaries::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NumberOfPrimaries", 1, value);
        }
        case ColorControl::Attributes::Primary1X::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary1X", 1, value);
        }
        case ColorControl::Attributes::Primary1Y::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary1Y", 1, value);
        }
        case ColorControl::Attributes::Primary1Intensity::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary1Intensity", 1, value);
        }
        case ColorControl::Attributes::Primary2X::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary2X", 1, value);
        }
        case ColorControl::Attributes::Primary2Y::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary2Y", 1, value);
        }
        case ColorControl::Attributes::Primary2Intensity::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary2Intensity", 1, value);
        }
        case ColorControl::Attributes::Primary3X::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary3X", 1, value);
        }
        case ColorControl::Attributes::Primary3Y::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary3Y", 1, value);
        }
        case ColorControl::Attributes::Primary3Intensity::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary3Intensity", 1, value);
        }
        case ColorControl::Attributes::Primary4X::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary4X", 1, value);
        }
        case ColorControl::Attributes::Primary4Y::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary4Y", 1, value);
        }
        case ColorControl::Attributes::Primary4Intensity::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary4Intensity", 1, value);
        }
        case ColorControl::Attributes::Primary5X::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary5X", 1, value);
        }
        case ColorControl::Attributes::Primary5Y::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary5Y", 1, value);
        }
        case ColorControl::Attributes::Primary5Intensity::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary5Intensity", 1, value);
        }
        case ColorControl::Attributes::Primary6X::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary6X", 1, value);
        }
        case ColorControl::Attributes::Primary6Y::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary6Y", 1, value);
        }
        case ColorControl::Attributes::Primary6Intensity::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Primary6Intensity", 1, value);
        }
        case ColorControl::Attributes::WhitePointX::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WhitePointX", 1, value);
        }
        case ColorControl::Attributes::WhitePointY::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("WhitePointY", 1, value);
        }
        case ColorControl::Attributes::ColorPointRX::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorPointRX", 1, value);
        }
        case ColorControl::Attributes::ColorPointRY::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorPointRY", 1, value);
        }
        case ColorControl::Attributes::ColorPointRIntensity::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorPointRIntensity", 1, value);
        }
        case ColorControl::Attributes::ColorPointGX::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorPointGX", 1, value);
        }
        case ColorControl::Attributes::ColorPointGY::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorPointGY", 1, value);
        }
        case ColorControl::Attributes::ColorPointGIntensity::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorPointGIntensity", 1, value);
        }
        case ColorControl::Attributes::ColorPointBX::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorPointBX", 1, value);
        }
        case ColorControl::Attributes::ColorPointBY::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorPointBY", 1, value);
        }
        case ColorControl::Attributes::ColorPointBIntensity::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorPointBIntensity", 1, value);
        }
        case ColorControl::Attributes::EnhancedCurrentHue::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EnhancedCurrentHue", 1, value);
        }
        case ColorControl::Attributes::EnhancedColorMode::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EnhancedColorMode", 1, value);
        }
        case ColorControl::Attributes::ColorLoopActive::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorLoopActive", 1, value);
        }
        case ColorControl::Attributes::ColorLoopDirection::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorLoopDirection", 1, value);
        }
        case ColorControl::Attributes::ColorLoopTime::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorLoopTime", 1, value);
        }
        case ColorControl::Attributes::ColorLoopStartEnhancedHue::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorLoopStartEnhancedHue", 1, value);
        }
        case ColorControl::Attributes::ColorLoopStoredEnhancedHue::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorLoopStoredEnhancedHue", 1, value);
        }
        case ColorControl::Attributes::ColorCapabilities::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorCapabilities", 1, value);
        }
        case ColorControl::Attributes::ColorTempPhysicalMinMireds::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorTempPhysicalMinMireds", 1, value);
        }
        case ColorControl::Attributes::ColorTempPhysicalMaxMireds::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ColorTempPhysicalMaxMireds", 1, value);
        }
        case ColorControl::Attributes::CoupleColorTempToLevelMinMireds::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CoupleColorTempToLevelMinMireds", 1, value);
        }
        case ColorControl::Attributes::StartUpColorTemperatureMireds::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StartUpColorTemperatureMireds", 1, value);
        }
        case ColorControl::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case ColorControl::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case ColorControl::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case ColorControl::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case ColorControl::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case BallastConfiguration::Id: {
        switch (path.mAttributeId)
        {
        case BallastConfiguration::Attributes::PhysicalMinLevel::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PhysicalMinLevel", 1, value);
        }
        case BallastConfiguration::Attributes::PhysicalMaxLevel::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PhysicalMaxLevel", 1, value);
        }
        case BallastConfiguration::Attributes::BallastStatus::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BallastStatus", 1, value);
        }
        case BallastConfiguration::Attributes::MinLevel::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinLevel", 1, value);
        }
        case BallastConfiguration::Attributes::MaxLevel::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxLevel", 1, value);
        }
        case BallastConfiguration::Attributes::IntrinsicBalanceFactor::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("IntrinsicBalanceFactor", 1, value);
        }
        case BallastConfiguration::Attributes::BallastFactorAdjustment::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BallastFactorAdjustment", 1, value);
        }
        case BallastConfiguration::Attributes::LampQuantity::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LampQuantity", 1, value);
        }
        case BallastConfiguration::Attributes::LampType::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LampType", 1, value);
        }
        case BallastConfiguration::Attributes::LampManufacturer::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LampManufacturer", 1, value);
        }
        case BallastConfiguration::Attributes::LampRatedHours::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LampRatedHours", 1, value);
        }
        case BallastConfiguration::Attributes::LampBurnHours::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LampBurnHours", 1, value);
        }
        case BallastConfiguration::Attributes::LampAlarmMode::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LampAlarmMode", 1, value);
        }
        case BallastConfiguration::Attributes::LampBurnHoursTripPoint::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LampBurnHoursTripPoint", 1, value);
        }
        case BallastConfiguration::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case BallastConfiguration::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case BallastConfiguration::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case BallastConfiguration::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case BallastConfiguration::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case IlluminanceMeasurement::Id: {
        switch (path.mAttributeId)
        {
        case IlluminanceMeasurement::Attributes::MeasuredValue::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MeasuredValue", 1, value);
        }
        case IlluminanceMeasurement::Attributes::MinMeasuredValue::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinMeasuredValue", 1, value);
        }
        case IlluminanceMeasurement::Attributes::MaxMeasuredValue::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxMeasuredValue", 1, value);
        }
        case IlluminanceMeasurement::Attributes::Tolerance::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Tolerance", 1, value);
        }
        case IlluminanceMeasurement::Attributes::LightSensorType::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LightSensorType", 1, value);
        }
        case IlluminanceMeasurement::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case IlluminanceMeasurement::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case IlluminanceMeasurement::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case IlluminanceMeasurement::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case IlluminanceMeasurement::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case TemperatureMeasurement::Id: {
        switch (path.mAttributeId)
        {
        case TemperatureMeasurement::Attributes::MeasuredValue::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MeasuredValue", 1, value);
        }
        case TemperatureMeasurement::Attributes::MinMeasuredValue::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinMeasuredValue", 1, value);
        }
        case TemperatureMeasurement::Attributes::MaxMeasuredValue::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxMeasuredValue", 1, value);
        }
        case TemperatureMeasurement::Attributes::Tolerance::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Tolerance", 1, value);
        }
        case TemperatureMeasurement::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case TemperatureMeasurement::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case TemperatureMeasurement::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case TemperatureMeasurement::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case TemperatureMeasurement::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case PressureMeasurement::Id: {
        switch (path.mAttributeId)
        {
        case PressureMeasurement::Attributes::MeasuredValue::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MeasuredValue", 1, value);
        }
        case PressureMeasurement::Attributes::MinMeasuredValue::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinMeasuredValue", 1, value);
        }
        case PressureMeasurement::Attributes::MaxMeasuredValue::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxMeasuredValue", 1, value);
        }
        case PressureMeasurement::Attributes::Tolerance::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Tolerance", 1, value);
        }
        case PressureMeasurement::Attributes::ScaledValue::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ScaledValue", 1, value);
        }
        case PressureMeasurement::Attributes::MinScaledValue::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinScaledValue", 1, value);
        }
        case PressureMeasurement::Attributes::MaxScaledValue::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxScaledValue", 1, value);
        }
        case PressureMeasurement::Attributes::ScaledTolerance::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ScaledTolerance", 1, value);
        }
        case PressureMeasurement::Attributes::Scale::Id: {
            int8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Scale", 1, value);
        }
        case PressureMeasurement::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case PressureMeasurement::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case PressureMeasurement::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case PressureMeasurement::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case PressureMeasurement::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case FlowMeasurement::Id: {
        switch (path.mAttributeId)
        {
        case FlowMeasurement::Attributes::MeasuredValue::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MeasuredValue", 1, value);
        }
        case FlowMeasurement::Attributes::MinMeasuredValue::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MinMeasuredValue", 1, value);
        }
        case FlowMeasurement::Attributes::MaxMeasuredValue::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MaxMeasuredValue", 1, value);
        }
        case FlowMeasurement::Attributes::Tolerance::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Tolerance", 1, value);
        }
        case FlowMeasurement::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case FlowMeasurement::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case FlowMeasurement::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case FlowMeasurement::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case FlowMeasurement::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case RelativeHumidityMeasurement::Id: {
        switch (path.mAttributeId)
        {
        case RelativeHumidityMeasurement::Attributes::MeasuredValue::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured value", 1, value);
        }
        case RelativeHumidityMeasurement::Attributes::MinMeasuredValue::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("min measured value", 1, value);
        }
        case RelativeHumidityMeasurement::Attributes::MaxMeasuredValue::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("max measured value", 1, value);
        }
        case RelativeHumidityMeasurement::Attributes::Tolerance::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("tolerance", 1, value);
        }
        case RelativeHumidityMeasurement::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case RelativeHumidityMeasurement::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case RelativeHumidityMeasurement::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case RelativeHumidityMeasurement::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case RelativeHumidityMeasurement::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case OccupancySensing::Id: {
        switch (path.mAttributeId)
        {
        case OccupancySensing::Attributes::Occupancy::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("occupancy", 1, value);
        }
        case OccupancySensing::Attributes::OccupancySensorType::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("occupancy sensor type", 1, value);
        }
        case OccupancySensing::Attributes::OccupancySensorTypeBitmap::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("occupancy sensor type bitmap", 1, value);
        }
        case OccupancySensing::Attributes::PirOccupiedToUnoccupiedDelay::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PIR occupied to unoccupied delay", 1, value);
        }
        case OccupancySensing::Attributes::PirUnoccupiedToOccupiedDelay::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PIR unoccupied to occupied delay", 1, value);
        }
        case OccupancySensing::Attributes::PirUnoccupiedToOccupiedThreshold::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PIR unoccupied to occupied threshold", 1, value);
        }
        case OccupancySensing::Attributes::UltrasonicOccupiedToUnoccupiedDelay::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ultrasonic occupied to unoccupied delay", 1, value);
        }
        case OccupancySensing::Attributes::UltrasonicUnoccupiedToOccupiedDelay::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ultrasonic unoccupied to occupied delay", 1, value);
        }
        case OccupancySensing::Attributes::UltrasonicUnoccupiedToOccupiedThreshold::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ultrasonic unoccupied to occupied threshold", 1, value);
        }
        case OccupancySensing::Attributes::PhysicalContactOccupiedToUnoccupiedDelay::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("physical contact occupied to unoccupied delay", 1, value);
        }
        case OccupancySensing::Attributes::PhysicalContactUnoccupiedToOccupiedDelay::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("physical contact unoccupied to occupied delay", 1, value);
        }
        case OccupancySensing::Attributes::PhysicalContactUnoccupiedToOccupiedThreshold::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("physical contact unoccupied to occupied threshold", 1, value);
        }
        case OccupancySensing::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case OccupancySensing::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case OccupancySensing::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case OccupancySensing::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case OccupancySensing::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case WakeOnLan::Id: {
        switch (path.mAttributeId)
        {
        case WakeOnLan::Attributes::MACAddress::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MACAddress", 1, value);
        }
        case WakeOnLan::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case WakeOnLan::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case WakeOnLan::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case WakeOnLan::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case WakeOnLan::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case Channel::Id: {
        switch (path.mAttributeId)
        {
        case Channel::Attributes::ChannelList::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::Channel::Structs::ChannelInfo::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ChannelList", 1, value);
        }
        case Channel::Attributes::Lineup::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::Channel::Structs::LineupInfo::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Lineup", 1, value);
        }
        case Channel::Attributes::CurrentChannel::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::Channel::Structs::ChannelInfo::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentChannel", 1, value);
        }
        case Channel::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case Channel::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case Channel::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case Channel::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case Channel::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case TargetNavigator::Id: {
        switch (path.mAttributeId)
        {
        case TargetNavigator::Attributes::TargetList::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::TargetNavigator::Structs::TargetInfo::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TargetList", 1, value);
        }
        case TargetNavigator::Attributes::CurrentTarget::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentTarget", 1, value);
        }
        case TargetNavigator::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case TargetNavigator::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case TargetNavigator::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case TargetNavigator::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case TargetNavigator::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case MediaPlayback::Id: {
        switch (path.mAttributeId)
        {
        case MediaPlayback::Attributes::CurrentState::Id: {
            chip::app::Clusters::MediaPlayback::PlaybackStateEnum value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentState", 1, value);
        }
        case MediaPlayback::Attributes::StartTime::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StartTime", 1, value);
        }
        case MediaPlayback::Attributes::Duration::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Duration", 1, value);
        }
        case MediaPlayback::Attributes::SampledPosition::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::MediaPlayback::Structs::PlaybackPosition::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SampledPosition", 1, value);
        }
        case MediaPlayback::Attributes::PlaybackSpeed::Id: {
            float value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PlaybackSpeed", 1, value);
        }
        case MediaPlayback::Attributes::SeekRangeEnd::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SeekRangeEnd", 1, value);
        }
        case MediaPlayback::Attributes::SeekRangeStart::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SeekRangeStart", 1, value);
        }
        case MediaPlayback::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case MediaPlayback::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case MediaPlayback::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case MediaPlayback::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case MediaPlayback::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case MediaInput::Id: {
        switch (path.mAttributeId)
        {
        case MediaInput::Attributes::InputList::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::MediaInput::Structs::InputInfo::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("InputList", 1, value);
        }
        case MediaInput::Attributes::CurrentInput::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentInput", 1, value);
        }
        case MediaInput::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case MediaInput::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case MediaInput::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case MediaInput::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case MediaInput::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case LowPower::Id: {
        switch (path.mAttributeId)
        {
        case LowPower::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case LowPower::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case LowPower::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case LowPower::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case LowPower::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case KeypadInput::Id: {
        switch (path.mAttributeId)
        {
        case KeypadInput::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case KeypadInput::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case KeypadInput::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case KeypadInput::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case KeypadInput::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case ContentLauncher::Id: {
        switch (path.mAttributeId)
        {
        case ContentLauncher::Attributes::AcceptHeader::Id: {
            chip::app::DataModel::DecodableList<chip::CharSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptHeader", 1, value);
        }
        case ContentLauncher::Attributes::SupportedStreamingProtocols::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SupportedStreamingProtocols", 1, value);
        }
        case ContentLauncher::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case ContentLauncher::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case ContentLauncher::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case ContentLauncher::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case ContentLauncher::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case AudioOutput::Id: {
        switch (path.mAttributeId)
        {
        case AudioOutput::Attributes::OutputList::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::AudioOutput::Structs::OutputInfo::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("OutputList", 1, value);
        }
        case AudioOutput::Attributes::CurrentOutput::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentOutput", 1, value);
        }
        case AudioOutput::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case AudioOutput::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case AudioOutput::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case AudioOutput::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case AudioOutput::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case ApplicationLauncher::Id: {
        switch (path.mAttributeId)
        {
        case ApplicationLauncher::Attributes::CatalogList::Id: {
            chip::app::DataModel::DecodableList<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CatalogList", 1, value);
        }
        case ApplicationLauncher::Attributes::CurrentApp::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::ApplicationLauncher::Structs::ApplicationEP::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CurrentApp", 1, value);
        }
        case ApplicationLauncher::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case ApplicationLauncher::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case ApplicationLauncher::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case ApplicationLauncher::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case ApplicationLauncher::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case ApplicationBasic::Id: {
        switch (path.mAttributeId)
        {
        case ApplicationBasic::Attributes::VendorName::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("VendorName", 1, value);
        }
        case ApplicationBasic::Attributes::VendorID::Id: {
            chip::VendorId value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("VendorID", 1, value);
        }
        case ApplicationBasic::Attributes::ApplicationName::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ApplicationName", 1, value);
        }
        case ApplicationBasic::Attributes::ProductID::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ProductID", 1, value);
        }
        case ApplicationBasic::Attributes::Application::Id: {
            chip::app::Clusters::ApplicationBasic::Structs::ApplicationBasicApplication::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Application", 1, value);
        }
        case ApplicationBasic::Attributes::Status::Id: {
            chip::app::Clusters::ApplicationBasic::ApplicationStatusEnum value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Status", 1, value);
        }
        case ApplicationBasic::Attributes::ApplicationVersion::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ApplicationVersion", 1, value);
        }
        case ApplicationBasic::Attributes::AllowedVendorList::Id: {
            chip::app::DataModel::DecodableList<chip::VendorId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AllowedVendorList", 1, value);
        }
        case ApplicationBasic::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case ApplicationBasic::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case ApplicationBasic::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case ApplicationBasic::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case ApplicationBasic::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case AccountLogin::Id: {
        switch (path.mAttributeId)
        {
        case AccountLogin::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case AccountLogin::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case AccountLogin::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case AccountLogin::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case AccountLogin::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case ElectricalMeasurement::Id: {
        switch (path.mAttributeId)
        {
        case ElectricalMeasurement::Attributes::MeasurementType::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measurement type", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcVoltage::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc voltage", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcVoltageMin::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc voltage min", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcVoltageMax::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc voltage max", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc current", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcCurrentMin::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc current min", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcCurrentMax::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc current max", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcPower::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc power", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcPowerMin::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc power min", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcPowerMax::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc power max", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcVoltageMultiplier::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc voltage multiplier", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcVoltageDivisor::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc voltage divisor", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcCurrentMultiplier::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc current multiplier", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcCurrentDivisor::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc current divisor", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcPowerMultiplier::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc power multiplier", 1, value);
        }
        case ElectricalMeasurement::Attributes::DcPowerDivisor::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("dc power divisor", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcFrequency::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac frequency", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcFrequencyMin::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac frequency min", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcFrequencyMax::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac frequency max", 1, value);
        }
        case ElectricalMeasurement::Attributes::NeutralCurrent::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("neutral current", 1, value);
        }
        case ElectricalMeasurement::Attributes::TotalActivePower::Id: {
            int32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("total active power", 1, value);
        }
        case ElectricalMeasurement::Attributes::TotalReactivePower::Id: {
            int32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("total reactive power", 1, value);
        }
        case ElectricalMeasurement::Attributes::TotalApparentPower::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("total apparent power", 1, value);
        }
        case ElectricalMeasurement::Attributes::Measured1stHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured 1st harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::Measured3rdHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured 3rd harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::Measured5thHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured 5th harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::Measured7thHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured 7th harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::Measured9thHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured 9th harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::Measured11thHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured 11th harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::MeasuredPhase1stHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured phase 1st harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::MeasuredPhase3rdHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured phase 3rd harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::MeasuredPhase5thHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured phase 5th harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::MeasuredPhase7thHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured phase 7th harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::MeasuredPhase9thHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured phase 9th harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::MeasuredPhase11thHarmonicCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("measured phase 11th harmonic current", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcFrequencyMultiplier::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac frequency multiplier", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcFrequencyDivisor::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac frequency divisor", 1, value);
        }
        case ElectricalMeasurement::Attributes::PowerMultiplier::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("power multiplier", 1, value);
        }
        case ElectricalMeasurement::Attributes::PowerDivisor::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("power divisor", 1, value);
        }
        case ElectricalMeasurement::Attributes::HarmonicCurrentMultiplier::Id: {
            int8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("harmonic current multiplier", 1, value);
        }
        case ElectricalMeasurement::Attributes::PhaseHarmonicCurrentMultiplier::Id: {
            int8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("phase harmonic current multiplier", 1, value);
        }
        case ElectricalMeasurement::Attributes::InstantaneousVoltage::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("instantaneous voltage", 1, value);
        }
        case ElectricalMeasurement::Attributes::InstantaneousLineCurrent::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("instantaneous line current", 1, value);
        }
        case ElectricalMeasurement::Attributes::InstantaneousActiveCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("instantaneous active current", 1, value);
        }
        case ElectricalMeasurement::Attributes::InstantaneousReactiveCurrent::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("instantaneous reactive current", 1, value);
        }
        case ElectricalMeasurement::Attributes::InstantaneousPower::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("instantaneous power", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltage::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageMin::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage min", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageMax::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage max", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsCurrent::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms current", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsCurrentMin::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms current min", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsCurrentMax::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms current max", 1, value);
        }
        case ElectricalMeasurement::Attributes::ActivePower::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active power", 1, value);
        }
        case ElectricalMeasurement::Attributes::ActivePowerMin::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active power min", 1, value);
        }
        case ElectricalMeasurement::Attributes::ActivePowerMax::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active power max", 1, value);
        }
        case ElectricalMeasurement::Attributes::ReactivePower::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("reactive power", 1, value);
        }
        case ElectricalMeasurement::Attributes::ApparentPower::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("apparent power", 1, value);
        }
        case ElectricalMeasurement::Attributes::PowerFactor::Id: {
            int8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("power factor", 1, value);
        }
        case ElectricalMeasurement::Attributes::AverageRmsVoltageMeasurementPeriod::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("average rms voltage measurement period", 1, value);
        }
        case ElectricalMeasurement::Attributes::AverageRmsUnderVoltageCounter::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("average rms under voltage counter", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsExtremeOverVoltagePeriod::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms extreme over voltage period", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsExtremeUnderVoltagePeriod::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms extreme under voltage period", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageSagPeriod::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage sag period", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageSwellPeriod::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage swell period", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcVoltageMultiplier::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac voltage multiplier", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcVoltageDivisor::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac voltage divisor", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcCurrentMultiplier::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac current multiplier", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcCurrentDivisor::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac current divisor", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcPowerMultiplier::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac power multiplier", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcPowerDivisor::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac power divisor", 1, value);
        }
        case ElectricalMeasurement::Attributes::OverloadAlarmsMask::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("overload alarms mask", 1, value);
        }
        case ElectricalMeasurement::Attributes::VoltageOverload::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("voltage overload", 1, value);
        }
        case ElectricalMeasurement::Attributes::CurrentOverload::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("current overload", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcOverloadAlarmsMask::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac overload alarms mask", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcVoltageOverload::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac voltage overload", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcCurrentOverload::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac current overload", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcActivePowerOverload::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac active power overload", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcReactivePowerOverload::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ac reactive power overload", 1, value);
        }
        case ElectricalMeasurement::Attributes::AverageRmsOverVoltage::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("average rms over voltage", 1, value);
        }
        case ElectricalMeasurement::Attributes::AverageRmsUnderVoltage::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("average rms under voltage", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsExtremeOverVoltage::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms extreme over voltage", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsExtremeUnderVoltage::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms extreme under voltage", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageSag::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage sag", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageSwell::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage swell", 1, value);
        }
        case ElectricalMeasurement::Attributes::LineCurrentPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("line current phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::ActiveCurrentPhaseB::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active current phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::ReactiveCurrentPhaseB::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("reactive current phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltagePhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageMinPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage min phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageMaxPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage max phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsCurrentPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms current phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsCurrentMinPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms current min phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsCurrentMaxPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms current max phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::ActivePowerPhaseB::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active power phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::ActivePowerMinPhaseB::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active power min phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::ActivePowerMaxPhaseB::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active power max phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::ReactivePowerPhaseB::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("reactive power phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::ApparentPowerPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("apparent power phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::PowerFactorPhaseB::Id: {
            int8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("power factor phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::AverageRmsVoltageMeasurementPeriodPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("average rms voltage measurement period phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::AverageRmsOverVoltageCounterPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("average rms over voltage counter phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::AverageRmsUnderVoltageCounterPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("average rms under voltage counter phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsExtremeOverVoltagePeriodPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms extreme over voltage period phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsExtremeUnderVoltagePeriodPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms extreme under voltage period phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageSagPeriodPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage sag period phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageSwellPeriodPhaseB::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage swell period phase b", 1, value);
        }
        case ElectricalMeasurement::Attributes::LineCurrentPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("line current phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::ActiveCurrentPhaseC::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active current phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::ReactiveCurrentPhaseC::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("reactive current phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltagePhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageMinPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage min phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageMaxPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage max phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsCurrentPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms current phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsCurrentMinPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms current min phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsCurrentMaxPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms current max phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::ActivePowerPhaseC::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active power phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::ActivePowerMinPhaseC::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active power min phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::ActivePowerMaxPhaseC::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("active power max phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::ReactivePowerPhaseC::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("reactive power phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::ApparentPowerPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("apparent power phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::PowerFactorPhaseC::Id: {
            int8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("power factor phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::AverageRmsVoltageMeasurementPeriodPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("average rms voltage measurement period phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::AverageRmsOverVoltageCounterPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("average rms over voltage counter phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::AverageRmsUnderVoltageCounterPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("average rms under voltage counter phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsExtremeOverVoltagePeriodPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms extreme over voltage period phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsExtremeUnderVoltagePeriodPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms extreme under voltage period phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageSagPeriodPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage sag period phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::RmsVoltageSwellPeriodPhaseC::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("rms voltage swell period phase c", 1, value);
        }
        case ElectricalMeasurement::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case ElectricalMeasurement::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case ElectricalMeasurement::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case ElectricalMeasurement::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case ElectricalMeasurement::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    case TestCluster::Id: {
        switch (path.mAttributeId)
        {
        case TestCluster::Attributes::Boolean::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("boolean", 1, value);
        }
        case TestCluster::Attributes::Bitmap8::Id: {
            chip::BitMask<chip::app::Clusters::TestCluster::Bitmap8MaskMap> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("bitmap8", 1, value);
        }
        case TestCluster::Attributes::Bitmap16::Id: {
            chip::BitMask<chip::app::Clusters::TestCluster::Bitmap16MaskMap> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("bitmap16", 1, value);
        }
        case TestCluster::Attributes::Bitmap32::Id: {
            chip::BitMask<chip::app::Clusters::TestCluster::Bitmap32MaskMap> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("bitmap32", 1, value);
        }
        case TestCluster::Attributes::Bitmap64::Id: {
            chip::BitMask<chip::app::Clusters::TestCluster::Bitmap64MaskMap> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("bitmap64", 1, value);
        }
        case TestCluster::Attributes::Int8u::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int8u", 1, value);
        }
        case TestCluster::Attributes::Int16u::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int16u", 1, value);
        }
        case TestCluster::Attributes::Int24u::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int24u", 1, value);
        }
        case TestCluster::Attributes::Int32u::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int32u", 1, value);
        }
        case TestCluster::Attributes::Int40u::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int40u", 1, value);
        }
        case TestCluster::Attributes::Int48u::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int48u", 1, value);
        }
        case TestCluster::Attributes::Int56u::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int56u", 1, value);
        }
        case TestCluster::Attributes::Int64u::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int64u", 1, value);
        }
        case TestCluster::Attributes::Int8s::Id: {
            int8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int8s", 1, value);
        }
        case TestCluster::Attributes::Int16s::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int16s", 1, value);
        }
        case TestCluster::Attributes::Int24s::Id: {
            int32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int24s", 1, value);
        }
        case TestCluster::Attributes::Int32s::Id: {
            int32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int32s", 1, value);
        }
        case TestCluster::Attributes::Int40s::Id: {
            int64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int40s", 1, value);
        }
        case TestCluster::Attributes::Int48s::Id: {
            int64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int48s", 1, value);
        }
        case TestCluster::Attributes::Int56s::Id: {
            int64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int56s", 1, value);
        }
        case TestCluster::Attributes::Int64s::Id: {
            int64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("int64s", 1, value);
        }
        case TestCluster::Attributes::Enum8::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("enum8", 1, value);
        }
        case TestCluster::Attributes::Enum16::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("enum16", 1, value);
        }
        case TestCluster::Attributes::FloatSingle::Id: {
            float value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("float_single", 1, value);
        }
        case TestCluster::Attributes::FloatDouble::Id: {
            double value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("float_double", 1, value);
        }
        case TestCluster::Attributes::OctetString::Id: {
            chip::ByteSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("octet_string", 1, value);
        }
        case TestCluster::Attributes::ListInt8u::Id: {
            chip::app::DataModel::DecodableList<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("list_int8u", 1, value);
        }
        case TestCluster::Attributes::ListOctetString::Id: {
            chip::app::DataModel::DecodableList<chip::ByteSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("list_octet_string", 1, value);
        }
        case TestCluster::Attributes::ListStructOctetString::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::TestCluster::Structs::TestListStructOctet::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("list_struct_octet_string", 1, value);
        }
        case TestCluster::Attributes::LongOctetString::Id: {
            chip::ByteSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("long_octet_string", 1, value);
        }
        case TestCluster::Attributes::CharString::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("char_string", 1, value);
        }
        case TestCluster::Attributes::LongCharString::Id: {
            chip::CharSpan value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("long_char_string", 1, value);
        }
        case TestCluster::Attributes::EpochUs::Id: {
            uint64_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("epoch_us", 1, value);
        }
        case TestCluster::Attributes::EpochS::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("epoch_s", 1, value);
        }
        case TestCluster::Attributes::VendorId::Id: {
            chip::VendorId value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("vendor_id", 1, value);
        }
        case TestCluster::Attributes::ListNullablesAndOptionalsStruct::Id: {
            chip::app::DataModel::DecodableList<
                chip::app::Clusters::TestCluster::Structs::NullablesAndOptionalsStruct::DecodableType>
                value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("list_nullables_and_optionals_struct", 1, value);
        }
        case TestCluster::Attributes::EnumAttr::Id: {
            chip::app::Clusters::TestCluster::SimpleEnum value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("enum_attr", 1, value);
        }
        case TestCluster::Attributes::StructAttr::Id: {
            chip::app::Clusters::TestCluster::Structs::SimpleStruct::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("struct_attr", 1, value);
        }
        case TestCluster::Attributes::RangeRestrictedInt8u::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("range_restricted_int8u", 1, value);
        }
        case TestCluster::Attributes::RangeRestrictedInt8s::Id: {
            int8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("range_restricted_int8s", 1, value);
        }
        case TestCluster::Attributes::RangeRestrictedInt16u::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("range_restricted_int16u", 1, value);
        }
        case TestCluster::Attributes::RangeRestrictedInt16s::Id: {
            int16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("range_restricted_int16s", 1, value);
        }
        case TestCluster::Attributes::ListLongOctetString::Id: {
            chip::app::DataModel::DecodableList<chip::ByteSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("list_long_octet_string", 1, value);
        }
        case TestCluster::Attributes::ListFabricScoped::Id: {
            chip::app::DataModel::DecodableList<chip::app::Clusters::TestCluster::Structs::TestFabricScoped::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("list_fabric_scoped", 1, value);
        }
        case TestCluster::Attributes::TimedWriteBoolean::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("timed_write_boolean", 1, value);
        }
        case TestCluster::Attributes::GeneralErrorBoolean::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("general_error_boolean", 1, value);
        }
        case TestCluster::Attributes::ClusterErrorBoolean::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("cluster_error_boolean", 1, value);
        }
        case TestCluster::Attributes::Unsupported::Id: {
            bool value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("unsupported", 1, value);
        }
        case TestCluster::Attributes::NullableBoolean::Id: {
            chip::app::DataModel::Nullable<bool> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_boolean", 1, value);
        }
        case TestCluster::Attributes::NullableBitmap8::Id: {
            chip::app::DataModel::Nullable<chip::BitMask<chip::app::Clusters::TestCluster::Bitmap8MaskMap>> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_bitmap8", 1, value);
        }
        case TestCluster::Attributes::NullableBitmap16::Id: {
            chip::app::DataModel::Nullable<chip::BitMask<chip::app::Clusters::TestCluster::Bitmap16MaskMap>> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_bitmap16", 1, value);
        }
        case TestCluster::Attributes::NullableBitmap32::Id: {
            chip::app::DataModel::Nullable<chip::BitMask<chip::app::Clusters::TestCluster::Bitmap32MaskMap>> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_bitmap32", 1, value);
        }
        case TestCluster::Attributes::NullableBitmap64::Id: {
            chip::app::DataModel::Nullable<chip::BitMask<chip::app::Clusters::TestCluster::Bitmap64MaskMap>> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_bitmap64", 1, value);
        }
        case TestCluster::Attributes::NullableInt8u::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int8u", 1, value);
        }
        case TestCluster::Attributes::NullableInt16u::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int16u", 1, value);
        }
        case TestCluster::Attributes::NullableInt24u::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int24u", 1, value);
        }
        case TestCluster::Attributes::NullableInt32u::Id: {
            chip::app::DataModel::Nullable<uint32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int32u", 1, value);
        }
        case TestCluster::Attributes::NullableInt40u::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int40u", 1, value);
        }
        case TestCluster::Attributes::NullableInt48u::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int48u", 1, value);
        }
        case TestCluster::Attributes::NullableInt56u::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int56u", 1, value);
        }
        case TestCluster::Attributes::NullableInt64u::Id: {
            chip::app::DataModel::Nullable<uint64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int64u", 1, value);
        }
        case TestCluster::Attributes::NullableInt8s::Id: {
            chip::app::DataModel::Nullable<int8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int8s", 1, value);
        }
        case TestCluster::Attributes::NullableInt16s::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int16s", 1, value);
        }
        case TestCluster::Attributes::NullableInt24s::Id: {
            chip::app::DataModel::Nullable<int32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int24s", 1, value);
        }
        case TestCluster::Attributes::NullableInt32s::Id: {
            chip::app::DataModel::Nullable<int32_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int32s", 1, value);
        }
        case TestCluster::Attributes::NullableInt40s::Id: {
            chip::app::DataModel::Nullable<int64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int40s", 1, value);
        }
        case TestCluster::Attributes::NullableInt48s::Id: {
            chip::app::DataModel::Nullable<int64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int48s", 1, value);
        }
        case TestCluster::Attributes::NullableInt56s::Id: {
            chip::app::DataModel::Nullable<int64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int56s", 1, value);
        }
        case TestCluster::Attributes::NullableInt64s::Id: {
            chip::app::DataModel::Nullable<int64_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_int64s", 1, value);
        }
        case TestCluster::Attributes::NullableEnum8::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_enum8", 1, value);
        }
        case TestCluster::Attributes::NullableEnum16::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_enum16", 1, value);
        }
        case TestCluster::Attributes::NullableFloatSingle::Id: {
            chip::app::DataModel::Nullable<float> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_float_single", 1, value);
        }
        case TestCluster::Attributes::NullableFloatDouble::Id: {
            chip::app::DataModel::Nullable<double> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_float_double", 1, value);
        }
        case TestCluster::Attributes::NullableOctetString::Id: {
            chip::app::DataModel::Nullable<chip::ByteSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_octet_string", 1, value);
        }
        case TestCluster::Attributes::NullableCharString::Id: {
            chip::app::DataModel::Nullable<chip::CharSpan> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_char_string", 1, value);
        }
        case TestCluster::Attributes::NullableEnumAttr::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::TestCluster::SimpleEnum> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_enum_attr", 1, value);
        }
        case TestCluster::Attributes::NullableStruct::Id: {
            chip::app::DataModel::Nullable<chip::app::Clusters::TestCluster::Structs::SimpleStruct::DecodableType> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_struct", 1, value);
        }
        case TestCluster::Attributes::NullableRangeRestrictedInt8u::Id: {
            chip::app::DataModel::Nullable<uint8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_range_restricted_int8u", 1, value);
        }
        case TestCluster::Attributes::NullableRangeRestrictedInt8s::Id: {
            chip::app::DataModel::Nullable<int8_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_range_restricted_int8s", 1, value);
        }
        case TestCluster::Attributes::NullableRangeRestrictedInt16u::Id: {
            chip::app::DataModel::Nullable<uint16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_range_restricted_int16u", 1, value);
        }
        case TestCluster::Attributes::NullableRangeRestrictedInt16s::Id: {
            chip::app::DataModel::Nullable<int16_t> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("nullable_range_restricted_int16s", 1, value);
        }
        case TestCluster::Attributes::WriteOnlyInt8u::Id: {
            uint8_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("write_only_int8u", 1, value);
        }
        case TestCluster::Attributes::GeneratedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneratedCommandList", 1, value);
        }
        case TestCluster::Attributes::AcceptedCommandList::Id: {
            chip::app::DataModel::DecodableList<chip::CommandId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AcceptedCommandList", 1, value);
        }
        case TestCluster::Attributes::AttributeList::Id: {
            chip::app::DataModel::DecodableList<chip::AttributeId> value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttributeList", 1, value);
        }
        case TestCluster::Attributes::FeatureMap::Id: {
            uint32_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("FeatureMap", 1, value);
        }
        case TestCluster::Attributes::ClusterRevision::Id: {
            uint16_t value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ClusterRevision", 1, value);
        }
        }
        break;
    }
    default:
        break;
    }
    ChipLogProgress(chipTool, "  Don't know how to log atribute value");
    return CHIP_NO_ERROR;
}

CHIP_ERROR DataModelLogger::LogCommand(const chip::app::ConcreteCommandPath & path, chip::TLV::TLVReader * data)
{
    ChipLogProgress(chipTool, "Endpoint: %u Cluster: " ChipLogFormatMEI " Command " ChipLogFormatMEI, path.mEndpointId,
                    ChipLogValueMEI(path.mClusterId), ChipLogValueMEI(path.mCommandId));

    switch (path.mClusterId)
    {
    case Groups::Id: {
        switch (path.mCommandId)
        {
        case Groups::Commands::AddGroupResponse::Id: {
            Groups::Commands::AddGroupResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AddGroupResponse", 1, value);
        }
        case Groups::Commands::ViewGroupResponse::Id: {
            Groups::Commands::ViewGroupResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ViewGroupResponse", 1, value);
        }
        case Groups::Commands::GetGroupMembershipResponse::Id: {
            Groups::Commands::GetGroupMembershipResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GetGroupMembershipResponse", 1, value);
        }
        case Groups::Commands::RemoveGroupResponse::Id: {
            Groups::Commands::RemoveGroupResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RemoveGroupResponse", 1, value);
        }
        }
        break;
    }
    case Scenes::Id: {
        switch (path.mCommandId)
        {
        case Scenes::Commands::AddSceneResponse::Id: {
            Scenes::Commands::AddSceneResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AddSceneResponse", 1, value);
        }
        case Scenes::Commands::ViewSceneResponse::Id: {
            Scenes::Commands::ViewSceneResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ViewSceneResponse", 1, value);
        }
        case Scenes::Commands::RemoveSceneResponse::Id: {
            Scenes::Commands::RemoveSceneResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RemoveSceneResponse", 1, value);
        }
        case Scenes::Commands::RemoveAllScenesResponse::Id: {
            Scenes::Commands::RemoveAllScenesResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RemoveAllScenesResponse", 1, value);
        }
        case Scenes::Commands::StoreSceneResponse::Id: {
            Scenes::Commands::StoreSceneResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StoreSceneResponse", 1, value);
        }
        case Scenes::Commands::GetSceneMembershipResponse::Id: {
            Scenes::Commands::GetSceneMembershipResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GetSceneMembershipResponse", 1, value);
        }
        case Scenes::Commands::EnhancedAddSceneResponse::Id: {
            Scenes::Commands::EnhancedAddSceneResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EnhancedAddSceneResponse", 1, value);
        }
        case Scenes::Commands::EnhancedViewSceneResponse::Id: {
            Scenes::Commands::EnhancedViewSceneResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("EnhancedViewSceneResponse", 1, value);
        }
        case Scenes::Commands::CopySceneResponse::Id: {
            Scenes::Commands::CopySceneResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CopySceneResponse", 1, value);
        }
        }
        break;
    }
    case OtaSoftwareUpdateProvider::Id: {
        switch (path.mCommandId)
        {
        case OtaSoftwareUpdateProvider::Commands::QueryImageResponse::Id: {
            OtaSoftwareUpdateProvider::Commands::QueryImageResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("QueryImageResponse", 1, value);
        }
        case OtaSoftwareUpdateProvider::Commands::ApplyUpdateResponse::Id: {
            OtaSoftwareUpdateProvider::Commands::ApplyUpdateResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ApplyUpdateResponse", 1, value);
        }
        }
        break;
    }
    case GeneralCommissioning::Id: {
        switch (path.mCommandId)
        {
        case GeneralCommissioning::Commands::ArmFailSafeResponse::Id: {
            GeneralCommissioning::Commands::ArmFailSafeResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ArmFailSafeResponse", 1, value);
        }
        case GeneralCommissioning::Commands::SetRegulatoryConfigResponse::Id: {
            GeneralCommissioning::Commands::SetRegulatoryConfigResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SetRegulatoryConfigResponse", 1, value);
        }
        case GeneralCommissioning::Commands::CommissioningCompleteResponse::Id: {
            GeneralCommissioning::Commands::CommissioningCompleteResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CommissioningCompleteResponse", 1, value);
        }
        }
        break;
    }
    case NetworkCommissioning::Id: {
        switch (path.mCommandId)
        {
        case NetworkCommissioning::Commands::ScanNetworksResponse::Id: {
            NetworkCommissioning::Commands::ScanNetworksResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ScanNetworksResponse", 1, value);
        }
        case NetworkCommissioning::Commands::NetworkConfigResponse::Id: {
            NetworkCommissioning::Commands::NetworkConfigResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NetworkConfigResponse", 1, value);
        }
        case NetworkCommissioning::Commands::ConnectNetworkResponse::Id: {
            NetworkCommissioning::Commands::ConnectNetworkResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ConnectNetworkResponse", 1, value);
        }
        }
        break;
    }
    case DiagnosticLogs::Id: {
        switch (path.mCommandId)
        {
        case DiagnosticLogs::Commands::RetrieveLogsResponse::Id: {
            DiagnosticLogs::Commands::RetrieveLogsResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RetrieveLogsResponse", 1, value);
        }
        }
        break;
    }
    case OperationalCredentials::Id: {
        switch (path.mCommandId)
        {
        case OperationalCredentials::Commands::AttestationResponse::Id: {
            OperationalCredentials::Commands::AttestationResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AttestationResponse", 1, value);
        }
        case OperationalCredentials::Commands::CertificateChainResponse::Id: {
            OperationalCredentials::Commands::CertificateChainResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CertificateChainResponse", 1, value);
        }
        case OperationalCredentials::Commands::CSRResponse::Id: {
            OperationalCredentials::Commands::CSRResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("CSRResponse", 1, value);
        }
        case OperationalCredentials::Commands::NOCResponse::Id: {
            OperationalCredentials::Commands::NOCResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NOCResponse", 1, value);
        }
        }
        break;
    }
    case GroupKeyManagement::Id: {
        switch (path.mCommandId)
        {
        case GroupKeyManagement::Commands::KeySetReadResponse::Id: {
            GroupKeyManagement::Commands::KeySetReadResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("KeySetReadResponse", 1, value);
        }
        case GroupKeyManagement::Commands::KeySetReadAllIndicesResponse::Id: {
            GroupKeyManagement::Commands::KeySetReadAllIndicesResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("KeySetReadAllIndicesResponse", 1, value);
        }
        }
        break;
    }
    case DoorLock::Id: {
        switch (path.mCommandId)
        {
        case DoorLock::Commands::GetWeekDayScheduleResponse::Id: {
            DoorLock::Commands::GetWeekDayScheduleResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GetWeekDayScheduleResponse", 1, value);
        }
        case DoorLock::Commands::GetYearDayScheduleResponse::Id: {
            DoorLock::Commands::GetYearDayScheduleResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GetYearDayScheduleResponse", 1, value);
        }
        case DoorLock::Commands::GetHolidayScheduleResponse::Id: {
            DoorLock::Commands::GetHolidayScheduleResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GetHolidayScheduleResponse", 1, value);
        }
        case DoorLock::Commands::GetUserResponse::Id: {
            DoorLock::Commands::GetUserResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GetUserResponse", 1, value);
        }
        case DoorLock::Commands::SetCredentialResponse::Id: {
            DoorLock::Commands::SetCredentialResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SetCredentialResponse", 1, value);
        }
        case DoorLock::Commands::GetCredentialStatusResponse::Id: {
            DoorLock::Commands::GetCredentialStatusResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GetCredentialStatusResponse", 1, value);
        }
        }
        break;
    }
    case Thermostat::Id: {
        switch (path.mCommandId)
        {
        case Thermostat::Commands::GetWeeklyScheduleResponse::Id: {
            Thermostat::Commands::GetWeeklyScheduleResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GetWeeklyScheduleResponse", 1, value);
        }
        }
        break;
    }
    case Channel::Id: {
        switch (path.mCommandId)
        {
        case Channel::Commands::ChangeChannelResponse::Id: {
            Channel::Commands::ChangeChannelResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ChangeChannelResponse", 1, value);
        }
        }
        break;
    }
    case TargetNavigator::Id: {
        switch (path.mCommandId)
        {
        case TargetNavigator::Commands::NavigateTargetResponse::Id: {
            TargetNavigator::Commands::NavigateTargetResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NavigateTargetResponse", 1, value);
        }
        }
        break;
    }
    case MediaPlayback::Id: {
        switch (path.mCommandId)
        {
        case MediaPlayback::Commands::PlaybackResponse::Id: {
            MediaPlayback::Commands::PlaybackResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PlaybackResponse", 1, value);
        }
        }
        break;
    }
    case KeypadInput::Id: {
        switch (path.mCommandId)
        {
        case KeypadInput::Commands::SendKeyResponse::Id: {
            KeypadInput::Commands::SendKeyResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SendKeyResponse", 1, value);
        }
        }
        break;
    }
    case ContentLauncher::Id: {
        switch (path.mCommandId)
        {
        case ContentLauncher::Commands::LaunchResponse::Id: {
            ContentLauncher::Commands::LaunchResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LaunchResponse", 1, value);
        }
        }
        break;
    }
    case ApplicationLauncher::Id: {
        switch (path.mCommandId)
        {
        case ApplicationLauncher::Commands::LauncherResponse::Id: {
            ApplicationLauncher::Commands::LauncherResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LauncherResponse", 1, value);
        }
        }
        break;
    }
    case AccountLogin::Id: {
        switch (path.mCommandId)
        {
        case AccountLogin::Commands::GetSetupPINResponse::Id: {
            AccountLogin::Commands::GetSetupPINResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GetSetupPINResponse", 1, value);
        }
        }
        break;
    }
    case ElectricalMeasurement::Id: {
        switch (path.mCommandId)
        {
        case ElectricalMeasurement::Commands::GetProfileInfoResponseCommand::Id: {
            ElectricalMeasurement::Commands::GetProfileInfoResponseCommand::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GetProfileInfoResponseCommand", 1, value);
        }
        case ElectricalMeasurement::Commands::GetMeasurementProfileResponseCommand::Id: {
            ElectricalMeasurement::Commands::GetMeasurementProfileResponseCommand::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GetMeasurementProfileResponseCommand", 1, value);
        }
        }
        break;
    }
    case TestCluster::Id: {
        switch (path.mCommandId)
        {
        case TestCluster::Commands::TestSpecificResponse::Id: {
            TestCluster::Commands::TestSpecificResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestSpecificResponse", 1, value);
        }
        case TestCluster::Commands::TestAddArgumentsResponse::Id: {
            TestCluster::Commands::TestAddArgumentsResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestAddArgumentsResponse", 1, value);
        }
        case TestCluster::Commands::TestSimpleArgumentResponse::Id: {
            TestCluster::Commands::TestSimpleArgumentResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestSimpleArgumentResponse", 1, value);
        }
        case TestCluster::Commands::TestStructArrayArgumentResponse::Id: {
            TestCluster::Commands::TestStructArrayArgumentResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestStructArrayArgumentResponse", 1, value);
        }
        case TestCluster::Commands::TestListInt8UReverseResponse::Id: {
            TestCluster::Commands::TestListInt8UReverseResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestListInt8UReverseResponse", 1, value);
        }
        case TestCluster::Commands::TestEnumsResponse::Id: {
            TestCluster::Commands::TestEnumsResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestEnumsResponse", 1, value);
        }
        case TestCluster::Commands::TestNullableOptionalResponse::Id: {
            TestCluster::Commands::TestNullableOptionalResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestNullableOptionalResponse", 1, value);
        }
        case TestCluster::Commands::TestComplexNullableOptionalResponse::Id: {
            TestCluster::Commands::TestComplexNullableOptionalResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestComplexNullableOptionalResponse", 1, value);
        }
        case TestCluster::Commands::BooleanResponse::Id: {
            TestCluster::Commands::BooleanResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BooleanResponse", 1, value);
        }
        case TestCluster::Commands::SimpleStructResponse::Id: {
            TestCluster::Commands::SimpleStructResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SimpleStructResponse", 1, value);
        }
        case TestCluster::Commands::TestEmitTestEventResponse::Id: {
            TestCluster::Commands::TestEmitTestEventResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestEmitTestEventResponse", 1, value);
        }
        case TestCluster::Commands::TestEmitTestFabricScopedEventResponse::Id: {
            TestCluster::Commands::TestEmitTestFabricScopedEventResponse::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestEmitTestFabricScopedEventResponse", 1, value);
        }
        }
        break;
    }
    default:
        break;
    }
    ChipLogProgress(chipTool, "  Don't know how to log command response data");
    return CHIP_NO_ERROR;
}

CHIP_ERROR DataModelLogger::LogEvent(const chip::app::EventHeader & header, chip::TLV::TLVReader * data)
{
    ChipLogProgress(chipTool, "Endpoint: %u Cluster: " ChipLogFormatMEI " Event " ChipLogFormatMEI, header.mPath.mEndpointId,
                    ChipLogValueMEI(header.mPath.mClusterId), ChipLogValueMEI(header.mPath.mEventId));

    ChipLogProgress(chipTool, "  Event number: %" PRIu64, header.mEventNumber);

    if (header.mPriorityLevel == chip::app::PriorityLevel::Info)
    {
        ChipLogProgress(chipTool, "  Priority: Info");
    }
    else if (header.mPriorityLevel == chip::app::PriorityLevel::Critical)
    {
        ChipLogProgress(chipTool, "  Priority: Critical");
    }
    else if (header.mPriorityLevel == chip::app::PriorityLevel::Debug)
    {
        ChipLogProgress(chipTool, "  Priority: Debug");
    }
    else
    {
        ChipLogProgress(chipTool, "  Priority: Unknown");
    }

    ChipLogProgress(chipTool, "  Timestamp: %" PRIu64, header.mTimestamp.mValue);

    switch (header.mPath.mClusterId)
    {
    case AccessControl::Id: {
        switch (header.mPath.mEventId)
        {
        case AccessControl::Events::AccessControlEntryChanged::Id: {
            chip::app::Clusters::AccessControl::Events::AccessControlEntryChanged::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AccessControlEntryChanged", 1, value);
        }
        case AccessControl::Events::AccessControlExtensionChanged::Id: {
            chip::app::Clusters::AccessControl::Events::AccessControlExtensionChanged::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AccessControlExtensionChanged", 1, value);
        }
        }
        break;
    }
    case Actions::Id: {
        switch (header.mPath.mEventId)
        {
        case Actions::Events::StateChanged::Id: {
            chip::app::Clusters::Actions::Events::StateChanged::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StateChanged", 1, value);
        }
        case Actions::Events::ActionFailed::Id: {
            chip::app::Clusters::Actions::Events::ActionFailed::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ActionFailed", 1, value);
        }
        }
        break;
    }
    case Basic::Id: {
        switch (header.mPath.mEventId)
        {
        case Basic::Events::StartUp::Id: {
            chip::app::Clusters::Basic::Events::StartUp::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StartUp", 1, value);
        }
        case Basic::Events::ShutDown::Id: {
            chip::app::Clusters::Basic::Events::ShutDown::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ShutDown", 1, value);
        }
        case Basic::Events::Leave::Id: {
            chip::app::Clusters::Basic::Events::Leave::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Leave", 1, value);
        }
        case Basic::Events::ReachableChanged::Id: {
            chip::app::Clusters::Basic::Events::ReachableChanged::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ReachableChanged", 1, value);
        }
        }
        break;
    }
    case OtaSoftwareUpdateRequestor::Id: {
        switch (header.mPath.mEventId)
        {
        case OtaSoftwareUpdateRequestor::Events::StateTransition::Id: {
            chip::app::Clusters::OtaSoftwareUpdateRequestor::Events::StateTransition::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StateTransition", 1, value);
        }
        case OtaSoftwareUpdateRequestor::Events::VersionApplied::Id: {
            chip::app::Clusters::OtaSoftwareUpdateRequestor::Events::VersionApplied::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("VersionApplied", 1, value);
        }
        case OtaSoftwareUpdateRequestor::Events::DownloadError::Id: {
            chip::app::Clusters::OtaSoftwareUpdateRequestor::Events::DownloadError::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DownloadError", 1, value);
        }
        }
        break;
    }
    case GeneralDiagnostics::Id: {
        switch (header.mPath.mEventId)
        {
        case GeneralDiagnostics::Events::HardwareFaultChange::Id: {
            chip::app::Clusters::GeneralDiagnostics::Events::HardwareFaultChange::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("HardwareFaultChange", 1, value);
        }
        case GeneralDiagnostics::Events::RadioFaultChange::Id: {
            chip::app::Clusters::GeneralDiagnostics::Events::RadioFaultChange::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("RadioFaultChange", 1, value);
        }
        case GeneralDiagnostics::Events::NetworkFaultChange::Id: {
            chip::app::Clusters::GeneralDiagnostics::Events::NetworkFaultChange::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NetworkFaultChange", 1, value);
        }
        case GeneralDiagnostics::Events::BootReason::Id: {
            chip::app::Clusters::GeneralDiagnostics::Events::BootReason::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("BootReason", 1, value);
        }
        }
        break;
    }
    case SoftwareDiagnostics::Id: {
        switch (header.mPath.mEventId)
        {
        case SoftwareDiagnostics::Events::SoftwareFault::Id: {
            chip::app::Clusters::SoftwareDiagnostics::Events::SoftwareFault::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SoftwareFault", 1, value);
        }
        }
        break;
    }
    case ThreadNetworkDiagnostics::Id: {
        switch (header.mPath.mEventId)
        {
        case ThreadNetworkDiagnostics::Events::ConnectionStatus::Id: {
            chip::app::Clusters::ThreadNetworkDiagnostics::Events::ConnectionStatus::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ConnectionStatus", 1, value);
        }
        case ThreadNetworkDiagnostics::Events::NetworkFaultChange::Id: {
            chip::app::Clusters::ThreadNetworkDiagnostics::Events::NetworkFaultChange::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("NetworkFaultChange", 1, value);
        }
        }
        break;
    }
    case WiFiNetworkDiagnostics::Id: {
        switch (header.mPath.mEventId)
        {
        case WiFiNetworkDiagnostics::Events::Disconnection::Id: {
            chip::app::Clusters::WiFiNetworkDiagnostics::Events::Disconnection::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Disconnection", 1, value);
        }
        case WiFiNetworkDiagnostics::Events::AssociationFailure::Id: {
            chip::app::Clusters::WiFiNetworkDiagnostics::Events::AssociationFailure::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AssociationFailure", 1, value);
        }
        case WiFiNetworkDiagnostics::Events::ConnectionStatus::Id: {
            chip::app::Clusters::WiFiNetworkDiagnostics::Events::ConnectionStatus::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ConnectionStatus", 1, value);
        }
        }
        break;
    }
    case BridgedDeviceBasic::Id: {
        switch (header.mPath.mEventId)
        {
        case BridgedDeviceBasic::Events::StartUp::Id: {
            chip::app::Clusters::BridgedDeviceBasic::Events::StartUp::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StartUp", 1, value);
        }
        case BridgedDeviceBasic::Events::ShutDown::Id: {
            chip::app::Clusters::BridgedDeviceBasic::Events::ShutDown::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ShutDown", 1, value);
        }
        case BridgedDeviceBasic::Events::Leave::Id: {
            chip::app::Clusters::BridgedDeviceBasic::Events::Leave::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Leave", 1, value);
        }
        case BridgedDeviceBasic::Events::ReachableChanged::Id: {
            chip::app::Clusters::BridgedDeviceBasic::Events::ReachableChanged::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ReachableChanged", 1, value);
        }
        }
        break;
    }
    case Switch::Id: {
        switch (header.mPath.mEventId)
        {
        case Switch::Events::SwitchLatched::Id: {
            chip::app::Clusters::Switch::Events::SwitchLatched::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SwitchLatched", 1, value);
        }
        case Switch::Events::InitialPress::Id: {
            chip::app::Clusters::Switch::Events::InitialPress::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("InitialPress", 1, value);
        }
        case Switch::Events::LongPress::Id: {
            chip::app::Clusters::Switch::Events::LongPress::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LongPress", 1, value);
        }
        case Switch::Events::ShortRelease::Id: {
            chip::app::Clusters::Switch::Events::ShortRelease::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ShortRelease", 1, value);
        }
        case Switch::Events::LongRelease::Id: {
            chip::app::Clusters::Switch::Events::LongRelease::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LongRelease", 1, value);
        }
        case Switch::Events::MultiPressOngoing::Id: {
            chip::app::Clusters::Switch::Events::MultiPressOngoing::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MultiPressOngoing", 1, value);
        }
        case Switch::Events::MultiPressComplete::Id: {
            chip::app::Clusters::Switch::Events::MultiPressComplete::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MultiPressComplete", 1, value);
        }
        }
        break;
    }
    case BooleanState::Id: {
        switch (header.mPath.mEventId)
        {
        case BooleanState::Events::StateChange::Id: {
            chip::app::Clusters::BooleanState::Events::StateChange::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("StateChange", 1, value);
        }
        }
        break;
    }
    case DoorLock::Id: {
        switch (header.mPath.mEventId)
        {
        case DoorLock::Events::DoorLockAlarm::Id: {
            chip::app::Clusters::DoorLock::Events::DoorLockAlarm::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DoorLockAlarm", 1, value);
        }
        case DoorLock::Events::DoorStateChange::Id: {
            chip::app::Clusters::DoorLock::Events::DoorStateChange::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DoorStateChange", 1, value);
        }
        case DoorLock::Events::LockOperation::Id: {
            chip::app::Clusters::DoorLock::Events::LockOperation::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LockOperation", 1, value);
        }
        case DoorLock::Events::LockOperationError::Id: {
            chip::app::Clusters::DoorLock::Events::LockOperationError::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LockOperationError", 1, value);
        }
        case DoorLock::Events::LockUserChange::Id: {
            chip::app::Clusters::DoorLock::Events::LockUserChange::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("LockUserChange", 1, value);
        }
        }
        break;
    }
    case PumpConfigurationAndControl::Id: {
        switch (header.mPath.mEventId)
        {
        case PumpConfigurationAndControl::Events::SupplyVoltageLow::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::SupplyVoltageLow::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SupplyVoltageLow", 1, value);
        }
        case PumpConfigurationAndControl::Events::SupplyVoltageHigh::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::SupplyVoltageHigh::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SupplyVoltageHigh", 1, value);
        }
        case PumpConfigurationAndControl::Events::PowerMissingPhase::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::PowerMissingPhase::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PowerMissingPhase", 1, value);
        }
        case PumpConfigurationAndControl::Events::SystemPressureLow::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::SystemPressureLow::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SystemPressureLow", 1, value);
        }
        case PumpConfigurationAndControl::Events::SystemPressureHigh::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::SystemPressureHigh::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SystemPressureHigh", 1, value);
        }
        case PumpConfigurationAndControl::Events::DryRunning::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::DryRunning::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("DryRunning", 1, value);
        }
        case PumpConfigurationAndControl::Events::MotorTemperatureHigh::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::MotorTemperatureHigh::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("MotorTemperatureHigh", 1, value);
        }
        case PumpConfigurationAndControl::Events::PumpMotorFatalFailure::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::PumpMotorFatalFailure::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PumpMotorFatalFailure", 1, value);
        }
        case PumpConfigurationAndControl::Events::ElectronicTemperatureHigh::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::ElectronicTemperatureHigh::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ElectronicTemperatureHigh", 1, value);
        }
        case PumpConfigurationAndControl::Events::PumpBlocked::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::PumpBlocked::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("PumpBlocked", 1, value);
        }
        case PumpConfigurationAndControl::Events::SensorFailure::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::SensorFailure::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("SensorFailure", 1, value);
        }
        case PumpConfigurationAndControl::Events::ElectronicNonFatalFailure::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::ElectronicNonFatalFailure::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ElectronicNonFatalFailure", 1, value);
        }
        case PumpConfigurationAndControl::Events::ElectronicFatalFailure::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::ElectronicFatalFailure::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("ElectronicFatalFailure", 1, value);
        }
        case PumpConfigurationAndControl::Events::GeneralFault::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::GeneralFault::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("GeneralFault", 1, value);
        }
        case PumpConfigurationAndControl::Events::Leakage::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::Leakage::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("Leakage", 1, value);
        }
        case PumpConfigurationAndControl::Events::AirDetection::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::AirDetection::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("AirDetection", 1, value);
        }
        case PumpConfigurationAndControl::Events::TurbineOperation::Id: {
            chip::app::Clusters::PumpConfigurationAndControl::Events::TurbineOperation::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TurbineOperation", 1, value);
        }
        }
        break;
    }
    case TestCluster::Id: {
        switch (header.mPath.mEventId)
        {
        case TestCluster::Events::TestEvent::Id: {
            chip::app::Clusters::TestCluster::Events::TestEvent::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestEvent", 1, value);
        }
        case TestCluster::Events::TestFabricScopedEvent::Id: {
            chip::app::Clusters::TestCluster::Events::TestFabricScopedEvent::DecodableType value;
            ReturnErrorOnFailure(chip::app::DataModel::Decode(*data, value));
            return DataModelLogger::LogValue("TestFabricScopedEvent", 1, value);
        }
        }
        break;
    }
    default:
        break;
    }
    ChipLogProgress(chipTool, "  Don't know how to log event data");
    return CHIP_NO_ERROR;
}
