/*
 *
 *    Copyright (c) 2022 Project CHIP Authors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

// THIS FILE IS GENERATED BY ZAP

#pragma once

#if CONFIG_ENABLE_YAML_TESTS

#include <commands/common/Commands.h>
#include <commands/tests/TestCommand.h>
#include <lib/core/Optional.h>
#include <lib/support/CHIPListUtils.h>
#include <system/SystemClock.h>

#include <math.h> // For INFINITY

class TestList : public Command
{
public:
    TestList() : Command("list"){};
    CHIP_ERROR Run() override
    {
        printf("TestAccessControlCluster\n");
        printf("Test_TC_ACL_1_1\n");
        printf("Test_TC_ACL_2_1\n");
        printf("Test_TC_ACL_2_2\n");
        printf("Test_TC_BOOL_1_1\n");
        printf("Test_TC_BOOL_2_1\n");
        printf("Test_TC_ACT_1_1\n");
        printf("Test_TC_BIND_1_1\n");
        printf("Test_TC_CC_1_1\n");
        printf("Test_TC_CC_2_1\n");
        printf("Test_TC_CC_3_2\n");
        printf("Test_TC_CC_3_3\n");
        printf("Test_TC_CC_4_1\n");
        printf("Test_TC_CC_4_2\n");
        printf("Test_TC_CC_4_3\n");
        printf("Test_TC_CC_4_4\n");
        printf("Test_TC_CC_5_1\n");
        printf("Test_TC_CC_5_2\n");
        printf("Test_TC_CC_5_3\n");
        printf("Test_TC_CC_6_1\n");
        printf("Test_TC_CC_6_2\n");
        printf("Test_TC_CC_6_3\n");
        printf("Test_TC_CC_7_2\n");
        printf("Test_TC_CC_7_3\n");
        printf("Test_TC_CC_7_4\n");
        printf("Test_TC_CC_8_1\n");
        printf("Test_TC_OPCREDS_1_2\n");
        printf("Test_TC_BINFO_1_1\n");
        printf("Test_TC_BINFO_2_1\n");
        printf("Test_TC_CNET_1_3\n");
        printf("Test_TC_DESC_1_1\n");
        printf("Test_TC_DLOG_1_1\n");
        printf("Test_TC_DGETH_1_1\n");
        printf("Test_TC_DGETH_2_1\n");
        printf("Test_TC_DGETH_2_2\n");
        printf("Test_TC_FLW_1_1\n");
        printf("Test_TC_FLW_2_1\n");
        printf("Test_TC_FLABEL_1_1\n");
        printf("Test_TC_FLABEL_2_1\n");
        printf("Test_TC_CGEN_1_1\n");
        printf("Test_TC_CGEN_2_1\n");
        printf("Test_TC_DGGEN_1_1\n");
        printf("Test_TC_DGGEN_2_1\n");
        printf("Test_TC_I_1_1\n");
        printf("Test_TC_I_2_1\n");
        printf("Test_TC_I_2_2\n");
        printf("Test_TC_I_2_3\n");
        printf("Test_TC_ILL_1_1\n");
        printf("Test_TC_ILL_2_1\n");
        printf("Test_TC_ILL_2_2\n");
        printf("Test_TC_LVL_1_1\n");
        printf("Test_TC_LVL_2_1\n");
        printf("Test_TC_LVL_2_2\n");
        printf("Test_TC_LVL_3_1\n");
        printf("Test_TC_LVL_4_1\n");
        printf("Test_TC_LVL_5_1\n");
        printf("Test_TC_LVL_6_1\n");
        printf("Test_TC_LCFG_1_1\n");
        printf("Test_TC_LUNIT_1_2\n");
        printf("Test_TC_LTIME_1_2\n");
        printf("Test_TC_LOWPOWER_1_1\n");
        printf("Test_TC_KEYPADINPUT_1_2\n");
        printf("Test_TC_APPLAUNCHER_1_3\n");
        printf("Test_TC_MEDIAINPUT_1_4\n");
        printf("Test_TC_WAKEONLAN_1_5\n");
        printf("Test_TC_CHANNEL_1_6\n");
        printf("Test_TC_MEDIAPLAYBACK_1_7\n");
        printf("Test_TC_AUDIOOUTPUT_1_8\n");
        printf("Test_TC_TGTNAV_1_9\n");
        printf("Test_TC_TGTNAV_8_2\n");
        printf("Test_TC_APBSC_1_10\n");
        printf("Test_TC_CONTENTLAUNCHER_1_11\n");
        printf("Test_TC_ALOGIN_1_12\n");
        printf("Test_TC_LOWPOWER_2_1\n");
        printf("Test_TC_KEYPADINPUT_3_2\n");
        printf("Test_TC_KEYPADINPUT_3_3\n");
        printf("Test_TC_APPLAUNCHER_3_5\n");
        printf("Test_TC_APPLAUNCHER_3_6\n");
        printf("Test_TC_APPLAUNCHER_3_7\n");
        printf("Test_TC_APPLAUNCHER_3_8\n");
        printf("Test_TC_APPLAUNCHER_3_9\n");
        printf("Test_TC_MEDIAINPUT_3_10\n");
        printf("Test_TC_MEDIAINPUT_3_11\n");
        printf("Test_TC_MEDIAINPUT_3_12\n");
        printf("Test_TC_MEDIAINPUT_3_13\n");
        printf("Test_TC_CHANNEL_5_1\n");
        printf("Test_TC_CHANNEL_5_2\n");
        printf("Test_TC_CHANNEL_5_3\n");
        printf("Test_TC_MEDIAPLAYBACK_6_1\n");
        printf("Test_TC_MEDIAPLAYBACK_6_2\n");
        printf("Test_TC_MEDIAPLAYBACK_6_3\n");
        printf("Test_TC_MEDIAPLAYBACK_6_4\n");
        printf("Test_TC_AUDIOOUTPUT_7_1\n");
        printf("Test_TC_AUDIOOUTPUT_7_2\n");
        printf("Test_TC_TGTNAV_8_1\n");
        printf("Test_TC_APBSC_9_1\n");
        printf("Test_TC_CONTENTLAUNCHER_10_1\n");
        printf("Test_TC_MOD_1_1\n");
        printf("OTA_SuccessfulTransfer\n");
        printf("Test_TC_OCC_1_1\n");
        printf("Test_TC_OCC_2_1\n");
        printf("Test_TC_OO_1_1\n");
        printf("Test_TC_OO_2_1\n");
        printf("Test_TC_OO_2_2\n");
        printf("Test_TC_OO_2_4\n");
        printf("Test_TC_PS_1_1\n");
        printf("Test_TC_PS_2_1\n");
        printf("Test_TC_PRS_1_1\n");
        printf("Test_TC_PRS_2_1\n");
        printf("Test_TC_PRS_2_2\n");
        printf("Test_TC_PCC_1_1\n");
        printf("Test_TC_PCC_2_1\n");
        printf("Test_TC_PCC_2_2\n");
        printf("Test_TC_PCC_2_3\n");
        printf("Test_TC_PCC_2_4\n");
        printf("Test_TC_PSCFG_1_1\n");
        printf("Test_TC_PSCFG_2_1\n");
        printf("Test_TC_RH_1_1\n");
        printf("Test_TC_RH_2_1\n");
        printf("Test_TC_SWTCH_1_1\n");
        printf("Test_TC_SWTCH_2_1\n");
        printf("Test_TC_TMP_1_1\n");
        printf("Test_TC_TMP_2_1\n");
        printf("Test_TC_TSTAT_1_1\n");
        printf("Test_TC_TSTAT_2_1\n");
        printf("Test_TC_TSTAT_2_2\n");
        printf("Test_TC_TSUIC_1_1\n");
        printf("Test_TC_TSUIC_2_1\n");
        printf("Test_TC_TSUIC_2_2\n");
        printf("Test_TC_DGTHREAD_1_1\n");
        printf("Test_TC_DGTHREAD_2_1\n");
        printf("Test_TC_DGTHREAD_2_2\n");
        printf("Test_TC_DGTHREAD_2_3\n");
        printf("Test_TC_DGTHREAD_2_4\n");
        printf("Test_TC_ULABEL_1_1\n");
        printf("Test_TC_ULABEL_2_1\n");
        printf("Test_TC_ULABEL_2_2\n");
        printf("Test_TC_ULABEL_2_3\n");
        printf("Test_TC_ULABEL_2_4\n");
        printf("Test_TC_DGWIFI_1_1\n");
        printf("Test_TC_DGWIFI_2_1\n");
        printf("Test_TC_DGWIFI_2_3\n");
        printf("Test_TC_WNCV_1_1\n");
        printf("Test_TC_WNCV_2_1\n");
        printf("Test_TC_WNCV_2_2\n");
        printf("Test_TC_WNCV_2_3\n");
        printf("Test_TC_WNCV_2_4\n");
        printf("Test_TC_WNCV_2_5\n");
        printf("Test_TC_WNCV_3_1\n");
        printf("Test_TC_WNCV_3_2\n");
        printf("Test_TC_WNCV_3_3\n");
        printf("Test_TC_WNCV_3_4\n");
        printf("Test_TC_WNCV_3_5\n");
        printf("Test_TC_WNCV_4_1\n");
        printf("Test_TC_WNCV_4_2\n");
        printf("Test_TC_WNCV_4_3\n");
        printf("Test_TC_WNCV_4_4\n");
        printf("Test_TC_WNCV_4_5\n");
        printf("TV_TargetNavigatorCluster\n");
        printf("TV_AudioOutputCluster\n");
        printf("TV_ApplicationLauncherCluster\n");
        printf("TV_KeypadInputCluster\n");
        printf("TV_AccountLoginCluster\n");
        printf("TV_WakeOnLanCluster\n");
        printf("TV_ApplicationBasicCluster\n");
        printf("TV_MediaPlaybackCluster\n");
        printf("TV_ChannelCluster\n");
        printf("TV_LowPowerCluster\n");
        printf("TV_ContentLauncherCluster\n");
        printf("TV_MediaInputCluster\n");
        printf("TestCASERecovery\n");
        printf("TestCluster\n");
        printf("TestClusterComplexTypes\n");
        printf("TestConstraints\n");
        printf("TestDelayCommands\n");
        printf("TestEvents\n");
        printf("TestDiscovery\n");
        printf("TestLogCommands\n");
        printf("TestSaveAs\n");
        printf("TestConfigVariables\n");
        printf("TestDescriptorCluster\n");
        printf("TestBasicInformation\n");
        printf("TestFabricRemovalWhileSubscribed\n");
        printf("TestGeneralCommissioning\n");
        printf("TestIdentifyCluster\n");
        printf("TestOperationalCredentialsCluster\n");
        printf("TestModeSelectCluster\n");
        printf("TestSelfFabricRemoval\n");
        printf("TestSystemCommands\n");
        printf("TestBinding\n");
        printf("TestUserLabelCluster\n");
        printf("TestUserLabelClusterConstraints\n");
        printf("TestArmFailSafe\n");
        printf("TestFanControl\n");
        printf("TestAccessControlConstraints\n");
        printf("TestLevelControlWithOnOffDependency\n");
        printf("TestCommissioningWindow\n");
        printf("TestMultiAdmin\n");
        printf("Test_TC_DGSW_1_1\n");
        printf("TestSubscribe_OnOff\n");
        printf("DL_UsersAndCredentials\n");
        printf("DL_LockUnlock\n");
        printf("DL_Schedules\n");
        printf("Test_TC_DRLK_1_1\n");
        printf("Test_TC_DRLK_2_2\n");
        printf("Test_TC_DRLK_2_3\n");
        printf("Test_TC_DRLK_2_4\n");
        printf("Test_TC_DRLK_2_5\n");
        printf("Test_TC_DRLK_2_7\n");
        printf("Test_TC_DRLK_2_9\n");
        printf("TestGroupMessaging\n");
        printf("TestGroupsCluster\n");
        printf("TestGroupKeyManagementCluster\n");
        printf("Test_TC_G_1_1\n");
        printf("Test_TC_G_2_1\n");

        return CHIP_NO_ERROR;
    }
};

class ManualTestList : public Command
{
public:
    ManualTestList() : Command("list-manual"){};
    CHIP_ERROR Run() override
    {
        printf("Test_TC_DD_1_5\n");
        printf("Test_TC_DD_1_6\n");
        printf("Test_TC_DD_1_7\n");
        printf("Test_TC_DD_1_8\n");
        printf("Test_TC_DD_1_9\n");
        printf("Test_TC_DD_1_10\n");
        printf("Test_TC_DD_1_11\n");
        printf("Test_TC_DD_1_12\n");
        printf("Test_TC_DD_1_13\n");
        printf("Test_TC_DD_1_14\n");
        printf("Test_TC_DD_1_15\n");
        printf("Test_TC_DD_2_1\n");
        printf("Test_TC_DD_2_2\n");
        printf("Test_TC_DD_3_1\n");
        printf("Test_TC_DD_3_2\n");
        printf("Test_TC_DD_3_3\n");
        printf("Test_TC_DD_3_4\n");
        printf("Test_TC_DD_3_5\n");
        printf("Test_TC_DD_3_6\n");
        printf("Test_TC_DD_3_7\n");
        printf("Test_TC_DD_3_8\n");
        printf("Test_TC_DD_3_9\n");
        printf("Test_TC_DD_3_10\n");
        printf("Test_TC_DD_3_11\n");
        printf("Test_TC_DD_3_12\n");
        printf("Test_TC_DD_3_13\n");
        printf("Test_TC_DD_3_14\n");
        printf("Test_TC_DD_3_15\n");
        printf("Test_TC_DD_3_16\n");
        printf("Test_TC_DD_3_17\n");
        printf("Test_TC_DD_3_18\n");
        printf("Test_TC_DD_3_19\n");
        printf("Test_TC_DD_3_20\n");
        printf("Test_TC_DD_3_21\n");
        printf("TestGroupDemoCommand\n");
        printf("TestGroupDemoConfig\n");
        printf("Test_TC_G_2_2\n");
        printf("Test_TC_G_2_3\n");
        printf("Test_TC_G_3_1\n");
        printf("Test_TC_G_3_2\n");
        printf("Test_TC_BDX_1_1\n");
        printf("Test_TC_BDX_1_2\n");
        printf("Test_TC_BDX_1_3\n");
        printf("Test_TC_BDX_1_4\n");
        printf("Test_TC_BDX_1_5\n");
        printf("Test_TC_BDX_1_6\n");
        printf("Test_TC_BDX_2_1\n");
        printf("Test_TC_BDX_2_2\n");
        printf("Test_TC_BDX_2_3\n");
        printf("Test_TC_BDX_2_4\n");
        printf("Test_TC_BDX_2_5\n");
        printf("Test_TC_BR_1\n");
        printf("Test_TC_BR_2\n");
        printf("Test_TC_BR_3\n");
        printf("Test_TC_BR_4\n");
        printf("Test_TC_DA_1_1\n");
        printf("Test_TC_DA_1_2\n");
        printf("Test_TC_DA_1_3\n");
        printf("Test_TC_DA_1_4\n");
        printf("Test_TC_DA_1_5\n");
        printf("Test_TC_DA_1_6\n");
        printf("Test_TC_DA_1_7\n");
        printf("Test_TC_BINFO_2_2\n");
        printf("Test_TC_BINFO_2_4\n");
        printf("Test_TC_OPCREDS_3_1\n");
        printf("Test_TC_OPCREDS_3_2\n");
        printf("Test_TC_OPCREDS_3_3\n");
        printf("Test_TC_OPCREDS_3_4\n");
        printf("Test_TC_CNET_4_1\n");
        printf("Test_TC_CNET_4_2\n");
        printf("Test_TC_CNET_4_3\n");
        printf("Test_TC_CNET_4_4\n");
        printf("Test_TC_CNET_4_5\n");
        printf("Test_TC_CNET_4_6\n");
        printf("Test_TC_CNET_4_9\n");
        printf("Test_TC_CNET_4_10\n");
        printf("Test_TC_CNET_4_11\n");
        printf("Test_TC_CNET_4_12\n");
        printf("Test_TC_CNET_4_13\n");
        printf("Test_TC_CNET_4_14\n");
        printf("Test_TC_CNET_4_15\n");
        printf("Test_TC_CNET_4_16\n");
        printf("Test_TC_CNET_4_17\n");
        printf("Test_TC_CNET_4_18\n");
        printf("Test_TC_CNET_4_19\n");
        printf("Test_TC_CNET_4_20\n");
        printf("Test_TC_CNET_4_21\n");
        printf("Test_TC_CNET_4_22\n");
        printf("Test_TC_DLOG_2_1\n");
        printf("Test_TC_DLOG_2_2\n");
        printf("Test_TC_DLOG_3_1\n");
        printf("Test_TC_DESC_2_1\n");
        printf("Test_TC_DESC_2_2\n");
        printf("Test_TC_DGETH_3_1\n");
        printf("Test_TC_DGETH_3_2\n");
        printf("Test_TC_CGEN_2_2\n");
        printf("Test_TC_CGEN_2_4\n");
        printf("Test_TC_DGGEN_2_2\n");
        printf("Test_TC_DGGEN_2_3\n");
        printf("Test_TC_DGGEN_3_1\n");
        printf("Test_TC_I_3_1\n");
        printf("Test_TC_I_3_2\n");
        printf("Test_TC_ILL_3_1\n");
        printf("Test_TC_IDM_1_1\n");
        printf("Test_TC_IDM_1_2\n");
        printf("Test_TC_IDM_2_1\n");
        printf("Test_TC_IDM_2_2\n");
        printf("Test_TC_IDM_3_1\n");
        printf("Test_TC_IDM_3_2\n");
        printf("Test_TC_IDM_4_1\n");
        printf("Test_TC_IDM_4_2\n");
        printf("Test_TC_IDM_4_3\n");
        printf("Test_TC_IDM_5_1\n");
        printf("Test_TC_IDM_5_2\n");
        printf("Test_TC_IDM_6_1\n");
        printf("Test_TC_IDM_6_2\n");
        printf("Test_TC_IDM_6_3\n");
        printf("Test_TC_IDM_6_4\n");
        printf("Test_TC_IDM_7_1\n");
        printf("Test_TC_IDM_8_1\n");
        printf("Test_TC_LOWPOWER_2_2\n");
        printf("Test_TC_APPLAUNCHER_3_7_1\n");
        printf("Test_TC_APPLAUNCHER_3_8_1\n");
        printf("Test_TC_APPLAUNCHER_3_9_1\n");
        printf("Test_TC_MEDIAINPUT_3_14\n");
        printf("Test_TC_MEDIAINPUT_3_15\n");
        printf("Test_TC_MEDIAINPUT_3_16\n");
        printf("Test_TC_MEDIAINPUT_3_17\n");
        printf("Test_TC_WAKEONLAN_4_1\n");
        printf("Test_TC_CHANNEL_5_4\n");
        printf("Test_TC_CHANNEL_5_5\n");
        printf("Test_TC_CHANNEL_5_6\n");
        printf("Test_TC_KEYPADINPUT_3_1\n");
        printf("Test_TC_MEDIAPLAYBACK_6_5\n");
        printf("Test_TC_MEDIAPLAYBACK_6_7\n");
        printf("Test_TC_AUDIOOUTPUT_7_3\n");
        printf("Test_TC_AUDIOOUTPUT_7_4\n");
        printf("Test_TC_CONTENTLAUNCHER_10_3\n");
        printf("Test_TC_CONTENTLAUNCHER_10_4\n");
        printf("Test_TC_CONTENTLAUNCHER_10_5\n");
        printf("Test_TC_CONTENTLAUNCHER_10_7\n");
        printf("Test_TC_MC_11_1\n");
        printf("Test_TC_MC_11_2\n");
        printf("Test_TC_ALOGIN_12_1\n");
        printf("Test_TC_ALOGIN_12_2\n");
        printf("Test_TC_CADMIN_1_1\n");
        printf("Test_TC_CADMIN_1_2\n");
        printf("Test_TC_CADMIN_1_7\n");
        printf("Test_TC_CADMIN_1_8\n");
        printf("Test_TC_CADMIN_1_11\n");
        printf("Test_TC_CADMIN_1_12\n");
        printf("Test_TC_CADMIN_1_14\n");
        printf("Test_TC_CADMIN_1_15\n");
        printf("Test_TC_CADMIN_1_16\n");
        printf("Test_TC_CADMIN_1_17\n");
        printf("Test_TC_CADMIN_1_18\n");
        printf("Test_TC_CADMIN_1_19\n");
        printf("Test_TC_CADMIN_1_20\n");
        printf("Test_TC_CADMIN_1_21\n");
        printf("Test_TC_CADMIN_1_22\n");
        printf("Test_TC_CADMIN_1_3\n");
        printf("Test_TC_CADMIN_1_4\n");
        printf("Test_TC_CADMIN_1_5\n");
        printf("Test_TC_CADMIN_1_6\n");
        printf("Test_TC_CADMIN_1_9\n");
        printf("Test_TC_CADMIN_1_10\n");
        printf("Test_TC_CADMIN_1_13\n");
        printf("Test_TC_CADMIN_1_23\n");
        printf("Test_TC_CADMIN_1_24\n");
        printf("Test_TC_MOD_1_2\n");
        printf("Test_TC_MOD_1_3\n");
        printf("Test_TC_MOD_2_1\n");
        printf("Test_TC_MOD_2_2\n");
        printf("Test_TC_MOD_3_1\n");
        printf("Test_TC_MOD_3_2\n");
        printf("Test_TC_MOD_3_3\n");
        printf("Test_TC_MOD_3_4\n");
        printf("Test_TC_SU_1_1\n");
        printf("Test_TC_SU_2_1\n");
        printf("Test_TC_SU_2_2\n");
        printf("Test_TC_SU_2_3\n");
        printf("Test_TC_SU_2_4\n");
        printf("Test_TC_SU_2_5\n");
        printf("Test_TC_SU_2_6\n");
        printf("Test_TC_SU_2_7\n");
        printf("Test_TC_SU_2_8\n");
        printf("Test_TC_SU_3_1\n");
        printf("Test_TC_SU_3_2\n");
        printf("Test_TC_SU_3_3\n");
        printf("Test_TC_SU_3_4\n");
        printf("Test_TC_SU_4_1\n");
        printf("Test_TC_SU_4_2\n");
        printf("Test_TC_PSCFG_2_2\n");
        printf("Test_TC_PSCFG_3_1\n");
        printf("Test_TC_SC_1_1\n");
        printf("Test_TC_SC_1_2\n");
        printf("Test_TC_SC_1_3\n");
        printf("Test_TC_SC_1_4\n");
        printf("Test_TC_SC_2_1\n");
        printf("Test_TC_SC_2_2\n");
        printf("Test_TC_SC_2_3\n");
        printf("Test_TC_SC_2_4\n");
        printf("Test_TC_SC_3_1\n");
        printf("Test_TC_SC_3_2\n");
        printf("Test_TC_SC_3_3\n");
        printf("Test_TC_SC_3_4\n");
        printf("Test_TC_SC_3_6\n");
        printf("Test_TC_SC_4_1\n");
        printf("Test_TC_SC_4_2\n");
        printf("Test_TC_SC_4_3\n");
        printf("Test_TC_SC_4_4\n");
        printf("Test_TC_SC_4_5\n");
        printf("Test_TC_SC_4_6\n");
        printf("Test_TC_SC_4_7\n");
        printf("Test_TC_SC_4_8\n");
        printf("Test_TC_SC_4_9\n");
        printf("Test_TC_SC_4_10\n");
        printf("Test_TC_SC_5_1\n");
        printf("Test_TC_SC_5_2\n");
        printf("Test_TC_SC_5_3\n");
        printf("Test_TC_SC_6_1\n");
        printf("Test_TC_DGSW_2_1\n");
        printf("Test_TC_DGSW_2_2\n");
        printf("Test_TC_DGSW_2_3\n");
        printf("Test_TC_DGSW_3_1\n");
        printf("Test_TC_DGSW_3_2\n");
        printf("Test_TC_DGWIFI_2_2\n");
        printf("Test_TC_DGWIFI_3_1\n");
        printf("Test_TC_DGWIFI_3_2\n");
        printf("Test_TC_WNCV_6_1\n");
        printf("Test_TC_WNCV_7_1\n");
        printf("Test_TC_FLW_2_2\n");
        printf("Test_TC_FLW_3_1\n");
        printf("Test_TC_OCC_2_2\n");
        printf("Test_TC_OCC_2_3\n");
        printf("Test_TC_OCC_2_4\n");
        printf("Test_TC_OCC_3_1\n");
        printf("Test_TC_PRS_3_1\n");
        printf("Test_TC_PS_2_2\n");
        printf("Test_TC_PS_3_1\n");
        printf("Test_TC_BOOL_2_2\n");
        printf("Test_TC_BOOL_3_1\n");
        printf("Test_TC_CC_2_2\n");
        printf("Test_TC_CC_3_4\n");
        printf("Test_TC_CC_4_5\n");
        printf("Test_TC_CC_5_4\n");
        printf("Test_TC_CC_6_4\n");
        printf("Test_TC_CC_7_5\n");
        printf("Test_TC_CC_9_4\n");
        printf("Test_TC_CC_3_1\n");
        printf("Test_TC_CC_7_1\n");
        printf("Test_TC_CC_9_1\n");
        printf("Test_TC_CC_9_2\n");
        printf("Test_TC_CC_9_3\n");
        printf("Test_TC_DRLK_2_1\n");
        printf("Test_TC_DRLK_2_6\n");
        printf("Test_TC_DRLK_2_8\n");
        printf("Test_TC_DRLK_2_10\n");
        printf("Test_TC_DRLK_3_1\n");
        printf("Test_TC_DRLK_3_2\n");
        printf("Test_TC_DRLK_3_3\n");
        printf("Test_TC_LCFG_2_1\n");
        printf("Test_TC_LCFG_3_1\n");
        printf("Test_TC_LVL_2_3\n");
        printf("Test_TC_LVL_7_1\n");
        printf("Test_TC_LVL_8_1\n");
        printf("Test_TC_OO_2_3\n");
        printf("Test_TC_OO_3_1\n");
        printf("Test_TC_OO_3_2\n");
        printf("Test_TC_RH_2_2\n");
        printf("Test_TC_RH_3_1\n");
        printf("Test_TC_SWTCH_2_2\n");
        printf("Test_TC_SWTCH_3_1\n");
        printf("Test_TC_SWTCH_3_2\n");
        printf("Test_TC_TMP_2_2\n");
        printf("Test_TC_TMP_3_1\n");
        printf("Test_TC_TSTAT_3_1\n");
        printf("Test_TC_TSTAT_3_2\n");
        printf("Test_TC_TSUIC_3_1\n");
        printf("Test_TC_DGTHREAD_2_5\n");
        printf("Test_TC_DGTHREAD_3_1\n");
        printf("Test_TC_DGTHREAD_3_2\n");
        printf("Test_TC_DGTHREAD_3_3\n");
        printf("Test_TC_DGTHREAD_3_4\n");
        printf("Test_TC_DGTHREAD_3_5\n");
        printf("Test_TC_ACT_2_1\n");
        printf("Test_TC_ACT_2_2\n");
        printf("Test_TC_ACT_3_1\n");
        printf("Test_TC_ACT_3_2\n");
        printf("Test_TC_LTIME_1_1\n");
        printf("Test_TC_LTIME_2_1\n");
        printf("Test_TC_LTIME_3_1\n");
        printf("Test_TC_LUNIT_1_1\n");
        printf("Test_TC_LUNIT_2_1\n");
        printf("Test_TC_LUNIT_3_1\n");
        printf("Test_TC_FLABEL_3_1\n");
        printf("Test_TC_BIND_2_1\n");
        printf("Test_TC_BIND_2_2\n");
        printf("Test_TC_BIND_2_3\n");
        printf("Test_TC_S_1_1\n");
        printf("Test_TC_S_2_1\n");
        printf("Test_TC_S_2_2\n");
        printf("Test_TC_S_2_3\n");
        printf("Test_TC_S_3_1\n");
        printf("Test_TC_PCC_3_1\n");
        printf("Test_TC_ACL_2_3\n");
        printf("Test_TC_ACL_2_4\n");
        printf("Test_TC_ACL_2_5\n");
        printf("Test_TC_ACL_2_6\n");
        printf("Test_TC_ACL_2_7\n");
        printf("Test_TC_ACL_2_8\n");
        printf("Test_TC_ACL_2_9\n");
        printf("Test_TC_ACL_2_10\n");
        printf("Test_TC_ULABEL_3_1\n");
        printf("Test_TC_BRBINFO_1_1\n");
        printf("Test_TC_BRBINFO_2_1\n");
        printf("Test_TC_BRBINFO_2_2\n");
        printf("Test_TC_BRBINFO_2_3\n");
        printf("Test_TC_ACE_1_1\n");
        printf("Test_TC_ACE_1_2\n");

        return CHIP_NO_ERROR;
    }
};

class TestAccessControlClusterSuite : public TestCommand
{
public:
    TestAccessControlClusterSuite(CredentialIssuerCommands * credsIssuerConfig) :
        TestCommand("TestAccessControlCluster", 24, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~TestAccessControlClusterSuite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>
                    value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 0));
                    VerifyOrReturn(CheckValue("acl[0].privilege", iter_0.GetValue().privilege, 5U));
                    VerifyOrReturn(CheckValue("acl[0].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNull("acl[0].subjects", iter_0.GetValue().subjects));
                    VerifyOrReturn(CheckValueNonNull("acl[0].targets", iter_0.GetValue().targets));
                    {
                        auto iter_3 = iter_0.GetValue().targets.Value().begin();
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[0].targets.Value()", iter_3, 0));
                        VerifyOrReturn(CheckValueNull("acl[0].targets.Value()[0].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(CheckValueNonNull("acl[0].targets.Value()[0].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[0].targets.Value()[0].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 0U));
                        VerifyOrReturn(CheckValueNull("acl[0].targets.Value()[0].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[0].targets.Value()", iter_3, 1));
                        VerifyOrReturn(CheckValueNonNull("acl[0].targets.Value()[1].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[0].targets.Value()[1].cluster.Value()", iter_3.GetValue().cluster.Value(), 1UL));
                        VerifyOrReturn(CheckValueNull("acl[0].targets.Value()[1].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(CheckValueNull("acl[0].targets.Value()[1].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[0].targets.Value()", iter_3, 2));
                        VerifyOrReturn(CheckValueNonNull("acl[0].targets.Value()[2].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[0].targets.Value()[2].cluster.Value()", iter_3.GetValue().cluster.Value(), 2UL));
                        VerifyOrReturn(CheckValueNonNull("acl[0].targets.Value()[2].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[0].targets.Value()[2].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 3U));
                        VerifyOrReturn(CheckValueNull("acl[0].targets.Value()[2].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(
                            CheckNoMoreListItems<decltype(iter_0.GetValue().targets.Value())>("acl[0].targets.Value()", iter_3, 3));
                    }
                    VerifyOrReturn(CheckValue("acl[0].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 1));
                    VerifyOrReturn(CheckValue("acl[1].privilege", iter_0.GetValue().privilege, 1U));
                    VerifyOrReturn(CheckValue("acl[1].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNonNull("acl[1].subjects", iter_0.GetValue().subjects));
                    {
                        auto iter_3 = iter_0.GetValue().subjects.Value().begin();
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[1].subjects.Value()", iter_3, 0));
                        VerifyOrReturn(CheckValue("acl[1].subjects.Value()[0]", iter_3.GetValue(), 4ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[1].subjects.Value()", iter_3, 1));
                        VerifyOrReturn(CheckValue("acl[1].subjects.Value()[1]", iter_3.GetValue(), 5ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[1].subjects.Value()", iter_3, 2));
                        VerifyOrReturn(CheckValue("acl[1].subjects.Value()[2]", iter_3.GetValue(), 6ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[1].subjects.Value()", iter_3, 3));
                        VerifyOrReturn(CheckValue("acl[1].subjects.Value()[3]", iter_3.GetValue(), 7ULL));
                        VerifyOrReturn(CheckNoMoreListItems<decltype(iter_0.GetValue().subjects.Value())>("acl[1].subjects.Value()",
                                                                                                          iter_3, 4));
                    }
                    VerifyOrReturn(CheckValueNonNull("acl[1].targets", iter_0.GetValue().targets));
                    {
                        auto iter_3 = iter_0.GetValue().targets.Value().begin();
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[1].targets.Value()", iter_3, 0));
                        VerifyOrReturn(CheckValueNull("acl[1].targets.Value()[0].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(CheckValueNonNull("acl[1].targets.Value()[0].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[1].targets.Value()[0].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 8U));
                        VerifyOrReturn(CheckValueNull("acl[1].targets.Value()[0].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[1].targets.Value()", iter_3, 1));
                        VerifyOrReturn(CheckValueNonNull("acl[1].targets.Value()[1].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[1].targets.Value()[1].cluster.Value()", iter_3.GetValue().cluster.Value(), 9UL));
                        VerifyOrReturn(CheckValueNull("acl[1].targets.Value()[1].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(CheckValueNull("acl[1].targets.Value()[1].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[1].targets.Value()", iter_3, 2));
                        VerifyOrReturn(CheckValueNonNull("acl[1].targets.Value()[2].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[1].targets.Value()[2].cluster.Value()", iter_3.GetValue().cluster.Value(), 10UL));
                        VerifyOrReturn(CheckValueNonNull("acl[1].targets.Value()[2].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[1].targets.Value()[2].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 11U));
                        VerifyOrReturn(CheckValueNull("acl[1].targets.Value()[2].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(
                            CheckNoMoreListItems<decltype(iter_0.GetValue().targets.Value())>("acl[1].targets.Value()", iter_3, 3));
                    }
                    VerifyOrReturn(CheckValue("acl[1].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 2));
                    VerifyOrReturn(CheckValue("acl[2].privilege", iter_0.GetValue().privilege, 3U));
                    VerifyOrReturn(CheckValue("acl[2].authMode", iter_0.GetValue().authMode, 3U));
                    VerifyOrReturn(CheckValueNonNull("acl[2].subjects", iter_0.GetValue().subjects));
                    {
                        auto iter_3 = iter_0.GetValue().subjects.Value().begin();
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[2].subjects.Value()", iter_3, 0));
                        VerifyOrReturn(CheckValue("acl[2].subjects.Value()[0]", iter_3.GetValue(), 12ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[2].subjects.Value()", iter_3, 1));
                        VerifyOrReturn(CheckValue("acl[2].subjects.Value()[1]", iter_3.GetValue(), 13ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[2].subjects.Value()", iter_3, 2));
                        VerifyOrReturn(CheckValue("acl[2].subjects.Value()[2]", iter_3.GetValue(), 14ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[2].subjects.Value()", iter_3, 3));
                        VerifyOrReturn(CheckValue("acl[2].subjects.Value()[3]", iter_3.GetValue(), 15ULL));
                        VerifyOrReturn(CheckNoMoreListItems<decltype(iter_0.GetValue().subjects.Value())>("acl[2].subjects.Value()",
                                                                                                          iter_3, 4));
                    }
                    VerifyOrReturn(CheckValueNonNull("acl[2].targets", iter_0.GetValue().targets));
                    {
                        auto iter_3 = iter_0.GetValue().targets.Value().begin();
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[2].targets.Value()", iter_3, 0));
                        VerifyOrReturn(CheckValueNull("acl[2].targets.Value()[0].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(CheckValueNonNull("acl[2].targets.Value()[0].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[2].targets.Value()[0].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 16U));
                        VerifyOrReturn(CheckValueNull("acl[2].targets.Value()[0].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[2].targets.Value()", iter_3, 1));
                        VerifyOrReturn(CheckValueNonNull("acl[2].targets.Value()[1].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[2].targets.Value()[1].cluster.Value()", iter_3.GetValue().cluster.Value(), 17UL));
                        VerifyOrReturn(CheckValueNull("acl[2].targets.Value()[1].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(CheckValueNull("acl[2].targets.Value()[1].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[2].targets.Value()", iter_3, 2));
                        VerifyOrReturn(CheckValueNonNull("acl[2].targets.Value()[2].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[2].targets.Value()[2].cluster.Value()", iter_3.GetValue().cluster.Value(), 18UL));
                        VerifyOrReturn(CheckValueNonNull("acl[2].targets.Value()[2].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[2].targets.Value()[2].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 19U));
                        VerifyOrReturn(CheckValueNull("acl[2].targets.Value()[2].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(
                            CheckNoMoreListItems<decltype(iter_0.GetValue().targets.Value())>("acl[2].targets.Value()", iter_3, 3));
                    }
                    VerifyOrReturn(CheckValue("acl[2].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acl", iter_0, 3));
                }
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>
                    value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 0));
                    VerifyOrReturn(CheckValue("acl[0].privilege", iter_0.GetValue().privilege, 5U));
                    VerifyOrReturn(CheckValue("acl[0].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNull("acl[0].subjects", iter_0.GetValue().subjects));
                    VerifyOrReturn(CheckValueNull("acl[0].targets", iter_0.GetValue().targets));
                    VerifyOrReturn(CheckValue("acl[0].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 1));
                    VerifyOrReturn(CheckValue("acl[1].privilege", iter_0.GetValue().privilege, 1U));
                    VerifyOrReturn(CheckValue("acl[1].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNull("acl[1].subjects", iter_0.GetValue().subjects));
                    VerifyOrReturn(CheckValueNull("acl[1].targets", iter_0.GetValue().targets));
                    VerifyOrReturn(CheckValue("acl[1].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acl", iter_0, 2));
                }
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>
                    value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 0));
                    VerifyOrReturn(CheckValue("acl[0].privilege", iter_0.GetValue().privilege, 5U));
                    VerifyOrReturn(CheckValue("acl[0].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNull("acl[0].subjects", iter_0.GetValue().subjects));
                    VerifyOrReturn(CheckValueNull("acl[0].targets", iter_0.GetValue().targets));
                    VerifyOrReturn(CheckValue("acl[0].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acl", iter_0, 1));
                }
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>
                    value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 0));
                    VerifyOrReturn(CheckValue("acl[0].privilege", iter_0.GetValue().privilege, 5U));
                    VerifyOrReturn(CheckValue("acl[0].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNull("acl[0].subjects", iter_0.GetValue().subjects));
                    VerifyOrReturn(CheckValueNull("acl[0].targets", iter_0.GetValue().targets));
                    VerifyOrReturn(CheckValue("acl[0].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acl", iter_0, 1));
                }
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>
                    value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 0));
                    VerifyOrReturn(CheckValue("acl[0].privilege", iter_0.GetValue().privilege, 5U));
                    VerifyOrReturn(CheckValue("acl[0].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNull("acl[0].subjects", iter_0.GetValue().subjects));
                    VerifyOrReturn(CheckValueNull("acl[0].targets", iter_0.GetValue().targets));
                    VerifyOrReturn(CheckValue("acl[0].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acl", iter_0, 1));
                }
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_CONSTRAINT_ERROR));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>
                    value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 0));
                    VerifyOrReturn(CheckValue("acl[0].privilege", iter_0.GetValue().privilege, 5U));
                    VerifyOrReturn(CheckValue("acl[0].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNull("acl[0].subjects", iter_0.GetValue().subjects));
                    VerifyOrReturn(CheckValueNull("acl[0].targets", iter_0.GetValue().targets));
                    VerifyOrReturn(CheckValue("acl[0].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acl", iter_0, 1));
                }
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_FAILURE));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>
                    value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 0));
                    VerifyOrReturn(CheckValue("acl[0].privilege", iter_0.GetValue().privilege, 5U));
                    VerifyOrReturn(CheckValue("acl[0].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNull("acl[0].subjects", iter_0.GetValue().subjects));
                    VerifyOrReturn(CheckValueNull("acl[0].targets", iter_0.GetValue().targets));
                    VerifyOrReturn(CheckValue("acl[0].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acl", iter_0, 1));
                }
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_FAILURE));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>
                    value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 0));
                    VerifyOrReturn(CheckValue("acl[0].privilege", iter_0.GetValue().privilege, 5U));
                    VerifyOrReturn(CheckValue("acl[0].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNull("acl[0].subjects", iter_0.GetValue().subjects));
                    VerifyOrReturn(CheckValueNull("acl[0].targets", iter_0.GetValue().targets));
                    VerifyOrReturn(CheckValue("acl[0].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acl", iter_0, 1));
                }
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_RESOURCE_EXHAUSTED));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>
                    value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 0));
                    VerifyOrReturn(CheckValue("acl[0].privilege", iter_0.GetValue().privilege, 5U));
                    VerifyOrReturn(CheckValue("acl[0].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNull("acl[0].subjects", iter_0.GetValue().subjects));
                    VerifyOrReturn(CheckValueNonNull("acl[0].targets", iter_0.GetValue().targets));
                    {
                        auto iter_3 = iter_0.GetValue().targets.Value().begin();
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[0].targets.Value()", iter_3, 0));
                        VerifyOrReturn(CheckValueNull("acl[0].targets.Value()[0].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(CheckValueNonNull("acl[0].targets.Value()[0].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[0].targets.Value()[0].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 0U));
                        VerifyOrReturn(CheckValueNull("acl[0].targets.Value()[0].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[0].targets.Value()", iter_3, 1));
                        VerifyOrReturn(CheckValueNonNull("acl[0].targets.Value()[1].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[0].targets.Value()[1].cluster.Value()", iter_3.GetValue().cluster.Value(), 1UL));
                        VerifyOrReturn(CheckValueNull("acl[0].targets.Value()[1].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(CheckValueNull("acl[0].targets.Value()[1].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[0].targets.Value()", iter_3, 2));
                        VerifyOrReturn(CheckValueNonNull("acl[0].targets.Value()[2].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[0].targets.Value()[2].cluster.Value()", iter_3.GetValue().cluster.Value(), 2UL));
                        VerifyOrReturn(CheckValueNonNull("acl[0].targets.Value()[2].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[0].targets.Value()[2].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 3U));
                        VerifyOrReturn(CheckValueNull("acl[0].targets.Value()[2].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(
                            CheckNoMoreListItems<decltype(iter_0.GetValue().targets.Value())>("acl[0].targets.Value()", iter_3, 3));
                    }
                    VerifyOrReturn(CheckValue("acl[0].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 1));
                    VerifyOrReturn(CheckValue("acl[1].privilege", iter_0.GetValue().privilege, 1U));
                    VerifyOrReturn(CheckValue("acl[1].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNonNull("acl[1].subjects", iter_0.GetValue().subjects));
                    {
                        auto iter_3 = iter_0.GetValue().subjects.Value().begin();
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[1].subjects.Value()", iter_3, 0));
                        VerifyOrReturn(CheckValue("acl[1].subjects.Value()[0]", iter_3.GetValue(), 4ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[1].subjects.Value()", iter_3, 1));
                        VerifyOrReturn(CheckValue("acl[1].subjects.Value()[1]", iter_3.GetValue(), 5ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[1].subjects.Value()", iter_3, 2));
                        VerifyOrReturn(CheckValue("acl[1].subjects.Value()[2]", iter_3.GetValue(), 6ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[1].subjects.Value()", iter_3, 3));
                        VerifyOrReturn(CheckValue("acl[1].subjects.Value()[3]", iter_3.GetValue(), 7ULL));
                        VerifyOrReturn(CheckNoMoreListItems<decltype(iter_0.GetValue().subjects.Value())>("acl[1].subjects.Value()",
                                                                                                          iter_3, 4));
                    }
                    VerifyOrReturn(CheckValueNonNull("acl[1].targets", iter_0.GetValue().targets));
                    {
                        auto iter_3 = iter_0.GetValue().targets.Value().begin();
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[1].targets.Value()", iter_3, 0));
                        VerifyOrReturn(CheckValueNull("acl[1].targets.Value()[0].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(CheckValueNonNull("acl[1].targets.Value()[0].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[1].targets.Value()[0].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 8U));
                        VerifyOrReturn(CheckValueNull("acl[1].targets.Value()[0].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[1].targets.Value()", iter_3, 1));
                        VerifyOrReturn(CheckValueNonNull("acl[1].targets.Value()[1].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[1].targets.Value()[1].cluster.Value()", iter_3.GetValue().cluster.Value(), 9UL));
                        VerifyOrReturn(CheckValueNull("acl[1].targets.Value()[1].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(CheckValueNull("acl[1].targets.Value()[1].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[1].targets.Value()", iter_3, 2));
                        VerifyOrReturn(CheckValueNonNull("acl[1].targets.Value()[2].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[1].targets.Value()[2].cluster.Value()", iter_3.GetValue().cluster.Value(), 10UL));
                        VerifyOrReturn(CheckValueNonNull("acl[1].targets.Value()[2].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[1].targets.Value()[2].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 11U));
                        VerifyOrReturn(CheckValueNull("acl[1].targets.Value()[2].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(
                            CheckNoMoreListItems<decltype(iter_0.GetValue().targets.Value())>("acl[1].targets.Value()", iter_3, 3));
                    }
                    VerifyOrReturn(CheckValue("acl[1].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 2));
                    VerifyOrReturn(CheckValue("acl[2].privilege", iter_0.GetValue().privilege, 3U));
                    VerifyOrReturn(CheckValue("acl[2].authMode", iter_0.GetValue().authMode, 3U));
                    VerifyOrReturn(CheckValueNonNull("acl[2].subjects", iter_0.GetValue().subjects));
                    {
                        auto iter_3 = iter_0.GetValue().subjects.Value().begin();
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[2].subjects.Value()", iter_3, 0));
                        VerifyOrReturn(CheckValue("acl[2].subjects.Value()[0]", iter_3.GetValue(), 12ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[2].subjects.Value()", iter_3, 1));
                        VerifyOrReturn(CheckValue("acl[2].subjects.Value()[1]", iter_3.GetValue(), 13ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[2].subjects.Value()", iter_3, 2));
                        VerifyOrReturn(CheckValue("acl[2].subjects.Value()[2]", iter_3.GetValue(), 14ULL));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().subjects.Value())>(
                            "acl[2].subjects.Value()", iter_3, 3));
                        VerifyOrReturn(CheckValue("acl[2].subjects.Value()[3]", iter_3.GetValue(), 15ULL));
                        VerifyOrReturn(CheckNoMoreListItems<decltype(iter_0.GetValue().subjects.Value())>("acl[2].subjects.Value()",
                                                                                                          iter_3, 4));
                    }
                    VerifyOrReturn(CheckValueNonNull("acl[2].targets", iter_0.GetValue().targets));
                    {
                        auto iter_3 = iter_0.GetValue().targets.Value().begin();
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[2].targets.Value()", iter_3, 0));
                        VerifyOrReturn(CheckValueNull("acl[2].targets.Value()[0].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(CheckValueNonNull("acl[2].targets.Value()[0].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[2].targets.Value()[0].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 16U));
                        VerifyOrReturn(CheckValueNull("acl[2].targets.Value()[0].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[2].targets.Value()", iter_3, 1));
                        VerifyOrReturn(CheckValueNonNull("acl[2].targets.Value()[1].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[2].targets.Value()[1].cluster.Value()", iter_3.GetValue().cluster.Value(), 17UL));
                        VerifyOrReturn(CheckValueNull("acl[2].targets.Value()[1].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(CheckValueNull("acl[2].targets.Value()[1].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(CheckNextListItemDecodes<decltype(iter_0.GetValue().targets.Value())>(
                            "acl[2].targets.Value()", iter_3, 2));
                        VerifyOrReturn(CheckValueNonNull("acl[2].targets.Value()[2].cluster", iter_3.GetValue().cluster));
                        VerifyOrReturn(
                            CheckValue("acl[2].targets.Value()[2].cluster.Value()", iter_3.GetValue().cluster.Value(), 18UL));
                        VerifyOrReturn(CheckValueNonNull("acl[2].targets.Value()[2].endpoint", iter_3.GetValue().endpoint));
                        VerifyOrReturn(
                            CheckValue("acl[2].targets.Value()[2].endpoint.Value()", iter_3.GetValue().endpoint.Value(), 19U));
                        VerifyOrReturn(CheckValueNull("acl[2].targets.Value()[2].deviceType", iter_3.GetValue().deviceType));
                        VerifyOrReturn(
                            CheckNoMoreListItems<decltype(iter_0.GetValue().targets.Value())>("acl[2].targets.Value()", iter_3, 3));
                    }
                    VerifyOrReturn(CheckValue("acl[2].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acl", iter_0, 3));
                }
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::DecodableType>
                    value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acl", iter_0, 0));
                    VerifyOrReturn(CheckValue("acl[0].privilege", iter_0.GetValue().privilege, 5U));
                    VerifyOrReturn(CheckValue("acl[0].authMode", iter_0.GetValue().authMode, 2U));
                    VerifyOrReturn(CheckValueNull("acl[0].subjects", iter_0.GetValue().subjects));
                    VerifyOrReturn(CheckValueNull("acl[0].targets", iter_0.GetValue().targets));
                    VerifyOrReturn(CheckValue("acl[0].fabricIndex", iter_0.GetValue().fabricIndex, 1U));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acl", iter_0, 1));
                }
            }
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 4U));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 3U));
            }
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 3U));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for commissionee");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Write entries");
            ListFreer listFreer;
            chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type> value;

            {
                auto * listHolder_0 = new ListHolder<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(3);
                listFreer.add(listHolder_0);

                listHolder_0->mList[0].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(5);
                listHolder_0->mList[0].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[0].subjects.SetNull();
                listHolder_0->mList[0].targets.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<chip::app::Clusters::AccessControl::Structs::Target::Type>(3);
                    listFreer.add(listHolder_3);

                    listHolder_3->mList[0].cluster.SetNull();
                    listHolder_3->mList[0].endpoint.SetNonNull();
                    listHolder_3->mList[0].endpoint.Value() = 0U;
                    listHolder_3->mList[0].deviceType.SetNull();

                    listHolder_3->mList[1].cluster.SetNonNull();
                    listHolder_3->mList[1].cluster.Value() = 1UL;
                    listHolder_3->mList[1].endpoint.SetNull();
                    listHolder_3->mList[1].deviceType.SetNull();

                    listHolder_3->mList[2].cluster.SetNonNull();
                    listHolder_3->mList[2].cluster.Value() = 2UL;
                    listHolder_3->mList[2].endpoint.SetNonNull();
                    listHolder_3->mList[2].endpoint.Value() = 3U;
                    listHolder_3->mList[2].deviceType.SetNull();

                    listHolder_0->mList[0].targets.Value() =
                        chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::Target::Type>(listHolder_3->mList,
                                                                                                              3);
                }
                listHolder_0->mList[0].fabricIndex = 0U;

                listHolder_0->mList[1].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(1);
                listHolder_0->mList[1].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[1].subjects.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<uint64_t>(4);
                    listFreer.add(listHolder_3);
                    listHolder_3->mList[0]                  = 4ULL;
                    listHolder_3->mList[1]                  = 5ULL;
                    listHolder_3->mList[2]                  = 6ULL;
                    listHolder_3->mList[3]                  = 7ULL;
                    listHolder_0->mList[1].subjects.Value() = chip::app::DataModel::List<uint64_t>(listHolder_3->mList, 4);
                }
                listHolder_0->mList[1].targets.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<chip::app::Clusters::AccessControl::Structs::Target::Type>(3);
                    listFreer.add(listHolder_3);

                    listHolder_3->mList[0].cluster.SetNull();
                    listHolder_3->mList[0].endpoint.SetNonNull();
                    listHolder_3->mList[0].endpoint.Value() = 8U;
                    listHolder_3->mList[0].deviceType.SetNull();

                    listHolder_3->mList[1].cluster.SetNonNull();
                    listHolder_3->mList[1].cluster.Value() = 9UL;
                    listHolder_3->mList[1].endpoint.SetNull();
                    listHolder_3->mList[1].deviceType.SetNull();

                    listHolder_3->mList[2].cluster.SetNonNull();
                    listHolder_3->mList[2].cluster.Value() = 10UL;
                    listHolder_3->mList[2].endpoint.SetNonNull();
                    listHolder_3->mList[2].endpoint.Value() = 11U;
                    listHolder_3->mList[2].deviceType.SetNull();

                    listHolder_0->mList[1].targets.Value() =
                        chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::Target::Type>(listHolder_3->mList,
                                                                                                              3);
                }
                listHolder_0->mList[1].fabricIndex = 0U;

                listHolder_0->mList[2].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(3);
                listHolder_0->mList[2].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(3);
                listHolder_0->mList[2].subjects.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<uint64_t>(4);
                    listFreer.add(listHolder_3);
                    listHolder_3->mList[0]                  = 12ULL;
                    listHolder_3->mList[1]                  = 13ULL;
                    listHolder_3->mList[2]                  = 14ULL;
                    listHolder_3->mList[3]                  = 15ULL;
                    listHolder_0->mList[2].subjects.Value() = chip::app::DataModel::List<uint64_t>(listHolder_3->mList, 4);
                }
                listHolder_0->mList[2].targets.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<chip::app::Clusters::AccessControl::Structs::Target::Type>(3);
                    listFreer.add(listHolder_3);

                    listHolder_3->mList[0].cluster.SetNull();
                    listHolder_3->mList[0].endpoint.SetNonNull();
                    listHolder_3->mList[0].endpoint.Value() = 16U;
                    listHolder_3->mList[0].deviceType.SetNull();

                    listHolder_3->mList[1].cluster.SetNonNull();
                    listHolder_3->mList[1].cluster.Value() = 17UL;
                    listHolder_3->mList[1].endpoint.SetNull();
                    listHolder_3->mList[1].deviceType.SetNull();

                    listHolder_3->mList[2].cluster.SetNonNull();
                    listHolder_3->mList[2].cluster.Value() = 18UL;
                    listHolder_3->mList[2].endpoint.SetNonNull();
                    listHolder_3->mList[2].endpoint.Value() = 19U;
                    listHolder_3->mList[2].deviceType.SetNull();

                    listHolder_0->mList[2].targets.Value() =
                        chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::Target::Type>(listHolder_3->mList,
                                                                                                              3);
                }
                listHolder_0->mList[2].fabricIndex = 0U;

                value = chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(
                    listHolder_0->mList, 3);
            }
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Verify");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Write entries empty lists");
            ListFreer listFreer;
            chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type> value;

            {
                auto * listHolder_0 = new ListHolder<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(2);
                listFreer.add(listHolder_0);

                listHolder_0->mList[0].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(5);
                listHolder_0->mList[0].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[0].subjects.SetNull();
                listHolder_0->mList[0].targets.SetNull();
                listHolder_0->mList[0].fabricIndex = 0U;

                listHolder_0->mList[1].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(1);
                listHolder_0->mList[1].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[1].subjects.SetNonNull();

                listHolder_0->mList[1].subjects.Value() = chip::app::DataModel::List<uint64_t>();
                listHolder_0->mList[1].targets.SetNonNull();

                listHolder_0->mList[1].targets.Value() =
                    chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::Target::Type>();
                listHolder_0->mList[1].fabricIndex = 0U;

                value = chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(
                    listHolder_0->mList, 2);
            }
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Verify");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Write entry invalid privilege");
            ListFreer listFreer;
            chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type> value;

            {
                auto * listHolder_0 = new ListHolder<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(2);
                listFreer.add(listHolder_0);

                listHolder_0->mList[0].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(5);
                listHolder_0->mList[0].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[0].subjects.SetNull();
                listHolder_0->mList[0].targets.SetNull();
                listHolder_0->mList[0].fabricIndex = 0U;

                listHolder_0->mList[1].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(5);
                listHolder_0->mList[1].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(3);
                listHolder_0->mList[1].subjects.SetNull();
                listHolder_0->mList[1].targets.SetNull();
                listHolder_0->mList[1].fabricIndex = 0U;

                value = chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(
                    listHolder_0->mList, 2);
            }
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Verify");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, true,
                                 chip::NullOptional);
        }
        case 7: {
            LogStep(7, "Write entry invalid auth mode");
            ListFreer listFreer;
            chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type> value;

            {
                auto * listHolder_0 = new ListHolder<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(2);
                listFreer.add(listHolder_0);

                listHolder_0->mList[0].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(5);
                listHolder_0->mList[0].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[0].subjects.SetNull();
                listHolder_0->mList[0].targets.SetNull();
                listHolder_0->mList[0].fabricIndex = 0U;

                listHolder_0->mList[1].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(1);
                listHolder_0->mList[1].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(1);
                listHolder_0->mList[1].subjects.SetNull();
                listHolder_0->mList[1].targets.SetNull();
                listHolder_0->mList[1].fabricIndex = 0U;

                value = chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(
                    listHolder_0->mList, 2);
            }
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Verify");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, true,
                                 chip::NullOptional);
        }
        case 9: {
            LogStep(9, "Write entry invalid subject");
            ListFreer listFreer;
            chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type> value;

            {
                auto * listHolder_0 = new ListHolder<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(2);
                listFreer.add(listHolder_0);

                listHolder_0->mList[0].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(5);
                listHolder_0->mList[0].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[0].subjects.SetNull();
                listHolder_0->mList[0].targets.SetNull();
                listHolder_0->mList[0].fabricIndex = 0U;

                listHolder_0->mList[1].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(1);
                listHolder_0->mList[1].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[1].subjects.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<uint64_t>(1);
                    listFreer.add(listHolder_3);
                    listHolder_3->mList[0]                  = 0ULL;
                    listHolder_0->mList[1].subjects.Value() = chip::app::DataModel::List<uint64_t>(listHolder_3->mList, 1);
                }
                listHolder_0->mList[1].targets.SetNull();
                listHolder_0->mList[1].fabricIndex = 0U;

                value = chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(
                    listHolder_0->mList, 2);
            }
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Verify");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, true,
                                 chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Write entry invalid target");
            ListFreer listFreer;
            chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type> value;

            {
                auto * listHolder_0 = new ListHolder<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(2);
                listFreer.add(listHolder_0);

                listHolder_0->mList[0].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(5);
                listHolder_0->mList[0].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[0].subjects.SetNull();
                listHolder_0->mList[0].targets.SetNull();
                listHolder_0->mList[0].fabricIndex = 0U;

                listHolder_0->mList[1].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(1);
                listHolder_0->mList[1].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[1].subjects.SetNull();
                listHolder_0->mList[1].targets.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<chip::app::Clusters::AccessControl::Structs::Target::Type>(1);
                    listFreer.add(listHolder_3);

                    listHolder_3->mList[0].cluster.SetNull();
                    listHolder_3->mList[0].endpoint.SetNull();
                    listHolder_3->mList[0].deviceType.SetNull();

                    listHolder_0->mList[1].targets.Value() =
                        chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::Target::Type>(listHolder_3->mList,
                                                                                                              1);
                }
                listHolder_0->mList[1].fabricIndex = 0U;

                value = chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(
                    listHolder_0->mList, 2);
            }
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 12: {
            LogStep(12, "Verify");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, true,
                                 chip::NullOptional);
        }
        case 13: {
            LogStep(13, "Write entry too many subjects");
            ListFreer listFreer;
            chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type> value;

            {
                auto * listHolder_0 = new ListHolder<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(2);
                listFreer.add(listHolder_0);

                listHolder_0->mList[0].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(5);
                listHolder_0->mList[0].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[0].subjects.SetNull();
                listHolder_0->mList[0].targets.SetNull();
                listHolder_0->mList[0].fabricIndex = 0U;

                listHolder_0->mList[1].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(1);
                listHolder_0->mList[1].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[1].subjects.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<uint64_t>(20);
                    listFreer.add(listHolder_3);
                    listHolder_3->mList[0]                  = 1ULL;
                    listHolder_3->mList[1]                  = 2ULL;
                    listHolder_3->mList[2]                  = 3ULL;
                    listHolder_3->mList[3]                  = 4ULL;
                    listHolder_3->mList[4]                  = 5ULL;
                    listHolder_3->mList[5]                  = 6ULL;
                    listHolder_3->mList[6]                  = 7ULL;
                    listHolder_3->mList[7]                  = 8ULL;
                    listHolder_3->mList[8]                  = 9ULL;
                    listHolder_3->mList[9]                  = 10ULL;
                    listHolder_3->mList[10]                 = 11ULL;
                    listHolder_3->mList[11]                 = 12ULL;
                    listHolder_3->mList[12]                 = 13ULL;
                    listHolder_3->mList[13]                 = 14ULL;
                    listHolder_3->mList[14]                 = 15ULL;
                    listHolder_3->mList[15]                 = 16ULL;
                    listHolder_3->mList[16]                 = 17ULL;
                    listHolder_3->mList[17]                 = 18ULL;
                    listHolder_3->mList[18]                 = 19ULL;
                    listHolder_3->mList[19]                 = 20ULL;
                    listHolder_0->mList[1].subjects.Value() = chip::app::DataModel::List<uint64_t>(listHolder_3->mList, 20);
                }
                listHolder_0->mList[1].targets.SetNull();
                listHolder_0->mList[1].fabricIndex = 0U;

                value = chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(
                    listHolder_0->mList, 2);
            }
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "Verify");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, true,
                                 chip::NullOptional);
        }
        case 15: {
            LogStep(15, "Write entry too many targets");
            ListFreer listFreer;
            chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type> value;

            {
                auto * listHolder_0 = new ListHolder<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(2);
                listFreer.add(listHolder_0);

                listHolder_0->mList[0].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(5);
                listHolder_0->mList[0].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[0].subjects.SetNull();
                listHolder_0->mList[0].targets.SetNull();
                listHolder_0->mList[0].fabricIndex = 0U;

                listHolder_0->mList[1].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(1);
                listHolder_0->mList[1].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[1].subjects.SetNull();
                listHolder_0->mList[1].targets.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<chip::app::Clusters::AccessControl::Structs::Target::Type>(20);
                    listFreer.add(listHolder_3);

                    listHolder_3->mList[0].cluster.SetNull();
                    listHolder_3->mList[0].endpoint.SetNonNull();
                    listHolder_3->mList[0].endpoint.Value() = 1U;
                    listHolder_3->mList[0].deviceType.SetNull();

                    listHolder_3->mList[1].cluster.SetNull();
                    listHolder_3->mList[1].endpoint.SetNonNull();
                    listHolder_3->mList[1].endpoint.Value() = 2U;
                    listHolder_3->mList[1].deviceType.SetNull();

                    listHolder_3->mList[2].cluster.SetNull();
                    listHolder_3->mList[2].endpoint.SetNonNull();
                    listHolder_3->mList[2].endpoint.Value() = 3U;
                    listHolder_3->mList[2].deviceType.SetNull();

                    listHolder_3->mList[3].cluster.SetNull();
                    listHolder_3->mList[3].endpoint.SetNonNull();
                    listHolder_3->mList[3].endpoint.Value() = 4U;
                    listHolder_3->mList[3].deviceType.SetNull();

                    listHolder_3->mList[4].cluster.SetNull();
                    listHolder_3->mList[4].endpoint.SetNonNull();
                    listHolder_3->mList[4].endpoint.Value() = 5U;
                    listHolder_3->mList[4].deviceType.SetNull();

                    listHolder_3->mList[5].cluster.SetNull();
                    listHolder_3->mList[5].endpoint.SetNonNull();
                    listHolder_3->mList[5].endpoint.Value() = 6U;
                    listHolder_3->mList[5].deviceType.SetNull();

                    listHolder_3->mList[6].cluster.SetNull();
                    listHolder_3->mList[6].endpoint.SetNonNull();
                    listHolder_3->mList[6].endpoint.Value() = 7U;
                    listHolder_3->mList[6].deviceType.SetNull();

                    listHolder_3->mList[7].cluster.SetNull();
                    listHolder_3->mList[7].endpoint.SetNonNull();
                    listHolder_3->mList[7].endpoint.Value() = 8U;
                    listHolder_3->mList[7].deviceType.SetNull();

                    listHolder_3->mList[8].cluster.SetNull();
                    listHolder_3->mList[8].endpoint.SetNonNull();
                    listHolder_3->mList[8].endpoint.Value() = 9U;
                    listHolder_3->mList[8].deviceType.SetNull();

                    listHolder_3->mList[9].cluster.SetNull();
                    listHolder_3->mList[9].endpoint.SetNonNull();
                    listHolder_3->mList[9].endpoint.Value() = 10U;
                    listHolder_3->mList[9].deviceType.SetNull();

                    listHolder_3->mList[10].cluster.SetNull();
                    listHolder_3->mList[10].endpoint.SetNonNull();
                    listHolder_3->mList[10].endpoint.Value() = 11U;
                    listHolder_3->mList[10].deviceType.SetNull();

                    listHolder_3->mList[11].cluster.SetNull();
                    listHolder_3->mList[11].endpoint.SetNonNull();
                    listHolder_3->mList[11].endpoint.Value() = 12U;
                    listHolder_3->mList[11].deviceType.SetNull();

                    listHolder_3->mList[12].cluster.SetNull();
                    listHolder_3->mList[12].endpoint.SetNonNull();
                    listHolder_3->mList[12].endpoint.Value() = 13U;
                    listHolder_3->mList[12].deviceType.SetNull();

                    listHolder_3->mList[13].cluster.SetNull();
                    listHolder_3->mList[13].endpoint.SetNonNull();
                    listHolder_3->mList[13].endpoint.Value() = 14U;
                    listHolder_3->mList[13].deviceType.SetNull();

                    listHolder_3->mList[14].cluster.SetNull();
                    listHolder_3->mList[14].endpoint.SetNonNull();
                    listHolder_3->mList[14].endpoint.Value() = 15U;
                    listHolder_3->mList[14].deviceType.SetNull();

                    listHolder_3->mList[15].cluster.SetNull();
                    listHolder_3->mList[15].endpoint.SetNonNull();
                    listHolder_3->mList[15].endpoint.Value() = 16U;
                    listHolder_3->mList[15].deviceType.SetNull();

                    listHolder_3->mList[16].cluster.SetNull();
                    listHolder_3->mList[16].endpoint.SetNonNull();
                    listHolder_3->mList[16].endpoint.Value() = 17U;
                    listHolder_3->mList[16].deviceType.SetNull();

                    listHolder_3->mList[17].cluster.SetNull();
                    listHolder_3->mList[17].endpoint.SetNonNull();
                    listHolder_3->mList[17].endpoint.Value() = 18U;
                    listHolder_3->mList[17].deviceType.SetNull();

                    listHolder_3->mList[18].cluster.SetNull();
                    listHolder_3->mList[18].endpoint.SetNonNull();
                    listHolder_3->mList[18].endpoint.Value() = 19U;
                    listHolder_3->mList[18].deviceType.SetNull();

                    listHolder_3->mList[19].cluster.SetNull();
                    listHolder_3->mList[19].endpoint.SetNonNull();
                    listHolder_3->mList[19].endpoint.Value() = 20U;
                    listHolder_3->mList[19].deviceType.SetNull();

                    listHolder_0->mList[1].targets.Value() =
                        chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::Target::Type>(listHolder_3->mList,
                                                                                                              20);
                }
                listHolder_0->mList[1].fabricIndex = 0U;

                value = chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(
                    listHolder_0->mList, 2);
            }
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 16: {
            LogStep(16, "Verify");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, true,
                                 chip::NullOptional);
        }
        case 17: {
            LogStep(17, "Write too many entries");
            ListFreer listFreer;
            chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type> value;

            {
                auto * listHolder_0 = new ListHolder<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(4);
                listFreer.add(listHolder_0);

                listHolder_0->mList[0].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(5);
                listHolder_0->mList[0].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[0].subjects.SetNull();
                listHolder_0->mList[0].targets.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<chip::app::Clusters::AccessControl::Structs::Target::Type>(3);
                    listFreer.add(listHolder_3);

                    listHolder_3->mList[0].cluster.SetNull();
                    listHolder_3->mList[0].endpoint.SetNonNull();
                    listHolder_3->mList[0].endpoint.Value() = 0U;
                    listHolder_3->mList[0].deviceType.SetNull();

                    listHolder_3->mList[1].cluster.SetNonNull();
                    listHolder_3->mList[1].cluster.Value() = 1UL;
                    listHolder_3->mList[1].endpoint.SetNull();
                    listHolder_3->mList[1].deviceType.SetNull();

                    listHolder_3->mList[2].cluster.SetNonNull();
                    listHolder_3->mList[2].cluster.Value() = 2UL;
                    listHolder_3->mList[2].endpoint.SetNonNull();
                    listHolder_3->mList[2].endpoint.Value() = 3U;
                    listHolder_3->mList[2].deviceType.SetNull();

                    listHolder_0->mList[0].targets.Value() =
                        chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::Target::Type>(listHolder_3->mList,
                                                                                                              3);
                }
                listHolder_0->mList[0].fabricIndex = 0U;

                listHolder_0->mList[1].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(1);
                listHolder_0->mList[1].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[1].subjects.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<uint64_t>(4);
                    listFreer.add(listHolder_3);
                    listHolder_3->mList[0]                  = 4ULL;
                    listHolder_3->mList[1]                  = 5ULL;
                    listHolder_3->mList[2]                  = 6ULL;
                    listHolder_3->mList[3]                  = 7ULL;
                    listHolder_0->mList[1].subjects.Value() = chip::app::DataModel::List<uint64_t>(listHolder_3->mList, 4);
                }
                listHolder_0->mList[1].targets.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<chip::app::Clusters::AccessControl::Structs::Target::Type>(3);
                    listFreer.add(listHolder_3);

                    listHolder_3->mList[0].cluster.SetNull();
                    listHolder_3->mList[0].endpoint.SetNonNull();
                    listHolder_3->mList[0].endpoint.Value() = 8U;
                    listHolder_3->mList[0].deviceType.SetNull();

                    listHolder_3->mList[1].cluster.SetNonNull();
                    listHolder_3->mList[1].cluster.Value() = 9UL;
                    listHolder_3->mList[1].endpoint.SetNull();
                    listHolder_3->mList[1].deviceType.SetNull();

                    listHolder_3->mList[2].cluster.SetNonNull();
                    listHolder_3->mList[2].cluster.Value() = 10UL;
                    listHolder_3->mList[2].endpoint.SetNonNull();
                    listHolder_3->mList[2].endpoint.Value() = 11U;
                    listHolder_3->mList[2].deviceType.SetNull();

                    listHolder_0->mList[1].targets.Value() =
                        chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::Target::Type>(listHolder_3->mList,
                                                                                                              3);
                }
                listHolder_0->mList[1].fabricIndex = 0U;

                listHolder_0->mList[2].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(3);
                listHolder_0->mList[2].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(3);
                listHolder_0->mList[2].subjects.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<uint64_t>(4);
                    listFreer.add(listHolder_3);
                    listHolder_3->mList[0]                  = 12ULL;
                    listHolder_3->mList[1]                  = 13ULL;
                    listHolder_3->mList[2]                  = 14ULL;
                    listHolder_3->mList[3]                  = 15ULL;
                    listHolder_0->mList[2].subjects.Value() = chip::app::DataModel::List<uint64_t>(listHolder_3->mList, 4);
                }
                listHolder_0->mList[2].targets.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<chip::app::Clusters::AccessControl::Structs::Target::Type>(3);
                    listFreer.add(listHolder_3);

                    listHolder_3->mList[0].cluster.SetNull();
                    listHolder_3->mList[0].endpoint.SetNonNull();
                    listHolder_3->mList[0].endpoint.Value() = 16U;
                    listHolder_3->mList[0].deviceType.SetNull();

                    listHolder_3->mList[1].cluster.SetNonNull();
                    listHolder_3->mList[1].cluster.Value() = 17UL;
                    listHolder_3->mList[1].endpoint.SetNull();
                    listHolder_3->mList[1].deviceType.SetNull();

                    listHolder_3->mList[2].cluster.SetNonNull();
                    listHolder_3->mList[2].cluster.Value() = 18UL;
                    listHolder_3->mList[2].endpoint.SetNonNull();
                    listHolder_3->mList[2].endpoint.Value() = 19U;
                    listHolder_3->mList[2].deviceType.SetNull();

                    listHolder_0->mList[2].targets.Value() =
                        chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::Target::Type>(listHolder_3->mList,
                                                                                                              3);
                }
                listHolder_0->mList[2].fabricIndex = 0U;

                listHolder_0->mList[3].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(1);
                listHolder_0->mList[3].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[3].subjects.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<uint64_t>(4);
                    listFreer.add(listHolder_3);
                    listHolder_3->mList[0]                  = 20ULL;
                    listHolder_3->mList[1]                  = 21ULL;
                    listHolder_3->mList[2]                  = 22ULL;
                    listHolder_3->mList[3]                  = 23ULL;
                    listHolder_0->mList[3].subjects.Value() = chip::app::DataModel::List<uint64_t>(listHolder_3->mList, 4);
                }
                listHolder_0->mList[3].targets.SetNonNull();

                {
                    auto * listHolder_3 = new ListHolder<chip::app::Clusters::AccessControl::Structs::Target::Type>(3);
                    listFreer.add(listHolder_3);

                    listHolder_3->mList[0].cluster.SetNull();
                    listHolder_3->mList[0].endpoint.SetNonNull();
                    listHolder_3->mList[0].endpoint.Value() = 24U;
                    listHolder_3->mList[0].deviceType.SetNull();

                    listHolder_3->mList[1].cluster.SetNonNull();
                    listHolder_3->mList[1].cluster.Value() = 25UL;
                    listHolder_3->mList[1].endpoint.SetNull();
                    listHolder_3->mList[1].deviceType.SetNull();

                    listHolder_3->mList[2].cluster.SetNonNull();
                    listHolder_3->mList[2].cluster.Value() = 26UL;
                    listHolder_3->mList[2].endpoint.SetNonNull();
                    listHolder_3->mList[2].endpoint.Value() = 27U;
                    listHolder_3->mList[2].deviceType.SetNull();

                    listHolder_0->mList[3].targets.Value() =
                        chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::Target::Type>(listHolder_3->mList,
                                                                                                              3);
                }
                listHolder_0->mList[3].fabricIndex = 0U;

                value = chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(
                    listHolder_0->mList, 4);
            }
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 18: {
            LogStep(18, "Verify");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, true,
                                 chip::NullOptional);
        }
        case 19: {
            LogStep(19, "Restore ACL");
            ListFreer listFreer;
            chip::app::DataModel::List<const chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type> value;

            {
                auto * listHolder_0 = new ListHolder<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(1);
                listFreer.add(listHolder_0);

                listHolder_0->mList[0].privilege = static_cast<chip::app::Clusters::AccessControl::Privilege>(5);
                listHolder_0->mList[0].authMode  = static_cast<chip::app::Clusters::AccessControl::AuthMode>(2);
                listHolder_0->mList[0].subjects.SetNull();
                listHolder_0->mList[0].targets.SetNull();
                listHolder_0->mList[0].fabricIndex = 0U;

                value = chip::app::DataModel::List<chip::app::Clusters::AccessControl::Structs::AccessControlEntry::Type>(
                    listHolder_0->mList, 1);
            }
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 20: {
            LogStep(20, "Verify");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::Acl::Id, true,
                                 chip::NullOptional);
        }
        case 21: {
            LogStep(21, "Validate resource minima (SubjectsPerAccessControlEntry)");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id,
                                 AccessControl::Attributes::SubjectsPerAccessControlEntry::Id, true, chip::NullOptional);
        }
        case 22: {
            LogStep(22, "Validate resource minima (TargetsPerAccessControlEntry)");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id,
                                 AccessControl::Attributes::TargetsPerAccessControlEntry::Id, true, chip::NullOptional);
        }
        case 23: {
            LogStep(23, "Validate resource minima (AccessControlEntriesPerFabric)");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id,
                                 AccessControl::Attributes::AccessControlEntriesPerFabric::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_ACL_1_1Suite : public TestCommand
{
public:
    Test_TC_ACL_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_ACL_1_1", 7, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_ACL_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acceptedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads ClusterRevision attribute from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::ClusterRevision::Id,
                                 true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads FeatureMap attribute from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH reads AttributeList attribute from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads optional attribute (Extension) in AttributeList");
            VerifyOrDo(!ShouldSkip("ACL.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id, AccessControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads AcceptedCommandList attribute from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id,
                                 AccessControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6, "TH reads GeneratedCommandList attribute from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id,
                                 AccessControl::Attributes::GeneratedCommandList::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_ACL_2_1Suite : public TestCommand
{
public:
    Test_TC_ACL_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_ACL_2_1", 4, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_ACL_2_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 4U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 3U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 3U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads SubjectsPerAccessControlEntry attribute from DUT");
            VerifyOrDo(!ShouldSkip("ACL.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id,
                                 AccessControl::Attributes::SubjectsPerAccessControlEntry::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads TargetsPerAccessControlEntry attribute from DUT");
            VerifyOrDo(!ShouldSkip("ACL.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id,
                                 AccessControl::Attributes::TargetsPerAccessControlEntry::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH reads AccessControlEntriesPerFabric attribute from DUT");
            VerifyOrDo(!ShouldSkip("ACL.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), AccessControl::Id,
                                 AccessControl::Attributes::AccessControlEntriesPerFabric::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_ACL_2_2Suite : public TestCommand
{
public:
    Test_TC_ACL_2_2Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_ACL_2_2", 3, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_ACL_2_2Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::ClusterId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 31UL));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH1 reads DUT Descriptor cluster ServerList attribute from Endpoint 0");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Descriptor::Id, Descriptor::Attributes::ServerList::Id, true,
                                 chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH1 reads DUT Descriptor cluster ServerList attribute from every Endpoint except 0");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message =
                chip::Span<const char>("Factory Reset the DUT and enter 'y' after successgarbage: not in length on purpose", 49);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_BOOL_1_1Suite : public TestCommand
{
public:
    Test_TC_BOOL_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_BOOL_1_1", 6, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_BOOL_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acceptedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "read the global attribute: ClusterRevision");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), BooleanState::Id, BooleanState::Attributes::ClusterRevision::Id,
                                 true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Read the global attribute: FeatureMap");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), BooleanState::Id, BooleanState::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Read the global attribute: AttributeList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), BooleanState::Id, BooleanState::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Read the global attribute: AcceptedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), BooleanState::Id,
                                 BooleanState::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Read the global attribute: GeneratedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), BooleanState::Id,
                                 BooleanState::Attributes::GeneratedCommandList::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_BOOL_2_1Suite : public TestCommand
{
public:
    Test_TC_BOOL_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_BOOL_2_1", 2, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_BOOL_2_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "boolean", "boolean"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Read mandatory non-global attribute: StateValue");
            VerifyOrDo(!ShouldSkip("BOOL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), BooleanState::Id, BooleanState::Attributes::StateValue::Id, true,
                                 chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_ACT_1_1Suite : public TestCommand
{
public:
    Test_TC_ACT_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_ACT_1_1", 7, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_ACT_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 11));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Read the global attribute: ClusterRevision");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Actions::Id, Actions::Attributes::ClusterRevision::Id, true,
                                 chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Read the global attribute: FeatureMap");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Actions::Id, Actions::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Read the global attribute: AttributeList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Actions::Id, Actions::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Read the optional attribute(SetupURL) in AttributeList");
            VerifyOrDo(!ShouldSkip("ACT.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Actions::Id, Actions::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Read the global attribute: AcceptedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Actions::Id, Actions::Attributes::AcceptedCommandList::Id, true,
                                 chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Read the global attribute: GeneratedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Actions::Id, Actions::Attributes::GeneratedCommandList::Id, true,
                                 chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_BIND_1_1Suite : public TestCommand
{
public:
    Test_TC_BIND_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_BIND_1_1", 6, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_BIND_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acceptedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads the ClusterRevision from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Binding::Id, Binding::Attributes::ClusterRevision::Id, true,
                                 chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads the FeatureMap from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Binding::Id, Binding::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH reads AttributeList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Binding::Id, Binding::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads AcceptedCommandList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Binding::Id, Binding::Attributes::AcceptedCommandList::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads GeneratedCommandList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Binding::Id, Binding::Attributes::GeneratedCommandList::Id, true,
                                 chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_1_1Suite : public TestCommand
{
public:
    Test_TC_CC_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_1_1", 47, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 5U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
                VerifyOrReturn(CheckConstraintHasMasksSet("value", value, 1UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
                VerifyOrReturn(CheckConstraintHasMasksSet("value", value, 2UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
                VerifyOrReturn(CheckConstraintHasMasksSet("value", value, 4UL));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
                VerifyOrReturn(CheckConstraintHasMasksSet("value", value, 8UL));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
                VerifyOrReturn(CheckConstraintHasMasksSet("value", value, 16UL));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 8UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 15UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 16385UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 16394UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 5UL));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 6UL));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 7UL));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16384UL));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16386UL));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16387UL));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16388UL));
            }
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16389UL));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16390UL));
            }
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16395UL));
            }
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16396UL));
            }
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16397UL));
            }
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16400UL));
            }
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
            }
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
            }
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
            }
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
            }
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
            }
            break;
        case 32:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 5UL));
            }
            break;
        case 33:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 6UL));
            }
            break;
        case 34:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 7UL));
            }
            break;
        case 35:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 8UL));
            }
            break;
        case 36:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 9UL));
            }
            break;
        case 37:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 10UL));
            }
            break;
        case 38:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 64UL));
            }
            break;
        case 39:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 65UL));
            }
            break;
        case 40:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 66UL));
            }
            break;
        case 41:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 67UL));
            }
            break;
        case 42:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 68UL));
            }
            break;
        case 43:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 71UL));
            }
            break;
        case 44:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 75UL));
            }
            break;
        case 45:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 76UL));
            }
            break;
        case 46:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "read the global attribute: ClusterRevision");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ClusterRevision::Id,
                                 true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Read the global attribute: FeatureMap");
            VerifyOrDo(!ShouldSkip("( !CC.S.F00 && !CC.S.F01 && !CC.S.F02 && !CC.S.F03 && !CC.S.F04 )"),
                       return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Given CC.S.F00(HS) ensure featuremap has the correct bit set");
            VerifyOrDo(!ShouldSkip("CC.S.F00"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Given CC.S.F01(EHue) ensure featuremap has the correct bit set");
            VerifyOrDo(!ShouldSkip("CC.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Given CC.S.F02(CL) ensure featuremap has the correct bit set");
            VerifyOrDo(!ShouldSkip("CC.S.F02"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Given CC.S.F03(XY) ensure featuremap has the correct bit set");
            VerifyOrDo(!ShouldSkip("CC.S.F03"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 7: {
            LogStep(7, "Given CC.S.F04(CT) ensure featuremap has the correct bit set");
            VerifyOrDo(!ShouldSkip("CC.S.F04"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Read the global attribute: AttributeList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 9: {
            LogStep(9, "Read the optional attribute(CurrentHue) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Read the optional attribute(CurrentSaturation) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Read the optional attribute(RemainingTime) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 12: {
            LogStep(12, "Read the optional attribute(CurrentX) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "Read the optional attribute(CurrentY) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "Read the optional attribute(DriftCompensation) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 15: {
            LogStep(15, "Read the optional attribute(CompensationText) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 16: {
            LogStep(16, "Read the optional attribute(ColorTemperatureMireds) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "Read the optional attribute(EnhancedCurrentHue) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A4000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 18: {
            LogStep(18, "Read the optional attribute(ColorLoopActive) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A4002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 19: {
            LogStep(19, "Read the optional attribute(ColorLoopDirection) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A4003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 20: {
            LogStep(20, "Read the optional attribute(ColorLoopTime) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A4004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 21: {
            LogStep(21, "Read the optional attribute(ColorLoopStartEnhancedHue) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A4005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 22: {
            LogStep(22, "Read the optional attribute(ColorLoopStoredEnhancedHue) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A4006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 23: {
            LogStep(23, "Read the optional attribute(ColorTempPhysicalMinMireds) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A400b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 24: {
            LogStep(24, "Read the optional attribute(ColorTempPhysicalMaxMireds) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A400c"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 25: {
            LogStep(25, "Read the optional attribute(CoupleColorTempToLevelMinMireds) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A400d"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 26: {
            LogStep(26, "Read the optional attribute(StartUpColorTemperatureMireds) in AttributeList");
            VerifyOrDo(!ShouldSkip("CC.S.A4010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 27: {
            LogStep(27, "Read the optional command(MoveToHue) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 28: {
            LogStep(28, "Read the optional command(MoveHue) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 29: {
            LogStep(29, "Read the optional command(StepHue) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C02.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 30: {
            LogStep(30, "Read the optional command(MoveToSaturation) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C03.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 31: {
            LogStep(31, "Read the optional command(MoveSaturation) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C04.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 32: {
            LogStep(32, "Read the optional command(StepSaturation) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C05.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 33: {
            LogStep(33, "Read the optional command(MoveToHueAndSaturation) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C06.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 34: {
            LogStep(34, "Read the optional command(MoveToColor) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 35: {
            LogStep(35, "Read the optional command(MoveColor) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 36: {
            LogStep(36, "Read the optional command(StepColor) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C09.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 37: {
            LogStep(37, "Read the optional command(MoveToColorTemperature) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C0a.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 38: {
            LogStep(38, "Read the optional command(EnhancedMoveToHue) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 39: {
            LogStep(39, "Read the optional command(EnhancedMoveHue) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 40: {
            LogStep(40, "Read the optional command(EnhancedStepHue) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C42.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 41: {
            LogStep(41, "Read the optional command(EnhancedMoveToHueAndSaturation) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C43.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 42: {
            LogStep(42, "Read the optional command(ColorLoopSet) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C44.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 43: {
            LogStep(43, "Read the optional command(StopMoveStep) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C47.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 44: {
            LogStep(44, "Read the optional command(MoveColorTemperature) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 45: {
            LogStep(45, "Read the optional command(StepColorTemperature) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("CC.S.C4c.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 46: {
            LogStep(46, "Read the global attribute: GeneratedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::GeneratedCommandList::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_2_1Suite : public TestCommand
{
public:
    Test_TC_CC_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_2_1", 54, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_2_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    uint32_t FeatureMapValue;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65534U));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 4U));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "char_string", "char_string"));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 254));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap8", "bitmap8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 4U));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65534U));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                FeatureMapValue = value;
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorCapabilities", value, FeatureMapValue));
                VerifyOrReturn(CheckConstraintType("value", "bitmap16", "bitmap16"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 31U));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 6U));
            }
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 32:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 33:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 34:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 35:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 36:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 37:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 38:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 39:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 40:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 41:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 42:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 43:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 44:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 45:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 46:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 47:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 255U));
            }
            break;
        case 48:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 49:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 50:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 255U));
            }
            break;
        case 51:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 52:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
            }
            break;
        case 53:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 255U));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH reads RemainingTime attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::RemainingTime::Id,
                                 true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 6: {
            LogStep(6, "TH reads DriftCompensation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::DriftCompensation::Id,
                                 true, chip::NullOptional);
        }
        case 7: {
            LogStep(7, "TH reads CompensationText attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CompensationText::Id,
                                 true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "TH reads ColorTemperatureMireds attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 9: {
            LogStep(9, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 10: {
            LogStep(10, "TH reads Options attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, true,
                                 chip::NullOptional);
        }
        case 11: {
            LogStep(11, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A4000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 12: {
            LogStep(12, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F02"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "TH reads ColorLoopActive attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A4002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorLoopActive::Id,
                                 true, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "TH reads ColorLoopDirection attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A4003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorLoopDirection::Id,
                                 true, chip::NullOptional);
        }
        case 15: {
            LogStep(15, "TH reads ColorLoopTime attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A4004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorLoopTime::Id,
                                 true, chip::NullOptional);
        }
        case 16: {
            LogStep(16, "TH reads ColorLoopStartEnhancedHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A4005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorLoopStartEnhancedHue::Id, true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "TH reads ColorLoopStoredEnhancedHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A4006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorLoopStoredEnhancedHue::Id, true, chip::NullOptional);
        }
        case 18: {
            LogStep(18, "Saving for comparision in step 19 reads FeatureMap attribute from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 19: {
            LogStep(19, "TH reads ColorCapabilities attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A400a"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorCapabilities::Id,
                                 true, chip::NullOptional);
        }
        case 20: {
            LogStep(20, "TH reads ColorTempPhysicalMinMireds attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A400b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTempPhysicalMinMireds::Id, true, chip::NullOptional);
        }
        case 21: {
            LogStep(21, "TH reads ColorTempPhysicalMaxMireds attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A400c"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTempPhysicalMaxMireds::Id, true, chip::NullOptional);
        }
        case 22: {
            LogStep(22, "TH reads CoupleColorTempToLevelMinMireds attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A400d"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::CoupleColorTempToLevelMinMireds::Id, true, chip::NullOptional);
        }
        case 23: {
            LogStep(23, "TH reads StartUpColorTemperatureMireds attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A4010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::StartUpColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 24: {
            LogStep(24, "TH reads NumberOfPrimaries attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::NumberOfPrimaries::Id,
                                 true, chip::NullOptional);
        }
        case 25: {
            LogStep(25,
                    "TH reads Primary1X attribute from DUT and Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] "
                    "if NumberOfPrimaries is 1 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0011"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 26: {
            LogStep(26,
                    "TH reads Primary1Y attribute from DUT and Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] "
                    "if NumberOfPrimaries is 1 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0012"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 27: {
            LogStep(27,
                    "TH reads Primary1Intensity attribute from DUT and Verify that the DUT response contains an uint8 if "
                    "NumberOfPrimaries is 1 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0013"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 28: {
            LogStep(28,
                    "TH reads Primary2X attribute from DUT and Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] "
                    "if NumberOfPrimaries is 2 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0015"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 29: {
            LogStep(29,
                    "TH reads Primary2Y attribute from DUT and Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] "
                    "if NumberOfPrimaries is 2 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0016"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 30: {
            LogStep(30,
                    "TH reads Primary2Intensity attribute from DUT and Verify that the DUT response contains an uint8 if "
                    "NumberOfPrimaries is 2 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0017"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 31: {
            LogStep(31,
                    "TH reads Primary3X attribute from DUT and Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] "
                    "if NumberOfPrimaries is 3 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0019"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 32: {
            LogStep(32,
                    "TH reads Primary3Y attribute from DUT and Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] "
                    "if NumberOfPrimaries is 3 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A001a"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 33: {
            LogStep(33,
                    "TH reads Primary3Intensity attribute from DUT and Verify that the DUT response contains an uint8 if "
                    "NumberOfPrimaries is 3 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A001b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 34: {
            LogStep(34,
                    "TH reads Primary4X attribute from DUT Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] if "
                    "NumberOfPrimaries is 4 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0020"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 35: {
            LogStep(35,
                    "TH reads Primary4Y attribute from DUT and Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] "
                    "if NumberOfPrimaries is 4 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0021"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 36: {
            LogStep(36,
                    "TH reads Primary4Intensity attribute from DUT and Verify that the DUT response contains an uint8 if "
                    "NumberOfPrimaries is 4 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0022"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 37: {
            LogStep(37,
                    "TH reads Primary5X attribute from DUT and Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] "
                    "if NumberOfPrimaries is 5 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0024"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 38: {
            LogStep(38,
                    "TH reads Primary5Y attribute from DUT and Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] "
                    "if NumberOfPrimaries is 5 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0025"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 39: {
            LogStep(39,
                    "TH reads Primary5Intensity attribute from DUT and Verify that the DUT response contains an uint8 if "
                    "NumberOfPrimaries is 5 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0026"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 40: {
            LogStep(40,
                    "TH reads Primary6X attribute from DUT and Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] "
                    "if NumberOfPrimaries is 6 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0028"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 41: {
            LogStep(41,
                    "TH reads Primary6Y attribute from DUT and Verify that the DUT response contains an uint16 [Min:0 Max:0xfeff] "
                    "if NumberOfPrimaries is 6 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A0029"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 42: {
            LogStep(42,
                    "TH reads Primary6Intensity attribute from DUT and Verify that the DUT response contains an uint8 if "
                    "NumberOfPrimaries is 6 or more");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && CC.S.A002a"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 43: {
            LogStep(43, "TH reads WhitePointX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0030"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::WhitePointX::Id, true,
                                 chip::NullOptional);
        }
        case 44: {
            LogStep(44, "TH reads WhitePointY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0031"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::WhitePointY::Id, true,
                                 chip::NullOptional);
        }
        case 45: {
            LogStep(45, "TH reads ColorPointRX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0032"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorPointRX::Id, true,
                                 chip::NullOptional);
        }
        case 46: {
            LogStep(46, "TH reads ColorPointRY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0033"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorPointRY::Id, true,
                                 chip::NullOptional);
        }
        case 47: {
            LogStep(47, "TH reads ColorPointRIntensity attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0034"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorPointRIntensity::Id, true, chip::NullOptional);
        }
        case 48: {
            LogStep(48, "TH reads ColorPointGX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0036"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorPointGX::Id, true,
                                 chip::NullOptional);
        }
        case 49: {
            LogStep(49, "TH reads ColorPointGY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0037"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorPointGY::Id, true,
                                 chip::NullOptional);
        }
        case 50: {
            LogStep(50, "TH reads ColorPointGIntensity attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0038"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorPointGIntensity::Id, true, chip::NullOptional);
        }
        case 51: {
            LogStep(51, "TH reads ColorPointBX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A003a"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorPointBX::Id, true,
                                 chip::NullOptional);
        }
        case 52: {
            LogStep(52, "TH reads ColorPointBY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A003b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorPointBY::Id, true,
                                 chip::NullOptional);
        }
        case 53: {
            LogStep(53, "TH reads ColorPointBIntensity attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A003c"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorPointBIntensity::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_3_2Suite : public TestCommand
{
public:
    Test_TC_CC_3_2Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_3_2", 31, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_3_2Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 215U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 255U));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 38U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 52U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 80U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 110U));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 80U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 110U));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 8U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 12U));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 183U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 247U));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 140U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 190U));
            }
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 140U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 190U));
            }
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3,
                    "TH sends MoveToHue command to DUT with Hue=200, Direction=0x00 (shortest distance) and TransitionTime=0 "
                    "(immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToHue::Type value;
            value.hue             = 200U;
            value.direction       = static_cast<chip::app::Clusters::ColorControl::HueDirection>(0);
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToHue::Id, value,
                               chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH sends MoveHue command to DUT with MoveMode=0x01 (up) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveHue::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(1);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveHue::Id, value,
                               chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 11: {
            LogStep(11, "TH sends MoveHue command to DUT with MoveMode=0x00 (stop) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveHue::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(0);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveHue::Id, value,
                               chip::NullOptional

            );
        }
        case 12: {
            LogStep(12, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 13: {
            LogStep(13, "Wait 2s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 2000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 14: {
            LogStep(14, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 15: {
            LogStep(15,
                    "TH sends MoveToHue command to DUT with Hue=60, Direction=0x00 (shortest distance) and TransitionTime=0 "
                    "(immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToHue::Type value;
            value.hue             = 60U;
            value.direction       = static_cast<chip::app::Clusters::ColorControl::HueDirection>(0);
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToHue::Id, value,
                               chip::NullOptional

            );
        }
        case 16: {
            LogStep(16, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 17: {
            LogStep(17, "TH sends MoveHue command to DUT with MoveMode=0x03 (down) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveHue::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(3);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveHue::Id, value,
                               chip::NullOptional

            );
        }
        case 18: {
            LogStep(18, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 19: {
            LogStep(19, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 20: {
            LogStep(20, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 21: {
            LogStep(21, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 22: {
            LogStep(22, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 23: {
            LogStep(23, "TH sends MoveHue command to DUT with MoveMode=0x00 (stop) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveHue::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(0);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveHue::Id, value,
                               chip::NullOptional

            );
        }
        case 24: {
            LogStep(24, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 25: {
            LogStep(25, "Wait 2s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 2000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 26: {
            LogStep(26, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 27: {
            LogStep(27, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 28: {
            LogStep(28, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 29: {
            LogStep(29, "Turn off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 30: {
            LogStep(30, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_3_3Suite : public TestCommand
{
public:
    Test_TC_CC_3_3Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_3_3", 25, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_3_3Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 195U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 4U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 6U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 4U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 6U));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 17U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 23U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 208U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 255U));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 208U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 255U));
            }
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3,
                    "TH sends MoveToHue command to DUT with Hue=200, Direction=0x00 (shortest distance) and TransitionTime=0 "
                    "(immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToHue::Type value;
            value.hue             = 200U;
            value.direction       = static_cast<chip::app::Clusters::ColorControl::HueDirection>(0);
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToHue::Id, value,
                               chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH sends StepHue command to DUT with StepMode=0x01 (up), StepSize=60 and TransitionTime=200 (20s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C02.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StepHue::Type value;
            value.stepMode        = static_cast<chip::app::Clusters::ColorControl::HueStepMode>(1);
            value.stepSize        = 60U;
            value.transitionTime  = 200U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StepHue::Id, value,
                               chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 11: {
            LogStep(11, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 12: {
            LogStep(12,
                    "TH sends MoveToHue command to DUT with Hue=50, Direction=0x00 (shortest distance) and TransitionTime=0 "
                    "(immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToHue::Type value;
            value.hue             = 50U;
            value.direction       = static_cast<chip::app::Clusters::ColorControl::HueDirection>(0);
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToHue::Id, value,
                               chip::NullOptional

            );
        }
        case 13: {
            LogStep(13, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 14: {
            LogStep(14, "TH sends StepHue command to DUT with StepMode=0x03 (down), StepSize=60 and TransitionTime=200 (20s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C02.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StepHue::Type value;
            value.stepMode        = static_cast<chip::app::Clusters::ColorControl::HueStepMode>(3);
            value.stepSize        = 60U;
            value.transitionTime  = 200U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StepHue::Id, value,
                               chip::NullOptional

            );
        }
        case 15: {
            LogStep(15, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 16: {
            LogStep(16, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 17: {
            LogStep(17, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 18: {
            LogStep(18, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 19: {
            LogStep(19, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 20: {
            LogStep(20, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 21: {
            LogStep(21, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 22: {
            LogStep(22, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 23: {
            LogStep(23, "Turn off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 24: {
            LogStep(24, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_4_1Suite : public TestCommand
{
public:
    Test_TC_CC_4_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_4_1", 18, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("SaturationConfigValue", 0, UINT8_MAX, &mSaturationConfigValue);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_4_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint8_t> mSaturationConfigValue;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 68U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 92U));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 80U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 115U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 102U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 138U));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 102U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 138U));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3, "TH sends MoveToSaturation command to DUT with Saturation=60 and TransitionTime=0 (immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C03.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToSaturation::Type value;
            value.saturation      = 60U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToSaturation::Id,
                               value, chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH sends MoveToSaturation command to DUT with Saturation=120 and TransitionTime=300 (30s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C03.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToSaturation::Type value;
            value.saturation      = 120U;
            value.transitionTime  = 300U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToSaturation::Id,
                               value, chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 11: {
            LogStep(11, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 12: {
            LogStep(12, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 13: {
            LogStep(13, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 15: {
            LogStep(15, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 16: {
            LogStep(16, "Turn off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 17: {
            LogStep(17, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_4_2Suite : public TestCommand
{
public:
    Test_TC_CC_4_2Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_4_2", 34, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_4_2Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 170U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 230U));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 216U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 216U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 59U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 81U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 17U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 23U));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 10U));
            }
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 170U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 230U));
            }
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 170U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 230U));
            }
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 170U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 230U));
            }
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 32:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 33:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3, "TH sends MoveToSaturation command to DUT with Saturation=150 and TransitionTime=0 (immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C03.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToSaturation::Type value;
            value.saturation      = 150U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToSaturation::Id,
                               value, chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH sends MoveSaturation command to DUT with MoveMode=0x01 (up) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C04.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveSaturation::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::SaturationMoveMode>(1);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveSaturation::Id, value,
                               chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 11: {
            LogStep(11, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 12: {
            LogStep(12, "TH sends MoveToSaturation command to DUT with Saturation=120 and TransitionTime=0 (immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C03.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToSaturation::Type value;
            value.saturation      = 120U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToSaturation::Id,
                               value, chip::NullOptional

            );
        }
        case 13: {
            LogStep(13, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 14: {
            LogStep(14, "TH sends MoveSaturation command to DUT with MoveMode=0x03 (down) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C04.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveSaturation::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::SaturationMoveMode>(3);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveSaturation::Id, value,
                               chip::NullOptional

            );
        }
        case 15: {
            LogStep(15, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 16: {
            LogStep(16, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 18: {
            LogStep(18, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 19: {
            LogStep(19, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 20: {
            LogStep(20, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 21: {
            LogStep(21, "TH sends MoveToSaturation command to DUT with Saturation=150 and TransitionTime=0 (immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C03.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToSaturation::Type value;
            value.saturation      = 150U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToSaturation::Id,
                               value, chip::NullOptional

            );
        }
        case 22: {
            LogStep(22, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 23: {
            LogStep(23, "TH sends MoveSaturation command to DUT with MoveMode=0x01 (up) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C04.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveSaturation::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::SaturationMoveMode>(1);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveSaturation::Id, value,
                               chip::NullOptional

            );
        }
        case 24: {
            LogStep(24, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 25: {
            LogStep(25, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 26: {
            LogStep(26, "TH sends MoveSaturation command to DUT with MoveMode=0x00 (stop) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C04.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveSaturation::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::SaturationMoveMode>(0);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveSaturation::Id, value,
                               chip::NullOptional

            );
        }
        case 27: {
            LogStep(27, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 28: {
            LogStep(28, "Wait 2s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 2000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 29: {
            LogStep(29, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 30: {
            LogStep(30, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 31: {
            LogStep(31, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 32: {
            LogStep(32, "Turn off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 33: {
            LogStep(33, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_4_3Suite : public TestCommand
{
public:
    Test_TC_CC_4_3Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_4_3", 31, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_4_3Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 187U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 253U));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 204U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 204U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 216U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 25U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 35U));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 8U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 12U));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 8U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 12U));
            }
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("currentSaturation", value, 0U));
            }
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3, "TH sends MoveToSaturation command to DUT with Saturation=200 and TransitionTime=0 (immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C03.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToSaturation::Type value;
            value.saturation      = 200U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToSaturation::Id,
                               value, chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH sends StepSaturation command to DUT with StepMode=0x01 (up), StepSize=40 and TransitionTime=200 (20s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C05.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StepSaturation::Type value;
            value.stepMode        = static_cast<chip::app::Clusters::ColorControl::SaturationStepMode>(1);
            value.stepSize        = 40U;
            value.transitionTime  = 200U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StepSaturation::Id, value,
                               chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 11: {
            LogStep(11, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 12: {
            LogStep(12, "TH sends StepSaturation command to DUT with StepMode=0x01 (up), StepSize=20 and TransitionTime=100 (10s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C05.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StepSaturation::Type value;
            value.stepMode        = static_cast<chip::app::Clusters::ColorControl::SaturationStepMode>(1);
            value.stepSize        = 20U;
            value.transitionTime  = 100U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StepSaturation::Id, value,
                               chip::NullOptional

            );
        }
        case 13: {
            LogStep(13, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 14: {
            LogStep(14, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 15: {
            LogStep(15, "TH sends MoveToSaturation command to DUT with Saturation=50 and TransitionTime=0 (immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C03.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToSaturation::Type value;
            value.saturation      = 50U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToSaturation::Id,
                               value, chip::NullOptional

            );
        }
        case 16: {
            LogStep(16, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 17: {
            LogStep(17,
                    "TH sends StepSaturation command to DUT with StepMode=0x03 (down), StepSize=40 and TransitionTime=200 (20s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C05.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StepSaturation::Type value;
            value.stepMode        = static_cast<chip::app::Clusters::ColorControl::SaturationStepMode>(3);
            value.stepSize        = 40U;
            value.transitionTime  = 200U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StepSaturation::Id, value,
                               chip::NullOptional

            );
        }
        case 18: {
            LogStep(18, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 19: {
            LogStep(19, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 20: {
            LogStep(20, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 21: {
            LogStep(21, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 22: {
            LogStep(22, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 23: {
            LogStep(23, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 24: {
            LogStep(24,
                    "TH sends StepSaturation command to DUT with StepMode=0x03 (down), StepSize=20 and TransitionTime=100 (10 s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C05.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StepSaturation::Type value;
            value.stepMode        = static_cast<chip::app::Clusters::ColorControl::SaturationStepMode>(3);
            value.stepSize        = 20U;
            value.transitionTime  = 100U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StepSaturation::Id, value,
                               chip::NullOptional

            );
        }
        case 25: {
            LogStep(25, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 26: {
            LogStep(26, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 27: {
            LogStep(27, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 28: {
            LogStep(28, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 29: {
            LogStep(29, "Turn off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 30: {
            LogStep(30, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_4_4Suite : public TestCommand
{
public:
    Test_TC_CC_4_4Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_4_4", 21, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_4_4Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 170U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 230U));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 42U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 58U));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 160U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 200U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 50U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 80U));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 135U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 185U));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 68U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 92U));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 135U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 185U));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 68U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 92U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(
                3, "TH sends MoveToHueAndSaturation command to DUT with Hue=200, Saturation=50 and TransitionTime=0 (immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C06.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToHueAndSaturation::Type value;
            value.hue             = 200U;
            value.saturation      = 50U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToHueAndSaturation::Id,
                               value, chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH reads CurrentHue attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000 && CC.S.C06.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 6: {
            LogStep(6, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 7: {
            LogStep(7, "TH sends MoveToHueAndSaturation command to DUT with Hue=160, Saturation=80 and TransitionTime=200 (20s)");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.C06.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToHueAndSaturation::Type value;
            value.hue             = 160U;
            value.saturation      = 80U;
            value.transitionTime  = 200U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToHueAndSaturation::Id,
                               value, chip::NullOptional

            );
        }
        case 8: {
            LogStep(8, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 10: {
            LogStep(10, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 12: {
            LogStep(12, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 13: {
            LogStep(13, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 15: {
            LogStep(15, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 16: {
            LogStep(16, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 18: {
            LogStep(18, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F00 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 19: {
            LogStep(19, "Turn off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 20: {
            LogStep(20, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_5_1Suite : public TestCommand
{
public:
    Test_TC_CC_5_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_5_1", 59, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_5_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 27853U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 37683U));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 16711U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 22609U));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 13107U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 32768U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 13107U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 19660U));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 11141U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 15073U));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 11141U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 15073U));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 11141U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 15073U));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 11141U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 15073U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("options", value, 0U));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 27853U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 37683U));
            }
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 16711U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 22609U));
            }
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("currentX", value, 32768U));
            }
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("currentY", value, 19660U));
            }
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("currentX", value, 32768U));
            }
            break;
        case 32:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("currentY", value, 19660U));
            }
            break;
        case 33:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 34:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 35:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 22282U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 30146U));
            }
            break;
        case 36:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 27853U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 37683U));
            }
            break;
        case 37:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 38:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("options", value, 1U));
            }
            break;
        case 39:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 40:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 41:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 42:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 27853U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 37683U));
            }
            break;
        case 43:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 16711U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 22609U));
            }
            break;
        case 44:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 45:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 46:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 47:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 11141U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 15073U));
            }
            break;
        case 48:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 11141U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 15073U));
            }
            break;
        case 49:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 50:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 51:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("currentX", value, 13107U));
            }
            break;
        case 52:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("currentY", value, 13107U));
            }
            break;
        case 53:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 54:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 55:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 22282U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 30146U));
            }
            break;
        case 56:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 27853U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 37683U));
            }
            break;
        case 57:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 1U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 58:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 1U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3,
                    "TH sends MoveToColor command to DUT, with ColorX = 32768/0x8000 ColorY = 19660/0x4CCC TransitionTime = 0 "
                    "(immediate)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 32768U;
            value.colorY          = 19660U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 6: {
            LogStep(6, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 7: {
            LogStep(
                7,
                "TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 13107/0x3333 TransitionTime = 200 (20s)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 13107U;
            value.colorY          = 13107U;
            value.transitionTime  = 200U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 8: {
            LogStep(8, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 10: {
            LogStep(10, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 12: {
            LogStep(12, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 13: {
            LogStep(13, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 14: {
            LogStep(14, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 15: {
            LogStep(15, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 16: {
            LogStep(16, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 17: {
            LogStep(17, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 18: {
            LogStep(18, "TH read Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, true,
                                 chip::NullOptional);
        }
        case 19: {
            LogStep(19, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 20: {
            LogStep(20,
                    "TH sends a MoveToColor command to the DUT with ColorX = 32768/0x8000 (x=0.5) (purple) ColorY = 19660/0x4CCC "
                    "(y=0.3) TransitionTime = 0 (immediate)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 32768U;
            value.colorY          = 19660U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 21: {
            LogStep(21, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 22: {
            LogStep(22, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 23: {
            LogStep(23, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 24: {
            LogStep(24, "TH sends Off command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 25: {
            LogStep(25,
                    "TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 13107/0x3333 TransitionTime = 0 "
                    "(immediate)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 13107U;
            value.colorY          = 13107U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 26: {
            LogStep(26, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 27: {
            LogStep(27, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 28: {
            LogStep(28, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 29: {
            LogStep(29,
                    "TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 32768/0x8000 TransitionTime = 0 "
                    "(immediate)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 13107U;
            value.colorY          = 32768U;
            value.transitionTime  = 0U;
            value.optionsMask     = 1U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 30: {
            LogStep(30, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 31: {
            LogStep(31, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 32: {
            LogStep(32, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 33: {
            LogStep(33,
                    "TH sends MoveToColor command to DUT, with ColorX = 26214/0x6666 ColorY = 32768/0x8000 TransitionTime = 0 "
                    "(immediate)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 26214U;
            value.colorY          = 32768U;
            value.transitionTime  = 0U;
            value.optionsMask     = 1U;
            value.optionsOverride = 1U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 34: {
            LogStep(34, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 35: {
            LogStep(35, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 36: {
            LogStep(36, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 37: {
            LogStep(37, "TH writes 1 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 1U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 38: {
            LogStep(38, "TH read Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, true,
                                 chip::NullOptional);
        }
        case 39: {
            LogStep(39, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 40: {
            LogStep(40,
                    "TH sends MoveToColor command to DUT, with ColorX = 32768/0x8000 ColorY = 19660/0x4CCC TransitionTime = 0 "
                    "(immediate)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 32768U;
            value.colorY          = 19660U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 41: {
            LogStep(41, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 42: {
            LogStep(42, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 43: {
            LogStep(43, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 44: {
            LogStep(44, "TH sends Off command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 45: {
            LogStep(45,
                    "TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 13107/0x3333 TransitionTime = 0 "
                    "(immediate)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 13107U;
            value.colorY          = 13107U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 46: {
            LogStep(46, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 47: {
            LogStep(47, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 48: {
            LogStep(48, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 49: {
            LogStep(49,
                    "TH sends MoveToColor command to DUT, with ColorX = 13107/0x3333 ColorY = 32768/0x8000 TransitionTime = 0 "
                    "(immediate)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 13107U;
            value.colorY          = 32768U;
            value.transitionTime  = 0U;
            value.optionsMask     = 1U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 50: {
            LogStep(50, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 51: {
            LogStep(51, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 52: {
            LogStep(52, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 53: {
            LogStep(53,
                    "TH sends MoveToColor command to DUT, with ColorX = 26214/0x6666 ColorY = 32768/0x8000 TransitionTime = 0 "
                    "(immediate)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 26214U;
            value.colorY          = 32768U;
            value.transitionTime  = 0U;
            value.optionsMask     = 1U;
            value.optionsOverride = 1U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 54: {
            LogStep(54, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 55: {
            LogStep(55, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 56: {
            LogStep(56, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 57: {
            LogStep(57, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 58: {
            LogStep(58, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_5_2Suite : public TestCommand
{
public:
    Test_TC_CC_5_2Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_5_2", 22, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_5_2Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    uint16_t CurrentXValue;
    uint16_t CurrentYValue;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 27200U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 36800U));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 22900U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 31100U));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 26350U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 35650U));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 23800U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 32200U));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 25500U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 34500U));
                CurrentXValue = value;
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 24650U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 33350U));
                CurrentYValue = value;
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 25500U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 34500U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 24650U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 33350U));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 1U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 1U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3, "TH sends MoveToColor command to DUT, with ColorX = 33000 ColorY = 26000 TransitionTime = 0 (immediate)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 33000U;
            value.colorY          = 26000U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH sends MoveColor command to DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveColor::Type value;
            value.rateX           = -100;
            value.rateY           = 100;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveColor::Id, value,
                               chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 8: {
            LogStep(8, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 9: {
            LogStep(9, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 10: {
            LogStep(10, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 11: {
            LogStep(11, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 12: {
            LogStep(12, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 13: {
            LogStep(13, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 14: {
            LogStep(14, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 15: {
            LogStep(15, "TH sends StopMoveStep command to DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C47.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StopMoveStep::Type value;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StopMoveStep::Id, value,
                               chip::NullOptional

            );
        }
        case 16: {
            LogStep(16, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 17: {
            LogStep(17, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 18: {
            LogStep(18, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 19: {
            LogStep(19, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 20: {
            LogStep(20, "Turn off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 21: {
            LogStep(21, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_5_3Suite : public TestCommand
{
public:
    Test_TC_CC_5_3Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_5_3", 19, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_5_3Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 13000U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 33000U));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 14000U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 20000U));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 11050U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 14950U));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 11900U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 16100U));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 11050U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 14950U));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 11900U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 16100U));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 1U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 1U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3, "TH sends MoveToColor command to DUT, with ColorX = 33000 ColorY = 20000 TransitionTime = 0 (immediate)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C07.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColor::Type value;
            value.colorX          = 33000U;
            value.colorY          = 20000U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColor::Id, value,
                               chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH sends StepColor command to DUT, with StepX = -20000, StepY = -6000, TransitionTime = 200 (20s)");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.C09.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StepColor::Type value;
            value.stepX           = -20000;
            value.stepY           = -6000;
            value.transitionTime  = 200U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StepColor::Id, value,
                               chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 8: {
            LogStep(8, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 9: {
            LogStep(9, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 10: {
            LogStep(10, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 11: {
            LogStep(11, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 12: {
            LogStep(12, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 13: {
            LogStep(13, "TH reads CurrentX attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0003 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentX::Id, true,
                                 chip::NullOptional);
        }
        case 14: {
            LogStep(14, "TH reads CurrentY attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0004 && CC.S.C08.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentY::Id, true,
                                 chip::NullOptional);
        }
        case 15: {
            LogStep(15, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 16: {
            LogStep(16, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F03 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "Turn off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 18: {
            LogStep(18, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_6_1Suite : public TestCommand
{
public:
    Test_TC_CC_6_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_6_1", 21, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_6_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    uint16_t ColorTempPhysicalMinMiredsValue;
    uint16_t ColorTempPhysicalMaxMiredsValue;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
                ColorTempPhysicalMinMiredsValue = value;
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
                ColorTempPhysicalMaxMiredsValue = value;
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 246U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 334U));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 230U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 310U));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 212U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 288U));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 212U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 288U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 2U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 2U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3, "TH reads ColorTempPhysicalMinMireds attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A400b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTempPhysicalMinMireds::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads ColorTempPhysicalMaxMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A400c"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTempPhysicalMaxMireds::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6,
                    "TH sends MoveToColorTemperature command to DUT with ColorTemperatureMireds=310 and TransitionTime=0 "
                    "(immediately).");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.C0a.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColorTemperature::Type value;
            value.colorTemperature = 310U;
            value.transitionTime   = 0U;
            value.optionsMask      = 0U;
            value.optionsOverride  = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 7: {
            LogStep(7, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 8: {
            LogStep(8,
                    "TH sends MoveToColorTemperatur command to DUT with ColorTemperatureMireds=250 and TransitionTime=300 (30s).");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.C0a.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColorTemperature::Type value;
            value.colorTemperature = 250U;
            value.transitionTime   = 300U;
            value.optionsMask      = 0U;
            value.optionsOverride  = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 9: {
            LogStep(9, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 10: {
            LogStep(10, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C0a.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 12: {
            LogStep(12, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C0a.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 14: {
            LogStep(14, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C0a.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 15: {
            LogStep(15, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 16: {
            LogStep(16, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C0a.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 18: {
            LogStep(18, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 19: {
            LogStep(19, "Turn Off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 20: {
            LogStep(20, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_6_2Suite : public TestCommand
{
public:
    Test_TC_CC_6_2Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_6_2", 32, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_6_2Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    uint16_t ColorTempPhysicalMinMiredsValue;
    uint16_t ColorTempPhysicalMaxMiredsValue;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
                ColorTempPhysicalMinMiredsValue = value;
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
                ColorTempPhysicalMaxMiredsValue = value;
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorTemperatureMireds", value, ColorTempPhysicalMaxMiredsValue));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorTemperatureMireds", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 2U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 2U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3, "TH reads ColorTempPhysicalMinMireds attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A400b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTempPhysicalMinMireds::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads ColorTempPhysicalMaxMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A400c"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTempPhysicalMaxMireds::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6,
                    "TH sends MoveToColorTemperature command to DUT with ColorTemperatureMireds=(ColorTempPhysicalMinMireds + "
                    "ColorTempPhysicalMaxMireds)/2 and TransitionTime=0 (immediately).");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.C0a.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColorTemperature::Type value;
            value.colorTemperature = static_cast<uint16_t>((ColorTempPhysicalMinMiredsValue + ColorTempPhysicalMaxMiredsValue) / 2);
            value.transitionTime   = 0U;
            value.optionsMask      = 0U;
            value.optionsOverride  = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 7: {
            LogStep(7, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 8: {
            LogStep(8,
                    "TH sends MoveColorTemperature command to DUT with MoveMode = 0x01 (up), Rate = (ColorTempPhysicalMaxMireds - "
                    "ColorTempPhysicalMinMireds)/40");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveColorTemperature::Type value;
            value.moveMode = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(1);
            value.rate     = static_cast<uint16_t>((ColorTempPhysicalMaxMiredsValue - ColorTempPhysicalMinMiredsValue) / 40);
            value.colorTemperatureMinimumMireds = ColorTempPhysicalMinMiredsValue;
            value.colorTemperatureMaximumMireds = ColorTempPhysicalMaxMiredsValue;
            value.optionsMask                   = 0U;
            value.optionsOverride               = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 9: {
            LogStep(9, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 10: {
            LogStep(10, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 12: {
            LogStep(12, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 14: {
            LogStep(14, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 15: {
            LogStep(15,
                    "TH sends MoveColorTemperature command to DUT with MoveMode = 0x03(down), Rate = (ColorTempPhysicalMaxMireds - "
                    "ColorTempPhysicalMinMireds)/20");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveColorTemperature::Type value;
            value.moveMode = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(3);
            value.rate     = static_cast<uint16_t>((ColorTempPhysicalMaxMiredsValue - ColorTempPhysicalMinMiredsValue) / 20);
            value.colorTemperatureMinimumMireds = ColorTempPhysicalMinMiredsValue;
            value.colorTemperatureMaximumMireds = ColorTempPhysicalMaxMiredsValue;
            value.optionsMask                   = 0U;
            value.optionsOverride               = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 16: {
            LogStep(16, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 17: {
            LogStep(17, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 18: {
            LogStep(18, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 19: {
            LogStep(19, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 20: {
            LogStep(20, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 21: {
            LogStep(21, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 22: {
            LogStep(22,
                    "TH sends MoveColorTemperature command to DUT with MoveMode = 0x01(up), Rate = (ColorTempPhysicalMaxMireds - "
                    "ColorTempPhysicalMinMireds)/20");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveColorTemperature::Type value;
            value.moveMode = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(1);
            value.rate     = static_cast<uint16_t>((ColorTempPhysicalMaxMiredsValue - ColorTempPhysicalMinMiredsValue) / 20);
            value.colorTemperatureMinimumMireds = ColorTempPhysicalMinMiredsValue;
            value.colorTemperatureMaximumMireds = ColorTempPhysicalMaxMiredsValue;
            value.optionsMask                   = 0U;
            value.optionsOverride               = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 23: {
            LogStep(23, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 24: {
            LogStep(24,
                    "After 10 seconds, TH sends MoveColorTemperature command to DUT with MoveMode = 0x00(stop), Rate = "
                    "(ColorTempPhysicalMaxMireds - ColorTempPhysicalMinMireds)/20");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveColorTemperature::Type value;
            value.moveMode = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(0);
            value.rate     = static_cast<uint16_t>((ColorTempPhysicalMaxMiredsValue - ColorTempPhysicalMinMiredsValue) / 20);
            value.colorTemperatureMinimumMireds = ColorTempPhysicalMinMiredsValue;
            value.colorTemperatureMaximumMireds = ColorTempPhysicalMaxMiredsValue;
            value.optionsMask                   = 0U;
            value.optionsOverride               = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 25: {
            LogStep(25, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 26: {
            LogStep(26, "Wait 2s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 2000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 27: {
            LogStep(27, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 28: {
            LogStep(28, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 29: {
            LogStep(29, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 30: {
            LogStep(30, "Turn off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 31: {
            LogStep(31, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_6_3Suite : public TestCommand
{
public:
    Test_TC_CC_6_3Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_6_3", 26, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_6_3Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    uint16_t ColorTempPhysicalMinMiredsValue;
    uint16_t ColorTempPhysicalMaxMiredsValue;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
                ColorTempPhysicalMinMiredsValue = value;
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
                ColorTempPhysicalMaxMiredsValue = value;
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorTemperatureMireds", value, ColorTempPhysicalMaxMiredsValue));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorTemperatureMireds", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMiredsValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMiredsValue));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 2U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 2U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3, "TH reads ColorTempPhysicalMinMireds attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A400b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTempPhysicalMinMireds::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads ColorTempPhysicalMaxMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A400c"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTempPhysicalMaxMireds::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6,
                    "TH sends MoveToColorTemperature command to DUT with ColorTemperatureMireds=(ColorTempPhysicalMinMireds + "
                    "ColorTempPhysicalMaxMireds)/2 and TransitionTime=0 (immediately).");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.C0a.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColorTemperature::Type value;
            value.colorTemperature = static_cast<uint16_t>((ColorTempPhysicalMinMiredsValue + ColorTempPhysicalMaxMiredsValue) / 2);
            value.transitionTime   = 0U;
            value.optionsMask      = 0U;
            value.optionsOverride  = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 7: {
            LogStep(7, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 8: {
            LogStep(8,
                    "TH sends StepColorTemperature command to DUT with StepMode = 0x01 (up), StepSize = "
                    "(ColorTempPhysicalMaxMireds - ColorTempPhysicalMinMireds)/2 and TransitionTime = 200 (20s).");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.C4c.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StepColorTemperature::Type value;
            value.stepMode       = static_cast<chip::app::Clusters::ColorControl::HueStepMode>(1);
            value.stepSize       = static_cast<uint16_t>((ColorTempPhysicalMinMiredsValue + ColorTempPhysicalMaxMiredsValue) / 2);
            value.transitionTime = 200U;
            value.colorTemperatureMinimumMireds = ColorTempPhysicalMinMiredsValue;
            value.colorTemperatureMaximumMireds = ColorTempPhysicalMaxMiredsValue;
            value.optionsMask                   = 0U;
            value.optionsOverride               = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StepColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 9: {
            LogStep(9, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 10: {
            LogStep(10, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4c.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 12: {
            LogStep(12, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4c.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 14: {
            LogStep(14, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4c.Rsp && PICS_SKIP_SAMPLE_APP"),
                       return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 15: {
            LogStep(15,
                    "TH sends StepColorTemperature command to DUT with StepMode = 0x03 (down), StepSize = "
                    "(ColorTempPhysicalMaxMireds - ColorTempPhysicalMinMireds) and TransitionTime = 200 (20s).");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.C4c.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StepColorTemperature::Type value;
            value.stepMode       = static_cast<chip::app::Clusters::ColorControl::HueStepMode>(3);
            value.stepSize       = static_cast<uint16_t>(ColorTempPhysicalMaxMiredsValue - ColorTempPhysicalMinMiredsValue);
            value.transitionTime = 200U;
            value.colorTemperatureMinimumMireds = ColorTempPhysicalMinMiredsValue;
            value.colorTemperatureMaximumMireds = ColorTempPhysicalMaxMiredsValue;
            value.optionsMask                   = 0U;
            value.optionsOverride               = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StepColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 16: {
            LogStep(16, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 17: {
            LogStep(17, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4c.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 18: {
            LogStep(18, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 19: {
            LogStep(19, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4c.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 20: {
            LogStep(20, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 21: {
            LogStep(21, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0007 && CC.S.C4c.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 22: {
            LogStep(22, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 23: {
            LogStep(23, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F04 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 24: {
            LogStep(24, "Turn Off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 25: {
            LogStep(25, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_7_2Suite : public TestCommand
{
public:
    Test_TC_CC_7_2Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_7_2", 31, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_7_2Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 21250U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 28750U));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 25500U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 34500U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 29750U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 40250U));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 29750U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 40250U));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 17000U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 23000U));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 12750U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 17250U));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 8500U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 11500U));
            }
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 8500U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 11500U));
            }
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 3U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3,
                    "TH sends EnhancedMoveToHue command to DUT with EnhancedHue=20000, Direction=0x00 (shortest distance) and "
                    "TransitionTime=0 (immediately).");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveToHue::Type value;
            value.enhancedHue     = 20000U;
            value.direction       = static_cast<chip::app::Clusters::ColorControl::HueDirection>(0);
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedMoveToHue::Id,
                               value, chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH sends EnhancedMoveHue command to DUT with MoveMode=0x01 (up) and Rate=500 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveHue::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(1);
            value.rate            = 500U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedMoveHue::Id, value,
                               chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 11: {
            LogStep(11, "TH sends EnhancedMoveHue command to DUT with MoveMode=0x00 (stop) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveHue::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(0);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedMoveHue::Id, value,
                               chip::NullOptional

            );
        }
        case 12: {
            LogStep(12, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "Wait 2s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 2000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 14: {
            LogStep(14, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 15: {
            LogStep(15,
                    "TH sends EnhancedMoveToHue command to DUT with EnhancedHue=25000, Direction=0x00 (shortest distance) and "
                    "TransitionTime=0 (immediately).");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveToHue::Type value;
            value.enhancedHue     = 25000U;
            value.direction       = static_cast<chip::app::Clusters::ColorControl::HueDirection>(0);
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedMoveToHue::Id,
                               value, chip::NullOptional

            );
        }
        case 16: {
            LogStep(16, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 17: {
            LogStep(17, "TH sends EnhancedMoveHue command to DUT with MoveMode=0x03 (down) and Rate=500 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveHue::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(3);
            value.rate            = 500U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedMoveHue::Id, value,
                               chip::NullOptional

            );
        }
        case 18: {
            LogStep(18, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 19: {
            LogStep(19, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 20: {
            LogStep(20, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 21: {
            LogStep(21, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 22: {
            LogStep(22, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 23: {
            LogStep(23, "TH sends EnhancedMoveHue command to DUT with MoveMode=0x00 (stop) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveHue::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(0);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedMoveHue::Id, value,
                               chip::NullOptional

            );
        }
        case 24: {
            LogStep(24, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 25: {
            LogStep(25, "Wait 2s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 2000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 26: {
            LogStep(26, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 27: {
            LogStep(27, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 28: {
            LogStep(28, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 29: {
            LogStep(29, "Turn Off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 30: {
            LogStep(30, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_7_3Suite : public TestCommand
{
public:
    Test_TC_CC_7_3Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_7_3", 29, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_7_3Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 6800U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9200U));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 8500U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 11500U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 10200U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 13800U));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 10200U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 13800U));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 8500U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 11500U));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 6800U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9200U));
            }
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 5100U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 6900U));
            }
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 5100U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 6900U));
            }
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 3U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3,
                    "TH sends EnhancedMoveToHue command to DUT with EnhancedHue=6000, Direction=0x00 (shortest distance) and "
                    "TransitionTime=0 (immediately).");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveToHue::Type value;
            value.enhancedHue     = 6000U;
            value.direction       = static_cast<chip::app::Clusters::ColorControl::HueDirection>(0);
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedMoveToHue::Id,
                               value, chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5,
                    "TH sends EnhancedStepHue command to DUT with StepMode=0x01 (up), StepSize=6000 and TransitionTime=300 (30s).");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C42.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedStepHue::Type value;
            value.stepMode        = static_cast<chip::app::Clusters::ColorControl::HueStepMode>(1);
            value.stepSize        = 6000U;
            value.transitionTime  = 300U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedStepHue::Id, value,
                               chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 11: {
            LogStep(11, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 12: {
            LogStep(12, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 13: {
            LogStep(13, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 14: {
            LogStep(14,
                    "TH sends EnhancedMoveToHue command to DUT with EnhancedHue=12000, Direction=0x00 (shortest distance) and "
                    "TransitionTime=0 (immediately).");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveToHue::Type value;
            value.enhancedHue     = 12000U;
            value.direction       = static_cast<chip::app::Clusters::ColorControl::HueDirection>(0);
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedMoveToHue::Id,
                               value, chip::NullOptional

            );
        }
        case 15: {
            LogStep(15, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 16: {
            LogStep(
                16,
                "TH sends EnhancedStepHue command to DUT with StepMode=0x03 (down), StepSize=6000 and TransitionTime=300 (30s)");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C42.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedStepHue::Type value;
            value.stepMode        = static_cast<chip::app::Clusters::ColorControl::HueStepMode>(3);
            value.stepSize        = 6000U;
            value.transitionTime  = 300U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedStepHue::Id, value,
                               chip::NullOptional

            );
        }
        case 17: {
            LogStep(17, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 18: {
            LogStep(18, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 19: {
            LogStep(19, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 20: {
            LogStep(20, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 21: {
            LogStep(21, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 22: {
            LogStep(22, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 23: {
            LogStep(23, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 24: {
            LogStep(24, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000 && CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 25: {
            LogStep(25, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 26: {
            LogStep(26, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 27: {
            LogStep(27, "Turn Off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 28: {
            LogStep(28, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_7_4Suite : public TestCommand
{
public:
    Test_TC_CC_7_4Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_7_4", 21, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_7_4Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 17000U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 23000U));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 42U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 58U));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 16000U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 20000U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 50U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 80U));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 13600U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 18400U));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 68U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 92U));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedCurrentHue", value, 16000U));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("currentSaturation", value, 80U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("colorMode", value, 0U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("enhancedColorMode", value, 3U));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 3U));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3,
                    "TH sends EnhancedMoveToHueAndSaturation command to DUT with EnhancedHue=20000, Saturation=50 and "
                    "TransitionTime=0 (immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C43.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveToHueAndSaturation::Type value;
            value.enhancedHue     = 20000U;
            value.saturation      = 50U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                               ColorControl::Commands::EnhancedMoveToHueAndSaturation::Id, value, chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 6: {
            LogStep(6, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 7: {
            LogStep(7,
                    "TH sends EnhancedMoveToHueAndSaturation command to DUT with EnhancedHue=16000, Saturation=80 and "
                    "TransitionTime=200 (20s)");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.C43.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveToHueAndSaturation::Type value;
            value.enhancedHue     = 16000U;
            value.saturation      = 80U;
            value.transitionTime  = 200U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                               ColorControl::Commands::EnhancedMoveToHueAndSaturation::Id, value, chip::NullOptional

            );
        }
        case 8: {
            LogStep(8, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 12: {
            LogStep(12, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "Wait 5s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 15: {
            LogStep(15, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 16: {
            LogStep(16, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "TH reads ColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::ColorMode::Id, true,
                                 chip::NullOptional);
        }
        case 18: {
            LogStep(18, "TH reads EnhancedColorMode attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.F01 && CC.S.A4001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedColorMode::Id,
                                 true, chip::NullOptional);
        }
        case 19: {
            LogStep(19, "Turn Off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 20: {
            LogStep(20, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CC_8_1Suite : public TestCommand
{
public:
    Test_TC_CC_8_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CC_8_1", 39, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CC_8_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    uint16_t ColorTempPhysicalMinMireds;
    uint16_t ColorTempPhysicalMaxMireds;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 216U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 216U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 170U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 230U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 170U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 230U));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
                ColorTempPhysicalMinMireds = value;
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65279U));
                ColorTempPhysicalMaxMireds = value;
            }
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMireds));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMireds));
            }
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, ColorTempPhysicalMinMireds));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, ColorTempPhysicalMaxMireds));
            }
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 32:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 33:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 34:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 21250U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 28750U));
            }
            break;
        case 35:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 36:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 21250U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 28750U));
            }
            break;
        case 37:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 38:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("CC.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 3: {
            LogStep(3,
                    "TH sends MoveToHue command to DUT with Hue=200, Direction=0x00 (shortest distance) and TransitionTime=0 "
                    "(immediately).");
            VerifyOrDo(!ShouldSkip("CC.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToHue::Type value;
            value.hue             = 200U;
            value.direction       = static_cast<chip::app::Clusters::ColorControl::HueDirection>(0);
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToHue::Id, value,
                               chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "TH sends MoveHue command to DUT with MoveMode=0x01 (up) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveHue::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(1);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveHue::Id, value,
                               chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "TH sends StopMoveStep command to DUT");
            VerifyOrDo(!ShouldSkip("CC.S.C47.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StopMoveStep::Type value;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StopMoveStep::Id, value,
                               chip::NullOptional

            );
        }
        case 8: {
            LogStep(8, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0000 && CC.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 9: {
            LogStep(9, "Wait 2s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 2000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 10: {
            LogStep(10, "TH reads CurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0000 && CC.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentHue::Id, true,
                                 chip::NullOptional);
        }
        case 11: {
            LogStep(11, "TH sends MoveToSaturation command to DUT with Saturation=150 and TransitionTime=0 (immediately)");
            VerifyOrDo(!ShouldSkip("CC.S.C03.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToSaturation::Type value;
            value.saturation      = 150U;
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToSaturation::Id,
                               value, chip::NullOptional

            );
        }
        case 12: {
            LogStep(12, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 13: {
            LogStep(13, "TH sends MoveSaturation command to DUT with MoveMode=0x01 (up) and Rate=5 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.C04.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveSaturation::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::SaturationMoveMode>(1);
            value.rate            = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveSaturation::Id, value,
                               chip::NullOptional

            );
        }
        case 14: {
            LogStep(14, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 15: {
            LogStep(15, "TH sends StopMoveStep command to DUT");
            VerifyOrDo(!ShouldSkip("CC.S.C47.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StopMoveStep::Type value;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StopMoveStep::Id, value,
                               chip::NullOptional

            );
        }
        case 16: {
            LogStep(16, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "Wait 2s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 2000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 18: {
            LogStep(18, "TH reads CurrentSaturation attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::CurrentSaturation::Id,
                                 true, chip::NullOptional);
        }
        case 19: {
            LogStep(19, "TH reads ColorTempPhysicalMinMireds attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A400b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTempPhysicalMinMireds::Id, true, chip::NullOptional);
        }
        case 20: {
            LogStep(20, "TH reads ColorTempPhysicalMaxMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.A400c"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTempPhysicalMaxMireds::Id, true, chip::NullOptional);
        }
        case 21: {
            LogStep(21,
                    "TH sends MoveToColorTemperature command to DUT with ColorTemperatureMireds= ColorTempPhysicalMaxMireds / 2 "
                    "and TransitionTime=0 (immediately).");
            VerifyOrDo(!ShouldSkip("CC.S.C0a.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveToColorTemperature::Type value;
            value.colorTemperature = static_cast<uint16_t>((ColorTempPhysicalMinMireds + ColorTempPhysicalMaxMireds) / 2);
            value.transitionTime   = 0U;
            value.optionsMask      = 0U;
            value.optionsOverride  = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveToColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 22: {
            LogStep(22, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 23: {
            LogStep(23,
                    "TH sends MoveColorTemperature command to DUT with MoveMode = 0x01 (up), Rate = (ColorTempPhysicalMaxMireds - "
                    "ColorTempPhysicalMinMireds)/40");
            VerifyOrDo(!ShouldSkip("CC.S.C4b.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::MoveColorTemperature::Type value;
            value.moveMode = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(1);
            value.rate     = static_cast<uint16_t>((ColorTempPhysicalMaxMireds - ColorTempPhysicalMinMireds) / 40);
            value.colorTemperatureMinimumMireds = ColorTempPhysicalMinMireds;
            value.colorTemperatureMaximumMireds = ColorTempPhysicalMaxMireds;
            value.optionsMask                   = 0U;
            value.optionsOverride               = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::MoveColorTemperature::Id,
                               value, chip::NullOptional

            );
        }
        case 24: {
            LogStep(24, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 25: {
            LogStep(25, "TH sends StopMoveStep command to DUT");
            VerifyOrDo(!ShouldSkip("CC.S.C4b.Rsp && CC.S.C47.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StopMoveStep::Type value;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StopMoveStep::Id, value,
                               chip::NullOptional

            );
        }
        case 26: {
            LogStep(26, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.A0007 && CC.S.C4b.Rsp && CC.S.C47.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 27: {
            LogStep(27, "Wait 2s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 2000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 28: {
            LogStep(28, "TH reads ColorTemperatureMireds attribute from DUT.");
            VerifyOrDo(!ShouldSkip("CC.S.A0007 && CC.S.C4b.Rsp && CC.S.C47.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id,
                                 ColorControl::Attributes::ColorTemperatureMireds::Id, true, chip::NullOptional);
        }
        case 29: {
            LogStep(29,
                    "TH sends EnhancedMoveToHue command to DUT with EnhancedHue=20000, Direction=0x00 (shortest distance) and "
                    "TransitionTime=0 (immediately).");
            VerifyOrDo(!ShouldSkip("CC.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveToHue::Type value;
            value.enhancedHue     = 20000U;
            value.direction       = static_cast<chip::app::Clusters::ColorControl::HueDirection>(0);
            value.transitionTime  = 0U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedMoveToHue::Id,
                               value, chip::NullOptional

            );
        }
        case 30: {
            LogStep(30, "Wait 100ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 100UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 31: {
            LogStep(31, "TH sends EnhancedMoveHue command to DUT with MoveMode=0x01 (up) and Rate=500 (units/s)");
            VerifyOrDo(!ShouldSkip("CC.S.C41.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::EnhancedMoveHue::Type value;
            value.moveMode        = static_cast<chip::app::Clusters::ColorControl::HueMoveMode>(1);
            value.rate            = 500U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::EnhancedMoveHue::Id, value,
                               chip::NullOptional

            );
        }
        case 32: {
            LogStep(32, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 33: {
            LogStep(33, "TH sends StopMoveStep command to DUT");
            VerifyOrDo(!ShouldSkip("CC.S.C47.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::ColorControl::Commands::StopMoveStep::Type value;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Commands::StopMoveStep::Id, value,
                               chip::NullOptional

            );
        }
        case 34: {
            LogStep(34, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A4000 && CC.S.C47.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 35: {
            LogStep(35, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 36: {
            LogStep(36, "TH reads EnhancedCurrentHue attribute from DUT");
            VerifyOrDo(!ShouldSkip("CC.S.A4000 && CC.S.C47.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), ColorControl::Id, ColorControl::Attributes::EnhancedCurrentHue::Id,
                                 true, chip::NullOptional);
        }
        case 37: {
            LogStep(37, "Turn Off light that we turned on");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 38: {
            LogStep(38, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_OPCREDS_1_2Suite : public TestCommand
{
public:
    Test_TC_OPCREDS_1_2Suite(CredentialIssuerCommands * credsIssuerConfig) :
        TestCommand("Test_TC_OPCREDS_1_2", 6, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_OPCREDS_1_2Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 5UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 6UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 7UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 9UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 10UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 11UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 5UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 8UL));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads the ClusterRevision from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), OperationalCredentials::Id,
                                 OperationalCredentials::Attributes::ClusterRevision::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads the FeatureMap from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), OperationalCredentials::Id,
                                 OperationalCredentials::Attributes::FeatureMap::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH reads AttributeList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), OperationalCredentials::Id,
                                 OperationalCredentials::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads AcceptedCommandList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), OperationalCredentials::Id,
                                 OperationalCredentials::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads GeneratedCommandList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), OperationalCredentials::Id,
                                 OperationalCredentials::Attributes::GeneratedCommandList::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_BINFO_1_1Suite : public TestCommand
{
public:
    Test_TC_BINFO_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_BINFO_1_1", 14, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_BINFO_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 5UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 6UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 7UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 8UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 9UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 10UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 19UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 11UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 12UL));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 13UL));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 14UL));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 15UL));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16UL));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 17UL));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 18UL));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acceptedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads the ClusterRevision from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ClusterRevision::Id, true,
                                 chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads the FeatureMap from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH reads AttributeList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads optional attribute(ManufacturingDate) in attributeList");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads optional attribute(PartNumber) in attributeList");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000c"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 6: {
            LogStep(6, "TH reads optional attribute(ProductURL) in attributeList");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000d"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 7: {
            LogStep(7, "TH reads optional attribute(ProductLabel) in attributeList");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000e"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 8: {
            LogStep(8, "TH reads optional attribute(SerialNumber) in attributeList");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 9: {
            LogStep(9, "TH reads optional attribute(LocalConfigDisabled) in attributeList");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 10: {
            LogStep(10, "TH reads optional attribute(Reachable) in attributeList");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0011"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 11: {
            LogStep(11, "TH reads optional attribute(UniqueID) in attributeList");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0012"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 12: {
            LogStep(12, "TH1 reads AcceptedCommandList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::AcceptedCommandList::Id, true,
                                 chip::NullOptional);
        }
        case 13: {
            LogStep(13, "TH1 reads GeneratedCommandList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::GeneratedCommandList::Id, true,
                                 chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_BINFO_2_1Suite : public TestCommand
{
public:
    Test_TC_BINFO_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_BINFO_2_1", 68, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_BINFO_2_1Suite()
    {
        if (VendorNameValueBuffer != nullptr)
        {
            chip::Platform::MemoryFree(VendorNameValueBuffer);
            VendorNameValueBuffer = nullptr;
        }
        if (ProductNameValueBuffer != nullptr)
        {
            chip::Platform::MemoryFree(ProductNameValueBuffer);
            ProductNameValueBuffer = nullptr;
        }
        if (NodeLabelValueBuffer != nullptr)
        {
            chip::Platform::MemoryFree(NodeLabelValueBuffer);
            NodeLabelValueBuffer = nullptr;
        }
        if (HardwareVersionStringValueBuffer != nullptr)
        {
            chip::Platform::MemoryFree(HardwareVersionStringValueBuffer);
            HardwareVersionStringValueBuffer = nullptr;
        }
        if (SoftwareVersionStringValueBuffer != nullptr)
        {
            chip::Platform::MemoryFree(SoftwareVersionStringValueBuffer);
            SoftwareVersionStringValueBuffer = nullptr;
        }
        if (ManufacturingDateValueBuffer != nullptr)
        {
            chip::Platform::MemoryFree(ManufacturingDateValueBuffer);
            ManufacturingDateValueBuffer = nullptr;
        }
        if (PartNumberValueBuffer != nullptr)
        {
            chip::Platform::MemoryFree(PartNumberValueBuffer);
            PartNumberValueBuffer = nullptr;
        }
        if (ProductURLValueBuffer != nullptr)
        {
            chip::Platform::MemoryFree(ProductURLValueBuffer);
            ProductURLValueBuffer = nullptr;
        }
        if (ProductLabelValueBuffer != nullptr)
        {
            chip::Platform::MemoryFree(ProductLabelValueBuffer);
            ProductLabelValueBuffer = nullptr;
        }
        if (SerialNumberValueBuffer != nullptr)
        {
            chip::Platform::MemoryFree(SerialNumberValueBuffer);
            SerialNumberValueBuffer = nullptr;
        }
        if (UniqueIDValueBuffer != nullptr)
        {
            chip::Platform::MemoryFree(UniqueIDValueBuffer);
            UniqueIDValueBuffer = nullptr;
        }
    }

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    uint16_t DataModelRevisionValue;
    char * VendorNameValueBuffer = nullptr;
    chip::CharSpan VendorNameValue;
    chip::VendorId VendorIDValue;
    char * ProductNameValueBuffer = nullptr;
    chip::CharSpan ProductNameValue;
    uint16_t ProductIDValue;
    char * NodeLabelValueBuffer = nullptr;
    chip::CharSpan NodeLabelValue;
    uint16_t HardwareVersionValue;
    char * HardwareVersionStringValueBuffer = nullptr;
    chip::CharSpan HardwareVersionStringValue;
    uint32_t SoftwareVersionValue;
    char * SoftwareVersionStringValueBuffer = nullptr;
    chip::CharSpan SoftwareVersionStringValue;
    char * ManufacturingDateValueBuffer = nullptr;
    chip::CharSpan ManufacturingDateValue;
    char * PartNumberValueBuffer = nullptr;
    chip::CharSpan PartNumberValue;
    char * ProductURLValueBuffer = nullptr;
    chip::CharSpan ProductURLValue;
    char * ProductLabelValueBuffer = nullptr;
    chip::CharSpan ProductLabelValue;
    char * SerialNumberValueBuffer = nullptr;
    chip::CharSpan SerialNumberValue;
    char * UniqueIDValueBuffer = nullptr;
    chip::CharSpan UniqueIDValue;
    chip::app::Clusters::Basic::Structs::CapabilityMinimaStruct::DecodableType CapabilityMinimaValue;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65534U));
                DataModelRevisionValue = value;
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("dataModelRevision", value, DataModelRevisionValue));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "char_string", "char_string"));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 32));
                if (VendorNameValueBuffer != nullptr)
                {
                    chip::Platform::MemoryFree(VendorNameValueBuffer);
                }
                VendorNameValueBuffer = static_cast<char *>(chip::Platform::MemoryAlloc(value.size()));
                memcpy(VendorNameValueBuffer, value.data(), value.size());
                VendorNameValue = chip::CharSpan(VendorNameValueBuffer, value.size());
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("vendorName", value, VendorNameValue));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::VendorId value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "vendor_id", "vendor_id"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 1U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65521U));
                VendorIDValue = value;
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::VendorId value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("vendorID", value, VendorIDValue));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "char_string", "char_string"));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 32));
                if (ProductNameValueBuffer != nullptr)
                {
                    chip::Platform::MemoryFree(ProductNameValueBuffer);
                }
                ProductNameValueBuffer = static_cast<char *>(chip::Platform::MemoryAlloc(value.size()));
                memcpy(ProductNameValueBuffer, value.data(), value.size());
                ProductNameValue = chip::CharSpan(ProductNameValueBuffer, value.size());
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("productName", value, ProductNameValue));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 1U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65534U));
                ProductIDValue = value;
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("productID", value, ProductIDValue));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "char_string", "char_string"));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 32));
                if (NodeLabelValueBuffer != nullptr)
                {
                    chip::Platform::MemoryFree(NodeLabelValueBuffer);
                }
                NodeLabelValueBuffer = static_cast<char *>(chip::Platform::MemoryAlloc(value.size()));
                memcpy(NodeLabelValueBuffer, value.data(), value.size());
                NodeLabelValue = chip::CharSpan(NodeLabelValueBuffer, value.size());
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("nodeLabel", value, chip::CharSpan("newnode", 7)));
            }
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "char_string", "char_string"));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 16));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("location", value, chip::CharSpan("in", 2)));
            }
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65534U));
                HardwareVersionValue = value;
            }
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("hardwareVersion", value, HardwareVersionValue));
            }
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "char_string", "char_string"));
                VerifyOrReturn(CheckConstraintMinLength("value", value, 1));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 64));
                if (HardwareVersionStringValueBuffer != nullptr)
                {
                    chip::Platform::MemoryFree(HardwareVersionStringValueBuffer);
                }
                HardwareVersionStringValueBuffer = static_cast<char *>(chip::Platform::MemoryAlloc(value.size()));
                memcpy(HardwareVersionStringValueBuffer, value.data(), value.size());
                HardwareVersionStringValue = chip::CharSpan(HardwareVersionStringValueBuffer, value.size());
            }
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("hardwareVersionString", value, HardwareVersionStringValue));
            }
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0UL));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 4294967294UL));
                SoftwareVersionValue = value;
            }
            break;
        case 32:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 33:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 34:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("softwareVersion", value, SoftwareVersionValue));
            }
            break;
        case 35:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinLength("value", value, 1));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 64));
                if (SoftwareVersionStringValueBuffer != nullptr)
                {
                    chip::Platform::MemoryFree(SoftwareVersionStringValueBuffer);
                }
                SoftwareVersionStringValueBuffer = static_cast<char *>(chip::Platform::MemoryAlloc(value.size()));
                memcpy(SoftwareVersionStringValueBuffer, value.data(), value.size());
                SoftwareVersionStringValue = chip::CharSpan(SoftwareVersionStringValueBuffer, value.size());
            }
            break;
        case 36:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 37:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("softwareVersionString", value, SoftwareVersionStringValue));
            }
            break;
        case 38:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "char_string", "char_string"));
                VerifyOrReturn(CheckConstraintMinLength("value", value, 8));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 16));
                if (ManufacturingDateValueBuffer != nullptr)
                {
                    chip::Platform::MemoryFree(ManufacturingDateValueBuffer);
                }
                ManufacturingDateValueBuffer = static_cast<char *>(chip::Platform::MemoryAlloc(value.size()));
                memcpy(ManufacturingDateValueBuffer, value.data(), value.size());
                ManufacturingDateValue = chip::CharSpan(ManufacturingDateValueBuffer, value.size());
            }
            break;
        case 39:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 40:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 41:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("manufacturingDate", value, ManufacturingDateValue));
            }
            break;
        case 42:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "char_string", "char_string"));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 32));
                if (PartNumberValueBuffer != nullptr)
                {
                    chip::Platform::MemoryFree(PartNumberValueBuffer);
                }
                PartNumberValueBuffer = static_cast<char *>(chip::Platform::MemoryAlloc(value.size()));
                memcpy(PartNumberValueBuffer, value.data(), value.size());
                PartNumberValue = chip::CharSpan(PartNumberValueBuffer, value.size());
            }
            break;
        case 43:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 44:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("partNumber", value, PartNumberValue));
            }
            break;
        case 45:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "long_char_string", "long_char_string"));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 256));
                if (ProductURLValueBuffer != nullptr)
                {
                    chip::Platform::MemoryFree(ProductURLValueBuffer);
                }
                ProductURLValueBuffer = static_cast<char *>(chip::Platform::MemoryAlloc(value.size()));
                memcpy(ProductURLValueBuffer, value.data(), value.size());
                ProductURLValue = chip::CharSpan(ProductURLValueBuffer, value.size());
            }
            break;
        case 46:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 47:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 48:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("productURL", value, ProductURLValue));
            }
            break;
        case 49:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "char_string", "char_string"));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 64));
                if (ProductLabelValueBuffer != nullptr)
                {
                    chip::Platform::MemoryFree(ProductLabelValueBuffer);
                }
                ProductLabelValueBuffer = static_cast<char *>(chip::Platform::MemoryAlloc(value.size()));
                memcpy(ProductLabelValueBuffer, value.data(), value.size());
                ProductLabelValue = chip::CharSpan(ProductLabelValueBuffer, value.size());
            }
            break;
        case 50:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 51:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 52:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("productLabel", value, ProductLabelValue));
            }
            break;
        case 53:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "char_string", "char_string"));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 32));
                if (SerialNumberValueBuffer != nullptr)
                {
                    chip::Platform::MemoryFree(SerialNumberValueBuffer);
                }
                SerialNumberValueBuffer = static_cast<char *>(chip::Platform::MemoryAlloc(value.size()));
                memcpy(SerialNumberValueBuffer, value.data(), value.size());
                SerialNumberValue = chip::CharSpan(SerialNumberValueBuffer, value.size());
            }
            break;
        case 54:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 55:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("serialNumber", value, SerialNumberValue));
            }
            break;
        case 56:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("localConfigDisabled", value, false));
                VerifyOrReturn(CheckConstraintType("value", "boolean", "boolean"));
            }
            break;
        case 57:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 58:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("localConfigDisabled", value, true));
            }
            break;
        case 59:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("reachable", value, true));
                VerifyOrReturn(CheckConstraintType("value", "boolean", "boolean"));
            }
            break;
        case 60:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 61:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("reachable", value, true));
                VerifyOrReturn(CheckConstraintType("value", "boolean", "boolean"));
            }
            break;
        case 62:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "char_string", "char_string"));
                VerifyOrReturn(CheckConstraintMaxLength("value", value, 32));
                if (UniqueIDValueBuffer != nullptr)
                {
                    chip::Platform::MemoryFree(UniqueIDValueBuffer);
                }
                UniqueIDValueBuffer = static_cast<char *>(chip::Platform::MemoryAlloc(value.size()));
                memcpy(UniqueIDValueBuffer, value.data(), value.size());
                UniqueIDValue = chip::CharSpan(UniqueIDValueBuffer, value.size());
            }
            break;
        case 63:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 64:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::CharSpan value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueAsString("uniqueID", value, UniqueIDValue));
            }
            break;
        case 65:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::Clusters::Basic::Structs::CapabilityMinimaStruct::DecodableType value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                CapabilityMinimaValue = value;
            }
            break;
        case 66:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 67:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::Clusters::Basic::Structs::CapabilityMinimaStruct::DecodableType value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "During Commissioning, TH Saves the CountryCode Information from SetRegulatoryConfig command");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 2: {
            LogStep(2, "TH reads DataModelRevision from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::DataModelRevision::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH writes DataModelRevision from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint16_t value;
            value = 4388U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::DataModelRevision::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads DataModelRevision from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::DataModelRevision::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads VendorName from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::VendorName::Id, true,
                                 chip::NullOptional);
        }
        case 6: {
            LogStep(6, "TH writes VendorName from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("samplegarbage: not in length on purpose", 6);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::VendorName::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 7: {
            LogStep(7, "TH reads VendorName from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::VendorName::Id, true,
                                 chip::NullOptional);
        }
        case 8: {
            LogStep(8, "TH reads VendorID from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::VendorID::Id, true,
                                 chip::NullOptional);
        }
        case 9: {
            LogStep(9, "Verify that VendorID matches the value assigned to this manufacturer");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && BINFO.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 10: {
            LogStep(10, "TH writes VendorID from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::VendorId value;
            value = static_cast<chip::VendorId>(17);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::VendorID::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "TH reads VendorID from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::VendorID::Id, true,
                                 chip::NullOptional);
        }
        case 12: {
            LogStep(12, "TH reads ProductName from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductName::Id, true,
                                 chip::NullOptional);
        }
        case 13: {
            LogStep(13, "TH writes ProductName from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("newproductgarbage: not in length on purpose", 10);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductName::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "TH reads ProductName from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductName::Id, true,
                                 chip::NullOptional);
        }
        case 15: {
            LogStep(15, "TH reads ProductID from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductID::Id, true,
                                 chip::NullOptional);
        }
        case 16: {
            LogStep(16, "TH writes ProductID from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint16_t value;
            value = 17697U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductID::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "TH reads ProductID from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductID::Id, true,
                                 chip::NullOptional);
        }
        case 18: {
            LogStep(18, "TH reads NodeLabel from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::NodeLabel::Id, true,
                                 chip::NullOptional);
        }
        case 19: {
            LogStep(19, "TH writes NodeLabel from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("newnodegarbage: not in length on purpose", 7);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::NodeLabel::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 20: {
            LogStep(20, "TH reads NodeLabel from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::NodeLabel::Id, true,
                                 chip::NullOptional);
        }
        case 21: {
            LogStep(21, "TH reads Location from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::Location::Id, true,
                                 chip::NullOptional);
        }
        case 22: {
            LogStep(22, "Verify that the Location is same as CountryCode value saved from step1");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && BINFO.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 23: {
            LogStep(23, "TH write Location from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("ingarbage: not in length on purpose", 2);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::Location::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 24: {
            LogStep(24, "TH reads Location from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::Location::Id, true,
                                 chip::NullOptional);
        }
        case 25: {
            LogStep(25, "TH reads HardwareVersion from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::HardwareVersion::Id, true,
                                 chip::NullOptional);
        }
        case 26: {
            LogStep(26, "TH writes HardwareVersion from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint16_t value;
            value = 17713U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::HardwareVersion::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 27: {
            LogStep(27, "TH reads HardwareVersion from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::HardwareVersion::Id, true,
                                 chip::NullOptional);
        }
        case 28: {
            LogStep(28, "TH reads HardwareVersionString from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::HardwareVersionString::Id, true,
                                 chip::NullOptional);
        }
        case 29: {
            LogStep(29, "TH writes HardwareVersionString from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("newhardwareversiongarbage: not in length on purpose", 18);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::HardwareVersionString::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 30: {
            LogStep(30, "TH reads HardwareVersionString from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::HardwareVersionString::Id, true,
                                 chip::NullOptional);
        }
        case 31: {
            LogStep(31, "TH reads SoftwareVersion from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0009"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::SoftwareVersion::Id, true,
                                 chip::NullOptional);
        }
        case 32: {
            LogStep(32,
                    "Verify that the SoftwareVersion is not displayed to the end-user through any device specific means (ex: "
                    "screen, audio)");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && BINFO.S.A0009"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 33: {
            LogStep(33, "TH writes SoftwareVersion from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0009"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint32_t value;
            value = 33299UL;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::SoftwareVersion::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 34: {
            LogStep(34, "TH reads SoftwareVersion from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0009"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::SoftwareVersion::Id, true,
                                 chip::NullOptional);
        }
        case 35: {
            LogStep(35, "TH reads SoftwareVersionString from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000a"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::SoftwareVersionString::Id, true,
                                 chip::NullOptional);
        }
        case 36: {
            LogStep(36, "TH writes SoftwareVersionString from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000a"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("1.0garbage: not in length on purpose", 3);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::SoftwareVersionString::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 37: {
            LogStep(37, "TH reads SoftwareVersionString from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000a"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::SoftwareVersionString::Id, true,
                                 chip::NullOptional);
        }
        case 38: {
            LogStep(38, "TH reads ManufacturingDate from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ManufacturingDate::Id, true,
                                 chip::NullOptional);
        }
        case 39: {
            LogStep(39, "Verify if the first 8 characters specify date according to ISO 8601, i.e, YYYYMMDD");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && BINFO.S.A000b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 40: {
            LogStep(40, "TH writes ManufacturingDate from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("20210814789452INgarbage: not in length on purpose", 16);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ManufacturingDate::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 41: {
            LogStep(41, "TH reads ManufacturingDate from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000b"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ManufacturingDate::Id, true,
                                 chip::NullOptional);
        }
        case 42: {
            LogStep(42, "TH reads PartNumber from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000c"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::PartNumber::Id, true,
                                 chip::NullOptional);
        }
        case 43: {
            LogStep(43, "TH writes PartNumber from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000c"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("newpartgarbage: not in length on purpose", 7);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::PartNumber::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 44: {
            LogStep(44, "TH reads PartNumber from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000c"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::PartNumber::Id, true,
                                 chip::NullOptional);
        }
        case 45: {
            LogStep(45, "TH reads ProductURL from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000d"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductURL::Id, true,
                                 chip::NullOptional);
        }
        case 46: {
            LogStep(46,
                    "Verify that it specifies a link to a specific web page, Verify that it follows the syntax rules specified in "
                    "RFC 3986.");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && BINFO.S.A000d"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 47: {
            LogStep(47, "TH writes ProductURL from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000d"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("https://www.example.comgarbage: not in length on purpose", 23);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductURL::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 48: {
            LogStep(48, "TH reads ProductURL from the DUT");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000d"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductURL::Id, true,
                                 chip::NullOptional);
        }
        case 49: {
            LogStep(49, "TH reads ProductLabel from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000e"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductLabel::Id, true,
                                 chip::NullOptional);
        }
        case 50: {
            LogStep(50, "Verify that it does not include the name of the vendor as defined within the VendorName attribute");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && BINFO.S.A000e"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 51: {
            LogStep(51, "TH writes ProductLabel from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000e"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("newproductlabelgarbage: not in length on purpose", 15);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductLabel::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 52: {
            LogStep(52, "TH reads ProductLabel from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000e"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::ProductLabel::Id, true,
                                 chip::NullOptional);
        }
        case 53: {
            LogStep(53, "TH reads SerialNumber from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::SerialNumber::Id, true,
                                 chip::NullOptional);
        }
        case 54: {
            LogStep(54, "TH writes SerialNumber from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("newserialnumbergarbage: not in length on purpose", 15);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::SerialNumber::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 55: {
            LogStep(55, "TH reads SerialNumber from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::SerialNumber::Id, true,
                                 chip::NullOptional);
        }
        case 56: {
            LogStep(56, "TH reads LocalConfigDisabled from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::LocalConfigDisabled::Id, true,
                                 chip::NullOptional);
        }
        case 57: {
            LogStep(57, "TH sets LocalConfigDisabled to True");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            bool value;
            value = true;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::LocalConfigDisabled::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 58: {
            LogStep(58, "TH reads LocalConfigDisabled from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::LocalConfigDisabled::Id, true,
                                 chip::NullOptional);
        }
        case 59: {
            LogStep(59, "TH reads Reachable from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0011"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::Reachable::Id, true,
                                 chip::NullOptional);
        }
        case 60: {
            LogStep(60, "TH sends Write request message to DUT to change value of Reachable to false");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0011"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            bool value;
            value = false;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::Reachable::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 61: {
            LogStep(61, "TH reads Reachable from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0011"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::Reachable::Id, true,
                                 chip::NullOptional);
        }
        case 62: {
            LogStep(62, "TH reads UniqueID from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0012"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::UniqueID::Id, true,
                                 chip::NullOptional);
        }
        case 63: {
            LogStep(63, "TH writes UniqueID from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0012"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::CharSpan value;
            value = chip::Span<const char>("newidgarbage: not in length on purpose", 5);
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::UniqueID::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 64: {
            LogStep(64, "TH reads UniqueID from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0012"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::UniqueID::Id, true,
                                 chip::NullOptional);
        }
        case 65: {
            LogStep(65, "TH reads CapabilityMinima attribute from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0013"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::CapabilityMinima::Id, true,
                                 chip::NullOptional);
        }
        case 66: {
            LogStep(66, "TH writes CapabilityMinima from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0013"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Basic::Structs::CapabilityMinimaStruct::Type value;

            value.caseSessionsPerFabric  = 4U;
            value.subscriptionsPerFabric = 4U;

            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::CapabilityMinima::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 67: {
            LogStep(67, "TH reads CapabilityMinima attribute from the DUT.");
            VerifyOrDo(!ShouldSkip("BINFO.S.A0013"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Basic::Id, Basic::Attributes::CapabilityMinima::Id, true,
                                 chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CNET_1_3Suite : public TestCommand
{
public:
    Test_TC_CNET_1_3Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CNET_1_3", 0, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CNET_1_3Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_DESC_1_1Suite : public TestCommand
{
public:
    Test_TC_DESC_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_DESC_1_1", 6, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_DESC_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acceptedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Read the global attribute: ClusterRevision");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Descriptor::Id, Descriptor::Attributes::ClusterRevision::Id, true,
                                 chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Read the global attribute: FeatureMap");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Descriptor::Id, Descriptor::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Read the global attribute: AttributeList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Descriptor::Id, Descriptor::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Read the global attribute: AcceptedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Descriptor::Id, Descriptor::Attributes::AcceptedCommandList::Id,
                                 true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Read the global attribute: GeneratedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), Descriptor::Id, Descriptor::Attributes::GeneratedCommandList::Id,
                                 true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_DLOG_1_1Suite : public TestCommand
{
public:
    Test_TC_DLOG_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_DLOG_1_1", 6, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_DLOG_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("acceptedCommandList", iter_0, 0));
                    VerifyOrReturn(CheckValue("acceptedCommandList[0]", iter_0.GetValue(), 0UL));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acceptedCommandList", iter_0, 1));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNextListItemDecodes<decltype(value)>("generatedCommandList", iter_0, 0));
                    VerifyOrReturn(CheckValue("generatedCommandList[0]", iter_0.GetValue(), 1UL));
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 1));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads the ClusterRevision from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), DiagnosticLogs::Id,
                                 DiagnosticLogs::Attributes::ClusterRevision::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads the FeatureMap from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), DiagnosticLogs::Id, DiagnosticLogs::Attributes::FeatureMap::Id,
                                 true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH reads AttributeList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), DiagnosticLogs::Id, DiagnosticLogs::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads AcceptedCommandList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), DiagnosticLogs::Id,
                                 DiagnosticLogs::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads GeneratedCommandList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), DiagnosticLogs::Id,
                                 DiagnosticLogs::Attributes::GeneratedCommandList::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_DGETH_1_1Suite : public TestCommand
{
public:
    Test_TC_DGETH_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_DGETH_1_1", 18, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_DGETH_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
                VerifyOrReturn(CheckConstraintHasMasksSet("value", value, 1UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
                VerifyOrReturn(CheckConstraintHasMasksSet("value", value, 2UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 5UL));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 6UL));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 7UL));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 8UL));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acceptedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads the ClusterRevision from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::ClusterRevision::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads the FeatureMap from DUT");
            VerifyOrDo(!ShouldSkip(" !DGETH.S.F00 && !DGETH.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::FeatureMap::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Given DGETH.S.F00 ensure featuremap has the correct bit set");
            VerifyOrDo(!ShouldSkip("DGETH.S.F00"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::FeatureMap::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Given DGETH.S.F01 ensure featuremap has the correct bit set");
            VerifyOrDo(!ShouldSkip("DGETH.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::FeatureMap::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads AttributeList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6, "TH reads optional attribute(PHYRate) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 7: {
            LogStep(7, "TH reads optional attribute(FullDuplex) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F00(PKTCNT)) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 9: {
            LogStep(9, "TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F00(PKTCNT)) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F01(ERRCNT)) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F01(ERRCNT)) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 12: {
            LogStep(12, "TH reads optional attribute(PacketRxCount) and Feature dependent(DGETH.S.F01(ERRCNT)) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "TH reads optional attribute(CarrierDetect) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "TH reads optional attribute(TimeSinceReset) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 15: {
            LogStep(15, "TH reads AcceptedCommandList from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.F00 || DGETH.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 16: {
            LogStep(16, "TH reads AcceptedCommandList from DUT");
            VerifyOrDo(!ShouldSkip(" !DGETH.S.F00 && !DGETH.S.F01 "), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "TH reads GeneratedCommandList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::GeneratedCommandList::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_DGETH_2_1Suite : public TestCommand
{
public:
    Test_TC_DGETH_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_DGETH_2_1", 17, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_DGETH_2_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9U));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<bool> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "boolean", "boolean"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int64u", "int64u"));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int64u", "int64u"));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int64u", "int64u"));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int64u", "int64u"));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int64u", "int64u"));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<bool> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "boolean", "boolean"));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int64u", "int64u"));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Read PHYRate attribute constraints");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PHYRate::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Read FullDuplex attribute constraints");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::FullDuplex::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Read PacketRxCount attribute constraints");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PacketRxCount::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Read PacketRxCount value from DUT and verify the number of packets received on ethernet network interface");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "Read PacketTxCount attribute constraints");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PacketTxCount::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Read PacketTxCount value from DUT and verify the number of packets received on ethernet network interface");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "Read TxErrCount attribute constraints");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::TxErrCount::Id, true, chip::NullOptional);
        }
        case 8: {
            LogStep(8,
                    "Read TxErrCount value from DUT and verify value indicates the number of failed packet transmission on "
                    "ethernet network interface");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9, "Read CollisionCount attribute constraints");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::CollisionCount::Id, true, chip::NullOptional);
        }
        case 10: {
            LogStep(10,
                    "Read CollisionCount value from DUT and verify value indicates the number of collision occurred while "
                    "transmitting packets on ethernet network interface");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 11: {
            LogStep(11, "Read OverrunCount attribute constraints");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::OverrunCount::Id, true, chip::NullOptional);
        }
        case 12: {
            LogStep(12,
                    "Read OverrunCount value from DUT and verify value indicates the number of packets dropped due to lack of "
                    "buffer memory on ethernet network interface");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 13: {
            LogStep(13, "Read CarrierDetect attribute constraints");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::CarrierDetect::Id, true, chip::NullOptional);
        }
        case 14: {
            LogStep(14,
                    "Read CarrierDetect value from DUT and verify value indicates the presence of carrier detect control signal on "
                    "ethernet network interface");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 15: {
            LogStep(15, "Read TimeSinceReset attribute constraints");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::TimeSinceReset::Id, true, chip::NullOptional);
        }
        case 16: {
            LogStep(16, "Read TimeSinceReset value from DUT and verify the value indicates the duration of time, in minutes");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && DGETH.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_DGETH_2_2Suite : public TestCommand
{
public:
    Test_TC_DGETH_2_2Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_DGETH_2_2", 22, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_DGETH_2_2Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    uint64_t PacketRxCount;
    uint64_t PacketTxCount;
    uint64_t TxErrCount;
    uint64_t CollisionCount;
    uint64_t OverrunCount;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9U));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9U));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9U));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9U));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9U));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9U));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9U));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9U));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<chip::app::Clusters::EthernetNetworkDiagnostics::PHYRateType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 9U));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                PacketRxCount = value;
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                PacketTxCount = value;
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                TxErrCount = value;
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                CollisionCount = value;
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                OverrunCount = value;
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, PacketRxCount));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, PacketTxCount));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, TxErrCount));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, CollisionCount));
            }
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, OverrunCount));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads PHYRate attribute from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PHYRate::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads PHYRate attribute from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PHYRate::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH reads PHYRate attribute from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PHYRate::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads PHYRate attribute from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PHYRate::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads PHYRate attribute from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PHYRate::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6, "TH reads PHYRate attribute from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PHYRate::Id, true, chip::NullOptional);
        }
        case 7: {
            LogStep(7, "TH reads PHYRate attribute from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PHYRate::Id, true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "TH reads PHYRate attribute from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PHYRate::Id, true, chip::NullOptional);
        }
        case 9: {
            LogStep(9, "TH reads PHYRate attribute from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PHYRate::Id, true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "TH reads PHYRate attribute from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PHYRate::Id, true, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "TH reads PacketRxCount attribute value from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PacketRxCount::Id, true, chip::NullOptional);
        }
        case 12: {
            LogStep(12, "TH reads PacketTxCount attribute value from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PacketTxCount::Id, true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "TH reads TxErrCount attribute value from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::TxErrCount::Id, true, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "TH reads CollisionCount attribute value from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::CollisionCount::Id, true, chip::NullOptional);
        }
        case 15: {
            LogStep(15, "TH reads OverrunCount attribute value from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::OverrunCount::Id, true, chip::NullOptional);
        }
        case 16: {
            LogStep(16, "Sends ResetCounts command");
            VerifyOrDo(!ShouldSkip("DGETH.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::EthernetNetworkDiagnostics::Commands::ResetCounts::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                               EthernetNetworkDiagnostics::Commands::ResetCounts::Id, value, chip::NullOptional

            );
        }
        case 17: {
            LogStep(17, "TH reads PacketRxCount attribute value from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PacketRxCount::Id, true, chip::NullOptional);
        }
        case 18: {
            LogStep(18, "TH reads PacketTxCount attribute value from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::PacketTxCount::Id, true, chip::NullOptional);
        }
        case 19: {
            LogStep(19, "TH reads TxErrCount attribute value from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::TxErrCount::Id, true, chip::NullOptional);
        }
        case 20: {
            LogStep(20, "TH reads CollisionCount attribute value from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::CollisionCount::Id, true, chip::NullOptional);
        }
        case 21: {
            LogStep(21, "TH reads OverrunCount attribute value from DUT");
            VerifyOrDo(!ShouldSkip("DGETH.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), EthernetNetworkDiagnostics::Id,
                                 EthernetNetworkDiagnostics::Attributes::OverrunCount::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_FLW_1_1Suite : public TestCommand
{
public:
    Test_TC_FLW_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_FLW_1_1", 7, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_FLW_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 3U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acceptedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Read the global attribute: ClusterRevision");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FlowMeasurement::Id,
                                 FlowMeasurement::Attributes::ClusterRevision::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Read the global attribute: FeatureMap");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FlowMeasurement::Id, FlowMeasurement::Attributes::FeatureMap::Id,
                                 true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Read the global attribute: AttributeList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FlowMeasurement::Id,
                                 FlowMeasurement::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Read the optional attribute(Tolerance) in AttributeList");
            VerifyOrDo(!ShouldSkip("FLW.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FlowMeasurement::Id,
                                 FlowMeasurement::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Read the global attribute: AcceptedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FlowMeasurement::Id,
                                 FlowMeasurement::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Read the global attribute: GeneratedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FlowMeasurement::Id,
                                 FlowMeasurement::Attributes::GeneratedCommandList::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_FLW_2_1Suite : public TestCommand
{
public:
    Test_TC_FLW_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_FLW_2_1", 5, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_FLW_2_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65533U));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65534U));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2048U));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Read the mandatory attribute: MinMeasuredValue");
            VerifyOrDo(!ShouldSkip("FLW.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FlowMeasurement::Id,
                                 FlowMeasurement::Attributes::MinMeasuredValue::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Read the mandatory attribute: MaxMeasuredValue");
            VerifyOrDo(!ShouldSkip("FLW.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FlowMeasurement::Id,
                                 FlowMeasurement::Attributes::MaxMeasuredValue::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Read the mandatory attribute: MeasuredValue");
            VerifyOrDo(!ShouldSkip("FLW.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FlowMeasurement::Id,
                                 FlowMeasurement::Attributes::MeasuredValue::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads from the DUT the Tolerance attribute");
            VerifyOrDo(!ShouldSkip("FLW.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FlowMeasurement::Id, FlowMeasurement::Attributes::Tolerance::Id,
                                 true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_FLABEL_1_1Suite : public TestCommand
{
public:
    Test_TC_FLABEL_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_FLABEL_1_1", 6, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_FLABEL_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acceptedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads the ClusterRevision from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FixedLabel::Id, FixedLabel::Attributes::ClusterRevision::Id, true,
                                 chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads the FeatureMap from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FixedLabel::Id, FixedLabel::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH reads AttributeList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FixedLabel::Id, FixedLabel::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads AcceptedCommandList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FixedLabel::Id, FixedLabel::Attributes::AcceptedCommandList::Id,
                                 true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads GeneratedCommandList from DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FixedLabel::Id, FixedLabel::Attributes::GeneratedCommandList::Id,
                                 true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_FLABEL_2_1Suite : public TestCommand
{
public:
    Test_TC_FLABEL_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_FLABEL_2_1", 4, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_FLABEL_2_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::app::Clusters::FixedLabel::Structs::LabelStruct::DecodableType> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), EMBER_ZCL_STATUS_UNSUPPORTED_WRITE));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads LabelList from the DUT");
            VerifyOrDo(!ShouldSkip("FLABEL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), FixedLabel::Id, FixedLabel::Attributes::LabelList::Id, true,
                                 chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH tries to write LabelList attribute of the DUT by setting Label = Test_Label, Value= Test_Value");
            VerifyOrDo(!ShouldSkip("FLABEL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::DataModel::List<const chip::app::Clusters::FixedLabel::Structs::LabelStruct::Type> value;

            {
                auto * listHolder_0 = new ListHolder<chip::app::Clusters::FixedLabel::Structs::LabelStruct::Type>(1);
                listFreer.add(listHolder_0);

                listHolder_0->mList[0].label = chip::Span<const char>("Test_Labelgarbage: not in length on purpose", 10);
                listHolder_0->mList[0].value = chip::Span<const char>("Test_Valuegarbage: not in length on purpose", 10);

                value =
                    chip::app::DataModel::List<chip::app::Clusters::FixedLabel::Structs::LabelStruct::Type>(listHolder_0->mList, 1);
            }
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), FixedLabel::Id, FixedLabel::Attributes::LabelList::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH reads LabelList from the DUT");
            VerifyOrDo(!ShouldSkip("PICS_SKIP_SAMPLE_APP && FLABEL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Enter 'y' after successgarbage: not in length on purpose", 23);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CGEN_1_1Suite : public TestCommand
{
public:
    Test_TC_CGEN_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CGEN_1_1", 6, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CGEN_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 5UL));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Read the global attribute: ClusterRevision");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                 GeneralCommissioning::Attributes::ClusterRevision::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Read the global attribute: FeatureMap");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                 GeneralCommissioning::Attributes::FeatureMap::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Read the global attribute: AttributeList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                 GeneralCommissioning::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Read the global attribute: AcceptedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                 GeneralCommissioning::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Read the global attribute: GeneratedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                 GeneralCommissioning::Attributes::GeneratedCommandList::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_CGEN_2_1Suite : public TestCommand
{
public:
    Test_TC_CGEN_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_CGEN_2_1", 8, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_CGEN_2_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int64u", "int64u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("breadcrumb", value, 1ULL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::Clusters::GeneralCommissioning::RegulatoryLocationType value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2U));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::Clusters::GeneralCommissioning::Structs::BasicCommissioningInfo::DecodableType value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "boolean", "boolean"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH1 reads the BreadCrumb Attribute from the DUT");
            VerifyOrDo(!ShouldSkip("CGEN.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                 GeneralCommissioning::Attributes::Breadcrumb::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH1 writes the BreadCrumb attribute as 1 to the DUT");
            VerifyOrDo(!ShouldSkip("CGEN.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint64_t value;
            value = 1ULL;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                  GeneralCommissioning::Attributes::Breadcrumb::Id, value, chip::NullOptional, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH1 reads the BreadCrumb attribute from the DUT");
            VerifyOrDo(!ShouldSkip("CGEN.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                 GeneralCommissioning::Attributes::Breadcrumb::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH1 reads the RegulatoryConfig attribute from the DUT");
            VerifyOrDo(!ShouldSkip("CGEN.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                 GeneralCommissioning::Attributes::RegulatoryConfig::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH1 reads the LocationCapability attribute from the DUT");
            VerifyOrDo(!ShouldSkip("CGEN.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                 GeneralCommissioning::Attributes::LocationCapability::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6,
                    "TH1 reads BasicCommissioningInfo attribute from DUT and Verify that the BasicCommissioningInfo attribute has "
                    "the following field: FailSafeExpiryLengthSeconds field value is within a duration range of 0 to 65535");
            VerifyOrDo(!ShouldSkip("CGEN.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                 GeneralCommissioning::Attributes::BasicCommissioningInfo::Id, true, chip::NullOptional);
        }
        case 7: {
            LogStep(7, "TH1 reads SupportsConcurrentConnection attribute from the DUT");
            VerifyOrDo(!ShouldSkip("CGEN.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralCommissioning::Id,
                                 GeneralCommissioning::Attributes::SupportsConcurrentConnection::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_DGGEN_1_1Suite : public TestCommand
{
public:
    Test_TC_DGGEN_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_DGGEN_1_1", 12, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_DGGEN_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 8UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 5UL));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 6UL));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 7UL));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Read the global attribute: ClusterRevision");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::ClusterRevision::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Read the global attribute: FeatureMap");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::FeatureMap::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Read the global attribute: AttributeList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Read optional attribute(UpTime) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGGEN.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Read optional attribute(TotalOperationalHours) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGGEN.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Read optional attribute(BootReason) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGGEN.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 7: {
            LogStep(7, "Read optional attribute(ActiveHardwareFaults) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGGEN.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Read optional attribute(ActiveRadioFaults) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGGEN.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 9: {
            LogStep(9, "Read optional attribute(ActiveNetworkFaults) in AttributeList");
            VerifyOrDo(!ShouldSkip("DGGEN.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Read the global attribute: AcceptedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Read the global attribute: GeneratedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::GeneratedCommandList::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_DGGEN_2_1Suite : public TestCommand
{
public:
    Test_TC_DGGEN_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_DGGEN_2_1", 18, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_DGGEN_2_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<
                    chip::app::Clusters::GeneralDiagnostics::Structs::NetworkInterfaceType::DecodableType>
                    value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint64_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int64u", "int64u"));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int32u", "int32u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0UL));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 4294967294UL));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 6U));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads NetworkInterfaces structure attribute from DUT.");
            VerifyOrDo(!ShouldSkip("DGGEN.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::NetworkInterfaces::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads a RebootCount attribute value from DUT.");
            VerifyOrDo(!ShouldSkip("DGGEN.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::RebootCount::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Reboot target device");
            VerifyOrDo(!ShouldSkip("PICS_SDK_CI_ONLY"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::SystemCommands::Commands::Reboot::Type value;
            return Reboot(kIdentityAlpha, value);
        }
        case 4: {
            LogStep(4, "Reboot target device(DUT)");
            VerifyOrDo(!ShouldSkip("PICS_SKIP_SAMPLE_APP"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message =
                chip::Span<const char>("Please reboot the DUT and enter 'y' after DUT startsgarbage: not in length on purpose", 52);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "Reboot target device");
            VerifyOrDo(!ShouldSkip("PICS_SDK_CI_ONLY"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::SystemCommands::Commands::Reboot::Type value;
            return Reboot(kIdentityAlpha, value);
        }
        case 6: {
            LogStep(6, "Reboot target device(DUT)");
            VerifyOrDo(!ShouldSkip("PICS_SKIP_SAMPLE_APP"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message =
                chip::Span<const char>("Please reboot the DUT and enter 'y' after DUT startsgarbage: not in length on purpose", 52);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 8: {
            LogStep(8,
                    "DUT reboots and TH reads a UpTime attribute value of DUT since some arbitrary start time of DUT rebooting.");
            VerifyOrDo(!ShouldSkip("DGGEN.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id, GeneralDiagnostics::Attributes::UpTime::Id,
                                 true, chip::NullOptional);
        }
        case 9: {
            LogStep(9, "TH reads a TotalOperationalHours attribute value from DUT.");
            VerifyOrDo(!ShouldSkip("DGGEN.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::TotalOperationalHours::Id, true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Reboot target device");
            VerifyOrDo(!ShouldSkip("PICS_SDK_CI_ONLY"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::SystemCommands::Commands::Reboot::Type value;
            return Reboot(kIdentityAlpha, value);
        }
        case 11: {
            LogStep(11, "Reboot target device(DUT)");
            VerifyOrDo(!ShouldSkip("PICS_SKIP_SAMPLE_APP"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message =
                chip::Span<const char>("Please reboot the DUT and enter 'y' after DUT startsgarbage: not in length on purpose", 52);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 12: {
            LogStep(12, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 13: {
            LogStep(13, "TH reads BootReason attribute value from DUT.");
            VerifyOrDo(!ShouldSkip("DGGEN.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(0), GeneralDiagnostics::Id,
                                 GeneralDiagnostics::Attributes::BootReasons::Id, true, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "TH reads ActiveHardwareFaults attribute value from DUT.");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && DGGEN.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 15: {
            LogStep(15, "TH reads ActiveRadioFaults attribute value from DUT.");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && DGGEN.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 16: {
            LogStep(16, "TH reads ActiveNetworkFaults attribute value from DUT.");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && DGGEN.S.A0007"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 17: {
            LogStep(17, "TH reads TestEventTriggersEnabled attribute value");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && DGGEN.S.A0008"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_I_1_1Suite : public TestCommand
{
public:
    Test_TC_I_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_I_1_1", 7, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_I_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 4U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 64UL));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads the ClusterRevision attribute from the DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::ClusterRevision::Id, true,
                                 chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads the FeatureMap attribute from the DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Read the global attribute: AttributeList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::AttributeList::Id, true,
                                 chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Read the global attribute: AcceptedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::AcceptedCommandList::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Read the optional command(TriggerEffect) in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::AcceptedCommandList::Id, true,
                                 chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Read the global attribute: GeneratedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::GeneratedCommandList::Id, true,
                                 chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_I_2_1Suite : public TestCommand
{
public:
    Test_TC_I_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_I_2_1", 3, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_I_2_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 5U));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads the IdentifyTime attribute from the DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::IdentifyTime::Id, true,
                                 chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads the IdentifyType attribute from the DUT");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::IdentifyType::Id, true,
                                 chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_I_2_2Suite : public TestCommand
{
public:
    Test_TC_I_2_2Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_I_2_2", 11, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_I_2_2Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 51U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 69U));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 42U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 58U));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("identifyTime", value, 0U));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 5U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 15U));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH sends Identify command to DUT, with the identify time field set to 0x003c (60s).");
            VerifyOrDo(!ShouldSkip("I.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::Identify::Type value;
            value.identifyTime = 60U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::Identify::Id, value,
                               chip::NullOptional

            );
        }
        case 2: {
            LogStep(2, "TH reads immediately IdentifyTime attribute from DUT");
            VerifyOrDo(!ShouldSkip("I.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::IdentifyTime::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Wait 10000ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 4: {
            LogStep(4, "After 10 seconds, the TH reads IdentifyTime attribute from DUT");
            VerifyOrDo(!ShouldSkip("I.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::IdentifyTime::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5,
                    "TH sends IdentifyQuery command to DUT and Verify IdentifyQueryResponse command to TH,with the Timeout field "
                    "set to a value in the range 0x0000 to 0x0032");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && I.S.C01.Rsp && I.S.C00.Tx"),
                       return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 6: {
            LogStep(6, "TH sends Identify command to DUT, with the identify time field set to 0x0000 (stop identifying).");
            VerifyOrDo(!ShouldSkip("I.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::Identify::Type value;
            value.identifyTime = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::Identify::Id, value,
                               chip::NullOptional

            );
        }
        case 7: {
            LogStep(7, "TH reads immediately IdentifyTime attribute from DUT");
            VerifyOrDo(!ShouldSkip("I.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::IdentifyTime::Id, true,
                                 chip::NullOptional);
        }
        case 8: {
            LogStep(8, "TH writes a value of 0x000f (15s) to IdentifyTime attribute of DUT");
            VerifyOrDo(!ShouldSkip("I.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint16_t value;
            value = 15U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::IdentifyTime::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 9: {
            LogStep(9, "Wait 5000ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 10: {
            LogStep(10, "After 5 seconds, the TH reads IdentifyTime attribute from DUT");
            VerifyOrDo(!ShouldSkip("I.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Attributes::IdentifyTime::Id, true,
                                 chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_I_2_3Suite : public TestCommand
{
public:
    Test_TC_I_2_3Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_I_2_3", 21, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_I_2_3Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "1.Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1,
                    "TH sends TriggerEffect command to DUT with the effect identifier field set to 0x00 blink and the effect "
                    "variant field set to 0x00 default");
            VerifyOrDo(!ShouldSkip("I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::TriggerEffect::Type value;
            value.effectIdentifier = static_cast<chip::app::Clusters::Identify::IdentifyEffectIdentifier>(0);
            value.effectVariant    = static_cast<chip::app::Clusters::Identify::IdentifyEffectVariant>(0);
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::TriggerEffect::Id, value,
                               chip::NullOptional

            );
        }
        case 2: {
            LogStep(2, "DUT executes a blink effect");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 3: {
            LogStep(3,
                    "TH sends TriggerEffect command to DUT with the effect identifier field set to 0x01 breathe and the effect "
                    "variant field set to 0x00 default");
            VerifyOrDo(!ShouldSkip("I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::TriggerEffect::Type value;
            value.effectIdentifier = static_cast<chip::app::Clusters::Identify::IdentifyEffectIdentifier>(1);
            value.effectVariant    = static_cast<chip::app::Clusters::Identify::IdentifyEffectVariant>(0);
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::TriggerEffect::Id, value,
                               chip::NullOptional

            );
        }
        case 4: {
            LogStep(4, "DUT executes a breathe effect");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5,
                    "TH sends TriggerEffect command to DUT with the effect identifier field set to 0x02 okay and the effect "
                    "variant field set to 0x00 default");
            VerifyOrDo(!ShouldSkip("I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::TriggerEffect::Type value;
            value.effectIdentifier = static_cast<chip::app::Clusters::Identify::IdentifyEffectIdentifier>(2);
            value.effectVariant    = static_cast<chip::app::Clusters::Identify::IdentifyEffectVariant>(0);
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::TriggerEffect::Id, value,
                               chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "DUT executes an okay effect");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7,
                    "TH sends TriggerEffect command to DUT with the effect identifier field set to 0x0b channel change and the "
                    "effect variant field set to 0x00 default");
            VerifyOrDo(!ShouldSkip("I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::TriggerEffect::Type value;
            value.effectIdentifier = static_cast<chip::app::Clusters::Identify::IdentifyEffectIdentifier>(11);
            value.effectVariant    = static_cast<chip::app::Clusters::Identify::IdentifyEffectVariant>(0);
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::TriggerEffect::Id, value,
                               chip::NullOptional

            );
        }
        case 8: {
            LogStep(8, "DUT executes a channel change effect");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 9: {
            LogStep(9,
                    "TH sends TriggerEffect command to DUT with the effect identifier field set to 0x01 breathe and the effect "
                    "variant field set to 0x00 default");
            VerifyOrDo(!ShouldSkip("I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::TriggerEffect::Type value;
            value.effectIdentifier = static_cast<chip::app::Clusters::Identify::IdentifyEffectIdentifier>(1);
            value.effectVariant    = static_cast<chip::app::Clusters::Identify::IdentifyEffectVariant>(0);
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::TriggerEffect::Id, value,
                               chip::NullOptional

            );
        }
        case 10: {
            LogStep(10, "DUT executes a breathe effect");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 11: {
            LogStep(11,
                    "TH sends TriggerEffect command to DUT with the effect identifier field set to 0xfe finish effect and the "
                    "effect variant field set to 0x00 default");
            VerifyOrDo(!ShouldSkip("I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::TriggerEffect::Type value;
            value.effectIdentifier = static_cast<chip::app::Clusters::Identify::IdentifyEffectIdentifier>(254);
            value.effectVariant    = static_cast<chip::app::Clusters::Identify::IdentifyEffectVariant>(0);
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::TriggerEffect::Id, value,
                               chip::NullOptional

            );
        }
        case 12: {
            LogStep(12, "DUT stops the breathe effect after the current effect sequence");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 13: {
            LogStep(13,
                    "TH sends TriggerEffect command to DUT with the effect identifier field set to 0x01 breathe and the effect "
                    "variant field set to 0x00 default");
            VerifyOrDo(!ShouldSkip("I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::TriggerEffect::Type value;
            value.effectIdentifier = static_cast<chip::app::Clusters::Identify::IdentifyEffectIdentifier>(1);
            value.effectVariant    = static_cast<chip::app::Clusters::Identify::IdentifyEffectVariant>(0);
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::TriggerEffect::Id, value,
                               chip::NullOptional

            );
        }
        case 14: {
            LogStep(14, "DUT executes a breathe effect");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 15: {
            LogStep(15,
                    "TH sends TriggerEffect command to DUT with the effect identifier field set to 0xff stop effect and the effect "
                    "variant field set to 0x00 default");
            VerifyOrDo(!ShouldSkip("I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::TriggerEffect::Type value;
            value.effectIdentifier = static_cast<chip::app::Clusters::Identify::IdentifyEffectIdentifier>(255);
            value.effectVariant    = static_cast<chip::app::Clusters::Identify::IdentifyEffectVariant>(0);
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::TriggerEffect::Id, value,
                               chip::NullOptional

            );
        }
        case 16: {
            LogStep(16, "DUT stops the breathe effect as soon as possible.");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 17: {
            LogStep(17,
                    "TH sends TriggerEffect command to DUT with the effect identifier field set to 0x00 blink and the effect "
                    "variant field set to 0x42 unknown");
            VerifyOrDo(!ShouldSkip("I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::TriggerEffect::Type value;
            value.effectIdentifier = static_cast<chip::app::Clusters::Identify::IdentifyEffectIdentifier>(0);
            value.effectVariant    = static_cast<chip::app::Clusters::Identify::IdentifyEffectVariant>(66);
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::TriggerEffect::Id, value,
                               chip::NullOptional

            );
        }
        case 18: {
            LogStep(18, "Check DUT executes a blink effect.");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 19: {
            LogStep(19,
                    "TH sends TriggerEffect command to DUT with the effect identifier field set to 0xff stop effect and the effect "
                    "variant field set to 0x00 default");
            VerifyOrDo(!ShouldSkip("I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::Identify::Commands::TriggerEffect::Type value;
            value.effectIdentifier = static_cast<chip::app::Clusters::Identify::IdentifyEffectIdentifier>(255);
            value.effectVariant    = static_cast<chip::app::Clusters::Identify::IdentifyEffectVariant>(0);
            return SendCommand(kIdentityAlpha, GetEndpoint(1), Identify::Id, Identify::Commands::TriggerEffect::Id, value,
                               chip::NullOptional

            );
        }
        case 20: {
            LogStep(20, "DUT stops any effect that may be still running as soon as possible");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT && I.S.C40.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_ILL_1_1Suite : public TestCommand
{
public:
    Test_TC_ILL_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_ILL_1_1", 8, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_ILL_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 3U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("acceptedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "read the global attribute: ClusterRevision");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::ClusterRevision::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Read the global attribute: FeatureMap");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::FeatureMap::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Read the global attribute: AttributeList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Read the optional attribute(Tolerance) in AttributeList");
            VerifyOrDo(!ShouldSkip("ILL.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Read the optional attribute(LightSensorType) in AttributeList");
            VerifyOrDo(!ShouldSkip("ILL.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::AttributeList::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Read the global attribute: AcceptedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 7: {
            LogStep(7, "Read the global attribute: GeneratedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::GeneratedCommandList::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_ILL_2_1Suite : public TestCommand
{
public:
    Test_TC_ILL_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_ILL_2_1", 6, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_ILL_2_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 1U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65533U));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 2U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65534U));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65534U));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 2048U));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "enum8", "enum8"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads MinMeasuredValue attribute from DUT");
            VerifyOrDo(!ShouldSkip("ILL.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::MinMeasuredValue::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads MaxMeasuredValue attribute from DUT");
            VerifyOrDo(!ShouldSkip("ILL.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::MaxMeasuredValue::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "TH reads MeasuredValue attribute from DUT");
            VerifyOrDo(!ShouldSkip("ILL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::MeasuredValue::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH reads Tolerance attribute from DUT");
            VerifyOrDo(!ShouldSkip("ILL.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::Tolerance::Id, true, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads LightSensorType attribute from DUT");
            VerifyOrDo(!ShouldSkip("ILL.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::LightSensorType::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_ILL_2_2Suite : public TestCommand
{
public:
    Test_TC_ILL_2_2Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_ILL_2_2", 9, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_ILL_2_2Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::app::DataModel::Nullable<uint16_t> MinMeasuredValue;
    chip::app::DataModel::Nullable<uint16_t> MaxMeasuredValue;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                MinMeasuredValue = value;
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                MaxMeasuredValue = value;
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65534U));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "TH reads MinMeasuredValue attribute from DUT");
            VerifyOrDo(!ShouldSkip("ILL.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::MinMeasuredValue::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "TH reads MaxMeasuredValue attribute from DUT");
            VerifyOrDo(!ShouldSkip("ILL.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::MaxMeasuredValue::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Cover the sensor or darken the room");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for Successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 4: {
            LogStep(4, "Wait 1s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 1000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 5: {
            LogStep(5, "After a few seconds, TH reads MeasuredValue attribute from DUT.");
            VerifyOrDo(!ShouldSkip("ILL.S.A0000 && PICS_SKIP_SAMPLE_APP"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::MeasuredValue::Id, true, chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Expose the sensor again to light");
            VerifyOrDo(!ShouldSkip("PICS_USER_PROMPT"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LogCommands::Commands::UserPrompt::Type value;
            value.message = chip::Span<const char>("Please enter 'y' for Successgarbage: not in length on purpose", 28);
            value.expectedValue.Emplace();
            value.expectedValue.Value() = chip::Span<const char>("ygarbage: not in length on purpose", 1);
            return UserPrompt(kIdentityAlpha, value);
        }
        case 7: {
            LogStep(7, "Wait 1s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 1000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 8: {
            LogStep(8, "After a few seconds, TH reads MeasuredValue attribute from DUT.");
            VerifyOrDo(!ShouldSkip("ILL.S.A0000 && PICS_SKIP_SAMPLE_APP"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), IlluminanceMeasurement::Id,
                                 IlluminanceMeasurement::Attributes::MeasuredValue::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_LVL_1_1Suite : public TestCommand
{
public:
    Test_TC_LVL_1_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_LVL_1_1", 18, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_LVL_1_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("clusterRevision", value, 5U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("featureMap", value, 0UL));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
                VerifyOrReturn(CheckConstraintHasMasksSet("value", value, 1UL));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
                VerifyOrReturn(CheckConstraintHasMasksSet("value", value, 2UL));
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint32_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap32", "bitmap32"));
                VerifyOrReturn(CheckConstraintHasMasksSet("value", value, 4UL));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 15UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 17UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65528UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65529UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65531UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65532UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 65533UL));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 16384UL));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 5UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 6UL));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 16UL));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 18UL));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 19UL));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::AttributeId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 20UL));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 0UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 1UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 2UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 3UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 4UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 5UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 6UL));
                VerifyOrReturn(CheckConstraintContains("value", value, 7UL));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
                VerifyOrReturn(CheckConstraintContains("value", value, 8UL));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::DecodableList<chip::CommandId> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                {
                    auto iter_0 = value.begin();
                    VerifyOrReturn(CheckNoMoreListItems<decltype(value)>("generatedCommandList", iter_0, 0));
                }
                VerifyOrReturn(CheckConstraintType("value", "list", "list"));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Read the global attribute: ClusterRevision");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::ClusterRevision::Id,
                                 true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Read the global attribute: FeatureMap");
            VerifyOrDo(!ShouldSkip(" !LVL.S.F00 && !LVL.S.F01 && !LVL.S.F02 "), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Given LVL.S.F00(OO) ensure featuremap has the correct bit set");
            VerifyOrDo(!ShouldSkip("LVL.S.F00"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Given LVL.S.F01(LT) ensure featuremap has the correct bit set");
            VerifyOrDo(!ShouldSkip("LVL.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Given LVL.S.F02(FQ) ensure featuremap has the correct bit set");
            VerifyOrDo(!ShouldSkip("LVL.S.F02"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::FeatureMap::Id, true,
                                 chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Read the global attribute: AttributeList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 7: {
            LogStep(7, "Read the optional attribute(StartUpCurrentLevel and RemainingTime) in AttributeList");
            VerifyOrDo(!ShouldSkip("LVL.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Read the optional attribute(CurrentFrequency, MinFrequency and MinFrequency) in AttributeList");
            VerifyOrDo(!ShouldSkip("LVL.S.F02"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 9: {
            LogStep(9, "Read the optional attribute(MinLevel) in AttributeList");
            VerifyOrDo(!ShouldSkip("LVL.S.A0002"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Read the optional attribute(MaxLevel) in AttributeList");
            VerifyOrDo(!ShouldSkip("LVL.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Read the optional attribute(OnOffTransitionTime) in AttributeList");
            VerifyOrDo(!ShouldSkip("LVL.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 12: {
            LogStep(12, "Read the optional attribute(OnTransitionTime) in AttributeList");
            VerifyOrDo(!ShouldSkip("LVL.S.A0012"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "Read the optional attribute(OffTransitionTime) in AttributeList");
            VerifyOrDo(!ShouldSkip("LVL.S.A0013"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "Read the optional attribute(DefaultMoveRate) in AttributeList");
            VerifyOrDo(!ShouldSkip("LVL.S.A0014"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::AttributeList::Id,
                                 true, chip::NullOptional);
        }
        case 15: {
            LogStep(15, "Read the global attribute: AcceptedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                 LevelControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 16: {
            LogStep(16, "Read the Feature-dependent(LVL.S.F02) command in AcceptedCommandList");
            VerifyOrDo(!ShouldSkip("LVL.S.F02"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                 LevelControl::Attributes::AcceptedCommandList::Id, true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "Read the global attribute: GeneratedCommandList");
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                 LevelControl::Attributes::GeneratedCommandList::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_LVL_2_1Suite : public TestCommand
{
public:
    Test_TC_LVL_2_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_LVL_2_1", 21, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_LVL_2_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::app::DataModel::Nullable<uint8_t> CurrentLevelValue;
    uint8_t MinLevelValue;
    uint8_t MinLevelFeatureMapNotSupportedValue;
    uint8_t MaxLevelValue;
    uint8_t MaxLevelFeatureMapNotSupportedValue;
    uint16_t MinFrequencyValue;
    uint16_t MaxFrequencyValue;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
                CurrentLevelValue = value;
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("minLevel", value, 1U));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                MinLevelValue = value;
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
                MinLevelFeatureMapNotSupportedValue = value;
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("maxLevel", value, 254U));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, MinLevelValue));
                MaxLevelValue = value;
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, MinLevelFeatureMapNotSupportedValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
                MaxLevelFeatureMapNotSupportedValue = value;
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, MinLevelValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, MaxLevelValue));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, MinLevelFeatureMapNotSupportedValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, MaxLevelFeatureMapNotSupportedValue));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
                MinFrequencyValue = value;
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
                MaxFrequencyValue = value;
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, MinFrequencyValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, MaxFrequencyValue));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, MinLevelValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, MaxLevelValue));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, MinLevelFeatureMapNotSupportedValue));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, MaxLevelFeatureMapNotSupportedValue));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 255U));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "bitmap8", "bitmap8"));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 255U));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Reads the CurrentLevel attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 2: {
            LogStep(2, "Reads the RemainingTime attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0001"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::RemainingTime::Id,
                                 true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Reads the MinLevel attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0002 && LVL.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::MinLevel::Id, true,
                                 chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Reads the MinLevel attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0002 && !LVL.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::MinLevel::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5, "Reads the MaxLevel attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0003 && LVL.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::MaxLevel::Id, true,
                                 chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Reads the MaxLevel attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0003 && !LVL.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::MaxLevel::Id, true,
                                 chip::NullOptional);
        }
        case 7: {
            LogStep(7, "Step 4b & 4C Reads the CurrentLevel attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.F01 && LVL.S.A0002 && LVL.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Step 4b & 4C Reads the CurrentLevel attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0002 && LVL.S.A0003 && !LVL.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 9: {
            LogStep(9, "Reads the CurrentFrequency attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0004"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentFrequency::Id,
                                 true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Reads the MinFrequency attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0005"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::MinFrequency::Id, true,
                                 chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Reads the MaxFrequency attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::MaxFrequency::Id, true,
                                 chip::NullOptional);
        }
        case 12: {
            LogStep(12, "Step 7b & 7C Reads the CurrentFrequency attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0004 && LVL.S.A0005 && LVL.S.A0006"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentFrequency::Id,
                                 true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "Reads the OnOffTransitionTime attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                 LevelControl::Attributes::OnOffTransitionTime::Id, true, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "Reads the OnLevel attribute ");
            VerifyOrDo(!ShouldSkip("LVL.S.F01 && LVL.S.A0011"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OnLevel::Id, true,
                                 chip::NullOptional);
        }
        case 15: {
            LogStep(15, "Reads the OnLevel attribute ");
            VerifyOrDo(!ShouldSkip("LVL.S.A0011 && !LVL.S.F01"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OnLevel::Id, true,
                                 chip::NullOptional);
        }
        case 16: {
            LogStep(16, "Reads the OnTransitionTime attribute ");
            VerifyOrDo(!ShouldSkip("LVL.S.A0012"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OnTransitionTime::Id,
                                 true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "Reads the OffTransitionTime attribute ");
            VerifyOrDo(!ShouldSkip("LVL.S.A0013"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OffTransitionTime::Id,
                                 true, chip::NullOptional);
        }
        case 18: {
            LogStep(18, "Reads the DefaultMoveRate attribute ");
            VerifyOrDo(!ShouldSkip("LVL.S.A0014"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::DefaultMoveRate::Id,
                                 true, chip::NullOptional);
        }
        case 19: {
            LogStep(19, "Reads the Options attribute ");
            VerifyOrDo(!ShouldSkip("LVL.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::Options::Id, true,
                                 chip::NullOptional);
        }
        case 20: {
            LogStep(20, "Reads the StartUpCurrentLevel attribute ");
            VerifyOrDo(!ShouldSkip("LVL.S.A4000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                 LevelControl::Attributes::StartUpCurrentLevel::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_LVL_2_2Suite : public TestCommand
{
public:
    Test_TC_LVL_2_2Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_LVL_2_2", 20, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("OnOffTransitionTimeConfigValue", 0, UINT16_MAX, &mOnOffTransitionTimeConfigValue);
        AddArgument("OnLevelConfigValue", 0, UINT8_MAX, &mOnLevelConfigValue);
        AddArgument("OnTransitionTimeConfigValue", 0, UINT16_MAX, &mOnTransitionTimeConfigValue);
        AddArgument("OffTransitionTimeConfigValue", 0, UINT16_MAX, &mOffTransitionTimeConfigValue);
        AddArgument("DefaultMoveRateConfigValue", 0, UINT8_MAX, &mDefaultMoveRateConfigValue);
        AddArgument("StartUpCurrentLevelConfigValue", 0, UINT8_MAX, &mStartUpCurrentLevelConfigValue);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_LVL_2_2Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mOnOffTransitionTimeConfigValue;
    chip::Optional<uint8_t> mOnLevelConfigValue;
    chip::Optional<uint16_t> mOnTransitionTimeConfigValue;
    chip::Optional<uint16_t> mOffTransitionTimeConfigValue;
    chip::Optional<uint8_t> mDefaultMoveRateConfigValue;
    chip::Optional<uint8_t> mStartUpCurrentLevelConfigValue;
    chip::Optional<uint16_t> mTimeout;

    uint16_t OnOffTransitionTimeValue;
    chip::app::DataModel::Nullable<uint8_t> OnLevelValue;
    chip::app::DataModel::Nullable<uint16_t> OnTransitionTimeValue;
    chip::app::DataModel::Nullable<uint16_t> OffTransitionTimeValue;
    chip::app::DataModel::Nullable<uint8_t> DefaultMoveRatevalue;
    chip::app::DataModel::Nullable<uint8_t> StartUpCurrentLevelValue;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
                OnOffTransitionTimeValue = value;
            }
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint16_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(
                    CheckValue("onOffTransitionTime", value,
                               mOnOffTransitionTimeConfigValue.HasValue() ? mOnOffTransitionTimeConfigValue.Value() : 10U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintNotValue("value", value, OnOffTransitionTimeValue));
            }
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
                OnLevelValue = value;
            }
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("onLevel", value));
                VerifyOrReturn(CheckValue("onLevel.Value()", value.Value(),
                                          mOnLevelConfigValue.HasValue() ? mOnLevelConfigValue.Value() : 5U));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintNotValue("value", value, OnLevelValue));
            }
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
                OnTransitionTimeValue = value;
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("onTransitionTime", value));
                VerifyOrReturn(CheckValue("onTransitionTime.Value()", value.Value(),
                                          mOnTransitionTimeConfigValue.HasValue() ? mOnTransitionTimeConfigValue.Value() : 5U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintNotValue("value", value, OnTransitionTimeValue));
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 65535U));
                OffTransitionTimeValue = value;
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint16_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("offTransitionTime", value));
                VerifyOrReturn(CheckValue("offTransitionTime.Value()", value.Value(),
                                          mOffTransitionTimeConfigValue.HasValue() ? mOffTransitionTimeConfigValue.Value() : 10U));
                VerifyOrReturn(CheckConstraintType("value", "int16u", "int16u"));
                VerifyOrReturn(CheckConstraintNotValue("value", value, OffTransitionTimeValue));
            }
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 255U));
                DefaultMoveRatevalue = value;
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("defaultMoveRate", value));
                VerifyOrReturn(CheckValue("defaultMoveRate.Value()", value.Value(),
                                          mDefaultMoveRateConfigValue.HasValue() ? mDefaultMoveRateConfigValue.Value() : 111U));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintNotValue("value", value, DefaultMoveRatevalue));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 255U));
                StartUpCurrentLevelValue = value;
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("startUpCurrentLevel", value));
                VerifyOrReturn(
                    CheckValue("startUpCurrentLevel.Value()", value.Value(),
                               mStartUpCurrentLevelConfigValue.HasValue() ? mStartUpCurrentLevelConfigValue.Value() : 5U));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintNotValue("value", value, StartUpCurrentLevelValue));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Reads the OnOffTransitionTime attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                 LevelControl::Attributes::OnOffTransitionTime::Id, true, chip::NullOptional);
        }
        case 2: {
            LogStep(2, "writes the OnOffTransitionTime attribute on the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint16_t value;
            value = mOnOffTransitionTimeConfigValue.HasValue() ? mOnOffTransitionTimeConfigValue.Value() : 10U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                  LevelControl::Attributes::OnOffTransitionTime::Id, value, chip::NullOptional, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Reads the OnOffTransitionTime attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                 LevelControl::Attributes::OnOffTransitionTime::Id, true, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "Reads the OnLevel attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0011"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OnLevel::Id, true,
                                 chip::NullOptional);
        }
        case 5: {
            LogStep(5, "writes the OnLevel attribute on the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0011"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::DataModel::Nullable<uint8_t> value;
            value.SetNonNull();
            value.Value() = mOnLevelConfigValue.HasValue() ? mOnLevelConfigValue.Value() : 5U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OnLevel::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 6: {
            LogStep(6, "Reads the OnLevel attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0011"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OnLevel::Id, true,
                                 chip::NullOptional);
        }
        case 7: {
            LogStep(7, "Reads the OnTransitionTime attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0012"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OnTransitionTime::Id,
                                 true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "Writes the OnTransitionTime attribute on the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0012"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::DataModel::Nullable<uint16_t> value;
            value.SetNonNull();
            value.Value() = mOnTransitionTimeConfigValue.HasValue() ? mOnTransitionTimeConfigValue.Value() : 5U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OnTransitionTime::Id,
                                  value, chip::NullOptional, chip::NullOptional);
        }
        case 9: {
            LogStep(9, "Reads the OnTransitionTime attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0012"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OnTransitionTime::Id,
                                 true, chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Reads the OffTransitionTime attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0013"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OffTransitionTime::Id,
                                 true, chip::NullOptional);
        }
        case 11: {
            LogStep(11, "Writes the OffTransitionTime attribute on the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0013"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::DataModel::Nullable<uint16_t> value;
            value.SetNonNull();
            value.Value() = mOffTransitionTimeConfigValue.HasValue() ? mOffTransitionTimeConfigValue.Value() : 10U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OffTransitionTime::Id,
                                  value, chip::NullOptional, chip::NullOptional);
        }
        case 12: {
            LogStep(12, "Reads the OffTransitionTime attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0013"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::OffTransitionTime::Id,
                                 true, chip::NullOptional);
        }
        case 13: {
            LogStep(13, "Reads the DefaultMoveRate attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0014"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::DefaultMoveRate::Id,
                                 true, chip::NullOptional);
        }
        case 14: {
            LogStep(14, "Writes the DefaultMoveRate attribute on the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0014"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::DataModel::Nullable<uint8_t> value;
            value.SetNonNull();
            value.Value() = mDefaultMoveRateConfigValue.HasValue() ? mDefaultMoveRateConfigValue.Value() : 111U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::DefaultMoveRate::Id,
                                  value, chip::NullOptional, chip::NullOptional);
        }
        case 15: {
            LogStep(15, "Reads the DefaultMoveRate attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0014"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::DefaultMoveRate::Id,
                                 true, chip::NullOptional);
        }
        case 16: {
            LogStep(16, "Reads the StartUpCurrentLevel attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A4000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                 LevelControl::Attributes::StartUpCurrentLevel::Id, true, chip::NullOptional);
        }
        case 17: {
            LogStep(17, "writes the StartUpCurrentLevel attribute on the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A4000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::DataModel::Nullable<uint8_t> value;
            value.SetNonNull();
            value.Value() = mStartUpCurrentLevelConfigValue.HasValue() ? mStartUpCurrentLevelConfigValue.Value() : 5U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                  LevelControl::Attributes::StartUpCurrentLevel::Id, value, chip::NullOptional, chip::NullOptional);
        }
        case 18: {
            LogStep(18, "reads the StartUpCurrentLevel attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A4000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                 LevelControl::Attributes::StartUpCurrentLevel::Id, true, chip::NullOptional);
        }
        case 19: {
            LogStep(19, "writes back default value of OnOffTransitionTime attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint16_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                  LevelControl::Attributes::OnOffTransitionTime::Id, value, chip::NullOptional, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_LVL_3_1Suite : public TestCommand
{
public:
    Test_TC_LVL_3_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_LVL_3_1", 46, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_LVL_3_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 1));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 1));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 50U));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 50U));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 85U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 115U));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 127U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 173U));
            }
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 170U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 200U));
            }
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 200U));
            }
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 200U));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("options", value, 0U));
            }
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 26:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 100U));
            }
            break;
        case 27:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 28:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 29:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 100U));
            }
            break;
        case 30:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 31:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 100U));
            }
            break;
        case 32:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 33:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 160U));
            }
            break;
        case 34:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 35:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("options", value, 1U));
            }
            break;
        case 36:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 37:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 38:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 100U));
            }
            break;
        case 39:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 40:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 41:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 120U));
            }
            break;
        case 42:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 43:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 120U));
            }
            break;
        case 44:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 45:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 160U));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Precondition Send On Command");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 2: {
            LogStep(2, "Check on/off attribute value is true after on command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Precondition: write default value of OnOffTransitionTime attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint16_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                  LevelControl::Attributes::OnOffTransitionTime::Id, value, chip::NullOptional, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH sends Off command to DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C04.Rsp && OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 6: {
            LogStep(6, "TH sends a MoveToLevelWithOnOff command to DUT, with Level =50 and TransitionTime =0 (immediate)");
            VerifyOrDo(!ShouldSkip("LVL.S.C04.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevelWithOnOff::Type value;
            value.level = 50U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 0U;
            value.optionsMask            = 0U;
            value.optionsOverride        = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevelWithOnOff::Id,
                               value, chip::NullOptional

            );
        }
        case 7: {
            LogStep(7, "TH reads OnOff attribute (On/Off cluster) from DUT");
            VerifyOrDo(!ShouldSkip("OO.S.A0000 && LVL.S.C04.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        case 8: {
            LogStep(8, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C04.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 9: {
            LogStep(9, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C04.Rsp && OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 10: {
            LogStep(10, "TH sends a MoveToLevel command to DUT, with Level =50 and TransitionTime =0 (immediate)");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevel::Type value;
            value.level = 50U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 0U;
            value.optionsMask            = 0U;
            value.optionsOverride        = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevel::Id, value,
                               chip::NullOptional

            );
        }
        case 11: {
            LogStep(11, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 12: {
            LogStep(12,
                    "TH sends a MoveToLevel command to the DUT with Level = 200 and TransitionTime = 300 (30 s). This means the "
                    "level should increase by 150 units in 30s, so 5 units/s");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevel::Type value;
            value.level = 200U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 300U;
            value.optionsMask            = 0U;
            value.optionsOverride        = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevel::Id, value,
                               chip::NullOptional

            );
        }
        case 13: {
            LogStep(13, "Wait 10000ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 14: {
            LogStep(14, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000 && LVL.S.M.VarRate"),
                       return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 15: {
            LogStep(15, "Wait 10000ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 16: {
            LogStep(16, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000 && LVL.S.M.VarRate"),
                       return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 17: {
            LogStep(17, "Wait 10000ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 18: {
            LogStep(18, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000 && LVL.S.M.VarRate"),
                       return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 19: {
            LogStep(19, "Wait 5000ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 20: {
            LogStep(20, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000 && LVL.S.M.VarRate"),
                       return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 21: {
            LogStep(21, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000 && !LVL.S.M.VarRate"),
                       return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 22: {
            LogStep(22, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 23: {
            LogStep(23, "TH reads Options attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::Options::Id, true,
                                 chip::NullOptional);
        }
        case 24: {
            LogStep(24, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 25: {
            LogStep(25, "TH sends a MoveToLevel command to the DUT with");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevel::Type value;
            value.level = 100U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 0U;
            value.optionsMask            = 0U;
            value.optionsOverride        = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevel::Id, value,
                               chip::NullOptional

            );
        }
        case 26: {
            LogStep(26, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 27: {
            LogStep(27, "TH sends Off command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 28: {
            LogStep(28, "TH sends a MoveToLevel command to the DUT with");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevel::Type value;
            value.level = 120U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 0U;
            value.optionsMask            = 0U;
            value.optionsOverride        = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevel::Id, value,
                               chip::NullOptional

            );
        }
        case 29: {
            LogStep(29, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 30: {
            LogStep(30, "TH sends a MoveToLevel command to the DUT with");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevel::Type value;
            value.level = 140U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 0U;
            value.optionsMask            = 1U;
            value.optionsOverride        = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevel::Id, value,
                               chip::NullOptional

            );
        }
        case 31: {
            LogStep(31, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 32: {
            LogStep(32, "TH sends a MoveToLevel command to the DUT with");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevel::Type value;
            value.level = 160U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 0U;
            value.optionsMask            = 1U;
            value.optionsOverride        = 1U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevel::Id, value,
                               chip::NullOptional

            );
        }
        case 33: {
            LogStep(33, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 34: {
            LogStep(34, "TH writes 1 to the Options attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 1U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 35: {
            LogStep(35, "TH reads Options attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::Options::Id, true,
                                 chip::NullOptional);
        }
        case 36: {
            LogStep(36, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 37: {
            LogStep(37, "TH sends a MoveToLevel command to the DUT with");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevel::Type value;
            value.level = 100U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 0U;
            value.optionsMask            = 0U;
            value.optionsOverride        = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevel::Id, value,
                               chip::NullOptional

            );
        }
        case 38: {
            LogStep(38, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 39: {
            LogStep(39, "TH sends Off command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 40: {
            LogStep(40, "TH sends a MoveToLevel command to the DUT with");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevel::Type value;
            value.level = 120U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 0U;
            value.optionsMask            = 0U;
            value.optionsOverride        = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevel::Id, value,
                               chip::NullOptional

            );
        }
        case 41: {
            LogStep(41, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 42: {
            LogStep(42, "TH sends a MoveToLevel command to the DUT with");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevel::Type value;
            value.level = 140U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 0U;
            value.optionsMask            = 1U;
            value.optionsOverride        = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevel::Id, value,
                               chip::NullOptional

            );
        }
        case 43: {
            LogStep(43, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 44: {
            LogStep(44, "TH sends a MoveToLevel command to the DUT with");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevel::Type value;
            value.level = 160U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 0U;
            value.optionsMask            = 1U;
            value.optionsOverride        = 1U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevel::Id, value,
                               chip::NullOptional

            );
        }
        case 45: {
            LogStep(45, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_LVL_4_1Suite : public TestCommand
{
public:
    Test_TC_LVL_4_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_LVL_4_1", 26, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_LVL_4_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::app::DataModel::Nullable<uint8_t> CurrentLevelValue;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 1));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                uint8_t value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 1));
            }
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintType("value", "int8u", "int8u"));
                CurrentLevelValue = value;
            }
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 0U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 254U));
            }
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 50U));
            }
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 85U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 115U));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 127U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 173U));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 170U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 230U));
            }
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 23:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 254U));
            }
            break;
        case 24:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 25:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Precondition Send On Command");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 2: {
            LogStep(2, "Check on/off attribute value is true after on command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Precondition: write default value of OnOffTransitionTime attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint16_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                  LevelControl::Attributes::OnOffTransitionTime::Id, value, chip::NullOptional, chip::NullOptional);
        }
        case 4: {
            LogStep(4, "TH writes 0 to the Options attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A000f"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint8_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::Options::Id, value,
                                  chip::NullOptional, chip::NullOptional);
        }
        case 5: {
            LogStep(5, "TH reads the MaxLevel attribute from the DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.A0003"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::MaxLevel::Id, true,
                                 chip::NullOptional);
        }
        case 6: {
            LogStep(6, "TH sends Off command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp && LVL.S.C05.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 7: {
            LogStep(7, "TH sends a MoveWithOnOff command to DUT, with MoveMode =0x00 (up) and Rate =10 (units/s)");
            VerifyOrDo(!ShouldSkip("LVL.S.C05.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveWithOnOff::Type value;
            value.moveMode = static_cast<chip::app::Clusters::LevelControl::MoveMode>(0);
            value.rate.SetNonNull();
            value.rate.Value()    = 10U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveWithOnOff::Id, value,
                               chip::NullOptional

            );
        }
        case 8: {
            LogStep(8, "TH reads OnOff attribute (On/Off cluster) from DUT");
            VerifyOrDo(!ShouldSkip("OO.S.A0000 && LVL.S.C05.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        case 9: {
            LogStep(9, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C05.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 10: {
            LogStep(10, "Wait 5000ms");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 5000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 11: {
            LogStep(11, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C05.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 12: {
            LogStep(12, "TH sends On command to DUT");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 13: {
            LogStep(13, "TH sends a MoveToLevel command to DUT, with Level =50 and TransitionTime =0 (immediate)");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::MoveToLevel::Type value;
            value.level = 50U;
            value.transitionTime.SetNonNull();
            value.transitionTime.Value() = 0U;
            value.optionsMask            = 0U;
            value.optionsOverride        = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::MoveToLevel::Id, value,
                               chip::NullOptional

            );
        }
        case 14: {
            LogStep(14, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C00.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 15: {
            LogStep(15, "TH sends a Move command to the DUT with MoveMode =0x00 (up) and Rate =5 (units/s)");
            VerifyOrDo(!ShouldSkip("LVL.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::LevelControl::Commands::Move::Type value;
            value.moveMode = static_cast<chip::app::Clusters::LevelControl::MoveMode>(0);
            value.rate.SetNonNull();
            value.rate.Value()    = 5U;
            value.optionsMask     = 0U;
            value.optionsOverride = 0U;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Commands::Move::Id, value,
                               chip::NullOptional

            );
        }
        case 16: {
            LogStep(16, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 17: {
            LogStep(17, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C01.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 18: {
            LogStep(18, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 19: {
            LogStep(19, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C01.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 20: {
            LogStep(20, "Wait 10s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 10000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 21: {
            LogStep(21, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C01.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 22: {
            LogStep(22, "Wait 19s");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForMs::Type value;
            value.ms = 19000UL;
            return WaitForMs(kIdentityAlpha, value);
        }
        case 23: {
            LogStep(23, "TH reads CurrentLevel attribute from DUT");
            VerifyOrDo(!ShouldSkip("LVL.S.C01.Rsp && LVL.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id, LevelControl::Attributes::CurrentLevel::Id, true,
                                 chip::NullOptional);
        }
        case 24: {
            LogStep(24, "Precondition send Off Command");
            VerifyOrDo(!ShouldSkip("OO.S.C00.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::Off::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::Off::Id, value, chip::NullOptional

            );
        }
        case 25: {
            LogStep(25, "Check on/off attribute value is false after off command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        }
        return CHIP_NO_ERROR;
    }
};

class Test_TC_LVL_5_1Suite : public TestCommand
{
public:
    Test_TC_LVL_5_1Suite(CredentialIssuerCommands * credsIssuerConfig) : TestCommand("Test_TC_LVL_5_1", 23, credsIssuerConfig)
    {
        AddArgument("nodeId", 0, UINT64_MAX, &mNodeId);
        AddArgument("cluster", &mCluster);
        AddArgument("endpoint", 0, UINT16_MAX, &mEndpoint);
        AddArgument("timeout", 0, UINT16_MAX, &mTimeout);
    }

    ~Test_TC_LVL_5_1Suite() {}

    chip::System::Clock::Timeout GetWaitDuration() const override
    {
        return chip::System::Clock::Seconds16(mTimeout.ValueOr(kTimeoutInSeconds));
    }

private:
    chip::Optional<chip::NodeId> mNodeId;
    chip::Optional<chip::CharSpan> mCluster;
    chip::Optional<chip::EndpointId> mEndpoint;
    chip::Optional<uint16_t> mTimeout;

    chip::EndpointId GetEndpoint(chip::EndpointId endpoint) { return mEndpoint.HasValue() ? mEndpoint.Value() : endpoint; }

    //
    // Tests methods
    //

    void OnResponse(const chip::app::StatusIB & status, chip::TLV::TLVReader * data) override
    {
        bool shouldContinue = false;

        switch (mTestIndex - 1)
        {
        case 0:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 1:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 2:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 1));
            }
            break;
        case 3:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 4:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 5:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 6:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 7:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 1));
            }
            break;
        case 8:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 9:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 10:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 50U));
            }
            break;
        case 11:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 12:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 13:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 85U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 115U));
            }
            break;
        case 14:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 15:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 127U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 173U));
            }
            break;
        case 16:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 17:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckConstraintMinValue("value", value, 170U));
                VerifyOrReturn(CheckConstraintMaxValue("value", value, 200U));
            }
            break;
        case 18:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            shouldContinue = true;
            break;
        case 19:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 200U));
            }
            break;
        case 20:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                chip::app::DataModel::Nullable<uint8_t> value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValueNonNull("currentLevel", value));
                VerifyOrReturn(CheckValue("currentLevel.Value()", value.Value(), 200U));
            }
            break;
        case 21:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            break;
        case 22:
            VerifyOrReturn(CheckValue("status", chip::to_underlying(status.mStatus), 0));
            {
                bool value;
                VerifyOrReturn(CheckDecodeValue(chip::app::DataModel::Decode(*data, value)));
                VerifyOrReturn(CheckValue("onOff", value, 0));
            }
            break;
        default:
            LogErrorOnFailure(ContinueOnChipMainThread(CHIP_ERROR_INVALID_ARGUMENT));
        }

        if (shouldContinue)
        {
            ContinueOnChipMainThread(CHIP_NO_ERROR);
        }
    }

    CHIP_ERROR DoTestStep(uint16_t testIndex) override
    {
        using namespace chip::app::Clusters;
        switch (testIndex)
        {
        case 0: {
            LogStep(0, "Wait for the commissioned device to be retrieved");
            ListFreer listFreer;
            chip::app::Clusters::DelayCommands::Commands::WaitForCommissionee::Type value;
            value.nodeId = mNodeId.HasValue() ? mNodeId.Value() : 305414945ULL;
            return WaitForCommissionee(kIdentityAlpha, value);
        }
        case 1: {
            LogStep(1, "Precondition Send On Command");
            VerifyOrDo(!ShouldSkip("OO.S.C01.Rsp"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            chip::app::Clusters::OnOff::Commands::On::Type value;
            return SendCommand(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Commands::On::Id, value, chip::NullOptional

            );
        }
        case 2: {
            LogStep(2, "Check on/off attribute value is true after on command");
            VerifyOrDo(!ShouldSkip("OO.S.A0000"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            return ReadAttribute(kIdentityAlpha, GetEndpoint(1), OnOff::Id, OnOff::Attributes::OnOff::Id, true, chip::NullOptional);
        }
        case 3: {
            LogStep(3, "Precondition: write default value of OnOffTransitionTime attribute");
            VerifyOrDo(!ShouldSkip("LVL.S.A0010"), return ContinueOnChipMainThread(CHIP_NO_ERROR));
            ListFreer listFreer;
            uint16_t value;
            value = 0U;
            return WriteAttribute(kIdentityAlpha, GetEndpoint(1), LevelControl::Id,
                                  LevelControl::Attributes::OnOffTransitionTime::Id, value, chip::NullOption